#!/bin/sh
#
#       fhist - file history and comparison tools
#       Copyright (C) 1998, 1999, 2001, 2008, 2009 Peter Miller
#
#       This program is free software; you can redistribute it and/or modify
#       it under the terms of the GNU General Public License as published by
#       the Free Software Foundation; either version 3 of the License, or
#       (at your option) any later version.
#
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#
#       You should have received a copy of the GNU General Public License
#       along with this program. If not, see
#       <http://www.gnu.org/licenses/>.
#
version=${version-0.0.0}
echo 'Summary: file history and comparison tools'
echo 'Name: fhist'
echo "Version: ${version}"
echo 'Release: 1'
echo 'Copyright: GPL'
echo 'Group: Development/Tools'
echo "Source: http://fhist.sourceforge.net/fhist-${version}.tar.gz"
echo 'URL: http://fhist.sourceforge.net/'
echo 'BuildRoot: /tmp/fhist-build-root'

prefix=/usr
#
# RPM only has install-time relocatable packages.  It has no support for
# build-time relocatable packages.  Therefore, we must NOT specify a Spec
# prefix, or the installed locations will not match the built locations.
#
#echo "Prefix: $prefix"

echo ''

cat << 'fubar'
%description
The FHist package contains 3 utilities, a file history tool ``fhist'',
a file comparison tool ``fcomp'', and a file merging tool ``fmerge''.
All three are bundled together, because they all use the same
minimal-difference algorithm.

The history tool presented here, fhist, is a minimal history tool.
It provides no locking or branching.  This can be useful in contexts
where the configuration management or change control be being provided
by some other tool.

%prep
fubar

#
# set the prefix here
#
echo '%setup'
echo ''
echo '%build'
echo "./configure --prefix=$prefix"
echo 'make'
echo ''
echo '%install'
echo 'make RPM_BUILD_ROOT=$RPM_BUILD_ROOT install'

#
# remember things for the %files section
#
binfiles=
files=

remember_prog()
{
        if eval "test \"\${prog_${1}-no}\" != yes"
        then
                eval "prog_${1}=yes"
                binfiles="$binfiles $prefix/bin/${1}"
        fi
}

for file in $*
do
        case $file in

        txt2c/*)
                ;;

        */main.c)
                dir=`echo $file | sed 's|\([^/]*\)/.*|\1|'`
                remember_prog $dir
                ;;

        lib/*/*/*.so)
                ;;

        lib/*/man?/*.[1-9])
                stem=`echo $file | sed 's|^lib/||'`
                files="$files $prefix/share/fhist/${stem}*"

                case $file in
                lib/en/*)
                        stem2=`echo $file | sed 's|^lib/en/||'`
                        files="$files $prefix/man/${stem2}*"
                        ;;
                esac
                ;;

        lib/*/LC_MESSAGES/common.po)
                ;;

        lib/*.po)
                stem=`echo $file | sed 's|^lib/\(.*\)\.po$|\1|'`
                dst="$prefix/lib/fhist/$stem.mo"
                files="$files $dst"
                ;;

        lib/*/*/main.*)
                stem=`echo $file | sed 's|^lib/\(.*\)/main.*$|\1|'`
                files="$files $prefix/share/fhist/$stem.ps"
                files="$files $prefix/share/fhist/$stem.dvi"
                files="$files $prefix/share/fhist/$stem.txt"
                ;;

        *)
                ;;
        esac
done

echo ''
echo '%files'
for file in $binfiles
do
        echo "%attr(0755,root,bin) $file"
done
for file in $files
do
        echo "%attr(0644,root,bin) $file"
done

echo ''
echo '%clean'
echo 'rm -rf $RPM_BUILD_ROOT'
