dnl -*- Autoconf -*-
dnl Copyright (C) 1993-2017 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License as published by the Free Software Foundation;
dnl either version 2 of the License, or (at your option) any later version.
dnl As a special exception to the GNU General Public License, this file
dnl may be distributed as part of a program that contains a configuration
dnl script generated by Autoconf, under the same distribution terms as
dnl the rest of that program.

dnl From Bruno Haible, Marcus Daniels, Sam Steingold.

AC_PREREQ([2.13])

AC_DEFUN([CL_PROG_LN],
[
  AC_CACHE_CHECK([how to make hard links], [cl_cv_prog_LN],
    [rm -f conftestdata conftestfile
     echo data > conftestfile
     if ln conftestfile conftestdata 2>/dev/null; then
       cl_cv_prog_LN=ln
     else
       cl_cv_prog_LN="cp -p"
     fi
     rm -f conftestdata conftestfile
    ])
  LN="$cl_cv_prog_LN"
  AC_SUBST([LN])
])

AC_DEFUN([CL_PROG_LN_S],
[
  AC_REQUIRE([CL_PROG_LN])
  dnl Make a symlink if possible; otherwise try a hard link. On filesystems
  dnl which support neither symlink nor hard link, use a plain copy.
  AC_CACHE_CHECK([whether ln -s works], [cl_cv_prog_LN_S_works],
    [rm -f conftestdata
     if ln -s X conftestdata 2>/dev/null; then
       cl_cv_prog_LN_S_works=yes
     else
       cl_cv_prog_LN_S_works=no
     fi
     rm -f conftestdata
    ])
  if test $cl_cv_prog_LN_S_works = yes; then
    LN_S="ln -s"
  else
    LN_S="$cl_cv_prog_LN"
  fi
  AC_SUBST([LN_S])
])
