/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import javax.swing.event.EventListenerList;
import thredds.ui.BAMutil;
import thredds.ui.ProgressMonitorTask;
import ucar.nc2.util.CancelTask;

public class StopButton
extends JButton
implements CancelTask {
    private static ImageIcon[] icon = new ImageIcon[2];
    private static boolean debug;
    private ProgressMonitorTask task;
    private Timer myTimer;
    private boolean busy;
    private boolean isCancelled;
    private int count;
    private EventListenerList listenerList = new EventListenerList();

    public StopButton(String tooltip) {
        this.setIcon(icon[0]);
        this.setMaximumSize(new Dimension(28, 28));
        this.setPreferredSize(new Dimension(28, 28));
        this.setToolTipText(tooltip);
        this.setFocusPainted(false);
        super.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (debug) {
                    System.out.println(" StopButton.EVENT");
                }
                StopButton.this.isCancelled = true;
            }
        });
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    private void fireEvent(ActionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            ((ActionListener)listeners[i + 1]).actionPerformed(event);
        }
    }

    public boolean isCancel() {
        return this.isCancelled;
    }

    public void setError(String msg) {
        System.out.println("Got Error= " + msg);
    }

    public boolean startProgressMonitorTask(ProgressMonitorTask pmt) {
        if (this.busy) {
            return false;
        }
        this.busy = true;
        this.task = pmt;
        this.isCancelled = false;
        this.count = 0;
        this.setIcon(icon[0]);
        ActionListener watcher = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (StopButton.this.isCancelled && !StopButton.this.task.isCancel()) {
                    StopButton.this.task.cancel();
                    if (debug) {
                        System.out.println(" task.cancel");
                    }
                    return;
                }
                StopButton.this.count++;
                StopButton.this.setIcon(icon[StopButton.this.count % 2]);
                if (debug) {
                    System.out.println(" stop count=" + StopButton.this.count);
                }
                if (StopButton.this.task.isDone()) {
                    if (StopButton.this.myTimer != null) {
                        StopButton.this.myTimer.stop();
                    }
                    StopButton.this.myTimer = null;
                    if (StopButton.this.task.isError()) {
                        JOptionPane.showMessageDialog(null, StopButton.this.task.getErrorMessage());
                    }
                    if (StopButton.this.task.isSuccess()) {
                        StopButton.this.fireEvent(new ActionEvent(this, 0, "success"));
                    } else if (StopButton.this.task.isError()) {
                        StopButton.this.fireEvent(new ActionEvent(this, 0, "error"));
                    } else if (StopButton.this.task.isCancel()) {
                        StopButton.this.fireEvent(new ActionEvent(this, 0, "cancel"));
                    } else {
                        StopButton.this.fireEvent(new ActionEvent(this, 0, "done"));
                    }
                    StopButton.this.busy = false;
                }
            }
        };
        this.myTimer = new Timer(1000, watcher);
        this.myTimer.start();
        Thread taskThread = new Thread(this.task);
        taskThread.start();
        return true;
    }

    public void clear() {
        if (this.myTimer != null) {
            this.myTimer.stop();
        }
        this.myTimer = null;
        this.busy = false;
    }

    static {
        StopButton.icon[0] = BAMutil.getIcon("Stop24", true);
        StopButton.icon[1] = BAMutil.getIcon("Stop16", true);
        debug = false;
    }
}

