/* $Id: cpu_jit_ops_mem.h,v 1.10 2009-01-22 17:01:07 potyra Exp $ 
 *
 *  Copyright (c) 2005-2009 FAUmachine Team.
 *  Copyright (c) 2003 Fabrice Bellard.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301
 * USA
 */

void glue(glue(NAME_(op_ldub), MEMSUFFIX), _T0_A0)(void)
{
    T0 = glue(ldub, MEMSUFFIX)(A0);
}

void glue(glue(NAME_(op_ldsb), MEMSUFFIX), _T0_A0)(void)
{
    T0 = glue(ldsb, MEMSUFFIX)(A0);
}

void glue(glue(NAME_(op_lduw), MEMSUFFIX), _T0_A0)(void)
{
    T0 = glue(lduw, MEMSUFFIX)(A0);
}

void glue(glue(NAME_(op_ldsw), MEMSUFFIX), _T0_A0)(void)
{
    T0 = glue(ldsw, MEMSUFFIX)(A0);
}

void glue(glue(NAME_(op_ldl), MEMSUFFIX), _T0_A0)(void)
{
    T0 = (uint32_t)glue(ldl, MEMSUFFIX)(A0);
}

void glue(glue(NAME_(op_ldub), MEMSUFFIX), _T1_A0)(void)
{
    T1 = glue(ldub, MEMSUFFIX)(A0);
}

void glue(glue(NAME_(op_ldsb), MEMSUFFIX), _T1_A0)(void)
{
    T1 = glue(ldsb, MEMSUFFIX)(A0);
}

void glue(glue(NAME_(op_lduw), MEMSUFFIX), _T1_A0)(void)
{
    T1 = glue(lduw, MEMSUFFIX)(A0);
}

void glue(glue(NAME_(op_ldsw), MEMSUFFIX), _T1_A0)(void)
{
    T1 = glue(ldsw, MEMSUFFIX)(A0);
}

void glue(glue(NAME_(op_ldl), MEMSUFFIX), _T1_A0)(void)
{
    T1 = (uint32_t)glue(ldl, MEMSUFFIX)(A0);
}

void glue(glue(NAME_(op_stb), MEMSUFFIX), _T0_A0)(void)
{
    glue(stb, MEMSUFFIX)(A0, T0);
    FORCE_RET();
}

void glue(glue(NAME_(op_stw), MEMSUFFIX), _T0_A0)(void)
{
    glue(stw, MEMSUFFIX)(A0, T0);
    FORCE_RET();
}

void glue(glue(NAME_(op_stl), MEMSUFFIX), _T0_A0)(void)
{
    glue(stl, MEMSUFFIX)(A0, T0);
    FORCE_RET();
}

#if 0
void glue(glue(NAME_(op_stb), MEMSUFFIX), _T1_A0)(void)
{
    glue(stb, MEMSUFFIX)(A0, T1);
    FORCE_RET();
}
#endif

void glue(glue(NAME_(op_stw), MEMSUFFIX), _T1_A0)(void)
{
    glue(stw, MEMSUFFIX)(A0, T1);
    FORCE_RET();
}

void glue(glue(NAME_(op_stl), MEMSUFFIX), _T1_A0)(void)
{
    glue(stl, MEMSUFFIX)(A0, T1);
    FORCE_RET();
}

/* SSE/MMX support */
void glue(glue(NAME_(op_ldq), MEMSUFFIX), _env_A0)(void)
{
    uint64_t *p;
    p = (uint64_t *)((char *)env + PARAM1);
    *p = glue(ldq, MEMSUFFIX)(A0);
}

void glue(glue(NAME_(op_stq), MEMSUFFIX), _env_A0)(void)
{
    uint64_t *p;
    p = (uint64_t *)((char *)env + PARAM1);
    glue(stq, MEMSUFFIX)(A0, *p);
    FORCE_RET();
}

void glue(glue(NAME_(op_ldo), MEMSUFFIX), _env_A0)(void)
{
    XMMReg *p;
    p = (XMMReg *)((char *)env + PARAM1);
    p->XMM_Q(0) = glue(ldq, MEMSUFFIX)(A0);
    p->XMM_Q(1) = glue(ldq, MEMSUFFIX)(A0 + 8);
}

void glue(glue(NAME_(op_sto), MEMSUFFIX), _env_A0)(void)
{
    XMMReg *p;
    p = (XMMReg *)((char *)env + PARAM1);
    glue(stq, MEMSUFFIX)(A0, p->XMM_Q(0));
    glue(stq, MEMSUFFIX)(A0 + 8, p->XMM_Q(1));
    FORCE_RET();
}

#if CONFIG_CPU >= 80486 && CONFIG_CPU_LM_SUPPORT
void glue(glue(NAME_(op_ldsl), MEMSUFFIX), _T0_A0)(void)
{
    T0 = (int32_t)glue(ldl, MEMSUFFIX)(A0);
}

void glue(glue(NAME_(op_ldsl), MEMSUFFIX), _T1_A0)(void)
{
    T1 = (int32_t)glue(ldl, MEMSUFFIX)(A0);
}

void glue(glue(NAME_(op_ldq), MEMSUFFIX), _T0_A0)(void)
{
    T0 = glue(ldq, MEMSUFFIX)(A0);
}

void glue(glue(NAME_(op_ldq), MEMSUFFIX), _T1_A0)(void)
{
    T1 = glue(ldq, MEMSUFFIX)(A0);
}

void glue(glue(NAME_(op_stq), MEMSUFFIX), _T0_A0)(void)
{
    glue(stq, MEMSUFFIX)(A0, T0);
    FORCE_RET();
}

void glue(glue(NAME_(op_stq), MEMSUFFIX), _T1_A0)(void)
{
    glue(stq, MEMSUFFIX)(A0, T1);
    FORCE_RET();
}
#endif /* CONFIG_CPU_LM_SUPPORT */

#undef MEMSUFFIX
