/*
 * $Id: arch_gen_cpu_x86_reg_fast.c,v 1.5 2009-01-23 10:34:53 potyra Exp $
 *
 * Derived from QEMU sources.
 * Modified for FAUmachine by Volkmar Sieh.
 *  
 *  Copyright (c) 2005-2009 FAUmachine Team.
 *  Copyright (c) 2003 Fabrice Bellard.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301
 * USA
 */

void
NAME_(helper_movl_crN_T0)(int reg)
{
	switch(reg) {
	case 0:
		NAME_(update_cr0)(T0);
		break;
	case 3:
		NAME_(update_cr3)(T0);
		break;
	case 4:
		NAME_(update_cr4)(T0);
		break;
#if 80486 <= CONFIG_CPU && CONFIG_CPU_APIC_SUPPORT
	case 8:
		NAME_(set_apic_tpr)(T0);
		break;
#endif
	default:
		env->cr[reg] = T0;
		break;
	}
}

/* XXX: do more */
void
NAME_(helper_movl_drN_T0)(int reg)
{
	env->dr[reg] = T0;
}
