/* $Id$ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SUBPROG_BODY_HPP_INCLUDED
#define __SUBPROG_BODY_HPP_INCLUDED

#include <list>
#include "frontend/ast/SymbolDeclaration.hpp"
#include "frontend/ast/SeqStat.hpp"

namespace ast {

//! definition of a VHDL procedure or function.
/** This class represents a VHDL function or procedure 
 *  body.
 */
class SubprogBody : public AstNode {
public:
	/** kind of subprog body */
	enum ProgKind {
		PROG_KIND_UNKNOWN,	/**< unspecifed */
		PROG_KIND_FUNCTION,	/**< it's a function */
		PROG_KIND_PROCEDURE	/**< it's a procedure */
	};

	//! c'tor
	/** @param localDefs local definitions.
          * @param seqS sequential stat of the subprogram.
          * @param loc location of the definition.
          */
	SubprogBody(
		std::list<ast::SymbolDeclaration*> *localDefs,
		std::list<SeqStat*> *seqS,
		Location loc
		) : 	AstNode(loc),
			seqStats(seqS),
			declarations(localDefs) {}

	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor& visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		stream << "suprogram body";
	}


	/** sequential statements */
	std::list<SeqStat*> *seqStats;

	/** declarations */
	std::list<SymbolDeclaration*> *declarations;

protected:
	/** Destructor */
	virtual ~SubprogBody() {
		util::MiscUtil::lterminate(seqStats);
		util::MiscUtil::lterminate(declarations);
	}
};

}; /* namespace ast */

#endif /* __SUBPROG_BODY_HPP_INCLUDED */
