// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file member_idTypeObjectSupport.cxx
 * Source file containing the implementation to register the TypeObject representation of the described types in the IDL file
 *
 * This file was generated by the tool fastddsgen.
 */

#include "member_idTypeObjectSupport.hpp"

#include <mutex>
#include <string>

#include <fastcdr/xcdr/external.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastdds/dds/domain/DomainParticipantFactory.hpp>
#include <fastdds/dds/log/Log.hpp>
#include <fastdds/dds/xtypes/common.hpp>
#include <fastdds/dds/xtypes/type_representation/ITypeObjectRegistry.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObject.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObjectUtils.hpp>

#include "member_id.hpp"


using namespace eprosima::fastdds::dds::xtypes;

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_FixId_type_identifier(
        TypeIdentifierPair& type_ids_FixId)
{

    ReturnCode_t return_code_FixId {eprosima::fastdds::dds::RETCODE_OK};
    return_code_FixId =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "FixId", type_ids_FixId);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_FixId)
    {
        StructTypeFlag struct_flags_FixId = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, false);
        QualifiedTypeName type_name_FixId = "FixId";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_FixId;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_FixId;
        AppliedAnnotationSeq tmp_ann_custom_FixId;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_FixId;
        if (!tmp_ann_custom_FixId.empty())
        {
            ann_custom_FixId = tmp_ann_custom_FixId;
        }

        CompleteTypeDetail detail_FixId = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_FixId, ann_custom_FixId, type_name_FixId.to_string());
        CompleteStructHeader header_FixId;
        header_FixId = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_FixId);
        CompleteStructMemberSeq member_seq_FixId;
        {
            TypeIdentifierPair type_ids_o;
            ReturnCode_t return_code_o {eprosima::fastdds::dds::RETCODE_OK};
            return_code_o =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_o);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_o)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "o Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_o = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_o = 0x00000064;
            bool common_o_ec {false};
            CommonStructMember common_o {TypeObjectUtils::build_common_struct_member(member_id_o, member_flags_o, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_o, common_o_ec))};
            if (!common_o_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure o member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_o = "o";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_o;
            ann_custom_FixId.reset();
            AppliedAnnotationSeq tmp_ann_custom_o;
            eprosima::fastcdr::optional<std::string> unit_o;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_o;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_o;
            eprosima::fastcdr::optional<std::string> hash_id_o;
            if (unit_o.has_value() || min_o.has_value() || max_o.has_value() || hash_id_o.has_value())
            {
                member_ann_builtin_o = TypeObjectUtils::build_applied_builtin_member_annotations(unit_o, min_o, max_o, hash_id_o);
            }
            if (!tmp_ann_custom_o.empty())
            {
                ann_custom_FixId = tmp_ann_custom_o;
            }
            CompleteMemberDetail detail_o = TypeObjectUtils::build_complete_member_detail(name_o, member_ann_builtin_o, ann_custom_FixId);
            CompleteStructMember member_o = TypeObjectUtils::build_complete_struct_member(common_o, detail_o);
            TypeObjectUtils::add_complete_struct_member(member_seq_FixId, member_o);
        }
        {
            TypeIdentifierPair type_ids_s;
            ReturnCode_t return_code_s {eprosima::fastdds::dds::RETCODE_OK};
            return_code_s =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_s);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_s)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "s Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_s = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_s = 0x0000012c;
            bool common_s_ec {false};
            CommonStructMember common_s {TypeObjectUtils::build_common_struct_member(member_id_s, member_flags_s, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_s, common_s_ec))};
            if (!common_s_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure s member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_s = "s";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_s;
            ann_custom_FixId.reset();
            AppliedAnnotationSeq tmp_ann_custom_s;
            eprosima::fastcdr::optional<std::string> unit_s;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_s;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_s;
            eprosima::fastcdr::optional<std::string> hash_id_s;
            if (unit_s.has_value() || min_s.has_value() || max_s.has_value() || hash_id_s.has_value())
            {
                member_ann_builtin_s = TypeObjectUtils::build_applied_builtin_member_annotations(unit_s, min_s, max_s, hash_id_s);
            }
            if (!tmp_ann_custom_s.empty())
            {
                ann_custom_FixId = tmp_ann_custom_s;
            }
            CompleteMemberDetail detail_s = TypeObjectUtils::build_complete_member_detail(name_s, member_ann_builtin_s, ann_custom_FixId);
            CompleteStructMember member_s = TypeObjectUtils::build_complete_struct_member(common_s, detail_s);
            TypeObjectUtils::add_complete_struct_member(member_seq_FixId, member_s);
        }
        {
            TypeIdentifierPair type_ids_l;
            ReturnCode_t return_code_l {eprosima::fastdds::dds::RETCODE_OK};
            return_code_l =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_l);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_l)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "l Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_l = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_l = 0x000001f4;
            bool common_l_ec {false};
            CommonStructMember common_l {TypeObjectUtils::build_common_struct_member(member_id_l, member_flags_l, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_l, common_l_ec))};
            if (!common_l_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure l member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_l = "l";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_l;
            ann_custom_FixId.reset();
            AppliedAnnotationSeq tmp_ann_custom_l;
            eprosima::fastcdr::optional<std::string> unit_l;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_l;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_l;
            eprosima::fastcdr::optional<std::string> hash_id_l;
            if (unit_l.has_value() || min_l.has_value() || max_l.has_value() || hash_id_l.has_value())
            {
                member_ann_builtin_l = TypeObjectUtils::build_applied_builtin_member_annotations(unit_l, min_l, max_l, hash_id_l);
            }
            if (!tmp_ann_custom_l.empty())
            {
                ann_custom_FixId = tmp_ann_custom_l;
            }
            CompleteMemberDetail detail_l = TypeObjectUtils::build_complete_member_detail(name_l, member_ann_builtin_l, ann_custom_FixId);
            CompleteStructMember member_l = TypeObjectUtils::build_complete_struct_member(common_l, detail_l);
            TypeObjectUtils::add_complete_struct_member(member_seq_FixId, member_l);
        }
        {
            TypeIdentifierPair type_ids_ll;
            ReturnCode_t return_code_ll {eprosima::fastdds::dds::RETCODE_OK};
            return_code_ll =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_ll);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_ll)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "ll Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_ll = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_ll = 0x000001f5;
            bool common_ll_ec {false};
            CommonStructMember common_ll {TypeObjectUtils::build_common_struct_member(member_id_ll, member_flags_ll, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_ll, common_ll_ec))};
            if (!common_ll_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure ll member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_ll = "ll";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_ll;
            ann_custom_FixId.reset();
            CompleteMemberDetail detail_ll = TypeObjectUtils::build_complete_member_detail(name_ll, member_ann_builtin_ll, ann_custom_FixId);
            CompleteStructMember member_ll = TypeObjectUtils::build_complete_struct_member(common_ll, detail_ll);
            TypeObjectUtils::add_complete_struct_member(member_seq_FixId, member_ll);
        }
        CompleteStructType struct_type_FixId = TypeObjectUtils::build_complete_struct_type(struct_flags_FixId, header_FixId, member_seq_FixId);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_FixId, type_name_FixId.to_string(), type_ids_FixId))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "FixId already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_FixHexId_type_identifier(
        TypeIdentifierPair& type_ids_FixHexId)
{

    ReturnCode_t return_code_FixHexId {eprosima::fastdds::dds::RETCODE_OK};
    return_code_FixHexId =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "FixHexId", type_ids_FixHexId);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_FixHexId)
    {
        StructTypeFlag struct_flags_FixHexId = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, false);
        QualifiedTypeName type_name_FixHexId = "FixHexId";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_FixHexId;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_FixHexId;
        AppliedAnnotationSeq tmp_ann_custom_FixHexId;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_FixHexId;
        if (!tmp_ann_custom_FixHexId.empty())
        {
            ann_custom_FixHexId = tmp_ann_custom_FixHexId;
        }

        CompleteTypeDetail detail_FixHexId = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_FixHexId, ann_custom_FixHexId, type_name_FixHexId.to_string());
        CompleteStructHeader header_FixHexId;
        header_FixHexId = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_FixHexId);
        CompleteStructMemberSeq member_seq_FixHexId;
        {
            TypeIdentifierPair type_ids_ho;
            ReturnCode_t return_code_ho {eprosima::fastdds::dds::RETCODE_OK};
            return_code_ho =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_ho);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_ho)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "ho Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_ho = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_ho = 0x00000100;
            bool common_ho_ec {false};
            CommonStructMember common_ho {TypeObjectUtils::build_common_struct_member(member_id_ho, member_flags_ho, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_ho, common_ho_ec))};
            if (!common_ho_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure ho member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_ho = "ho";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_ho;
            ann_custom_FixHexId.reset();
            AppliedAnnotationSeq tmp_ann_custom_ho;
            eprosima::fastcdr::optional<std::string> unit_ho;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_ho;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_ho;
            eprosima::fastcdr::optional<std::string> hash_id_ho;
            if (unit_ho.has_value() || min_ho.has_value() || max_ho.has_value() || hash_id_ho.has_value())
            {
                member_ann_builtin_ho = TypeObjectUtils::build_applied_builtin_member_annotations(unit_ho, min_ho, max_ho, hash_id_ho);
            }
            if (!tmp_ann_custom_ho.empty())
            {
                ann_custom_FixHexId = tmp_ann_custom_ho;
            }
            CompleteMemberDetail detail_ho = TypeObjectUtils::build_complete_member_detail(name_ho, member_ann_builtin_ho, ann_custom_FixHexId);
            CompleteStructMember member_ho = TypeObjectUtils::build_complete_struct_member(common_ho, detail_ho);
            TypeObjectUtils::add_complete_struct_member(member_seq_FixHexId, member_ho);
        }
        {
            TypeIdentifierPair type_ids_hs;
            ReturnCode_t return_code_hs {eprosima::fastdds::dds::RETCODE_OK};
            return_code_hs =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_hs);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_hs)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "hs Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_hs = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_hs = 0x00000300;
            bool common_hs_ec {false};
            CommonStructMember common_hs {TypeObjectUtils::build_common_struct_member(member_id_hs, member_flags_hs, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_hs, common_hs_ec))};
            if (!common_hs_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure hs member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_hs = "hs";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_hs;
            ann_custom_FixHexId.reset();
            AppliedAnnotationSeq tmp_ann_custom_hs;
            eprosima::fastcdr::optional<std::string> unit_hs;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_hs;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_hs;
            eprosima::fastcdr::optional<std::string> hash_id_hs;
            if (unit_hs.has_value() || min_hs.has_value() || max_hs.has_value() || hash_id_hs.has_value())
            {
                member_ann_builtin_hs = TypeObjectUtils::build_applied_builtin_member_annotations(unit_hs, min_hs, max_hs, hash_id_hs);
            }
            if (!tmp_ann_custom_hs.empty())
            {
                ann_custom_FixHexId = tmp_ann_custom_hs;
            }
            CompleteMemberDetail detail_hs = TypeObjectUtils::build_complete_member_detail(name_hs, member_ann_builtin_hs, ann_custom_FixHexId);
            CompleteStructMember member_hs = TypeObjectUtils::build_complete_struct_member(common_hs, detail_hs);
            TypeObjectUtils::add_complete_struct_member(member_seq_FixHexId, member_hs);
        }
        {
            TypeIdentifierPair type_ids_hl;
            ReturnCode_t return_code_hl {eprosima::fastdds::dds::RETCODE_OK};
            return_code_hl =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_hl);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_hl)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "hl Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_hl = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_hl = 0x00000500;
            bool common_hl_ec {false};
            CommonStructMember common_hl {TypeObjectUtils::build_common_struct_member(member_id_hl, member_flags_hl, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_hl, common_hl_ec))};
            if (!common_hl_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure hl member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_hl = "hl";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_hl;
            ann_custom_FixHexId.reset();
            AppliedAnnotationSeq tmp_ann_custom_hl;
            eprosima::fastcdr::optional<std::string> unit_hl;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_hl;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_hl;
            eprosima::fastcdr::optional<std::string> hash_id_hl;
            if (unit_hl.has_value() || min_hl.has_value() || max_hl.has_value() || hash_id_hl.has_value())
            {
                member_ann_builtin_hl = TypeObjectUtils::build_applied_builtin_member_annotations(unit_hl, min_hl, max_hl, hash_id_hl);
            }
            if (!tmp_ann_custom_hl.empty())
            {
                ann_custom_FixHexId = tmp_ann_custom_hl;
            }
            CompleteMemberDetail detail_hl = TypeObjectUtils::build_complete_member_detail(name_hl, member_ann_builtin_hl, ann_custom_FixHexId);
            CompleteStructMember member_hl = TypeObjectUtils::build_complete_struct_member(common_hl, detail_hl);
            TypeObjectUtils::add_complete_struct_member(member_seq_FixHexId, member_hl);
        }
        {
            TypeIdentifierPair type_ids_ll;
            ReturnCode_t return_code_ll {eprosima::fastdds::dds::RETCODE_OK};
            return_code_ll =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_ll);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_ll)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "ll Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_ll = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_ll = 0x00000501;
            bool common_ll_ec {false};
            CommonStructMember common_ll {TypeObjectUtils::build_common_struct_member(member_id_ll, member_flags_ll, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_ll, common_ll_ec))};
            if (!common_ll_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure ll member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_ll = "ll";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_ll;
            ann_custom_FixHexId.reset();
            CompleteMemberDetail detail_ll = TypeObjectUtils::build_complete_member_detail(name_ll, member_ann_builtin_ll, ann_custom_FixHexId);
            CompleteStructMember member_ll = TypeObjectUtils::build_complete_struct_member(common_ll, detail_ll);
            TypeObjectUtils::add_complete_struct_member(member_seq_FixHexId, member_ll);
        }
        CompleteStructType struct_type_FixHexId = TypeObjectUtils::build_complete_struct_type(struct_flags_FixHexId, header_FixHexId, member_seq_FixHexId);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_FixHexId, type_name_FixHexId.to_string(), type_ids_FixHexId))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "FixHexId already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_FixHashidDefault_type_identifier(
        TypeIdentifierPair& type_ids_FixHashidDefault)
{

    ReturnCode_t return_code_FixHashidDefault {eprosima::fastdds::dds::RETCODE_OK};
    return_code_FixHashidDefault =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "FixHashidDefault", type_ids_FixHashidDefault);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_FixHashidDefault)
    {
        StructTypeFlag struct_flags_FixHashidDefault = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, false);
        QualifiedTypeName type_name_FixHashidDefault = "FixHashidDefault";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_FixHashidDefault;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_FixHashidDefault;
        AppliedAnnotationSeq tmp_ann_custom_FixHashidDefault;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_FixHashidDefault;
        if (!tmp_ann_custom_FixHashidDefault.empty())
        {
            ann_custom_FixHashidDefault = tmp_ann_custom_FixHashidDefault;
        }

        CompleteTypeDetail detail_FixHashidDefault = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_FixHashidDefault, ann_custom_FixHashidDefault, type_name_FixHashidDefault.to_string());
        CompleteStructHeader header_FixHashidDefault;
        header_FixHashidDefault = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_FixHashidDefault);
        CompleteStructMemberSeq member_seq_FixHashidDefault;
        {
            TypeIdentifierPair type_ids_o;
            ReturnCode_t return_code_o {eprosima::fastdds::dds::RETCODE_OK};
            return_code_o =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_o);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_o)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "o Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_o = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_o = 0x057956d9;
            bool common_o_ec {false};
            CommonStructMember common_o {TypeObjectUtils::build_common_struct_member(member_id_o, member_flags_o, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_o, common_o_ec))};
            if (!common_o_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure o member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_o = "o";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_o;
            ann_custom_FixHashidDefault.reset();
            AppliedAnnotationSeq tmp_ann_custom_o;
            eprosima::fastcdr::optional<std::string> unit_o;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_o;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_o;
            eprosima::fastcdr::optional<std::string> hash_id_o;
            hash_id_o = "";

            if (unit_o.has_value() || min_o.has_value() || max_o.has_value() || hash_id_o.has_value())
            {
                member_ann_builtin_o = TypeObjectUtils::build_applied_builtin_member_annotations(unit_o, min_o, max_o, hash_id_o);
            }
            if (!tmp_ann_custom_o.empty())
            {
                ann_custom_FixHashidDefault = tmp_ann_custom_o;
            }
            CompleteMemberDetail detail_o = TypeObjectUtils::build_complete_member_detail(name_o, member_ann_builtin_o, ann_custom_FixHashidDefault);
            CompleteStructMember member_o = TypeObjectUtils::build_complete_struct_member(common_o, detail_o);
            TypeObjectUtils::add_complete_struct_member(member_seq_FixHashidDefault, member_o);
        }
        {
            TypeIdentifierPair type_ids_s;
            ReturnCode_t return_code_s {eprosima::fastdds::dds::RETCODE_OK};
            return_code_s =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_s);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_s)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "s Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_s = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_s = 0x0cc0c703;
            bool common_s_ec {false};
            CommonStructMember common_s {TypeObjectUtils::build_common_struct_member(member_id_s, member_flags_s, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_s, common_s_ec))};
            if (!common_s_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure s member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_s = "s";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_s;
            ann_custom_FixHashidDefault.reset();
            AppliedAnnotationSeq tmp_ann_custom_s;
            eprosima::fastcdr::optional<std::string> unit_s;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_s;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_s;
            eprosima::fastcdr::optional<std::string> hash_id_s;
            hash_id_s = "";

            if (unit_s.has_value() || min_s.has_value() || max_s.has_value() || hash_id_s.has_value())
            {
                member_ann_builtin_s = TypeObjectUtils::build_applied_builtin_member_annotations(unit_s, min_s, max_s, hash_id_s);
            }
            if (!tmp_ann_custom_s.empty())
            {
                ann_custom_FixHashidDefault = tmp_ann_custom_s;
            }
            CompleteMemberDetail detail_s = TypeObjectUtils::build_complete_member_detail(name_s, member_ann_builtin_s, ann_custom_FixHashidDefault);
            CompleteStructMember member_s = TypeObjectUtils::build_complete_struct_member(common_s, detail_s);
            TypeObjectUtils::add_complete_struct_member(member_seq_FixHashidDefault, member_s);
        }
        {
            TypeIdentifierPair type_ids_l;
            ReturnCode_t return_code_l {eprosima::fastdds::dds::RETCODE_OK};
            return_code_l =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_l);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_l)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "l Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_l = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_l = 0x0e5eb92d;
            bool common_l_ec {false};
            CommonStructMember common_l {TypeObjectUtils::build_common_struct_member(member_id_l, member_flags_l, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_l, common_l_ec))};
            if (!common_l_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure l member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_l = "l";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_l;
            ann_custom_FixHashidDefault.reset();
            AppliedAnnotationSeq tmp_ann_custom_l;
            eprosima::fastcdr::optional<std::string> unit_l;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_l;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_l;
            eprosima::fastcdr::optional<std::string> hash_id_l;
            hash_id_l = "";

            if (unit_l.has_value() || min_l.has_value() || max_l.has_value() || hash_id_l.has_value())
            {
                member_ann_builtin_l = TypeObjectUtils::build_applied_builtin_member_annotations(unit_l, min_l, max_l, hash_id_l);
            }
            if (!tmp_ann_custom_l.empty())
            {
                ann_custom_FixHashidDefault = tmp_ann_custom_l;
            }
            CompleteMemberDetail detail_l = TypeObjectUtils::build_complete_member_detail(name_l, member_ann_builtin_l, ann_custom_FixHashidDefault);
            CompleteStructMember member_l = TypeObjectUtils::build_complete_struct_member(common_l, detail_l);
            TypeObjectUtils::add_complete_struct_member(member_seq_FixHashidDefault, member_l);
        }
        {
            TypeIdentifierPair type_ids_ll;
            ReturnCode_t return_code_ll {eprosima::fastdds::dds::RETCODE_OK};
            return_code_ll =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_ll);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_ll)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "ll Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_ll = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_ll = 0x0e5eb92e;
            bool common_ll_ec {false};
            CommonStructMember common_ll {TypeObjectUtils::build_common_struct_member(member_id_ll, member_flags_ll, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_ll, common_ll_ec))};
            if (!common_ll_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure ll member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_ll = "ll";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_ll;
            ann_custom_FixHashidDefault.reset();
            CompleteMemberDetail detail_ll = TypeObjectUtils::build_complete_member_detail(name_ll, member_ann_builtin_ll, ann_custom_FixHashidDefault);
            CompleteStructMember member_ll = TypeObjectUtils::build_complete_struct_member(common_ll, detail_ll);
            TypeObjectUtils::add_complete_struct_member(member_seq_FixHashidDefault, member_ll);
        }
        CompleteStructType struct_type_FixHashidDefault = TypeObjectUtils::build_complete_struct_type(struct_flags_FixHashidDefault, header_FixHashidDefault, member_seq_FixHashidDefault);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_FixHashidDefault, type_name_FixHashidDefault.to_string(), type_ids_FixHashidDefault))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "FixHashidDefault already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_FixHashid_type_identifier(
        TypeIdentifierPair& type_ids_FixHashid)
{

    ReturnCode_t return_code_FixHashid {eprosima::fastdds::dds::RETCODE_OK};
    return_code_FixHashid =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "FixHashid", type_ids_FixHashid);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_FixHashid)
    {
        StructTypeFlag struct_flags_FixHashid = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, false);
        QualifiedTypeName type_name_FixHashid = "FixHashid";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_FixHashid;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_FixHashid;
        AppliedAnnotationSeq tmp_ann_custom_FixHashid;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_FixHashid;
        if (!tmp_ann_custom_FixHashid.empty())
        {
            ann_custom_FixHashid = tmp_ann_custom_FixHashid;
        }

        CompleteTypeDetail detail_FixHashid = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_FixHashid, ann_custom_FixHashid, type_name_FixHashid.to_string());
        CompleteStructHeader header_FixHashid;
        header_FixHashid = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_FixHashid);
        CompleteStructMemberSeq member_seq_FixHashid;
        {
            TypeIdentifierPair type_ids_o;
            ReturnCode_t return_code_o {eprosima::fastdds::dds::RETCODE_OK};
            return_code_o =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_o);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_o)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "o Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_o = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_o = 0x02b9e4e7;
            bool common_o_ec {false};
            CommonStructMember common_o {TypeObjectUtils::build_common_struct_member(member_id_o, member_flags_o, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_o, common_o_ec))};
            if (!common_o_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure o member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_o = "o";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_o;
            ann_custom_FixHashid.reset();
            AppliedAnnotationSeq tmp_ann_custom_o;
            eprosima::fastcdr::optional<std::string> unit_o;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_o;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_o;
            eprosima::fastcdr::optional<std::string> hash_id_o;
            hash_id_o = "octet";

            if (unit_o.has_value() || min_o.has_value() || max_o.has_value() || hash_id_o.has_value())
            {
                member_ann_builtin_o = TypeObjectUtils::build_applied_builtin_member_annotations(unit_o, min_o, max_o, hash_id_o);
            }
            if (!tmp_ann_custom_o.empty())
            {
                ann_custom_FixHashid = tmp_ann_custom_o;
            }
            CompleteMemberDetail detail_o = TypeObjectUtils::build_complete_member_detail(name_o, member_ann_builtin_o, ann_custom_FixHashid);
            CompleteStructMember member_o = TypeObjectUtils::build_complete_struct_member(common_o, detail_o);
            TypeObjectUtils::add_complete_struct_member(member_seq_FixHashid, member_o);
        }
        {
            TypeIdentifierPair type_ids_s;
            ReturnCode_t return_code_s {eprosima::fastdds::dds::RETCODE_OK};
            return_code_s =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_s);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_s)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "s Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_s = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_s = 0x09da094f;
            bool common_s_ec {false};
            CommonStructMember common_s {TypeObjectUtils::build_common_struct_member(member_id_s, member_flags_s, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_s, common_s_ec))};
            if (!common_s_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure s member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_s = "s";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_s;
            ann_custom_FixHashid.reset();
            AppliedAnnotationSeq tmp_ann_custom_s;
            eprosima::fastcdr::optional<std::string> unit_s;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_s;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_s;
            eprosima::fastcdr::optional<std::string> hash_id_s;
            hash_id_s = "short";

            if (unit_s.has_value() || min_s.has_value() || max_s.has_value() || hash_id_s.has_value())
            {
                member_ann_builtin_s = TypeObjectUtils::build_applied_builtin_member_annotations(unit_s, min_s, max_s, hash_id_s);
            }
            if (!tmp_ann_custom_s.empty())
            {
                ann_custom_FixHashid = tmp_ann_custom_s;
            }
            CompleteMemberDetail detail_s = TypeObjectUtils::build_complete_member_detail(name_s, member_ann_builtin_s, ann_custom_FixHashid);
            CompleteStructMember member_s = TypeObjectUtils::build_complete_struct_member(common_s, detail_s);
            TypeObjectUtils::add_complete_struct_member(member_seq_FixHashid, member_s);
        }
        {
            TypeIdentifierPair type_ids_l;
            ReturnCode_t return_code_l {eprosima::fastdds::dds::RETCODE_OK};
            return_code_l =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_l);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_l)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "l Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_l = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_l = 0x0364520f;
            bool common_l_ec {false};
            CommonStructMember common_l {TypeObjectUtils::build_common_struct_member(member_id_l, member_flags_l, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_l, common_l_ec))};
            if (!common_l_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure l member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_l = "l";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_l;
            ann_custom_FixHashid.reset();
            AppliedAnnotationSeq tmp_ann_custom_l;
            eprosima::fastcdr::optional<std::string> unit_l;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_l;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_l;
            eprosima::fastcdr::optional<std::string> hash_id_l;
            hash_id_l = "long";

            if (unit_l.has_value() || min_l.has_value() || max_l.has_value() || hash_id_l.has_value())
            {
                member_ann_builtin_l = TypeObjectUtils::build_applied_builtin_member_annotations(unit_l, min_l, max_l, hash_id_l);
            }
            if (!tmp_ann_custom_l.empty())
            {
                ann_custom_FixHashid = tmp_ann_custom_l;
            }
            CompleteMemberDetail detail_l = TypeObjectUtils::build_complete_member_detail(name_l, member_ann_builtin_l, ann_custom_FixHashid);
            CompleteStructMember member_l = TypeObjectUtils::build_complete_struct_member(common_l, detail_l);
            TypeObjectUtils::add_complete_struct_member(member_seq_FixHashid, member_l);
        }
        {
            TypeIdentifierPair type_ids_ll;
            ReturnCode_t return_code_ll {eprosima::fastdds::dds::RETCODE_OK};
            return_code_ll =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_ll);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_ll)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "ll Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_ll = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_ll = 0x03645210;
            bool common_ll_ec {false};
            CommonStructMember common_ll {TypeObjectUtils::build_common_struct_member(member_id_ll, member_flags_ll, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_ll, common_ll_ec))};
            if (!common_ll_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure ll member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_ll = "ll";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_ll;
            ann_custom_FixHashid.reset();
            CompleteMemberDetail detail_ll = TypeObjectUtils::build_complete_member_detail(name_ll, member_ann_builtin_ll, ann_custom_FixHashid);
            CompleteStructMember member_ll = TypeObjectUtils::build_complete_struct_member(common_ll, detail_ll);
            TypeObjectUtils::add_complete_struct_member(member_seq_FixHashid, member_ll);
        }
        CompleteStructType struct_type_FixHashid = TypeObjectUtils::build_complete_struct_type(struct_flags_FixHashid, header_FixHashid, member_seq_FixHashid);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_FixHashid, type_name_FixHashid.to_string(), type_ids_FixHashid))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "FixHashid already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_FixMix_type_identifier(
        TypeIdentifierPair& type_ids_FixMix)
{

    ReturnCode_t return_code_FixMix {eprosima::fastdds::dds::RETCODE_OK};
    return_code_FixMix =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "FixMix", type_ids_FixMix);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_FixMix)
    {
        StructTypeFlag struct_flags_FixMix = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, false);
        QualifiedTypeName type_name_FixMix = "FixMix";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_FixMix;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_FixMix;
        AppliedAnnotationSeq tmp_ann_custom_FixMix;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_FixMix;
        if (!tmp_ann_custom_FixMix.empty())
        {
            ann_custom_FixMix = tmp_ann_custom_FixMix;
        }

        CompleteTypeDetail detail_FixMix = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_FixMix, ann_custom_FixMix, type_name_FixMix.to_string());
        CompleteStructHeader header_FixMix;
        header_FixMix = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_FixMix);
        CompleteStructMemberSeq member_seq_FixMix;
        {
            TypeIdentifierPair type_ids_o;
            ReturnCode_t return_code_o {eprosima::fastdds::dds::RETCODE_OK};
            return_code_o =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_o);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_o)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "o Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_o = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_o = 0x00000064;
            bool common_o_ec {false};
            CommonStructMember common_o {TypeObjectUtils::build_common_struct_member(member_id_o, member_flags_o, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_o, common_o_ec))};
            if (!common_o_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure o member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_o = "o";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_o;
            ann_custom_FixMix.reset();
            AppliedAnnotationSeq tmp_ann_custom_o;
            eprosima::fastcdr::optional<std::string> unit_o;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_o;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_o;
            eprosima::fastcdr::optional<std::string> hash_id_o;
            if (unit_o.has_value() || min_o.has_value() || max_o.has_value() || hash_id_o.has_value())
            {
                member_ann_builtin_o = TypeObjectUtils::build_applied_builtin_member_annotations(unit_o, min_o, max_o, hash_id_o);
            }
            if (!tmp_ann_custom_o.empty())
            {
                ann_custom_FixMix = tmp_ann_custom_o;
            }
            CompleteMemberDetail detail_o = TypeObjectUtils::build_complete_member_detail(name_o, member_ann_builtin_o, ann_custom_FixMix);
            CompleteStructMember member_o = TypeObjectUtils::build_complete_struct_member(common_o, detail_o);
            TypeObjectUtils::add_complete_struct_member(member_seq_FixMix, member_o);
        }
        {
            TypeIdentifierPair type_ids_ho;
            ReturnCode_t return_code_ho {eprosima::fastdds::dds::RETCODE_OK};
            return_code_ho =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_ho);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_ho)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "ho Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_ho = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_ho = 0x00000200;
            bool common_ho_ec {false};
            CommonStructMember common_ho {TypeObjectUtils::build_common_struct_member(member_id_ho, member_flags_ho, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_ho, common_ho_ec))};
            if (!common_ho_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure ho member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_ho = "ho";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_ho;
            ann_custom_FixMix.reset();
            AppliedAnnotationSeq tmp_ann_custom_ho;
            eprosima::fastcdr::optional<std::string> unit_ho;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_ho;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_ho;
            eprosima::fastcdr::optional<std::string> hash_id_ho;
            if (unit_ho.has_value() || min_ho.has_value() || max_ho.has_value() || hash_id_ho.has_value())
            {
                member_ann_builtin_ho = TypeObjectUtils::build_applied_builtin_member_annotations(unit_ho, min_ho, max_ho, hash_id_ho);
            }
            if (!tmp_ann_custom_ho.empty())
            {
                ann_custom_FixMix = tmp_ann_custom_ho;
            }
            CompleteMemberDetail detail_ho = TypeObjectUtils::build_complete_member_detail(name_ho, member_ann_builtin_ho, ann_custom_FixMix);
            CompleteStructMember member_ho = TypeObjectUtils::build_complete_struct_member(common_ho, detail_ho);
            TypeObjectUtils::add_complete_struct_member(member_seq_FixMix, member_ho);
        }
        {
            TypeIdentifierPair type_ids_s;
            ReturnCode_t return_code_s {eprosima::fastdds::dds::RETCODE_OK};
            return_code_s =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_s);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_s)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "s Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_s = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_s = 0x0cc0c703;
            bool common_s_ec {false};
            CommonStructMember common_s {TypeObjectUtils::build_common_struct_member(member_id_s, member_flags_s, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_s, common_s_ec))};
            if (!common_s_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure s member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_s = "s";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_s;
            ann_custom_FixMix.reset();
            AppliedAnnotationSeq tmp_ann_custom_s;
            eprosima::fastcdr::optional<std::string> unit_s;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_s;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_s;
            eprosima::fastcdr::optional<std::string> hash_id_s;
            hash_id_s = "";

            if (unit_s.has_value() || min_s.has_value() || max_s.has_value() || hash_id_s.has_value())
            {
                member_ann_builtin_s = TypeObjectUtils::build_applied_builtin_member_annotations(unit_s, min_s, max_s, hash_id_s);
            }
            if (!tmp_ann_custom_s.empty())
            {
                ann_custom_FixMix = tmp_ann_custom_s;
            }
            CompleteMemberDetail detail_s = TypeObjectUtils::build_complete_member_detail(name_s, member_ann_builtin_s, ann_custom_FixMix);
            CompleteStructMember member_s = TypeObjectUtils::build_complete_struct_member(common_s, detail_s);
            TypeObjectUtils::add_complete_struct_member(member_seq_FixMix, member_s);
        }
        {
            TypeIdentifierPair type_ids_l;
            ReturnCode_t return_code_l {eprosima::fastdds::dds::RETCODE_OK};
            return_code_l =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_l);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_l)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "l Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_l = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_l = 0x0364520f;
            bool common_l_ec {false};
            CommonStructMember common_l {TypeObjectUtils::build_common_struct_member(member_id_l, member_flags_l, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_l, common_l_ec))};
            if (!common_l_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure l member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_l = "l";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_l;
            ann_custom_FixMix.reset();
            AppliedAnnotationSeq tmp_ann_custom_l;
            eprosima::fastcdr::optional<std::string> unit_l;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_l;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_l;
            eprosima::fastcdr::optional<std::string> hash_id_l;
            hash_id_l = "long";

            if (unit_l.has_value() || min_l.has_value() || max_l.has_value() || hash_id_l.has_value())
            {
                member_ann_builtin_l = TypeObjectUtils::build_applied_builtin_member_annotations(unit_l, min_l, max_l, hash_id_l);
            }
            if (!tmp_ann_custom_l.empty())
            {
                ann_custom_FixMix = tmp_ann_custom_l;
            }
            CompleteMemberDetail detail_l = TypeObjectUtils::build_complete_member_detail(name_l, member_ann_builtin_l, ann_custom_FixMix);
            CompleteStructMember member_l = TypeObjectUtils::build_complete_struct_member(common_l, detail_l);
            TypeObjectUtils::add_complete_struct_member(member_seq_FixMix, member_l);
        }
        {
            TypeIdentifierPair type_ids_ll;
            ReturnCode_t return_code_ll {eprosima::fastdds::dds::RETCODE_OK};
            return_code_ll =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_ll);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_ll)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "ll Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_ll = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_ll = 0x03645210;
            bool common_ll_ec {false};
            CommonStructMember common_ll {TypeObjectUtils::build_common_struct_member(member_id_ll, member_flags_ll, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_ll, common_ll_ec))};
            if (!common_ll_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure ll member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_ll = "ll";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_ll;
            ann_custom_FixMix.reset();
            CompleteMemberDetail detail_ll = TypeObjectUtils::build_complete_member_detail(name_ll, member_ann_builtin_ll, ann_custom_FixMix);
            CompleteStructMember member_ll = TypeObjectUtils::build_complete_struct_member(common_ll, detail_ll);
            TypeObjectUtils::add_complete_struct_member(member_seq_FixMix, member_ll);
        }
        CompleteStructType struct_type_FixMix = TypeObjectUtils::build_complete_struct_type(struct_flags_FixMix, header_FixMix, member_seq_FixMix);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_FixMix, type_name_FixMix.to_string(), type_ids_FixMix))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "FixMix already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AutoidDefault_type_identifier(
        TypeIdentifierPair& type_ids_AutoidDefault)
{

    ReturnCode_t return_code_AutoidDefault {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AutoidDefault =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AutoidDefault", type_ids_AutoidDefault);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AutoidDefault)
    {
        StructTypeFlag struct_flags_AutoidDefault = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, true);
        QualifiedTypeName type_name_AutoidDefault = "AutoidDefault";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AutoidDefault;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AutoidDefault;
        AppliedAnnotationSeq tmp_ann_custom_AutoidDefault;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_AutoidDefault;
        if (!tmp_ann_custom_AutoidDefault.empty())
        {
            ann_custom_AutoidDefault = tmp_ann_custom_AutoidDefault;
        }

        CompleteTypeDetail detail_AutoidDefault = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AutoidDefault, ann_custom_AutoidDefault, type_name_AutoidDefault.to_string());
        CompleteStructHeader header_AutoidDefault;
        header_AutoidDefault = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AutoidDefault);
        CompleteStructMemberSeq member_seq_AutoidDefault;
        {
            TypeIdentifierPair type_ids_c;
            ReturnCode_t return_code_c {eprosima::fastdds::dds::RETCODE_OK};
            return_code_c =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_char", type_ids_c);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_c)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "c Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_c = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_c = 0x00088a4a;
            bool common_c_ec {false};
            CommonStructMember common_c {TypeObjectUtils::build_common_struct_member(member_id_c, member_flags_c, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_c, common_c_ec))};
            if (!common_c_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure c member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_c = "c";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_c;
            ann_custom_AutoidDefault.reset();
            CompleteMemberDetail detail_c = TypeObjectUtils::build_complete_member_detail(name_c, member_ann_builtin_c, ann_custom_AutoidDefault);
            CompleteStructMember member_c = TypeObjectUtils::build_complete_struct_member(common_c, detail_c);
            TypeObjectUtils::add_complete_struct_member(member_seq_AutoidDefault, member_c);
        }
        {
            TypeIdentifierPair type_ids_o;
            ReturnCode_t return_code_o {eprosima::fastdds::dds::RETCODE_OK};
            return_code_o =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_o);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_o)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "o Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_o = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_o = 0x00000064;
            bool common_o_ec {false};
            CommonStructMember common_o {TypeObjectUtils::build_common_struct_member(member_id_o, member_flags_o, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_o, common_o_ec))};
            if (!common_o_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure o member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_o = "o";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_o;
            ann_custom_AutoidDefault.reset();
            AppliedAnnotationSeq tmp_ann_custom_o;
            eprosima::fastcdr::optional<std::string> unit_o;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_o;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_o;
            eprosima::fastcdr::optional<std::string> hash_id_o;
            if (unit_o.has_value() || min_o.has_value() || max_o.has_value() || hash_id_o.has_value())
            {
                member_ann_builtin_o = TypeObjectUtils::build_applied_builtin_member_annotations(unit_o, min_o, max_o, hash_id_o);
            }
            if (!tmp_ann_custom_o.empty())
            {
                ann_custom_AutoidDefault = tmp_ann_custom_o;
            }
            CompleteMemberDetail detail_o = TypeObjectUtils::build_complete_member_detail(name_o, member_ann_builtin_o, ann_custom_AutoidDefault);
            CompleteStructMember member_o = TypeObjectUtils::build_complete_struct_member(common_o, detail_o);
            TypeObjectUtils::add_complete_struct_member(member_seq_AutoidDefault, member_o);
        }
        {
            TypeIdentifierPair type_ids_s;
            ReturnCode_t return_code_s {eprosima::fastdds::dds::RETCODE_OK};
            return_code_s =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_s);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_s)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "s Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_s = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_s = 0x0cc0c703;
            bool common_s_ec {false};
            CommonStructMember common_s {TypeObjectUtils::build_common_struct_member(member_id_s, member_flags_s, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_s, common_s_ec))};
            if (!common_s_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure s member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_s = "s";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_s;
            ann_custom_AutoidDefault.reset();
            AppliedAnnotationSeq tmp_ann_custom_s;
            eprosima::fastcdr::optional<std::string> unit_s;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_s;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_s;
            eprosima::fastcdr::optional<std::string> hash_id_s;
            hash_id_s = "";

            if (unit_s.has_value() || min_s.has_value() || max_s.has_value() || hash_id_s.has_value())
            {
                member_ann_builtin_s = TypeObjectUtils::build_applied_builtin_member_annotations(unit_s, min_s, max_s, hash_id_s);
            }
            if (!tmp_ann_custom_s.empty())
            {
                ann_custom_AutoidDefault = tmp_ann_custom_s;
            }
            CompleteMemberDetail detail_s = TypeObjectUtils::build_complete_member_detail(name_s, member_ann_builtin_s, ann_custom_AutoidDefault);
            CompleteStructMember member_s = TypeObjectUtils::build_complete_struct_member(common_s, detail_s);
            TypeObjectUtils::add_complete_struct_member(member_seq_AutoidDefault, member_s);
        }
        {
            TypeIdentifierPair type_ids_l;
            ReturnCode_t return_code_l {eprosima::fastdds::dds::RETCODE_OK};
            return_code_l =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_l);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_l)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "l Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_l = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_l = 0x0364520f;
            bool common_l_ec {false};
            CommonStructMember common_l {TypeObjectUtils::build_common_struct_member(member_id_l, member_flags_l, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_l, common_l_ec))};
            if (!common_l_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure l member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_l = "l";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_l;
            ann_custom_AutoidDefault.reset();
            AppliedAnnotationSeq tmp_ann_custom_l;
            eprosima::fastcdr::optional<std::string> unit_l;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_l;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_l;
            eprosima::fastcdr::optional<std::string> hash_id_l;
            hash_id_l = "long";

            if (unit_l.has_value() || min_l.has_value() || max_l.has_value() || hash_id_l.has_value())
            {
                member_ann_builtin_l = TypeObjectUtils::build_applied_builtin_member_annotations(unit_l, min_l, max_l, hash_id_l);
            }
            if (!tmp_ann_custom_l.empty())
            {
                ann_custom_AutoidDefault = tmp_ann_custom_l;
            }
            CompleteMemberDetail detail_l = TypeObjectUtils::build_complete_member_detail(name_l, member_ann_builtin_l, ann_custom_AutoidDefault);
            CompleteStructMember member_l = TypeObjectUtils::build_complete_struct_member(common_l, detail_l);
            TypeObjectUtils::add_complete_struct_member(member_seq_AutoidDefault, member_l);
        }
        {
            TypeIdentifierPair type_ids_ll;
            ReturnCode_t return_code_ll {eprosima::fastdds::dds::RETCODE_OK};
            return_code_ll =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_ll);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_ll)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "ll Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_ll = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_ll = 0x00c0545b;
            bool common_ll_ec {false};
            CommonStructMember common_ll {TypeObjectUtils::build_common_struct_member(member_id_ll, member_flags_ll, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_ll, common_ll_ec))};
            if (!common_ll_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure ll member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_ll = "ll";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_ll;
            ann_custom_AutoidDefault.reset();
            CompleteMemberDetail detail_ll = TypeObjectUtils::build_complete_member_detail(name_ll, member_ann_builtin_ll, ann_custom_AutoidDefault);
            CompleteStructMember member_ll = TypeObjectUtils::build_complete_struct_member(common_ll, detail_ll);
            TypeObjectUtils::add_complete_struct_member(member_seq_AutoidDefault, member_ll);
        }
        CompleteStructType struct_type_AutoidDefault = TypeObjectUtils::build_complete_struct_type(struct_flags_AutoidDefault, header_AutoidDefault, member_seq_AutoidDefault);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AutoidDefault, type_name_AutoidDefault.to_string(), type_ids_AutoidDefault))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AutoidDefault already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AutoidSequential_type_identifier(
        TypeIdentifierPair& type_ids_AutoidSequential)
{

    ReturnCode_t return_code_AutoidSequential {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AutoidSequential =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AutoidSequential", type_ids_AutoidSequential);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AutoidSequential)
    {
        StructTypeFlag struct_flags_AutoidSequential = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, false);
        QualifiedTypeName type_name_AutoidSequential = "AutoidSequential";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AutoidSequential;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AutoidSequential;
        AppliedAnnotationSeq tmp_ann_custom_AutoidSequential;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_AutoidSequential;
        if (!tmp_ann_custom_AutoidSequential.empty())
        {
            ann_custom_AutoidSequential = tmp_ann_custom_AutoidSequential;
        }

        CompleteTypeDetail detail_AutoidSequential = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AutoidSequential, ann_custom_AutoidSequential, type_name_AutoidSequential.to_string());
        CompleteStructHeader header_AutoidSequential;
        header_AutoidSequential = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AutoidSequential);
        CompleteStructMemberSeq member_seq_AutoidSequential;
        {
            TypeIdentifierPair type_ids_c;
            ReturnCode_t return_code_c {eprosima::fastdds::dds::RETCODE_OK};
            return_code_c =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_char", type_ids_c);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_c)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "c Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_c = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_c = 0x00000000;
            bool common_c_ec {false};
            CommonStructMember common_c {TypeObjectUtils::build_common_struct_member(member_id_c, member_flags_c, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_c, common_c_ec))};
            if (!common_c_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure c member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_c = "c";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_c;
            ann_custom_AutoidSequential.reset();
            CompleteMemberDetail detail_c = TypeObjectUtils::build_complete_member_detail(name_c, member_ann_builtin_c, ann_custom_AutoidSequential);
            CompleteStructMember member_c = TypeObjectUtils::build_complete_struct_member(common_c, detail_c);
            TypeObjectUtils::add_complete_struct_member(member_seq_AutoidSequential, member_c);
        }
        {
            TypeIdentifierPair type_ids_o;
            ReturnCode_t return_code_o {eprosima::fastdds::dds::RETCODE_OK};
            return_code_o =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_o);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_o)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "o Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_o = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_o = 0x00000064;
            bool common_o_ec {false};
            CommonStructMember common_o {TypeObjectUtils::build_common_struct_member(member_id_o, member_flags_o, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_o, common_o_ec))};
            if (!common_o_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure o member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_o = "o";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_o;
            ann_custom_AutoidSequential.reset();
            AppliedAnnotationSeq tmp_ann_custom_o;
            eprosima::fastcdr::optional<std::string> unit_o;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_o;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_o;
            eprosima::fastcdr::optional<std::string> hash_id_o;
            if (unit_o.has_value() || min_o.has_value() || max_o.has_value() || hash_id_o.has_value())
            {
                member_ann_builtin_o = TypeObjectUtils::build_applied_builtin_member_annotations(unit_o, min_o, max_o, hash_id_o);
            }
            if (!tmp_ann_custom_o.empty())
            {
                ann_custom_AutoidSequential = tmp_ann_custom_o;
            }
            CompleteMemberDetail detail_o = TypeObjectUtils::build_complete_member_detail(name_o, member_ann_builtin_o, ann_custom_AutoidSequential);
            CompleteStructMember member_o = TypeObjectUtils::build_complete_struct_member(common_o, detail_o);
            TypeObjectUtils::add_complete_struct_member(member_seq_AutoidSequential, member_o);
        }
        {
            TypeIdentifierPair type_ids_s;
            ReturnCode_t return_code_s {eprosima::fastdds::dds::RETCODE_OK};
            return_code_s =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_s);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_s)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "s Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_s = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_s = 0x0cc0c703;
            bool common_s_ec {false};
            CommonStructMember common_s {TypeObjectUtils::build_common_struct_member(member_id_s, member_flags_s, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_s, common_s_ec))};
            if (!common_s_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure s member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_s = "s";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_s;
            ann_custom_AutoidSequential.reset();
            AppliedAnnotationSeq tmp_ann_custom_s;
            eprosima::fastcdr::optional<std::string> unit_s;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_s;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_s;
            eprosima::fastcdr::optional<std::string> hash_id_s;
            hash_id_s = "";

            if (unit_s.has_value() || min_s.has_value() || max_s.has_value() || hash_id_s.has_value())
            {
                member_ann_builtin_s = TypeObjectUtils::build_applied_builtin_member_annotations(unit_s, min_s, max_s, hash_id_s);
            }
            if (!tmp_ann_custom_s.empty())
            {
                ann_custom_AutoidSequential = tmp_ann_custom_s;
            }
            CompleteMemberDetail detail_s = TypeObjectUtils::build_complete_member_detail(name_s, member_ann_builtin_s, ann_custom_AutoidSequential);
            CompleteStructMember member_s = TypeObjectUtils::build_complete_struct_member(common_s, detail_s);
            TypeObjectUtils::add_complete_struct_member(member_seq_AutoidSequential, member_s);
        }
        {
            TypeIdentifierPair type_ids_l;
            ReturnCode_t return_code_l {eprosima::fastdds::dds::RETCODE_OK};
            return_code_l =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_l);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_l)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "l Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_l = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_l = 0x0364520f;
            bool common_l_ec {false};
            CommonStructMember common_l {TypeObjectUtils::build_common_struct_member(member_id_l, member_flags_l, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_l, common_l_ec))};
            if (!common_l_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure l member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_l = "l";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_l;
            ann_custom_AutoidSequential.reset();
            AppliedAnnotationSeq tmp_ann_custom_l;
            eprosima::fastcdr::optional<std::string> unit_l;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_l;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_l;
            eprosima::fastcdr::optional<std::string> hash_id_l;
            hash_id_l = "long";

            if (unit_l.has_value() || min_l.has_value() || max_l.has_value() || hash_id_l.has_value())
            {
                member_ann_builtin_l = TypeObjectUtils::build_applied_builtin_member_annotations(unit_l, min_l, max_l, hash_id_l);
            }
            if (!tmp_ann_custom_l.empty())
            {
                ann_custom_AutoidSequential = tmp_ann_custom_l;
            }
            CompleteMemberDetail detail_l = TypeObjectUtils::build_complete_member_detail(name_l, member_ann_builtin_l, ann_custom_AutoidSequential);
            CompleteStructMember member_l = TypeObjectUtils::build_complete_struct_member(common_l, detail_l);
            TypeObjectUtils::add_complete_struct_member(member_seq_AutoidSequential, member_l);
        }
        {
            TypeIdentifierPair type_ids_ll;
            ReturnCode_t return_code_ll {eprosima::fastdds::dds::RETCODE_OK};
            return_code_ll =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_ll);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_ll)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "ll Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_ll = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_ll = 0x03645210;
            bool common_ll_ec {false};
            CommonStructMember common_ll {TypeObjectUtils::build_common_struct_member(member_id_ll, member_flags_ll, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_ll, common_ll_ec))};
            if (!common_ll_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure ll member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_ll = "ll";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_ll;
            ann_custom_AutoidSequential.reset();
            CompleteMemberDetail detail_ll = TypeObjectUtils::build_complete_member_detail(name_ll, member_ann_builtin_ll, ann_custom_AutoidSequential);
            CompleteStructMember member_ll = TypeObjectUtils::build_complete_struct_member(common_ll, detail_ll);
            TypeObjectUtils::add_complete_struct_member(member_seq_AutoidSequential, member_ll);
        }
        CompleteStructType struct_type_AutoidSequential = TypeObjectUtils::build_complete_struct_type(struct_flags_AutoidSequential, header_AutoidSequential, member_seq_AutoidSequential);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AutoidSequential, type_name_AutoidSequential.to_string(), type_ids_AutoidSequential))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AutoidSequential already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AutoidHash_type_identifier(
        TypeIdentifierPair& type_ids_AutoidHash)
{

    ReturnCode_t return_code_AutoidHash {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AutoidHash =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AutoidHash", type_ids_AutoidHash);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AutoidHash)
    {
        StructTypeFlag struct_flags_AutoidHash = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, true);
        QualifiedTypeName type_name_AutoidHash = "AutoidHash";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AutoidHash;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AutoidHash;
        AppliedAnnotationSeq tmp_ann_custom_AutoidHash;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_AutoidHash;
        if (!tmp_ann_custom_AutoidHash.empty())
        {
            ann_custom_AutoidHash = tmp_ann_custom_AutoidHash;
        }

        CompleteTypeDetail detail_AutoidHash = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AutoidHash, ann_custom_AutoidHash, type_name_AutoidHash.to_string());
        CompleteStructHeader header_AutoidHash;
        header_AutoidHash = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AutoidHash);
        CompleteStructMemberSeq member_seq_AutoidHash;
        {
            TypeIdentifierPair type_ids_c;
            ReturnCode_t return_code_c {eprosima::fastdds::dds::RETCODE_OK};
            return_code_c =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_char", type_ids_c);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_c)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "c Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_c = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_c = 0x00088a4a;
            bool common_c_ec {false};
            CommonStructMember common_c {TypeObjectUtils::build_common_struct_member(member_id_c, member_flags_c, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_c, common_c_ec))};
            if (!common_c_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure c member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_c = "c";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_c;
            ann_custom_AutoidHash.reset();
            CompleteMemberDetail detail_c = TypeObjectUtils::build_complete_member_detail(name_c, member_ann_builtin_c, ann_custom_AutoidHash);
            CompleteStructMember member_c = TypeObjectUtils::build_complete_struct_member(common_c, detail_c);
            TypeObjectUtils::add_complete_struct_member(member_seq_AutoidHash, member_c);
        }
        {
            TypeIdentifierPair type_ids_o;
            ReturnCode_t return_code_o {eprosima::fastdds::dds::RETCODE_OK};
            return_code_o =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_o);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_o)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "o Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_o = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_o = 0x00000064;
            bool common_o_ec {false};
            CommonStructMember common_o {TypeObjectUtils::build_common_struct_member(member_id_o, member_flags_o, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_o, common_o_ec))};
            if (!common_o_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure o member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_o = "o";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_o;
            ann_custom_AutoidHash.reset();
            AppliedAnnotationSeq tmp_ann_custom_o;
            eprosima::fastcdr::optional<std::string> unit_o;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_o;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_o;
            eprosima::fastcdr::optional<std::string> hash_id_o;
            if (unit_o.has_value() || min_o.has_value() || max_o.has_value() || hash_id_o.has_value())
            {
                member_ann_builtin_o = TypeObjectUtils::build_applied_builtin_member_annotations(unit_o, min_o, max_o, hash_id_o);
            }
            if (!tmp_ann_custom_o.empty())
            {
                ann_custom_AutoidHash = tmp_ann_custom_o;
            }
            CompleteMemberDetail detail_o = TypeObjectUtils::build_complete_member_detail(name_o, member_ann_builtin_o, ann_custom_AutoidHash);
            CompleteStructMember member_o = TypeObjectUtils::build_complete_struct_member(common_o, detail_o);
            TypeObjectUtils::add_complete_struct_member(member_seq_AutoidHash, member_o);
        }
        {
            TypeIdentifierPair type_ids_s;
            ReturnCode_t return_code_s {eprosima::fastdds::dds::RETCODE_OK};
            return_code_s =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_s);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_s)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "s Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_s = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_s = 0x0cc0c703;
            bool common_s_ec {false};
            CommonStructMember common_s {TypeObjectUtils::build_common_struct_member(member_id_s, member_flags_s, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_s, common_s_ec))};
            if (!common_s_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure s member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_s = "s";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_s;
            ann_custom_AutoidHash.reset();
            AppliedAnnotationSeq tmp_ann_custom_s;
            eprosima::fastcdr::optional<std::string> unit_s;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_s;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_s;
            eprosima::fastcdr::optional<std::string> hash_id_s;
            hash_id_s = "";

            if (unit_s.has_value() || min_s.has_value() || max_s.has_value() || hash_id_s.has_value())
            {
                member_ann_builtin_s = TypeObjectUtils::build_applied_builtin_member_annotations(unit_s, min_s, max_s, hash_id_s);
            }
            if (!tmp_ann_custom_s.empty())
            {
                ann_custom_AutoidHash = tmp_ann_custom_s;
            }
            CompleteMemberDetail detail_s = TypeObjectUtils::build_complete_member_detail(name_s, member_ann_builtin_s, ann_custom_AutoidHash);
            CompleteStructMember member_s = TypeObjectUtils::build_complete_struct_member(common_s, detail_s);
            TypeObjectUtils::add_complete_struct_member(member_seq_AutoidHash, member_s);
        }
        {
            TypeIdentifierPair type_ids_l;
            ReturnCode_t return_code_l {eprosima::fastdds::dds::RETCODE_OK};
            return_code_l =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_l);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_l)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "l Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_l = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_l = 0x0364520f;
            bool common_l_ec {false};
            CommonStructMember common_l {TypeObjectUtils::build_common_struct_member(member_id_l, member_flags_l, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_l, common_l_ec))};
            if (!common_l_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure l member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_l = "l";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_l;
            ann_custom_AutoidHash.reset();
            AppliedAnnotationSeq tmp_ann_custom_l;
            eprosima::fastcdr::optional<std::string> unit_l;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_l;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_l;
            eprosima::fastcdr::optional<std::string> hash_id_l;
            hash_id_l = "long";

            if (unit_l.has_value() || min_l.has_value() || max_l.has_value() || hash_id_l.has_value())
            {
                member_ann_builtin_l = TypeObjectUtils::build_applied_builtin_member_annotations(unit_l, min_l, max_l, hash_id_l);
            }
            if (!tmp_ann_custom_l.empty())
            {
                ann_custom_AutoidHash = tmp_ann_custom_l;
            }
            CompleteMemberDetail detail_l = TypeObjectUtils::build_complete_member_detail(name_l, member_ann_builtin_l, ann_custom_AutoidHash);
            CompleteStructMember member_l = TypeObjectUtils::build_complete_struct_member(common_l, detail_l);
            TypeObjectUtils::add_complete_struct_member(member_seq_AutoidHash, member_l);
        }
        {
            TypeIdentifierPair type_ids_ll;
            ReturnCode_t return_code_ll {eprosima::fastdds::dds::RETCODE_OK};
            return_code_ll =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_ll);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_ll)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "ll Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_ll = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_ll = 0x00c0545b;
            bool common_ll_ec {false};
            CommonStructMember common_ll {TypeObjectUtils::build_common_struct_member(member_id_ll, member_flags_ll, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_ll, common_ll_ec))};
            if (!common_ll_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure ll member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_ll = "ll";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_ll;
            ann_custom_AutoidHash.reset();
            CompleteMemberDetail detail_ll = TypeObjectUtils::build_complete_member_detail(name_ll, member_ann_builtin_ll, ann_custom_AutoidHash);
            CompleteStructMember member_ll = TypeObjectUtils::build_complete_struct_member(common_ll, detail_ll);
            TypeObjectUtils::add_complete_struct_member(member_seq_AutoidHash, member_ll);
        }
        CompleteStructType struct_type_AutoidHash = TypeObjectUtils::build_complete_struct_type(struct_flags_AutoidHash, header_AutoidHash, member_seq_AutoidHash);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AutoidHash, type_name_AutoidHash.to_string(), type_ids_AutoidHash))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AutoidHash already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_DerivedAutoidDefault_type_identifier(
        TypeIdentifierPair& type_ids_DerivedAutoidDefault)
{

    ReturnCode_t return_code_DerivedAutoidDefault {eprosima::fastdds::dds::RETCODE_OK};
    return_code_DerivedAutoidDefault =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "DerivedAutoidDefault", type_ids_DerivedAutoidDefault);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_DerivedAutoidDefault)
    {
        StructTypeFlag struct_flags_DerivedAutoidDefault = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, true);
        return_code_DerivedAutoidDefault =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "AutoidDefault", type_ids_DerivedAutoidDefault);

        if (return_code_DerivedAutoidDefault != eprosima::fastdds::dds::RETCODE_OK)
        {
::register_AutoidDefault_type_identifier(type_ids_DerivedAutoidDefault);
        }
        QualifiedTypeName type_name_DerivedAutoidDefault = "DerivedAutoidDefault";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_DerivedAutoidDefault;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_DerivedAutoidDefault;
        AppliedAnnotationSeq tmp_ann_custom_DerivedAutoidDefault;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_DerivedAutoidDefault;
        if (!tmp_ann_custom_DerivedAutoidDefault.empty())
        {
            ann_custom_DerivedAutoidDefault = tmp_ann_custom_DerivedAutoidDefault;
        }

        CompleteTypeDetail detail_DerivedAutoidDefault = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_DerivedAutoidDefault, ann_custom_DerivedAutoidDefault, type_name_DerivedAutoidDefault.to_string());
        CompleteStructHeader header_DerivedAutoidDefault;
        if (EK_COMPLETE == type_ids_DerivedAutoidDefault.type_identifier1()._d())
        {
            header_DerivedAutoidDefault = TypeObjectUtils::build_complete_struct_header(type_ids_DerivedAutoidDefault.type_identifier1(), detail_DerivedAutoidDefault);
        }
        else if (EK_COMPLETE == type_ids_DerivedAutoidDefault.type_identifier2()._d())
        {
            header_DerivedAutoidDefault = TypeObjectUtils::build_complete_struct_header(type_ids_DerivedAutoidDefault.type_identifier2(), detail_DerivedAutoidDefault);
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "DerivedAutoidDefault Structure: base_type TypeIdentifier registered in TypeObjectRegistry is inconsistent.");
            return;
        }
        CompleteStructMemberSeq member_seq_DerivedAutoidDefault;
        {
            TypeIdentifierPair type_ids_cd;
            ReturnCode_t return_code_cd {eprosima::fastdds::dds::RETCODE_OK};
            return_code_cd =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_char", type_ids_cd);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_cd)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "cd Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_cd = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_cd = 0x03ae6568;
            bool common_cd_ec {false};
            CommonStructMember common_cd {TypeObjectUtils::build_common_struct_member(member_id_cd, member_flags_cd, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_cd, common_cd_ec))};
            if (!common_cd_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure cd member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_cd = "cd";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_cd;
            ann_custom_DerivedAutoidDefault.reset();
            CompleteMemberDetail detail_cd = TypeObjectUtils::build_complete_member_detail(name_cd, member_ann_builtin_cd, ann_custom_DerivedAutoidDefault);
            CompleteStructMember member_cd = TypeObjectUtils::build_complete_struct_member(common_cd, detail_cd);
            TypeObjectUtils::add_complete_struct_member(member_seq_DerivedAutoidDefault, member_cd);
        }
        {
            TypeIdentifierPair type_ids_od;
            ReturnCode_t return_code_od {eprosima::fastdds::dds::RETCODE_OK};
            return_code_od =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_od);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_od)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "od Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_od = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_od = 0x00000065;
            bool common_od_ec {false};
            CommonStructMember common_od {TypeObjectUtils::build_common_struct_member(member_id_od, member_flags_od, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_od, common_od_ec))};
            if (!common_od_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure od member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_od = "od";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_od;
            ann_custom_DerivedAutoidDefault.reset();
            AppliedAnnotationSeq tmp_ann_custom_od;
            eprosima::fastcdr::optional<std::string> unit_od;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_od;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_od;
            eprosima::fastcdr::optional<std::string> hash_id_od;
            if (unit_od.has_value() || min_od.has_value() || max_od.has_value() || hash_id_od.has_value())
            {
                member_ann_builtin_od = TypeObjectUtils::build_applied_builtin_member_annotations(unit_od, min_od, max_od, hash_id_od);
            }
            if (!tmp_ann_custom_od.empty())
            {
                ann_custom_DerivedAutoidDefault = tmp_ann_custom_od;
            }
            CompleteMemberDetail detail_od = TypeObjectUtils::build_complete_member_detail(name_od, member_ann_builtin_od, ann_custom_DerivedAutoidDefault);
            CompleteStructMember member_od = TypeObjectUtils::build_complete_struct_member(common_od, detail_od);
            TypeObjectUtils::add_complete_struct_member(member_seq_DerivedAutoidDefault, member_od);
        }
        {
            TypeIdentifierPair type_ids_sd;
            ReturnCode_t return_code_sd {eprosima::fastdds::dds::RETCODE_OK};
            return_code_sd =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_sd);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_sd)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "sd Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_sd = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_sd = 0x0bf72662;
            bool common_sd_ec {false};
            CommonStructMember common_sd {TypeObjectUtils::build_common_struct_member(member_id_sd, member_flags_sd, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_sd, common_sd_ec))};
            if (!common_sd_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure sd member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_sd = "sd";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_sd;
            ann_custom_DerivedAutoidDefault.reset();
            AppliedAnnotationSeq tmp_ann_custom_sd;
            eprosima::fastcdr::optional<std::string> unit_sd;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_sd;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_sd;
            eprosima::fastcdr::optional<std::string> hash_id_sd;
            hash_id_sd = "";

            if (unit_sd.has_value() || min_sd.has_value() || max_sd.has_value() || hash_id_sd.has_value())
            {
                member_ann_builtin_sd = TypeObjectUtils::build_applied_builtin_member_annotations(unit_sd, min_sd, max_sd, hash_id_sd);
            }
            if (!tmp_ann_custom_sd.empty())
            {
                ann_custom_DerivedAutoidDefault = tmp_ann_custom_sd;
            }
            CompleteMemberDetail detail_sd = TypeObjectUtils::build_complete_member_detail(name_sd, member_ann_builtin_sd, ann_custom_DerivedAutoidDefault);
            CompleteStructMember member_sd = TypeObjectUtils::build_complete_struct_member(common_sd, detail_sd);
            TypeObjectUtils::add_complete_struct_member(member_seq_DerivedAutoidDefault, member_sd);
        }
        {
            TypeIdentifierPair type_ids_ld;
            ReturnCode_t return_code_ld {eprosima::fastdds::dds::RETCODE_OK};
            return_code_ld =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_ld);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_ld)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "ld Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_ld = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_ld = 0x07f89ae6;
            bool common_ld_ec {false};
            CommonStructMember common_ld {TypeObjectUtils::build_common_struct_member(member_id_ld, member_flags_ld, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_ld, common_ld_ec))};
            if (!common_ld_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure ld member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_ld = "ld";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_ld;
            ann_custom_DerivedAutoidDefault.reset();
            AppliedAnnotationSeq tmp_ann_custom_ld;
            eprosima::fastcdr::optional<std::string> unit_ld;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_ld;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_ld;
            eprosima::fastcdr::optional<std::string> hash_id_ld;
            hash_id_ld = "long2";

            if (unit_ld.has_value() || min_ld.has_value() || max_ld.has_value() || hash_id_ld.has_value())
            {
                member_ann_builtin_ld = TypeObjectUtils::build_applied_builtin_member_annotations(unit_ld, min_ld, max_ld, hash_id_ld);
            }
            if (!tmp_ann_custom_ld.empty())
            {
                ann_custom_DerivedAutoidDefault = tmp_ann_custom_ld;
            }
            CompleteMemberDetail detail_ld = TypeObjectUtils::build_complete_member_detail(name_ld, member_ann_builtin_ld, ann_custom_DerivedAutoidDefault);
            CompleteStructMember member_ld = TypeObjectUtils::build_complete_struct_member(common_ld, detail_ld);
            TypeObjectUtils::add_complete_struct_member(member_seq_DerivedAutoidDefault, member_ld);
        }
        {
            TypeIdentifierPair type_ids_lld;
            ReturnCode_t return_code_lld {eprosima::fastdds::dds::RETCODE_OK};
            return_code_lld =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_lld);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_lld)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "lld Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_lld = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_lld = 0x00e90b05;
            bool common_lld_ec {false};
            CommonStructMember common_lld {TypeObjectUtils::build_common_struct_member(member_id_lld, member_flags_lld, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_lld, common_lld_ec))};
            if (!common_lld_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure lld member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_lld = "lld";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_lld;
            ann_custom_DerivedAutoidDefault.reset();
            CompleteMemberDetail detail_lld = TypeObjectUtils::build_complete_member_detail(name_lld, member_ann_builtin_lld, ann_custom_DerivedAutoidDefault);
            CompleteStructMember member_lld = TypeObjectUtils::build_complete_struct_member(common_lld, detail_lld);
            TypeObjectUtils::add_complete_struct_member(member_seq_DerivedAutoidDefault, member_lld);
        }
        CompleteStructType struct_type_DerivedAutoidDefault = TypeObjectUtils::build_complete_struct_type(struct_flags_DerivedAutoidDefault, header_DerivedAutoidDefault, member_seq_DerivedAutoidDefault);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_DerivedAutoidDefault, type_name_DerivedAutoidDefault.to_string(), type_ids_DerivedAutoidDefault))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "DerivedAutoidDefault already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_DerivedEmptyAutoidSequential_type_identifier(
        TypeIdentifierPair& type_ids_DerivedEmptyAutoidSequential)
{

    ReturnCode_t return_code_DerivedEmptyAutoidSequential {eprosima::fastdds::dds::RETCODE_OK};
    return_code_DerivedEmptyAutoidSequential =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "DerivedEmptyAutoidSequential", type_ids_DerivedEmptyAutoidSequential);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_DerivedEmptyAutoidSequential)
    {
        StructTypeFlag struct_flags_DerivedEmptyAutoidSequential = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, false);
        return_code_DerivedEmptyAutoidSequential =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "AutoidSequential", type_ids_DerivedEmptyAutoidSequential);

        if (return_code_DerivedEmptyAutoidSequential != eprosima::fastdds::dds::RETCODE_OK)
        {
::register_AutoidSequential_type_identifier(type_ids_DerivedEmptyAutoidSequential);
        }
        QualifiedTypeName type_name_DerivedEmptyAutoidSequential = "DerivedEmptyAutoidSequential";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_DerivedEmptyAutoidSequential;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_DerivedEmptyAutoidSequential;
        AppliedAnnotationSeq tmp_ann_custom_DerivedEmptyAutoidSequential;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_DerivedEmptyAutoidSequential;
        if (!tmp_ann_custom_DerivedEmptyAutoidSequential.empty())
        {
            ann_custom_DerivedEmptyAutoidSequential = tmp_ann_custom_DerivedEmptyAutoidSequential;
        }

        CompleteTypeDetail detail_DerivedEmptyAutoidSequential = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_DerivedEmptyAutoidSequential, ann_custom_DerivedEmptyAutoidSequential, type_name_DerivedEmptyAutoidSequential.to_string());
        CompleteStructHeader header_DerivedEmptyAutoidSequential;
        if (EK_COMPLETE == type_ids_DerivedEmptyAutoidSequential.type_identifier1()._d())
        {
            header_DerivedEmptyAutoidSequential = TypeObjectUtils::build_complete_struct_header(type_ids_DerivedEmptyAutoidSequential.type_identifier1(), detail_DerivedEmptyAutoidSequential);
        }
        else if (EK_COMPLETE == type_ids_DerivedEmptyAutoidSequential.type_identifier2()._d())
        {
            header_DerivedEmptyAutoidSequential = TypeObjectUtils::build_complete_struct_header(type_ids_DerivedEmptyAutoidSequential.type_identifier2(), detail_DerivedEmptyAutoidSequential);
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "DerivedEmptyAutoidSequential Structure: base_type TypeIdentifier registered in TypeObjectRegistry is inconsistent.");
            return;
        }
        CompleteStructMemberSeq member_seq_DerivedEmptyAutoidSequential;
        CompleteStructType struct_type_DerivedEmptyAutoidSequential = TypeObjectUtils::build_complete_struct_type(struct_flags_DerivedEmptyAutoidSequential, header_DerivedEmptyAutoidSequential, member_seq_DerivedEmptyAutoidSequential);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_DerivedEmptyAutoidSequential, type_name_DerivedEmptyAutoidSequential.to_string(), type_ids_DerivedEmptyAutoidSequential))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "DerivedEmptyAutoidSequential already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_DerivedAutoidSequential_type_identifier(
        TypeIdentifierPair& type_ids_DerivedAutoidSequential)
{

    ReturnCode_t return_code_DerivedAutoidSequential {eprosima::fastdds::dds::RETCODE_OK};
    return_code_DerivedAutoidSequential =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "DerivedAutoidSequential", type_ids_DerivedAutoidSequential);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_DerivedAutoidSequential)
    {
        StructTypeFlag struct_flags_DerivedAutoidSequential = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, false);
        return_code_DerivedAutoidSequential =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "DerivedEmptyAutoidSequential", type_ids_DerivedAutoidSequential);

        if (return_code_DerivedAutoidSequential != eprosima::fastdds::dds::RETCODE_OK)
        {
::register_DerivedEmptyAutoidSequential_type_identifier(type_ids_DerivedAutoidSequential);
        }
        QualifiedTypeName type_name_DerivedAutoidSequential = "DerivedAutoidSequential";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_DerivedAutoidSequential;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_DerivedAutoidSequential;
        AppliedAnnotationSeq tmp_ann_custom_DerivedAutoidSequential;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_DerivedAutoidSequential;
        if (!tmp_ann_custom_DerivedAutoidSequential.empty())
        {
            ann_custom_DerivedAutoidSequential = tmp_ann_custom_DerivedAutoidSequential;
        }

        CompleteTypeDetail detail_DerivedAutoidSequential = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_DerivedAutoidSequential, ann_custom_DerivedAutoidSequential, type_name_DerivedAutoidSequential.to_string());
        CompleteStructHeader header_DerivedAutoidSequential;
        if (EK_COMPLETE == type_ids_DerivedAutoidSequential.type_identifier1()._d())
        {
            header_DerivedAutoidSequential = TypeObjectUtils::build_complete_struct_header(type_ids_DerivedAutoidSequential.type_identifier1(), detail_DerivedAutoidSequential);
        }
        else if (EK_COMPLETE == type_ids_DerivedAutoidSequential.type_identifier2()._d())
        {
            header_DerivedAutoidSequential = TypeObjectUtils::build_complete_struct_header(type_ids_DerivedAutoidSequential.type_identifier2(), detail_DerivedAutoidSequential);
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "DerivedAutoidSequential Structure: base_type TypeIdentifier registered in TypeObjectRegistry is inconsistent.");
            return;
        }
        CompleteStructMemberSeq member_seq_DerivedAutoidSequential;
        {
            TypeIdentifierPair type_ids_cd;
            ReturnCode_t return_code_cd {eprosima::fastdds::dds::RETCODE_OK};
            return_code_cd =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_char", type_ids_cd);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_cd)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "cd Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_cd = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_cd = 0x03645211;
            bool common_cd_ec {false};
            CommonStructMember common_cd {TypeObjectUtils::build_common_struct_member(member_id_cd, member_flags_cd, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_cd, common_cd_ec))};
            if (!common_cd_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure cd member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_cd = "cd";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_cd;
            ann_custom_DerivedAutoidSequential.reset();
            CompleteMemberDetail detail_cd = TypeObjectUtils::build_complete_member_detail(name_cd, member_ann_builtin_cd, ann_custom_DerivedAutoidSequential);
            CompleteStructMember member_cd = TypeObjectUtils::build_complete_struct_member(common_cd, detail_cd);
            TypeObjectUtils::add_complete_struct_member(member_seq_DerivedAutoidSequential, member_cd);
        }
        {
            TypeIdentifierPair type_ids_od;
            ReturnCode_t return_code_od {eprosima::fastdds::dds::RETCODE_OK};
            return_code_od =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_od);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_od)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "od Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_od = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_od = 0x00000065;
            bool common_od_ec {false};
            CommonStructMember common_od {TypeObjectUtils::build_common_struct_member(member_id_od, member_flags_od, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_od, common_od_ec))};
            if (!common_od_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure od member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_od = "od";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_od;
            ann_custom_DerivedAutoidSequential.reset();
            AppliedAnnotationSeq tmp_ann_custom_od;
            eprosima::fastcdr::optional<std::string> unit_od;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_od;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_od;
            eprosima::fastcdr::optional<std::string> hash_id_od;
            if (unit_od.has_value() || min_od.has_value() || max_od.has_value() || hash_id_od.has_value())
            {
                member_ann_builtin_od = TypeObjectUtils::build_applied_builtin_member_annotations(unit_od, min_od, max_od, hash_id_od);
            }
            if (!tmp_ann_custom_od.empty())
            {
                ann_custom_DerivedAutoidSequential = tmp_ann_custom_od;
            }
            CompleteMemberDetail detail_od = TypeObjectUtils::build_complete_member_detail(name_od, member_ann_builtin_od, ann_custom_DerivedAutoidSequential);
            CompleteStructMember member_od = TypeObjectUtils::build_complete_struct_member(common_od, detail_od);
            TypeObjectUtils::add_complete_struct_member(member_seq_DerivedAutoidSequential, member_od);
        }
        {
            TypeIdentifierPair type_ids_sd;
            ReturnCode_t return_code_sd {eprosima::fastdds::dds::RETCODE_OK};
            return_code_sd =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_sd);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_sd)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "sd Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_sd = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_sd = 0x0bf72662;
            bool common_sd_ec {false};
            CommonStructMember common_sd {TypeObjectUtils::build_common_struct_member(member_id_sd, member_flags_sd, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_sd, common_sd_ec))};
            if (!common_sd_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure sd member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_sd = "sd";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_sd;
            ann_custom_DerivedAutoidSequential.reset();
            AppliedAnnotationSeq tmp_ann_custom_sd;
            eprosima::fastcdr::optional<std::string> unit_sd;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_sd;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_sd;
            eprosima::fastcdr::optional<std::string> hash_id_sd;
            hash_id_sd = "";

            if (unit_sd.has_value() || min_sd.has_value() || max_sd.has_value() || hash_id_sd.has_value())
            {
                member_ann_builtin_sd = TypeObjectUtils::build_applied_builtin_member_annotations(unit_sd, min_sd, max_sd, hash_id_sd);
            }
            if (!tmp_ann_custom_sd.empty())
            {
                ann_custom_DerivedAutoidSequential = tmp_ann_custom_sd;
            }
            CompleteMemberDetail detail_sd = TypeObjectUtils::build_complete_member_detail(name_sd, member_ann_builtin_sd, ann_custom_DerivedAutoidSequential);
            CompleteStructMember member_sd = TypeObjectUtils::build_complete_struct_member(common_sd, detail_sd);
            TypeObjectUtils::add_complete_struct_member(member_seq_DerivedAutoidSequential, member_sd);
        }
        {
            TypeIdentifierPair type_ids_ld;
            ReturnCode_t return_code_ld {eprosima::fastdds::dds::RETCODE_OK};
            return_code_ld =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_ld);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_ld)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "ld Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_ld = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_ld = 0x07f89ae6;
            bool common_ld_ec {false};
            CommonStructMember common_ld {TypeObjectUtils::build_common_struct_member(member_id_ld, member_flags_ld, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_ld, common_ld_ec))};
            if (!common_ld_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure ld member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_ld = "ld";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_ld;
            ann_custom_DerivedAutoidSequential.reset();
            AppliedAnnotationSeq tmp_ann_custom_ld;
            eprosima::fastcdr::optional<std::string> unit_ld;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_ld;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_ld;
            eprosima::fastcdr::optional<std::string> hash_id_ld;
            hash_id_ld = "long2";

            if (unit_ld.has_value() || min_ld.has_value() || max_ld.has_value() || hash_id_ld.has_value())
            {
                member_ann_builtin_ld = TypeObjectUtils::build_applied_builtin_member_annotations(unit_ld, min_ld, max_ld, hash_id_ld);
            }
            if (!tmp_ann_custom_ld.empty())
            {
                ann_custom_DerivedAutoidSequential = tmp_ann_custom_ld;
            }
            CompleteMemberDetail detail_ld = TypeObjectUtils::build_complete_member_detail(name_ld, member_ann_builtin_ld, ann_custom_DerivedAutoidSequential);
            CompleteStructMember member_ld = TypeObjectUtils::build_complete_struct_member(common_ld, detail_ld);
            TypeObjectUtils::add_complete_struct_member(member_seq_DerivedAutoidSequential, member_ld);
        }
        {
            TypeIdentifierPair type_ids_lld;
            ReturnCode_t return_code_lld {eprosima::fastdds::dds::RETCODE_OK};
            return_code_lld =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_lld);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_lld)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "lld Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_lld = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_lld = 0x07f89ae7;
            bool common_lld_ec {false};
            CommonStructMember common_lld {TypeObjectUtils::build_common_struct_member(member_id_lld, member_flags_lld, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_lld, common_lld_ec))};
            if (!common_lld_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure lld member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_lld = "lld";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_lld;
            ann_custom_DerivedAutoidSequential.reset();
            CompleteMemberDetail detail_lld = TypeObjectUtils::build_complete_member_detail(name_lld, member_ann_builtin_lld, ann_custom_DerivedAutoidSequential);
            CompleteStructMember member_lld = TypeObjectUtils::build_complete_struct_member(common_lld, detail_lld);
            TypeObjectUtils::add_complete_struct_member(member_seq_DerivedAutoidSequential, member_lld);
        }
        CompleteStructType struct_type_DerivedAutoidSequential = TypeObjectUtils::build_complete_struct_type(struct_flags_DerivedAutoidSequential, header_DerivedAutoidSequential, member_seq_DerivedAutoidSequential);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_DerivedAutoidSequential, type_name_DerivedAutoidSequential.to_string(), type_ids_DerivedAutoidSequential))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "DerivedAutoidSequential already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_DerivedAutoidHash_type_identifier(
        TypeIdentifierPair& type_ids_DerivedAutoidHash)
{

    ReturnCode_t return_code_DerivedAutoidHash {eprosima::fastdds::dds::RETCODE_OK};
    return_code_DerivedAutoidHash =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "DerivedAutoidHash", type_ids_DerivedAutoidHash);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_DerivedAutoidHash)
    {
        StructTypeFlag struct_flags_DerivedAutoidHash = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, true);
        return_code_DerivedAutoidHash =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "AutoidHash", type_ids_DerivedAutoidHash);

        if (return_code_DerivedAutoidHash != eprosima::fastdds::dds::RETCODE_OK)
        {
::register_AutoidHash_type_identifier(type_ids_DerivedAutoidHash);
        }
        QualifiedTypeName type_name_DerivedAutoidHash = "DerivedAutoidHash";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_DerivedAutoidHash;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_DerivedAutoidHash;
        AppliedAnnotationSeq tmp_ann_custom_DerivedAutoidHash;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_DerivedAutoidHash;
        if (!tmp_ann_custom_DerivedAutoidHash.empty())
        {
            ann_custom_DerivedAutoidHash = tmp_ann_custom_DerivedAutoidHash;
        }

        CompleteTypeDetail detail_DerivedAutoidHash = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_DerivedAutoidHash, ann_custom_DerivedAutoidHash, type_name_DerivedAutoidHash.to_string());
        CompleteStructHeader header_DerivedAutoidHash;
        if (EK_COMPLETE == type_ids_DerivedAutoidHash.type_identifier1()._d())
        {
            header_DerivedAutoidHash = TypeObjectUtils::build_complete_struct_header(type_ids_DerivedAutoidHash.type_identifier1(), detail_DerivedAutoidHash);
        }
        else if (EK_COMPLETE == type_ids_DerivedAutoidHash.type_identifier2()._d())
        {
            header_DerivedAutoidHash = TypeObjectUtils::build_complete_struct_header(type_ids_DerivedAutoidHash.type_identifier2(), detail_DerivedAutoidHash);
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "DerivedAutoidHash Structure: base_type TypeIdentifier registered in TypeObjectRegistry is inconsistent.");
            return;
        }
        CompleteStructMemberSeq member_seq_DerivedAutoidHash;
        {
            TypeIdentifierPair type_ids_cd;
            ReturnCode_t return_code_cd {eprosima::fastdds::dds::RETCODE_OK};
            return_code_cd =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_char", type_ids_cd);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_cd)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "cd Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_cd = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_cd = 0x03ae6568;
            bool common_cd_ec {false};
            CommonStructMember common_cd {TypeObjectUtils::build_common_struct_member(member_id_cd, member_flags_cd, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_cd, common_cd_ec))};
            if (!common_cd_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure cd member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_cd = "cd";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_cd;
            ann_custom_DerivedAutoidHash.reset();
            CompleteMemberDetail detail_cd = TypeObjectUtils::build_complete_member_detail(name_cd, member_ann_builtin_cd, ann_custom_DerivedAutoidHash);
            CompleteStructMember member_cd = TypeObjectUtils::build_complete_struct_member(common_cd, detail_cd);
            TypeObjectUtils::add_complete_struct_member(member_seq_DerivedAutoidHash, member_cd);
        }
        {
            TypeIdentifierPair type_ids_od;
            ReturnCode_t return_code_od {eprosima::fastdds::dds::RETCODE_OK};
            return_code_od =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_od);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_od)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "od Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_od = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_od = 0x00000065;
            bool common_od_ec {false};
            CommonStructMember common_od {TypeObjectUtils::build_common_struct_member(member_id_od, member_flags_od, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_od, common_od_ec))};
            if (!common_od_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure od member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_od = "od";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_od;
            ann_custom_DerivedAutoidHash.reset();
            AppliedAnnotationSeq tmp_ann_custom_od;
            eprosima::fastcdr::optional<std::string> unit_od;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_od;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_od;
            eprosima::fastcdr::optional<std::string> hash_id_od;
            if (unit_od.has_value() || min_od.has_value() || max_od.has_value() || hash_id_od.has_value())
            {
                member_ann_builtin_od = TypeObjectUtils::build_applied_builtin_member_annotations(unit_od, min_od, max_od, hash_id_od);
            }
            if (!tmp_ann_custom_od.empty())
            {
                ann_custom_DerivedAutoidHash = tmp_ann_custom_od;
            }
            CompleteMemberDetail detail_od = TypeObjectUtils::build_complete_member_detail(name_od, member_ann_builtin_od, ann_custom_DerivedAutoidHash);
            CompleteStructMember member_od = TypeObjectUtils::build_complete_struct_member(common_od, detail_od);
            TypeObjectUtils::add_complete_struct_member(member_seq_DerivedAutoidHash, member_od);
        }
        {
            TypeIdentifierPair type_ids_sd;
            ReturnCode_t return_code_sd {eprosima::fastdds::dds::RETCODE_OK};
            return_code_sd =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_sd);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_sd)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "sd Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_sd = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_sd = 0x0bf72662;
            bool common_sd_ec {false};
            CommonStructMember common_sd {TypeObjectUtils::build_common_struct_member(member_id_sd, member_flags_sd, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_sd, common_sd_ec))};
            if (!common_sd_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure sd member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_sd = "sd";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_sd;
            ann_custom_DerivedAutoidHash.reset();
            AppliedAnnotationSeq tmp_ann_custom_sd;
            eprosima::fastcdr::optional<std::string> unit_sd;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_sd;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_sd;
            eprosima::fastcdr::optional<std::string> hash_id_sd;
            hash_id_sd = "";

            if (unit_sd.has_value() || min_sd.has_value() || max_sd.has_value() || hash_id_sd.has_value())
            {
                member_ann_builtin_sd = TypeObjectUtils::build_applied_builtin_member_annotations(unit_sd, min_sd, max_sd, hash_id_sd);
            }
            if (!tmp_ann_custom_sd.empty())
            {
                ann_custom_DerivedAutoidHash = tmp_ann_custom_sd;
            }
            CompleteMemberDetail detail_sd = TypeObjectUtils::build_complete_member_detail(name_sd, member_ann_builtin_sd, ann_custom_DerivedAutoidHash);
            CompleteStructMember member_sd = TypeObjectUtils::build_complete_struct_member(common_sd, detail_sd);
            TypeObjectUtils::add_complete_struct_member(member_seq_DerivedAutoidHash, member_sd);
        }
        {
            TypeIdentifierPair type_ids_ld;
            ReturnCode_t return_code_ld {eprosima::fastdds::dds::RETCODE_OK};
            return_code_ld =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_ld);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_ld)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "ld Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_ld = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_ld = 0x07f89ae6;
            bool common_ld_ec {false};
            CommonStructMember common_ld {TypeObjectUtils::build_common_struct_member(member_id_ld, member_flags_ld, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_ld, common_ld_ec))};
            if (!common_ld_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure ld member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_ld = "ld";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_ld;
            ann_custom_DerivedAutoidHash.reset();
            AppliedAnnotationSeq tmp_ann_custom_ld;
            eprosima::fastcdr::optional<std::string> unit_ld;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_ld;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_ld;
            eprosima::fastcdr::optional<std::string> hash_id_ld;
            hash_id_ld = "long2";

            if (unit_ld.has_value() || min_ld.has_value() || max_ld.has_value() || hash_id_ld.has_value())
            {
                member_ann_builtin_ld = TypeObjectUtils::build_applied_builtin_member_annotations(unit_ld, min_ld, max_ld, hash_id_ld);
            }
            if (!tmp_ann_custom_ld.empty())
            {
                ann_custom_DerivedAutoidHash = tmp_ann_custom_ld;
            }
            CompleteMemberDetail detail_ld = TypeObjectUtils::build_complete_member_detail(name_ld, member_ann_builtin_ld, ann_custom_DerivedAutoidHash);
            CompleteStructMember member_ld = TypeObjectUtils::build_complete_struct_member(common_ld, detail_ld);
            TypeObjectUtils::add_complete_struct_member(member_seq_DerivedAutoidHash, member_ld);
        }
        {
            TypeIdentifierPair type_ids_lld;
            ReturnCode_t return_code_lld {eprosima::fastdds::dds::RETCODE_OK};
            return_code_lld =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_lld);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_lld)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "lld Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_lld = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_lld = 0x00e90b05;
            bool common_lld_ec {false};
            CommonStructMember common_lld {TypeObjectUtils::build_common_struct_member(member_id_lld, member_flags_lld, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_lld, common_lld_ec))};
            if (!common_lld_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure lld member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_lld = "lld";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_lld;
            ann_custom_DerivedAutoidHash.reset();
            CompleteMemberDetail detail_lld = TypeObjectUtils::build_complete_member_detail(name_lld, member_ann_builtin_lld, ann_custom_DerivedAutoidHash);
            CompleteStructMember member_lld = TypeObjectUtils::build_complete_struct_member(common_lld, detail_lld);
            TypeObjectUtils::add_complete_struct_member(member_seq_DerivedAutoidHash, member_lld);
        }
        CompleteStructType struct_type_DerivedAutoidHash = TypeObjectUtils::build_complete_struct_type(struct_flags_DerivedAutoidHash, header_DerivedAutoidHash, member_seq_DerivedAutoidHash);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_DerivedAutoidHash, type_name_DerivedAutoidHash.to_string(), type_ids_DerivedAutoidHash))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "DerivedAutoidHash already registered in TypeObjectRegistry for a different type.");
        }
    }
}

