/* -*- c-file-style: "GNU" -*- */
/*
 * Copyright (C) CNRS, INRIA, Université Bordeaux 1, Telecom SudParis
 * See COPYING in top-level directory.
 */

#ifndef __PTHREAD_EV_CODES_H__
#define __PTHREAD_EV_CODES_H__

#include "ev_codes.h"

#define EZTRACE_PTHREAD_EVENTS_ID SYSTEM_MODULE_ID(0x02)
#define EZTRACE_PTHREAD_PREFIX    GENERATE_SYSTEM_MODULE_PREFIX(EZTRACE_PTHREAD_EVENTS_ID)

/* semaphores */
#define EZTRACE_SEM_POST            (EZTRACE_PTHREAD_PREFIX | 0x0010)
#define EZTRACE_SEM_START_WAIT      (EZTRACE_PTHREAD_PREFIX | 0x0011)
#define EZTRACE_SEM_STOP_WAIT       (EZTRACE_PTHREAD_PREFIX | 0x0012)

/* spinlocks */
#define EZTRACE_SPIN_LOCK_START     (EZTRACE_PTHREAD_PREFIX | 0x0020 )
#define EZTRACE_SPIN_LOCK_STOP      (EZTRACE_PTHREAD_PREFIX | 0x0021 )

#define EZTRACE_SPIN_UNLOCK        (EZTRACE_PTHREAD_PREFIX | 0x0022 )
#define EZTRACE_SPIN_TRYLOCK        (EZTRACE_PTHREAD_PREFIX | 0x0023 )

/* mutexes */
#define EZTRACE_MUTEX_TRYLOCK_SUCCESS (EZTRACE_PTHREAD_PREFIX | 0x0030)
#define EZTRACE_MUTEX_TRYLOCK_FAIL    (EZTRACE_PTHREAD_PREFIX | 0x0031)

#define EZTRACE_MUTEX_LOCK_START    (EZTRACE_PTHREAD_PREFIX | 0x0033)
#define EZTRACE_MUTEX_LOCK_STOP     (EZTRACE_PTHREAD_PREFIX | 0x0034)
#define EZTRACE_MUTEX_UNLOCK        (EZTRACE_PTHREAD_PREFIX | 0x0035)

/* conditions */
#define EZTRACE_COND_SIGNAL         (EZTRACE_PTHREAD_PREFIX | 0x0040)
#define EZTRACE_COND_BROADCAST      (EZTRACE_PTHREAD_PREFIX | 0x0041)
#define EZTRACE_COND_START_WAIT     (EZTRACE_PTHREAD_PREFIX | 0x0042)
#define EZTRACE_COND_STOP_WAIT      (EZTRACE_PTHREAD_PREFIX | 0x0043)

/* rwlocks */
#define EZTRACE_RWLOCK_RDLOCK_START (EZTRACE_PTHREAD_PREFIX | 0x0050)
#define EZTRACE_RWLOCK_RDLOCK_STOP  (EZTRACE_PTHREAD_PREFIX | 0x0051)

#define EZTRACE_RWLOCK_WRLOCK_START (EZTRACE_PTHREAD_PREFIX | 0x0052)
#define EZTRACE_RWLOCK_WRLOCK_STOP  (EZTRACE_PTHREAD_PREFIX | 0x0053)

#define EZTRACE_RWLOCK_UNLOCK       (EZTRACE_PTHREAD_PREFIX | 0x0054)

/* barriers */
#define EZTRACE_BARRIER_START (EZTRACE_PTHREAD_PREFIX | 0x0060)
#define EZTRACE_BARRIER_STOP  (EZTRACE_PTHREAD_PREFIX | 0x0061)

#endif	/* __PTHREAD_EV_CODES_H__ */
