!{\src2tex{textfont=tt}}
!!****m* etsf_io_data_group/etsf_io_data_init
!! NAME
!!  etsf_io_data_init
!!
!! FUNCTION
!!    High-level routine to create an ETSF file.
!!
!! COPYRIGHT
!!  Copyright (C) 2006-2010 (Damien Caliste)
!!  This file is distributed under the terms of the
!!  GNU Lesser General Public License, see the COPYING file
!!  or http://www.gnu.org/copyleft/lesser.txt .
!!
!! INPUTS
!! * filename = 
!!     the path to the file to be accessed.
!! * groups <type(etsf_groups_flags)> = 
!!     choose the groups and the variables (from #etsf_groups_flags) that will
!!     be used. This is a sum of values taken from #FLAGS_VARIABLES for each group.
!!     Let the value to etsf_<grp>_none not to define a wall group.
!! * title = 
!!     the title of the file (maybe null but should not).
!! * history = 
!!     some history information (maybe null).
!! * k_dependent = (optional) 
!!     use this argument to set the attribute flag 'k_dependent' to 'yes'
!!     or 'no' on variables that have it. If no variable in the group has
!!     the attribute 'k_dependent', this argument has no effect. The default
!!     value is .true. (which puts 'yes' in the file).
!! * overwrite = (optional) 
!!     will overwrite an existing file with the same file name (default is .false.).
!! * split_definition <type(etsf_split)> = (optional) 
!!     give for each associated array the number of elements (given by the size)
!!     and the values of these elements in a splitted file.
!! OUTPUT
!! * lstat = 
!!     return .true. if all the actions succeed, if not the status
!!     of the file is undefined.
!! * error_data <type(etsf_io_low_error)> = 
!!     contains the details of the error is @lstat is false.
!! SIDE EFFECTS
!! * dims <type(etsf_dims)> = 
!!     contains all the dimensions required by the ETSF file. It will be modify
!!     by setting the constant dimensions to their right values, and the my_something
!!     dimensions will be set according to the @split optional argument (if not
!!     present, they will be put to their none split values).
!!
!! NOTES
!!  This file has been automatically generated by the autogen_subroutines.py
!!  script. Any change you would bring to it will systematically be
!!  overwritten.
!!
!! SOURCE
subroutine etsf_io_data_init(filename, groups, dims, title, history, lstat, &
  & error_data, k_dependent, overwrite, split_definition)

  !Arguments ------------------------------------
  character(len=*), intent(in) :: filename
  type(etsf_groups_flags), intent(in) :: groups
  type(etsf_dims), intent(inout) :: dims
  character(len=*), intent(in) :: title
  character(len=*), intent(in) :: history
  logical, intent(out) :: lstat
  type(etsf_io_low_error), intent(out) :: error_data
  logical, optional, intent(in) :: k_dependent
  logical, optional, intent(in) :: overwrite
  type(etsf_split), optional, intent(in) :: split_definition
  !Local variables-------------------------------
  character(len=*),parameter :: my_name = 'etsf_io_data_init'
  integer :: ncid, i
  logical :: my_k_dependent
  logical :: my_overwrite
  type(etsf_split) :: my_split_definition


  ! *************************************************************************

!DEBUG
!write (*,*) 'etsf_io_data_init : enter'
!ENDDEBUG

  ! Get values for optional arguments, set default.
  if (present(k_dependent)) then
    my_k_dependent = k_dependent
  else
    my_k_dependent = .true.
  end if
  if (present(overwrite)) then
    my_overwrite = overwrite
  else
    my_overwrite = .false.
  end if
  if (present(split_definition)) then
    my_split_definition = split_definition
  end if
  
  ! Create the NetCDF file
  call etsf_io_low_open_create(ncid, filename, etsf_file_format_version, lstat, &
                             & title = trim(title), history = trim(history), &
                             & error_data = error_data, overwrite = my_overwrite)
  if (.not. lstat) then
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  
  ! Define dimensions
  dims%character_string_length        = etsf_charlen
  dims%number_of_cartesian_directions = etsf_3dimlen
  dims%number_of_reduced_dimensions   = etsf_3dimlen
  dims%number_of_vectors              = etsf_3dimlen
  dims%symbol_length                  = etsf_chemlen
  
  ! We set the size of split arrays, if required.
  if (present(split_definition)) then
    call etsf_io_split_init(dims, split_definition)
  end if
  
  ! We write the dimensions to the file.
  call etsf_io_dims_def(ncid, dims, lstat, error_data)
  if (.not. lstat) then
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  
  ! Define split arrays.
  if (present(split_definition)) then
    call etsf_io_split_def(ncid, dims, lstat, error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  ! Define groups.
  if (groups%geometry /= etsf_geometry_none) then
    call etsf_io_geometry_def(ncid, lstat, error_data, &
                      & k_dependent = my_k_dependent, &
                      & flags = groups%geometry, &
                      & split = my_split_definition)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  if (groups%electrons /= etsf_electrons_none) then
    call etsf_io_electrons_def(ncid, lstat, error_data, &
                      & k_dependent = my_k_dependent, &
                      & flags = groups%electrons, &
                      & split = my_split_definition)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  if (groups%kpoints /= etsf_kpoints_none) then
    call etsf_io_kpoints_def(ncid, lstat, error_data, &
                      & k_dependent = my_k_dependent, &
                      & flags = groups%kpoints, &
                      & split = my_split_definition)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  if (groups%basisdata /= etsf_basisdata_none) then
    call etsf_io_basisdata_def(ncid, lstat, error_data, &
                      & k_dependent = my_k_dependent, &
                      & flags = groups%basisdata, &
                      & split = my_split_definition)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  if (groups%gwdata /= etsf_gwdata_none) then
    call etsf_io_gwdata_def(ncid, lstat, error_data, &
                      & k_dependent = my_k_dependent, &
                      & flags = groups%gwdata, &
                      & split = my_split_definition)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  if (groups%dielectric /= etsf_dielectric_none) then
    call etsf_io_dielectric_def(ncid, lstat, error_data, &
                      & k_dependent = my_k_dependent, &
                      & flags = groups%dielectric, &
                      & split = my_split_definition)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  if (groups%main /= etsf_main_none) then
    call etsf_io_main_def(ncid, lstat, error_data, &
                      & k_dependent = my_k_dependent, &
                      & flags = groups%main, &
                      & split = my_split_definition)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  ! Write the split arrays.
  if (present(split_definition)) then
    ! Begin by putting the file in write mode.
    call etsf_io_low_set_write_mode(ncid, lstat, error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
    ! Write the arrays.
    call etsf_io_split_put(ncid, split_definition, lstat, error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  ! End definitions and close file
  call etsf_io_low_close(ncid, lstat, error_data = error_data)
  if (.not. lstat) then
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if

!DEBUG
!write (*,*) 'etsf_io_data_init : exit'
!ENDDEBUG

end subroutine etsf_io_data_init
!!***
