/***********************************************************************/
/* Open Visualization Data Explorer                                    */
/* (C) Copyright IBM Corp. 1989,1999                                   */
/* ALL RIGHTS RESERVED                                                 */
/* This code licensed under the                                        */
/*    "IBM PUBLIC LICENSE - Open Visualization Data Explorer"          */
/***********************************************************************/

#include <dxconfig.h>


/*
 * $Header: /src/master/dx/src/exec/dxmods/cases.h,v 1.4 2000/08/24 20:04:25 davidt Exp $:
 */

#ifndef _CASES_H_
#define _CASES_H_

/*
 * This file contains the case tables used by _dxfMapToPlane when intersecting
 * elements with planes.
 */

typedef struct {
	int start, knt;
} Case;

static int tetras_case[] = {
 /*   0 */   0,   0,   1,   2,   3,   4,   5,   6, 
 /*   8 */   7,   8,   9,  10,  11,  12,  13,  14, 
            15};

static int tetras_edges[] = 
{
   /*   0   0 */    0, 2, 1,
   /*   1   3 */    3, 4, 0,
   /*   2   6 */    3, 4, 2, 1,
   /*   3  10 */    1, 5, 3,
   /*   4  13 */    0, 2, 5, 3,
   /*   5  17 */    1, 5, 4, 0,
   /*   6  21 */    5, 4, 2,
   /*   7  24 */    4, 5, 2,
   /*   8  27 */    0, 4, 5, 1,
   /*   9  31 */    3, 5, 2, 0,
   /*  10  35 */    3, 5, 1,
   /*  11  38 */    1, 2, 4, 3,
   /*  12  42 */    0, 4, 3,
   /*  13  45 */    1, 2, 0
};

static Case tetras_loops[] =
{
/*   0 */ {   0,  3},  /*   1 */ {   3,  3},  /*   2 */ {   6,  4},
/*   3 */ {  10,  3},  /*   4 */ {  13,  4},  /*   5 */ {  17,  4},
/*   6 */ {  21,  3},  /*   7 */ {  24,  3},  /*   8 */ {  27,  4},
/*   9 */ {  31,  4},  /*  10 */ {  35,  3},  /*  11 */ {  38,  4},
/*  12 */ {  42,  3},  /*  13 */ {  45,  3},  /*  14 */ {  -1, -1},

};

static int cubes_case[] = {
 /*   0 */   0,   0,   1,   2,   3,   4,   5,   7, 
 /*   8 */   8,   9,  11,  12,  13,  14,  15,  16, 
 /*  16 */  17,  18,  19,  21,  22,  24,  25,  28, 
 /*  24 */  29,  31,  33,  35,  36,  38,  39,  41, 
 /*  32 */  42,  43,  45,  46,  47,  49,  51,  53, 
 /*  40 */  54,  56,  59,  60,  61,  63,  65,  66, 
 /*  48 */  67,  68,  69,  70,  71,  73,  74,  76, 
 /*  56 */  77,  79,  81,  82,  83,  85,  86,  87, 
 /*  64 */  88,  89,  91,  93,  95,  96,  97,  99, 
 /*  72 */ 100, 102, 105, 107, 109, 110, 111, 112, 
 /*  80 */ 113, 114, 115, 117, 118, 119, 120, 122, 
 /*  88 */ 123, 125, 127, 129, 130, 131, 132, 133, 
 /*  96 */ 134, 136, 139, 141, 143, 145, 147, 149, 
 /* 104 */ 150, 153, 157, 159, 161, 163, 165, 166, 
 /* 112 */ 167, 168, 169, 170, 171, 172, 173, 174, 
 /* 120 */ 175, 177, 179, 180, 181, 182, 183, 184, 
 /* 128 */ 185, 186, 188, 190, 192, 194, 196, 199, 
 /* 136 */ 201, 202, 204, 205, 206, 207, 208, 209, 
 /* 144 */ 210, 212, 214, 217, 219, 222, 224, 228, 
 /* 152 */ 230, 232, 234, 236, 237, 239, 240, 242, 
 /* 160 */ 243, 244, 246, 247, 248, 250, 252, 254, 
 /* 168 */ 255, 256, 258, 259, 260, 261, 262, 263, 
 /* 176 */ 264, 265, 266, 267, 268, 270, 271, 273, 
 /* 184 */ 274, 275, 276, 277, 278, 279, 280, 281, 
 /* 192 */ 282, 283, 285, 287, 289, 290, 291, 293, 
 /* 200 */ 294, 295, 297, 298, 299, 300, 301, 302, 
 /* 208 */ 303, 304, 305, 307, 308, 309, 310, 312, 
 /* 216 */ 313, 314, 315, 316, 317, 318, 319, 320, 
 /* 224 */ 321, 322, 324, 325, 326, 327, 328, 329, 
 /* 232 */ 330, 331, 333, 334, 335, 336, 337, 338, 
 /* 240 */ 339, 340, 341, 342, 343, 344, 345, 346, 
 /* 248 */ 347, 348, 349, 350, 351, 352, 353, 354, 
           355};

static int cubes_edges[] = 
{
   /*   0   0 */    0, 4, 8,
   /*   1   3 */    0, 9, 5,
   /*   2   6 */    9, 5, 4, 8,
   /*   3  10 */    1, 10, 4,
   /*   4  13 */    0, 1, 10, 8,
   /*   5  17 */    0, 9, 5,
   /*   6  20 */    1, 10, 4,
   /*   7  23 */    9, 5, 1, 10, 8,
   /*   8  28 */    5, 11, 1,
   /*   9  31 */    0, 4, 8,
   /*  10  34 */    5, 11, 1,
   /*  11  37 */    0, 9, 11, 1,
   /*  12  41 */    9, 11, 1, 4, 8,
   /*  13  46 */    5, 11, 10, 4,
   /*  14  50 */    0, 5, 11, 10, 8,
   /*  15  55 */    0, 9, 11, 10, 4,
   /*  16  60 */    9, 11, 10, 8,
   /*  17  64 */    6, 2, 8,
   /*  18  67 */    0, 4, 6, 2,
   /*  19  71 */    0, 9, 5,
   /*  20  74 */    6, 2, 8,
   /*  21  77 */    9, 5, 4, 6, 2,
   /*  22  82 */    1, 10, 4,
   /*  23  85 */    6, 2, 8,
   /*  24  88 */    0, 1, 10, 6, 2,
   /*  25  93 */    0, 9, 5,
   /*  26  96 */    1, 10, 4,
   /*  27  99 */    6, 2, 8,
   /*  28 102 */    9, 5, 1, 10, 6, 2,
   /*  29 108 */    5, 11, 1,
   /*  30 111 */    6, 2, 8,
   /*  31 114 */    0, 4, 6, 2,
   /*  32 118 */    5, 11, 1,
   /*  33 121 */    0, 9, 11, 1,
   /*  34 125 */    6, 2, 8,
   /*  35 128 */    9, 11, 1, 4, 6, 2,
   /*  36 134 */    5, 11, 10, 4,
   /*  37 138 */    6, 2, 8,
   /*  38 141 */    0, 5, 11, 10, 6, 2,
   /*  39 147 */    0, 9, 11, 10, 4,
   /*  40 152 */    6, 2, 8,
   /*  41 155 */    9, 11, 10, 6, 2,
   /*  42 160 */    2, 7, 9,
   /*  43 163 */    0, 4, 8,
   /*  44 166 */    2, 7, 9,
   /*  45 169 */    0, 2, 7, 5,
   /*  46 173 */    2, 7, 5, 4, 8,
   /*  47 178 */    1, 10, 4,
   /*  48 181 */    2, 7, 9,
   /*  49 184 */    0, 1, 10, 8,
   /*  50 188 */    2, 7, 9,
   /*  51 191 */    0, 2, 7, 5,
   /*  52 195 */    1, 10, 4,
   /*  53 198 */    2, 7, 5, 1, 10, 8,
   /*  54 204 */    5, 11, 1,
   /*  55 207 */    2, 7, 9,
   /*  56 210 */    0, 4, 8,
   /*  57 213 */    5, 11, 1,
   /*  58 216 */    2, 7, 9,
   /*  59 219 */    0, 2, 7, 11, 1,
   /*  60 224 */    2, 7, 11, 1, 4, 8,
   /*  61 230 */    5, 11, 10, 4,
   /*  62 234 */    2, 7, 9,
   /*  63 237 */    0, 5, 11, 10, 8,
   /*  64 242 */    2, 7, 9,
   /*  65 245 */    0, 2, 7, 11, 10, 4,
   /*  66 251 */    2, 7, 11, 10, 8,
   /*  67 256 */    6, 7, 9, 8,
   /*  68 260 */    0, 4, 6, 7, 9,
   /*  69 265 */    0, 8, 6, 7, 5,
   /*  70 270 */    6, 7, 5, 4,
   /*  71 274 */    1, 10, 4,
   /*  72 277 */    6, 7, 9, 8,
   /*  73 281 */    0, 1, 10, 6, 7, 9,
   /*  74 287 */    0, 8, 6, 7, 5,
   /*  75 292 */    1, 10, 4,
   /*  76 295 */    6, 7, 5, 1, 10,
   /*  77 300 */    5, 11, 1,
   /*  78 303 */    6, 7, 9, 8,
   /*  79 307 */    0, 4, 6, 7, 9,
   /*  80 312 */    5, 11, 1,
   /*  81 315 */    0, 8, 6, 7, 11, 1,
   /*  82 321 */    6, 7, 11, 1, 4,
   /*  83 326 */    5, 11, 10, 4,
   /*  84 330 */    6, 7, 9, 8,
   /*  85 334 */    0, 5, 11, 10, 6, 7, 9,
   /*  86 341 */    0, 8, 6, 7, 11, 10, 4,
   /*  87 348 */    6, 7, 11, 10,
   /*  88 352 */    3, 6, 10,
   /*  89 355 */    0, 4, 8,
   /*  90 358 */    3, 6, 10,
   /*  91 361 */    0, 9, 5,
   /*  92 364 */    3, 6, 10,
   /*  93 367 */    9, 5, 4, 8,
   /*  94 371 */    3, 6, 10,
   /*  95 374 */    1, 3, 6, 4,
   /*  96 378 */    0, 1, 3, 6, 8,
   /*  97 383 */    0, 9, 5,
   /*  98 386 */    1, 3, 6, 4,
   /*  99 390 */    9, 5, 1, 3, 6, 8,
   /* 100 396 */    5, 11, 1,
   /* 101 399 */    3, 6, 10,
   /* 102 402 */    0, 4, 8,
   /* 103 405 */    5, 11, 1,
   /* 104 408 */    3, 6, 10,
   /* 105 411 */    0, 9, 11, 1,
   /* 106 415 */    3, 6, 10,
   /* 107 418 */    9, 11, 1, 4, 8,
   /* 108 423 */    3, 6, 10,
   /* 109 426 */    5, 11, 3, 6, 4,
   /* 110 431 */    0, 5, 11, 3, 6, 8,
   /* 111 437 */    0, 9, 11, 3, 6, 4,
   /* 112 443 */    9, 11, 3, 6, 8,
   /* 113 448 */    10, 3, 2, 8,
   /* 114 452 */    0, 4, 10, 3, 2,
   /* 115 457 */    0, 9, 5,
   /* 116 460 */    10, 3, 2, 8,
   /* 117 464 */    9, 5, 4, 10, 3, 2,
   /* 118 470 */    1, 3, 2, 8, 4,
   /* 119 475 */    0, 1, 3, 2,
   /* 120 479 */    0, 9, 5,
   /* 121 482 */    1, 3, 2, 8, 4,
   /* 122 487 */    9, 5, 1, 3, 2,
   /* 123 492 */    5, 11, 1,
   /* 124 495 */    10, 3, 2, 8,
   /* 125 499 */    0, 4, 10, 3, 2,
   /* 126 504 */    5, 11, 1,
   /* 127 507 */    0, 9, 11, 1,
   /* 128 511 */    10, 3, 2, 8,
   /* 129 515 */    9, 11, 1, 4, 10, 3, 2,
   /* 130 522 */    5, 11, 3, 2, 8, 4,
   /* 131 528 */    0, 5, 11, 3, 2,
   /* 132 533 */    0, 9, 11, 3, 2, 8, 4,
   /* 133 540 */    9, 11, 3, 2,
   /* 134 544 */    2, 7, 9,
   /* 135 547 */    3, 6, 10,
   /* 136 550 */    0, 4, 8,
   /* 137 553 */    2, 7, 9,
   /* 138 556 */    3, 6, 10,
   /* 139 559 */    0, 2, 7, 5,
   /* 140 563 */    3, 6, 10,
   /* 141 566 */    2, 7, 5, 4, 8,
   /* 142 571 */    3, 6, 10,
   /* 143 574 */    1, 3, 6, 4,
   /* 144 578 */    2, 7, 9,
   /* 145 581 */    0, 1, 3, 6, 8,
   /* 146 586 */    2, 7, 9,
   /* 147 589 */    0, 2, 7, 5,
   /* 148 593 */    1, 3, 6, 4,
   /* 149 597 */    2, 7, 5, 1, 3, 6, 8,
   /* 150 604 */    5, 11, 1,
   /* 151 607 */    2, 7, 9,
   /* 152 610 */    3, 6, 10,
   /* 153 613 */    0, 4, 8,
   /* 154 616 */    5, 11, 1,
   /* 155 619 */    2, 7, 9,
   /* 156 622 */    3, 6, 10,
   /* 157 625 */    0, 2, 7, 11, 1,
   /* 158 630 */    3, 6, 10,
   /* 159 633 */    2, 7, 11, 1, 4, 8,
   /* 160 639 */    3, 6, 10,
   /* 161 642 */    5, 11, 3, 6, 4,
   /* 162 647 */    2, 7, 9,
   /* 163 650 */    0, 5, 11, 3, 6, 8,
   /* 164 656 */    2, 7, 9,
   /* 165 659 */    0, 2, 7, 11, 3, 6, 4,
   /* 166 666 */    2, 7, 11, 3, 6, 8,
   /* 167 672 */    10, 3, 7, 9, 8,
   /* 168 677 */    0, 4, 10, 3, 7, 9,
   /* 169 683 */    0, 8, 10, 3, 7, 5,
   /* 170 689 */    10, 3, 7, 5, 4,
   /* 171 694 */    1, 3, 7, 9, 8, 4,
   /* 172 700 */    0, 1, 3, 7, 9,
   /* 173 705 */    0, 8, 4, 1, 3, 7, 5,
   /* 174 712 */    1, 3, 7, 5,
   /* 175 716 */    5, 11, 1,
   /* 176 719 */    10, 3, 7, 9, 8,
   /* 177 724 */    0, 4, 10, 3, 7, 9,
   /* 178 730 */    5, 11, 1,
   /* 179 733 */    0, 8, 10, 3, 7, 11, 1,
   /* 180 740 */    10, 3, 7, 11, 1, 4,
   /* 181 746 */    5, 11, 3, 7, 9, 8, 4,
   /* 182 753 */    0, 5, 11, 3, 7, 9,
   /* 183 759 */    0, 8, 4, 11, 3, 7,
   /* 184 765 */    11, 3, 7,
   /* 185 768 */    7, 3, 11,
   /* 186 771 */    0, 4, 8,
   /* 187 774 */    7, 3, 11,
   /* 188 777 */    0, 9, 5,
   /* 189 780 */    7, 3, 11,
   /* 190 783 */    9, 5, 4, 8,
   /* 191 787 */    7, 3, 11,
   /* 192 790 */    1, 10, 4,
   /* 193 793 */    7, 3, 11,
   /* 194 796 */    0, 1, 10, 8,
   /* 195 800 */    7, 3, 11,
   /* 196 803 */    0, 9, 5,
   /* 197 806 */    1, 10, 4,
   /* 198 809 */    7, 3, 11,
   /* 199 812 */    9, 5, 1, 10, 8,
   /* 200 817 */    7, 3, 11,
   /* 201 820 */    5, 7, 3, 1,
   /* 202 824 */    0, 4, 8,
   /* 203 827 */    5, 7, 3, 1,
   /* 204 831 */    0, 9, 7, 3, 1,
   /* 205 836 */    9, 7, 3, 1, 4, 8,
   /* 206 842 */    5, 7, 3, 10, 4,
   /* 207 847 */    0, 5, 7, 3, 10, 8,
   /* 208 853 */    0, 9, 7, 3, 10, 4,
   /* 209 859 */    9, 7, 3, 10, 8,
   /* 210 864 */    6, 2, 8,
   /* 211 867 */    7, 3, 11,
   /* 212 870 */    0, 4, 6, 2,
   /* 213 874 */    7, 3, 11,
   /* 214 877 */    0, 9, 5,
   /* 215 880 */    6, 2, 8,
   /* 216 883 */    7, 3, 11,
   /* 217 886 */    9, 5, 4, 6, 2,
   /* 218 891 */    7, 3, 11,
   /* 219 894 */    1, 10, 4,
   /* 220 897 */    6, 2, 8,
   /* 221 900 */    7, 3, 11,
   /* 222 903 */    0, 1, 10, 6, 2,
   /* 223 908 */    7, 3, 11,
   /* 224 911 */    0, 9, 5,
   /* 225 914 */    1, 10, 4,
   /* 226 917 */    6, 2, 8,
   /* 227 920 */    7, 3, 11,
   /* 228 923 */    9, 5, 1, 10, 6, 2,
   /* 229 929 */    7, 3, 11,
   /* 230 932 */    5, 7, 3, 1,
   /* 231 936 */    6, 2, 8,
   /* 232 939 */    0, 4, 6, 2,
   /* 233 943 */    5, 7, 3, 1,
   /* 234 947 */    0, 9, 7, 3, 1,
   /* 235 952 */    6, 2, 8,
   /* 236 955 */    9, 7, 3, 1, 4, 6, 2,
   /* 237 962 */    5, 7, 3, 10, 4,
   /* 238 967 */    6, 2, 8,
   /* 239 970 */    0, 5, 7, 3, 10, 6, 2,
   /* 240 977 */    0, 9, 7, 3, 10, 4,
   /* 241 983 */    6, 2, 8,
   /* 242 986 */    9, 7, 3, 10, 6, 2,
   /* 243 992 */    2, 3, 11, 9,
   /* 244 996 */    0, 4, 8,
   /* 245 999 */    2, 3, 11, 9,
   /* 246 1003 */    0, 2, 3, 11, 5,
   /* 247 1008 */    2, 3, 11, 5, 4, 8,
   /* 248 1014 */    1, 10, 4,
   /* 249 1017 */    2, 3, 11, 9,
   /* 250 1021 */    0, 1, 10, 8,
   /* 251 1025 */    2, 3, 11, 9,
   /* 252 1029 */    0, 2, 3, 11, 5,
   /* 253 1034 */    1, 10, 4,
   /* 254 1037 */    2, 3, 11, 5, 1, 10, 8,
   /* 255 1044 */    5, 9, 2, 3, 1,
   /* 256 1049 */    0, 4, 8,
   /* 257 1052 */    5, 9, 2, 3, 1,
   /* 258 1057 */    0, 2, 3, 1,
   /* 259 1061 */    2, 3, 1, 4, 8,
   /* 260 1066 */    5, 9, 2, 3, 10, 4,
   /* 261 1072 */    0, 5, 9, 2, 3, 10, 8,
   /* 262 1079 */    0, 2, 3, 10, 4,
   /* 263 1084 */    2, 3, 10, 8,
   /* 264 1088 */    6, 3, 11, 9, 8,
   /* 265 1093 */    0, 4, 6, 3, 11, 9,
   /* 266 1099 */    0, 8, 6, 3, 11, 5,
   /* 267 1105 */    6, 3, 11, 5, 4,
   /* 268 1110 */    1, 10, 4,
   /* 269 1113 */    6, 3, 11, 9, 8,
   /* 270 1118 */    0, 1, 10, 6, 3, 11, 9,
   /* 271 1125 */    0, 8, 6, 3, 11, 5,
   /* 272 1131 */    1, 10, 4,
   /* 273 1134 */    6, 3, 11, 5, 1, 10,
   /* 274 1140 */    5, 9, 8, 6, 3, 1,
   /* 275 1146 */    0, 4, 6, 3, 1, 5, 9,
   /* 276 1153 */    0, 8, 6, 3, 1,
   /* 277 1158 */    6, 3, 1, 4,
   /* 278 1162 */    5, 9, 8, 6, 3, 10, 4,
   /* 279 1169 */    0, 5, 9, 6, 3, 10,
   /* 280 1175 */    0, 8, 6, 3, 10, 4,
   /* 281 1181 */    6, 3, 10,
   /* 282 1184 */    11, 7, 6, 10,
   /* 283 1188 */    0, 4, 8,
   /* 284 1191 */    11, 7, 6, 10,
   /* 285 1195 */    0, 9, 5,
   /* 286 1198 */    11, 7, 6, 10,
   /* 287 1202 */    9, 5, 4, 8,
   /* 288 1206 */    11, 7, 6, 10,
   /* 289 1210 */    1, 11, 7, 6, 4,
   /* 290 1215 */    0, 1, 11, 7, 6, 8,
   /* 291 1221 */    0, 9, 5,
   /* 292 1224 */    1, 11, 7, 6, 4,
   /* 293 1229 */    9, 5, 1, 11, 7, 6, 8,
   /* 294 1236 */    5, 7, 6, 10, 1,
   /* 295 1241 */    0, 4, 8,
   /* 296 1244 */    5, 7, 6, 10, 1,
   /* 297 1249 */    0, 9, 7, 6, 10, 1,
   /* 298 1255 */    9, 7, 6, 10, 1, 4, 8,
   /* 299 1262 */    5, 7, 6, 4,
   /* 300 1266 */    0, 5, 7, 6, 8,
   /* 301 1271 */    0, 9, 7, 6, 4,
   /* 302 1276 */    9, 7, 6, 8,
   /* 303 1280 */    10, 11, 7, 2, 8,
   /* 304 1285 */    0, 4, 10, 11, 7, 2,
   /* 305 1291 */    0, 9, 5,
   /* 306 1294 */    10, 11, 7, 2, 8,
   /* 307 1299 */    9, 5, 4, 10, 11, 7, 2,
   /* 308 1306 */    1, 11, 7, 2, 8, 4,
   /* 309 1312 */    0, 1, 11, 7, 2,
   /* 310 1317 */    0, 9, 5,
   /* 311 1320 */    1, 11, 7, 2, 8, 4,
   /* 312 1326 */    9, 5, 1, 11, 7, 2,
   /* 313 1332 */    5, 7, 2, 8, 10, 1,
   /* 314 1338 */    0, 4, 10, 1, 5, 7, 2,
   /* 315 1345 */    0, 9, 7, 2, 8, 10, 1,
   /* 316 1352 */    9, 7, 2, 10, 1, 4,
   /* 317 1358 */    5, 7, 2, 8, 4,
   /* 318 1363 */    0, 5, 7, 2,
   /* 319 1367 */    0, 9, 7, 2, 8, 4,
   /* 320 1373 */    9, 7, 2,
   /* 321 1376 */    2, 6, 10, 11, 9,
   /* 322 1381 */    0, 4, 8,
   /* 323 1384 */    2, 6, 10, 11, 9,
   /* 324 1389 */    0, 2, 6, 10, 11, 5,
   /* 325 1395 */    2, 6, 10, 11, 5, 4, 8,
   /* 326 1402 */    1, 11, 9, 2, 6, 4,
   /* 327 1408 */    0, 1, 11, 9, 2, 6, 8,
   /* 328 1415 */    0, 2, 6, 4, 1, 11, 5,
   /* 329 1422 */    2, 6, 1, 11, 5, 8,
   /* 330 1428 */    5, 9, 2, 6, 10, 1,
   /* 331 1434 */    0, 4, 8,
   /* 332 1437 */    5, 9, 2, 6, 10, 1,
   /* 333 1443 */    0, 2, 6, 10, 1,
   /* 334 1448 */    2, 6, 10, 1, 4, 8,
   /* 335 1454 */    5, 9, 2, 6, 4,
   /* 336 1459 */    0, 5, 9, 2, 6, 8,
   /* 337 1465 */    0, 2, 6, 4,
   /* 338 1469 */    2, 6, 8,
   /* 339 1472 */    10, 11, 9, 8,
   /* 340 1476 */    0, 4, 10, 11, 9,
   /* 341 1481 */    0, 8, 10, 11, 5,
   /* 342 1486 */    10, 11, 5, 4,
   /* 343 1490 */    1, 11, 9, 8, 4,
   /* 344 1495 */    0, 1, 11, 9,
   /* 345 1499 */    0, 8, 4, 1, 11, 5,
   /* 346 1505 */    1, 11, 5,
   /* 347 1508 */    5, 9, 8, 10, 1,
   /* 348 1513 */    0, 4, 10, 1, 5, 9,
   /* 349 1519 */    0, 8, 10, 1,
   /* 350 1523 */    10, 1, 4,
   /* 351 1526 */    5, 9, 8, 4,
   /* 352 1530 */    0, 5, 9,
   /* 353 1533 */    0, 8, 4
};

static Case cubes_loops[] =
{
/*   0 */ {   0,  3},  /*   1 */ {   3,  3},  /*   2 */ {   6,  4},
/*   3 */ {  10,  3},  /*   4 */ {  13,  4},  /*   5 */ {  17,  3},
/*   6 */ {  20,  3},  /*   7 */ {  23,  5},  /*   8 */ {  28,  3},
/*   9 */ {  31,  3},  /*  10 */ {  34,  3},  /*  11 */ {  37,  4},
/*  12 */ {  41,  5},  /*  13 */ {  46,  4},  /*  14 */ {  50,  5},
/*  15 */ {  55,  5},  /*  16 */ {  60,  4},  /*  17 */ {  64,  3},
/*  18 */ {  67,  4},  /*  19 */ {  71,  3},  /*  20 */ {  74,  3},
/*  21 */ {  77,  5},  /*  22 */ {  82,  3},  /*  23 */ {  85,  3},
/*  24 */ {  88,  5},  /*  25 */ {  93,  3},  /*  26 */ {  96,  3},
/*  27 */ {  99,  3},  /*  28 */ { 102,  6},  /*  29 */ { 108,  3},
/*  30 */ { 111,  3},  /*  31 */ { 114,  4},  /*  32 */ { 118,  3},
/*  33 */ { 121,  4},  /*  34 */ { 125,  3},  /*  35 */ { 128,  6},
/*  36 */ { 134,  4},  /*  37 */ { 138,  3},  /*  38 */ { 141,  6},
/*  39 */ { 147,  5},  /*  40 */ { 152,  3},  /*  41 */ { 155,  5},
/*  42 */ { 160,  3},  /*  43 */ { 163,  3},  /*  44 */ { 166,  3},
/*  45 */ { 169,  4},  /*  46 */ { 173,  5},  /*  47 */ { 178,  3},
/*  48 */ { 181,  3},  /*  49 */ { 184,  4},  /*  50 */ { 188,  3},
/*  51 */ { 191,  4},  /*  52 */ { 195,  3},  /*  53 */ { 198,  6},
/*  54 */ { 204,  3},  /*  55 */ { 207,  3},  /*  56 */ { 210,  3},
/*  57 */ { 213,  3},  /*  58 */ { 216,  3},  /*  59 */ { 219,  5},
/*  60 */ { 224,  6},  /*  61 */ { 230,  4},  /*  62 */ { 234,  3},
/*  63 */ { 237,  5},  /*  64 */ { 242,  3},  /*  65 */ { 245,  6},
/*  66 */ { 251,  5},  /*  67 */ { 256,  4},  /*  68 */ { 260,  5},
/*  69 */ { 265,  5},  /*  70 */ { 270,  4},  /*  71 */ { 274,  3},
/*  72 */ { 277,  4},  /*  73 */ { 281,  6},  /*  74 */ { 287,  5},
/*  75 */ { 292,  3},  /*  76 */ { 295,  5},  /*  77 */ { 300,  3},
/*  78 */ { 303,  4},  /*  79 */ { 307,  5},  /*  80 */ { 312,  3},
/*  81 */ { 315,  6},  /*  82 */ { 321,  5},  /*  83 */ { 326,  4},
/*  84 */ { 330,  4},  /*  85 */ { 334,  7},  /*  86 */ { 341,  7},
/*  87 */ { 348,  4},  /*  88 */ { 352,  3},  /*  89 */ { 355,  3},
/*  90 */ { 358,  3},  /*  91 */ { 361,  3},  /*  92 */ { 364,  3},
/*  93 */ { 367,  4},  /*  94 */ { 371,  3},  /*  95 */ { 374,  4},
/*  96 */ { 378,  5},  /*  97 */ { 383,  3},  /*  98 */ { 386,  4},
/*  99 */ { 390,  6},  /* 100 */ { 396,  3},  /* 101 */ { 399,  3},
/* 102 */ { 402,  3},  /* 103 */ { 405,  3},  /* 104 */ { 408,  3},
/* 105 */ { 411,  4},  /* 106 */ { 415,  3},  /* 107 */ { 418,  5},
/* 108 */ { 423,  3},  /* 109 */ { 426,  5},  /* 110 */ { 431,  6},
/* 111 */ { 437,  6},  /* 112 */ { 443,  5},  /* 113 */ { 448,  4},
/* 114 */ { 452,  5},  /* 115 */ { 457,  3},  /* 116 */ { 460,  4},
/* 117 */ { 464,  6},  /* 118 */ { 470,  5},  /* 119 */ { 475,  4},
/* 120 */ { 479,  3},  /* 121 */ { 482,  5},  /* 122 */ { 487,  5},
/* 123 */ { 492,  3},  /* 124 */ { 495,  4},  /* 125 */ { 499,  5},
/* 126 */ { 504,  3},  /* 127 */ { 507,  4},  /* 128 */ { 511,  4},
/* 129 */ { 515,  7},  /* 130 */ { 522,  6},  /* 131 */ { 528,  5},
/* 132 */ { 533,  7},  /* 133 */ { 540,  4},  /* 134 */ { 544,  3},
/* 135 */ { 547,  3},  /* 136 */ { 550,  3},  /* 137 */ { 553,  3},
/* 138 */ { 556,  3},  /* 139 */ { 559,  4},  /* 140 */ { 563,  3},
/* 141 */ { 566,  5},  /* 142 */ { 571,  3},  /* 143 */ { 574,  4},
/* 144 */ { 578,  3},  /* 145 */ { 581,  5},  /* 146 */ { 586,  3},
/* 147 */ { 589,  4},  /* 148 */ { 593,  4},  /* 149 */ { 597,  7},
/* 150 */ { 604,  3},  /* 151 */ { 607,  3},  /* 152 */ { 610,  3},
/* 153 */ { 613,  3},  /* 154 */ { 616,  3},  /* 155 */ { 619,  3},
/* 156 */ { 622,  3},  /* 157 */ { 625,  5},  /* 158 */ { 630,  3},
/* 159 */ { 633,  6},  /* 160 */ { 639,  3},  /* 161 */ { 642,  5},
/* 162 */ { 647,  3},  /* 163 */ { 650,  6},  /* 164 */ { 656,  3},
/* 165 */ { 659,  7},  /* 166 */ { 666,  6},  /* 167 */ { 672,  5},
/* 168 */ { 677,  6},  /* 169 */ { 683,  6},  /* 170 */ { 689,  5},
/* 171 */ { 694,  6},  /* 172 */ { 700,  5},  /* 173 */ { 705,  7},
/* 174 */ { 712,  4},  /* 175 */ { 716,  3},  /* 176 */ { 719,  5},
/* 177 */ { 724,  6},  /* 178 */ { 730,  3},  /* 179 */ { 733,  7},
/* 180 */ { 740,  6},  /* 181 */ { 746,  7},  /* 182 */ { 753,  6},
/* 183 */ { 759,  6},  /* 184 */ { 765,  3},  /* 185 */ { 768,  3},
/* 186 */ { 771,  3},  /* 187 */ { 774,  3},  /* 188 */ { 777,  3},
/* 189 */ { 780,  3},  /* 190 */ { 783,  4},  /* 191 */ { 787,  3},
/* 192 */ { 790,  3},  /* 193 */ { 793,  3},  /* 194 */ { 796,  4},
/* 195 */ { 800,  3},  /* 196 */ { 803,  3},  /* 197 */ { 806,  3},
/* 198 */ { 809,  3},  /* 199 */ { 812,  5},  /* 200 */ { 817,  3},
/* 201 */ { 820,  4},  /* 202 */ { 824,  3},  /* 203 */ { 827,  4},
/* 204 */ { 831,  5},  /* 205 */ { 836,  6},  /* 206 */ { 842,  5},
/* 207 */ { 847,  6},  /* 208 */ { 853,  6},  /* 209 */ { 859,  5},
/* 210 */ { 864,  3},  /* 211 */ { 867,  3},  /* 212 */ { 870,  4},
/* 213 */ { 874,  3},  /* 214 */ { 877,  3},  /* 215 */ { 880,  3},
/* 216 */ { 883,  3},  /* 217 */ { 886,  5},  /* 218 */ { 891,  3},
/* 219 */ { 894,  3},  /* 220 */ { 897,  3},  /* 221 */ { 900,  3},
/* 222 */ { 903,  5},  /* 223 */ { 908,  3},  /* 224 */ { 911,  3},
/* 225 */ { 914,  3},  /* 226 */ { 917,  3},  /* 227 */ { 920,  3},
/* 228 */ { 923,  6},  /* 229 */ { 929,  3},  /* 230 */ { 932,  4},
/* 231 */ { 936,  3},  /* 232 */ { 939,  4},  /* 233 */ { 943,  4},
/* 234 */ { 947,  5},  /* 235 */ { 952,  3},  /* 236 */ { 955,  7},
/* 237 */ { 962,  5},  /* 238 */ { 967,  3},  /* 239 */ { 970,  7},
/* 240 */ { 977,  6},  /* 241 */ { 983,  3},  /* 242 */ { 986,  6},
/* 243 */ { 992,  4},  /* 244 */ { 996,  3},  /* 245 */ { 999,  4},
/* 246 */ {1003,  5},  /* 247 */ {1008,  6},  /* 248 */ {1014,  3},
/* 249 */ {1017,  4},  /* 250 */ {1021,  4},  /* 251 */ {1025,  4},
/* 252 */ {1029,  5},  /* 253 */ {1034,  3},  /* 254 */ {1037,  7},
/* 255 */ {1044,  5},  /* 256 */ {1049,  3},  /* 257 */ {1052,  5},
/* 258 */ {1057,  4},  /* 259 */ {1061,  5},  /* 260 */ {1066,  6},
/* 261 */ {1072,  7},  /* 262 */ {1079,  5},  /* 263 */ {1084,  4},
/* 264 */ {1088,  5},  /* 265 */ {1093,  6},  /* 266 */ {1099,  6},
/* 267 */ {1105,  5},  /* 268 */ {1110,  3},  /* 269 */ {1113,  5},
/* 270 */ {1118,  7},  /* 271 */ {1125,  6},  /* 272 */ {1131,  3},
/* 273 */ {1134,  6},  /* 274 */ {1140,  6},  /* 275 */ {1146,  7},
/* 276 */ {1153,  5},  /* 277 */ {1158,  4},  /* 278 */ {1162,  7},
/* 279 */ {1169,  6},  /* 280 */ {1175,  6},  /* 281 */ {1181,  3},
/* 282 */ {1184,  4},  /* 283 */ {1188,  3},  /* 284 */ {1191,  4},
/* 285 */ {1195,  3},  /* 286 */ {1198,  4},  /* 287 */ {1202,  4},
/* 288 */ {1206,  4},  /* 289 */ {1210,  5},  /* 290 */ {1215,  6},
/* 291 */ {1221,  3},  /* 292 */ {1224,  5},  /* 293 */ {1229,  7},
/* 294 */ {1236,  5},  /* 295 */ {1241,  3},  /* 296 */ {1244,  5},
/* 297 */ {1249,  6},  /* 298 */ {1255,  7},  /* 299 */ {1262,  4},
/* 300 */ {1266,  5},  /* 301 */ {1271,  5},  /* 302 */ {1276,  4},
/* 303 */ {1280,  5},  /* 304 */ {1285,  6},  /* 305 */ {1291,  3},
/* 306 */ {1294,  5},  /* 307 */ {1299,  7},  /* 308 */ {1306,  6},
/* 309 */ {1312,  5},  /* 310 */ {1317,  3},  /* 311 */ {1320,  6},
/* 312 */ {1326,  6},  /* 313 */ {1332,  6},  /* 314 */ {1338,  7},
/* 315 */ {1345,  7},  /* 316 */ {1352,  6},  /* 317 */ {1358,  5},
/* 318 */ {1363,  4},  /* 319 */ {1367,  6},  /* 320 */ {1373,  3},
/* 321 */ {1376,  5},  /* 322 */ {1381,  3},  /* 323 */ {1384,  5},
/* 324 */ {1389,  6},  /* 325 */ {1395,  7},  /* 326 */ {1402,  6},
/* 327 */ {1408,  7},  /* 328 */ {1415,  7},  /* 329 */ {1422,  6},
/* 330 */ {1428,  6},  /* 331 */ {1434,  3},  /* 332 */ {1437,  6},
/* 333 */ {1443,  5},  /* 334 */ {1448,  6},  /* 335 */ {1454,  5},
/* 336 */ {1459,  6},  /* 337 */ {1465,  4},  /* 338 */ {1469,  3},
/* 339 */ {1472,  4},  /* 340 */ {1476,  5},  /* 341 */ {1481,  5},
/* 342 */ {1486,  4},  /* 343 */ {1490,  5},  /* 344 */ {1495,  4},
/* 345 */ {1499,  6},  /* 346 */ {1505,  3},  /* 347 */ {1508,  5},
/* 348 */ {1513,  6},  /* 349 */ {1519,  4},  /* 350 */ {1523,  3},
/* 351 */ {1526,  4},  /* 352 */ {1530,  3},  /* 353 */ {1533,  3},
/* 354 */ {  -1, -1},  
};

#endif /* _CASES_H_ */
