// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;

// DIRECTIONS:
//    This file isn't very robust and makes several assumptions
//    It executes automatically when building the relevant hwintrinsic test projects
//
//    New tests can be generated from the template by adding an entry to the
//    appropriate Inputs array below.
//
//    You can support a new Isa by creating a new array and adding a new
//    "ProcessInputs" call at the bottom of the script.
//
//    There are currently four inputs expected in the following order
//    * projectName       - This should be '$(MSBuildProjectName)' and is used to filter which tests are being generated
//    * templateDirectory - This should be '$(MSBuildThisFileDirectory)Shared' and is used to locate the test templates
//    * outputDirectory   - This should be somewhere under the obj folder for the project and is where generated tests are written
//    * testListFileName  - This should likewise be somewhere under the obj folder and is where the list of generated tests is written

const string AlternatingBinOpTest_ValidationLogic = @"for (var i = 0; i < RetElementCount; i += 2)
            {
                if ({ValidateFirstResult} && (!mask.HasValue || ((left[i] != default) && result[i] != mask.Value)))
                {
                    succeeded = false;
                    break;
                }

                if ({ValidateRemainingResults} && (!mask.HasValue || ((left[i + 1] != default) && result[i + 1] != mask.Value)))
                {
                    succeeded = false;
                    break;
                }
            }";

const string AlternatingTernOpTest_ValidationLogic = @"for (var i = 0; i < RetElementCount; i += 2)
            {
                if ({ValidateFirstResult} && (!mask.HasValue || ((firstOp[0] != default) && result[0] != mask.Value)))
                {
                    succeeded = false;
                    break;
                }

                if ({ValidateRemainingResults} && (!mask.HasValue || ((firstOp[i] != default) && result[i] != mask.Value)))
                {
                    succeeded = false;
                    break;
                }
            }";


const string BooleanCmpTest_ValidationLogic = @"if ({ValidateFirstResult})
            {
                succeeded = false;
            }";

const string BooleanTwoCmpTest_ValidationLogic = @"var expectedResult1 = true;

            for (var i = 0; i < Op1ElementCount; i++)
            {
                expectedResult1 &= ({ValidateFirstResult});
            }

            var expectedResult2 = true;

            for (var i = 0; i < Op1ElementCount; i++)
            {
                expectedResult2 &= ({ValidateRemainingResults});
            }

            succeeded = (((expectedResult1 == false) && (expectedResult2 == false)) == result);";

const string BooleanOpTest_ValidationLogic = @"var expectedResult = true;

            for (var i = 0; i < Op1ElementCount; i++)
            {
                expectedResult &= ({ValidateFirstResult});
            }

            succeeded = (expectedResult == result);";

const string GaloisFieldMultiplyTest_ValidationLogic = @"static {RetBaseType} GaloisFieldMultiply({Op1BaseType} a, {Op1BaseType} b)
            {
                int ret = 0;
                for (int i = 0; i < 8; i++)
                {
                    if (((b >> i) & 1) != 0)
                    {
                        ret ^= a << i;
                    }
                }

                for (int i = 14; i >= 8; i--)
                {
                    if (((ret >> i) & 1) != 0)
                    {
                        ret ^= 0x11B << (i - 8);
                    }
                }

                return ({RetBaseType})ret;
            }

            if ({ValidateFirstResult} && (!mask.HasValue || ((left[0] != default) && result[0] != mask.Value)))
            {
                succeeded = false;
            }
            else
            {
                for (var i = 1; i < RetElementCount; i++)
                {
                    if ({ValidateRemainingResults} && (!mask.HasValue || ((left[i] != default) && result[i] != mask.Value)))
                    {
                        succeeded = false;
                        break;
                    }
                }
            }";

const string HorizontalOpTest_ValidationLogic = @"for (var outer = 0; outer < (LargestVectorSize / 16); outer++)
            {
                for (var inner = 0; inner < (8 / sizeof({RetBaseType})); inner++)
                {
                    var i1 = (outer * (16 / sizeof({RetBaseType}))) + inner;
                    var i2 = i1 + (8 / sizeof({RetBaseType}));
                    var i3 = (outer * (16 / sizeof({RetBaseType}))) + (inner * 2);

                    if ({ValidateFirstResult} && (!mask.HasValue || ((left[i1] != default) && result[i1] != mask.Value)))
                    {
                        succeeded = false;
                        break;
                    }

                    if ({ValidateRemainingResults} && (!mask.HasValue || ((left[i2] != default) && result[i2] != mask.Value)))
                    {
                        succeeded = false;
                        break;
                    }
                }
            }";

const string MultiShiftTest_ValidationLogic = @"static {RetBaseType} MultiShift({Op1BaseType}[] left, {Op2BaseType}[] right, int index)
            {
                int i = index / 8;
                int j = index % 8;

                {RetBaseType} result = 0;
                {Op2BaseType} tcur = right[i];

                {Op1BaseType} ctrl = ({Op1BaseType})(left[(i * 8) + j] & 0x3F);

                for (int k = 0; k < 8; k++)
                {
                    result |= ({RetBaseType})(((tcur >>> ((ctrl + k) & 0x3F)) & 1) << k);
                }

                return result;
            }

            if ({ValidateFirstResult} && (!mask.HasValue || ((left[0] != default) && result[0] != mask.Value)))
            {
                succeeded = false;
            }
            else
            {
                for (var i = 1; i < RetElementCount; i++)
                {
                    if ({ValidateRemainingResults} && (!mask.HasValue || ((left[i] != default) && result[i] != mask.Value)))
                    {
                        succeeded = false;
                        break;
                    }
                }
            }";

const string SimpleUnOpTest_ValidationLogic = @"if ({ValidateFirstResult} && (!mask.HasValue || ((firstOp[0] != default) && result[0] != mask.Value)))
            {
                succeeded = false;
            }
            else
            {
                for (var i = 1; i < RetElementCount; i++)
                {
                    if ({ValidateRemainingResults} && (!mask.HasValue || ((firstOp[i] != default) && result[i] != mask.Value)))
                    {
                        succeeded = false;
                        break;
                    }
                }
            }";

const string SimpleBinOpTest_ValidationLogic = @"if ({ValidateFirstResult} && (!mask.HasValue || ((left[0] != default) && result[0] != mask.Value)))
            {
                succeeded = false;
            }
            else
            {
                for (var i = 1; i < RetElementCount; i++)
                {
                    if ({ValidateRemainingResults} && (!mask.HasValue || ((left[i] != default) && result[i] != mask.Value)))
                    {
                        succeeded = false;
                        break;
                    }
                }
            }";

const string SimpleTernOpTest_ValidationLogic = @"if ({ValidateFirstResult} && (!mask.HasValue || ((firstOp[0] != default) && result[0] != mask.Value)))
            {
                succeeded = false;
            }
            else
            {
                for (var i = 1; i < RetElementCount; i++)
                {
                    if ({ValidateRemainingResults} && (!mask.HasValue || ((firstOp[i] != default) && result[i] != mask.Value)))
                    {
                        succeeded = false;
                        break;
                    }
                }
            }";

(string templateFileName, string outputTemplateName, Dictionary<string, string> templateData)[] Templates = new[]
{
    ("_BinaryOpTestTemplate.template",        "AlternatingBinOpTest.template",  new Dictionary<string, string> { ["TemplateName"] = "Alternating", ["TemplateValidationLogic"] = AlternatingBinOpTest_ValidationLogic }),
    ("_BinaryOpTestTemplate.template",        "GfniMultiplyTest.template",      new Dictionary<string, string> { ["TemplateName"] = "GfniMultiply",["TemplateValidationLogic"] = GaloisFieldMultiplyTest_ValidationLogic }),
    ("_BinaryOpTestTemplate.template",        "HorizontalBinOpTest.template",   new Dictionary<string, string> { ["TemplateName"] = "Horizontal",  ["TemplateValidationLogic"] = HorizontalOpTest_ValidationLogic }),
    ("_BinaryOpTestTemplate.template",        "SimpleBinOpTest.template",       new Dictionary<string, string> { ["TemplateName"] = "Simple",      ["TemplateValidationLogic"] = SimpleBinOpTest_ValidationLogic }),
    ("_BooleanBinaryOpTestTemplate.template", "BooleanBinOpTest.template",      new Dictionary<string, string> { ["TemplateName"] = "Boolean",     ["TemplateValidationLogic"] = BooleanOpTest_ValidationLogic }),
    ("_BooleanBinaryOpTestTemplate.template", "BooleanCmpOpTest.template",      new Dictionary<string, string> { ["TemplateName"] = "Boolean",     ["TemplateValidationLogic"] = BooleanCmpTest_ValidationLogic }),
    ("_BooleanBinaryOpTestTemplate.template", "BooleanTwoCmpOpTest.template",   new Dictionary<string, string> { ["TemplateName"] = "Boolean",     ["TemplateValidationLogic"] = BooleanTwoCmpTest_ValidationLogic }),
    ("_BooleanUnaryOpTestTemplate.template",  "BooleanUnOpTest.template",       new Dictionary<string, string> { ["TemplateName"] = "Boolean",     ["TemplateValidationLogic"] = BooleanOpTest_ValidationLogic }),
    ("_BinaryOpTestTemplate.template",        "MultiShiftTest.template",        new Dictionary<string, string> { ["TemplateName"] = "MultiShift",  ["TemplateValidationLogic"] = MultiShiftTest_ValidationLogic }),
    ("_TernaryOpTestTemplate.template",       "AlternatingTernOpTest.template", new Dictionary<string, string> { ["TemplateName"] = "Alternating", ["TemplateValidationLogic"] = AlternatingTernOpTest_ValidationLogic }),
    ("_TernaryOpTestTemplate.template",       "SimpleTernOpTest.template",      new Dictionary<string, string> { ["TemplateName"] = "Simple",      ["TemplateValidationLogic"] = SimpleTernOpTest_ValidationLogic }),
    ("_UnaryOpTestTemplate.template",         "SimpleUnOpTest.template",        new Dictionary<string, string> { ["TemplateName"] = "Simple",      ["TemplateValidationLogic"] = SimpleUnOpTest_ValidationLogic }),
};

(string templateFileName, Dictionary<string, string> templateData)[] Sse1Inputs = new []
{
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "Add",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] + right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i] + right[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "AddScalar",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] + right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "And",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "(BitConverter.SingleToInt32Bits(left[0]) & BitConverter.SingleToInt32Bits(right[0])) != BitConverter.SingleToInt32Bits(result[0])",  ["ValidateRemainingResults"] = "(BitConverter.SingleToInt32Bits(left[0]) & BitConverter.SingleToInt32Bits(right[0])) != BitConverter.SingleToInt32Bits(result[0])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "AndNot",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "(~BitConverter.SingleToInt32Bits(left[0]) & BitConverter.SingleToInt32Bits(right[0])) != BitConverter.SingleToInt32Bits(result[0])", ["ValidateRemainingResults"] = "(~BitConverter.SingleToInt32Bits(left[0]) & BitConverter.SingleToInt32Bits(right[0])) != BitConverter.SingleToInt32Bits(result[0])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareEqual",                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] == right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] == right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarEqual",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] == right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("BooleanCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarOrderedEqual",                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "(left[0] == right[0]) != result"}),
    ("BooleanCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarUnorderedEqual",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "(left[0] == right[0]) != result"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareGreaterThan",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] > right[0]) ? -1 : 0)",                                                       ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] > right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarGreaterThan",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] > right[0]) ? -1 : 0)",                                                       ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("BooleanCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarOrderedGreaterThan",          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "(left[0] > right[0]) != result"}),
    ("BooleanCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarUnorderedGreaterThan",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "(left[0] > right[0]) != result"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareGreaterThanOrEqual",                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] >= right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] >= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarGreaterThanOrEqual",          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] >= right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("BooleanCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarOrderedGreaterThanOrEqual",   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "(left[0] >= right[0]) != result"}),
    ("BooleanCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarUnorderedGreaterThanOrEqual", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "(left[0] >= right[0]) != result"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareLessThan",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] < right[0]) ? -1 : 0)",                                                       ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] < right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarLessThan",                    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] < right[0]) ? -1 : 0)",                                                       ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("BooleanCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarOrderedLessThan",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "(left[0] < right[0]) != result"}),
    ("BooleanCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarUnorderedLessThan",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "(left[0] < right[0]) != result"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareLessThanOrEqual",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] <= right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] <= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarLessThanOrEqual",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] <= right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("BooleanCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarOrderedLessThanOrEqual",      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "(left[0] <= right[0]) != result"}),
    ("BooleanCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarUnorderedLessThanOrEqual",    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "(left[0] <= right[0]) != result"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareNotEqual",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] != right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] != right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarNotEqual",                    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] != right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("BooleanCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarOrderedNotEqual",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "(left[0] != right[0]) != result"}),
    ("BooleanCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarUnorderedNotEqual",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "(left[0] != right[0]) != result"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareNotGreaterThan",                    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (!(left[0] > right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (!(left[i] > right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarNotGreaterThan",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (!(left[0] > right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareNotGreaterThanOrEqual",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (!(left[0] >= right[0]) ? -1 : 0)",                                                     ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (!(left[i] >= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarNotGreaterThanOrEqual",       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (!(left[0] >= right[0]) ? -1 : 0)",                                                     ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareNotLessThan",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (!(left[0] < right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (!(left[i] < right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarNotLessThan",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (!(left[0] < right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareNotLessThanOrEqual",                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (!(left[0] <= right[0]) ? -1 : 0)",                                                     ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (!(left[i] <= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarNotLessThanOrEqual",          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (!(left[0] <= right[0]) ? -1 : 0)",                                                     ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareOrdered",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((!float.IsNaN(left[0]) && !float.IsNaN(right[0])) ? -1 : 0)",                          ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((!float.IsNaN(left[i]) && !float.IsNaN(right[i])) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarOrdered",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((!float.IsNaN(left[0]) && !float.IsNaN(right[0])) ? -1 : 0)",                          ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareUnordered",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((float.IsNaN(left[0]) || float.IsNaN(right[0])) ? -1 : 0)",                            ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((float.IsNaN(left[i]) || float.IsNaN(right[i])) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "CompareScalarUnordered",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((float.IsNaN(left[0]) || float.IsNaN(right[0])) ? -1 : 0)",                            ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpConvTest.template",new Dictionary<string, string>{["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "ConvertScalarToVector128Single",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single",                                  ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "(float)right != result[0]"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "Divide",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] / right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i] / right[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "DivideScalar",                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] / right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("LoadUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse",                      ["Method"] = "LoadVector128",                            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                         ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[0])",                                            ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(firstOp[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("LoadUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse",                      ["Method"] = "LoadScalarVector128",                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                         ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[0])",                                            ["ValidateRemainingResults"] = "0 != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "Max",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(Math.Max(left[0], right[0])) != BitConverter.SingleToInt32Bits(result[0])",                           ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(Math.Max(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "MaxScalar",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(Math.Max(left[0], right[0])) != BitConverter.SingleToInt32Bits(result[0])",                           ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "Min",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(Math.Min(left[0], right[0])) != BitConverter.SingleToInt32Bits(result[0])",                           ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(Math.Min(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "MinScalar",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(Math.Min(left[0], right[0])) != BitConverter.SingleToInt32Bits(result[0])",                           ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimdScalarUnOpConvTest.template", new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "MoveMask",                                                            ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                         ["ValidateFirstResult"] = "(uint)result != SseVerify.MoveMask(firstOp)"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "Multiply",                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] * right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i] * right[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "MultiplyScalar",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] * right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "Or",                                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "(BitConverter.SingleToInt32Bits(left[0]) | BitConverter.SingleToInt32Bits(right[0])) != BitConverter.SingleToInt32Bits(result[0])",  ["ValidateRemainingResults"] = "(BitConverter.SingleToInt32Bits(left[0]) | BitConverter.SingleToInt32Bits(right[0])) != BitConverter.SingleToInt32Bits(result[0])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "Subtract",                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] - right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i] - right[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "SubtractScalar",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] - right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse", ["LoadIsa"] = "Sse", ["Method"] = "Xor",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] =  "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "(BitConverter.SingleToInt32Bits(left[0]) ^ BitConverter.SingleToInt32Bits(right[0])) != BitConverter.SingleToInt32Bits(result[0])",  ["ValidateRemainingResults"] = "(BitConverter.SingleToInt32Bits(left[0]) ^ BitConverter.SingleToInt32Bits(right[0])) != BitConverter.SingleToInt32Bits(result[0])"}),
};

(string templateFileName, Dictionary<string, string> templateData)[] Sse1X64Inputs = new []
{
    ("SimdScalarUnOpConvTest.template", new Dictionary<string, string> { ["Isa"] = "Sse.X64", ["LoadIsa"] = "Sse", ["Method"] = "ConvertToInt64",                                                  ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                          ["ValidateFirstResult"] = "(long)Math.Round(firstOp[0]) != result"}),
    ("SimdScalarUnOpConvTest.template", new Dictionary<string, string> { ["Isa"] = "Sse.X64", ["LoadIsa"] = "Sse", ["Method"] = "ConvertToInt64WithTruncation",                                    ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                          ["ValidateFirstResult"] = "(long) firstOp[0] != result"}),
    ("SimpleBinOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse.X64", ["LoadIsa"] = "Sse", ["Method"] = "ConvertScalarToVector128Single", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                    ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",   ["ValidateFirstResult"] = "(float)right != result[0]"}),
};

(string templateFileName, Dictionary<string, string> templateData)[] Sse2Inputs = new []
{
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Add",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] + right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i] + right[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Add",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "(byte)(left[0] + right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(byte)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Add",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "(short)(left[0] + right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(short)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Add",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "(int)(left[0] + right[0]) != result[0]",                                                                                             ["ValidateRemainingResults"] = "(int)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Add",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "(long)(left[0] + right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(long)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Add",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "(sbyte)(left[0] + right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(sbyte)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Add",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "(ushort)(left[0] + right[0]) != result[0]",                                                                                          ["ValidateRemainingResults"] = "(ushort)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Add",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "(uint)(left[0] + right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(uint)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Add",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "(ulong)(left[0] + right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(ulong)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AddSaturate",                              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "SseVerify.AddSaturate(left[0], right[0], result[0])",                                                                                ["ValidateRemainingResults"] = "SseVerify.AddSaturate(left[i], right[i], result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AddSaturate",                              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "SseVerify.AddSaturate(left[0], right[0], result[0])",                                                                                ["ValidateRemainingResults"] = "SseVerify.AddSaturate(left[i], right[i], result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AddSaturate",                              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "SseVerify.AddSaturate(left[0], right[0], result[0])",                                                                                ["ValidateRemainingResults"] = "SseVerify.AddSaturate(left[i], right[i], result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AddSaturate",                              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "SseVerify.AddSaturate(left[0], right[0], result[0])",                                                                                ["ValidateRemainingResults"] = "SseVerify.AddSaturate(left[i], right[i], result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AddScalar",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] + right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "And",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "(BitConverter.DoubleToInt64Bits(left[0]) & BitConverter.DoubleToInt64Bits(right[0])) != BitConverter.DoubleToInt64Bits(result[0])",  ["ValidateRemainingResults"] = "(BitConverter.DoubleToInt64Bits(left[i]) & BitConverter.DoubleToInt64Bits(right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "And",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "(byte)(left[0] & right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(byte)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "And",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "(short)(left[0] & right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(short)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "And",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "(int)(left[0] & right[0]) != result[0]",                                                                                             ["ValidateRemainingResults"] = "(int)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "And",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "(long)(left[0] & right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(long)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "And",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "(sbyte)(left[0] & right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(sbyte)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "And",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "(ushort)(left[0] & right[0]) != result[0]",                                                                                          ["ValidateRemainingResults"] = "(ushort)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "And",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "(uint)(left[0] & right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(uint)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "And",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "(ulong)(left[0] & right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(ulong)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AndNot",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "(~BitConverter.DoubleToInt64Bits(left[0]) & BitConverter.DoubleToInt64Bits(right[0])) != BitConverter.DoubleToInt64Bits(result[0])", ["ValidateRemainingResults"] = "(~BitConverter.DoubleToInt64Bits(left[i]) & BitConverter.DoubleToInt64Bits(right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AndNot",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "(byte)(~left[0] & right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(byte)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AndNot",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "(short)(~left[0] & right[0]) != result[0]",                                                                                          ["ValidateRemainingResults"] = "(short)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AndNot",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "(int)(~left[0] & right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(int)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AndNot",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "(long)(~left[0] & right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(long)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AndNot",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "(sbyte)(~left[0] & right[0]) != result[0]",                                                                                          ["ValidateRemainingResults"] = "(sbyte)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AndNot",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "(ushort)(~left[0] & right[0]) != result[0]",                                                                                         ["ValidateRemainingResults"] = "(ushort)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AndNot",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "(uint)(~left[0] & right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(uint)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "AndNot",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "(ulong)(~left[0] & right[0]) != result[0]",                                                                                          ["ValidateRemainingResults"] = "(ulong)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Average",                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "(byte)((left[0] + right[0] + 1) >> 1) != result[0]",                                                                                 ["ValidateRemainingResults"] = "(byte)((left[i] + right[i] + 1) >> 1) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Average",                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "(ushort)((left[0] + right[0] + 1) >> 1) != result[0]",                                                                               ["ValidateRemainingResults"] = "(ushort)((left[i] + right[i] + 1) >> 1) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareEqual",                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] == right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] == right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareEqual",                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((byte)(-1)) : 0)",                                                                   ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((byte)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareEqual",                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((short)(-1)) : 0)",                                                                  ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((short)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareEqual",                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((int)(-1)) : 0)",                                                                    ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((int)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareEqual",                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((sbyte)(-1)) : 0)",                                                                  ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((sbyte)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareEqual",                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((ushort)(-1)) : 0)",                                                                 ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((ushort)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareEqual",                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((uint)(-1)) : 0)",                                                                   ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((uint)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarEqual",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] == right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("BooleanCmpOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarOrderedEqual",                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean",["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "(left[0] == right[0]) != result"}),
    ("BooleanCmpOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarUnorderedEqual",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean",["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "(left[0] == right[0]) != result"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareGreaterThan",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] > right[0]) ? -1 : 0)",                                                       ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] > right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareGreaterThan",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? unchecked((short)(-1)) : 0)",                                                                   ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? unchecked((short)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareGreaterThan",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? unchecked((int)(-1)) : 0)",                                                                     ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? unchecked((int)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareGreaterThan",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? unchecked((sbyte)(-1)) : 0)",                                                                   ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? unchecked((sbyte)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarGreaterThan",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] > right[0]) ? -1 : 0)",                                                       ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("BooleanCmpOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarOrderedGreaterThan",          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean",["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "(left[0] > right[0]) != result"}),
    ("BooleanCmpOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarUnorderedGreaterThan",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean",["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "(left[0] > right[0]) != result"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareGreaterThanOrEqual",                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] >= right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] >= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarGreaterThanOrEqual",          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] >= right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("BooleanCmpOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarOrderedGreaterThanOrEqual",   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean",["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "(left[0] >= right[0]) != result"}),
    ("BooleanCmpOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarUnorderedGreaterThanOrEqual", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean",["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "(left[0] >= right[0]) != result"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareLessThan",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] < right[0]) ? -1 : 0)",                                                       ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] < right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareLessThan",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? unchecked((short)(-1)) : 0)",                                                                   ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? unchecked((short)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareLessThan",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? unchecked((int)(-1)) : 0)",                                                                     ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? unchecked((int)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareLessThan",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? unchecked((sbyte)(-1)) : 0)",                                                                   ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? unchecked((sbyte)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarLessThan",                    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] < right[0]) ? -1 : 0)",                                                       ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("BooleanCmpOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarOrderedLessThan",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean",["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "(left[0] < right[0]) != result"}),
    ("BooleanCmpOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarUnorderedLessThan",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean",["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "(left[0] < right[0]) != result"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareLessThanOrEqual",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] <= right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] <= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarLessThanOrEqual",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] <= right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("BooleanCmpOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarOrderedLessThanOrEqual",      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean",["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "(left[0] <= right[0]) != result"}),
    ("BooleanCmpOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarUnorderedLessThanOrEqual",    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean",["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "(left[0] <= right[0]) != result"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareNotEqual",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] != right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] != right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarNotEqual",                    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] != right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("BooleanCmpOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarOrderedNotEqual",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean",["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "(left[0] != right[0]) != result"}),
    ("BooleanCmpOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarUnorderedNotEqual",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Boolean",["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "(left[0] != right[0]) != result"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareNotGreaterThan",                    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (!(left[0] > right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (!(left[i] > right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarNotGreaterThan",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (!(left[0] > right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareNotGreaterThanOrEqual",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (!(left[0] >= right[0]) ? -1 : 0)",                                                     ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (!(left[i] >= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarNotGreaterThanOrEqual",       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (!(left[0] >= right[0]) ? -1 : 0)",                                                     ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareNotLessThan",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (!(left[0] < right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (!(left[i] < right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarNotLessThan",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (!(left[0] < right[0]) ? -1 : 0)",                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareNotLessThanOrEqual",                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (!(left[0] <= right[0]) ? -1 : 0)",                                                     ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (!(left[i] <= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarNotLessThanOrEqual",          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (!(left[0] <= right[0]) ? -1 : 0)",                                                     ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareOrdered",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((!double.IsNaN(left[0]) && !double.IsNaN(right[0])) ? -1 : 0)",                        ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((!double.IsNaN(left[i]) && !double.IsNaN(right[i])) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarOrdered",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((!double.IsNaN(left[0]) && !double.IsNaN(right[0])) ? -1 : 0)",                        ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareUnordered",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((double.IsNaN(left[0]) || double.IsNaN(right[0])) ? -1 : 0)",                          ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((double.IsNaN(left[i]) || double.IsNaN(right[i])) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "CompareScalarUnordered",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((double.IsNaN(left[0]) || double.IsNaN(right[0])) ? -1 : 0)",                          ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimdScalarUnOpConvTest.template", new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertToInt32",                                                            ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                         ["ValidateFirstResult"] = "(int)Math.Round(firstOp[0]) != result"}),
    ("SimdScalarUnOpConvTest.template", new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertToInt32",                                                            ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result"}),
    ("SimdScalarUnOpConvTest.template", new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertToInt32WithTruncation",                                              ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                         ["ValidateFirstResult"] = "(int) firstOp[0] != result"}),
    ("SimdScalarUnOpConvTest.template", new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertToUInt32",                                                           ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                         ["ValidateFirstResult"] = "firstOp[0] != result"}),
    ("SimpleUnOpConvTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertToVector128Double",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                         ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(firstOp[0])",                                            ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(firstOp[i])"}),
    ("SimpleUnOpConvTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertToVector128Double",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                          ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(firstOp[0])",                                            ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i & 1]) != BitConverter.DoubleToInt64Bits(firstOp[i & 1])"}),
    ("SimpleUnOpConvTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertToVector128Int32",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                         ["ValidateFirstResult"] = "result[0] != (int)Math.Round(firstOp[0])",                                                                                           ["ValidateRemainingResults"] = "result[i] != ((i < 2) ? (int)Math.Round(firstOp[i]) : 0)"}),
    ("SimpleUnOpConvTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertToVector128Int32",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                         ["ValidateFirstResult"] = "result[0] != (int)MathF.Round(firstOp[0])",                                                                                          ["ValidateRemainingResults"] = "result[i] != (int) MathF.Round(firstOp[i], 0)"}),
    ("SimpleUnOpConvTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertToVector128Int32WithTruncation",    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                         ["ValidateFirstResult"] = "result[0] != (int)firstOp[0]",                                                                                                       ["ValidateRemainingResults"] = "result[i] != ((i < 2) ? (int)firstOp[i] : 0)"}),
    ("SimpleUnOpConvTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertToVector128Int32WithTruncation",    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                         ["ValidateFirstResult"] = "result[0] != (int)firstOp[0]",                                                                                                       ["ValidateRemainingResults"] = "result[i] != (int)firstOp[i]"}),
    ("SimpleUnOpConvTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertToVector128Single",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                         ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits((float)firstOp[0])",                                     ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((i < 2) ? BitConverter.SingleToInt32Bits((float)firstOp[i]) : 0)"}),
    ("SimpleUnOpConvTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertToVector128Single",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                          ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits((float)firstOp[0])",                                     ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits((float)firstOp[i])"}),
    ("SimpleBinOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertScalarToVector128Double",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                  ["Op2BaseType"] = "Int32",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "(double)right != result[0]"}),
    ("ScalarSimdUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertScalarToVector128Int32",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",                                   ["Op1BaseType"] = "Int32",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                          ["ValidateFirstResult"] = "firstOp != result[0]",                                                                                                               ["ValidateRemainingResults"] = "false"}),
    ("ScalarSimdUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertScalarToVector128UInt32",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",                                  ["Op1BaseType"] = "UInt32",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                         ["ValidateFirstResult"] = "firstOp != result[0]",                                                                                                               ["ValidateRemainingResults"] = "false"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Divide",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] / right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i] / right[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "DivideScalar",                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] / right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("ExtractScalarTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                         ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                      ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                         ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("InsertScalarTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                               ["Data"] = "(short)2",  ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)0",                                                                                  ["ValidateFirstResult"] = "(i == 1 ? result[i] != scalarData : result[i] != 0)"}),
    ("InsertScalarTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                              ["Data"] = "(ushort)2", ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ushort)0",                                                                                 ["ValidateFirstResult"] = "(i == 1 ? result[i] != scalarData : result[i] != 0)"}),
    ("InsertScalarTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                               ["Data"] = "(short)2",  ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)0",                                                                                  ["ValidateFirstResult"] = "(i == 1 ? result[i] != scalarData : result[i] != 0)"}),
    ("InsertScalarTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                              ["Data"] = "(ushort)2", ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ushort)0",                                                                                 ["ValidateFirstResult"] = "(i == 1 ? result[i] != scalarData : result[i] != 0)"}),
    ("LoadUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Sse2",                       ["Method"] = "LoadVector128",                            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                         ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(firstOp[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                            ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(firstOp[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("LoadUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Sse2",                       ["Method"] = "LoadVector128",                            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",                                                                                                         ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                           ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "firstOp[i] != result[i]"}),
    ("LoadUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Sse2",                       ["Method"] = "LoadVector128",                            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "firstOp[i] != result[i]"}),
    ("LoadUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Sse2",                       ["Method"] = "LoadVector128",                            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "firstOp[i] != result[i]"}),
    ("LoadUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Sse2",                       ["Method"] = "LoadVector128",                            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                         ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "firstOp[i] != result[i]"}),
    ("LoadUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Sse2",                       ["Method"] = "LoadVector128",                            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "firstOp[i] != result[i]"}),
    ("LoadUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Sse2",                       ["Method"] = "LoadVector128",                            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                         ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "firstOp[i] != result[i]"}),
    ("LoadUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Sse2",                       ["Method"] = "LoadVector128",                            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "firstOp[i] != result[i]"}),
    ("LoadUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Sse2",                       ["Method"] = "LoadVector128",                            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                         ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "firstOp[i] != result[i]"}),
    ("LoadUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Sse2",                       ["Method"] = "LoadScalarVector128",                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                         ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(firstOp[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                            ["ValidateRemainingResults"] = "0 != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("LoadUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Sse2",                       ["Method"] = "LoadScalarVector128",                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("LoadUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Sse2",                       ["Method"] = "LoadScalarVector128",                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                         ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("LoadUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Sse2",                       ["Method"] = "LoadScalarVector128",                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("LoadUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Sse2",                       ["Method"] = "LoadScalarVector128",                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                         ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Max",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Math.Max(left[0], right[0])) != BitConverter.DoubleToInt64Bits(result[0])",                           ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(Math.Max(left[i], right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Max",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "Math.Max(left[0], right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "Math.Max(left[i], right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Max",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "Math.Max(left[0], right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "Math.Max(left[i], right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "MaxScalar",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Math.Max(left[0], right[0])) != BitConverter.DoubleToInt64Bits(result[0])",                           ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Min",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Math.Min(left[0], right[0])) != BitConverter.DoubleToInt64Bits(result[0])",                           ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(Math.Min(left[i], right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Min",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "Math.Min(left[0], right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "Math.Min(left[i], right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Min",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "Math.Min(left[0], right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "Math.Min(left[i], right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "MinScalar",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Math.Min(left[0], right[0])) != BitConverter.DoubleToInt64Bits(result[0])",                           ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Multiply",                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] * right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i] * right[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "MultiplyScalar",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] * right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "MultiplyAddAdjacent",                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != Math.Clamp(((right[1] * left[1]) + (right[0] * left[0])), int.MinValue, int.MaxValue)",                                 ["ValidateRemainingResults"] = "result[i] != Math.Clamp(((right[(i * 2) + 1] * left[(i * 2) + 1]) + (right[i * 2] * left[i * 2])), int.MinValue, int.MaxValue)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "MultiplyLow",                              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != BitConverter.ToInt16(BitConverter.GetBytes(((int)(left[0])) * right[0]), 0)",                                           ["ValidateRemainingResults"] = "result[i] != BitConverter.ToInt16(BitConverter.GetBytes(((int)(left[i])) * right[i]), 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "MultiplyLow",                              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != BitConverter.ToUInt16(BitConverter.GetBytes(((uint)(left[0])) * right[0]), 0)",                                         ["ValidateRemainingResults"] = "result[i] != BitConverter.ToUInt16(BitConverter.GetBytes(((uint)(left[i])) * right[i]), 0)"}),
    ("SimdScalarUnOpConvTest.template", new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "MoveMask",                                                                  ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",                                                                                                         ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                           ["ValidateFirstResult"] = "(uint)result != SseVerify.MoveMask(firstOp)"}),
    ("SimdScalarUnOpConvTest.template", new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "MoveMask",                                                                  ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                          ["ValidateFirstResult"] = "(uint)result != SseVerify.MoveMask(firstOp)"}),
    ("SimdScalarUnOpConvTest.template", new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "MoveMask",                                                                  ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                         ["ValidateFirstResult"] = "(uint)result != SseVerify.MoveMask(firstOp)"}),
    ("SimpleUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "MoveScalar",                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                          ["ValidateFirstResult"] = "result[0] != result[0]",                                                                                                             ["ValidateRemainingResults"] = "result[i] != ((i == 0) ? result[i] : 0)"}),
    ("SimpleUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "MoveScalar",                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                         ["ValidateFirstResult"] = "result[0] != result[0]",                                                                                                             ["ValidateRemainingResults"] = "result[i] != ((i == 0) ? result[i] : 0)"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Or",                                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "(BitConverter.DoubleToInt64Bits(left[0]) | BitConverter.DoubleToInt64Bits(right[0])) != BitConverter.DoubleToInt64Bits(result[0])",  ["ValidateRemainingResults"] = "(BitConverter.DoubleToInt64Bits(left[i]) | BitConverter.DoubleToInt64Bits(right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Or",                                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "(byte)(left[0] | right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(byte)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Or",                                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "(short)(left[0] | right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(short)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Or",                                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "(int)(left[0] | right[0]) != result[0]",                                                                                             ["ValidateRemainingResults"] = "(int)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Or",                                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "(long)(left[0] | right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(long)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Or",                                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "(sbyte)(left[0] | right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(sbyte)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Or",                                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "(ushort)(left[0] | right[0]) != result[0]",                                                                                          ["ValidateRemainingResults"] = "(ushort)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Or",                                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "(uint)(left[0] | right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(uint)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Or",                                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "(ulong)(left[0] | right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(ulong)(left[i] | right[i]) != result[i]"}),
    ("ComplexBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "PackSignedSaturate",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (short)Math.Min(Math.Max(left[0], short.MinValue), short.MaxValue)",                                                    ["ValidateRemainingResults"] = "result[i] != ((i < 4) ? (short)Math.Min(Math.Max(left[i], short.MinValue), short.MaxValue) : (short)Math.Min(Math.Max(right[i&3], short.MinValue), short.MaxValue))"}),
    ("ComplexBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "PackSignedSaturate",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (sbyte)Math.Min(Math.Max(left[0], sbyte.MinValue), sbyte.MaxValue)",                                                    ["ValidateRemainingResults"] = "result[i] != ((i < 8) ? (sbyte)Math.Min(Math.Max(left[i], sbyte.MinValue), sbyte.MaxValue) : (sbyte)Math.Min(Math.Max(right[i&7], sbyte.MinValue), sbyte.MaxValue))"}),
    ("ComplexBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "PackUnsignedSaturate",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != (byte)Math.Min(Math.Max(left[0], byte.MinValue), byte.MaxValue)",                                                       ["ValidateRemainingResults"] = "result[i] != ((i < 8) ? (byte)Math.Min(Math.Max(left[i], byte.MinValue), byte.MaxValue) : (byte)Math.Min(Math.Max(right[i&7], byte.MinValue), byte.MaxValue))"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                          ["ValidateFirstResult"] = "(short)(firstOp[0] << 1) != result[0]",                                                                                              ["ValidateRemainingResults"] = "(short)(firstOp[i] << 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                         ["ValidateFirstResult"] = "(ushort)(firstOp[0] << 1) != result[0]",                                                                                             ["ValidateRemainingResults"] = "(ushort)(firstOp[i] << 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                          ["ValidateFirstResult"] = "(int)(firstOp[0] << 1) != result[0]",                                                                                                ["ValidateRemainingResults"] = "(int)(firstOp[i] << 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                         ["ValidateFirstResult"] = "(uint)(firstOp[0] << 1) != result[0]",                                                                                               ["ValidateRemainingResults"] = "(uint)(firstOp[i] << 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                          ["ValidateFirstResult"] = "(long)(firstOp[0] << 1) != result[0]",                                                                                               ["ValidateRemainingResults"] = "(long)(firstOp[i] << 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                         ["ValidateFirstResult"] = "(ulong)(firstOp[0] << 1) != result[0]",                                                                                              ["ValidateRemainingResults"] = "(ulong)(firstOp[i] << 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                       ["Imm"] = "16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                          ["ValidateFirstResult"] = "0 != result[0]",                                                                                                                     ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                      ["Imm"] = "16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                         ["ValidateFirstResult"] = "0 != result[0]",                                                                                                                     ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                       ["Imm"] = "32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                          ["ValidateFirstResult"] = "0 != result[0]",                                                                                                                     ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                      ["Imm"] = "32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                         ["ValidateFirstResult"] = "0 != result[0]",                                                                                                                     ["ValidateRemainingResults"] = "0!= result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                       ["Imm"] = "64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                          ["ValidateFirstResult"] = "0 != result[0]",                                                                                                                     ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                                      ["Imm"] = "64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                         ["ValidateFirstResult"] = "0 != result[0]",                                                                                                                     ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical128BitLane",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(sbyte)8",                                                                                  ["ValidateFirstResult"] = "result[0] != 0",                                                                                                                     ["ValidateRemainingResults"] =  "result[i] != 8"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical128BitLane",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",                                                                                        ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(byte)8",                                                                                   ["ValidateFirstResult"] = "result[0] != 0",                                                                                                                     ["ValidateRemainingResults"] =  "result[i] != 8"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical128BitLane",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)8",                                                                                  ["ValidateFirstResult"] = "result[0] != 2048",                                                                                                                  ["ValidateRemainingResults"] =  "result[i] != 2048"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical128BitLane",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ushort)8",                                                                                 ["ValidateFirstResult"] = "result[0] != 2048",                                                                                                                  ["ValidateRemainingResults"] =  "result[i] != 2048"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical128BitLane",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)8",                                                                                    ["ValidateFirstResult"] = "result[0] != 2048",                                                                                                                  ["ValidateRemainingResults"] =  "result[i] != 2048"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical128BitLane",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(uint)8",                                                                                   ["ValidateFirstResult"] = "result[0] != 2048",                                                                                                                  ["ValidateRemainingResults"] =  "result[i] != 2048"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical128BitLane",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(long)8",                                                                                   ["ValidateFirstResult"] = "result[0] != 2048",                                                                                                                  ["ValidateRemainingResults"] =  "result[i] != 2048"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftLeftLogical128BitLane",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ulong)8",                                                                                  ["ValidateFirstResult"] = "result[0] != 2048",                                                                                                                  ["ValidateRemainingResults"] =  "result[i] != 2048"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightArithmetic",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                          ["ValidateFirstResult"] = "(short)(firstOp[0] >> 1) != result[0]",                                                                                              ["ValidateRemainingResults"] = "(short)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightArithmetic",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                          ["ValidateFirstResult"] = "(int)(firstOp[0] >> 1) != result[0]",                                                                                                ["ValidateRemainingResults"] = "(int)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightArithmetic",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                       ["Imm"] = "16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                          ["ValidateFirstResult"] = "(short)(firstOp[0] >> 15) != result[0]",                                                                                             ["ValidateRemainingResults"] = "(short)(firstOp[i] >> 15) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightArithmetic",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                       ["Imm"] = "32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                          ["ValidateFirstResult"] = "(int)(firstOp[0] >> 31) != result[0]",                                                                                               ["ValidateRemainingResults"] = "(int)(firstOp[i] >> 31) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                          ["ValidateFirstResult"] = "(short)(firstOp[0] >> 1) != result[0]",                                                                                              ["ValidateRemainingResults"] = "(short)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                         ["ValidateFirstResult"] = "(ushort)(firstOp[0] >> 1) != result[0]",                                                                                             ["ValidateRemainingResults"] = "(ushort)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                          ["ValidateFirstResult"] = "(int)(firstOp[0] >> 1) != result[0]",                                                                                                ["ValidateRemainingResults"] = "(int)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                         ["ValidateFirstResult"] = "(uint)(firstOp[0] >> 1) != result[0]",                                                                                               ["ValidateRemainingResults"] = "(uint)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                          ["ValidateFirstResult"] = "(long)(firstOp[0] >> 1) != result[0]",                                                                                               ["ValidateRemainingResults"] = "(long)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                         ["ValidateFirstResult"] = "(ulong)(firstOp[0] >> 1) != result[0]",                                                                                              ["ValidateRemainingResults"] = "(ulong)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                       ["Imm"] = "16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                          ["ValidateFirstResult"] = "0 != result[0]",                                                                                                                     ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                      ["Imm"] = "16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                         ["ValidateFirstResult"] = "0 != result[0]",                                                                                                                     ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                       ["Imm"] = "32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                          ["ValidateFirstResult"] = "0 != result[0]",                                                                                                                     ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                      ["Imm"] = "32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                         ["ValidateFirstResult"] = "0 != result[0]",                                                                                                                     ["ValidateRemainingResults"] = "0!= result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                       ["Imm"] = "64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                          ["ValidateFirstResult"] = "0 != result[0]",                                                                                                                     ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                                      ["Imm"] = "64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                         ["ValidateFirstResult"] = "0 != result[0]",                                                                                                                     ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical128BitLane",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(sbyte)8",                                                                                  ["ValidateFirstResult"] = "result[0] != 8",                                                                                                                     ["ValidateRemainingResults"] = "(i == 15 ? result[i] != 0 : result[i] != 8)"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical128BitLane",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",                                                                                        ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(byte)8",                                                                                   ["ValidateFirstResult"] = "result[0] != 8",                                                                                                                     ["ValidateRemainingResults"] = "(i == 15 ? result[i] != 0 : result[i] != 8)"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical128BitLane",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)8",                                                                                  ["ValidateFirstResult"] = "result[0] != 2048",                                                                                                                  ["ValidateRemainingResults"] = "(i == 7 ? result[i] != 0 : result[i] != 2048)"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical128BitLane",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ushort)8",                                                                                 ["ValidateFirstResult"] = "result[0] != 2048",                                                                                                                  ["ValidateRemainingResults"] = "(i == 7 ? result[i] != 0 : result[i] != 2048)"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical128BitLane",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(int)8",                                                                                    ["ValidateFirstResult"] = "result[0] != 134217728",                                                                                                             ["ValidateRemainingResults"] = "(i == 3 ? result[i] != 0 : result[i] != 134217728)"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical128BitLane",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(uint)8",                                                                                   ["ValidateFirstResult"] = "result[0] != 134217728",                                                                                                             ["ValidateRemainingResults"] = "(i == 3 ? result[i] != 0 : result[i] != 134217728)"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical128BitLane",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(long)8",                                                                                   ["ValidateFirstResult"] = "result[0] != 576460752303423488L",                                                                                                   ["ValidateRemainingResults"] = "(result[i] != 0)"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightLogical128BitLane",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(ulong)8",                                                                                  ["ValidateFirstResult"] = "result[0] != 576460752303423488UL",                                                                                                  ["ValidateRemainingResults"] = "(result[i] != 0)"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Shuffle",                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                       ["Imm"] = "0",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "firstOp[0] != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Shuffle",                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                      ["Imm"] = "0",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                         ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "firstOp[0] != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Shuffle",                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                          ["ValidateFirstResult"] = "firstOp[1] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "firstOp[0] != result[i]"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Shuffle",                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                         ["ValidateFirstResult"] = "firstOp[1] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "firstOp[0] != result[i]"}),
    ("ImmBinOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Shuffle",                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                         ["Imm"] = "0",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(left[0])",                                               ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(right[0])"}),
    ("ImmBinOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Shuffle",                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                         ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(left[1])",                                               ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(right[0])"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShuffleHigh",                              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                       ["Imm"] = "0",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "(i <= 3 ? (firstOp[i] != result[i]) : (firstOp[4] != result[i]))"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShuffleHigh",                              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                      ["Imm"] = "0",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                         ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "(i <= 3 ? (firstOp[i] != result[i]) : (firstOp[4] != result[i]))"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShuffleLow",                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                       ["Imm"] = "0",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "(i <= 3 ? (firstOp[0] != result[i]) : (firstOp[i] != result[i]))"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShuffleLow",                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                      ["Imm"] = "0",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                         ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "(i <= 3 ? (firstOp[0] != result[i]) : (firstOp[i] != result[i]))"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShuffleHigh",                              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "(i <= 3 ? (firstOp[i] != result[i]) : (firstOp[5] != result[4]))"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShuffleHigh",                              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                         ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "(i <= 3 ? (firstOp[i] != result[i]) : (firstOp[5] != result[4]))"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShuffleLow",                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                          ["ValidateFirstResult"] = "firstOp[1] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "(i <= 3 ? (firstOp[0] != result[i]) : (firstOp[i] != result[i]))"}),
    ("ImmUnOpTest.template",            new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "ShuffleLow",                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                         ["ValidateFirstResult"] = "firstOp[1] != result[0]",                                                                                                            ["ValidateRemainingResults"] = "(i <= 3 ? (firstOp[0] != result[i]) : (firstOp[i] != result[i]))"}),
    ("StoreUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "StoreScalar",                              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                          ["ValidateFirstResult"] = "value[0] != result[0]",                                                                                                              ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("StoreUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "StoreScalar",                              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                         ["ValidateFirstResult"] = "value[0] != result[0]",                                                                                                              ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("StoreUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "StoreScalar",                              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                          ["ValidateFirstResult"] = "value[0] != result[0]",                                                                                                              ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("StoreUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "StoreScalar",                              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                         ["ValidateFirstResult"] = "value[0] != result[0]",                                                                                                              ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Subtract",                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] - right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i] - right[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Subtract",                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "(byte)(left[0] - right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(byte)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Subtract",                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "(short)(left[0] - right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(short)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Subtract",                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "(int)(left[0] - right[0]) != result[0]",                                                                                             ["ValidateRemainingResults"] = "(int)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Subtract",                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "(long)(left[0] - right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(long)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Subtract",                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "(sbyte)(left[0] - right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(sbyte)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Subtract",                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "(ushort)(left[0] - right[0]) != result[0]",                                                                                          ["ValidateRemainingResults"] = "(ushort)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Subtract",                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "(uint)(left[0] - right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(uint)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Subtract",                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "(ulong)(left[0] - right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(ulong)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "SubtractSaturate",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "SseVerify.SubtractSaturate(left[0], right[0], result[0])",                                                                           ["ValidateRemainingResults"] = "SseVerify.SubtractSaturate(left[i], right[i], result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "SubtractSaturate",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "SseVerify.SubtractSaturate(left[0], right[0], result[0])",                                                                           ["ValidateRemainingResults"] = "SseVerify.SubtractSaturate(left[i], right[i], result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "SubtractSaturate",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "SseVerify.SubtractSaturate(left[0], right[0], result[0])",                                                                           ["ValidateRemainingResults"] = "SseVerify.SubtractSaturate(left[i], right[i], result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "SubtractSaturate",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "SseVerify.SubtractSaturate(left[0], right[0], result[0])",                                                                           ["ValidateRemainingResults"] = "SseVerify.SubtractSaturate(left[i], right[i], result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "SubtractScalar",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] - right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "SumAbsoluteDifferences",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",    ["ValidateFirstResult"] = "result[0] != SseVerify.SumAbsoluteDifferences(left, right, 0)",                                                                      ["ValidateRemainingResults"] = "result[i] != SseVerify.SumAbsoluteDifferences(left, right, i)"}),
    ("ComplexBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "UnpackHigh",                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(left[1])",                                               ["ValidateRemainingResults"] = "((i & 1) == 0) ? BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(left[i/2+1]) : BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(right[(i - 1)/2 + 1])"}),
    ("ComplexBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "UnpackHigh",                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != left[1] || result[1] != right[1]",                                                                                      ["ValidateRemainingResults"] = "((i & 1) == 0) ? result[i] != left[i/2 + 1] : result[i] != right[(i - 1)/2 + 1]"}),
    ("ComplexBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "UnpackHigh",                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != left[1] || result[1] != right[1]",                                                                                      ["ValidateRemainingResults"] = "((i & 1) == 0) ? result[i] != left[i/2 + 1] : result[i] != right[(i - 1)/2 + 1]"}),
    ("ComplexBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "UnpackHigh",                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != left[2]",                                                                                                               ["ValidateRemainingResults"] = "((i & 1) == 0) ? result[i] != left[i/2 + 2] : result[i] != right[(i - 1)/2 + 2]"}),
    ("ComplexBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "UnpackHigh",                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != left[2]",                                                                                                               ["ValidateRemainingResults"] = "((i & 1) == 0) ? result[i] != left[i/2 + 2] : result[i] != right[(i - 1)/2 + 2]"}),
    ("ComplexBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "UnpackHigh",                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != left[4]",                                                                                                               ["ValidateRemainingResults"] = "((i & 1) == 0) ? result[i] != left[i/2 + 4] : result[i] != right[(i - 1)/2 + 4]"}),
    ("ComplexBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "UnpackHigh",                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != left[4]",                                                                                                               ["ValidateRemainingResults"] = "((i & 1) == 0) ? result[i] != left[i/2 + 4] : result[i] != right[(i - 1)/2 + 4]"}),
    ("ComplexBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "UnpackHigh",                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != left[8]",                                                                                                               ["ValidateRemainingResults"] = "((i & 1) == 0) ? result[i] != left[i/2 + 8] : result[i] != right[(i - 1)/2 + 8]"}),
    ("ComplexBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "UnpackHigh",                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != left[8]",                                                                                                               ["ValidateRemainingResults"] = "((i & 1) == 0) ? result[i] != left[i/2 + 8] : result[i] != right[(i - 1)/2 + 8]"}),
    ("ComplexBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "UnpackLow",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(left[0])",                                               ["ValidateRemainingResults"] = "((i & 1) == 0) ? BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(left[i/2]) : BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(right[(i - 1)/2])"}),
    ("ComplexBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "UnpackLow",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != left[0] || result[1] != right[0]",                                                                                      ["ValidateRemainingResults"] = "((i & 1) == 0) ? result[i] != left[i/2] : result[i] != right[(i - 1)/2]"}),
    ("ComplexBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "UnpackLow",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != left[0] || result[1] != right[0]",                                                                                      ["ValidateRemainingResults"] = "((i & 1) == 0) ? result[i] != left[i/2] : result[i] != right[(i - 1)/2]"}),
    ("ComplexBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "UnpackLow",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != left[0]",                                                                                                               ["ValidateRemainingResults"] = "((i & 1) == 0) ? result[i] != left[i/2] : result[i] != right[(i - 1)/2]"}),
    ("ComplexBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "UnpackLow",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != left[0]",                                                                                                               ["ValidateRemainingResults"] = "((i & 1) == 0) ? result[i] != left[i/2] : result[i] != right[(i - 1)/2]"}),
    ("ComplexBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "UnpackLow",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "result[0] != left[0]",                                                                                                               ["ValidateRemainingResults"] = "((i & 1) == 0) ? result[i] != left[i/2] : result[i] != right[(i - 1)/2]"}),
    ("ComplexBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "UnpackLow",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "result[0] != left[0]",                                                                                                               ["ValidateRemainingResults"] = "((i & 1) == 0) ? result[i] != left[i/2] : result[i] != right[(i - 1)/2]"}),
    ("ComplexBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "UnpackLow",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "result[0] != left[0]",                                                                                                               ["ValidateRemainingResults"] = "((i & 1) == 0) ? result[i] != left[i/2] : result[i] != right[(i - 1)/2]"}),
    ("ComplexBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "UnpackLow",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "result[0] != left[0]",                                                                                                               ["ValidateRemainingResults"] = "((i & 1) == 0) ? result[i] != left[i/2] : result[i] != right[(i - 1)/2]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Xor",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "(BitConverter.DoubleToInt64Bits(left[0]) ^ BitConverter.DoubleToInt64Bits(right[0])) != BitConverter.DoubleToInt64Bits(result[0])",  ["ValidateRemainingResults"] = "(BitConverter.DoubleToInt64Bits(left[i]) ^ BitConverter.DoubleToInt64Bits(right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Xor",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["ValidateFirstResult"] = "(byte)(left[0] ^ right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(byte)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Xor",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["ValidateFirstResult"] = "(short)(left[0] ^ right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(short)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Xor",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "(int)(left[0] ^ right[0]) != result[0]",                                                                                             ["ValidateRemainingResults"] = "(int)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Xor",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "(long)(left[0] ^ right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(long)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Xor",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["ValidateFirstResult"] = "(sbyte)(left[0] ^ right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(sbyte)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Xor",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["ValidateFirstResult"] = "(ushort)(left[0] ^ right[0]) != result[0]",                                                                                          ["ValidateRemainingResults"] = "(ushort)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Xor",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "(uint)(left[0] ^ right[0]) != result[0]",                                                                                            ["ValidateRemainingResults"] = "(uint)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Sse2", ["LoadIsa"] = "Sse2", ["Method"] = "Xor",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "(ulong)(left[0] ^ right[0]) != result[0]",                                                                                           ["ValidateRemainingResults"] = "(ulong)(left[i] ^ right[i]) != result[i]"}),
};

(string templateFileName, Dictionary<string, string> templateData)[] Sse2X64Inputs = new []
{
    ("SimdScalarUnOpConvTest.template", new Dictionary<string, string> { ["Isa"] = "Sse2.X64", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertToInt64",                                                  ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                          ["ValidateFirstResult"] = "(long)Math.Round(firstOp[0]) != result"}),
    ("SimdScalarUnOpConvTest.template", new Dictionary<string, string> { ["Isa"] = "Sse2.X64", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertToInt64",                                                  ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                 ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                           ["ValidateFirstResult"] = "firstOp[0] != result"}),
    ("SimdScalarUnOpConvTest.template", new Dictionary<string, string> { ["Isa"] = "Sse2.X64", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertToUInt64",                                                 ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result"}),
    ("SimdScalarUnOpConvTest.template", new Dictionary<string, string> { ["Isa"] = "Sse2.X64", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertToInt64WithTruncation",                                    ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                          ["ValidateFirstResult"] = "(long)firstOp[0] != result"}),
    ("SimpleBinOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse2.X64", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertScalarToVector128Double", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                    ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",   ["ValidateFirstResult"] = "(double)right != result[0]"}),
    ("ScalarSimdUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse2.X64", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertScalarToVector128Int64",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",                                   ["Op1BaseType"] = "Int64",                                                                 ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                           ["ValidateFirstResult"] = "firstOp != result[0]",                                                                         ["ValidateRemainingResults"] = "false"}),
    ("ScalarSimdUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse2.X64", ["LoadIsa"] = "Sse2", ["Method"] = "ConvertScalarToVector128UInt64", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",                                  ["Op1BaseType"] = "UInt64",                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                          ["ValidateFirstResult"] = "firstOp != result[0]",                                                                         ["ValidateRemainingResults"] = "false"}),
};

(string templateFileName, Dictionary<string, string> templateData)[] Sse3Inputs = new []
{
    ("AlternatingBinOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse3", ["LoadIsa"] = "Sse2", ["Method"] = "AddSubtract",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(left[i] - right[i])",       ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i + 1]) != BitConverter.DoubleToInt64Bits(left[i + 1] + right[i + 1])"}),
    ("AlternatingBinOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse3", ["LoadIsa"] = "Sse" , ["Method"] = "AddSubtract",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i] - right[i])",       ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i + 1]) != BitConverter.SingleToInt32Bits(left[i + 1] + right[i + 1])"}),
    ("HorizontalBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse3", ["LoadIsa"] = "Sse2", ["Method"] = "HorizontalAdd",      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[i1]) != BitConverter.DoubleToInt64Bits(left[i3] + left[i3 + 1])", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i2]) != BitConverter.DoubleToInt64Bits(right[i3] + right[i3 + 1])"}),
    ("HorizontalBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse3", ["LoadIsa"] = "Sse",  ["Method"] = "HorizontalAdd",      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[i1]) != BitConverter.SingleToInt32Bits(left[i3] + left[i3 + 1])", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i2]) != BitConverter.SingleToInt32Bits(right[i3] + right[i3 + 1])"}),
    ("HorizontalBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse3", ["LoadIsa"] = "Sse2", ["Method"] = "HorizontalSubtract", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[i1]) != BitConverter.DoubleToInt64Bits(left[i3] - left[i3 + 1])", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i2]) != BitConverter.DoubleToInt64Bits(right[i3] - right[i3 + 1])"}),
    ("HorizontalBinOpTest.template",  new Dictionary<string, string> { ["Isa"] = "Sse3", ["LoadIsa"] = "Sse",  ["Method"] = "HorizontalSubtract", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[i1]) != BitConverter.SingleToInt32Bits(left[i3] - left[i3 + 1])", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i2]) != BitConverter.SingleToInt32Bits(right[i3] - right[i3 + 1])"}),
};

(string templateFileName, Dictionary<string, string> templateData)[] Ssse3Inputs = new []
{
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "Abs",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",                                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                              ["ValidateFirstResult"] = "result[0] != (byte)((firstOp[0] < 0) ? -firstOp[0] : firstOp[0])",                ["ValidateRemainingResults"] = "result[i] != (byte)((firstOp[i] < 0) ? -firstOp[i] : firstOp[i])"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "Abs",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                              ["ValidateFirstResult"] = "result[0] != (ushort)((firstOp[0] < 0) ? -firstOp[0] : firstOp[0])",              ["ValidateRemainingResults"] = "result[i] != (ushort)((firstOp[i] < 0) ? -firstOp[i] : firstOp[i])"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "Abs",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                              ["ValidateFirstResult"] = "result[0] != (uint)((firstOp[0] < 0) ? -firstOp[0] : firstOp[0])",                ["ValidateRemainingResults"] = "result[i] != (uint)((firstOp[i] < 0) ? -firstOp[i] : firstOp[i])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "AlignRight",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",  ["Imm"] = "0",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",       ["ValidateFirstResult"] = "result[0] != right[0]",                                                           ["ValidateRemainingResults"] = "result[i] != right[i]"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "AlignRight",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",  ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",       ["ValidateFirstResult"] = "result[0] != right[1]",                                                           ["ValidateRemainingResults"] = "result[i] != (i == 15 ? left[0] : right[i+1])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "AlignRight",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte", ["Imm"] = "0",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",      ["ValidateFirstResult"] = "result[0] != right[0]",                                                           ["ValidateRemainingResults"] = "result[i] != right[i]"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "AlignRight",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte", ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",      ["ValidateFirstResult"] = "result[0] != right[1]",                                                           ["ValidateRemainingResults"] = "result[i] != (i == 15 ? left[0] : right[i+1])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "AlignRight",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16", ["Imm"] = "0",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",      ["ValidateFirstResult"] = "result[0] != right[0]",                                                           ["ValidateRemainingResults"] = "result[i] != right[i]"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "AlignRight",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16", ["Imm"] = "2",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",      ["ValidateFirstResult"] = "result[0] != right[1]",                                                           ["ValidateRemainingResults"] = "result[i] != (i == 7 ? left[0] : right[i+1])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "AlignRight",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",["Imm"] = "0",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",     ["ValidateFirstResult"] = "result[0] != right[0]",                                                           ["ValidateRemainingResults"] = "result[i] != right[i]"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "AlignRight",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",["Imm"] = "2",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",     ["ValidateFirstResult"] = "result[0] != right[1]",                                                           ["ValidateRemainingResults"] = "result[i] != (i == 7 ? left[0] : right[i+1])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "AlignRight",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32", ["Imm"] = "0",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",      ["ValidateFirstResult"] = "result[0] != right[0]",                                                           ["ValidateRemainingResults"] = "result[i] != right[i]"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "AlignRight",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32", ["Imm"] = "4",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",      ["ValidateFirstResult"] = "result[0] != right[1]",                                                           ["ValidateRemainingResults"] = "result[i] != (i == 3 ? left[0] : right[i+1])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "AlignRight",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",["Imm"] = "0",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",     ["ValidateFirstResult"] = "result[0] != right[0]",                                                           ["ValidateRemainingResults"] = "result[i] != right[i]"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "AlignRight",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",["Imm"] = "4",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",     ["ValidateFirstResult"] = "result[0] != right[1]",                                                           ["ValidateRemainingResults"] = "result[i] != (i == 3 ? left[0] : right[i+1])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "AlignRight",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64", ["Imm"] = "0",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",      ["ValidateFirstResult"] = "result[0] != right[0]",                                                           ["ValidateRemainingResults"] = "result[i] != right[i]"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "AlignRight",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64", ["Imm"] = "8",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",      ["ValidateFirstResult"] = "result[0] != right[1]",                                                           ["ValidateRemainingResults"] = "result[i] != (i == 1 ? left[0] : right[i+1])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "AlignRight",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",["Imm"] = "0",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",     ["ValidateFirstResult"] = "result[0] != right[0]",                                                           ["ValidateRemainingResults"] = "result[i] != right[i]"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "AlignRight",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",["Imm"] = "8",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",     ["ValidateFirstResult"] = "result[0] != right[1]",                                                           ["ValidateRemainingResults"] = "result[i] != (i == 1 ? left[0] : right[i+1])"}),
    ("HorizontalBinOpTest.template", new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "HorizontalAdd",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()", ["ValidateFirstResult"] = "result[i1] != (short)(left[i3] + left[i3 + 1])",                                                         ["ValidateRemainingResults"] = "result[i2] != (short)(right[i3] + right[i3 + 1])"}),
    ("HorizontalBinOpTest.template", new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "HorizontalAdd",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()", ["ValidateFirstResult"] = "result[i1] != (int)(left[i3] + left[i3 + 1])",                                                           ["ValidateRemainingResults"] = "result[i2] != (int)(right[i3] + right[i3 + 1])"}),
    ("HorizontalBinOpTest.template", new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "HorizontalAddSaturate",      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()", ["ValidateFirstResult"] = "result[i1] != Math.Clamp((left[i3] + left[i3 + 1]), short.MinValue, short.MaxValue)",                    ["ValidateRemainingResults"] = "result[i2] != Math.Clamp((right[i3] + right[i3 + 1]), short.MinValue, short.MaxValue)"}),
    ("HorizontalBinOpTest.template", new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "HorizontalSubtract",         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()", ["ValidateFirstResult"] = "result[i1] != (short)(left[i3] - left[i3 + 1])",                                                         ["ValidateRemainingResults"] = "result[i2] != (short)(right[i3] - right[i3 + 1])"}),
    ("HorizontalBinOpTest.template", new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "HorizontalSubtract",         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()", ["ValidateFirstResult"] = "result[i1] != (int)(left[i3] - left[i3 + 1])",                                                           ["ValidateRemainingResults"] = "result[i2] != (int)(right[i3] - right[i3 + 1])"}),
    ("HorizontalBinOpTest.template", new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "HorizontalSubtractSaturate", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()", ["ValidateFirstResult"] = "result[i1] != Math.Clamp((left[i3] - left[i3 + 1]), short.MinValue, short.MaxValue)",                    ["ValidateRemainingResults"] = "result[i2] != Math.Clamp((right[i3] - right[i3 + 1]), short.MinValue, short.MaxValue)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "MultiplyAddAdjacent",        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()", ["ValidateFirstResult"] = "result[0] != Math.Clamp(((right[1] * left[1]) + (right[0] * left[0])), short.MinValue, short.MaxValue)", ["ValidateRemainingResults"] = "result[i] != Math.Clamp(((right[(i * 2) + 1] * left[(i * 2) + 1]) + (right[i * 2] * left[i * 2])), short.MinValue, short.MaxValue)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "MultiplyHighRoundScale",     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()", ["ValidateFirstResult"] = "result[0] != (short)((((left[0] * right[0]) >> 14) + 1) >> 1)",                                          ["ValidateRemainingResults"] = "result[i] != (short)((((left[i] * right[i]) >> 14) + 1) >> 1)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "Shuffle",                    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",  ["ValidateFirstResult"] = "result[0] != ((right[0] > 127) ? 0 : left[right[0] & 0x0F])",                                            ["ValidateRemainingResults"] = "result[i] != ((right[i] > 127) ? 0 : left[right[i] & 0x0F])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "Shuffle",                    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()", ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()", ["ValidateFirstResult"] = "result[0] != ((right[0] < 0) ? 0 : left[right[0] & 0x0F])",                                              ["ValidateRemainingResults"] = "result[i] != ((right[i] < 0) ? 0 : left[right[i] & 0x0F])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "Sign",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()", ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()", ["ValidateFirstResult"] = "result[0] != (right[0] < 0 ? (sbyte)(-left[0]) : (right[0] > 0 ? left[0] : 0))",                         ["ValidateRemainingResults"] = "result[i] != (right[i] < 0 ? (sbyte)(-left[i]) : (right[i] > 0 ? left[i] : 0))"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "Sign",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()", ["ValidateFirstResult"] = "result[0] != (right[0] < 0 ? (short)(-left[0]) : (right[0] > 0 ? left[0] : 0))",                         ["ValidateRemainingResults"] = "result[i] != (right[i] < 0 ? (short)(-left[i]) : (right[i] > 0 ? left[i] : 0))"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Ssse3", ["LoadIsa"] = "Sse2", ["Method"] = "Sign",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()", ["ValidateFirstResult"] = "result[0] != (right[0] < 0 ? (int)(-left[0]) : (right[0] > 0 ? left[0] : 0))",                           ["ValidateRemainingResults"] = "result[i] != (right[i] < 0 ? (int)(-left[i]) : (right[i] > 0 ? left[i] : 0))"}),
};

(string templateFileName, Dictionary<string, string> templateData)[] Sse41Inputs = new []
{
    ("ComplexTernOpTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "BlendVariable",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Byte",                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp3"] = "(byte)(((i & 1) == 0) ? 128 : 1)",      ["ValidateFirstResult"] = "((thirdOp[0] >> 7) & 1) == 1 ? secondOp[0] != result[0] : firstOp[0] != result[0]",                                                                                                                                                                  ["ValidateRemainingResults"] = "((thirdOp[i] >> 7) & 1) == 1 ? secondOp[i] != result[i] : firstOp[i] != result[i]"}),
    ("ComplexTernOpTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "BlendVariable",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Double",                                         ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp3"] = "(double)(((i & 1) == 0) ? -0.0 : 1.0)", ["ValidateFirstResult"] = "((BitConverter.DoubleToInt64Bits(thirdOp[0]) >> 63) & 1) == 1 ? BitConverter.DoubleToInt64Bits(secondOp[0]) != BitConverter.DoubleToInt64Bits(result[0]) : BitConverter.DoubleToInt64Bits(firstOp[0]) != BitConverter.DoubleToInt64Bits(result[0])", ["ValidateRemainingResults"] = "((BitConverter.DoubleToInt64Bits(thirdOp[i]) >> 63) & 1) == 1 ? BitConverter.DoubleToInt64Bits(secondOp[i]) != BitConverter.DoubleToInt64Bits(result[i]) : BitConverter.DoubleToInt64Bits(firstOp[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("ComplexTernOpTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "BlendVariable",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "SByte",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp3"] = "(sbyte)(((i & 1) == 0) ? -128 : 1)",    ["ValidateFirstResult"] = "((thirdOp[0] >> 7) & 1) == 1 ? secondOp[0] != result[0] : firstOp[0] != result[0]",                                                                                                                                                                  ["ValidateRemainingResults"] = "((thirdOp[i] >> 7) & 1) == 1 ? secondOp[i] != result[i] : firstOp[i] != result[i]"}),
    ("ComplexTernOpTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "BlendVariable",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Single",                                         ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp3"] = "(float)(((i & 1) == 0) ? -0.0 : 1.0)",  ["ValidateFirstResult"] = "((BitConverter.SingleToInt32Bits(thirdOp[0]) >> 31) & 1) == 1 ? BitConverter.SingleToInt32Bits(secondOp[0]) != BitConverter.SingleToInt32Bits(result[0]) : BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[0])", ["ValidateRemainingResults"] = "((BitConverter.SingleToInt32Bits(thirdOp[i]) >> 31) & 1) == 1 ? BitConverter.SingleToInt32Bits(secondOp[i]) != BitConverter.SingleToInt32Bits(result[i]) : BitConverter.SingleToInt32Bits(firstOp[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("ComplexTernOpTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "BlendVariable",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int16",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp3"] = "(((i & 1) == 0) ? Convert.ToInt16(\"0xFFFF\", 16) : (short)0)",      ["ValidateFirstResult"] = "(thirdOp[0] != 0) ? secondOp[0] != result[0] : firstOp[0] != result[0]",                                                                                                                                                ["ValidateRemainingResults"] = "(thirdOp[i] != 0) ? secondOp[i] != result[i] : firstOp[i] != result[i]"}),
    ("ComplexTernOpTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "BlendVariable",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt16",                                         ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp3"] = "(((i & 1) == 0) ? Convert.ToUInt16(\"0xFFFF\", 16) : (ushort)0)",    ["ValidateFirstResult"] = "(thirdOp[0] != 0) ? secondOp[0] != result[0] : firstOp[0] != result[0]",                                                                                                                                                ["ValidateRemainingResults"] = "(thirdOp[i] != 0) ? secondOp[i] != result[i] : firstOp[i] != result[i]"}),
    ("ComplexTernOpTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "BlendVariable",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int32",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp3"] = "(((i & 1) == 0) ? Convert.ToInt32(\"0xFFFFFFFF\", 16) : (int)0)",    ["ValidateFirstResult"] = "(thirdOp[0] != 0) ? secondOp[0] != result[0] : firstOp[0] != result[0]",                                                                                                                                                ["ValidateRemainingResults"] = "(thirdOp[i] != 0) ? secondOp[i] != result[i] : firstOp[i] != result[i]"}),
    ("ComplexTernOpTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "BlendVariable",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt32",                                         ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp3"] = "(((i & 1) == 0) ? Convert.ToUInt32(\"0xFFFFFFFF\", 16) : (uint)0)",  ["ValidateFirstResult"] = "(thirdOp[0] != 0) ? secondOp[0] != result[0] : firstOp[0] != result[0]",                                                                                                                                                ["ValidateRemainingResults"] = "(thirdOp[i] != 0) ? secondOp[i] != result[i] : firstOp[i] != result[i]"}),
    ("ComplexTernOpTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "BlendVariable",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int64",                                          ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp3"] = "(((i & 1) == 0) ? Convert.ToInt64(\"0xFFFFFFFFFFFFFFFF\", 16) : (long)0)",   ["ValidateFirstResult"] = "(thirdOp[0] != 0) ? secondOp[0] != result[0] : firstOp[0] != result[0]",                                                                                                                                        ["ValidateRemainingResults"] = "(thirdOp[i] != 0) ? secondOp[i] != result[i] : firstOp[i] != result[i]"}),
    ("ComplexTernOpTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "BlendVariable",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt64",                                         ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp3"] = "(((i & 1) == 0) ? Convert.ToUInt64(\"0xFFFFFFFFFFFFFFFF\", 16): (ulong)0)",  ["ValidateFirstResult"] = "(thirdOp[0] != 0) ? secondOp[0] != result[0] : firstOp[0] != result[0]",                                                                                                                                        ["ValidateRemainingResults"] = "(thirdOp[i] != 0) ? secondOp[i] != result[i] : firstOp[i] != result[i]"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Ceiling",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Ceiling(firstOp[0]))",                                                                                                                                              ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(Math.Ceiling(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "Ceiling",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Ceiling(firstOp[0]))",                                                                                                                                             ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(MathF.Ceiling(firstOp[i]))"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "CeilingScalar",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Ceiling(right[0]))",                                                                                                                                                ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(left[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "CeilingScalar",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Ceiling(right[0]))",                                                                                                                                               ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "CompareEqual",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                              ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((long)(-1)) : 0)",                                                                                                                                                                                   ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((long)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "CompareEqual",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                             ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((ulong)(-1)) : 0)",                                                                                                                                                                                  ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((ulong)(-1)) : 0)"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Byte",                                                                                                                                                    ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                       ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int32",                                                                                                                                                   ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                      ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt32",                                                                                                                                                  ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                     ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "Extract",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                  ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "(BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(firstOp[1]))"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Byte",                                                                                                                                                    ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                       ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int32",                                                                                                                                                   ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                      ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt32",                                                                                                                                                  ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                     ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "Extract",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                  ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "(BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(firstOp[1]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Floor",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Floor(firstOp[0]))",                                                                                                                                                ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(Math.Floor(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "Floor",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Floor(firstOp[0]))",                                                                                                                                               ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(MathF.Floor(firstOp[i]))"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "FloorScalar",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Floor(right[0]))",                                                                                                                                                  ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(left[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "FloorScalar",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Floor(right[0]))",                                                                                                                                                 ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("InsertVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                     ["Imm"] = "0",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(right[0])",                                                                                                                                                              ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Byte",                                                                                                                             ["Data"] = "(byte)2",  ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                       ["ValidateFirstResult"] = "(i == 1 ? result[i] != scalarData : result[i] != firstOp[i])"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "SByte",                                                                                                                            ["Data"] = "(sbyte)2", ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                      ["ValidateFirstResult"] = "(i == 1 ? result[i] != scalarData : result[i] != firstOp[i])"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int32",                                                                                                                            ["Data"] = "(int)2",   ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                      ["ValidateFirstResult"] = "(i == 1 ? result[i] != scalarData : result[i] != firstOp[i])"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt32",                                                                                                                           ["Data"] = "(uint)2",  ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                     ["ValidateFirstResult"] = "(i == 1 ? result[i] != scalarData : result[i] != firstOp[i])"}),
    ("InsertVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                     ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(0.0f)",                                                                                                                                                                  ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("InsertVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                     ["Imm"] = "2",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(right[0])",                                                                                                                                                              ["ValidateRemainingResults"] = "i == 1 ? BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(0.0f) : BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("InsertVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                     ["Imm"] = "4",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(right[0])",                                                                                                                                                              ["ValidateRemainingResults"] = "i == 2 ? BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(0.0f) : BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("InsertVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                     ["Imm"] = "8",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(right[0])",                                                                                                                                                              ["ValidateRemainingResults"] = "i == 3 ? BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(0.0f) : BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("InsertVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                     ["Imm"] = "16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(left[0])",                                                                                                                                                               ["ValidateRemainingResults"] = "i == 1 ? BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(right[0]) : BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("InsertVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                     ["Imm"] = "32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(left[0])",                                                                                                                                                               ["ValidateRemainingResults"] = "i == 2 ? BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(right[0]) : BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("InsertVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                     ["Imm"] = "48",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(left[0])",                                                                                                                                                               ["ValidateRemainingResults"] = "i == 3 ? BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(right[0]) : BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("InsertVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                     ["Imm"] = "64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(right[1])",                                                                                                                                                              ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("InsertVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                     ["Imm"] = "128", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(right[2])",                                                                                                                                                              ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Byte",                                                                                                                             ["Data"] = "(byte)2",  ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                       ["ValidateFirstResult"] = "(i == 1 ? result[i] != scalarData : result[i] != firstOp[i])"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "SByte",                                                                                                                            ["Data"] = "(sbyte)2", ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                      ["ValidateFirstResult"] = "(i == 1 ? result[i] != scalarData : result[i] != firstOp[i])"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int32",                                                                                                                            ["Data"] = "(int)2",   ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                      ["ValidateFirstResult"] = "(i == 1 ? result[i] != scalarData : result[i] != firstOp[i])"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt32",                                                                                                                           ["Data"] = "(uint)2",  ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                     ["ValidateFirstResult"] = "(i == 1 ? result[i] != scalarData : result[i] != firstOp[i])"}),
    ("InsertVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                     ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(0.0f)",                                                                                                                                                                  ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("InsertVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                     ["Imm"] = "192", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(right[3])",                                                                                                                                                              ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Max",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                              ["ValidateFirstResult"] = "result[0] != Math.Max(left[0], right[0])",                                                                                                                                                                                                           ["ValidateRemainingResults"] = "result[i] != Math.Max(left[i], right[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Max",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                              ["ValidateFirstResult"] = "result[0] != Math.Max(left[0], right[0])",                                                                                                                                                                                                           ["ValidateRemainingResults"] = "result[i] != Math.Max(left[i], right[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Max",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                             ["ValidateFirstResult"] = "result[0] != Math.Max(left[0], right[0])",                                                                                                                                                                                                           ["ValidateRemainingResults"] = "result[i] != Math.Max(left[i], right[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Max",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                             ["ValidateFirstResult"] = "result[0] != Math.Max(left[0], right[0])",                                                                                                                                                                                                           ["ValidateRemainingResults"] = "result[i] != Math.Max(left[i], right[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Min",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                              ["ValidateFirstResult"] = "result[0] != Math.Min(left[0], right[0])",                                                                                                                                                                                                           ["ValidateRemainingResults"] = "result[i] != Math.Min(left[i], right[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Min",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                              ["ValidateFirstResult"] = "result[0] != Math.Min(left[0], right[0])",                                                                                                                                                                                                           ["ValidateRemainingResults"] = "result[i] != Math.Min(left[i], right[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Min",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                             ["ValidateFirstResult"] = "result[0] != Math.Min(left[0], right[0])",                                                                                                                                                                                                           ["ValidateRemainingResults"] = "result[i] != Math.Min(left[i], right[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "Min",                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                             ["ValidateFirstResult"] = "result[0] != Math.Min(left[0], right[0])",                                                                                                                                                                                                           ["ValidateRemainingResults"] = "result[i] != Math.Min(left[i], right[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "MultiplyLow",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                              ["ValidateFirstResult"] = "result[0] != BitConverter.ToInt32(BitConverter.GetBytes(((long)(left[0])) * right[0]), 0)",                                                                                                                                                          ["ValidateRemainingResults"] = "result[i] != BitConverter.ToInt32(BitConverter.GetBytes(((long)(left[i])) * right[i]), 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "MultiplyLow",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                             ["ValidateFirstResult"] = "result[0] != BitConverter.ToUInt32(BitConverter.GetBytes(((ulong)(left[0])) * right[0]), 0)",                                                                                                                                                        ["ValidateRemainingResults"] = "result[i] != BitConverter.ToUInt32(BitConverter.GetBytes(((ulong)(left[i])) * right[i]), 0)"}),
    ("ComplexBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "PackUnsignedSaturate",          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                              ["ValidateFirstResult"] = "result[0] != (ushort)Math.Clamp(left[0], ushort.MinValue, ushort.MaxValue)",                                                                                                                                                                         ["ValidateRemainingResults"] = "result[i] != ((i < 4) ? (ushort)Math.Clamp(left[i], ushort.MinValue, ushort.MaxValue) : (ushort)Math.Clamp(right[i&3], ushort.MinValue, ushort.MaxValue))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "RoundCurrentDirection",         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Round(firstOp[0]))",                                                                                                                                                ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(Math.Round(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "RoundCurrentDirection",         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Round(firstOp[0]))",                                                                                                                                               ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(MathF.Round(firstOp[i]))"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "RoundCurrentDirectionScalar",   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Round(right[0]))",                                                                                                                                                  ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(left[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "RoundCurrentDirectionScalar",   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Round(right[0]))",                                                                                                                                                 ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "RoundToNearestInteger",         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Round(firstOp[0], MidpointRounding.AwayFromZero))",                                                                                                                 ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(Math.Round(firstOp[i], MidpointRounding.AwayFromZero))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "RoundToNearestInteger",         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Round(firstOp[0], MidpointRounding.AwayFromZero))",                                                                                                                ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(MathF.Round(firstOp[i], MidpointRounding.AwayFromZero))"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "RoundToNearestIntegerScalar",   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Round(right[0], MidpointRounding.AwayFromZero))",                                                                                                                   ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(left[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "RoundToNearestIntegerScalar",   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Round(right[0], MidpointRounding.AwayFromZero))",                                                                                                                  ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "RoundToNegativeInfinity",       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Floor(firstOp[0]))",                                                                                                                                                ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(Math.Floor(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "RoundToNegativeInfinity",       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Floor(firstOp[0]))",                                                                                                                                               ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(MathF.Floor(firstOp[i]))"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "RoundToNegativeInfinityScalar", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Floor(right[0]))",                                                                                                                                                  ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(left[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "RoundToNegativeInfinityScalar", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Floor(right[0]))",                                                                                                                                                 ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "RoundToPositiveInfinity",       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Ceiling(firstOp[0]))",                                                                                                                                              ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(Math.Ceiling(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "RoundToPositiveInfinity",       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Ceiling(firstOp[0]))",                                                                                                                                             ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(MathF.Ceiling(firstOp[i]))"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "RoundToPositiveInfinityScalar", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Ceiling(right[0]))",                                                                                                                                                ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(left[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "RoundToPositiveInfinityScalar", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Ceiling(right[0]))",                                                                                                                                               ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "RoundToZero",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits((firstOp[0] > 0) ? Math.Floor(firstOp[0]) : Math.Ceiling(firstOp[0]))",                                                                                                  ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits((firstOp[i] > 0) ? Math.Floor(firstOp[i]) : Math.Ceiling(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "RoundToZero",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits((firstOp[0] > 0) ? MathF.Floor(firstOp[0]) : MathF.Ceiling(firstOp[0]))",                                                                                                ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits((firstOp[i] > 0) ? MathF.Floor(firstOp[i]) : MathF.Ceiling(firstOp[i]))"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "RoundToZeroScalar",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits((right[0] > 0) ? Math.Floor(right[0]) : Math.Ceiling(right[0]))",                                                                                                        ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(left[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "RoundToZeroScalar",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits((right[0] > 0) ? MathF.Floor(right[0]) : MathF.Ceiling(right[0]))",                                                                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(left[i])"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestC",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                               ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestC",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                              ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestC",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                              ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestC",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                              ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestC",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                              ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestC",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                             ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestC",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                             ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestC",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                             ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestNotZAndNotC",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                               ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestNotZAndNotC",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                              ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestNotZAndNotC",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                              ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestNotZAndNotC",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                              ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestNotZAndNotC",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                              ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestNotZAndNotC",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                             ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestNotZAndNotC",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                             ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestNotZAndNotC",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                             ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestZ",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                                                                        ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                               ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestZ",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                              ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestZ",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                              ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestZ",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                              ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestZ",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                              ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestZ",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                             ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestZ",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                             ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "TestZ",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                             ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
};

(string templateFileName, Dictionary<string, string> templateData)[] Sse41_OverloadedInputs = new []
{
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "RoundCurrentDirectionScalar",   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Round(firstOp[0]))",                                                                                                                                                  ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(firstOp[i])"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "RoundCurrentDirectionScalar",   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Round(firstOp[0]))",                                                                                                                                                 ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(firstOp[i])"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "RoundToNearestIntegerScalar",   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Round(firstOp[0], MidpointRounding.AwayFromZero))",                                                                                                                   ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(firstOp[i])"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "RoundToNearestIntegerScalar",   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Round(firstOp[0], MidpointRounding.AwayFromZero))",                                                                                                                  ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(firstOp[i])"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "RoundToNegativeInfinityScalar", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Floor(firstOp[0]))",                                                                                                                                                  ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(firstOp[i])"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "RoundToNegativeInfinityScalar", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Floor(firstOp[0]))",                                                                                                                                                 ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(firstOp[i])"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse2", ["Method"] = "RoundToPositiveInfinityScalar", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Double",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Ceiling(firstOp[0]))",                                                                                                                                                ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(firstOp[i])"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Sse41", ["LoadIsa"] = "Sse",  ["Method"] = "RoundToPositiveInfinityScalar", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                                   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Ceiling(firstOp[0]))",                                                                                                                                               ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(firstOp[i])"}),
};

(string templateFileName, Dictionary<string, string> templateData)[] Sse41X64Inputs = new []
{
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41.X64", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int64",                                                                                                                                                   ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                      ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41.X64", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt64",                                                                                                                                                  ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                     ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41.X64", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int64",                                                                                                                                                   ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                      ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("ExtractScalarTest.template",   new Dictionary<string, string> { ["Isa"] = "Sse41.X64", ["LoadIsa"] = "Sse2", ["Method"] = "Extract",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt64",                                                                                                                                                  ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                     ["ValidateFirstResult"] = "(result[0] != firstOp[1])"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41.X64", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int64",                                                                                                                            ["Data"] = "(long)2",  ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                      ["ValidateFirstResult"] = "(i == 1 ? result[i] != scalarData : result[i] != firstOp[i])"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41.X64", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt64",                                                                                                                           ["Data"] = "(ulong)2", ["Imm"] = "129", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                     ["ValidateFirstResult"] = "(i == 1 ? result[i] != scalarData : result[i] != firstOp[i])"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41.X64", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "Int64",                                                                                                                            ["Data"] = "(long)2",  ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                      ["ValidateFirstResult"] = "(i == 1 ? result[i] != scalarData : result[i] != firstOp[i])"}),
    ("InsertScalarTest.template",    new Dictionary<string, string> { ["Isa"] = "Sse41.X64", ["LoadIsa"] = "Sse2", ["Method"] = "Insert",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] ="Vector128", ["Op1BaseType"] = "UInt64",                                                                                                                           ["Data"] = "(ulong)2", ["Imm"] = "1",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                     ["ValidateFirstResult"] = "(i == 1 ? result[i] != scalarData : result[i] != firstOp[i])"}),
};

(string templateFileName, Dictionary<string, string> templateData)[] Sse42Inputs = new []
{
    ("SimpleBinOpTest.template", new Dictionary<string, string> { ["Isa"] = "Sse42", ["LoadIsa"] = "Sse2", ["Method"] = "CompareGreaterThan", ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()", ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? unchecked((long)(-1)) : 0)", ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? unchecked((long)(-1)) : 0)"}),
};

(string templateFileName, Dictionary<string, string> templateData)[] Avx1Inputs = new []
{
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Add",                                      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] + right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i] + right[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Add",                                      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] + right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i] + right[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("AlternatingBinOpTest.template",new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "AddSubtract",                              ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[i] - right[i]) != BitConverter.DoubleToInt64Bits(result[i])",                                                                                                                                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i + 1] + right[i + 1]) != BitConverter.DoubleToInt64Bits(result[i + 1])"}),
    ("AlternatingBinOpTest.template",new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "AddSubtract",                              ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[i] - right[i]) != BitConverter.SingleToInt32Bits(result[i])",                                                                                                                                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i + 1] + right[i + 1]) != BitConverter.SingleToInt32Bits(result[i + 1])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "And",                                      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "(BitConverter.DoubleToInt64Bits(left[0]) & BitConverter.DoubleToInt64Bits(right[0])) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                  ["ValidateRemainingResults"] = "(BitConverter.DoubleToInt64Bits(left[i]) & BitConverter.DoubleToInt64Bits(right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "And",                                      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "(BitConverter.SingleToInt32Bits(left[0]) & BitConverter.SingleToInt32Bits(right[0])) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                  ["ValidateRemainingResults"] = "(BitConverter.SingleToInt32Bits(left[i]) & BitConverter.SingleToInt32Bits(right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "AndNot",                                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "((~BitConverter.DoubleToInt64Bits(left[0])) & BitConverter.DoubleToInt64Bits(right[0])) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                               ["ValidateRemainingResults"] = "((~BitConverter.DoubleToInt64Bits(left[i])) & BitConverter.DoubleToInt64Bits(right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "AndNot",                                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "((~BitConverter.SingleToInt32Bits(left[0])) & BitConverter.SingleToInt32Bits(right[0])) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                               ["ValidateRemainingResults"] = "((~BitConverter.SingleToInt32Bits(left[i])) & BitConverter.SingleToInt32Bits(right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("ComplexTernOpTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "BlendVariable",                            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "Double",                                          ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp3"] = "(double)(((i & 1) == 0) ? -0.0 : 1.0)", ["ValidateFirstResult"] = "((BitConverter.DoubleToInt64Bits(thirdOp[0]) >> 63) & 1) == 1 ? BitConverter.DoubleToInt64Bits(secondOp[0]) != BitConverter.DoubleToInt64Bits(result[0]) : BitConverter.DoubleToInt64Bits(firstOp[0]) != BitConverter.DoubleToInt64Bits(result[0])", ["ValidateRemainingResults"] = "((BitConverter.DoubleToInt64Bits(thirdOp[i]) >> 63) & 1) == 1 ? BitConverter.DoubleToInt64Bits(secondOp[i]) != BitConverter.DoubleToInt64Bits(result[i]) : BitConverter.DoubleToInt64Bits(firstOp[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("ComplexTernOpTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "BlendVariable",                            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "Single",                                          ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp3"] = "(float)(((i & 1) == 0) ? -0.0 : 1.0)",  ["ValidateFirstResult"] = "((BitConverter.SingleToInt32Bits(thirdOp[0]) >> 31) & 1) == 1 ? BitConverter.SingleToInt32Bits(secondOp[0]) != BitConverter.SingleToInt32Bits(result[0]) : BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[0])", ["ValidateRemainingResults"] = "((BitConverter.SingleToInt32Bits(thirdOp[i]) >> 31) & 1) == 1 ? BitConverter.SingleToInt32Bits(secondOp[i]) != BitConverter.SingleToInt32Bits(result[i]) : BitConverter.SingleToInt32Bits(firstOp[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("LoadUnOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx",                      ["Method"] = "BroadcastScalarToVector128",               ["RetVectorType"]="Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                                      ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("LoadUnOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx",                      ["Method"] = "BroadcastScalarToVector256",               ["RetVectorType"]="Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                                      ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("LoadUnOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx",                      ["Method"] = "BroadcastScalarToVector256",               ["RetVectorType"]="Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                                                                                                                      ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(firstOp[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(firstOp[0]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("LoadUnOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx",                      ["Method"] = "BroadcastVector128ToVector256",            ["RetVectorType"]="Vector256",["RetBaseType"]= "Single",["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                                         ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (i < 4 ? BitConverter.SingleToInt32Bits(firstOp[i]) : BitConverter.SingleToInt32Bits(firstOp[i-4]))"}),
    ("LoadUnOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx",                      ["Method"] = "BroadcastVector128ToVector256",            ["RetVectorType"]="Vector256",["RetBaseType"]= "Double",["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                                                                                                                         ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(firstOp[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (i < 2 ? BitConverter.DoubleToInt64Bits(firstOp[i]) : BitConverter.DoubleToInt64Bits(firstOp[i-2]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Ceiling",                                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Ceiling(firstOp[0]))",                                                                                                                                              ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(Math.Ceiling(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Ceiling",                                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Ceiling(firstOp[0]))",                                                                                                                                             ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(MathF.Ceiling(firstOp[i]))"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareEqual",                             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] == right[0]) ? -1 : 0)",                                                                                                                                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] == right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareEqual",                             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] == right[0]) ? -1 : 0)",                                                                                                                                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] == right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareGreaterThan",                       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] > right[0]) ? -1 : 0)",                                                                                                                                                                       ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] > right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareGreaterThan",                       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] > right[0]) ? -1 : 0)",                                                                                                                                                                       ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] > right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareGreaterThanOrEqual",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] >= right[0]) ? -1 : 0)",                                                                                                                                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] >= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareGreaterThanOrEqual",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] >= right[0]) ? -1 : 0)",                                                                                                                                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] >= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareLessThan",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] < right[0]) ? -1 : 0)",                                                                                                                                                                       ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] < right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareLessThan",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] < right[0]) ? -1 : 0)",                                                                                                                                                                       ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] < right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareLessThanOrEqual",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] <= right[0]) ? -1 : 0)",                                                                                                                                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] <= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareLessThanOrEqual",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] <= right[0]) ? -1 : 0)",                                                                                                                                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] <= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareNotEqual",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] != right[0]) ? -1 : 0)",                                                                                                                                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] != right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareNotEqual",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] != right[0]) ? -1 : 0)",                                                                                                                                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] != right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareNotGreaterThan",                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (!(left[0] > right[0]) ? -1 : 0)",                                                                                                                                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (!(left[i] > right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareNotGreaterThan",                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (!(left[0] > right[0]) ? -1 : 0)",                                                                                                                                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (!(left[i] > right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareNotGreaterThanOrEqual",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (!(left[0] >= right[0]) ? -1 : 0)",                                                                                                                                                                     ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (!(left[i] >= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareNotGreaterThanOrEqual",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (!(left[0] >= right[0]) ? -1 : 0)",                                                                                                                                                                     ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (!(left[i] >= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareNotLessThan",                       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (!(left[0] < right[0]) ? -1 : 0)",                                                                                                                                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (!(left[i] < right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareNotLessThan",                       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (!(left[0] < right[0]) ? -1 : 0)",                                                                                                                                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (!(left[i] < right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareNotLessThanOrEqual",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (!(left[0] <= right[0]) ? -1 : 0)",                                                                                                                                                                     ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (!(left[i] <= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareNotLessThanOrEqual",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (!(left[0] <= right[0]) ? -1 : 0)",                                                                                                                                                                     ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (!(left[i] <= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareOrdered",                           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((!float.IsNaN(left[0]) && !float.IsNaN(right[0])) ? -1 : 0)",                                                                                                                                          ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((!float.IsNaN(left[i]) && !float.IsNaN(right[i])) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareOrdered",                           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((!double.IsNaN(left[0]) && !double.IsNaN(right[0])) ? -1 : 0)",                                                                                                                                        ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((!double.IsNaN(left[i]) && !double.IsNaN(right[i])) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareUnordered",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((float.IsNaN(left[0]) || float.IsNaN(right[0])) ? -1 : 0)",                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((float.IsNaN(left[i]) || float.IsNaN(right[i])) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "CompareUnordered",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((double.IsNaN(left[0]) || double.IsNaN(right[0])) ? -1 : 0)",                                                                                                                                          ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((double.IsNaN(left[i]) || double.IsNaN(right[i])) ? -1 : 0)"}),
    ("SimpleUnOpConvTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "ConvertToVector256Int32",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "result[0] != (int)MathF.Round(firstOp[0])",                                                                                                                                                                                                          ["ValidateRemainingResults"] = "result[i] != (int) MathF.Round(firstOp[i], 0)"}),
    ("SimpleUnOpConvTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "ConvertToVector256Int32WithTruncation",    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "result[0] != (int)firstOp[0]",                                                                                                                                                                                                                       ["ValidateRemainingResults"] = "result[i] != (int)firstOp[i]"}),
    ("SimpleUnOpConvTest.template",  new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "ConvertToVector256Single",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                                                                                     ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                      ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits((float)firstOp[0])",                                                                                                                                                     ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits((float)firstOp[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Divide",                                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] / right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i] / right[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Divide",                                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] / right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i] / right[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("ComplexUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "DuplicateEvenIndexed",                     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(firstOp[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                                                            ["ValidateRemainingResults"] = "((i & 1) == 0) ? (BitConverter.DoubleToInt64Bits(firstOp[i]) != BitConverter.DoubleToInt64Bits(result[i])) : (BitConverter.DoubleToInt64Bits(firstOp[i - 1]) != BitConverter.DoubleToInt64Bits(result[i]))"}),
    ("ComplexUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "DuplicateEvenIndexed",                     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                                            ["ValidateRemainingResults"] = "((i & 1) == 0) ? (BitConverter.SingleToInt32Bits(firstOp[i]) != BitConverter.SingleToInt32Bits(result[i])) : (BitConverter.SingleToInt32Bits(firstOp[i - 1]) != BitConverter.SingleToInt32Bits(result[i]))"}),
    ("ComplexUnOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "DuplicateOddIndexed",                      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(firstOp[1]) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                                            ["ValidateRemainingResults"] = "((i & 1) == 0) ? (BitConverter.SingleToInt32Bits(firstOp[i + 1]) != BitConverter.SingleToInt32Bits(result[i])) : (BitConverter.SingleToInt32Bits(firstOp[i]) != BitConverter.SingleToInt32Bits(result[i]))"}),
    ("ImmUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "ExtractVector128",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single",                                                                                                                                                   ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(firstOp[4])",                                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(firstOp[i+4])"}),
    ("ImmUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "ExtractVector128",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double",                                                                                                                                                   ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(firstOp[2])",                                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(firstOp[i+2])"}),
    ("ImmUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "ExtractVector128",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",                                                                                                                                                     ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                       ["ValidateFirstResult"] = "result[0] != firstOp[16]",                                                                                                                                                                                                                           ["ValidateRemainingResults"] = "result[i] != firstOp[i+16]"}),
    ("ImmUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "ExtractVector128",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",                                                                                                                                                    ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                      ["ValidateFirstResult"] = "result[0] != firstOp[16]",                                                                                                                                                                                                                           ["ValidateRemainingResults"] = "result[i] != firstOp[i+16]"}),
    ("ImmUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "ExtractVector128",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",                                                                                                                                                    ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                      ["ValidateFirstResult"] = "result[0] != firstOp[8]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != firstOp[i+8]"}),
    ("ImmUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "ExtractVector128",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16",                                                                                                                                                   ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                     ["ValidateFirstResult"] = "result[0] != firstOp[8]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != firstOp[i+8]"}),
    ("ImmUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "ExtractVector128",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                                                                    ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                      ["ValidateFirstResult"] = "result[0] != firstOp[4]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != firstOp[i+4]"}),
    ("ImmUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "ExtractVector128",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32",                                                                                                                                                   ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                     ["ValidateFirstResult"] = "result[0] != firstOp[4]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != firstOp[i+4]"}),
    ("ImmUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "ExtractVector128",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",                                                                                                                                                    ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                      ["ValidateFirstResult"] = "result[0] != firstOp[2]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != firstOp[i+2]"}),
    ("ImmUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "ExtractVector128",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64",                                                                                                                                                   ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                     ["ValidateFirstResult"] = "result[0] != firstOp[2]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != firstOp[i+2]"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "InsertVector128",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                                                        ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                               ["ValidateFirstResult"] = "result[0] != left[0]",                                                                                                                                                                                                                               ["ValidateRemainingResults"] = "result[i] != (i < 16 ? left[i] : right[i-16])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "InsertVector128",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                              ["ValidateFirstResult"] = "result[0] != left[0]",                                                                                                                                                                                                                               ["ValidateRemainingResults"] = "result[i] != (i < 16 ? left[i] : right[i-16])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "InsertVector128",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                              ["ValidateFirstResult"] = "result[0] != left[0]",                                                                                                                                                                                                                               ["ValidateRemainingResults"] = "result[i] != (i < 8 ? left[i] : right[i-8])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "InsertVector128",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                             ["ValidateFirstResult"] = "result[0] != left[0]",                                                                                                                                                                                                                               ["ValidateRemainingResults"] = "result[i] != (i < 8 ? left[i] : right[i-8])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "InsertVector128",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                              ["ValidateFirstResult"] = "result[0] != left[0]",                                                                                                                                                                                                                               ["ValidateRemainingResults"] = "result[i] != (i < 4 ? left[i] : right[i-4])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "InsertVector128",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                             ["ValidateFirstResult"] = "result[0] != left[0]",                                                                                                                                                                                                                               ["ValidateRemainingResults"] = "result[i] != (i < 4 ? left[i] : right[i-4])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "InsertVector128",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                                                                       ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                              ["ValidateFirstResult"] = "result[0] != left[0]",                                                                                                                                                                                                                               ["ValidateRemainingResults"] = "result[i] != (i < 2 ? left[i] : right[i-2])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "InsertVector128",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                             ["ValidateFirstResult"] = "result[0] != left[0]",                                                                                                                                                                                                                               ["ValidateRemainingResults"] = "result[i] != (i < 2 ? left[i] : right[i-2])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "InsertVector128",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(left[0])",                                                                                                                                                               ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (i < 4 ? BitConverter.SingleToInt32Bits(left[i]) : BitConverter.SingleToInt32Bits(right[i-4]))"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "InsertVector128",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(left[0])",                                                                                                                                                               ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (i < 2 ? BitConverter.DoubleToInt64Bits(left[i]) : BitConverter.DoubleToInt64Bits(right[i-2]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Floor",                                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Floor(firstOp[0]))",                                                                                                                                                ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(Math.Floor(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Floor",                                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Floor(firstOp[0]))",                                                                                                                                               ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(MathF.Floor(firstOp[i]))"}),
    ("LoadUnOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx",                       ["Method"] = "LoadVector256",                           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(firstOp[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("LoadUnOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx",                       ["Method"] = "LoadVector256",                           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(firstOp[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(firstOp[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("LoadUnOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx",                       ["Method"] = "LoadVector256",                           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",                                                                                                                                                                      ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                       ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "firstOp[i] != result[i]"}),
    ("LoadUnOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx",                       ["Method"] = "LoadVector256",                           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",                                                                                                                                                                     ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                      ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "firstOp[i] != result[i]"}),
    ("LoadUnOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx",                       ["Method"] = "LoadVector256",                           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",                                                                                                                                                                     ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                      ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "firstOp[i] != result[i]"}),
    ("LoadUnOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx",                       ["Method"] = "LoadVector256",                           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                     ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "firstOp[i] != result[i]"}),
    ("LoadUnOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx",                       ["Method"] = "LoadVector256",                           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                                                                                     ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                      ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "firstOp[i] != result[i]"}),
    ("LoadUnOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx",                       ["Method"] = "LoadVector256",                           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                     ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "firstOp[i] != result[i]"}),
    ("LoadUnOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx",                       ["Method"] = "LoadVector256",                           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",                                                                                                                                                                     ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                      ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "firstOp[i] != result[i]"}),
    ("LoadUnOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx",                       ["Method"] = "LoadVector256",                           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                     ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "firstOp[i] != result[i]"}),
    ("LoadBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "MaskLoad",                                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits((BitConverter.DoubleToInt64Bits(right[0]) < 0) ? left[0] : 0)",                                                                                                          ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits((BitConverter.DoubleToInt64Bits(right[i]) < 0) ? left[i] : 0)"}),
    ("LoadBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "MaskLoad",                                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits((BitConverter.SingleToInt32Bits(right[0]) < 0) ? left[0] : 0)",                                                                                                          ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits((BitConverter.SingleToInt32Bits(right[i]) < 0) ? left[i] : 0)"}),
    ("StoreBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "MaskStore",                                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits((BitConverter.DoubleToInt64Bits(left[0]) < 0) ? right[0] : BitConverter.DoubleToInt64Bits(result[0]))",                                                                  ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits((BitConverter.DoubleToInt64Bits(left[i]) < 0) ? right[i] : BitConverter.DoubleToInt64Bits(result[i]))"}),
    ("StoreBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "MaskStore",                                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits((BitConverter.SingleToInt32Bits(left[0]) < 0) ? right[0] : BitConverter.SingleToInt32Bits(result[0]))",                                                                  ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits((BitConverter.SingleToInt32Bits(left[i]) < 0) ? right[i] : BitConverter.SingleToInt32Bits(result[i]))"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Max",                                      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Math.Max(left[0], right[0])) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                                           ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(Math.Max(left[i], right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Max",                                      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(MathF.Max(left[0], right[0])) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                          ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(MathF.Max(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Min",                                      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Math.Min(left[0], right[0])) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                                           ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(Math.Min(left[i], right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Min",                                      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(MathF.Min(left[0], right[0])) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                          ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(MathF.Min(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimdScalarUnOpConvTest.template", new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "MoveMask",                                                               ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "(uint)result != SseVerify.MoveMask(firstOp)"}),
    ("SimdScalarUnOpConvTest.template", new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "MoveMask",                                                               ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "(uint)result != SseVerify.MoveMask(firstOp)"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Multiply",                                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] * right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i] * right[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Multiply",                                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] * right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i] * right[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Or",                                       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "(BitConverter.DoubleToInt64Bits(left[0]) | BitConverter.DoubleToInt64Bits(right[0])) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                  ["ValidateRemainingResults"] = "(BitConverter.DoubleToInt64Bits(left[i]) | BitConverter.DoubleToInt64Bits(right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Or",                                       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "(BitConverter.SingleToInt32Bits(left[0]) | BitConverter.SingleToInt32Bits(right[0])) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                  ["ValidateRemainingResults"] = "(BitConverter.SingleToInt32Bits(left[i]) | BitConverter.SingleToInt32Bits(right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("ImmUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Permute",                                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single",                                                                                                                                                   ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(firstOp[1])",                                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[4]) != BitConverter.SingleToInt32Bits(firstOp[5])"}),
    ("ImmUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Permute",                                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double",                                                                                                                                                   ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(firstOp[1])",                                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[2]) != BitConverter.DoubleToInt64Bits(firstOp[2]) || BitConverter.DoubleToInt64Bits(result[2]) != BitConverter.DoubleToInt64Bits(firstOp[2])"}),
    ("ImmUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Sse", ["Method"] = "Permute",                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                   ["Imm"] = "2",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(firstOp[2])",                                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[1]) != BitConverter.SingleToInt32Bits(firstOp[0]) || BitConverter.SingleToInt32Bits(result[2]) != BitConverter.SingleToInt32Bits(firstOp[0])"}),
    ("ImmUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Sse2",["Method"] = "Permute",                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                                                                                                   ["Imm"] = "2",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(firstOp[0])",                                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[1]) != BitConverter.DoubleToInt64Bits(firstOp[1])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Permute2x128",                             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                      ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(right[0])",                                                                                                                                                              ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (i < 2 ? BitConverter.DoubleToInt64Bits(right[i]) : BitConverter.DoubleToInt64Bits(left[i-2]))"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Permute2x128",                             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                      ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(right[0])",                                                                                                                                                              ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (i < 4 ? BitConverter.SingleToInt32Bits(right[i]) : BitConverter.SingleToInt32Bits(left[i-4]))"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Permute2x128",                             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                        ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                               ["ValidateFirstResult"] = "result[0] != right[0]",                                                                                                                                                                                                                              ["ValidateRemainingResults"] = "result[i] != (i < 16 ? right[i] : left[i-16])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Permute2x128",                             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                                       ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                              ["ValidateFirstResult"] = "result[0] != right[0]",                                                                                                                                                                                                                              ["ValidateRemainingResults"] = "result[i] != (i < 16 ? right[i] : left[i-16])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Permute2x128",                             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                                       ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                              ["ValidateFirstResult"] = "result[0] != right[0]",                                                                                                                                                                                                                              ["ValidateRemainingResults"] = "result[i] != (i < 8 ? right[i] : left[i-8])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Permute2x128",                             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                                      ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                             ["ValidateFirstResult"] = "result[0] != right[0]",                                                                                                                                                                                                                              ["ValidateRemainingResults"] = "result[i] != (i < 8 ? right[i] : left[i-8])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Permute2x128",                             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                                       ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                              ["ValidateFirstResult"] = "result[0] != right[0]",                                                                                                                                                                                                                              ["ValidateRemainingResults"] = "result[i] != (i < 4 ? right[i] : left[i-4])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Permute2x128",                             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                                      ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                             ["ValidateFirstResult"] = "result[0] != right[0]",                                                                                                                                                                                                                              ["ValidateRemainingResults"] = "result[i] != (i < 4 ? right[i] : left[i-4])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Permute2x128",                             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                                                       ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                              ["ValidateFirstResult"] = "result[0] != right[0]",                                                                                                                                                                                                                              ["ValidateRemainingResults"] = "result[i] != (i < 2 ? right[i] : left[i-2])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Permute2x128",                             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                                                      ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                             ["ValidateFirstResult"] = "result[0] != right[0]",                                                                                                                                                                                                                              ["ValidateRemainingResults"] = "result[i] != (i < 2 ? right[i] : left[i-2])"}),
    ("ComplexBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "PermuteVar",                               ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                                                        ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "1",                                                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[1]) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                                               ["ValidateRemainingResults"] = "i > 3 ? (BitConverter.SingleToInt32Bits(left[5]) != BitConverter.SingleToInt32Bits(result[i])) : (BitConverter.SingleToInt32Bits(left[1]) != BitConverter.SingleToInt32Bits(result[i]))"}),
    ("ComplexBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "PermuteVar",                               ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                                                                        ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "(long)1",                                                                                       ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                                                               ["ValidateRemainingResults"] = "i > 1 ? (BitConverter.DoubleToInt64Bits(left[2]) != BitConverter.DoubleToInt64Bits(result[i])) : (BitConverter.DoubleToInt64Bits(left[0]) != BitConverter.DoubleToInt64Bits(result[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "RoundCurrentDirection",                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Round(firstOp[0]))",                                                                                                                                                ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(Math.Round(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "RoundCurrentDirection",                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Round(firstOp[0]))",                                                                                                                                               ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(MathF.Round(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "RoundToNearestInteger",                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Round(firstOp[0], MidpointRounding.AwayFromZero))",                                                                                                                 ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(Math.Round(firstOp[i], MidpointRounding.AwayFromZero))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "RoundToNearestInteger",                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Round(firstOp[0], MidpointRounding.AwayFromZero))",                                                                                                                ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(MathF.Round(firstOp[i], MidpointRounding.AwayFromZero))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "RoundToNegativeInfinity",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Floor(firstOp[0]))",                                                                                                                                                ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(Math.Floor(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "RoundToNegativeInfinity",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Floor(firstOp[0]))",                                                                                                                                               ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(MathF.Floor(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "RoundToPositiveInfinity",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(Math.Ceiling(firstOp[0]))",                                                                                                                                              ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(Math.Ceiling(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "RoundToPositiveInfinity",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(MathF.Ceiling(firstOp[0]))",                                                                                                                                             ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(MathF.Ceiling(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "RoundToZero",                              ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits((firstOp[0] > 0) ? Math.Floor(firstOp[0]) : Math.Ceiling(firstOp[0]))",                                                                                                  ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits((firstOp[i] > 0) ? Math.Floor(firstOp[i]) : Math.Ceiling(firstOp[i]))"}),
    ("SimpleUnOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "RoundToZero",                              ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single",                                                                                                                                                                    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits((firstOp[0] > 0) ? MathF.Floor(firstOp[0]) : MathF.Ceiling(firstOp[0]))",                                                                                                ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits((firstOp[i] > 0) ? MathF.Floor(firstOp[i]) : MathF.Ceiling(firstOp[i]))"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Shuffle",                                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(left[1])",                                                                                                                                                               ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[7]) != BitConverter.SingleToInt32Bits(right[4])"}),
    ("ImmBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Shuffle",                                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                      ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(left[1])",                                                                                                                                                               ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[3]) != BitConverter.DoubleToInt64Bits(right[2])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Subtract",                                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] - right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i] - right[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Subtract",                                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] - right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i] - right[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestC",                                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                                         ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                               ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestC",                                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                                                        ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                              ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestC",                                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                                                        ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                              ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestC",                                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                                                                        ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                              ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestC",                                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                                                        ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                              ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestC",                                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                             ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestC",                                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                             ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestC",                                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                             ["ValidateFirstResult"] = "(~left[i] & right[i]) == 0"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestNotZAndNotC",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                                         ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                               ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestNotZAndNotC",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                                                        ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                              ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestNotZAndNotC",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                                                        ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                              ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestNotZAndNotC",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                                                                        ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                              ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestNotZAndNotC",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                                                        ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                              ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestNotZAndNotC",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                             ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestNotZAndNotC",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                             ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanTwoCmpOpTest.template", new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestNotZAndNotC",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                             ["ValidateFirstResult"] = "((left[i] & right[i]) == 0)",                                                                                                                                                                                                                        ["ValidateRemainingResults"] = "((~left[i] & right[i]) == 0)"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestZ",                                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                                         ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                               ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestZ",                                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                                                        ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                              ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestZ",                                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                                                        ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                              ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestZ",                                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                                                                        ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                              ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestZ",                                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                                                        ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                              ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestZ",                                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                             ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestZ",                                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                             ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("BooleanBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "TestZ",                                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                             ["ValidateFirstResult"] = "(left[i] & right[i]) == 0"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Xor",                                      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "(BitConverter.SingleToInt32Bits(left[0]) ^ BitConverter.SingleToInt32Bits(right[0])) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                  ["ValidateRemainingResults"] = "(BitConverter.SingleToInt32Bits(left[i]) ^ BitConverter.SingleToInt32Bits(right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "Xor",                                      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "(BitConverter.DoubleToInt64Bits(left[0]) ^ BitConverter.DoubleToInt64Bits(right[0])) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                  ["ValidateRemainingResults"] = "(BitConverter.DoubleToInt64Bits(left[i]) ^ BitConverter.DoubleToInt64Bits(right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
};

(string templateFileName, Dictionary<string, string> templateData)[] Avx1_Vector128Inputs = new []
{
    ("LoadBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "MaskLoad",                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits((BitConverter.DoubleToInt64Bits(right[0]) < 0) ? left[0] : 0)",                                         ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits((BitConverter.DoubleToInt64Bits(right[i]) < 0) ? left[i] : 0)"}),
    ("LoadBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "MaskLoad",                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits((BitConverter.SingleToInt32Bits(right[0]) < 0) ? left[0] : 0)",                                         ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits((BitConverter.SingleToInt32Bits(right[i]) < 0) ? left[i] : 0)"}),
    ("StoreBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "MaskStore",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits((BitConverter.DoubleToInt64Bits(left[0]) < 0) ? right[0] : BitConverter.DoubleToInt64Bits(result[0]))", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits((BitConverter.DoubleToInt64Bits(left[i]) < 0) ? right[i] : BitConverter.DoubleToInt64Bits(result[i]))"}),
    ("StoreBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "MaskStore",               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits((BitConverter.SingleToInt32Bits(left[0]) < 0) ? right[0] : BitConverter.SingleToInt32Bits(result[0]))", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits((BitConverter.SingleToInt32Bits(left[i]) < 0) ? right[i] : BitConverter.SingleToInt32Bits(result[i]))"}),
    ("ComplexBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "PermuteVar",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "1",                                 ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[1]) != BitConverter.SingleToInt32Bits(result[0])",                                                                                              ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[1]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("ComplexBinOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx", ["LoadIsa"] = "Avx", ["Method"] = "PermuteVar",              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "(long)1",                           ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                              ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[0]) != BitConverter.DoubleToInt64Bits(result[i])"}),
};

(string templateFileName, Dictionary<string, string> templateData)[] Avx2Inputs = new []
{
    ("SimpleUnOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Abs",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",                                                                                                                                            ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                   ["ValidateFirstResult"] = "result[0] != (byte)((firstOp[0] < 0) ? -firstOp[0] : firstOp[0])",                        ["ValidateRemainingResults"] = "result[i] != (byte)((firstOp[i] < 0) ? -firstOp[i] : firstOp[i])"}),
    ("SimpleUnOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Abs",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",                                                                                                                                            ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                   ["ValidateFirstResult"] = "result[0] != (ushort)((firstOp[0] < 0) ? -firstOp[0] : firstOp[0])",                      ["ValidateRemainingResults"] = "result[i] != (ushort)((firstOp[i] < 0) ? -firstOp[i] : firstOp[i])"}),
    ("SimpleUnOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Abs",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                                                            ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                   ["ValidateFirstResult"] = "result[0] != (uint)((firstOp[0] < 0) ? -firstOp[0] : firstOp[0])",                        ["ValidateRemainingResults"] = "result[i] != (uint)((firstOp[i] < 0) ? -firstOp[i] : firstOp[i])"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Add",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                            ["ValidateFirstResult"] = "(byte)(left[0] + right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(byte)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Add",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "(short)(left[0] + right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(short)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Add",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "(int)(left[0] + right[0]) != result[0]",                                                  ["ValidateRemainingResults"] = "(int)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Add",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                           ["ValidateFirstResult"] = "(long)(left[0] + right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(long)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Add",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                           ["ValidateFirstResult"] = "(sbyte)(left[0] + right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(sbyte)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Add",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "(ushort)(left[0] + right[0]) != result[0]",                                               ["ValidateRemainingResults"] = "(ushort)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Add",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "(uint)(left[0] + right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(uint)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Add",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                          ["ValidateFirstResult"] = "(ulong)(left[0] + right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(ulong)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AddSaturate",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                            ["ValidateFirstResult"] = "SseVerify.AddSaturate(left[0], right[0], result[0])",                                     ["ValidateRemainingResults"] = "SseVerify.AddSaturate(left[i], right[i], result[i])"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AddSaturate",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                           ["ValidateFirstResult"] = "SseVerify.AddSaturate(left[0], right[0], result[0])",                                     ["ValidateRemainingResults"] = "SseVerify.AddSaturate(left[i], right[i], result[i])"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AddSaturate",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "SseVerify.AddSaturate(left[0], right[0], result[0])",                                     ["ValidateRemainingResults"] = "SseVerify.AddSaturate(left[i], right[i], result[i])"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AddSaturate",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "SseVerify.AddSaturate(left[0], right[0], result[0])",                                     ["ValidateRemainingResults"] = "SseVerify.AddSaturate(left[i], right[i], result[i])"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                              ["Imm"] = "5",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                           ["ValidateFirstResult"] = "result[0] != right[5]",                                                                   ["ValidateRemainingResults"] = "(result[i] != ((i < 16) ? ((i < 11) ? right[i + 5] : left[i - 11]) : ((i < 27) ? right[i + 5] : left[i - 11])))"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                              ["Imm"] = "27",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                           ["ValidateFirstResult"] = "result[0] != left[11]",                                                                   ["ValidateRemainingResults"] = "(result[i] != ((i < 16) ? ((i < 5) ? left[i + 11] : 0) : ((i < 21) ? left[i + 11] : 0)))"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                              ["Imm"] = "228", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                           ["ValidateFirstResult"] = "result[0] != 0",                                                                          ["ValidateRemainingResults"] = "result[i] != 0"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                              ["Imm"] = "250", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                           ["ValidateFirstResult"] = "result[0] != 0",                                                                          ["ValidateRemainingResults"] = "result[i] != 0"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                               ["Imm"] = "5",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                            ["ValidateFirstResult"] = "result[0] != right[5]",                                                                   ["ValidateRemainingResults"] = "(result[i] != ((i < 16) ? ((i < 11) ? right[i + 5] : left[i - 11]) : ((i < 27) ? right[i + 5] : left[i - 11])))"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                               ["Imm"] = "27",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                            ["ValidateFirstResult"] = "result[0] != left[11]",                                                                   ["ValidateRemainingResults"] = "(result[i] != ((i < 16) ? ((i < 5) ? left[i + 11] : 0) : ((i < 21) ? left[i + 11] : 0)))"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                               ["Imm"] = "228", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                            ["ValidateFirstResult"] = "result[0] != 0",                                                                          ["ValidateRemainingResults"] = "result[i] != 0"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                               ["Imm"] = "250", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                            ["ValidateFirstResult"] = "result[0] != 0",                                                                          ["ValidateRemainingResults"] = "result[i] != 0"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                              ["Imm"] = "0",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "result[0] != right[0]",                                                                   ["ValidateRemainingResults"] = "result[i] != right[i]"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                              ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "result[0] != right[1]",                                                                   ["ValidateRemainingResults"] = "result[i] != (i < 8 ? (i == 7 ? left[0] : right[i+1]) : (i == 15 ? left[8] : right[i+1]))"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                             ["Imm"] = "0",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "result[0] != right[0]",                                                                   ["ValidateRemainingResults"] = "result[i] != right[i]"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                             ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "result[0] != right[1]",                                                                   ["ValidateRemainingResults"] = "result[i] != (i < 8 ? (i == 7 ? left[0] : right[i+1]) : (i == 15 ? left[8] : right[i+1]))"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                              ["Imm"] = "0",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "result[0] != right[0]",                                                                   ["ValidateRemainingResults"] = "result[i] != right[i]"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                              ["Imm"] = "4",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "result[0] != right[1]",                                                                   ["ValidateRemainingResults"] = "result[i] != (i < 4 ? (i == 3 ? left[0] : right[i+1]) : (i == 7 ? left[4] : right[i+1]))"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                             ["Imm"] = "0",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "result[0] != right[0]",                                                                   ["ValidateRemainingResults"] = "result[i] != right[i]"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                             ["Imm"] = "4",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "result[0] != right[1]",                                                                   ["ValidateRemainingResults"] = "result[i] != (i < 4 ? (i == 3 ? left[0] : right[i+1]) : (i == 7 ? left[4] : right[i+1]))"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                              ["Imm"] = "0",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                           ["ValidateFirstResult"] = "result[0] != right[0]",                                                                   ["ValidateRemainingResults"] = "result[i] != right[i]"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                              ["Imm"] = "8",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                           ["ValidateFirstResult"] = "result[0] != right[1]",                                                                   ["ValidateRemainingResults"] = "result[i] != (i < 2 ? (i == 1 ? left[0] : right[i+1]) : (i == 3 ? left[2] : right[i+1]))"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                             ["Imm"] = "0",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                          ["ValidateFirstResult"] = "result[0] != right[0]",                                                                   ["ValidateRemainingResults"] = "result[i] != right[i]"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AlignRight",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                             ["Imm"] = "8",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                          ["ValidateFirstResult"] = "result[0] != right[1]",                                                                   ["ValidateRemainingResults"] = "result[i] != (i < 2 ? (i == 1 ? left[0] : right[i+1]) : (i == 3 ? left[2] : right[i+1]))"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "And",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                            ["ValidateFirstResult"] = "(byte)(left[0] & right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(byte)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "And",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "(short)(left[0] & right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(short)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "And",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "(int)(left[0] & right[0]) != result[0]",                                                  ["ValidateRemainingResults"] = "(int)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "And",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                           ["ValidateFirstResult"] = "(long)(left[0] & right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(long)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "And",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                           ["ValidateFirstResult"] = "(sbyte)(left[0] & right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(sbyte)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "And",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "(ushort)(left[0] & right[0]) != result[0]",                                               ["ValidateRemainingResults"] = "(ushort)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "And",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "(uint)(left[0] & right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(uint)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "And",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                          ["ValidateFirstResult"] = "(ulong)(left[0] & right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(ulong)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AndNot",                      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                            ["ValidateFirstResult"] = "(byte)(~left[0] & right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(byte)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AndNot",                      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "(short)(~left[0] & right[0]) != result[0]",                                               ["ValidateRemainingResults"] = "(short)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AndNot",                      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "(int)(~left[0] & right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(int)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AndNot",                      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                           ["ValidateFirstResult"] = "(long)(~left[0] & right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(long)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AndNot",                      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                           ["ValidateFirstResult"] = "(sbyte)(~left[0] & right[0]) != result[0]",                                               ["ValidateRemainingResults"] = "(sbyte)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AndNot",                      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "(ushort)(~left[0] & right[0]) != result[0]",                                              ["ValidateRemainingResults"] = "(ushort)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AndNot",                      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "(uint)(~left[0] & right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(uint)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "AndNot",                      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                          ["ValidateFirstResult"] = "(ulong)(~left[0] & right[0]) != result[0]",                                               ["ValidateRemainingResults"] = "(ulong)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Average",                     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                            ["ValidateFirstResult"] = "(byte)((left[0] + right[0] + 1) >> 1) != result[0]",                                      ["ValidateRemainingResults"] = "(byte)((left[i] + right[i] + 1) >> 1) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Average",                     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "(ushort)((left[0] + right[0] + 1) >> 1) != result[0]",                                    ["ValidateRemainingResults"] = "(ushort)((left[i] + right[i] + 1) >> 1) != result[i]"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Blend",                       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                              ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "result[0] != (((1 & (1 << 0)) == 0) ? left[0] : right[0])",                               ["ValidateRemainingResults"] = "result[i] != ((i < 8) ? (((1 & (1 << i)) == 0) ? left[i] : right[i]) : (((1 & (1 << (i - 8))) == 0) ? left[i] : right[i]))"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Blend",                       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                              ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "result[0] != (((2 & (1 << 0)) == 0) ? left[0] : right[0])",                               ["ValidateRemainingResults"] = "result[i] != ((i < 8) ? (((2 & (1 << i)) == 0) ? left[i] : right[i]) : (((2 & (1 << (i - 8))) == 0) ? left[i] : right[i]))"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Blend",                       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                              ["Imm"] = "4",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "result[0] != (((4 & (1 << 0)) == 0) ? left[0] : right[0])",                               ["ValidateRemainingResults"] = "result[i] != ((i < 8) ? (((4 & (1 << i)) == 0) ? left[i] : right[i]) : (((4 & (1 << (i - 8))) == 0) ? left[i] : right[i]))"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Blend",                       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                              ["Imm"] = "85",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "result[0] != (((85 & (1 << 0)) == 0) ? left[0] : right[0])",                              ["ValidateRemainingResults"] = "result[i] != ((i < 8) ? (((85 & (1 << i)) == 0) ? left[i] : right[i]) : (((85 & (1 << (i - 8))) == 0) ? left[i] : right[i]))"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Blend",                       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                             ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "result[0] != (((1 & (1 << 0)) == 0) ? left[0] : right[0])",                               ["ValidateRemainingResults"] = "result[i] != ((i < 8) ? (((1 & (1 << i)) == 0) ? left[i] : right[i]) : (((1 & (1 << (i - 8))) == 0) ? left[i] : right[i]))"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Blend",                       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                             ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "result[0] != (((2 & (1 << 0)) == 0) ? left[0] : right[0])",                               ["ValidateRemainingResults"] = "result[i] != ((i < 8) ? (((2 & (1 << i)) == 0) ? left[i] : right[i]) : (((2 & (1 << (i - 8))) == 0) ? left[i] : right[i]))"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Blend",                       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                             ["Imm"] = "4",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "result[0] != (((4 & (1 << 0)) == 0) ? left[0] : right[0])",                               ["ValidateRemainingResults"] = "result[i] != ((i < 8) ? (((4 & (1 << i)) == 0) ? left[i] : right[i]) : (((4 & (1 << (i - 8))) == 0) ? left[i] : right[i]))"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Blend",                       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                             ["Imm"] = "85",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "result[0] != (((85 & (1 << 0)) == 0) ? left[0] : right[0])",                              ["ValidateRemainingResults"] = "result[i] != ((i < 8) ? (((85 & (1 << i)) == 0) ? left[i] : right[i]) : (((85 & (1 << (i - 8))) == 0) ? left[i] : right[i]))"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Blend",                       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                              ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "result[0] != (((1 & (1 << 0)) == 0) ? left[0] : right[0])",                               ["ValidateRemainingResults"] = "result[i] != (((1 & (1 << i)) == 0) ? left[i] : right[i])"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Blend",                       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                              ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "result[0] != (((2 & (1 << 0)) == 0) ? left[0] : right[0])",                               ["ValidateRemainingResults"] = "result[i] != (((2 & (1 << i)) == 0) ? left[i] : right[i])"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Blend",                       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                              ["Imm"] = "4",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "result[0] != (((4 & (1 << 0)) == 0) ? left[0] : right[0])",                               ["ValidateRemainingResults"] = "result[i] != (((4 & (1 << i)) == 0) ? left[i] : right[i])"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Blend",                       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                              ["Imm"] = "85",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "result[0] != (((85 & (1 << 0)) == 0) ? left[0] : right[0])",                              ["ValidateRemainingResults"] = "result[i] != (((85 & (1 << i)) == 0) ? left[i] : right[i])"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Blend",                       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                             ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "result[0] != (((1 & (1 << 0)) == 0) ? left[0] : right[0])",                               ["ValidateRemainingResults"] = "result[i] != (((1 & (1 << i)) == 0) ? left[i] : right[i])"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Blend",                       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                             ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "result[0] != (((2 & (1 << 0)) == 0) ? left[0] : right[0])",                               ["ValidateRemainingResults"] = "result[i] != (((2 & (1 << i)) == 0) ? left[i] : right[i])"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Blend",                       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                             ["Imm"] = "4",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "result[0] != (((4 & (1 << 0)) == 0) ? left[0] : right[0])",                               ["ValidateRemainingResults"] = "result[i] != (((4 & (1 << i)) == 0) ? left[i] : right[i])"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Blend",                       ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                             ["Imm"] = "85",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "result[0] != (((85 & (1 << 0)) == 0) ? left[0] : right[0])",                              ["ValidateRemainingResults"] = "result[i] != (((85 & (1 << i)) == 0) ? left[i] : right[i])"}),
    ("ComplexTernOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "BlendVariable",               ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "Byte",                   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp3"] = "(byte)(((i & 1) == 0) ? 128 : 1)",   ["ValidateFirstResult"] = "((thirdOp[0] >> 7) & 1) == 1 ? secondOp[0] != result[0] : firstOp[0] != result[0]",       ["ValidateRemainingResults"] = "((thirdOp[i] >> 7) & 1) == 1 ? secondOp[i] != result[i] : firstOp[i] != result[i]"}),
    ("ComplexTernOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "BlendVariable",               ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "SByte",                  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp3"] = "(sbyte)(((i & 1) == 0) ? -128 : 1)", ["ValidateFirstResult"] = "((thirdOp[0] >> 7) & 1) == 1 ? secondOp[0] != result[0] : firstOp[0] != result[0]",       ["ValidateRemainingResults"] = "((thirdOp[i] >> 7) & 1) == 1 ? secondOp[i] != result[i] : firstOp[i] != result[i]"}),
    ("ComplexTernOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "BlendVariable",               ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "Int16",                  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp3"] = "(((i & 1) == 0) ? Convert.ToInt16(\"0xFFFF\", 16) : (short)0)",      ["ValidateFirstResult"] = "(thirdOp[0] != 0) ? secondOp[0] != result[0] : firstOp[0] != result[0]",              ["ValidateRemainingResults"] = "(thirdOp[i] != 0) ? secondOp[i] != result[i] : firstOp[i] != result[i]"}),
    ("ComplexTernOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "BlendVariable",               ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "UInt16",                 ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp3"] = "(((i & 1) == 0) ? Convert.ToUInt16(\"0xFFFF\", 16) : (ushort)0)",    ["ValidateFirstResult"] = "(thirdOp[0] != 0) ? secondOp[0] != result[0] : firstOp[0] != result[0]",              ["ValidateRemainingResults"] = "(thirdOp[i] != 0) ? secondOp[i] != result[i] : firstOp[i] != result[i]"}),
    ("ComplexTernOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "BlendVariable",               ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "Int32",                  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp3"] = "(((i & 1) == 0) ? Convert.ToInt32(\"0xFFFFFFFF\", 16) : (int)0)",    ["ValidateFirstResult"] = "(thirdOp[0] != 0) ? secondOp[0] != result[0] : firstOp[0] != result[0]",              ["ValidateRemainingResults"] = "(thirdOp[i] != 0) ? secondOp[i] != result[i] : firstOp[i] != result[i]"}),
    ("ComplexTernOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "BlendVariable",               ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "UInt32",                 ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp3"] = "(((i & 1) == 0) ? Convert.ToUInt32(\"0xFFFFFFFF\", 16) : (uint)0)",  ["ValidateFirstResult"] = "(thirdOp[0] != 0) ? secondOp[0] != result[0] : firstOp[0] != result[0]",              ["ValidateRemainingResults"] = "(thirdOp[i] != 0) ? secondOp[i] != result[i] : firstOp[i] != result[i]"}),
    ("ComplexTernOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "BlendVariable",               ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "Int64",                  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp3"] = "(((i & 1) == 0) ? Convert.ToInt64(\"0xFFFFFFFFFFFFFFFF\", 16) : (long)0)",   ["ValidateFirstResult"] = "(thirdOp[0] != 0) ? secondOp[0] != result[0] : firstOp[0] != result[0]",      ["ValidateRemainingResults"] = "(thirdOp[i] != 0) ? secondOp[i] != result[i] : firstOp[i] != result[i]"}),
    ("ComplexTernOpTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "BlendVariable",               ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector256", ["Op3BaseType"] = "UInt64",                 ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp3"] = "(((i & 1) == 0) ? Convert.ToUInt64(\"0xFFFFFFFFFFFFFFFF\", 16): (ulong)0)",  ["ValidateFirstResult"] = "(thirdOp[0] != 0) ? secondOp[0] != result[0] : firstOp[0] != result[0]",      ["ValidateRemainingResults"] = "(thirdOp[i] != 0) ? secondOp[i] != result[i] : firstOp[i] != result[i]"}),
    ("BroadcastTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",                                                                                                                                             ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                    ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("BroadcastTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",                                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                   ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("BroadcastTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                   ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("BroadcastTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                  ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("BroadcastTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                   ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("BroadcastTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                  ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("BroadcastTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                   ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("BroadcastTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                  ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("BroadcastTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse",  ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                  ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[0])", ["ValidateRemainingResults"] = "(BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[i]))"}),
    ("BroadcastTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                  ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(firstOp[0]) != BitConverter.DoubleToInt64Bits(result[0])", ["ValidateRemainingResults"] = "(BitConverter.DoubleToInt64Bits(firstOp[0]) != BitConverter.DoubleToInt64Bits(result[i]))"}),
    ("BroadcastTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",                                                                                                                                             ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                    ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("BroadcastTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",                                                                                                                                            ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                   ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("BroadcastTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                                                                            ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                   ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("BroadcastTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                  ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("BroadcastTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                                                            ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                   ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("BroadcastTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                  ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("BroadcastTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                                                                            ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                   ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("BroadcastTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                  ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                 ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("BroadcastTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse",  ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                  ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[0])", ["ValidateRemainingResults"] = "(BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[i]))"}),
    ("BroadcastTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                  ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(firstOp[0]) != BitConverter.DoubleToInt64Bits(result[0])", ["ValidateRemainingResults"] = "(BitConverter.DoubleToInt64Bits(firstOp[0]) != BitConverter.DoubleToInt64Bits(result[i]))"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "CompareEqual",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                            ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((byte)(-1)) : 0)",                        ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((byte)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "CompareEqual",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((short)(-1)) : 0)",                       ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((short)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "CompareEqual",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((int)(-1)) : 0)",                         ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((int)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "CompareEqual",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                           ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((long)(-1)) : 0)",                        ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((long)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "CompareEqual",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                           ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((sbyte)(-1)) : 0)",                       ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((sbyte)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "CompareEqual",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((ushort)(-1)) : 0)",                      ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((ushort)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "CompareEqual",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((uint)(-1)) : 0)",                        ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((uint)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "CompareEqual",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                          ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((ulong)(-1)) : 0)",                       ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((ulong)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "CompareGreaterThan",          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? unchecked((short)(-1)) : 0)",                        ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? unchecked((short)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "CompareGreaterThan",          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? unchecked((int)(-1)) : 0)",                          ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? unchecked((int)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "CompareGreaterThan",          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                           ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? unchecked((long)(-1)) : 0)",                         ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? unchecked((long)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "CompareGreaterThan",          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                           ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? unchecked((sbyte)(-1)) : 0)",                        ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? unchecked((sbyte)(-1)) : 0)"}),
    ("SimdScalarUnOpTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ConvertToInt32",                                               ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                                                            ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                   ["ValidateFirstResult"] = "result != firstOp[0]"}),
    ("SimdScalarUnOpTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ConvertToUInt32",                                              ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32",                                                                                                                                           ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                  ["ValidateFirstResult"] = "result != firstOp[0]"}),
    ("ExtractVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ExtractVector128",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",                                                                                                                           ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                    ["ValidateFirstResult"] = "result[0] != firstOp[16]",                                                                ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 16])"}),
    ("ExtractVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ExtractVector128",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",                                                                                                                          ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                   ["ValidateFirstResult"] = "result[0] != firstOp[16]",                                                                ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 16])"}),
    ("ExtractVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ExtractVector128",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",                                                                                                                          ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                   ["ValidateFirstResult"] = "result[0] != firstOp[8]",                                                                 ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 8])"}),
    ("ExtractVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ExtractVector128",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16",                                                                                                                         ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                  ["ValidateFirstResult"] = "result[0] != firstOp[8]",                                                                 ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 8])"}),
    ("ExtractVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ExtractVector128",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                                          ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                   ["ValidateFirstResult"] = "result[0] != firstOp[4]",                                                                 ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 4])"}),
    ("ExtractVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ExtractVector128",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32",                                                                                                                         ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                  ["ValidateFirstResult"] = "result[0] != firstOp[4]",                                                                 ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 4])"}),
    ("ExtractVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ExtractVector128",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",                                                                                                                          ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                   ["ValidateFirstResult"] = "result[0] != firstOp[2]",                                                                 ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 2])"}),
    ("ExtractVector128Test.template", new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ExtractVector128",            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64",                                                                                                                         ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                  ["ValidateFirstResult"] = "result[0] != firstOp[2]",                                                                 ["ValidateRemainingResults"] = "(result[i] != firstOp[i + 2])"}),
    ("InsertVector128Test.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "InsertVector128",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                              ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                            ["ValidateFirstResult"] = "result[0] != left[0]",                                                                    ["ValidateRemainingResults"] = "(i > 15 ? result[i] != right[i - 16] : result[i] != left[i])"}),
    ("InsertVector128Test.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "InsertVector128",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                             ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                           ["ValidateFirstResult"] = "result[0] != left[0]",                                                                    ["ValidateRemainingResults"] = "(i > 15 ? result[i] != right[i - 16] : result[i] != left[i])"}),
    ("InsertVector128Test.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "InsertVector128",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                             ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "result[0] != left[0]",                                                                    ["ValidateRemainingResults"] = "(i > 7 ? result[i] != right[i - 8] : result[i] != left[i])"}),
    ("InsertVector128Test.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "InsertVector128",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                            ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "result[0] != left[0]",                                                                    ["ValidateRemainingResults"] = "(i > 7 ? result[i] != right[i - 8] : result[i] != left[i])"}),
    ("InsertVector128Test.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "InsertVector128",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                             ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "result[0] != left[0]",                                                                    ["ValidateRemainingResults"] = "(i > 3 ? result[i] != right[i - 4] : result[i] != left[i])"}),
    ("InsertVector128Test.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "InsertVector128",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                            ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "result[0] != left[0]",                                                                    ["ValidateRemainingResults"] = "(i > 3 ? result[i] != right[i - 4] : result[i] != left[i])"}),
    ("InsertVector128Test.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "InsertVector128",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                                             ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                           ["ValidateFirstResult"] = "result[0] != left[0]",                                                                    ["ValidateRemainingResults"] = "(i > 1 ? result[i] != right[i - 2] : result[i] != left[i])"}),
    ("InsertVector128Test.template",  new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "InsertVector128",             ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                                            ["Imm"] = "1",    ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                          ["ValidateFirstResult"] = "result[0] != left[0]",                                                                    ["ValidateRemainingResults"] = "(i > 1 ? result[i] != right[i - 2] : result[i] != left[i])"}),
    ("LoadBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "MaskLoad",                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "result[0] != ((right[0] < 0) ? left[0] : 0)",                                             ["ValidateRemainingResults"] = "result[i] != ((right[i] < 0) ? left[i] : 0)"}),
    ("LoadBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "MaskLoad",                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "result[0] != (((right[0] & (1U << 31)) != 0) ? left[0] : 0)",                             ["ValidateRemainingResults"] = "result[i] != (((right[i] & (1U << 31)) != 0) ? left[i] : 0)"}),
    ("LoadBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "MaskLoad",                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                           ["ValidateFirstResult"] = "result[0] != ((right[0] < 0) ? left[0] : 0)",                                             ["ValidateRemainingResults"] = "result[i] != ((right[i] < 0) ? left[i] : 0)"}),
    ("LoadBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "MaskLoad",                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                          ["ValidateFirstResult"] = "result[0] != (((right[0] & (1UL << 63)) != 0) ? left[0] : 0)",                            ["ValidateRemainingResults"] = "result[i] != (((right[i] & (1UL << 63)) != 0) ? left[i] : 0)"}),
    ("StoreBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "MaskStore",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "result[0] != ((left[0] < 0) ? right[0] : result[0])",                                     ["ValidateRemainingResults"] = "result[i] != ((left[i] < 0) ? right[i] : result[i])"}),
    ("StoreBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "MaskStore",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                         ["ValidateFirstResult"] = "result[0] != (((left[0] & (1U << 31)) != 0)  ? right[0] : result[0])",                    ["ValidateRemainingResults"] = "result[i] != (((left[i] & (1U << 31)) != 0) ? right[i] : result[i])"}),
    ("StoreBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "MaskStore",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                            ["ValidateFirstResult"] = "result[0] != ((left[0] < 0) ? right[0] : result[0])",                                     ["ValidateRemainingResults"] = "result[i] != ((left[i] < 0) ? right[i] : result[i])"}),
    ("StoreBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "MaskStore",                   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                          ["ValidateFirstResult"] = "result[0] != (((left[0] & (1UL << 63)) != 0)  ? right[0] : result[0])",                   ["ValidateRemainingResults"] = "result[i] != (((left[i] & (1UL << 63)) != 0) ? right[i] : result[i])"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Max",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "result[0] != Math.Max(left[0], right[0])",                                                ["ValidateRemainingResults"] = "result[i] != Math.Max(left[i], right[i])"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Max",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                            ["ValidateFirstResult"] = "result[0] != Math.Max(left[0], right[0])",                                                ["ValidateRemainingResults"] = "result[i] != Math.Max(left[i], right[i])"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Max",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "result[0] != Math.Max(left[0], right[0])",                                                ["ValidateRemainingResults"] = "result[i] != Math.Max(left[i], right[i])"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Max",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                           ["ValidateFirstResult"] = "result[0] != Math.Max(left[0], right[0])",                                                ["ValidateRemainingResults"] = "result[i] != Math.Max(left[i], right[i])"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Max",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "result[0] != Math.Max(left[0], right[0])",                                                ["ValidateRemainingResults"] = "result[i] != Math.Max(left[i], right[i])"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Max",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "result[0] != Math.Max(left[0], right[0])",                                                ["ValidateRemainingResults"] = "result[i] != Math.Max(left[i], right[i])"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Min",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "result[0] != Math.Min(left[0], right[0])",                                                ["ValidateRemainingResults"] = "result[i] != Math.Min(left[i], right[i])"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Min",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                            ["ValidateFirstResult"] = "result[0] != Math.Min(left[0], right[0])",                                                ["ValidateRemainingResults"] = "result[i] != Math.Min(left[i], right[i])"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Min",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "result[0] != Math.Min(left[0], right[0])",                                                ["ValidateRemainingResults"] = "result[i] != Math.Min(left[i], right[i])"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Min",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                           ["ValidateFirstResult"] = "result[0] != Math.Min(left[0], right[0])",                                                ["ValidateRemainingResults"] = "result[i] != Math.Min(left[i], right[i])"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Min",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "result[0] != Math.Min(left[0], right[0])",                                                ["ValidateRemainingResults"] = "result[i] != Math.Min(left[i], right[i])"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Min",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "result[0] != Math.Min(left[0], right[0])",                                                ["ValidateRemainingResults"] = "result[i] != Math.Min(left[i], right[i])"}),
    ("SimdScalarUnOpConvTest.template", new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx", ["Method"] = "MoveMask",                                                    ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",                                                                                                                                             ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                    ["ValidateFirstResult"] = "(uint)result != SseVerify.MoveMask(firstOp)"}),
    ("SimdScalarUnOpConvTest.template", new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx", ["Method"] = "MoveMask",                                                    ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",                                                                                                                                            ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                   ["ValidateFirstResult"] = "(uint)result != SseVerify.MoveMask(firstOp)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "MultiplyAddAdjacent",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                           ["ValidateFirstResult"] = "result[0] != Math.Clamp(((right[1] * left[1]) + (right[0] * left[0])), short.MinValue, short.MaxValue)",      ["ValidateRemainingResults"] = "result[i] != Math.Clamp(((right[(i * 2) + 1] * left[(i * 2) + 1]) + (right[i * 2] * left[i * 2])), short.MinValue, short.MaxValue)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "MultiplyAddAdjacent",         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "result[0] != Math.Clamp(((right[1] * left[1]) + (right[0] * left[0])), int.MinValue, int.MaxValue)",          ["ValidateRemainingResults"] = "result[i] != Math.Clamp(((right[(i * 2) + 1] * left[(i * 2) + 1]) + (right[i * 2] * left[i * 2])), int.MinValue, int.MaxValue)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "MultiplyHighRoundScale",      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "result[0] != (short)((((left[0] * right[0]) >> 14) + 1) >> 1)",                                               ["ValidateRemainingResults"] = "result[i] != (short)((((left[i] * right[i]) >> 14) + 1) >> 1)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "MultiplyHigh",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "result[0] != BitConverter.ToInt16(BitConverter.GetBytes((((int)(left[0])) * right[0]) >> 16), 0)",            ["ValidateRemainingResults"] = "result[i] != BitConverter.ToInt16(BitConverter.GetBytes((((int)(left[i])) * right[i]) >> 16), 0)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "MultiplyHigh",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "result[0] != BitConverter.ToUInt16(BitConverter.GetBytes((((uint)(left[0])) * right[0]) >> 16), 0)",          ["ValidateRemainingResults"] = "result[i] != BitConverter.ToUInt16(BitConverter.GetBytes((((uint)(left[i])) * right[i]) >> 16), 0)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "MultiplyLow",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "result[0] != BitConverter.ToInt32(BitConverter.GetBytes(((long)(left[0])) * right[0]), 0)",                   ["ValidateRemainingResults"] = "result[i] != BitConverter.ToInt32(BitConverter.GetBytes(((long)(left[i])) * right[i]), 0)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "MultiplyLow",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "result[0] != BitConverter.ToInt16(BitConverter.GetBytes(((int)(left[0])) * right[0]), 0)",                    ["ValidateRemainingResults"] = "result[i] != BitConverter.ToInt16(BitConverter.GetBytes(((int)(left[i])) * right[i]), 0)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "MultiplyLow",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "result[0] != BitConverter.ToUInt32(BitConverter.GetBytes(((ulong)(left[0])) * right[0]), 0)",                 ["ValidateRemainingResults"] = "result[i] != BitConverter.ToUInt32(BitConverter.GetBytes(((ulong)(left[i])) * right[i]), 0)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "MultiplyLow",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] ="Vector256",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "result[0] != BitConverter.ToUInt16(BitConverter.GetBytes(((uint)(left[0])) * right[0]), 0)",                  ["ValidateRemainingResults"] = "result[i] != BitConverter.ToUInt16(BitConverter.GetBytes(((uint)(left[i])) * right[i]), 0)"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "MultipleSumAbsoluteDifferences",["RetVectorType"]="Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                               ["Imm"] = "0",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                            ["ValidateFirstResult"] = "result[0] != (Math.Abs(left[0]-right[0])+Math.Abs(left[1]-right[1])+Math.Abs(left[2]-right[2])+Math.Abs(left[3]-right[3]))",                                                                   ["ValidateRemainingResults"] = "result[i] != Math.Abs(left[(i&7)+(i>7?16:0)]-right[0+(i>7?16:0)])+Math.Abs(left[(i&7)+1+(i>7?16:0)]-right[1+(i>7?16:0)])+Math.Abs(left[(i&7)+2+(i>7?16:0)]-right[2+(i>7?16:0)])+Math.Abs(left[(i&7)+3+(i>7?16:0)]-right[3+(i>7?16:0)])"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Or",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                            ["ValidateFirstResult"] = "(byte)(left[0] | right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(byte)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Or",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "(short)(left[0] | right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(short)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Or",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "(int)(left[0] | right[0]) != result[0]",                                                  ["ValidateRemainingResults"] = "(int)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Or",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                           ["ValidateFirstResult"] = "(long)(left[0] | right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(long)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Or",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                           ["ValidateFirstResult"] = "(sbyte)(left[0] | right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(sbyte)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Or",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "(ushort)(left[0] | right[0]) != result[0]",                                               ["ValidateRemainingResults"] = "(ushort)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Or",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "(uint)(left[0] | right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(uint)(left[i] | right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Or",                          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                          ["ValidateFirstResult"] = "(ulong)(left[0] | right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(ulong)(left[i] | right[i]) != result[i]"}),
    ("ComplexBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "PackUnsignedSaturate",        ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "result[0] != (ushort)Math.Clamp(left[0], ushort.MinValue, ushort.MaxValue)",              ["ValidateRemainingResults"] = "result[i] != (i < 4 ? (ushort)Math.Clamp(left[i], ushort.MinValue, ushort.MaxValue) : (i < 8 && i > 3 ? (ushort)Math.Clamp(right[i&3], ushort.MinValue, ushort.MaxValue) : (i < 12 && i > 7 ? (ushort)Math.Clamp(left[i-4], ushort.MinValue, ushort.MaxValue) : (ushort)Math.Clamp(right[i-8], ushort.MinValue, ushort.MaxValue))))"}),
    ("ComplexBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "PackUnsignedSaturate",        ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "result[0] != (byte)Math.Clamp(left[0], byte.MinValue, byte.MaxValue)",                    ["ValidateRemainingResults"] = "result[i] != (i < 8 ? (byte)Math.Clamp(left[i], byte.MinValue, byte.MaxValue) : (i < 16 && i > 7 ? (byte)Math.Clamp(right[i&7], byte.MinValue, byte.MaxValue) : (i < 24 && i > 15 ? (byte)Math.Clamp(left[i-8], byte.MinValue, byte.MaxValue) : (byte)Math.Clamp(right[i-16], byte.MinValue, byte.MaxValue))))"}),
    ("ComplexBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "PackSignedSaturate",          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "result[0] != (short)Math.Clamp(left[0], short.MinValue, short.MaxValue)",                 ["ValidateRemainingResults"] = "result[i] != (i < 4 ? (short)Math.Clamp(left[i], short.MinValue, short.MaxValue) : (i < 8 && i > 3 ? (short)Math.Clamp(right[i&3], short.MinValue, short.MaxValue) : (i < 12 && i > 7 ? (short)Math.Clamp(left[i-4], short.MinValue, short.MaxValue) : (short)Math.Clamp(right[i-8], short.MinValue, short.MaxValue))))"}),
    ("ComplexBinOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "PackSignedSaturate",          ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "result[0] != (sbyte)Math.Clamp(left[0], sbyte.MinValue, sbyte.MaxValue)",                 ["ValidateRemainingResults"] = "result[i] != (i < 8 ? (sbyte)Math.Clamp(left[i], sbyte.MinValue, sbyte.MaxValue) : (i < 16 && i > 7 ? (sbyte)Math.Clamp(right[i&7], sbyte.MinValue, sbyte.MaxValue) : (i < 24 && i > 15 ? (sbyte)Math.Clamp(left[i-8], sbyte.MinValue, sbyte.MaxValue) : (sbyte)Math.Clamp(right[i-16], sbyte.MinValue, sbyte.MaxValue))))"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Permute2x128",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                              ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "result[0] != right[0]",                                                                   ["ValidateRemainingResults"] = "i > 3 ? (result[i] != left[i - 4]) : (result[i] != right[i])"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Permute2x128",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                             ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "result[0] != right[0]",                                                                   ["ValidateRemainingResults"] = "i > 3 ? (result[i] != left[i - 4]) : (result[i] != right[i])"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Permute2x128",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                              ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                           ["ValidateFirstResult"] = "result[0] != right[0]",                                                                   ["ValidateRemainingResults"] = "i > 1 ? (result[i] != left[i - 2]) : (result[i] != right[i])"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Permute2x128",                ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                             ["Imm"] = "2",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                          ["ValidateFirstResult"] = "result[0] != right[0]",                                                                   ["ValidateRemainingResults"] = "i > 1 ? (result[i] != left[i - 2]) : (result[i] != right[i])"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Permute4x64",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double",                                                                                                                          ["Imm"] = "85",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                  ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(firstOp[1]) != BitConverter.DoubleToInt64Bits(result[0])", ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(firstOp[1])  != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Permute4x64",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",                                                                                                                           ["Imm"] = "85",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                   ["ValidateFirstResult"] = "firstOp[1] != result[0]",                                                                 ["ValidateRemainingResults"] = "firstOp[1] != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Permute4x64",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64",                                                                                                                          ["Imm"] = "85",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                  ["ValidateFirstResult"] = "firstOp[1] != result[0]",                                                                 ["ValidateRemainingResults"] = "firstOp[1] != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "PermuteVar8x32",              ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "left[(right[0] & 7)] != result[0]",                                                       ["ValidateRemainingResults"] = "left[(right[i] & 7)] != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "PermuteVar8x32",              ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "left[(right[0] & (uint)7)] != result[0]",                                                 ["ValidateRemainingResults"] = "left[(right[i] & (uint)7)] != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "PermuteVar8x32",              ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[(right[0] & 7)]) != BitConverter.SingleToInt32Bits(result[0])", ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[(right[i] & 7)]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                   ["ValidateFirstResult"] = "(short)(firstOp[0] << 1) != result[0]",                                                   ["ValidateRemainingResults"] = "(short)(firstOp[i] << 1) != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16",                                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                  ["ValidateFirstResult"] = "(ushort)(firstOp[0] << 1) != result[0]",                                                  ["ValidateRemainingResults"] = "(ushort)(firstOp[i] << 1) != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                   ["ValidateFirstResult"] = "(int)(firstOp[0] << 1) != result[0]",                                                     ["ValidateRemainingResults"] = "(int)(firstOp[i] << 1) != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32",                                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                  ["ValidateFirstResult"] = "(uint)(firstOp[0] << 1) != result[0]",                                                    ["ValidateRemainingResults"] = "(uint)(firstOp[i] << 1) != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                   ["ValidateFirstResult"] = "(long)(firstOp[0] << 1) != result[0]",                                                    ["ValidateRemainingResults"] = "(long)(firstOp[i] << 1) != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64",                                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                  ["ValidateFirstResult"] = "(ulong)(firstOp[0] << 1) != result[0]",                                                   ["ValidateRemainingResults"] = "(ulong)(firstOp[i] << 1) != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",                                                                                                                           ["Imm"] = "16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                   ["ValidateFirstResult"] = "0 != result[0]",                                                                          ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16",                                                                                                                          ["Imm"] = "16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                  ["ValidateFirstResult"] = "0 != result[0]",                                                                          ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                                           ["Imm"] = "32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                   ["ValidateFirstResult"] = "0 != result[0]",                                                                          ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32",                                                                                                                          ["Imm"] = "32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                  ["ValidateFirstResult"] = "0 != result[0]",                                                                          ["ValidateRemainingResults"] = "0!= result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",                                                                                                                           ["Imm"] = "64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                   ["ValidateFirstResult"] = "0 != result[0]",                                                                          ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64",                                                                                                                          ["Imm"] = "64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                  ["ValidateFirstResult"] = "0 != result[0]",                                                                          ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical128BitLane",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(sbyte)8",                                                                                                                                           ["ValidateFirstResult"] = "result[0] != 0",                                                                          ["ValidateRemainingResults"] = "(i == 16 ? result[i] != 0 : result[i] != 8)"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical128BitLane",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",                                                                                                                            ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(byte)8",                                                                                                                                            ["ValidateFirstResult"] = "result[0] != 0",                                                                          ["ValidateRemainingResults"] = "(i == 16 ? result[i] != 0 : result[i] != 8)"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical128BitLane",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)8",                                                                                                                                           ["ValidateFirstResult"] = "result[0] != 2048",                                                                       ["ValidateRemainingResults"] = "result[i] != 2048"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical128BitLane",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16",                                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ushort)8",                                                                                                                                          ["ValidateFirstResult"] = "result[0] != 2048",                                                                       ["ValidateRemainingResults"] = "result[i] != 2048"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical128BitLane",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)8",                                                                                                                                             ["ValidateFirstResult"] = "result[0] != 2048",                                                                       ["ValidateRemainingResults"] = "result[i] != 2048"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical128BitLane",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32",                                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(uint)8",                                                                                                                                            ["ValidateFirstResult"] = "result[0] != 2048",                                                                       ["ValidateRemainingResults"] = "result[i] != 2048"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical128BitLane",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(long)8",                                                                                                                                            ["ValidateFirstResult"] = "result[0] != 2048",                                                                       ["ValidateRemainingResults"] = "result[i] != 2048"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftLeftLogical128BitLane",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64",                                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ulong)8",                                                                                                                                           ["ValidateFirstResult"] = "result[0] != 2048",                                                                       ["ValidateRemainingResults"] = "result[i] != 2048"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightArithmetic",        ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                   ["ValidateFirstResult"] = "(short)(firstOp[0] >> 1) != result[0]",                                                   ["ValidateRemainingResults"] = "(short)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightArithmetic",        ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                   ["ValidateFirstResult"] = "(int)(firstOp[0] >> 1) != result[0]",                                                     ["ValidateRemainingResults"] = "(int)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightArithmetic",        ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",                                                                                                                           ["Imm"] = "16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                   ["ValidateFirstResult"] = "(short)(firstOp[0] >> 15) != result[0]",                                                  ["ValidateRemainingResults"] = "(short)(firstOp[i] >> 15) != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightArithmetic",        ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                                           ["Imm"] = "32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                   ["ValidateFirstResult"] = "(int)(firstOp[0] >> 31) != result[0]",                                                    ["ValidateRemainingResults"] = "(int)(firstOp[i] >> 31) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightArithmeticVariable",["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()", ["NextValueOp2"] = "(TestLibrary.Generator.GetUInt32() & 31)",                                                    ["ValidateFirstResult"] = "(int)(left[0] >> (int)right[0]) != result[0]",                                            ["ValidateRemainingResults"] = "(int)(left[i] >> (int)right[i]) != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                   ["ValidateFirstResult"] = "(short)(firstOp[0] >> 1) != result[0]",                                                   ["ValidateRemainingResults"] = "(short)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16",                                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                  ["ValidateFirstResult"] = "(ushort)(firstOp[0] >> 1) != result[0]",                                                  ["ValidateRemainingResults"] = "(ushort)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                   ["ValidateFirstResult"] = "(int)(firstOp[0] >> 1) != result[0]",                                                     ["ValidateRemainingResults"] = "(int)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32",                                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                  ["ValidateFirstResult"] = "(uint)(firstOp[0] >> 1) != result[0]",                                                    ["ValidateRemainingResults"] = "(uint)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                   ["ValidateFirstResult"] = "(long)(firstOp[0] >> 1) != result[0]",                                                    ["ValidateRemainingResults"] = "(long)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64",                                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                  ["ValidateFirstResult"] = "(ulong)(firstOp[0] >> 1) != result[0]",                                                   ["ValidateRemainingResults"] = "(ulong)(firstOp[i] >> 1) != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",                                                                                                                           ["Imm"] = "16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                   ["ValidateFirstResult"] = "0 != result[0]",                                                                          ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16",                                                                                                                          ["Imm"] = "16",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                  ["ValidateFirstResult"] = "0 != result[0]",                                                                          ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                                           ["Imm"] = "32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                   ["ValidateFirstResult"] = "0 != result[0]",                                                                          ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32",                                                                                                                          ["Imm"] = "32",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                  ["ValidateFirstResult"] = "0 != result[0]",                                                                          ["ValidateRemainingResults"] = "0!= result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",                                                                                                                           ["Imm"] = "64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                   ["ValidateFirstResult"] = "0 != result[0]",                                                                          ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical",           ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64",                                                                                                                          ["Imm"] = "64",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                  ["ValidateFirstResult"] = "0 != result[0]",                                                                          ["ValidateRemainingResults"] = "0 != result[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical128BitLane", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(sbyte)8",                                                                                                                                           ["ValidateFirstResult"] = "result[0] != 8",                                                                          ["ValidateRemainingResults"] = "(i == 31 || i == 15 ? result[i] != 0 : result[i] != 8)"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical128BitLane", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",                                                                                                                            ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(byte)8",                                                                                                                                            ["ValidateFirstResult"] = "result[0] != 8",                                                                          ["ValidateRemainingResults"] = "(i == 31 || i == 15 ? result[i] != 0 : result[i] != 8)"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical128BitLane", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(short)8",                                                                                                                                           ["ValidateFirstResult"] = "result[0] != 2048",                                                                       ["ValidateRemainingResults"] = "(i == 7 || i == 15 ? result[i] != 0 : result[i] != 2048)"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical128BitLane", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16",                                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ushort)8",                                                                                                                                          ["ValidateFirstResult"] = "result[0] != 2048",                                                                       ["ValidateRemainingResults"] = "(i == 7 || i == 15 ? result[i] != 0 : result[i] != 2048)"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical128BitLane", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(int)8",                                                                                                                                             ["ValidateFirstResult"] = "result[0] != 134217728",                                                                  ["ValidateRemainingResults"] = "(i == 3 || i == 7 ? result[i] != 0 : result[i] != 134217728)"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical128BitLane", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32",                                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(uint)8",                                                                                                                                            ["ValidateFirstResult"] = "result[0] != 134217728",                                                                  ["ValidateRemainingResults"] = "(i == 3 || i == 7 ? result[i] != 0 : result[i] != 134217728)"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical128BitLane", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(long)8",                                                                                                                                            ["ValidateFirstResult"] = "result[0] != 576460752303423488L",                                                        ["ValidateRemainingResults"] = "(i == 2 ? result[i] != 576460752303423488L : result[i] != 0)"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShiftRightLogical128BitLane", ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64",                                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "(ulong)8",                                                                                                                                           ["ValidateFirstResult"] = "result[0] != 576460752303423488UL",                                                       ["ValidateRemainingResults"] = "(i == 2 ? result[i] != 576460752303423488UL : result[i] != 0)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Sign",                        ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()", ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                            ["ValidateFirstResult"] = "result[0] != (right[0] < 0 ? (sbyte)(-left[0]) : (right[0] > 0 ? left[0] : 0))",          ["ValidateRemainingResults"] = "result[i] != (right[i] < 0 ? (sbyte)(-left[i]) : (right[i] > 0 ? left[i] : 0))"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Sign",                        ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                            ["ValidateFirstResult"] = "result[0] != (right[0] < 0 ? (short)(-left[0]) : (right[0] > 0 ? left[0] : 0))",          ["ValidateRemainingResults"] = "result[i] != (right[i] < 0 ? (short)(-left[i]) : (right[i] > 0 ? left[i] : 0))"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Sign",                        ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                            ["ValidateFirstResult"] = "result[0] != (right[0] < 0 ? (int)(-left[0]) : (right[0] > 0 ? left[0] : 0))",            ["ValidateRemainingResults"] = "result[i] != (right[i] < 0 ? (int)(-left[i]) : (right[i] > 0 ? left[i] : 0))"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Shuffle",                     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                 ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                             ["ValidateFirstResult"] = "result[0] != ((right[0] > 127) ? 0 : left[right[0] & 0x0F])",                             ["ValidateRemainingResults"] = "result[i] != (i < 16 ? (right[i] > 127 ? 0 : left[right[i] & 0x0F]) : (right[i] > 127 ? 0 : left[(right[i] & 0x0F) + 16]))"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Shuffle",                     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()", ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                            ["ValidateFirstResult"] = "result[0] != ((right[0] < 0) ? 0 : left[right[0] & 0x0F])",                               ["ValidateRemainingResults"] = "result[i] != (i < 16 ? (right[i] < 0 ? 0 : left[right[i] & 0x0F]) : (right[i] < 0 ? 0 : left[(right[i] & 0x0F) + 16]))"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Shuffle",                     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",                                                                                                                           ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                   ["ValidateFirstResult"] = "result[0] != firstOp[1]",                                                                 ["ValidateRemainingResults"] = "result[i] != (i < 4 ? firstOp[0] : (i == 4 ? firstOp[5] : firstOp[4]))"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Shuffle",                     ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32",                                                                                                                          ["Imm"] = "1",   ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                  ["ValidateFirstResult"] = "result[0] != firstOp[1]",                                                                 ["ValidateRemainingResults"] = "result[i] != (i < 4 ? firstOp[0] : (i == 4 ? firstOp[5] : firstOp[4]))"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShuffleHigh",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",                                                                                                                           ["Imm"] = "228", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                   ["ValidateFirstResult"] = "result[0] != firstOp[0]",                                                                 ["ValidateRemainingResults"] = "result[i] != firstOp[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShuffleHigh",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16",                                                                                                                          ["Imm"] = "228", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                  ["ValidateFirstResult"] = "result[0] != firstOp[0]",                                                                 ["ValidateRemainingResults"] = "result[i] != firstOp[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShuffleLow",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",                                                                                                                           ["Imm"] = "228", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                   ["ValidateFirstResult"] = "result[0] != firstOp[0]",                                                                 ["ValidateRemainingResults"] = "result[i] != firstOp[i]"}),
    ("ImmUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "ShuffleLow",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16",                                                                                                                          ["Imm"] = "228", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                  ["ValidateFirstResult"] = "result[0] != firstOp[0]",                                                                 ["ValidateRemainingResults"] = "result[i] != firstOp[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "SumAbsoluteDifferences",      ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                            ["ValidateFirstResult"] = "result[0] != SseVerify.SumAbsoluteDifferences(left, right, 0)",                           ["ValidateRemainingResults"] = "result[i] != SseVerify.SumAbsoluteDifferences(left, right, i)"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Subtract",                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                            ["ValidateFirstResult"] = "(byte)(left[0] - right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(byte)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Subtract",                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "(short)(left[0] - right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(short)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Subtract",                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "(int)(left[0] - right[0]) != result[0]",                                                  ["ValidateRemainingResults"] = "(int)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Subtract",                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                           ["ValidateFirstResult"] = "(long)(left[0] - right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(long)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Subtract",                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                           ["ValidateFirstResult"] = "(sbyte)(left[0] - right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(sbyte)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Subtract",                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "(ushort)(left[0] - right[0]) != result[0]",                                               ["ValidateRemainingResults"] = "(ushort)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Subtract",                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "(uint)(left[0] - right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(uint)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Subtract",                    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                          ["ValidateFirstResult"] = "(ulong)(left[0] - right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(ulong)(left[i] - right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "SubtractSaturate",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                            ["ValidateFirstResult"] = "SseVerify.SubtractSaturate(left[0], right[0], result[0])",                                ["ValidateRemainingResults"] = "SseVerify.SubtractSaturate(left[i], right[i], result[i])"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "SubtractSaturate",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                           ["ValidateFirstResult"] = "SseVerify.SubtractSaturate(left[0], right[0], result[0])",                                ["ValidateRemainingResults"] = "SseVerify.SubtractSaturate(left[i], right[i], result[i])"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "SubtractSaturate",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "SseVerify.SubtractSaturate(left[0], right[0], result[0])",                                ["ValidateRemainingResults"] = "SseVerify.SubtractSaturate(left[i], right[i], result[i])"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "SubtractSaturate",            ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "SseVerify.SubtractSaturate(left[0], right[0], result[0])",                                ["ValidateRemainingResults"] = "SseVerify.SubtractSaturate(left[i], right[i], result[i])"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Xor",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Byte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                            ["ValidateFirstResult"] = "(byte)(left[0] ^ right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(byte)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Xor",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                           ["ValidateFirstResult"] = "(short)(left[0] ^ right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(short)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Xor",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                           ["ValidateFirstResult"] = "(int)(left[0] ^ right[0]) != result[0]",                                                  ["ValidateRemainingResults"] = "(int)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Xor",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "Int64",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                           ["ValidateFirstResult"] = "(long)(left[0] ^ right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(long)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Xor",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "SByte",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                           ["ValidateFirstResult"] = "(sbyte)(left[0] ^ right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(sbyte)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Xor",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                          ["ValidateFirstResult"] = "(ushort)(left[0] ^ right[0]) != result[0]",                                               ["ValidateRemainingResults"] = "(ushort)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Xor",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                          ["ValidateFirstResult"] = "(uint)(left[0] ^ right[0]) != result[0]",                                                 ["ValidateRemainingResults"] = "(uint)(left[i] ^ right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Avx",  ["Method"] = "Xor",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector256", ["Op2BaseType"] = "UInt64",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                          ["ValidateFirstResult"] = "(ulong)(left[0] ^ right[0]) != result[0]",                                                ["ValidateRemainingResults"] = "(ulong)(left[i] ^ right[i]) != result[i]"}),
};

(string templateFileName, Dictionary<string, string> templateData)[] Avx2_Vector128Inputs = new []
{
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "Blend",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["Imm"] = "1",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (((1 & (1 << 0)) == 0) ? left[0] : right[0])",                                ["ValidateRemainingResults"] = "result[i] != (((1 & (1 << i)) == 0) ? left[i] : right[i])"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "Blend",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["Imm"] = "2",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (((2 & (1 << 0)) == 0) ? left[0] : right[0])",                                ["ValidateRemainingResults"] = "result[i] != (((2 & (1 << i)) == 0) ? left[i] : right[i])"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "Blend",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["Imm"] = "4",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (((4 & (1 << 0)) == 0) ? left[0] : right[0])",                                ["ValidateRemainingResults"] = "result[i] != (((4 & (1 << i)) == 0) ? left[i] : right[i])"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "Blend",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["Imm"] = "85", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != (((85 & (1 << 0)) == 0) ? left[0] : right[0])",                               ["ValidateRemainingResults"] = "result[i] != (((85 & (1 << i)) == 0) ? left[i] : right[i])"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "Blend",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["Imm"] = "1",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (((1 & (1 << 0)) == 0) ? left[0] : right[0])",                                ["ValidateRemainingResults"] = "result[i] != (((1 & (1 << i)) == 0) ? left[i] : right[i])"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "Blend",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["Imm"] = "2",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (((2 & (1 << 0)) == 0) ? left[0] : right[0])",                                ["ValidateRemainingResults"] = "result[i] != (((2 & (1 << i)) == 0) ? left[i] : right[i])"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "Blend",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["Imm"] = "4",  ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (((4 & (1 << 0)) == 0) ? left[0] : right[0])",                                ["ValidateRemainingResults"] = "result[i] != (((4 & (1 << i)) == 0) ? left[i] : right[i])"}),
    ("ImmBinOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "Blend",                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["Imm"] = "85", ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (((85 & (1 << 0)) == 0) ? left[0] : right[0])",                               ["ValidateRemainingResults"] = "result[i] != (((85 & (1 << i)) == 0) ? left[i] : right[i])"}),
    ("LoadBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "MaskLoad",                    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != ((right[0] < 0) ? left[0] : 0)",                                              ["ValidateRemainingResults"] = "result[i] != ((right[i] < 0) ? left[i] : 0)"}),
    ("LoadBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "MaskLoad",                    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                 ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (((right[0] & (1U << 31)) != 0) ? left[0] : 0)",                              ["ValidateRemainingResults"] = "result[i] != (((right[i] & (1U << 31)) != 0) ? left[i] : 0)"}),
    ("LoadBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "MaskLoad",                    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != ((right[0] < 0) ? left[0] : 0)",                                              ["ValidateRemainingResults"] = "result[i] != ((right[i] < 0) ? left[i] : 0)"}),
    ("LoadBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "MaskLoad",                    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                 ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (((right[0] & (1UL << 63)) != 0) ? left[0] : 0)",                             ["ValidateRemainingResults"] = "result[i] != (((right[i] & (1UL << 63)) != 0) ? left[i] : 0)"}),
    ("StoreBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "MaskStore",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["ValidateFirstResult"] = "result[0] != ((left[0] < 0) ? right[0] : result[0])",                                      ["ValidateRemainingResults"] = "result[i] != ((left[i] < 0) ? right[i] : result[i])"}),
    ("StoreBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "MaskStore",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                 ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["ValidateFirstResult"] = "result[0] != (((left[0] & (1U << 31)) != 0) ? right[0] : result[0])",                      ["ValidateRemainingResults"] = "result[i] != (((left[i] & (1U << 31)) != 0) ? right[i] : result[i])"}),
    ("StoreBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "MaskStore",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["ValidateFirstResult"] = "result[0] != ((left[0] < 0) ? right[0] : result[0])",                                      ["ValidateRemainingResults"] = "result[i] != ((left[i] < 0) ? right[i] : result[i])"}),
    ("StoreBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "MaskStore",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                 ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["ValidateFirstResult"] = "result[0] != (((left[0] & (1UL << 63))  != 0) ? right[0] : result[0])",                    ["ValidateRemainingResults"] = "result[i] != (((left[i] & (1UL << 63)) != 0) ? right[i] : result[i])"}),
    ("SimpleBinOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx2", ["LoadIsa"] = "Sse2", ["Method"] = "ShiftRightArithmeticVariable",["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                 ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "(TestLibrary.Generator.GetUInt32() & 31)", ["ValidateFirstResult"] = "(int)(left[0] >> (int)right[0]) != result[0]",                                      ["ValidateRemainingResults"] = "(int)(left[i] >> (int)right[i]) != result[i]"}),
    ("LoadUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2",                       ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",                                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                           ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                  ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("LoadUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2",                       ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",                                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                  ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("LoadUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2",                       ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                  ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("LoadUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2",                       ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                         ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                  ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("LoadUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2",                       ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                  ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("LoadUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2",                       ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                         ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                  ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("LoadUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2",                       ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                  ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("LoadUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2",                       ["Method"] = "BroadcastScalarToVector128",  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                         ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                  ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("LoadUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2",                       ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",                                                                                ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                           ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                  ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("LoadUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2",                       ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                  ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("LoadUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2",                       ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                  ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("LoadUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2",                       ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                         ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                  ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("LoadUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2",                       ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                  ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("LoadUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2",                       ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                         ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                  ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("LoadUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2",                       ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                               ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                          ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                  ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("LoadUnOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx2",                       ["Method"] = "BroadcastScalarToVector256",  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                              ["LargestVectorSize"] = "32", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                         ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                  ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
};

(string templateFileName, Dictionary<string, string> templateData)[] Avx512FInputs = new []
{
    ("SimpleUnOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "Abs",                                      ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int32",                                                                                                                                                                     ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                      ["ValidateFirstResult"] = "result[0] != (uint)((firstOp[0] < 0) ? -firstOp[0] : firstOp[0])",                                                                                                                                                                                   ["ValidateRemainingResults"] = "result[i] != (uint)((firstOp[i] < 0) ? -firstOp[i] : firstOp[i])"}),
    ("SimpleUnOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "Abs",                                      ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int64",                                                                                                                                                                     ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                      ["ValidateFirstResult"] = "result[0] != (ulong)((firstOp[0] < 0) ? -firstOp[0] : firstOp[0])",                                                                                                                                                                                  ["ValidateRemainingResults"] = "result[i] != (ulong)((firstOp[i] < 0) ? -firstOp[i] : firstOp[i])"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "Add",                                      ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] + right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i] + right[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "Add",                                      ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Int32",                                                                                                        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                              ["ValidateFirstResult"] = "(int)(left[0] + right[0]) != result[0]",                                                                                                                                                                                                             ["ValidateRemainingResults"] = "(int)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "Add",                                      ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Int64",                                                                                                        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                              ["ValidateFirstResult"] = "(long)(left[0] + right[0]) != result[0]",                                                                                                                                                                                                            ["ValidateRemainingResults"] = "(long)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "Add",                                      ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] + right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i] + right[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "Add",                                      ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "UInt32",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                             ["ValidateFirstResult"] = "(uint)(left[0] + right[0]) != result[0]",                                                                                                                                                                                                            ["ValidateRemainingResults"] = "(uint)(left[i] + right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "Add",                                      ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "UInt64",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                             ["ValidateFirstResult"] = "(ulong)(left[0] + right[0]) != result[0]",                                                                                                                                                                                                           ["ValidateRemainingResults"] = "(ulong)(left[i] + right[i]) != result[i]"}),
    ("ImmBinOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "AlignRight32",                             ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Int32",                                                                                       ["Imm"] = "5",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                              ["ValidateFirstResult"] = "result[0] != right[5]",                                                                                                                                                                                                                              ["ValidateRemainingResults"] = "result[i] != ((i < 11) ? right[i + 5]  : left[i - 11])"}),
    ("ImmBinOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "AlignRight32",                             ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Int32",                                                                                       ["Imm"] = "27",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                              ["ValidateFirstResult"] = "result[0] != right[11]",                                                                                                                                                                                                                             ["ValidateRemainingResults"] = "result[i] != ((i < 5)  ? right[i + 11] : left[i - 5])"}),
    ("ImmBinOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "AlignRight32",                             ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "UInt32",                                                                                      ["Imm"] = "5",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                             ["ValidateFirstResult"] = "result[0] != right[5]",                                                                                                                                                                                                                              ["ValidateRemainingResults"] = "result[i] != ((i < 11) ? right[i + 5]  : left[i - 11])"}),
    ("ImmBinOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "AlignRight32",                             ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "UInt32",                                                                                      ["Imm"] = "27",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                             ["ValidateFirstResult"] = "result[0] != right[11]",                                                                                                                                                                                                                             ["ValidateRemainingResults"] = "result[i] != ((i < 5)  ? right[i + 11] : left[i - 5])"}),
    ("ImmBinOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "AlignRight64",                             ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Int64",                                                                                       ["Imm"] = "5",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                              ["ValidateFirstResult"] = "result[0] != right[5]",                                                                                                                                                                                                                              ["ValidateRemainingResults"] = "result[i] != ((i < 3)  ? right[i + 5]  : left[i - 3])"}),
    ("ImmBinOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "AlignRight64",                             ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Int64",                                                                                       ["Imm"] = "11",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                              ["ValidateFirstResult"] = "result[0] != right[3]",                                                                                                                                                                                                                              ["ValidateRemainingResults"] = "result[i] != ((i < 5)  ? right[i + 3]  : left[i - 5])"}),
    ("ImmBinOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "AlignRight64",                             ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "UInt64",                                                                                      ["Imm"] = "5",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                             ["ValidateFirstResult"] = "result[0] != right[5]",                                                                                                                                                                                                                              ["ValidateRemainingResults"] = "result[i] != ((i < 3)  ? right[i + 5]  : left[i - 3])"}),
    ("ImmBinOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "AlignRight64",                             ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "UInt64",                                                                                      ["Imm"] = "11",  ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                             ["ValidateFirstResult"] = "result[0] != right[3]",                                                                                                                                                                                                                              ["ValidateRemainingResults"] = "result[i] != ((i < 5)  ? right[i + 3]  : left[i - 5])"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "And",                                      ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Byte",                                                                                                         ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                               ["ValidateFirstResult"] = "(byte)(left[0] & right[0]) != result[0]",                                                                                                                                                                                                            ["ValidateRemainingResults"] = "(byte)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "And",                                      ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Int16",                                                                                                        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                              ["ValidateFirstResult"] = "(short)(left[0] & right[0]) != result[0]",                                                                                                                                                                                                           ["ValidateRemainingResults"] = "(short)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "And",                                      ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Int32",                                                                                                        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                              ["ValidateFirstResult"] = "(int)(left[0] & right[0]) != result[0]",                                                                                                                                                                                                             ["ValidateRemainingResults"] = "(int)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "And",                                      ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Int64",                                                                                                        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                              ["ValidateFirstResult"] = "(long)(left[0] & right[0]) != result[0]",                                                                                                                                                                                                            ["ValidateRemainingResults"] = "(long)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "And",                                      ["RetVectorType"] = "Vector512", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "SByte",                                                                                                        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                              ["ValidateFirstResult"] = "(sbyte)(left[0] & right[0]) != result[0]",                                                                                                                                                                                                           ["ValidateRemainingResults"] = "(sbyte)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "And",                                      ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "UInt16",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                             ["ValidateFirstResult"] = "(ushort)(left[0] & right[0]) != result[0]",                                                                                                                                                                                                          ["ValidateRemainingResults"] = "(ushort)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "And",                                      ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "UInt32",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                             ["ValidateFirstResult"] = "(uint)(left[0] & right[0]) != result[0]",                                                                                                                                                                                                            ["ValidateRemainingResults"] = "(uint)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "And",                                      ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "UInt64",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                             ["ValidateFirstResult"] = "(ulong)(left[0] & right[0]) != result[0]",                                                                                                                                                                                                           ["ValidateRemainingResults"] = "(ulong)(left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "AndNot",                                   ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Byte",                                                                                                         ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",   ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                               ["ValidateFirstResult"] = "(byte)(~left[0] & right[0]) != result[0]",                                                                                                                                                                                                           ["ValidateRemainingResults"] = "(byte)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "AndNot",                                   ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Int16",                                                                                                        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                              ["ValidateFirstResult"] = "(short)(~left[0] & right[0]) != result[0]",                                                                                                                                                                                                          ["ValidateRemainingResults"] = "(short)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "AndNot",                                   ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Int32",                                                                                                        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                              ["ValidateFirstResult"] = "(int)(~left[0] & right[0]) != result[0]",                                                                                                                                                                                                            ["ValidateRemainingResults"] = "(int)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "AndNot",                                   ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Int64",                                                                                                        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                              ["ValidateFirstResult"] = "(long)(~left[0] & right[0]) != result[0]",                                                                                                                                                                                                           ["ValidateRemainingResults"] = "(long)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "AndNot",                                   ["RetVectorType"] = "Vector512", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "SByte",                                                                                                        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",  ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                              ["ValidateFirstResult"] = "(sbyte)(~left[0] & right[0]) != result[0]",                                                                                                                                                                                                          ["ValidateRemainingResults"] = "(sbyte)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "AndNot",                                   ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "UInt16",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                             ["ValidateFirstResult"] = "(ushort)(~left[0] & right[0]) != result[0]",                                                                                                                                                                                                         ["ValidateRemainingResults"] = "(ushort)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "AndNot",                                   ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "UInt32",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                             ["ValidateFirstResult"] = "(uint)(~left[0] & right[0]) != result[0]",                                                                                                                                                                                                           ["ValidateRemainingResults"] = "(uint)(~left[i] & right[i]) != result[i]"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "AndNot",                                   ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "UInt64",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                             ["ValidateFirstResult"] = "(ulong)(~left[0] & right[0]) != result[0]",                                                                                                                                                                                                          ["ValidateRemainingResults"] = "(ulong)(~left[i] & right[i]) != result[i]"}),
    ("ComplexTernOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "BlendVariable",                            ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector512", ["Op3BaseType"] = "Double",                                          ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp3"] = "(double)(((i & 1) == 0) ? -0.0 : 0.0)", ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(double.IsNegative(thirdOp[0]) ? secondOp[0] : firstOp[0])",                                                                                                              ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(double.IsNegative(thirdOp[i]) ? secondOp[i] : firstOp[i])"}),
    ("ComplexTernOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "BlendVariable",                            ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector512", ["Op3BaseType"] = "Int32",                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp3"] = "(int)(((i & 1) == 0) ? -1 : 0)",        ["ValidateFirstResult"] = "result[0] != ((thirdOp[0] != 0) ? secondOp[0] : firstOp[0])",                                                                                                                                                                                        ["ValidateRemainingResults"] = "result[i] != ((thirdOp[i] != 0) ? secondOp[i] : firstOp[i])"}),
    ("ComplexTernOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "BlendVariable",                            ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector512", ["Op3BaseType"] = "Int64",                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp3"] = "(long)(((i & 1) == 0) ? -1 : 0)",       ["ValidateFirstResult"] = "result[0] != ((thirdOp[0] != 0) ? secondOp[0] : firstOp[0])",                                                                                                                                                                                        ["ValidateRemainingResults"] = "result[i] != ((thirdOp[i] != 0) ? secondOp[i] : firstOp[i])"}),
    ("ComplexTernOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "BlendVariable",                            ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector512", ["Op3BaseType"] = "Single",                                          ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp3"] = "(float)(((i & 1) == 0) ? -0.0 : 0.0)",  ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(float.IsNegative(thirdOp[0]) ? secondOp[0] : firstOp[0])",                                                                                                               ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(float.IsNegative(thirdOp[i]) ? secondOp[i] : firstOp[i])"}),
    ("ComplexTernOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "BlendVariable",                            ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector512", ["Op3BaseType"] = "UInt32",                                          ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp3"] = "(uint)(((i & 1) == 0) ? -1 : 0)",       ["ValidateFirstResult"] = "result[0] != ((thirdOp[0] != 0) ? secondOp[0] : firstOp[0])",                                                                                                                                                                                        ["ValidateRemainingResults"] = "result[i] != ((thirdOp[i] != 0) ? secondOp[i] : firstOp[i])"}),
    ("ComplexTernOpTest.template",     new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "BlendVariable",                            ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector512", ["Op3BaseType"] = "UInt64",                                          ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp3"] = "(ulong)(((i & 1) == 0) ? -1: 0)",       ["ValidateFirstResult"] = "result[0] != ((thirdOp[0] != 0) ? secondOp[0] : firstOp[0])",                                                                                                                                                                                        ["ValidateRemainingResults"] = "result[i] != ((thirdOp[i] != 0) ? secondOp[i] : firstOp[i])"}),
    ("BroadcastTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "BroadcastScalarToVector512",               ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                                                                                     ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                      ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("BroadcastTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "BroadcastScalarToVector512",               ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                                                                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                     ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("BroadcastTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "BroadcastScalarToVector512",               ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                                                                                                     ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                      ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("BroadcastTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "BroadcastScalarToVector512",               ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                                                                                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                     ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "(firstOp[0] != result[i])"}),
    ("BroadcastTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "BroadcastScalarToVector512",               ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                                            ["ValidateRemainingResults"] = "(BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[i]))"}),
    ("BroadcastTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "BroadcastScalarToVector512",               ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                                                                                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(firstOp[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                                                            ["ValidateRemainingResults"] = "(BitConverter.DoubleToInt64Bits(firstOp[0]) != BitConverter.DoubleToInt64Bits(result[i]))"}),
    ("LoadUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx512F",                                     ["Method"] = "BroadcastVector128ToVector512",            ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                                                                                     ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                      ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != firstOp[i & 3]"}),
    ("LoadUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx512F",                                     ["Method"] = "BroadcastVector128ToVector512",            ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                                                                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                     ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != firstOp[i & 3]"}),
    ("LoadUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx512F",                                     ["Method"] = "BroadcastVector128ToVector512",            ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(firstOp[i & 3])"}),
    ("LoadUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx512F",                                     ["Method"] = "BroadcastVector256ToVector512",            ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Int64",                                                                                                                                                                     ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                      ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != firstOp[i & 3]"}),
    ("LoadUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx512F",                                     ["Method"] = "BroadcastVector256ToVector512",            ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt64",                                                                                                                                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                     ["ValidateFirstResult"] = "firstOp[0] != result[0]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != firstOp[i & 3]"}),
    ("LoadUnOpTest.template",          new Dictionary<string, string> { ["Isa"] = "Avx512F",                                     ["Method"] = "BroadcastVector256ToVector512",            ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "Double",                                                                                                                                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(firstOp[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(firstOp[i & 3])"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareEqual",                             ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] == right[0]) ? -1 : 0)",                                                                                                                                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] == right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareEqual",                             ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Int32",                                                                                                        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                              ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((int)(-1)) : 0)",                                                                                                                                                                                    ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((int)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareEqual",                             ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Int64",                                                                                                        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                              ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((long)(-1)) : 0)",                                                                                                                                                                                   ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((long)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareEqual",                             ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] == right[0]) ? -1 : 0)",                                                                                                                                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] == right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareEqual",                             ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "UInt32",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                             ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((uint)(-1)) : 0)",                                                                                                                                                                                   ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((uint)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareEqual",                             ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "UInt64",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                             ["ValidateFirstResult"] = "result[0] != ((left[0] == right[0]) ? unchecked((ulong)(-1)) : 0)",                                                                                                                                                                                  ["ValidateRemainingResults"] = "result[i] != ((left[i] == right[i]) ? unchecked((ulong)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareGreaterThan",                       ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] > right[0]) ? -1 : 0)",                                                                                                                                                                       ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] > right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareGreaterThan",                       ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Int32",                                                                                                        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                              ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? unchecked((int)(-1)) : 0)",                                                                                                                                                                                     ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? unchecked((int)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareGreaterThan",                       ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Int64",                                                                                                        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                              ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? unchecked((long)(-1)) : 0)",                                                                                                                                                                                    ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? unchecked((long)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareGreaterThan",                       ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] > right[0]) ? -1 : 0)",                                                                                                                                                                       ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] > right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareGreaterThan",                       ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "UInt32",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                             ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? unchecked((uint)(-1)) : 0)",                                                                                                                                                                                    ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? unchecked((uint)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareGreaterThan",                       ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "UInt64",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                             ["ValidateFirstResult"] = "result[0] != ((left[0] > right[0]) ? unchecked((ulong)(-1)) : 0)",                                                                                                                                                                                   ["ValidateRemainingResults"] = "result[i] != ((left[i] > right[i]) ? unchecked((ulong)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareGreaterThanOrEqual",                ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] >= right[0]) ? -1 : 0)",                                                                                                                                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] >= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareGreaterThanOrEqual",                ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Int32",                                                                                                        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                              ["ValidateFirstResult"] = "result[0] != ((left[0] >= right[0]) ? unchecked((int)(-1)) : 0)",                                                                                                                                                                                    ["ValidateRemainingResults"] = "result[i] != ((left[i] >= right[i]) ? unchecked((int)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareGreaterThanOrEqual",                ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Int64",                                                                                                        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                              ["ValidateFirstResult"] = "result[0] != ((left[0] >= right[0]) ? unchecked((long)(-1)) : 0)",                                                                                                                                                                                   ["ValidateRemainingResults"] = "result[i] != ((left[i] >= right[i]) ? unchecked((long)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareGreaterThanOrEqual",                ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] >= right[0]) ? -1 : 0)",                                                                                                                                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] >= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareGreaterThanOrEqual",                ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "UInt32",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                             ["ValidateFirstResult"] = "result[0] != ((left[0] >= right[0]) ? unchecked((uint)(-1)) : 0)",                                                                                                                                                                                   ["ValidateRemainingResults"] = "result[i] != ((left[i] >= right[i]) ? unchecked((uint)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareGreaterThanOrEqual",                ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "UInt64",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                             ["ValidateFirstResult"] = "result[0] != ((left[0] >= right[0]) ? unchecked((ulong)(-1)) : 0)",                                                                                                                                                                                  ["ValidateRemainingResults"] = "result[i] != ((left[i] >= right[i]) ? unchecked((ulong)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareLessThan",                          ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] < right[0]) ? -1 : 0)",                                                                                                                                                                       ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] < right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareLessThan",                          ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Int32",                                                                                                        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                              ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? unchecked((int)(-1)) : 0)",                                                                                                                                                                                     ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? unchecked((int)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareLessThan",                          ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Int64",                                                                                                        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                              ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? unchecked((long)(-1)) : 0)",                                                                                                                                                                                    ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? unchecked((long)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareLessThan",                          ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] < right[0]) ? -1 : 0)",                                                                                                                                                                       ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] < right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareLessThan",                          ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "UInt32",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                             ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? unchecked((uint)(-1)) : 0)",                                                                                                                                                                                    ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? unchecked((uint)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareLessThan",                          ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "UInt64",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                             ["ValidateFirstResult"] = "result[0] != ((left[0] < right[0]) ? unchecked((ulong)(-1)) : 0)",                                                                                                                                                                                   ["ValidateRemainingResults"] = "result[i] != ((left[i] < right[i]) ? unchecked((ulong)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareLessThanOrEqual",                   ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] <= right[0]) ? -1 : 0)",                                                                                                                                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] <= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareLessThanOrEqual",                   ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Int32",                                                                                                        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                              ["ValidateFirstResult"] = "result[0] != ((left[0] <= right[0]) ? unchecked((int)(-1)) : 0)",                                                                                                                                                                                    ["ValidateRemainingResults"] = "result[i] != ((left[i] <= right[i]) ? unchecked((int)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareLessThanOrEqual",                   ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Int64",                                                                                                        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                              ["ValidateFirstResult"] = "result[0] != ((left[0] <= right[0]) ? unchecked((long)(-1)) : 0)",                                                                                                                                                                                   ["ValidateRemainingResults"] = "result[i] != ((left[i] <= right[i]) ? unchecked((long)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareLessThanOrEqual",                   ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] <= right[0]) ? -1 : 0)",                                                                                                                                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] <= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareLessThanOrEqual",                   ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "UInt32",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                             ["ValidateFirstResult"] = "result[0] != ((left[0] <= right[0]) ? unchecked((uint)(-1)) : 0)",                                                                                                                                                                                   ["ValidateRemainingResults"] = "result[i] != ((left[i] <= right[i]) ? unchecked((uint)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareLessThanOrEqual",                   ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "UInt64",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                             ["ValidateFirstResult"] = "result[0] != ((left[0] <= right[0]) ? unchecked((ulong)(-1)) : 0)",                                                                                                                                                                                  ["ValidateRemainingResults"] = "result[i] != ((left[i] <= right[i]) ? unchecked((ulong)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareNotEqual",                          ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((left[0] != right[0]) ? -1 : 0)",                                                                                                                                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((left[i] != right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareNotEqual",                          ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Int32",                                                                                                        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                              ["ValidateFirstResult"] = "result[0] != ((left[0] != right[0]) ? unchecked((int)(-1)) : 0)",                                                                                                                                                                                    ["ValidateRemainingResults"] = "result[i] != ((left[i] != right[i]) ? unchecked((int)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareNotEqual",                          ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Int64",                                                                                                        ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                              ["ValidateFirstResult"] = "result[0] != ((left[0] != right[0]) ? unchecked((long)(-1)) : 0)",                                                                                                                                                                                   ["ValidateRemainingResults"] = "result[i] != ((left[i] != right[i]) ? unchecked((long)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareNotEqual",                          ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((left[0] != right[0]) ? -1 : 0)",                                                                                                                                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((left[i] != right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareNotEqual",                          ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "UInt32",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                             ["ValidateFirstResult"] = "result[0] != ((left[0] != right[0]) ? unchecked((uint)(-1)) : 0)",                                                                                                                                                                                   ["ValidateRemainingResults"] = "result[i] != ((left[i] != right[i]) ? unchecked((uint)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareNotEqual",                          ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "UInt64",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                             ["ValidateFirstResult"] = "result[0] != ((left[0] != right[0]) ? unchecked((ulong)(-1)) : 0)",                                                                                                                                                                                  ["ValidateRemainingResults"] = "result[i] != ((left[i] != right[i]) ? unchecked((ulong)(-1)) : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareNotGreaterThan",                    ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (!(left[0] > right[0]) ? -1 : 0)",                                                                                                                                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (!(left[i] > right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareNotGreaterThan",                    ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (!(left[0] > right[0]) ? -1 : 0)",                                                                                                                                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (!(left[i] > right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareNotGreaterThanOrEqual",             ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (!(left[0] >= right[0]) ? -1 : 0)",                                                                                                                                                                     ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (!(left[i] >= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareNotGreaterThanOrEqual",             ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (!(left[0] >= right[0]) ? -1 : 0)",                                                                                                                                                                     ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (!(left[i] >= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareNotLessThan",                       ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (!(left[0] < right[0]) ? -1 : 0)",                                                                                                                                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (!(left[i] < right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareNotLessThan",                       ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (!(left[0] < right[0]) ? -1 : 0)",                                                                                                                                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (!(left[i] < right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareNotLessThanOrEqual",                ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != (!(left[0] <= right[0]) ? -1 : 0)",                                                                                                                                                                     ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != (!(left[i] <= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareNotLessThanOrEqual",                ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != (!(left[0] <= right[0]) ? -1 : 0)",                                                                                                                                                                     ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != (!(left[i] <= right[i]) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareOrdered",                           ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((!double.IsNaN(left[0]) && !double.IsNaN(right[0])) ? -1 : 0)",                                                                                                                                        ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((!double.IsNaN(left[i]) && !double.IsNaN(right[i])) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareOrdered",                           ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((!float.IsNaN(left[0]) && !float.IsNaN(right[0])) ? -1 : 0)",                                                                                                                                          ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((!float.IsNaN(left[i]) && !float.IsNaN(right[i])) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareUnordered",                         ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != ((double.IsNaN(left[0]) || double.IsNaN(right[0])) ? -1 : 0)",                                                                                                                                          ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != ((double.IsNaN(left[i]) || double.IsNaN(right[i])) ? -1 : 0)"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompareUnordered",                         ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != ((float.IsNaN(left[0]) || float.IsNaN(right[0])) ? -1 : 0)",                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != ((float.IsNaN(left[i]) || float.IsNaN(right[i])) ? -1 : 0)"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "Compress",                                 ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector512", ["Op3BaseType"] = "Double",                                          ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "BitConverter.Int64BitsToDouble(((i & 1) == 0) ? -1 : 0)", ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()",  ["ValidateFirstResult"] = "result[0] != Avx512Verify.Compress(firstOp, secondOp, thirdOp, 0)",                                                                                                                                                               ["ValidateRemainingResults"] = "result[i] != Avx512Verify.Compress(firstOp, secondOp, thirdOp, i)"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "Compress",                                 ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector512", ["Op3BaseType"] = "Int32",                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "(int)(((i & 1) == 0) ? -1 : 0)",                          ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",   ["ValidateFirstResult"] = "result[0] != Avx512Verify.Compress(firstOp, secondOp, thirdOp, 0)",                                                                                                                                                               ["ValidateRemainingResults"] = "result[i] != Avx512Verify.Compress(firstOp, secondOp, thirdOp, i)"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "Compress",                                 ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector512", ["Op3BaseType"] = "Int64",                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp2"] = "(long)(((i & 1) == 0) ? -1 : 0)",                         ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",   ["ValidateFirstResult"] = "result[0] != Avx512Verify.Compress(firstOp, secondOp, thirdOp, 0)",                                                                                                                                                               ["ValidateRemainingResults"] = "result[i] != Avx512Verify.Compress(firstOp, secondOp, thirdOp, i)"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "Compress",                                 ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector512", ["Op3BaseType"] = "Single",                                          ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "BitConverter.Int32BitsToSingle(((i & 1) == 0) ? -1 : 0)", ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()",  ["ValidateFirstResult"] = "result[0] != Avx512Verify.Compress(firstOp, secondOp, thirdOp, 0)",                                                                                                                                                               ["ValidateRemainingResults"] = "result[i] != Avx512Verify.Compress(firstOp, secondOp, thirdOp, i)"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "Compress",                                 ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector512", ["Op3BaseType"] = "UInt32",                                          ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "(uint)(((i & 1) == 0) ? -1 : 0)",                         ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",  ["ValidateFirstResult"] = "result[0] != Avx512Verify.Compress(firstOp, secondOp, thirdOp, 0)",                                                                                                                                                               ["ValidateRemainingResults"] = "result[i] != Avx512Verify.Compress(firstOp, secondOp, thirdOp, i)"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "Compress",                                 ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector512", ["Op3BaseType"] = "UInt64",                                          ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp2"] = "(ulong)(((i & 1) == 0) ? -1: 0)",                         ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",  ["ValidateFirstResult"] = "result[0] != Avx512Verify.Compress(firstOp, secondOp, thirdOp, 0)",                                                                                                                                                               ["ValidateRemainingResults"] = "result[i] != Avx512Verify.Compress(firstOp, secondOp, thirdOp, i)"}),
    ("StoreBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompressStore",                            ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp1"] = "BitConverter.Int64BitsToDouble(((i & 1) == 0) ? -1 : 0)",                                       ["ValidateFirstResult"] = "result[0] != Avx512Verify.Compress(result, left, right, 0)",                                                                                                                                                                                         ["ValidateRemainingResults"] = "result[i] != Avx512Verify.Compress(result, left, right, i)"}),
    ("StoreBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompressStore",                            ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Int32",                                                                                                        ["LargestVectorSize"] = "64", ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp1"] = "(int)(((i & 1) == 0) ? -1 : 0)",                                                                ["ValidateFirstResult"] = "result[0] != Avx512Verify.Compress(result, left, right, 0)",                                                                                                                                                                                         ["ValidateRemainingResults"] = "result[i] != Avx512Verify.Compress(result, left, right, i)"}),
    ("StoreBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompressStore",                            ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Int64",                                                                                                        ["LargestVectorSize"] = "64", ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",  ["NextValueOp1"] = "(long)(((i & 1) == 0) ? -1 : 0)",                                                               ["ValidateFirstResult"] = "result[0] != Avx512Verify.Compress(result, left, right, 0)",                                                                                                                                                                                         ["ValidateRemainingResults"] = "result[i] != Avx512Verify.Compress(result, left, right, i)"}),
    ("StoreBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompressStore",                            ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp1"] = "BitConverter.Int32BitsToSingle(((i & 1) == 0) ? -1 : 0)",                                       ["ValidateFirstResult"] = "result[0] != Avx512Verify.Compress(result, left, right, 0)",                                                                                                                                                                                         ["ValidateRemainingResults"] = "result[i] != Avx512Verify.Compress(result, left, right, i)"}),
    ("StoreBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompressStore",                            ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "UInt32",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp1"] = "(uint)(((i & 1) == 0) ? -1 : 0)",                                                               ["ValidateFirstResult"] = "result[0] != Avx512Verify.Compress(result, left, right, 0)",                                                                                                                                                                                         ["ValidateRemainingResults"] = "result[i] != Avx512Verify.Compress(result, left, right, i)"}),
    ("StoreBinOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "CompressStore",                            ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "UInt64",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()", ["NextValueOp1"] = "(ulong)(((i & 1) == 0) ? -1: 0)",                                                               ["ValidateFirstResult"] = "result[0] != Avx512Verify.Compress(result, left, right, 0)",                                                                                                                                                                                         ["ValidateRemainingResults"] = "result[i] != Avx512Verify.Compress(result, left, right, i)"}),
    ("SimpleBinOpConvTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertScalarToVector128Double",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                  ["Op2BaseType"] = "UInt32",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                             ["ValidateFirstResult"] = "result[0] != right"}),
    ("SimpleBinOpConvTest.template",   new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertScalarToVector128Single",           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                  ["Op2BaseType"] = "UInt32",                                                                                                       ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                             ["ValidateFirstResult"] = "result[0] != right"}),
    ("SimdScalarUnOpConvTest.template",new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToUInt32",                                                           ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                                                                                                                    ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "(uint)double.Round(firstOp[0]) != result"}),
    ("SimdScalarUnOpConvTest.template",new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToUInt32",                                                           ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                                    ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "(uint)float.Round(firstOp[0]) != result"}),
    ("SimdScalarUnOpConvTest.template",new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToUInt32WithTruncation",                                             ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                                                                                                                    ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "(uint)firstOp[0] != result"}),
    ("SimdScalarUnOpConvTest.template",new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToUInt32WithTruncation",                                             ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                                                                    ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "(uint)firstOp[0] != result"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector128Byte",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int32",                                                                                                                                                                     ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                      ["ValidateFirstResult"] = "result[0] != (byte)firstOp[0]",                                                                                                                                                                                                                      ["ValidateRemainingResults"] = "result[i] != (byte)firstOp[i]"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector128Byte",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int64",                                                                                                                                                                     ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                      ["ValidateFirstResult"] = "result[0] != (byte)firstOp[0]",                                                                                                                                                                                                                      ["ValidateRemainingResults"] = "result[i] != ((i < 8) ? (byte)firstOp[i] : result[i])"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector128Byte",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt32",                                                                                                                                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                     ["ValidateFirstResult"] = "result[0] != (byte)firstOp[0]",                                                                                                                                                                                                                      ["ValidateRemainingResults"] = "result[i] != (byte)firstOp[i]"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector128Byte",                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt64",                                                                                                                                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                     ["ValidateFirstResult"] = "result[0] != (byte)firstOp[0]",                                                                                                                                                                                                                      ["ValidateRemainingResults"] = "result[i] != ((i < 8) ? (byte)firstOp[i] : result[i])"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector128ByteWithSaturation",     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt32",                                                                                                                                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                     ["ValidateFirstResult"] = "result[0] != (byte)uint.Clamp(firstOp[0], byte.MinValue, byte.MaxValue)",                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != (byte)uint.Clamp(firstOp[i], byte.MinValue, byte.MaxValue)"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector128ByteWithSaturation",     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt64",                                                                                                                                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                     ["ValidateFirstResult"] = "result[0] != (byte)ulong.Clamp(firstOp[0], byte.MinValue, byte.MaxValue)",                                                                                                                                                                           ["ValidateRemainingResults"] = "result[i] != ((i < 8) ? (byte)ulong.Clamp(firstOp[i], byte.MinValue, byte.MaxValue) : result[i])"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector128Int16",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int64",                                                                                                                                                                     ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                      ["ValidateFirstResult"] = "result[0] != (short)firstOp[0]",                                                                                                                                                                                                                     ["ValidateRemainingResults"] = "result[i] != (short)firstOp[i]"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector128Int16",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt64",                                                                                                                                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                     ["ValidateFirstResult"] = "result[0] != (short)firstOp[0]",                                                                                                                                                                                                                     ["ValidateRemainingResults"] = "result[i] != (short)firstOp[i]"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector128Int16WithSaturation",    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int64",                                                                                                                                                                     ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                      ["ValidateFirstResult"] = "result[0] != (short)long.Clamp(firstOp[0], short.MinValue, short.MaxValue)",                                                                                                                                                                         ["ValidateRemainingResults"] = "result[i] != (short)long.Clamp(firstOp[i], short.MinValue, short.MaxValue)"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector128SByte",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int32",                                                                                                                                                                     ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                      ["ValidateFirstResult"] = "result[0] != (sbyte)firstOp[0]",                                                                                                                                                                                                                     ["ValidateRemainingResults"] = "result[i] != (sbyte)firstOp[i]"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector128SByte",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int64",                                                                                                                                                                     ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                      ["ValidateFirstResult"] = "result[0] != (sbyte)firstOp[0]",                                                                                                                                                                                                                     ["ValidateRemainingResults"] = "result[i] != ((i < 8) ? (sbyte)firstOp[i] : result[i])"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector128SByte",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt32",                                                                                                                                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                     ["ValidateFirstResult"] = "result[0] != (sbyte)firstOp[0]",                                                                                                                                                                                                                     ["ValidateRemainingResults"] = "result[i] != (sbyte)firstOp[i]"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector128SByte",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt64",                                                                                                                                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                     ["ValidateFirstResult"] = "result[0] != (sbyte)firstOp[0]",                                                                                                                                                                                                                     ["ValidateRemainingResults"] = "result[i] != ((i < 8) ? (sbyte)firstOp[i] : result[i])"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector128SByteWithSaturation",    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int32",                                                                                                                                                                     ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                      ["ValidateFirstResult"] = "result[0] != (sbyte)int.Clamp(firstOp[0], sbyte.MinValue, sbyte.MaxValue)",                                                                                                                                                                          ["ValidateRemainingResults"] = "result[i] != (sbyte)int.Clamp(firstOp[i], sbyte.MinValue, sbyte.MaxValue)"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector128SByteWithSaturation",    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int64",                                                                                                                                                                     ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                      ["ValidateFirstResult"] = "result[0] != (sbyte)long.Clamp(firstOp[0], sbyte.MinValue, sbyte.MaxValue)",                                                                                                                                                                         ["ValidateRemainingResults"] = "result[i] != ((i < 8) ? (sbyte)long.Clamp(firstOp[i], sbyte.MinValue, sbyte.MaxValue) : result[i])"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector128UInt16",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int64",                                                                                                                                                                     ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                      ["ValidateFirstResult"] = "result[0] != (ushort)firstOp[0]",                                                                                                                                                                                                                    ["ValidateRemainingResults"] = "result[i] != (ushort)firstOp[i]"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector128UInt16",                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt64",                                                                                                                                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                     ["ValidateFirstResult"] = "result[0] != (ushort)firstOp[0]",                                                                                                                                                                                                                    ["ValidateRemainingResults"] = "result[i] != (ushort)firstOp[i]"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector128UInt16WithSaturation",   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt64",                                                                                                                                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                     ["ValidateFirstResult"] = "result[0] != (ushort)ulong.Clamp(firstOp[0], ushort.MinValue, ushort.MaxValue)",                                                                                                                                                                     ["ValidateRemainingResults"] = "result[i] != (ushort)ulong.Clamp(firstOp[i], ushort.MinValue, ushort.MaxValue)"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector256Int16",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int32",                                                                                                                                                                     ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                      ["ValidateFirstResult"] = "result[0] != (short)firstOp[0]",                                                                                                                                                                                                                     ["ValidateRemainingResults"] = "result[i] != (short)firstOp[i]"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector256Int16",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt32",                                                                                                                                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                     ["ValidateFirstResult"] = "result[0] != (short)firstOp[0]",                                                                                                                                                                                                                     ["ValidateRemainingResults"] = "result[i] != (short)firstOp[i]"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector256Int16WithSaturation",    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int32",                                                                                                                                                                     ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                      ["ValidateFirstResult"] = "result[0] != (short)int.Clamp(firstOp[0], short.MinValue, short.MaxValue)",                                                                                                                                                                          ["ValidateRemainingResults"] = "result[i] != (short)int.Clamp(firstOp[i], short.MinValue, short.MaxValue)"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector256Int32",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Double",                                                                                                                                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "result[0] != (int)double.Round(firstOp[0])",                                                                                                                                                                                                         ["ValidateRemainingResults"] = "result[i] != (int)double.Round(firstOp[i])"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector256Int32",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int64",                                                                                                                                                                     ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                      ["ValidateFirstResult"] = "result[0] != (int)firstOp[0]",                                                                                                                                                                                                                       ["ValidateRemainingResults"] = "result[i] != (int)firstOp[i]"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector256Int32",                  ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt64",                                                                                                                                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                     ["ValidateFirstResult"] = "result[0] != (int)firstOp[0]",                                                                                                                                                                                                                       ["ValidateRemainingResults"] = "result[i] != (int)firstOp[i]"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector256Int32WithSaturation",    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int64",                                                                                                                                                                     ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                      ["ValidateFirstResult"] = "result[0] != (int)long.Clamp(firstOp[0], int.MinValue, int.MaxValue)",                                                                                                                                                                               ["ValidateRemainingResults"] = "result[i] != (int)long.Clamp(firstOp[i], int.MinValue, int.MaxValue)"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector256Int32WithTruncation",    ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Double",                                                                                                                                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "result[0] != (int)firstOp[0]",                                                                                                                                                                                                                       ["ValidateRemainingResults"] = "result[i] != (int)firstOp[i]"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector256Single",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Double",                                                                                                                                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "result[0] != (float)firstOp[0]",                                                                                                                                                                                                                     ["ValidateRemainingResults"] = "result[i] != (float)firstOp[i]"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector256UInt16",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int32",                                                                                                                                                                     ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                      ["ValidateFirstResult"] = "result[0] != (ushort)firstOp[0]",                                                                                                                                                                                                                    ["ValidateRemainingResults"] = "result[i] != (ushort)firstOp[i]"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector256UInt16",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt32",                                                                                                                                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                     ["ValidateFirstResult"] = "result[0] != (ushort)firstOp[0]",                                                                                                                                                                                                                    ["ValidateRemainingResults"] = "result[i] != (ushort)firstOp[i]"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector256UInt16WithSaturation",   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt32",                                                                                                                                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                     ["ValidateFirstResult"] = "result[0] != (ushort)uint.Clamp(firstOp[0], ushort.MinValue, ushort.MaxValue)",                                                                                                                                                                      ["ValidateRemainingResults"] = "result[i] != (ushort)uint.Clamp(firstOp[i], ushort.MinValue, ushort.MaxValue)"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector256UInt32",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Double",                                                                                                                                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "result[0] != (uint)double.Round(firstOp[0])",                                                                                                                                                                                                        ["ValidateRemainingResults"] = "result[i] != (uint)double.Round(firstOp[i])"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector256UInt32",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int64",                                                                                                                                                                     ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                      ["ValidateFirstResult"] = "result[0] != (uint)firstOp[0]",                                                                                                                                                                                                                      ["ValidateRemainingResults"] = "result[i] != (uint)firstOp[i]"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector256UInt32",                 ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt64",                                                                                                                                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                     ["ValidateFirstResult"] = "result[0] != (uint)firstOp[0]",                                                                                                                                                                                                                      ["ValidateRemainingResults"] = "result[i] != (uint)firstOp[i]"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector256UInt32WithSaturation",   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt64",                                                                                                                                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                     ["ValidateFirstResult"] = "result[0] != (uint)ulong.Clamp(firstOp[0], uint.MinValue, uint.MaxValue)",                                                                                                                                                                           ["ValidateRemainingResults"] = "result[i] != (uint)ulong.Clamp(firstOp[i], uint.MinValue, uint.MaxValue)"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector256UInt32WithTruncation",   ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Double",                                                                                                                                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "result[0] != (uint)firstOp[0]",                                                                                                                                                                                                                      ["ValidateRemainingResults"] = "result[i] != (uint)firstOp[i]"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector512Double",                 ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector256", ["Op1BaseType"] = "UInt32",                                                                                                                                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(firstOp[0])",                                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(firstOp[i])"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector512Int32",                  ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Single",                                                                                                                                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "result[0] != (int)float.Round(firstOp[0])",                                                                                                                                                                                                          ["ValidateRemainingResults"] = "result[i] != (int)float.Round(firstOp[i])"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector512Int32WithTruncation",    ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Single",                                                                                                                                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "result[0] != (int)firstOp[0]",                                                                                                                                                                                                                       ["ValidateRemainingResults"] = "result[i] != (int)firstOp[i]"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector512Single",                 ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int32",                                                                                                                                                                     ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                      ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(firstOp[0])",                                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(firstOp[i])"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector512Single",                 ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt32",                                                                                                                                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(firstOp[0])",                                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(firstOp[i])"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector512UInt32",                 ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Single",                                                                                                                                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "result[0] != (uint)float.Round(firstOp[0])",                                                                                                                                                                                                         ["ValidateRemainingResults"] = "result[i] != (uint)float.Round(firstOp[i])"}),
    ("SimpleUnOpConvTest.template",    new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ConvertToVector512UInt32WithTruncation",   ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Single",                                                                                                                                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "result[0] != (uint)firstOp[0]",                                                                                                                                                                                                                      ["ValidateRemainingResults"] = "result[i] != (uint)firstOp[i]"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "Divide",                                   ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Double",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                             ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(left[0] / right[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(left[i] / right[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleBinOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "Divide",                                   ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Single",                                                                                                       ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                             ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(left[0] / right[0]) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(left[i] / right[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("ComplexUnOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "DuplicateEvenIndexed",                     ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Double",                                                                                                                                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(firstOp[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                                                                            ["ValidateRemainingResults"] = "((i & 1) == 0) ? (BitConverter.DoubleToInt64Bits(firstOp[i]) != BitConverter.DoubleToInt64Bits(result[i])) : (BitConverter.DoubleToInt64Bits(firstOp[i - 1]) != BitConverter.DoubleToInt64Bits(result[i]))"}),
    ("ComplexUnOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "DuplicateEvenIndexed",                     ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Single",                                                                                                                                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                                            ["ValidateRemainingResults"] = "((i & 1) == 0) ? (BitConverter.SingleToInt32Bits(firstOp[i]) != BitConverter.SingleToInt32Bits(result[i])) : (BitConverter.SingleToInt32Bits(firstOp[i - 1]) != BitConverter.SingleToInt32Bits(result[i]))"}),
    ("ComplexUnOpTest.template",       new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "DuplicateOddIndexed",                      ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Single",                                                                                                                                                                    ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(firstOp[1]) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                                                                            ["ValidateRemainingResults"] = "((i & 1) == 0) ? (BitConverter.SingleToInt32Bits(firstOp[i + 1]) != BitConverter.SingleToInt32Bits(result[i])) : (BitConverter.SingleToInt32Bits(firstOp[i]) != BitConverter.SingleToInt32Bits(result[i]))"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "Expand",                                   ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector512", ["Op3BaseType"] = "Double",                                          ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "BitConverter.Int64BitsToDouble(((i & 1) == 0) ? -1 : 0)", ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()",  ["ValidateFirstResult"] = "result[0] != Avx512Verify.Expand(firstOp, secondOp, thirdOp, 0)",                                                                                                                                                                 ["ValidateRemainingResults"] = "result[i] != Avx512Verify.Expand(firstOp, secondOp, thirdOp, i)"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "Expand",                                   ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector512", ["Op3BaseType"] = "Int32",                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "(int)(((i & 1) == 0) ? -1 : 0)",                          ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",   ["ValidateFirstResult"] = "result[0] != Avx512Verify.Expand(firstOp, secondOp, thirdOp, 0)",                                                                                                                                                                 ["ValidateRemainingResults"] = "result[i] != Avx512Verify.Expand(firstOp, secondOp, thirdOp, i)"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "Expand",                                   ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector512", ["Op3BaseType"] = "Int64",                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "(long)(((i & 1) == 0) ? -1 : 0)",                         ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",   ["ValidateFirstResult"] = "result[0] != Avx512Verify.Expand(firstOp, secondOp, thirdOp, 0)",                                                                                                                                                                 ["ValidateRemainingResults"] = "result[i] != Avx512Verify.Expand(firstOp, secondOp, thirdOp, i)"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "Expand",                                   ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector512", ["Op3BaseType"] = "Single",                                          ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "BitConverter.Int32BitsToSingle(((i & 1) == 0) ? -1 : 0)", ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()",  ["ValidateFirstResult"] = "result[0] != Avx512Verify.Expand(firstOp, secondOp, thirdOp, 0)",                                                                                                                                                                 ["ValidateRemainingResults"] = "result[i] != Avx512Verify.Expand(firstOp, secondOp, thirdOp, i)"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "Expand",                                   ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector512", ["Op3BaseType"] = "UInt32",                                          ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "(uint)(((i & 1) == 0) ? -1 : 0)",                         ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",  ["ValidateFirstResult"] = "result[0] != Avx512Verify.Expand(firstOp, secondOp, thirdOp, 0)",                                                                                                                                                                 ["ValidateRemainingResults"] = "result[i] != Avx512Verify.Expand(firstOp, secondOp, thirdOp, i)"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "Expand",                                   ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector512", ["Op3BaseType"] = "UInt64",                                          ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "(ulong)(((i & 1) == 0) ? -1: 0)",                         ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",  ["ValidateFirstResult"] = "result[0] != Avx512Verify.Expand(firstOp, secondOp, thirdOp, 0)",                                                                                                                                                                 ["ValidateRemainingResults"] = "result[i] != Avx512Verify.Expand(firstOp, secondOp, thirdOp, i)"}),
    ("LoadTernOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ExpandLoad",                               ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector512", ["Op3BaseType"] = "Double",                                          ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "BitConverter.Int64BitsToDouble(((i & 1) == 0) ? -1 : 0)", ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()",  ["ValidateFirstResult"] = "result[0] != Avx512Verify.Expand(thirdOp, secondOp, firstOp, 0)",                                                                                                                                                                 ["ValidateRemainingResults"] = "result[i] != Avx512Verify.Expand(thirdOp, secondOp, firstOp, i)"}),
    ("LoadTernOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ExpandLoad",                               ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector512", ["Op3BaseType"] = "Int32",                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "(int)(((i & 1) == 0) ? -1 : 0)",                          ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",   ["ValidateFirstResult"] = "result[0] != Avx512Verify.Expand(thirdOp, secondOp, firstOp, 0)",                                                                                                                                                                 ["ValidateRemainingResults"] = "result[i] != Avx512Verify.Expand(thirdOp, secondOp, firstOp, i)"}),
    ("LoadTernOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ExpandLoad",                               ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector512", ["Op3BaseType"] = "Int64",                                           ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",  ["NextValueOp2"] = "(long)(((i & 1) == 0) ? -1 : 0)",                         ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",   ["ValidateFirstResult"] = "result[0] != Avx512Verify.Expand(thirdOp, secondOp, firstOp, 0)",                                                                                                                                                                 ["ValidateRemainingResults"] = "result[i] != Avx512Verify.Expand(thirdOp, secondOp, firstOp, i)"}),
    ("LoadTernOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ExpandLoad",                               ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector512", ["Op3BaseType"] = "Single",                                          ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "BitConverter.Int32BitsToSingle(((i & 1) == 0) ? -1 : 0)", ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()",  ["ValidateFirstResult"] = "result[0] != Avx512Verify.Expand(thirdOp, secondOp, firstOp, 0)",                                                                                                                                                                 ["ValidateRemainingResults"] = "result[i] != Avx512Verify.Expand(thirdOp, secondOp, firstOp, i)"}),
    ("LoadTernOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ExpandLoad",                               ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector512", ["Op3BaseType"] = "UInt32",                                          ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "(uint)(((i & 1) == 0) ? -1 : 0)",                         ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",  ["ValidateFirstResult"] = "result[0] != Avx512Verify.Expand(thirdOp, secondOp, firstOp, 0)",                                                                                                                                                                 ["ValidateRemainingResults"] = "result[i] != Avx512Verify.Expand(thirdOp, secondOp, firstOp, i)"}),
    ("LoadTernOpTest.template",        new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ExpandLoad",                               ["RetVectorType"] = "Vector512", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector512", ["Op3BaseType"] = "UInt64",                                          ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()", ["NextValueOp2"] = "(ulong)(((i & 1) == 0) ? -1: 0)",                         ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",  ["ValidateFirstResult"] = "result[0] != Avx512Verify.Expand(thirdOp, secondOp, firstOp, 0)",                                                                                                                                                                 ["ValidateRemainingResults"] = "result[i] != Avx512Verify.Expand(thirdOp, secondOp, firstOp, i)"}),
    ("ImmUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ExtractVector128",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Single",                                                                                                                                                   ["Imm"] = "1",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(firstOp[4])",                                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(firstOp[i+4])"}),
    ("ImmUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ExtractVector128",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Double",                                                                                                                                                   ["Imm"] = "1",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(firstOp[2])",                                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(firstOp[i+2])"}),
    ("ImmUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ExtractVector128",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Byte",                                                                                                                                                     ["Imm"] = "1",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                       ["ValidateFirstResult"] = "result[0] != firstOp[16]",                                                                                                                                                                                                                           ["ValidateRemainingResults"] = "result[i] != firstOp[i+16]"}),
    ("ImmUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ExtractVector128",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "SByte",                                                                                                                                                    ["Imm"] = "1",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                      ["ValidateFirstResult"] = "result[0] != firstOp[16]",                                                                                                                                                                                                                           ["ValidateRemainingResults"] = "result[i] != firstOp[i+16]"}),
    ("ImmUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ExtractVector128",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int16",                                                                                                                                                    ["Imm"] = "1",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                      ["ValidateFirstResult"] = "result[0] != firstOp[8]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != firstOp[i+8]"}),
    ("ImmUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ExtractVector128",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt16",                                                                                                                                                   ["Imm"] = "1",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                     ["ValidateFirstResult"] = "result[0] != firstOp[8]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != firstOp[i+8]"}),
    ("ImmUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ExtractVector128",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int32",                                                                                                                                                    ["Imm"] = "1",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                      ["ValidateFirstResult"] = "result[0] != firstOp[4]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != firstOp[i+4]"}),
    ("ImmUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ExtractVector128",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt32",                                                                                                                                                   ["Imm"] = "1",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                     ["ValidateFirstResult"] = "result[0] != firstOp[4]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != firstOp[i+4]"}),
    ("ImmUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ExtractVector128",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int64",                                                                                                                                                    ["Imm"] = "1",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                      ["ValidateFirstResult"] = "result[0] != firstOp[2]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != firstOp[i+2]"}),
    ("ImmUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ExtractVector128",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt64",                                                                                                                                                   ["Imm"] = "1",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                     ["ValidateFirstResult"] = "result[0] != firstOp[2]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != firstOp[i+2]"}),
    ("ImmUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ExtractVector256",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Single",                                                                                                                                                   ["Imm"] = "1",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(result[0]) != BitConverter.SingleToInt32Bits(firstOp[8])",                                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(firstOp[i+8])"}),
    ("ImmUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ExtractVector256",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Double",                                                                                                                                                   ["Imm"] = "1",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(result[0]) != BitConverter.DoubleToInt64Bits(firstOp[4])",                                                                                                                                                            ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(firstOp[i+4])"}),
    ("ImmUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ExtractVector256",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Byte",   ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Byte",                                                                                                                                                     ["Imm"] = "1",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                       ["ValidateFirstResult"] = "result[0] != firstOp[32]",                                                                                                                                                                                                                           ["ValidateRemainingResults"] = "result[i] != firstOp[i+32]"}),
    ("ImmUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ExtractVector256",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "SByte",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "SByte",                                                                                                                                                    ["Imm"] = "1",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                      ["ValidateFirstResult"] = "result[0] != firstOp[32]",                                                                                                                                                                                                                           ["ValidateRemainingResults"] = "result[i] != firstOp[i+32]"}),
    ("ImmUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ExtractVector256",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int16",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int16",                                                                                                                                                    ["Imm"] = "1",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                      ["ValidateFirstResult"] = "result[0] != firstOp[16]",                                                                                                                                                                                                                           ["ValidateRemainingResults"] = "result[i] != firstOp[i+16]"}),
    ("ImmUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ExtractVector256",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt16", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt16",                                                                                                                                                   ["Imm"] = "1",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                     ["ValidateFirstResult"] = "result[0] != firstOp[16]",                                                                                                                                                                                                                           ["ValidateRemainingResults"] = "result[i] != firstOp[i+16]"}),
    ("ImmUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ExtractVector256",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int32",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int32",                                                                                                                                                    ["Imm"] = "1",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                      ["ValidateFirstResult"] = "result[0] != firstOp[8]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != firstOp[i+8]"}),
    ("ImmUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ExtractVector256",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt32", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt32",                                                                                                                                                   ["Imm"] = "1",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                     ["ValidateFirstResult"] = "result[0] != firstOp[8]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != firstOp[i+8]"}),
    ("ImmUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ExtractVector256",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "Int64",  ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Int64",                                                                                                                                                    ["Imm"] = "1",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                      ["ValidateFirstResult"] = "result[0] != firstOp[4]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != firstOp[i+4]"}),
    ("ImmUnOpTest.template",           new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "ExtractVector256",                         ["RetVectorType"] = "Vector256", ["RetBaseType"] = "UInt64", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "UInt64",                                                                                                                                                   ["Imm"] = "1",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                     ["ValidateFirstResult"] = "result[0] != firstOp[4]",                                                                                                                                                                                                                            ["ValidateRemainingResults"] = "result[i] != firstOp[i+4]"}),
    ("ImmTernOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "Fixup",                                    ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector512", ["Op3BaseType"] = "Int64",                          ["Imm"] = "0",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",      ["ValidateFirstResult"] = "Avx512Verify.ValidateFixup(result[0], op1[0], op2[0], op3[0])",                                                                                                                                                                                      ["ValidateRemainingResults"] = "Avx512Verify.ValidateFixup(result[i], op1[i], op2[i], op3[i])"}),
    ("ImmTernOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "Fixup",                                    ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector512", ["Op3BaseType"] = "Int32",                          ["Imm"] = "0",   ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",      ["ValidateFirstResult"] = "Avx512Verify.ValidateFixup(result[0], op1[0], op2[0], op3[0])",                                                                                                                                                                                      ["ValidateRemainingResults"] = "Avx512Verify.ValidateFixup(result[i], op1[i], op2[i], op3[i])"}),
    ("ImmTernOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "FixupScalar",                              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int64",                          ["Imm"] = "0",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",      ["ValidateFirstResult"] = "Avx512Verify.ValidateFixup(result[0], op1[0], op2[0], op3[0])",                                                                                                                                                                                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != BitConverter.DoubleToInt64Bits(op2[i])"}),
    ("ImmTernOpTest.template",         new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "FixupScalar",                              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int32",                          ["Imm"] = "0",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",      ["ValidateFirstResult"] = "Avx512Verify.ValidateFixup(result[0], op1[0], op2[0], op3[0])",                                                                                                                                                                                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != BitConverter.SingleToInt32Bits(op2[i])"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "FusedMultiplyAdd",                         ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector512", ["Op3BaseType"] = "Double",                                          ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()",     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(double.FusedMultiplyAdd(firstOp[0], secondOp[0], thirdOp[0])) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                          ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(double.FusedMultiplyAdd(firstOp[i], secondOp[i], thirdOp[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "FusedMultiplyAdd",                         ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector512", ["Op3BaseType"] = "Single",                                          ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()",     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(float.FusedMultiplyAdd(firstOp[0], secondOp[0], thirdOp[0])) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                           ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(float.FusedMultiplyAdd(firstOp[i], secondOp[i], thirdOp[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "FusedMultiplyAddNegated",                  ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector512", ["Op3BaseType"] = "Double",                                          ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()",     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(double.FusedMultiplyAdd(-firstOp[0], secondOp[0], thirdOp[0])) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                         ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(double.FusedMultiplyAdd(-firstOp[i], secondOp[i], thirdOp[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "FusedMultiplyAddNegated",                  ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector512", ["Op3BaseType"] = "Single",                                          ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()",     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(float.FusedMultiplyAdd(-firstOp[0], secondOp[0], thirdOp[0])) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                          ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(float.FusedMultiplyAdd(-firstOp[i], secondOp[i], thirdOp[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("AlternatingTernOpTest.template", new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "FusedMultiplyAddSubtract",                 ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector512", ["Op3BaseType"] = "Double",                                          ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()",     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(double.FusedMultiplyAdd(firstOp[i], secondOp[i], -thirdOp[i])) != BitConverter.DoubleToInt64Bits(result[i])",                                                                                                         ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(double.FusedMultiplyAdd(firstOp[i + 1], secondOp[i + 1], thirdOp[i + 1])) != BitConverter.DoubleToInt64Bits(result[i + 1])"}),
    ("AlternatingTernOpTest.template", new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "FusedMultiplyAddSubtract",                 ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector512", ["Op3BaseType"] = "Single",                                          ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()",     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(float.FusedMultiplyAdd(firstOp[i], secondOp[i], -thirdOp[i])) != BitConverter.SingleToInt32Bits(result[i])",                                                                                                          ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(float.FusedMultiplyAdd(firstOp[i + 1], secondOp[i + 1], thirdOp[i + 1])) != BitConverter.SingleToInt32Bits(result[i + 1])"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "FusedMultiplySubtract",                    ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector512", ["Op3BaseType"] = "Double",                                          ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()",     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(double.FusedMultiplyAdd(firstOp[0], secondOp[0], -thirdOp[0])) != BitConverter.DoubleToInt64Bits(result[0])",                                                                                                         ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(double.FusedMultiplyAdd(firstOp[i], secondOp[i], -thirdOp[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
    ("SimpleTernOpTest.template",      new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "FusedMultiplySubtract",                    ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector512", ["Op3BaseType"] = "Single",                                          ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()",     ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(float.FusedMultiplyAdd(firstOp[0], secondOp[0], -thirdOp[0])) != BitConverter.SingleToInt32Bits(result[0])",                                                                                                          ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(float.FusedMultiplyAdd(firstOp[i], secondOp[i], -thirdOp[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
    ("AlternatingTernOpTest.template", new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "FusedMultiplySubtractAdd",                 ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Double", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector512", ["Op3BaseType"] = "Double",                                          ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()", ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()",     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(double.FusedMultiplyAdd(firstOp[i], secondOp[i], thirdOp[i])) != BitConverter.DoubleToInt64Bits(result[i])",                                                                                                          ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(double.FusedMultiplyAdd(firstOp[i + 1], secondOp[i + 1], -thirdOp[i + 1])) != BitConverter.DoubleToInt64Bits(result[i + 1])"}),
    ("AlternatingTernOpTest.template", new Dictionary<string, string> { ["Isa"] = "Avx512F",            ["LoadIsa"] = "Avx512F", ["Method"] = "FusedMultiplySubtractAdd",                 ["RetVectorType"] = "Vector512", ["RetBaseType"] = "Single", ["Op1VectorType"] = "Vector512", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector512", ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector512", ["Op3BaseType"] = "Single",                                          ["LargestVectorSize"] = "64", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()", ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()",     ["Valida