﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

// NOTE: This file was generated by $(WpfCodeGenDir)AvTrace\AvTraceMessages.tt.
// Any manual updates to this file will overwritten.

namespace MS.Internal
{
    internal static partial class TraceRoutedEvent
    {
        private static AvTrace _avTrace = new AvTrace(
                delegate() { return PresentationTraceSources.RoutedEventSource; },
                delegate() { PresentationTraceSources._RoutedEventSource = null; }
                );
        private static AvTraceDetails _RaiseEvent;
		public static AvTraceDetails RaiseEvent
        {
            get
            {
                if ( _RaiseEvent == null )
                {
                    _RaiseEvent = new AvTraceDetails(1, new string[] { "Raise RoutedEvent" } );
                }

                return _RaiseEvent;
            }
        }

        private static AvTraceDetails _ReRaiseEventAs;
		public static AvTraceDetails ReRaiseEventAs
        {
            get
            {
                if ( _ReRaiseEventAs == null )
                {
                    _ReRaiseEventAs = new AvTraceDetails(2, new string[] { "Raise RoutedEvent" } );
                }

                return _ReRaiseEventAs;
            }
        }

        private static AvTraceDetails _HandleEvent;
		public static AvTraceDetails HandleEvent
        {
            get
            {
                if ( _HandleEvent == null )
                {
                    _HandleEvent = new AvTraceDetails(3, new string[] { "RoutedEvent has set Handled" } );
                }

                return _HandleEvent;
            }
        }

        private static AvTraceDetails _InvokeHandlers;
		public static AvTraceDetails InvokeHandlers
        {
            get
            {
                if ( _InvokeHandlers == null )
                {
                    _InvokeHandlers = new AvTraceDetails(4, new string[] { "InvokeHandlers" } );
                }

                return _InvokeHandlers;
            }
        }

        /// <summary> Send a single trace output </summary>
        public static void Trace(TraceEventType type, AvTraceDetails traceDetails, params ReadOnlySpan<object> parameters)
        {
            _avTrace.Trace(type, traceDetails.Id, traceDetails.Message, traceDetails.Labels, parameters);
        }

        /// <summary> Send a singleton "activity" trace (really, this sends the same trace as both a Start and a Stop) </summary>
        public static void TraceActivityItem(AvTraceDetails traceDetails, params ReadOnlySpan<object> parameters)
        {
            _avTrace.TraceStartStop(traceDetails.Id, traceDetails.Message, traceDetails.Labels, parameters);
        }

        public static bool IsEnabled
        {
            get { return _avTrace != null && _avTrace.IsEnabled; }
        }

        /// <summary> Is there a Tracesource?  (See comment on AvTrace.IsEnabledOverride.) </summary>
        public static bool IsEnabledOverride
        {
            get { return _avTrace.IsEnabledOverride; }
        }

        /// <summary> Re-read the configuration for this trace source </summary>
        public static void Refresh()
        {
            _avTrace.Refresh();
        }
	}
    static internal partial class TraceAnimation
    {
        static private AvTrace _avTrace = new AvTrace(
                delegate() { return PresentationTraceSources.AnimationSource; },
                delegate() { PresentationTraceSources._AnimationSource = null; }
                );
        private static AvTraceDetails _StoryboardBegin;
		public static AvTraceDetails StoryboardBegin
        {
            get
            {
                if ( _StoryboardBegin == null )
                {
                    _StoryboardBegin = new AvTraceDetails(1, new string[] { "Storyboard has begun" } );
                }

                return _StoryboardBegin;
            }
        }

        private static AvTraceDetails _StoryboardPause;
		public static AvTraceDetails StoryboardPause
        {
            get
            {
                if ( _StoryboardPause == null )
                {
                    _StoryboardPause = new AvTraceDetails(2, new string[] { "Storyboard has been paused" } );
                }

                return _StoryboardPause;
            }
        }

        private static AvTraceDetails _StoryboardRemove;
		public static AvTraceDetails StoryboardRemove
        {
            get
            {
                if ( _StoryboardRemove == null )
                {
                    _StoryboardRemove = new AvTraceDetails(3, new string[] { "Storyboard has been removed" } );
                }

                return _StoryboardRemove;
            }
        }

        private static AvTraceDetails _StoryboardResume;
		public static AvTraceDetails StoryboardResume
        {
            get
            {
                if ( _StoryboardResume == null )
                {
                    _StoryboardResume = new AvTraceDetails(4, new string[] { "Storyboard has been resumed" } );
                }

                return _StoryboardResume;
            }
        }

        private static AvTraceDetails _StoryboardStop;
		public static AvTraceDetails StoryboardStop
        {
            get
            {
                if ( _StoryboardStop == null )
                {
                    _StoryboardStop = new AvTraceDetails(5, new string[] { "Storyboard has been stopped" } );
                }

                return _StoryboardStop;
            }
        }

        private static AvTraceDetails _StoryboardNotApplied;
		public static AvTraceDetails StoryboardNotApplied
        {
            get
            {
                if ( _StoryboardNotApplied == null )
                {
                    _StoryboardNotApplied = new AvTraceDetails(6, new string[] { "Unable to perform action because the specified Storyboard was never applied to this object for interactive control." } );
                }

                return _StoryboardNotApplied;
            }
        }

        private static AvTraceDetails _AnimateStorageValidationFailed;
		public static AvTraceDetails AnimateStorageValidationFailed
        {
            get
            {
                if ( _AnimateStorageValidationFailed == null )
                {
                    _AnimateStorageValidationFailed = new AvTraceDetails(7, new string[] { "Animated property failed validation. Animated value not set." } );
                }

                return _AnimateStorageValidationFailed;
            }
        }

        private static AvTraceDetails _AnimateStorageValidationNoLongerFailing;
		public static AvTraceDetails AnimateStorageValidationNoLongerFailing
        {
            get
            {
                if ( _AnimateStorageValidationNoLongerFailing == null )
                {
                    _AnimateStorageValidationNoLongerFailing = new AvTraceDetails(8, new string[] { "Animated property no longer failing validation." } );
                }

                return _AnimateStorageValidationNoLongerFailing;
            }
        }

        /// <summary> Send a single trace output </summary>
        public static void Trace(TraceEventType type, AvTraceDetails traceDetails, params ReadOnlySpan<object> parameters)
        {
            _avTrace.Trace(type, traceDetails.Id, traceDetails.Message, traceDetails.Labels, parameters);
        }

        /// <summary> Send a singleton "activity" trace (really, this sends the same trace as both a Start and a Stop) </summary>
        public static void TraceActivityItem(AvTraceDetails traceDetails, params ReadOnlySpan<object> parameters)
        {
            _avTrace.TraceStartStop(traceDetails.Id, traceDetails.Message, traceDetails.Labels, parameters);
        }

        public static bool IsEnabled
        {
            get { return _avTrace != null && _avTrace.IsEnabled; }
        }

        /// <summary> Is there a Tracesource?  (See comment on AvTrace.IsEnabledOverride.) </summary>
        public static bool IsEnabledOverride
        {
            get { return _avTrace.IsEnabledOverride; }
        }

        /// <summary> Re-read the configuration for this trace source </summary>
        public static void Refresh()
        {
            _avTrace.Refresh();
        }
	}
}
