// Auto generated SWIG file for Python interface of DOLFIN
//
// Copyright (C) 2012 Kristian B. Oelgaard
//
// This file is part of DOLFIN.
//
// DOLFIN is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// DOLFIN is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with DOLFIN. If not, see <http://www.gnu.org/licenses/>.
//

// Autogenerated docstrings file, extracted from the DOLFIN source C++ files.

// Documentation extracted from: (module=generation, header=ImplicitDomainMeshGenerator.h)
%feature("docstring")  dolfin::ImplicitDomainMeshGenerator "
Generate surface or volume meshes from implicit representations
of a domain modelled by the abstract dolfin::ImplicitSurface
class. CGAL is used for the mesh generation.
";

%feature("docstring")  dolfin::ImplicitDomainMeshGenerator::generate "
Create volume mesh from implicit surface representation
";

%feature("docstring")  dolfin::ImplicitDomainMeshGenerator::generate_surface "
Create surface mesh from implicit surface representation. This
function uses the CGAL 3D mesh genrator
";

// Documentation extracted from: (module=generation, header=PolygonalMeshGenerator.h)
%feature("docstring")  dolfin::PolygonalMeshGenerator "
Polygonal mesh generator that uses CGAL
";

%feature("docstring")  dolfin::PolygonalMeshGenerator::generate "
**Overloaded versions**

* generate\ (mesh, vertices, cell_size)

  Generate mesh of a polygonal domain described by domain vertices

* generate\ (mesh, polygon, cell_size)

  Generate mesh of a domain described by a CGAL polygon
";

// Documentation extracted from: (module=generation, header=PolyhedralMeshGenerator.h)
%feature("docstring")  dolfin::PolyhedralMeshGenerator "
Polyhedral mesh generator that uses CGAL. Volume and surfaces of
polyhedra (closed surface) can be generated from polyhedra
defined via polygonal facets.
";

%feature("docstring")  dolfin::PolyhedralMeshGenerator::generate "
**Overloaded versions**

* generate\ (mesh, off_file, cell_size, detect_sharp_features=true)

  Create volume mesh from Object File Format (.off) file

* generate\ (mesh, vertices, facets, cell_size, detect_sharp_features=true)

  Create volume mesh from a collection of facets
";

%feature("docstring")  dolfin::PolyhedralMeshGenerator::generate_surface_mesh "
**Overloaded versions**

* generate_surface_mesh\ (mesh, vertices, facets, cell_size, detect_sharp_features=true)

  Create surface mesh from a collection of facets

* generate_surface_mesh\ (mesh, off_file, cell_size, detect_sharp_features=true)

  Create a surface mesh from Object File Format (.off) file
";

%feature("docstring")  dolfin::PolyhedralMeshGenerator::cgal_generate "
Create mesh from a CGAL polyhedron
";

%feature("docstring")  dolfin::PolyhedralMeshGenerator::cgal_generate_surface_mesh "
Create surface mesh from a CGAL polyhedron
";

// Documentation extracted from: (module=generation, header=Triangulate.h)
%feature("docstring")  dolfin::Triangulate "
Create mesh from a triangulation of points
";

%feature("docstring")  dolfin::Triangulate::triangulate "
Create mesh from a triangulation of points
";

// Documentation extracted from: (module=generation, header=BoxMesh.h)
%feature("docstring")  dolfin::BoxMesh "
Tetrahedral mesh of the 3D rectangular prism [x0, x1] x [y0, y1]
x [z0, z1].  Given the number of cells (nx, ny, nz) in each
direction, the total number of tetrahedra will be 6*nx*ny*nz and
the total number of vertices will be (nx + 1)*(ny + 1)*(nz + 1).
";

%feature("docstring")  dolfin::BoxMesh::BoxMesh "
Create a uniform finite element :py:class:`Mesh` over the rectangular prism
[x0, x1] x [y0, y1] x [z0, z1].

*Arguments*
    x0 (float)
        :math:`x`-min.
    y0 (float)
        :math:`y`-min.
    z0 (float)
        :math:`z`-min.
    x1 (float)
        :math:`x`-max.
    y1 (float)
        :math:`y`-max.
    z1 (float)
        :math:`z`-max.
    xn (float)
        Number of cells in :math:`x`-direction.
    yn (float)
        Number of cells in :math:`y`-direction.
    zn (float)
        Number of cells in :math:`z`-direction.

*Example*
    .. note::
    
        No example code available for this function.
";

// Documentation extracted from: (module=generation, header=EllipseMesh.h)
%feature("docstring")  dolfin::EllipseMesh "
Triangular mesh of an ellipse. CGAL is used to generate the
mesh.
";

%feature("docstring")  dolfin::EllipseMesh::EllipseMesh "
        EllipsoidMesh mesh(Point(1.0, 2.0), dims, 0.2);

";

%feature("docstring")  dolfin::CircleMesh::CircleMesh "
Create an unstructured :py:class:`Mesh` of a circle

*Arguments*
    center (:py:class:`Point`)
        Center of the ellipsoid
    radius (float)
        Axes lengths
    cell_size (float)
        Cell size measure

*Example*
    .. note::
    
        No example code available for this function.
";

// Documentation extracted from: (module=generation, header=EllipsoidMesh.h)
%feature("docstring")  dolfin::EllipsoidMesh "
Tetrahedral mesh of an ellipsoid. CGAL is used to generate the
mesh.
";

%feature("docstring")  dolfin::EllipsoidMesh::EllipsoidMesh "
        EllipsoidMesh mesh(Point(1.0, 2.0, -1.0), dims, 0.2);

";

%feature("docstring")  dolfin::SphereMesh::SphereMesh "
Create an unstructured :py:class:`Mesh` of a sphere

*Arguments*
    center (:py:class:`Point`)
        Center of the ellipsoid
    radius (float)
        Axes lengths
    cell_size (float)
        Cell size measure

*Example*
    .. note::
    
        No example code available for this function.
";

// Documentation extracted from: (module=generation, header=IntervalMesh.h)
%feature("docstring")  dolfin::IntervalMesh "
Interval mesh of the 1D line [a,b].  Given the number of cells
(nx) in the axial direction, the total number of intervals will
be nx and the total number of vertices will be (nx + 1).
";

%feature("docstring")  dolfin::IntervalMesh::IntervalMesh "
Constructor

*Arguments*
    nx (int)
        The number of cells.
    a (float)
        The minimum point (inclusive).
    b (float)
        The maximum point (inclusive).

*Example*
    .. note::
    
        No example code available for this function.
";

// Documentation extracted from: (module=generation, header=Interval.h)
%feature("docstring")  dolfin::Interval "
Interval mesh of the 1D line [a,b].  Given the number of cells
(nx) in the axial direction, the total number of intervals will
be nx and the total number of vertices will be (nx + 1).

This class is deprecated. Use :py:class:`IntervalMesh`.
";

%feature("docstring")  dolfin::Interval::Interval "
Constructor

*Arguments*
    nx (int)
        The number of cells.
    a (float)
        The minimum point (inclusive).
    b (float)
        The maximum point (inclusive).

*Example*
    .. note::
    
        No example code available for this function.
";

// Documentation extracted from: (module=generation, header=RectangleMesh.h)
%feature("docstring")  dolfin::RectangleMesh "
Triangular mesh of the 2D rectangle (x0, y0) x (x1, y1).
Given the number of cells (nx, ny) in each direction,
the total number of triangles will be 2*nx*ny and the
total number of vertices will be (nx + 1)*(ny + 1).

*Arguments*
    x0 (float)
        :math:`x`-min.
    y0 (float)
        :math:`y`-min.
    x1 (float)
        :math:`x`-max.
    y1 (float)
        :math:`y`-max.
    xn (float)
        Number of cells in :math:`x`-direction.
    yn (float)
        Number of cells in :math:`y`-direction.
    diagonal (str)
        Direction of diagonals: \"left\", \"right\", \"left/right\", \"crossed\"

*Example*
    .. note::
    
        No example code available for this function.
";

// Documentation extracted from: (module=generation, header=UnitTetrahedronMesh.h)
%feature("docstring")  dolfin::UnitTetrahedronMesh "
A mesh consisting of a single tetrahedron with vertices at

  (0, 0, 0)
  (1, 0, 0)
  (0, 1, 0)
  (0, 0, 1)

This class is useful for testing.
";

%feature("docstring")  dolfin::UnitTetrahedronMesh::UnitTetrahedronMesh "
Create mesh of unit tetrahedron
";

// Documentation extracted from: (module=generation, header=UnitCubeMesh.h)
%feature("docstring")  dolfin::UnitCubeMesh "
Tetrahedral mesh of the 3D unit cube [0,1] x [0,1] x [0,1].
Given the number of cells (nx, ny, nz) in each direction,
the total number of tetrahedra will be 6*nx*ny*nz and the
total number of vertices will be (nx + 1)*(ny + 1)*(nz + 1).
";

%feature("docstring")  dolfin::UnitCubeMesh::UnitCubeMesh "
Create a uniform finite element :py:class:`Mesh` over the unit cube
[0,1] x [0,1] x [0,1].

*Arguments*
    nx (int)
        Number of cells in :math:`x` direction.
    ny (int)
        Number of cells in :math:`y` direction.
    nz (int)
        Number of cells in :math:`z` direction.

*Example*
    .. note::
    
        No example code available for this function.
";

// Documentation extracted from: (module=generation, header=UnitCube.h)
%feature("docstring")  dolfin::UnitCube "
Tetrahedral mesh of the 3D unit cube [0,1] x [0,1] x [0,1].
Given the number of cells (nx, ny, nz) in each direction,
the total number of tetrahedra will be 6*nx*ny*nz and the
total number of vertices will be (nx + 1)*(ny + 1)*(nz + 1).

This class has been deprecated. Unit :py:class:`UnitCubeMesh`.
";

%feature("docstring")  dolfin::UnitCube::UnitCube "
Create a uniform finite element :py:class:`Mesh` over the unit cube
[0,1] x [0,1] x [0,1].

*Arguments*
    nx (int)
        Number of cells in :math:`x` direction.
    ny (int)
        Number of cells in :math:`y` direction.
    nz (int)
        Number of cells in :math:`z` direction.

*Example*
    .. note::
    
        No example code available for this function.
";

// Documentation extracted from: (module=generation, header=UnitIntervalMesh.h)
%feature("docstring")  dolfin::UnitIntervalMesh "
A mesh of the unit interval (0, 1) with a given number of cells
(nx) in the axial direction. The total number of intervals will
be nx and the total number of vertices will be (nx + 1).
";

%feature("docstring")  dolfin::UnitIntervalMesh::UnitIntervalMesh "
Create mesh of unit interval
";

// Documentation extracted from: (module=generation, header=UnitInterval.h)
%feature("docstring")  dolfin::UnitInterval "
A mesh of the unit interval (0, 1) with a given number of cells
(nx) in the axial direction. The total number of intervals will
be nx and the total number of vertices will be (nx + 1).

This class has been deprecated. Use :py:class:`UnitIntervalMesh`.
";

%feature("docstring")  dolfin::UnitInterval::UnitInterval "
Create mesh of unit interval
";

// Documentation extracted from: (module=generation, header=UnitTriangleMesh.h)
%feature("docstring")  dolfin::UnitTriangleMesh "
A mesh consisting of a single triangle with vertices at

  (0, 0)
  (1, 0)
  (0, 1)

This class is useful for testing.
";

%feature("docstring")  dolfin::UnitTriangleMesh::UnitTriangleMesh "
Create mesh of unit triangle
";

// Documentation extracted from: (module=generation, header=UnitSquareMesh.h)
%feature("docstring")  dolfin::UnitSquareMesh "
Triangular mesh of the 2D unit square [0,1] x [0,1].
Given the number of cells (nx, ny) in each direction,
the total number of triangles will be 2*nx*ny and the
total number of vertices will be (nx + 1)*(ny + 1).

std::string diagonal (\"left\", \"right\", \"right/left\", \"left/right\",
or \"crossed\") indicates the direction of the diagonals.
";

%feature("docstring")  dolfin::UnitSquareMesh::UnitSquareMesh "
Create a uniform finite element :py:class:`Mesh` over the unit square
[0,1] x [0,1].

*Arguments*
    nx (int)
        Number of cells in horizontal direction.
    ny (int)
        Number of cells in vertical direction.
    diagonal (str)
        Optional argument: A std::string indicating
        the direction of the diagonals.

*Example*
    .. note::
    
        No example code available for this function.
";

// Documentation extracted from: (module=generation, header=UnitSquare.h)
%feature("docstring")  dolfin::UnitSquare "
Triangular mesh of the 2D unit square [0,1] x [0,1].
Given the number of cells (nx, ny) in each direction,
the total number of triangles will be 2*nx*ny and the
total number of vertices will be (nx + 1)*(ny + 1).

std::string diagonal (\"left\", \"right\", \"right/left\", \"left/right\",
or \"crossed\") indicates the direction of the diagonals.

This class is deprecated. Use :py:class:`UnitSquareMesh`.
";

%feature("docstring")  dolfin::UnitSquare::UnitSquare "
Create a uniform finite element :py:class:`Mesh` over the unit square
[0,1] x [0,1].

*Arguments*
    nx (int)
        Number of cells in horizontal direction.
    ny (int)
        Number of cells in vertical direction.
    diagonal (str)
        Optional argument: A std::string indicating
        the direction of the diagonals.

*Example*
    .. note::
    
        No example code available for this function.
";

// Documentation extracted from: (module=generation, header=UnitCircleMesh.h)
%feature("docstring")  dolfin::UnitCircleMesh "
This class is deprecated.
";

%feature("docstring")  dolfin::UnitCircleMesh::UnitCircleMesh "
This class is deprecated
";

// Documentation extracted from: (module=generation, header=UnitCircle.h)
%feature("docstring")  dolfin::UnitCircle::UnitCircle "
Create a uniform finite element :py:class:`Mesh` over the unit circle.
This class is deprecated. Use :py:class:`UnitCircleMesh`.

*Arguments*
    n (int)
        Resolution of the mesh.
    diagonal (str)
        Optional argument: A std::string indicating
        the direction of the diagonals.
    transformation (str)
        Optional argument: A std::string indicating
        the type of transformation used.
";

// Documentation extracted from: (module=generation, header=CSGGeometry.h)
%feature("docstring")  dolfin::CSGGeometry "
Geometry described by Constructive Solid Geometry (CSG)
";

%feature("docstring")  dolfin::CSGGeometry::CSGGeometry "
Constructor
";

%feature("docstring")  dolfin::CSGGeometry::dim "
Return dimension of geometry
";

%feature("docstring")  dolfin::CSGGeometry::str "
Informal string representation
";

%feature("docstring")  dolfin::CSGGeometry::set_subdomain "
Define subdomain. This feature is 2D only.
The subdomain is itself a CSGGeometry and the corresponding
cells in the resulting will be marked with i
If subdomains overlap, the latest added will take precedence.
";

// Documentation extracted from: (module=generation, header=CSGMeshGenerator.h)
%feature("docstring")  dolfin::CSGMeshGenerator "
Mesh generator for Constructive Solid Geometry (CSG)
";

%feature("docstring")  dolfin::CSGMeshGenerator::generate "
**Overloaded versions**

* generate\ (mesh, geometry, resolution)

  Generate mesh from CSG geometry

* generate\ (mesh, geometry)

  Generate boundary mesh from the surface of a CSG geometry
";

// Documentation extracted from: (module=generation, header=CSGCGALMeshGenerator2D.h)
%feature("docstring")  dolfin::CSGCGALMeshGenerator2D "
Mesh generator for Constructive Solid Geometry (CSG)
utilizing CGALs 2D Regularized Boolean Set-Operations
";

%feature("docstring")  dolfin::CSGCGALMeshGenerator2D::default_parameters "
Default parameter values
";

// Documentation extracted from: (module=generation, header=CSGCGALMeshGenerator3D.h)
%feature("docstring")  dolfin::CSGCGALMeshGenerator3D "
Mesh generator for Constructive Solid Geometry (CSG)
utilizing CGALs boolean operation on Nef_polyhedrons.
";

%feature("docstring")  dolfin::CSGCGALMeshGenerator3D::default_parameters "
Default parameter values
";

// Documentation extracted from: (module=generation, header=CSGOperators.h)
%feature("docstring")  dolfin::CSGUnion "
Union of CSG geometries
";

%feature("docstring")  dolfin::CSGUnion::CSGUnion "
Create union of two geometries
";

%feature("docstring")  dolfin::CSGUnion::str "
Informal string representation
";

%feature("docstring")  dolfin::CSGDifference "
Difference of CSG geometries
";

%feature("docstring")  dolfin::CSGDifference::CSGDifference "
Create union of two geometries
";

%feature("docstring")  dolfin::CSGDifference::str "
Informal string representation
";

%feature("docstring")  dolfin::CSGIntersection "
Intersection of CSG geometries
";

%feature("docstring")  dolfin::CSGIntersection::CSGIntersection "
Create intersection of two geometries
";

%feature("docstring")  dolfin::CSGIntersection::str "
Informal string representation
";

%feature("docstring")  dolfin::CSGIntersection::operator+ "
**Overloaded versions**

* operator+\ (g0, g1)

  Create union of two geometries

* operator+\ (g0, g1)

  Create union of two geometries

* operator+\ (g0, g1)

  Create union of two geometries

* operator+\ (g0, g1)

  Create union of two geometries
";

%feature("docstring")  dolfin::CSGIntersection::operator- "
**Overloaded versions**

* operator-\ (g0, g1)

  Create difference of two geometries

* operator-\ (g0, g1)

  Create difference of two geometries

* operator-\ (g0, g1)

  Create union of two geometries

* operator-\ (g0, g1)

  Create difference of two geometries
";

%feature("docstring")  dolfin::CSGIntersection::operator* "
**Overloaded versions**

* operator*\ (g0, g1)

  Create intersection  of two geometries

* operator*\ (g0, g1)

  Create intersection of two geometries

* operator*\ (g0, g1)

  Create intersection of two geometries

* operator*\ (g0, g1)

  Create intersection of two geometries
";

// Documentation extracted from: (module=generation, header=CSGPrimitive.h)
%feature("docstring")  dolfin::CSGPrimitive "
Base class for Constructive Solid Geometry (CSG) primitives.
";

// Documentation extracted from: (module=generation, header=CSGPrimitives2D.h)
%feature("docstring")  dolfin::CSGPrimitive2D "
Base class for 2D primitives
";

%feature("docstring")  dolfin::CSGPrimitive2D::dim "
Return dimension of geometry
";

%feature("docstring")  dolfin::Circle "
This class describes a 2D circle which can be used to build
geometries using Constructive Solid Geometry (CSG).
";

%feature("docstring")  dolfin::Circle::Circle "
Create circle at x = (x0, x1) with radius r.

*Arguments*
    x0 (float)
        x0-coordinate of center.
    x1 (float)
        x1-coordinate of center.
    r (float)
        radius.
    fragments (int)
        number of fragments.
";

%feature("docstring")  dolfin::Circle::str "
Informal string representation
";

%feature("docstring")  dolfin::Circle::center "
Return center of circle
";

%feature("docstring")  dolfin::Circle::radius "
Return radius of circle
";

%feature("docstring")  dolfin::Circle::fragments "
Return number of fragments around the circle
";

%feature("docstring")  dolfin::Ellipse "
This class describes a 2D ellipse which can be used to build
geometries using Constructive Solid Geometry (CSG).
";

%feature("docstring")  dolfin::Ellipse::Ellipse "
Create ellipse at x = (x0, x1) with horizontal semi-axis a and
vertical semi-axis b.

*Arguments*
    x0 (float)
        x0-coordinate of center.
    x1 (float)
        x1-coordinate of center.
    a (float)
        horizontal semi-axis.
    b (float)
        vertical semi-axis.
    fragments (int)
        number of fragments.
";

%feature("docstring")  dolfin::Ellipse::str "
Informal string representation
";

%feature("docstring")  dolfin::Ellipse::center "
Return center of ellipse
";

%feature("docstring")  dolfin::Ellipse::a "
Return horizontal semi-axis
";

%feature("docstring")  dolfin::Ellipse::b "
Return vertical semi-axis
";

%feature("docstring")  dolfin::Ellipse::fragments "
Return number of fragments around the ellipse
";

%feature("docstring")  dolfin::Rectangle "
This class describes a 2D rectangle which can be used to build
geometries using Constructive Solid Geometry (CSG).
";

%feature("docstring")  dolfin::Rectangle::Rectangle "
Create rectangle defined by two opposite corners
x = (x0, x1) and y = (y0, y1).

*Arguments*
    x0 (float)
        x0-coordinate of first corner.
    x1 (float)
        x1-coordinate of first corner.
    y0 (float)
        y0-coordinate of second corner.
    y1 (float)
        y1-coordinate of second corner.
";

%feature("docstring")  dolfin::Rectangle::str "
Informal string representation
";

%feature("docstring")  dolfin::Rectangle::first_corner "
Return first corner
";

%feature("docstring")  dolfin::Rectangle::second_corner "
Return second corner
";

%feature("docstring")  dolfin::Polygon "
This class describes a 2D polygon which can be used to build
geometries using Constructive Solid Geometry (CSG).
";

%feature("docstring")  dolfin::Polygon::str "
Informal string representation
";

%feature("docstring")  dolfin::Polygon::vertices "
Return vertices in polygon
";

// Documentation extracted from: (module=generation, header=CSGPrimitives3D.h)
%feature("docstring")  dolfin::CSGPrimitive3D "
Base class for 3D primitives
";

%feature("docstring")  dolfin::CSGPrimitive3D::dim "
Return dimension of geometry
";

%feature("docstring")  dolfin::Sphere "
This class describes a 3D sphere which can be used to build
geometries using Constructive Solid Geometry (CSG).
";

%feature("docstring")  dolfin::Sphere::Sphere "
Create sphere at x = (x0, x1, x2) with radius r.

*Arguments*
    x0 (float)
        x0-coordinate of center.
    x1 (float)
        x1-coordinate of center.
    x2 (float)
        x2-coordinate of center.
    r (float)
        radius.
";

%feature("docstring")  dolfin::Sphere::str "
Informal string representation
";

%feature("docstring")  dolfin::Box "
This class describes a 3D box which can be used to build
geometries using Constructive Solid Geometry (CSG).
";

%feature("docstring")  dolfin::Box::Box "
Create box defined by two opposite corners
x = (x0, x1, x2) and y = (y0, y1, y2).

*Arguments*
    x0 (float)
        x0-coordinate of first corner.
    x1 (float)
        x1-coordinate of first corner.
    x2 (float)
        x2-coordinate of first corner.
    y0 (float)
        y0-coordinate of second corner.
    y1 (float)
        y1-coordinate of second corner.
    y2 (float)
        y2-coordinate of second corner.
";

%feature("docstring")  dolfin::Box::str "
Informal string representation
";

%feature("docstring")  dolfin::Cone "
This class describes a 3D cone which can be used to build
geometries using Constructive Solid Geometry (CSG).
";

%feature("docstring")  dolfin::Cone::Cone "
Create cone defined by upper and lower center
and radius respectively.

*Arguments*
    top (Point)
        Center at top of cone.
    top_radius (float)
        Radius bottom of cone.
    bottom (Point)
        Center at top of cone.
    bottom_radius (float)
        radius at top of cone.
    slices (int)
        number of faces on the side when generating a
        polyhedral approximation.
";

%feature("docstring")  dolfin::Cone::str "
Informal string representation
";

%feature("docstring")  dolfin::Cylinder "
This class describes a 3D cylinder which can be used to build
geometries using Constructive Solid Geometry (CSG). A cylinder
is here just a special case of a cone.
";

%feature("docstring")  dolfin::Cylinder::Cylinder "
Create cylinder defined by upper and lower center
and radius respectively.

*Arguments*
    top (Point)
        Center at top of cylinder.
    bottom (Point)
        Center at top of cylinder.
    r (float)
        radius of cylinder.
    slices (int)
        number of faces on the side when generating a
        polyhedral approximation.
";

%feature("docstring")  dolfin::Tetrahedron "
This class describes a Tetrahedron which can be used to build
geometries using Constructive Solid Geometry (CSG).
";

%feature("docstring")  dolfin::Tetrahedron::Tetrahedron "
Create tetrahedron defined by four corner points.

*Arguments*
    x0 (Point)
        Point.
    x1 (Point)
        Point.
    x2 (Point)
        Point.
    x3 (Point)
        Point.
";

%feature("docstring")  dolfin::Tetrahedron::str "
Informal string representation
";

%feature("docstring")  dolfin::Surface3D "
This class describes a 3D surface loaded from file.
The supported file types
";

%feature("docstring")  dolfin::Surface3D::str "
Informal string representation
";

// Documentation extracted from: (module=generation, header=CSGGeometries3D.h)
