set common {
  {Press Backspace to clear console}
  {Press Backquote to fold/unfold console}
  {Press F1 for complete help}
}

set keyboard_keyboard {
  {Press any key below to play a note}
  {Press more than one key to play chords}
  {Move mouse away from dotted line to bend pitch}
  {Green keys are key notes}
  {Green key to Green key is an octave of the scale.}
  {Press z to shift down an octave}
  {Press x to shift up an octave}
  {Click on Delay to toggle stereo Delay}
  {Play with Parameters!}
  {Click once and move mouse to move sliders!}
  {Press 2 to edit waveform of the notes}
  {Press 3 to edit attack of the notes}
  {Press 4 to edit decay of the notes}
  {Dotted crosses shown when MIDI is available}
  {White notes -> White boxes, Black notes -> Black boxes}
  {Size of the boxes proportional to MIDI velocity}
  {Press 5 to edit MIDI velocity}
  {Press 6 to edit DIN's delay lines}
  {Press 7 to edit octave shift}
}

set single_insert {
  {Press i to insert a vertex}
}

set undo_redo {
  {Press z to undo}
  {Press LSHIFT & z to redo}
}

set library {
  {Press 9 to assign previous curve from library}
  {Press 0 to assign next curve from library}
}

set curve_editor {
  {Press w a s d keys to pan}
  {Press q e to zoom}
  {Press f on a vertex and move mouse to move vertex}
  {Press f again to stop moving vertex}
  {Press x to snap in x}
  {Press y to snap in y}
  {Press b to snap in both x & y}
  {Press n to move freely}
  {Press v on a vertex to delete}
}

set quit_editor {
  {Press Escape to quit editor}
}

set keyboard_keyboard_waveform {
  {A cycle of waveform shown here}
  {Edit waveform to change the timbre of the notes}
}

set attack {
  {Attack curve shown here}
  {Edit attack curve to change the attack of the notes}
  {Sustain is part of the attack curve}
  {Click on the blue triangle and move mouse to set sustain}
}

set decay {
  {Decay curve shown here}
  {Edit this curve to change the decay of the notes}
}

set velocity {
  {MIDI velocity curve shown here}
  {Edit this curve to determine the note volume at a given velocity}
}

set double_insert {
  {To insert vertex, press i to pick curve, then i again to insert}
}

set delay {
  {Delay is stereo, 1 for L and 1 for R}
  {feedback and volume curves shown here}
  {One curve for every channel ie 2 feedback & 2 volume curves}
  {feedback-L is cyan & feedback-R is yellow}
  {volume-L is red & volume-R is green}
  {To move the entire curve, LSHIFT + f on left most vertex}
  {Move feedback curve beyond max (or -max) to overdrive delay!}
  {Use set-delay command to set the duration of a delay line}
  {eg., set-delay left 5000 sets left channel delay to 5 seconds}
  {eg., set-delay right 10000 sets right channel delay to 10 seconds}
  {eg., set-delay all 1000 sets left & right channel delay to 1 second}
  {delay time is in milliseconds for fine control}
}

set octave_shift {
  {Octave shift curve shown here}
  {Edit curve to determine how the key note shifts an octave}
  {But, dont have to shift octaves! Can shift to any microtone/interval!}
  {Use set-bpm command to control the speed of octave shift}
  {eg., set-bpm os 60 causes an octave shift in 1 second}
}

set gater {
  {Gater curve shown here}
  {Applied on lead voice to make it beat}
  {Edit the curve to change the shape of the beat}
  {Use set-bpm command to change BPM}
  {eg., set-bpm gr 30 beats the lead voice 30 times a minute}
  {Use set-style command to alter beat progression}
  {eg., set-style gr pong reverses beat shape at the end of the beat}
}

set modulation {
  {ampltitude (magenta) and frequency (cyan) modulation curves shown here}
  {carrier is the lead voice. modulators are the AM and FM curves}
  {x is beat. y is modulation level}
  {Use the set-bpm command to set modulation rate}
  {eg., set-bpm fm 240 sets frequency modulation rate to 240 BPM}
  {eg., set-bpm am 30 sets ampltitude modulation rate to 30 BPM}
  {Use the set-var command to set FM depth and AM depth}
  {eg., set-var fm_depth 100 sets FM depth to 100 Hz}
  {eg., set-var am_depth 0.1 sets AM depth to 0.1 of max volume}
}

set drone_modulation {
  {frequency (cyan) and ampltitude (magenta) modulation curves for drones shown here}
  {They affect how the modulating drones move in frequency (x) & amplitude (y) axes}
  {Press o to overlay the current instrument on the editor}
}

set microtonal_keyboard {
  {x is pitch. y is volume}
  {Click on Voice to toggle lead voice}
  {Click on Delay to toggle stereo delay}
  {Move mouse into the playing area to 'play' the instrument!}
  {Glissando, Vibrato & Tremolo are all easy & accurate!}
  {Press a and d to scroll left and right}
  {Press w and s to scroll up and down}
  {Press f to start recording a phrase}
  {Press v to stop recording and play immediately!}
  {Press g to clear previously recorded phrases}
  {Press <- and -> to scratch the phrase, [ and ] to set jog amount}
  {Press z to shift down an octave}
  {Press x to shift up an octave}
  {Press q to create a drone}
  {Keep pressing q and move mouse to spray drones!}
  {Click and drag to select a bunch of drones}
  {Press e and move mouse to move selected drones}
  {Press c to destroy selected drones. Watch out! No undo :)}
  {Press 9 and 0 to change size of drones}
  {Press r and t to modulate the volume of the drones}
  {Press y and u to modulate the pitch of the drones}
  {Press F7 and F8 to change speed of drone pitch modulation}
  {Press F9 and F10 to change speed of drone volume modulation}
  {Press - and + to let modulating drones leave a trail}
  {Press b or click on Gater button to toggle Gater}
  {Gater causes the lead voice to beat}
  {Press i to toggle the pitch & volume information display}
  {Use notation command to change to western notation}
  {eg., notation western}
  {Use key command to change key of the scale}
  {eg., key C sets key to middle-C}
  {key Bb -1 sets key to Bb nearest to middle-C}
  {Use list-scale command to list available scales}
  {Use load-scale command to load an available scale}
  {eg., load-scale minor5 loads the minor pentatonic scale}
  {Press 2 to edit lead voice waveform}
  {Press 3 to edit shape of drone modulation in pitch (x) & volume (y) axes}
  {Press 4 to edit lead voice modulation curves}
  {Press 5 to edit the shape of beat}
  {Press 6 to edit feedback & volume curves!}
  {Press 7 to edit octave shift progression!}
  {Press 8 to edit the timbre of the drones}
}

set microtonal_keyboard_waveform {
  {One cycle of waveform shown here}
  {Edit this waveform to change the timbre of lead voice}
}

set drone {
  {A cycle of Waveform shown here}
  {Edit the waveform to edit the timbre of all drones}
}

set morse_code {
  {Bezier curve patterns for dot, dash, inner, letter and word spacing shown here}
  {Use morse-code command to convert text to morse code}
  {eg., morse-code sos}
  {Paste the generated pattern into any curve on any curve editor!}
}

set compressor {
  {Compressor curve shown here}
  {Edit curve to determine how DIN massages output samples to stay between -1 and 1}
}

set ALL_TIPS(keyboard-keyboard) [concat $keyboard_keyboard $common]
set ALL_TIPS(keyboard-keyboard-waveform) [concat $keyboard_keyboard_waveform $curve_editor $single_insert $undo_redo $library $quit_editor]
set ALL_TIPS(attack) [concat $attack $curve_editor $single_insert $undo_redo $library $quit_editor]
set ALL_TIPS(decay) [concat $decay $curve_editor $single_insert $undo_redo $library $quit_editor]
set ALL_TIPS(velocity) [concat $velocity $curve_editor $single_insert $undo_redo $library $quit_editor]
set ALL_TIPS(delay) [concat $delay $curve_editor $double_insert $undo_redo $quit_editor]
set ALL_TIPS(octave-shift) [concat $octave_shift $curve_editor $single_insert $undo_redo $library $quit_editor]
set ALL_TIPS(microtonal-keyboard) [concat $microtonal_keyboard $common]
set ALL_TIPS(microtonal-keyboard-waveform) [concat $microtonal_keyboard_waveform $curve_editor $single_insert $undo_redo $library $quit_editor $common]
set ALL_TIPS(drone-modulation) [concat $drone_modulation $curve_editor $double_insert $undo_redo $quit_editor $common]
set ALL_TIPS(modulation) [concat $modulation $curve_editor $double_insert $undo_redo $quit_editor $common]
set ALL_TIPS(drone) [concat $drone $curve_editor $single_insert $undo_redo $library $quit_editor $common]
set ALL_TIPS(gater) [concat $gater $curve_editor $single_insert $undo_redo $library $quit_editor $common]
set ALL_TIPS(morse-code) [concat $morse_code $curve_editor $double_insert $undo_redo $quit_editor $common]
set ALL_TIPS(compressor) [concat $compressor $curve_editor $single_insert $undo_redo $quit_editor $common]

set TIPS {}
set NUM_TIPS 0
set SECTION {}

proc get-tip {section} {

  global ALL_TIPS
  global TIPS NUM_TIPS TIP_ID
  global SECTION

  if {$section ne $SECTION} {
    set SECTION $section
    if {[catch {set TIPS $ALL_TIPS($section)}]} { set TIPS {}}
    if {[catch {set tip_id $TIP_ID($section)}]} { set tip_id 0}
    set NUM_TIPS [llength $TIPS]
  } else {
    set tip_id $TIP_ID($section)
  }

  set tip [lindex $TIPS $tip_id]
  incr tip_id
  if {$tip_id >= $NUM_TIPS} {set tip_id 0}
  set TIP_ID($section) $tip_id
  return $tip

}

