/****
DIAMOND protein aligner
Copyright (C) 2020 Max Planck Society for the Advancement of Science e.V.

Code developed by Benjamin Buchfink <benjamin.buchfink@tue.mpg.de>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
****/

#include "../standard_matrix.h"

namespace Stats {

const StandardMatrix pam250{

    14, 2,

	{ { (double)INT2_MAX, (double)INT2_MAX, (double)INT2_MAX, 0.2252, 0.0868, 0.2223, 0.98, -5.0, 0.660059, 11.754300, 11.754300 },
	{ 15, 3, (double)INT2_MAX, 0.205, 0.049, 0.13, 1.6, -23, 0.687656, 34.578400, 34.928000 },
	{ 14, 3, (double)INT2_MAX, 0.200, 0.043, 0.12, 1.7, -26, 0.689768, 43.353000, 43.443800 },
	{ 13, 3, (double)INT2_MAX, 0.194, 0.036, 0.10, 1.9, -31, 0.697431, 50.948500, 51.081700 },
	{ 12, 3, (double)INT2_MAX, 0.186, 0.029, 0.085, 2.2, -41, 0.704565, 69.606500, 69.793600 },
	{ 11, 3, (double)INT2_MAX, 0.174, 0.020, 0.070, 2.5, -48, 0.722438, 98.653500, 98.927100 },
	{ 17, 2, (double)INT2_MAX, 0.204, 0.047, 0.12, 1.7, -28, 0.684799, 41.583800, 41.735800 },
	{ 16, 2, (double)INT2_MAX, 0.198, 0.038, 0.11, 1.8, -29, 0.691098, 51.635200, 51.843900 },
	{ 15, 2, (double)INT2_MAX, 0.191, 0.031, 0.087, 2.2, -44, 0.699051, 67.256700, 67.558500 },
	{ 14, 2, (double)INT2_MAX, 0.182, 0.024, 0.073, 2.5, -53, 0.714103, 96.315100, 96.756800 },
	{ 13, 2, (double)INT2_MAX, 0.171, 0.017, 0.059, 2.9, -64, 0.728738, 135.653000, 136.339000 },
	{ 21, 1, (double)INT2_MAX, 0.205, 0.045, 0.11, 1.8, -34, 0.683265, 48.728200, 49.218800 },
	{ 20, 1, (double)INT2_MAX, 0.199, 0.037, 0.10, 1.9, -35, 0.689380, 60.832000, 61.514100 },
	{ 19, 1, (double)INT2_MAX, 0.192, 0.029, 0.083, 2.3, -52, 0.696344, 84.019700, 84.985600 },
	{ 18, 1, (double)INT2_MAX, 0.183, 0.021, 0.070, 2.6, -60, 0.710525, 113.829000, 115.184000 },
	{ 17, 1, (double)INT2_MAX, 0.171, 0.014, 0.052, 3.3, -86, 0.727000, 175.071000, 177.196000 } },

	{
		   /*       A,  R,  N,  D,  C,  Q,  E,  G,  H,  I,  L,  K,  M,
             F,  P,  S,  T,  W,  Y,  V,  B,  J,  Z,  X,  *        */ 
    /*A*/    2, -2,  0,  0, -2,  0,  0,  1, -1, -1, -2, -1, -1,
            -3,  1,  1,  1, -6, -3,  0,  0, -1,  0, -1, -8, -18,
    /*R*/   -2,  6,  0, -1, -4,  1, -1, -3,  2, -2, -3,  3,  0,
            -4,  0,  0, -1,  2, -4, -2, -1, -3,  0, -1, -8, -18,
    /*N*/    0,  0,  2,  2, -4,  1,  1,  0,  2, -2, -3,  1, -2,
            -3,  0,  1,  0, -4, -2, -2,  2, -3,  1, -1, -8, -18,
    /*D*/    0, -1,  2,  4, -5,  2,  3,  1,  1, -2, -4,  0, -3,
            -6, -1,  0,  0, -7, -4, -2,  3, -3,  3, -1, -8, -18,
    /*C*/   -2, -4, -4, -5, 12, -5, -5, -3, -3, -2, -6, -5, -5,
            -4, -3,  0, -2, -8,  0, -2, -4, -5, -5, -1, -8, -18,
    /*Q*/    0,  1,  1,  2, -5,  4,  2, -1,  3, -2, -2,  1, -1,
            -5,  0, -1, -1, -5, -4, -2,  1, -2,  3, -1, -8, -18,
    /*E*/    0, -1,  1,  3, -5,  2,  4,  0,  1, -2, -3,  0, -2,
            -5, -1,  0,  0, -7, -4, -2,  3, -3,  3, -1, -8, -18,
    /*G*/    1, -3,  0,  1, -3, -1,  0,  5, -2, -3, -4, -2, -3,
            -5,  0,  1,  0, -7, -5, -1,  0, -4,  0, -1, -8, -18,
    /*H*/   -1,  2,  2,  1, -3,  3,  1, -2,  6, -2, -2,  0, -2,
            -2,  0, -1, -1, -3,  0, -2,  1, -2,  2, -1, -8, -18,
    /*I*/   -1, -2, -2, -2, -2, -2, -2, -3, -2,  5,  2, -2,  2,
             1, -2, -1,  0, -5, -1,  4, -2,  3, -2, -1, -8, -18,
    /*L*/   -2, -3, -3, -4, -6, -2, -3, -4, -2,  2,  6, -3,  4,
             2, -3, -3, -2, -2, -1,  2, -3,  5, -3, -1, -8, -18,
    /*K*/   -1,  3,  1,  0, -5,  1,  0, -2,  0, -2, -3,  5,  0,
            -5, -1,  0,  0, -3, -4, -2,  1, -3,  0, -1, -8, -18,
    /*M*/   -1,  0, -2, -3, -5, -1, -2, -3, -2,  2,  4,  0,  6,
             0, -2, -2, -1, -4, -2,  2, -2,  3, -2, -1, -8, -18,
    /*F*/   -3, -4, -3, -6, -4, -5, -5, -5, -2,  1,  2, -5,  0,
             9, -5, -3, -3,  0,  7, -1, -4,  2, -5, -1, -8, -18,
    /*P*/    1,  0,  0, -1, -3,  0, -1,  0,  0, -2, -3, -1, -2,
            -5,  6,  1,  0, -6, -5, -1, -1, -2,  0, -1, -8, -18,
    /*S*/    1,  0,  1,  0,  0, -1,  0,  1, -1, -1, -3,  0, -2,
            -3,  1,  2,  1, -2, -3, -1,  0, -2,  0, -1, -8, -18,
    /*T*/    1, -1,  0,  0, -2, -1,  0,  0, -1,  0, -2,  0, -1,
            -3,  0,  1,  3, -5, -3,  0,  0, -1, -1, -1, -8, -18,
    /*W*/   -6,  2, -4, -7, -8, -5, -7, -7, -3, -5, -2, -3, -4,
             0, -6, -2, -5, 17,  0, -6, -5, -3, -6, -1, -8, -18,
    /*Y*/   -3, -4, -2, -4,  0, -4, -4, -5,  0, -1, -1, -4, -2,
             7, -5, -3, -3,  0, 10, -2, -3, -1, -4, -1, -8, -18,
    /*V*/    0, -2, -2, -2, -2, -2, -2, -1, -2,  4,  2, -2,  2,
            -1, -1, -1,  0, -6, -2,  4, -2,  2, -2, -1, -8, -18,
    /*B*/    0, -1,  2,  3, -4,  1,  3,  0,  1, -2, -3,  1, -2,
            -4, -1,  0,  0, -5, -3, -2,  3, -3,  2, -1, -8, -18,
    /*J*/   -1, -3, -3, -3, -5, -2, -3, -4, -2,  3,  5, -3,  3,
             2, -2, -2, -1, -3, -1,  2, -3,  5, -2, -1, -8, -18,
    /*Z*/    0,  0,  1,  3, -5,  3,  3,  0,  2, -2, -3,  0, -2,
            -5,  0,  0, -1, -6, -4, -2,  2, -2,  3, -1, -8, -18,
    /*X*/   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
            -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -8, -18,
    /***/   -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8,
            -8, -8, -8, -8, -8, -8, -8, -8, -8, -8, -8,  1, -18,
			-18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18,
			-18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18 },

{ {1.1506395421657883e-02, 2.4975231508904631e-03, 3.6632346972757428e-03,
   4.3697565048539024e-03, 1.8276942838570587e-03, 3.0112866662942396e-03,
   4.6380059574065739e-03, 1.0339526813131699e-02, 2.1445971886243646e-03,
   2.8561290389349852e-03, 4.8067900424585462e-03, 5.3728656072800076e-03,
   9.9018955937298613e-04, 1.5464751871669552e-03, 5.7141459312891330e-03,
   7.8179771536648658e-03, 6.7187128037285646e-03, 2.4101326295153331e-04,
   1.1721100314806740e-03, 5.8923284166788933e-03},
  {2.4975231508904631e-03, 6.8223547287428144e-03, 1.6533152696263029e-03,
   1.4242726301819985e-03, 5.8944515652700497e-04, 2.0890675656647919e-03,
   1.5846263196146995e-03, 2.0115937172949889e-03, 1.9669335302920869e-03,
   9.4903575242628803e-04, 1.7492451507985533e-03, 7.1821276038123629e-03,
   5.4579896329619748e-04, 5.8361963932467844e-04, 1.9905178391619333e-03,
   2.6418797202180837e-03, 1.9640564224658449e-03, 7.0871113466232773e-04,
   4.6349536482262227e-04, 1.4862706481749135e-03},
  {3.6632346972757428e-03, 1.6533152696263029e-03, 2.5955847457262279e-03,
   3.0517594529028400e-03, 5.8568302165395883e-04, 1.8510873859350727e-03,
   2.7895276558308215e-03, 3.8931580947872417e-03, 1.9571964875229838e-03,
   9.8420613349048088e-04, 1.7794215836961103e-03, 4.0932232786158613e-03,
   3.9994286569269551e-04, 7.1880113475369782e-04, 1.8301977419577379e-03,
   3.2997070393949880e-03, 2.6196442519984238e-03, 1.6728058239964415e-04,
   7.5085733385690172e-04, 1.7484567810093011e-03},
  {4.3697565048539024e-03, 1.4242726301819985e-03, 3.0517594529028400e-03,
   5.3450782499419218e-03, 4.8131585819575790e-04, 2.6206774727375219e-03,
   5.1008808895958635e-03, 4.7650879451660638e-03, 1.8490514559930820e-03,
   1.0026061088056078e-03, 1.5930790839216963e-03, 3.8473023950370976e-03,
   3.7899432160262535e-04, 5.1061942897298563e-04, 1.9136209919861855e-03,
   3.4857847560291560e-03, 2.6547044011729533e-03, 1.0462445958257217e-04,
   5.1745954208780515e-04, 1.8552568588661234e-03},
  {1.8276942838570587e-03, 5.8944515652700497e-04, 5.8568302165395883e-04,
   4.8131585819575790e-04, 1.7511424258914964e-02, 3.7076129096329572e-04,
   4.8903939170975950e-04, 1.3623489692838801e-03, 5.0846386896381476e-04,
   7.2550893644428554e-04, 7.0799236631215092e-04, 7.7075174636654406e-04,
   1.4785573890415589e-04, 4.9387975479971797e-04, 8.9473603104580409e-04,
   2.3049495795083078e-03, 1.1784720532548663e-03, 5.9299054281549242e-05,
   1.0798150304862418e-03, 1.3840709648926645e-03},
  {3.0112866662942396e-03, 2.0890675656647919e-03, 1.8510873859350727e-03,
   2.6206774727375219e-03, 3.7076129096329572e-04, 3.7185262078390084e-03,
   3.3568227763936856e-03, 2.5676676841601132e-03, 2.5232383252931120e-03,
   8.8236895610109610e-04, 2.1731391610102509e-03, 3.6449762674855470e-03,
   4.4907751867065491e-04, 5.2205033209354096e-04, 2.0463950617354261e-03,
   2.3688704455266710e-03, 1.8654198667353624e-03, 1.3455315022844615e-04,
   4.5154514263611947e-04, 1.6079057012005865e-03},
  {4.6380059574065739e-03, 1.5846263196146995e-03, 2.7895276558308215e-03,
   5.1008808895958635e-03, 4.8903939170975950e-04, 3.3568227763936856e-03,
   5.9222965859089486e-03, 4.5816393201343689e-03, 1.9402998565554576e-03,
   1.1442983475073972e-03, 1.9598706476253135e-03, 3.9374858628132975e-03,
   4.4836711718981544e-04, 5.6555863311724848e-04, 2.2081467402101113e-03,
   3.4413512797094705e-03, 2.6498050070285850e-03, 1.0428284199341159e-04,
   5.5113323096536227e-04, 2.1170384602596944e-03},
  {1.0339526813131699e-02, 2.0115937172949889e-03, 3.8931580947872417e-03,
   4.7650879451660638e-03, 1.3623489692838801e-03, 2.5676676841601132e-03,
   4.5816393201343689e-03, 2.3482233614097934e-02, 1.8337281555648979e-03,
   1.8208983421724295e-03, 2.9852908206479617e-03, 4.8388854328488646e-03,
   6.8680090301959161e-04, 1.1712470257125083e-03, 4.0151722887942186e-03,
   7.8821587248468251e-03, 5.1811218591430661e-03, 1.8631167134196649e-04,
   7.9425725644547004e-04, 4.2129549753424219e-03},
  {2.1445971886243646e-03, 1.9669335302920869e-03, 1.9571964875229838e-03,
   1.8490514559930820e-03, 5.0846386896381476e-04, 2.5232383252931120e-03,
   1.9402998565554576e-03, 1.8337281555648979e-03, 5.0577823911620960e-03,
   7.0758217809190201e-04, 1.7792986667457807e-03, 2.6790420483436923e-03,
   3.0226127635083285e-04, 8.8185158980207221e-04, 1.6125778990215547e-03,
   1.9419581808088138e-03, 1.4578210132932265e-03, 1.9201336290789017e-04,
   9.8449170102575230e-04, 1.2982251382555629e-03},
  {2.8561290389349852e-03, 9.4903575242628803e-04, 9.8420613349048088e-04,
   1.0026061088056078e-03, 7.2550893644428554e-04, 8.8236895610109610e-04,
   1.1442983475073972e-03, 1.8208983421724295e-03, 7.0758217809190201e-04,
   3.8506568985748504e-03, 5.5072715793686080e-03, 1.9022872797907308e-03,
   8.9779553718262028e-04, 1.8514043008626233e-03, 1.1725443795985299e-03,
   1.8542542117578613e-03, 2.1953086037143862e-03, 1.1715327832769289e-04,
   8.8263202943021396e-04, 5.5816714963892811e-03},
  {4.8067900424585462e-03, 1.7492451507985533e-03, 1.7794215836961103e-03,
   1.5930790839216963e-03, 7.0799236631215092e-04, 2.1731391610102509e-03,
   1.9598706476253135e-03, 2.9852908206479617e-03, 1.7792986667457807e-03,
   5.5072715793686080e-03, 2.8633158451940706e-02, 3.5641037178981254e-03,
   2.9437898388951153e-03, 5.1517088250987598e-03, 2.4053702086781481e-03,
   3.1126304674457994e-03, 3.3831513688247950e-03, 5.7942468517701131e-04,
   2.0809174228785228e-03, 8.4617896693113381e-03},
  {5.3728656072800076e-03, 7.1821276038123629e-03, 4.0932232786158613e-03,
   3.8473023950370976e-03, 7.7075174636654406e-04, 3.6449762674855470e-03,
   3.9374858628132975e-03, 4.8388854328488646e-03, 2.6790420483436923e-03,
   1.9022872797907308e-03, 3.5641037178981254e-03, 1.8953839887039359e-02,
   1.3056068288886324e-03, 9.5430576257042143e-04, 3.1427838314461703e-03,
   5.3849029169230475e-03, 4.6910200930370578e-03, 3.8031958293778897e-04,
   8.6636282903806235e-04, 2.9693904037835185e-03},
  {9.9018955937298613e-04, 5.4579896329619748e-04, 3.9994286569269551e-04,
   3.7899432160262535e-04, 1.4785573890415589e-04, 4.4907751867065491e-04,
   4.4836711718981544e-04, 6.8680090301959161e-04, 3.0226127635083285e-04,
   8.9779553718262028e-04, 2.9437898388951153e-03, 1.3056068288886324e-03,
   9.5839891336186689e-04, 6.1182400928263853e-04, 4.6431155948741784e-04,
   7.1706174187243107e-04, 7.5402578765302252e-04, 5.8044986217193111e-05,
   2.5054194683598869e-04, 1.4420721870535345e-03},
  {1.5464751871669552e-03, 5.8361963932467844e-04, 7.1880113475369782e-04,
   5.1061942897298563e-04, 4.9387975479971797e-04, 5.2205033209354096e-04,
   5.6555863311724848e-04, 1.1712470257125083e-03, 8.8185158980207221e-04,
   1.8514043008626233e-03, 5.1517088250987598e-03, 9.5430576257042143e-04,
   6.1182400928263853e-04, 1.2698002251905573e-02, 7.0713747400886877e-04,
   1.3236969321879562e-03, 1.1372790252379261e-03, 4.4935713151489045e-04,
   5.9204171542750639e-03, 1.9724229735869326e-03},
  {5.7141459312891330e-03, 1.9905178391619333e-03, 1.8301977419577379e-03,
   1.9136209919861855e-03, 8.9473603104580409e-04, 2.0463950617354261e-03,
   2.2081467402101113e-03, 4.0151722887942186e-03, 1.6125778990215547e-03,
   1.1725443795985299e-03, 2.4053702086781481e-03, 3.1427838314461703e-03,
   4.6431155948741784e-04, 7.0713747400886877e-04, 9.8665046135635783e-03,
   4.3847634418626652e-03, 3.1909511773661765e-03, 1.4643278579496693e-04,
   4.8653577087297381e-04, 2.4870690688613543e-03},
  {7.8179771536648658e-03, 2.6418797202180837e-03, 3.2997070393949880e-03,
   3.4857847560291560e-03, 2.3049495795083078e-03, 2.3688704455266710e-03,
   3.4413512797094705e-03, 7.8821587248468251e-03, 1.9419581808088138e-03,
   1.8542542117578613e-03, 3.1126304674457994e-03, 5.3849029169230475e-03,
   7.1706174187243107e-04, 1.3236969321879562e-03, 4.3847634418626652e-03,
   6.9740330873263399e-03, 5.5479545040527179e-03, 4.1290844979042010e-04,
   1.0821257035278605e-03, 3.5981076685639816e-03},
  {6.7187128037285646e-03, 1.9640564224658449e-03, 2.6196442519984238e-03,
   2.6547044011729533e-03, 1.1784720532548663e-03, 1.8654198667353624e-03,
   2.6498050070285850e-03, 5.1811218591430661e-03, 1.4578210132932265e-03,
   2.1953086037143862e-03, 3.3831513688247950e-03, 4.6910200930370578e-03,
   7.5402578765302252e-04, 1.1372790252379261e-03, 3.1909511773661765e-03,
   5.5479545040527179e-03, 6.1907639011039494e-03, 1.8788403040115726e-04,
   9.2861947637862599e-04, 4.0449485444032200e-03},
  {2.4101326295153331e-04, 7.0871113466232773e-04, 1.6728058239964415e-04,
   1.0462445958257217e-04, 5.9299054281549242e-05, 1.3455315022844615e-04,
   1.0428284199341159e-04, 1.8631167134196649e-04, 1.9201336290789017e-04,
   1.1715327832769289e-04, 5.7942468517701131e-04, 3.8031958293778897e-04,
   5.8044986217193111e-05, 4.4935713151489045e-04, 1.4643278579496693e-04,
   4.1290844979042010e-04, 1.8788403040115726e-04, 5.7988503825631863e-03,
   3.0440102514689768e-04, 1.6081303524350391e-04},
  {1.1721100314806740e-03, 4.6349536482262227e-04, 7.5085733385690172e-04,
   5.1745954208780515e-04, 1.0798150304862418e-03, 4.5154514263611947e-04,
   5.5113323096536227e-04, 7.9425725644547004e-04, 9.8449170102575230e-04,
   8.8263202943021396e-04, 2.0809174228785228e-03, 8.6636282903806235e-04,
   2.5054194683598869e-04, 5.9204171542750639e-03, 4.8653577087297381e-04,
   1.0821257035278605e-03, 9.2861947637862599e-04, 3.0440102514689768e-04,
   9.2529814445245183e-03, 1.0955188103504248e-03},
  {5.8923284166788933e-03, 1.4862706481749135e-03, 1.7484567810093011e-03,
   1.8552568588661234e-03, 1.3840709648926645e-03, 1.6079057012005865e-03,
   2.1170384602596944e-03, 4.2129549753424219e-03, 1.2982251382555629e-03,
   5.5816714963892811e-03, 8.4617896693113381e-03, 2.9693904037835185e-03,
   1.4420721870535345e-03, 1.9724229735869326e-03, 2.4870690688613543e-03,
   3.5981076685639816e-03, 4.0449485444032200e-03, 1.6081303524350391e-04,
   1.0955188103504248e-03, 1.1301289775766317e-02} },

   { 8.7126757718998679e-02, 4.0903890307999048e-02, 4.0432285538126674e-02,
     4.6871932807633972e-02, 3.3473507356366124e-02, 3.8255436978704142e-02,
     4.9530476921569762e-02, 8.8612083613937145e-02, 3.3618414314618796e-02,
     3.6885613388971901e-02, 8.5357443758733623e-02, 8.0481583375956817e-02,
     1.4752761600830055e-02, 3.9771658566274730e-02, 5.0679914836743105e-02,
     6.9577076005018168e-02, 5.8541664190993777e-02, 1.0493678893463984e-02,
     2.9916218247065893e-02, 6.4717601577993583e-02 },

  { {0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
    0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
    0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
    0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
    0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
    0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
    0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00},
   {0.00000000e+00, 1.51578006e+00, 1.05606466e+00, 6.26687137e-01,
    1.07002228e+00, 1.07474947e+00, 4.46290560e-01, 1.33923306e+00,
    7.32178470e-01, 8.88728816e-01, 7.66227814e-01, 6.46341735e-01,
    7.70359541e-01, 1.03988401e+00, 1.29408826e+00, 9.03456780e-01,
    7.00798809e-01, 1.28966428e+00, 1.31725380e+00, 1.04499203e+00,
    2.63609841e-01, 7.50000000e-01, 4.49686798e-01, 1.00010336e+00,
    7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 7.19479599e-01},
   {0.00000000e+00, 1.05606466e+00, 1.84257846e+00, 3.65113184e-01,
    2.05195422e+00, 1.82470118e+00, 3.54071966e-01, 1.11918465e+00,
    1.29683470e+00, 6.16970770e-01, 1.13010166e+00, 4.52559218e-01,
    6.04775077e-01, 1.59985542e+00, 8.46142888e-01, 1.33890747e+00,
    8.61808201e-01, 1.11706882e+00, 1.03197349e+00, 6.37811920e-01,
    2.96793416e-01, 7.50000000e-01, 4.85608019e-01, 1.61300149e+00,
    7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 5.02168751e-01},
   {0.00000000e+00, 6.26687137e-01, 3.65113184e-01, 1.56285624e+01,
    3.06772262e-01, 2.94964746e-01, 3.70976416e-01, 4.59297624e-01,
    4.51836855e-01, 5.87603719e-01, 2.86099293e-01, 2.47791243e-01,
    2.99408166e-01, 4.32746060e-01, 5.27421501e-01, 2.89534285e-01,
    4.30504374e-01, 9.89678273e-01, 6.01385571e-01, 6.38902701e-01,
    1.68818010e-01, 7.50000000e-01, 1.07830459e+00, 2.92598254e-01,
    7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 3.50326241e-01},
   {0.00000000e+00, 1.07002228e+00, 2.05195422e+00, 3.06772262e-01,
    2.43292288e+00, 2.19715052e+00, 2.73911818e-01, 1.14726861e+00,
    1.17343465e+00, 5.79909835e-01, 1.01987501e+00, 3.98183329e-01,
    5.48083233e-01, 1.61030872e+00, 8.05577240e-01, 1.46152937e+00,
    7.42874842e-01, 1.06886174e+00, 9.67471640e-01, 6.11601820e-01,
    2.12712296e-01, 7.50000000e-01, 3.69025897e-01, 1.87658077e+00,
    7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 4.53017475e-01},
   {0.00000000e+00, 1.07474947e+00, 1.82470118e+00, 2.94964746e-01,
    2.19715052e+00, 2.41404373e+00, 2.87098831e-01, 1.04389169e+00,
    1.16525001e+00, 6.26339428e-01, 9.87756703e-01, 4.63568053e-01,
    6.13603630e-01, 1.39293185e+00, 8.79669521e-01, 1.77158803e+00,
    7.82149443e-01, 9.98597151e-01, 9.13853001e-01, 6.60440693e-01,
    2.00637717e-01, 7.50000000e-01, 3.71943861e-01, 2.13407372e+00,
    7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 5.12682678e-01},
   {0.00000000e+00, 4.46290560e-01, 3.54071966e-01, 3.70976416e-01,
    2.73911818e-01, 2.87098831e-01, 8.02764197e+00, 3.32339414e-01,
    6.59545216e-01, 1.26203255e+00, 2.98137999e-01, 1.51752623e+00,
    1.04274830e+00, 4.46999215e-01, 3.50828021e-01, 3.43119584e-01,
    3.58749728e-01, 4.78353203e-01, 4.88459165e-01, 7.66309017e-01,
    1.07668873e+00, 7.50000000e-01, 4.97590308e+00, 3.11511613e-01,
    7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 1.44043358e+00},
   {0.00000000e+00, 1.33923306e+00, 1.11918465e+00, 4.59297624e-01,
    1.14726861e+00, 1.04389169e+00, 3.32339414e-01, 2.99056680e+00,
    6.15552047e-01, 5.57103314e-01, 6.78509416e-01, 3.94686522e-01,
    5.25369171e-01, 1.08662777e+00, 8.94077901e-01, 7.57447784e-01,
    5.54986868e-01, 1.27845679e+00, 9.98770702e-01, 7.34634729e-01,
    2.00363838e-01, 7.50000000e-01, 2.99613619e-01, 9.19064864e-01,
    7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 4.43694156e-01},
   {0.00000000e+00, 7.32178470e-01, 1.29683470e+00, 4.51836855e-01,
    1.17343465e+00, 1.16525001e+00, 6.59545216e-01, 6.15552047e-01,
    4.47513035e+00, 5.70614299e-01, 9.90160946e-01, 6.20055020e-01,
    6.09441413e-01, 1.43988866e+00, 9.46471632e-01, 1.96194975e+00,
    1.43036819e+00, 8.30226277e-01, 7.40733381e-01, 5.96692220e-01,
    5.44285116e-01, 7.50000000e-01, 9.78877039e-01, 1.51243666e+00,
    7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 6.05136779e-01},
   {0.00000000e+00, 8.88728816e-01, 6.16970770e-01, 5.87603719e-01,
    5.79909835e-01, 6.26339428e-01, 1.26203255e+00, 5.57103314e-01,
    5.70614299e-01, 2.83022396e+00, 6.40800116e-01, 1.74919442e+00,
    1.64986005e+00, 6.59934398e-01, 6.27243837e-01, 6.25316723e-01,
    6.29014923e-01, 7.22513707e-01, 1.01665478e+00, 2.33821719e+00,
    3.02670201e-01, 7.50000000e-01, 7.99863687e-01, 6.25893752e-01,
    7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 2.07538421e+00},
   {0.00000000e+00, 7.66227814e-01, 1.13010166e+00, 2.86099293e-01,
    1.01987501e+00, 9.87756703e-01, 2.98137999e-01, 6.78509416e-01,
    9.90160946e-01, 6.40800116e-01, 2.92620120e+00, 5.18814877e-01,
    1.09961986e+00, 1.25788411e+00, 7.70516817e-01, 1.18387275e+00,
    2.18168472e+00, 9.61645918e-01, 9.95647751e-01, 5.70096500e-01,
    4.50323287e-01, 7.50000000e-01, 3.59829368e-01, 1.07322036e+00,
    7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 5.55622697e-01},
   {0.00000000e+00, 6.46341735e-01, 4.52559218e-01, 2.47791243e-01,
    3.98183329e-01, 4.63568053e-01, 1.51752623e+00, 3.94686522e-01,
    6.20055020e-01, 1.74919442e+00, 5.18814877e-01, 3.92994485e+00,
    2.33771776e+00, 5.15595552e-01, 5.56038228e-01, 6.65507525e-01,
    5.01008003e-01, 5.24107036e-01, 6.77040993e-01, 1.53178711e+00,
    6.46886104e-01, 7.50000000e-01, 8.14904569e-01, 5.51569446e-01,
    7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 3.27192533e+00},
   {0.00000000e+00, 7.70359541e-01, 6.04775077e-01, 2.99408166e-01,
    5.48083233e-01, 6.13603630e-01, 1.04274830e+00, 5.25369171e-01,
    6.09441413e-01, 1.64986005e+00, 1.09961986e+00, 2.33771776e+00,
    4.40351686e+00, 6.70496227e-01, 6.21012433e-01, 7.95710012e-01,
    9.04471250e-01, 6.98581457e-01, 8.73067477e-01, 1.51039751e+00,
    3.74941590e-01, 7.50000000e-01, 5.67675865e-01, 6.92962139e-01,
    7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 2.13016362e+00},
   {0.00000000e+00, 1.03988401e+00, 1.59985542e+00, 4.32746060e-01,
    1.61030872e+00, 1.39293185e+00, 4.46999215e-01, 1.08662777e+00,
    1.43988866e+00, 6.59934398e-01, 1.25788411e+00, 5.15595552e-01,
    6.70496227e-01, 1.58773724e+00, 8.93169424e-01, 1.19675558e+00,
    9.99684066e-01, 1.17295383e+00, 1.10674855e+00, 6.68196499e-01,
    3.94266130e-01, 7.50000000e-01, 6.20758168e-01, 1.30744195e+00,
    7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 5.59148347e-01},
   {0.00000000e+00, 1.29408826e+00, 8.46142888e-01, 5.27421501e-01,
    8.05577240e-01, 8.79669521e-01, 3.50828021e-01, 8.94077901e-01,
    9.46471632e-01, 6.27243837e-01, 7.70516817e-01, 5.56038228e-01,
    6.21012433e-01, 8.93169424e-01, 3.84141803e+00, 1.05550534e+00,
    9.60208581e-01, 1.24349521e+00, 1.07552180e+00, 7.58279920e-01,
    2.75343404e-01, 7.50000000e-01, 3.20901839e-01, 9.56295438e-01,
    7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 5.77523805e-01},
   {0.00000000e+00, 9.03456780e-01, 1.33890747e+00, 2.89534285e-01,
    1.46152937e+00, 1.77158803e+00, 3.43119584e-01, 7.57447784e-01,
    1.96194975e+00, 6.25316723e-01, 1.18387275e+00, 6.65507525e-01,
    7.95710012e-01, 1.19675558e+00, 1.05550534e+00, 2.54088209e+00,
    1.33504131e+00, 8.89983529e-01, 8.32948914e-01, 6.49448913e-01,
    3.35176014e-01, 7.50000000e-01, 3.94549334e-01, 2.10683180e+00,
    7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 6.53380354e-01},
   {0.00000000e+00, 7.00798809e-01, 8.61808201e-01, 4.30504374e-01,
    7.42874842e-01, 7.82149443e-01, 3.58749728e-01, 5.54986868e-01,
    1.43036819e+00, 6.29014923e-01, 2.18168472e+00, 5.01008003e-01,
    9.04471250e-01, 9.99684066e-01, 9.60208581e-01, 1.33504131e+00,
    4.07760419e+00, 9.28286966e-01, 8.20208528e-01, 5.61449723e-01,
    1.65111328e+00, 7.50000000e-01, 3.78768704e-01, 1.02308924e+00,
    7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 5.39632804e-01},
   {0.00000000e+00, 1.28966428e+00, 1.11706882e+00, 9.89678273e-01,
    1.06886174e+00, 9.98597151e-01, 4.78353203e-01, 1.27845679e+00,
    8.30226277e-01, 7.22513707e-01, 9.61645918e-01, 5.24107036e-01,
    6.98581457e-01, 1.17295383e+00, 1.24349521e+00, 8.89983529e-01,
    9.28286966e-01, 1.44062735e+00, 1.36207698e+00, 7.99071364e-01,
    5.65535441e-01, 7.50000000e-01, 5.19882078e-01, 9.51265394e-01,
    7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 5.83974254e-01},
   {0.00000000e+00, 1.31725380e+00, 1.03197349e+00, 6.01385571e-01,
    9.67471640e-01, 9.13853001e-01, 4.88459165e-01, 9.98770702e-01,
    7.40733381e-01, 1.01665478e+00, 9.95647751e-01, 6.77040993e-01,
    8.73067477e-01, 1.10674855e+00, 1.07552180e+00, 8.32948914e-01,
    8.20208528e-01, 1.36207698e+00, 1.80640078e+00, 1.06764169e+00,
    3.05841935e-01, 7.50000000e-01, 5.30232118e-01, 8.78596534e-01,
    7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 7.79516037e-01},
   {0.00000000e+00, 1.04499203e+00, 6.37811920e-01, 6.38902701e-01,
    6.11601820e-01, 6.60440693e-01, 7.66309017e-01, 7.34634729e-01,
    5.96692220e-01, 2.33821719e+00, 5.70096500e-01, 1.53178711e+00,
    1.51039751e+00, 6.68196499e-01, 7.58279920e-01, 6.49448913e-01,
    5.61449723e-01, 7.99071364e-01, 1.06764169e+00, 2.69825619e+00,
    2.36794202e-01, 7.50000000e-01, 5.65836205e-01, 6.55650683e-01,
    7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 1.77511928e+00},
   {0.00000000e+00, 2.63609841e-01, 2.96793416e-01, 1.68818010e-01,
    2.12712296e-01, 2.00637717e-01, 1.07668873e+00, 2.00363838e-01,
    5.44285116e-01, 3.02670201e-01, 4.50323287e-01, 6.46886104e-01,
    3.74941590e-01, 3.94266130e-01, 2.75343404e-01, 3.35176014e-01,
    1.65111328e+00, 5.65535441e-01, 3.05841935e-01, 2.36794202e-01,
    5.26606678e+01, 7.50000000e-01, 9.69642510e-01, 2.59266956e-01,
    7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 5.43022417e-01},
   {0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 7.50000000e-01},
   {0.00000000e+00, 4.49686798e-01, 4.85608019e-01, 1.07830459e+00,
    3.69025897e-01, 3.71943861e-01, 4.97590308e+00, 2.99613619e-01,
    9.78877039e-01, 7.99863687e-01, 3.59829368e-01, 8.14904569e-01,
    5.67675865e-01, 6.20758168e-01, 3.20901839e-01, 3.94549334e-01,
    3.78768704e-01, 5.19882078e-01, 5.30232118e-01, 5.65836205e-01,
    9.69642510e-01, 7.50000000e-01, 1.03387565e+01, 3.81794898e-01,
    7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 8.10366134e-01},
   {0.00000000e+00, 1.00010336e+00, 1.61300149e+00, 2.92598254e-01,
    1.87658077e+00, 2.13407372e+00, 3.11511613e-01, 9.19064864e-01,
    1.51243666e+00, 6.25893752e-01, 1.07322036e+00, 5.51569446e-01,
    6.92962139e-01, 1.30744195e+00, 9.56295438e-01, 2.10683180e+00,
    1.02308924e+00, 9.51265394e-01, 8.78596534e-01, 6.55650683e-01,
    2.59266956e-01, 7.50000000e-01, 3.81794898e-01, 2.12220220e+00,
    7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 5.73996058e-01},
   {0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 7.50000000e-01},
   {0.00000000e+00, 1.70000000e-01, 1.70000000e-01, 1.70000000e-01,
    1.70000000e-01, 1.70000000e-01, 1.70000000e-01, 1.70000000e-01,
    1.70000000e-01, 1.70000000e-01, 1.70000000e-01, 1.70000000e-01,
    1.70000000e-01, 1.70000000e-01, 1.70000000e-01, 1.70000000e-01,
    1.70000000e-01, 1.70000000e-01, 1.70000000e-01, 1.70000000e-01,
    1.70000000e-01, 1.70000000e-01, 1.70000000e-01, 1.70000000e-01,
    1.70000000e-01, 1.33300000e+00, 1.70000000e-01, 1.70000000e-01},
   {0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 7.50000000e-01},
   {0.00000000e+00, 7.19479599e-01, 5.02168751e-01, 3.50326241e-01,
    4.53017475e-01, 5.12682678e-01, 1.44043358e+00, 4.43694156e-01,
    6.05136779e-01, 2.07538421e+00, 5.55622697e-01, 3.27192533e+00,
    2.13016362e+00, 5.59148347e-01, 5.77523805e-01, 6.53380354e-01,
    5.39632804e-01, 5.83974254e-01, 7.79516037e-01, 1.77511928e+00,
    5.43022417e-01, 7.50000000e-01, 8.10366134e-01, 5.73996058e-01,
    7.50000000e-01, 1.70000000e-01, 7.50000000e-01, 2.91088108e+00} }

};

}