/* xalloc.c - memory allocation with error checking.
   Copyright (C) 2000, 2001, 2002, 2003 Cris van Pelt
   Copyright (C) 2003, 2004 Peter Palfrader

   $Id: xalloc.c 734 2008-09-28 16:53:26Z carsten-guest $

   Distributed under the terms of the Artistic License.
*/

#include <stdio.h>
#include <string.h>

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <deborphan.h>

#ifdef USE_XALLOC		/* xalloc can be disabled in config.h */

#include <xalloc.h>

#ifdef HAVE_ERRNO_H
#  include <errno.h>
extern int errno;
#endif

#ifdef STDC_HEADERS
#  include <stdlib.h>
#else
void *calloc();
void *malloc();
void *realloc();
void free();
#   define EXIT_FAILURE 1
#endif /* STDC_HEADERS */

inline void *
xrealloc(void *ptr, size_t size)
{
    void *t;
    if (!(t = realloc(ptr, size)))
	error(EXIT_FAILURE, errno, "xrealloc: %p", t);
    return t;
}

inline void *
xcalloc(size_t nmemb, size_t size)
{
    void *t;

    if (!(t = calloc(nmemb, size)))
	error(EXIT_FAILURE, errno, "xcalloc: %p", t);

    return t;
}

inline void *
xmalloc(size_t size)
{
    void *t;

    if (!(t = malloc(size)))
	error(EXIT_FAILURE, errno, "xmalloc: %p", t);

    return t;
}

inline char *
xstrdup(const char *s)
{
    char *t;

    if ((t = strdup(s)) == NULL)
	error(EXIT_FAILURE, errno, "xstrdup: %p", (void *)t);

    return t;
}

#endif /* USE_XALLOC */
