/*
  dbaudio.h

  structure and function definitions for interfacing with the /dev/dsp device

  Author: Bob Dean
  Copyright (c) 1999

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public Licensse as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


 */

#ifndef __DB_AUDIO_H_
#define __DB_AUDIO_H_

#include <dbchannel.h>

/*The following structure contains all the variables needed to control the 
Open Sound System device.*/

#define DBMONO   0
#define DBSTEREO 1

/* audio devices are hardcoded for now... */
#ifdef DBMIX_DEBUG
#define DEFAULT_AUDIO_DEVICE   "/dev/dsp0"
#define DEFAULT_CUE_AUDIO_DEVICE "/dev/dsp8"
#else
#define DEFAULT_AUDIO_DEVICE   "/dev/dsp"
#define DEFAULT_CUE_AUDIO_DEVICE "/dev/dsp2"
#endif

/* #ifndef DB_FRAGSIZE */
#if 0

#define DB_FRAGSIZE      9  /* 2^DB_FRAGSIZE is the size of the fragment: 2^11 = 2048 */  
#define DB_NUM_FRAGMENTS  65536 / (2^DB_FRAGSIZE)
#endif
/* #endif */

typedef struct oss_control_s
{
	/*variables for controlling the Mixer device /dev/Mixer */
	int fd_mixer;  /*file descriptors*/
	int fd_dsp;

	                       /*Soundcard.h Macro      Description  */
	int master_volume;     /*SOUND_MIXER_VOLUME  master output level*/
	int treble;            /*SOUND_MIXER_TREBLE  master treble*/
	int bass;              /*SOUND_MIXER_BASS    master bass*/
	int synth_input_volume;/*SOUND_MIXER_SYNTH   synthesizer input volume*/ 
	int PCM_volume;        /*SOUND_MIXER_PCM     Out vol for devs dsp, audio*/
	int speaker_volume;    /*SOUND_MIXER_SPEAKER Out vol for PC speakers*/
	int line_input_volume; /*SOUND_MIXER_LINE    in vol for line in*/
	int mic_input_volume;  /*SOUND_MIXER_MIC     in vol from microphone*/
	int CD_input_volume;   /*SOUND_MIXER_CD      in vol from cd audio*/
	int IMIX_volume;       /*SOUND_MIXER_IMIX    some recording thing */
	int ALTPCM_volume;     /*SOUND_MIXER_ALTPCM  out vol for alternate codec*/
	int record_level;      /*SOUND_MIXER_RECLEV  global recording level*/

	/*varibles for controlling the /dev/dsp device*/

	int sample_format;     /*format of data sent to dsp*/
	int channels;          /*0 = mono 1 = stereo*/
	int sample_rate;       /*sampling rate*/
	int fullduplex;        /* true/false */

} oss_control_struct;


/*
  Interface functions
 */
oss_control_struct * init_audio(char * dsp_path, int flags, int output_stdout, 
								int numbuffs);
void close_audio(oss_control_struct * in_ctrl);
void pause_audio(oss_control_struct * in_ctrl);
int  write_audio(oss_control_struct * in_ctrl, void* buf, int size);
int  read_audio(oss_control_struct * in_ctrl, void* buf, int size);


#endif /* __DB_AUDIO_H_ */

