#!/usr/bin/env bash
## Test for issue2275 - darcs follows symbolic links instead of properly
## ignoring them.
## When substituting a recorded file with a symbolic link, darcs becomes
## confused and associates the filename label to the content of the file
## pointed by the link.
##
## Copyright (C) 2017 Gian Piero Carrubba
##
## Permission is hereby granted, free of charge, to any person
## obtaining a copy of this software and associated documentation
## files (the "Software"), to deal in the Software without
## restriction, including without limitation the rights to use, copy,
## modify, merge, publish, distribute, sublicense, and/or sell copies
## of the Software, and to permit persons to whom the Software is
## furnished to do so, subject to the following conditions:
##
## The above copyright notice and this permission notice shall be
## included in all copies or substantial portions of the Software.
##
## THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
## EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
## MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
## NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
## BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
## ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
## CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
## SOFTWARE.

. lib                           # Load some portability helpers.
abort_windows                   # Skip test on Windows

darcs init      --repo R        # Create the test repo.
cd R

touch g                         # Change the working tree.
echo 'This line should not appear in g.' > f
darcs record -lam 'Add f and g.'

rm -f g                         # Remove g and create a link with the
ln -s f g                       # same name ponting to f

darcs diff g | not grep -F '+This line should not appear in g.'

cd ..
