{-  darcs-monitor - Darcs repository monitor
    Copyright © 2007 Antti-Juhani Kaijanaho

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
-}
module Darcs where

import Control.Monad.Trans
import System.Exit
import System.IO
import System.Process

import Config

-- runs darcs with args and returns what it outputs
invokeDarcs :: (MonadConfig m, MonadIO m) =>
               [String] -> m String
invokeDarcs args = do
  darcs <- asks confDarcsPath
  cargs <- asks confDarcsArgs
  let as' = cargs ++ args
  liftIO $ do (inh, outh, errh, ph) <-
                  runInteractiveProcess darcs as' Nothing Nothing
              hClose inh
              hSetBinaryMode outh True
              rv <- hGetContents outh
              err <- hGetContents errh
              length rv `seq` hClose outh
              length err `seq` hClose errh
              hPutStr stderr err
              ec <- waitForProcess ph
              when (ec /= ExitSuccess) $ ioError $ userError "darcs failed"
              return rv
