#include "memory"

void *Memory::malloc(size_t sz, string const &desc) {
    static int lock;
    void *ptr = ::malloc(sz);
    MemoryEntry ent = { ptr, sz, desc };
    
    mutex_lock(&lock);
    s_memlog.push_back(ent);
    mutex_unlock(&lock);
    if (s_follow) {
	mutex_lock(&cout);
	cout << "Memory::malloc(" << sz << ") -> " << ptr << ' '
	     << desc << '\n';
	mutex_unlock(&cout);
    }
    return ptr;
}
