/*
 * This file is part of the UVES Pipeline
 * Copyright (C) 2002, 2003, 2004, 2005 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA
 */

/*
 * $Author: amodigli $
 * $Date: 2010-09-24 09:32:07 $
 * $Revision: 1.24 $
 * $Name: not supported by cvs2svn $
 * $Log: not supported by cvs2svn $
 * Revision 1.22  2007/08/30 14:05:19  amodigli
 * moved MAX_NAME_SIZE def to uves_globals.h
 *
 * Revision 1.21  2007/06/06 08:17:33  amodigli
 * replace tab with 4 spaces
 *
 * Revision 1.20  2007/04/24 14:09:29  jmlarsen
 * Removed obsolete log_slitwidth option to uves_qclog_add_common_wave()
 *
 * Revision 1.19  2007/04/24 12:50:29  jmlarsen
 * Replaced cpl_propertylist -> uves_propertylist which is much faster
 *
 * Revision 1.18  2007/02/26 10:16:42  jmlarsen
 * Support not logging slit width
 *
 * Revision 1.17  2007/01/29 12:11:02  jmlarsen
 * Log QC parameters (pos, fwhm, s/n) also for simple extraction
 *
 * Revision 1.16  2007/01/26 12:33:57  amodigli
 * added function for common QC
 *
 * Revision 1.15  2006/12/07 08:26:21  jmlarsen
 * Added uves_pfits_get_readspeed
 *
 * Revision 1.14  2006/12/01 12:28:18  jmlarsen
 * Added function to create QC parameter names
 *
 * Revision 1.13  2006/10/04 10:59:04  jmlarsen
 * Implemented QC.VRAD parameters
 *
 * Revision 1.12  2006/10/02 08:35:01  jmlarsen
 * const bugfix
 *
 * Revision 1.11  2006/09/19 14:32:43  jmlarsen
 * Factored out common code to compute extraction QC parameters
 *
 * Revision 1.10  2006/08/24 11:38:32  jmlarsen
 * Write QC dictionary ID to product header
 *
 * Revision 1.9  2006/07/14 12:28:02  jmlarsen
 * Added function to write common QC parameters
 *
 * Revision 1.8  2006/06/28 13:27:50  amodigli
 * Fixed problem dumping ARCFILE key changing uves_save_paf interface
 *
 * Revision 1.7  2006/06/22 08:58:33  jmlarsen
 * Use correct port number for QC
 *
 * Revision 1.6  2006/05/05 13:55:45  jmlarsen
 * Removed lone CPL_END_DECLS
 *
 */

#ifndef UVES_QCLOG_H
#define UVES_QCLOG_H

#include <uves_propertylist.h>
#include <uves_chip.h>

#include <cpl.h>

#include <stdbool.h>

#define KEY_NAME_PRO_REC1_RAW1_NAME        "ESO PRO REC1 RAW1 NAME"

#define KEY_NAME_PRO_DRSID                 "ESO PRO REC1 DRS ID"
#define PAF_NAME_PRO_DRSID                 "PRO REC1 DRS ID"
#define KEY_HELP_PRO_DRSID                 "Data Reduction System identifier"

#define KEY_NAME_PIPE_ID                   "ESO PRO REC1 PIPE ID"
#define PAF_NAME_PIPE_ID                   "PRO REC1 PIPE ID"
#define KEY_HELP_PIPE_ID                   "Pipeline (unique) identifier"
#define KEY_NAME_PIPEFILE                  "PIPEFILE"
#define KEY_HELP_PIPEFILE                  "Filename of data product"

#define KEY_NAME_QC_DID                    "ESO QC DID"
#define PAF_NAME_QC_DID                    "QC DID"
#define KEY_HELP_QC_DID                    "Data dictionary for QC"

#define KEY_NAME_PRO_TYPE                  "ESO PRO TYPE"
#define PAF_NAME_PRO_TYPE                  "PRO TYPE"
#define KEY_HELP_PRO_TYPE                  "Product Type"

#define KEY_NAME_DATE_OBS                  "DATE-OBS"
#define KEY_HELP_DATE_OBS                  "Observing date"

#define KEY_NAME_PRO_RECID                 "ESO PRO REC1 ID"
#define PAF_NAME_PRO_RECID                 "PRO REC1 ID"
#define KEY_HELP_PRO_RECID                 "Pipeline recipe(unique) identifier"

#define KEY_NAME_DPR_TYPE                  "ESO DPR TYPE"
#define KEY_NAME_DPR_CATG                  "ESO DPR CATG"
#define KEY_NAME_DPR_TECH                  "ESO DPR TECH"
#define KEY_NAME_PRO_CATG                  "ESO PRO CATG"
#define KEY_NAME_TPL_ID                    "ESO TPL ID"
#define KEY_NAME_ARCFILE                   "ARCFILE"

#define PAF_NAME_DPR_TYPE                  "DPR TYPE"
#define PAF_NAME_DPR_CATG                  "DPR CATG"
#define PAF_NAME_DPR_TECH                  "DPR TECH"
#define PAF_NAME_PRO_CATG                  "PRO CATG"
#define PAF_NAME_TPL_ID                    "TPL ID"
#define PAF_NAME_PRO_DRSID                 "PRO REC1 DRS ID"

#define KEY_HELP_DPR_TYPE                  "Observation type"
#define KEY_HELP_DPR_CATG                  "Observation category"
#define KEY_HELP_DPR_TECH                  "Observation technique"
#define KEY_HELP_PRO_CATG                  "Category of pipeline product frame"
#define KEY_HELP_TPL_ID                    "Template sig"
#define KEY_HELP_ARCFILE                   "Archive file name"
#define KEY_HELP_PRO_DRSID                 "Data Reduction System identifier"

#define PORT_ID(chip) (((chip) == UVES_CHIP_REDL) ? 4 : 1)

char * uves_get_rootname(const char * filename);
void uves_get_paf_name(const char* in, int paf_no, char** paf);

int uves_blank2dot(const char * in, char* ou);

int uves_save_paf(const char* filename, 
          int paf_no,
                  const char* rec_id,  
                  const cpl_table* qclog,
                  uves_propertylist*   plist,
                  const uves_propertylist*   rhead,
                  const char*      pro_catg);

cpl_table *
uves_qclog_init(const uves_propertylist *raw_header,
        enum uves_chip chip);
int
uves_qclog_add_int(cpl_table* table,
                 const char* name,  
                 const int   value,
                 const char* help,
         const char* format);

int
uves_qclog_add_bool(cpl_table* table,
                 const char* name,  
                 const char  value,
                 const char* help,
         const char* format);


int
uves_qclog_add_float(cpl_table* table,
                 const char* name,  
                 const float value,
                 const char* help,
         const char* format);


int
uves_qclog_add_double(cpl_table* table,
                 const char* name,  
                 const double value,
                 const char* help,
         const char* format);


int
uves_qclog_add_string(cpl_table* table,
                 const char* name,  
                 const char* value,
                 const char* help,
         const char* format);


int uves_qclog_delete(cpl_table** table);

int uves_pfits_put_qc(uves_propertylist * plist, const cpl_table * qclog);

void uves_qclog_add_sci(cpl_table *qclog,
            const uves_propertylist *raw_header,
            const cpl_image *raw_image,
            double slit,
            const cpl_table *info_tbl);

void 
uves_qclog_add_common_wave(const uves_propertylist *raw_header,
               enum uves_chip chip,
               cpl_table *qclog);

const char *
uves_qclog_get_qc_name(const char *name,
               bool flames, int trace_number);

int
uves_qclog_dump_common(const uves_propertylist *plist,
               enum uves_chip chip, 
                       cpl_table* qclog);

int
uves_qclog_dump_common_wave(const uves_propertylist *plist,
                    enum uves_chip chip, 
                            cpl_table* qclog);


#endif
