/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.Err;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.ValidationErrorValue;
import net.sf.saxon.value.Whitespace;

public final class BooleanValue
extends AtomicValue
implements Comparable {
    private boolean value;
    public static final BooleanValue TRUE = new BooleanValue(true);
    public static final BooleanValue FALSE = new BooleanValue(false);

    private BooleanValue(boolean bl) {
        this.value = bl;
    }

    public static BooleanValue get(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public static AtomicValue fromString(CharSequence charSequence) {
        int n = (charSequence = Whitespace.trimWhitespace(charSequence)).length();
        if (n == 1) {
            char c = charSequence.charAt(0);
            if (c == '1') {
                return TRUE;
            }
            if (c == '0') {
                return FALSE;
            }
        } else if (n == 4) {
            if (charSequence.charAt(0) == 't' && charSequence.charAt(1) == 'r' && charSequence.charAt(2) == 'u' && charSequence.charAt(3) == 'e') {
                return TRUE;
            }
        } else if (n == 5 && charSequence.charAt(0) == 'f' && charSequence.charAt(1) == 'a' && charSequence.charAt(2) == 'l' && charSequence.charAt(3) == 's' && charSequence.charAt(4) == 'e') {
            return FALSE;
        }
        ValidationException validationException = new ValidationException("The string " + Err.wrap(charSequence, 4) + " cannot be cast to a boolean");
        validationException.setErrorCode("FORG0001");
        return new ValidationErrorValue(validationException);
    }

    public boolean getBooleanValue() {
        return this.value;
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) {
        return this.value;
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, XPathContext xPathContext) {
        switch (builtInAtomicType.getPrimitiveType()) {
            case 88: 
            case 514: 
            case 643: {
                return this;
            }
            case 532: 
            case 646: {
                return this.value ? IntegerValue.PLUS_ONE : IntegerValue.ZERO;
            }
            case 515: {
                return this.value ? DecimalValue.ONE : DecimalValue.ZERO;
            }
            case 516: {
                return this.value ? FloatValue.ONE : FloatValue.ZERO;
            }
            case 517: {
                return this.value ? DoubleValue.ONE : DoubleValue.ZERO;
            }
            case 513: {
                return this.value ? StringValue.TRUE : StringValue.FALSE;
            }
            case 642: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
        }
        ValidationException validationException = new ValidationException("Cannot convert boolean to " + builtInAtomicType.getDisplayName());
        validationException.setErrorCode("XPTY0004");
        validationException.setIsTypeError(true);
        return new ValidationErrorValue(validationException);
    }

    public String getStringValue() {
        return this.value ? "true" : "false";
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return Type.BOOLEAN_TYPE;
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        if (clazz == Object.class) {
            return this.value;
        }
        if (clazz.isAssignableFrom(BooleanValue.class)) {
            return this;
        }
        if (clazz == Boolean.TYPE) {
            return this.value;
        }
        if (clazz == Boolean.class) {
            return this.value;
        }
        if (clazz == String.class || clazz == CharSequence.class) {
            return this.getStringValue();
        }
        if (clazz == Double.TYPE) {
            return new Double(this.value ? 1 : 0);
        }
        if (clazz == Double.class) {
            return new Double(this.value ? 1 : 0);
        }
        if (clazz == Float.TYPE) {
            return new Float(this.value ? 1 : 0);
        }
        if (clazz == Float.class) {
            return new Float(this.value ? 1 : 0);
        }
        if (clazz == Long.TYPE) {
            return new Long(this.value ? 1 : 0);
        }
        if (clazz == Long.class) {
            return new Long(this.value ? 1 : 0);
        }
        if (clazz == Integer.TYPE) {
            return new Integer(this.value ? 1 : 0);
        }
        if (clazz == Integer.class) {
            return new Integer(this.value ? 1 : 0);
        }
        if (clazz == Short.TYPE) {
            return new Short((short)(this.value ? 1 : 0));
        }
        if (clazz == Short.class) {
            return new Short((short)(this.value ? 1 : 0));
        }
        if (clazz == Byte.TYPE) {
            return new Byte((byte)(this.value ? 1 : 0));
        }
        if (clazz == Byte.class) {
            return new Byte((byte)(this.value ? 1 : 0));
        }
        if (clazz == Character.TYPE) {
            return new Character(this.value ? (char)'1' : '0');
        }
        if (clazz == Character.class) {
            return new Character(this.value ? (char)'1' : '0');
        }
        Object object = super.convertToJava(clazz, xPathContext);
        if (object == null) {
            DynamicError dynamicError = new DynamicError("Conversion of xs:boolean to " + clazz.getName() + " is not supported");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setErrorCode("SXJE0001");
            throw dynamicError;
        }
        return object;
    }

    public int compareTo(Object object) {
        if (!(object instanceof BooleanValue)) {
            throw new ClassCastException("Boolean values are not comparable to " + object.getClass());
        }
        if (this.value == ((BooleanValue)object).value) {
            return 0;
        }
        if (this.value) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object object) {
        BooleanValue booleanValue = (BooleanValue)((AtomicValue)object).getPrimitiveValue();
        return this.value == booleanValue.value;
    }

    public int hashCode() {
        return this.value ? 0 : 1;
    }

    public String toString() {
        return this.getStringValue() + "()";
    }
}

