/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.text.CollationElementIterator;
import java.text.RuleBasedCollator;
import java.util.Comparator;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.sort.StandardCollationURIResolver;
import net.sf.saxon.sort.SubstringMatcher;

public class RuleBasedSubstringMatcher
implements SubstringMatcher {
    private RuleBasedCollator collator;

    public RuleBasedSubstringMatcher(RuleBasedCollator ruleBasedCollator) {
        this.collator = ruleBasedCollator;
    }

    public boolean comparesEqual(String string, String string2) {
        return this.compare(string, string2) == 0;
    }

    public boolean contains(String string, String string2) {
        CollationElementIterator collationElementIterator = this.collator.getCollationElementIterator(string);
        CollationElementIterator collationElementIterator2 = this.collator.getCollationElementIterator(string2);
        return this.collationContains(collationElementIterator, collationElementIterator2, null, false);
    }

    public boolean endsWith(String string, String string2) {
        CollationElementIterator collationElementIterator = this.collator.getCollationElementIterator(string);
        CollationElementIterator collationElementIterator2 = this.collator.getCollationElementIterator(string2);
        return this.collationContains(collationElementIterator, collationElementIterator2, null, true);
    }

    public boolean startsWith(String string, String string2) {
        CollationElementIterator collationElementIterator = this.collator.getCollationElementIterator(string);
        CollationElementIterator collationElementIterator2 = this.collator.getCollationElementIterator(string2);
        return this.collationStartsWith(collationElementIterator, collationElementIterator2);
    }

    public String substringAfter(String string, String string2) {
        int[] nArray;
        CollationElementIterator collationElementIterator;
        CollationElementIterator collationElementIterator2 = this.collator.getCollationElementIterator(string);
        boolean bl = this.collationContains(collationElementIterator2, collationElementIterator = this.collator.getCollationElementIterator(string2), nArray = new int[2], false);
        if (bl) {
            return string.substring(nArray[1]);
        }
        return "";
    }

    public String substringBefore(String string, String string2) {
        int[] nArray;
        CollationElementIterator collationElementIterator;
        CollationElementIterator collationElementIterator2 = this.collator.getCollationElementIterator(string);
        boolean bl = this.collationContains(collationElementIterator2, collationElementIterator = this.collator.getCollationElementIterator(string2), nArray = new int[2], false);
        if (bl) {
            return string.substring(0, nArray[0]);
        }
        return "";
    }

    public int compare(Object object, Object object2) {
        return this.collator.compare(object, object2);
    }

    private boolean collationStartsWith(CollationElementIterator collationElementIterator, CollationElementIterator collationElementIterator2) {
        while (true) {
            int n;
            int n2;
            if ((n2 = collationElementIterator2.next()) == 0) {
                continue;
            }
            if (n2 == -1) {
                return true;
            }
            while ((n = collationElementIterator.next()) == 0) {
            }
            if (n != n2) break;
        }
        return false;
    }

    private boolean collationContains(CollationElementIterator collationElementIterator, CollationElementIterator collationElementIterator2, int[] nArray, boolean bl) {
        int n;
        while ((n = collationElementIterator2.next()) == 0) {
        }
        if (n == -1) {
            return true;
        }
        int n2 = -1;
        while (true) {
            if (n2 != n) {
                while ((n2 = collationElementIterator.next()) == 0) {
                }
                if (n2 != -1) continue;
                return false;
            }
            int n3 = collationElementIterator.getOffset();
            if (this.collationStartsWith(collationElementIterator, collationElementIterator2)) {
                if (bl) {
                    while ((n2 = collationElementIterator.next()) == 0) {
                    }
                    if (n2 == -1) {
                        return true;
                    }
                } else {
                    if (nArray != null) {
                        nArray[0] = n3 - 1;
                        nArray[1] = collationElementIterator.getOffset();
                    }
                    return true;
                }
            }
            collationElementIterator.setOffset(n3);
            if (collationElementIterator.getOffset() != n3) {
                collationElementIterator.next();
            }
            collationElementIterator2.reset();
            n2 = -1;
            while ((n = collationElementIterator2.next()) == 0) {
            }
        }
    }

    public static void main(String[] stringArray) {
        Configuration configuration = new Configuration();
        Comparator comparator = StandardCollationURIResolver.getInstance().resolve(stringArray[0], stringArray[0], configuration);
        FastStringBuffer fastStringBuffer = new FastStringBuffer(100);
        if (comparator instanceof RuleBasedCollator) {
            int n;
            CollationElementIterator collationElementIterator = ((RuleBasedCollator)comparator).getCollationElementIterator(stringArray[1]);
            while ((n = collationElementIterator.next()) != -1) {
                fastStringBuffer.append(n + " ");
            }
            System.err.println(fastStringBuffer.toString());
        }
    }
}

