/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.UserFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;

public final class TailCallLoop
extends UnaryExpression {
    UserFunction containingFunction;

    public TailCallLoop(UserFunction userFunction) {
        super(userFunction.getBody());
        this.containingFunction = userFunction;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.operand = this.operand.simplify(staticContext);
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand = this.operand.typeCheck(staticContext, itemType);
        return this;
    }

    public int getImplementationMethod() {
        return this.operand.getImplementationMethod();
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        UserFunction userFunction;
        XPathContextMajor xPathContextMajor = (XPathContextMajor)xPathContext;
        do {
            SequenceIterator sequenceIterator = this.operand.iterate(xPathContextMajor);
            ValueRepresentation valueRepresentation = SequenceExtent.makeSequenceExtent(sequenceIterator);
            userFunction = xPathContextMajor.getTailCallFunction();
            if (userFunction != null) continue;
            return Value.asIterator(valueRepresentation, xPathContextMajor);
        } while (userFunction == this.containingFunction);
        return Value.asIterator(this.tailCallDifferentFunction(userFunction, xPathContextMajor), xPathContextMajor);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        UserFunction userFunction;
        XPathContextMajor xPathContextMajor = (XPathContextMajor)xPathContext;
        do {
            Item item = this.operand.evaluateItem(xPathContext);
            userFunction = xPathContextMajor.getTailCallFunction();
            if (userFunction != null) continue;
            return item;
        } while (userFunction == this.containingFunction);
        return Value.asItem(this.tailCallDifferentFunction(userFunction, xPathContextMajor));
    }

    public void process(XPathContext xPathContext) throws XPathException {
        UserFunction userFunction;
        XPathContextMajor xPathContextMajor = (XPathContextMajor)xPathContext;
        do {
            this.operand.process(xPathContext);
            userFunction = xPathContextMajor.getTailCallFunction();
            if (userFunction != null) continue;
            return;
        } while (userFunction == this.containingFunction);
        Value.asValue(this.tailCallDifferentFunction(userFunction, xPathContextMajor)).process(xPathContextMajor);
    }

    private ValueRepresentation tailCallDifferentFunction(UserFunction userFunction, XPathContextMajor xPathContextMajor) throws XPathException {
        xPathContextMajor.resetStackFrameMap(userFunction.getStackFrameMap(), userFunction.getNumberOfArguments());
        try {
            return ExpressionTool.evaluate(userFunction.getBody(), userFunction.getEvaluationMode(), xPathContextMajor, 1);
        }
        catch (XPathException xPathException) {
            if (xPathException.getLocator() == null) {
                xPathException.setLocator(userFunction);
            }
            throw xPathException;
        }
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return this.operand.getItemType(typeHierarchy);
    }

    protected String displayOperator(Configuration configuration) {
        return "tail-recursive loop";
    }
}

