function CaptureAudioOptions(override) {
    this.limit = 1;
    this.duration = -1;
    this.mode = "audio/amr";
    if (typeof(override) === 'object') {
        //TODO: throw exception
        if (typeof(override.limit) == typeof(this.limit) && override.limit >= 1)
            this.limit = override.limit;
        if (typeof(override.mode) == typeof(this.mode) && navigator.device.capture.supportedAudioModes.indexOf(override.mode) !== -1)
            this.mode = override.mode;
    }
}

function CaptureImageOptions(override) {
    this.limit = 1;
    this.mode = "image/jpeg";
    if (typeof(override) === 'object') {
        //TODO: throw exception
        if (typeof(override.limit) == typeof(this.limit) && override.limit >= 1)
            this.limit = override.limit;
        if (typeof(override.mode) == typeof(this.mode) && navigator.device.capture.supportedImageModes.indexOf(override.mode) !== -1)
            this.mode = override.mode;
    }
}

function CaptureVideoOptions(override) {
    this.limit = 1;
    this.duration = -1;
    this.mode = "video/3gpp";
    if (typeof(override) === 'object') {
        //TODO: throw exception
        if (typeof(override.limit) == typeof(this.limit) && override.limit != 0)
            this.limit = override.limit;
        if (typeof(override.mode) == typeof(this.mode) && override.mode in navigator.device.capture.supportedVideoModes)
            this.mode = override.mode;
    }
}

function CaptureError(code) {
    if (code) {
        this.code = code;
    } else {
        this.code = CaptureError.CAPTURE_INTERNAL_ERR;
    }
}
CaptureError.CAPTURE_INTERNAL_ERR = 0;
CaptureError.CAPTURE_APPLICATION_BUSY = 1;
CaptureError.CAPTURE_INVALID_ARGUMENT = 2;
CaptureError.CAPTURE_NO_MEDIA_FILES = 3;
CaptureError.CAPTURE_NOT_SUPPORTED = 4;

function MediaFile(name, fullPath, type, lastModifiedDate, size) {
    if (name)
        this.name = name;
    else
        this.name = "";
    if (fullPath)
        this.fullPath = fullPath;
    else
        this.fullPath = "";
    if (type)
        this.type = type;
    else
        this.type = "";
    if (lastModifiedDate)
        this.lastModifiedDate = lastModifiedDate;
    else
        this.lastModifiedDate = 0;
    if (size)
        this.size = size;
    else
        this.size = 0;
    this.getFormatData = function() {}
}

function MediaFileData(codecs, bitrate, height, width, duration) {
    if (codecs)
        this.codecs = codecs;
    else
        this.codecs = "";
    if (bitrate)
        this.bitrate = bitrate;
    else
        this.bitrate = 0;
    if (this.height)
        this.height = height;
    else
        this.height = 0;
    if (this.width)
        this.width = width;
    else
        this.width = 0;
    if (this.duration)
        this.duration = duration;
    else
        this.duration = 0;
}

function Capture() {
    Cordova.deviceready.freeze();

    this.supportedAudioModes = [];
    this.supportedImageModes = [];
    this.supportedVideoModes = [];

    var self = this;
    Cordova.exec(function (audioCodecs, videoCodecs, imageFormats) {
        self.supportedAudioModes = audioCodecs;
        self.supportedVideoModes = videoCodecs;
        self.supportedImageModes = imageFormats;
        Cordova.deviceready.unfreeze();
    }, null, "com.cordova.Capture", "getSupportedFormats", []);
}

function makeCallback(captureSuccess, captureError) {
    return function (files) {
        var i = 0;
        var result = [];
        function getFileInfo() {
            var fileEntry = new FileEntry();
            if (files[i].match(/^file:\/\//))
                files[i] = files[i].substr('file://'.length);
            fileEntry.fullPath = files[i];

            fileEntry.file(handleFile, function() {
                captureError(new CaptureError());
            });
        }

        function handleFile(file) {
            result.push(new MediaFile(file.name, file.fullPath, file.type, file.lastModifiedDate, file.size));
            if (files.length <= ++i) {
                captureSuccess(result);
            } else {
                getFileInfo();
            }
        }
        getFileInfo();
    };
}

Capture.prototype = {
    captureAudio: function(captureSuccess, captureError, options) {
        if (typeof(captureError) != 'function')
            captureError = new Function();
        options = new CaptureAudioOptions(options);
        Cordova.exec(makeCallback(captureSuccess, captureError), function (msg) {
            if (msg === 'canceled') {
                captureError(new CaptureError(CaptureError.CAPTURE_NO_MEDIA_FILES));
            } else {
                captureError(new CaptureError(CaptureError.CAPTURE_APPLICATION_BUSY));
            }
        }, "com.cordova.Capture", "startAudioRecordApp", [ options ]);
    },

    captureImage: function(captureSuccess, captureError, options) {
        if (typeof(captureSuccess) != 'function')
            return;
        if (typeof(captureError) != 'function')
            captureError = new Function();
        options = new CaptureImageOptions(options);
        var cameraOptions = { quality: 75,
                              sourceType: Camera.PictureSourceType.CAMERA,
                              destinationType: Camera.DestinationType.FILE_URI,
                              allowEdit: true,
                              captureAPI: true,
                              encodingType: Camera.EncodingType.JPEG,//FIXME should be options.mode
                              limit: options.limit };
        Cordova.exec(makeCallback(captureSuccess, captureError), function (msg) {
            if (msg === 'canceled') {
                captureError(new CaptureError(CaptureError.CAPTURE_NO_MEDIA_FILES));
            } else {
                captureError(new CaptureError(CaptureError.CAPTURE_APPLICATION_BUSY));
            }
        }, "com.cordova.Camera", "getPicture", [ cameraOptions ]);
    },

    captureVideo: function(captureSuccess, captureError, options) {
        if (typeof(captureSuccess) != 'function')
            return;
        if (typeof(captureError) != 'function')
            captureError = new Function();

        options = new CaptureImageOptions(options);
        Cordova.exec(function(files) {
            console.log(String(files));
        }, function (msg) {
            if (msg === 'canceled') {
                captureError(new CaptureError(CaptureError.CAPTURE_NO_MEDIA_FILES));
            } else {
                captureError(new CaptureError(CaptureError.CAPTURE_APPLICATION_BUSY));
            }
        }, "com.cordova.Camera", "recordVideo", [ options ]);
    }
};

Cordova.addConstructor("com.cordova.Capture", function () {
    if (!window.navigator.device) {
        window.navigator.device = {};
    }

    window.navigator.device.capture = new Capture();
    window.MediaFile = MediaFile;
    window.CaptureError = CaptureError;
    window.MediaFileData = MediaFileData;
    window.MediaFile = MediaFile;
    window.CaptureAudioOptions = CaptureAudioOptions;
    window.CaptureImageOptions = CaptureImageOptions;
    window.CaptureVideoOptions = CaptureVideoOptions;
});
