import QtQuick 2.0
import CordovaUbuntu 2.8

Item {
    id: root
    property string wwwDir

    Cordova {
        id: cordova
        wwwDir: root.wwwDir
    }
    Image {
        id: splashscreen
        anchors.fill: parent
    }
    Loader {
        id: loader
        asynchronous: true
        visible: false
        anchors.fill: parent
        onLoaded: {
            cordova.parent = loader.item
            loader.item.completed.connect(function(){
                loader.item.visible = true
                loader.visible = true
                splashscreen.visible = false
            });
        }
    }
    Component.onCompleted: {
        splashscreen.source = cordova.getSplashscreenPath(cordova, root.wwwDir)
        loader.source = "CordovaViewInternal.qml"
    }
}
