/* display_list.h
 *
 * By Byron C. Darrah
 * 4/28/94, Thursday
 *
 * This module is for actually drawing a prepared list of polygons into a
 * window on a screen.
 *
 * Here is a brief description of the exported display_list functions:
 *
 * o  void disp_init(int *argc, char *argv[], int color);
 *
 *    Initializes a display: Creates a window, allocates display memory, etc.
 *    ie: Does whatever is necessary to get ready to start displaying
 *    lists of polygons.  If color is zero, monochrome operation will
 *    be enabled.  Otherwise, color mode is used.
 *
 * o  void disp_end(void);
 *
 *    Destroys the display, frees resources, etc.  This is called when no more
 *    rendering is to be performed.
 *
 * o  void disp_polygons(polygon_node_t *pnodes);
 *
 *    Draws polygons.  pnodes is a list of polygons.  The polygons are
 *    displayed from first to last, until a polygon key value of 0.0 is
 *    encountered.  This allows render1 to use the painter's algorithm of
 *    hidden line removal.  ie: Before disp_polygons is called, the polygon
 *    list is sorted so that farther-away polygons are closer to the head of
 *    the list. 
 *
 * o  void disp_sync(void);
 *
 *    Pauses execution until graphics processing requests have completed.
 *
 * o  void disp_freeze(void);
 *
 *    Pauses the display, so that it may be examined at length by the user.
 *    At the moment, this is for debugging purposes, and is not guranteed to
 *    ever return.
 *
 * o  void disp_setsize(unsigned short width, unsigned short height);
 *
 *    Change the scale of the image.  This involves updating some global
 *    variables and reallocating some image memory.  This does not
 *    automatically change the window size, but does change how display
 *    operations behave.
 *
 * o  void disp_getsize(unsigned short *width, unsigned short *height);
 *
 *    Queries the size of the output window, and returns it's dimentions
 *    in the output parameters width and height.
 */

#include "render1.h"

#ifdef DISPLAY_LIST_MODULE
#define DISP_EXTERN
#else
#define DISP_EXTERN extern
#endif

/* Define the display size.  (This is non-adjustable at runtime, for now) */
DISP_EXTERN unsigned short Gfx_Width;
DISP_EXTERN unsigned short Gfx_Height;

/* Define the "origin" offset: ie: we want (0,0) to translate to (52, 40),
 * which is the middle of the display.
 */
DISP_EXTERN unsigned short Gfx_X_Origin;
DISP_EXTERN unsigned short Gfx_Y_Origin;

/* The display_list module will set "recommended" scaling factors */
DISP_EXTERN float disp_x_scale;
DISP_EXTERN float disp_y_scale;

/* Here is the structure for the nodes of the aggregate polygon list */
typedef struct aggregate_pgn_struct
{
   struct aggregate_pgn_struct *next;
   struct aggregate_pgn_struct *prev;
   polygon_t                   *polygon;
   float                        k;      /* Sort-key for the aggregate list */
} polygon_node_t;

/* These four functions are exported to the renderer. */
void disp_init(int *argc, char *argv[], int color);
void disp_end(void);
void disp_polygons(polygon_node_t *pnodes);
void disp_sync(void);
int  disp_freeze(unsigned long interval);
void disp_bell(void);
void disp_setsize(unsigned short width, unsigned short height);
void disp_getsize(unsigned short *width, unsigned short *height);
