// Copyright (c) 2023, ETH Zurich and UNC Chapel Hill.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//
//     * Neither the name of ETH Zurich and UNC Chapel Hill nor the names of
//       its contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

#include "colmap/ui/license_widget.h"

namespace colmap {

LicenseWidget::LicenseWidget(QWidget* parent) : QTextEdit(parent) {
  setReadOnly(true);
  setWindowFlags(Qt::Dialog);
  resize(parent->width() - 20, parent->height() - 20);
  setWindowTitle("License");

  QString licenses;
  licenses += "<h2>COLMAP</h2>";
  licenses += GetCOLMAPLicense();
  licenses += "<h2>External</h2>";
  licenses += "<h3>LSD</h3>";
  licenses += GetLSDLicense();
  licenses += "<h3>PoissonRecon</h3>";
  licenses += GetPoissonReconLicense();
  licenses += "<h3>SiftGPU</h3>";
  licenses += GetSiftGPULicense();
  licenses += "<h3>SQLite</h3>";
  licenses += GetSQLiteLicense();
  licenses += "<h3>VLFeat</h3>";
  licenses += GetVLFeatLicense();
  setHtml(licenses);
}

QString LicenseWidget::GetCOLMAPLicense() const {
  QString license =
      "Copyright (c) 2023, ETH Zurich and UNC Chapel Hill.<br>"
      "All rights reserved.<br>"
      "<br>"
      "Redistribution and use in source and binary forms, with or without<br>"
      "modification, are permitted provided that the following conditions are "
      "met:<br>"
      "<br>"
      "    * Redistributions of source code must retain the above copyright<br>"
      "      notice, this list of conditions and the following disclaimer.<br>"
      "<br>"
      "    * Redistributions in binary form must reproduce the above "
      "copyright<br>"
      "      notice, this list of conditions and the following disclaimer in "
      "the<br>"
      "      documentation and/or other materials provided with the "
      "distribution.<br>"
      "<br>"
      "    * Neither the name of ETH Zurich and UNC Chapel Hill nor the names "
      "of<br>"
      "      its contributors may be used to endorse or promote products "
      "derived<br>"
      "      from this software without specific prior written permission.<br>"
      "<br>"
      "THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "
      "\"AS IS\"<br>"
      "AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, "
      "THE<br>"
      "IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR "
      "PURPOSE<br>"
      "ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS "
      "BE<br>"
      "LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR<br>"
      "CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF<br>"
      "SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR "
      "BUSINESS<br>"
      "INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER "
      "IN<br>"
      "CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR "
      "OTHERWISE)<br>"
      "ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF "
      "THE<br>"
      "POSSIBILITY OF SUCH DAMAGE.";
  return license;
}

QString LicenseWidget::GetLSDLicense() const {
  QString license =
      "LSD - Line Segment Detector on digital images<br>"
      "<br>"
      "This code is part of the following publication and was subject<br>"
      "to peer review:"
      "<br>"
      "  \"LSD: a Line Segment Detector\" by Rafael Grompone von Gioi,<br>"
      "  Jeremie Jakubowicz, Jean-Michel Morel, and Gregory Randall,<br>"
      "  Image Processing On Line, 2012. DOI:10.5201/ipol.2012.gjmr-lsd<br>"
      "  http://dx.doi.org/10.5201/ipol.2012.gjmr-lsd<br>"
      "<br>"
      "Copyright(c) 2007-2011 rafael grompone von gioi <grompone@gmail.com><br>"
      "<br>"
      "This program is free software: you can redistribute it and/or<br>"
      "modify it under the terms of the GNU Affero General Public License<br>"
      "as published by the Free Software Foundation, either version 3 of<br>"
      "the License, or (at your option) any later version.<br>"
      "<br>"
      "This program is distributed in the hope that it will be useful,<br>"
      "but WITHOUT ANY WARRANTY; without even the implied warranty of<br>"
      "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the<br>"
      "GNU Affero General Public License for more details.<br>"
      "<br>"
      "You should have received a copy of the GNU Affero General Public<br>"
      "License along with this program.<br>"
      "If not, see http://www.gnu.org/licenses/.";
  return license;
}

QString LicenseWidget::GetPoissonReconLicense() const {
  QString license =
      "The MIT License (MIT)<br>"
      "<br>"
      "Copyright (c) 2015 mkazhdan<br>"
      "<br>"
      "Permission is hereby granted, free of charge, to any person<br>"
      "obtaining a copy of this software and associated documentation<br>"
      "files (the \"Software\"), to deal in the Software without<br>"
      "restriction, including without limitation the rights to use, copy,<br>"
      "modify, merge, publish, distribute, sublicense, and/or sell copies<br>"
      "of the Software, and to permit persons to whom the Software is<br>"
      "furnished to do so, subject to the following conditions:<br>"
      "<br>"
      "The above copyright notice and this permission notice shall be<br>"
      "included in all copies or substantial portions of the Software.<br>"
      "<br>"
      "THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND,<br>"
      "EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF<br>"
      "MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND<br>"
      "NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS<br>"
      "BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN<br>"
      "ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN<br>"
      "CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE<br>"
      "SOFTWARE.";
  return license;
}

QString LicenseWidget::GetSiftGPULicense() const {
  QString license =
      "Copyright (c) 2007 University of North Carolina at Chapel Hill<br>"
      "All Rights Reserved<br>"
      "<br>"
      "Permission to use, copy, modify and distribute this software and its<br>"
      "documentation for educational, research and non-profit purposes,<br>"
      "without fee, and without a written agreement is hereby granted,<br>"
      "provided that the above copyright notice and the following paragraph<br>"
      "appear in all copies.<br>"
      "<br>"
      "The University of North Carolina at Chapel Hill make no<br>"
      "representations about the suitability of this software for any<br>"
      "purpose. It is provided 'as is' without express or implied warranty.";
  return license;
}

QString LicenseWidget::GetSQLiteLicense() const {
  QString license =
      "The author disclaims copyright to this source code. In place of<br>"
      "a legal notice, here is a blessing:<br>"
      "May you do good and not evil.<br>"
      "May you find forgiveness for yourself and forgive others.<br>"
      "May you share freely, never taking more than you give.";
  return license;
}

QString LicenseWidget::GetVLFeatLicense() const {
  QString license =
      "Copyright (C) 2007-11, Andrea Vedaldi and Brian Fulkerson<br>"
      "Copyright (C) 2012-13, The VLFeat Team<br>"
      "All rights reserved.<br>"
      "<br>"
      "Redistribution and use in source and binary forms, with or without<br>"
      "modification, are permitted provided that the following conditions <br>"
      "are met:<br>"
      "1. Redistributions of source code must retain the above copyright<br>"
      "   notice, this list of conditions and the following disclaimer.<br>"
      "2. Redistributions in binary form must reproduce the above copyright<br>"
      "   notice, this list of conditions and the following disclaimer in<br>"
      "   the documentation and/or other materials provided with the<br>"
      "   distribution.<br>"
      "<br>"
      "THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS<br>"
      "AS IS AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT<br>"
      "LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS<br>"
      "FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE<br>"
      "COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,<br>"
      "INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,<br>"
      "BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;<br>"
      "LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER<br>"
      "CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT<br>"
      "LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN<br>"
      "ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE<br>"
      "POSSIBILITY OF SUCH DAMAGE.";
  return license;
}

}  // namespace colmap
