/*
 * Copyright 2009 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.codenarc.rule.basic

import org.codehaus.groovy.ast.MethodNode
import org.codenarc.rule.AbstractAstVisitorRule
import org.codenarc.rule.AbstractMethodVisitor
import org.codenarc.util.AstUtil

/**
 * An empty static initializer was found. It is safe to remove it. 
 *
 * @author Hamlet D'Arcy
 */
class EmptyStaticInitializerRule extends AbstractAstVisitorRule {
    String name = 'EmptyStaticInitializer'
    int priority = 2
    Class astVisitorClass = EmptyStaticInitializerAstVisitor
}

class EmptyStaticInitializerAstVisitor extends AbstractMethodVisitor {

    @Override
    void visitMethod(MethodNode node) {
        if (node.name == '<clinit>' && AstUtil.isEmptyBlock(node.code)) {
            def emptyBlock = AstUtil.getEmptyBlock(node.code)
            if (emptyBlock) {
                addViolation(emptyBlock, "The class ${node?.declaringClass?.name} has an empty static initializer. It is safe to delete it")
            }
        }
    }
}
