// Copyright 2013 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//
// Created by postproc-cld2 4.0 on 2013-05-27 15:41:29
// From command line:
//  --cld2 --cc --just_read_raw --delta_octa
//  --wrt=cld2_generated_quad0527.bin --standard --minchars=5 --mincount=1
//  --max_items_per_langscript=3000 --flatmap --rr_alloc --freq_alloc
//  --boostcloseweakerpercent=00 --indirectbits=12 --thresh=240 --v25
//  --kentries=64 --tablename=DeltaOcta0527 --suppress=bs-Latn bs-Cyrl
//  sr-ME-Latn    az-Arab az-Cyrl kk-Latn ku-Latn my-Latn ru-Latn tg-Arab
//  tk-Arab ug-Latn za-Hani zzb-Latn zze-Latn zzh-Latn
//  --remap=xxx-Latn=>ut-Latn sh-Latn=>hr-Latn sh-Cyrl=>sr-Cyrl
//  sr-ME-Cyrl=>sr-Cyrl  --ko_english --force_to_lang_soft --nosoft_cram2
//  --nomsidlevel --shapeflatprob --langpriorpercent=10 --skipnuc
//  --noshapeforcetop --noshapeeventop --noshapesteep2 --spread=15
//  --nodoubleclose --langcounts --writebin --list_items=120
//  i18n/encodings/cld2/prob_data/vetted_octa_prob_20130527.utf8
//
// CLD2_pslangs
//
// See compact_lang_det.cc for usage
//
#include "cld2tablesummary.h"
namespace CLD2 {

static const uint32 kDeltaOcta0527BuildDate = 20130527;    // yyyymmdd


// Of 393339 offered items into 65536 table entries:
// 65536 filled (16%), 28 merged (0%), 327775 dropped (83%)

// Nil-grams: 19 languages
//     GREEK MALAYALAM TELUGU TAMIL GUJARATI THAI KANNADA PUNJABI
//     GEORGIAN SINHALESE ARMENIAN LAOTHIAN KHMER DHIVEHI CHEROKEE
//     SYRIAC LIMBU ORIYA INUKTITUT

// Uni-grams: 4 languages
//     Japanese Korean Chinese ChineseT

// Words/Quads: 142 languages in range ENGLISH..X_KLINGON:
//     ENGLISH DANISH DUTCH FINNISH FRENCH GERMAN HEBREW ITALIAN
//     NORWEGIAN POLISH PORTUGUESE RUSSIAN SPANISH SWEDISH CZECH
//     ICELANDIC LATVIAN LITHUANIAN ROMANIAN HUNGARIAN ESTONIAN
//     Unknown BULGARIAN CROATIAN SERBIAN IRISH GALICIAN TAGALOG
//     TURKISH UKRAINIAN HINDI MACEDONIAN BENGALI INDONESIAN LATIN
//     MALAY WELSH NEPALI ALBANIAN BELARUSIAN JAVANESE OCCITAN URDU
//     BIHARI ARABIC CATALAN ESPERANTO BASQUE INTERLINGUA
//     SCOTS_GAELIC SWAHILI SLOVENIAN MARATHI MALTESE VIETNAMESE
//     FRISIAN SLOVAK FAROESE SUNDANESE UZBEK AMHARIC AZERBAIJANI
//     TIGRINYA PERSIAN NORWEGIAN_N XHOSA ZULU GUARANI SESOTHO
//     TURKMEN KYRGYZ BRETON YIDDISH SOMALI UIGHUR KURDISH MONGOLIAN
//     SINDHI RHAETO_ROMANCE AFRIKAANS LUXEMBOURGISH TIBETAN ASSAMESE
//     CORSICAN INTERLINGUE KAZAKH LINGALA PASHTO QUECHUA SHONA TAJIK
//     TATAR TONGA YORUBA MAORI WOLOF ABKHAZIAN AFAR AYMARA BASHKIR
//     BISLAMA DZONGKHA FIJIAN GREENLANDIC HAUSA HAITIAN_CREOLE
//     INUPIAK KASHMIRI KINYARWANDA MALAGASY NAURU OROMO RUNDI SAMOAN
//     SANGO SANSKRIT SISWANT TSONGA TSWANA VOLAPUK ZHUANG KHASI
//     SCOTS GANDA MANX AKAN IGBO MAURITIAN_CREOLE HAWAIIAN CEBUANO
//     HMONG NYANJA PEDI SESELWA VENDA WARAY_PHILIPPINES X_PIG_LATIN
//     X_KLINGON

//  ENGLISH 404
//  DANISH 424
//  DUTCH 429
//  FINNISH 418
//  FRENCH 415
//  GERMAN 442
//  HEBREW 400
//  ITALIAN 426
//  Japanese 421
//  Korean 433
//  NORWEGIAN 832
//  POLISH 421
//  PORTUGUESE 428
//  RUSSIAN 431
//  SPANISH 431
//  SWEDISH 414
//  Chinese 425
//  CZECH 831
//  ICELANDIC 419
//  LATVIAN 427
//  LITHUANIAN 450
//  ROMANIAN 788
//  HUNGARIAN 436
//  ESTONIAN 419
//  Unknown 656
//  BULGARIAN 431
//  CROATIAN 810
//  SERBIAN 1038
//  IRISH 424
//  GALICIAN 423
//  TAGALOG 437
//  TURKISH 412
//  UKRAINIAN 427
//  HINDI 708
//  MACEDONIAN 428
//  BENGALI 421
//  INDONESIAN 833
//  LATIN 414
//  MALAY 589
//  WELSH 431
//  NEPALI 441
//  ALBANIAN 413
//  BELARUSIAN 420
//  JAVANESE 423
//  OCCITAN 439
//  URDU 419
//  BIHARI 499
//  ARABIC 427
//  CATALAN 428
//  ESPERANTO 419
//  BASQUE 427
//  INTERLINGUA 433
//  SCOTS_GAELIC 429
//  SWAHILI 430
//  SLOVENIAN 428
//  MARATHI 431
//  MALTESE 409
//  VIETNAMESE 269
//  FRISIAN 429
//  SLOVAK 542
//  ChineseT 487
//  FAROESE 420
//  SUNDANESE 441
//  UZBEK 1188
//  AMHARIC 433
//  AZERBAIJANI 415
//  TIGRINYA 446
//  PERSIAN 415
//  NORWEGIAN_N 555
//  XHOSA 842
//  ZULU 536
//  GUARANI 414
//  SESOTHO 434
//  TURKMEN 843
//  KYRGYZ 848
//  BRETON 411
//  YIDDISH 442
//  SOMALI 420
//  UIGHUR 846
//  KURDISH 439
//  MONGOLIAN 416
//  SINDHI 410
//  RHAETO_ROMANCE 406
//  AFRIKAANS 421
//  LUXEMBOURGISH 428
//  TIBETAN 34
//  ASSAMESE 77
//  CORSICAN 426
//  INTERLINGUE 419
//  KAZAKH 866
//  LINGALA 433
//  PASHTO 420
//  QUECHUA 437
//  SHONA 429
//  TAJIK 399
//  TATAR 831
//  TONGA 434
//  YORUBA 434
//  MAORI 431
//  WOLOF 419
//  ABKHAZIAN 408
//  AFAR 409
//  AYMARA 411
//  BASHKIR 427
//  BISLAMA 419
//  DZONGKHA 7
//  FIJIAN 428
//  GREENLANDIC 411
//  HAUSA 423
//  HAITIAN_CREOLE 418
//  INUPIAK 317
//  KASHMIRI 247
//  KINYARWANDA 829
//  MALAGASY 403
//  NAURU 390
//  OROMO 426
//  RUNDI 581
//  SAMOAN 426
//  SANGO 253
//  SANSKRIT 839
//  SISWANT 415
//  TSONGA 406
//  TSWANA 432
//  VOLAPUK 419
//  ZHUANG 187
//  KHASI 379
//  SCOTS 444
//  GANDA 418
//  MANX 425
//  AKAN 372
//  IGBO 416
//  MAURITIAN_CREOLE 439
//  HAWAIIAN 434
//  CEBUANO 430
//  HMONG 246
//  NYANJA 419
//  PEDI 254
//  SESELWA 415
//  VENDA 269
//  WARAY_PHILIPPINES 417
//  X_PIG_LATIN 406
//  X_KLINGON 404



// Recognized language-script combinations [155]:
static const char* const kDeltaOcta0527RecognizedLangScripts =
  "aa-Latn ab-Cyrl af-Latn ak-Latn am-Ethi ar-Arab as-Beng ay-Latn "
  "az-Latn ba-Cyrl be-Cyrl bg-Cyrl bh-Deva bi-Latn blu-Latn bn-Beng "
  "bo-Tibt br-Latn ca-Latn ceb-Latn co-Latn crs-Latn cs-Latn cy-Latn "
  "da-Latn de-Latn dz-Tibt en-Latn eo-Latn es-Latn et-Latn eu-Latn "
  "fa-Arab fi-Latn fj-Latn fo-Latn fr-Latn fy-Latn ga-Latn gd-Latn "
  "gl-Latn gn-Latn gv-Latn ha-Latn haw-Latn hi-Deva hr-Latn ht-Latn "
  "hu-Latn ia-Latn id-Latn ie-Latn ig-Latn ik-Latn is-Latn it-Latn "
  "iw-Hebr ja-Hani jw-Latn kha-Latn kk-Arab kk-Cyrl kl-Latn ko-Hani "
  "ks-Arab ks-Deva ku-Arab ky-Arab ky-Cyrl la-Latn lb-Latn lg-Latn "
  "ln-Latn lt-Latn lv-Latn mfe-Latn mg-Latn mi-Latn mk-Cyrl mn-Cyrl "
  "mr-Deva ms-Latn mt-Latn na-Latn ne-Deva nl-Latn nn-Latn no-Latn "
  "nso-Latn ny-Latn oc-Latn om-Latn pl-Latn ps-Arab pt-Latn qu-Latn "
  "rm-Latn rn-Latn ro-Cyrl ro-Latn ru-Cyrl rw-Latn sa-Deva sa-Latn "
  "sco-Latn sd-Arab sg-Latn sk-Latn sl-Latn sm-Latn sn-Latn so-Latn "
  "sq-Latn sr-Cyrl sr-Latn ss-Latn st-Latn su-Latn sv-Latn sw-Latn "
  "tg-Cyrl ti-Ethi tk-Cyrl tk-Latn tl-Latn tlh-Latn tn-Latn to-Latn "
  "tr-Latn ts-Latn tt-Cyrl tt-Latn ug-Arab ug-Cyrl uk-Cyrl un-Cyrl "
  "un-Latn ur-Arab uz-Arab uz-Cyrl uz-Latn ve-Latn vi-Latn vo-Latn "
  "war-Latn wo-Latn xh-Latn yi-Hebr yo-Latn za-Latn zh-Hani zh-Hant-Hani "
  "zh-Hant-Latn zu-Latn zzp-Latn ";

static const uint32 kDeltaOcta0527Size = 16384;    // Bucket count
static const uint32 kDeltaOcta0527KeyMask = 0xfffff000;    // Mask hash key

static const IndirectProbBucket4 kDeltaOcta0527[kDeltaOcta0527Size] = {
  // hash_indirect[4], tokens[4] in UTF-8
   {{0x92901002,0xe6dc0003,0x72fd0004,0xe3eb4005}},	// [000] _vihar_, _नामित_, _ngagem_, _vietoj_,
   {{0xd2497006,0x53831007,0xaf49e008,0x8a02c009}},	//   _mwambo_, _ennyire_, _вазифеле, _уничтоже,
   {{0x3a4ba00a,0x827f700b,0x0757500c,0x6282c00d}},	//   _בלילה_, _maanna_, _malilieg, _alkanadi_,
   {{0x627ef00e,0x8c67200f,0xd2d8d010,0xaeb6e011}},	//   _ikinci_, _meltzer_, _frees_, _acerrife_,
   {{0xb4013012,0x06037013,0xc2d8d014,0xf2efc015}},	//   _آئنده_, _villarri, _treet_, _allinta_,
   {{0x7e716016,0x83eb9017,0xe290c018,0x72d47019}},	//   _karaoké_, _nesta_, _galati_, _perdis_,
   {{0xc319c012,0x616d501a,0x025d901b,0x6cc0101c}},	//   _حيران_, _массалык_, _dostlukl, _شیرافگن_,
   {{0xf386d01d,0x527f401e,0x2290301f,0x61d7d020}},	//   _scorch_, _ahenni_, _nijar_, _ailednay_,
   {{0x728e1021,0x30d72022,0x5e38c023,0x6f67e024}},	//   _moskeen_, _субъектi, _ankacisa, _स्वच्छन्,
   {{0x72487025,0x2d5dc026,0x35ad8027,0x5a161028}},	//   _sanma_, _북마크하기_, _cooperaz, _propagid,
   {{0x02cb8008,0xac75f029,0x03cf1022,0x0c78d02a}},	//   _berdi_, _syariah_, _бәйтерек_, _actuary_,
   {{0x3386e02b,0x01c5c02c,0x63eb902d,0xaaf5e018}},	//   _shirka_, _सामथ्र्य_, _lesta_, _crestere,
   {{0xbc67202e,0xfb19202f,0x23f9f030,0x7b1a8031}},	//   _другие_, _riparian_, _butun_, _የማንነት_,
   {{0xf774f032,0xe2b57033,0x4ead4034,0x727ed035}},	//   _virkileg, _atache_, _corriere_, _ikonai_,
   {{0xf1c92036,0x69083037,0x6e059038,0x12646039}},	//   _доста_, _чөнки_, _kendaraa, _batlot_,
   {{0xeb35b03a,0x8202703b,0xc3f9203c,0x4e37403d}},	//   _agrandis, _insita_, _sicuri_, _اولادونه_,
   {{0x1291803e,0x9d7f903f,0xcd544040,0x0e5d5041}},	// [010] _miran_, _सिद्धांत, _biyatlhq, _تجهيزاتو_,
   {{0xb3029042,0x6a13c043,0xf386e044,0x226d8045}},	//   _akubute_, _podcaste, _ahiria_, _abanonyi_,
   {{0xd3eb9046,0xa2fc9047,0xe2ded048,0x83263049}},	//   _desta_, _amagi_, _takovou_, _iniciou_,
   {{0xc2f5404a,0x9eea104b,0x6305304c,0x5290104d}},	//   _stunner_, _йилларид, _توتال_, _abhag_,
   {{0x32da904e,0xba53b04f,0x4ff06050,0xada29051}},	//   _amplify_, _menerima_, _床前明月光_, _betrayed_,
   {{0xd9171009,0x6ccee052,0x5867d053,0x9932100a}},	//   _нашего_, _latvener, _kündigun, _dismisse,
   {{0xf2918054,0x47b83055,0x32254056,0xf5f59057}},	//   _kiran_, _abbracci, _thekgo_, _единтеле_,
   {{0xf3dca058,0x7689d059,0xe2918059,0xac347034}},	//   _imbwa_, _በቅርቡም_, _jiran_, _sudafric,
   {{0x43eb9032,0x92cb0045,0x8290a040,0x9c10305a}},	//   _besti_, _abaddu_, _bibah_, _exagerac,
   {{0x2de9505b,0xc3eb905c,0x9291805d,0xf290e05e}},	//   _داستانون, _jesti_, _eiran_, _fanaui_,
   {{0xa200805f,0x2fdda022,0x12ebc060,0xa189c061}},	//   _hikina_, _назарына_, _brinker_, _نقاطي_,
   {{0xa26e0062,0xcd971063,0xe268604b,0xa2485064}},	//   _popole_, _salohiya, _ittifoqi_, _calme_,
   {{0x71809065,0x45acc030,0x5f65200f,0x2c5d2066}},	//   _הנישואין_, _уламо_, _становищ, _listado_,
   {{0x73ea6067,0x4f77a068,0x0200e069,0x7f51b06a}},	//   _ngota_, _mencadan, _runini_, _डांगे_,
   {{0x6394e003,0x5a49706b,0xe254e06c,0x99c3306d}},	//   _naised_, _feleunga_, _arvestam, _ahambela_,
   {{0xeb74906e,0x837af06f,0x7aa3f01f,0x70ed0047}},	//   _beasiswa_, _semanal_, _hankulan_, _abanunul,
   {{0x99ee1070,0xd3877071,0x316e6072,0xc9a18073}},	// [020] _borgmest, _hearde_, _половино, _krištof_,
   {{0xa2905074,0x53eb9075,0x82905076,0xe2c64077}},	//   _cilat_, _cesti_, _pilau_, _abalaye_,
   {{0x9c003078,0x5224e079,0xfc14f07a,0x32f0707b}},	//   _chostas_, _danket_, _dursley_, _asiiyyi_,
   {{0xdaffb07c,0x2290c07d,0x3eac107e,0x2fcc507f}},	//   _kunganab, _andap_, _aktuellt_, _aníke_,
   {{0x03f83080,0xf27f7081,0x3ad0d082,0x72b40083}},	//   _jujuy_, _taanna_, _amstelve, _clica_,
   {{0xf30ac084,0xfb0d0085,0xfe9ba086,0x9ec1f087}},	//   _abanidij, _কূটনৈতিক_, _alterius_, _gjenstan,
   {{0xa26fb088,0x32cac089,0x0dc3a065,0xedb0208a}},	//   _mengalam, _redds_, _מרוקו_, _akhatywe_,
   {{0x8292508b,0x12d8d08c,0xc224908d,0x63ea900c}},	//   _setali_, _breek_, _avaku_, _afatu_,
   {{0x12ec608e,0xc317908f,0xe25a0090,0x52d9200d}},	//   _cingleix_, _weinidog_, _arile_, _asyee_,
   {{0xf25a0091,0xef12e092,0x1792e092,0xd2901093}},	//   _brile_, _tautukta, _tautukti, _wahai_,
   {{0x3daa0094,0xd2b4d095,0x9278f096,0x79e2a097}},	//   _argitara, _brocht_, _مواخذہ_, _golfbane,
   {{0x6a6cc098,0xc2fe1099,0x8250209a,0xe40b7084}},	//   _abaminis, _odznaky_, _يىگەن_, _akakọgbọ,
   {{0x6789d09b,0xfe4c309c,0xd3877071,0x5a17701f}},	//   _bailidön_, _magaalaa, _wearde_, _kazalika_,
   {{0xc3f9f09d,0x2c7af09e,0x9a04609f,0x7202c0a0}},	//   _mutum_, _glasnik_, _bakatefe, _abazilil,
   {{0x12b570a1,0x73ead089,0xcb21c046,0xb3f250a2}},	//   _stacie_, _beets_, _cumprime, _abazame_,
   {{0x839470a3,0x620080a4,0xa29050a5,0x8290507d}},	//   _mense_, _tikina_, _silat_, _bilas_,
   {{0x16d2d0a6,0xbc6ac0a7,0x8d30c0a8,0xf2f180a9}},	// [030] _स्विच_, _nadzvučn, _vlastnic, _tarinki_,
   {{0xd38770aa,0xa39670ab,0xcc44008a,0xdf1c90ac}},	//   _akarya_, _kurset_, _abawela_, _verdwijn,
   {{0x2b61e0ad,0xfd78c07f,0xd2cbe07d,0x4b8d20ae}},	//   _regluger, _андреи_, _betde_, _istismar,
   {{0x6a14c05b,0xef1f20af,0xa290501f,0x320100b0}},	//   _دبليو_, _お気に入りに登録, _tilas_, _tebing_,
   {{0xa28c30b1,0xb977a0b2,0x9113e0b3,0xa2da60b4}},	//   _dagaalam, _kojiblee, _jurnalın, _herema_,
   {{0xca8d5008,0xe85cc0a0,0x79cee0b5,0x520110b6}},	//   _батырлык_, _بارانونو_, _بالاڭنىڭ_, _encima_,
   {{0xb3eb90b7,0xd238a0b8,0xc4bb0031,0x7eae00b9}},	//   _mestu_, _органлар, _የምስረታ_, _milletin,
   {{0xf2d990ba,0xb25d00bb,0x326cc0bc,0xf2d8d0bd}},	//   _museu_, _учасникі, _ailoye_, _preek_,
   {{0xe3f8d00e,0x07b9e0be,0x1f3560bf,0xe290500e}},	//   _budur_, _komuniki, _kitoblar_, _xilas_,
   {{0xc29050c0,0x8da3a009,0xc3ea00c1,0xd580c0c2}},	//   _vilas_, _ходить_, _ngiti_, _инеме_,
   {{0x307af0c3,0xac05e0be,0x73ea00c4,0x67b4f0c5}},	//   _besplatn, _perseri_, _igiti_, _akarindi,
   {{0x62eed0c6,0x3291e0c7,0x2b2880c8,0x588880c9}},	//   _abefi_, _intaa_, _факультэ, _тексту_,
   {{0x8f3ab0ca,0x5d29f083,0x03f8d0cb,0x95d07060}},	//   _alaukika, _respondr, _tudur_, _baratily,
   {{0x0e6690cc,0xa13600cd,0x1e8fc0ce,0x5b1fd0cf}},	//   _সম্পাদকী, _middelal, _دماغی_, _kalayaan_,
   {{0x56ae20d0,0xb9c330d1,0xf0b8d0d2,0x8c04c0d3}},	//   _ilitariy, _akambela_, _асман_, _presidi_,
   {{0x62da60d4,0x520200d5,0x57ec20d6,0xe2b2d0d7}},	//   _gereja_, _impilo_, _устанавл, _авазы_,
   {{0xd25ad00c,0x825a00d8,0x727f40d9,0xd26e00da}},	// [040] _atele_, _buill_, _abenga_, _nipote_,
   {{0xf3ea90db,0xa2901076,0x5394e0dc,0x825ac0dd}},	//   _ngata_, _hahau_, _penses_, _kallie_,
   {{0x33b640a7,0x8eca80de,0xad28c0df,0x503170ac}},	//   _ludviga_, _пикетчил, _esistanc, _aanteken,
   {{0xe29010e0,0xdc01f0bb,0x329180e1,0x73f960e2}},	//   _mahat_, _kostnads, _airal_, _liguri_,
   {{0xd29010e3,0xb291e02e,0xb29260e4,0x37b760cf}},	//   _lahat_, _antaa_, _abraam_, _tagubili,
   {{0x1e6f90e5,0xa50160e6,0xd2d970e7,0x67cee0e8}},	//   _व्यक्तिय, _materjal_, _ndaelo_, _भूमिकाएं_,
   {{0x161970e9,0xe2d990ea,0xf291104e,0x834460eb}},	//   _ganaderí, _muset_, _mabati_, _ascende_,
   {{0x9396d0ec,0x33ac70e4,0x7cdeb0ed,0x7063b0ee}},	//   _strategj, _soupir_, _elikhulu_, _podstatn,
   {{0x729080ef,0xc2b570f0,0x42d920f1,0x3682e0f2}},	//   _bahati_, _chacun_, _bryet_, _श्राप_,
   {{0xd68820bb,0x53eb90f3,0xfa0600f4,0xa40ae041}},	//   _контролю_, _gestu_, _چاقناپ_, _قاچاقبرا,
   {{0x49d030bf,0xa23160d1,0x127ef0f5,0xf29620f6}},	//   _секин_, _ahumesa_, _seinem_, _теорияны_,
   {{0x425b704b,0x3d3d9065,0x4d55f0f7,0xd929a0f8}},	//   _ingliz_, _אשתקד_, _中国人民政治协商, _яраланга,
   {{0x03eb90f9,0x632460fa,0x0e6f90fb,0x4c5740fc}},	//   _bestu_, _oficiri_, _व्यक्ताय, _hostele_,
   {{0x9291c0fd,0x2237c0fe,0x02d860ff,0x62fce100}},	//   _anvan_, _ngombwa_, _groep_, _bangko_,
   {{0xb26c2101,0xa2b4f095,0x8fcd4102,0xa1a9a103}},	//   _lekol_, _bricht_, _kopierer_, _birmohwi_,
   {{0x92d8d095,0xbcb09104,0x49b61105,0xc3417106}},	//   _queer_, _যান্ত্রি, _ליצמאן_, _aigesan_,
   {{0x69aaa107,0xf8322108,0x7ee79056,0xf25ac109}},	// [050] _दिग्विजय_, _عبدالصبو, _kgokagan, _samlar_,
   {{0xa6a5010a,0x19b5b0e5,0xe29070f9,0x6c02710b}},	//   _پئماني_, _दुष्कर्म_, _hinar_, _aragakor,
   {{0x5d85d026,0x42fcd10c,0xa29070d7,0x23e9b10d}},	//   _카테고리의_, _amega_, _rinat_, _паўплыва,
   {{0x80f5110e,0x42eff10f,0x6290c110,0x40f7a0fb}},	//   _अनुराग_, _tragédia_, _salapi_, _अभावे_,
   {{0x0a772050,0x6317c030,0x02ea1111,0x72b400d2}},	//   _增幅比去年同期低, _madaniy_, _regiono_, _amics_,
   {{0x9f2e1009,0x96a67008,0x5c5c0112,0x3af39113}},	//   _числе_, _аларсыңы, _pertuan_, _taksomet,
   {{0x02901114,0x52485115,0xc2fcd116,0x5686d08d}},	//   _faham_, _balma_, _lingid_, _atidzuni,
   {{0x23eae088,0x4f3f4117,0xffb98118,0x2d03d030}},	//   _contoh_, _ghishiya, _tableclo, _ادراه_,
   {{0xec51c032,0xcb2d4119,0x0200b11a,0x0e01101a}},	//   _samtaka_, _tusaamas, _andito_, _supedita,
   {{0x7302011b,0x4dd7c11c,0x645c30bf,0x4869a11d}},	//   _članku_, _وفاته_, _عاقتبیده_, _achikuru,
   {{0x82d8911e,0x9248511f,0x62d92120,0xa00d5121}},	//   _traer_, _falma_, _fryer_, _konveren,
   {{0x32d8f122,0xfeb72123,0x9f852124,0x1131a0f7}},	//   _juger_, _konsilte_, _автомашь, _中国共产党大事记_,
   {{0x727ef125,0xd3f98126,0x32da6127,0x63c86128}},	//   _ikindi_, _buruj_, _cereka_, _mervyn_,
   {{0x89ed7031,0x4b21c129,0x12d9203a,0x4c8ca0c9}},	//   _sainsnya_, _komprome, _aryer_, _факторів_,
   {{0x525b012a,0xe0c220bc,0x020030bf,0x9370b12b}},	//   _quales_, _abaralóm, _kamida_, _anwansị_,
   {{0xe224d12c,0x0250c12d,0xec6a812e,0x0dfe112f}},	//   _aweke_, _governem, _systemy_, _نەپىس_,
   {{0x56b530d0,0xbf279130,0xf1d8a050,0xe6666131}},	// [060] _aglakuvi, _tsiraira, _很傻很天真_, _दिवसभर_,
   {{0x4973a132,0x6fb2b065,0xf1489133,0xaf9ca101}},	//   _интермед, _ויטמינים_, _automaty_, _formasyo,
   {{0x82d8c08d,0x53209067,0x62c85095,0xb394d134}},	//   _bileni_, _izaya_, _leconte_, _celsis_,
   {{0x142b3135,0x234fc136,0x72907137,0x43b64138}},	//   _ሕጋውነት_, _estekak_, _pinas_, _kreveta_,
   {{0x12a02096,0x52d89139,0x138d108b,0xc305013a}},	//   _عنہما_, _bajeta_, _amastani_, _ngwanem_,
   {{0x87a2913b,0x3a7600ae,0x85253067,0x861f613c}},	//   _illulaqi, _apellyas, _malitegh, _balniari,
   {{0xd2b4b13d,0xb2d44025,0x064d413e,0xbc913137}},	//   _lecce_, _aidogba_, _स्मार्टन, _mabuting_,
   {{0xed07313f,0x0b4960fb,0x34f39140,0x2c15b141}},	//   _אינסטלצי, _वर्षाणि_, _зонасы_, _medreses,
   {{0x7378d01f,0x5ebb2142,0x4b34d143,0xda9a2144}},	//   _kimanin_, _alergije_, _babandis, _asinasis,
   {{0x02246145,0x926c2146,0xe5d4700e,0x6eadf147}},	//   _nwoke_, _rekod_, _redaksiy, _istodobn,
   {{0xa6b1510e,0xe3801019,0x6b7f0148,0x4d9c1149}},	//   _हस्ती_, _supren_, _sakumaha_, _feterale_,
   {{0x23f9114a,0x99b0e048,0x5b03b14b,0x20c3f14c}},	//   _amburu_, _अपहरणकार, _pourraie, _তাজীন_,
   {{0xf2d5114d,0x7200e14e,0x41ffd14f,0xd2c8409a}},	//   _sellest_, _sonido_, _nimittaṃ_, _خاندانلى,
   {{0x0c766150,0x62d8d151,0x7291c152,0x92026153}},	//   _første_, _tseem_, _aivan_, _aktier_,
   {{0x437e1154,0xb5f2a155,0x523f8156,0x52903157}},	//   _моноксид, _ﺋﯩﺠﺮﺍ_, _оставете_, _bajau_,
   {{0x26ce3158,0x7b551159,0xac484011,0xac77015a}},	//   _detaljni, _rendesen_, _ahendúvo_, _damskie_,
   {{0xf27f415b,0x0da1315c,0x63005119,0x33f9815d}},	// [070] _ejensi_, _infokana, _qulaani_, _wuruk_,
   {{0x4ed2701a,0xc20ec15e,0x3213e0fc,0xdb81b15f}},	//   _كەتتىڭ_, _канад_, _bothe_, _qunngiar,
   {{0x62927160,0xe3eae161,0x33e7702d,0xa725809a}},	//   _igrati_, _kuitwa_, _sportivi_, _گۈلىستان_,
   {{0x92523162,0x897870a8,0xa36eb0c4,0x330e6163}},	//   _адвокатл, _velikost, _amaguru_, _rosales_,
   {{0x2291e164,0x4cd73030,0xb2cac165,0x8213e0e7}},	//   _mitan_, _معتاد_, _melden_, _wothe_,
   {{0x42b60166,0xb917b167,0xe9cf2168,0x52d99169}},	//   _muscat_, _rinconad, _momentee, _musek_,
   {{0xc2a6c16a,0x6291c040,0x033de16b,0x0291e0c7}},	//   _member_, _pivan_, _servizzi_, _xitaa_,
   {{0x537d416c,0x65935115,0xdc9640f4,0xed07216d}},	//   _etranje_, _abandonè, _شاھمات_, _bearbesc,
   {{0x43bb105b,0x0fede16e,0x2200c16f,0x22943170}},	//   _دسوات_, _republič, _polico_, _odradili_,
   {{0xf3874171,0x33473172,0xa2c5b101,0xa213e0e7}},	//   _sheria_, _bulelwa_, _egalite_, _yothe_,
   {{0xd27ef173,0xa291011c,0x53cf4174,0x0291e175}},	//   _ikinji_, _tobann_, _preveo_, _kitan_,
   {{0xf3f47086,0xe24870fb,0xf0792176,0x42918177}},	//   _lastfm_, _janma_, _عزیزم_, _miraa_,
   {{0x08518178,0x3f3d6179,0xea7170af,0xf290c138}},	//   _sveriges_, _innflutn, _たかじんのそこま, _izlaza_,
   {{0xd526d17a,0xeb56203d,0x889e417b,0x9394e17c}},	//   _সম্পাদকৰ_, _نظریو_, _ءتۇزەيتى, _pensis_,
   {{0xbe191098,0x998ec037,0xccb0d17d,0x82b66057}},	//   _nizeyima, _табиб_, _входа_, _fructe_,
   {{0x1346317e,0xe564917f,0x605a20f4,0xc4969180}},	//   _genders_, _мунчар_, _франсийи, _特許請求の範囲_,
   {{0x2d755181,0x2bed4182,0x53f9a10e,0x23e7c183}},	// [080] _uramutse_, _ananuśru, _kupuj_, _centdeci_,
   {{0xd291e184,0x02ee8185,0x7c77b186,0x87602105}},	//   _hitan_, _gaanani_, _afashwe_, _שמוציג_,
   {{0x82249187,0x0b7b4188,0x89d6012e,0xe1778143}},	//   _mwake_, _hannergr, _विशेषताए, _aaaiiihh_,
   {{0x22249189,0xdfd5218a,0x3290718b,0xa27f418c}},	//   _svaki_, _internaţ, _janai_, _abenza_,
   {{0x4290a18d,0x8c62f18e,0xc2901177,0x3e0f218a}},	//   _dibar_, _fevriye_, _tahak_, _comentea,
   {{0x92b4018f,0x62dcc03a,0x63ebf190,0xbaf99191}},	//   _klick_, _anforsi_, _ceuti_, _agendaen_,
   {{0x73588192,0x0aeea193,0x6ec3a065,0xabd17194}},	//   _кушнарен, _fortgehe, _ואורח_, _handwier,
   {{0x5a09711d,0x149c706a,0x12918148,0xc291e120}},	//   _kufanana_, _उत्पादने_, _sirah_, _gitan_,
   {{0xb2d8b195,0xd2cae196,0x02efc197,0xc66c1198}},	//   _madera_, _mundua_, _ahlinya_, _холандиј,
   {{0x63e1210f,0x56968155,0x7291e199,0xd291c030}},	//   _اضلاع_, _ﭼﻮﯕﻘﯘﺭ_, _yntau_, _anvar_,
   {{0x3db670bb,0xcea440eb,0xf29030b0,0xa2d8c027}},	//   _brundtla, _ambulate_, _tajam_, _valeta_,
   {{0xf6de50be,0x91d8c0d8,0x3f0f1037,0xf1b1207f}},	//   _futbolli, _ainglibh_, _шикәр_, _асумои_,
   {{0xb291e184,0x43fa608c,0x1631a19a,0x6291c19b}},	//   _vitan_, _natuur_, _economai, _bival_,
   {{0x02b4018f,0x227f7143,0xe290119c,0x1324503c}},	//   _blick_, _abanda_, _hahai_, _calculi_,
   {{0x3c67208a,0x1904019d,0x27b4305a,0xb263d19e}},	//   _دروان_, _comataid, _كروراندى, _horopaki_,
   {{0xcc1d3008,0xdc61619f,0x727f4185,0xd2d9b1a0}},	//   _suratlar, _antumaa_, _obenya_, _niveri_,
   {{0x27c1f1a1,0xd3058023,0xc2782080,0xd3eb91a2}},	// [090] _insteadw, _asmatuk_, _abuná_, _kesti_,
   {{0x72d8c1a3,0xf37f81a4,0x048461a5,0x1ebb01a6}},	//   _dalesa_, _ahiahia_, _abafelok, _alishiye_,
   {{0x825a01a7,0xefb5a1a8,0x7847c1a9,0xdc98100a}},	//   _drill_, _блогера_, _закари_, _carrying_,
   {{0x614221aa,0x027f0084,0x3290c1ab,0x925b41ac}},	//   _аттар_, _akanji_, _inday_, _ivelan_,
   {{0xbea61196,0x9c6181ad,0x5f750145,0xed14d0e5}},	//   _экологий, _peerage_, _chọba_, _स्वर्णिम_,
   {{0xb29051ae,0x88c751af,0x938001b0,0x4874b1b1}},	//   _walau_, _whatiang, _vopred_, _parisuhd,
   {{0x73d08142,0x56f7814f,0x023161b2,0xd25a61a4}},	//   _klimatsk, _मानवाः_, _shumisa_, _auolo_,
   {{0x12d8b1b3,0x9321503a,0x9d3af14b,0x45a3a086}},	//   _cadera_, _akeyir_, _domicile_, _christum_,
   {{0xc2cae141,0xfc14d1b4,0x002c71b5,0x29e091b6}},	//   _menden_, _शुक्रास्, _оқсан_, _armonija_,
   {{0x9290c1b7,0x305a01b8,0xc03da1b9,0x02903033}},	//   _onday_, _agribank_, _бизнесҡа_, _gajak_,
   {{0x5c7731ba,0x324911bb,0xdfdda1bc,0xffd31100}},	//   _console_, _yazma_, _базасына_, _relihiyo,
   {{0xca79c1a1,0x005a0180,0x526c41bd,0x62766022}},	//   _esponsib, _このブログ全体を, _nemoc_, _ءﺗﯘﺑﯩﺮﻟﻰ_,
   {{0xa25a91be,0x22905134,0x620270be,0x0c05e1bf}},	//   _suala_, _walal_, _arriti_, _versuri_,
   {{0x02cb7048,0x12cad052,0x47dae182,0xf9ece1c0}},	//   _hradec_, _saldus_, _क्षरणे_, _angoscia_,
   {{0x32d881c1,0x620191c2,0x63f7019e,0x72cae0c7}},	//   _bekend_, _lexing_, _ahorangi_, _booday_,
   {{0xa213e1c3,0x434051c4,0x4290c1c5,0x8ac9a115}},	//   _motha_, _burdens_, _bidas_, _conjugas,
   {{0x625a0082,0xe27e00e3,0x22907005,0xea435005}},	// [0a0] _brill_, _aming_, _manau_, _месенджа,
   {{0xb25951c6,0x72330178,0x8de101c7,0x9638710a}},	//   _portafol, _exempel_, _тәрбие_, _mwenyeki,
   {{0x826c20a1,0xd6bad1c8,0xcfffc144,0x4213e1c9}},	//   _dekoa_, _javascri, _abakapho, _gotha_,
   {{0x1d9f212a,0x86d5a1ca,0x2d192101,0x8290c0d3}},	//   _mangiate_, _daraawii, _dinnyite_, _gidar_,
   {{0xab411015,0x9f2f00d7,0x53eae0ac,0x55436116}},	//   _denbighs, _dumasını, _feiten_, _अगवढ़_,
   {{0x6c9811cb,0x83417044,0xd26c21cc,0x8b2fa0ac}},	//   _tarraing_, _rerenga_, _rekoh_, _확인해주세요_,
   {{0xf992e1cd,0x0dc720ac,0x42d9c12b,0x2427e1ce}},	//   _verklige, _부동산써브가_, _chineke_, _grudziąd,
   {{0x4290a023,0x83eae1cf,0x4291e115,0x32905008}},	//   _rabah_, _heiten_, _aital_, _galam_,
   {{0xcd07a1d0,0xb72d101c,0xe318e11a,0x89fb21a7}},	//   _multifoc, _tartalom_, _balitang_, _desappre,
   {{0x82d981d1,0x829031d2,0x515c71cf,0x7d5a30d7}},	//   _amennde_, _bajah_, _jangdebl, _ролен_,
   {{0x5290a07d,0xd4339085,0x7899d01a,0x67f1a042}},	//   _babai_, _হামিদ_, _арменияд, _akusesiw,
   {{0x9f98e16e,0x3635d124,0xaf3c21d3,0xc4f64031}},	//   _политику_, _алексеи_, _annunzia, _ፍርስራሽ_,
   {{0x397901d4,0xc2a701d5,0x124301d6,0x4d6aa031}},	//   _misilitt, _odabir_, _anemtali_, _በፍርሃት_,
   {{0x4389b17d,0xf2d051d7,0x1340a1d8,0x0610f0f4}},	//   _helsinki_, _flattery_, _rakeyan_, _ﺩﺍﺋﯩﺮﯨﺴﯩ,
   {{0x123c6168,0x12467032,0x13e211d9,0x66d0109b}},	//   _감사합니다_, _svolítið_, _تىلەيمىن_, _hukafomi,
   {{0x1290700e,0xe5ca11da,0x58c6e1db,0x15b560db}},	//   _manat_, _burafash, _innehold, _февралдә_,
   {{0x425a0074,0xb3cf711b,0x348011dc,0x2147c140}},	// [0b0] _prill_, _glavne_, _सेनाको_, _санитар_,
   {{0x6c519100,0x324111aa,0x420661dd,0xcfa42124}},	//   _taktika_, _khampani_, _tukituki_, _черкесси,
   {{0x265ec1a5,0xf2b400c3,0x1c7af1de,0x925ad1df}},	//   _backroom_, _slici_, _vlasnik_, _stelo_,
   {{0x2291e1e0,0xfcdfc1e1,0x5aea8036,0xd343c1e2}},	//   _vitae_, _amakhulu_, _trattame, _болотар_,
   {{0x9290306a,0x8c6061e3,0xb2d8c1e4,0x28c651e5}},	//   _pajak_, _austens_, _kalepa_, _aprelind,
   {{0x72d8d051,0x4290e1e6,0x42011122,0xa291e1e7}},	//   _creep_, _manasi_, _vicina_, _aitab_,
   {{0x42dab00a,0x636e3005,0x99de81dd,0x729180be}},	//   _october_, _maitinim, _cikuuuuu, _mirat_,
   {{0xe34b01e8,0xfbb18096,0x939671e9,0xf318e137}},	//   _tulevat_, _مصطفوی_, _dissel_, _salitang_,
   {{0xa9d0c1ea,0x2978b1a0,0x12ef71eb,0x49818115}},	//   _дедим_, _dakipast, _kaafen_, _aisidame,
   {{0x624981ec,0xed60b0f7,0xc26cc042,0x4b0431b9}},	//   _larme_, _香港紫金碳雕加盟, _ahlose_, _ameriaka_,
   {{0x72905177,0x683521ed,0xd29030cf,0xc2905086}},	//   _malak_, _kremlend, _tumayo_, _palam_,
   {{0x720ec0b8,0x827f71ee,0x72b401ef,0xbdce11f0}},	//   _факат_, _abanza_, _boica_, _кишер_,
   {{0x02d8e03c,0x517e40bf,0xc29180c0,0x7e55514f}},	//   _manera_, _jarayonl, _airau_, _पूर्वत्र,
   {{0x82027163,0x854df161,0x9b9221f1,0x8290a023}},	//   _buriti_, _aisvetuk, _poniendo_, _gabaw_,
   {{0x553d01b5,0x225ac1f2,0x44c1c01b,0x867db0de}},	//   _تيتانيك_, _gamlar_, _йөнекей_, _بااڭاردى_,
   {{0xb2e30074,0x229051f3,0xfd2300be,0x227f40b0}},	//   _familje_, _halak_, _familjet_, _keenam_,
   {{0xaf36b00f,0xbfd5813f,0x197681f4,0x1291c05e}},	// [0c0] _prøver_, _אולסטארס_, _aranseme, _hivaa_,
   {{0xd778d1f5,0x557d6198,0xf2c2019f,0x9b1731f6}},	//   _سونامی_, _populaçã, _amaluma_, _रेसकोर्स_,
   {{0x03781062,0x531771f7,0xa9678109,0x024981f8}},	//   _faaalia_, _aznakay_, _aikidote, _farme_,
   {{0xf5e071f9,0xe984f1fa,0x92cb50cb,0x0c6220b3}},	//   _कण्ट्रोल_, _chukumet, _credir_, _tartıq_,
   {{0xf54db03c,0x225a6062,0xd479015e,0x1f1fe1fb}},	//   _dignità_, _atolu_, _польшийн_, _aratanga,
   {{0x824a51fc,0x82d851aa,0x52907023,0x9c5f11fd}},	//   _hetman_, _kiley_, _hanam_, _unuttum_,
   {{0x829071fe,0x725a40ef,0x7c75f1ff,0x15ff7200}},	//   _kanam_, _jumla_, _स्प्रे_, _payllawi,
   {{0x90d361bc,0x3db23083,0xde68c1d9,0xed75d1b5}},	//   _эларалык_, _нооруз_, _тарифтер, _كورشى_,
   {{0xbe510085,0x12cc2201,0xc2d61051,0xcb0ca202}},	//   _পুঁজিবাদ, _italico_, _gallows_, _maksudna_,
   {{0x83ea9195,0x594da203,0x2799a030,0x925a90fd}},	//   _ngati_, _enkomere, _қабристо, _prale_,
   {{0x93f98204,0x3394e205,0x6233514e,0x01fc8048}},	//   _turut_, _chisel_, _অপরিহার্, _bankovní_,
   {{0x9d9b0206,0x288130b8,0x0290e029,0x685f0105}},	//   _taylorma, _тарғиб_, _janari_, _impresas_,
   {{0xf0462104,0x8929e022,0xf2907207,0xed870086}},	//   _incremen, _дербес_, _sanal_, _oddworld_,
   {{0xa24830ce,0xc2907208,0xd30e7209,0xdd29f085}},	//   _semmit_, _panal_, _anabata_, _সৌভাগ্য_,
   {{0x4da20101,0xb2903172,0xa290d1af,0xb2751008}},	//   _prensipa, _dumago_, _matapihi_, _gündelik_,
   {{0xc1a50004,0x0300520a,0xe294b20b,0xe29180a9}},	//   _انتظامی_, _kulaani_, _रामप्यार, _niraj_,
   {{0xd2d8f20c,0x329071e6,0x801f520d,0xfb4df140}},	// [0d0] _mahera_, _vanam_, _handiago, _бюджетта,
   {{0xe2156085,0x80be520e,0x12d8c20f,0xd2d67053}},	//   _নিয়ন্ত্র, _комплетн, _taleyi_, _autoren_,
   {{0xd9586210,0x7c766067,0xd34c6085,0x44e3a096}},	//   _unplanne, _adiresi_, _সময়ের_, _پروڈیوسر_,
   {{0x53ea6211,0x99b71212,0xa605519f,0x5300d213}},	//   _ngoto_, _واکسین_, _adamsani, _sujakiw_,
   {{0xbfaec214,0xf25ab215,0x6f95c02e,0x1dc12216}},	//   _банкі_, _želeo_, _близко_, _toxicoma,
   {{0x929200ee,0x725c0082,0x425a0189,0xd300101f}},	//   _strany_, _dalestim, _krila_, _makamai_,
   {{0xd838f217,0x4f690218,0xd25ae219,0xef4c9180}},	//   _башлангы, _phraghas_, _cvilin_, _priserne_,
   {{0x6db3a005,0x72907196,0x82266185,0xa3eb9095}},	//   _negalite_, _lanak_, _akukuo_, _nests_,
   {{0x12e9b0e4,0xe15cc21a,0x138f20f7,0x27afe21b}},	//   _bruneau_, _булак_, _年获得了苏州市政, _sigurgei,
   {{0x17ada21c,0xa3f9821d,0x429050a4,0x701d103a}},	//   _direttiv, _gurur_, _lalai_, _fondasyo,
   {{0x6fda009f,0xfc07b21e,0x12e900c5,0x74c1c1d9}},	//   _afrikabo, _khasiat_, _birisha_, _көнемен_,
   {{0xe28c0012,0x43f9821f,0x0d4a504c,0x62027220}},	//   _chakula_, _aurur_, _ارجمند_, _buriri_,
   {{0xff67f009,0x325ad196,0xa25a012c,0x8eb1f144}},	//   _других_, _zuela_, _arila_, _akulobun,
   {{0xfbfa8221,0x7a521222,0xe2911223,0x1d5dc0b0}},	//   _abathemb, _formanss, _mabasi_, _tembakau_,
   {{0x3b1920fd,0xc8414224,0xac34d1bd,0x6201811b}},	//   _depatman_, _kholaped, _प्रेमप्र, _muzici_,
   {{0x28464225,0x594ed14f,0xde7c5226,0xd2027149}},	//   _qualidad, _avalokit, _होम्स_, _tosina_,
   {{0xd0f920af,0x5fc7811b,0xd27ef029,0x923f0227}},	// [0e0] _クショップ_, _evropsko, _nginum_, _신청합니다_,
   {{0x13877078,0x429260c8,0x758ba12b,0x92497228}},	//   _tharla_, _kitais_, _ezinaụlọ_, _adamel_,
   {{0x5290a177,0xc25a9229,0x7283f22a,0xba87e022}},	//   _gabat_, _quale_, _prikaza_, _ﺩﻩﻧﺴﺎﯞﻟﯩ,
   {{0xc290c16c,0x8077e168,0x9ec2a0c0,0xc29110a4}},	//   _kadav_, _koppelin, _digitaus_, _kabasi_,
   {{0x6290722b,0x1c6731e7,0x073eb22c,0x7057d1f7}},	//   _kanak_, _kultuur_, _amalosig, _театрның_,
   {{0xe2918123,0x43f98206,0x9290a0d7,0x9c67322d}},	//   _mirak_, _purus_, _kabat_, _cultuur_,
   {{0x429180d7,0xc3f9f228,0x7a97b0cf,0xc0091009}},	//   _tiraj_, _butuh_, _tumingin_, _разобрат,
   {{0xbb6f81ba,0xe291122e,0x1c86c03d,0xeaf3522f}},	//   _volontar, _nabari_, _شفاهي_, _ugostite,
   {{0x9213e0e7,0x7d105230,0xb290a054,0xcb6f8231}},	//   _hothe_, _boalsert_, _dabam_, _wolontar,
   {{0xe6d93232,0x32905008,0x56996233,0xb9b77102}},	//   _رياست_, _talap_, _antenimi, _класифік,
   {{0xf2b58123,0xbbc1b234,0x084ed09b,0xfea2e0f1}},	//   _eredite_, _biskupic, _pibligid, _skuldren,
   {{0x529110b4,0x52907004,0x801d80e9,0xec6e4235}},	//   _sabati_, _manah_, _adjetivo, _andreea_,
   {{0x49db6236,0x5d1b6236,0x725b6237,0xac1b60fa}},	//   _porodica_, _porodice_, _porodici_, _porodicu_,
   {{0x68005152,0x52918238,0xc2911239,0xd2da01d7}},	//   _официаль, _dirak_, _labari_, _upsets_,
   {{0xc73f0152,0x825af23a,0x1b1f2012,0xd2d9b23b}},	//   _оставить_, _nailar_, _قصيدو_, _daveta_,
   {{0x223b71d2,0xb267b105,0x7a4d900e,0xe2762105}},	//   _kammiet_, _ננננננננ, _qondarma_, _מידטאון_,
   {{0x0640805e,0xd2b58057,0x5291e05e,0xeb63b065}},	// [0f0] _aisikili, _credite_, _eitai_, _הרושם_,
   {{0x32901029,0x726c20bd,0xbf8ab128,0x5d5dc23c}},	//   _dahar_, _gekom_, _harvests_, _гаранция_,
   {{0x3dd2d0b9,0x79a37198,0xc3f98039,0xb3ea923d}},	//   _столы_, _ministér, _kurup_, _kgato_,
   {{0xa291123e,0x2a4ae23f,0x226cd09e,0x03bff240}},	//   _jabari_, _cerdanha_, _nalogu_, _kurvini_,
   {{0x4290c0fb,0xe37b80d4,0xe1011241,0x73e5c242}},	//   _dadau_, _semacam_, _акватикэ_, _tātad_,
   {{0x23966243,0xf2a051e7,0xaae21030,0x3c51f031}},	//   _persib_, _klubid_, _آپریل_, _kontena_,
   {{0xd529b244,0x2476b0ce,0x61e2506c,0x20b41245}},	//   _askipach, _hirtelen_, _भितरे_, _anemibal,
   {{0xd2903015,0xbda7c157,0x72907246,0x6bf20202}},	//   _lajas_, _keboleha, _nanai_, _kartakus,
   {{0x8f150205,0x6b35b043,0xb6c3b247,0xd60f6248}},	//   _furthera, _virallis, _hastalık_, _ንዝተባህለ_,
   {{0x42d721d9,0x4f20c249,0x1290719c,0xc8e0c24a}},	//   _تارتتى_, _pretenda, _hanai_, _oangeand,
   {{0x60b4124b,0x1a88a12f,0x994f0018,0xd1c371f8}},	//   _enemibal, _ﺗﻪﻳﻴﺎﺭﻟﯩ, _aprobare, _postupak_,
   {{0x02d99052,0x0ac531bf,0x42d8c24c,0x7347324d}},	//   _puses_, _адаптаря_, _dileen_, _vulelwa_,
   {{0x3ff0120e,0x53f98008,0xd200724e,0x197e124f}},	//   _мерки_, _durup_, _apnic_, _sivisune,
   {{0x52907250,0x25a42105,0x97bcf251,0xeba02252}},	//   _lanai_, _שראלטשע_, _комуници, _режимдин_,
   {{0x9da2c253,0xd290c08c,0xc3877254,0x12017076}},	//   _polokala, _nadat_, _ugarte_, _anaina_,
   {{0xd3eb9255,0x12b1f256,0xcb31b257,0x83f98141}},	//   _restr_, _bandika_, _klubunun_, _gurup_,
   {{0x3ef00258,0x72903015,0x7290e0a1,0x65a57227}},	// [100] _folketin, _fajas_, _rafai_, _예산낭비신고_,
   {{0x925a6193,0xb60cd259,0x3f473083,0xf3f8d16c}},	//   _stolz_, _avtomati, _аламанды, _abouti_,
   {{0x62cae25a,0x7b72d063,0x8076325b,0xaaf7c25c}},	//   _mendon_, _عبدالمتی, _skipanin, _مىزدا_,
   {{0xb6d24199,0xe9e6e14d,0x72d5110a,0x51d75057}},	//   _morgannw, _चट्टी_, _kupokea_, _дестинул_,
   {{0x827e6151,0x9e61f243,0x1d8b925d,0xd313811c}},	//   _hmong_, _pembagia, _bakokuta, _amxbans_,
   {{0x125a925e,0x35bca216,0x7290c012,0x7c7c925f}},	//   _kuala_, _turissem_, _wadau_, _blissin_,
   {{0xe3ceb260,0x72eab111,0x0291c007,0x2a042261}},	//   _snevre_, _atendas_, _divat_, _rinascit,
   {{0x62e970b0,0xac1c2262,0x12003142,0x52cac168}},	//   _dirinya_, _rugambar, _mamica_, _gelden_,
   {{0x3290707d,0x2eed6078,0x62dcb263,0x8f109264}},	//   _sanap_, _يييييييي, _минтакаи_, _اللؤلؤ_,
   {{0xc2b46265,0xa2c4109f,0x227f5010,0x326c0266}},	//   _mloci_, _hillard_, _amends_, _afioo_,
   {{0x12da4267,0xfc0580df,0xf1e12268,0x13444077}},	//   _gwanine_, _adarray_, _яъқуб_, _bibeere_,
   {{0x927e6269,0x65be2036,0x2c5ca26a,0x9249821d}},	//   _imong_, _друго_, _central_, _carma_,
   {{0xd2d88211,0x62552266,0xa394726b,0xb74ba214}},	//   _maheni_, _aholelei_, _zonse_, _этикасы_,
   {{0xc2b3426c,0xa76c9008,0x225a026d,0x0fac6264}},	//   _učenje_, _намысына_, _tsile_, _مغامرات_,
   {{0xb37a001e,0x67f44140,0xbe5d226e,0xfd940199}},	//   _aguaman_, _инвалидл, _матчу_, _celtaidd_,
   {{0x6290c170,0x6986c1dc,0x9380626f,0xebd59270}},	//   _nadam_, _बालकृष्ण_, _saurna_, _mendasar,
   {{0x42d9205a,0x7cd37085,0x825a6271,0x7f9ed218}},	// [110] _valorar_, _ঝুঁকি_, _stoly_, _محاور_,
   {{0x02b49272,0x336e90e5,0x33ac120e,0xd96ab0f8}},	//   _flack_, _पक्षियों_, _слободен_, _otunbaye,
   {{0xb35331d9,0xe26e5273,0x329030fb,0xc26c40c3}},	//   _تۇران_, _chuong_, _rajas_, _nemoj_,
   {{0x4d5a8274,0x32b1f047,0xe6813121,0x427ed1ad}},	//   _प्रभाकर_, _tandika_, _जुटान_, _finned_,
   {{0xc2395011,0xcb775275,0x1bc31276,0xf547807f}},	//   _арбџьарм, _راستلا_, _وهنجڻ_, _баҕапшь_,
   {{0xf8433026,0x5b0290d8,0x4b41d277,0xabe6c278}},	//   _되었습니다_, _litriche, _diagnóst, _apoloiso_,
   {{0xdae85279,0x47b4114c,0xa24980a9,0x8105827a}},	//   _nabobyen_, _োকােনা_, _tarma_, _pamiatky_,
   {{0xf290c052,0x9c6ac27b,0x738700f3,0x3bfc00bb}},	//   _gadam_, _चिठ्ठा_, _starcu_, _aalefric,
   {{0xd70d4198,0xf300827c,0xb9c5a0fc,0x485ca00e}},	//   _experiên, _forbrug_, _balekgot, _xarakter_,
   {{0x9290c09c,0x6dc2004f,0x8e4fd0af,0x8e552071}},	//   _aadam_, _meningka, _オンラインショッ, _redaksje_,
   {{0xa290127d,0x6602827e,0x4fb3e050,0x09f7a27f}},	//   _tahay_, _द्विअर्थ, _生活必需品_, _بیرورای_,
   {{0x13781280,0x22903104,0x548ce186,0xd212c0c7}},	//   _lubanga_, _bajar_, _urugerek, _indha_,
   {{0xe25b608e,0xcecb8281,0x3c062105,0x12903027}},	//   _lwglan_, _komishan, _זשאואיש_, _pajas_,
   {{0x0145213d,0x96aa40d2,0xef9da282,0xac615228}},	//   _spreewal, _اقساداعى_, _מסכתא_, _andukan_,
   {{0x8c081283,0x203640aa,0xeb19a1c7,0xee03123f}},	//   _learners, _ahatunan, _ﺑﺎﻗﯩﻼﯞ_, _arrevira,
   {{0x3175a019,0x2c2cf159,0x1288f284,0x21491248}},	//   _מוקצה_, _bruttó_, _pesantem, _ዘይካኣል_,
   {{0xd7b61166,0x03781285,0x0ccf8064,0x12915171}},	// [120] _trasferi, _kubanga_, _如要投诉或提出意, _nafasi_,
   {{0xf2c1c003,0x0bdd7231,0xcb7b9115,0x52905137}},	//   _sellega_, _दरिया_, _alashiya_, _balat_,
   {{0x17aa8286,0x68f67258,0xd2e8e1c9,0xb26e5287}},	//   _kastosli, _innarluu, _diliman_, _kitose_,
   {{0x6200819c,0x44133288,0x9290c04b,0xfc67b289}},	//   _hakina_, _سانده_, _qadam_, _hebraeg_,
   {{0x3d3d5031,0x42d9f28a,0x7f571008,0x53f8d28b}},	//   _ተቀናጅተው_, _truet_, _sungatyn, _theun_,
   {{0xf290a28c,0x5100113f,0x6b20028d,0x063fc127}},	//   _labai_, _רמקולים_, _acharamb, _kamikami,
   {{0x6c4b104f,0x3ae54262,0x461bb155,0x5248b04a}},	//   _tentang_, _itsembab, _аталғу_, _adembe_,
   {{0xa2905008,0xa15fb28e,0x6f2e4053,0x12e8e1a0}},	//   _halas_, _mengamal, _anleitun, _hiliman_,
   {{0x39e2c10a,0x8608228f,0x806e9290,0x9fa1b291}},	//   _ڇانيل_, _biografí, _klasyczn, _عملياتي_,
   {{0x226c4105,0x57c73292,0xa22540bc,0xb0e200ec}},	//   _temoj_, _далили_, _akekoo_, _gjeneral,
   {{0xe807a13f,0x82d59064,0x8249812e,0x5c76c293}},	//   _מתמיד_, _凡本网注明_, _darmo_, _aderesi_,
   {{0x1beeb1a1,0x9e88417a,0x27c94294,0x827f7295}},	//   _indentur, _মানসমূহ_, _longgggg, _abanja_,
   {{0x1b183296,0x226cf0ba,0xd290f297,0x837fd0f6}},	//   _linganis, _segon_, _cliant_, _bolanda_,
   {{0xcd8f313b,0x602cb24c,0x728170a1,0x3906d011}},	//   _aallanga, _اقبالؒ_, _lembetti_, _airamogu,
   {{0x8ec43298,0x7e4de026,0x025a9299,0x7843729a}},	//   _kinyarwa, _대학보고서_, _quali_, _bertugas_,
   {{0x125a908f,0x335bf29b,0xd2a711ec,0xc37b20c3}},	//   _arall_, _isigaba_, _alabaz_, _ukratko_,
   {{0x51fdb27a,0x468311c9,0xa23df0f6,0x52cae29c}},	// [130] _reklamác, _rosemari, _гөрүҗили, _venden_,
   {{0x7394716c,0x3290518b,0xa2b4929d,0x62cae0f5}},	//   _konsa_, _palat_, _slach_, _wenden_,
   {{0xd97ae29e,0xe06e6111,0x43ea015e,0xf134c1bc}},	//   _souhaite, _rachunek_, _maite_, _алдыда_,
   {{0xdde5c241,0x8662d0b3,0x7290e028,0x75ea30f9}},	//   _афише_, _декабрис, _nafam_, _heiminum_,
   {{0x62905027,0x9200829f,0x32f7014a,0x125a90a8}},	//   _talas_, _makila_, _arkiseh_, _staly_,
   {{0xe2ace237,0xebea72a0,0x130771c3,0x2bdbc27a}},	//   _procjeni_, _پلاتفۆرم, _aghaigh_, _definíci,
   {{0x0ed96081,0x502fe104,0xe9fc407b,0x580fc13c}},	//   _aalisarn, _alrededo, _adaamaat, _амзари_,
   {{0x729010fb,0x50098034,0x9354d1e0,0x9dc202a1}},	//   _ubhau_, _занимава, _generis_, _peningka,
   {{0x894f32a2,0x63eaf0f0,0xdd30a126,0xd6c81063}},	//   _dallinge, _faites_, _tennille_, _shubhasi,
   {{0xe46ee2a3,0x7635e2a4,0x837fd22f,0xa26d21d7}},	//   _урамы_, _ईतिहास_, _odlaska_, _beyon_,
   {{0xb236d2a5,0x52cae07e,0xa3ea011c,0xea89c25f}},	//   _ajeji_, _hundra_, _daite_, _unsophis,
   {{0xac3202a6,0xa291e086,0x63f8d1c3,0x3cb57199}},	//   _kombinir, _vitam_, _fheum_, _targedau_,
   {{0xb291e0e8,0xa2f54216,0x12fc21b3,0xa25a0266}},	//   _witam_, _brunner_, _feminas_, _asila_,
   {{0x72d76261,0xc75532a7,0x37b49227,0x62ef92a8}},	//   _livorno_, _курилди_, _afmeting, _pikinga_,
   {{0x22da5207,0x4b77019e,0x958f8019,0x63a5a26e}},	//   _sitesi_, _akoranga_, _אמתער_, _garantij,
   {{0x33eae2a9,0x02e21175,0x293ff00b,0x7290c114}},	//   _seiten_, _andomaz_, _kaammatt, _dadah_,
   {{0x4e1a309c,0x62027101,0xde4222aa,0xd4e9c248}},	// [140] _akkeekka, _kisisa_, _ankalaza, _ስርሖያት_,
   {{0xb2da01b3,0x427e90e7,0x0e67e0dc,0x52a6c228}},	//   _sapeva_, _mmane_, _рахмат_, _jembar_,
   {{0x67eee0af,0x064072ab,0x4da2c2ac,0x10dcb292}},	//   _ブログトップ_, _pasidali, _ناچنه_, _advokatl,
   {{0xff5d22ad,0xa291e15b,0xeae9315e,0x04133078}},	//   _marautan, _antap_, _больж_, _جامده_,
   {{0x9c5b52ae,0x615972af,0x8249814d,0xb2d8b223}},	//   _albumid_, _barutamo, _tarmo_, _madeni_,
   {{0x727e9115,0xf25af2b0,0x6ecd0212,0xbc52710b}},	//   _amand_, _bugle_, _akanalun, _byatera_,
   {{0x9da9a272,0x69f8c086,0xf290c01f,0x1529a2b1}},	//   _apropria, _movablet, _kadai_, _apropriy,
   {{0x8e177064,0x9290c14a,0xc3a30079,0x729112b2}},	//   _中华人民共和国商, _sadak_, _akapar_, _mazat_,
   {{0x70f5a2b2,0xc368d2b3,0x598022b4,0xaab1606c}},	//   _अप्रेल_, _ringkas_, _ब्रम्ह_, _जगदीश्वर,
   {{0x4291e1d5,0xfc8492b5,0xb464a2b6,0x235c20c2}},	//   _pitam_, _interred_, _toleranz, _тәлмәрйе,
   {{0x3dc5d078,0x63f9f057,0xfa8e92b7,0x13f9f21c}},	//   _ابراج_, _putut_, _kwanakin_, _mutur_,
   {{0x82905039,0xfbd3613d,0x12fb5004,0x83f472b8}},	//   _ialap_, _feldkirc, _bathara_, _opstel_,
   {{0x2b4f02b9,0x9cb6b1d9,0xe29072ba,0x52d912bb}},	//   _সাম্প্ৰত, _تالاستى_, _kanas_, _babedi_,
   {{0x13f8911d,0x737b8112,0xd2b591bd,0xb291819e}},	//   _makumi_, _semalam_, _desce_, _pirau_,
   {{0x729070c3,0x124902bc,0xd159910f,0x469a20e5}},	//   _danas_, _teamet_, _ہوشیار_, _chomikuj_,
   {{0xa8a321e6,0xf291819f,0x1292119e,0xe25ad026}},	//   _प्रशान्त, _firas_, _hapati_, _stelt_,
   {{0x2edec0f8,0x1bce7083,0xac685041,0x42921004}},	// [150] _нинди_, _бюджетти, _naluphi_, _kapati_,
   {{0x3721b1f0,0xb17d2094,0x1249822d,0x4267d176}},	//   _тәрбиә_, _arratsal, _warme_, _ایرونی_,
   {{0xac5ca2bd,0x7f5e92be,0x1af7a1b9,0x538d1004}},	//   _bontril_, _campeona, _заманса_, _properti_,
   {{0xa3ea92bf,0xe23112c0,0x12b4e200,0x02d5b262}},	//   _agati_, _asamaan_, _jinchu_, _gakondo_,
   {{0x729072c1,0xf2d8c2c2,0x8175e2c3,0x1c301123}},	//   _sanat_, _maleni_, _рудный_, _konsitis,
   {{0xd291816f,0x031d913f,0x129052c4,0x520240f9}},	//   _diras_, _ניצחה_, _balap_, _meting_,
   {{0x125a6094,0x33009134,0x1c2612c5,0xd644a2c6}},	//   _urola_, _baqalah_, _ressursb, _inricchi,
   {{0xf38002c7,0x553ce114,0x959c01c5,0xd1dec0be}},	//   _poprad_, _sekirany, _beluspik, _realizim,
   {{0x3b9802c8,0x2ee3d231,0x929070cc,0x24e6b0d7}},	//   _sosialur, _पृथ्वीरा, _ganar_, _янындагы_,
   {{0x32cae0f9,0xd291e1d8,0x1ad852c9,0x148042ca}},	//   _hendan_, _nitah_, _filminin_, _باتۇۇعا_,
   {{0xafc2c2cb,0xb19f810f,0xf24942cc,0xf4ad62cd}},	//   _بارود_, _استقبالی, _teemat_, _vollstän,
   {{0xa20182ce,0xdda112cf,0xe30412d0,0xf2918030}},	//   _anyika_, _didomina, _emtasol_, _bazasi_,
   {{0xc2907054,0xa2918101,0x575612d1,0xa6423171}},	//   _janar_, _pirat_, _سالنامه_, _ushiriki,
   {{0x2f322244,0x423c90b2,0x729e123c,0x9004b171}},	//   _ikirasip, _vammeej_, _питам_, _تندرستي_,
   {{0xee5162ab,0xab92d12a,0xe5d3f2d2,0xa4b5f0aa}},	//   _patarima, _cojiendo_, _manchmal_, _arabitek,
   {{0x5eab812e,0x56c3a03b,0x826cd0c8,0x796d608b}},	//   _systemie_, _angasayi, _malonu_, _ambiyant,
   {{0x5c51f148,0x43f890a0,0x525bf267,0xe2eff02a}},	// [160] _contona_, _kakubi_, _atule_, _scuff_,
   {{0xc2dd22d3,0xb2b6715c,0x929072d4,0x0bbb6126}},	//   _bavouti_, _luucht_, _hanaq_, _minkakho_,
   {{0x827f7126,0x8d198009,0xe8c7d224,0x613cb1f0}},	//   _mbanna_, _различны, _boitemog, _профсоюз_,
   {{0x629072d5,0x6b492231,0xa2024157,0x085c92d6}},	//   _sanas_, _इर्ष्या_, _beting_, _kataster_,
   {{0x63f4618b,0x2c9b712f,0x825ea2d7,0xe2cae1cf}},	//   _gautam_, _كۈنگەي_, _bagolodi_, _dendan_,
   {{0x837c70ff,0xa0e752d8,0x82fcf149,0xe2b4d15c}},	//   _locatie_, _kulindel, _haight_, _bleck_,
   {{0xe20180ef,0x237902d9,0x76f382da,0x2c3c2200}},	//   _muziki_, _ansaana_, _tentokrá, _happersb,
   {{0x74c72155,0xfb360105,0xc25b62db,0xae46b2dc}},	//   _ئاپئاق_, _בייעסד_, _daglar_, _tatangga,
   {{0xa26ce237,0x23dc02dd,0xb15140a7,0xe6670024}},	//   _aviona_, _atiwe_, _hristovo, _रेफस्य_,
   {{0x429072b7,0x0b5ed2de,0xf2d990f5,0x7742d2df}},	//   _ranar_, _храна_, _essen_, _johnsonv,
   {{0x564012e0,0x52907054,0x5c05a016,0x0236e02d}},	//   _abanyarw, _sanar_, _kuasmuv_, _sinjal_,
   {{0xb290701f,0xdaac52e1,0x2f891030,0xb26c22e2}},	//   _yanar_, _adekanmb, _шерали_, _sekou_,
   {{0xc6d5024c,0x4c08b030,0xd3659094,0x1445e2e3}},	//   _رنگیٖں_, _قوتاردی_, _oxigeno_, _नवरात्रो,
   {{0xb2cf82e4,0x4cf502e5,0x22905294,0x9b57f083}},	//   _afamily_, _ostatnýc, _oblat_, _таратуу_,
   {{0xeaa592e6,0xc2d46225,0xcfed7207,0x6113f0fc}},	//   _सुन्दरता_, _jardim_, _markalar_, _техникаһ,
   {{0x602a9230,0xd015b086,0x7fc812c8,0xa17db065}},	//   _midfrysk_, _muiderpo, _stongdur_, _ניחוח_,
   {{0xd35752cc,0x420062b1,0x038c82d6,0x624122e7}},	// [170] _कल्ले_, _aplik_, _čistenie_, _akamwini_,
   {{0xd88961f7,0x52008098,0xc213e089,0x06543132}},	//   _комитеты_, _bakica_, _moths_, _алтчева_,
   {{0x5c351057,0x062b12ab,0x8c00d264,0x42c742b5}},	//   _descrier, _susitari, _وخالد_, _deplore_,
   {{0x9721b2e8,0x1e15314a,0xd2da518a,0x63a620bf}},	//   _riarachá, _dareemaa, _cateva_, _евроитти,
   {{0xe29182e9,0x4273700e,0xb7f7511b,0x3ca41065}},	//   _virar_, _güney_, _културни, _סטארמד_,
   {{0xc2ca32ea,0x763760c9,0x326cd1f6,0x936bf009}},	//   _hajde_, _властиво, _kolory_, _строку_,
   {{0x8c683036,0xaf5c403c,0x1290a242,0x9291a07d}},	//   _доставка_, _abbastan, _dabas_, _aipas_,
   {{0xc04832eb,0xab0260c6,0xc291a1d8,0xe2918137}},	//   _лукошенк, _anisoade, _sipat_, _hirap_,
   {{0xe27e02ec,0x92901199,0x96cd8130,0xf27d7192}},	//   _gmina_, _uchaf_, _mampalah, _тамашасы_,
   {{0xae8a8030,0x1c6241ce,0x926de285,0xe249807b}},	//   _билдирил, _charice_, _bizinesi_, _harma_,
   {{0x4290a173,0x67c0a07f,0xf2cae059,0xe3ef313e}},	//   _habar_, _аахәоуп_, _tandas_, _hipotecz,
   {{0x429010c7,0x6210821d,0xa4fb921d,0xc291a005}},	//   _nahay_, _उदाहरणम्_, _अपवादः_, _tipas_,
   {{0x92cae2ed,0x1290a07d,0xdb0e92ce,0xd36142e9}},	//   _vendin_, _sabat_, _apostola_, _bangdaj_,
   {{0x6ccc22d1,0x47e44267,0x4a7cf06a,0x39018041}},	//   _ئیزنی_, _gioburug, _rekayasa_, _افراسیاب_,
   {{0xb2da6077,0x030dc012,0xf290a0d7,0x53d2126c}},	//   _aarewa_, _kumbuka_, _qabat_, _hormonsk,
   {{0x42e770fa,0x83f89294,0x2378d2ee,0x0e8b8121}},	//   _zasniva_, _dhaus_, _zamanin_, _निहत्था_,
   {{0xf4d771df,0x2dcf409c,0x329012aa,0x3290a0b1}},	// [180] _אנציקלאפ, _lightest_, _mahay_, _gabar_,
   {{0x827a42ef,0xfd5742f0,0xa3e8c11e,0xc29071ab}},	//   _persoonl, _व्यग्र_, _effectiv_, _sanay_,
   {{0x5c6e3064,0xea90f1ad,0x6d0fc21f,0xb03ff083}},	//   _我来说两句_, _counterb, _anstreic, _seguimen,
   {{0x427862f1,0x7290a038,0x26c6f1d8,0x2ae0a009}},	//   _ubundi_, _kabar_, _kapanggi, _nokuvuse,
   {{0x6290a243,0xb1e1217d,0xd6b7510e,0xea4d92f2}},	//   _jabar_, _движения_, _obserwow, _dondurma_,
   {{0x0290a28c,0x512d22f3,0xd2baf199,0x01c552f4}},	//   _dabar_, _расте_, _enwedig_, _автомата,
   {{0xb291a0ec,0xc2498147,0x829011ab,0xd2907177}},	//   _sipas_, _farma_, _bahay_, _tanay_,
   {{0xf3f1b110,0x22918136,0x610902f5,0x1210b212}},	//   _layering_, _garai_, _eotoroña, _طرزالعمل_,
   {{0xe83d417d,0xe28382f6,0x64daf0ac,0x0d87f1a1}},	//   _достижен, _mushiki_, _인터넷으로_, _inimumma,
   {{0xf16962a1,0x726c2030,0x655462f7,0xd98e31aa}},	//   _perintah_, _bekor_, _ﺳﯧﺪﯨﻖ_, _галин_,
   {{0x3291b11d,0xfb321212,0x03d79048,0xe2e301f3}},	//   _havasi_, _همدلته_, _dědictví_, _bennük_,
   {{0x17161050,0xe290a176,0x53787062,0xf2f0f177}},	//   _答案是否定的_, _babar_, _tigaina_, _assimah_,
   {{0x027860ae,0xc360d290,0x8a34d14c,0x3a44b2f8}},	//   _iyunda_, _interfej, _এলসিডি_, _josevata_,
   {{0xdb7be0a1,0x8856b12e,0xa291a00d,0x1b5012f9}},	//   _bangoran_, _मातृभूमि_, _sipar_, _akamuher,
   {{0x7290f2ce,0x129182fa,0x4ab3b261,0x88437035}},	//   _tshama_, _farai_, _salvezza_, _partijas_,
   {{0xedd7b0af,0xa3ea02fa,0x53f402fb,0xc2da62fc}},	//   _roskilde_, _waita_, _partaz_, _careva_,
   {{0x0c9332fd,0x326e52fe,0xe97960d2,0x829782ff}},	// [190] _نادات_, _intoke_, _грузияны, _blogalác,
   {{0xc52de009,0xe2aee056,0x72eb2115,0x82f052cd}},	//   _позволяе, _porantšh, _aranés_, _polizei_,
   {{0x526e7300,0x92e9515b,0x4c4b1202,0xff2a8301}},	//   _mirout_, _didiman_, _bentang_, _rastisla,
   {{0xa2927075,0xff0e32f4,0x3c188005,0x03145302}},	//   _naravi_, _хараахан_, _dizainer, _henblik_,
   {{0x23bb32a7,0x4290a063,0xb6afd1a1,0xd6dc40a8}},	//   _اسمار_, _xabar_, _enteredw, _ह्विल_,
   {{0x704dc00f,0x42241303,0xb37a6304,0xf26c4305}},	//   _проти_, _справ_, _lawatan_, _hemos_,
   {{0x120ec277,0x2ba92094,0xa290f262,0x1bd7b118}},	//   _пазар_, _merkatar, _ishaka_, _wandswor,
   {{0xc30ec280,0x2f4d90bf,0xa28b5122,0xa3eb4040}},	//   _combien_, _ташланди_, _traversé_, _chetoj_,
   {{0x14043306,0xbd11a175,0x42b66272,0x3c7cd307}},	//   _okungenz, _valorize_, _circul_, _ramsden_,
   {{0xd2ca52b9,0x4861024f,0xe3875020,0xe51d2125}},	//   _halde_, _parnaaru, _aceray_, _batuyemo_,
   {{0x2946624c,0xf27e8308,0xe241d23c,0xb29182ad}},	//   _خداوندی_, _adinax_, _дестинац, _parai_,
   {{0xfc801083,0xc8505013,0x76c6f202,0x498ae0d7}},	//   _берем_, _emboscad, _papanggi, _canın_,
   {{0x1cf4c0a6,0x0eb84309,0xc627b30a,0x6e10814c}},	//   _कथाकार_, _bimejnis_, _dediketi, _ব্যঙ্গ_,
   {{0xf291c30b,0xca0e524f,0x92e8e079,0x22e65176}},	//   _divas_, _soraarne, _ckliyan_, _alengka_,
   {{0x92da630c,0xaaba8086,0x5290c01f,0x88fc124c}},	//   _pareva_, _schwerdt, _hadar_, _safaarad,
   {{0x63f1430d,0x730e60af,0x69afa031,0x5965c30e}},	//   _importaz, _悩みを聞いて_, _በመደወል_, _stupňů_,
   {{0x5cdae2c7,0xa1d2818b,0x12b400e8,0x53f821d4}},	// [1a0] _katalóg_, _solemnly_, _ulicy_, _ikkut_,
   {{0xf290c0b0,0x498ae0d7,0x653711e6,0x5b89b231}},	//   _padat_, _sanın_, _समुदायस्, _ogrodnic,
   {{0xb26c428c,0x9fe0830f,0x2c63611b,0xf9a7d0f7}},	//   _temos_, _संयुक्ता_, _povukao_, _如对稿件内容有疑,
   {{0xf3eb7055,0x937a6310,0xd668f277,0x99ecc064}},	//   _tratta_, _jawatan_, _присуств, _魔兽野怪介绍_,
   {{0xc291c0d0,0x80b8009a,0xec28e311,0xde1ac312}},	//   _pivat_, _بەدەن_, _маслахат, _diberika,
   {{0x1e7d40ea,0x12bb603b,0x28ca1115,0x7b35b07c}},	//   _पुर्व_, _ammelwe_, _cherchav, _стихотво,
   {{0x9290a007,0x40aa3223,0xa26cf123,0x835550dc}},	//   _abban_, _دراوڙي_, _degou_, _repetit_,
   {{0xd2927313,0x483a30c7,0x2290f2f1,0x4b1c7314}},	//   _qaravi_, _ارساتھ_, _ashaka_, _označení_,
   {{0x429180a4,0x1643a17d,0x70c8205b,0xd2027315}},	//   _marau_, _musiikki, _chlorofl, _aisida_,
   {{0x6290a316,0x63a96056,0x02903317,0xbc052087}},	//   _sabay_, _lefaseng_, _romant_, _bokstav_,
   {{0xd1b442ae,0xbc17528b,0xd7dc1061,0x326d91fc}},	//   _enamasti_, _belabber, _ميرواهه_, _neson_,
   {{0x8bd6a026,0xf20fb1bc,0xe29a30bf,0x4c5bf055}},	//   _광고제휴문의_, _كوپلىت_, _ваколатл, _pastori_,
   {{0xa3dc9202,0xc27f4318,0x82905040,0x9b1ae228}},	//   _atawa_, _icenda_, _ablah_, _sampurna_,
   {{0x6290f262,0x726d92ed,0xd9edc036,0x026dc272}},	//   _ushaka_, _beson_, _sinistra_, _sinistri_,
   {{0x791b7319,0xd201b22e,0x26a5131a,0x2eb7a10b}},	//   _quán_, _rovigo_, _oktuktah, _akarenge_,
   {{0x3a8f131b,0x8201a31c,0x34efd0ac,0x9213e187}},	//   _amazwana_, _ispis_, _관련사이트_, _dothi_,
   {{0x32ca72e2,0xb7d8c075,0x19f4331d,0x13eb1100}},	// [1b0] _mande_, _današnji_, _limón_, _pectin_,
   {{0x33a2d1a7,0x3a6a52f4,0xc3ead314,0x01633124}},	//   _propri_, _харамсал, _filtry_, _сухум_,
   {{0x96824121,0xe291c2c1,0xf27e631e,0x8980714c}},	//   _भुलाई_, _sivas_, _amone_, _দাঁতের_,
   {{0x23f28232,0x22927024,0x16118234,0x0859e31f}},	//   _عبدالحکی, _harati_, _klientom_, _naturais_,
   {{0xc22ac225,0x37cf9043,0x737901d8,0x925a0320}},	//   _добар_, _varsinki, _misalna_, _usilk_,
   {{0x67ccb026,0x5e6a12f7,0xfe5cc115,0x6b7e5321}},	//   _노튼주니어_, _торда_, _probabla, _kanukoka_,
   {{0x25a00050,0x229181ed,0xc27e001f,0x3290e322}},	//   _一下班他就飛快的, _karau_, _aminu_, _cafat_,
   {{0x5291e323,0x32918217,0x6290e0b3,0x1c0d7241}},	//   _zitat_, _marat_, _vafat_, _cumpere_,
   {{0xb29ec1e2,0xaa8b5324,0xc5aa3248,0xed3880bf}},	//   _дидан_, _gustaría_, _ኣፋፍኖት_, _рахимаху,
   {{0x528a7285,0x42c6b325,0x8b03c2bd,0xd2c59326}},	//   _mutabani_, _aarlige_, _моделе_, _abelele_,
   {{0xe3dc924e,0x4290c177,0xdfedd00d,0xb2af4214}},	//   _utawa_, _wadar_, _bologër_, _اۋىسىپ_,
   {{0x2025c15d,0x020661ef,0xf2e78245,0xec6780f6}},	//   _سواری_, _bukibuki_, _asinawo_, _ruhunda_,
   {{0x0a93c1bf,0x4c177005,0xc0ec0065,0x33cc2065}},	//   _доведи_, _buhalter, _טלנסקי_, _הלוחמים_,
   {{0x9d85e285,0xe2ca70bd,0x02faa1d2,0xe15f1327}},	//   _makerere_, _hande_, _bakhwan_, _aburúmok,
   {{0x5290c039,0x19c722c3,0xa2dc909c,0x19b49008}},	//   _jadap_, _парасат_, _amboofi_, _гутулуп_,
   {{0xf7d64328,0x14964328,0xd290c2ae,0x573ad28c}},	//   _pimaklug, _pimakluk, _padar_, _мозгу_,
   {{0xc290e030,0xe290c268,0xc7ad10bb,0x22dc3329}},	// [1c0] _nafar_, _qadar_, _kulturhi, _assembli_,
   {{0x39ade276,0x01c61121,0x93ea0297,0x08d8c17d}},	//   _تجربو_, _आत्मीयता_, _caite_, _kansainv,
   {{0x4d3fb135,0xd291814a,0xf291e2ee,0x22d9f32a}},	//   _ስምዒትን_, _garat_, _fitar_, _truer_,
   {{0xe614e042,0xe2927063,0xe96c02d7,0xb4ff632b}},	//   _tivessem_, _kurash_, _bodiphat, _monmouth,
   {{0x6b038319,0x07662214,0x4320e03e,0xc0aa10a2}},	//   _petrovie, _ءﺑﯩﻠﯟ_, _ariyan_, _فرعوني_,
   {{0xf354932c,0xa9dff085,0x336e30d0,0xfdcdd140}},	//   _sejenis_, _তাইওয়ান_, _qangalu_, _солдатла,
   {{0x541d708c,0xe2bfb10f,0x00b0d096,0x69b17159}},	//   _verstaan_, _mondjuk_, _گریجویشن_, _rendelet,
   {{0xcc27532d,0x529021c9,0x33a2f32e,0xadf7c32f}},	//   _kulaputr, _inmate_, _skipar_, _сайвалӣ_,
   {{0x5291800d,0x83ea001d,0xb302a223,0x87207330}},	//   _waral_, _baite_, _angalau_, _中国人居环境奖_,
   {{0xb25ad067,0x29c511b3,0xc1bc8241,0x02cc2143}},	//   _trela_, _interrat, _дистинже_, _alaliyo_,
   {{0x42b672f5,0x13006032,0x0e679331,0xf25a0332}},	//   _frucht_, _vonandi_, _redaktør_, _usila_,
   {{0xf29050c7,0xd29180fb,0x7df82009,0xf2903114}},	//   _galay_, _naram_, _версии_, _kilang_,
   {{0x6e6ac1d9,0xd9f32333,0xed332333,0x759a2012}},	//   _болды_, _agencija_, _agencije_, _ترجماني_,
   {{0xcc168231,0xca30f085,0x02006334,0x2290e238}},	//   _मुद्रास्, _স্টিকি_, _nplij_, _dafar_,
   {{0x627e90cf,0xa2905100,0xd3eb212a,0x52cc0289}},	//   _umano_, _balay_, _factos_, _kerlenn_,
   {{0x20f520ea,0x017870df,0x1c6232d4,0xa3ea905e}},	//   _अप्रिल_, _againway_, _braulio_, _haate_,
   {{0x57d3a2e8,0x12eac335,0xc26cb0cb,0xfc5a9336}},	// [1d0] _نيويورك_, _grondas_, _ofcom_, _akataki_,
   {{0x8b602337,0x70d9e338,0x93549339,0xe95330d7}},	//   _लगानी_, _zaboravl, _indekss_, _кысып_,
   {{0x1291a332,0xa85fa054,0x8b823039,0x8290e33a}},	//   _kapau_, _mujallar_, _khanapar, _zafar_,
   {{0x6290306a,0xfb7e60ec,0x33eaf113,0x6c82f316}},	//   _bilang_, _profilin_, _saites_, _kimerald_,
   {{0xd2d9125d,0x914ed02a,0xe27e933b,0x22e3e1a1}},	//   _babeli_, _dictatio, _gmane_, _infoway_,
   {{0xd4095262,0x32b4029e,0x1343c1bf,0xcc43a1f6}},	//   _amagambo_, _voici_, _колорат_, _पनडुब्बी_,
   {{0xae36c1dd,0x02cad0a9,0xb4f6f309,0xb248c1fa}},	//   _matavuva, _faldas_, _arimatlh, _akomba_,
   {{0x4ce7f1f0,0xb836f17f,0x7921a0b5,0x1f89c33c}},	//   _башлығы_, _матрах_, _مەرمەر_, _сенати_,
   {{0x5459c33d,0x52918113,0xb6fd715d,0x63c0b0e5}},	//   _objetivo_, _varam_, _اینست_, _हनुमानगढ,
   {{0xa822f1b6,0x2228e0f8,0x7e27233e,0xba41221d}},	//   _འཕྲིག_, _советлар_, _sungguhp, _सानुबन्ध,
   {{0x2b8c91ba,0xb5391186,0x93806083,0x7c5ec33f}},	//   _attivato_, _bagilish, _hauria_, _fistful_,
   {{0xcb8ac340,0x40c37030,0x0fbf3096,0x294c906e}},	//   _сокот_, _اگوست_, _رحمتہ_, _अनुक्रमे_,
   {{0x2291e2c1,0xbc1e7248,0xd292114f,0x1e71913e}},	//   _kitap_, _መንግስቲን_, _tapati_, _शिष्ट_,
   {{0x2bfe4341,0x2dcdc0d2,0xe380619e,0x7c5371ff}},	//   _kwitchib, _коалиция, _mauria_, _बुलेट_,
   {{0x8291800d,0x5681c13e,0x3283c263,0x3c7c8342}},	//   _yaram_, _हत्थे_, _субхи_, _seisean_,
   {{0x02918322,0x4aeda2d7,0x4e123022,0x9a49a0c8}},	//   _qaram_, _bafuduge, _ءدىني_, _гайдукев,
   {{0x7d996258,0xe2d8e2d5,0x2200724a,0xd291a0ec}},	// [1e0] _slagelse_, _ainean_, _opnij_, _hapat_,
   {{0x874e2040,0xb2b4601a,0x0291c343,0x43f9f063}},	//   _undiscov, _blocs_, _savai_, _ustun_,
   {{0x136570c3,0x2d8be152,0x57cc0065,0xdb77a344}},	//   _drugima_, _европы_, _ופתאום_, _akaranga_,
   {{0x1857a2a0,0x9c16014f,0xf3eb0345,0x1ca8b0fd}},	//   _ڵیاندا_, _पूर्णात्, _saates_, _materyèl_,
   {{0x025b4013,0x07d26253,0x6cf7e21d,0x46fc1282}},	//   _adelio_, _amagalog, _बालकाः_, _באליבטער_,
   {{0xa291e18b,0x12786203,0x069a6248,0x1569e346}},	//   _citap_, _obungi_, _ይረኣየካ_, _ngawengk,
   {{0xf291832d,0xd2cae31f,0x9c67c17d,0xa2918177}},	//   _param_, _bandas_, _телефона_, _marak_,
   {{0xe2925015,0xf39310f7,0xdd20b0f7,0xc2921246}},	//   _watapi_, _分享知识和经验_, _政府工作报告_, _sapati_,
   {{0x62911030,0xee1032f7,0xaa7b5347,0xcea4f083}},	//   _nazar_, _җәнубий_, _balonces, _novetats_,
   {{0x0a14117a,0x125a017f,0x7c66b348,0xd9d03008}},	//   _dynastie, _isilo_, _surtout_, _велин_,
   {{0x0291101b,0x1003a1c8,0xdeff1349,0x120e31d9}},	//   _hazar_, _הנמען_, _silkedyn, _талай_,
   {{0x32ee834a,0x2a6f8018,0xe40862c3,0x52cb0049}},	//   _abanini_, _alegerea_, _بويلاي_, _acadou_,
   {{0xdb9a22a4,0x0236934b,0xfd472214,0xe23770db}},	//   _napisano_, _ndaje_, _تۇسۋگە_, _arajwe_,
   {{0xaaf4f34c,0x12d98032,0xc29110d3,0xf280514f}},	//   _dissabte, _skref_, _cazas_, _anindā_,
   {{0xb3dc92f1,0xd155034d,0x0d9ae34e,0x195ae34e}},	//   _ntawe_, _kharbudo, _abangcwa, _abangcwe,
   {{0xec03d0b5,0x5279534f,0x93f0a350,0x005910ee}},	//   _телеарна, _hamanirm, _polopenz, _kapacito,
   {{0x3200801f,0x1daab17a,0x038070d2,0x33f8c351}},	// [1f0] _hakika_, _ক্ষেত্ৰৰ_, _correu_, _tulung_,
   {{0x3b9a212a,0x7223d352,0x12e95256,0x615631b5}},	//   _capitano_, _شدارن_, _batinya_, _залынан_,
   {{0x129b1264,0x92113353,0x4916f354,0x2291e336}},	//   _أكلات_, _vinkovci_, _giubileu, _fatai_,
   {{0xf2008355,0x72918134,0xa38b8159,0x5412124e}},	//   _dakika_, _marah_, _sárga_, _mbenakak,
   {{0xe25a90e7,0xb755230f,0x62da0161,0xd2d4c356}},	//   _arali_, _कनिष्ठ_, _rapera_, _hailuku_,
   {{0x31d7d357,0x5a605121,0xac6701d8,0x8d3a2242}},	//   _urnedtay_, _tellimus, _nyorang_, _filiāles_,
   {{0x386982f8,0x730df356,0xace8b358,0x37f15180}},	//   _tinikaru, _baibala_, _доставки_, _この商品のカスタ,
   {{0xb2e82359,0x0cbc30d0,0x6e60818b,0x754e1030}},	//   _içinde_, _angiriaq, _harbhaja, _фитна_,
   {{0x3290a023,0x3d9d018a,0xa25a901a,0x8200f35a}},	//   _abbah_, _raportea, _quals_, _ihiihi_,
   {{0x347ca1a0,0xc2918146,0x1c609059,0xd2f5a09b}},	//   _begespik, _barah_, _mahukan_, _nemirik_,
   {{0xb7ffc35b,0x89d2235c,0xe96b50f5,0x661e723c}},	//   _одного_, _aaresist, _meinunge, _connessi,
   {{0xb3ea22c5,0xe5fc135d,0x99e0a35e,0xad20a35e}},	//   _sakte_, _selecció, _adaidzwa_, _adaidzwe_,
   {{0x43ea020d,0xe2cac2c1,0xdd74310d,0xe200c35f}},	//   _baita_, _madde_, _пустым_, _palivo_,
   {{0x6d623291,0x2127109a,0x5f25419a,0x385c1360}},	//   _قديمي_, _матори_, _offerynn, _سیفٹی_,
   {{0xc291e19e,0x45964200,0xd51030f7,0x2703a227}},	//   _patai_, _iwrupank, _出口许可证管理分, _아이스크림_,
   {{0x22c3f11b,0xb2ef00fc,0xf2d8e1ad,0x5294624b}},	//   _користи_, _loafer_, _afield_, _отправля,
   {{0xb6c920fa,0x42918146,0xcff4d005,0x6bfc51b5}},	// [200] _ustašama_, _zarah_, _techniko, _премьері_,
   {{0xc27e9361,0x3a2fb12f,0x0b7c10f7,0x37ece28d}},	//   _imana_, _نوكىيا_, _如果您没能找到需, _achasung,
   {{0x6291813c,0xe843f2ab,0x9291a136,0x2230d238}},	//   _karai_, _baltijos_, _mapak_, _mammenn_,
   {{0x12911359,0xcc93312f,0x9291510c,0xc2f0400c}},	//   _yazar_, _تامام_, _bogare_, _aumiumi_,
   {{0x73f402e2,0xc2c44176,0xd28350a8,0x82918291}},	//   _jistis_, _nyambut_, _आफूहरूले_, _marai_,
   {{0x529f9221,0x3e3d0225,0xa2f7e038,0xb2917077}},	//   _kunjalo_, _картички_, _arsitek_, _alaaye_,
   {{0xe16c6217,0x86d6b1c7,0x93f8905e,0x216391ba}},	//   _проценты_, _باقشاسى_, _akauu_, _istruzio,
   {{0x227e9076,0xdc66420f,0x1344f362,0x9f630243}},	//   _omana_, _tutulub_, _izvedbe_, _wilayahn,
   {{0x230c40c4,0x72af0224,0x426d2348,0xf291c363}},	//   _impamvu_, _kopantšw, _école_, _vavau_,
   {{0x52ca701b,0xe3dc4262,0xec756128,0x6248e077}},	//   _sanda_, _kumwe_, _inquest_, _abomey_,
   {{0xd291c027,0xe8828144,0xdaebf2a9,0xc2da5364}},	//   _tavau_, _anginaku, _apotheke, _diteli_,
   {{0xc6d00232,0x82911359,0xecb132a0,0x335701fc}},	//   _ephakami, _pazar_, _زمانێک_, _disfala_,
   {{0xc2913027,0xc05a2365,0x0c7c40d2,0x62e97366}},	//   _taxas_, _dabararo, _carrers_, _harinya_,
   {{0x92ca7054,0x68cdf07e,0xac0ea1e0,0x42fd530d}},	//   _wanda_, _samtidig, _corpore_, _haggle_,
   {{0x0237f067,0x32ff4367,0x52ca526e,0x6236d21c}},	//   _ajuju_, _maribor_, _valdo_, _idejn_,
   {{0x5246d20d,0x08972030,0xd2e31368,0xae2c81e8}},	//   _интернэт_, _غریبی_, _filipae_, _посовету,
   {{0xd16630e5,0x5291c2c9,0xb37a10a5,0x7354f369}},	// [210] _प्रतिबंध_, _davam_, _pasaran_, _devenit_,
   {{0x1983a140,0x36a7c009,0x3234212f,0x924a4068}},	//   _элеккеге_, _несмотря_, _سىمۋول_, _automasi_,
   {{0xb22660ed,0xc27e9171,0xe407e23c,0x72027115}},	//   _akukho_, _amani_, _градове_, _aisina_,
   {{0x7e9fb36a,0x0aaa7083,0x2394736b,0x5f2d51ab}},	//   _módulos_, _بۉتكۉل_, _sonst_, _kahuluga,
   {{0x28d6d15e,0x1e71536c,0xec1de23f,0x1394736d}},	//   _estrateg, _छ्द्म_, _arquebis, _conss_,
   {{0x62918008,0x6c62021d,0xc202705c,0x0e25136e}},	//   _tarap_, _abruvan_, _visina_, _gyllideb_,
   {{0x96960362,0x22497071,0xe37f8262,0x5d31836f}},	//   _izvedeni, _neamde_, _mihanda_, _borisefe_,
   {{0xa290a0c1,0x02ab12b8,0xd7ecc202,0xc26d9370}},	//   _gabay_, _leiding_, _panalung, _қарабоғи_,
   {{0x3290129e,0xd2b730c8,0x990b9190,0x372ce192}},	//   _achat_, _другім_, _delainau, _урмандар_,
   {{0x62901027,0x374ab35f,0x1a8ab371,0xbde9c15a}},	//   _schau_, _upozorni, _upozorne, _अनुष्ठान_,
   {{0x72e39163,0xdbda2140,0x5290a0d7,0xfb4eb140}},	//   _entidad_, _базарынд, _babay_, _ostaları_,
   {{0x939470d8,0x4200e316,0x23ea9345,0xa1f8e210}},	//   _innse_, _ganito_, _saata_, _ultiplem,
   {{0xa213e1e2,0x3b0f41c0,0x2283d215,0xdb6e21b1}},	//   _lithe_, _rispetta_, _tenkova_, _kartalla_,
   {{0x2291a1e4,0x2025c12f,0x59e3c372,0xcb5632ea}},	//   _hapai_, _ئوغرى_, _fotonaka_, _themelor,
   {{0x53ea91e7,0xb98da13f,0xa27ed187,0x8290a004}},	//   _vaata_, _מיילי_, _amene_, _endang_,
   {{0x6d8c5373,0xa2027374,0x62e9d263,0x63ea9322}},	//   _རྒྱོབ_, _tisina_, _мемонад_, _waata_,
   {{0x5b709044,0x83f09044,0xcd6a4030,0xfafa5320}},	// [220] _tauranga_, _taurangi_, _болалари_, _phanvien_,
   {{0xd638f375,0xe3ea2200,0xa2ca7195,0x7c08b010}},	//   _шаралары, _jakta_, _jando_, _resorted_,
   {{0x59fd905d,0xd2da719e,0x73ea2376,0x6acaf159}},	//   _situaziu, _tireni_, _dakta_, _látogatá,
   {{0xb9c7e377,0xc2ca716f,0xfc045378,0xcc773191}},	//   _निश्चिंत_, _lando_, _vinstri_, _kinsale_,
   {{0x4169119a,0x0c00d113,0xfaea628b,0x0eaf21f6}},	//   _pennaeth_, _gaismas_, _fertelle, _कनेडियन_,
   {{0xb27e634d,0x6053d251,0x5347805e,0x9c948248}},	//   _klong_, _мобилен_, _vahenga_, _ሓንጸጽቲ_,
   {{0xc291e246,0xf051d20e,0x877f50ac,0x822f3065}},	//   _tatau_, _услови_, _서울대학교_, _קופירייט,
   {{0x33ac5075,0x13eb01d0,0xca02f243,0xcc4b7188}},	//   _župan_, _ebates_, _tetangga_, _geltung_,
   {{0x13dc00fe,0x32da5163,0xb2df7030,0xe25b02f4}},	//   _ariwe_, _matera_, _kamolot_, _ahalik_,
   {{0x32ca7379,0x751090a1,0x3302b11e,0xd37b6124}},	//   _cando_, _sarrango_, _herbage_, _аҭыӡқәа_,
   {{0xb2dc21dd,0x5cf1637a,0x995ce367,0xbc60e0d8}},	//   _serekali_, _imiterer, _nadomest, _caluman_,
   {{0xd233d059,0xd2da5098,0xe5c3a023,0xcda64223}},	//   _olivenol, _gatera_, _angagayy, _kuruhusu_,
   {{0x73791187,0xd84720e9,0x22aba060,0x6c668252}},	//   _kupanga_, _карасин_, _beading_, _калышы_,
   {{0x1eeaa083,0xe2b4937b,0x12925171,0xb51090a1}},	//   _жайларын, _inace_, _hatari_, _warrango_,
   {{0x08e3b0c8,0x799d2008,0xc27ed0a7,0x8510937c}},	//   _кампаніі_, _барыш_, _smene_, _tarrango_,
   {{0xa0f1c0aa,0x7903306a,0x52fcf169,0x3f268287}},	//   _abazisho, _पुनरावृत, _fanger_, _канькі_,
   {{0x42317031,0xa855d0af,0x22e20100,0x0e42124f}},	// [230] _bermula_, _ああっ名無しさま, _kalidad_, _qulaanut_,
   {{0x937a637d,0xda060370,0x8b2c10dd,0x427e9067}},	//   _kawasan_, _ababelet, _speakeas, _mmanu_,
   {{0x0897d02f,0x09fcc0c2,0x53f1304b,0xc67ab1e0}},	//   _خرابه_, _иглин_, _asoslari_, _ingenium_,
   {{0x62fc737e,0x03e99008,0xfb02315c,0x7a7fa101}},	//   _funge_, _премиясы, _samschde, _linondas,
   {{0xd7e27016,0x9f3dd27b,0x526cd37f,0xcd095065}},	//   _cinplaim_, _क्षितिज_, _maloku_, _opposite_,
   {{0xd236d159,0xa412c375,0xd2081105,0x3e359380}},	//   _ideje_, _аванс_, _דעסקטאפ_, _ingleses_,
   {{0x82da5196,0xc80cc381,0x22181009,0x62027382}},	//   _batera_, _алаку_, _общая_, _jesite_,
   {{0x7291e1e6,0xee32c005,0xb2fc735e,0x02388223}},	//   _gatam_, _шкада_, _kunge_, _thamani_,
   {{0xde6ca340,0x02ca70a9,0x0675c0f7,0xf114c0d7}},	//   _облегчен, _pando_, _经典艺术片_, _ачкан_,
   {{0xa2e20104,0x6c781368,0x8fc32383,0x6336130d}},	//   _calidad_, _arestem_, _meninger_, _diskussj,
   {{0x22aba00a,0x326cd041,0x24f9610e,0x450a8248}},	//   _reading_, _kaloku_, _warunków_, _ብባዕዳውያን_,
   {{0xfae870a6,0xf644a063,0xdde830c2,0xe349d384}},	//   _अनुवादक_, _birinchi, _колхозда_, _modelov_,
   {{0xeb220385,0x72494124,0x22b1f386,0xc533d387}},	//   _walaupun_, _chemba_, _tendela_, _akingboy,
   {{0x5290c1fe,0xd29271e6,0x71bff14c,0x1394d103}},	//   _aaday_, _carati_, _উদ্যোক্ত, _choslu_,
   {{0x6290c177,0x329010d3,0x5d06e018,0xc290b0fd}},	//   _baday_, _schar_, _petrecer, _ladann_,
   {{0x83a8e039,0x10f4230f,0x03f431c0,0x037971df}},	//   _bhlalang_, _आक्रमक_, _virtù_, _stranga_,
   {{0xc25ad2b6,0x3e55c007,0x328f1111,0x23341252}},	// [240] _quels_, _دوستی_, _diskuto_, _مئليون_,
   {{0x776e816a,0x3ea6c036,0x22f0f01d,0xa290b27d}},	//   _universi, _направо_, _korinth_, _wadaan_,
   {{0x63dc924e,0xd29252a8,0x4b07301b,0xa9f08093}},	//   _utawi_, _tatari_, _себэп_, _hasilnya_,
   {{0x44133388,0x7e7b9050,0x9d9dc061,0x3a02b08f}},	//   _شاندن_, _一夜激情成人聊天, _پهچڻو_, _cerrigyd,
   {{0xe75a91b5,0x02a690ed,0xc2f990db,0x7e39412f}},	//   _قارامايد, _kwaba_, _aikhona_, _مەمتىمىن_,
   {{0x4395805d,0xf20101b3,0x959db2f2,0x52da6284}},	//   _forsa_, _habito_, _lisenziy, _laborar_,
   {{0xdfd3b264,0x120272ea,0x22a69186,0x6999c303}},	//   _وتقنية_, _burimi_, _mwaba_, _нелегко_,
   {{0xb2d51003,0x1c690213,0xe263d336,0x9a10736f}},	//   _millest_, _serruto_, _fofolahi_, _bosafele,
   {{0x0379b389,0x1641d041,0xc2da12d7,0x4c552267}},	//   _bayanin_, _abakwavi, _bapedi_, _ezitere_,
   {{0xac73a2bc,0x52d6738a,0x9ddc8307,0x8959108b}},	//   _averter_, _autojen_, _baskerla, _موازنه_,
   {{0xb291e1d8,0x39dd8307,0xa34a038b,0xdae5a25f}},	//   _matak_, _langstre, _gamethu_, _contrapt,
   {{0xf87cc38c,0x4202000b,0xb2927190,0x299480b5}},	//   _поставље, _kisimi_, _barasi_, _қыруар_,
   {{0x9386b0ff,0xec6b41ef,0xd36fa133,0x7c539034}},	//   _indruk_, _isausau_, _investuj, _lontano_,
   {{0x8291804f,0xf217209a,0x59aea22c,0xa290c0b1}},	//   _barat_, _орунда_, _middlewe, _salaan_,
   {{0x18f05009,0xb625204b,0x76b3912f,0x229182b7}},	//   _amaphrov, _moliyavi, _ﻣﯘﻫﻪﺑﺒﻪﺕ_, _maras_,
   {{0x227e9118,0x42025299,0xc2918052,0x427ed233}},	//   _ilang_, _ultimo_, _varat_, _omena_,
   {{0xb2918111,0x5248e38d,0xec1510fb,0x79e0814c}},	// [250] _faras_, _dhimma_, _संस्थाप्, _একদমই_,
   {{0x4a8b524f,0x9367412a,0x67a0d086,0x2ed41015}},	//   _hennings, _castigam, _carthagi, _allinnin,
   {{0x435321be,0x08d9d03d,0xb290c137,0x63fa7057}},	//   _مهمان_, _دزابل_, _talaan_, _masura_,
   {{0x53b7118b,0xceb89020,0x72ca5339,0xb968a2d2}},	//   _praveen_, _affordin, _galda_, _informie,
   {{0x025ad38e,0x955100ac,0x120272f6,0xe285d38f}},	//   _esele_, _자동로그인_, _rurimi_, _michiel_,
   {{0xcb42c11b,0x72ba72f5,0x97a861de,0x2abc9077}},	//   _екипе_, _camerad_, _nastavni, _alábojút,
   {{0xc29cf0b5,0x62ca7171,0xf4403144,0x70d42218}},	//   _ﺍﻟﺫﻴﻥ_, _pande_, _alikabik, _موفقه_,
   {{0x82ee02bd,0xa27ee1a3,0x525ad03e,0x52d9e0f8}},	//   _seife_, _dzinwe_, _isele_, _citez_,
   {{0x3365922e,0x43ea9390,0xddadb0c0,0xa849f248}},	//   _pangulo_, _baate_, _dolichop, _ብቴሌፍን_,
   {{0x93cb7009,0x42cac391,0x09d6f1a7,0x13730123}},	//   _соответс, _wadda_, _scheffle, _comanne_,
   {{0xc2918390,0x3290a392,0xb25a9149,0x22914393}},	//   _harar_, _sidang_, _usala_, _creado_,
   {{0x5291e114,0xb28c1394,0xb06aa0f7,0x4a39c022}},	//   _watak_, _anakcha_, _教育技术专业英语_, _железин_,
   {{0xe60cd283,0xc3eb4395,0xa37b2032,0x194b819a}},	//   _kutowati, _asetra_, _dagatal_, _etholaet,
   {{0xb2540019,0x6d77f005,0x7cb2414c,0xc4e8c0e0}},	//   _שאפינג_, _называюц, _আইনগত_, _adhastāt_,
   {{0x227ed2f8,0xbb60106a,0xa833b396,0x4e70f0e5}},	//   _emeni_, _परीक्षेत_, _eliminad, _कॉर्प_,
   {{0xa29182b7,0x20b7704c,0x02fc2065,0x9b977176}},	//   _farar_, _داشبورد_, _הלהקות_, _سايرين_,
   {{0x5201026b,0x02497397,0x7291e2c1,0xda0f3398}},	// [260] _mkaidi_, _nhamba_, _yatak_, _disputad,
   {{0xa25a9399,0x48c2639a,0x795e71bf,0x675fa105}},	//   _tsala_, _आउटसोर्स, _cheltuie, _אזאנס_,
   {{0x32925347,0x33ea600c,0x6057739b,0x9ff70221}},	//   _estaba_, _maota_, _akhaonto, _abayifun,
   {{0x0291a339,0x94aea0af,0xd2ea02e2,0xec6b30e5}},	//   _lapas_, _ショップで確認_, _dirijan_, _कार्ला_,
   {{0x9290e1fe,0x6bddd39c,0x62876395,0x6d609124}},	//   _dafay_, _ечилди_, _manaagem, _апресско,
   {{0x5d3922ae,0x1c70903e,0x4201139d,0x2291a004}},	//   _mobiilne_, _aderoju_, _nacija_, _napas_,
   {{0xc226739e,0x635f9084,0xfcffc39f,0x737fd392}},	//   _markat_, _adegoke_, _vidunder, _dilanda_,
   {{0x63ea9345,0x52d733a0,0x42fc60b3,0x02b60065}},	//   _saate_, _مکاری_, _yulga_, _בברזיל_,
   {{0x328e41a3,0xef83a16e,0x3f079030,0x72f2f139}},	//   _mashudu_, _функције_, _دانیشیر_, _addisuu_,
   {{0xf10cb121,0x59997026,0x8b82019e,0x220203a1}},	//   _तमाशा_, _미디어로그_, _kikokiko_, _kisiki_,
   {{0x4e41f328,0x993413a2,0x53e821d9,0x027ed0a7}},	//   _huraanit_, _elemenat, _үстел_, _smeni_,
   {{0xe730e3a3,0xf48760e5,0x629180f6,0xec7750f0}},	//   _novostav, _निकाले_, _barar_, _assurer_,
   {{0x83e2b3a4,0x29fc43a5,0xc47bd0ac,0xe379c281}},	//   _ferretti_, _ngonyaka_, _제휴사이트_, _macalin_,
   {{0xee928075,0x857e503a,0x9906f218,0xccb393a6}},	//   _priključ, _viktimiz, _أفغانستا, _preached_,
   {{0x7fc2d288,0x22d5d2ca,0xf407c202,0xec66b159}},	//   _باتور_, _benefici_, _walungan_, _tartott_,
   {{0x0c6140fe,0x0515c1b9,0x829182ee,0xdc72e180}},	//   _intumwa_, _bahlomph, _tarar_, _商品到着後_,
   {{0xa7ece1f7,0xd41d320d,0xa1088007,0x4f77b1fa}},	// [270] _atkazang, _hasierak, _moderálá, _cincelan,
   {{0x5395e056,0xb290e17e,0x7a0680d9,0x4943d2bc}},	//   _botse_, _sanaan_, _ethambut, _kjellere,
   {{0x14c95244,0x2c055103,0x99fc7284,0x54e10048}},	//   _chachank, _chorhey_, _incaviat, _रहृयो_,
   {{0x93eaf370,0x569c2152,0xa26df05e,0xac6860b1}},	//   _faiths_, _достаточ, _aeuoa_, _weeraro_,
   {{0x53fa4045,0x524973a7,0x9379635e,0x69b64214}},	//   _dawudi_, _chamba_, _kutanga_, _ءالقيسا_,
   {{0x9d0a11c6,0x247df09a,0x9201037f,0xd2927193}},	//   _segretar, _رايوننىڭ_, _akaidi_, _garapi_,
   {{0x234631d0,0xb2918281,0x7bb7c009,0x8edff06a}},	//   _finders_, _warar_, _каждой_, _jurnalis_,
   {{0x04aa610e,0x3eb4f145,0x6867e102,0x7f66110b}},	//   _सॉफ़्टवे, _alakụba_, _органам_, _arabimen,
   {{0x6ac8836d,0x12a06395,0xc79b93a8,0xce4b3023}},	//   _值得一提的是_, _abubuo_, _lwglungz_, _amaatele_,
   {{0x5291a004,0x725bf3a9,0xbcc6f3a3,0xd29180d7}},	//   _papat_, _fuula_, _zaciatku_, _karap_,
   {{0x52497344,0x734630dd,0x428570a1,0x51fd5252}},	//   _shamba_, _kinders_, _bithiro_, _урматтуу_,
   {{0x219c1031,0x719fd1ad,0x0d9c722b,0x43eab1f7}},	//   _የደረሱበት_, _bamboozl, _dielakka, _aacte_,
   {{0x52ca738d,0x22e6013f,0x5e41712a,0x52918140}},	//   _danda_, _משפחתו_, _cambiate_, _qarar_,
   {{0x3965016e,0xb27ce0d9,0xb3ead369,0x22fc21e0}},	//   _obnovlje, _afandaki_, _laeto_, _nominis_,
   {{0x65cfb248,0xa274001a,0x5b8333aa,0xb2d7e00c}},	//   _ማይክሮፎን_, _اۋدەۋ_, _bernegar, _funefeai_,
   {{0x5f20e03e,0x7290e123,0x1a0a12aa,0x23e2d3ab}},	//   _abdulasa, _banann_, _misahana_, _británii_,
   {{0xfc9cd0bf,0x1213e187,0xde368009,0x274f03ac}},	// [280] _кунда_, _anthu_, _свидетел, _muzzammi,
   {{0x42d982c7,0x537960c4,0x8d0853ad,0x9435e393}},	//   _okrem_, _gutanga_, _geboorte_, _efectivo_,
   {{0x369c9088,0xb7a181d4,0xcc80d1bc,0xe27ed067}},	//   _menghasi, _januaari, _кедей_, _emenu_,
   {{0x1a5ca287,0x228811f7,0x5be37038,0xbc93c276}},	//   _kolegija_, _айрат_, _memengar, _ناپاڪ_,
   {{0xacf781e7,0x9a9943ae,0xc2007008,0x184b7187}},	//   _महाकाश_, _titulní_, _düşünmek_, _achotsed,
   {{0x125ac206,0x6959120e,0x227ed333,0xf2ca6343}},	//   _bellum_, _теренот_, _imenu_, _apoliki_,
   {{0x63bff299,0xb15c217f,0x125bc03e,0xf7b4d2bf}},	//   _servizi_, _русал_, _agalú_, _amurungi,
   {{0x5290d146,0x7ab7e056,0x69f61352,0xa3ea91fe}},	//   _pinang_, _dipholis, _دوریت_, _laata_,
   {{0x837fd278,0x8097d225,0x8f3e92ab,0x880621b9}},	//   _talanoa_, _промена_, _neprikla, _adopthiw,
   {{0xc2d473af,0x3310e184,0x427e9012,0x4b9c502f}},	//   _daudwz_, _nataony_, _imani_, _ميانمر_,
   {{0xcf2301a7,0x80f99340,0x87e481b9,0x6410c276}},	//   _desligar_, _девень_, _статьяһы, _ڪئمپن_,
   {{0x32cac0c7,0x59f640e5,0xbd314264,0x02f922ac}},	//   _cadde_, _निषेधाज्, _اووووووو, _دڵپڕی_,
   {{0xe37961af,0xd829f152,0x3969d3b0,0x63eaf141}},	//   _putanga_, _четверг_, _redigere, _tagta_,
   {{0x42873395,0xcb0f226a,0x4290e1d8,0x2291822e}},	//   _aduhuam_, _corporat, _nanaon_, _waray_,
   {{0x63dc6128,0x7ecdd036,0x0364202f,0xa2e8b304}},	//   _crowe_, _продажба_, _دويمه_, _rejimen_,
   {{0xd47ec00f,0xb4d7f3b1,0xc416b3b2,0xc3780336}},	//   _чином_, _वाटिका_, _méritent_, _avaavaa_,
   {{0x7f606371,0x9212c199,0xe366b101,0x2c0fb123}},	// [290] _nespozna, _sidhu_, _lantrenm, _institis,
   {{0x627ed15c,0x72ca6082,0x69cd90f7,0xd25bf358}},	//   _kleng_, _geiloti_, _河北陶金风_, _tuuli_,
   {{0xf3eae289,0x20e5b3b3,0xb2a6e011,0xa277c144}},	//   _mentel_, _तबदीली_, _banbot_, _bawatfum,
   {{0xedb4c292,0x98dab3b4,0x0077b097,0xd2b5f0a8}},	//   _قوشون_, _babusakg, _gruppein, _kluci_,
   {{0x29a623b5,0xed95d1b3,0x550b01f3,0xa5411351}},	//   _proximid, _benedice_, _شکارپور_, _الزامي_,
   {{0x82cac203,0x3290815d,0x935223b6,0xfaa1f200}},	//   _wadde_, _pokale_, _कबूला_, _walinaks,
   {{0x5201419a,0x331a214f,0x9fa733b7,0x79f81031}},	//   _rheini_, _addasā_, _comenzar_, _ተፈረደባቸው_,
   {{0x427ed1b9,0x6b79120f,0xf4b473b8,0xdf2400b7}},	//   _ileng_, _aparılan_, _sydafrik, _pošto_,
   {{0x0c93c3b9,0xfeb7f106,0xb5385263,0x42910281}},	//   _قاجار_, _aineolas_, _футболдо, _rabaan_,
   {{0xe366a202,0xd1ffc390,0x9654d231,0x029243ba}},	//   _wungkul_, _bilisumm, _biznesow, _kovač_,
   {{0xb29180b1,0x62e85336,0x427863bb,0x62497287}},	//   _qarax_, _ameilka_, _akunan_, _skamba_,
   {{0x22647213,0x02fdc271,0x752c822e,0x8f27f139}},	//   _azules_, _podniky_, _oristano_, _afererra,
   {{0xf39663bc,0x7867a063,0x1379719e,0x62fc723c}},	//   _fyrste_, _сингари_, _turanga_, _lungo_,
   {{0x65e88206,0xec0fb3bd,0x25ea13be,0xb2c2130b}},	//   _為業務需要參加_, _enstitis, _нормы_, _dublina_,
   {{0x3c082206,0xc0e9e17d,0x5c9d30ef,0xb47cf131}},	//   _starburs, _принадле, _marehemu_, _भराभर_,
   {{0x32ee839e,0x22f1c030,0xc395e01f,0xd9c9d3bf}},	//   _ajanuni_, _sevimli_, _motsa_, _ангелов_,
   {{0x2ca9b30e,0x1b97d124,0x05f421ba,0x7e5de1bf}},	// [2a0] _konzumac, _sanación_, _случва_, _маракуца_,
   {{0x9b5ed15e,0x186ed032,0x3119d037,0xad1b5248}},	//   _ярина_, _inniheld, _режимга_, _የዒንተይ_,
   {{0xf57930db,0x33614040,0x1a60c085,0x83dc2267}},	//   _наградал, _bangjaj_, _ভাইদের_, _jukwa_,
   {{0x4fe90282,0xc8f2b1d9,0x827c51bd,0x92eff358}},	//   _קלוגשאפט_, _اڭداماس_, _प्रवेशको_, _etunimi_,
   {{0x3990c3c0,0x23eb41e6,0x23fa00a9,0xf997b3c1}},	//   _hlohlele, _pretya_, _yasuni_, _enskilda_,
   {{0x230e715e,0x4c52e179,0x740360fb,0x1e031146}},	//   _arabera_, _boltinn_, _पर्याप्त, _disenara,
   {{0xb1f5338c,0x03dd90e7,0xfc5c13c2,0xcc0eb076}},	//   _имати_, _ntswa_, _abatoro_, _kaupale_,
   {{0xb3ea024d,0x26f14023,0x29c17264,0xf387024e}},	//   _nyito_, _aftaalá_, _القذافي_, _amargi_,
   {{0x67cc63c3,0x429183c4,0x76c51292,0x5d7e02a0}},	//   _personli, _obras_, _بولسم_, _بتبینم_,
   {{0x238743c5,0xa2d8e1c5,0x22758275,0xddfc515a}},	//   _ndersa_, _jenets_, _гуруһлар, _generowa,
   {{0xb2dc509c,0x22369084,0x27ad73aa,0xfc769285}},	//   _kolonii_, _alaja_, _इन्स्पेक, _abarumi_,
   {{0xa2da0101,0x2fd5f3a2,0xe3eb220f,0x03dc90a4}},	//   _lapolis_, _arheološ, _sayta_, _drawe_,
   {{0xbad3f14c,0x32da5369,0x5dbf43c6,0x1c46103a}},	//   _বাগআচঁড়, _antean_, _harakore_, _propozis,
   {{0xa9d4c275,0x4290b09c,0x63b4213f,0xcd07e140}},	//   _бурчини_, _aadaan_, _הנמצאים_, _ансамбле_,
   {{0x41637089,0x25c14085,0xd31213c7,0x12f2f3c8}},	//   _humility_, _পাথরের_, _hombres_, _bidilqu_,
   {{0xefd71048,0x835643c9,0x04ba00ee,0xcee8025d}},	//   _protože_, _ceteris_, _disponuj, _alekizan,
   {{0xdda47226,0x2065c3ca,0x3c539396,0x00aa93cb}},	// [2b0] _reagovat_, _दक्षता_, _editado_, _कानुनी_,
   {{0xe3ce5150,0xd03073cc,0xd25733cd,0xf38773ce}},	//   _selve_, _ихэвчлэн_, _føler_, _kaarte_,
   {{0xbcbec0c8,0xd395e0f9,0x037a119e,0x01dc40af}},	//   _далей_, _altso_, _aperaham, _はじめての方へ_,
   {{0xd2b5f126,0xc030213f,0x8aea41c3,0x027f43c1}},	//   _bouca_, _המהדורה_, _renfrews, _igenom_,
   {{0x53eab206,0x729271d0,0x27a9e041,0xec01a198}},	//   _facta_, _amsale_, _دارالانش, _acessar_,
   {{0xc3eb2288,0xff4af3cf,0xe57dd031,0xefba935e}},	//   _qayta_, _heggelun, _የተመጣጠነ_, _abaltimo,
   {{0xc1eb424c,0xc379a262,0xfb01a080,0x0b8ca1ba}},	//   _وفادارن_, _muhango_, _abusupit, _arrivato_,
   {{0x52908143,0x02012075,0xf80a3156,0xd239f129}},	//   _mikate_, _akciji_, _струга_, _formali_,
   {{0x62fcf102,0x6e2740b3,0x1291e04e,0xf2da5326}},	//   _ganger_, _версиясе_, _katas_, _abanike_,
   {{0xf249737c,0x326933d0,0x46eec3d1,0x93416179}},	//   _meambe_, _нэхмэл_, _ahlaselw, _notenda_,
   {{0x401b2041,0x86ce312e,0x65fbe248,0x068f5024}},	//   _معاشونو_, _ustaleni, _ምርብራብ_, _amitragh,
   {{0xfc7443d2,0xe290c0b1,0xc5943105,0x1d78614c}},	//   _draught_, _galaan_, _העברעאיש, _বাতিলের_,
   {{0x9ef1b25b,0x85eb202f,0x19391187,0x46e80180}},	//   _fiskivin, _ورساوه_, _chimanga_, _アカウント_,
   {{0xf89991bf,0xf200b37a,0x63c4c105,0x7fe9a3d3}},	//   _универс_, _radiyo_, _מערילענד_, _नारायणन_,
   {{0x02ee4185,0x20e3a1b0,0x9290c390,0xbe40f0aa}},	//   _memfa_, _skontrol, _balaan_, _baratoye_,
   {{0xbdc3907a,0x22fc7012,0x3790906a,0xf01da3d4}},	//   _peringka, _bunge_, _प्रस्थाप, _vandiemz_,
   {{0xa2cac09c,0xc3fcf144,0x5200c061,0x2b9c5344}},	// [2c0] _madda_, _abancedz, _malipo_, _arazisob,
   {{0x8753a019,0x82cac07e,0x503741de,0xde4d4336}},	//   _קאידא_, _ladda_, _postojan, _akapuluu_,
   {{0x22a720c8,0xf2fe6027,0x52918208,0xffc67342}},	//   _заробак_, _mesiras_, _abrar_, _shanntar_,
   {{0xe3431102,0xd224a180,0x93ef617d,0xb291e2b7}},	//   _ворота_, _さんがコメントし, _suurempi_, _fatar_,
   {{0xa291e0fb,0x6aeed104,0x52e33392,0xdcef63d5}},	//   _tatas_, _tratamie, _भूमीत_, _doktorgr,
   {{0x3b6fd24f,0xd37300f0,0x8202412b,0x316c13d6}},	//   _takornar, _domaine_, _ekwiti_, _поисковы,
   {{0xb41c201b,0x2bde73d7,0xedc39093,0x8387415e}},	//   _турме_, _छत्रपति_, _seringka, _ederra_,
   {{0x17b7c085,0x83eb91e7,0x699fc0af,0xcb25d348}},	//   _সমাধানের_, _laste_, _ブログランキング_, _montréal_,
   {{0x129dd21d,0xa26e1218,0x6b6f3159,0x132570f4}},	//   _hetoḥ_, _expono_, _tartalma_, _ئىسھاق_,
   {{0xa3c8726a,0x78c4e300,0xdd7a90ba,0x927862cd}},	//   _server_, _diverrad, _diumenge_, _stunde_,
   {{0x7b569155,0x6f4f83d8,0x73c87033,0x826d1118}},	//   _ﺋﺎﻳﻨﯩﯔ_, _kwesikha, _perver_, _macomb_,
   {{0x7f0fd371,0xae3de11d,0xb9fde2fa,0xce3ab12c}},	//   _opatrova, _achangop, _achangot, _dayagira,
   {{0xe3eae270,0xa30ca15c,0x67f21123,0xfb25202e}},	//   _isotop_, _gerannt_, _konbativ, _пушкина_,
   {{0x957bd149,0x4244c14d,0xdf63b01a,0x5b0b40ac}},	//   _aikupito_, _शिवानन्द_, _тапшырат_, _borstvoe,
   {{0x0f65c2e9,0x92ea7311,0x529142d2,0xdf24a3d9}},	//   _seraphin, _getiren_, _anfang_, _bolekann,
   {{0xc56cc032,0x7dfdd210,0xfdfcf3da,0xf835e06d}},	//   _framleið, _absentwa, _accentwa, _мудерн_,
   {{0x23eb93db,0xc15d9110,0x42da10db,0xbd8ad3dc}},	// [2d0] _faste_, _actuatio, _bapeli_, _старого_,
   {{0xbee2030f,0x525a5010,0xd953e182,0xc201813a}},	//   _दुर्दैवा, _filly_, _abhayaṅk, _epril_,
   {{0x8200c285,0xfd0d53dd,0xe9cd53dd,0xebca1198}},	//   _waliyo_, _primirje_, _primirja_, _продавни,
   {{0x9291e0d7,0x93eaf0f5,0xe31b5008,0xcb0093de}},	//   _tatar_, _sagte_, _düzen_, _preselit,
   {{0x0a9e3096,0xd681e345,0xa2026270,0xc8b5c128}},	//   _مسافروں_, _अफनात_, _diakhiri_, _stitcher_,
   {{0xd7ee41ab,0xc25a43df,0x7c770075,0xd6eb7213}},	//   _katanung, _оригінал, _razredi_, _sumaspaw,
   {{0xf533d2b0,0xcfff906e,0x32fc622e,0x5072f0f7}},	//   _schaukel_, _कालावधी_, _hulga_, _第四十四条_,
   {{0x50f043e0,0x4568c2bf,0xf757c31c,0x985ff0d7}},	//   _dilantik_, _abawugiz, _jedinstv, _kunaklar_,
   {{0xcd5ac011,0x63f8c3e1,0x3251d0e7,0xd394704d}},	//   _боден_, _prouve_, _thetshel, _annsa_,
   {{0x72e9d273,0x62b4005a,0x5fcff0ac,0x3b31b0de}},	//   _admicro_, _inici_, _마이페이지_, _ئشتۅۅسۉ_,
   {{0x6b921221,0x3290e09c,0xbfa45365,0xff1e13c1}},	//   _ilungelo_, _kanaan_, _deceiver_, _landstin,
   {{0x0ad8e032,0x720ec108,0x17fb4050,0x4c5ff209}},	//   _myndaalb, _салаф_, _一位台北的中年男, _solushọn_,
   {{0x726d90d2,0xc9913102,0xcbd311bf,0x4355a17c}},	//   _mesos_, _balkonge, _игнораць_, _revenis_,
   {{0x8201800a,0x4079c248,0xa2a053e2,0xba27e152}},	//   _april_, _እምባኣር_, _futbal_, _средний_,
   {{0x32da52e4,0x69c3e2a0,0x03dcd089,0xe18a022e}},	//   _aptech_, _قاڵبی_, _stews_, _estanisl,
   {{0xb049c252,0x21b42105,0x7290836f,0x730a517f}},	//   _талибанд, _ראדזין_, _bokane_, _abazoham,
   {{0xcd4e3228,0xcea4d17d,0xcc0a03c2,0xb18410f4}},	// [2e0] _رحيمي_, _будучи_, _abappya_, _ﺭﯗﺧﺴﻪﺕ_,
   {{0x939583e3,0x3c12819d,0x52ca33e4,0xffdc30f4}},	//   _morso_, _elspeth_, _afeleti_, _تۇرشاۋۇل_,
   {{0x2f5251c7,0x83dce11c,0xa290e0b1,0x34eb612e}},	//   _ﺍﻟﺭﺍﺒﻁ_, _سؤالي_, _banaan_, _systemów_,
   {{0x7b09d0af,0x105c83e5,0xe6905096,0xa601c337}},	//   _サインイン_, _noviniek_, _واویلا_, _तालाबन्द,
   {{0xcd0ab3e6,0x0a3fc351,0xc84162f4,0xc290e3e7}},	//   _totokore_, _شمرده_, _sailkatu, _danaan_,
   {{0xe3ebf278,0xd0d3311b,0xcbda6287,0x71860263}},	//   _ngutu_, _власт_, _конкурсе_, _ababalel,
   {{0xe290e1fe,0xd9e9a005,0xa305a0e2,0x2a11230a}},	//   _fanaan_, _дастатко, _almanak_, _enkareje,
   {{0x229181ed,0xed4e41b5,0xe24f7131,0x3e36504c}},	//   _faraz_, _заманауи_, _penerjem, _مدرنیته_,
   {{0xfd2d43db,0x485f63e8,0xf213e19a,0x9e1d7114}},	//   _designet_, _estrelas_, _eitha_, _cangkera,
   {{0x2c67d171,0x0797c3e9,0xb84ae031,0x728d73ea}},	//   _kununua_, _अपरम्पार_, _አብረውት_, _akukula_,
   {{0x42fc71af,0x72fcf3eb,0x243c1085,0xd70792a3}},	//   _hunga_, _langar_, _স্থির_, _лагеры_,
   {{0xfecb83af,0x598ae30f,0x4ebee05e,0x8b955262}},	//   _yalijsan, _निष्पन्न_, _fauniten, _nayinzir,
   {{0x6858a0b3,0x51775221,0x8d6d0296,0x526d93e1}},	//   _фракцияс, _balandel, _бартарии_, _lesor_,
   {{0x52eca261,0x727610f7,0xb5f8b0f6,0x22e0a3ec}},	//   _antiche_, _rassembl, _гапуровд, _tunnell_,
   {{0x0276b276,0x4388c287,0xc291e22e,0x78544031}},	//   _مهاراج_, _tragedij, _patay_, _መስታወት_,
   {{0x05bc00b5,0x3236d2e5,0x18d9e3ed,0x6dad3360}},	//   _ءﺷﺎﺷﯩﻦ_, _oleja_, _сервіс_, _ٹارچر_,
   {{0xafea6063,0xbb57013e,0x7c27e222,0x011313ee}},	// [2f0] _жалолобо, _पूर्णाहु, _haraftur, _abakakul,
   {{0xd4124090,0x7ae322da,0x2637c289,0x3c1bb3c9}},	//   _afanelak, _platnost, _kreistei, _tanquam_,
   {{0x2147d06d,0x629180e5,0xe28bb065,0x0291e1ab}},	//   _вазифаи_, _zaraz_, _לפוסט_, _tatay_,
   {{0xb08a009a,0x92ea03e1,0x8d8312b5,0xe807b3ef}},	//   _كىنونى_, _aeriyen_, _forefoot_, _nascetur_,
   {{0x829180c7,0xba34c0de,0x76b9a381,0xa303b3c8}},	//   _maray_, _ئنىسنەن_, _aporohay, _disampu_,
   {{0x0fd6101c,0x1b611264,0x9e944293,0x44961008}},	//   _تہذيب_, _تجاربك_, _kwamagan, _дүшүп_,
   {{0xe3625196,0x3938f187,0x7290f17e,0x7613733e}},	//   _hangoak_, _akumenya_, _bahaan_, _nautikal_,
   {{0xa7e14003,0xd291e1ed,0xef39e3f0,0x92ba73f1}},	//   _परार्थ_, _qatay_, _फिलिप्स_, _bondeli_,
   {{0xb5a1b3f2,0xa98ab13c,0xc1b3c007,0x761c5009}},	//   _esifanay, _akatuágo, _جاگری_, _поставля,
   {{0x0947500a,0x9fc823f3,0xaecd31ca,0x0848a0d7}},	//   _explanat, _anonymur_, _furitaan, _миллениу,
   {{0x096460d4,0x0c1c638d,0xc9656229,0x120261ab}},	//   _keanggot, _bacancar, _fotocame, _suriin_,
   {{0x9386d1de,0x43082124,0x7dddc0af,0x36a0c0af}},	//   _utorak_, _grabado_, _すべての質問_, _までにお届けしま,
   {{0xf29180c7,0x43f8c3f4,0x34faa030,0x162b1136}},	//   _daray_, _arouse_, _سیاستلری, _musikari,
   {{0x12d983df,0x238ba07f,0xdd559155,0xb634e086}},	//   _skrev_, _síria_, _алинур_, _thinkbli,
   {{0xd54c1019,0x1b0060ac,0x62260300,0xa67523a1}},	//   _קלינטאן_, _afdrukke, _diskar_, _abakambw,
   {{0x726c83ea,0xb26d907e,0x559871a1,0xefbda065}},	//   _kukopa_, _resor_, _urrently, _ביקשו_,
   {{0xb25b43f5,0xa30c23cf,0x6dc9a3f6,0x6552101a}},	// [300] _huelen_, _nymarks_, _सत्यापन_, _сентябры,
   {{0x425db28c,0x02c8b009,0x62d772d1,0x0ab6509f}},	//   _sprendim, _находятс, _وکورد_, _bakhomis,
   {{0xe200c1e9,0x172b0135,0x2090f2ac,0xb43d814c}},	//   _balido_, _ekspertë, _لیلزاد_, _পঁচিশ_,
   {{0x73ea03f7,0xfb6420c0,0xf6321027,0x0db980c8}},	//   _ayiti_, _dintrada_, _evenimai, _berniuka,
   {{0x6e575344,0x02cbf37f,0xbeac523c,0xcd82d301}},	//   _cambodge_, _achotsa_, _guardare_, _londýne_,
   {{0x3386e389,0xc2d9e2fb,0xb3a262d9,0x158ec37f}},	//   _shirye_, _akter_, _opopa_, _akatalik,
   {{0x6b0d73f8,0xb32a1102,0xbf4831c5,0x62fcf222}},	//   _función_, _самовряд, _krigadin, _sangir_,
   {{0xc3ea02e1,0x92ee600c,0x9ef7911b,0xba189018}},	//   _eyiti_, _apinati_, _размах_, _datorită_,
   {{0xdc49f140,0xd854333c,0xaaf7c0dc,0x5ada2337}},	//   _кредитла, _قوريب_, _майданы_, _उतार्ने_,
   {{0x23b0d03c,0x62c3725b,0xdb9d003f,0x053e6038}},	//   _cinque_, _serliga_, _गुरुदेव_, _posisiny,
   {{0xd2cb8376,0x27c703f9,0x53be9144,0x125b2284}},	//   _yarda_, _нашими_, _akavumi_, _asylo_,
   {{0x326fa296,0x7a0b0004,0xc2910139,0x3f72b12d}},	//   _abaningi_, _surakart, _jabaan_, _anabavin,
   {{0x345e4086,0xca9113fa,0xceb8313f,0xa27ee28d}},	//   _agovirin_, _manyanga_, _progress_, _aainge_,
   {{0x9b0ce212,0x3c12f149,0xda57c1e5,0x428d21d8}},	//   _مالیې_, _alapati_, _гайдып_, _ditarjam,
   {{0x40483041,0x9f4e51ba,0xfc9242f3,0x70f603fb}},	//   _پاکستاني, _продажби_, _инфекциј, _mekanikk_,
   {{0x327a1081,0xa37a3378,0x839583fc,0xd2c0c037}},	//   _kisianni_, _kjarasam, _worst_, _ыннан_,
   {{0xe291a3fd,0xebd1f3fe,0xad3453d5,0x7291a1d8}},	// [310] _capaz_, _अर्पण_, _avansert_, _mapay_,
   {{0x9a8a6238,0xa20c9207,0xf2e653ff,0x5250c2ca}},	//   _éditions_, _herhangi_, _signora_, _چىلەر_,
   {{0x8b187159,0x150d73ab,0x715c21b9,0x2477f20e}},	//   _ingatlan_, _maloobch, _дусар_, _критериу,
   {{0xcb7d32da,0xc731b099,0xba8ce24f,0xe2c94248}},	//   _finanční_, _celoslov, _davidsen_, _ብጥሜትን_,
   {{0x5c93d01a,0x4f3ea400,0xe9833248,0x50d8e248}},	//   _مازار_, _अरविन्द_, _ብተክኒካዊ_, _ኣቀባብላ_,
   {{0x2e5d5401,0x3c6771a0,0x3637e206,0x2241c1e7}},	//   _forbairt_, _glatiks_, _latitudi, _सकरले_,
   {{0x493f0257,0xdc7e0402,0x12d442bd,0xe2b3920d}},	//   _olimpiya_, _sausien_, _afdokia_, _handiko_,
   {{0x502da152,0xf26e60f7,0x027ee161,0x13b820f9}},	//   _название_, _autour_, _vainge_, _privatu_,
   {{0xc5ba815f,0xae1860a4,0x0c5313c1,0xe95bd403}},	//   _kamaniqy, _buredela, _platsen_, _akunakwe,
   {{0xd2fc7404,0xa3eb9405,0x99ecd186,0x17c713b4}},	//   _mungu_, _casta_, _atangaza_, _akaretsw,
   {{0xf248e095,0x84d7e037,0x5354515c,0xd2c52336}},	//   _primed_, _чараны_, _arbecht_, _foilupe_,
   {{0x420e117f,0xf9aac057,0x86db0078,0x738293d2}},	//   _башар_, _ловим_, _وااااااا, _burying_,
   {{0x26fd2041,0x7c4a62f4,0x3a19b102,0x7a0e10d7}},	//   _سیاسي_, _дипломто, _нарахува, _qatlawlı_,
   {{0xa0ba31c7,0x32fc52cd,0x253c528b,0x15871395}},	//   _санитарл, _wichtig_, _wichtich, _nketsenk,
   {{0x6fefa0ea,0x40ef90b3,0x82027161,0x7477c2fc}},	//   _अपराह्न_, _bulaçak_, _vasina_, _деловима_,
   {{0xfd8011c2,0xd3f461ec,0x029191fe,0x0c6de406}},	//   _asamblea, _foutan_, _caxaan_, _spirita_,
   {{0xc27ff21f,0xd394511c,0x0e5130b7,0xc79720db}},	// [320] _amuno_, _ailse_, _оставку_, _октябргә_,
   {{0x8b676267,0x9343515c,0x800f3065,0x6389b248}},	//   _deputara_, _onscharf_, _קוקסינלי, _ዘይምሱል_,
   {{0x92c8a407,0xab37915e,0x4c84a02a,0xdd08a407}},	//   _feroare_, _налайх_, _bereaved_, _feroaret_,
   {{0x7200d2ab,0x839d815e,0x77f82078,0xf851106c}},	//   _toliau_, _proposam, _ببرنامج_, _noormees_,
   {{0x2202711d,0xbe2100e5,0xa5a9e13c,0x9f3e5180}},	//   _pasina_, _कार्यपाल, _абардырр, _商品の説明_,
   {{0xec074217,0xfdcbf18c,0xcc0a0076,0xd1e7c228}},	//   _sistemas, _kwikhomp, _alapama_, _aktifaké_,
   {{0xba801172,0x92093048,0x4386d362,0xdc66801a}},	//   _senyakwa_, _motorkář, _sporno_, _жайылып_,
   {{0x9b5c41de,0xb2d90178,0xd938f203,0xcc5a73a5}},	//   _političk, _arbete_, _okumanya_, _yintoni_,
   {{0xdfe630b8,0xe2fc50f5,0xae4ca128,0x8c609139}},	//   _мансуб_, _richtig_, _detainee_, _achuman_,
   {{0xaa24824e,0x0294704c,0x5f893009,0xd2da6395}},	//   _stockist, _konkani_, _делали_, _twreye_,
   {{0x42b5f0fd,0x69502408,0xa2f28362,0xa2260409}},	//   _bouch_, _गैरव्यवह, _strahovi_, _diskur_,
   {{0x53897031,0x925bf055,0xf2fd60ee,0x52027394}},	//   _አባላቱን_, _isula_, _bannery_, _sasina_,
   {{0x3c76f193,0x127870f0,0x2ab3613c,0x4eca9272}},	//   _nourish_, _jeunes_, _интердиа, _reunites_,
   {{0x1648b284,0x5248d0d3,0xc4e8c0e0,0xd02790f8}},	//   _lethargi, _selmer_, _adhastād_, _юристлар,
   {{0x2304e21d,0x2434f042,0x6fbdc296,0xa3f463d2}},	//   _locanam_, _akukabek, _abalitho, _crutch_,
   {{0x12fd61a6,0x4292612e,0x530ca32b,0x7273d3a4}},	//   _tannery_, _sprawa_, _geraint_, _questhel,
   {{0xb31c840a,0xf26d80ee,0x63167133,0xc2d8d1e0}},	// [330] _edicion_, _kandidát, _honza_, _munere_,
   {{0x03207232,0x7756215d,0x109d504c,0xac063030}},	//   _omnye_, _کارنامه_, _خاطرنشان_, _байрами_,
   {{0x72189309,0x7daa3321,0xc3eae40b,0xde03f030}},	//   _biyinlaw_, _assilisa, _ventet_, _порлоқ_,
   {{0x557f540c,0xe378140d,0x08c9a0ac,0x42fc7179}},	//   _dilucutk, _nabadda_, _입체평면도_, _tungu_,
   {{0x9ea05128,0x0c06f258,0x42d8e137,0x025bf045}},	//   _distrust_, _amerlass, _tenets_, _asula_,
   {{0xe3eb9230,0xd1682169,0x66b4d067,0xe111a005}},	//   _hasto_, _langweil, _achapụta, _parsisių,
   {{0xa2fc7263,0x90e8101a,0x5ea6a0c9,0x1c66a3b0}},	//   _zungu_, _فوتوشوپ_, _fortsatt_, _fortsat_,
   {{0x53ebf22e,0x3f66c008,0x62caf365,0x6978c180}},	//   _haute_, _амала_, _geidet_, _目のつけ所が名無,
   {{0x0987a40e,0xcdd04286,0x73fe83a8,0x6291c210}},	//   _jacintha_, _motherna, _seizgan_, _iavay_,
   {{0x2fe33007,0xc301e40f,0xb37a6054,0x27e2f410}},	//   _جانتی_, _notandi_, _jawabin_, _almandyg,
   {{0x9da753e6,0x93cf0101,0xf7b5b030,0x8b9d10df}},	//   _huruhuru_, _traver_, _tekshiri, _acticepr,
   {{0x574220e5,0x475d6411,0xc7c7c009,0x42e3a00a}},	//   _विनिर्मा, _sebilang, _наличие_, _derived_,
   {{0xd3dc0412,0x5c163056,0xb26fb1d8,0xe6955270}},	//   _asiwa_, _mebušose, _pangalam, _diperbai,
   {{0x056d91d9,0x72903055,0xfb5c41f8,0x7292516e}},	//   _تارىمنىڭ_, _aimait_, _političa, _ostala_,
   {{0x7337c011,0x92906205,0xf9f671c2,0xe27ee413}},	//   _николаи_, _pickett_, _aisén_, _udinga_,
   {{0x70e33141,0xb9ede11d,0xcbad8077,0x3c64c367}},	//   _сырты_, _abhiyura_, _alábòsí_, _haitiju_,
   {{0x32b46265,0x426ba1c6,0x0c67c291,0xd04df28b}},	// [340] _dnoch_, _onorevol, _هرحال_, _frankryk_,
   {{0x0084113f,0x6c82e1c7,0x335ab064,0x2c6b4414}},	//   _בנימינה_, _ﯨﺒﯩﺮﺍﻳﯩﻢ_, _parfait_, _braunau_,
   {{0x693e5152,0xdb609024,0x8201a33f,0xbf6a81c5}},	//   _специаль, _रोदने_, _envied_, _zeladels_,
   {{0xf09230e9,0x037b1163,0x36e9d415,0x230810b9}},	//   _вольтер_, _geraldo_, _индиан_, _meselä_,
   {{0x212d30bb,0x52926416,0x49eb2380,0x49dc2343}},	//   _сайти_, _uprava_, _derrotad, _atalanoa_,
   {{0x0373d224,0xa317801d,0x03eb905c,0x37fb72bc}},	//   _bokaone_, _kerze_, _zasto_, _anschiov,
   {{0x1212c11d,0x13128417,0x8dcb21d9,0xbed6015a}},	//   _kadhi_, _सुदृढ_, _убликасы, _बांटना_,
   {{0x6f6c6418,0x2942b15f,0x2768308a,0x7202512f}},	//   _abababon, _taimaaqt, _abakuvav, _تەۋپىق_,
   {{0xe436412f,0xf62a0119,0x03dc6077,0x92cae404}},	//   _ﻣﯘﻫﯩﻢ_, _periutsi, _arowa_, _kondoo_,
   {{0x19911009,0xa46512a1,0xa3ead22f,0x35b9614c}},	//   _likhetha_, _ditetapk, _uzeti_, _সেইখানে_,
   {{0xf4bbc135,0x828d423c,0x8505b419,0x9fdd31f6}},	//   _ዚምልከት_, _appartam, _posteado_, _कैनेडियन_,
   {{0x6f0ef24b,0x737f315f,0x662fe08a,0x22ad033c}},	//   _amatshwa, _tamaita_, _abalingw, _علیات_,
   {{0x02fd6407,0xe81040f7,0x6a02a281,0x9e95141a}},	//   _ekonomy_, _分类精彩知识问答_, _magalada_, _gentofte_,
   {{0x82cb841b,0xa12d241c,0xc395821c,0x74c890c2}},	//   _aarde_, _жарты_, _forsi_, _замандар,
   {{0xfdd0c23c,0x2066e061,0x1d83c2c4,0xa5059065}},	//   _острови_, _وندرائين, _स्कोअरका, _אורבך_,
   {{0x5f584169,0x156c51bc,0x2eb322a6,0x8236d3b0}},	//   _verpasst_, _اجەڭىلسە, _izgubile_, _pleje_,
   {{0xa3021246,0x0b8c80db,0x8248c351,0xba05b015}},	// [350] _talavou_, _агентлыҡ_, _ngombe_, _naranjit,
   {{0x98c10159,0xe3eae007,0x3290d22c,0x2c0781bf}},	//   _keresked, _mintha_, _hankins_, _crescut_,
   {{0x02da41d2,0x63ead00c,0x1e020004,0xc5984292}},	//   _rowell_, _tootoo_, _pagelara, _курашнин,
   {{0x58ae4009,0x1626c09b,0x23dcf262,0xcc46c2f6}},	//   _качестве_, _fitategü, _rugwe_, _abapolis,
   {{0x1a8cc3ed,0x2353012f,0xd2d82169,0x13f94064}},	//   _retnings, _ئۇماق_, _gelooss_, _preuve_,
   {{0x4291e2c1,0x961352c0,0x262b1048,0x511c51f7}},	//   _hatay_, _battaxal_, _गीतहरू_, _сайттагы_,
   {{0x8d75614d,0xa44912b2,0x1fbf341d,0x7c53015e}},	//   _वर्षगाँठ_, _proveden_, _محنتی_, _bestela_,
   {{0x5a6da1cc,0xd02ec303,0xcc670065,0x60eb20b3}},	//   _vukovars, _назви_, _scoring_, _акциядә_,
   {{0xf38000f7,0x26ca42bf,0x4be3e031,0xa283f301}},	//   _常州组织工作_, _ahushany, _ኢንጂኒየር_, _funkcia_,
   {{0x085130fb,0xc3e5c2f7,0xa37cb41e,0x33eb908c}},	//   _विद्वान्_, _олимпик_, _garance_, _gaste_,
   {{0x2c0623dd,0x77580226,0xe1be0041,0x48c0e0df}},	//   _proseku_, _विश्वमा_, _سیاستونو_, _intended,
   {{0x93e39030,0x8510c41f,0xa2bb2420,0x13f46026}},	//   _حقیقتا_, _biyontah, _genelde_, _fouten_,
   {{0xb4a4013f,0x4e4f6421,0xe2926422,0xf24a6223}},	//   _באשדוד_, _magaalla, _usrana_, _chumba_,
   {{0x0ebd01f8,0xda3dd352,0xb294e039,0x03ea610a}},	//   _apsolutn, _بانکه_, _kyrkieh_, _nyota_,
   {{0x3c55136f,0x76820121,0x33f46423,0xeb8453c6}},	//   _lentswe_, _बिलाई_, _houten_, _inangaro_,
   {{0x9200322f,0x9c4a3086,0xe863f03c,0x425b0424}},	//   _uzmite_, _leucoenc, _irréguli, _ibalik_,
   {{0x02948285,0x0291e2ff,0x4a8690bb,0x04b170de}},	// [360] _abakazi_, _datay_, _радуйся_, _секундас,
   {{0x97e7613e,0x92b490d8,0xcab9c031,0xf3877039}},	//   _सामरिक_, _anach_, _አይደልም_, _sharum_,
   {{0xd29110e0,0x0fca1162,0xf24a611d,0xe85cf0ac}},	//   _locane_, _маркисиз, _shumba_, _반품배송비는_,
   {{0xe31a10cf,0xc25f4425,0x92caf071,0x0300d032}},	//   _sariling_, _babogedi_, _neidat_, _lifandi_,
   {{0xbf6c90fb,0x9c5e610f,0x23b5325b,0x721c0281}},	//   _निर्वाणं_, _محمدعبید, _álvara_, _abshir_,
   {{0xd3868221,0x62ed40d8,0xf1eb40f7,0x03966364}},	//   _abazali_, _airighe_, _输入您的搜索字词_, _barsam_,
   {{0x02d46426,0x8e97a358,0xc291b0e2,0x6471d0e4}},	//   _jorden_, _рецензии_, _savann_, _kontstan_,
   {{0x2ffa3005,0x22b49427,0x5ba532cd,0x336c83a1}},	//   _работнік, _piace_, _praktisc, _abagabi_,
   {{0x129260be,0x134af1b0,0x80af2428,0x7887c360}},	//   _thuash_, _hotelov_, _gestabók, _ذرےعے_,
   {{0x2c93d252,0xbe1bb085,0xf63eb207,0x627f4429}},	//   _بارات_, _কতিপয়_, _hamileli, _abente_,
   {{0xb1c92152,0x4200e00c,0x887891aa,0xeb189031}},	//   _почти_, _manino_, _реестры_, _መጨናነቅ_,
   {{0x505ec08e,0xe25ac200,0x4c66d111,0x59d6c2af}},	//   _fuengsik_, _billon_, _montras_, _belegile,
   {{0x93dc91af,0xf44a200f,0x898451a3,0xc3eb900a}},	//   _arawa_, _молодого_, _tshisima_, _paste_,
   {{0x9d91742a,0x4b8bc1bf,0x7cdaa1b9,0xaf9ed264}},	//   _algemene_, _schimbar, _авгусҡа_, _بحدود_,
   {{0x72f1e42b,0x42230360,0x4d383007,0x429153d9}},	//   _koristi_, _المکان_, _مقروض_, _bogame_,
   {{0xc278642c,0xe364d217,0x225ac2ed,0xfc6680d7}},	//   _grunde_, _yangın_, _fillon_, _басылып_,
   {{0x4dc821bc,0xb0b38027,0xc380642d,0xff94500f}},	// [370] _усулу_, _communal, _entrou_, _величезн,
   {{0x23eb91b8,0x62ca7039,0x43947110,0x93d41065}},	//   _hastc_, _hynda_, _kinsa_, _באיחור_,
   {{0x893b4059,0x3c9240ea,0x1cee911b,0xe27ff3a7}},	//   _የጦርነት_, _najednou_, _искуства_, _amuna_,
   {{0xcbeec28c,0xf2fc7203,0xf51f716d,0xdc282223}},	//   _вакол_, _kungi_, _donnesch, _چيلنج_,
   {{0x83a2d2d9,0xb2ca742e,0x44a39121,0xaf74910e}},	//   _apepa_, _mynda_, _ज्ञानदर्, _katarzyn,
   {{0x92b4e304,0x279320a1,0x12fc71fe,0x9249427c}},	//   _rancak_, _molongö_, _mungi_, _djemba_,
   {{0xa27f013a,0x8156c1a8,0x8db4f1bc,0x93759255}},	//   _planti_, _памылак_, _بۉلبۉلدۅ, _abelameg_,
   {{0x9dafd026,0xf5d07052,0x8f2de369,0x0ad2f053}},	//   _가맹점가입안내_, _komentēt_, _sufficen, _gestalte,
   {{0x43fa621e,0x620113ab,0xe87ba427,0xe7cfa275}},	//   _burung_, _mobilu_, _известна_, _амалисз_,
   {{0xe30311d4,0xcb8ac152,0xc26c40c3,0x4644b137}},	//   _allatut_, _водой_, _samog_, _bisitahi,
   {{0x938d1196,0xdfa170de,0x13f9413d,0x10ec305d}},	//   _насандаа_, _arreglar_, _creuse_, _regiunal,
   {{0x727ee19e,0xd3eae0d2,0x22b3121c,0x36dc5121}},	//   _meinga_, _sentit_, _pradhan_, _पाकिट_,
   {{0x33ac6018,0xec4f42f8,0x5db9342f,0xe2f2126e}},	//   _asupra_, _ikawalu_, _adingsha, _аксак_,
   {{0xb3ebf235,0x9eb7f3b0,0xee37e414,0xd31670e4}},	//   _cauta_, _hverdage_, _catandua, _konze_,
   {{0x712060e5,0xac7e11a6,0x888c5176,0xfe1db18b}},	//   _प्रजातिय, _abasito_, _علاقمندا, _jeremaia,
   {{0x52555430,0xa6d401d4,0x1f697004,0x3053c04c}},	//   _məlum_, _tamakkii, _sembaran, _واکسن_,
   {{0x23947431,0x2b93131d,0xde5d3296,0x529143f9}},	// [380] _ainsi_, _alentejo_, _ганчи_, _diskett_,
   {{0xe87540d0,0x927ef223,0x7fb0f221,0x92e97262}},	//   _frenchlu, _ulinzi_, _abalondo, _kurinda_,
   {{0xb3ebf432,0xb39470ef,0xe290309c,0x4965630b}},	//   _rauta_, _jinsi_, _ummata_, _fotokame,
   {{0xe27f70ce,0x1375c0f4,0xcc13e1dd,0x886b508a}},	//   _tegnap_, _ﭘﯘﺭﺳﻪﺕ_, _idusidus, _فلسطنيان,
   {{0xf224026b,0x6c7c518b,0x82caf059,0x0f5b729a}},	//   _dziko_, _agarkar_, _realiti_, _memandan,
   {{0xe25e2242,0xb2cae0c6,0x137a02a1,0xee54e104}},	//   _ventspil, _adidie_, _setahun_, _porcenta,
   {{0x98cd92e1,0x7ba44180,0xa2cb80ae,0x027ef404}},	//   _watersid, _発明が解決しよう, _farda_, _pointi_,
   {{0x22d5a430,0x92a752a9,0x1c67f09c,0x1b920433}},	//   _millət_, _lieber_, _adnuyaa_, _aplicado_,
   {{0x33eb9200,0x3305133c,0x8bdf722e,0x09f6c0bf}},	//   _kasta_, _اولان_, _friedber, _توقیز_,
   {{0x2407d434,0x2bc7d17d,0x1386e0c0,0xd3871015}},	//   _продава_, _продажа_, _georgy_, _huaraz_,
   {{0x53eb9435,0xa9bf51a3,0xe2eed169,0x397f02c1}},	//   _masta_, _lulembet, _leeft_, _makinele,
   {{0x825ac169,0x528e215d,0x427eb271,0x084a7352}},	//   _villen_, _اصولا_, _podnik_, _کارکردنی,
   {{0x925ac0ff,0x73c70218,0x027f72ea,0xa7db72c6}},	//   _willen_, _corparái, _mbante_, _demandav,
   {{0x5d98306d,0x9a968113,0x869882a9,0x5200f3a7}},	//   _нестанд_, _novembrī_, _lebensmi, _ajiili_,
   {{0xc200e3c4,0x4905d16f,0x32b57436,0xb86c80fd}},	//   _único_, _ankoraŭ_, _llacan_, _asistans_,
   {{0x8c733437,0x1dd0513e,0xc2bb800f,0x2a93d132}},	//   _framhald_, _तुर्कमेन, _ledende_, _доведит_,
   {{0xec7150e5,0x4395e3d9,0x1bd910ac,0x37c351a2}},	// [390] _पुर्खा_, _antse_, _지식전문가_, _регулиро,
   {{0x306010c7,0x652f523c,0x4f335202,0x3fb7c121}},	//   _الانزٕ_, _supporto_, _ngiringa, _roolijoo,
   {{0xf638027d,0xc2e930f9,0x50146221,0x7c5ca192}},	//   _sannadki, _reinert_, _amavolon, _bintril_,
   {{0xcc6bc04b,0xb7a72005,0xf2d511e7,0xa99fc3a7}},	//   _hukumat_, _svetaini, _millist_, _anakhula_,
   {{0x513952ab,0x9c5e2122,0x209fe227,0x62efc103}},	//   _драматыч, _barthel_, _지방자치단체_, _dilista_,
   {{0x23f8929a,0x538df429,0x60e832ca,0x596cf238}},	//   _dijual_, _aleteháp, _ايپقا_, _stankade,
   {{0x1136e10f,0xf3649110,0x7c610202,0x737a2137}},	//   _عراقی_, _friggin_, _kisunda_, _basahin_,
   {{0x3be731ec,0x2b983022,0x0924b0de,0xe3bf30de}},	//   _deteryor, _ءﺗﻴﯩﺲ_, _اققۇۇلار_, _الىچۇ_,
   {{0xc20262ce,0xd277a252,0xd7a22186,0xec52c401}},	//   _marito_, _банктын_, _kabuhari, _toitín_,
   {{0x6b205438,0xa2c5c04b,0x8c9e1065,0xb3dd9291}},	//   _ingakumb, _olimlar_, _מוזיקת_, _yuswa_,
   {{0xf806a1f0,0x59bf23a7,0xd292017d,0x3225416f}},	//   _сумкалар, _akavumbu, _tapaan_, _elekto_,
   {{0xa53e5439,0xa106e04d,0x2bc4e0af,0xd20261ab}},	//   _karierny, _mechthil, _この記事のトラッ, _narito_,
   {{0xcfae117f,0x8a34d291,0x027f70bd,0x6a67e192}},	//   _барки_, _تسلیت_, _maande_, _яралана_,
   {{0xc823b02d,0x9a2f3381,0x9a10603b,0x1f6280e5}},	//   _འགྲིམ_, _graciela_, _angameme, _संस्थाएं_,
   {{0x121380fb,0x7c5c129e,0xdb5ce2ec,0xaf33d24f}},	//   _tarhi_, _gestion_, _sächsisc, _takutipp,
   {{0x43dd9220,0x08c9c1c7,0x623a53de,0xc7aa40df}},	//   _ruswa_, _салалард, _pohvalil, _edetermi,
   {{0x2bbb207f,0xadcd515e,0x8fce6101,0x4d2fd328}},	// [3a0] _студиа_, _дорлигжа, _akonplir_, _ministat_,
   {{0x61978156,0xb27f01e6,0x427f743a,0xa2eb61d8}},	//   _групата_, _dhanam_, _abante_, _diantos_,
   {{0x02cd116f,0xbe272064,0xb2537012,0x4a875366}},	//   _berlino_, _milliers_, _راهنمائي_, _polyacet,
   {{0x62b49007,0xc63bc200,0x3dcb20de,0x8aea410b}},	//   _piaci_, _lakirapx, _اعادىل_, _ararifat,
   {{0x3049116e,0x2358b309,0x8b1c2033,0x1efd506a}},	//   _периоду_, _berghbe_, _ekspekst, _तारका_,
   {{0xe3648030,0x5624226e,0xd29031ba,0x62da6249}},	//   _mingdan_, _слушна_, _concorsi_, _attent_,
   {{0x4e9521b3,0xb97890f6,0x27cb524a,0x14f8c0f7}},	//   _contente_, _serişdel, _hearrenf, _第四十二条_,
   {{0x2e2892c3,0xc2fa2012,0x11fed10d,0x1f91f2b7}},	//   _вагондар, _kichina_, _прозы_, _gundumar_,
   {{0xaf5bf2aa,0xcaa5a17d,0x627ed395,0xc3781143}},	//   _fijalian, _kotimais, _mpontu_, _babanda_,
   {{0x5f6280e5,0xcf5d8105,0xe531608b,0x1ce0d07f}},	//   _संस्थाओं_, _קירכע_, _تجربیات_, _асессиа_,
   {{0x4cfb91c4,0xa262b044,0x4c53e057,0x96cfb02d}},	//   _defended_, _momotuhi_, _албастрэ_, _sigurtà_,
   {{0x88cc33e5,0x03006408,0x0dc0525d,0xb2a7d288}},	//   _najdisku, _aliansi_, _batimola, _садокат_,
   {{0xebbf303d,0x15c3a0b3,0x95eac0c8,0xa605d29e}},	//   _abakwelo_, _кодексы_, _мойму_, _confirmé,
   {{0xa794143b,0xdc0a3013,0xf342643c,0x2870a3ef}},	//   _mistoqsi, _galpón_, _rodeado_, _circiter_,
   {{0x9290b0af,0xdc54a369,0xa86741cf,0x227ff1fe}},	//   _forkert_, _hartwig_, _belichtu, _amunu_,
   {{0xb942537c,0xbda8a3ef,0x5387443d,0xc26c2054}},	//   _charlier_, _agromeha, _undrar_, _makon_,
   {{0xb26c2004,0x8abc60f7,0xa37f8244,0xe2dfb0f4}},	// [3b0] _lakon_, _如何贡献知识_, _makatta_, _ﺩﻭﺧﺘﯘﺭﺧﺎ,
   {{0x014ec0ac,0x7386d3e2,0x0b1f40b5,0xdbb47049}},	//   _저작자표시_, _utorok_, _بۋىرشىن_, _reacción_,
   {{0x12d811e7,0x860911b8,0xf3f97086,0xf2d952b8}},	//   _mehed_, _halongvi, _crause_, _oggend_,
   {{0x02d81121,0x1beec005,0x727ef043,0xd6287207}},	//   _lehed_, _малой_, _kunnes_, _kalitesi,
   {{0x2956a043,0xac289031,0xf2da61df,0x9f7fc124}},	//   _sellaine, _ቢዝነስና_, _parolis_, _амҩаҟны_,
   {{0xe47b92d2,0x080b943e,0x95237214,0xfc05a057}},	//   _gefunden_, _समुद्री_, _ﺑﯩﺮﺩﻩ_, _буникэ_,
   {{0x7245843f,0xe2a6d231,0xb3a261e4,0x0d1db0af}},	//   _rámci_, _osobom_, _apopo_, _ブログに書く_,
   {{0xb4f6c0c8,0xd27f71c2,0x8bc901ed,0x02804362}},	//   _суправад, _adanna_, _партияне, _prisilil,
   {{0x526d7187,0x231b20ca,0x038d7113,0xef4d73c9}},	//   _ataona_, _advayā_, _personai_, _personae_,
   {{0x13167440,0x5e430137,0xfa92b0c6,0xd66a0441}},	//   _konzi_, _mamamaya, _nsonsons, _проверяв,
   {{0xd26c20c3,0xdc72c28c,0x308c713f,0x475e20e5}},	//   _nakon_, _sportas_, _פפראצי_, _चित्रित_,
   {{0x23f46164,0x4dd9d030,0x027f7442,0xf3eb0177}},	//   _mouton_, _билдирга, _ndanda_, _amatuk_,
   {{0xd5bb70c7,0x7394724a,0x2a0d6220,0xfc1132ca}},	//   _پروانن_, _kinst_, _kubasaba_, _marginac,
   {{0x88d71124,0x7defd0ac,0x3745e080,0x72027239}},	//   _витали_, _하이파이브_, _ajinataj_, _wasila_,
   {{0x475b10ca,0x3301f19a,0x99d982c3,0xbfa0b38c}},	//   _parinirv, _baratoi_, _лигасыны, _novembar_,
   {{0xb3cf81df,0x12b600dc,0x3ed482a2,0xbfcb11b3}},	//   _servo_, _riscos_, _ndeindin, _desidero,
   {{0x1ddbc1ce,0x245820f7,0xdb88104d,0x3583d144}},	// [3c0] _spokesma, _国家文物局_, _bacioter, _bakuchaz,
   {{0x39c7b187,0xf5a26443,0x8946124e,0x56ec926d}},	//   _akuletsa_, _chokokué, _anglepat, _dumalanw,
   {{0x8ed4e0c7,0x629111a6,0xf2cae14f,0x54498444}},	//   _زبانو_, _ancabe_, _aindro_, _preveden_,
   {{0x1be5125a,0x83013222,0x326c83c2,0x0791f23c}},	//   _interpar, _livandi_, _kukola_, _costitui,
   {{0x8f2760a9,0x24cbf3ca,0x0e7391dc,0x5da2423c}},	//   _derechon, _टोकियो_, _भाग्न_, _esigenze_,
   {{0x09dd7363,0x987f5193,0x5175f210,0x92fc7339}},	//   _poloaiga_, _assiduou, _ehindbay_, _kungs_,
   {{0x0493e0bb,0xc6523256,0xae0c40af,0x57872252}},	//   _стратегі, _tanzaniy, _バでブログを書こ, _باشاتى_,
   {{0x5fbd7084,0xb34b6289,0x42fd82b7,0x92b362fa}},	//   _abaniṣer, _kemeret_, _burge_, _abudisa_,
   {{0xed5eb083,0xeb1b0445,0x3387024e,0xf27ce143}},	//   _кодексин, _batalion_, _dobric_, _agangaki_,
   {{0x52d8d42e,0xb850e416,0xbf33f00b,0xcc9321ca}},	//   _erlent_, _novograd, _taarsiga, _ہاوان_,
   {{0x854d7385,0x8c29b059,0x628d729a,0xd3877446}},	//   _terkenal_, _ነፃነትን_, _terkena_, _sparno_,
   {{0xe252a349,0xe2874205,0xf35f1271,0x6c25c21f}},	//   _skytshel, _ciliary_, _objekty_, _akeberer,
   {{0x4356914b,0x77b01065,0x93dc922e,0x5356b175}},	//   _revenir_, _נזיקין_, _asawa_, _detenir_,
   {{0x57f922ca,0x2d98c030,0xbfed01b0,0x95491192}},	//   _четинен_, _kollejla, _hlohovec_, _замандаш,
   {{0x1301f19a,0xbdbf804b,0xac6ee0de,0x0d2fb0f7}},	//   _paratoi_, _muhabbat_, _aporten_, _cheminée_,
   {{0xb2d46118,0x9f577102,0xa250c275,0x52e952d4}},	//   _kordon_, _johansen, _شىكەر_, _amanaku_,
   {{0x2f66c0f6,0x5c14304b,0xdc3bb0a0,0xe2c362d4}},	// [3d0] _смола_, _بوسنی_, _yezindlu_, _abelwan_,
   {{0x326c2228,0x9f96113f,0x6317130d,0x99d7d212}},	//   _takon_, _איילון_, _bozza_, _انډيوالا,
   {{0x23cf82cc,0x3c2791c6,0x12f402d1,0x9b07c23c}},	//   _terve_, _dijametr, _خودموختا, _билети_,
   {{0x21072007,0x19ee60a9,0xa253a0c8,0xc1ed6179}},	//   _فروري_, _iturrald, _klientam, _fullorði,
   {{0x226c2376,0x5b55a009,0xb238f028,0x2e0c5447}},	//   _sakon_, _главным_, _gramati_, _королевс,
   {{0xf644431a,0xbe185448,0x91182043,0xf32bd23f}},	//   _tunihiff, _aftenbla, _природны, _cercatz_,
   {{0x192b00b8,0x0bd9e0f6,0x89bfb0b3,0x03ead060}},	//   _абдулази, _баранынд, _terrorğa_, _dyeta_,
   {{0x22fd8449,0x02e671c2,0x2c53a2d9,0x340741f6}},	//   _purge_, _adaneva_, _nkitaho_, _हवलदार_,
   {{0x0c70a0e5,0xd06e40a1,0x786e50c8,0xbeb003ef}},	//   _मुर्गा_, _tagaaboo, _atsirand, _libertas_,
   {{0x95b0601a,0xc3a2911d,0xcc54922d,0x8238f033}},	//   _كورگەندە_, _ipapo_, _korting_, _dramati_,
   {{0x92e640a7,0xcebe52a6,0xc28bc021,0x850f10cc}},	//   _rudnika_, _vrhunske_, _tyrkisk_, _aprovech,
   {{0xfe48c031,0x3292444a,0x62d4644b,0x1202123c}},	//   _በጥንታዊ_, _kitang_, _fordon_, _capito_,
   {{0x1301a00e,0x526c90ef,0x8b892288,0x11ed6179}},	//   _abbasov_, _سيوستان_, _файласуф, _fullorðn,
   {{0xf5c30025,0xbadf4217,0x24d4c44c,0x7e43006e}},	//   _ahmadiyy, _delegats, _спани_, _ahmadiya,
   {{0xf200815e,0x1224011d,0xbef080c8,0xe26c4110}},	//   _nahiko_, _dzika_, _elektrin, _namon_,
   {{0x6031c0c2,0x0238644d,0x72cba0c6,0xc3408082}},	//   _aletaren, _primiti_, _worekodi_, _panemon_,
   {{0x927860a1,0x7304344e,0xdc7b6315,0x9d2a7115}},	// [3e0] _avunga_, _israyil_, _conselh_, _reticent_,
   {{0xc2d8d1b3,0x5563a105,0xc56140ce,0xc587609f}},	//   _peleas_, _פאוער_, _hallgató, _basehloh,
   {{0x96d021c7,0x231e744b,0x83f8c230,0x8ea970f4}},	//   _ءشامشى_, _matchen_, _troude_, _ئېھسان_,
   {{0xb257006a,0x285c10dc,0x10c153b0,0xbd8920b5}},	//   _परदेशी_, _naturals_, _tilladel, _ءبادىك_,
   {{0xb95f009a,0x168a42e5,0x427ef049,0xaad17050}},	//   _апиришид, _akadémia, _asinou_, _一方面聽眾欣賞了,
   {{0x8a6073a4,0x3f94344f,0xcd13d33c,0xb0473268}},	//   _jailhous, _власта_, _кулланма_, _кекса_,
   {{0x22da744b,0x1f5d1430,0x82903179,0xa32b71a1}},	//   _adress_, _kitabxan, _gamall_, _ainchay_,
   {{0x1386b3f1,0xcfe0814e,0x3e9631d9,0x383ce214}},	//   _cherie_, _বৈষম্য_, _ءىشىڭ_, _باسەكەسى_,
   {{0x126c809e,0x12ce2102,0xdb7cc011,0xd2b52384}},	//   _sukoba_, _формальн, _ahasápa_, _inych_,
   {{0x7a5f1039,0x120272df,0x9f2e109a,0xa2d9b0d3}},	//   _dangstep_, _basika_, _бовисиғи, _suvent_,
   {{0x77fd011c,0x62d8d308,0x84048013,0x8349c0a7}},	//   _اتفاقية_, _kunene_, _евразиат, _izvesni_,
   {{0x64b9a340,0x2a09f284,0xb38071e0,0xbafd838c}},	//   _деметра_, _megahert, _plures_, _severois,
   {{0x43ebf0a4,0x79cd922e,0x8ca6d2ac,0xdd608022}},	//   _kauta_, _kurosawa_, _دایبنێ_, _ءﺳﻮﻳﺘﯩﭗ_,
   {{0xd231e12a,0x62d85007,0x937b91e0,0xb2eef223}},	//   _cammino_, _meleg_, _senatum_, _ufanisi_,
   {{0x0213e450,0x5dd2d152,0x2504204d,0x8960f30e}},	//   _bathi_, _стало_, _ciallach, _माउन्ट_,
   {{0xe303331a,0x5b26c152,0x84651038,0xd56ee0ea}},	//   _ahianit_, _одном_, _diterapk, _मस्तिष्क,
   {{0x0ad362b5,0xe189b0b9,0xfe011373,0xa26c40bf}},	// [3f0] _smothere, _рахманбе, _ripetuta, _zamon_,
   {{0xc2c76005,0x52908207,0xeaa8d061,0xc6f63048}},	//   _засталіс, _hikaye_, _جياپو_, _उपलव्ध_,
   {{0x7dbb3163,0x92e611ce,0xe395e2aa,0xfb0791ba}},	//   _basilica, _ipanema_, _antso_, _финанси_,
   {{0x0793e1de,0x22d95348,0x129251ac,0xfb433031}},	//   _pretvori, _effets_, _hataon_, _በመስከረም_,
   {{0xa1f980d6,0x731c5451,0xa3ebf2b7,0xd2d8e2d2}},	//   _nemzabal, _atecina_, _bauta_, _erneut_,
   {{0xf2246233,0x7ae9a018,0xf57ae1b8,0xfe1730df}},	//   _azoko_, _департе_, _vietinfo_, _enderbla,
   {{0x0ff31290,0x20e4f3c9,0x7213e041,0xe959a248}},	//   _कलाकारों_, _fringill, _yathi_, _ኣርሒቖም_,
   {{0x536f407c,0xdbc2d2a7,0xcf235078,0x115d12bd}},	//   _amagugu_, _عبداللطی, _إصدارات_, _adiology_,
   {{0xdc67b177,0x12926039,0x9ae6643d,0x43eaf11a}},	//   _addunya_, _jirang_, _publiken_, _bantay_,
   {{0x72925452,0xb292639b,0x426ce397,0xbbe8a2f8}},	//   _nataon_, _dirang_, _kuiona_, _butobuto_,
   {{0xa2926316,0xa26d1103,0x62b63340,0x60fe5277}},	//   _paraan_, _biboch_, _антериор_, _прогласи_,
   {{0xe3947256,0x7ba0108a,0xb2d85453,0xd867e012}},	//   _minsi_, _مککین_, _beleg_, _بدانتظام,
   {{0x32ca73eb,0x32d8c3f2,0xa99cb007,0x3252f308}},	//   _myndi_, _kulele_, _دانشوروں_, _akutlhel,
   {{0xa9bec16b,0xf2927215,0xa31e1454,0x22dab455}},	//   _headlamp_, _posade_, _fracaso_, _attover_,
   {{0x237f3258,0xe213e0fb,0xdb82c456,0x1c767308}},	//   _tamatta_, _pathi_, _लोकमत_, _emirini_,
   {{0x6658b39c,0x1bac7105,0xafb71162,0xec1720ea}},	//   _قاچانغىچ, _תּיכּף_, _бурунқид, _पूर्वमन्,

   {{0x339cc184,0x327ee0d8,0xd2d81004,0x3c51f085}},	// [400] _fanatanj, _beinna_, _adhem_, _ventaja_,
   {{0x02915296,0x72b401c3,0xc2916317,0x228973c6}},	//   _ingabe_, _raich_, _digant_, _marangai_,
   {{0xe8d7c225,0xad64308a,0x039a5251,0x23ea9025}},	//   _цигари_, _تعلیمي_, _законски, _ayath_,
   {{0x4c25f2f5,0xdf7a80e5,0x5709f043,0x7863906c}},	//   _akaberer, _महाप्रबं, _seitsemä, _एजुगा_,
   {{0xddcb527b,0x3f2b31e6,0xc2d8509b,0xa27f7187}},	//   _सर्वदलीय_, _manushya, _feled_, _adanka_,
   {{0xa14520e6,0xd1f8d041,0x55fbf457,0xbdad6106}},	//   _materjal, _مقالی_, _dimensió, _bainnsea,
   {{0x22240187,0xaac9d369,0xd0025116,0x32b43401}},	//   _usiku_, _verworfe, _लिखऽतानी_, _maidrid_,
   {{0xd4d96174,0xf9fc70d0,0xf1d23192,0x58543276}},	//   _просјечн, _hiqiniup_, _былтырғы_, _ڪوريج_,
   {{0x7a5d22a1,0xa6bc230a,0x06d933b0,0x87544093}},	//   _diterima_, _bagarapi, _simpelth, _keuntung,
   {{0x5695e007,0x2f4eb284,0x67b631eb,0xd1dbd225}},	//   _مطلوبہ_, _suspecte_, _naturkni, _отвора_,
   {{0x4adfb217,0x087f715c,0x3200920d,0x829150f5}},	//   _federats, _positiou, _amaia_, _angabe_,
   {{0xec7070fb,0x22b1f33e,0xe21c6141,0xc2bbc3a5}},	//   _राज्ञा_, _saidina_, _merhum_, _athenge_,
   {{0x76372263,0x72d30146,0x02e3839b,0xc61911f3}},	//   _саркозӣ_, _mestilah_, _bofilwe_, _kapacitá,
   {{0x0bd920b9,0xc3e92375,0x996ac42c,0xa26b0263}},	//   _банклары, _القىنباي, _revidere, _ahlukahl,
   {{0x62ea6036,0x692ef44c,0x527f722c,0xc2f040e2}},	//   _affitto_, _камертон_, _afanua_, _filisti_,
   {{0xe3dcd166,0x82c1c1f1,0xc189731d,0xeed410d0}},	//   _brews_, _belleza_, _barangay_, _qaliriin,
   {{0xd274d05b,0x13788140,0x29f590cc,0xf30410f7}},	// [410] _حواله_, _kazanda_, _comienza_, _制定本条例_,
   {{0xb7fad040,0x827ec1da,0x4e431458,0x7985b1c2}},	//   _waibling, _ibonye_, _sambhava, _pulitika_,
   {{0x1e50a10e,0xc2d85007,0xc6c6c1d4,0x53207360}},	//   _मूसलाधार_, _veled_, _attavigi, _بیرونِ_,
   {{0x52eef029,0x6f7f9065,0x29ea01ca,0x724a603d}},	//   _atanapi_, _ממלכת_, _weerarad, _akumka_,
   {{0x3c9cb009,0x1055f126,0x564960c8,0x8159c2de}},	//   _дополнит, _aburukun, _задаваль, _насилств,
   {{0x282d536f,0x89dbe248,0xc27ec181,0x4f3f709c}},	//   _аралашыу_, _ምጽውዋር_, _mbonye_, _afurtama,
   {{0xdd7db03e,0x841a22b8,0xe22550af,0x12026213}},	//   _abemiega, _moontlik, _でご注文いただく, _intiru_,
   {{0x427ee032,0x32ee9459,0x43779105,0xcf33e30f}},	//   _seinna_, _agafe_, _זערסי_, _विक्रेते_,
   {{0x62d9b101,0x03739168,0xd26c215e,0xab72b057}},	//   _devers_, _betaald_, _kakoa_, _нелиништ,
   {{0xde9b1424,0x926ce45a,0x329551fa,0xa2e3f104}},	//   _bindings_, _bliong_, _avhareji_, _navidad_,
   {{0xa43a2248,0x22e58171,0x71c3d447,0x027ec181}},	//   _ብወተሃደራዊ_, _kuingia_, _говорил_, _abonye_,
   {{0x6340e082,0xa3a2e0cf,0xfc932171,0xe26c2076}},	//   _eblebon_, _isipan_, _قاچار_, _lakoa_,
   {{0x8ae640cc,0xa74243e6,0x527ed435,0x4e43123c}},	//   _সংলাপে_, _rarotong, _alongi_, _cambiare_,
   {{0xbd037115,0xd29cd1e2,0x1e9b1065,0x026cf09b}},	//   _contrucc, _масеҳият_, _findings_, _magod_,
   {{0x7015a21d,0x32ebb146,0x624a6028,0x92e3645b}},	//   _दर्शने_, _fizikal_, _boumam_, _comique_,
   {{0x5ac051e7,0x8c772063,0x1ece12ca,0x13eb41ba}},	//   _pakkumis, _bayrami_, _каиданын_, _dietro_,
   {{0x5320d45c,0x19582031,0xb5c3a182,0x98d1d45d}},	// [420] _polyps_, _በመቶውን_, _alpasukh, _pneuserv,
   {{0x32615192,0xc9c4b18a,0x2e91320b,0xb18a406d}},	//   _студенты_, _rezervat, _मनुष्यता_, _ababayal,
   {{0x42d5126b,0x7d7bc090,0xcf80d205,0x127f715a}},	//   _kuponya_, _anamanya, _cracklin, _zdania_,
   {{0xeb61945e,0x13f46255,0x5d4ac007,0x6d5082e9}},	//   _inkluder, _boutin_, _اسپنر_, _bopabchu_,
   {{0xaa73d0d7,0x41b3d23c,0xbc677203,0x77d5c1a1}},	//   _менделее, _доволен_, _victors_, _averagew,
   {{0xa2d9a123,0xc2136310,0x32b252e1,0x7f4fd006}},	//   _adverb_, _loghat_, _adedoja_, _chipolop,
   {{0x32908076,0x1290309c,0x226850f0,0xcc51f2ee}},	//   _aikane_, _kamaal_, _naturell, _kantuna_,
   {{0x5507f128,0x13c1317d,0xe9ec63e8,0x909cb14c}},	//   _dihedral_, _сведения_, _empreend, _নিঝুম_,
   {{0xd27d61c7,0x427ec220,0x9d1bd330,0x5481110e}},	//   _саладағы_, _ubonye_, _peinture_, _gratuluj,
   {{0x96cc0287,0x244240ac,0xf27e73c2,0x574310ea}},	//   _кантроль_, _사회복지과_, _munne_, _जीविकोपा,
   {{0x8294f2bf,0xf50c121a,0x85f91248,0x0e57c097}},	//   _nyakuri_, _устаноўл, _ንሓባራዊ_, _moralske_,
   {{0x617db13f,0x527f4139,0xefa4a0af,0x02fd03bf}},	//   _מיזוג_, _keenya_, _derefter_, _viaggi_,
   {{0x3fbf202f,0x6c1f418b,0xe837020e,0x87562212}},	//   _abangeso, _serampor, _литургиј, _کارنامو_,
   {{0xa27f7401,0xa212245f,0xb091114c,0x383552e5}},	//   _teanga_, _tomhle_, _চাপুন_, _akokoľve,
   {{0x3001f096,0x1202606a,0xb9cff13f,0x24f11155}},	//   _محبوبہ_, _barito_, _preferre, _бәәйни_,
   {{0x52d87152,0x187d5149,0xcc2e7162,0x937881e5}},	//   _menee_, _agaifanu, _дадаңдәк_, _sazanda_,
   {{0x400951e9,0xb26c9336,0x32d8c421,0x227ef29f}},	// [430] _beseitön_, _aaaon_, _addee_, _alingi_,
   {{0xe395a3c1,0x5c52a180,0xf3648316,0xff270276}},	//   _tipsa_, _auktion_, _tingnan_, _مانجهي_,
   {{0x927ef0c9,0x32916243,0x5939c248,0xe78880f4}},	//   _hanner_, _diakses_, _ኮይኑዎም_, _مەھبۇبۇل_,
   {{0x8d3c30a8,0xc27ef341,0xf249f460,0x33fa62d9}},	//   _velikost_, _kanner_, _nazmeg_, _betumu_,
   {{0x93a370c2,0xbe0d31d0,0x3356d061,0x8867d162}},	//   _agapao_, _mundipha, _نرالا_, _еливатқа,
   {{0xcd973023,0x4146e09a,0x8f1c31fa,0x82b4013d}},	//   _barlamaa, _سانائەت_, _ahluriwa, _ubice_,
   {{0x227f737a,0xb2c752a6,0x437f81fa,0x4dc3a372}},	//   _ibanze_, _toplice_, _arhamba_, _masinaka,
   {{0xd27e7426,0x050db030,0x430541df,0xb302b089}},	//   _kunne_, _germaniy, _monatoj_, _stubble_,
   {{0xa2ad1297,0x36a1a3a7,0xe42d6395,0xd3a2d2a5}},	//   _مليار_, _achumach, _mipacheo_, _aropin_,
   {{0x74813275,0xa3cb1375,0xecd1b0fb,0x7801e3c2}},	//   _усуллар_, _ءﻭﺷﯩﺮﯞ_, _श्रेष्ठि, _abachagg,
   {{0x11b9a135,0x12941105,0x3290b05f,0xac93c004}},	//   _ኣምላኸይ_, _חרבנות_, _aneane_, _داداش_,
   {{0x0ea6c036,0x3c7c6365,0xc9d85012,0xf201a109}},	//   _направи_, _oppress_, _kutekele, _eivind_,
   {{0x3e3bc3df,0x4c16d024,0x9dfec461,0xa12c0065}},	//   _kvinners_, _नरश्रेष्, _adresova, _להתאמץ_,
   {{0xaef671bf,0x2d0be0c8,0x1c6e5011,0xa821614c}},	//   _империул_, _sekretor, _chereja_, _গতিপথ_,
   {{0x32e67205,0xd316702d,0x653222c4,0xcc7f011e}},	//   _bhangra_, _gonzi_, _अल्बम_, _acusato_,
   {{0x22b49041,0x66b46161,0x6200b2b8,0x523a03de}},	//   _thaca_, _achanzwi, _lyding_, _prometu_,
   {{0x22025042,0x5e73c0f7,0x36c64462,0x0292e227}},	// [440] _satiso_, _构建社会主义和谐, _अज्ञानता_, _의미합니다_,
   {{0xe394e23b,0xa202104c,0x04dda031,0xd68011cd}},	//   _monson_, _kopiku_, _እሞክራለሁ_, _arbetsti,
   {{0x12d763aa,0x127ee12b,0x47fcd005,0x2826b0de}},	//   _चाहत्यां, _ebinye_, _алега_, _بالاما_,
   {{0x9257d463,0xedfe212f,0x19ccc08a,0x527f7390}},	//   _centriol, _شەخىس_, _ذهنیت_, _baanee_,
   {{0xeceed381,0x797403f9,0xaa341404,0x7378a00e}},	//   _араду_, _allintit, _منتقلي_, _baxanda_,
   {{0xdd8b8332,0x2458617d,0xf248e3a4,0xd98ed105}},	//   _eeeeeeee_, _буквальн, _animam_, _גואנטאנא,
   {{0xb155b0ef,0xc8b960f7,0x011c3198,0xa3eb4319}},	//   _واقفيت_, _第四十一条_, _куманово_, _vietyo_,
   {{0x52b4d13e,0xc3871051,0xc07d21d9,0x73f88044}},	//   _niech_, _dearly_, _жатса_, _kukume_,
   {{0x5f4e0431,0xa35ab1b9,0x82925390,0x8b6a013a}},	//   _personne_, _оператив_, _mataan_, _bekteria_,
   {{0x288731e2,0x49f353ef,0xfa9f02db,0x6f19c031}},	//   _баланд_, _consuetu, _астындан_, _የመፍትሔ_,
   {{0xc7e0a1e7,0xf3a3f0e5,0x123bf10c,0x056b716d}},	//   _नववर्ष_, _grupy_, _anelang_, _priorité,
   {{0xec5b83ab,0xebe1f169,0xd40ab031,0xf2ee9285}},	//   _dostali_, _gewerksc, _የባለሙያ_, _agafa_,
   {{0x6e169009,0xf46dd464,0x3d838218,0x82e3e133}},	//   _значение_, _presión_, _gaileara, _reformy_,
   {{0x13ea02c6,0x9d4d531a,0x72eb20cb,0x8ba3924f}},	//   _exito_, _aupayaaq, _digidol_, _kukkuner,
   {{0xd2925163,0x52f6a180,0x11bff3ea,0xa26d1437}},	//   _bataan_, _不適切なレビュ_, _adamupem, _ambolt_,
   {{0x5ed98009,0x52fcc465,0x297650d0,0x365ed009}},	//   _расширен, _belgio_, _nalipkut, _yanikelw,
   {{0x926c3278,0x4166115f,0xd33af09a,0xe2cbd266}},	// [450] _momoko_, _kongiakl, _мәктәпли, _aololoa_,
   {{0xb2f52218,0x872c31d0,0x4a92323a,0x42911007}},	//   _laistigh_, _crimefig, _niangtas, _lakhely_,
   {{0xbf8e3466,0xa2c94199,0xffd21065,0x02b0a1a2}},	//   _شمشير_, _pellach_, _לחיזוק_, _здравоох,
   {{0x83031081,0x72b59046,0xbb1d5467,0x92fd5144}},	//   _allanut_, _risco_, _mantaña_, _angafisi_,
   {{0x753700de,0xb403a2d1,0xb2e952ae,0xac2952ae}},	//   _تاماققا_, _ڕاسپارده_, _omaniku_, _omanikud_,
   {{0xc3f803c9,0x1486a468,0x3c60401a,0xb27f00d9}},	//   _aliud_, _ल्याउन_, _partits_, _alandi_,
   {{0x8847c17f,0x4c76f30a,0x69c7c141,0x7adcb17d}},	//   _назари_, _anarasi_, _назара_, _областно,
   {{0x63eaf469,0x62e8a2eb,0x319902bc,0x61ce1287}},	//   _editer_, _gaviota_, _banenivå_, _узброены,
   {{0x59fc346a,0x6d3c332f,0x1e17c0c8,0xc387113f}},	//   _kwenzeka_, _kwenzeke_, _назвай_, _nearby_,
   {{0x37803009,0xf060b300,0xabe09227,0x2e454392}},	//   _управлен, _diskouez_, _genetisc, _menangga,
   {{0x80ce10b9,0x5b0cd2d1,0x221c5258,0xb9dde2df}},	//   _bellenil, _وامیت_, _anthon_, _dodoliga_,
   {{0xf2cb41f8,0x7bd16235,0x2c53846b,0x9d42f196}},	//   _gledam_, _conducer, _contigo_, _ordaindu_,
   {{0x3852a095,0xa3eb9337,0x5882d022,0x0752b422}},	//   _patrones_, _byste_, _ءﺗﯘﺯﯨﻢ_, _ironmong,
   {{0x8201a3c9,0xe2f42175,0xb302846c,0x17aed46d}},	//   _maximo_, _arrisol_, _saratov_, _forebygg,
   {{0xa301e2a4,0x08c0f09c,0x9d877245,0x35540282}},	//   _ostatni_, _algeessu, _ahambela, _באיערי_,
   {{0x82647217,0xbc27a2fc,0xd3948039,0xf5e821ed}},	//   _şulay_, _примери_, _nangring_, _kanatlı_,
   {{0xa23160f3,0x45e29135,0x039450ee,0x4374901a}},	// [460] _firmata_, _gazetarë, _dalsi_, _имаратка_,
   {{0x10de2096,0x6d30a122,0xfbe16144,0x5258122e}},	//   _مسجدوں_, _cannelle_, _anemfuno_, _podlaski_,
   {{0x0dcb203e,0x52926281,0xa0c02012,0xb3f883c6}},	//   _àlàbá_, _karaan_, _مشاهدو_, _mahuru_,
   {{0xe573105c,0x4fc2c15d,0x2dcbc02f,0xf175218e}},	//   _amatersk, _کانون_, _بګرام_, _okipasyo,
   {{0x72926390,0x47f2b08e,0x073d20c0,0x325bd21a}},	//   _maraan_, _sicangzv, _desplacè, _maloniai_,
   {{0x2e38946e,0x99fa3242,0xe3f472c9,0x104d141d}},	//   _irenaeus_, _starptau, _dostun_, _ہلیری_,
   {{0xba10546f,0x5570713d,0xb2905175,0x50ed3282}},	//   _estabele, _mandaluy, _lelan_, _בלינדקיי,
   {{0x40dd0007,0xd6f3206e,0xda1930de,0xabb7907f}},	//   _گیلری_, _वाढदिवसा, _disculpe, _аидыслар,
   {{0x8290e3d2,0xb15411f3,0x1659306a,0xf6d2540d}},	//   _chiare_, _قراردادو, _प्रशासकी, _کراماتھا_,
   {{0x82fca470,0x868cc121,0xd75ed121,0x19836471}},	//   _derimot_, _नादान_, _कुम्हार_, _ветерина,
   {{0x12475472,0xc2926390,0x8bb8503d,0x730f61b3}},	//   _təmin_, _baraan_, _abakumac, _apparer_,
   {{0xe354b15d,0xa29051ab,0x79bf82fa,0xcb01a0db}},	//   _فراگیر_, _kelan_, _achenget, _bitsedit,
   {{0xe292607b,0x72d55100,0x1ce61065,0x6940f421}},	//   _daraan_, _istorya_, _בבחירת_, _ademsist,
   {{0x225a41d5,0x850a720d,0x8ad4134d,0x71343162}},	//   _probuši_, _бизнесий, _flattere, _ئورگانلى,
   {{0x195260ab,0x673f0043,0x569f0299,0x0297e3d9}},	//   _billigst, _вставить_, _margheri, _kerafiki_,
   {{0xc6fd110f,0xe2249233,0x622402ae,0x59b1646f}},	//   _ٹیکسی_, _ezaka_, _isiku_, _acidente,
   {{0x82fd5257,0xafbbf2ca,0x0b547031,0x4b8bb0d8}},	// [470] _ingilis_, _congelar_, _ለዝርዝር_, _chunnair,
   {{0x858e80d7,0x2e2e0309,0xa2fe7428,0xd6e48086}},	//   _predpriy, _polonyus_, _margar_, _clicmobi,
   {{0x5e030473,0xacf2c223,0xb8c301f2,0x868301f2}},	//   _foreldra, _عالمن_, _foreldru, _foreldri,
   {{0xc3aac009,0xe3396031,0x05b6f04c,0x129051df}},	//   _второй_, _በሸራተን_, _دادرسی_, _belan_,
   {{0x8f2ee0d7,0x72d91053,0x69f8b369,0x52607387}},	//   _zamanınd, _arbeit_, _cathedra_, _aintimul,
   {{0x5c540128,0xc395e100,0xdb2312c1,0x27a7d214}},	//   _blotted_, _pitsa_, _yazamazs, _باسەكە_,
   {{0xd29052a3,0xa9f2d0e0,0x51f6134a,0x7b616180}},	//   _melao_, _क्षेप्स्, _abazimel, _ruteplan_,
   {{0xe9c9b1de,0x8db0b1aa,0x7fb52234,0x527b1214}},	//   _odgovara_, _baballwe_, _poslanco, _актобе_,
   {{0x4b893474,0x4beec263,0x7bd3e358,0x8090a008}},	//   _diciembr, _канор_, _огромное_, _азалдылм,
   {{0x620f62db,0x13007475,0x7f2c013f,0xc1fb9015}},	//   _işine_, _menaiki_, _selectin, _allillam,
   {{0x130253d9,0x5dfdc11c,0x747281fc,0xb3f8335e}},	//   _arabele_, _فلاتر_, _bulekolo_, _nemusi_,
   {{0xe2b4008e,0xbefd50ac,0x6bea5476,0xb25ae0c3}},	//   _haici_, _확인하시기_, _cálculo_, _prilog_,
   {{0xfb62137f,0x23e21187,0x2291544e,0xe3788477}},	//   _adaleker, _adalekez, _angale_, _manapun_,
   {{0x347e500a,0x785ea3be,0x89eba0f7,0x42014202}},	//   _ישראליות_, _khulukhu, _由县级以上人民政, _didieu_,
   {{0x2288d23c,0x15a091e6,0x0e48d23c,0x027ef1ed}},	//   _immagini_, _रोचते_, _immagine_, _sannar_,
   {{0xf35bf1fa,0x1d2302c6,0x7916b1f0,0x12ee9478}},	//   _ringana_, _obligate_, _агросәнә, _leafy_,
   {{0xc07d3162,0xd290c1fa,0xe181710f,0xc087d004}},	// [480] _қалса_, _mclain_, _valahogy_, _معاملاتی_,
   {{0xc7ee40d0,0x9c5e3431,0xe3947421,0x72d8c479}},	//   _atuagang, _portail_, _aansi_, _redeg_,
   {{0x92905196,0x18bb4031,0x97b5910f,0x75323024}},	//   _zelan_, _በመፍታት_, _amelynek_, _amantray,
   {{0x14d7700a,0x9277a030,0x7b7b8385,0xda85a1d9}},	//   _אנציקלופ, _радиоси_, _biasanya_, _تۇرمىس_,
   {{0xd24a547a,0x7e3432bb,0x5fc7c429,0xfae6d1a0}},	//   _igumye_, _belaelwa, _димбеит_, _sibinön_,
   {{0xc2b520fd,0xc24a6149,0x0ef7324a,0x6d18f1c1}},	//   _koodone_, _atumau_, _funksjes_, _publieke_,
   {{0xec6a536c,0x8c15c0a6,0x390ee328,0x2c460128}},	//   _गुड्डू_, _स्क्रिप्, _hunavalu, _complais,
   {{0x42b4d47b,0x33191176,0x1c10d0ee,0xa968e469}},	//   _theca_, _ايلام_, _displej_, _derivate,
   {{0x32947242,0x1e9452bd,0x537fe441,0x627ed0c6}},	//   _veikali_, _ikamahan, _finanza_, _nkonim_,
   {{0xd90f13f2,0x7045d365,0xcbe0e207,0xd2cc60c9}},	//   _bakahulu, _amerumen, _istekler, _контролю,
   {{0xa740c064,0x763200e5,0x32b5937b,0xb373847c}},	//   _科学技术部_, _अन्त्योद, _lisca_, _medaile_,
   {{0xf4684042,0xd3a30224,0x07dd924b,0x82da7057}},	//   _tindleko_, _hlaphu_, _lamaprov, _curent_,
   {{0x6947e225,0x9249006c,0xf30dc13a,0x42ff108a}},	//   _предлог_, _raamat_, _imobeta_, _استعفي_,
   {{0x524a52fe,0xa3786262,0xd81c82db,0xe2cb73e5}},	//   _agumye_, _ingamba_, _başlanýa, _hladam_,
   {{0x42c50173,0x129240e7,0xb823b0de,0x22d8517d}},	//   _bellige_, _tswayo_, _ارتستەرى, _ollen_,
   {{0xb290701f,0x123b9137,0xef4860f0,0xa68392a7}},	//   _kenan_, _biglang_, _chapitre_, _солдати_,
   {{0x3a01e2dd,0x86e620cc,0x9d9ae09f,0xe163c20e}},	// [490] _tilandze, _suscribi, _ananelwa, _помина_,
   {{0x625ad3c9,0xb020d3c1,0x02da5104,0x5875e0e9}},	//   _tellus_, _andersso, _errores_, _avaitegu,
   {{0x42b491eb,0x38889039,0x02e96363,0xd3947187}},	//   _saach_, _bakhatdu, _marieta_, _pansi_,
   {{0xf926c0c9,0x3faae2ab,0xaf6a326d,0xbc75f329}},	//   _причин_, _informuo, _arabiwan, _blesing_,
   {{0x275450a3,0x6d2dc005,0x43f280db,0x4ebe147d}},	//   _tegnolog, _прашу_, _bolumeli_, _calgacus_,
   {{0x43947045,0xaad622cb,0x90b3947e,0x4feeb15a}},	//   _wansi_, _واشنگٽن_, _nonmetal, _अवमानना_,
   {{0x237862aa,0xbc7571c3,0x95427042,0xaf86913c}},	//   _angamba_, _adhradh_, _alikabuy, _ajánte_,
   {{0x3ec1b177,0x594f127a,0x6b5b70ff,0x8ae2047f}},	//   _acinnaan, _sprostre, _afmelden_, _realizan_,
   {{0xfaf3e085,0x89aac17f,0x9d4db248,0xbf91d1ca}},	//   _ক্ষেত্র_, _помир_, _ብኣስገዳድ_, _پرٕژھ_,
   {{0x51cfd1bf,0xd2d8c285,0x52b591c2,0x685fc2b7}},	//   _адаптат_, _tuleme_, _wisch_, _halartar_,
   {{0x6b6bb038,0xf27f4067,0x2fc8a090,0xe2fdb21e}},	//   _kedokter, _ebenye_, _ebrongho, _diwarisi_,
   {{0x0c8012db,0x75b5109a,0x7379644c,0x0cf38173}},	//   _берен_, _отурисид, _garatua_, _annalyýe,
   {{0x283240ac,0x4246b1b5,0xdcac3004,0xe2cae335}},	//   _잊으셨나요_, _استاناعا_, _اللهی_, _mender_,
   {{0xdf02c21c,0x20ec12e8,0xd27ef480,0x860421a1}},	//   _སྒྲུག_, _speisial, _bannor_, _implausi,
   {{0x820e1196,0x85d1b0fb,0x228383f1,0x7387d1bf}},	//   _бараг_, _chrutvā_, _atikala_, _примэв_,
   {{0xe25502c6,0xfe91e16f,0x5868b022,0x63eaf0ca}},	//   _governam, _nuntempe_, _банкротт, _aditir_,
   {{0x4f78a273,0xe49c20b5,0xb368c2b9,0xf6085009}},	// [4a0] _ngẩng_, _ﺍﻟﺨﺴﺎﺌﺭ_, _langres_, _доступны_,
   {{0xf50cd0e8,0x3302113f,0xf4394102,0xce94437f}},	//   _automaty, _החיצוני_, _наприкін, _adamulan,
   {{0xb987b142,0x23f152f4,0x235b1025,0x9107b362}},	//   _prikazat, _мөртлөө_, _afirìkà_, _prikazal,
   {{0x14b9d196,0xdb281139,0xe9cf3180,0xc1a8c050}},	//   _английн_, _asaammes, _ウェブリブログの_, _一個機緣裡_,
   {{0x19c71481,0x7f481044,0x5a4ca249,0x726cf2ee}},	//   _чаралар_, _ringarin, _mundiala_, _zagon_,
   {{0xd38920de,0x230310be,0x2f9bd1bb,0x3b9730d2}},	//   _چىڭلۇڭ_, _allahut_, _şampiyon, _relació_,
   {{0x83ead39b,0x15b0b482,0x66447105,0xefffc1a5}},	//   _sentle_, _yingceny, _קאָסטן_, _abakatho,
   {{0x497863c7,0x4b3c8129,0x93eac151,0xca799483}},	//   _administ, _སྟོངས_, _lwmtus_, _тойларда_,
   {{0x1b62c345,0xd43b81bc,0xaf191330,0x693c0234}},	//   _कलपना_, _отчету_, _尚不构成犯罪的_, _aimmonit,
   {{0x0b43a2bd,0xc711b144,0x126cf1df,0x32a07484}},	//   _ветеранд, _aguculiw, _tagon_, _barbut_,
   {{0x02b273dd,0x964c6019,0xc2cae3b0,0x42d8b097}},	//   _vladara_, _פּרנסה_, _kender_, _ordene_,
   {{0x4290724e,0x769e6030,0xc21a6292,0x9213141f}},	//   _tenan_, _мовароун, _фариштал, _bochbe_,
   {{0x7213e3d8,0x4d9f20fa,0x69eb23b0,0x3413c09a}},	//   _oaths_, _porodica, _befriend, _ماڭدى_,
   {{0xb5a1f39a,0x2164922e,0xd3897031,0xbd2c6193}},	//   _बताती_, _mahogany_, _አፍጋኒስታን_, _bändigen_,
   {{0x439472b7,0x9e41e1b3,0xa137c009,0x1452f0f7}},	//   _kansu_, _paradoxe_, _данном_, _对应的网络投票表,
   {{0x2c48a36b,0x7e45c098,0xd33d327f,0x8af2b0c7}},	//   _antwort_, _bigaraga, _هیشام_, _horreeye,
   {{0xea1ec0f4,0x134040ee,0x5c5a5018,0x51e9b115}},	// [4b0] _диний_, _modelka_, _sunteti_, _arrondim,
   {{0x949d6485,0x02e0b0c6,0x4b018423,0xbc4ca1bf}},	//   _श्रमजीवी_, _bɛfaa_, _betrokke, _комитету,
   {{0x43808373,0xdf11f29a,0x7273b0de,0x67dc11c9}},	//   _སྦྱོངས_, _bertujua, _اتەيىست_, _hydropow,
   {{0x6395e00e,0x34b6038c,0x3081c486,0x32a85134}},	//   _vitse_, _kompanij, _trabalho, _angaaraw_,
   {{0x9fb313db,0xca3d10b3,0xfeb242d7,0xb2569032}},	//   _dialogbo, _seminarı_, _digokgon, _sóley_,
   {{0x17057063,0x3a06f20a,0xf0e5503b,0xaf99d09a}},	//   _ақшнинг_, _kubatiza_, _akungcol, _бирилиди,
   {{0xcdc8a018,0xd174d0f7,0x7653f0a3,0x1eeef419}},	//   _викиману, _第四十八条_, _beskuldi, _desventa,
   {{0x33870487,0x3a9050c9,0x826cf07e,0x3c664488}},	//   _ngarah_, _медицини_, _lagom_, _gratwit_,
   {{0x1c2a1489,0xd347248a,0x3a531399,0x251a3248}},	//   _nebudú_, _blodkar_, _engetela_, _መንፈቕን_,
   {{0xd3c800e5,0x4b648249,0x826d2292,0xd154948b}},	//   _प्रतिरक्, _pretenda_, _bayon_, _kristoso,
   {{0x620e10d2,0x13234272,0x42da547b,0x33f40086}},	//   _качан_, _marchar_, _butere_, _icstis_,
   {{0x17b30144,0x02027197,0xa3eaf17a,0xd9c3c1d1}},	//   _unreserv, _periuk_, _heiter_, _shambila_,
   {{0x93f9600a,0xa43f408a,0xe16fa180,0x73a2e0cb}},	//   _august_, _استعفئ_, _掛け軸の店ひのき, _sgipio_,
   {{0x33947240,0xe224d2ec,0xf539e43b,0x22da63e6}},	//   _kanst_, _czeka_, _proactol_, _aurere_,
   {{0x623ba48c,0x924a7102,0xd26d248d,0x29cb036b}},	//   _atumatu_, _termer_, _gayon_, _beleucht,
   {{0x92d873c9,0x7c6f816f,0x427e7172,0x931d82fe}},	//   _omnes_, _spirito_, _bunne_, _icicaro_,
   {{0xa350616b,0xd2e7e1a7,0x128d4306,0x83e04152}},	// [4c0] _photolum, _pionero_, _yisakham, _hallituk,
   {{0xe310b46e,0x0979b185,0x73234199,0xfc690284}},	//   _chuckle_, _asantehe, _carchar_, _carreto_,
   {{0xc2c9448e,0x89fce01f,0xe2a6316f,0x7fc16126}},	//   _bellach_, _makarant, _nombro_, _nabokono,
   {{0xc33d3030,0x627e7345,0xa27ef320,0x83807258}},	//   _ویران_, _tunne_, _yanner_, _torrak_,
   {{0x46936143,0x1290a1a0,0xc4730381,0x77a3e2e5}},	//   _comentai, _geban_, _festejan_, _žarnovic,
   {{0x4b28b2ab,0x1c6240dc,0x0386b437,0x127f7459}},	//   _транспар, _امانات_, _fjerde_, _ibanye_,
   {{0x85c8f39b,0xf1fc623f,0x82c24143,0xe99811d8}},	//   _bagaetsh, _ancianam, _amelisa_, _ngayakeu,
   {{0xd366a369,0x31a9f18a,0x9487c30f,0xbc4fa007}},	//   _lingual_, _аранжаме, _स्वाईन_, _bátran_,
   {{0xe2f0c056,0x8200a039,0x0dc371d8,0x72d9811b}},	//   _badiidi_, _iwbih_, _kawijaka, _odred_,
   {{0xed210272,0xe8fb1182,0x527f7267,0x26e04179}},	//   _genitive_, _agrapuru, _mbanye_, _alfarið_,
   {{0x8e522412,0xe44601d9,0x282e9009,0x52da6098}},	//   _aqhanaka, _قاققان_, _условиях_, _turere_,
   {{0x9f398120,0x01c9221a,0x57aa830f,0xba2d1041}},	//   _muenster_, _кошту_, _westerli, _ولیده_,
   {{0xe70422e5,0xa5841063,0x8395e01d,0x6eaf8368}},	//   _distribú, _dastlabk, _antsi_, _kalomuan,
   {{0xc2ea03f7,0x82fce079,0xde3583ec,0x42267039}},	//   _afriken_, _bengko_, _rowlands_, _shukor_,
   {{0x927f7296,0xa823e1b6,0xfa1710f7,0x527e700f}},	//   _abanye_, _འགྲིན_, _徐州监察分局_, _sunne_,
   {{0xd460d0f7,0xc7c18026,0xa8a2d024,0x1506a263}},	//   _香艳的寻宝之旅_, _betrekki, _योगशास्त, _гуруснаг,
   {{0x5791f48f,0x37e81252,0x3af7c03b,0x3ad1f1d0}},	// [4d0] _institui, _encarreg, _ahlukume, _institue,
   {{0xabca217a,0xfb8cb2f4,0xc088d427,0xa2917267}},	//   _সংযোগেৰ_, _компанит, _самочувс, _imaara_,
   {{0x2387718b,0x4290f1b9,0xb47e10c7,0xf2aab276}},	//   _charle_, _akhang_, _agagaark, _پرنسپال_,
   {{0x22003177,0x3fba224b,0xe2e8636f,0x2291b267}},	//   _aamine_, _заключае, _bafihla_, _inwale_,
   {{0x346103aa,0x3e1b633e,0x51d45264,0x022ba3ad}},	//   _disebutk, _jangkita, _ميجابايت_, _vermoed_,
   {{0xcf41127d,0x8d37c292,0xc2915296,0xb249744e}},	//   _doorasha, _یکسان_, _ingane_, _anamam_,
   {{0xaf4e8392,0xd301b084,0x7290c317,0x33f821a4}},	//   _bersenja, _alabase_, _ledan_, _hokua_,
   {{0x2e9621d9,0x63f82356,0xb8fbb1c5,0xe3f2b490}},	//   _عىلىم_, _kokua_, _donaklad, _atuzame_,
   {{0x7101c005,0xee29d032,0xa9e95056,0x42da744e}},	//   _свету_, _bygginga, _mengwage, _adrees_,
   {{0x42ee60d7,0x9a98900f,0x4eaf132b,0x0b5203bd}},	//   _sängat_, _натисніт, _gwariant_, _swadizan_,
   {{0x2291712b,0xe16121d0,0x6559a140,0xf76a8180}},	//   _amaara_, _gorgasal, _artistı_, _個人的には_,
   {{0xfe6c2030,0x25755447,0x906011e9,0xf5445491}},	//   _عیسوی_, _откровен, _fajistik_, _परफेक्ट_,
   {{0x5290c22f,0xc29050d9,0xa291b12b,0x2df162ec}},	//   _jedan_, _selah_, _anwale_, _ocidenta,
   {{0xe2d87492,0x3290a475,0x39bfa1ca,0xdd0940ff}},	//   _emner_, _kebal_, _majeerte, _wellicht_,
   {{0xd2bac0ce,0xdc09f0c3,0xd2d55296,0x2f239322}},	//   _eredeti_, _pripada_, _abaloku_, _celeeman,
   {{0x4e2810bf,0x4a8cf0f7,0xc1253213,0xaeb12426}},	//   _айланган_, _胶南市民政局_, _kusisiña, _bibelens_,
   {{0x9290c3c1,0x7b0c2352,0x73004392,0x7e76f327}},	// [4e0] _nedan_, _کاتیا_, _memadai_, _as̟ojú_,
   {{0x7aa0a026,0xcd2a0463,0x8dfe911b,0x2af7223c}},	//   _verkopen_, _agrigent_, _neverova, _дарения_,
   {{0x1c93d252,0xe3006261,0xc987d1a8,0xdff5a381}},	//   _керектиг, _innanzi_, _сродак_, _атенниса,
   {{0xba68a135,0x22903343,0x0f274183,0x96a0b1a1}},	//   _ሕክምናዊ_, _mamalu_, _corespon, _objectsw,
   {{0x8553f24b,0x6299b27c,0x393ab1d2,0x32d8c049}},	//   _amakheth, _アウトドア_, _chaminda_, _aldea_,
   {{0x68dc5493,0x604c6067,0x6bd3941e,0x838803a1}},	//   _tarraing, _amaramon, _स्वयम_, _abayala_,
   {{0x7f9430fc,0x1c62700e,0x52003047,0xa46073aa}},	//   _класта_, _dostluq_, _famile_, _melepask,
   {{0x827ef1f2,0xb27ed3db,0x036400c3,0x241ef031}},	//   _kannar_, _ordne_, _dragana_, _በቀዳሚነት_,
   {{0xb2926039,0x4636120e,0x827ce143,0xdf2731bc}},	//   _iarain_, _discussã, _azangaki_, _талапк_,
   {{0x72003207,0x32d5e2c0,0x056d201c,0xef5f40dc}},	//   _hamile_, _bayliku_, _داستانوں_, _dotacion,
   {{0xc7c733df,0xf6ce3186,0x6387723e,0x02b51177}},	//   _такими_, _rutagani, _alarba_, _aracay_,
   {{0x027f01a0,0xdebe2228,0x8a91f494,0x6c4c9214}},	//   _ikanom_, _pangurus_, _turizmin_, _фототопт,
   {{0x935bf1d1,0x63f91029,0x9425d0ac,0x78c480de}},	//   _lingana_, _kaburu_, _반도보라스카이뷰_, _اچىشسا_,
   {{0x1290c2e4,0x220273fa,0xe3bc600f,0x2d85e06e}},	//   _vedan_, _musial_, _потребую, _आगेकूच_,
   {{0x61d6100a,0xb2d9b495,0x037960cf,0xb6317496}},	//   _ישראלית_, _arvest_, _matanda_, _dailynew,
   {{0x2773906d,0x4844a497,0x86a6023c,0xae44d030}},	//   _доллари_, _खंडेलवाल_, _ringrazi, _aksariya,
   {{0xab182405,0xf35bf1af,0x33644354,0x527e7078}},	// [4f0] _هههههههه, _hangaia_, _elegida_, _gunna_,
   {{0xaa6d40db,0x127ef498,0xd347a499,0x8d3d7140}},	//   _последня, _dannar_, _वर्डप्रे, _концертл,
   {{0xab62449a,0x620263bf,0xdd3ea431,0xeecf23ed}},	//   _नतिनी_, _marino_, _souhaite_, _divisjon,
   {{0xc26cf22e,0x024a71d0,0x135bf496,0x79b712a7}},	//   _lagoa_, _germir_, _dingana_, _ماکسین_,
   {{0xbdae00b2,0x46b96130,0x530453e7,0x49d702bd}},	//   _kasnasda, _kalandri, _bakanam_, _behehile,
   {{0x12b312db,0x227e7249,0xb320c365,0xc1e990b3}},	//   _формал_, _dunna_, _dreissig_, _хроногра,
   {{0x89f1e032,0x72ac82c4,0xdef81248,0xcc54249b}},	//   _endilega_, _आधुनिकीक, _ሰበይቱን_, _pyntuid_,
   {{0x4dd7e011,0x4cb72064,0xfd8d4166,0x32f0e244}},	//   _владисла, _您当前的位置_, _immodera, _puripch_,
   {{0x32fd749c,0x8fbf1019,0x32cae075,0xf26c43ea}},	//   _thairis_, _מוזיקאַל, _vendar_, _symon_,
   {{0x539470d1,0xd290c07e,0xb2e2a2ae,0xf44aa49d}},	//   _hansi_, _redan_, _loginud_, _serveren_,
   {{0xb9d2e003,0x52d8b118,0xe290c00a,0x52d8a201}},	//   _tallinna_, _nadeem_, _sedan_, _ambes_,
   {{0x2c7e0100,0x34ecd248,0xf2fd50d8,0xfc2952ae}},	//   _bersyon_, _ብዘየማትእ_, _aiginis_, _elanikud_,
   {{0xf2e7611b,0x791dc336,0xd27ec04e,0x55eda105}},	//   _putnika_, _akonakí_, _sconce_, _שייעך_,
   {{0xe7a3832d,0x42d8c0b9,0x4bfcf0dd,0x1b7e00b4}},	//   _gandharv, _elden_, _vergader, _aikupika_,
   {{0x71f8c404,0x0962b1d9,0x7201549e,0x8ca3c275}},	//   _مقالا_, _деректер, _gneiss_, _алматаға_,
   {{0xc5a260d7,0xc27e72e1,0x9063c152,0x95ac90fb}},	//   _başlığı_, _funni_, _голосов_, _परंतप_,
   {{0x92d8a003,0xb347d0f3,0x9695249f,0x32d85043}},	// [500] _umbes_, _ginevra_, _materiai, _ellei_,
   {{0x10e4b06a,0xc6902043,0x9e68e174,0xc27ee4a0}},	//   _सुनीता_, _справочн, _koristeć, _nginza_,
   {{0x9fe8b10e,0x1290a088,0x73031258,0x332091a3}},	//   _सिरामिक_, _sebab_, _allamut_, _zwayo_,
   {{0xcc7c026f,0x029454a1,0x2206c2df,0x63949084}},	//   _biasana_, _linkovi_, _digitaki_, _abosù_,
   {{0xa202500c,0x7290c2e2,0xdb5d2008,0x9c6ef11c}},	//   _patino_, _medam_, _басырлып_, _teorann_,
   {{0x82d8a01c,0x13e89026,0xbb9b7185,0x52b491cf}},	//   _ember_, _태터데스크_, _latinfoo_, _daach_,
   {{0x47fcb431,0xdc1ce27c,0x52d66333,0x8047a105}},	//   _只看该作者_, _サイトマップ_, _podobno_, _שׂונא_,
   {{0xd6c76046,0xeb443192,0x127ed03e,0x93793054}},	//   _financei, _редакцие, _afonja_, _labarun_,
   {{0x247230a8,0x22b59354,0xf24a7257,0xae72420e}},	//   _libereck, _disch_, _vermir_, _инфлациј,
   {{0x323862ae,0x2c53739e,0xf049202d,0x0da73061}},	//   _inimesi_, _sartana_, _anonimek_, _موچڙا_,
   {{0x9047d263,0xbe074105,0x014562f4,0xd20084a2}},	//   _юшенко_, _סימפּאַט, _espezial, _makine_,
   {{0x5504837c,0x5c6341ba,0xc373f0c3,0xc9da8491}},	//   _futtango_, _imprese_, _dodajte_, _पुलवामा_,
   {{0xfc0544a3,0x993a2102,0xcc6e82d5,0x32f2f131}},	//   _chorvats, _мірою_, _beirinn_, _समोरच_,
   {{0xd37f84a4,0x03ea0289,0x0e537093,0x32e3a345}},	//   _ishamba_, _evito_, _ditangka, _parimad_,
   {{0x6a7c8285,0xd2d8513d,0x137932b7,0xb5380124}},	//   _makanisa_, _solec_, _dabarun_, _латвиатә,
   {{0x758a02e5,0xe2ea0329,0xe2d97095,0x229154a5}},	//   _registrá, _agrimen_, _arboles_, _digale_,
   {{0x055274a6,0x9335e290,0x2c00d0e1,0xc2d8c1ef}},	// [510] _सत्यनारा, _रथयात्रा_, _abisses_, _beleti_,
   {{0x030cb258,0x9290330e,0x9e187079,0xf144c3d0}},	//   _sisamat_, _nejak_, _deregila, _европчуу,
   {{0x837972fa,0x263ee03b,0x893ff20a,0x7b7ad187}},	//   _varanda_, _agunyatw, _abamutya_, _akasanza_,
   {{0x0b013085,0xb2d8d06c,0xca9d814c,0x437fe054}},	//   _সময়টা_, _poleks_, _ভাঁড়_, _sunansa_,
   {{0x79f61004,0xb2e74140,0xf2025339,0x4236d27a}},	//   _سوریه_, _рубрикал, _netiek_, _nieje_,
   {{0x1394b1db,0xd582f110,0xa2d8523b,0x02903225}},	//   _fleste_, _kategory, _bolea_, _sejam_,
   {{0xbd6da248,0x427ea0f6,0x514fc33c,0x805fd196}},	//   _ተቐዳዳማይ_, _lubna_, _услуб_, _poliziak_,
   {{0xa77333f6,0xc2d85190,0x0f59c1f7,0x7db99139}},	//   _प्राधिका, _dolea_, _милицияд, _beenisha,
   {{0xe31bc32d,0xedbde213,0xfdaa82f6,0xa2e3b421}},	//   _cetasā_, _mayitana, _mudugudu_, _argiine_,
   {{0xe2f1e23c,0x954122e8,0xa2b490e9,0x2097c008}},	//   _diritti_, _الزاوية_, _abaco_, _дилинде_,
   {{0x0fe03401,0xd9c71009,0xf8471009,0x225ad191}},	//   _sadistic_, _начала_, _начали_, _gullet_,
   {{0x62d87048,0xbb01c197,0x9032606a,0x1ea12121}},	//   _konec_, _persekit, _जवाहर_, _sportnet_,
   {{0xe153c0f7,0x42eed46c,0x9ca40062,0xda6cb440}},	//   _企业国有产权转让, _stoffa_, _alagaupu_, _atambwis,
   {{0x3e9e1263,0x32905238,0xf529e11b,0x420094a7}},	//   _насли_, _eelam_, _разматра, _fokisi_,
   {{0x9ef41248,0xd56f5248,0xb1db7180,0x1fecd048}},	//   _ላዕላዋይ_, _ፋሕተርተር_, _上田慎一郎_, _सिटौलाले_,
   {{0x14a8417a,0xe290e2c0,0x1b7f201f,0x77e2f227}},	//   _সমস্যাৰ_, _defal_, _bangaren_, _관리자에게_,
   {{0x072a63df,0xe3452032,0xf28dc32d,0xc2bca253}},	// [520] _приватни, _myndast_, _anipphal, _condell_,
   {{0xa280c35f,0x52d8e08f,0xf85da105,0x52d060b5}},	//   _novinky_, _elfen_, _משביע_, _ﺍﻟﻘﻀﻴﺔ_,
   {{0xf35bf104,0x1290e24a,0xac2632a7,0x229113e1}},	//   _ninguna_, _gefal_, _دئییلمه_, _lezan_,
   {{0x53a9c0c7,0xbcd6b212,0x6f324418,0xf33d027f}},	//   _پٲزار_, _دامطلب_, _abafanan, _ڵینان_,
   {{0x94c000b5,0x686a312f,0x43052351,0xa26d9043}},	//   _نازەركە_, _базардик, _قوچان_, _tasoa_,
   {{0x54160105,0xdb0a6415,0x0958d0b3,0x496ee15e}},	//   _קיבארד_, _заналхий, _донорлар_, _etengabe,
   {{0xebadd4a8,0x142d218a,0x91d161a1,0x8236912b}},	//   _गणतंत्र_, _католика_, _entercay_, _anaju_,
   {{0x122494a9,0xd27e7240,0xb2e1c06a,0xc4ce4234}},	//   _mpaka_, _kunnu_, _ग्रीस_, _prezerať_,
   {{0x8327d2a3,0x47e3d17f,0xd7298271,0x7897d212}},	//   _урамда_, _мобилии_, _diplomov, _خرابې_,
   {{0x4e02206a,0xa057b1c7,0x02da0033,0x0cbaa0f0}},	//   _सुरक्षित, _назарға_, _aspere_, _magnifiq,
   {{0xa3f7a13f,0x5688e3ce,0x5a0914aa,0x0289f212}},	//   _amazing_, _kinderli, _klubapre, _مرغومی_,
   {{0xaef2f283,0xeeba707e,0x75cca109,0xd26ce05f}},	//   _akakavun, _annorlun, _ahuacatl_, _hinoma_,
   {{0x4019e0b3,0xd373b22f,0x344520bf,0x705a220e}},	//   _францияд, _pomaže_, _буткул_, _транзици,
   {{0xb3966183,0x293401a7,0x32e69010,0xd8fd2287}},	//   _forsan_, _amemorat, _stinkin_, _сяржук_,
   {{0x54d6005a,0x797d0050,0x9103c1fa,0xa067043d}},	//   _مايكىل_, _一些漆面較軟的車, _ezekiyel, _forskarn,
   {{0x62d851c7,0xa27f74ab,0x1037c022,0xc37972ab}},	//   _бизнесті, _abanje_, _анасы_, _apranga_,
   {{0x1290c134,0xa7df214d,0xb57a9096,0xb3e2f096}},	// [530] _addat_, _कलाकारन_, _برطرفی_, _محاصرے_,
   {{0x926d92fb,0x83052438,0xdccd2140,0x827e7240}},	//   _fason_, _جولاي_, _комитеты, _vunnu_,
   {{0x62d83338,0x5224035a,0x20ff608b,0xda179309}},	//   _uljem_, _upiki_, _اثربخشی_, _lubaghha_,
   {{0xe2903088,0x92d85101,0x9b42425d,0x92ba444d}},	//   _sejak_, _koleg_, _tribalis, _prodati_,
   {{0x3ea7b22e,0x4323206f,0x5e72e1e7,0x4b43d45f}},	//   _cellphon, _século_, _वाष्प_, _lokalitě_,
   {{0xcb88601b,0xd3ec30f4,0x2242f345,0x72d8e0c8}},	//   _аладалан, _вирусида_, _चलवला_, _menesi_,
   {{0xc69e70e0,0x3550419e,0xf2d981d8,0x57a0d24a}},	//   _anagārik, _kaikauwh, _sereg_, _fertragi,
   {{0x526cc184,0x530ed217,0x0368c124,0x72d833ab}},	//   _filoha_, _bularaq_, _абаза_, _dojem_,
   {{0xb287f4a2,0x12d8e161,0x49b1714a,0x433c91ab}},	//   _hastalık, _genesi_, _bandelet, _maikling_,
   {{0xcc52e1f6,0x02018006,0x1843c0ac,0xa942a276}},	//   _अवशेष_, _mizimu_, _하였습니다_, _بحيثيت_,
   {{0xb2907278,0xb3660105,0x097ad0f5,0x92c0c0d7}},	//   _tenau_, _אינדעקס_, _enthalte, _анган_,
   {{0x53f8f2ca,0x62249233,0xf3006234,0xdf5960f1}},	//   _algun_, _isaky_, _podnikov_, _supplert_,
   {{0x12d85199,0x5c441012,0x031d3015,0xaabd2388}},	//   _coleg_, _utawala_, _leccion_, _جیاده_,
   {{0xe2d8322f,0xdab99018,0x21e1f11c,0xac5ac1df}},	//   _kojem_, _политиче_, _cruinniú_, _pretigi_,
   {{0x523b039b,0x7291009c,0x020083d9,0xa0b770c2}},	//   _akolang_, _abaaru_, _bakile_, _инвалиды_,
   {{0x74ef40c9,0x0290c199,0x92787039,0x52d4c01d}},	//   _спортивн, _addas_, _younis_, _almosen_,
   {{0xbc3fd1d9,0x59e6824b,0x52d85199,0x7290506e}},	// [540] _адамға_, _мастера_, _goleg_, _kelak_,
   {{0xeb1002e5,0xa7ac800a,0x3060020f,0x1b84e0c9}},	//   _prostrie, _effectiv, _prosesin, _екологіч,
   {{0x62e682e9,0xf2846009,0xc9f8f2c2,0x4e428287}},	//   _klingon_, _безопасн, _milijuna_, _kataloge_,
   {{0x503c9168,0xd23ba039,0xa5e6910d,0xe1767121}},	//   _namelijk_, _bhalang_, _кадраў_, _प्रतिघात_,
   {{0x679fe081,0xb0e81088,0x40ad1004,0x39e26095}},	//   _avatangi, _sebanyak_, _مشورت_, _disgrunt,
   {{0x51c9c36d,0xd37b02d7,0xc4d020c5,0xab0d74ac}},	//   _中正紀念堂_, _ditaelo_, _aricurik, _funcións_,
   {{0x777bd108,0x2f79926a,0x14399111,0x146860e5}},	//   _اساسی_, _problems_, _problemo_, _महानगरों_,
   {{0xf46393d6,0xc1dcd030,0x63eaf21c,0xc486014d}},	//   _linelwaz, _اتقاقی_, _editur_, _प्राते_,
   {{0x32d852d2,0xa2d8a08c,0x326d134d,0xfb0481c3}},	//   _allem_, _albei_, _naboth_, _caigeann_,
   {{0x3612019c,0x52240233,0x8f42f1a5,0xb7c2f370}},	//   _haalelei, _tsiky_, _abashada, _abashadi,
   {{0x5290e0d8,0x570901e2,0x2d4e4063,0xd23bb05f}},	//   _chiall_, _пешини_, _самарали_, _ahumanu_,
   {{0x889700b5,0xe2d85075,0x023930d7,0x7f58e4ad}},	//   _ﺟﻴﺎﺑﺎﯞ_, _poleg_, _согуд_, _boraosen,
   {{0xcfa5233c,0x0290c0ec,0x489a80af,0x735fd0ac}},	//   _موقعی_, _islame_, _したがって_, _아이들에게_,
   {{0xa3b50155,0x5290c148,0xed1da2a7,0x0291616d}},	//   _ئىلھام_, _pedah_, _قیلرایشی_, _digart_,
   {{0x88aed451,0x237a1054,0x5c05f093,0xf52950be}},	//   _demjanju, _karatun_, _persegi_, _eksploro_,
   {{0x33f84032,0x82ea80de,0x539582a9,0x412c522e}},	//   _komum_, _айлампас, _wirst_, _südliche_,
   {{0x133d30c7,0x8f20129a,0x22909012,0xf2137144}},	// [550] _شیران_, _kepulaua, _makamu_, _alahle_,
   {{0xf34851c6,0x5631c043,0x4d1f1012,0xd532c34e}},	//   _lineari_, _erinomai, _مسجدون_, _abazonik,
   {{0x01eb20c9,0x75a8c109,0xbde5f45b,0x331cd0b3}},	//   _автореф_, _synspunk, _annonçan, _adresı_,
   {{0x25b7b027,0x9d271405,0x6eac407f,0x029161f2}},	//   _disposiz, _مهرجان_, _cañón_, _sigast_,
   {{0x4a57c38c,0x0d875079,0x8ae3f027,0xe2131071}},	//   _никада_, _akselere_, _settembe, _hichte_,
   {{0x92a13026,0x1146d2d5,0x94e10292,0x92d17093}},	//   _불가합니다_, _amhlaobh_, _پیشانم_, _disertai_,
   {{0x3655611e,0x0dd562ca,0xc1501065,0x8290c2d9}},	//   _conjunti, _conjunta, _הצבאית_, _dedaw_,
   {{0x7201f02f,0xdbf5c0d6,0xb92e42c3,0x7e438300}},	//   _maziko_, _esitjhab, _بازارلار_, _lavarout_,
   {{0x62647483,0xec6d82fc,0x13f89027,0xaf5d43e1}},	//   _arslan_, _pokriva_, _plaun_, _desandan,
   {{0xd963e147,0x39e0c29a,0xa23694ae,0x748620ef}},	//   _prosinac_, _menggant, _viaje_, _مطالبي_,
   {{0x925ad4a5,0x0f10c313,0xb26d03ce,0x59c2c01a}},	//   _jullit_, _tautauva, _gebore_, _divendre,
   {{0xa2267059,0x96db0078,0xfe7254af,0x357da065}},	//   _shukur_, _يااااااا, _आरम्भ_, _אביעד_,
   {{0x5d06c21a,0x2365921c,0x3b0a945a,0xf7a450c9}},	//   _retriver, _qingdao_, _iexpecte, _тематичн,
   {{0x7290c175,0x1394e0f3,0xb40d6283,0x6290c1a1}},	//   _cedaw_, _ulisse_, _ayonakek, _adday_,
   {{0x5c7f1042,0xc607f09a,0x735a242e,0x3844f0ae}},	//   _akusimo_, _ашулар_, _selfoss_, _vermədən_,
   {{0x1af501ec,0xcc6ad308,0xac702055,0x4a8950f6}},	//   _importan_, _makungu_, _spiritu_, _ташланма,
   {{0x5c7f626a,0x34d7c0ea,0x09f8527d,0xd61d73c7}},	// [560] _january_, _पोलिसी_, _caasimad, _valoraci,
   {{0xf2d85226,0xaa76e4b0,0xd2cae16f,0x3a8682e7}},	//   _kolem_, _šezdeset, _hindio_, _ananyamb,
   {{0x14a6806a,0x9eb34150,0x5de73105,0xab8f1436}},	//   _प्राधान्, _forskere_, _אינדארסי, _tennengo_,
   {{0x2628e09c,0x43877161,0x825bc063,0x4af1c00f}},	//   _accounii, _acarol_, _портловч, _engserve,
   {{0xe86ca483,0xec20730e,0x147a74b1,0x1ecd10dc}},	//   _маслахат_, _चुरेभावर, _pyntroin_, _similars_,
   {{0x2985c0fa,0x925ac177,0x15e3b0fb,0xedc0d052}},	//   _visinama_, _mallow_, _प्रमाणम्_, _komisija,
   {{0x1eacb46a,0x9f90c007,0xac047174,0x27aa814c}},	//   _esithile_, _بنايا_, _srđan_, _ক্ষেতে_,
   {{0x5231d0ce,0x52901411,0x2a9042f3,0x6ec1d2db}},	//   _بخاری_, _rehat_, _величини_, _tehnikan,
   {{0x6290106e,0x9354f492,0x232000d9,0xb4a140d7}},	//   _sehat_, _øverst_, _atiye_, _ataması_,
   {{0x43f8b273,0x76ad3105,0x4aec03ef,0xc290a0b0}},	//   _mocua_, _אַרכיטעק, _selestib, _tebal_,
   {{0x59e4b19e,0x2394e405,0x2af84296,0x21acd180}},	//   _mokopuna_, _coiste_, _abasempe, _最新の投稿_,
   {{0x6a7213ab,0xf9828162,0xe385c200,0xbeda42a0}},	//   _značka_, _доктур_, _churapki_, _واژۆکۆکر,
   {{0xb2cad0bd,0x1f3e213e,0x3c17524f,0xc3430018}},	//   _vandag_, _गिरिराज_, _allaaner, _modelul_,
   {{0x1364310a,0x985150fb,0x029134b2,0x735661c8}},	//   _موسمي_, _विद्यात्_, _lexam_, _experts_,
   {{0xc2d85114,0xd853f2b5,0x2c0b6074,0x72cae4b3}},	//   _kolej_, _endanger_, _perpara_, _bendir_,
   {{0xad73217a,0x5f3fa06e,0x42e97284,0x14cd13a1}},	//   _মাধ্যমহে_, _tangeran, _chrisma_, _akacwano_,
   {{0x24f010de,0x6878b0bb,0x92c4c2d5,0x42ed4496}},	// [570] _анына_, _продовжу, _chomais_, _depiote_,
   {{0x4944416d,0xa27864b4,0x284f71bd,0x74a1b2f2}},	//   _chauffer_, _daunim_, _kambodži_, _forması_,
   {{0xc0114104,0xd603c2f3,0x8141c121,0xabd640fe}},	//   _producto, _колико_, _न्यूटन_, _amadolar,
   {{0xb02524b5,0xa3eaf222,0x8ee04086,0x0290a4b6}},	//   _خونرن_, _leitar_, _lightzon, _gebam_,
   {{0xb3f803c9,0xbc6cd3e5,0x92010077,0xd290f144}},	//   _alius_, _nebudem_, _alaisi_, _ashade_,
   {{0x1231811b,0x922092fd,0x31aa5009,0x12e881a0}},	//   _септембр, _زیادتر_, _таможенн, _monitan_,
   {{0x99fa34b7,0x12907004,0x42fcf188,0x9a0610ef}},	//   _mccaffre, _genah_, _ziggy_, _ڏکويل_,
   {{0x32901094,0x43ef2077,0x69e0c29a,0x544dc229}},	//   _behar_, _adetunji_, _penggant, _занимава_,
   {{0x1b0922e9,0xa47211f8,0xf5bbd309,0xf2f390a9}},	//   _simplete, _direktno_, _boharlah, _aktinyu_,
   {{0xadcec17d,0x2d8f63be,0xd110720e,0xfd52f0fb}},	//   _видел_, _wehlanga, _технички_, _श्रेष्ठः_,
   {{0x629072df,0x3b8c116f,0x7290c2aa,0xdc53100f}},	//   _kenai_, _registar, _somary_, _oration_,
   {{0x26b850c9,0x928d61d0,0xd654b13f,0x127c1251}},	//   _глобальн, _espaciam, _plaintif, _играм_,
   {{0xa55190d2,0x92d8524e,0x72cae11e,0xa61e40cc}},	//   _айланып_, _golek_, _rendir_, _reconoci,
   {{0xf2d8c20d,0x82cae32e,0x4fc6b3a0,0xcf495085}},	//   _kodea_, _sendir_, _سانسۆری_, _apasiona,
   {{0x92da51a3,0x43f9d38d,0xc3fa60a4,0x08e7f072}},	//   _mutele_, _adwui_, _datuvu_, _затвору_,
   {{0x827f4403,0x03ead03c,0x7594a16e,0xa00e11bc}},	//   _ngenxa_, _avete_, _студенат, _امىقب_,
   {{0xee634078,0xc0d5d0af,0xb364808c,0xbdef90fb}},	// [580] _محاضرة_, _このサイトを評価, _aangaan_, _निर्विषय,
   {{0xc3bb31bc,0x1e46a0a4,0xa26c8012,0x4d95a105}},	//   _ئسلام_, _ciwasaga, _mikopo_, _וואטס_,
   {{0xb163329b,0x438061cc,0xcec04264,0xf7f901d9}},	//   _гурух_, _jutros_, _ملحوظة_, _بالالارع,
   {{0x47e9e231,0xf38c248f,0xb8d650f4,0x3004b291}},	//   _luksusow, _ручек_, _شاگىرت_, _انترنتی_,
   {{0x53fa02d0,0xaaea6115,0x132261ab,0x7306b061}},	//   _jesuis_, _decrocat, _apuyin_, _آدمخور_,
   {{0xf8dc707b,0xec7f00e7,0xc682f21d,0x2166001e}},	//   _fibrinog, _mitsiko_, _jitendri, _nyanibah_,
   {{0x75120019,0xe2d59362,0x6df53159,0x9fc2d291}},	//   _מחלוקה_, _ponovno_, _rendelet_, _کارون_,
   {{0xb2fc02fe,0x058f40bd,0x0629e057,0x32ee94ab}},	//   _ijigo_, _geleenth, _захарови, _agafu_,
   {{0xfc1c32db,0x6c3542b5,0xaa92a148,0xc28733ce}},	//   _doganlar, _drunkard_, _gigireun_, _funksie_,
   {{0xc20260f3,0x086214b8,0x0e33d15f,0x4694f41e}},	//   _intimu_, _राजगद्दी_, _takunnaq, _kadeřnic,
   {{0x5daf620d,0xf4d41116,0x62d874b9,0x9c605335}},	//   _argitalp, _आउरियो_, _ronel_, _jasters_,
   {{0xced4c1d9,0xf2d9e007,0xf2cae22e,0xe300401d}},	//   _активтер, _beteg_, _lyndon_, _kamamei_,
   {{0x5f24300b,0x6ae4326a,0x330cb45f,0x9dec5155}},	//   _septemba, _septembe, _upravit_, _һәмкарли,
   {{0x6fc6721a,0x029f22f4,0x8a8674ba,0xb3f82101}},	//   _istorijo, _айсуй_, _istorijs, _bokuo_,
   {{0x676960fb,0x0c617080,0x0ad52141,0xc25ad230}},	//   _राज्यम्_, _insulza_, _аңласа_, _jelles_,
   {{0x2c7582e6,0x23ead384,0x59c214bb,0x1d1e04bc}},	//   _तपस्या_, _svete_, _bermakna_, _chloride_,
   {{0x729030fb,0xe389724b,0xe3fad0dc,0x1b8d1012}},	// [590] _tejas_, _ibuyela_, _esquí_, _وزارتون_,
   {{0xf3f8f13c,0xb44f04bd,0x825ad2c5,0x13f8b015}},	//   _rogue_, _पाचत्तिक, _felles_, _alcul_,
   {{0xc23014be,0x8ea2a0af,0xa3d811c7,0x7188d0c6}},	//   _miamija_, _最新記事一覧_, _ойлаймын_, _comapany_,
   {{0xe281c23c,0x9365937e,0x6b57e0b5,0xd290c21d}},	//   _possibil, _langaho_, _тарату_, _cedam_,
   {{0x70f884bf,0xbda630f4,0x0290a1d8,0xc6e7240f}},	//   _umkhandl, _ئىتوت_, _lebah_, _sumarið_,
   {{0xb2d850e5,0x6923d1bf,0x02b544c0,0x49ca70f1}},	//   _kolei_, _поезией_, _drecha_, _ungdomme,
   {{0x72914493,0x72306460,0xfc1b8148,0x8f470086}},	//   _gheall_, _diujuj_, _kulantar, _corstorp,
   {{0x53ced095,0x7b7c423f,0x3e0da20d,0xee0510df}},	//   _calves_, _torralba_, _ordenaga, _atternpa,
   {{0x4c6f104d,0x4981e097,0xfe49b0a0,0x501d833d}},	//   _fearann_, _deaktive, _kuyakuba, _objetivo,
   {{0xebd4520e,0x92cae4b3,0xd34303a4,0x539543c7}},	//   _генералн, _hendur_, _nitendo_, _puesto_,
   {{0x63954034,0xb5fb2059,0x111c7021,0xf3958114}},	//   _questo_, _የመብራት_, _sølvgrå_, _parsi_,
   {{0x4ce5f1d9,0xa20e11d9,0x82d9e0c6,0xce52c45f}},	//   _مالىمەت_, _нашар_, _metee_, _osobnost_,
   {{0x42497281,0x69806341,0x12b59322,0xdff010dc}},	//   _maamul_, _natierle, _fasci_, _берки_,
   {{0x72e09300,0x951972cb,0x4623e2d6,0xa2c4908c}},	//   _banniel_, _رومانيت_, _synonymi, _skuldig_,
   {{0x30e3c152,0xa291806e,0x838060d8,0xc302d40e}},	//   _рекоменд, _heran_, _beurla_, _khibdwb_,
   {{0x927ed04a,0x236fa040,0x32d81135,0xb3f822ee}},	//   _anonzi_, _berghqu_, _kohes_, _alkur_,
   {{0x07eb50e5,0x2f0220e5,0xb8edc030,0x6224630b}},	// [5a0] _विपक्षी_, _विद्रोही_, _болалард, _spoki_,
   {{0xc3f84369,0xc64c80ee,0xd04c2300,0x13870138}},	//   _comun_, _disciplí, _steredon, _kvartu_,
   {{0xb2d8744c,0x70c7c1e5,0xf68fe23f,0x5292714b}},	//   _honek_, _билинер_, _aprenedi, _visage_,
   {{0x9f72c0a2,0x9c7c503a,0x00993041,0x72bd14c1}},	//   _ababanin, _atarver_, _اتلسو_, _perdido_,
   {{0x220063af,0x22b61003,0xe2d8c114,0x62360195}},	//   _atlig_, _कर्मकाण्, _saleem_, _chija_,
   {{0x0b7c6171,0xe248c285,0xf2d812a9,0xb1d792a7}},	//   _wakulima_, _abawalil, _hoher_, _сайлаш_,
   {{0x13806064,0xcbfd747e,0x3da213ed,0x53430171}},	//   _autres_, _revendic, _egenskap, _vitendo_,
   {{0x72ea0249,0x7d6140fd,0xb140e171,0x6c07b256}},	//   _derivan_, _karaktè_, _kutembel, _urusaku_,
   {{0xb2ad3218,0x84c0b0e5,0xb140f429,0x64e1b14c}},	//   _الدار_, _कल्पनाओं_, _bluefiel, _দোহাই_,
   {{0x0c44a4c2,0xd290c1de,0x8291817c,0x027f8367}},	//   _dakwaan_, _sedam_, _veran_, _burno_,
   {{0xe34b80a7,0xa27f70aa,0x42d8c121,0x7c299031}},	//   _izvesnu_, _aganya_, _moded_, _ነፃነትና_,
   {{0xc22513a6,0x93417027,0x7db76218,0xf386b45e}},	//   _rocked_, _gasetta_, _droichea, _kjerne_,
   {{0xeeb1336e,0x92d8519a,0x03eb51e7,0x12f3a0db}},	//   _prosiect_, _dolen_, _peeter_, _baahing_,
   {{0xe0fb9031,0x379d2443,0xcb6152b1,0xc29ec358}},	//   _መዘግየት_, _биуро_, _redesann_, _милая_,
   {{0x02026293,0x261dd369,0x3c685118,0xa290c075}},	//   _harimo_, _favorabi, _belushi_, _sedaj_,
   {{0xf3f47043,0x22918408,0x737b04c3,0xf16322d1}},	//   _lasten_, _peran_, _ditaolo_, _سایزی_,
   {{0x0695213f,0x5840d342,0x52011453,0x2b4eb180}},	// [5b0] _הורוסקופ_, _آخرون_, _yacine_, _medmindr,
   {{0xb22491f8,0x27861342,0xff20f272,0x3611c32e}},	//   _opaki_, _واشنطن_, _aprenden, _útlendin,
   {{0x2c016264,0x63a8e2d7,0xdc7c0342,0xe38733f9}},	//   _teastas_, _bolawang_, _shasana_, _diaré_,
   {{0xa2b0b2e9,0x16fa51b8,0x82da0097,0xabeee2a0}},	//   _spacetim, _peacesof, _museer_, _هیدبوونی_,
   {{0x93ea0098,0xea3911e5,0xd2e12131,0x02008035}},	//   _kwita_, _терези_, _एवढीच_, _pekina_,
   {{0x0290c146,0x3c93d2f7,0x0a15e4c4,0x52910149}},	//   _kedah_, _قارار_, _forbinde, _faaalu_,
   {{0x5291801a,0x530251aa,0xb3ea02f6,0xbd23f128}},	//   _seran_, _arabile_, _mwita_, _abdicate_,
   {{0x927ed117,0x83f4724a,0x778a012f,0x71462264}},	//   _ngonda_, _easten_, _заманиви, _وفقكم_,
   {{0x93f4721f,0x4edc63c7,0x122494c5,0xd50c31bf}},	//   _fasten_, _sociales_, _epaki_, _комунитэ,
   {{0xc2d874c6,0x729052b9,0xd2e77336,0xf098d11b}},	//   _konei_, _delar_, _atungia_, _бирократ,
   {{0x7291844f,0xe22461df,0x6e6151bc,0x487ae27c}},	//   _geral_, _epoko_, _الىحان_, _kroppens_,
   {{0x4202508d,0x7f03540d,0xe3f840f9,0x0b3432c8}},	//   _matiko_, _برمندِنى, _gomul_, _sambands,
   {{0x337880af,0xa2e120fd,0xa31690a0,0x8a7a43ba}},	//   _ひとりごと_, _pozitif_, _ababeki_, _domoljub,
   {{0x12d85201,0xc3958421,0x324d0290,0xc4d790f6}},	//   _illes_, _aarsu_, _धवाला_, _ваканың_,
   {{0xa8d7f0f6,0x5f68e1c5,0xa395400d,0x527e7179}},	//   _бармаяр_, _nolavans_, _beesal_, _sunnu_,
   {{0xb2b2821f,0xd2e3914a,0xee4f1436,0xfc9dc1ca}},	//   _handeln_, _abittooy_, _mujadala, _ؤٹتھ_,
   {{0xe291844e,0x42905225,0x5388c262,0x59e124c7}},	// [5c0] _meram_, _pelas_, _amashami_, _motorima_,
   {{0xa27ef041,0xa1896094,0xc03300f7,0x2e01a2bf}},	//   _uninzi_, _элементү, _justemen, _bakegera,
   {{0x02c36038,0x12fd6114,0x4e380102,0x3481c1f6}},	//   _abelian_, _enggan_, _принципі, _बिगाड़ा_,
   {{0x090eb0af,0x72905015,0x4367948f,0x8fb200cc}},	//   _はじめまして_, _telar_, _лекарите_, _empleado,
   {{0x54b7712e,0xd2d8b2db,0x93a2e086,0xac6f1027}},	//   _वस्त्र_, _medeni_, _epipen_, _guardan_,
   {{0xbf37c243,0xba07615f,0x7c004317,0xc29ce319}},	//   _pemukima, _munaritt, _klaskit_, _hòang_,
   {{0xa2aed0af,0x7b2d221f,0xa012e3bf,0xaac0a0f7}},	//   _回答日時の_, _belagern_, _ремонтир, _紫微金庸群侠传_,
   {{0xf2fe6244,0x96392083,0x69f4830a,0x338072c6}},	//   _ampirus_, _палатасы, _asosiasu, _turres_,
   {{0x93f991bb,0x42d8e0d2,0xaae43071,0x4201615e}},	//   _olsun_, _diners_, _septimbe, _begira_,
   {{0x235cf077,0xc29070eb,0xe37a143d,0x89dab031}},	//   _intanẹẹt, _genas_, _orsaken_, _አወዛጋቢ_,
   {{0xa04812db,0xac769065,0x96e8c192,0x79660226}},	//   _nebitgaz_, _housing_, _тарафтар, _लेखनाथ_,
   {{0xd305c0b8,0x836c8203,0x8c7d61fe,0xa44240e5}},	//   _سوراق_, _amagezi_, _brusiya_, _क्वात्रो,
   {{0xbf1fe15f,0xe22464c8,0x739ae0f7,0x32d8c2ab}},	//   _avatinga, _upoko_, _个人空间管理_, _todel_,
   {{0x7e351177,0x22901267,0xc9e27256,0xd9d2f1e4}},	//   _cellules_, _aghaa_, _bakomoka_, _apoluona_,
   {{0xa2c982d5,0x230d3054,0x38dc2036,0x9fd720bf}},	//   _poblach_, _tambaya_, _кутия_, _зарарли_,
   {{0xb2c27244,0xe2d8b207,0xdf5b929a,0x7af910c9}},	//   _challwa_, _nedeni_, _melamban, _положень_,
   {{0x5beec4c9,0xa2d870d2,0x49574308,0x0f2542cd}},	// [5d0] _самом_, _donen_, _ekhombye, _auseinan,
   {{0x7f6d8024,0x9bed744f,0x3d98522b,0xb20260c4}},	//   _विज्ञानं_, _fevereir, _berlaina, _hariho_,
   {{0x3f4f8135,0x82a702b1,0x127f74a7,0x453100d1}},	//   _መንፈሳውን_, _etabli_, _afanaa_, _avunharh,
   {{0x001fd04d,0x13f861c4,0x8486c314,0x3298414c}},	//   _greensto, _clout_, _पुरानै_, _এজেন্সি_,
   {{0x22cad4ca,0x087094cb,0x969871fd,0x0291044c}},	//   _mandag_, _básicas_, _verebili, _австрийн_,
   {{0x82907113,0xe2d8744c,0x1290707e,0x6b97c162}},	//   _cenas_, _honen_, _menar_, _сайлам_,
   {{0x0f531252,0xda31b0de,0xb4077036,0x029071ed}},	//   _قوشسوڭۇز, _ئشتەتسە_, _autorizz, _lenar_,
   {{0xb0e8e0bd,0x3c7c711b,0x72e17238,0xdf4ca2bc}},	//   _christel, _časova_, _galizeg_, _dekslene_,
   {{0x6cd821e2,0x4283b008,0x10f4006c,0xe5e8c243}},	//   _okukhulu_, _mugallym, _poliitil, _puncakny,
   {{0xca15e349,0xb9ad82b2,0x72025005,0xf5f18338}},	//   _forbunde, _अनुष्ठान, _patiko_, _primjeri,
   {{0xc3806484,0x6303009b,0xf16d3248,0x133b003d}},	//   _autras_, _dalabot_, _ንወለዶታት_, _abawafum,
   {{0xb2a6037c,0xbc710086,0xf29070b9,0xec610301}},	//   _aziba_, _oportet_, _kenar_, _kapusta_,
   {{0xe6927349,0xc2da0192,0x2213148c,0xde1cb12a}},	//   _kontorsy, _maseru_, _dochie_, _streatha,
   {{0x5da78372,0x02d850f7,0xcf2dc29a,0x827ee071}},	//   _fotonaka, _allez_, _kepentin, _aginda_,
   {{0x048e9367,0xb2907406,0x96b6c2b2,0xbd1440ac}},	//   _popravlj, _venas_, _गस्ती_, _doorstur,
   {{0x12ee70bc,0xda3501c7,0xf5202012,0x9ba60121}},	//   _abinibi_, _субъекті, _mwananch, _अमित्र_,
   {{0xc92e0030,0x0b698140,0x7416200d,0x6b0c21e2}},	// [5e0] _болалари, _дипломна, _amaguloo_, _ҳусни_,
   {{0x76eb540b,0x8291c0e2,0xf2f41241,0xd27cb375}},	//   _ランキング_, _devan_, _articol_, _шаралары_,
   {{0x12d85183,0x4d12526a,0x5c5ba151,0x9b94e22a}},	//   _volet_, _construc, _lubtsev_, _reciklir,
   {{0xb2ba0086,0x62907385,0xa3873387,0x22d572ad}},	//   _décor_, _benar_, _adarí_, _toronga_,
   {{0xfeae228b,0x12d850b6,0x9a0bf1e4,0x1f6ab0ce}},	//   _fertelle_, _goles_, _hemahema_, _پروسیسر_,
   {{0x19e481ac,0xd2cae32e,0xc0bbf155,0x08c4d32b}},	//   _manokana_, _hendir_, _دەھشەتلى, _aberdaug,
   {{0xdd8f64cc,0xfb66406a,0xa5879287,0x4c140105}},	//   _behlanga, _पत्रकारा, _газету_, _ורבותי_,
   {{0xc52ac0c5,0xa3ea01df,0x7bf20293,0x1278615b}},	//   _abanegih, _eviti_, _uwatwits, _kaunim_,
   {{0x7395824a,0x1207e17d,0x52786332,0x8dc102f4}},	//   _farsk_, _musiikki_, _afungi_, _хvргэж_,
   {{0xc4d6b0e0,0x02d8c225,0x65644248,0x62907033}},	//   _प्रिया_, _podem_, _ንምውሓስ_, _renar_,
   {{0x5d9ad152,0x5224915c,0x43f8f225,0x0a72f215}},	//   _статьи_, _spako_, _algum_, _ustanova_,
   {{0x0394b099,0xa3ea902e,0x1c5d2271,0x6eb374cd}},	//   _klesne_, _avata_, _dostalo_, _intentos_,
   {{0x03f46310,0xa2d8c4ce,0x3126f085,0xbc6180db}},	//   _pautan_, _veleni_, _ফাউন্ডেশ, _aterese_,
   {{0x8af7f009,0x7136f2e1,0x38cca026,0x0ac83022}},	//   _ekhulume, _afolábí_, _begeleid, _ءﺩﺍﺳﺘﯘﺭﻟ,
   {{0x23f8907d,0xac00d3d2,0xd620d1b0,0x2395e01d}},	//   _klaut_, _saisies_, _ochoreni, _batsi_,
   {{0xb27ef296,0x62d46231,0xc402305d,0xe2d851e0}},	//   _iningi_, _trudno_, _planisaz, _solet_,
   {{0x32d853f4,0x39deb213,0xe2ec11c7,0x1d95015c}},	// [5f0] _elley_, _akanakwa_, _бостанды, _tomewert_,
   {{0x0797a0b3,0x1ed77304,0x303140cb,0xe274d11c}},	//   _лидеры_, _bernafas_, _culturen, _جوالي_,
   {{0xd5537223,0xee4424ad,0xc2907008,0x026e6145}},	//   _امدادي_, _balatofa, _jenap_, _eruola_,
   {{0x620261dd,0x0b6c4085,0xdca96080,0x82c54096}},	//   _eyring_, _informó_, _alliyarq, _kuplung_,
   {{0xc94d11b7,0x2c5244cf,0xf8ec123f,0xa5b970ef}},	//   _opposite, _četama_, _argelièr, _رومانوي_,
   {{0x37a5c1b0,0x0306631a,0xd27f84d0,0x228b91c2}},	//   _databáza_, _tunihidj, _murna_, _allaukam,
   {{0x0a79b0d2,0x6249723e,0x2e3a3148,0xf291e3e1}},	//   _маселеле, _kaamil_, _babatura, _letan_,
   {{0x2b7e125d,0xf3874032,0x3c93d11c,0xe3eaf0ad}},	//   _chantier, _hversu_, _جازان_, _heitir_,
   {{0x7bee12f3,0x06ac1065,0xd2d854d1,0x222c1065}},	//   _махом_, _ולמצוא_, _doler_, _ולמנוע_,
   {{0xfc5372dc,0xd2b5f216,0x3316f196,0x72d8c062}},	//   _hartina_, _rauch_, _baizik_, _seleni_,
   {{0xdba02311,0xd356d33c,0x0310730e,0x1984a3a1}},	//   _режимден_, _شرحله_, _sluzby_, _abakyawa_,
   {{0x847e113c,0x4f65a1a2,0xc3ea90fb,0xe2d85303}},	//   _мирон_, _vitamiin, _svata_, _allex_,
   {{0xe3f89286,0x0d8d0250,0x89c430ff,0x3290a004}},	//   _hlaus_, _hipopota, _regelmat, _sebat_,
   {{0x6291c4d2,0xb2d9a3ce,0xb0f8807c,0x6082c0f7}},	//   _revan_, _amper_, _imkhandl, _柳暗花明又一村_,
   {{0x32c6b0d7,0xdd14015b,0xd778d3eb,0x6d8b8366}},	//   _berlege_, _ballande_, _reikning, _bermarka,
   {{0x1b88f4d3,0x520174a7,0xa57d6198,0x028573a7}},	//   _eksister, _afaiva_, _reputaçã, _bulking_,
   {{0xe201523c,0x629051bf,0xa870b42d,0xc3106033}},	// [600] _pagine_, _aflat_, _físicas_, _burzwa_,
   {{0x580a33af,0x7395e01f,0xbe48d257,0xc7cbe258}},	//   _saucueng, _watsi_, _dollarlı, _kristumi,
   {{0x7364826f,0xcc01a378,0xd2d85175,0xf21341c3}},	//   _sangkan_, _flestir_, _toler_, _bodhar_,
   {{0xdc55b42a,0x626c8256,0x62786404,0xe9ec5180}},	//   _gesteld_, _inkono_, _ufundi_, _商品を返品する_,
   {{0xfbaa617d,0xe3823041,0x1ce7e225,0x6f3ee121}},	//   _прикольн, _قافله_, _решавање_, _चाहियें_,
   {{0x8a99b12f,0x1e5411e4,0x12d880b8,0xb2bb008c}},	//   _ئىپپەت_, _halaania, _bmtning_, _groente_,
   {{0x9eb3044f,0x3b8d3074,0xac35b2b6,0xedbe72a8}},	//   _direitos_, _besimtar, _idraulic, _pakupaku_,
   {{0x4291826e,0xe27f8123,0x9fee60f7,0xcca31009}},	//   _gerai_, _furni_, _国家体育总局_, _сегодняш,
   {{0x23954036,0xb4c624c1,0x32d8c4a5,0xbc6251f8}},	//   _presso_, _iniciado_, _amleen_, _starije_,
   {{0x1ffa2031,0xd15581ad,0x5ddd7043,0x6c67a0ec}},	//   _በአብላጫ_, _boistero, _pirkanma, _bukuria_,
   {{0xbc1c420e,0x4c73f12d,0x8303924a,0xd9aa9031}},	//   _процесот_, _raisina_, _pleatst_, _ጉባኤውን_,
   {{0xd2d9b225,0x3fdda048,0xef2a21a2,0x7c16324f}},	//   _jovens_, _ivančice_, _банковск, _naturins,
   {{0xe2d9809e,0x2d43d0bb,0x431681a5,0xfdee60bf}},	//   _pored_, _автомобі, _amabili_, _яраланди_,
   {{0xb3f80249,0x4ccdc311,0xf2d8705a,0x0c692031}},	//   _uniun_, _макалада_, _dones_, _ሴክሬታሪ_,
   {{0x6140e121,0x27e7c217,0xa291e228,0xff5cc2ae}},	//   _तिरंगा_, _филиалы_, _wetan_, _vanalinn,
   {{0xe2251128,0x12d6d37c,0x184cb0f7,0x14850121}},	//   _docked_, _ikhlass_, _常见问题解答_, _संघाती_,
   {{0x32e1700d,0xd86f4498,0x72ef43eb,0xa1dcc3bf}},	// [610] _politig_, _steinald, _stefna_, _глоба_,
   {{0xa2266191,0x1308320d,0x0c520280,0xc62b62dc}},	//   _merkte_, _arabako_, _akatela_, _pamingpi,
   {{0x57e59287,0xf237f1aa,0xbfccb284,0x9a8cb3aa}},	//   _экзамена, _alimana_, _resister_, _resisten_,
   {{0xc25a5036,0xfc07010f,0x9c45123e,0x22da4399}},	//   _delle_, _ہالبروک_, _baawaan_, _ehandle_,
   {{0xe2d8c411,0x03dfd08e,0xd2a6d0ce,0x12240013}},	//   _moden_, _lwglingz, _szebb_, _apiky_,
   {{0x62d873e1,0xc340103c,0xc2aa321f,0x7290f421}},	//   _loner_, _accetta_, _babareow_, _adhaan_,
   {{0x525ad0f0,0x13f9b12a,0xc25ad200,0x162a3220}},	//   _celles_, _alque_, _qullut_, _kubikuri,
   {{0xd47a702d,0xf40dd48c,0x2e4ec1ef,0x826c8012}},	//   _awstralj, _ebenchek, _bulabala, _mikono_,
   {{0x3d8960f5,0x49fce023,0x172883ab,0x24bb303b}},	//   _homepage_, _devaluat, _publikov, _akubonak,
   {{0x425a51e7,0xea8014d4,0x657f42ce,0x09d3a32f}},	//   _kelle_, _dinyakwa_, _afidhavh, _новбари_,
   {{0x9011f1a7,0x871fe408,0x3b8ac2f3,0xd4ad4293}},	//   _traducto, _अविस्मरण, _логор_, _barashak,
   {{0x0c54b269,0x1c7c806e,0x5291e4d5,0x62d8a4d6}},	//   _flatbed_, _pensiun_, _detal_, _hobel_,
   {{0x7b64b20c,0x1f2fa13f,0x6e7c6121,0x4f311227}},	//   _aratinda_, _מציין_, _परस्त_, _생각했는데_,
   {{0xd30e007c,0xf33352bd,0x22d8523b,0x425ad431}},	//   _ababuya_, _alexor_, _bolei_, _belles_,
   {{0x7d0fc0cc,0x4254e085,0x326cc0fc,0xc85ff2d4}},	//   _লুকিয়ে_, _আরণ্যক_, _ahlola_, _chorizos_,
   {{0xf87e0105,0xc2d8a086,0x6c93d0f4,0xa27fa290}},	//   _קונטרס_, _mobem_, _ناپاك_, _kupna_,
   {{0x927f44d7,0x71abd0f7,0x3237803d,0x5905e0ac}},	// [620] _agenga_, _位读者读过此文_, _مشروعیت_, _빨래바구니_,
   {{0xbe1391fe,0xe29011ab,0xb32003f7,0x22003126}},	//   _suleymaa, _agham_, _kriye_, _temika_,
   {{0xb7ac843b,0xc2d872b1,0x222670bb,0x826d222e}},	//   _effettiv, _boner_, _merket_, _ascoli_,
   {{0x427f4435,0xc386a38f,0xe30052b7,0x12eef0a2}},	//   _ngenda_, _gedrag_, _halarci_, _abanesi_,
   {{0x3d3b7248,0x8332001a,0x6c5350ac,0x0c9be248}},	//   _ክትወስድ_, _deixo_, _fietsen_, _ውድባቱን_,
   {{0x02cbb2b1,0x2cea016e,0xbc6b1358,0x127e006a}},	//   _apremidi_, _командом_, _kulunut_, _dhini_,
   {{0x7386a0ac,0x227e001e,0xc2f54252,0x732000e4}},	//   _bedrag_, _ehini_, _apuntar_, _griye_,
   {{0x4292029e,0xe3ea9149,0x9d76c04c,0xc29271fa}},	//   _espace_, _avatu_, _ارمنی_, _dickler_,
   {{0xb465b28c,0xb35d113f,0x485dc1a5,0x132000aa}},	//   _kambarių_, _singing_, _abalikhu, _ariye_,
   {{0x04b3a06d,0xd2d87289,0x82d9e0f5,0xc20e315e}},	//   _худованд_, _soner_, _alten_, _далан_,
   {{0xc2b574d8,0x7d9bd271,0xd7ab83e1,0xca876007}},	//   _asacha_, _autoseda, _dekouraz_, _fenyeget,
   {{0x2b27b0be,0xbc7d20c7,0x1f67b033,0x7532c08a}},	//   _eksperie, _yaasiin_, _eksperia, _abazinik,
   {{0x805332b2,0x027e0012,0x525ad121,0x58663218}},	//   _sportovn, _chini_, _selles_, _استايلات_,
   {{0x3b7250af,0xbb6b9256,0xb7a5c2e5,0xdb87935b}},	//   _地域共同研究セン, _bakonger, _databázy_, _назвою_,
   {{0x39c271e7,0x020110f3,0x7975b4d9,0x575fa10e}},	//   _kindlust, _decina_, _periclit, _तीर्थों_,
   {{0xa38744da,0x16659256,0x8e3cd39e,0x1a605292}},	//   _tierra_, _rushinzw, _mayakipa, _مشکللر_,
   {{0xa72c51c7,0x22e672bf,0xb200708c,0x53f9b169}},	// [630] _басталды_, _itangwa_, _junie_, _coque_,
   {{0x66cef144,0xd354d16d,0x92d65138,0x6301800c}},	//   _kuhalali, _scheiss_, _toplinu_, _fesagai_,
   {{0xe175c1b7,0xc2d8c26a,0x12d8c4cb,0xa2d87474}},	//   _econdsay_, _model_, _poden_, _poner_,
   {{0x52fe6167,0x85ee34db,0xc3ead1d0,0x3b03d0a1}},	//   _casitas_, _fundació, _aveta_, _mongoumb,
   {{0x39df01d9,0x22369267,0x001ab28b,0x97b2f4dc}},	//   _مەندە_, _chaja_, _staverin, _fartelef,
   {{0x1f339321,0xa2007057,0x9758d198,0xb301f293}},	//   _innuttaa, _iunie_, _финансис, _murambi_,
   {{0xc20100d0,0x838a2217,0x6296220d,0x2290c146}},	//   _ilaini_, _törek_, _klikatu_, _sedar_,
   {{0xf30e8245,0x53417122,0xcaa9c2c3,0xb44c206d}},	//   _elizweni_, _casetta_, _анадан_, _қубодиён_,
   {{0xe14161fe,0x6d57c06e,0xd224e118,0xcfc5220d}},	//   _aamustro, _बेळगाव_, _alikud_, _клубийн_,
   {{0xdb5e50a7,0x3fd67065,0x0c5a70db,0x40bf6330}},	//   _džekson_, _אירלנד_, _baitedi_, _中华人民共和国中,
   {{0xde3d337e,0x7f3c533e,0x430084dd,0xfb155345}},	//   _murangap, _dikurnia, _garborg_, _कारणें_,
   {{0xd3f9a111,0xb27f4220,0x63f9b46b,0x6a82d091}},	//   _דקדוק_, _ugenda_, _toque_, _frazilit,
   {{0x0245b22e,0x73807083,0x9549f245,0xf337b264}},	//   _cundinam, _carrer_, _amahlath, _وشوفوا_,
   {{0xd215c2d1,0xd8422027,0x1bd64078,0xd26c839b}},	//   _دوائی_, _victimas_, _كارلوس_, _dikolo_,
   {{0x539672ae,0x2e447007,0xb27e04a7,0x89d20241}},	//   _varsti_, _javasolt_, _ekina_, _preferat,
   {{0x34b5e4ad,0x92e6f086,0xb2d8a4de,0x72d9a0ee}},	//   _repablik, _poonpon_, _gober_, _kopec_,
   {{0xcea5a256,0x99c943ef,0xa2d8c005,0xd283a2af}},	// [640] _urutonde_, _imediale, _kodel_, _baranodi_,
   {{0x4f212381,0x62cbe0ba,0xa3f4722d,0x72da6181}},	//   _orquesta, _menorca_, _gasten_, _mureke_,
   {{0x23ea91d0,0xadd100dc,0xa3148230,0xf2d8a004}},	//   _iwata_, _projecte_, _radionij, _kober_,
   {{0xe3ead384,0xb3fa719e,0x43f47083,0xb3209395}},	//   _sveta_, _haruru_, _sortit_, _muaye_,
   {{0x826e7171,0x6af583c9,0x22cf337f,0xc6443008}},	//   _kusoma_, _conspect, _achotse_, _düşünmek,
   {{0xb175d228,0x42d8c097,0x66b91144,0x037ff00c}},	//   _گذاری_, _alder_, _legalisi, _senatoa_,
   {{0x2575b373,0x04551248,0xd16af1b3,0x34d682f7}},	//   _ventilaz, _ምድንጓይ_, _respecto, _расхоти_,
   {{0x629184df,0x62d83329,0xe2a662f9,0x82f22339}},	//   _veral_, _enjel_, _azoba_, _junioru_,
   {{0x23f16026,0x69400078,0x0ec44081,0x51d7d020}},	//   _zaterdag_, _cosmaide, _ajunginn, _aileybay_,
   {{0xbfc6c35f,0x98c010df,0xe2de72ae,0x72e03082}},	//   _autoškol, _accepted, _tänane_, _pianiko_,
   {{0x627e0187,0x125ac0ff,0xe355c161,0x83f82008}},	//   _chino_, _jullie_, _eliezer_, _dokuz_,
   {{0xa26c6151,0xd49eb085,0x730762f7,0x79d8403b}},	//   _xyoos_, _ফোল্ডার_, _системис, _akwelule,
   {{0x3d2d93db,0xf73371bf,0x29ed907e,0x32cac144}},	//   _redigere_, _репресал, _redigera_, _agodle_,
   {{0x4290e31e,0xd3ce543d,0x693e614c,0xa3f8d0f7}},	//   _defar_, _halva_, _নাহয়_, _bleus_,
   {{0xa3f8f025,0x60cf32a2,0x3868c1c7,0x134554e0}},	//   _dogun_, _hungnaek_, _بيجيڭ_, _sigurisë_,
   {{0x06d602d1,0x73fa6242,0xd72c7319,0xc74810b2}},	//   _ئالمان_, _saturu_, _vietboom_, _zoonkauj_,
   {{0x2c0ae175,0x13958010,0x52f1613f,0xf7e3c04b}},	// [650] _adoptan_, _warst_, _saturday_, _номини_,
   {{0x52e0543b,0x82d8c083,0xf2903039,0x26d5130a}},	//   _kummissj, _podeu_, _imlang_, _hospitol_,
   {{0x1223d030,0x517734a8,0xab0c3352,0xdee1106a}},	//   _اداره_, _अस्सी_, _جائیز_, _विस्तारा,
   {{0x8f5c31d4,0xc3ce510d,0x117d9105,0x7586d08c}},	//   _angallan, _galva_, _נילוס_, _gedragsk,
   {{0x1394b28a,0x3b25a005,0x23f8d423,0x6200d00e}},	//   _eneste_, _купалы_, _kleur_, _etdik_,
   {{0x32001288,0x1200a120,0x3341713d,0x0ec91144}},	//   _muhim_, _tubig_, _caserta_, _akayitsa,
   {{0x0c68c25a,0xdb7b413f,0xbf5d435e,0x3217e1d9}},	//   _rubriko_, _demonstr, _kusangan, _иранға_,
   {{0x2852a086,0x759bf01d,0x1968e124,0x43ea93b4}},	//   _ultrices_, _gehorsam_, _inconcie, _barutegi_,
   {{0x127f74e1,0xc23161b2,0x727f7280,0x4a1911bf}},	//   _mganda_, _pfumisa_, _aganga_, _диструже,
   {{0x137244e2,0x330ef384,0x52cad026,0x9c9dc27f}},	//   _bangfuz_, _upozorni_, _handig_, _ولاشه_,
   {{0xf2e900ec,0xe25ec328,0x54d7e1b9,0xaab6b308}},	//   _berisha_, _kitunigl, _сараны_, _anghenis,
   {{0xd201147e,0x403962c1,0x3b5242ca,0x8394c16c}},	//   _cecila_, _kastamon, _quedaran_, _aloske_,
   {{0x74982031,0xd2ea03bd,0xece7a263,0x9f9a039c}},	//   _ለመገምገም_, _ekriven_, _таблиғ_, _дигиними,
   {{0x1e9b10af,0xad86f11a,0x6e691264,0xf65631f6}},	//   _プレスリリ_, _siyempre_, _نيوتن_, _कबाड़खाना_,
   {{0xd290f218,0xec7e11a6,0x5249718c,0x5ef61179}},	//   _cliath_, _akasiso_, _ahambe_, _krakkarn,
   {{0x1426012f,0x82d8c478,0x8cb9a034,0x7dc2e289}},	//   _ﺩﯦﻤﻮﻛﺮﺍﺗ, _bodes_, _подаване_, _adskriva,
   {{0xd27e0137,0x03f773df,0xad4a3404,0xd31ca4cb}},	// [660] _aking_, _березень_, _حسينه_, _hábito_,
   {{0x14ac54e3,0x1587b1ba,0xc50300fd,0x20c0c1b7}},	//   _kubandak, _причинат, _refleksy, _abelledl,
   {{0x9a9434e4,0xb2d8c3cd,0x3d4eb288,0x639ae004}},	//   _ngenhlos, _foder_, _آسمانده_, _اسامي_,
   {{0x33eb40e7,0x68e782db,0xdf49549e,0x5209b131}},	//   _phetho_, _аллатага, _alascana, _ध्वजाचा_,
   {{0xa2cae42e,0x9967b00a,0xbaa922db,0x9c74a095}},	//   _myndin_, _indicate, _меселем_, _endures_,
   {{0x26224099,0x246ea1f0,0x6526531a,0x51c86225}},	//   _narodeni, _аралашып_, _maligauy, _самостој,
   {{0x9206111c,0x03806484,0xf65903d6,0xf68ff48f}},	//   _ناروتو_, _astres_, _настольк, _engenhei,
   {{0xc225f293,0x53874419,0x22d46175,0x3e1a20b0}},	//   _isuku_, _mierda_, _gardan_, _dikemuka,
   {{0xa2003148,0xd27e74b2,0x63a2d199,0xa2e64127}},	//   _mimiti_, _gunny_, _siopau_, _apenisa_,
   {{0x5f192036,0x328831d9,0x52fd6010,0x437bb4c7}},	//   _детайли_, _ойлан_, _diggin_, _oznakom_,
   {{0xfd1de3c8,0xe968d30c,0x3911c4e5,0xa5ecc00f}},	//   _coquelic, _entitate, _aamanuku, _повернут,
   {{0x638060a9,0x72a694e6,0xf3e1b27a,0xc9d0112f}},	//   _fourmi_, _azaba_, _objektov_, _шерин_,
   {{0xa2918030,0x82d981fe,0xfdb4315d,0x6c60d2e5}},	//   _kerak_, _goreg_, _موسوم_, _libuša_,
   {{0x4ae9d198,0x657521ba,0x87592248,0x44abd435}},	//   _позиција_, _contatto_, _በብጊዚኡ_, _bakangak,
   {{0x3a7af307,0xe2d9122e,0x7290a238,0xf8a1a105}},	//   _bogoljub, _bozen_, _kerkent_, _צובאקומע,
   {{0xf86350aa,0x62d8c396,0x51ea04e7,0x3c76a0c1}},	//   _abandond, _podes_, _attieksm, _bossing_,
   {{0x623690fd,0x6beec1e2,0x69947405,0xea4752bd}},	// [670] _chaje_, _тамом_, _dathanna_, _anselara_,
   {{0x22d9e224,0xf27e630d,0xf20ec1ed,0xa34a44e8}},	//   _botee_, _skond_, _камал_, _abafele_,
   {{0x7f3ac142,0x33f47238,0xba8ca026,0xff969136}},	//   _pregledn, _distag_, _tarieven_, _баршгүй_,
   {{0x23ea90e9,0x93eb01c8,0xc2e7615c,0xc1b401bf}},	//   _avati_, _status_, _frendin_, _терменул,
   {{0x1291815e,0xa778f030,0xf5b034e9,0x5a1a3351}},	//   _berak_, _اوراقی_, _aragraph, _مزایا_,
   {{0x7d6fd015,0x3310e120,0x8fce0141,0xf290e01f}},	//   _haemosta, _cutaway_, _bildiriş, _nunawa_,
   {{0x82003024,0x22e5b0d2,0x43791177,0xd215c096}},	//   _kimiti_, _llengua_, _anqaasa_, _روپئے_,
   {{0xfc93d1b5,0x301722ab,0x3278620f,0xb202448e}},	//   _باراك_, _народны_, _olunan_, _edwina_,
   {{0xe37fd443,0xb2ea046c,0x134661ec,0x949b0290}},	//   _palanca_, _skriven_, _aksesib_, _ostatecz,
   {{0x12780197,0x26910163,0x27f8c248,0x85cd52f3}},	//   _musnah_, _rosenhei, _ክሕግዘና_, _контроло,
   {{0xcedd54d2,0xbff844b6,0x1df42287,0x22bfb22e}},	//   _bipivnes_, _ladyekas_, _экскурсі, _waldeck_,
   {{0x1b9734ea,0x42d992d4,0x63807422,0x9cf4e10f}},	//   _relación_, _drenaje_, _farrar_, _منتظمین_,
   {{0xba828064,0x83954229,0x56e7c32f,0x0291e0c8}},	//   _市政府主要部门_, _fresco_, _таблиг_, _retai_,
   {{0x64681252,0xfef60282,0xa0fb5180,0x5c3432cb}},	//   _айтор_, _עבֿריתּ_, _エスニック_, _نبيله_,
   {{0x968230b6,0x7355e4eb,0x89db10f7,0x950bb1fe}},	//   _necesari, _teofila_, _国家宗教事务局_, _bareegul_,
   {{0x26c520e3,0x61b3b200,0x23ead075,0x60d83370}},	//   _pamamagi, _apkataña, _svetu_, _душманон,
   {{0x227ef17d,0x5ecac1c3,0xc2ca40f6,0x0e4b308c}},	// [680] _kiinni_, _leantain, _dilleri_, _wedstryd_,
   {{0xb543f2c9,0x648f81ca,0x92eb50ea,0x4ef1f13e}},	//   _komissiy, _صبحٕکہِ_, _majitel_, _ठुमके_,
   {{0xd2911033,0x8237e2d7,0x31571196,0xfcf8c022}},	//   _sezar_, _adimiwa_, _энергийн_, _принципт,
   {{0xec612075,0x7f9bd4ec,0x804db00a,0x8beda2c1}},	//   _dvorane_, _anketler_, _resultin, _gerektir,
   {{0xe305c4b5,0xe2d8513f,0xa27e0089,0x4f197050}},	//   _روزان_, _filed_, _shins_, _一位從事裝潢的朋,
   {{0x727f01e2,0x0bd4a090,0xaee832bf,0x6c664337}},	//   _phansi_, _sarmento_, _ahakoran, _prstenu_,
   {{0xe589b242,0x675dd328,0x46c8f1ce,0x79e3c16e}},	//   _pasaulē_, _maniliog, _laranjei, _показао_,
   {{0x1c3f51e2,0xb745311b,0x53eb700c,0x32e60346}},	//   _ngaphans, _удара_, _seatac_, _duanana_,
   {{0x52003098,0x86f03012,0x520071ab,0xc39663e7}},	//   _komini_, _نشانين_, _kunin_, _arusto_,
   {{0xc98e30d7,0x6057c008,0xbc5bf2db,0x02fe500a}},	//   _галим_, _динидир_, _tertibi_, _periods_,
   {{0xe20031d0,0x52913086,0xb3200361,0x5704510f}},	//   _domini_, _lexar_, _ariyo_, _منافرت_,
   {{0x70b8209a,0x71dbe29a,0x1053c375,0x7c6890c8}},	//   _истан_, _mengubah_, _ءادسى_, _albumai_,
   {{0xeeb5616e,0xe22f20db,0x16a24443,0x62cae3c9}},	//   _autonomn, _абруй_, _ambueich, _mundus_,
   {{0x8283b056,0x9e4bb024,0xbd1510aa,0xecab6180}},	//   _thekgwa_, _abhaavaa, _akaruhur, _クチコミ数_,
   {{0x05e9a257,0x93f470ec,0x76d0013a,0x127e6211}},	//   _maraqlı_, _rastin_, _behainim_, _ahoni_,
   {{0x220072d4,0xab8e6190,0x669b71d4,0x82d913e5}},	//   _hunin_, _bibivoro_, _itigarti, _mozem_,
   {{0x7421f0c9,0x7291c2c1,0xd2006118,0x826d6223}},	// [690] _politikk, _devam_, _tulin_, _vigogo_,
   {{0xc3a8d137,0x627ee17a,0x53f900e7,0x285e04ad}},	//   _dumating_, _munnen_, _ngauri_, _boaneled,
   {{0xf31673f1,0x03eae1b8,0xc56c0225,0x23f41319}},	//   _panzi_, _bantot_, _осигурув, _nnptnt_,
   {{0x63f45206,0x5a60c004,0xd2e9504b,0xc9b521ba}},	//   _lottie_, _تخليه_, _oldidan_, _condotta_,
   {{0x8f64144f,0xe6d290b1,0xa226b096,0xf24a6029}},	//   _економиј, _dagaalki, _آخرکار_, _umumna_,
   {{0xf41cf3a5,0xf20ec102,0xd5e9a207,0xd3bb003d}},	//   _ubhaliso_, _запам_, _yararlı_, _مکتبونه_,
   {{0xe34f723a,0xb2001336,0x2c564121,0xd2d5034d}},	//   _asherah_, _auhia_, _teatele_, _pyllait_,
   {{0xf386d43f,0x120172d5,0x5f374271,0x07aeb3c2}},	//   _tvorbu_, _acaire_, _poslanec_, _abatasii,
   {{0x7e1b7153,0xc2873234,0x3300f0a1,0x2a79e11b}},	//   _vetenska, _funkcie_, _quraish_, _забележе,
   {{0x19883213,0xd32042fe,0x8e1b708c,0x2291e0fb}},	//   _anakapat, _yumye_, _wetenska, _hetau_,
   {{0x701631ba,0x22aa6422,0xb38064e7,0x85c7e24b}},	//   _екскурзи, _discernm, _astras_, _мастерст,
   {{0xa7a90431,0xa320021d,0x862244ed,0x7f29003a}},	//   _entrepri, _priyo_, _narozeni, _entrepra,
   {{0xb2c0c418,0x0f07d352,0xbf4a6218,0x325a10db}},	//   _январ_, _تاریکی_, _فعاليات_, _wohle_,
   {{0x72fcb06a,0x1655a1f0,0xdfae1083,0xd350a0dc}},	//   _berikut_, _музейы_, _наркы_, _انگلىسچە_,
   {{0x62b1f20c,0xcfa1d23f,0x03806249,0x995e9087}},	//   _imiduga_, _atelosto, _estras_, _annnonse,
   {{0x427ee22d,0xd22bb283,0xd394e033,0xa17cb080}},	//   _kunnen_, _avamise_, _sanson_, _nezahual,
   {{0x91b7c263,0xc3f99202,0xb1b921bf,0x222d605e}},	// [6a0] _чинохи_, _rosul_, _терминэ_, _kaivevel,
   {{0xc248433c,0xeb190414,0xbd9be0f1,0xb6676004}},	//   _элементл, _agrarian_, _felleska, _پارتیشن_,
   {{0xe2d574ee,0x63b0e320,0x9826b02b,0x55609381}},	//   _narodna_, _vuiqua_, _سامانا_, _navideña_,
   {{0xba885043,0xc7a2130f,0x427e6074,0x472d2043}},	//   _kokonais, _वर्तमाना, _thoni_, _казалось_,
   {{0xc7c72198,0xdc74a07e,0x5597d09b,0x96d570af}},	//   _mensagem_, _forumet_, _betiridö, _月末日まで_,
   {{0xf2003427,0xf7562096,0x93eb01a0,0xe38063e1}},	//   _uomini_, _کارنامے_, _glatik_, _pourki_,
   {{0x83954424,0x3f4da065,0xa27e63e6,0xbd8ee0df}},	//   _presyo_, _גיורא_, _akona_, _antorgra,
   {{0x06b7215f,0x3f290091,0x037fd1ce,0x67a902e2}},	//   _kangikhi, _antrepra, _malacca_, _antrepri,
   {{0xe27f724c,0x02fcd189,0xf25a10fc,0x12b4a4ef}},	//   _maanta_, _njega_, _sohle_, _basdang_,
   {{0xc2257296,0xe6ea9056,0xfd8630c8,0xf834911b}},	//   _ngakho_, _ditaetšo_, _настрой_, _културе_,
   {{0x1d23a4d9,0x2e3d439e,0x1da481fe,0x169480e0}},	//   _giuridic, _jasakipa, _amboosma, _व्यवतिष्,
   {{0x32d813af,0x4a89c143,0x2200612b,0x5dcea21d}},	//   _cihen_, _hipocris, _bulie_, _निष्पन्न,
   {{0xe8f13078,0xa9e681d9,0x52d872c1,0x1d1a0109}},	//   _انتظر_, _қайтару_, _annem_, _andrespr,
   {{0x829b31bc,0xc019223c,0x32d06051,0x6487710e}},	//   _اكبار_, _борса_, _hapless_, _chorwacj,
   {{0xb8d5c0c9,0xc43ec00f,0x7c61a13f,0xc3ead1aa}},	//   _страхува, _майна_, _carried_, _bantse_,
   {{0x827ee463,0xf2905173,0xc2d9c13f,0x526ca044}},	//   _cainta_, _oglan_, _loved_, _putiputi_,
   {{0x027e9304,0x149fd39c,0x324832d9,0x62d87036}},	// [6b0] _ghani_, _амалсиз_, _mommma_, _linee_,
   {{0xe8787092,0x139670f9,0x929050b3,0x616b12ff}},	//   _frenchku, _fyrsti_, _iglan_, _birinmoh_,
   {{0x429b2078,0x49e0c475,0xee06a1b5,0x927e90fb}},	//   _وكمان_, _menghant, _ءرياسىزد, _ahani_,
   {{0xf7221124,0x65765198,0x8769241c,0xa2d87051}},	//   _adoració, _publicaç, _жанданды, _ained_,
   {{0x17607288,0x2959708a,0xd37b51ab,0x384e5101}},	//   _kiritilg, _akalidle, _kuwarto_, _regretab_,
   {{0xb5cec36f,0xcb60e19c,0xe1c341c7,0x0ed30064}},	//   _даими_, _telemann_, _клубтары_, _familles_,
   {{0x83164385,0xc48be083,0xd1be21d9,0xe9c230d0}},	//   _kembali_, _аталган_, _بەرمە_, _haavitau,
   {{0x92003308,0x1f5f4036,0xd3f272a6,0xab727231}},	//   _fujii_, _citazion, _aktualni_, _aktualna_,
   {{0xa25ae478,0xdc66c1fb,0x0f9912b2,0xd3209387}},	//   _sailed_, _protais_, _वस्तुगत_, _araye_,
   {{0xc9e4f38e,0xe3209123,0xacf2f0cc,0xfa14e048}},	//   _lokufund, _braye_, _carteler, _warcente,
   {{0x2d03b009,0x03f80086,0xb300822e,0x9c24045e}},	//   _выберите_, _unius_, _harburg_, _polarsir,
   {{0xdfbdf217,0x43ead018,0x92905311,0x40f63443}},	//   _fotoalbo, _aveti_, _yglan_, _вальдес_,
   {{0x1b7974bd,0xad03d2db,0x2d2220be,0xb27e9187}},	//   _दर्शयति_, _hukuklar, _pozitive_, _chani_,
   {{0xbcbf206a,0x69e4402f,0x26bca4f0,0xd2da731e}},	//   _क्षेत्रा, _buffaloe, _हप्ता_, _lorens_,
   {{0x9ee231ca,0x7387021a,0x13a31495,0x08fd40c4}},	//   _وۅلسنہ_, _svarbu_, _limbourg_, _bagahind,
   {{0x83ead21d,0xa49662e6,0xac1741d4,0x1eb06273}},	//   _eveti_, _प्रचारित_, _tamakker, _sacomban,
   {{0x1cca818c,0x7956508f,0x9616519a,0xec8c50ac}},	// [6c0] _emihlanu_, _boblogae, _boblogai, _홍보담당자_,
   {{0xd3ead1e6,0xd2d8328b,0x635c01ca,0x6426c1df}},	//   _tantre_, _lijen_, _وتھى۪ن_, _organizo_,
   {{0x2c76d199,0x23cf8180,0x1a80721f,0xfc69c065}},	//   _hytrach_, _farve_, _ekenimon_, _dietary_,
   {{0xb3ead164,0xe9e4f46a,0x2d57612f,0x1300e2ec}},	//   _rantre_, _nokufund, _туридиға, _legazpi_,
   {{0x6a5772a0,0x068233a5,0x82def29f,0x90226283}},	//   _زۆۆۆۆۆۆۆ, _abavotay, _babetaki_, _atawubon,
   {{0x2c1b8105,0x4d89223e,0xf63c60de,0xcbc01494}},	//   _פּעקל_, _anifuate_, _египетте_, _tikilmiş_,
   {{0x0ead429f,0xa3917263,0x2c172276,0x26dd70fb}},	//   _derriere_, _услубӣ_, _بورچي_, _तद्दर्शन,
   {{0x525a109f,0x82b66167,0x33418085,0xd394d22e}},	//   _mohla_, _trucha_, _abierto_, _krosno_,
   {{0x9db30196,0x465571a6,0x23a36408,0x89c692b2}},	//   _hilabete_, _alandelw, _angpau_, _abcpráce_,
   {{0xc91e3352,0x2dbca3db,0xe8b5412f,0xf23e929c}},	//   _ولایه_, _antallet_, _كۆۋرۈك_, _málaga_,
   {{0x8c29320f,0xf689c257,0xd9c9c008,0x4a2d2018}},	//   _versiyas, _bildirmi, _bildirme, _duminică_,
   {{0x0200f0f0,0x01a2845b,0xb9fe1005,0x4290b185}},	//   _panier_, _condamné_, _redaguot, _bedann_,
   {{0x027e6060,0xe32200af,0xa2001030,0x1b76a235}},	//   _akong_, _ブログジャンル_, _muhit_, _графиче_,
   {{0x441e10c8,0x2e399052,0xbed2f381,0x51943113}},	//   _savinink, _dienests_, _аноминац, _komentēj,
   {{0xbed41019,0x99e4f46a,0xf5c62065,0x429180c8}},	//   _אנטייל_, _yokufund, _ובהצלחה_, _meras_,
   {{0x68c38021,0x0679c124,0x6c80c483,0xc343e005}},	//   _landjord, _семион_, _сенем_, _privalom,
   {{0xd2d9b183,0x7616532b,0x595653ec,0xdc67905a}},	// [6d0] _deveni_, _poblogai, _poblogae, _adjunta_,
   {{0x1ae213f4,0xe29182ab,0xd17eb15f,0x17cf20af}},	//   _careless, _geras_, _kamagill, _サイト内検索_,
   {{0x8f5c3159,0x72d9c284,0x22c6d064,0x12cb30ea}},	//   _ingatlan, _novem_, _第三十六条_, _mladá_,
   {{0xf52a0175,0x53200293,0xb2909408,0x8fb3a405}},	//   _motivasy, _iriya_, _arjasa_, _هيونداي_,
   {{0xa378d04f,0x22c941c9,0x66cba248,0xf657c1bc}},	//   _semakin_, _villach_, _ምኽኒያቱ_, _баллга_,
   {{0xbda9d00e,0xdd6b1435,0xf9ea513b,0x73200351}},	//   _stansiya, _calmette_, _nattillu, _kriya_,
   {{0xb2918178,0x521252e9,0xa27f0076,0x5bfbf10b}},	//   _deras_, _belha_, _ahanui_, _aragater,
   {{0xce52f1e6,0xd7b54089,0x72006171,0x720ec375}},	//   _kimartha, _disengag, _kulia_, _санат_,
   {{0x1c76f0fb,0xb3ead2fa,0xfdabd109,0xb2c56430}},	//   _पुत्री_, _kwete_, _bygninga, _nədir_,
   {{0xd2fce197,0x6991217a,0xd7afe248,0x1e03c32d}},	//   _tengku_, _পটভূমিয়, _ብትኽክል_, _abhedopa,
   {{0x065e524c,0x9e92316e,0x33200243,0x53f9200e}},	//   _دستوٝر_, _постали_, _griya_, _soyuq_,
   {{0x4688f196,0x71951402,0x5ec203e2,0x32d8c0c9}},	//   _системий, _gancengh_, _podnikan, _endel_,
   {{0x4291e004,0x92918004,0x42905333,0xe0efc4f1}},	//   _tetak_, _beras_, _oglas_, _asmaraak_,
   {{0x527e94f2,0x02ddc2ec,0xf291e004,0x02d980ff}},	//   _fhano_, _açores_, _betah_, _horen_,
   {{0xd917327d,0xd2006363,0xf26742ae,0x27931276}},	//   _رِنگا_, _aulia_, _alkoholi_, _يُوزر_,
   {{0x72925189,0x2ae7714c,0xe20062df,0xffabc03b}},	//   _ostaje_, _মিশায়_, _bulia_, _alamakho,
   {{0x32007038,0x33872083,0xb430b225,0x917e60d7}},	// [6e0] _etnis_, _decret_, _desconto_, _gennadiy_,
   {{0x065da13f,0xe75e213f,0xd2d85033,0xc845d111}},	//   _הביאו_, _נוהגים_, _anlev_, _reklamad,
   {{0xe2d982d2,0x4291e22b,0xf2d8c007,0x3644536f}},	//   _foren_, _getah_, _hideg_, _boyitshi,
   {{0xa127e1bf,0x120072c6,0x7aac8305,0x8ee921a6}},	//   _британич, _runic_, _deberán_, _awukafan,
   {{0x525a5071,0x0200d054,0x920274f3,0x9f65a149}},	//   _wolle_, _kudin_, _yasize_, _tatalain,
   {{0xf320d22e,0x82497250,0x8c66f1e5,0x7e1830d7}},	//   _steyr_, _alamea_, _башының_, _көмеш_,
   {{0xd4f49085,0x20d330c9,0xe70b8065,0x8969616f}},	//   _সম্পৃক্ত_, _класу_, _בהעדר_, _solidare,
   {{0xcc7b20de,0xdc627146,0xf2b6839c,0x07522075}},	//   _اراداقى_, _letupan_, _турсунҗа, _učitelji_,
   {{0x0291e138,0x8f1a6059,0x82cae0e7,0x36271030}},	//   _petak_, _መንፈስና_, _ndidza_, _تاباره_,
   {{0xb2d460e3,0x7411a244,0x56c7b10e,0xc290d016}},	//   _hardin_, _asinarak, _प्रशंसको, _oblats_,
   {{0x13200293,0xac51e161,0x63f894f4,0x100702f4}},	//   _uriya_, _kuitira_, _anaua_, _машинд_,
   {{0xd27860fd,0x7394b27a,0x1c05d42f,0x9a7e50bf}},	//   _tounen_, _mieste_, _acerray_, _tiklanis,
   {{0x62f0d0c8,0xbd715218,0x02d46247,0xc2d9502d}},	//   _greitai_, _بجائزة_, _mardin_, _difens_,
   {{0xc32001e6,0x8fd23229,0xb26cf3c0,0xafd2f0ea}},	//   _priya_, _покупка_, _ikhola_, _dostateč,
   {{0x43877238,0xa2c250c0,0xd85433b9,0xa8682282}},	//   _adarre_, _apelada_, _فوريه_, _מתמידים_,
   {{0xeab3b0f6,0x6265418a,0x73e533aa,0xf94d80f7}},	//   _интелеге, _anunturi_, _इण्डस्ट्, _全国人大常委会关,
   {{0x927e926f,0x125a51eb,0xde688301,0x6a97103d}},	// [6f0] _akang_, _solle_, _aktivít_, _abayakut,
   {{0xa2d8702e,0x620242df,0x32d9e16c,0x43f9203c}},	//   _ennen_, _cowiri_, _kotem_, _seculi_,
   {{0x75eb03b9,0x362704f5,0x22d9a42a,0xf60ef057}},	//   _سرمايه_, _سامانه_, _kopen_, _octombri,
   {{0x226c82a4,0x52d85135,0x2171b022,0xe2d94199}},	//   _ponoć_, _cilen_, _аграрлық_, _fideos_,
   {{0xe2d872bc,0x703263a3,0xc2e721b9,0xe587f4d3}},	//   _innen_, _spotrebn, _рубрикаһ, _agerdyrk,
   {{0x38421008,0x2c6a115a,0x175f2116,0x4089b0b3}},	//   _adamlard, _गुत्थी_, _इंज्वाय_, _израилгә_,
   {{0x98a5d3fe,0x82d852bc,0x0200d381,0x72d9409c}},	//   _इच्छुक_, _filen_, _judio_, _akeeku_,
   {{0x120204f6,0x63877199,0x42fcd289,0x034432b8}},	//   _nositi_, _gwared_, _kroget_, _landbou_,
   {{0x4950b0bb,0x06172268,0x1eba7031,0x8038413b}},	//   _personer_, _دادالله_, _እያስገኘ_, _ngutainn,
   {{0x21c7e0b0,0xb290b459,0x03a29171,0xf291806a}},	//   _menengah_, _budata_, _iwapo_, _kerap_,
   {{0xe4d2107f,0x4394e0c1,0x584a13f9,0xbd20a072}},	//   _ашәҭқәа_, _pansin_, _дочки_, _kolonije_,
   {{0xe2d85076,0x9e51b414,0xe2d981d2,0x2d6fc264}},	//   _kileo_, _vaucluse_, _horel_, _محتار_,
   {{0xc6e5c24b,0x4602f4a6,0xa291a1d8,0x42e360eb}},	//   _asebantw, _स्वागताध, _tepas_, _diminue_,
   {{0x62d8745e,0x8b72d096,0xa3f403c9,0x595911a2}},	//   _annen_, _عبدالمجی, _noster_, _дерево_,
   {{0x1d9343d8,0x8291a0f0,0x47c1c42f,0x12151358}},	//   _jikelele_, _repas_, _acetatew, _страховы,
   {{0x9ecad196,0x520c9171,0xc718f252,0xb35e1375}},	//   _eranskin, _ديندار_, _канаттуу, _санаймын_,
   {{0x52a7007b,0x136fb362,0x8d6ab009,0x02d872f4}},	// [700] _arabni_, _postavim, _дагестан, _zinea_,
   {{0x6ae64085,0xbecad2c8,0x0b6cf318,0x2fd242e4}},	//   _দোকানে_, _granskin, _kuronder, _quangcao,
   {{0x9879e0af,0x4c53700c,0x2e0020b0,0xd55192c3}},	//   _ジャンル別_, _tautala_, _dicerita, _айлары_,
   {{0xc197202a,0x726d54f7,0x99bfe0ea,0x53877401}},	//   _sanctity_, _inform_, _kamarádk, _bharra_,
   {{0x0b0951fc,0x439c834e,0x62d8c0ea,0x73545241}},	//   _anastane, _нооромиҳ, _kodex_, _popescu_,
   {{0x0f3e910e,0x315080f7,0x2386f2ab,0x4c2ad267}},	//   _क्रिसमस_, _东营市蓝天塑胶有, _skirti_, _nsinambu_,
   {{0x73f99037,0xb368d0d8,0xd8aa51ba,0x12d98123}},	//   _ilsur_, _aonghas_, _поздрави_, _anreg_,
   {{0xb6346387,0x61b92275,0x2a70611a,0x0f928009}},	//   _ailabawọ, _бермини_, _gumagawa_, _вопросу_,
   {{0xa2cac224,0x687b317d,0x6898b013,0x0248c00c}},	//   _dikemedi_, _странах_, _ҵарадырр, _moomia_,
   {{0x82d9e075,0xcff3e0af,0xd20e31d9,0xd27ed4f8}},	//   _potem_, _関連商品を見る_, _залал_, _ikena_,
   {{0x8285c45d,0xe2920034,0x234e31df,0x825a51a2}},	//   _estranky_, _appare_, _literoj_, _nolla_,
   {{0xc2d9e048,0x00d96287,0x4dd9206a,0x0d81a25d}},	//   _fotek_, _паспраба, _इत्यादी_, _payement_,
   {{0xf26d5123,0x51e140de,0x189f40e5,0xe5e0a14c}},	//   _anform_, _ازدەكتەگ, _हविष्यान, _বৈষম্যের_,
   {{0x7291a3e1,0x238a3076,0xb0c9c1df,0xa2d98086}},	//   _repar_, _abesalom, _esprimoj_, _mores_,
   {{0x626e605f,0x42d8311d,0xc2e5c280,0x59f08257}},	//   _herode_, _lameck_, _alongua_, _rusiyaya_,
   {{0xa2f443d7,0x49bf528d,0x92fcd05d,0x1624a1e9}},	//   _प्रारम्भ_, _kundenge, _proget_, _litaliyä,
   {{0xe15992a0,0xc303f38f,0xe913f46e,0x029033cf}},	// [710] _هوشیار_, _bedankt_, _anacletu, _nymark_,
   {{0x28cb404c,0xdd8d912a,0xc250c14c,0xdcb20009}},	//   _اعتراضی_, _inhonora, _হাল্কা_, _улучшить_,
   {{0x85a131ca,0x52d980d2,0x9a90436e,0x72808388}},	//   _زمانٕچ_, _hores_, _taliesin_, _ویندۆس_,
   {{0x48cda4f9,0x825ad3c9,0x42f2b026,0x72ca825d}},	//   _अविश्वसन, _mollis_, _archief_, _abaloli_,
   {{0x63f822f8,0x587f10d2,0x83f9b01a,0xced6011b}},	//   _nikua_, _cercador_, _loquo_, _južno_,
   {{0x977de019,0xc291c0ff,0x92497246,0x0ba413e9}},	//   _סיטואציע_, _bevat_, _anamua_, _मनमुटाव_,
   {{0x425a517d,0x5e23f030,0x927ed184,0x7a08d1e9}},	//   _jolla_, _راولپندی_, _ekena_, _jimatana_,
   {{0x1048b41a,0x2c93d1bc,0x1dcdb078,0x1c6d3215}},	//   _grafikko, _حارام_, _بانوراما_, _verujem_,
   {{0xb0d8e1d9,0xcbaa80f4,0xe39fb180,0xa76c648f}},	//   _грамотас, _ﯰﻧﯩﯖﻐﺎ_, _価格の高い順_, _додавајќ,
   {{0xe68ce030,0x62d9c383,0xc2369104,0xc296b084}},	//   _مقداری_, _loven_, _abajo_, _alaketu_,
   {{0x126c80db,0x92d87071,0x854ec1aa,0xf2018029}},	//   _nakong_, _finen_, _гимны_, _jurig_,
   {{0x2c2764fa,0xa2d8720d,0x12fcf44b,0x55c1a065}},	//   _زندگانی_, _ginen_, _kriget_, _מכוער_,
   {{0xe263e2b5,0x027e00e5,0x0c06112b,0xcc61a010}},	//   _sparingl, _chiny_, _kwekọrit, _harried_,
   {{0x12a6639a,0x631f5009,0x2d34209a,0x82c932a9}},	//   _osoby_, _okuyikom, _سېتىق_, _endlich_,
   {{0xd291c465,0x661790e5,0x5c01c49c,0x93f8f428}},	//   _devas_, _प्रत्याश, _seisear_, _engum_,
   {{0x42d9c104,0xfefc6116,0xe27ed007,0xc2f523c9}},	//   _joven_, _फुदकत_, _benned_, _totidem_,
   {{0x6291c339,0xbecdb38d,0xfc7ea0d2,0x8efe7202}},	// [720] _nevar_, _miliyoon, _consell_, _ngajawab_,
   {{0xe37cb328,0x325ad369,0xdafda1b1,0x927f03e7}},	//   _atauttim, _pollas_, _hotellis, _baangi_,
   {{0x1e5d731b,0x92e5e08d,0xf2c2412b,0x0d1d30de}},	//   _ngabadla, _alingua_, _ebelata_, _ئيگىلكتە,
   {{0x4b4ae196,0xc2d870bb,0xe2001367,0xe7ba9328}},	//   _долларын_, _annet_, _arhiv_, _taalamik_,
   {{0x2e4f41c3,0x02d982f5,0xd7ea3290,0xd01370ac}},	//   _theaghla, _dorer_, _सुरुचिपू, _매물이없습니다_,
   {{0x32d9827c,0xa1c550f7,0x8c76b18a,0xb5cc94fb}},	//   _vores_, _中华人民共和国国, _tuturor_, _malangny,
   {{0x92cae13f,0xab624271,0x4291c49f,0x0b995005}},	//   _finder_, _starosta_, _levar_, _gedimino_,
   {{0xc2d574a5,0x327ed1ad,0xfb080443,0x5c69e272}},	//   _aaroona_, _shenn_, _ahaséma_, _actuali_,
   {{0x22d8c42a,0x736e300e,0x319d71c7,0xc275f022}},	//   _alleen_, _redaktə_, _ﺍﻟﻁﻔﻴﻠﻲ_, _ءﺗﯘﺳﯩﺮﯞ_,
   {{0xf2d873f1,0x6257b264,0xb35e22d5,0x271fc227}},	//   _ninel_, _الزكاة_, _bangaid_, _대전광역시교육청_,
   {{0xf7a28164,0xe2cae0f5,0x170342c4,0xe2d983ea}},	//   _kontribi, _kinder_, _ज्ञानकोश, _borer_,
   {{0xc290b2ef,0x4c6f710b,0x43877405,0x56ddb0e5}},	//   _gedaan_, _agurana_, _tiarna_, _इन्द्रधन,
   {{0xb38700ca,0x5f4954fc,0x8b094141,0xa37230cb}},	//   _udaram_, _existuje_, _dollaryň_, _wahardd_,
   {{0xd9f6e25d,0xa2388263,0x8aa3a248,0xd30e0438}},	//   _courageu, _dlamini_, _ተስፋልደት_, _ababeya_,
   {{0xb975a4fd,0xe47690bb,0x23893009,0x72051339}},	//   _koristit, _процесі_, _создания_, _notikumi_,
   {{0xa320921d,0xa17db065,0x5c6e522e,0xd94921bf}},	//   _trayo_, _מיגון_, _isernia_, _комитеря_,
   {{0x61b48152,0xe68e30f7,0xa2b672ea,0x3ea37113}},	// [730] _здоровье_, _国家税务总局_, _forcat_, _studijas_,
   {{0x7ea764a3,0xf2d9c22f,0x82914330,0x9f12f245}},	//   _platnost_, _doveo_, _radars_, _ekudalen,
   {{0x4294a2ae,0xfa10a4bb,0x0c00d00d,0x827dc031}},	//   _स्रोतः_, _bercinta_, _afisaas_, _እንረዳለን_,
   {{0xe29014b5,0xc3f4629e,0x149c20fc,0xd26d00bc}},	//   _mahad_, _sortie_, _туристик_, _agboye_,
   {{0x1347236f,0x0b278468,0xd2f0f1ba,0xbdeec04c}},	//   _romelwa_, _प्रकरणमा_, _regioni_, _همتون_,
   {{0x30e8e2b9,0x2eb14026,0x1290c1ca,0x01d7c303}},	//   _artikkel, _단독다가구_, _helaan_, _виникає_,
   {{0x56aa6056,0x82d8a2e2,0x2a562022,0x05c7814c}},	//   _bongwadi, _kiben_, _ﺍﻟﻔﺘﺭﺓ_, _রবার্ট_,
   {{0xf2d870d7,0xf1943052,0xa61c044d,0x0a7d848f}},	//   _minem_, _komentēt, _usporedi, _полуврем,
   {{0x93f8f32e,0x12d8a48e,0x53f96057,0xa54c21aa}},	//   _ungum_, _diben_, _reguli_, _bashwesh,
   {{0x7eb724ec,0x79fb4009,0x5e27311a,0xf2006075}},	//   _cinsiyet_, _lokutjhu, _pangyaya, _julij_,
   {{0xf2016071,0x4a57b0de,0x144b7182,0xb41330a2}},	//   _safier_, _السىقا_, _antaḥsaṃ, _شاهدې_,
   {{0x32d9e17d,0x2a28b135,0x5c3410c5,0xe62fb336}},	//   _joten_, _emocione, _aracemer, _efulunif,
   {{0xe2ecb4fe,0xd2d9e341,0x88360105,0x8296f174}},	//   _agribee_, _doten_, _ליסטעס_, _lovački_,
   {{0x6ec6c0c8,0x925aa01a,0xe2d871eb,0x1200b01f}},	//   _кантакт_, _poble_, _enner_, _rediyo_,
   {{0x72d8701c,0x92b3920d,0x42006028,0x8aeb6196}},	//   _ennek_, _munduko_, _nulik_, _inprimat,
   {{0x339540b2,0xe86cf3d7,0xe201826e,0x623602ec}},	//   _fresno_, _गतिविधिय, _kurie_, _ecija_,
   {{0x92d8c3b0,0x8e79132f,0x9f6420af,0xd8e980b3}},	// [740] _inden_, _боғча_, _最新コメント_, _проектны,
   {{0x1f66d005,0x92925367,0x4291e09e,0x933230db}},	//   _амаль_, _ostale_, _metar_, _горячих_,
   {{0xb2d9e04c,0x0e395475,0x3291e44b,0xf916609a}},	//   _boten_, _kemahira, _letar_, _ангилийә_,
   {{0x9010c218,0x8291c317,0x75ef6152,0xd291e074}},	//   _انتقل_, _pevar_, _изначаль, _fetar_,
   {{0x49595059,0x5eaa911e,0x82c1c200,0xc3e93225}},	//   _ክትትልና_, _victorie_, _jullisa_, _resoluçã,
   {{0xc78bb057,0xf9cbb057,0xb27f4052,0xc20061c5}},	//   _servicii, _serviciu, _dienai_, _fulik_,
   {{0x3255b217,0x8c7f01a6,0x09d5b0b3,0xc2016333}},	//   _tantanal, _akusiso_, _tantanad, _regija_,
   {{0x39d1d0e7,0x427e61be,0x53877009,0x50f880f1}},	//   _eletshed, _mkono_, _inarha_, _bokhandl,
   {{0x5ea8d248,0x7f26e116,0x22e100a2,0x722a309a}},	//   _ንተኻፈልቲ_, _भींजले_, _akunazo_, _солап_,
   {{0x12d8c40b,0xfe483264,0x986ee042,0x3290104e}},	//   _anden_, _ليسوا_, _asengibu, _bahad_,
   {{0x860151d4,0xcdce0072,0xea0682af,0x4200d27a}},	//   _aallarti, _пишем_, _bakalade, _ludia_,
   {{0x0c0e3352,0x8320b0b6,0x62d8a0e4,0xf2efb202}},	//   _کارکردنی_, _efectos_, _anbet_, _didinya_,
   {{0x985f3284,0x3262d0d7,0xb7599043,0x83f4020e}},	//   _demandar_, _dekabrdä_, _преступл, _postar_,
   {{0x3294f213,0x63ea91e5,0x52901121,0x12d9c4ff}},	//   _anakati_, _wiktor_, _tahad_, _elver_,
   {{0x440c7041,0xcf4490aa,0xbee31500,0x42920395}},	//   _پاکستاني_, _agisamba, _valideyn, _kasamu_,
   {{0xd25a13ab,0x927e9076,0x363e5081,0x137a0285}},	//   _mohli_, _okani_, _kisianni, _kigambo_,
   {{0x2fc2c0c7,0x2200d329,0x7198131c,0x02006228}},	// [750] _والون_, _judia_, _specijal, _mulih_,
   {{0x82fd012b,0x62b39041,0x56e6d2e0,0x71a1d01a}},	//   _abaghi_, _candelo_, _barayagw, _بەزىنەن_,
   {{0x527e6318,0x82c280ce,0x8ae90261,0x7512b0e7}},	//   _nkono_, _mailben_, _intrapre, _tshumelo_,
   {{0x2a173009,0xe26f8063,0x6c13f0c0,0xceba11e8}},	//   _семья_, _hukumatl, _amassats, _пошли_,
   {{0x827e60a1,0x63225089,0x83f8215d,0xf3429327}},	//   _akono_, _parches_, _mikut_, _adirésì_,
   {{0x9291e2b1,0xc0e19406,0x49e4c13f,0x2c51e327}},	//   _retar_, _אדמור_, _fulfille, _eritira_,
   {{0x12d2113f,0xc3eaf25f,0xa291e146,0x3a109475}},	//   _הקבצים_, _gentry_, _setar_, _berbunga_,
   {{0x837a0285,0xe66a6094,0x0da9f1c2,0x82ec80dc}},	//   _bigambo_, _соронзон_, _anatachu_, _civisme_,
   {{0x327860fd,0xb98b423c,0xdac88290,0xa386e3fa}},	//   _jounen_, _richiest, _जकार्ता_, _abirwa_,
   {{0x5889209b,0x75f0b0b6,0x80535101,0x6e01b362}},	//   _boekhand, _cataluña_, _konstren, _anketira,
   {{0xecbb8092,0x3a2a3248,0x43eb23ec,0x5e4f003b}},	//   _maliruaq, _ኣብክንዲ_, _dicter_, _bakamhla,
   {{0x65a063f7,0x1986a326,0x6a14311c,0x4344b3b2}},	//   _jerizalè, _kuthunye, _إبليس_, _cruelle_,
   {{0x627ee470,0xb04c23e5,0x429251e6,0xd3be61ba}},	//   _kvinne_, _modrykon, _uttara_, _giovani_,
   {{0x0edec500,0x8c7d230a,0xf26dd0f9,0xe942b0f0}},	//   _milyonla, _dipsela_, _amboð_, _courrier_,
   {{0xd2d9e2ca,0x06bb2083,0xc3cf830c,0x9c5a61d2}},	//   _altes_, _айланасы, _parve_, _pyntrei_,
   {{0x4bf660e8,0x63ea90dc,0xb290f141,0x43be1362}},	//   _व्यथित_, _conté_, _buhara_, _pohvali_,
   {{0x877401c8,0x827e9187,0x82d8c00d,0xa169f04c}},	// [760] _ברעננה_, _chanu_, _andeu_, _گرسنگی_,
   {{0xd6d7f0fb,0x6da6b306,0x6fba1288,0x918a43a5}},	//   _कौशिक_, _wabonaka, _фаровонл, _ababulal,
   {{0xfd380248,0x93eae477,0xd087e292,0x52da7136}},	//   _ከምዘድሊ_, _mentah_, _бардош_, _berezi_,
   {{0xcc66d051,0xbefc44dc,0xb2d8c2cd,0xca38b194}},	//   _britons_, _tilvilda, _endet_, _ozonwäer,
   {{0x2290c285,0x72d8518a,0xf37ff0af,0x62d8c2d2}},	//   _bulaga_, _zilei_, _この質問に対する, _allein_,
   {{0x4f5b8088,0x60ad32cb,0x538743e8,0x9a71f171}},	//   _melaksan, _مشترڪ_, _aberta_, _watakuwa_,
   {{0x626c6151,0x62fc022e,0xfb649084,0x92369013}},	//   _txoos_, _adige_, _adedokun_, _mbaja_,
   {{0xd27ee501,0x52d8c483,0xc366a3c7,0x3affc056}},	//   _izinga_, _giden_, _escribió_, _makgopab,
   {{0x6290c0e7,0x61ebf10f,0x42e9617d,0xc2369384}},	//   _fulaga_, _اندوزی_, _kotimaa_, _obaja_,
   {{0x5c7531cd,0x73209207,0xd2605101,0xbbcff251}},	//   _minuter_, _oraya_, _lekonomi_, _culinári,
   {{0x4291e222,0x1da6d020,0xf5830257,0x8964603d}},	//   _aftan_, _ersionva, _terrorçu, _abangoot,
   {{0x332173f7,0x72905082,0x9dd5e502,0xeb7d6053}},	//   _mwayen_, _balaf_, _elekkege_, _abonnier,
   {{0x8497232f,0x42d8c27c,0x8f5c00e5,0xfb62a09c}},	//   _дискҳои_, _viden_, _सिंगल_, _aadreesa_,
   {{0x10171063,0xe2d8c01d,0x325a1271,0xf2d8a110}},	//   _پادشاه_, _indes_, _mohlo_, _tobey_,
   {{0x3290f1d0,0x0a475185,0xc321f220,0x4e0310c4}},	//   _ithaca_, _abaduaba_, _utuye_, _masezera,
   {{0x027f42cb,0x72d8c41a,0x98c0227c,0x238773d0}},	//   _kwenye_, _andet_, _続きを読む_, _oharra_,
   {{0x72135369,0xd5c084f1,0xe2eaa08c,0xab8ed48c}},	// [770] _dreher_, _babarril_, _tieners_, _kuzigwor,
   {{0x638763a9,0x227f4223,0x92014286,0xb2c66026}},	//   _digrii_, _mwenye_, _isdias_, _reclame_,
   {{0xf20ec15e,0xb6d3d179,0x0adfa124,0xae36b1a1}},	//   _таван_, _tungumál_, _апресзид, _oltageva,
   {{0x1397606d,0xd3957205,0x6b715285,0xd26c34ec}},	//   _турсунзо, _brasno_, _abasussa_, _kalitesi_,
   {{0xf2b54503,0xce56c358,0x12cae4dc,0x52f39065}},	//   _precum_, _простая_, _rindar_, _ורענן_,
   {{0x22ef21d1,0xc201c06c,0x929070e0,0x9a81d0bf}},	//   _humiswa_, _huvid_, _agnau_, _مضمونیگه_,
   {{0x3bef5087,0xec530504,0x1ba602b5,0xd2d87300}},	//   _genentec, _ब्लेड_, _crazines, _ginea_,
   {{0x229183e2,0x52d8c28b,0x274e3120,0xa970614c}},	//   _teraz_, _fideo_, _anticonv, _চৌপুকুরি,
   {{0x42e68177,0xc4dac20e,0x82d9e188,0x0473b26d}},	//   _hannaan_, _воени_, _jotes_, _baneelak,
   {{0x12d8c505,0x227f442a,0x12d813c0,0xc0e734c4}},	//   _siden_, _dienen_, _dihek_, _almindel,
   {{0x969b920c,0xe30e44cb,0x402181f3,0x54054171}},	//   _baseruki, _citados_, _zenekaro, _مناظرا_,
   {{0x998ec00f,0xf30063f2,0x734ad2a8,0x029050e2}},	//   _таких_, _emnandi_, _tokerau_, _malad_,
   {{0x227e6506,0xb968b086,0xd628b086,0xe20240cc}},	//   _sjong_, _civitate, _civitati, _javier_,
   {{0x52d8c16a,0xc5f9e1bf,0x926e5507,0x644b600f}},	//   _video_, _организе, _petone_, _всередин,
   {{0x627f424a,0xe2d5727c,0xa2cb80c3,0x32918123}},	//   _hienen_, _billigt_, _tvrdi_, _feray_,
   {{0x5f33a23c,0xe31e71c4,0xe4c320c9,0x93ebf2dd}},	//   _следните_, _watchin_, _незаверш, _awute_,
   {{0x6e032083,0xa214b11b,0x42d983c9,0xeeb4a252}},	// [780] _assegura, _регистро, _foret_, _directes_,
   {{0xf262c0c7,0xd638f481,0x93e5703e,0xd29052c0}},	//   _عاشقا_, _чаралары, _àsìkò_, _galag_,
   {{0x57e540bb,0x32d87309,0x6f0d0508,0x99e54049}},	//   _актуальн, _vineh_, _buscadas_, _impulsad,
   {{0x22d9e05a,0x7f5b8477,0x0a313085,0x1a0862b8}},	//   _totes_, _pelaksan, _বালিকা_, _belangst,
   {{0x37d73292,0x1dbe40f7,0x78491171,0x53da404c}},	//   _سارانول_, _蛮儿天赐重逢_, _ايوبي_, _معضلات_,
   {{0x52d8c0dd,0x374ed043,0x8641e033,0x50b5f30f}},	//   _ander_, _крови_, _anaktivi, _गुरुची_,
   {{0x79aa8059,0xc2b39130,0xd20260c0,0xdb64e200}},	//   _በየዕለቱ_, _mandalo_, _arties_, _uchumasa_,
   {{0x805ad0bf,0x018730dc,0x97078234,0x02538030}},	//   _عرفانی_, _پارتىي_, _životom_, _турмушга_,
   {{0x8d1cd0b5,0x12393155,0x92eff266,0x52020148}},	//   _павлодар_, _қобул_, _taufa_, _rosidi_,
   {{0xbae09258,0xa41660bc,0x99e2f220,0xf68a8121}},	//   _sineriss, _ajorehin_, _haboneka_, _akadeemi,
   {{0x7ab140af,0x5851704a,0x2201828e,0xc3a2e101}},	//   _お気に入りブログ_, _peruanas_, _suria_, _konpri_,
   {{0xdb5b543e,0x0d854385,0x2107c0b1,0xd1461105}},	//   _दक्षिणी_, _permukaa, _قرارک_, _מייבאק_,
   {{0x1290500c,0x3476f273,0x73f222a3,0x5af4e038}},	//   _malae_, _textilen_, _иттек_, _investas,
   {{0x3b9a001a,0xe27f72b1,0xc34b318f,0x0d6f20d2}},	//   _بىلمەك_, _azanda_, _scheint_, _احماد_,
   {{0x3fc23318,0x120ab1a9,0xe7304109,0x151d3171}},	//   _abanyepo, _радиосин, _nussbaum_, _kuboresh,
   {{0x6c70c10e,0xb2ac92f7,0x9022e1fa,0x25e9a0ae}},	//   _zakresu_, _бомбилир, _coldrink_, _qaranlıq_,
   {{0x6efc9052,0x827e92c4,0x0c1ce30a,0x32d48437}},	// [790] _samazinā, _ajang_, _edvaisar, _unionen_,
   {{0x529052dc,0x02da549b,0x4127d009,0x4eb1d110}},	//   _balad_, _jeteli_, _рабочих_, _monophon,
   {{0xf2d832e9,0x42907509,0x1ff4c12e,0x098ec1aa}},	//   _bijej_, _manag_, _rachunko, _закир_,
   {{0x9ebb9019,0x83c5f352,0x9415d48b,0x1387034d}},	//   _תּמיד_, _کانونی_, _anonsemk, _kharai_,
   {{0xf2d9e102,0xb38700c7,0xa3d45318,0xfc4ec1ca}},	//   _roter_, _sharci_, _mwamikaz, _زمانچ_,
   {{0x73f841d0,0xef20c3a5,0xbeb804d3,0x329180f6}},	//   _simul_, _ekwenzen, _anmodnin, _agram_,
   {{0xa00d5226,0xb02d1196,0x94abf50a,0x96f2820f}},	//   _proveden, _христийн_, _nastaviť_, _liderlər,
   {{0x43c6e041,0x73f84309,0xef60745b,0xfe89c105}},	//   _فعاله_, _bimum_, _manquait_, _סימפֿאָנ,
   {{0xe2018239,0x927e9082,0xc292150b,0xb2cb0395}},	//   _burin_, _ekans_, _oppakt_, _readih_,
   {{0xc290742a,0x12cf650c,0x0c1570fb,0x9d4ae004}},	//   _vanaf_, _remonte_, _विद्वान्, _کساني_,
   {{0x3ea53049,0x3200e50d,0x43e4b395,0x0f3d60de}},	//   _unidades_, _tenido_, _bɛtra_, _ئمپورىتت,
   {{0x77f9101a,0x78d9b340,0x6291e179,0xdc4a00e5}},	//   _бериле_, _басарабе, _oftar_, _भोजनालय_,
   {{0x6e3fc50e,0xe2fcc101,0xdec88009,0x02901043}},	//   _kamaramp, _progre_, _nezingen, _rahaa_,
   {{0x72d85411,0x12027005,0xa11a1198,0x13209054}},	//   _filem_, _kurios_, _борба_, _tsaye_,
   {{0x32cad2bc,0xda617105,0x72d8a0b4,0xd79f841a}},	//   _bilder_, _בארואיגט_, _gibea_, _bekendtg,
   {{0x0c60d36d,0x3fbbe1cd,0xbdac8283,0xeb11a177}},	//   _女人我最大_, _fungerar_, _alinakup, _gadhabó_,
   {{0x4afa300f,0xd297c044,0x82d8c0c7,0x0ffd9008}},	// [7a0] _населенн, _matariki_, _sidee_, _гарднери_,
   {{0xa63cc009,0x8201828c,0xf2a771c5,0x2639a14e}},	//   _использо, _kurio_, _braben_, _অাওরঙ্গজ,
   {{0x18a5004b,0x22901266,0xf53c4283,0x8ea650e7}},	//   _ترانسپور, _tahaa_, _abayifak, _ndalukan,
   {{0xf3b6b231,0x6da9b185,0x9686b121,0x6200d1d5}},	//   _वातानुकू, _atirimpɔ, _खियाई_, _budim_,
   {{0x529012db,0x12ce02e5,0x6629650f,0x5f8a90f7}},	//   _jahan_, _akadémia_, _soviétic, _广告经营许可证_,
   {{0xc12693dd,0x16a6c185,0xbb0ac510,0x4da10012}},	//   _stepeniš, _britanny, _abafalis, _بارگاه_,
   {{0x7c8a720d,0xc2006351,0xd27e9346,0x92027369}},	//   _уралдаан, _nulis_, _ujang_, _curios_,
   {{0xec4ec0c7,0xc37903bb,0x63f0534e,0xe27f7267}},	//   _زمانن_, _waranka_, _меоварад_, _kwanye_,
   {{0xc20182d4,0xfb5b3300,0xa317803c,0x6e4ee04d}},	//   _purin_, _renerien_, _marzu_, _chianala,
   {{0x1e88a0b8,0x72d6d1cf,0x0061305b,0x643723bf}},	//   _یوناما_, _schlass_, _اندرس_, _concetto_,
   {{0x8b71f161,0x8290e05a,0x720e01e5,0xe2fc901d}},	//   _makombor, _canals_, _кашан_, _adaga_,
   {{0xb9d9a019,0x0c6f205d,0xa6c9739e,0x5071d113}},	//   _אינדרויס, _emprima_, _maratjam_, _pamatsko,
   {{0x027ed511,0xc76a0135,0xdd0a5086,0xae147105}},	//   _okenn_, _መጻእኩም_, _bearshar, _אָפפערס_,
   {{0x63790281,0xab0d035d,0x5265d1ba,0xe34a4296}},	//   _qaranka_, _edición_, _агенции_, _abafile_,
   {{0xed2461d9,0x6b1d3264,0xd2bd71d7,0x320063c9}},	//   _деректем, _الخجل_, _liddell_, _tulit_,
   {{0x1237c2c8,0xa709d0f6,0xad1070af,0x927ed1dd}},	//   _kommuna_, _режимин_, _商品レビュ_, _bhenu_,
   {{0xb2d982e9,0xb4f7c027,0x2851a381,0x22901512}},	// [7b0] _horey_, _communal_, _refranes_, _gahan_,
   {{0xdec22009,0xf7d0c005,0x12011265,0x029ec0b9}},	//   _поэтому_, _многа_, _drzim_, _дилар_,
   {{0x5af2c172,0x406d7166,0xe27ed1af,0x403ae011}},	//   _aparteit, _temporan, _whenu_, _избанзар_,
   {{0xcb1f937d,0x0d2dc1a0,0x12918023,0x02428435}},	//   _bahagian_, _bernheze_, _agrak_, _abombeli_,
   {{0xe9aac057,0xf27c3225,0x429df3d2,0x92cae41a}},	//   _добит_, _necessár, _svijeca_, _vinder_,
   {{0x525a51aa,0x6c283078,0x93803166,0x4dd0a00e}},	//   _mollo_, _ديزني_, _wenzhou_, _sarkisya,
   {{0x55f6d021,0xac2983ab,0x0743c057,0x427dc031}},	//   _molekylæ, _literárn, _бойинка_, _እንሄዳለን_,
   {{0x3c07f29b,0xe80a3036,0x7dbae078,0xd27f709e}},	//   _шароити_, _струва_, _يساهم_, _zvanje_,
   {{0x0fde5402,0x43b0905a,0x63411352,0xbf5c2316}},	//   _archiver_, _مليارد_, _بۆتان_, _magandan,
   {{0x2d9a4513,0xac0732f6,0x1379535e,0xc2d851ed}},	//   _velocida, _tharciss, _kuwacha_, _milek_,
   {{0x7745a198,0xf200649b,0x3bab440d,0xe696714c}},	//   _владата_, _pulit_, _گردابس_, _হনলুলু_,
   {{0x460e40b9,0x60d53358,0xefc8f23c,0xa74c02f3}},	//   _oppozisi, _журнале_, _visitato, _досадашњ,
   {{0x2f2c32a8,0x47a5b0f9,0xa200c4b5,0xe4ef30ce}},	//   _pineamin, _sundalag, _geliyo_, _بحمدہ_,
   {{0x17916206,0x92d64212,0xc25a509b,0x12c8a340}},	//   _sententi, _injongo_, _dollo_, _istorie_,
   {{0x0fe2146c,0xdf771335,0xa37b348f,0xe3b94242}},	//   _polybius_, _concrets_, _desafio_, _slavenu_,
   {{0xa2927514,0xa2bc6110,0x8c01c01f,0xfc67928d}},	//   _kusabc_, _kredito_, _bangaror, _kukuona_,
   {{0x67cf107e,0x62fd6240,0x895e00ee,0x1290317d}},	// [7c0] _dessutom_, _byggja_, _fulltext, _rajaa_,
   {{0x615c2083,0x82d871e0,0x6200a3a4,0xa1692225}},	//   _курал_, _finem_, _orbis_, _методиј_,
   {{0x07de120e,0xf2f004be,0xd9e2a246,0x42d980c3}},	//   _законски_, _uživam_, _fefinaua_, _porez_,
   {{0xf236d2e5,0x428271b9,0x32003063,0x625ac389}},	//   _svojim_, _bamamedi_, _limini_, _mallam_,
   {{0xb25a512a,0xd2eff193,0x986260a8,0xd2deb088}},	//   _collo_, _taufe_, _zapomenu, _memenuhi_,
   {{0xf3f90169,0xa2007139,0x831670c9,0x8b7592d5}},	//   _brauch_, _kunis_, _експертн, _millteac,
   {{0x529263ab,0x1d829300,0x92007424,0xf94ca068}},	//   _strava_, _landerne_, _yunit_, _dermoche,
   {{0x8c5591ad,0x43954036,0xe52f90f3,0x4f34a0c0}},	//   _mouthed_, _spesso_, _fedeltà_, _enlumena,
   {{0x6200c1ca,0x2200d018,0x7bf51128,0x2ff11228}},	//   _celiyo_, _ordin_, _indecenc, _فلاسفه_,
   {{0x73be83d4,0xfb3e53c1,0xb25ac3e7,0x1d785162}},	//   _mwibieng_, _fotbolls, _ballam_, _елментли,
   {{0xc290a27d,0xa2a7f0c4,0xf3f8f12e,0xce031475}},	//   _nabad_, _izuba_, _janusz_, _kesedara,
   {{0xf684f155,0xfe020112,0x299b7413,0x465b71a5}},	//   _ئىتتىپاق, _kegemara, _abakhole, _abakholi,
   {{0xa2903148,0x72a4041c,0xfcf8f0ac,0x827ed0cb}},	//   _najan_, _аннотаци, _정보통신망법에_, _rhent_,
   {{0xf3805370,0xdfe250dc,0x058813a4,0x7201a0c3}},	//   _matric_, _prohibir_, _tharpark, _kupio_,
   {{0x2b43c39c,0xddb3125d,0x02e77245,0x4575112e}},	//   _бойлап_, _malamute_, _ukunika_, _dostarcz,
   {{0xdf68c07f,0x36c5b00c,0x9e35b4e2,0x2300d336}},	//   _cabañas_, _matagofi, _sigaigva, _aneafii_,
   {{0xea8c4285,0x0b7fe1ef,0x33ffe1ef,0x3225f336}},	// [7d0] _chairmen_, _basuraka_, _basuraki_, _apuku_,
   {{0x2db9c3b4,0x5639c2af,0xf2d8c206,0xf2564062}},	//   _akantsha, _akantshi, _fidei_, _agalelei_,
   {{0xd3f8f104,0xfc714141,0x22cec1c5,0xb290d31e}},	//   _sigue_, _dessine_, _lekoned_, _balaas_,
   {{0xe65f02cb,0x2290c19c,0x802300bd,0x6a26f360}},	//   _آسماني_, _kulana_, _katestro, _قادریہ_,
   {{0xc2be317d,0xc3eae196,0x141e2022,0x83f200b4}},	//   _подключе, _kontua_, _ﺍﺷﯩﻠﯟﯨﻦ_, _baalebek,
   {{0xa200109c,0xbdecf17d,0x1ea8423f,0x90cef14f}},	//   _ishii_, _ситуацию_, _boulbonn, _ambarãųa,
   {{0xf9321258,0x5200c266,0x4e2fb07f,0xf27e9108}},	//   _rasmusse, _melino_, _архҭақәа_, _ekani_,
   {{0xa20113fa,0xc8fb80b6,0x8bc96064,0xa3f97515}},	//   _kuzim_, _demasiad, _compléte, _klauen_,
   {{0xedcb3187,0x0b6204e9,0xed3b00f7,0x325d5034}},	//   _cochrane_, _analyzer, _国家知识产权局_, _capacità_,
   {{0x6a16424e,0x0ef372a0,0xc95f9055,0x4e7c20fb}},	//   _minangka_, _ئۆبژه_, _ceinture, _मूत्र_,
   {{0x796492c4,0xb295e111,0x12d872e9,0x29ecb2f5}},	//   _जीवनात_, _komputil, _binej_, _buriouta_,
   {{0xe290b0e7,0x9dbad0b3,0xfc85a105,0xd26e6516}},	//   _mudala_, _видеореп, _פוטין_, _batohy_,
   {{0xe4b4715e,0x2cb7b16e,0x7394d244,0x027ed143}},	//   _didaktik, _границе_, _diosat_, _abongi_,
   {{0x0290a228,0x514520f6,0xd2d8710f,0x6fe3d2cb}},	//   _babad_, _душманы_, _minek_, _لاپتا_,
   {{0x5a39c196,0x120872c2,0x629013e6,0x0291e0e2}},	//   _телевиз_, _učiti_, _tahae_, _betay_,
   {{0xff69604b,0x520e123c,0xc2d9c4de,0xf2d8c4e7}},	//   _bolalarn, _захар_, _envel_, _videi_,
   {{0x4f173009,0x548210e5,0x6d80b2e2,0x2d36231e}},	// [7e0] _ukutjhap, _regulacj, _develope_, _andirekt_,
   {{0x32901177,0x64a7e05a,0x9ee2d517,0x72639115}},	//   _dahab_, _organitz, _стоки_, _alluvial,
   {{0xe27e60c6,0x4354f0ce,0x7917e11b,0x52fce0d8}},	//   _akonu_, _sikeres_, _средине_, _aingil_,
   {{0xb2d870ce,0xe7b56169,0xbbb0c510,0x1d30b08a}},	//   _kinek_, _onbedeng, _abakubir, _abasesic,
   {{0x3b1fb26f,0x4995e394,0x22a1d227,0xe2d8a0b3}},	//   _kajadian_, _markanxa_, _소개합니다_, _kibet_,
   {{0xc74e1381,0x6a1502b5,0xf2d8e02e,0x65421164}},	//   _аппаратқ, _discreet, _koneen_, _cockfigh,
   {{0x804d50dc,0x02e953f7,0x9c5021ca,0xf2903027}},	//   _tarragon, _andidan_, _وچھنہ_, _sajan_,
   {{0x5304740f,0xf341e039,0x6255b0d3,0xcbddc121}},	//   _endanum_, _faleiro_, _cantunal, _बप्पा_,
   {{0x4de0a144,0x94d7f15e,0xb7ed42f6,0x71fe2367}},	//   _akukakha, _сахарын_, _wasangag, _dodiplom,
   {{0x6b910300,0xe94d009e,0xd9a1615d,0x7e61f28c}},	//   _gwengolo_, _nepokret, _بلورین_, _kambaria,
   {{0xeeffb412,0x05ffb248,0xa276f362,0xc3480009}},	//   _asiwayap, _ብሓባራዊ_, _spontani_, _благопри,
   {{0x0d05e00a,0x32901003,0x4bcd20d2,0x829051fd}},	//   _introduc, _tahab_, _апрелде_, _kalan_,
   {{0x337fd0d4,0xb21d3518,0xd3f9b46e,0xac603519}},	//   _belanda_, _кабул_, _nique_, _styring_,
   {{0x82d8e22e,0xe34520fd,0x4ebe1105,0x7d5ed3ca}},	//   _koblenz_, _jandbot_, _יוניאנס_, _विम्बल्ड,
   {{0x8581a05a,0x6493a063,0x7364451a,0xc290c113}},	//   _депутатт, _фермерла, _chegada_, _izlasi_,
   {{0x82a77273,0x025a551b,0xe9eb720d,0xde2b720d}},	//   _muaban_, _sollt_, _langilee, _langilea,
   {{0xe4cd9030,0x8cd482e5,0x535d7027,0xbedca183}},	// [7f0] _харитаси_, _uskutočn, _lungatg_, _juristes_,
   {{0xe9262217,0x02d87177,0xfc6ed406,0xdfca4009}},	//   _студентл, _cineh_, _insuloj_, _принимал,
   {{0xf20012ea,0x5da912ab,0x538742c1,0xc387a16c}},	//   _ishin_, _atsiliep, _ederim_, _espri_,
   {{0xd0ecc25c,0x929100c4,0x276dd182,0xf27f60c1}},	//   _агенттік_, _kubaza_, _ajjhupag, _tignan_,
   {{0xaf120142,0x627ed0c3,0xa3a2d343,0x63452011}},	//   _simbolič, _njene_, _atepa_, _bandbot_,
   {{0xc20180a4,0xde1d713c,0xe2d81142,0xda89911e}},	//   _muria_, _adverbia, _ziher_, _punition_,
   {{0x73f8f01a,0xe2e33037,0x7c09e3e6,0x92c5835a}},	//   _aigua_, _näfis_, _tokomaru_, _hōlani_,
   {{0xfd3c651c,0xe9fc63c1,0xa7b38105,0x32905207}},	//   _tekniske_, _tekniska_, _יאָסל_, _falan_,
   {{0x4290501b,0x6201815b,0x45a880d7,0x1e1a540b}},	//   _galan_, _guria_, _карамаст, _videnska,
   {{0xf096d51d,0x3f2e20cc,0x9ff3e138,0x9c8b408a}},	//   _چالاکیه_, _editoria, _poprilič, _قرارګاه_,
   {{0x35932438,0x93f830e7,0x8291028d,0x4f370030}},	//   _zaseburh, _namusi_, _kubaya_, _uskunala,
   {{0x5c9321d9,0x9a574085,0x6290500e,0x1201834d}},	//   _قاماپ_, _কলোনী_, _yalan_, _buria_,
   {{0x227ef51e,0xaebfa059,0xfae9315e,0xc463a51f}},	//   _ibindi_, _አገላለፅ_, _польш_, _menerapk,
   {{0xbc759520,0xe3f82004,0xcd4060fb,0x43b671b0}},	//   _moduler_, _tikus_, _क्षेत्रं_, _dievča_,
   {{0xdfa4f26a,0xbbe4f00b,0xe03cd036,0xa03fc00a}},	//   _november_, _novembar, _recensio, _listenin,
   {{0xa29052aa,0x72d572b0,0x9aecc2f8,0x793f715f}},	//   _lalao_, _angogen_, _bubuluit, _taimaitt,

   {{0xcb977042,0x23568110,0xfc61812b,0x93cc20f6}},	// [800] _tínhamos_, _griffon_, _eserese_, _башланяр_,
   {{0xaa8b1101,0x69f3f20f,0x735f342c,0x72d8c23e}},	//   _desizyon_, _fikrincə_, _tingene_, _bideu_,
   {{0x6ccdc018,0xd3f822ea,0xaad52192,0xfdc7d009}},	//   _preveder, _dikur_, _аңламай_, _ошибок_,
   {{0xbc44640b,0x1c932083,0xc27ed492,0xc7d93276}},	//   _プライバシ_, _سالات_, _tjene_, _ابراھيم_,
   {{0xe290520f,0x5c51f0cc,0x72e954cd,0x52d8c238}},	//   _qalan_, _ventana_, _indican_, _indez_,
   {{0xf34ec071,0x82003062,0x62d9e44f,0x62a6e1d8}},	//   _tagelyk_, _samita_, _ontem_, _tribun_,
   {{0x5ed67101,0x258952eb,0x255661bc,0x69582101}},	//   _tanzanie_, _comisarí, _بۇزماي_, _kalorife,
   {{0x34868121,0xfda742ad,0x0bedf128,0x8c6d80a9}},	//   _बाजारी_, _marumaru_, _seafarer, _amirika_,
   {{0xf47c31d6,0x59da8160,0xb6f7e15a,0xfb843030}},	//   _lusekelo_, _spremlje, _सातवें_, _افراطیلی,
   {{0x820030e7,0xd84bd3a4,0xe288f02a,0x427f4104}},	//   _tamisa_, _litteris_, _derangem, _vienen_,
   {{0x22d8c3c8,0x038773ad,0x527f4521,0x1b10b1c7}},	//   _videl_, _daarna_, _wienen_, _ﻤﻌﺭﻜﺔ_,
   {{0xf29051fe,0x227f447f,0x929071fe,0x5ea8514d}},	//   _dalal_, _tienen_, _xanaa_, _kindlaks_,
   {{0xa5be2152,0x64225036,0x50f100f9,0xc2d9e0c6}},	//   _другу_, _indirizz, _grundarl, _entem_,
   {{0xb177238c,0xf3f83003,0xf2cae0ec,0xa32611d9}},	//   _месту_, _samuti_, _lindur_, _جايىمىز_,
   {{0xbc878085,0x0290138d,0xf2c86241,0xf556d1c7}},	//   _তালুকদার_, _bahaa_, _nicolae_, _ﺍﻟﺜﻭﺭﺓ_,
   {{0xc3f820ec,0x2213e1b9,0x5c753440,0xa06e2075}},	//   _sikur_, _letho_, _ennuyer_, _anksiozn,
   {{0x42b40339,0x6200614a,0x42e900f1,0x115a82c5}},	// [810] _teica_, _aslik_, _lesinga_, _situasjo,
   {{0x22907134,0x50d5312f,0x9a9040de,0xac6fc141}},	//   _danan_, _аңлитип_, _اقىچىيلى, _aktuwak_,
   {{0x4b69b234,0xddd2e1e8,0x1d042012,0xb2925394}},	//   _nobunaga_, _отель_, _ڳولها_, _jutata_,
   {{0x92d8c26a,0xa2dbc07d,0xd90553d9,0x2ec2d387}},	//   _under_, _felosip_, _boobabed, _apinfunn,
   {{0xc2257025,0x6200d1df,0xeafb6421,0xdb072008}},	//   _apakan_, _ludis_, _afarsine, _бирехим_,
   {{0x627f0125,0xa27e6522,0xeb7c329b,0x625ac2e5}},	//   _abandi_, _ikony_, _kusukela_, _podla_,
   {{0x62c940e8,0xcad17175,0x4b5b54bd,0x02fcd1c4}},	//   _stronie_, _terminan_, _दक्षिणे_, _hanged_,
   {{0x027f4523,0xf4a8a17a,0x7366a148,0xf737601c}},	//   _mwenge_, _আশঙ্কায়_, _tangkal_, _کارتوس_,
   {{0x92d9844c,0xe2026086,0xbc73c110,0xb2ec626a}},	//   _diren_, _merito_, _pulsera_, _february_,
   {{0x4506e1ca,0xc2fce38b,0x5ed91339,0x88d5b020}},	//   _دامانہٕ_, _langtu_, _kopienas_, _enerateg,
   {{0xc290735a,0xd27ed2ce,0x925a508f,0x4c6b512e}},	//   _manao_, _akeni_, _golli_, _चुम्बन_,
   {{0xb15622a3,0x338773ad,0x1fe6415a,0xf1dfc0e5}},	//   _башынан_, _waarna_, _मनीकंट्र, _स्कारलेट_,
   {{0xac5a018b,0x8201f15e,0x7528e1ec,0xa48b7180}},	//   _syntiew_, _mutil_, _indikasy, _パティスリ_,
   {{0x7a07425d,0xd2d981eb,0x93f8d29e,0x73f8f171}},	//   _ahmadiya_, _hiren_, _pneus_, _miguu_,
   {{0x0ba8b0d7,0xfc0d32c7,0x8f53d20e,0x9d7831d9}},	//   _хакимият, _pripade_, _домашна_, _ابايدىڭ_,
   {{0x45c8f4b1,0xcb8bd33c,0x625a51fe,0xd2910181}},	//   _muralith, _vakillar, _dolli_, _kubana_,
   {{0x02e11103,0xa420e0ac,0x5ef1338c,0x54874524}},	// [820] _minifig_, _개인정보의_, _осталих_, _प्रार्_,
   {{0x0a03a525,0x825a523e,0xa9d6e085,0x92d58225}},	//   _mauritiu, _folli_, _ডার্কলর্, _conosco_,
   {{0x537900cf,0x92920114,0x5290701f,0x4290527d}},	//   _gagawin_, _ampang_, _wanan_, _qalad_,
   {{0xdb1cb526,0x5e34742f,0xb1701527,0xc2d98207}},	//   _bazakwab, _anagerma, _sensatio, _giren_,
   {{0x82905177,0x4a3921bf,0xbed5642d,0xd20253df}},	//   _galab_, _веселие_, _mínimos_, _antikk_,
   {{0x427f41fb,0x8be49227,0x51e18528,0x4dc7b0ce}},	//   _bwenge_, _국가인권위_, _अविरत_, _munkanap,
   {{0x525a5199,0x14326476,0xbfdc510b,0x026e60b4}},	//   _colli_, _descenso_, _atazoron, _ierome_,
   {{0xe8c45046,0x38f560b9,0x429261ba,0xe294f0c5}},	//   _liberdad, _акрабала, _durata_, _amakopi_,
   {{0x473b3276,0x0207b283,0x39cf9248,0xe342122e}},	//   _ايماندار_, _abakwati_, _ዝተፋላለየ_, _rogelio_,
   {{0x396e9152,0xc98e3030,0x527ff278,0xb6886287}},	//   _kiinnost, _далил_, _ikuna_, _фантасты,
   {{0xb826a083,0x5eab8139,0xdcd981ba,0x03f820a4}},	//   _بالاعا_, _abdullee_, _заслужав, _dakui_,
   {{0x03eb0514,0x22907100,0x159c01fd,0x1a0181de}},	//   _kwathi_, _tanan_, _koleksiy, _prošlo_,
   {{0xc2a66514,0xcd28c10d,0xf20032f8,0x4277a116}},	//   _uqobo_, _андрэй_, _simici_, _piisaval,
   {{0xf2d98196,0xfc113178,0x72f1e03c,0x029091ac}},	//   _ziren_, _helsingb, _antichi_, _dikany_,
   {{0x626473df,0x7efa53a1,0xc1b0d227,0x2245a248}},	//   _syslog_, _abajaman, _일부상품은_, _ዝበለጸት_,
   {{0x9d78400b,0x523841d4,0x29cd92d7,0x893841d4}},	//   _kommunit_, _kommuni_, _barongwa_, _kommunip_,
   {{0xf2018340,0xd290a27d,0x226e61f2,0x6c2ac1e2}},	// [830] _murit_, _rabaa_, _strond_, _авесто_,
   {{0xe290f02f,0x89db839b,0xe290a07b,0x7395738a}},	//   _kuhala_, _setefike, _sabaa_, _omasta_,
   {{0xc2d852bc,0xd27ff2d4,0xf2905096,0x02fc60ef}},	//   _filer_, _akuna_, _malac_, _ndogo_,
   {{0xf6a9019d,0x52905288,0x82fcd317,0x9d57d287}},	//   _litreach, _talab_, _krogit_, _названы_,
   {{0xb2d87165,0x7201f2aa,0x1290f0aa,0x92cf622f}},	//   _ihnen_, _cutie_, _muhama_, _nemojte_,
   {{0x1ae5f11d,0x92d85118,0x495090ea,0x427f224a}},	//   _abarrote, _riles_, _स्पर्धाम, _skynt_,
   {{0xe21c705b,0xdd8e008c,0x02da72e2,0xf200d38d}},	//   _cashed_, _veroorsa, _jeremi_, _ardii_,
   {{0x3290a18b,0x94cad10f,0xdb87f10f,0xdfd53292}},	//   _kaban_, _دروازہ_, _megismer, _курашда_,
   {{0xa2907080,0xbb62345f,0x0cc061ba,0xada3c012}},	//   _manam_, _कामना_, _известни, _گهاتو_,
   {{0xc290a376,0x4dd9c078,0x12d551e7,0x65f9d0ee}},	//   _daban_, _اتخاذ_, _avaliku_, _komenské,
   {{0x923b40f7,0xc60c812f,0x4981e16c,0x437f9056}},	//   _控制面板首页_, _ﺟﯘﻣﻬﯘﺭﯨﻴ, _dominike, _tlhahla_,
   {{0x720182ab,0xc201c152,0xd4165387,0x1fad900f}},	//   _turiu_, _kuvia_, _akoroyin_, _поточног,
   {{0x2c09e313,0x727ed0b0,0xf3731529,0x62009368}},	//   _ijipita_, _nyonya_, _izlaske_, _pikini_,
   {{0xf1dff059,0xc25d514b,0xd380713c,0xd21c7010}},	//   _አማኑኤል_, _capacité_, _амонахцә, _bashed_,
   {{0x1238a09a,0x3e70d14d,0x6ad073bf,0x82739040}},	//   _органлир, _कॉर्न_, _инфекции_, _botichdi_,
   {{0x967a01f2,0x8360606e,0xc545c252,0xeb840065}},	//   _almennum_, _पॉंईंट_, _ابادا_, _לטענתו_,
   {{0x627ee285,0x5a2be048,0x229050c7,0x135f3404}},	// [840] _oyinza_, _hodonín_, _qalab_, _zingine_,
   {{0xf387018b,0x28e48057,0x22d87238,0x7310e1a1}},	//   _kharoi_, _густос_, _annez_, _istavay_,
   {{0x5cd9709a,0x34367248,0x84b3f510,0x163ac139}},	//   _قولدىن_, _መንግስትነት_, _abachwez, _amananii,
   {{0xd4c30192,0x420ec15e,0xc27f0293,0x929100b4}},	//   _алтындан_, _шавар_, _abanzi_, _iubala_,
   {{0xf290a239,0x62b7d238,0xc2d9e086,0x729074b5}},	//   _gaban_, _kendalc_, _antea_, _sanad_,
   {{0x1c1d816f,0x42d8c1d2,0x2c5284de,0xc8c9907c}},	//   _רשעות_, _kidei_, _hentenn_, _продукта,
   {{0x46cc23f7,0x7309b0a9,0x837001c5,0x726ce22f}},	//   _ekspresy, _pozzuoli_, _dinamaf_, _odnosa_,
   {{0x652a32e2,0x1290a4f1,0x027f0245,0xaef9b2aa}},	//   _popilasy, _yaban_, _ebanzi_, _panjakan,
   {{0x8b0e73a5,0xb27f4435,0x368c014f,0xec75938a}},	//   _entshona_, _abengi_, _बलवान_, _inducer_,
   {{0x925a516b,0x5dbed0cc,0xddce301a,0x2e8ff37f}},	//   _kollu_, _pelicula, _билем_, _adamuten,
   {{0x039470af,0xb5b750f6,0xca957506,0x22d8b32b}},	//   _件を表示していま, _буйругын, _toaniels, _fodern_,
   {{0xb6293218,0x827ee045,0xc387013a,0x7b2ca09e}},	//   _traidisi, _ayinza_, _bearem_, _omladins,
   {{0xe29ed04c,0x1292647e,0xadc2a17d,0x69ee5330}},	//   _امامی_, _catars_, _ensisija, _大理风景名胜区内,
   {{0x37a3046e,0xf00bd173,0x263d13d5,0xf291b16c}},	//   _cerulari, _атанак_, _foreslåt, _davans_,
   {{0x63ac609e,0x22e8e01f,0x120080e7,0x826cc14b}},	//   _ukupno_, _miliyan_, _nakisa_, _salope_,
   {{0xd347d076,0xc0f04475,0xd20182ea,0x03f99411}},	//   _kuleana_, _melantik_, _burim_, _ansur_,
   {{0x9290a52a,0x50b8113f,0x99dea1b9,0xad1ea192}},	// [850] _qaban_, _לתצוגה_, _ananelwa_, _ananelwe_,
   {{0xe118138c,0xe2e5f0e7,0xf3f86089,0xd25af2ff}},	//   _гимназиј, _tsinina_, _shoud_, _chillu_,
   {{0x198e120d,0xcdc340e7,0xad0d73dc,0x1c7ff0d2}},	//   _зарим_, _tshitsha, _родителя, _enguany_,
   {{0xdd95900b,0xc290a177,0x6b67634a,0xc2d874de}},	//   _qallunaa, _taban_, _amathuba_, _sinet_,
   {{0x530cb312,0x4320d0fd,0xd2ae0224,0xef69e449}},	//   _pesawat_, _eseye_, _lebantšh, _sumarios_,
   {{0x5c602027,0x225a51fe,0x12011166,0xc27f7285}},	//   _secunda_, _tollu_, _ambitu_, _kwange_,
   {{0x2290507b,0x7c53c52b,0x805e62b8,0xb2021115}},	//   _balaa_, _डोमेन_, _moontlik_, _espias_,
   {{0xc2018196,0x72b40078,0x8da51133,0xc2d87478}},	//   _orria_, _seice_, _zamilova, _tines_,
   {{0xe250c1d9,0x1635c0d7,0xf2d8b2ff,0x7201b3e8}},	//   _بىلەك_, _элекке_, _andeen_, _devido_,
   {{0x62efc52c,0xd7259065,0x156a2308,0x4e38e05d}},	//   _kalinya_, _נועדו_, _chivirik, _egualita,
   {{0x12817085,0xd290a364,0xce529357,0x9b95b52d}},	//   _সন্ন্যাস, _gabal_, _anuaryja, _insistir,
   {{0x4290c054,0x09aac11b,0x1c1dc0f0,0x4df8c152}},	//   _kadan_, _новим_, _visualis, _женский_,
   {{0x66c7503c,0x3290c353,0x35f3a20e,0x54035221}},	//   _cambiari, _jadan_, _orientaç, _abangenz,
   {{0xd69b80e4,0xd290c2dc,0x227f7285,0xa9669287}},	//   _lidershi, _dadan_, _bwange_, _просты_,
   {{0xf7bda406,0xf882f3c2,0xbdbec1c2,0x027ed11b}},	//   _interlig, _abakituu, _alliylla, _njeno_,
   {{0xde114210,0x0e3a4052,0xe55c1105,0xe3408082}},	//   _ommentca, _pianists_, _גלוגעוו_, _penemon_,
   {{0xe2eda198,0x325ad0d3,0x22cc708c,0xb2d9c0fd}},	// [860] _приватна_, _sillas_, _paulsen_, _diven_,
   {{0xd320923d,0xa27e90c4,0x52008435,0x02624180}},	//   _tsaya_, _ijana_, _bakisa_, _ルドライレディ_,
   {{0x727f720a,0x0e3da31a,0x1ff2412f,0xdeb2147e}},	//   _gwange_, _kitulliq, _ﺩﯦﺘﺎﻝ_, _ausetans_,
   {{0xb290c068,0x3a9411cd,0x52d9c1a0,0xff435053}},	//   _badan_, _artikeln_, _niven_, _passiert_,
   {{0xcb2061f3,0xc1bd23bf,0x72da70a4,0x33d1127f}},	//   _مالیاتی_, _чисти_, _cereki_, _رێکار_,
   {{0xb815d36f,0x82aae2b5,0x32476257,0x8290a09c}},	//   _буласаҡ_, _concealm, _dəmir_, _babal_,
   {{0x2b99c52e,0xb3827328,0xc4ff30de,0x13ead0c6}},	//   _उपयुक्त_, _hansardm, _اشىرابەر_, _mpotam_,
   {{0xf3a20213,0x13f8901f,0x83f890f7,0x9ec502e9}},	//   _atipt_, _hakuri_, _chaud_, _brazilda,
   {{0xa2d9a004,0x220182f4,0x63be8090,0xca85b34e}},	//   _piped_, _urria_, _chaveni_, _ҷумбиши_,
   {{0x92d9e46c,0xb38be0a4,0xfc09b0c5,0x8adf3053}},	//   _anten_, _bosstaki_, _amugumir, _bildungs,
   {{0xd11471f7,0xa290c27d,0x47b7801a,0xc964b085}},	//   _konkursl, _aadan_, _aportaci, _শুভকামনা_,
   {{0x69147235,0x60ddd24b,0x1a147183,0x52f1a3ba}},	//   _concursu, _положите, _concurse, _samouboj,
   {{0x027ed045,0xdc5531a3,0xd355413f,0x5f4c602e}},	//   _byonna_, _maitele_, _angeles_, _plussala,
   {{0xb60bd092,0xa2cbe0bf,0x23a2c214,0x82d9c1d7}},	//   _algoyati, _sirlari_, _кілтін_, _aiven_,
   {{0x1290a137,0x8956a043,0x2213e17f,0x936c634d}},	//   _babae_, _tallenne, _bethi_, _dingiei_,
   {{0xb2ddf018,0x53911287,0x2c6140be,0x81912180}},	//   _europei_, _эміграцы, _martuar_, _に付着した電着塗,
   {{0xd2d9c28f,0x4213e2e4,0x4f4d00eb,0xc18c021d}},	// [870] _viven_, _dethi_, _adoptate_, _धरुवम_,
   {{0x22b0830e,0x3e3860ea,0x527ed3c2,0x72d9c13c}},	//   _कानुन_, _पोर्टफोल, _gyonna_, _inves_,
   {{0xd2d852f8,0xcba42120,0xea1a71d9,0x1741c143}},	//   _talei_, _artikulo_, _شىققان_, _comprimé,
   {{0x34c5820e,0x02d9c453,0x53a2d0f0,0x5201a075}},	//   _trabalho_, _anvet_, _propos_, _kupim_,
   {{0x32d9e02e,0xe2907390,0xf4b6814f,0xf9f602b2}},	//   _miten_, _manaa_, _बहुतरं_, _मृगेन्द्,
   {{0x22d9e0bb,0x73a20295,0xcfbe523e,0x005ff177}},	//   _liten_, _kuipa_, _arête_, _anninnak_,
   {{0x04751169,0x22e8407b,0x4987e213,0x1c4a345b}},	//   _photogen_, _abdisaa_, _masinaka_, _bétail_,
   {{0x62d8315b,0x2f79b0f4,0xd64e01d9,0x3ea2f474}},	//   _jajem_, _ئىملاغا_, _тарифтік_, _mantiene_,
   {{0x68e0a111,0xca97c0d2,0x92b733be,0x3c4a30f7}},	//   _malgrand, _قاناكۅرۉ, _другими_, _détail_,
   {{0x4f3fe234,0x2685e009,0x3f2e4005,0xfd5354b6}},	//   _nakoniec_, _отображе, _sektoria, _pamiedük,
   {{0xe2d830f9,0xc290c421,0x144990af,0x6519e013}},	//   _alment_, _sadan_, _ドを忘れた_, _терент_,
   {{0xa97f0241,0xfe06c2d4,0x59f370e5,0xf7e702b2}},	//   _vehicule, _abidjana, _konstytu, _रेकर्ड_,
   {{0xa2d9e0be,0x92d9c089,0x4f20c231,0xc367b06a}},	//   _diten_, _riven_, _interwen, _pangdam_,
   {{0x026d009e,0x3213e0c0,0xdd8733d6,0x1201f39e}},	//   _odbora_, _sethi_, _другого_, _kutiw_,
   {{0x3ebd1075,0x626ce439,0x5278b3c6,0x4e5064ad}},	//   _vožnja_, _jenova_, _takitini_, _boramola,
   {{0xb201824c,0xa29260ff,0x86afb34d,0x929024cd}},	//   _arrin_, _sprake_, _nangshai, _remate_,
   {{0xf290c4b5,0x06cbf106,0x32fd521e,0x099800d1}},	// [880] _hadal_, _cheartai, _muggle_, _bleksema_,
   {{0x28e62136,0xc33cb13f,0x42d8a252,0x37b061ba}},	//   _африк_, _מצטיינים_, _ribes_, _esercizi,
   {{0x0394e174,0xd851e06a,0xc2d873d9,0xa27ee459}},	//   _opisao_, _perlindu, _banei_, _etinye_,
   {{0x4e96e0b8,0xcee8a248,0x950920d7,0x748e91f8}},	//   _براون_, _ትግራዋይ_, _массакүл, _napravlj,
   {{0x12e3c3f2,0x3b0d32fd,0x52d8a079,0xa2b40127}},	//   _iphinde_, _خشنده_, _diber_, _beici_,
   {{0xaa0271ca,0x82d811d2,0x5249442e,0x3290c1d5}},	//   _somalida_, _baheh_, _snemma_, _izlazi_,
   {{0x72d9e42c,0xd981b1ca,0x3dc9f49c,0x3b53721d}},	//   _intet_, _قٕسمتس_, _holyrood_, _abravīn_,
   {{0x5a0b0356,0x33f84100,0x89fc9357,0xd2d9e193}},	//   _eleakala_, _kamut_, _ermanent, _giten_,
   {{0xda450276,0xdfc5d09e,0x39fcf121,0x1ec8a229}},	//   _اندرين_, _pomorsko, _kavandat, _iniziale_,
   {{0x9290c079,0x48d1d22e,0xa319d223,0xe2d9c03a}},	//   _badal_, _ravensbu, _فيضان_, _anver_,
   {{0x72d761f8,0x46b8c2af,0xcd99d008,0x82d8d0bb}},	//   _navodno_, _bakatisi, _gollanma, _avlest_,
   {{0xb26cc079,0xfdb1a2fe,0x439d952f,0xe27f4530}},	//   _balote_, _musazawe_, _televīzi, _abenzi_,
   {{0x9213e199,0x0bb7a0a8,0x3db38128,0x8268a2a7}},	//   _methu_, _programů_, _stearate_, _اویدیره_,
   {{0x820f7311,0x8213e3a5,0x22d9c0be,0x87cb6476}},	//   _işini_, _lethu_, _enver_, _castelán_,
   {{0x1ad521b9,0xdf5d30d7,0xc349c0fc,0x52d8a289}},	//   _аңлата_, _ukrainan, _аномаль_, _tiber_,
   {{0x622003b3,0x33413004,0x4bc7e17d,0xf2d9e091}},	//   _viljandi_, _پنجاه_, _продаже_, _antet_,
   {{0x946ee1b1,0xa2d8c313,0xf39650c9,0xe3bda193}},	// [890] _время_, _baleti_, _авторськ, _akawong_,
   {{0x13ebf0a8,0x3df1b45f,0xebed10ac,0x42d8a146}},	//   _historii_, _sledovat_, _네비게이션_, _siber_,
   {{0x33d81065,0x331f2034,0x42f9913c,0xa3874531}},	//   _מתיווך_, _marchio_, _болгариа_, _aberya_,
   {{0xa439d056,0xa62c11a1,0x92d8c206,0x8249700e}},	//   _boikanok, _accountw, _fides_, _inamla_,
   {{0x425ba2e4,0x25ad206a,0x9db4c404,0x9d56c3dd}},	//   _amply_, _बोलता_, _قوتون_, _saradnju_,
   {{0x78898288,0x604dc0c9,0x125a50f0,0xc1c500f7}},	//   _талабала, _проте_, _fille_, _提高服务质量_,
   {{0x521c13ef,0xb2d8c1d7,0xfa9110c6,0x537f8262}},	//   _sophos_, _hides_, _anyinyin_, _muhanga_,
   {{0x226cf05f,0xe5a1f0be,0xd22b33ae,0x6b34d139}},	//   _iehova_, _politikë, _animace_, _baballis,
   {{0xc2be4078,0x9b8d33cf,0x97b740a8,0x9a6d1056}},	//   _بالاضافة_, _stridbar, _poplatek_, _mengwaga_,
   {{0xf067e2e6,0xfb3100d7,0x52311292,0x0607702f}},	//   _उदासी_, _тәшкил_, _بخورد_, _tapeworm_,
   {{0x48ef60ac,0x03f491e8,0x117b814a,0xc2ba90cb}},	//   _각종계약서_, _вероятно, _allaaqal, _academi_,
   {{0xf413d0d8,0xc213a12a,0x273a13cc,0x6c643115}},	//   _fairburn_, _nephi_, _босго_, _centrau_,
   {{0x4832c1d9,0x12d85351,0x86b9812f,0xd39543dd}},	//   _قارىم_, _dalem_, _камбоджа, _smesta_,
   {{0x7369c109,0x673df083,0x57b4f2d2,0xec76913f}},	//   _fingrar_, _avantatg, _mittlerw, _causing_,
   {{0xa388f174,0xcaac8504,0xd290e24e,0x360d43ef}},	//   _unutrašn, _मच्छर_, _safan_, _humordri,
   {{0x933d7176,0x2290a390,0xa2fcd010,0xc15b82c1}},	//   _میلاد_, _gabaa_, _banged_, _nedeniyl,
   {{0x02918532,0x396d4128,0x592ee0d2,0x12d8a040}},	// [8a0] _xaraf_, _desiccat, _палестин_, _bibep_,
   {{0x561c522e,0xf2d71533,0x29e07075,0x56a3d3c8}},	//   _podlaski, _mirongo_, _navodila_, _dajustah,
   {{0x3b11c168,0xe213e3a5,0xfe4b1336,0xbd01425d}},	//   _misschie, _bethu_, _angavale_, _anulaire_,
   {{0x9e48c10a,0xe9d4b003,0x37f681ba,0x92d8c207}},	//   _آيتون_, _अनुपस्_, _текстове_, _gider_,
   {{0x4c6f122c,0xc8153342,0xf290a12b,0xae120053}},	//   _sharron_, _ابنته_, _dabaa_, _vereinba,
   {{0x3213e4e8,0x99f8d13b,0x32d8c431,0x13a26086}},	//   _wethu_, _kamisina_, _aider_, _prope_,
   {{0x642084a4,0x32fce469,0xfd7381b9,0xd3f820e8}},	//   _maradiyo_, _singul_, _геологта, _zakup_,
   {{0xf2911037,0x32918007,0x0da730db,0xa9dbd256}},	//   _kazan_, _marad_, _bahokaha, _ahindura_,
   {{0xe386a1f3,0x9c626393,0xe30eb135,0x3264624a}},	//   _شاندار_, _escribe_, _shtator_, _houlik_,
   {{0x72d853a3,0x5272816e,0x3d85c438,0x12bb908c}},	//   _malej_, _географс, _annexure_, _engelse_,
   {{0xa35bf370,0xf3806534,0xf37fa19e,0xa2d9e008}},	//   _sangoma_, _actriz_, _takahia_, _entek_,
   {{0x317d9019,0x988151bc,0x2200923a,0x91dfb401}},	//   _קירוב_, _ئجاارا_, _khaii_, _margaidh_,
   {{0x32fcf12a,0xa59fb1d1,0xc20091a5,0x184c1027}},	//   _junger_, _linganah, _shaik_, _promoziu,
   {{0x02fc607e,0xc3a0127c,0x72e99086,0x88706535}},	//   _blogg_, _ログインして投票, _usenext_, _शैलेंद्र_,
   {{0x12d8513a,0x02d8e09b,0xa2d8c266,0x22d8b304}},	//   _talem_, _lifes_, _salesi_, _paderi_,
   {{0x327f4299,0xa3f8d04d,0x8378d01f,0x23f8d202}},	//   _utente_, _cheud_, _lamarin_, _lieur_,
   {{0x729110e4,0x9a0eb17f,0x9fe722f4,0x6424117d}},	// [8b0] _cazan_, _бомбгузо, _эрхзүй_, _politiik,
   {{0x62cae240,0x2e9973f7,0x12e8647e,0x235f3012}},	//   _sindur_, _kontinye_, _perfum_, _kingine_,
   {{0x5a474473,0xe2786015,0xec8011c7,0xfc6d1277}},	//   _foreldra_, _trunka_, _терең_, _relatóri,
   {{0x473c1196,0xd26cc299,0x4301e044,0xada77006}},	//   _олимпийн_, _valore_, _parauri_, _achipata,
   {{0xbd2840a1,0xa290b2a6,0x3a8970b0,0xca87c124}},	//   _aadiyaat_, _dodamo_, _disimpan_, _белиаева_,
   {{0x52d8c536,0x8f8e01d9,0xb2af9449,0x47a19267}},	//   _sider_, _تارماققا_, _achachaw_, _ighukari,
   {{0x82d98317,0xac764537,0x2f15c1ba,0x75b621d0}},	//   _miret_, _estudos_, _блогове_, _voiperiz,
   {{0xd2911538,0xb4aba28e,0xed8df31c,0x026e72df}},	//   _yazan_, _menanyak, _odgovara, _burotu_,
   {{0x429182ad,0x7341305a,0x82d8c201,0xd6d05345}},	//   _marae_, _اندان_, _vider_, _ट्रिक_,
   {{0xa055103e,0xcabe80f6,0xbc2d219d,0x0b2d219d}},	//   _adarihun, _голастыл, _barantac, _barantas,
   {{0x7200b2c7,0xaffd1124,0xbd96a003,0xc2d87300}},	//   _akcie_, _процесси_, _tallinna, _ganet_,
   {{0x62eef37f,0x8d1bc159,0x82d8c202,0x020042ff}},	//   _heifer_, _mennyire_, _hidep_, _bimiy_,
   {{0x3291a137,0x83c6e218,0x7e9ec0c8,0x99fd24f3}},	//   _kapag_, _تعالو_, _магла_, _batandat,
   {{0xacb65110,0xa26451bf,0xd8f2e194,0x02d87289}},	//   _polyneur, _sucursal, _spiggelu, _kanet_,
   {{0x5201c263,0xb306026d,0x7413c0f4,0x727e03af}},	//   _irvin_, _karolong_, _ساددا_, _nding_,
   {{0xa5861038,0x52fc9004,0x0949d10d,0xf6fb50b5}},	//   _diproduk, _tlaga_, _снежань_, _ارپتەس_,
   {{0xb469849f,0xd9f2a36f,0xe26e6113,0xeeb362c8}},	// [8c0] _prefeito_, _amahngwa_, _autoru_, _starvast_,
   {{0x2e6ac1f7,0xf2c381a3,0x32d0e3a1,0x57399030}},	//   _фонды_, _kholomo_, _sulemani_, _қаратилг,
   {{0xf290f28d,0x46d67022,0x727ed1d5,0xdefcb1f7}},	//   _kuhama_, _نايمان_, _sjena_, _allahunı,
   {{0x1e18e339,0xb200c22a,0x3290c17e,0xf206e180}},	//   _galerija, _veliko_, _gadaa_, _クリックで拡大_,
   {{0x8492a048,0x1291a118,0x527e916c,0x1083402a}},	//   _जम्मा_, _lapad_, _ajans_, _calcareo,
   {{0x62d87007,0x02926114,0x470840ac,0x357b1098}},	//   _hanem_, _purata_, _산업자원부_, _imitungo_,
   {{0x3291a09e,0x8201245b,0x9f3af4bb,0x965f907e}},	//   _napad_, _vicini_, _pemuliha, _konstnär,
   {{0x52d85177,0xba7cb539,0x827ed0db,0xc0fd7152}},	//   _maleh_, _ojúewé_, _tjena_, _магазины_,
   {{0xca9423e3,0x57c8e0df,0x23f803c9,0xf92ba156}},	//   _priyorit, _initialw, _maius_, _indivídu,
   {{0xa2d980ea,0x8871e2bd,0xb3a2d049,0xa3a290ec}},	//   _firem_, _исмаһам_, _tropas_, _prape_,
   {{0x9291539a,0xb6184059,0x90373020,0x3f925284}},	//   _pokaż_, _ተግባሩን_, _undevelo, _predicar_,
   {{0xe712f35b,0x9292653a,0x26ad4443,0x5291300e}},	//   _форумі_, _kurara_, _agureroh, _baxan_,
   {{0x3a5fb05d,0x5c825275,0x72ea50ea,0xbd55c030}},	//   _dumengia_, _بوستانلى, _शुभारम्भ_, _assalomu_,
   {{0xc201826e,0xd2d8700a,0xaad742a9,0x161a5248}},	//   _kuris_, _panel_, _festplat, _በብቑሩብ_,
   {{0xb2018035,0x908d91c8,0x8ed5c0c9,0xbbb92340}},	//   _juris_, _לשיער_, _kopierin, _десенат_,
   {{0x12e31226,0xfe9a71ba,0x443ec09a,0x52018005}},	//   _policie_, _comunque_, _санни_, _duris_,
   {{0x2aa840ac,0xb2249285,0x030db193,0x157ba10b}},	// [8d0] _지속적으로_, _lwaki_, _bagawer_, _amatongo_,
   {{0x0a08d24e,0x127f72f6,0xf9e85152,0xddbed1ab}},	//   _ramayana_, _nyanza_, _kustannu, _pelikula,
   {{0x92d8e36e,0xb2d833ab,0xa37322b1,0x7be88248}},	//   _baneri_, _objem_, _annatye_, _ርእሰማል_,
   {{0x130da53b,0x0d90a0e5,0x839570c0,0x9ba28140}},	//   _freiburg_, _शिक्षकेत, _amassa_, _медальлә,
   {{0x7628b1c8,0xbda101af,0x5968b0f0,0xc46bc1e8}},	//   _navigati, _taputapu_, _navigate, _скидки_,
   {{0xd1c6b407,0x6afa5005,0x82da71cf,0xd2d7f41e}},	//   _kategory_, _хамелеон, _durech_, _domovem_,
   {{0xe2d8216f,0xd1b7c263,0x19ce8026,0x025da2ea}},	//   _somere_, _силоҳи_, _beheerde, _arrestim,
   {{0xcc70426a,0xd00b724c,0xf329226c,0xa5c9003b}},	//   _website_, _دروازٕ_, _preklinj, _angakash,
   {{0xe26d0086,0x9292502a,0x934523a4,0x7f271335}},	//   _labore_, _detain_, _memetic_, _empresta,
   {{0x72b4b1ce,0xff6ca20e,0x925520b6,0xf2da70e4}},	//   _lecco_, _detalhes_, _intercam, _direks_,
   {{0xb2020285,0x9e92300f,0x8a06b2bd,0x7290e262}},	//   _misiri_, _потреби_, _arabelwa_, _runaka_,
   {{0xa814610d,0x1f2ed53c,0xc7e0a056,0x71b33096}},	//   _незалежн, _sectaria, _ditsenyw, _کامرس_,
   {{0x02d8707d,0x0200923a,0x9b17253d,0x044ac11b}},	//   _ranem_, _thain_, _montaža_, _razvijen_,
   {{0x92d90406,0xd7203065,0x92eca303,0x2f78f05a}},	//   _laboris_, _פרנסיסקו_, _artiske_, _cambrils_,
   {{0x51c6b26a,0x02c6b19a,0xc513d018,0x9c6e126c}},	//   _category_, _categori_, _витралиу_, _dobrima_,
   {{0x5ea14330,0x79c2f100,0x925aa123,0x0e1943e1}},	//   _rubrique_, _watercre, _dible_, _governma,
   {{0x3ec210b2,0x036e2251,0xab23a05d,0x12b5140b}},	// [8e0] _vientian, _приватни_, _votaziun_, _mindste_,
   {{0xc201f3b8,0xbcc2e0ac,0xb290e250,0xac4ad2ac}},	//   _butik_, _매우불만족_, _hunaia_, _باکگراون,
   {{0x6d3930f0,0xd34ba09b,0x130da065,0x035542cd}},	//   _ancienne_, _kleilüka, _היקפי_, _eigenes_,
   {{0x1e8181e6,0xe1f60212,0xeb4ee3d0,0x43a260ac}},	//   _द्रक्ष्य, _abazanel, _эмшуис_, _stopt_,
   {{0x72d8a206,0x66e1b06d,0x89f2a257,0x7f2fa328}},	//   _habet_, _ababechi, _regionda_, _tautugia,
   {{0x48564430,0xf27f70fe,0x9290e17e,0x528c0296}},	//   _əslində_, _myanya_, _lafaa_, _abakala_,
   {{0xe200d126,0x871f2263,0xe013a287,0x1297e0a4}},	//   _cheik_, _убури_, _легітымн, _josateki_,
   {{0xa3f8f2c8,0x6596e196,0xe2b2012b,0xcf3dd263}},	//   _sigur_, _garrantz, _abadaba_, _комиссию,
   {{0xbd9dc1de,0x2a0af142,0x62cb7177,0x05857443}},	//   _jednosta, _pomagala_, _akadde_, _agronomí,
   {{0xa9176064,0xb25a50ec,0x92d911bb,0xd25be53e}},	//   _地方商务之窗_, _tilla_, _haberi_, _kotle_,
   {{0x72003278,0x5e952158,0x42433221,0x2201a0de}},	//   _famili_, _formiran, _abammeli_, _espia_,
   {{0x62d87004,0x5389e059,0xb3f9007d,0x366ef0f7}},	//   _maneh_, _የሁለቱን_, _akauns_, _中国经典经济现代,
   {{0xa2d911ec,0x641ac0a2,0x2d35a25c,0xb7b4b17e}},	//   _mizer_, _abanezik, _гулидің_, _badruddi,
   {{0xb2e8553f,0x5291b187,0x4c1552d2,0x55c9b223}},	//   _poslednj, _kuvala_, _motorrad_, _kuzalish,
   {{0x3200b27a,0xc2003012,0xd0597415,0x3290e336}},	//   _akcia_, _kamili_, _zorionak_, _fafaa_,
   {{0x427ef0bc,0xfad753f4,0xc24611ca,0x669c11c7}},	//   _abinni_, _inattent, _پُھٹرنس_, _бизнесті_,
   {{0xd72a24a8,0x0c5c32bf,0x5ec1a484,0x1e51f29a}},	// [8f0] _चिदम्बरम_, _agatako_, _anoncian, _melainka,
   {{0x39512152,0x4f45c0bd,0xcc152430,0x72926028}},	//   _automaat, _betrokke_, _tutulmas, _matans_,
   {{0x7fa52083,0x2394730a,0xdad0d121,0xe753b282}},	//   _قولعو_, _kensa_, _ekstrave, _הרחמן_,
   {{0x2320c159,0x82018039,0x42d9801b,0x5c6852d0}},	//   _milyen_, _jurip_, _birek_, _gavrnan_,
   {{0x226e7075,0xe5d16222,0xa2910262,0xcc935540}},	//   _visoko_, _landsstý, _kubaka_, _सुबोध_,
   {{0xb2b401cb,0x12e77541,0x36b91003,0x79e19065}},	//   _deich_, _bernama_, _tagasisi, _בכסלו_,
   {{0xe1be201a,0x0a8670c6,0xee7d41bc,0x826d1494}},	//   _تەرمە_, _amanasan_, _تاشچاينا, _kuboku_,
   {{0x0962c3c0,0x22819244,0xab0174db,0x6200946e}},	//   _bolokile, _ampirux_, _posición_, _khaim_,
   {{0x0628f1af,0x83980065,0x12d8b31e,0x327ff18a}},	//   _pirihiti, _קעקועים_, _ameele_, _ajung_,
   {{0xbc5521f0,0x72910181,0xde47513a,0x9194f283}},	//   _алынған_, _kubaha_, _colardea, _akucelel,
   {{0xab756437,0xfd061527,0x12d914bc,0x92e9110a}},	//   _valsalva_, _apprendr, _sizes_, _kusikia_,
   {{0x42d81039,0x23f8201d,0xfc6df200,0x76db0264}},	//   _taher_, _makur_, _ayirina_, _هااااااا,
   {{0x32e0a0cb,0x216380af,0x12910510,0x1347d227}},	//   _llinell_, _円以上ご注文頂き, _bubaka_, _분리수거함_,
   {{0x925a52bd,0xb27ef2cd,0x63043542,0x8e51f244}},	//   _dillo_, _bringt_, _jasabel_, _mulanaka,
   {{0x9af6e0fe,0x8c7cb043,0x7291e110,0x1db4f3e2}},	//   _iterambe, _tekstin_, _matag_, _vulgarne_,
   {{0x9d92a183,0x5c6af048,0xb2d2a45b,0xa2e8801f}},	//   _funerale_, _sestavy_, _funerali_, _ainihin_,
   {{0x6291c062,0x8290c0c3,0x61583140,0x4e1a1030}},	// [900] _mavae_, _polako_, _агентлык, _билдирад,
   {{0x02d914ff,0xd0521290,0xd719b0f7,0x20085330}},	//   _sizer_, _फिलिपिनो_, _出口许可证管理货, _社会主义市场经济,
   {{0x2290e138,0x0c616250,0x1348e205,0x527bd11b}},	//   _ionako_, _bitunia_, _screech_, _управног_,
   {{0x552a02e2,0x63549426,0xd317737b,0xec615422}},	//   _sitiyasy, _istedet_, _prazno_, _fibroid_,
   {{0xdcf74080,0x414b9031,0x7a8010ac,0xdfdf600e}},	//   _festejar, _ወረርሽኝ_, _zwangers, _poçtla_,
   {{0xb290b13e,0x584d22ab,0xb2d8a083,0x83a89148}},	//   _dodano_, _sistemos_, _sabem_, _kahayang_,
   {{0xc9f931fd,0xe27ee246,0x12f0c171,0x53cec13f}},	//   _arasında, _atinae_, _hadithi_, _proved_,
   {{0x503a0543,0x30ce9056,0x630092b3,0x2c633272}},	//   _आत्माराम_, _ditlhohl, _separuh_, _vaquero_,
   {{0x0af17026,0x52fdf262,0xaa5720f8,0xfe8fa11c}},	//   _opdracht, _nduga_, _сатарга_, _análaith,
   {{0x42d9c180,0x0357530c,0x0d65d009,0x02b402d4}},	//   _givet_, _inserer_, _главной_, _afico_,
   {{0x6ad73345,0xb2ca41e7,0x2c6122bf,0x5a89c087}},	//   _postitat, _kellegi_, _akoroke_, _adminton_,
   {{0x4da232e1,0x1290e44c,0xc200c24a,0xf4378244}},	//   _nitorina, _honako_, _belied_, _samkanak,
   {{0xf968a2ae,0x6201f01a,0xfce7b252,0x82d9c079}},	//   _reformie, _estic_, _اشىقچا_, _kivet_,
   {{0x234260e5,0xe2d883d9,0x4040f086,0xa69292b1}},	//   _बोधिसत्व_, _bokete_, _gerunden, _lentansy,
   {{0x122b83c7,0x62920213,0xb2eab1df,0xd07cb018}},	//   _siempre_, _ispasa_, _atendis_, _membrilo,
   {{0xf2ee9211,0xa3f8423a,0x9291f256,0xe49c2008}},	//   _amanaki_, _bamut_, _kuzana_, _барысыны_,
   {{0x230e917a,0x729260c3,0x83f82202,0x93a26290}},	// [910] _ekvator_, _straha_, _sakur_, _stopy_,
   {{0x928d81af,0x0758d0a6,0x6b62315b,0xf2ef4067}},	//   _waikato_, _स्क्रिन_, _ascenson_, _chefuo_,
   {{0x62b4919d,0x825a5126,0xdf0d74da,0x0fbc71f8}},	//   _seach_, _sillo_, _mascotas_, _englesko,
   {{0x06c73026,0xb04e81af,0x9307a1ba,0x95ffe0e5}},	//   _고객님께서_, _kahungun, _направет, _शिरोमणि_,
   {{0x337fd250,0x9c047542,0x3658009a,0x146d7464}},	//   _nolaila_, _baisnei_, _турмушид, _tensión_,
   {{0x9202613c,0x4f3a541a,0xc76970fb,0x6a0301ca}},	//   _herido_, _brancher_, _शिक्षते_, _somaliye,
   {{0xfff6d056,0x3c5180a6,0xd4d69231,0xd37fe19e}},	//   _diphetho, _जीमेल_, _मारियो_, _runanga_,
   {{0x85fe40af,0x13f8401f,0x13a8e1ab,0x33b592a6}},	//   _tilmeldi, _jamus_, _talagang_, _zahvala_,
   {{0xa2918228,0x22842394,0xb42810b4,0x1ae14122}},	//   _jaran_, _goshuin_, _asekenaz, _maltratt,
   {{0x7599005a,0xd8cb4276,0x42026049,0x6503e08a}},	//   _камбарат, _اعتراضن_, _perigo_, _مارجی_,
   {{0xd25a51cb,0x8c5c14f7,0x838770c7,0xb2d810c7}},	//   _cille_, _certain_, _sharaf_, _tahey_,
   {{0xf38062ae,0xbc6c124a,0x0d3d71b9,0xd2e3c32f}},	//   _korral_, _aktueel_, _популярл, _uphinde_,
   {{0x525a5308,0xb731506c,0x825b0023,0xfe572284}},	//   _solly_, _kelleleg, _abaluk_, _mancante_,
   {{0x1236e4b0,0xa2e861b3,0x53163300,0x59aa10bf}},	//   _ubijen_, _affirma_, _digarez_, _ботир_,
   {{0x652aa09a,0xb2907268,0x225a51c3,0xf2009223}},	//   _گىتتار_, _aynan_, _gille_, _makini_,
   {{0xe25ba05c,0xb2d010c8,0x1421c192,0xd2ca0128}},	//   _toplo_, _receptai_, _мәжитов_, _bubonic_,
   {{0xa36da008,0x9e60e105,0x8579d45b,0xd2d8e101}},	// [920] _berjaý_, _ארדענונג_, _costanzo_, _lafet_,
   {{0xc96e4163,0x926c907b,0x928c008a,0x02eae111}},	//   _agrigent, _abboolii_, _abakula_, _atingis_,
   {{0xf615a019,0x683231d9,0x4b0cd05b,0x0aad703b}},	//   _מוצאי_, _سايىپ_, _پامیر_, _akukhomb,
   {{0x120e10d2,0x4044507c,0xdd7a71cd,0x926e71d2}},	//   _барат_, _kubumban, _kommande_, _rasong_,
   {{0xfe447308,0x012d3034,0xb8b5c3fb,0xf5c91544}},	//   _aswakuya, _факта_, _doktorav, _bagafash,
   {{0x2292600e,0x82d85437,0x02cb1086,0xf25a50ec}},	//   _burada_, _talet_, _webdav_, _tille_,
   {{0x8291f0ee,0x3a800244,0x78e6313c,0x9ad3f24f}},	//   _zuzana_, _atiyatwa_, _минуҭи_, _kattusse,
   {{0x8d86b01a,0x82b6629f,0xf0146288,0x52004545}},	//   _entendre_, _torche_, _اتلانتیک_, _akmin_,
   {{0xa25ac4ce,0x525a517f,0x930d828c,0xfc22e167}},	//   _endla_, _zille_, _gamintoj, _escribis,
   {{0x8242e3b1,0x1c09c1d9,0x025ba16b,0x858ec1a0}},	//   _चावला_, _минералд, _poplu_, _statudik,
   {{0xd379a1d4,0x689b806d,0x531731e2,0x0968d0bd}},	//   _soorunam, _ikakhulu, _kancane_, _aktiwite,
   {{0xebba1063,0x32b4c064,0x4c3c2282,0xd7d8135e}},	//   _газетаси, _proche_, _אפווישן_, _akaashev,
   {{0xfeb7d24c,0x5f64a148,0xa9c721d9,0x427ee1bf}},	//   _پرستن_, _maranehn, _қаражат_, _atinge_,
   {{0x82552266,0x9c1510fb,0x237652cb,0x1bee92bf}},	//   _akolelei_, _विद्यात्, _تاشقند_, _bakengur,
   {{0x82913177,0xb291a146,0x7622b1d0,0x92b4e1a7}},	//   _baxaa_, _lapan_, _demopoli, _fricke_,
   {{0xb2918364,0x72b4c231,0x2c15f20b,0x42f3730d}},	//   _maral_, _troche_, _सहस्राब्, _kumitat_,
   {{0xaf5c6078,0x12918281,0x1b8bd1a3,0x6cb370ef}},	// [930] _هههههههه_, _qaran_, _sekithar, _jumatatu_,
   {{0xf213e221,0x62d85546,0x12015547,0x5ecd00a2}},	//   _sethu_, _cales_, _affixo_, _abanelun,
   {{0xa52bb098,0xc4550104,0xe290c13c,0xe6038121}},	//   _munyakaz, _producto_, _solano_, _दनादन_,
   {{0xa291a06e,0x5f0871e2,0x4201f01b,0xa3dc718e}},	//   _kapan_, _дарназар, _ertir_, _monwa_,
   {{0x1a0082a1,0x9291a00a,0x995150c3,0x0b197088}},	//   _misalnya_, _japan_, _nepoznat, _kesatuan_,
   {{0xfc831050,0x7c55c173,0x22918365,0x82fc61df}},	//   _生活小提示_, _илинка_, _raran_, _blogo_,
   {{0x8394f51c,0x08fd72e1,0x50161105,0x67db90c8}},	//   _priser_, _babatund, _שילדערן_, _finansav,
   {{0xd2eff0c3,0x45acc192,0xd2d85202,0xdeaff41e}},	//   _nedostaj, _алама_, _kaler_, _nedostan,
   {{0x9d5c51c7,0x327ed0ec,0x42d9c548,0x222ac10d}},	//   _объектіл, _gjeni_, _анений_, _родам_,
   {{0x699d20d7,0x429182c0,0x1f58e010,0x6c4ee0ee}},	//   _салым_, _faral_, _eloquent_, _servery_,
   {{0x22016105,0x527ff12c,0x4dd97404,0x9ef92292}},	//   _pagita_, _akuni_, _زڪوات_, _گزیته_,
   {{0x46c51388,0x5bf1016b,0x131742e5,0xb2e901b3}},	//   _یویست_, _boathous, _brezno_, _fusiona_,
   {{0xb26cc549,0x9856e095,0x7386e11b,0xa8fce283}},	//   _allora_, _journeys_, _zbirka_, _akhawund,
   {{0x238c4185,0xaee7d345,0xb3eb530e,0x50a92061}},	//   _ayayade_, _parimaks_, _मालसामान_, _ڀرچونڊي_,
   {{0x0d26f1d9,0x92d8c0a8,0x82fcd18a,0x38c2d0f4}},	//   _деректер_, _radek_, _alege_, _итник_,
   {{0x85f9f248,0xb505a065,0x6a85d2c1,0x002e309f}},	//   _ብምቕያር_, _כואבת_, _brezilya_, _колоннал,
   {{0xd3a2c385,0x12918044,0x9242410e,0x1c6b030f}},	// [940] _hampir_, _parao_, _पीपली_, _कुर्ला_,
   {{0xeda8d408,0x2292037f,0xa6514212,0x82b44234}},	//   _aktivita, _kupala_, _ټولپوښتن, _nemci_,
   {{0x9d0b20fa,0x250cc12f,0x4b55128f,0x08e090f7}},	//   _patrijar, _ﯬﻟﻪﻳﻜﯘﻡ_, _producen_, _最高人民法院_,
   {{0x5200900e,0x05f63292,0x23a2c004,0xd2d8c253}},	//   _sakini_, _عدالتلی_, _mampir_, _aloese_,
   {{0x2ecf528b,0x152e013f,0xf2918531,0x5e0bf248}},	//   _besikers_, _לונדון_, _aaral_, _ግርጭትን_,
   {{0x13a24285,0x77ed6148,0x0bb4309a,0xda57d0dc}},	//   _kumpi_, _babareng, _аяғни_, _намазга_,
   {{0x52d85123,0x5faea3c8,0xd3860159,0x12d8728c}},	//   _saler_, _arnoldqo, _amire_, _manes_,
   {{0x035fd056,0xb4b32202,0x6c7cb2f3,0xccdb92c3}},	//   _bokgole_, _nembongk, _оркестар_, _полицияғ,
   {{0x220160c4,0x9bc8703f,0x8759854a,0x5ff820af}},	//   _bagira_, _श्रीहरि_, _पात्रता_, _北海道大学大学院,
   {{0x5fed2064,0x22d8314b,0x63b4b0e5,0x38008008}},	//   _百度知道投诉吧_, _objet_, _atrakcyj, _асырлык_,
   {{0x7a0b011e,0xc57f7031,0xf91c512f,0x92d85202}},	//   _altavoce, _እንሰጣለን_, _داموللام_, _waler_,
   {{0xc2d873ec,0x4c1d2262,0xb5960026,0x752270db}},	//   _hanes_, _intambar, _클릭하세요_, _белгестә,
   {{0x2f22454b,0x23a2630f,0x28e3a271,0x3290f1df}},	//   _acelerar_, _eropa_, _extralig, _johano_,
   {{0x225a51c2,0xc2e8e291,0x2217d083,0x5b0a7083}},	//   _killa_, _kaliyan_, _иранда_, _تۉركۉن_,
   {{0x82d87367,0x8dba312e,0x96cad15d,0xbd959065}},	//   _danes_, _चैम्पियन, _دکترای_, _אורטל_,
   {{0x647f11ba,0xb723a301,0x929d310f,0xa394f225}},	//   _progetto_, _faktorom_, _nyelvű_, _quiser_,
   {{0xb2918134,0xc2fea54c,0x72f05041,0x0292e1a1}},	// [950] _garab_, _lithole_, _naliphi_, _orthway_,
   {{0xd638f54d,0x02d903af,0x33a2d06a,0xc16950b5}},	//   _kuphrovi, _mobeng_, _tropis_, _ءﺍﺯﯨﻞ_,
   {{0x22009187,0xd25a5178,0x5291130d,0xd25a93b0}},	//   _bakili_, _gilla_, _azzar_, _cykler_,
   {{0x23bab2e9,0x525ad029,0xdf2fa0f7,0xafc2c159}},	//   _blevins_, _millis_, _informer_, _بانوے_,
   {{0xd077e198,0x6201f54e,0xa3ceb38c,0x02b4d322}},	//   _хроника_, _astig_, _prevod_, _beeca_,
   {{0xdd28954f,0x72d874d5,0x82918007,0x927f50ff}},	//   _पारंपरिक_, _canes_, _darab_, _brengt_,
   {{0x22941282,0x52786055,0x22993030,0x8e4d9065}},	//   _הרבנית_, _spunta_, _خاندانین, _אינטל_,
   {{0x225ac221,0xec7d60d7,0xa25a5055,0x6c76d0c3}},	//   _indlu_, _сайланды_, _dilla_, _americi_,
   {{0xfa8e10c6,0xd9a2e0f4,0x542402ea,0x798e21a5}},	//   _omansies, _ﺯﻩﺭﺑﻪ_, _suksesin_, _бақия_,
   {{0xe169219a,0x0c606005,0x12d981eb,0x3f8af180}},	//   _presenno, _kartais_, _hirer_, _プログラム_,
   {{0x126cc484,0x42d8715c,0xa3957365,0x10387048}},	//   _tolosa_, _aaner_, _chaste_, _लोकन्थली,
   {{0xca1680ea,0x629181fe,0x277e2424,0x4683c131}},	//   _osobnost, _barab_, _drawstri, _थैमान_,
   {{0x5c766543,0xa2926531,0x527e0374,0xcc600064}},	//   _परस्ती_, _mataas_, _ndine_, _secteur_,
   {{0x125a521c,0x18d2c550,0x6aba00f7,0xc2018023}},	//   _billi_, _sobreviv, _双色球霸主_, _bayisa_,
   {{0x327f433d,0xc6748287,0x938062df,0xf2d913ba}},	//   _frente_, _слухаць_, _laurai_, _kazem_,
   {{0x9283e2ee,0x97032009,0x7b6fd218,0x17d6e277}},	//   _bunkasa_, _русского_, _achomhar, _некролог_,
   {{0x63a3f246,0x0f2191e6,0x0375d12e,0x7aefa3e3}},	// [960] _atupe_, _bahutara, _oferujem, _enformen_,
   {{0xea9d12c5,0xcb3c3180,0xe3e0216f,0x0c6a3048}},	//   _medisins, _最近トラックバッ, _המוריה_, _खोज्नु_,
   {{0xb2006106,0x2e4212f2,0x3c5bc293,0x856c8031}},	//   _chois_, _adamları, _bakunze_, _የአቅርቦት_,
   {{0x629253bb,0x7a6b6140,0x9290f443,0x34a8a026}},	//   _kutana_, _innovats, _pohano_, _maximaal_,
   {{0xe82ed483,0x82009480,0x337920fa,0x7290c551}},	//   _эркин_, _thaiv_, _nosača_, _namany_,
   {{0x122494bd,0x34ac5552,0xd047c225,0xb3f990ec}},	//   _bvaky_, _kebanyak, _законот_, _nisur_,
   {{0xe98c51c7,0x8a9771d5,0x7b252013,0xe3780288}},	//   _табылады_, _količinu_, _чуркин_, _albatta_,
   {{0xf977b21c,0xec0381fc,0xb02c9401,0x1f91e120}},	//   _indirett, _acountab, _wiaderko, _candybar_,
   {{0xdc77d46e,0x6e70d345,0x020d5034,0x867920f6}},	//   _paksane_, _घमण्ड_, _richiedi_, _меркези_,
   {{0x93957369,0x0c38b384,0x83cf030a,0x7c0d31e4}},	//   _chasse_, _podpreds, _ataveu_, _haipule_,
   {{0xad848238,0x495e044d,0xb2c21187,0xb2d982c1}},	//   _diverket_, _autocest, _adaluma_, _birer_,
   {{0x521d11a6,0xd29250b4,0xaef6f251,0xda087282}},	//   _abakhoni_, _butana_, _елиминац, _געװיסע_,
   {{0x52918134,0x312d21bf,0xc28380c5,0xa2d98086}},	//   _qarab_, _парте_, _akikoma_, _phred_,
   {{0xd28b1129,0x32fc92d3,0x46c510c5,0x1b40d0b3}},	//   _doganali_, _tlago_, _arashush, _офицерла,
   {{0x02f711bd,0x4413d030,0x12f101f3,0xd37393a1}},	//   _novinek_, _واردو_, _fizikai_, _bagasse_,
   {{0x9290207b,0x03f99206,0x9578a0f4,0x7df6b0be}},	//   _remade_, _risus_, _архетикт, _studimet_,
   {{0x06b792a3,0x09091309,0x62787553,0x3bb7d09e}},	// [970] _балаларғ, _ampasdaq_, _kornet_, _predlaže,
   {{0xa75a113f,0xdb7220bb,0xcc6b0131,0x9e4901fb}},	//   _בכיוון_, _детальні, _चौथ्या_, _magayane_,
   {{0x654dc056,0xc3955033,0x92d89183,0x235771b3}},	//   _dikhomph, _freser_, _astonat_, _experir_,
   {{0x43f99005,0x3387145f,0xab47c0b8,0xd2ea0101}},	//   _visus_, _dobrou_, _такдим_, _dirizan_,
   {{0x62d9112e,0xd2fe6122,0x70e24418,0xa10dd508}},	//   _razem_, _assises_, _abanecal, _правдата_,
   {{0x544e1121,0xd316b1ad,0x55296554,0x35c8b01f}},	//   _तांत्रिक, _poached_, _maligary, _makamash,
   {{0x14c021ca,0xf2830241,0xb20110c0,0x4b25f0d2}},	//   _پۆتُس_, _romaniei_, _ancian_, _сурады_,
   {{0xbdb241d4,0x7344b29f,0x520090d8,0xf07ec1ba}},	//   _ilanngaa, _casette_, _chait_, _правилно_,
   {{0x42d20212,0xc5cf514a,0xfc224012,0x45ba8031}},	//   _دحقوقو_, _baraggoy, _shirikis, _አንድምታ_,
   {{0x4201f138,0x1f351085,0xe3f15036,0x6aeb7347}},	//   _istim_, _স্বয়ংক্, _associaz, _norteame,
   {{0xe291852a,0x5290c130,0x92008291,0xb715810f}},	//   _karaa_, _namaly_, _adhimu_, _elismeré,
   {{0x4c776038,0x020180d7,0x5f37e119,0x7a5d80b4}},	//   _populer_, _yuriy_, _aperaarp, _hamepuka_,
   {{0xa9476085,0x925aa101,0x72732012,0x4163211b}},	//   _গোপনে_, _sible_, _utendaji_, _носилац_,
   {{0xa320808e,0xdefdd152,0xc2009286,0x63a29074}},	//   _bahyai_, _политиче, _khais_, _prapa_,
   {{0xa131c3b0,0x025530c0,0xfb3201b9,0xa6689296}},	//   _meddelel, _aluenham, _кескәйҙә, _барангех,
   {{0xa291817e,0x120123af,0x1b2a30aa,0xce5571c3}},	//   _garaa_, _liyiz_, _akabirab, _caibidea,
   {{0x925af196,0x3f6cb0d2,0x2e48a544,0xd859649f}},	// [980] _sailak_, _paraules_, _bakababa, _envolvid,
   {{0x92ebd2e8,0x0e6442ea,0xd20032b7,0xe23fc176}},	//   _muintir_, _procesit_, _namiji_, _nyembah_,
   {{0x3e46c2ab,0x5b758308,0xa6b9b372,0x33f9921a}},	//   _kataloga, _matsalwa_, _jakasiri, _visur_,
   {{0xd291827d,0xfdecd427,0xf96972c6,0x2287c1a4}},	//   _jaraa_, _кукла_, _califact, _kuikele_,
   {{0x62490555,0xf290c130,0xe20e1292,0x6c768012}},	//   _phambi_, _hamaly_, _шараф_, _mbaroni_,
   {{0x72b4949e,0xc22462c2,0xf344412b,0xb4f850f6}},	//   _deach_, _otoka_, _dabeere_, _алыпдырл,
   {{0xd2d9a0f0,0xf50a9424,0x4200d218,0x53860008}},	//   _favoris_, _sigurado_, _theip_, _emiri_,
   {{0x7291e2ee,0x3a497278,0xb25a84b2,0x5a07e0c3}},	//   _fatan_, _puleanga_, _daklak_, _istaknut,
   {{0xd9624185,0x627f401d,0x8291e43d,0x325a540f}},	//   _akanizat, _etenge_, _gatan_, _hillu_,
   {{0xe3583314,0xba51b0f7,0x928cb10b,0x62d982a6}},	//   _dopravní_, _胶南市外经局_, _ahahutu_, _obred_,
   {{0xf15612d1,0xe26ce142,0xc3a24051,0x9eb9a248}},	//   _داروده_, _ponosa_, _lumps_, _ዝበሃለሉ_,
   {{0xdfbda162,0xa291e556,0x320090b2,0xa2d830ec}},	//   _جەريانىد, _hatao_, _rhais_, _koment_,
   {{0x2107a03d,0x62c3e174,0x2c683387,0x93053352}},	//   _ngokumal, _корист_, _adaruko_, _خوتان_,
   {{0x8303104d,0xc9e2f3ce,0x575460af,0xd9492031}},	//   _malairt_, _portefeu, _最新から表示_, _የማይሆን_,
   {{0x72027211,0x8291e2ee,0x4466849f,0x3291c115}},	//   _masiva_, _watan_, _novembro_, _caval_,
   {{0x020060f0,0x23c5f159,0xc54f9009,0xf946339e}},	//   _choix_, _باشندے_, _сможете_, _challwat,
   {{0xb0e841fe,0xd4053121,0x20316112,0xe3806114}},	// [990] _aadamaak_, _आनंदित_, _serentak_, _syurga_,
   {{0x23a242e9,0xd25a5177,0xd290838d,0x0291e233}},	//   _pumpu_, _billu_, _mekane_, _natao_,
   {{0xf386d12b,0xc2fe6284,0x734211e0,0xada8a148}},	//   _emere_, _fusiles_, _ingenio_, _parobaha,
   {{0x737300f0,0x7b871299,0x244621b5,0x2aa41329}},	//   _semaine_, _художниц, _باتقانى_, _obligeis,
   {{0x22786187,0x060c533e,0xc26d023b,0x4344b557}},	//   _mpunga_, _hemolysi, _cobota_, _baserte_,
   {{0x22eb5459,0x7aad7078,0xabd530fb,0x3248d171}},	//   _dijital_, _حزيران_, _समीक्ष्य_, _naomba_,
   {{0x32d9c272,0x32d853f9,0xc273207e,0x4c6102c4}},	//   _vivet_, _abler_, _hända_, _karunia_,
   {{0xf20202c8,0x1fac31f1,0x62ef8256,0x905374de}},	//   _eisini_, _animacio, _muhinda_, _hensonen,
   {{0xc0537300,0x91c33558,0xebb2e24b,0x44068187}},	//   _kensonen, _autorské_, _omthetho_, _achisodz,
   {{0xf237f3e6,0xfc28d184,0xf2fdf31e,0x8e2b611c}},	//   _haimona_, _latabatr, _beugg_, _chigirea,
   {{0xf2fc03ed,0x714601ef,0x32d8c0d2,0x7386921d}},	//   _enige_, _clarksto, _dades_, _smara_,
   {{0x483d31ed,0x72653045,0xb617b05d,0x03a8e316}},	//   _артык_, _yerusaal, _exposizi, _malamang_,
   {{0x0ed4017e,0xc2d8c08c,0xe29080e9,0x82d98453}},	//   _komishin, _nader_, _nekane_, _abred_,
   {{0xd3a82057,0xa6b4e197,0x4a071176,0xb20430a4}},	//   _privind_, _dahuluny, _سفیدی_, _basikeli_,
   {{0x5e36c43f,0x62d8c180,0x6ab0a358,0xa24904a7}},	//   _upravova, _hader_, _merkitys, _ehamai_,
   {{0x92d9c453,0xf6b36005,0xa2fcd172,0x39d71018}},	//   _niver_, _pristaty, _ilego_, _horoscop_,
   {{0x6b951019,0xdba692cc,0xc9a4f1aa,0xff64c2ab}},	// [9a0] _פאשקעווי, _एकछत्र_, _atakisia_, _dabartin,
   {{0x62fda109,0x90272389,0x325aa0be,0x50a3201a}},	//   _greiner_, _goodluck_, _bibla_, _коробка_,
   {{0x9c56a383,0xdb1811ab,0x8afe201d,0x634aa336}},	//   _kortere_, _libangan_, _ausgiess, _angefau_,
   {{0x4d9d6179,0xeb83d08c,0xe3875131,0x1c0462c1}},	//   _vinnusta, _binnekor, _klerus_, _kanseri_,
   {{0x4efb211b,0x9291c257,0xc623f0cc,0x227f7015}},	//   _страни_, _cavab_, _conocimi, _chanin_,
   {{0xdc151284,0x3ddee0af,0x80537317,0xd6ba0149}},	//   _suspiro_, _昭和つっても幅広, _gensonen, _overstay,
   {{0x0202053f,0x4693301a,0xb294c428,0x027e0559}},	//   _visini_, _superaci, _frekari_, _geing_,
   {{0x22d9c55a,0x3224917f,0xd355d44f,0xb2d9845f}},	//   _giver_, _mtaka_, _confira_, _barev_,
   {{0x15fce0f7,0x6cdb10ac,0x1a73d2ca,0x9de2d1bc}},	//   _中央人民广播电台_, _호우주의보_, _беренеси, _اساارىند,
   {{0xa3f952d9,0xb25aa0a8,0x031a614f,0x57a83120}},	//   _fufuro_, _bibli_, _adhanā_, _tretinoi,
   {{0xf27e92c1,0x19f6b0ee,0x1b7580e5,0x430f60c7}},	//   _adana_, _ustanove, _कार्पोरे, _berbera_,
   {{0x2da2c10a,0x233a5031,0xa4c85500,0xc201134d}},	//   _سارنگ_, _የሰራተኛ_, _peacemak, _tician_,
   {{0x7b5330b5,0xecb83292,0x72249012,0x7e68c419}},	//   _ﺍﻟﻤﺸﺭﻭﻉ_, _خزینه_, _ataka_, _aficiona,
   {{0x0d58412f,0x33a2d228,0xdad4d0d7,0xe27ef2d2}},	//   _بۇزغۇنچى, _krepa_, _yaratıp_, _meines_,
   {{0x72925225,0x8fc0f101,0x42489253,0xa3fb4187}},	//   _estava_, _lakomino, _atamalii_, _alirenji_,
   {{0xa157f110,0xe7861404,0x57d54225,0x7bdf523c}},	//   _sourcebo, _باشندن_, _екстремн, _benesser,
   {{0xd517c0f6,0x2f23e1c7,0x7b863155,0xc6cf1295}},	// [9b0] _сайлады_, _ұжымдық_, _шинхуа_, _kukaguli,
   {{0x427e055b,0x31acb538,0x4c1f300b,0xa4d4c0fb}},	//   _meine_, _bakanlığ, _attartor, _उत्तरोत्,
   {{0x12fcf178,0x45d6f405,0x22d9e2ed,0xc248e4c5}},	//   _logga_, _forbarth, _vitet_, _waimea_,
   {{0xb1e72004,0x7854f248,0x499d6283,0x0bf0d0a8}},	//   _مهربانی_, _ሃልሃልታ_, _abekhona_, _mistrovs,
   {{0x5d7a70f0,0xad896383,0x3e36c3e5,0x8d4ed061}},	//   _commande_, _rimelige_, _upratova, _محڪمي_,
   {{0x6b99e35b,0xb29260aa,0xb26d0030,0x02d8c43d}},	//   _forhindr, _muraba_, _tobora_, _rader_,
   {{0x905261ce,0x998180de,0xa29262f4,0xf2d9c20e}},	//   _podravin, _ئچەكتتىن_, _erraza_, _tiver_,
   {{0x375f403f,0xc3a2d437,0x899d6009,0x87aba05d}},	//   _शास्त्र_, _drepa_, _ebekhona_, _populazi,
   {{0xf2009430,0xef9371b3,0xf2b54369,0x03f250e8}},	//   _geniş_, _perdonar_, _precie_, _okazuje_,
   {{0x42d8c08c,0xb27e0053,0xd93f83c0,0xa3a99097}},	//   _vader_, _deine_, _ikamanya_, _brevene_,
   {{0xfda9c249,0x427f421f,0x425730f8,0xc3f880a2}},	//   _parochia, _ekenen_, _kartinal, _akhuph_,
   {{0xd79281ba,0x92926058,0x3af47368,0x85c0931e}},	//   _интересу, _kuraba_, _asosiese, _abaabiil_,
   {{0x43860218,0x3373c193,0xaaf71057,0xcaeeb07e}},	//   _imirt_, _schande_, _кардин_, _fastighe,
   {{0xce0cc27c,0x12f3a0f5,0x6c77d040,0x0a6d14ad}},	//   _ドを入力してくだ, _beginnt_, _chomevpu_, _boporaeb,
   {{0xa8a5e15e,0x8d2d2272,0xc39671c9,0xcaf24142}},	//   _шударга_, _cylindre_, _kassel_, _pokrovit,
   {{0x227e02d2,0x82c74291,0x32578007,0xb2d71077}},	//   _keine_, _ادارات_, _nálam_, _aisooto_,
   {{0x72d9e469,0xa7d9538f,0x52e921a0,0xc3f0d06e}},	// [9c0] _miter_, _klassenf, _dabinan_, _konsumsi_,
   {{0x8075b23f,0xc3a291d7,0xe7ad2531,0xcaed210e}},	//   _atraccio, _draps_, _kontrahi, _kontrahe,
   {{0x0291c336,0xbc736369,0xbc7f80aa,0x4654d031}},	//   _kavaa_, _guarras_, _akamanyu_, _ቆላስይስ_,
   {{0x322bb067,0x3ec841a2,0x73f8f134,0x727ed0ec}},	//   _akamere_, _художник, _bagut_, _pronat_,
   {{0xf2d9821d,0x0c6f11b3,0x820274e5,0x82d8133e}},	//   _haret_, _pharaon_, _amrisu_, _acheh_,
   {{0xed9b41e7,0xa539401a,0x83f99008,0xa486406a}},	//   _kinnisva, _دوستور_, _masut_, _स्वारी_,
   {{0x12b4d55c,0xad8540ea,0x3fbf21ca,0xc421f00b}},	//   _leech_, _एकीकरण_, _رحمتک_, _aalisakk,
   {{0x8f88f1d9,0x7248c4e0,0xd2b85180,0xdc690046}},	//   _айдархан_, _kulmin_, _参議院議員_, _dourado_,
   {{0xd437c1da,0x42d9808c,0x9689d031,0xa8895245}},	//   _bishigik, _darem_, _ሳይጨምር_, _abakwand,
   {{0x75ba913c,0xa3a352e5,0x6547d0f6,0x9632c4ab}},	//   _абхазавт, _prepis_, _баллыев_, _aringani,
   {{0xa42aa22c,0xce35d0e5,0xfc7c525d,0x651351ba}},	//   _finagalo_, _opracowa, _amesana_, _енергийн,
   {{0x874c01ba,0x3a0e7127,0x02d850c7,0x30d990f7}},	//   _растения_, _bucabuca_, _galey_, _宁波市工商局_,
   {{0x44b4d0e0,0x1237530d,0xbd97045f,0x564c0234}},	//   _उत्तमम_, _plejer_, _expedice_, _psycholó,
   {{0x3c76d06a,0x038cd037,0x55018199,0x0eca12e8}},	//   _मिश्रण_, _музее_, _seneddol_, _fionlain,
   {{0xf39580d7,0xb2d984b4,0xf2846077,0x5ef4c005}},	//   _berse_, _karem_, _abibitum, _выпуску_,
   {{0x62fdd210,0x2bb29052,0xb1dee0ee,0xfa7d12a6}},	//   _ivengay_, _saglabāt_, _schránky_, _poučno_,
   {{0xbfda8483,0x45a5a20e,0x4dbde0aa,0xf2b573b2}},	// [9d0] _манкуртл, _atribuiç, _baharure_, _crache_,
   {{0xe34c1368,0x2839223c,0x72da52a9,0x7290f2a8}},	//   _auteuil_, _последна_, _eltern_, _miharo_,
   {{0xfd5fe1d9,0xa20090b4,0x7f245327,0xd190b036}},	//   _كومپيۋ_, _akaii_, _adáso_, _удоволст,
   {{0xe837c241,0xe27f70da,0xc28d4296,0xc73020c8}},	//   _баладе_, _quante_, _abaholu_, _informav,
   {{0x22d9c2a2,0x62009030,0x725a52db,0x03d4d0d7}},	//   _davei_, _vakili_, _hilli_, _qararı_,
   {{0x7c01c510,0x720092cb,0x289b9124,0x3603d152}},	//   _vengador, _wakili_, _абзазара, _картинку_,
   {{0x69d0c057,0x22d981cc,0x59f1613e,0x9e92220e}},	//   _сенин_, _barem_, _चतुर्वेद, _форумот_,
   {{0x4691e252,0x7bd9e2c3,0xfda87137,0xa2ecc101}},	//   _ordenaci, _сарайынд, _kalikasa, _dezinye_,
   {{0x62d98121,0x9ca8c06a,0xc41cc28c,0x65bbe24b}},	//   _varem_, _संस्थांच, _meninink, _степень_,
   {{0xf79fa55d,0x5e4e106d,0x8ff1e07f,0xa62af328}},	//   _kattuffi, _ҳарду_, _цәыббра_, _titirari,
   {{0x72da74b1,0x0c69d31e,0xb52590fb,0x6ee1c121}},	//   _suresh_, _jibriil_, _veditavy, _विद्यादा,
   {{0x4200c0cf,0xc20202b5,0x294b810c,0x3d2d7180}},	//   _huling_, _misici_, _bokonate, _おすすめサイト_,
   {{0x1274316e,0x5dd2d222,0x72d8c0c7,0x2a8e9421}},	//   _пермалин, _merkinga, _sadex_, _amantiin_,
   {{0xfc40f06e,0xc3956437,0xe2c65241,0x4007a09a}},	//   _गुरुवारी_, _hugsar_, _incluse_, _دىلىمدىن_,
   {{0xf291e266,0x7f25214b,0x4a05a3a4,0xb28f516b}},	//   _kataa_, _utiliser_, _butalbit, _pappagal,
   {{0x08571040,0xe13ba13f,0x2bc9c083,0xe283e0f6}},	//   _allsorts_, _ללבוש_, _грузияда, _bankara_,
   {{0x1291e17e,0xa144b49e,0xd30613e7,0xf26d013c}},	// [9e0] _mataa_, _mealladh_, _andakuk_, _amboja_,
   {{0xde52513f,0x53a260d3,0x9d10921d,0x0291e447}},	//   _purchase_, _propi_, _niyataṃ_, _lataa_,
   {{0x02d9a21d,0x0465a438,0x04ab12cb,0xaeb8343f}},	//   _japet_, _imveliso_, _دارالخلا, _pohostin,
   {{0xe1773008,0x39757002,0x32009440,0x02f3734d}},	//   _келте_, _barghdaq_, _bakimi_, _kumapati_,
   {{0x9049014e,0xb1afa1d9,0x83ac60e4,0x9a553144}},	//   _ফারজানা_, _адамдарғ, _atupri_, _akumhlab,
   {{0x2c56b00c,0xcba003a0,0x9254906a,0xf201f01a}},	//   _lautele_, _تکریت_, _रोमांचित_, _estil_,
   {{0xfb19726f,0x02d98121,0x7f94302e,0xa27e9093}},	//   _sorangan_, _parem_, _класса_, _udang_,
   {{0xac60f308,0x7dff7349,0x6703001a,0x8bc2b14c}},	//   _midrand_, _seiersta, _беларуст, _অঙ্গরাজ্,
   {{0x949960c7,0xfaf2c0cc,0x5249755e,0x13f92023}},	//   _islamark, _presupue, _abamwa_, _cayut_,
   {{0xd762d299,0x1834c124,0x1378f053,0x43ea01df}},	//   _става_, _клаудио_, _monaten_, _uzita_,
   {{0x17b71436,0x22b491c3,0x8e452202,0x2b2c20b3}},	//   _ibaranbi, _teacs_, _pamadega, _бирмиләр_,
   {{0xd7a82064,0x09e8236b,0x1224d55f,0x18c75144}},	//   _impressi, _impressu, _iteka_, _acatjang,
   {{0x12e89039,0x3cee23dc,0x92d981d8,0x91363352}},	//   _abhiyan_, _груди_, _karek_, _بریقه_,
   {{0xa4ba0026,0xe75240bc,0xdf5b8560,0xaeb0e326}},	//   _중국국제전화카드_, _adanilag, _dilaksan, _ahlukane_,
   {{0x52fcf150,0x49de9085,0xa24902cb,0xea01919e}},	//   _logge_, _সুকুমার_, _dhambi_, _angaanga_,
   {{0xb23a02c8,0x02d9a091,0x1691d144,0xfea6538c}},	//   _kommunu_, _rapel_, _akwesabi, _italijan,
   {{0x12d9e0f5,0x0ee1c0fb,0xeaed4163,0x01d0f036}},	// [9f0] _datei_, _विद्यारा, _wolfrats, _стефанов_,
   {{0x267b7501,0xc14fc443,0x02da2116,0x249a2116}},	//   _eyakhelw, _custodio, _tänava_, _tänaval_,
   {{0xf3a2d3df,0x227f74d6,0x454db065,0x85b06050}},	//   _drept_, _ekanen_, _לבזבז_, _一些小區居民也把,
   {{0x2ee120d7,0x82d9834d,0xe1192214,0xe3521337}},	//   _massakül, _mareh_, _ءنۇسىپحا, _absurdní_,
   {{0xe0e9d0c0,0x8682030f,0x12b57369,0xb237f1aa}},	//   _navigabl, _एकनाथ_, _tracie_, _baimana_,
   {{0xd2fcf24a,0xbf9a009a,0x36106199,0x9e743063}},	//   _dogge_, _билимини, _seiliedi, _чемпионл,
   {{0x72925244,0x527ed05f,0x0b4ae14f,0xfe471048}},	//   _astaza_, _edena_, _मनीषिणः_, _označit_,
   {{0xe17d900a,0x0a03d004,0x73ce412f,0xb9f3c15e}},	//   _בישול_, _پروگرامر_, _заманиви_, _prestatu,
   {{0xfb97f01a,0x42d8a177,0xd224d4f4,0xf237f278}},	//   _татарча_, _abbeh_, _eteka_, _faimana_,
   {{0x6eda1050,0x59d1413d,0x0149319a,0xfc350029}},	//   _一些常理上會產生, _usbekist, _southwoo, _ngabubur,
   {{0x43958228,0x6a04b114,0xda96612f,0xc3410218}},	//   _kersa_, _megabait, _كۇچلۇك_, _ligeann_,
   {{0xea0903db,0x897d1191,0xf26e00f3,0x06c903b0}},	//   _forbedre, _actinopt, _vapore_, _forbedri,
   {{0x8f9ec004,0x53320049,0x7f62d436,0xb037c0b0}},	//   _محسوب_, _baixa_, _stepanie_, _semenjak_,
   {{0xa2fc622f,0x784d80ac,0x3975113f,0xef9700d7}},	//   _mnoge_, _들었습니다_, _acknowle, _ilgizär_,
   {{0x1378a0eb,0x3860c0c8,0xc27f4256,0xcfa6a1d9}},	//   _novanta_, _інакш_, _irenze_, _بايراعى_,
   {{0x22fc60ee,0x220004a5,0x527f72f3,0x23ead301}},	//   _blogy_, _ajiin_, _stanje_, _azete_,
   {{0xd63922bd,0xd5344561,0x02914401,0x52d9c3b0}},	// [a00] _балалары, _itungany, _cheana_, _lavet_,
   {{0x1350231b,0x3291827d,0xbead2142,0x52490293}},	//   _abafayo_, _biyaha_, _zaposlen, _nkambi_,
   {{0x39d76169,0x569760f5,0x2ed64213,0xb3958292}},	//   _eigentle, _eigentli, _camillun, _bersa_,
   {{0xa9c5306a,0xc5f9513c,0x86a5141f,0x7e547313}},	//   _kesempat, _завражан, _datuqtah, _luvawale_,
   {{0xb529e2e2,0xf6f3e0cb,0x62027452,0xe8d28263}},	//   _navigasy, _amcangyf, _rasipa_, _консерт_,
   {{0x6c23a13f,0xdc8201e7,0x727e6202,0xe3f923aa}},	//   _בראון_, _perekond_, _keong_, _bayur_,
   {{0xd52eb4da,0xcbfac08d,0xa57141c7,0xe3d0c25c}},	//   _respecto_, _akinasso_, _ﺴﻴﻜﻭﻥ_, _идеялард,
   {{0xe83dd15d,0x927d6140,0xb79370f7,0xd2d9c2c1}},	//   _مشابه_, _палатасы_, _国家旅游局_, _davet_,
   {{0x5a0a12bf,0xb20192a2,0x1238715f,0x09c720fc}},	//   _turakina_, _yisiz_, _taimani_, _маташа_,
   {{0x727ed095,0xfec2310e,0xb052535c,0xf3bfd013}},	//   _manned_, _planowan, _amagutoo, _амандат_,
   {{0x53869209,0x998e01a2,0xe08fa065,0x5b174418}},	//   _amara_, _нашим_, _בזבוז_, _ahlangeb,
   {{0xd3ead22c,0xcee810ef,0x2e538223,0x69d870db}},	//   _nzetc_, _سڪينه_, _kutafaka, _bosebele,
   {{0x62d9e11d,0xe2f11438,0x92127043,0x3ee720bf}},	//   _mateu_, _naziphi_, _vanha_, _саратон_,
   {{0x42d9c453,0x37a74213,0x184cf018,0xf4c29084}},	//   _kavet_, _mistsupx, _контрази, _alubọọmu_,
   {{0x47572198,0xf27e6250,0x9e08e2d5,0x733e92f4}},	//   _метри_, _adoni_, _abideala, _номинчим,
   {{0x80744052,0x6c000037,0x3c7c7050,0x7c34b287}},	//   _kalendār, _härber_, _一九八四年八月十, _негатыўн,
   {{0x2c741107,0x4057e13a,0x3c654444,0xb2fce1c2}},	// [a10] _वास्तु_, _biongtok_, _napuste_, _amigon_,
   {{0x0e725121,0xa2bf2351,0x46fb3292,0xda7f52aa}},	//   _लिस्ट_, _سمنان_, _строкой_, _desambra_,
   {{0xfbd542e4,0xe301f0f9,0x959b10f7,0x52fdb29a}},	//   _rồngbay_, _verandi_, _胡锦涛强调_, _mewarisi_,
   {{0x4355408b,0x4e36515f,0x9d18c20e,0x2791f187}},	//   _kasebut_, _kalallua, _дискутир, _akatsati,
   {{0xd9c38562,0x132da335,0x02016057,0x6417d1e9}},	//   _inmediat, _proximam, _pagini_, _diuretin_,
   {{0x6f1e12c1,0x7e3f01e9,0x07dd9105,0xf3563004}},	//   _kendisin, _arkadelp, _מילדע_, _تریلر_,
   {{0xd25b11fd,0xef21003d,0x1255339c,0x6d0d12d1}},	//   _gizli_, _kusengen, _аңлисам_, _سزادان_,
   {{0x627e0285,0x97ba4262,0x2aa2a2e4,0x2e1b649c}},	//   _olina_, _hakuriki, _techcomb, _ionganta,
   {{0x42d98495,0xae48a0e7,0x505a4149,0x6c2e542d}},	//   _ebrel_, _makahane_, _papatiso, _parques_,
   {{0x7a7380ea,0xba1e1008,0x0516116f,0x9d9a148e}},	//   _सर्वसाधा, _ничин_, _konstruo_, _arlunydd_,
   {{0x9925047e,0x727e03c2,0x546e835d,0x529251d6}},	//   _caractèr, _alina_, _versión_, _kutama_,
   {{0xde0c7009,0xabffc21f,0x384481bc,0x889c6187}},	//   _пользова, _austreib, _mallorqu, _akukhulu,
   {{0xeb916393,0x44fbd121,0x18488227,0x35aa2043}},	//   _duración_, _चुराये_, _바르셀로나_, _спасения_,
   {{0xe5a2610e,0x4601530c,0x90dde16e,0x32240135}},	//   _बताते_, _violenti, _ученика_, _frike_,
   {{0xb386d185,0xa58fa114,0xa10b10f7,0x826cf0ee}},	//   _amere_, _bertarik, _座落于胜利油田发, _xenony_,
   {{0x86187263,0xb94e5075,0xe7f96031,0x2aa3632d}},	//   _писарамр, _uskladit, _መንስኤው_, _anekādbh,
   {{0x8f696217,0x028234b1,0x281fa0ac,0xf79100ac}},	// [a20] _balalarn, _bakhraw_, _광화문연가_, _테마감상평_,
   {{0xc6c53438,0x16cfc37e,0xeeb9c47e,0xf491014f}},	//   _amashish, _sumbedzi, _ampostin, _दम्मी_,
   {{0x2f633209,0xcc900352,0x4fd54048,0x6653e2b8}},	//   _binaries_, _جائیزه_, _पारिएको_, _verkondi,
   {{0x069ac06a,0x53fa0132,0xa608f124,0xcd9c310c}},	//   _पदार्थां, _impune_, _аиустици, _berekile_,
   {{0xa2370237,0xe249715f,0x0373000d,0xd2d9e01d}},	//   _krajem_, _taamna_, _amlante_, _eatet_,
   {{0xf2f0020c,0xe2d9e191,0x927d401b,0xc5a71159}},	//   _buhindi_, _fatet_, _барадакы_, _شکنجے_,
   {{0x17e4f319,0xcd123009,0x9f5dd3fa,0x48a0b14c}},	//   _campuchi, _добрый_, _venation, _লুলুপাগল,
   {{0x5ae0d26c,0x9581101d,0x9305d012,0xa27e906e}},	//   _satelits, _geschwät, _نوران_, _teknis_,
   {{0x37ba4563,0x527e90ef,0xae2e0065,0x30e241a5}},	//   _bakuriki, _ndani_, _חוששים_, _abanacal,
   {{0xb75fa031,0xc2503043,0x42242140,0xa224f163}},	//   _ተግባርና_, _делал_, _yukka_, _trikes_,
   {{0x119723ab,0x2efd74a6,0xed2c930c,0xe39b9159}},	//   _koncerty_, _धडाका_, _entitate_, _tanulmán,
   {{0x9ceed277,0xf2d462c1,0x72249244,0x436af3c8}},	//   _гради_, _nerden_, _itaki_, _bingdaq_,
   {{0xf27ff235,0x2386f004,0x7d743031,0x0815d24e}},	//   _ajuns_, _ngirim_, _በስቶክሆልም_, _نباتی_,
   {{0x11b3c263,0x610d50a3,0x6b2cf079,0x4ead9251}},	//   _нуралиев_, _silverto, _devalyas, _позиција,
   {{0x626d00e7,0x3224946c,0x1c61633b,0xac995030}},	//   _goboza_, _stakk_, _antukna_, _бишкекда,
   {{0x12dfb083,0xc292011e,0xb25a513f,0x8f33b17e}},	//   _europeu_, _pesant_, _bills_, _ashuuraa,
   {{0xc50ab059,0x9dfa80af,0x27e95458,0xe6540248}},	// [a30] _የጉምሩክ_, _このレビュ_, _महालक्ष्, _መርመርቲ_,
   {{0xaf3463ef,0xd0af40b3,0xe8247182,0x727e90c2}},	//   _adironda, _осталары_, _aikṣvāka, _beang_,
   {{0x32fc006c,0x923624b3,0x12fd72f5,0xc2d9e4b4}},	//   _liige_, _vekja_, _emagen_, _katem_,
   {{0xd25a51cd,0xe386d0cc,0x2c77d21c,0xa20260ff}},	//   _tills_, _flores_, _entrati_, _opties_,
   {{0xc2ecd15a,0x92019207,0xf80573d0,0x2aed90c9}},	//   _autorzy_, _eksik_, _автстрал, _постачан,
   {{0x52fd7104,0x5af5c021,0x2d6fd1bc,0x92d8347d}},	//   _imagen_, _overnatt, _ئحسان_, _aileag_,
   {{0x6a895217,0xb3a902d3,0xf48f2022,0xb5e89264}},	//   _башланга, _magatong_, _ءﻭﺯﺍﺭﺍ_, _رويترز_,
   {{0xcde580af,0x452c40c9,0x03019012,0xa2909262}},	//   _指定しない_, _остаточн, _wasanii_, _bukavu_,
   {{0xc69a4041,0x937c90fe,0x329250ef,0x32eea1ba}},	//   _اقداماتو_, _yatanze_, _kutaka_, _tecnici_,
   {{0xa3dd82fe,0xabbdb248,0x0627334f,0x7968d13f}},	//   _korwa_, _ብመጽናዕቲ_, _timiquti, _activate,
   {{0x72490076,0x8dd9c02f,0x824ee1a7,0x9290c0c7}},	//   _akamai_, _دتخار_, _perfectm, _filayo_,
   {{0x67293263,0xe2e20137,0x5d4bd554,0x6394d24e}},	//   _роҳро_, _paligid_, _tuhariaq, _grosir_,
   {{0x200a8431,0x472ca0c0,0xbee073c8,0x4357711e}},	//   _回复此发言_, _montcalm_, _binitnis_, _expedir_,
   {{0x10161019,0x3cce32a0,0xd602c07f,0x32d9c0e4}},	//   _שילדערט_, _ڤینۆس_, _ахаҳә_, _cavek_,
   {{0xa9f3b257,0xc27c2076,0xdec630b3,0xe3ea800c}},	//   _rusiyada_, _alohanui_, _байтак_, _aitulagi_,
   {{0xbec4437a,0xd2f5a24a,0xe1fc712f,0x8faed14c}},	//   _banyarwa, _polityk_, _تەيۋەن_, _অযৌক্তিক_,
   {{0x6170d192,0xf032f3ab,0x9c11e2b8,0x7c44b327}},	// [a40] _ихлас_, _postaven, _gesprek_, _afagbára,
   {{0x13dd809f,0x40e4013f,0x2d15d51a,0xb645e390}},	//   _borwa_, _האנושי_, _estrutur, _elektiri,
   {{0x339580f9,0x32249278,0x7c78227c,0x5648b022}},	//   _gerst_, _utaki_, _forskel_, _ﻛﻪﺩﻩﻳﻠﻪﺭ,
   {{0xb202725f,0x42027244,0xd617b218,0x1202605f}},	//   _casita_, _masisa_, _hollscoi, _ieriko_,
   {{0x012d3152,0x4363608e,0x227e0228,0x05eda097}},	//   _сайте_, _cingsih_, _eling_, _videregå,
   {{0x327e0089,0x6db22094,0xb27e0007,0xf5d8c1d0}},	//   _fling_, _behintza, _amint_, _glickenh,
   {{0x6c18320e,0xe2246105,0x3396709f,0xdfed743d}},	//   _текстот_, _stoko_, _bassel_, _riskerar_,
   {{0x153220ea,0x425ac2e9,0x4887a282,0x5ee9340f}},	//   _नब्बे_, _dellaw_, _דעלטא_, _verkaman,
   {{0x12909192,0x847b944a,0xcd08b3fb,0xa301b07b}},	//   _lijalo_, _gustuhin_, _forordet_, _baqanii_,
   {{0x626e50d9,0xf3960169,0xb2c190db,0x9380645f}},	//   _matope_, _ausser_, _mohlala_, _ostrov_,
   {{0x53f83466,0x714e11ba,0x00385137,0x759c8207}},	//   _mtazamo_, _protezio, _magtanon, _enfeksiy,
   {{0x150e3085,0x442a2280,0x30fe52dd,0x4c11e24a}},	//   _castillo_, _bapagano_, _babhadal, _besprek_,
   {{0x430c92c2,0x020262a8,0x3c6bf337,0xfdd8a518}},	//   _pomicanj, _heriko_, _जेब्रा_, _balkonna,
   {{0x5290c229,0x4c62706e,0x025b8140,0xf2d900c7}},	//   _milano_, _ratusan_, _birle_, _habeen_,
   {{0xa2d980e0,0xf913e44c,0x220260fd,0xf2e1d264}},	//   _caret_, _энтерови, _jeriko_, _اضغطي_,
   {{0xf292e0df,0xd2d980be,0xe2027012,0x6c309283}},	//   _orthfay_, _varet_, _hasira_, _awesabis,
   {{0xbe1a71de,0xa5dcb078,0x7065b557,0x7dc731bc}},	// [a50] _materija, _ويعتبر_, _politikk_, _جازدىم_,
   {{0x48b9a23c,0x5c51f3c2,0xf2e9012e,0x828e105e}},	//   _последни_, _alituma_, _posiada_, _ekakato_,
   {{0x49848232,0xe8083212,0x6e45200c,0x427ef2d2}},	//   _ngokwase, _دتړون_, _femalaga, _seines_,
   {{0xb337c20e,0xdd1b40e8,0x29e1306a,0x2d11f04b}},	//   _никола_, _katowice_, _कट्टर_, _المیدی_,
   {{0x22926015,0xaf436011,0x0e9a000a,0xfe53408a}},	//   _kuraka_, _comisión, _numerous_, _achatsha,
   {{0x1d92824c,0x09c4503c,0xd109d388,0xfea5b2db}},	//   _puntland_, _accettat, _حکومییه_, _tertipde_,
   {{0x68fcc281,0x920c113f,0x5f20e0c9,0x36a0e564}},	//   _siyaasad, _להבטיח_, _adressen, _adressef,
   {{0x626c9453,0x603aa26e,0x1290e229,0x3300d2c4}},	//   _sikour_, _заключэн, _chiama_, _affandi_,
   {{0x12d9e20d,0xf31a614f,0x820160b8,0x52125040}},	//   _batek_, _adhamā_, _ozgina_, _dalha_,
   {{0xfddb7288,0x427f43d5,0xd224912d,0x47dad248}},	//   _سعودیه_, _trenge_, _itako_, _ምትዕራቕ_,
   {{0xf27e02db,0x63a7917d,0x3b5e21f0,0xb2da739b}},	//   _eline_, _противор, _ярына_, _bareri_,
   {{0xb859907b,0x335250f7,0x536a9018,0x2c6062b8}},	//   _nucleolu, _知识堂首页_, _exclusiv_, _destyds_,
   {{0x4b5c450e,0xdaad2375,0xa2d9821c,0x63bef114}},	//   _abimukir, _ءزارينا_, _saret_, _graviti_,
   {{0x02cb423f,0x12026285,0x14fd6013,0x427e0008}},	//   _istoric_, _yeriko_, _ааҩыуаак_, _iline_,
   {{0xc496d1d1,0xa3a3f4a7,0xf24c013f,0x12e88326}},	//   _anganedz, _utupu_, _ספרדית_, _umzimba_,
   {{0xd2d98095,0xb0fc9116,0x3201f08c,0xadb9f346}},	//   _wares_, _सुखवा_, _skuif_, _ngahonta,
   {{0x92250244,0x42fc61fe,0xb2926215,0x7395e121}},	// [a60] _anakak_, _googu_, _turaka_, _metsa_,
   {{0x3f695288,0x24fa92e6,0x5c6f9248,0x1925a396}},	//   _عبدالحی_, _ग्लानि_, _ድህሰሳን_, _aeronáut,
   {{0xf962b06a,0x224a632d,0x3c2f40f7,0x927ed0c7}},	//   _अधिवेशना, _saumya_, _marquer_, _sannad_,
   {{0x472292db,0x3c0ae30a,0xe37ac1c9,0x2290744b}},	//   _бердимух, _adopsen_, _locarno_, _synas_,
   {{0xec0b919a,0x967630a2,0xcdde90fb,0x8d210142}},	//   _etholiad_, _راکمولو_, _महत्त्वम, _zanimive_,
   {{0x9b7f2122,0x3ebc8183,0xfc7c8565,0x6df981ba}},	//   _francesc, _existent_, _existen_, _шампиона,
   {{0x82d9e49b,0x93109320,0x1e2a7248,0xd9d862bd}},	//   _katei_, _becamex_, _ዘገድሰና_, _bahlanka_,
   {{0xe25a5364,0x73154102,0x026cc566,0x808e7022}},	//   _calli_, _включенн, _coloca_, _бизнеске_,
   {{0xbca42036,0x6da120ef,0x145410ab,0xb2f1a10a}},	//   _английск, _سالگرهه_, _verdensk, _mapishi_,
   {{0x1769a105,0x00f7e17f,0x92273275,0x13aa4097}},	//   _רחמנא_, _худованд, _پارتكوم_, _kravene_,
   {{0x92da7057,0x138fe223,0x62c490fc,0x61d14210}},	//   _pareri_, _bonyeza_, _стерлита, _esterway_,
   {{0xd3f99567,0xc3870302,0xe9c4545b,0xf21c60d8}},	//   _casus_, _klares_, _accertat, _dithis_,
   {{0x136ce005,0x82d9803a,0x229252fc,0x5c25f165}},	//   _licencij, _carer_, _ostaci_, _verbrauc,
   {{0xfc2aa222,0xebdba4ac,0x122421fe,0xcdd57336}},	//   _innihald_, _formando_, _bukke_, _hauhauka,
   {{0xc2b1d23c,0x73f9a221,0x4369c437,0xe86904e9}},	//   _vendita_, _imvume_, _manglar_, _assigned,
   {{0xb416521d,0x135e5048,0xef7850c5,0x0af84262}},	//   _हीदमायुष, _पर्ला_, _atacaman, _abasenat,
   {{0x521c01c5,0x528ce0f9,0xc23ba079,0xd44a1192}},	// [a70] _alphen_, _klokkan_, _alalong_, _магнитог,
   {{0x566163e5,0xcfdd10c8,0x9d6040e5,0x9c0003c1}},	//   _učilište_, _medicino, _साम्प्रद, _färger_,
   {{0x098ec1b9,0xf25a521c,0x72b4d018,0xcb98d2a6}},	//   _табип_, _talli_, _efect_, _cinično_,
   {{0x25cb6009,0xa2910069,0x2deb3264,0xa1c933d6}},	//   _государс, _kibazo_, _مكاتب_, _почте_,
   {{0xaf63d339,0xa3416187,0x57b3f47d,0xd4dac009}},	//   _vakances_, _kutenga_, _beasanti, _войне_,
   {{0x72a7c005,0x029274b4,0xb2d98568,0xe58700c2}},	//   _такога_, _aisaia_, _varer_, _клубтары,
   {{0x7413c005,0xac55d0b3,0x2930e053,0x8bccc251}},	//   _возера_, _планнар_, _vermiete, _позициит,
   {{0xd7b63075,0xbdd23009,0x7c6e10aa,0x0df9643f}},	//   _aktualni, _доступа_, _ararima_, _službách_,
   {{0xb43f2026,0xcb683120,0xe25ab478,0x73960249}},	//   _부산광역시_, _takedown_, _heeled_, _mussar_,
   {{0xe2d98176,0x03ea9111,0xd25ba191,0xf25be21c}},	//   _karep_, _uzata_, _piple_, _titla_,
   {{0x3147c063,0xe49b20e5,0x7be68365,0x19c7c0d7}},	//   _камида_, _ogranicz, _übermorg, _камада_,
   {{0x62468395,0xe3ac0175,0xf05be11b,0x5c5653ef}},	//   _kɔmaa_, _eksper_, _отворио_, _auctore_,
   {{0x8d1e2262,0xc932a20e,0xe343c292,0x52e6420d}},	//   _jenoside_, _реализир, _тобора_, _prentsa_,
   {{0x9c99c0c8,0xc881e13b,0x9f1e1248,0x2a60c0ca}},	//   _interviu_, _naminiku, _ዝንባሌታት_, _anapāśri,
   {{0x83eb5135,0x33b4003d,0xd27ec267,0x1290e0b4}},	//   _vjeter_, _ډنمارکي_, _esonye_, _hinano_,
   {{0x45b5e2ab,0x8e70a034,0x32f03569,0xf318756a}},	//   _пунктаў_, _статията_, _bewitch_, _aplikasj,
   {{0x32f450ec,0x9c24328d,0x47c86180,0xce44c03b}},	// [a80] _pranuar_, _achaitir, _あけましておめで, _angasifa,
   {{0x4b65613c,0x8bcd7334,0xc96250ef,0x93958141}},	//   _orquesta_, _chivkeeb, _پروپيگنڊ, _hersi_,
   {{0x427f0218,0x2248d07c,0x231670ed,0x3b7f201d}},	//   _leanas_, _abomma_, _yenza_, _frighten_,
   {{0x927e656b,0xf33d2096,0x125a5200,0x5baee06c}},	//   _olona_, _خیرات_, _jallu_, _कवाँड़ी_,
   {{0x425ba03a,0x0f41c0bb,0x9673e56c,0x61743225}},	//   _anpli_, _jorsalfa, _застанат_, _несовесн,
   {{0xa27f4193,0xaf277308,0xc27e00bd,0x0144b0d8}},	//   _grenze_, _factiona, _klink_, _sealladh_,
   {{0x68bbf2b1,0x26aeb064,0xa88e220e,0x33f47335}},	//   _soutenir_, _民族自治地方的自, _холандск, _restan_,
   {{0xe2920169,0x32d8c0c7,0x5c5bf19e,0x6275e0a4}},	//   _gesait_, _galeen_, _rautaki_, _apinatai_,
   {{0x4ae411d0,0x134b2194,0x8ad1f1d0,0x52f19024}},	//   _fortlibe, _genervt_, _restitue, _पालनाभ्य,
   {{0xc31673b2,0x93f992ed,0x53869098,0xf9e51342}},	//   _senza_, _pasur_, _imari_, _سندريلا_,
   {{0x82240361,0xe27e6041,0xc2d983e3,0x931673f1}},	//   _ariko_, _elona_, _parey_, _penza_,
   {{0x317a0233,0x030c52cf,0x36c7419f,0x69d011a2}},	//   _toriteny_, _dicatat_, _bebbeksi, _серий_,
   {{0x52d8b56d,0xc37fd430,0xcd8c9015,0x8340824a}},	//   _eleele_, _onlarla_, _mitmacha, _brieven_,
   {{0x031673a5,0xadc3b098,0xd583f023,0xeeeaa008}},	//   _wenza_, _gisirika, _abdulraz, _байларын,
   {{0x72d9a201,0x2ba82005,0x3202018a,0x73f401e7}},	//   _saper_, _начальні, _masini_, _vastas_,
   {{0xe25a5199,0x22700308,0x42d9c42c,0xab5102fd}},	//   _gallu_, _masungul, _laves_, _وێنده_,
   {{0x99d6b337,0xb3ead49d,0x3290e3ea,0xf7d2a01a}},	// [a90] _हतियार_, _feltet_, _linalo_, _сентябрг,
   {{0x7305209a,0xa7ef60e5,0xf3168143,0xd354a00a}},	//   _دولان_, _पुनर्जाग, _akabeli_, _attempt_,
   {{0xbc7744c0,0x74d792ca,0xd27f7180,0x37cc213f}},	//   _amrutar_, _баланын_, _brande_, _surprisi,
   {{0x75f20321,0xb2d9213e,0x1ae2613d,0x62019327}},	//   _sermitsi, _chcemy_, _miltenbe, _bayiii_,
   {{0x828e12b8,0x054b9122,0x9f64115e,0x4cbe11e2}},	//   _miskien_, _modéré_, _konplika, _сарез_,
   {{0x82e3206a,0xfcf3643d,0x4213724e,0x320ec1bf}},	//   _प्लीज_, _bredband_, _adahal_, _папал_,
   {{0xb4e2a252,0x63f46100,0x231c006d,0xcd9ce180}},	//   _өксүктөр_, _brutsa_, _abeyozam, _雑誌に出ていない,
   {{0x73ea0285,0x3380656e,0xa6b5f2ce,0xcf72b55e}},	//   _mpita_, _pluraj_, _aparatey, _ababasin,
   {{0xf394e42a,0x9fc721b6,0x525b8108,0x914a921f}},	//   _mensen_, _ཨཱཙཱརྻ_, _sirli_, _ekatsimo,
   {{0x55642362,0x23f34223,0x125a507e,0x42d9010c}},	//   _previsok, _kukubali_, _kallt_, _dibeng_,
   {{0xb28e31f5,0x025a5200,0x4e6bd292,0x53806463}},	//   _اصولی_, _jallt_, _دیوانیمد, _akuran_,
   {{0x2f920316,0xc368a252,0x932510ac,0x7224044d}},	//   _headgear_, _базаркор, _디스플레이_, _priko_,
   {{0xdf2e10d7,0x1201906e,0xc59dd32b,0x67336516}},	//   _бирле_, _eksis_, _heffeith, _absorbov,
   {{0xa9c51118,0x9cae20c7,0xa7d5c030,0x1b632345}},	//   _vallarta_, _استانک_, _آوازی_, _श्रृंगार,
   {{0x29388304,0xc0c72056,0x002e2072,0x564e5031}},	//   _rasminya_, _letlakal, _важности_, _ስንታየሁ_,
   {{0xa3a2d06b,0xe9ec80ac,0xff66629a,0x8fa7c05a}},	//   _preps_, _blogpost, _menampun, _алкоголд,
   {{0x1239e02d,0x7f2631ed,0x93eaa103,0x4224d0c4}},	// [aa0] _formati_, _veterann, _bajtah_, _nteko_,
   {{0xb27e903e,0x29c3311c,0xff9bd124,0x0407106e}},	//   _ilana_, _طالبه_, _авиациа_, _तांदूळ_,
   {{0x96b47244,0xe212a4b1,0xa27ee46a,0x726d6411}},	//   _arkatawi, _babha_, _esinye_, _vigour_,
   {{0x7e60b2a2,0x82b57295,0xe27ed3a6,0xb386e04d}},	//   _hemphuhu_, _kwacha_, _tanned_, _àirde_,
   {{0xc2d9c18d,0x57a82011,0x8c002492,0xa862d06a}},	//   _savet_, _никарагә, _nærmer_, _भविष्यात,
   {{0x99e67086,0xac1853db,0x923152fa,0xeeba556f}},	//   _craftsme, _knapper_, _kuumbwa_, _prisjakt_,
   {{0x32d9c3b0,0x427e02db,0xa290c0d7,0x1b0b0180}},	//   _laver_, _elini_, _aydar_, _オンライン_,
   {{0x227e9130,0x7555f1fd,0x84d7a0ba,0x7c00d531}},	//   _olana_, _cumhuriy, _базасын_, _tonsils_,
   {{0xe2d9c570,0x52d98083,0x72caa007,0xd201954e}},	//   _gaver_, _obres_, _meddig_, _aksis_,
   {{0x3a9f411b,0x522421fe,0x9fcaf381,0x9c75f0e8}},	//   _aktivnos, _bukki_, _зсанитар, _तीव्रग_,
   {{0x327e9076,0xa77831f3,0xec2d4089,0x12d8d571}},	//   _alana_, _اڈوانی_, _perished_, _tineeg_,
   {{0xf7a5f27a,0x22d9c317,0xa27f7126,0x52cf010e}},	//   _objektov, _kaver_, _suanne_, _kolorze_,
   {{0x3c00d11c,0x82d98322,0xaf5db036,0x502e215e}},	//   _تختلف_, _abret_, _relazion, _fundazio,
   {{0x227e607d,0xa2d852ff,0x7984d149,0xaebe50bf}},	//   _blong_, _abley_, _alailima_, _долларли,
   {{0xbd05a11c,0x227720c6,0x69f0a387,0xb94f339f}},	//   _suntasac, _kwansini_, _akintola_, _kyllinge,
   {{0xa6d6002f,0xe3fa60a4,0x8b5ee007,0xa21400c5}},	//   _عالمان_, _buruto_, _ایرانیوں_, _ayakozem,
   {{0x109b40af,0x4752a25d,0x26f43572,0xc562c21a}},	// [ab0] _オリジナル_, _akontang, _subterrá, _булгакаў_,
   {{0xe2a7a124,0x8d3bb15e,0x2ef2c30e,0xdb223335}},	//   _тактикат, _станцын_, _किनकि_, _sanaziun_,
   {{0xac5361b3,0x726cb012,0x7725e322,0xfdcc523f}},	//   _portava_, _dodoma_, _afrikák_, _begonhés_,
   {{0x327e0076,0x1cbe1009,0x21489248,0x3c64a2ec}},	//   _koina_, _вашей_, _ብኮምሽን_, _słupsk_,
   {{0x527e924e,0xb20c33af,0xe096f2a0,0xf1489248}},	//   _clana_, _hoihlaux_, _ناپاکی_, _ብኮሚሽን_,
   {{0x027f700a,0xe9fb90de,0xaa60e0a8,0x89a4611c}},	//   _france_, _ئشتەتۉۉن, _पत्रिकाम, _twojanut,
   {{0x12f45339,0xd996e02d,0x0b8ac0c0,0x81aa53f9}},	//   _stundas_, _bachelie, _chantair, _наконечн,
   {{0xd3f9b03c,0x90ef0152,0xf29180f6,0x39d80008}},	//   _acque_, _ravintol, _myrat_, _dikeltme,
   {{0x72d46573,0xdd5ac370,0x2c681012,0x1ae52136}},	//   _verden_, _додем_, _vikundi_, _sailaren_,
   {{0x7f13c0ce,0x88f3e18a,0x018b3064,0x28d180ac}},	//   _اختلافات_, _programu, _日时政要闻_, _버전에서만_,
   {{0xa2d9c027,0x86123007,0xbc810367,0x5f8bb04c}},	//   _saver_, _ڈاوُن_, _storitev_, _مخملباف_,
   {{0x2db55080,0x62eb413d,0xc7158277,0xd345340f}},	//   _équateur_, _nariño_, _руската_, _fundist_,
   {{0x13f47406,0x8a391299,0xe64463da,0x43eac4f1}},	//   _reston_, _весели_, _aerosolw, _kaltah_,
   {{0x327f4285,0x5212c421,0x6e4cc343,0x469bd031}},	//   _esente_, _hadha_, _aliamana, _በምስጢር_,
   {{0x5c3451c8,0x92bd1011,0xa25aa2e2,0x7d867057}},	//   _standard_, _cardozo_, _tabli_, _necesare_,
   {{0x2d3273ae,0x227f703a,0x82010126,0x427f40af}},	//   _pronájem_, _aranze_, _mbaiki_, _drenge_,
   {{0x22b492e8,0x4965714f,0x03960251,0xab40b453}},	// [ac0] _ngach_, _लेखनम्_, _passou_, _prévert_,
   {{0x2b9604b2,0xb6d9c161,0x82d9e086,0x3561b0b5}},	//   _quangcao_, _stepmoth, _patet_, _ءراببمىز_,
   {{0x22d9e00a,0x43408057,0x52b490c0,0xdf416085}},	//   _later_, _prieten_, _agach_, _ফ্রন্ট_,
   {{0x1458f0ca,0x734391cc,0x59ebb37b,0x82fc60c3}},	//   _viditvā_, _zelenom_, _frendica_, _onoga_,
   {{0x73f470f5,0x17b32212,0x1262d0a4,0x926d91bd}},	//   _besten_, _کتنټوک_, _civicivi_, _sezony_,
   {{0x263fe226,0xc3f40369,0x0dc31250,0xa58af282}},	//   _kalendář_, _gastes_, _iwakalua, _סווימינג_,
   {{0xf3167221,0x31edd0b9,0x46fd3030,0x629262a8}},	//   _benze_, _базарова_, _بیرسی_, _horano_,
   {{0xe9c780f6,0xd337e10e,0x8d93f30b,0x6c018065}},	//   _аррыклар, _मोनालीसा_, _aviokomp, _הכרזת_,
   {{0x1de4d1dc,0x534013a4,0xd19471f3,0xc9092102}},	//   _स्वैच्छि, _dibella_, _قراردادی, _застереж,
   {{0x327e90d8,0x1b8f52c7,0x431673a5,0xa2d9e00f}},	//   _clann_, _striebor, _wenze_, _dater_,
   {{0x2ed480a3,0x2ad4b038,0xc82e50c9,0x62d3a02d}},	//   _bedienin, _permanen_, _кредитів_, _ammonti_,
   {{0x7bba7077,0xe200d1de,0x97a7e083,0x6975e0f7}},	//   _abawọn_, _veliku_, _اۋعۇستتا_, _国家民族事务委员,
   {{0xcc5d21b4,0x6625f124,0xe347d076,0x0f0a5227}},	//   _परदेस_, _алитерат, _gileada_, _문화체육과_,
   {{0x1c65916b,0x12915111,0xbaa741bd,0x23ead02a}},	//   _pretest_, _infano_, _potrubí_, _paltry_,
   {{0x6316746a,0x825ac1fa,0x3ecc5050,0xc2f463ae}},	//   _yenze_, _badli_, _一件事情要做的對_, _trenér_,
   {{0x99c7c0d7,0x3b9800f0,0xedb8a34a,0x498281bf}},	//   _санала_, _visiteur, _abanenka, _докторь_,
   {{0x927e9120,0xa9665009,0xe26cb181,0xa4fa0005}},	// [ad0] _alang_, _njengomt, _modoka_, _разгледз,
   {{0x7386d47b,0xe0a383be,0x50ce71fa,0x1cb27077}},	//   _imeri_, _мероприя, _andlaril, _bibajẹ_,
   {{0x469772fd,0xc613627a,0xb27e9095,0x392b0288}},	//   _نگخانه_, _severnom_, _clang_, _абдумали,
   {{0x22903039,0x9485c024,0xf2d984f1,0xa275e336}},	//   _balang_, _स्नानं_, _abrek_, _apinetai_,
   {{0xba16d0b1,0x7e1f9059,0x03ea9161,0xaceb9065}},	//   _dagaalka_, _ተጠናቀው_, _asati_, _להעיד_,
   {{0x7a1e1105,0xc6558326,0x8b617574,0xb386d459}},	//   _רובריק_, _abanyulw, _थालनी_, _mmeri_,
   {{0x1053845f,0x1daa02f8,0x4a0bb32b,0xf37cd309}},	//   _potravin, _batibasa, _hunaniae, _biyapbe_,
   {{0xd386d250,0x434a5222,0x7292e1a1,0xc37fd177}},	//   _omeri_, _tiltakið_, _orthnay_, _bilaala_,
   {{0xec9cc030,0x43cf009e,0x8c67f3d9,0xc29273a1}},	//   _булди_, _pravcu_, _apereng_, _kisaka_,
   {{0xd28c7213,0xc2d9e2d2,0xe3003124,0x96a4a330}},	//   _anakapa_, _vater_, _здырҵахь, _您当前所在位置_,
   {{0x7bd6d2c1,0x8df8c14d,0xda0f60c5,0xb634410a}},	//   _faydalar, _शर्मशार_, _arapfund, _kuungani,
   {{0x227e013f,0xa3ced320,0xf940f2cd,0x2ae6d14c}},	//   _doing_, _jaovat_, _themenst, _ভাসানী_,
   {{0xd4a5f0ea,0x726cf144,0x26331275,0x1126509a}},	//   _स्वामित्, _akhone_, _аватлашқ, _بىلگەندى,
   {{0x807c513f,0x1043c24b,0x7c62b469,0x66242218}},	//   _הרפתקאות_, _nokuzwan, _plurale_, _atmaisfé,
   {{0x72903316,0xc2da4501,0x6db393e7,0xd57e41a1}},	//   _walang_, _ofanele_, _amfiteya, _apitaliz,
   {{0x025640cc,0x62d9e086,0x5fbf251c,0x12d9e115}},	//   _ভিত্তি_, _pater_, _fungerer_, _obten_,
   {{0x725be032,0xcdc19223,0xa8de4264,0x3eaab0f1}},	// [ae0] _litla_, _rasilima, _وأثناء_, _måloppnå,
   {{0xd8597473,0x1065727c,0x19e3a13f,0x5776514e}},	//   _straumar_, _danskern, _הנדרש_, _বিবৃতি_,
   {{0x53ea92fa,0xfa7f4178,0x738a70bc,0x9a4ba065}},	//   _usati_, _varandra_, _adeyemo_, _ללילה_,
   {{0x7db05327,0x97b5f2d7,0x687e916d,0xd959c009}},	//   _subsided_, _aparetei, _decisiou, _северо_,
   {{0xd248300c,0x92ba706e,0x868322e2,0xe23b11ad}},	//   _malolosi_, _kendali_, _ensekiri, _coiling_,
   {{0xd27e92bd,0x3eaa41d9,0x330e020a,0x8e7a0156}},	//   _tlang_, _قىزىقتى_, _ababala_, _шампиони,
   {{0x727e9178,0x7348a05c,0xb88960f7,0xf302a4ab}},	//   _bland_, _nebeski_, _您当前位置_, _akubise_,
   {{0x49eda4da,0x42fc638c,0x4590f05b,0x4cb7b277}},	//   _actualid, _mnogo_, _weseketh, _граници_,
   {{0xec96315f,0x1225f00f,0x22369013,0x02ee2056}},	//   _haalluaq, _становле, _peaje_, _mongwadi_,
   {{0x62cad0e5,0x52bad287,0xc781b1bf,0xbd9b9430}},	//   _chodzi_, _старым_, _аседият_, _toplanma,
   {{0xbb7e11e7,0xe13ed413,0xd93c9336,0xc2da556c}},	//   _saaremaa_, _abadumil, _elemenit, _esteja_,
   {{0xa48590fb,0x93f9b1c0,0x82e84131,0x730522fd}},	//   _विभाषा_, _acqua_, _ardilla_, _قومار_,
   {{0x0a0b1211,0x66b6d15f,0x33e662d7,0xf19a214c}},	//   _angahala_, _turaarvi, _borutisi_, _দিগন্তে_,
   {{0x83ac006e,0xbc00b051,0x62e860d9,0x525be106}},	//   _ekspor_, _tresses_, _anginda_, _bitli_,
   {{0x726cc1b9,0x62ea72e2,0xb0dd0212,0xd8fe5343}},	//   _boloka_, _patizan_, _سمنګان_, _apapalag,
   {{0x32b5f208,0x193b01d4,0x6c186010,0xac766575}},	//   _feuch_, _kommunea_, _coppers_, _assumes_,
   {{0x627e00e5,0x48d6c0b1,0x5c620123,0x46832123}},	// [af0] _gminy_, _کارتِکس_, _anruinn_, _ansekiri,
   {{0x6e44c2a4,0xf201f38f,0x8f97b200,0xdec9b0ac}},	//   _आक्रोशित_, _thuis_, _chikayaņ, _검색되었습니다_,
   {{0xc49e7264,0x72d4615e,0xf8cdc009,0x2888d1f6}},	//   _بكلمتي_, _berdin_, _оплате_, _बॉडीगार्,
   {{0x1b5b1169,0xd2da515e,0x03f96185,0xc04b22cd}},	//   _galerien_, _esteka_, _waguan_, _anerkann,
   {{0x3200e405,0xe4914065,0xce34709e,0x447801ce}},	//   _innill_, _ואלכוהול_, _drugopla, _wilfredo_,
   {{0x34aca46c,0xcc62c12a,0xf3955422,0xe0252576}},	//   _artikkel_, _secundo_, _fleshy_, _telemark_,
   {{0xb27ed05f,0x33ea03a7,0x67cb30a3,0xcaf1706e}},	//   _adonai_, _upite_, _geesteli, _गणेशोत्स,
   {{0xbff68265,0x272863ab,0x1e32e13c,0xf3417484}},	//   _dvojnaso, _realizov, _willians_, _corella_,
   {{0x34b4a262,0xaaf843da,0x6f3d2043,0x6edfb2d4}},	//   _bagambik, _induceme, _справка_, _nudistas_,
   {{0x4f5d7366,0x13021258,0x63e7c004,0xf669f171}},	//   _डुंगा_, _allallu_, _مفاصل_, _kushindw,
   {{0x8b67b299,0xb316706d,0x4eb1425d,0x55ec613d}},	//   _collabor, _benza_, _desserte_, _eckernfö,
   {{0x52a69125,0x1c80101a,0xe4899008,0xaed02163}},	//   _bwabo_, _десем_, _анкасы_, _granados_,
   {{0x4f77c2e5,0x1b9a91b8,0x13ea9203,0xed928395}},	//   _priceman, _teenclic, _esatu_, _molemole_,
   {{0x3eeac0db,0x85998372,0x1682f49f,0xf52d5218}},	//   _provense_, _barnaskó, _verdadei, _chonarth,
   {{0x294e1577,0x2224d2ed,0xc2fd5449,0xc2da72df}},	//   _prolazit, _greke_, _ciegos_, _mosese_,
   {{0x30eaa2e4,0x4828f12f,0x44fdc03d,0x05190405}},	//   _vinamilk_, _вирусини, _مجددي_, _سوداني_,
   {{0xbf2ca035,0x82cab169,0xb9c0e261,0x4d03e11c}},	// [b00] _austrija, _gudden_, _intellet, _جدران_,
   {{0x090f1306,0x2dadd352,0xe3795436,0x43408104}},	//   _kukahulu, _مانچه_, _tawanna_, _quieren_,
   {{0x47c07455,0x2d2d30db,0x0440c03b,0x8ae3b2c6}},	//   _overtaki, _ярышы_, _akakanik, _annuciat,
   {{0xc5f8c248,0xa2d50129,0x22c822f4,0xa26e3410}},	//   _ባርባራዊ_, _apposta_, _испанийн_, _арабадан_,
   {{0x63f47242,0x07e1f0c9,0x9577f0c9,0x05a130ef}},	//   _tautas_, _тенденці, _кафедри_, _اشرافيه_,
   {{0x20b621e7,0x9f94f1b4,0x36e79009,0x21f352b1}},	//   _दुरुस्_, _छूआछूत_, _найдете_, _granmanm,
   {{0x777f7578,0xb9e03169,0xa27e902a,0x6b6f3046}},	//   _क्रान्ति, _ochiniwa_, _slane_, _natureza_,
   {{0x8f5bb386,0xca41d2fd,0x6c489063,0x7c54816b}},	//   _funashan, _مخابن_, _хроникас, _jetting_,
   {{0x99f74196,0xb37fd149,0x0e615579,0xdc69e1c0}},	//   _hilabete, _manatua_, _قوشىۋىلى, _attuali_,
   {{0x626e630e,0x447ca499,0xc2516085,0x0791f213}},	//   _metody_, _सुरभि_, _বেঙ্গল_, _khathati,
   {{0x92d50272,0xe24e04a2,0x21c732cb,0xeb8df178}},	//   _apporta_, _bildirim, _داستانن_, _grundkur,
   {{0x34cd10b5,0xe784c030,0xc555e005,0xd2efd0a4}},	//   _дүлдүл_, _зўрға_, _neteisėt, _lanieta_,
   {{0xb25be42e,0xb230008d,0x6037c3d0,0x5c00247e}},	//   _litlu_, _byamina_, _хучилтта, _crosats_,
   {{0xb1222075,0x2d00203d,0xc27f7143,0x3db68395}},	//   _prijavil, _سپيني_, _avanda_, _rwandama,
   {{0x1202721c,0xf87b0096,0x02921272,0x39b7008b}},	//   _disinn_, _اپیلیں_, _appari_, _جانسون_,
   {{0x443240c9,0x7f3e1500,0x6a5e1008,0x22f31420}},	//   _революці, _bayramla, _советини, _emniyet_,
   {{0x4f04725c,0x7967e1ca,0x668471d9,0x868e64d3}},	// [b10] _түрде_, _نہناوِہے_, _түрме_, _bilforsi,
   {{0x1ea65051,0x5b20118e,0xf23ba10c,0xfaa04443}},	//   _careless_, _arjantin_, _boalong_, _апрактик,
   {{0xa512f1bf,0x8c7d9185,0xf30af0e5,0x020144e7}},	//   _универсу, _amisano_, _nawigacj, _mediju_,
   {{0xc83dc352,0x1319620e,0x6857b0c0,0x32fd40ec}},	//   _پشتبه_, _просторо, _amassats_, _besimit_,
   {{0xb9b5a0e5,0xf2249332,0xf4d56218,0xca03a0dc}},	//   _kandydat, _auaki_, _عنوانه_, _igualada_,
   {{0xff56c32f,0xe9d1a52e,0x827e908c,0xddc8c0f7}},	//   _минтака_, _अविश्वास, _klank_, _知识产权局_,
   {{0x93f8d2c7,0x22a77307,0x53167374,0xe6b4f16c}},	//   _ponuke_, _chabad_, _tenzi_, _arestasy,
   {{0x150fc3da,0x47bee292,0xf3730085,0x327ed300}},	//   _emulsify, _مصافه_, _delante_, _alenn_,
   {{0xf3530162,0x42cae100,0xda4ff2e7,0x29aa1228}},	//   _دۇچار_, _sundon_, _adampats, _pandhawa_,
   {{0x65336155,0x2b18a18d,0x8e8d6214,0x8db4611d}},	//   _ﺋﺎﺧﺒﺎﺭﺍﺕ_, _fokalenn_, _ءﺩﺍﺳﺘﯘﺭﻯ_, _achikufa,
   {{0x719512a2,0xfe563370,0xb2926079,0xb26cc23f}},	//   _yencangh_, _бастани_, _extans_, _colona_,
   {{0x27e6957a,0x52d9e513,0x7c829368,0xd35651e7}},	//   _हेमराज_, _obter_, _laitning_, _rasedus_,
   {{0x6f5e2036,0xcd2eb325,0x7b0af0f1,0xb9eeb44b}},	//   _redazion, _aktivere_, _skepsise, _aktivera_,
   {{0x1863a13f,0x927ed16d,0x027ef1a2,0x41937296}},	//   _מרטין_, _ament_, _miinus_, _adicilel,
   {{0x32cb0395,0x46a29030,0xdda81104,0xf27e9089}},	//   _adadam_, _чеченист, _colombia, _clank_,
   {{0xf38062e2,0x5b6b62ae,0x435493e7,0xc1c3d155}},	//   _kouraj_, _renoveer, _attekat_, _гобияв_,
   {{0x1977538d,0x2a6d14ad,0x0db7504d,0xa7e2d030}},	// [b20] _ministee, _dingwaga_, _ministea, _мукаддас_,
   {{0x12ca102d,0xa290c233,0x1e43015f,0x05e1454a}},	//   _reklami_, _silamo_, _kamagiya, _रामचंद्र_,
   {{0x727e6187,0x6a58930c,0x637b3005,0x2f60f105}},	//   _loona_, _licentia_, _vasario_, _אָרעמאַן_,
   {{0xa386e218,0x545ec009,0x1201402d,0x7e9e10f6}},	//   _cairde_, _ngeenzuk, _mediku_, _саялы_,
   {{0xdc47748c,0x57bd322a,0x93a3f0d2,0x0cad6531}},	//   _akuwkwo_, _najrazli, _grups_, _guesting_,
   {{0xf2fdf191,0x80e31032,0x325be057,0xda4d811b}},	//   _lough_, _grundval, _titlu_, _понедеља,
   {{0x93f4719a,0xb27e9211,0xd3898077,0x92c93180}},	//   _destun_, _soane_, _afoyemo_, _在庫がございます_,
   {{0xc1b3a17a,0xae47913c,0xf1e1536c,0xe2490095}},	//   _মিলেট_, _переписи_, _हाजरी_, _clamps_,
   {{0x8d7630c8,0x117f0463,0x57792005,0x02f4507e}},	//   _максім_, _achacoll, _нішто_, _stannar_,
   {{0xf27e60b1,0xc2e80056,0x83ea63a7,0x8371e238}},	//   _doona_, _fediša_, _mpoto_, _redadeg_,
   {{0x14120351,0xdf69d005,0xc358a57b,0x4909d231}},	//   _محققان_, _komandos_, _borgere_, _makijaż_,
   {{0x246a8056,0xa29171e4,0xec859105,0x3583f38d}},	//   _latelago_, _akaaka_, _דוניץ_, _abdurraz,
   {{0x73ea9025,0xcc52400c,0x1fc2d12f,0x53f7b23c}},	//   _apata_, _oketopa_, _ئاتوم_, _храната_,
   {{0xc8d2d2b5,0x6e96d078,0x9da5c42f,0x530e508a}},	//   _secretiv, _نرجوا_, _activewa, _abebala_,
   {{0xcc93d012,0x22fcf3b8,0x2a902111,0xf84d121a}},	//   _پاران_, _ligge_, _grandurb, _partijos_,
   {{0x1d00f075,0x09c0f26c,0x3240f2a6,0x6eb6c2fc}},	//   _prometne_, _prometna_, _prometni_, _елеменат,
   {{0x06d5d064,0xb2a070dc,0xcdd0b168,0xd2c9511b}},	// [b30] _与本站立场无关_, _herbes_, _toekomst_, _okolnih_,
   {{0x748da005,0xc42a7484,0xdf6a70dc,0x93eae38f}},	//   _situacij, _catalano_, _catalans_, _buiten_,
   {{0x03807064,0x469881a1,0xc27ed216,0xb2979032}},	//   _heures_, _unsettli, _umens_, _tungumál,
   {{0x22240496,0x7a06e317,0x2897d10a,0xc31701a7}},	//   _isika_, _degasade, _خرابي_, _grazer_,
   {{0x79e790fa,0x2f41d4a7,0x1778015d,0x5717313f}},	//   _delovima_, _longolon, _مبلمان_, _themselv,
   {{0x42c65008,0x269dc01a,0xb2ca73bf,0x8b03f043}},	//   _adamlar_, _арасы_, _разочаро, _haastatt,
   {{0x8290a4bb,0x6506c1e2,0x720001ca,0x30d5317d}},	//   _ladang_, _адами_, _idiin_, _журнала_,
   {{0x428d62a2,0xf36cf262,0x22925293,0x53ced063}},	//   _boekfan_, _akagari_, _bitaro_, _shovot_,
   {{0x93f4719a,0x3054f2d2,0x0017c0a2,0x63ac60ee}},	//   _testun_, _personen, _راوپارول, _stupni_,
   {{0xdc5bf1f2,0x599d20d2,0xd2e6f38d,0xb324c0f3}},	//   _kortini_, _салык_, _kanneen_, _precisi_,
   {{0x3778f15d,0x1ebd6018,0x0a8872fc,0x226d01ef}},	//   _خوراکی_, _abonamen, _источном_, _boboka_,
   {{0x5c66d2ab,0xbc5482fd,0x5db3857c,0x72e2a137}},	//   _centras_, _تۆقاندن_, _omfattet_, _narinig_,
   {{0xc77b22a7,0x0164d085,0x927f43fb,0xd3f9601a}},	//   _دسیسه_, _স্থিতিশী, _brenne_, _paguen_,
   {{0x226cb18c,0x0290a06a,0xb26ce2bf,0x711f757d}},	//   _indoda_, _dadang_, _bonona_, _كثيييييي,
   {{0x4c5c5474,0x466d1352,0x927ed28a,0x927f4042}},	//   _সদস্য_, _جلیسی_, _alene_, _kwenta_,
   {{0x6c340135,0x7200330c,0x26a6e0af,0x7dee236f}},	//   _ዝተኸስተ_, _lumine_, _generalf, _тонировк,
   {{0x1316c0e7,0xe224029f,0xae64d57e,0x227e957f}},	// [b40] _medza_, _esika_, _arabiske_, _noana_,
   {{0xd27cb481,0x028e2245,0x8d6d212f,0x6e14c0c9}},	//   _чаралары_, _abakulo_, _арсланға_, _власних_,
   {{0x22d9c09e,0xb2cb4197,0x66b3206a,0x31a654b0}},	//   _savez_, _kaedah_, _आत्ता_, _popović_,
   {{0xf27e934f,0x5b0cd2d1,0xc2021008,0xf7b30252}},	//   _koana_, _هاوین_, _beriş_, _titulaci,
   {{0xfb500008,0xd4b99155,0xa77dc264,0xc2d9208c}},	//   _ленинизм_, _телегр_, _الرزق_, _vinnige_,
   {{0x2879c201,0x2b07e42f,0xb224612d,0x2427f10a}},	//   _campanas_, _adaptive, _oroka_, _bagamoyo_,
   {{0xc6d4e421,0x24463064,0xb27e62e4,0x648120a8}},	//   _percenti, _信息产业部_, _joong_, _नाराका_,
   {{0xe866b152,0xb0171012,0xf001d14c,0x9630232f}},	//   _kotisivu, _پاتشاهه_, _দুপচাঁচি, _abanegci,
   {{0xb3ac61c6,0x4cfcc4b5,0x6c14f0ce,0xa3800174}},	//   _gruppi_, _دٔدون_, _verseny_, _napred_,
   {{0xe2fc622f,0xe2246267,0x33eae580,0x7fac20f6}},	//   _mnogi_, _broka_, _montow_, _гөркезен,
   {{0xa3947428,0xf27e60c1,0x0e953175,0x7387c225}},	//   _hérna_, _noong_, _permanan, _ceará_,
   {{0x2b1a513c,0x862a0063,0x32d89525,0x52eb704d}},	//   _compuest, _natijasi, _ankest_, _aranais_,
   {{0x32918140,0x19c0f249,0x10e8108a,0xaebab393}},	//   _ayrat_, _feuerste, _موجودو_, _perfiles_,
   {{0x43dc5581,0x6dee20ac,0xe2d9e169,0x84a3b3aa}},	//   _kilwa_, _다큐멘터리_, _abtei_, _किनारपट्,
   {{0x0f2843d2,0x62cb4582,0x1ae84010,0x8887a0a4}},	//   _cautiona, _faedah_, _cautione, _alikisad,
   {{0x927ed111,0x883860ac,0xdc2bc2d5,0xe2e6d0dc}},	//   _plene_, _쇼핑몰에서_, _aoineord_, _fiança_,
   {{0xa386e240,0x99d631e7,0xb327f583,0xa3f40133}},	// [b50] _teirra_, _ettepane, _प्रसिध्द_, _postav_,
   {{0xd5dfb135,0x810274b5,0x616d200a,0x2d55a20e}},	//   _ተመሃሮን_, _زمینہِ_, _military_, _планира_,
   {{0x827e61d8,0xdc7f7187,0x7366a0db,0xfd4b4050}},	//   _goong_, _abusawo_, _bongril_, _一口就沒了_,
   {{0xdc01e27c,0xf51bd28e,0xfbe74299,0xa37873c1}},	//   _næsten_, _mengawal_, _ulterior, _dagarna_,
   {{0xc779510c,0xdb063218,0xeca9f118,0x530db365}},	//   _baakanng, _clasaice, _setyembr, _engatar_,
   {{0x02cae0b9,0xe34380e0,0xf70e30a8,0x427e7212}},	//   _mundan_, _sametam_, _सहँदैनौं_, _دایټالیا_,
   {{0x020ec1e2,0x3ce53401,0x9b55107d,0x98a4134e}},	//   _назар_, _إظهار_, _fandesen_, _федероси,
   {{0x70522128,0x8aeeb193,0x79da9584,0x3c551395}},	//   _scorchin, _ansteche, _desetlje, _nantese_,
   {{0xb73ed27d,0x294433ef,0x00e56287,0x727e011c}},	//   _caalamig, _dialdict, _скандаль, _boinn_,
   {{0x8a7f009a,0xaa10211e,0x1d1171e6,0x73eac1e7}},	//   _قاتارىدا_, _revancha_, _antareṇa_, _tooted_,
   {{0xbf2cd128,0xf3a3f072,0x061d4009,0x9db542a9}},	//   _deceivin, _grupi_, _вооружен, _abendbla,
   {{0x42cae00e,0x7c801299,0x924a613f,0x127e01d7}},	//   _bundan_, _песен_, _formed_, _glint_,
   {{0x9f07d2ac,0xf75243c2,0xb4ee1008,0x07a860c3}},	//   _باپیری_, _abandyag, _дилинден_, _spomenik_,
   {{0xe25a5161,0xa22b238c,0xcc52a316,0x92132118}},	//   _sally_, _promene_, _kaitlyn_, _lachey_,
   {{0x6c7c92b7,0xb25a5027,0xb294525d,0xd2917045}},	//   _ofishin_, _pally_, _bankisi_, _akaana_,
   {{0x0e350387,0x5d267362,0xc43841e2,0xc27ed425}},	//   _adigunja, _gotovine_, _abakunak, _boene_,
   {{0xd65d41bf,0x43df70b4,0xe2d4a2e4,0x225b018b}},	// [b60] _контамин, _ahimelek, _dohoavn_, _phaloh_,
   {{0xd67ec1e2,0x126cf3c0,0x3316c0e7,0x01e0b06a}},	//   _ӯзбекист, _mohola_, _wedzi_, _हजारी_,
   {{0x4e66e288,0x56f6c09a,0x87a97404,0x42267291}},	//   _اراهم_, _قازاقچە_, _دولتمند_, _ngukur_,
   {{0x73ea9435,0x320ec44c,0xcc3fd19a,0x02a02140}},	//   _mpate_, _хавар_, _taliadau_, _zavodı_,
   {{0x2224019e,0x3a14e2c6,0xd9ec801d,0xe75b5248}},	//   _ariki_, _mercante, _eingrabe, _ኣልበርት_,
   {{0x32ff5317,0x1ebac22a,0xd2946500,0x72869192}},	//   _skritur_, _strokovn, _spikeri_, _артыуын_,
   {{0x9201842b,0x78ce320d,0x72918287,0x802950f7}},	//   _jeziku_, _уралдаан_, _vyras_, _返回河北主站_,
   {{0x30e0e14d,0x12cae25b,0x62f3c1cc,0x2e4bc0d0}},	//   _स्वीटी_, _fundin_, _iskazati_, _tuhaffaa,
   {{0x227e9585,0x1c5d2094,0xf25be42e,0xe3fde3fa}},	//   _hoang_, _hasteko_, _litli_, _afungidz,
   {{0x63f900a7,0x672712cb,0xa4fdf18a,0x163682cb}},	//   _pobune_, _نگراني_, _католиче_, _mwandami,
   {{0xc2249586,0xd290d24e,0x846c0587,0x829e123c}},	//   _graka_, _lanang_, _slowdown_, _риран_,
   {{0x730870c3,0x9c7a00e5,0xb202624e,0xe79d8290}},	//   _trebalo_, _चित्रांग, _luring_, _प्राइमरी_,
   {{0x62249452,0x627e9319,0xb2899159,0x2200c199}},	//   _araka_, _loang_, _ترانوے_, _hiliol_,
   {{0xaa6d1056,0xbc186139,0xdd6a039c,0x497b7200}},	//   _bongnaga_, _hoppers_, _بازارلىر, _qamiript,
   {{0xecac00a1,0xd27ed28b,0xf213e2e7,0xc26cf356}},	//   _bîrringi_, _soene_, _yatha_, _hohola_,
   {{0x33ea9084,0x8585a130,0x2946403d,0x530071e7}},	//   _ipate_, _tanterak, _abumbene, _finaali_,
   {{0xa20262dc,0xd202028e,0xd740a012,0xbb651193}},	// [b70] _kuring_, _masihi_, _المبارڪ_, _demurora_,
   {{0x33fa739e,0x02918040,0x0c51f394,0x0ef1b0ff}},	//   _apsusa_, _ayraq_, _haitiya_, _verklein,
   {{0x5267d588,0x6d52539e,0xe2cae1ab,0x8d26238c}},	//   _بیرونی_, _chacharu_, _sundin_, _napomene_,
   {{0x5224d11b,0x72f361e2,0x06b5144f,0xba7322fa}},	//   _preko_, _sengathi_, _assistên, _ainamata_,
   {{0xf22491d5,0xfdd52589,0x7316d0c3,0xfc0c0065}},	//   _zraka_, _abakhuba, _prozor_, _adopted_,
   {{0xac672096,0xb2f3029a,0xe2cfc16c,0x6ee1007e}},	//   _پرناب_, _dilihat_, _rakonte_, _utnyttja,
   {{0x9290d0fc,0x5588f329,0x027f4381,0x537fd21a}},	//   _hanang_, _amamasim_, _oyente_, _valanda_,
   {{0xccd1d225,0x637fd351,0x3290d09f,0x1160b58a}},	//   _особено_, _walanda_, _banang_, _depresjo,
   {{0xa2bf3493,0x62c5b13d,0xdc6730a3,0xba1ec23c}},	//   _حمدان_, _warlord_, _hanteer_, _видин_,
   {{0xf6d38009,0xd2014401,0xd2026032,0x1a1522f1}},	//   _должны_, _breise_, _netinu_, _mutarama_,
   {{0x51434078,0xb1b36394,0xcc51d1ce,0xded5b407}},	//   _ممارسة_, _armasiña, _mantova_, _ferienin,
   {{0x62027233,0x28c8c2a0,0xfc49a1ba,0x69e3c358}},	//   _fisian_, _بڕۆین_, _ремонти_, _показал_,
   {{0xe316758b,0xe7a1c099,0xa3cee3ae,0x5364021f}},	//   _menzi_, _svedectv, _provoz_, _amagada_,
   {{0x7c01c41b,0xde19e0b0,0xba7f4015,0xb224610e}},	//   _luister_, _dilengka, _aktapura_, _kroku_,
   {{0x227ed08f,0x39d300a0,0x3294f0d8,0x66926218}},	//   _eleni_, _unreport, _parkash_, _chothabh,
   {{0x0b197300,0x8d7982db,0xa2ea04fb,0xf97320cb}},	//   _vogalenn_, _сайлавла, _tarikan_, _frenhine,
   {{0xc2cb8012,0xb21e0212,0xa5a94078,0xdcadc0b3}},	// [b80] _maslahi_, _جګپوړي_, _مبادرة_, _проектны_,
   {{0x6959d135,0x624a6171,0x828880b4,0xe36361d8}},	//   _ንዋታውን_, _ukumbi_, _ainapuni_, _manggih_,
   {{0xac66841c,0x31142275,0xa8c72032,0x62138008}},	//   _санының_, _ачсам_, _fletting, _barha_,
   {{0x2e6de58c,0x076081b0,0x226cc0ee,0x01b7d156}},	//   _अधिकारिय, _michalov, _poloha_, _видови_,
   {{0x3c075121,0xbe6ad0a1,0x12c8b2db,0x67c98180}},	//   _ebatsens, _katikâti_, _ишгарлер, _アクセスカウンタ_,
   {{0xc3cff057,0x82d470e4,0x5af7d225,0x7372c47d}},	//   _servicii_, _sardis_, _заменик_, _abhachd_,
   {{0xdcabf044,0x7ec3b3d2,0xd249015b,0xc4ea6031}},	//   _rangahau_, _perilous_, _amamas_, _ተአምራት_,
   {{0x727e0431,0xdceed1bf,0xc29264d4,0xf25ae218}},	//   _moins_, _креде_, _hirago_, _soilse_,
   {{0x9b6fe3a2,0x927e9449,0xd3ea91bf,0x922520ee}},	//   _diplomir, _llank_, _spate_, _styku_,
   {{0x4de79009,0xc27e90c0,0x08c0c2e5,0x487923ef}},	//   _данных_, _doane_, _predsedu, _mobilebu,
   {{0x73fe00fe,0xf6eea0af,0x62eca519,0xb27e9506}},	//   _amazina_, _よくある質問_, _optiske_, _toand_,
   {{0x127ed56d,0x274a4124,0x9d17930c,0x69afb2bd}},	//   _koena_, _дружинин, _monstrar, _апитерап,
   {{0xa27ef222,0x21d104e9,0x1dba0365,0xf0f9e1bf}},	//   _leingi_, _upperway_, _angangot_, _весель_,
   {{0x127e91e4,0x821370c5,0x0dfcf020,0x0379521f}},	//   _ioane_, _abikuyem, _exceptwa, _didaten_,
   {{0xdf3bd408,0xe68331ff,0x563da0df,0x5e32d0b0}},	//   _kebutuha, _रतलाम_, _englishw, _tenggela,
   {{0xe29261b2,0xa7315224,0x0b79a0fb,0x6101e58d}},	//   _mirado_, _laolegeg, _निर्विशे, _तलाशे_,
   {{0x0c6a8140,0x3eaca521,0xfee0c009,0xf27ff1a3}},	// [b90] _тарафынн, _sintrale_, _земли_, _nduni_,
   {{0x32eed3ff,0xaf4c40af,0xf531d0ac,0x4543a2ab}},	//   _signori_, _ウェブライタ_, _꿈꾸는수진_, _pasisaky,
   {{0x927ff487,0x82e5d030,0x13961105,0x82dab183}},	//   _jeung_, _عباره_, _מיאוסע_, _astonar_,
   {{0x125b8335,0xf3eae3c9,0x827ed1aa,0x8ea9b031}},	//   _carli_, _mentem_, _boena_, _ከባልንጀሮቻች,
   {{0xdff54022,0x4291607b,0xd0c7a187,0xbc57e1e8}},	//   _экспорты, _argatu_, _akolowol, _тарифы_,
   {{0x22ef434d,0x7c6a3044,0x53784405,0x47f96031}},	//   _riffle_, _manukau_, _theanga_, _ይግጠመን_,
   {{0x327e004b,0x1c5c2006,0xa34081cf,0x7e0cd0de}},	//   _uning_, _ubatizo_, _frieden_, _رجانا_,
   {{0x8dc6c07f,0x47ccd3af,0xe200d1f3,0x3868b252}},	//   _прорыв_, _roeghaij_, _ideig_, _банкнотт,
   {{0x92d8838f,0x824893a5,0xa2249327,0x6faff087}},	//   _enkele_, _umama_, _asake_, _diplomfo,
   {{0xb09f20af,0xa21311a7,0x6599825b,0xd52df3ea}},	//   _イベント会場_, _amcham_, _savninum_, _amangoth,
   {{0x8f2ca1fa,0x6bc7e17d,0xdc08622c,0x8c5052b5}},	//   _amathoka, _продажи_, _asomaliu_, _perturb_,
   {{0xb2d561e7,0xbbeec32f,0x334fe1f8,0xf506b009}},	//   _euroopa_, _забон_, _desetak_, _сложност,
   {{0x35add23c,0x668c314d,0xea7320a4,0xb276121c}},	//   _работата_, _पुरान_, _vinakata_, _passabbl,
   {{0x527e047b,0xc65e1292,0xe22672bc,0x82fb12a0}},	//   _inine_, _бирма_, _brukes_, _مومکینه_,
   {{0x329101ab,0x5d11c078,0xcae12009,0xeff7d2fc}},	//   _habang_, _تختار_, _ссылок_, _распоређ,
   {{0x3585a157,0x3a08e0df,0xce66308a,0xd291009f}},	//   _bandaray, _andardst, _دروهي_, _babang_,
   {{0xe29102a1,0x227ed16c,0xc2da60b1,0x4ee851d9}},	// [ba0] _cabang_, _plenn_, _mareen_, _дизельді,
   {{0xc38700e4,0x9644a28d,0x3404a071,0xdf349213}},	//   _dharam_, _mariachi, _sprutsen_, _kumunana,
   {{0x5c4b1351,0x22bb8207,0x89dae0f2,0xa5b60320}},	//   _sunting_, _nedenle_, _मालवाहक_, _keangnam_,
   {{0xf27e039b,0xb2ab1168,0xd0e8025c,0xa4d9e102}},	//   _pliny_, _vandaag_, _مونولوگ_, _провадже,
   {{0x18cb60f7,0x92f652f4,0xd37c8267,0xd27e0064}},	//   _北京新发地_, _экспортл, _buwanye_, _soins_,
   {{0xb7f9c0db,0xd94ec3a7,0xf51641a5,0x5ffa023c}},	//   _селигер_, _abalalit, _abaliday, _часовник,
   {{0x87fd90f6,0xe38ff3a5,0xf2fcd569,0x68880190}},	//   _командаб, _konyaka_, _ziege_, _alekisad,
   {{0xce0d2030,0xbc67958e,0xe02d41c7,0x400b313c}},	//   _ایسته_, _nukunba_, _ﺍﻟﻨﺼﺭ_, _апост_,
   {{0x32da6281,0x2486d311,0x3a5d9502,0xd30480b0}},	//   _dareen_, _яманы_, _кайларда_, _menolong_,
   {{0xb224912e,0x027e6336,0x02003365,0x9386d0bf}},	//   _braku_, _mooni_, _pumice_, _iborat_,
   {{0x7317103c,0x5d192238,0x8e503224,0xd184446a}},	//   _pezzi_, _kinniget_, _ngwalela, _ephambil,
   {{0xa283e245,0xb224b0a8,0x39ed90a4,0xe11f4048}},	//   _kutheni_, _řekla_, _didivara_, _hospodař,
   {{0xb9fdb28d,0xe22493c1,0x574b325c,0xefd7f401}},	//   _gimnasia_, _frakt_, _ارشالى_, _chainteo,
   {{0x1ce5a3cb,0x71ce90f4,0xe159858f,0x085122fc}},	//   _गरीएको_, _товлиялм, _aizkavēt, _обратио_,
   {{0x3387f12b,0xcc1b8018,0x875c10f7,0xe86d3287}},	//   _amuru_, _urmatoar, _政府信息公开_, _кампанію_,
   {{0xcf2721a8,0xc577224b,0x96b892bf,0x427e6187}},	//   _парадку_, _isetjenz, _abafunzw, _yoona_,
   {{0x727ff0f0,0x4291e200,0xe27e600d,0xdb1c5169}},	// [bb0] _jeune_, _aytat_, _coona_, _dobannen_,
   {{0x9b08329a,0x23eb70ff,0xe3083221,0x99c0c330}},	//   _mengakib, _praten_, _isabelo_, _穿越之皇后要出宫_,
   {{0xc213e3a5,0xaf3ca1bf,0xbc5a70c6,0x59e5f290}},	//   _bathe_, _колорату, _fanteni_, _gwarantu,
   {{0x8838f1ba,0x3417804c,0xf2910110,0x34a221b3}},	//   _проектир, _nasrudin_, _tabang_, _burnwell_,
   {{0x9aebe005,0x39ed8258,0xd7fb315e,0x49f0a387}},	//   _столькі_, _kinguart, _berbalag, _akinbola_,
   {{0xcc66a46c,0xb38771c1,0x4cf2301a,0x024892b0}},	//   _partiet_, _waarde_, _بايما_, _omamo_,
   {{0xe27e6343,0x02d82006,0x62a6d080,0xe93ed144}},	//   _soona_, _limene_, _wiejski_, _anemibut,
   {{0xbd02f590,0x94e36085,0xa2489367,0xb27e63ea}},	//   _fortalec, _অবকাশ_, _imamo_, _poona_,
   {{0x788920ca,0x8eb73105,0xa22493fb,0x4f1130f1}},	//   _निरीक्ष्, _ליקווידי, _brakt_, _maldiven,
   {{0xf2e7c009,0x0227c009,0x06a2a032,0x534c2271}},	//   _данные_, _данный_, _tilfinni, _dostupná_,
   {{0xb2c501ad,0xdf2ff2a8,0x2d8bf00f,0xeb92234a}},	//   _acolyte_, _heretaun, _договорі, _akunjalo_,
   {{0xf9d8a2c1,0x92a07567,0x6a30813f,0xf2e312d7}},	//   _inceleme, _verbes_, _specifie, _bilione_,
   {{0x734fc248,0xd387431e,0xbd2cf3a4,0x3e4eb16b}},	//   _ተረድኦን_, _alersi_, _civitate_, _analitiċ,
   {{0xa2ff7151,0xdd6b9238,0xefe33292,0xf30de131}},	//   _sibhlub_, _tremenet_, _باقتی_, _ajibata_,
   {{0x63877401,0xa37ab438,0x0353c342,0x9f3b82b5}},	//   _bearta_, _unyango_, _سهرات_, _dyslexic_,
   {{0x738772e8,0x35ea220e,0x59d5009e,0xd2903500}},	//   _cearta_, _презенти, _devetnae, _camaat_,
   {{0x0b04f1b1,0xb7d07521,0x2f6b70c8,0x5c7140ca}},	// [bc0] _viestist, _wedstrii, _patalpos_, _मार्गो_,
   {{0x025b124c,0xb24200ef,0xb2ea7123,0xbebb84e3}},	//   _shalay_, _nyumbani_, _batiman_, _ngasinye_,
   {{0x93eae443,0x04544591,0xd4b1533c,0xa213e187}},	//   _gritan_, _اختلاس_, _بیمارلر_, _pathe_,
   {{0x1f6fb11e,0xe2249161,0x4005a105,0x22cb007d}},	//   _mudanzas_, _isaka_, _קומסט_, _keadem_,
   {{0x42027310,0x29f892a5,0xb69ba14c,0x86d8a462}},	//   _beribu_, _afosùndá, _চাকূরি_, _स्वभाविक_,
   {{0x039473e5,0x5e54e1ba,0x43eae2db,0x73cf41cf}},	//   _séria_, _икономич, _britan_, _stevek_,
   {{0x4896d009,0x6929d198,0x5334721d,0x461ac0f7}},	//   _существу, _северна_, _सिडनीनगर, _提出您的问题_,
   {{0x295152ec,0x975a357d,0x63eae2ea,0x8d867500}},	//   _mcarthur_, _وسلّم_, _dritan_, _serverlə,
   {{0xbd76c1f5,0x51b3009a,0x24460030,0x7dc59146}},	//   _جرمنی_, _мусулман_, _تالقان_, _diiktira,
   {{0xb34193c0,0x62ff6093,0x6ec030f7,0xf224610e}},	//   _dineelo_, _pesisir_, _英超新赛季球队前, _kroki_,
   {{0x92da003c,0x427e9044,0xe290300b,0x3e9f612f}},	//   _appena_, _hoani_, _tamaat_, _كأرضىحع_,
   {{0xb307b592,0x03eb4453,0x3f454586,0x9527c1a9}},	//   _tamaiti_, _breton_, _résister_, _далйән_,
   {{0x622494a5,0x936cd20e,0x96737086,0xf90d70c8}},	//   _asaka_, _собрание, _hendreri, _народныя_,
   {{0xa879c20e,0xfc1f21a7,0x31a39248,0x32cd008a}},	//   _campinas_, _navalmor, _ስጉምቲታት_, _egulayo_,
   {{0x226cb322,0xcc67d218,0x527f7593,0x1fa0555b}},	//   _andola_, _سرعان_, _azanye_, _offenbar_,
   {{0xd27e6281,0xad3fb031,0x530022ae,0xb200948e}},	//   _doono_, _ካፒታሊዝም_, _sajandi_, _adain_,
   {{0x531780a8,0x1110312f,0xb2f18193,0xb344b2c6}},	// [bd0] _verze_, _ﭘﺎﺭﭼﻪ_, _begierv_, _acresce_,
   {{0x0581f0cc,0xd224011d,0xb903a0b5,0xd2137023}},	//   _শর্তাবলী_, _tsika_, _ынталанд, _alahum_,
   {{0x902740d0,0x125a50d9,0xf37c6322,0xd601609c}},	//   _karenerk_, _fally_, _cabakke_, _atileeti,
   {{0x027e0266,0x49c7c1c7,0x0977a009,0xf9c7c005}},	//   _poini_, _салада_, _ошибку_, _багата_,
   {{0x3234a193,0x7723b14f,0x9342623c,0x720093ce}},	//   _plumage_, _सामान्यव, _modello_, _gekies_,
   {{0x82a6c228,0x134c2271,0x0fd4519f,0x1928a510}},	//   _tumbas_, _dostupný_, _amanitoo, _abambowa_,
   {{0x32eed1c3,0x10d413fb,0x33f97253,0x3da6b326}},	//   _diofar_, _forlagsl, _apaula_, _bebonaka,
   {{0x4e83b01a,0x54d6641e,0xe37810fc,0x2178136f}},	//   _келишимг, _नंदिता_, _baballa_, _baballel,
   {{0xd2fa2283,0x299370af,0x4602e0d0,0x6e9c9228}},	//   _kuchuma_, _ソフトウェア_, _naulaiti, _amemelin,
   {{0xb35e23ef,0x41700105,0xb2ea7028,0x8fd74048}},	//   _videosz_, _סעליולער_, _datikan_, _instalač,
   {{0x78809449,0x1fad0175,0xf291408f,0x724a64c5}},	//   _kapitulu, _izolasyo, _pedair_, _haumia_,
   {{0x8c5d12ad,0xb047c447,0x8d331060,0x49c7c005}},	//   _tautoko_, _самого_, _townhome_, _самага_,
   {{0xd2e02594,0xdaf4c443,0xb95dc03d,0x927f7256}},	//   _huanuco_, _aserrade, _abalukhe, _uzanye_,
   {{0x929250d9,0x41363264,0xe1dcc034,0x13870202}},	//   _mitano_, _فريقه_, _слаби_, _ibarat_,
   {{0x93ea9211,0x6a12326e,0x1b6a0289,0x4655d2cd}},	//   _epato_, _istoriją_, _kameroun_, _tschechi,
   {{0x0f5c7456,0x4faaf024,0xdf1e20d4,0x3485b39c}},	//   _प्रगत_, _adhokṣaj, _mendefin, _гугулашт,
   {{0x066600e9,0xe1654120,0xef242328,0x7835115a}},	// [be0] _страничк, _motorway_, _kituliqa, _अन्जान_,
   {{0x2213e1cb,0x06e8b23c,0x99878019,0xc2aa0084}},	//   _latha_, _гарантир, _elektita_, _apadabọ_,
   {{0x38631174,0x9993a065,0xb3874250,0xb2fb6224}},	//   _пошаљи_, _הטאלק_, _aderia_, _methala_,
   {{0x92d484b0,0xa1f8c264,0x72903057,0x52b4e595}},	//   _osnovan_, _لتصفح_, _pamant_, _lincah_,
   {{0xc3d922ea,0x5da61439,0xce53a0b0,0xa29264b5}},	//   _dollarë_, _penolaka, _disamaka, _dirayo_,
   {{0xb7a91291,0x038763f7,0x22cfa101,0x83b0b124}},	//   _دوستانم_, _magrit_, _negosye_, _иззеиқәм,
   {{0x42c2408d,0x07b33049,0x3e6680fb,0xd373a128}},	//   _endlela_, _próximos_, _chandomā, _aerated_,
   {{0x5b86c09a,0x7200311b,0xf29143b4,0x626d247e}},	//   _پروگرامم, _armije_, _bafang_, _bilitari_,
   {{0xb1ba2080,0xd74f817d,0x394b448e,0x6acfd44b}},	//   _raimondi_, _elintarv, _mamolaet, _skatteve,
   {{0x82c24221,0x8200d44c,0x9d0e5408,0xf114a2c4}},	//   _indlela_, _ideia_, _diluncur, _स्मृती_,
   {{0x354831ff,0xc213e37c,0xa0d05122,0x260641b1}},	//   _ट्वेंटी_, _fatha_, _pellicul, _alumiini,
   {{0x3c7c416e,0x62249239,0x9b1691d9,0x61a20212}},	//   _потенциј, _iraki_, _بولساڭىز_, _دمسيحيت_,
   {{0x127e61ab,0xcf33e2a1,0xce722508,0x927e61c4}},	//   _anong_, _persatua, _гостин_, _loons_,
   {{0x5e9ec1d9,0x426db122,0x92bba08c,0x69c7d0bf}},	//   _жайлы_, _divota_, _gereeld_, _садақа_,
   {{0x127e938f,0x899d31ed,0xa3fa51df,0x7386d520}},	//   _klant_, _табыш_, _entute_, _scoret_,
   {{0x564a3248,0x539451ed,0xc3eb7093,0x70bc024f}},	//   _ምምሃርን_, _qalsa_, _muatan_, _kommunil,
   {{0x0b7654da,0xa27e9596,0xdea030c7,0x920272c0}},	// [bf0] _publicac, _yoann_, _کھتوو_, _afrigu_,
   {{0xe387021b,0x6c05d2c4,0x38639105,0x23955225}},	//   _þarna_, _matsuri_, _ברעיק_, _apesar_,
   {{0xe2fcf3c1,0x428690ea,0xfa91e494,0xbc01c44b}},	//   _ligga_, _मध्यपूर्, _şriftin_, _brister_,
   {{0x373243ab,0x02f24111,0xa402403a,0xec13e024}},	//   _informov, _informoj, _eparnyen_, _गार्हपत्,
   {{0xbfd82007,0x5a8cb228,0xdd6fc2cb,0x3a08a397}},	//   _تقويم_, _disimpen_, _محبان_, _achawona_,
   {{0xa394f150,0x92902211,0x92137023,0x13eb7088}},	//   _spiser_, _tamate_, _amaham_, _buatan_,
   {{0x827e90bb,0xb29250c6,0xb3f8d143,0xc28962cf}},	//   _blant_, _aguare_, _annule_, _ditandai_,
   {{0x122492f8,0x8f2d21bc,0xf30c9382,0x0c6e54c8}},	//   _draki_, _امانگەلد, _ostavit_, _aperama_,
   {{0x5224d407,0x9dfe63a4,0x088421ba,0xbdc5a0fd}},	//   _krekt_, _ownergua, _известни_, _kominike_,
   {{0xb27e91c5,0x3bded583,0x3a15b2f8,0x6295b1dd}},	//   _flans_, _अप्रतिम_, _bulataka_, _bulataki_,
   {{0xd7e471ff,0x12f00171,0x83b0d064,0xce55e068}},	//   _उतारना_, _ushindi_, _manque_, _perbanda,
   {{0xa8676266,0x7292537e,0x4399148b,0x73eb7004}},	//   _konisitu, _mitalo_, _asurooow_, _kraton_,
   {{0xac055193,0x4f1163ef,0xc9f39223,0xf3e73121}},	//   _glorify_, _vantagep, _jitihada_, _lätis_,
   {{0xac28e347,0x1fd82011,0x569ab0c7,0x83588192}},	//   _establec, _иҭархаз_, _habeenki, _турнирын,
   {{0x363e1443,0x33dde0b5,0x726d6365,0x2152322b}},	//   _mesiánic, _ءتەمۇجين, _gogoro_, _kecemerl,
   {{0x8f591008,0xe27e615d,0x727e0063,0x88cf304c}},	//   _бошлыкда_, _onone_, _ining_, _تلفکس_,

   {{0xf6e8e292,0x22267389,0x730053eb,0x83fa71d8}},	// [c00] _камайтир, _saukar_, _talandi_, _lisung_,
   {{0x6638f1d9,0x8ff151fa,0x9d33f1ed,0x126e639b}},	//   _қаражаты, _ayikongo, _бюросы_, _boroba_,
   {{0x82a64295,0x21cc9299,0x443fa21c,0x127e8421}},	//   _jumbe_, _attività_, _deskrizz, _amananii_,
   {{0xc23fb1e9,0x818fc213,0xb234424e,0x426d6023}},	//   _tommasi_, _armaskay_, _agamane_, _dogoro_,
   {{0xea9ac175,0xfa83d2a9,0xfe3b10d0,0x92fa204a}},	//   _francois, _schicken_, _katraqaq, _pachena_,
   {{0x5bdfe597,0xf6c481ed,0x03eae169,0xc2d9505e}},	//   _अग्रवाल_, _отставка, _dentom_, _angeee_,
   {{0x92da6039,0x27ba50f6,0x80c5c387,0x5ac900ac}},	//   _aireng_, _biologik_, _akilimal, _사이트에서_,
   {{0xa2fc00d8,0x027ef07d,0xd2a073c9,0x137fa250}},	//   _taigh_, _painim_, _verbis_, _zekaria_,
   {{0x496230db,0x42cbc387,0xd9505169,0x727ef179}},	//   _составы_, _akadá_, _mullebut, _beinni_,
   {{0x92a6408d,0x02fcd598,0x627ff19c,0xb2014053}},	//   _kumbe_, _liegt_, _iluna_, _preise_,
   {{0x82c95031,0x33980282,0xffa91272,0xee4730de}},	//   _በትህትና_, _געעצהט_, _confuser_, _تۉستۅ_,
   {{0x4234b18c,0x689b11a2,0x52e612aa,0x410241a8}},	//   _afumane_, _экране_, _mianaka_, _штрафной_,
   {{0xf12d206d,0x9f2bd228,0x9dd0f0a5,0xc6ac2287}},	//   _дасти_, _kabudaya, _archduke_, _pritaiky,
   {{0x9c095223,0x9be8d059,0x69d10545,0xcbf1f187}},	//   _قبرستان_, _ይገርማል_, _asseedee, _akatsots,
   {{0x23f9129a,0xa98df248,0x1a15352d,0xc4c3a4df}},	//   _dibuat_, _መለክዒታት_, _stranama_, _verbruik,
   {{0xc27ff0b4,0x0b34b177,0x6035b2a9,0x2d6602b2}},	//   _oluna_, _afgaanis, _seitenan, _इतिहासमा_,
   {{0x88095026,0x92fb536f,0x4dab032d,0xa9796033}},	// [c10] _삼성패밀리세이브_, _bothata_, _parihara, _anlibert,
   {{0xc2a6c3bb,0xc212e12b,0x852f3012,0x327e9169}},	//   _tumbes_, _ahihia_, _mwandish, _glanz_,
   {{0x7356d0ef,0x4146d238,0x67b504df,0x0386a381}},	//   _مرحلو_, _hanterno, _rassisti, _agirũ_,
   {{0x927ed278,0xa38772d5,0x4f62c1d8,0xa2903004}},	//   _koeni_, _dearga_, _sabalikn, _lumaku_,
   {{0x4573e059,0xe9ebb121,0x12b1d196,0xf25b71df}},	//   _በቫንኩቨር_, _परिवारो_, _bilduma_, _italio_,
   {{0x63ea0365,0x6bc130ac,0x31d3e00a,0x5c57f0af}},	//   _spitz_, _세금계산서_, _recently_, _強い味方が必要_,
   {{0x6290232d,0x88c72020,0xd2db4083,0x2a15c043}},	//   _samare_, _omething, _aprovar_, _угодно_,
   {{0x9394e223,0xee9fe599,0xd2cad006,0x527a124f}},	//   _mwisho_, _iqalungn, _abodza_, _aasianni_,
   {{0xb2fc028c,0x4c01b123,0xf8dcc132,0x93eb20a3}},	//   _taigi_, _awtsors_, _гулий_, _spyte_,
   {{0x8234b03d,0x925a101d,0xd26c80c6,0x8476a0e5}},	//   _ufumane_, _schlu_, _kokobo_, _चन्द्रपु,
   {{0xe9b7041d,0x6a09501a,0x0386d067,0xf843842d}},	//   _فرانسیسی_, _badalona_, _chorom_, _sentidos_,
   {{0x3248f18a,0xb27f52b1,0xb2ce524b,0x6fb04065}},	//   _primul_, _byenet_, _западной_, _mattress_,
   {{0x93178048,0x63f8e187,0x72eb72e4,0x72925533}},	//   _verzi_, _fanuel_, _vitinfo_, _gitabo_,
   {{0xc98e11e1,0x2e4f4405,0x73d6a36f,0x538771ca}},	//   _yomhlaba_, _zippered_, _bauthuti_, _afarta_,
   {{0xa2d8115e,0x73178166,0xe6a8f11e,0x23566060}},	//   _lehen_, _terzi_, _ultrasch, _josephs_,
   {{0x827ef0f9,0xe339449a,0xd29263d9,0xb287c271}},	//   _seinni_, _जनकपुरी_, _diralo_, _hodinky_,
   {{0x23dd159a,0x30656031,0x22d8e1ef,0xac51e0d2}},	// [c20] _zizwi_, _መስህቦች_, _iiieee_, _mantega_,
   {{0xc66f60e8,0x5225f087,0xd34c23ab,0x925ba2e2}},	//   _pozdrawi, _bruke_, _dostupné_, _lapli_,
   {{0xa394527d,0x9147105d,0x7dbf923c,0xd237c1a5}},	//   _balse_, _suprasto, _областта_, _филмҳои_,
   {{0xe7fa412b,0x681cc06a,0x5c2a71b1,0xac9271aa}},	//   _anabigag, _पदार्थाच, _продавцо, _ditulong_,
   {{0x130c5316,0x7354058f,0xab25f20a,0xf3037081}},	//   _subalit_, _cements_, _ababereb, _tamanit_,
   {{0x437ab041,0x0e1c3249,0x6b99e2bc,0xc2a1142e}},	//   _onyango_, _scienzia, _aarhundr, _teljast_,
   {{0x9c51d33e,0xf27e9316,0x1ec371e0,0xd62f3329}},	//   _tentera_, _unang_, _facilius_, _longtaem_,
   {{0x922590fa,0x22925510,0xad4b359b,0x0d27759c}},	//   _ruski_, _bitabo_, _खासगरी_, _hornpipe_,
   {{0xa9b33290,0x5bb3e114,0x03009435,0x548f0300}},	//   _शंकराचार, _berketur, _babandi_, _milourel_,
   {{0xdb6d13d5,0xda8b131e,0xaf3bf275,0x7fb8c0de}},	//   _assosier, _bariwoon_, _истираси, _بايولۇقت,
   {{0x4432414c,0x77bb00c8,0x79c41136,0x57d704e9}},	//   _অবহিত_, _kolektyv, _defendat, _improvew,
   {{0xbecd203c,0x929091d0,0x02d81074,0x5224d59d}},	//   _artigian, _lojack_, _behen_, _trekk_,
   {{0x5fc3909b,0x62d903fa,0xfaece279,0xe248d466}},	//   _speicher_, _incomes_, _kaffehus, _umeme_,
   {{0x2988c0c9,0x40172287,0xb494b3e7,0xc9ba4464}},	//   _bankkont, _гародні_, _amalatul_, _excesiva_,
   {{0x7f644250,0xce45d2f5,0xe6cbb04a,0x35cbb35e}},	//   _baharain, _doganiga, _achaurai, _achauray,
   {{0xdc76612b,0x55ff930e,0x34caf007,0xd427505b}},	//   _agirisi_, _स्रोतका_, _مردانہ_, _adlalayo_,
   {{0x0db7e1a0,0x69843308,0x222ac241,0x318330fc}},	// [c30] _springda, _masipala_, _ионал_, _флоты_,
   {{0x461da0bf,0x2e1f7030,0x1ee3506a,0x4f65a214}},	//   _жисмоний_, _تحقیقاتگ, _मुस्लिमा, _ءﯨﺲﻭﺭﯨﻨﺪ,
   {{0x32eb1040,0x3a44522e,0xfdc96102,0x625413b0}},	//   _berinmo_, _macerata_, _радикаль, _ekstrabl,
   {{0x1ea5b086,0x0d140203,0x62da609c,0x54b603a5}},	//   _dailycan, _amasomer, _gareen_, _ababebek,
   {{0x98a92083,0xb8ca43d0,0x22fc9030,0x7a12b2d7}},	//   _кандайды, _бичвэрий, _chaga_, _dibayoke,
   {{0x6c75a02a,0x627430ef,0x7c6b23c9,0x77444191}},	//   _ceasing_, _سورلي_, _patriam_, _bernkonv,
   {{0x82a6d523,0xb94873ea,0xc4a9b057,0x147f4264}},	//   _ntebe_, _agalimot, _jurnalul_, _استبعاد_,
   {{0x13207145,0x12903167,0x9667c140,0x86b4816c}},	//   _denye_, _sumaku_, _халиков_, _asosyasy,
   {{0x7f66c38c,0x3df0c007,0xbdbaa13b,0x2aa411d4}},	//   _имала_, _اندوز_, _pignagia, _naligiis,
   {{0xd27e000d,0x45bcb065,0xc91af319,0x49f61352}},	//   _diine_, _למעסיקים_, _chịu_, _موسیک_,
   {{0x1387418d,0x0413f106,0x2f8023cb,0x72c4e225}},	//   _spered_, _ceistean_, _लक्की_, _animais_,
   {{0x4a4f40e7,0x72f0a416,0x09ff62cd,0x5c76116b}},	//   _khombets, _delovanj, _tourismu, _brostad_,
   {{0xa97ab471,0xe22660f9,0x937ba07d,0xef350469}},	//   _liyingce, _merkja_, _honarem_, _absorbar_,
   {{0x02489047,0x832072bd,0x3679a086,0xb1c682a0}},	//   _imamu_, _kenye_, _bookbrow, _کاسترۆ_,
   {{0x411992bd,0x58cec05d,0xa2bb116c,0x4eb861ac}},	//   _паролемд, _tradiziu, _konekte_, _rajoelin,
   {{0xc39470aa,0xf453930e,0x629bc481,0x56d5a0b1}},	//   _canse_, _अनौपचारि, _aleksey_, _faransii,
   {{0xb53812d1,0x72d8b267,0x1252f053,0x325b742c}},	// [c40] _خۆپاراست, _cheere_, _feststel, _smalle_,
   {{0x65a9b0af,0xe5dd21a0,0x91d170c7,0x33f423bf}},	//   _よろしくお願いし, _belegivö, _wareegay_, _esercizi_,
   {{0xfd0021a1,0x151b1171,0x49b33180,0xce06d009}},	//   _encumber, _مسيحا_, _と思います_, _аьлла_,
   {{0xd2bad387,0x727e619f,0xf2e810f0,0x68c2f31d}},	//   _adedeji_, _tooni_, _objectif_, _portaleg,
   {{0xf2b4b0fb,0x9225f05e,0x37589287,0x53dcc2e7}},	//   _tacca_, _etuku_, _значную_, _amamaliz,
   {{0x20402216,0xeb0c50e7,0x9bc9b2b4,0xc3f8200e}},	//   _incumben, _kutshile, _अनुकरणीय_, _yekun_,
   {{0x3c2a4135,0xf5c1e2d5,0xb394718b,0xa387032d}},	//   _ነጻነትን_, _artaigil_, _banse_, _acarat_,
   {{0xc25ac051,0x9430a10e,0xbba0b17c,0x4ecd304f}},	//   _callan_, _narkotyk, _verkisto_, _keringan,
   {{0xd379524f,0xc1a5f04c,0x6325806a,0x401fd057}},	//   _kitaata_, _نارنجی_, _निरनिराळ, _referito,
   {{0x8fe8a578,0xefbc120e,0xab7d8011,0x22e291d2}},	//   _सीताराम_, _историск, _trincher, _phriang_,
   {{0x42fc83b4,0xe25b711b,0x46b7e0d2,0xc2a6c44e}},	//   _bakatisi_, _stalno_, _jerarqui, _cambar_,
   {{0xdceff3c1,0x4fda1009,0x9d673484,0x4159859e}},	//   _ansvarig_, _ngezilan, _islandès_, _aizkavēj,
   {{0xba944038,0xf2f1e019,0x216bc2e5,0x5dc63057}},	//   _akuntans, _atribui_, _skrátka_, _такселе_,
   {{0xc3736591,0xe26e6436,0x6a2a1065,0x51b3301c}},	//   _kumazwe_, _moroda_, _הדיאטה_, _یاترا_,
   {{0x4c9322a0,0x827ed16c,0x0304822b,0xc11c252d}},	//   _ڕامان_, _plent_, _penolong_, _služila_,
   {{0x4017d225,0xc548f263,0xd2d3b1fb,0x8a0df4be}},	//   _наводно_, _насридди, _kamonyi_, _kuharica_,
   {{0x1cf7a0be,0x8c3022a0,0x806e334d,0x7b617114}},	// [c50] _kulturor, _مالیزم_, _chaphran, _seremban_,
   {{0xe36400ce,0x3e2fb064,0x17afb0a8,0x73f8201f}},	//   _végül_, _historiq, _historii, _tekun_,
   {{0x3249414d,0x873821e6,0x15579065,0x6248d440}},	//   _asemel_, _saṃlakṣa, _נתקלת_, _amema_,
   {{0x538740dc,0x836482a2,0xc7341206,0x02b2f159}},	//   _ordres_, _singdin_, _harleysv, _rendben_,
   {{0x0a6540e5,0xf9c40526,0x0e7220f7,0xdb94014b}},	//   _कार्यकाल_, _kweentat, _遵守中华人民共和, _similair,
   {{0x0ec23245,0x322460c4,0x53f821c5,0xd6622050}},	//   _abantwan, _isoko_, _dekul_, _一位因為從小自一,
   {{0x939472e2,0xf3f8d099,0x6d68a46a,0x32f4544b}},	//   _panse_, _linuxe_, _ngamazwe_, _grannar_,
   {{0xe1e5b074,0x92efc2e2,0xa23f9065,0x41e110db}},	//   _politikë_, _ankouraj, _רמיקס_, _уйынын_,
   {{0xd27e62c0,0x2c6fc15e,0x6a0d31d4,0x260b52c6}},	//   _noonu_, _loturak_, _angalane, _allocuti,
   {{0xedab22b4,0xb9e65153,0x313e6252,0x727ee03a}},	//   _श्रीशांत_, _forumind, _саммитке_, _iminan_,
   {{0x6db3000f,0xa248c064,0x667c40c9,0xc2002500}},	//   _belastet_, _sommes_, _комуналь, _ilkin_,
   {{0x1e69f14f,0x427f720c,0xa318d248,0xbf119441}},	//   _mantraṃ_, _vyanse_, _ኣይትኹን_, _адаптира,
   {{0x0585d300,0xfc01c378,0x398d2096,0x59ec935e}},	//   _energiez, _tvisvar_, _مقررےن_, _aitibata_,
   {{0xaa13e0f7,0x4a5313b4,0x33e50096,0xdb398252}},	//   _您的身份为游客_, _begelela_, _پرسکون_, _ракетада,
   {{0x5e08e304,0x0fecf0d7,0x91fe227a,0xbef8b257}},	//   _hendakla, _хакимият_, _diskusné_, _quraşdır,
   {{0xeff31492,0xdeb9d22d,0xd9fcb0b3,0xc2b4b123}},	//   _benyttes_, _situatie_, _машинасы_, _cacco_,
   {{0x702ed0c8,0x626cc076,0x2ebbd04b,0x4eff90f7}},	// [c60] _назвы_, _ailona_, _belgilab_, _日允许外方独资_,
   {{0xf4f6d0c9,0xf3fa5055,0x456b63e2,0x73877135}},	//   _партнері, _rotule_, _minoritá, _ndarja_,
   {{0x670fb342,0x6c77b144,0x3db9e1ab,0x49f1b220}},	//   _institiú, _acashwe_, _maghinta, _ikinyoma_,
   {{0xeaf8536b,0x9cd7e004,0x3c686031,0xf88093a4}},	//   _aktuelle, _اعضاي_, _ይወሰዳል_, _capitulu,
   {{0x33fa621a,0x29a3c218,0x5b1fb385,0x247c3207}},	//   _forume_, _وداعا_, _kejadian_, _genellik,
   {{0x9dbc934f,0x4303a060,0x619a114f,0xd2d85289}},	//   _kamisina, _magamit_, _akhilāṃ_, _melen_,
   {{0xbe0024da,0x22d83202,0x2318a2e8,0x68d4a06a}},	//   _necesita, _sejen_, _يونايتد_, _प्रसारमा,
   {{0x77c3a0ac,0x72bb0469,0x5afdc15a,0x0b7ac2f8}},	//   _ㅋㅋㅋㅋㅋㅋㅋㅋ, _volente_, _warunkie, _eparaama_,
   {{0x89e6242f,0x437f7276,0xd68312c4,0xbb0c2030}},	//   _escribed, _ايماندار, _विरार_, _نازیک_,
   {{0xbc630171,0xdff5442d,0xbb02e258,0x3200b124}},	//   _matukio_, _proteína, _missinge, _aecid_,
   {{0x16d5e068,0x79fa743a,0xfba031ca,0x0c9ac031}},	//   _berbandi, _maghanap_, _می٘انہ_, _መግባቱን_,
   {{0xcfb1c30e,0x2dc4100a,0x827e64a5,0x128861e2}},	//   _कांग्रेस, _באפריל_, _yoonu_, _киргизис,
   {{0x93f90098,0xa30d423f,0xf2e640b4,0xb84c60ac}},	//   _kibuye_, _ligadas_, _abenera_, _없었습니다_,
   {{0x63dde0c4,0xa3ab01d2,0x32fc011c,0xa75d259f}},	//   _yitwa_, _paramarj, _maigh_, _छेन्तला_,
   {{0x6387735f,0x18d195a0,0x927ed317,0x0af5a381}},	//   _zdarma_, _амбасада, _poent_, _jakobson_,
   {{0x54fbd048,0xe146a2bc,0x22fc6065,0x39da32d7}},	//   _कैलाली_, _biltekno, _sexually_, _diketeke,
   {{0xe3f840fa,0x626e52f8,0x678b1085,0xa3fa7094}},	// [c70] _zemun_, _motoka_, _যাতায়াত_, _kasuan_,
   {{0x240ef064,0x4248f089,0x93104283,0xea9a317d}},	//   _比上年增长_, _climbs_, _abacele_, _kiinteis,
   {{0xf3877010,0x1f15937c,0xc27ef07d,0xb292010c}},	//   _spared_, _pandesan, _lainim_, _dipako_,
   {{0x6301805c,0x226cd105,0xf59f040d,0x322672b7}},	//   _trebate_, _denove_, _اسمانن_, _daukar_,
   {{0xc06805a1,0xe5795135,0x23f903a5,0x706e95a2}},	//   _reparado, _ኣልኣሚን_, _sibuze_, _piaseczn,
   {{0x8aa262a7,0x72d23111,0x1ac040db,0x52903078}},	//   _عبدالقیو, _titoloj_, _maikemis, _tamall_,
   {{0x32fb3238,0x3a171100,0x2f9a503c,0x193cc2fc}},	//   _dachenn_, _makakuha_, _poème_, _znamenit,
   {{0xc2fc01c3,0xbc93240d,0x0c93d252,0xe2a642e7}},	//   _faigh_, _نالان_, _بارام_, _fumbo_,
   {{0x72d85173,0xf2a64161,0xc4eb2248,0xe7db35a3}},	//   _gelen_, _gumbo_, _ንምምካት_, _zapadnoj_,
   {{0x537e7252,0x63947421,0xf61af0f9,0x43d78009}},	//   _тараткан_, _aansa_, _urtagarð, _серверов_,
   {{0x739470e3,0x4d3631d9,0xd25ac40f,0x2d8c10d8}},	//   _bansa_, _қайтып_, _fullum_, _allmedia,
   {{0x194e701d,0xe86720c9,0x9c4c316e,0xf27ef1c5}},	//   _anklopfe, _михайло_, _наставља_, _ibinom_,
   {{0x28fc50e1,0x3e27b07f,0x42fcd046,0xd27ef110}},	//   _escarpad, _аусдкыла, _chega_, _angng_,
   {{0x43731178,0x62fc3169,0x19e3c256,0x0a7ee2e7}},	//   _senaste_, _gezielt_, _gatolika_, _afundits,
   {{0xadb35184,0xca8032b1,0xd20042ee,0x15c3825a}},	//   _fiangona, _negosias, _ilmin_, _hispanio_,
   {{0xa27e25a4,0xf25ac22e,0x264b40ac,0x3c65519e}},	//   _שוחקות_, _wallon_, _친구그룹이_, _tapuwae_,
   {{0x8ec18218,0xf98e106d,0x29e7c2d7,0x6d23c0ec}},	// [c80] _bronntan, _lomhlaba_, _babolela_, _katolike_,
   {{0xd781b492,0xd71ce009,0x72cb05a5,0x04c9c007}},	//   _virkelig, _подтверж, _deadam_, _beruházá,
   {{0xa26db382,0xc601f4f7,0x03dc72d7,0xa941f065}},	//   _zivota_, _evaluati, _banwi_, _evaluate,
   {{0x7c9ca339,0x025ac3a4,0x9d79a03b,0x42dca075}},	//   _galeriju_, _callen_, _abamange_, _galeriji_,
   {{0x0915e2cd,0x9319108a,0xdbbdd009,0x9ae83427}},	//   _verbindu, _ديوال_, _показыва, _лекции_,
   {{0xcc8dd1ba,0x4c7c9394,0xb25af1ca,0x92d81266}},	//   _продукта_, _maysaxa_, _sahlan_, _hehea_,
   {{0x127f43e1,0xc34e30dc,0x927e906b,0x0201730a}},	//   _amenen_, _castelló_, _aoanu_, _fraide_,
   {{0x42d85217,0x3a074500,0xc878810e,0x4bfce05b}},	//   _telen_, _almaniya_, _दर्दनाक_, _عدلیې_,
   {{0x72fc04e6,0x8c67f044,0xafa2f0ac,0x3ac44290}},	//   _ibigo_, _tonutia_, _상습누범에_, _उपलक्ष्य_,
   {{0xf2cad115,0xd2d81056,0x629da12f,0xcc63724f}},	//   _moldau_, _lehea_, _баралмай_, _partiip_,
   {{0xc34f4300,0x4db352aa,0x4a67c2fc,0xc176c050}},	//   _armerzh_, _piangona, _прилагођ, _一九八九年夏天_,
   {{0xa8be22ca,0x9e05c272,0x7036d00e,0xdc5bd018}},	//   _иштин_, _paneurop, _leytenan, _noutati_,
   {{0xc2d60183,0x32ed4365,0x425ac168,0x2c2d4095}},	//   _europan_, _besiege_, _vallen_, _besieged_,
   {{0x52909300,0xf27e9317,0x13c872e4,0xc2e0307c}},	//   _lakaat_, _hoant_, _visvim_, _ofanako_,
   {{0x37a3f27c,0x626d2262,0x82026261,0xa1075463}},	//   _チェックリスト_, _miliyari_, _truite_, _akakamuy_,
   {{0x8aa69012,0x2ea145a6,0xf81220ef,0x4f001227}},	//   _magharib, _fullsten, _دُنيا_, _가족뮤지컬_,
   {{0xb2df40a5,0x92ebc24a,0x025b711e,0x7e30b4ff}},	// [c90] _melebihi_, _wannear_, _araldo_, _langrena,
   {{0x727c3440,0xdd2d92bf,0x945321d2,0xd27a8381}},	//   _asengaki_, _arangiye_, _thadlask, _bolsíllo,
   {{0x3628001b,0x527e61b8,0xc246252f,0x3c5ca36f}},	//   _kabineti, _giong_, _zīmes_, _bantril_,
   {{0x1c5d54a8,0x46bb313b,0x8be85059,0x05766124}},	//   _निवेश_, _aturumay, _ይሰማኛል_, _агранатр,
   {{0x22e03009,0x52fc92d7,0x235663c1,0x13ebf067}},	//   _efanako_, _baagi_, _arbetar_, _aputa_,
   {{0x1c7d654c,0xb2c1d129,0x827f03f1,0xf4bf3263}},	//   _ikusasa_, _pillola_, _afandi_, _африқо_,
   {{0x627e6151,0xe295f114,0xf63be1cd,0x3868303d}},	//   _xiong_, _terkini_, _underhål, _خيريه_,
   {{0xac322328,0x437a1185,0xef58e238,0xfb18e238}},	//   _apunmilu_, _americam, _displega, _displege,
   {{0x7290300e,0x03966199,0x89a3e3ab,0x195cc429}},	//   _olmasa_, _berson_, _rodinnéh, _ипатови_,
   {{0xf29031eb,0xa346c0af,0x2224e2d9,0x32925262}},	//   _gemach_, _randers_, _benkum_, _hitamo_,
   {{0x38d130e4,0x027f72f6,0x875a10bf,0x1f0bb1c7}},	//   _frizider_, _nyange_, _васаллам, _ﺷﻪﺑﯩﻨﺪﻩ_,
   {{0x42920039,0x39d0b10c,0xc9d91308,0x027e00b1}},	//   _bapang_, _bakerest, _connecta_, _miino_,
   {{0xbfefe35d,0x000e811b,0x727e9110,0xc2e87108}},	//   _electrón, _razvijen, _enano_, _валютала,
   {{0xac47b208,0x620182a6,0xbf1ed071,0x327f7285}},	//   _hunchbac, _nazivu_, _maatskip, _byange_,
   {{0xf20270c6,0xc29030e2,0x827e60f3,0xff473141}},	//   _afrimu_, _demach_, _lione_, _иниши_,
   {{0xf7b4e0eb,0x5ae505a7,0xe7562212,0x32e80166}},	//   _aggrandi, _rubrique, _کارنامې_, _abbilta_,
   {{0x738770f3,0x929203d9,0xc27e9362,0xbd9ee3c3}},	// [ca0] _scarse_, _gapang_, _znano_, _bibelske_,
   {{0xaeeb9042,0x726e5043,0x6c51f336,0xcdb6605e}},	//   _tenhamos_, _kotona_, _anitema_, _atungala,
   {{0xadc4c284,0x1394a1d2,0x866c205a,0x42f67177}},	//   _visibile_, _babsa_, _сууга_, _arkitak_,
   {{0x6a1ad176,0x6556108d,0x37f701ca,0x5c3c10e5}},	//   _قزوین_, _amakwerh, _وُجارٕ_, _मान्यताओ,
   {{0x32fc95a8,0x8ebd5009,0xd2d992e2,0xa9cfc2df}},	//   _paagi_, _ukuzibop, _dignite_, _cokovata_,
   {{0x2fb5c2d1,0xbc7f2036,0x5d482022,0x12c313f7}},	//   _غوربه_, _massimo_, _клиентте, _italyen_,
   {{0xe22b330c,0x696b438f,0xb26cc1fa,0x25db9009}},	//   _crimine_, _groninge, _ahlota_, _своему_,
   {{0xc1bd2063,0x79477042,0x007ad292,0xe26e6507}},	//   _битта_, _abambele, _داستانید, _horoia_,
   {{0x72fc912b,0xe39661c8,0x07a73007,0x7a15e2cd}},	//   _taagi_, _person_, _دفتری_, _verbunde,
   {{0x9304f20a,0xe92143ae,0x0224e0bd,0x385904d5}},	//   _whooping_, _aktivní_, _kuiken_, _altricos_,
   {{0xa2fa212a,0x0519110a,0xedf0c223,0x5d5a33f9}},	//   _machina_, _مبارڪون_, _منگول_, _ролей_,
   {{0x750aa155,0xe03c03ef,0xe27ed19a,0x52d8701a}},	//   _شىنخۇا_, _colectio, _poeni_, _tenen_,
   {{0x327e95a9,0xd2d91190,0x427f4126,0xf1852251}},	//   _liang_, _nicene_, _nyenye_, _огромен_,
   {{0xb4acf114,0xba152359,0xb1deb0bf,0x461ba44d}},	//   _dijalank, _ortalama_, _birlashm, _frendovi,
   {{0x42733492,0xc25532ca,0x330cd394,0x05fdb218}},	//   _måned_, _ensenyam, _mayacht_, _chreidiú,
   {{0x020022ab,0x002c4278,0x6a1a324e,0xecb01351}},	//   _tokie_, _finekifo, _ازبین_, _anggurmu_,
   {{0x52a7a0c2,0xba47c041,0x729214f7,0x46f0b023}},	// [cb0] _лауреатт, _معلوميږي_, _repair_, _bataatá_,
   {{0x9863c225,0x927e949b,0xdd90c063,0x1c3bc362}},	//   _долари_, _biang_, _менда_, _mobitelu_,
   {{0x62d87538,0x8213e040,0x72d8a36b,0x417e221c}},	//   _genel_, _bythe_, _leben_, _madankol,
   {{0x42c3b306,0x9af7f1e1,0xcbec6110,0xe2d70174}},	//   _kohlelo_, _kahulume, _underwir, _putovao_,
   {{0x83dde2bf,0x5808d11c,0x4d2d010b,0x6ced516e}},	//   _witwe_, _تتحول_, _arinjiye_, _наставак_,
   {{0x26d332f7,0xc075f011,0xdda5e2d7,0xa25ac086}},	//   _террорчи, _campesin, _dirisiwa, _goolge_,
   {{0xe27e9320,0xd2a69110,0xe9de3474,0xe4132352}},	//   _giang_, _grabe_, _contenid, _واندا_,
   {{0x2d06b2c1,0x826e62d4,0x72e480c2,0x0d2682d7}},	//   _birlikte_, _morona_, _алтынсы_, _bolokile_,
   {{0xd4a590ea,0xd2d87008,0xd386e177,0xb2d950d7}},	//   _स्थानान्, _menem_, _agirwa_, _nigeze_,
   {{0xed3bb0d2,0xf2d8a0b6,0x5f2512c4,0xe615c263}},	//   _стандын_, _deben_, _आश्रयाला_, _мукими_,
   {{0xd2ca031b,0x7291b1d9,0xe3f470ec,0x4fd241c7}},	//   _emide_, _ولگەندە_, _vertet_, _اماندا_,
   {{0xa224e105,0x02903157,0x18949057,0x63ee01b5}},	//   _sankta_, _jemaah_, _гласурь_, _фотосуре,
   {{0x8915d252,0x52a6c2b7,0x93cf711b,0x72e00084}},	//   _сыналгы_, _lambar_, _glavna_, _akunyun_,
   {{0x427e6233,0xf38fd159,0x52a6411d,0x406942b8}},	//   _inona_, _annyira_, _kumba_, _kampioen,
   {{0xd057c2db,0x32d8a365,0xfbf6f0c8,0xc5bed508}},	//   _физики_, _heben_, _частцы_, _дрога_,
   {{0x0d0dc412,0x0e5f40af,0x72a6404a,0xa24ca180}},	//   _apsuskir, _この記事へのトラ, _mumba_, _続きはこちら_,
   {{0x9394c1c2,0xc27ff156,0x0578d198,0x61e370f7}},	// [cc0] _pulska_, _aluno_, _срединат, _国家林业局_,
   {{0xb35ad1c7,0x7705a218,0x164fd32b,0x029152d5}},	//   _солардың_, _cuntasaí, _phenderf, _argaid_,
   {{0x0354a3fd,0x12a644a5,0x11b37412,0x6ad6403c}},	//   _podemos_, _gumba_, _jilayaña, _praticat,
   {{0xf2d87341,0xf0edd2e4,0x8843726e,0x21dca13f}},	//   _genee_, _vinarack_, _portalas_, _involvem,
   {{0xf305c342,0x98d72043,0x7934b0c6,0x53cec1de}},	//   _سوزان_, _питания_, _asembisa_, _olovka_,
   {{0x178d7588,0x325af16d,0xbb18b3bf,0x604de554}},	//   _نیوزی_, _wahlen_, _компютър_, _piqutain,
   {{0x43966408,0x13fa55aa,0x3bdab12b,0x92910511}},	//   _persen_, _estudo_, _asambodo_, _anbark_,
   {{0x6944b3c3,0xa3957272,0x275a9121,0xb9bc7317}},	//   _herunder_, _amasse_, _हुक्काम_, _guérande_,
   {{0x63f47174,0x0200930c,0xe27ef25b,0x0eb53026}},	//   _postao_, _blain_, _leinki_, _opdracht_,
   {{0x4debd2a6,0x02a642e7,0x1a0ed0f4,0x0e80a0f7}},	//   _trajanje_, _fumba_, _ﻗﺎﻻﻳﻤﯩﻘﺎ, _前开始排队_,
   {{0x6b2b70d7,0x6aabe24b,0xc3eb026c,0x6349c326}},	//   _komandas, _imikhumb, _platnu_, _asifele_,
   {{0x8225f2fe,0xc62d107d,0x82fcf1c8,0xe59f0188}},	//   _iruka_, _litimapi, _diggs_, _virgesch,
   {{0x95d42408,0x977a5248,0x6841c020,0xf1ae3264}},	//   _membutuh, _ብመዝሙር_, _eveloped, _ومسلم_,
   {{0xa2861033,0x2bccc036,0x06a5100f,0x4435a2ad}},	//   _pedagozi_, _комисият, _videoinf, _tumanako_,
   {{0x19d0c09a,0xf248c1c6,0x43877230,0x02017387}},	//   _бейиш_, _zammit_, _waarme_, _araiye_,
   {{0x66644003,0xc3a5415a,0xf20090f0,0x6249c093}},	//   _viljandi, _क्रिस्टी, _alain_, _perwakil,
   {{0x79ed02bc,0x13e5c5ab,0x52d854de,0x52d8a100}},	// [cd0] _forespør, _januwari_, _pelec_, _lebel_,
   {{0x52b590f3,0xbfb46009,0x6dbcf200,0x34ba4326}},	//   _nasce_, _некоторо, _jakirina, _ababonak,
   {{0x6ef1a00a,0xc2dfe094,0x5213112e,0x6faa2009}},	//   _marketin, _bereziki_, _kocham_, _заголовк,
   {{0x1453f146,0x398aa180,0xf2a600c4,0x128fe157}},	//   _ትምህርትና_, _ジアドレス_, _iriba_, _mokhtar_,
   {{0x415dd16d,0x779c70a1,0x93ebf47b,0xf17754dc}},	//   _hoffentl, _gobongö_, _epute_, _allarhel,
   {{0xd2d95058,0x2ebe136b,0xde9ec0d7,0x1225f5ac}},	//   _ingene_, _branchen, _сайла_, _bruka_,
   {{0x82d8c45f,0x901a1064,0x3a08d1e6,0x29be33d9}},	//   _leden_, _服务已开通_, _samayena_, _afidefit,
   {{0xac4ce11e,0xb26d612f,0x1f72b0a0,0x6225121f}},	//   _mulching_, _كەشپىيات, _ababevin, _ducken_,
   {{0xf9f3f063,0x8d054085,0xd3640174,0x98a631a0}},	//   _ravishda_, _সুইজারল্, _glagola_, _pädistuk,
   {{0xe280b226,0xb50b8340,0xf26e6044,0x89eb70ff}},	//   _diskuse_, _guvernul_, _torona_, _originee,
   {{0xccdb720b,0xdd7ec0c0,0xf695609a,0x48e0f07e}},	//   _उदारीकरण_, _alemanda, _енергийә_, _bakgrund,
   {{0x53006002,0x822b741a,0x1be9f180,0x22d8508c}},	//   _binaydi_, _kommode_, _神奈川県足柄上郡, _gelei_,
   {{0x82fdc12f,0x12d8a0c7,0xa2762105,0x3d0d5196}},	//   _камбоджа_, _hebel_, _פיליזאף_, _derrigor,
   {{0x186f6059,0x5ee86064,0x02d8c2f5,0xe169c38c}},	//   _እንግሊዝኛ_, _城乡规划法_, _deden_, _сезони_,
   {{0x63f86440,0x4cab401b,0x23784363,0x621110fc}},	//   _ndour_, _ющенконы, _nafanua_, _bakhethi_,
   {{0x8e325480,0x8ab9c32f,0x9b507330,0x2a14a135}},	//   _amelikas_, _abavunye, _原中国人民银行河, _miratohe,
   {{0xa2d8c538,0x30747369,0xd3eae2d9,0x4a8fd2ed}},	// [ce0] _neden_, _redactio, _hintaw_, _skenderb,
   {{0x327f51a8,0x85ee35ad,0x2348f177,0x62a6409d}},	//   _vienas_, _landslið, _esgelli_, _tumbi_,
   {{0xf215717a,0xe2d8743f,0xd1fe20a8,0xe48d50ac}},	//   _নিয়ন্ত্ৰ, _idnes_, _diskusní_, _인테리어소품_,
   {{0xb26e00c4,0xe2d8c207,0x53eba489,0x3602125c}},	//   _musozi_, _beden_, _textom_, _сервисті,
   {{0xf67b1171,0x520090d8,0xbaf261b9,0xfc552064}},	//   _قرباني_, _amais_, _экологик_, _montage_,
   {{0x6032f45f,0xf3dde186,0xc9545206,0x202a7063}},	//   _nastaven, _bitwa_, _sequitur_, _kundalik_,
   {{0x6200919a,0x9386e163,0xf86dc1f9,0x07f4044b}},	//   _blaid_, _leiria_, _बग्गा_, _felaktig,
   {{0x6c88e09a,0xd2b4e063,0x9db14104,0xfc503159}},	//   _билишимч, _pincha_, _lenguaje_, _ہنسنا_,
   {{0x93f8646c,0x21e7f113,0x8b8be326,0xd69b7041}},	//   _adour_, _spriedum, _abangagc, _ارقامو_,
   {{0xf27ff3f7,0xac01c24c,0x23a3a282,0xadc9b360}},	//   _moune_, _mansuur_, _האמזא_, _مہدویت_,
   {{0x0d2c931e,0x19ee90c3,0x426e90c3,0x9c24507b}},	//   _aktiwite_, _novinara_, _novinari_, _bahaniir,
   {{0x825ac39e,0xb37f0395,0x927e6401,0x324950d2}},	//   _jallun_, _merekɔ_, _anonn_, _poemes_,
   {{0xb291c04b,0x696ca078,0x938700ce,0x0d03d0ae}},	//   _avval_, _eilimint, _akarom_, _qohumlar,
   {{0xfdbd3050,0x4c14f1a1,0xca0d1222,0xb2da6138}},	//   _人民出版社_, _ourshay_, _vodafone, _sprema_,
   {{0x1ebf2030,0x7394e3e4,0xf630c359,0xa2f1f00d}},	//   _استراتیژ, _fafsa_, _biyograf, _muriidi_,
   {{0xec77b4be,0xe876c0ba,0x14b6112f,0xc6d0014d}},	//   _spasite_, _омика_, _قاتلام_, _टानिक_,
   {{0x0c7c8071,0xeeb8d42f,0xf394807d,0xec5c72c5}},	// [cf0] _frisian_, _escortin, _longlong_, _slutten_,
   {{0x02926004,0x9682327a,0xd342a405,0x5bdfb1db}},	//   _marang_, _decembri, _inneall_, _indekser,
   {{0xe386e1c6,0xc163d1ba,0xfbfc6185,0xb27f7390}},	//   _sufra_, _копирай_, _kolosefo_, _amanan_,
   {{0x92d594ee,0x627f0291,0x1506e3cf,0x0200b2e9}},	//   _osnovao_, _nganti_, _klimafly, _alcin_,
   {{0x73eb7196,0x9d151215,0x527ed039,0x61c93009}},	//   _esaten_, _nepoznat_, _lieng_, _почты_,
   {{0x5f946004,0x026da296,0xa1acc00e,0xe3b8a37b}},	//   _مخالفان_, _хатароти_, _düşündür, _procjenj,
   {{0xd506c370,0x389e70cc,0x31fe414f,0xc2a641d8}},	//   _одами_, _convenir_, _ajuhavuḥ_, _numbu_,
   {{0xf27f52ab,0xa9c720d2,0xf86871d4,0xc03b7258}},	//   _dienos_, _баратат_, _maniitsu, _amigarto,
   {{0x7c75136f,0xb3f1b06d,0xe303a0cf,0xf98c8296}},	//   _ofising_, _kwazise_, _gagamit_, _abakwamt,
   {{0x8c536346,0x92a64187,0x4c393443,0x8dd1414d}},	//   _surtiwa_, _kumbu_, _carcelar, _ठेकेदारो_,
   {{0x7d96a04f,0x6dd6e152,0xd26cc052,0x80968352}},	//   _tertentu_, _perjanta, _valoda_, _دارابی_,
   {{0x2cbe113c,0xc68df0fd,0x4f43f093,0xb201145b}},	//   _марек_, _espesifi, _persauda, _sabiru_,
   {{0xe670d2e3,0x3ac35082,0x9c531478,0x3bf6f3d0}},	//   _स्वच्छता_, _chavanne, _heathen_, _настны_,
   {{0x4baec3d6,0xc37b6012,0x927e038d,0xd6816064}},	//   _imihlobo_, _kiwango_, _diina_, _calendri,
   {{0x83be858f,0x794a92a0,0xdeb33252,0x4212e0af}},	//   _slaveni_, _ستیپێکرد_, _шериктеш, _frihed_,
   {{0x7a07814f,0xd2bba0e4,0x784ba309,0x82d8e472}},	//   _adharott, _deferle_, _challijd, _kefen_,
   {{0x93f8f135,0x8290c0c7,0xe2b674d9,0x6c3f1290}},	// [d00] _punuar_, _islaam_, _paucas_, _गरियाउँ_,
   {{0x126c9411,0x616c93ab,0xfe27c111,0x12d8e0e4}},	//   _aktiviti_, _aktivity_, _promesas_, _defen_,
   {{0x42c4a1c8,0x037351e7,0x127ed480,0x632c2030}},	//   _england_, _lubatud_, _xieng_, _шулардан_,
   {{0x9f8331d9,0x6246d52f,0x13035016,0x7225f12e}},	//   _قۇربى_, _tēmas_, _nyablab_, _druku_,
   {{0x82d8c027,0x02d9e123,0xe39660ae,0x3a0f5245}},	//   _medem_, _ankoler_, _versin_, _akaphend,
   {{0x127e0134,0xed0e5036,0x43142019,0x827e6493}},	//   _diini_, _продукти_, _באזוכער_, _cionn_,
   {{0xf2d8e4de,0x0c290031,0x626cd0e4,0x9a21f0f4}},	//   _brieuc_, _አጥነትን_, _galoup_, _ﺟﺎﻳﻼﺭﺩﺍ_,
   {{0xa3f9b256,0x82838030,0x3af61036,0x82a663ef}},	//   _imvura_, _kishini_, _traspare, _probo_,
   {{0xfd74b055,0xc27ed08e,0x1c6a1221,0xa291e44b}},	//   _permette_, _sieng_, _kuluhlu_, _avtal_,
   {{0x92cad010,0x4c535055,0xd553f0e7,0x62d87007}},	//   _minded_, _lettera_, _khakhath, _zenei_,
   {{0x92838063,0x4d1b0048,0x8ed6c2cd,0x3dc0f3c2}},	//   _lishini_, _expozice_, _bedienun, _abakumwa,
   {{0x9632c0ba,0x50bb13d4,0xdef63174,0x61d58036}},	//   _акциясын_, _hailangh_, _загреб_, _collegam,
   {{0x95cd312c,0x723b1039,0xc768b151,0x3c2bb024}},	//   _angahany, _kailang_, _yuavtsum_, _abhayapr,
   {{0xd27ed039,0x325af5ae,0x9263d009,0xeee823dc}},	//   _tieng_, _sahlin_, _nokuhlal, _метров_,
   {{0x8e564521,0x05def031,0x3c690085,0x59f9e3aa}},	//   _balbesit_, _በየቀበሌው_, _carrito_, _मौल्यवान_,
   {{0x329261ab,0xb27ed320,0x127e9175,0xf26e02f6}},	//   _parang_, _rieng_, _anann_, _musoni_,
   {{0x0316e426,0x052870fd,0x2200d128,0x42926292}},	// [d10] _benzon_, _politisy, _blein_, _qarang_,
   {{0x9d2fb085,0x1223f14f,0x1e4b9258,0xf487b10e}},	//   _মোশাররফ_, _agocaraṃ_, _qularnaa, _rekreacj,
   {{0xc2d87076,0xc25b423c,0x1eb083f7,0x52a7044e}},	//   _penei_, _quello_, _konesans_, _jaabir_,
   {{0x59ae715d,0xe394e0b1,0x2737a251,0x72926029}},	//   _ویزیت_, _amisom_, _наплата_, _tarang_,
   {{0xd39581fd,0x510a81a2,0xa27ed4e2,0x727e6363}},	//   _varsa_, _означает_, _moenx_, _aiono_,
   {{0x51b1e085,0x72cb705b,0x327e0447,0xc2d8543d}},	//   _কাঠের_, _abadla_, _viini_, _felet_,
   {{0x5f11628c,0x05e310bb,0xf27ed24a,0x1d876036}},	//   _kontakta, _культури_, _hiene_, _inserire_,
   {{0xba993012,0x1841a424,0x1e37536f,0x826d6256}},	//   _زياده_, _pruritus_, _bakgtsha, _ingoro_,
   {{0x175a9030,0xfd02701a,0xac027027,0x2a9010af}},	//   _agentlig, _qualitat_, _qualitad_, _skanderb,
   {{0x5290c12e,0x12d850ce,0x724900a9,0x92f2c288}},	//   _tematy_, _kelet_, _alampi_, _уклар_,
   {{0x427e9278,0x59d74180,0x9cfe410b,0x8cff83ea}},	//   _siana_, _hadersle, _aritahir, _akhumutc,
   {{0x037a001f,0xe26cb246,0x227f5104,0x4eca12ac}},	//   _jiragen_, _kirikiti_, _bienes_, _باپیرئاغ,
   {{0xf344522e,0x13ac01c0,0x13bb2007,0xfb6491df}},	//   _rebelde_, _sappia_, _آسیان_, _situanta_,
   {{0xa2945244,0xf4b7a1a0,0xd95d416f,0xaea6d0f6}},	//   _nakashim, _bekonsäl, _laborist, _делиллер_,
   {{0x8e1bc020,0xa1d7c17f,0x9d9a307f,0x32c85128}},	//   _ambercha, _милисаи_, _иаҳдыруе, _expound_,
   {{0x527f5085,0x527e91ac,0x503740c9,0x74774026}},	//   _tienes_, _tiana_, _systeman, _systemen_,
   {{0x4b0cc27c,0x4225f5af,0x74da1287,0x82c94309}},	// [d20] _友達に紹介_, _brukt_, _сотню_, _bosovbe_,
   {{0x403b62e4,0x20af4228,0x6fa4a2b9,0x9200906a}},	//   _saigonto, _استحضار_, _antenner_, _alaih_,
   {{0x32d910ff,0x2395831d,0x697d70f0,0xdfa370f7}},	//   _lezen_, _marso_, _ancienne, _收纳上手技之书有,
   {{0xec1aa3f4,0x720020c8,0x22d8512e,0xe4b5f418}},	//   _cornered_, _kokie_, _celem_, _ababesek,
   {{0x92fb00a1,0x02caf363,0xceae5031,0xf96d0043}},	//   _tashina_, _amalosi_, _እስካለፈው_, _navigaat,
   {{0x403c817c,0xa4be6116,0x5c6a1280,0x9ef96381}},	//   _kongreso, _कनडेरपन_, _bolumbu_, _разнеишь,
   {{0x1200d01d,0xbdb81115,0x2e0190e0,0x9e0ab096}},	//   _kleid_, _rubiacea, _mahendra, _دہرایا_,
   {{0x62d8524e,0x5342a41e,0xd2d8a169,0xca7df0cf}},	//   _gelem_, _stiebel_, _gebei_, _nakatira_,
   {{0xaea5c0f7,0x9971b2a2,0xe2918249,0xa04412fa}},	//   _annuaire_, _nyinhnae, _ovras_, _kufungan,
   {{0x11f7d074,0xf876711d,0x21b3c388,0xfdb294f4}},	//   _qëndrimi, _achikuud, _ئادره_, _fulufulu_,
   {{0x12d851f7,0x82903368,0x623b1488,0xd394e1cb}},	//   _belem_, _nomata_, _railing_, _ceiste_,
   {{0x069d30ac,0xf2919123,0xe35aa010,0x2b684114}},	//   _해피선데이_, _bayant_, _coffers_, _palestin_,
   {{0xfda7428e,0x52d850ce,0x6291b55f,0xc05a7287}},	//   _kelihata, _velem_, _ndwara_, _маркетын,
   {{0xb17b824f,0xa6de9038,0x72ef013a,0x2a392009}},	//   _tamannal, _tampakny, _ghafir_, _течении_,
   {{0x427ef064,0xc4b8105b,0xdc5a51d0,0x8ddc9086}},	//   _ligne_, _فورمونه_, _montgri_, _pocketma,
   {{0xe948b1c7,0x2592b2c4,0x0fb76443,0xc7dbb499}},	//   _кафедрас, _प्रदेशात, _exalumno, _उदारता_,
   {{0x92c892fe,0x4e37f395,0x6c624193,0xe29150fb}},	// [d30] _bitonze_, _aduannua, _avarice_, _nagare_,
   {{0x56a773dd,0x93207207,0x827f645b,0x4c51f06c}},	//   _rasformi, _konya_, _vignes_, _esitada_,
   {{0x627ed32d,0x82fb32e2,0x947890c8,0xd25ab194}},	//   _anena_, _machann_, _парсюкев, _joelle_,
   {{0xbe2c829a,0xcaea72c1,0x4ecd4223,0xa9cd70c2}},	//   _mengemba, _destekle, _wasichan, _принцибы_,
   {{0x05793189,0xaf20c2e5,0x7346d2ab,0x8c0870ae}},	//   _iskustvo_, _osvetlen, _bendros_, _fermerlə,
   {{0xc39582ab,0x229151b3,0x2d21a33e,0x893ad2bc}},	//   _garso_, _pagate_, _persisir, _моментом_,
   {{0x8de7b078,0x3794003d,0x9ecdd0ec,0xd73fa205}},	//   _الرهيب_, _منظومي_, _municion, _smooinag,
   {{0x77b0a1f6,0xc394e3d5,0x027e611d,0x67dad309}},	//   _podstawi, _reiste_, _tione_, _bowanerg,
   {{0xf2d853a3,0x29a4d250,0x1beec5b0,0x73a8e29a}},	//   _celej_, _alekelia_, _радом_, _melarang_,
   {{0xa2004435,0xeb98f455,0x127f00fd,0x0320726d}},	//   _momie_, _aksialtr, _franch_, _bonya_,
   {{0xc7b653c8,0xc837221a,0xe9f0e346,0xa1d70227}},	//   _biruchni, _карацей_, _nuturkeu, _하더라구요_,
   {{0x2fe1e249,0x12fa10aa,0xe2d8c41a,0xaff8d174}},	//   _turistic_, _arahema_, _odder_, _efikasno,
   {{0x9abdd01a,0x622671d8,0x7d2600c9,0x225b01e9}},	//   _باستىرىپ_, _saukur_, _редакції_, _dialet_,
   {{0x62924395,0x92e2a2ae,0x2bb7101a,0xe2d463d9}},	//   _atwamu_, _सुमीत_, _жарлык_, _bhudda_,
   {{0xa3fa63a4,0xb525e009,0x12d8709b,0x8af2412b}},	//   _intuit_, _ukuzizuz, _jenet_, _imirikit,
   {{0xa248d078,0xfc93c0dc,0x038782ed,0x99d6e0eb}},	//   _seomra_, _دابان_, _kurre_, _funerale,
   {{0x651c7140,0x6e35e020,0x024832b8,0xf25ac17d}},	// [d40] _агентлык_, _impactwa, _cammie_, _mallin_,
   {{0xf29ec40d,0xe27e604a,0x3fefc04b,0x9c1d022a}},	//   _امامس_, _rione_, _امابو_, _pristojb,
   {{0x1899906d,0x579eb2b5,0xf27e6211,0x05fcc1bf}},	//   _писандид, _certifyi, _sione_, _контакте,
   {{0xb264f085,0x8a73d0d2,0xa2d4d2e1,0x726cb57f}},	//   _বিনামূল্, _кесепети, _aimokan_, _jadona_,
   {{0x64133276,0x727e91a0,0x6e0751c3,0xc26ca26e}},	//   _شاهدي_, _anans_, _meadhana, _vadinasi_,
   {{0x2905615f,0x12bc112b,0x935b3065,0x92d912e2}},	//   _ahiatigu, _amadoro_, _טקסטואלי, _rezen_,
   {{0xcdbd70d7,0xc1416018,0xe7d0c328,0x0e50c328}},	//   _arasında_, _статулуй_, _kaasilii, _kaasiliq,
   {{0xa9ce4187,0xec75813f,0xd394e1ca,0x820041ec}},	//   _pulezide, _herself_, _liiska_, _komie_,
   {{0xd21ac198,0x227e9036,0x4953824f,0x792da0ea}},	//   _вториот_, _siano_, _ikiliart, _नतिजा_,
   {{0x738231d9,0x13f4732b,0x62da718e,0x02d850a8}},	//   _جايلى_, _costio_, _anseye_, _celek_,
   {{0x1b61b1c7,0xb9849215,0xcdc49215,0xbb721262}},	//   _ﺳﻮﻗﻘﻰ_, _familija_, _familije_, _murumuna_,
   {{0x0a7e52bd,0x538072e2,0xb26c93e6,0x225ae297}},	//   _bahlakis, _touris_, _matimati_, _moille_,
   {{0xa7bc53c3,0x6c96b0f7,0x226c9113,0x6f2300f9}},	//   _forretni, _重要思想为指导_, _rajona_, _harumfra,
   {{0x8b4b90a2,0xbd157030,0x6291511d,0xffd952e5}},	//   _ekuthiwa_, _murojaat_, _vagare_, _dostatoč,
   {{0x521bf050,0x5c5c0300,0x22d871cf,0xb386d005}},	//   _第二天一早_, _kartenn_, _benem_, _audra_,
   {{0x63417322,0xaf2d215f,0x6ac6117c,0x88415102}},	//   _assenta_, _uumunnga, _הימלער_, _balladed,
   {{0xb0f980b9,0x42f621c3,0x69aac136,0xe3f4748e}},	// [d50] _ministrl, _briseadh_, _номин_, _postio_,
   {{0x027f5035,0xf64a01a1,0x10e62140,0x57a6d142}},	//   _dienas_, _optionsw, _başladıl, _pritisni,
   {{0x25cec0bf,0x62ad3340,0xfe96b3a4,0x927e4063}},	//   _хамма_, _сигур_, _pertinet_, _zimni_,
   {{0xbf69b09e,0xe33a617d,0xf3f4000a,0x0291523c}},	//   _nezavisn, _останетс, _partly_, _pagare_,
   {{0x2378816f,0x62bb913f,0x8ae771a0,0xb9ef4133}},	//   _hazarda_, _entered_, _pavitön_, _riviéra_,
   {{0x5a0741ca,0xf5cff3b5,0x0291b0a4,0xdad6b0ff}},	//   _somaliya_, _líquido_, _dewava_, _webwinke,
   {{0x675a9031,0x3e52b140,0xf2eff126,0xc2ca03cd}},	//   _አደቆርሳ_, _remontlı, _tenisha_, _smide_,
   {{0x9c737115,0xc1b4c3d3,0xb7bda27f,0x82015139}},	//   _apareis_, _ध्यानचंद_, _تدابنێیت_, _argine_,
   {{0xd2d8a148,0x1205a093,0x4511c4ad,0xb04530b0}},	//   _lebet_, _dimiliki_, _beelwath, _perundan,
   {{0x62d812ed,0xcbb473e2,0xd2ea4050,0x52006039}},	//   _behet_, _reagovať_, _大航海時代_, _hooid_,
   {{0x2249409c,0x464d6227,0xa7697048,0x826cb10a}},	//   _ademaa_, _서브프라임_, _बोर्डको_, _madola_,
   {{0x023af248,0x2c610477,0x4231d07f,0x8236209a}},	//   _ምውዳብን_, _berusia_, _jazmín_, _ماتورى_,
   {{0x3353213f,0x14a550bf,0x011cc0b3,0x4ed4c06c}},	//   _perform_, _دنیادن_, _radiosın, _छपिटात_,
   {{0x32d87141,0x823cc395,0xa8fd247f,0x9ed13098}},	//   _senem_, _mpampam_, _detallad, _elizapha,
   {{0x3b962287,0x027e6044,0x6086807f,0xac2d2412}},	//   _школьнік, _hiona_, _алингвис, _maratpac,
   {{0x52d8a1e0,0x6713f115,0x72a0618b,0xbd9d7115}},	//   _debet_, _perseguí, _marbam_, _calorica,
   {{0x33388456,0xb252e1d4,0x630e9054,0xf35e80ed}},	// [d60] _वर्चस्व_, _millioni_, _aiwatar_, _abafazi_,
   {{0x6d82015d,0x0ad82356,0x631760cf,0x6aee3392}},	//   _realesta, _asetarot, _kwentong_, _pemungut,
   {{0x427e61e4,0x825ae49c,0x62a60052,0x02026115}},	//   _liona_, _coille_, _gribi_, _airial_,
   {{0x7d2dd19e,0xfc9c114d,0x0abf0360,0x87c93180}},	//   _mihinare_, _समरोह_, _napközbe, _明けましておめで,
   {{0x6e1b601f,0xc891c1e6,0x23bb909f,0x0ae674e6}},	//   _danganta, _प्रशस्यत, _bakwena_, _albumfot,
   {{0xb815d0db,0x0587c3c0,0x02a60395,0x71c24020}},	//   _булараҡ_, _kantorok, _bribi_, _oredstay_,
   {{0x92fc9285,0xa7c80374,0xe30c207d,0xef03e4e7}},	//   _mbaga_, _aburitsw, _hamamas_, _emocijas_,
   {{0xc2f9e189,0x86271110,0x417f242f,0xf0b5c57d}},	//   _njihova_, _brookshi, _adminway_, _tromlach_,
   {{0xe2fc63c2,0xf30e622e,0xcae6d1a0,0xfbe1603a}},	//   _mbogo_, _visayas_, _dabinön_, _lendistr,
   {{0x584ca0ac,0x6b6522a9,0xf2d8124c,0xe29b712d}},	//   _이었습니다_, _firmenpr, _meher_, _hankany_,
   {{0x6cdfc283,0x9200307d,0x66ce504a,0xcc3ba227}},	//   _ikakhulu_, _femili_, _aisafani, _카테고리에서_,
   {{0x23eaf22e,0xeffe5063,0xa9d012a7,0x5149f120}},	//   _poitou_, _газетаси_, _шерик_, _xanthomo,
   {{0x71ea7041,0x13063111,0x329b7130,0x539662c1}},	//   _اتصالاتو_, _detaloj_, _mankany_, _mersin_,
   {{0xed62c1b3,0x7205a372,0x71093360,0x338752df}},	//   _diaboliq, _kamisaki_, _رضاگیلان, _iperiu_,
   {{0x82662275,0x9c855095,0xeb7e6390,0x62dea023}},	//   _ئىملا_, _depended_, _aafrikaa_, _alfoonu_,
   {{0x827ed317,0x67a90031,0x727e948e,0x3f7d20f8}},	//   _hienn_, _የምክርና_, _dianc_, _aktivlaş,
   {{0x52a7f4d6,0xfa521018,0xa27e6171,0x9a81c0f4}},	// [d70] _stube_, _inseamna_, _jioni_, _فىقھى_,
   {{0x82a69086,0x5d0ea07e,0xe26ce368,0xc86af050}},	//   _fraba_, _otroligt_, _lanona_, _一個外報老總眼中,
   {{0xe8d96026,0xe249f209,0xd69a0263,0x82b0e06c}},	//   _해외부동산_, _amuma_, _хатарнок, _रहथुआ_,
   {{0x727ee447,0xa548f0d7,0x920120f3,0xe291b30f}},	//   _toinen_, _ватандаш, _decisi_, _dewata_,
   {{0x82000206,0x51c77083,0x2c67c0c7,0x1c7e6580}},	//   _aliis_, _شايتان_, _کرتان_, _efesofo_,
   {{0xb395e07e,0xc0ec01b1,0xa9584248,0x02d8c14b}},	//   _satsa_, _radikaal, _ተኣሚኖም_, _humeur_,
   {{0x5349f338,0x3ed6b20f,0x53f82339,0x52a69115}},	//   _spremni_, _radiosun, _nekur_, _craba_,
   {{0xbcf9e059,0x208b64b6,0x53958063,0x0c7460fb}},	//   _ሊያስፋፉት_, _tuscaloo, _narsa_, _शास्ता_,
   {{0xb27e0269,0xe395e0fb,0x927ed152,0x34750097}},	//   _niini_, _vatsa_, _hieno_, _filtypen_,
   {{0x26f6c09a,0x1d874205,0xf395e01f,0x32a602e2}},	//   _تارانچى_, _aqueduct_, _watsa_, _tribi_,
   {{0x2332f01a,0xf42ef1bf,0xd7915180,0xb9db61d8}},	//   _deixar_, _епископи, _produktg, _panginte,
   {{0x9695649f,0x4ee7e102,0xac794231,0x393663e4}},	//   _especiai, _правові_, _चित्तौडग, _alamagot,
   {{0x3ea40101,0x9b841005,0x720022aa,0xe316e354}},	//   _balthide_, _апроч_, _bokin_, _venzin_,
   {{0x72b5f163,0x53f45051,0xd3207067,0xf30290ae}},	//   _cauca_, _mettle_, _konye_, _musayev_,
   {{0x0bed31f7,0xfffa22ae,0x2fdb7031,0x267a210e}},	//   _министры_, _elektroo, _ከተካሄደ_, _elektrow,
   {{0x92efc30d,0x630cb0f6,0x8349511e,0x93e652f6}},	//   _familja_, _hasabat_, _gamedev_, _paruwasi_,
   {{0xf27e9100,0x63f453f4,0xb83af031,0xe51870db}},	// [d80] _niana_, _nettle_, _ልጠይቅህ_, _тартынма,
   {{0x218622bc,0x748972d1,0x832792b5,0xeb25a0fc}},	//   _економік, _جولانه_, _precast_, _булалыр_,
   {{0x5ec231da,0xa3b26064,0x0a20c192,0x7b51f230}},	//   _abanywan, _marque_, _темпы_, _meidwaan_,
   {{0x6cf1f2bf,0x3f2fe18a,0xc200f089,0x1d5800fc}},	//   _agaterer, _corespun, _bogie_, _сәсле_,
   {{0xc8c840ad,0xa888d041,0xc42be12a,0xf2a6621f}},	//   _flutning, _isikhund, _vocabulo_, _arobu_,
   {{0xf5628026,0xcf01c278,0x42b7f20f,0xd024d5b1}},	//   _때문입니다_, _isipité_, _bareldən_, _ﺋﯩﻠﮕﯩﺮﻟﻪ,
   {{0x727ef1e0,0xfcbd315f,0xd35bf37e,0xa3bb604c}},	//   _signa_, _nguinnaq, _tangana_, _کارخانجا,
   {{0x6e1871a1,0x12914071,0x127f4128,0xd2912141}},	//   _assescla, _freark_, _drench_, _argaç_,
   {{0xa720a25a,0x22cac010,0x4dcf32f2,0x31695043}},	//   _diversaj_, _gilded_, _funksiya, _itsensä_,
   {{0xa27ef3ff,0xeb4375b2,0x02f1e340,0x53488238}},	//   _vigna_, _thicknes, _parinti_, _direizh_,
   {{0xbfa172c1,0xe9be339b,0x7c14115e,0x4a96b583}},	//   _aksesuar_, _afidafit, _segurtas, _सन्मान_,
   {{0x724670aa,0x727ed28c,0x72d83081,0x71d4227b}},	//   _yémen_, _vieno_, _rejet_, _जन्मभूमि_,
   {{0x1395e043,0x32d8a217,0x1b4b6248,0x5e7fe113}},	//   _katso_, _kebek_, _ኣጠማምታ_, _psiholoģ,
   {{0xee472513,0x5af6f437,0xa841f003,0xcbdfc0e9}},	//   _localida, _sterkast, _avaldatu, _амодель_,
   {{0x366721e2,0x89fe710e,0x7c5bf0ce,0xd18a503b}},	//   _артиши_, _चैम्पियन_, _tartani_, _asabalal,
   {{0x63f4011b,0xe26065b3,0xd34d1086,0x62e8e0ae}},	//   _sastav_, _økonomi_, _alterum_, _polisin_,
   {{0xa3f82079,0x9200201d,0xa5452041,0xa036e345}},	// [d90] _sekur_, _tokin_, _abakwibh, _कराही_,
   {{0x127ed0c8,0x696bb088,0x0d8b921c,0xb2004019}},	//   _pieno_, _menikmat, _akkolita, _romia_,
   {{0xf2d982ef,0x129003e7,0x6f5d40ae,0xf30c0024}},	//   _leren_, _tombeaux_, _hesablan, _amanāpāṃ_,
   {{0xf23871fc,0x2ecf5075,0xbac102fd,0x38c375b4}},	//   _adimani_, _digitaln, _بۆندی_, _aumentad,
   {{0xa2d8a2c1,0x2e3a339e,0x9863c434,0x0a8022e2}},	//   _bebek_, _amparasa, _покажи_, _atansyon_,
   {{0x2b00a0fb,0x520090f0,0x927ff126,0xfc7fb20e}},	//   _गुरुवासर, _clair_, _youns_, _existem_,
   {{0x7016301a,0x825ad11e,0xf250d25d,0x130761c5}},	//   _нарында_, _follar_, _enterrem, _aalburg_,
   {{0xb83e15b5,0x026d90de,0xe3eae266,0xa386e2b2}},	//   _битка_, _ossos_, _faitoo_, _kufru_,
   {{0xe2012086,0x62ca91ca,0x2302b03b,0x7ef0d128}},	//   _socios_, _umada_, _akubone_, _bickerin,
   {{0x03d140e5,0x72d980f5,0xe6cf723c,0x1c759284}},	//   _मध्यप्रद, _deren_, _управляв, _adducer_,
   {{0xa200401f,0x5e563198,0xb195c21a,0x1df0906a}},	//   _domin_, _настани_, _членам_, _diajarka,
   {{0xd321e101,0xdc1ec1c7,0xed7c107e,0xa5f5148f}},	//   _metye_, _бюджетін, _sammanfa, _lideranç,
   {{0xa4ddf050,0xd58773ab,0x6c61a010,0xbe9ec251}},	//   _最佳分辨率_, _autorský, _hurried_, _павле_,
   {{0x7b5ba42a,0x8d78417a,0x535bf438,0xbd174309}},	//   _algemeen_, _বাহিৰেও_, _nangona_, _anglahbe_,
   {{0x3d3c35b6,0x726d0047,0xa6d9c1a9,0x4c61a11b}},	//   _फ्रॉम_, _kabona_, _рамаллад, _nagrade_,
   {{0x52d980a8,0x8cc27063,0x72d831c2,0x2f8d8083}},	//   _beren_, _عبدالودو, _tejer_, _грузияда_,
   {{0xdb05b07d,0x4645308a,0xe27ef406,0x651ec3ee}},	// [da0] _bakgraon_, _abakwisi, _ligno_, _abalaziy,
   {{0xd27ed23c,0x920041c4,0xda16113f,0x6c5c7071}},	//   _viene_, _comin_, _purchase, _doutzen_,
   {{0xe27ed521,0x939890bf,0x2a0652f2,0x169e81e6}},	//   _wiene_, _талаблар, _adamları_, _bahuvidh,
   {{0xb27ed0cc,0x6aa7a2d7,0x20dd2030,0xab912264}},	//   _tiene_, _maikarab, _طیاره_, _الشئون_,
   {{0xd2d85300,0x086dd0d6,0xdaa54203,0x0c9332fd}},	//   _welet_, _liziband, _ennyanja_, _داماو_,
   {{0x33f840f9,0xe04b5525,0x927e638b,0xc6c63205}},	//   _kemur_, _reprezan, _khong_, _blissful_,
   {{0x6faeb17d,0x7b3fb38f,0xe0e8f3b0,0x92f05030}},	//   _совершен, _beschikb, _oprindel, _kelishi_,
   {{0x1413912f,0x6c0da54e,0x5387f0f0,0x72d8e123}},	//   _ﭼﻮﯕﻠﯘﻏﻰ_, _bagpipe_, _outre_, _defet_,
   {{0x82a690da,0x126cf2aa,0xcb9dc418,0xf27790d2}},	//   _arabu_, _rahona_, _abenakho_, _банкты_,
   {{0xe2d8c1b0,0x4a18f126,0x82e3a00a,0xd2eff38d}},	//   _sedem_, _gamboula_, _arrived_, _annisaa_,
   {{0x827e00a9,0xa3f1b0db,0x92d853c4,0x1d3cf223}},	//   _shina_, _matsatsi_, _deles_, _mwanamke_,
   {{0xc3f7102a,0x1f9ba0ac,0x9c04706e,0x33eae121}},	//   _seizing_, _ongeveer_, _konsili_, _viited_,
   {{0x22d851fd,0x817c205e,0xa37fd4c7,0x63c783d0}},	//   _neler_, _angangal, _oslanja_, _группын_,
   {{0x08c753a5,0x7379f24a,0x164013a5,0xbdc4b2fc}},	//   _abatheng, _televyzj, _afundisw, _odlikuje_,
   {{0xb2fcd4d7,0x0cad70fc,0xe2c4a078,0xfda3f156}},	//   _mbega_, _газетаһы_, _aisling_, _формира_,
   {{0x927e0413,0xbcb7551d,0x727ed0f3,0x42d73352}},	//   _thina_, _پاراست_, _piene_, _دکارن_,
   {{0x2a1ec094,0x5d76d24c,0x85eed229,0x73877089}},	// [db0] _миний_, _ترانا_, _апартаме, _scarce_,
   {{0x97bbf15f,0x73167193,0xc3f84030,0xf29272bd}},	//   _guulumik_, _lanze_, _temur_, _assaad_,
   {{0x320e10d2,0x327f448b,0xb2a6d2f4,0x724fa287}},	//   _карап_, _ebenim_, _greba_, _perdavim,
   {{0xe82cd30d,0xbc75e2ee,0xa0f46135,0x2342721c}},	//   _སྒྲིལ_, _hukumar_, _ዘይንቡር_, _pradeep_,
   {{0x7ef1d275,0xb2d8501b,0x8e4f506b,0xe884206a}},	//   _исламий_, _geler_, _angapala, _वेबसाइटव,
   {{0x479270ac,0x16b3a0ac,0x02fd43ce,0x127ef089}},	//   _개인예약대기_, _사용하거나_, _pogings_, _brinch_,
   {{0x6505544f,0x53dcb231,0x8ecf91de,0x2b5cb290}},	//   _enquanto_, _kosmetyk, _socijaln, _kosmetyc,
   {{0xaafd4341,0xfb2f81bf,0xb3c87180,0x23f991df}},	//   _usergale, _историче_, _farver_, _jesuo_,
   {{0x3e45d293,0x8290e395,0xc22ac1e2,0x427e019d}},	//   _bagaraga, _ahiade_, _додан_, _bhinn_,
   {{0x527e0106,0x72a69291,0x82d850cd,0xc200213a}},	//   _chinn_, _prabu_, _deler_, _bokis_,
   {{0xd344b186,0xe1b0e230,0x8246d004,0x5345b30f}},	//   _murenge_, _riemersm, _afiliasi_, _serdadu_,
   {{0x2f6a1087,0xc2fcd0f0,0x7f903061,0x427ea44d}},	//   _absalons_, _longue_, _طنزيه_, _tajnik_,
   {{0x979430f7,0x6291e2e9,0xc2917267,0x02c20209}},	//   _公众用户组_, _avtah_, _amaala_, _ngalaba_,
   {{0x724a7538,0x99a2b0be,0x3400c3aa,0x6f53c410}},	//   _vermek_, _perjasht, _नामदेव_, _моабли_,
   {{0x9e4a4083,0xb2d8c300,0x7c537044,0x546a01df}},	//   _кореялык_, _redek_, _poutama_, _televido_,
   {{0x7ac29276,0x629030c7,0xa1dc13d0,0xc27ff16c}},	//   _عبدالقدي, _ilmaha_, _клубт_, _founi_,
   {{0xae45d37a,0x22d8c4ec,0xc9a5e141,0x62fbc199}},	// [dc0] _yagaraga, _yedek_, _алдаҗак_, _bychain_,
   {{0x42d87113,0xe3584195,0xb25f8221,0x21d85443}},	//   _nenes_, _akagule_, _athunyel, _aramirô_,
   {{0x9e83848c,0x12a69581,0x927ef11c,0x3bd462f3}},	//   _akawanye_, _nsaba_, _aigne_, _федералн,
   {{0x81a5c0a1,0x154b0248,0xc2a69098,0x774c7116}},	//   _danzapä_, _ዝተቐመጠ_, _isaba_, _वेबहोस्ट,
   {{0xca75113e,0xc9fb60ce,0xa0398105,0xc5bbf434}},	//   _अनुनाद_, _ellentét, _פֿלײש_, _акценти_,
   {{0x22d6c24a,0xda1be031,0x9e7d00f2,0xa2071214}},	//   _spilers_, _መድረሳቸውን_, _फिस्स_, _футболшы,
   {{0xc75e1121,0x631922cb,0x492190b5,0x03e111d8}},	//   _कम्पनियन_, _بيتاب_, _ءەلميرا_, _ngalakuk,
   {{0x946e2064,0x97a373c1,0x56c35065,0xe782d0c3}},	//   _国家税务总局关于, _kundserv, _biosynth, _privatni,
   {{0x103a830d,0x7c6d8327,0x0683f180,0x52dde1bf}},	//   _attenzjo, _akirika_, _ウェブリブログ_, _datorii_,
   {{0xf2da75b7,0x32fcd086,0x13f8f4d5,0x22a69581}},	//   _skreiv_, _congue_, _regul_, _osaba_,
   {{0x62d9f0dd,0x028c7213,0x52b213dd,0x9413d2d1}},	//   _dienste_, _anakawa_, _vladika_, _سازدا_,
   {{0x193af172,0x9387809c,0x3c60048f,0xa3800238}},	//   _abelanwa_, _turre_, _известув, _barrez_,
   {{0x0459e248,0x02fd3301,0x5320701e,0x0ba690df}},	//   _ካርቱምን_, _podnety_, _wonya_, _ackyardb,
   {{0xe2fe6075,0xb061304b,0x1ba6017b,0xa31601d6}},	//   _drugih_, _بندرا_, _اناعۇرلى, _ayibeki_,
   {{0xc909c05a,0x2c1a314f,0xb5bee0c9,0x9365635d}},	//   _келатат_, _bharatas, _останніх_, _aragón_,
   {{0x527ed13f,0x723dd2f7,0x5c5300c3,0x70dc1227}},	//   _phones_, _бөлүмини, _gostima_, _무료가입시_,
   {{0x53ebf253,0x2bca10c9,0x32a66077,0x0c5570db}},	// [dd0] _aputu_, _продовжи, _arobi_, _bultswe_,
   {{0x0f6e40fb,0xee447101,0x5cd7201c,0xb9ecb1df}},	//   _राष्ट्रं_, _konsolid_, _وعیال_, _skribita_,
   {{0x457740d3,0x377c50c8,0x28b7447e,0xe30ee054}},	//   _destinaz, _кантакты_, _destinav, _ziyarar_,
   {{0xa7bbe20e,0xaa33e0f7,0x830ee054,0x92d87317}},	//   _останати, _请作者在两周内速, _siyasar_, _renet_,
   {{0x783c3341,0x9a1ec09a,0x5656a200,0x9313d03c}},	//   _maimonid, _билиг_, _isthaphi, _mancava_,
   {{0x727ed30b,0x62d3622f,0x42d850b3,0xca90f4f7}},	//   _diena_, _pomoći_, _belep_, _thunderb,
   {{0x3ece1431,0x139d204c,0xd29033e2,0x1ea8e29d}},	//   _environn, _کتابچه_, _domaca_, _justysje_,
   {{0x32cb7356,0xe2bb01d5,0x2072b591,0x79f3f47e}},	//   _obadia_, _pametne_, _ababegxo, _apareigu,
   {{0xc2d8705a,0x703b504d,0xa2d873c7,0x95877271}},	//   _gener_, _congleto, _tenes_, _autorské,
   {{0xee2c8243,0x399d21bc,0xa15bf1a5,0x33ac62ea}},	//   _pengemba, _калып_, _abagaqel, _trupin_,
   {{0x12d9c38f,0xf2fcd0ef,0x23f8f086,0x82d871a7}},	//   _leven_, _mbegu_, _regum_, _renes_,
   {{0x9292601e,0xd3ff216e,0xcee7b074,0xaf1f326d}},	//   _aduasa_, _planinsk, _dashurin, _belegwen,
   {{0x9535a105,0xe85e1335,0xa2f3f368,0xc382c2a7}},	//   _הויעך_, _scolaziu, _dediket_, _یاشلا_,
   {{0xf2004053,0x18f5c28b,0x9590e11c,0x259a2251}},	//   _somit_, _ferantwu, _litearth, _поголемо_,
   {{0x3395e308,0x93ebf00c,0xae8c10af,0xd2d8502d}},	//   _katsa_, _uputu_, _ウェブ検索_, _celex_,
   {{0xd2caf5b8,0xec1743d5,0xec883043,0x916ad0bb}},	//   _pridal_, _balanser, _теории_, _acintosh_,
   {{0x541e6263,0xb27f0440,0x020044aa,0xb286c207}},	// [de0] _транзити_, _agangi_, _fomir_, _ingiliz_,
   {{0xd2a661de,0x92d9c23f,0xfcad341d,0x75bd42e9}},	//   _osobe_, _deven_, _میراموبا, _bopabtah,
   {{0x636931db,0xb27f72fe,0x7c0260dd,0xb291724f}},	//   _mangler_, _vyanje_, _aussies_, _ilaasa_,
   {{0x72d8726f,0x3c14013f,0x02d981bd,0x0453e248}},	//   _bener_, _ברצינות_, _herec_, _ትምህርቲን_,
   {{0x09f73437,0xa2fbe24a,0xb78495b9,0x4291700c}},	//   _samanset, _kolleezj, _ईश्वरी_, _alaata_,
   {{0xb2d6d01d,0xd2a6d2af,0x25387015,0xe25ab230}},	//   _schluss_, _tsebe_, _aanikush, _fielde_,
   {{0x4389109c,0xd2d9c15b,0x927e0211,0x02d0230a}},	//   _waayeen_, _heven_, _ahine_, _angoram_,
   {{0x19b09096,0xed56a121,0x1807e183,0x9fb1c0af}},	//   _پیدائش_, _बांगला_, _barbaric_, _すべてのカスタマ_,
   {{0xe27ff13f,0xd37b73e8,0xb7eca05e,0x78de0330}},	//   _mount_, _entanto_, _halamang, _深圳海上田园酒店,
   {{0x192850d2,0x65769196,0x105f31f5,0x525b0003}},	//   _партиясы, _минутын_, _عمارت_, _avalik_,
   {{0xf317106d,0x893fd31d,0x9300f0e0,0x435bf256}},	//   _snazzy_, _alemanya_, _aagaami_, _kangana_,
   {{0x721c041a,0x739671d8,0x137b7229,0x6d503072}},	//   _århus_, _narsis_, _intanto_, _зборник_,
   {{0xc2d9c026,0x1d08b128,0x9b66e10b,0xded1313f}},	//   _geven_, _desolate_, _acererwa_, _channels_,
   {{0x127ed2ab,0x535bf37e,0xa2d5f159,0xc73a72f7}},	//   _vieni_, _langana_, _amelyet_, _мәһкимис,
   {{0xa8dd1030,0x97ecd2fa,0xc2d870cb,0x5ae882ac}},	//   _бишкекда_, _achasang, _wener_, _دوواتر_,
   {{0xf27ed1c6,0x615e03eb,0x693bc5ba,0x85fbc370}},	//   _tieni_, _morgunbl, _abamenye, _abamenyi,
   {{0xdc7a31e5,0x6eb590f1,0x8056b062,0x931960de}},	// [df0] _дилейарл, _redusert_, _autalavo, _بويدوق_,
   {{0xb2d9c5bb,0xc36b72bc,0xb7c06152,0xb4fbb048}},	//   _veven_, _alterskj, _vieraski, _चुहावट_,
   {{0x527ef095,0xb35bf4d7,0xa73350ee,0x52da4169}},	//   _shines_, _bangana_, _absolvov, _nawell_,
   {{0xaf8990c8,0xc61dc0de,0xc5c89225,0x9467a1bf}},	//   _народнаг, _اتكەزچى_, _нареднат, _медикале_,
   {{0x237a6013,0xccc7934e,0xe3164093,0xe48ed0ee}},	//   _rebaño_, _маликшо_, _membeli_, _nefunguj,
   {{0xa2d8a161,0x7a7f0026,0x13f40522,0x60735264}},	//   _jebes_, _입주가능일_, _nastav_, _محادثات_,
   {{0x2410314e,0x825af24f,0x7ebc1082,0x2bec64c7}},	//   _নামহীণ_, _biilit_, _lotedels_, _dinamičk,
   {{0xa6ac8088,0x76818597,0x7fdae0de,0xe2a6921c}},	//   _mengambi, _कैलाश_, _اتچۇۇ_, _drabi_,
   {{0xf2d9c00a,0x78e9f2bc,0x13c5816e,0xdea5a1fa}},	//   _level_, _leksikog, _турнира_, _atiluvan,
   {{0x4c53503c,0x7061c030,0xe2d9819e,0x026c63ce}},	//   _lettura_, _مناره_, _herea_, _spoor_,
   {{0x12d982df,0x04a100de,0xf282800e,0xc9e9507d}},	//   _kerea_, _اسمانداع, _şahidi_, _kongrige,
   {{0xb373c0c4,0xf2ba7137,0x8184d23e,0x2c68a421}},	//   _ruhande_, _sandali_, _abaabiil, _albudii_,
   {{0xe2d9e135,0xb2009151,0xb7c4e198,0x7d7a3326}},	//   _jeten_, _hlais_, _acessibi, _bahlelwe_,
   {{0x3c71d0a6,0x59e79327,0x0e96c09a,0x87a2f41c}},	//   _माल्टा_, _adegboye, _مىتىر_, _сейфулли,
   {{0x1386d21c,0x7200b1df,0xf2924437,0xe2908012}},	//   _enormi_, _socia_, _sawant_, _athari_,
   {{0x327e634e,0x2bf01443,0x2dab7030,0xb37fc0f9}},	//   _khona_, _vicerrec, _سعیدین_, _almanna_,
   {{0x5de970cc,0xe394e5bc,0x22d9e007,0x2741348f}},	// [e00] _সপ্তাহে_, _ahisha_, _neten_, _источна_,
   {{0xb27ed30b,0x227e02c0,0x5f552005,0x027ef567}},	//   _dienu_, _mbind_, _становіш, _digni_,
   {{0x64dee290,0x625b72bd,0x69e2f181,0x8e1102a0}},	//   _प्रयासों_, _mmalwa_, _kuboneka_, _سکاڵا_,
   {{0x62d9e15b,0x031770ed,0xad79a365,0xce0ed157}},	//   _beten_, _amazwe_, _submerge_, _terengga,
   {{0xb27e023b,0x994e817d,0xc7bd8168,0x484e8358}},	//   _baini_, _mielipit, _beveilig, _mielipid,
   {{0xf2d6c109,0xf26d62fc,0x8d4aa05f,0x2b950282}},	//   _acilius_, _logoru_, _kanakolu_, _זעהקראפט_,
   {{0x7842b3e3,0x9b9a011e,0x827e6250,0x52073138}},	//   _overpass_, _phonetic, _ahona_, _istinski_,
   {{0x03f9b12a,0xde5062e5,0x663d2162,0x66720180}},	//   _seque_, _financie_, _бармайла_, _料理レシピ_,
   {{0x50e8f2b5,0xb2b38049,0xe4e19048,0x6f3e9073}},	//   _definabl, _fundado_, _राजभण्डा, _naprikla,
   {{0xe3436034,0x227ed03d,0x9d57f3c6,0xf2a6921c}},	//   _livello_, _lient_, _tupapaku_, _trabi_,
   {{0xf26e6083,0x32e212c6,0x1781c336,0x02d983ce}},	//   _girona_, _ordonez_, _esivilai, _berei_,
   {{0x44f4d543,0xe145234b,0x63960369,0xdd0d5191}},	//   _अभिज्ञात_, _мурман_, _cessat_, _borrador,
   {{0x8f2da26a,0x69fa50c8,0xd368c2b5,0xe1e1c226}},	//   _determin, _svarbiau, _tangles_, _ठगहरू_,
   {{0xa2d9e2ed,0x5bec6142,0x1306336f,0x11386031}},	//   _veten_, _dinamičn, _baqosang_, _አንፃራዊ_,
   {{0xb2d9e42a,0xb757c011,0x2a5a21ba,0x737953e6}},	//   _weten_, _даниель_, _санданск, _matamua_,
   {{0x22d732d1,0x2ff6d052,0x8fd58263,0x0abba248}},	//   _تکاره_, _saglabāt, _abanohlo, _ህግዲፍን_,
   {{0x0394e4b1,0xa27ed22d,0x73f4043d,0x931c8178}},	// [e10] _shisha_, _dient_, _testar_, _blicken_,
   {{0xd27ed5bd,0x2c7d623c,0x227f41ce,0xef0460e0}},	//   _vienu_, _последна, _trench_, _advaidhī,
   {{0x22d8a0d7,0x92ca944e,0xebc83443,0x9283e15e}},	//   _seber_, _amadi_, _agaitéra, _ariketa_,
   {{0xe25ae1aa,0xf2d9e0cb,0x263c63e8,0xf38705b2}},	//   _ahilwe_, _metel_, _nacionai, _fabric_,
   {{0xab072443,0xe3284155,0x69eee29a,0x62a7f067}},	//   _comisión_, _аңлиғучи, _sesunggu, _erube_,
   {{0x6a063469,0x4e99a443,0x3fdb2009,0x4d307113}},	//   _camarade, _карпенте, _связано_, _aviobiļe,
   {{0xa387f12e,0x2d69f01b,0x43d36180,0xe95f936f}},	//   _jutro_, _гөркезйә, _超音波振動子_, _connenct,
   {{0x98c8442c,0x934ba0f0,0xb533c23c,0xedb4c166}},	//   _slutning, _entendu_, _доклада_, _antiċipa,
   {{0xa200d0f9,0x7d1d2065,0xd04f424e,0x42cb01bf}},	//   _bleiv_, _קלינשטיי, _استعاره_, _gradul_,
   {{0x050261ba,0xf7e8f038,0xb2d8c2a9,0xa20094d1}},	//   _iscritto_, _कलाकृती_, _jedes_, _enaid_,
   {{0x3e096248,0x23167054,0xd87eb284,0x57128043}},	//   _ንህግድፍ_, _manzo_, _coupones_, _перевест,
   {{0x62374011,0x427f0453,0xa887115e,0x8d8f5096}},	//   _анатолии_, _granth_, _наранд_, _شیکسپیئر_,
   {{0xdf57126e,0xc2e603e4,0xc305a2e2,0x051801ba}},	//   _merginos_, _atanaga_, _jamayik_, _verranno_,
   {{0x827f000a,0xe9fcf1da,0x926e52aa,0x525cd4b5}},	//   _thanks_, _iyandika_, _antoka_, _habeenim,
   {{0x1d9e3075,0x3c06301a,0x7f13a4e7,0xeb6025be}},	//   _baterije_, _майрам_, _bezdarbn, _रोपनी_,
   {{0xe063c057,0x7c6162bf,0x53f8b091,0xcfaf70f7}},	//   _молотов_, _mitumba_, _recur_, _请及时与我们联系_,
   {{0x5e36c489,0x2c7c0281,0x268082ed,0x63f8b12a}},	// [e20] _stravova, _taasina_, _ekzekuti, _secur_,
   {{0x12ce600a,0x22d8c238,0x7951003d,0x927e9043}},	//   _removed_, _pedet_, _abalulut, _ihana_,
   {{0x829462d7,0xd2ca6077,0xdcb6729a,0xe6142057}},	//   _bookami_, _amodu_, _menyelur, _оформаря_,
   {{0xb27e923a,0x82266428,0xb17d42ca,0xa1454083}},	//   _khana_, _verkum_, _اتتىسىنە, _assenyal,
   {{0x727e6493,0xd784e1e0,0x0627813f,0x926e147b}},	//   _bhonn_, _convalli, _inhibiti, _ikpori_,
   {{0x9d8e2148,0xf2d9e07d,0xe3f88127,0x39d9424e}},	//   _bobodora, _letem_, _kukuva_, _دوستتان_,
   {{0x3297d038,0xdd9c20c2,0x227ff0ea,0xd84323ce}},	//   _murasaki_, _bahlanka, _louny_, _stormers_,
   {{0x8a06d064,0x027e935a,0x02e9013d,0x25b91264}},	//   _上一篇文章_, _ohana_, _gorizia_, _فودافون_,
   {{0x8cc061ca,0xf201908f,0xa2d8c053,0x381c501a}},	//   _دیوانگی_, _bosib_, _jeder_, _россияны,
   {{0x135673c2,0xbbbc811b,0x82c7300e,0xa503c096}},	//   _amafuta_, _полицијс, _azalıb_, _امرےکی_,
   {{0xe844a00a,0x960b9329,0x02571012,0xe6c7c2f5}},	//   _listings_, _difendem_, _لاتعلق_, _dedaroei,
   {{0xcc736175,0x827f4228,0x227e9208,0xab6c6251}},	//   _chargos_, _ngendi_, _bhana_, _impressa_,
   {{0x13860161,0xfafca0d9,0xff53d3bf,0x4a78c0db}},	//   _chiri_, _angengis, _домашно_, _иртүк_,
   {{0x0387f0fb,0x12a661cc,0x409e80af,0xd2a2b032}},	//   _putro_, _osobi_, _ポイント獲得_, _berjast_,
   {{0x9da63275,0xe249409c,0xf3dc9373,0x051625b5}},	//   _ۋىروس_, _ademma_, _tajwan_, _научна_,
   {{0xe93f3043,0x03878126,0x831cb110,0x22f9c124}},	//   _kommentt, _kurru_, _blubber_, _анимам_,
   {{0xc9f741cd,0xb7bda2a9,0xd27f70fd,0xcea5a50a}},	// [e30] _samarbet, _beteilig, _avanse_, _grilovan,
   {{0x127e0199,0x9a949085,0xbc52025d,0x2a198079}},	//   _maint_, _অন্তরে_, _abatela_, _caccount,
   {{0xe20ec162,0xb9f2b178,0x2ac935bf,0x1fb1f12f}},	//   _раван_, _startsid, _सुपरहिट_, _ﺋﺎﺭﺗﯘﻕ_,
   {{0xe3860295,0x1b5de160,0x7ec3739c,0x921d714c}},	//   _phiri_, _spriječi, _رەسسام_, _আধ্যাত্ম,
   {{0x00717016,0x4a8681bf,0xf7cd014c,0x4f1822fc}},	//   _norapamo, _диструс_, _স্যরি_, _сестре_,
   {{0x66276262,0x49676262,0x026cc4c3,0x2c5dc031}},	//   _minisiti, _minisite, _raloka_, _የተከታተሉ_,
   {{0x328f6170,0x0a0f61f8,0x1e4f61de,0x33449084}},	//   _stranici_, _stranica_, _stranice_, _adedibu_,
   {{0x8035a49e,0x6ebdd484,0xdf3202d2,0xe6641241}},	//   _santayan, _avenamen, _lieferan, _ындатори,
   {{0x3953c192,0x08db503f,0x3c59f335,0x6d3b703b}},	//   _рының_, _निष्कलंक_, _tratsch_, _andizele_,
   {{0xfd092381,0xe9f7835e,0x13f8d076,0x07afb43f}},	//   _гергиев_, _achakute, _haluku_, _okamžiku_,
   {{0x7387f348,0x7667112e,0x72d8c053,0xda795309}},	//   _autre_, _दिवसीय_, _weder_, _botaghpa_,
   {{0xee4d41db,0x526c3127,0xfe08f165,0x12d9801d}},	//   _forbedre_, _domomu_, _bundesla, _gereu_,
   {{0x125a835f,0x83c871a7,0xb2ebe3c9,0x127e634d}},	//   _okolí_, _carver_, _dominum_, _shong_,
   {{0xe27e62e4,0xa29271b3,0xf596c2f3,0xce55e0fd}},	//   _phong_, _basate_, _имамо_, _sekretè_,
   {{0xc27e00cb,0x56381327,0xb292745b,0xac01f1f2}},	//   _haint_, _arintaki, _casate_, _tekstir_,
   {{0x125ac3ef,0xd2d981fe,0xa9da72ca,0xc27f424a}},	//   _nullam_, _deret_, _castelld, _koenen_,
   {{0xd27d62bd,0x337c205a,0xa68c61e6,0x12d8c0ae}},	// [e40] _балалары_, _vilaweb_, _राजाह_, _qeder_,
   {{0xd04525c0,0xb201a3e3,0x6a741105,0xa29083ba}},	//   _gutungan, _efektivm, _ינקלודז_, _kuhati_,
   {{0xecae739b,0xb50d41f0,0x12926019,0xf676b04c}},	//   _antshang_, _тәртипкә_, _ekrano_, _باتشکر_,
   {{0x270d31bf,0xe6c8b160,0x4ee49155,0xe58280be}},	//   _сакри_, _varaždin, _ﺑﯘﺧﺎﺭﻯ_, _kundersh,
   {{0xcf73e0fb,0xe9a96031,0x12d984e0,0x0bdec295}},	//   _निर्देशः_, _በየክፍለ_, _heret_, _amadalir,
   {{0xf6cf9223,0x4c7562e4,0x66dd3048,0x10561065}},	//   _kubadili, _jxquest_, _provádím, _בבודפשט_,
   {{0x42b0e4a8,0x941d41b3,0xbada00b3,0xd31672f6}},	//   _ग्रुप_, _apparato_, _апрельдә_, _banze_,
   {{0xcd773258,0x72ddd211,0xd7c7d009,0xb7fef180}},	//   _sammisat_, _totongi_, _наличии_, _ショップ評価を見,
   {{0x726cb11d,0x62da629e,0xa6cb9246,0xae5f8339}},	//   _pasipoti_, _moteur_, _talanoai, _velosipē,
   {{0x98bb13db,0x0eb36042,0xfedca369,0x67ba5030}},	//   _minutter_, _tivermos_, _nationes_, _ekologik_,
   {{0x511112c7,0xd9911052,0x7200b0ee,0x3b1b82dd}},	//   _projekty_, _projekta_, _pocit_, _ahlangab,
   {{0xe285c2bd,0xa14223bf,0xc5fa53aa,0xf27ed230}},	//   _bophelo_, _оттам_, _प्रोसेस_, _rienk_,
   {{0x734302c6,0x82cbf05c,0xa197f124,0x320190e5}},	//   _vitello_, _osnovna_, _angapyhy_, _gosia_,
   {{0x33f452e9,0xb47c1172,0xa2d98247,0x94b450e5}},	//   _nettie_, _ditetelo_, _yerel_, _प्रज्ञान_,
   {{0x43167262,0xfdf260f4,0x826333de,0x2c9d1345}},	//   _yanze_, _سەنشىڭ_, _betonski_, _पूर्वांक,
   {{0x116af0be,0x5745c2a3,0x22f7c364,0x621312cd}},	//   _respekto, _ндары_, _acrimuk_, _dachte_,
   {{0xed04d352,0x03f0610e,0xc26c6151,0x727e90db}},	// [e50] _دواهه_, _गोलीबारी_, _npoos_, _ahang_,
   {{0xdd7882f5,0x23ea0220,0x732915c1,0xda10d347}},	//   _adamonit_, _twita_, _provesti_, _infancia_,
   {{0xe261a40c,0x543b7248,0xcc73f123,0x82fb5425}},	//   _grimmjow_, _መንግስትናን_, _konsoma_, _dithata_,
   {{0xf2fd0180,0x72fd31b6,0x29173102,0xad8290af}},	//   _amager_, _ionizer_, _грудень_, _kunderne_,
   {{0x6b64a01d,0x8b228085,0xff31e194,0x27b1e053}},	//   _streiten_, _অধিবেশনে_, _verschwa, _verschwi,
   {{0x57f910b9,0xbd0a1321,0x4b9171a3,0x1c34e060}},	//   _четине_, _amerliar, _thendelo_, _crucifer,
   {{0x02fca039,0x197b0041,0x877392f4,0xb3167374}},	//   _bashong_, _کړیده_, _долларт_, _panze_,
   {{0x22a6d03d,0x027e6074,0x59f954c4,0xb200d4df}},	//   _isebe_, _thone_, _upassend, _vleis_,
   {{0x126c81af,0x29d45231,0x2236923e,0x9200b2ca}},	//   _takoto_, _गरियसि_, _baaje_, _socis_,
   {{0x2d43a198,0x6584c031,0xc52c40f5,0x3200d300}},	//   _можност_, _ለመተካት_, _regelmäß, _gleiz_,
   {{0x63f463c9,0xec93c012,0x42d8e2c1,0x19189227}},	//   _mortem_, _واتان_, _sefer_, _추가자가진단_,
   {{0xd6c7234d,0x98d4b41d,0x42741212,0x638050e8}},	//   _cicadidi, _بناءپر_, _amasekel, _patryk_,
   {{0xe35404d9,0x2c7d6378,0x7200d238,0x92d8c225}},	//   _numerus_, _forseta_, _kleiz_, _sedex_,
   {{0xa2d87317,0x6e522228,0xf76410f5,0xdeaa53f7}},	//   _menez_, _akibatip, _beliebig, _banditis_,
   {{0x12cae0a5,0x22fcd402,0xc76a71a9,0xedd41230}},	//   _hendak_, _songde_, _كىينكى_, _terherne_,
   {{0x6b6d2110,0x8ae87064,0x7df83427,0xcb7dd369}},	//   _hypother, _représen, _женски_, _todoterr,
   {{0x20f090cc,0x5aff6180,0xd37f822c,0x4200443a}},	// [e60] _সংযোজন_, _overveje, _agiagia_, _himig_,
   {{0x727e918b,0x222ad443,0xde2892bd,0x421c63ac}},	//   _phang_, _нодар_, _райондар, _harhan_,
   {{0x025a13f2,0x5d62e1b5,0x1c5d123c,0x835bd256}},	//   _yehle_, _ادامي_, _postato_, _bongera_,
   {{0xb11440cc,0x2ad8810f,0x685ff078,0x5236052d}},	//   _স্থানীয়_, _تبادلے_, _bunachar_, _aziji_,
   {{0xac26906a,0x3673201a,0xb4e8b20e,0x756c048f}},	//   _भविष्यात_, _كىرگىزىپ_, _планиран, _laborató,
   {{0xb27e9320,0xbea1521c,0x327e0205,0xfb188248}},	//   _thang_, _fallimen, _haink_, _ተዘርዚሩ_,
   {{0x877f70c2,0x62c87138,0xa86bb1c6,0xc20672df}},	//   _спортсыл, _komadić_, _dawnlowd, _rakiraki_,
   {{0xcb9c211c,0x71f96157,0x4eac1105,0x5ff96031}},	//   _digiteac, _hurairah_, _תּהילים_, _እነዚሁም_,
   {{0xd2d8138b,0xa7dd80f7,0x4ae1f049,0x162cc043}},	//   _nghen_, _红股上市交易日_, _referirs, _потребле,
   {{0xe25643c7,0x72d98008,0xc25a53ec,0x0d043248}},	//   _সংখ্যা_, _gerek_, _wella_, _ዘመተታት_,
   {{0x524a6262,0xd3eae0dc,0x3da47210,0xf35bd181}},	//   _ubumwe_, _contes_, _orkingwa, _yongera_,
   {{0x1387f049,0x4cfbf205,0xe2fdf30d,0xa3fcd44b}},	//   _outra_, _indented_, _baugh_, _motortek,
   {{0x6036c0d7,0xf26c80c6,0xff209088,0x1277c2f6}},	//   _планлашт, _dakoro_, _penulisa, _indishyi_,
   {{0xdea411c8,0x53877030,0xe3728453,0xf508e510}},	//   _hundreds_, _agarda_, _tatareg_, _agattako_,
   {{0xfa3d8059,0x3387f027,0xe288e04d,0x7d0d227f}},	//   _አይዘነጋም_, _autra_, _peckham_, _سزادانی_,
   {{0x478ee1b5,0xb795155b,0x0178c0f7,0x56d60212}},	//   _органның_, _testberi, _工商行政管理部门, _دالمان_,
   {{0x46d305c2,0x735e9041,0x80f3b105,0x7215c061}},	// [e70] _ध्यानाकर, _abafaki_, _ראחוב_, _روپئي_,
   {{0x537fd0c7,0xc373e15f,0x22d9e029,0xada7900f}},	//   _calanka_, _uyarangm, _teteh_, _askinsta,
   {{0x3a835414,0xd07030ce,0x5d5ac005,0x72dab2c6}},	//   _brandenb, _hivatalo, _колер_, _fornace_,
   {{0x6fdd042f,0xb3f40191,0x2373711e,0x38883381}},	//   _undiagno, _hestar_, _lemaire_, _аграждан,
   {{0xa93b5248,0x4c0810f0,0x43167262,0xe35bf12d}},	//   _ዝከኣሎም_, _fourniss, _manza_, _mangina_,
   {{0x9b38d0c9,0xf2d91079,0x32d870f0,0x3316735d}},	//   _процесуа, _dezer_, _venez_, _lanza_,
   {{0xf68cb2d7,0xcb18a2a7,0x33e6c34e,0x29c761bc}},	//   _bafetofi, _радиолар, _кадрҳо_, _بئزاشقان,
   {{0x66b5020f,0x99d0c1ba,0x8f3505c3,0x37fcc034}},	//   _reportaj_, _тенис_, _reportar_, _влага_,
   {{0xe7bd227a,0x846f91e6,0x53f832df,0xd2e61041}},	//   _poplatok_, _अन्यॊन्य, _cumuta_, _abanika_,
   {{0xa1f7a0e8,0x7b57802f,0xe2d8138b,0x02a4847c}},	//   _programy_, _اختلافات, _ngheo_, _beskydy_,
   {{0xc27ee3b0,0x4c7eb078,0xe959b49f,0xc83150db}},	//   _kvinde_, _taistil_, _aproveit, _иттифағы_,
   {{0x6909c217,0xfc57417d,0x968ee2eb,0xfd59c1d9}},	//   _темага_, _интересы_, _irreligi, _файлдард,
   {{0xe25a51a2,0x427e011d,0x77e3c263,0x527ed2fa}},	//   _kello_, _kaini_, _кобили_, _chena_,
   {{0x22d4701b,0x07df3248,0x3f2630ac,0x7956c174}},	//   _serdar_, _ብምውካል_, _생활의지혜_, _прихода_,
   {{0x86bc6543,0x6fdbf128,0xadb7f257,0x2d4fa180}},	//   _सत्तर_, _botherso, _rusiyada, _ごめんなさい_,
   {{0x9387400e,0x3670439a,0x60d1f340,0xf40952b2}},	//   _enerji_, _परिचर्चा_, _instituţ, _seminark,
   {{0xa967420d,0x1732d5c4,0xeae6e3b0,0x9af7d01a}},	// [e80] _kalitate, _nezodpov, _sektione, _кажети_,
   {{0x5fae2019,0x23f40378,0x92d8c012,0x800ef2c4}},	//   _שווייץ_, _gestir_, _kuleta_, _चिंताजनक_,
   {{0x927c641a,0x92d982f8,0x8f9a55c5,0x03ad51d0}},	//   _forskell, _kerei_, _producir_, _mypathtv_,
   {{0x49943018,0x120263c8,0x42009407,0xc4df313e}},	//   _детермин, _scribo_, _noait_, _प्रयोगों_,
   {{0xa27e935a,0x6587c25b,0x6cac1180,0xc80c0050}},	//   _uhane_, _landsroy, _携帯でチェック_, _一個完全手工楯接,
   {{0x22c9f3ab,0x786fc0fb,0x66dc406c,0x42d941a0}},	//   _nakonec_, _परिवर्जय, _लिखिह_, _kadets_,
   {{0x220044b5,0x0b183041,0x23daf213,0x02f1657a}},	//   _yimid_, _yengenis, _khatatix_, _अग्रज_,
   {{0xb236d333,0x527f9079,0x7c02214c,0x0e63f3bf}},	//   _svojem_, _kisna_, _টাট্টুহর, _riscalda,
   {{0x82d8e0f0,0xf1520020,0x321c71ee,0xcd291008}},	//   _effet_, _obalglay_, _bishwe_, _ислән_,
   {{0x185c1340,0xb90f5403,0xa529b357,0x13ea70c6}},	//   _romanesc_, _angamalu, _eckingch, _tintimii_,
   {{0x03207045,0x7413227f,0xb22a10b3,0x09d00065}},	//   _ennyo_, _داودی_, _сорап_, _מצטרפת_,
   {{0xf2b504d2,0xb3205123,0xf388327f,0x81036124}},	//   _cracow_, _milye_, _رزیمه_, _германиа,
   {{0xbf3df244,0x8527e15a,0x5b5c5082,0x568b1360}},	//   _asirjama, _सरफ़ेस_, _miedeton_, _کھٹمنڈو_,
   {{0x55583031,0x39eed196,0x73f40238,0x66a971e2}},	//   _ያሳየናል_, _dirulagu, _gostez_, _тақаллуб,
   {{0xda9f23ab,0x72da605a,0x327ff06b,0x025ae043}},	//   _povinnos, _esports_, _anunu_, _niille_,
   {{0x60778019,0x5fd72019,0x6279a149,0xb346d0c9}},	//   _מערבֿ_, _דיסקרימי, _aposetol, _kundens_,
   {{0xb2a630e6,0x82d9c225,0xcc690389,0x50a77180}},	// [e90] _membru_, _devem_, _sauraro_, _最も参考になった,
   {{0x826e611b,0x942cc288,0xed388548,0x327ed02a}},	//   _naroda_, _ягона_, _ватикану, _chenn_,
   {{0x8cd820a2,0xabf800d2,0x4c7580e5,0xa3445086}},	//   _ubukhulu_, _بولموق_, _योद्धा_, _necesse_,
   {{0xd3657100,0xa4d7901a,0xf5257369,0x428fd16d}},	//   _virgina_, _баласын_, _virginal_, _rockhal_,
   {{0xcc57e0b5,0x727e9047,0xd943402a,0x85584221}},	//   _тарихы_, _baani_, _approver_, _abakhuph,
   {{0xc27711f7,0x8e0300e0,0xf26db127,0x1b82733c}},	//   _сарман_, _narendra, _davoca_, _کوتاریشل,
   {{0x6782f0e5,0x4970e558,0x67a521b3,0xde5aa116}},	//   _फ्रान्सि, _policajt, _adressav, _गद्गदा_,
   {{0x54d744f0,0x09c0c043,0x5ab23024,0xfc33f0e4}},	//   _मामिला_, _tekemise, _anavarat, _lemauric,
   {{0x127ed29e,0x2424d22e,0xf554e041,0x0573744b}},	//   _liens_, _kufstein_, _akukhath, _hantverk,
   {{0xfd7182a7,0x50e4716f,0x6dabb015,0xe719412f}},	//   _کریستوفر_, _חארוני_, _achinapa, _микробин,
   {{0x2a4680e0,0x8349924a,0x3cb911af,0x732bc5c6}},	//   _devendra_, _akademy_, _papakupu_, _richtung_,
   {{0x83860089,0x30b06159,0x40e5d5c7,0xf27c6169}},	//   _chirp_, _filmtabl, _धरणीधर_, _firstell,
   {{0x62d9c238,0x2a2fb083,0xe27e92cb,0x2200024f}},	//   _sevel_, _دوكىلات_, _yaani_, _iniit_,
   {{0xe20e120d,0xce85f008,0xcc6dc0ea,0x1b8d80a2}},	//   _хасах_, _тургут_, _chrudim_, _abandayo_,
   {{0x03ea70b5,0xa2caf143,0xa27ed339,0x327e6219}},	//   _ءتوزىمدى_, _alalisi_, _sienu_, _laont_,
   {{0x90632124,0x02d8e00a,0xf39e111b,0x495be333}},	//   _воронов_, _offer_, _osvajanj, _znanstve,
   {{0x6ed4000b,0x2a3095c8,0x6ab900af,0xc27ed0f0}},	// [ea0] _nalingin, _आयोजक_, _陽気なギャングが, _vient_,
   {{0xa28e25c9,0x3024c0b5,0xa57d7401,0x4241f12f}},	//   _miskiin_, _алдымен_, _bainistí, _ﺩﻩﭘﺘﯘ_,
   {{0xc27ed0b2,0xb9f2402f,0xb9fef1fa,0x968dd1c5}},	//   _giens_, _سمدلاسه_, _ankhensa_, _dagebagi,
   {{0xb28ba364,0xa2019329,0x395871d0,0x829032f8}},	//   _binaadam, _bosim_, _ultravnc_, _tomana_,
   {{0xb7b782e8,0xc26e60d8,0xe84fd19a,0x51ced3dd}},	//   _tairisci, _baroda_, _etholiad, _novoform,
   {{0xbc7f223c,0xf42cd30e,0x631ad124,0x69bdc072}},	//   _possono_, _बेखबर_, _апрефект_, _шампиона_,
   {{0xb6083013,0x5e7342a4,0xbf107050,0xb38662f1}},	//   _geografí, _तीर्थ_, _可以向人民法院提, _akora_,
   {{0xe55150e7,0x927ed0a3,0x927e9110,0xc2e3f2b8}},	//   _dzikhuvh, _diens_, _ubang_, _mediese_,
   {{0xb615d32f,0x9639c0ca,0x927e9121,0x22d9e01c}},	//   _руминия_, _aghamarṣ, _taani_, _hetet_,
   {{0x92a6d2bd,0x250e50e5,0xe20e244c,0xdea84097}},	//   _tseba_, _कारणात्म, _хацар_, _kritiske_,
   {{0xf4b5c074,0xa2fd23e1,0xb22a11d9,0x5f9a85ca}},	//   _parashik, _solider_, _торап_, _traducir_,
   {{0x838703ad,0x627ed5cb,0xe99bd3c8,0x3b7cd474}},	//   _daarop_, _ohene_, _cookieme, _automotr,
   {{0x3c96b019,0x1c6b4290,0x125a307e,0xd2d470be}},	//   _מייקראסא, _खात्मा_, _mejla_, _perdor_,
   {{0x2386637e,0xf2266097,0xd290314f,0x928c241d}},	//   _khoro_, _kirken_, _komala_, _سلیمی_,
   {{0xb34031bc,0x196d42ca,0xd3503111,0x113b948f}},	//   _ئرگەپ_, _assignat, _trafiko_, _консензу,
   {{0x869112a0,0x4c6e50e1,0x76ba24dd,0xe16951ed}},	//   _سێکسی_, _iberica_, _assamesi, _apreldä_,
   {{0xb2e97094,0x08dd6213,0x13869459,0x42388031}},	// [eb0] _hasiera_, _bloggeru, _ghari_, _የመድብለ_,
   {{0xc25a514d,0x95a300ea,0x820ec15e,0x82fd0083}},	//   _selle_, _अनिता_, _даган_, _lacions_,
   {{0xa3869069,0xe394e101,0x3d9ae3b4,0x31e3c0ac}},	//   _ahari_, _ofisye_, _baanelwa, _입금확인후_,
   {{0xd02531f5,0xbce8e2b4,0xb24940d9,0xead03287}},	//   _گوارا_, _जगनमोहन_, _alembi_, _konkursą_,
   {{0xee9ec04b,0xd742c009,0x0c7d81fb,0x4d2e9057}},	//   _майли_, _большое_, _imisoro_, _navigare_,
   {{0x29add0ef,0xe3f404b3,0xf12af248,0x027ed293}},	//   _تجربا_, _gestur_, _ከተንብብ_, _ihene_,
   {{0x5d07503a,0xfda8d378,0x0217e252,0x2ec1c2a8}},	//   _anglaise_, _tengjast_, _ирандан_, _hainaman,
   {{0xb27ed052,0x737fc31d,0xa37860c8,0xe290821d}},	//   _viens_, _romagna_, _pagalba_, _arhasi_,
   {{0xd3860145,0x4f382504,0x21808358,0xd37863c2}},	//   _nkiri_, _सेमिनार_, _удовольс, _bagamba_,
   {{0x8386012b,0xbc45b056,0x8201d490,0x3f2d62d7}},	//   _ikiri_, _dikwano_, _alwil_, _bahumaga,
   {{0x84d7a3d0,0xe3790195,0x4053c289,0xb863a28e}},	//   _канадын_, _masamba_, _tresaden, _beransur_,
   {{0xc93c240b,0x4c8011ed,0x9bea5476,0x62ebe1d0}},	//   _sommerfe, _керем_, _cálculos_, _nimirum_,
   {{0x92d9e4e0,0x92d4722d,0x538d8031,0x8dce1083}},	//   _vetem_, _verder_, _ደረጃቸውን_, _кирет_,
   {{0xf226727c,0xa2d9e30a,0x75415030,0x624a64c5}},	//   _besked_, _wetem_, _ایمانه_, _idumea_,
   {{0xfd9773ab,0xf20090d8,0xd35bf100,0x06846360}},	//   _autobaza, _anaim_, _panguna_, _دھونکل_,
   {{0xc22480af,0x5351e45f,0xfeb8a249,0x8f4df198}},	//   _mikkel_, _chomutov_, _decennis_, _бошковск,
   {{0xbc1e10dc,0x057510c7,0x8512e061,0xf3f9722c}},	// [ec0] _compres_, _distoork, _اسلامآبا, _atauva_,
   {{0xc39580f9,0xb60d60e9,0x1b68416e,0xb40e01ca}},	//   _fyrst_, _golondri, _pritiska_, _maarmaan_,
   {{0xd2b4e5cc,0xd386901f,0x42a6d185,0x60582287}},	//   _inicio_, _shari_, _asebo_, _вёсак_,
   {{0xb27ed2ed,0x7248d1cd,0x2c757248,0x9939a295}},	//   _thene_, _kalmar_, _ዘይንጹር_, _adamanga_,
   {{0x68942099,0xb3870423,0x327f4374,0x48b9221a}},	//   _prevodov, _waarop_, _avenge_, _заставал,
   {{0xdc6f11c3,0xb5260065,0xbe2882b7,0x1ad6400c}},	//   _clarion_, _איסוזו_, _kwaminis_, _amatamat,
   {{0x02f54064,0x26f2206a,0xd243f17a,0xfa08d05c}},	//   _dernier_, _कर्मचार्_, _লাইব্ৰেৰ, _komadina_,
   {{0x627e0401,0x620193af,0x42d981d8,0x6b81c2df}},	//   _baint_, _cosih_, _leres_, _bainimar,
   {{0x944cc102,0x727e02e8,0x47e2c10c,0x326e02d7}},	//   _товарист, _caint_, _akarediw, _bapola_,
   {{0x02d8e027,0xfc6e03ed,0x127f45cd,0xec29719f}},	//   _daners_, _досконал, _awente_, _banamerr,
   {{0x7291b189,0x4386948c,0x925a12e9,0xccdb739c}},	//   _stvari_, _akara_, _behlu_, _ئورگان_,
   {{0x29c7c141,0xb23bf10c,0xabe2e0af,0xa279a127}},	//   _бакара_, _abelang_, _が参考になった_, _apositol,
   {{0xd200242e,0x73f99406,0x2f27623c,0x0d2961a2}},	//   _mikil_, _הקפות_, _direzion, _нарисова,
   {{0x237fd2c0,0x0887c1b5,0xfc484089,0x3c551091}},	//   _malaaka_, _талайды_, _blackfac, _lentere_,
   {{0x32fdf285,0x030e4376,0x31772152,0x025a52ae}},	//   _mbuga_, _maganar_, _тесты_, _kella_,
   {{0x02cb9436,0x8e7304f5,0x53a8e0b0,0x41e280ea}},	//   _bakouma_, _امتحانی_, _belakang_, _घरहरा_,
   {{0xaa58d443,0x620020f9,0x02f3521d,0xa27e909c}},	// [ed0] _creencia_, _tikin_, _प्रयुक्त, _yaanu_,
   {{0x0e7ab27c,0x3a7054bd,0xd2d982c2,0xa7e1a0ac}},	//   _チェックリストに, _प्रभुः_, _teret_, _판매자에게_,
   {{0xaec791b9,0xb7d52227,0xf6208227,0xa27e0023}},	//   _behiloen, _제휴쇼핑몰로서_, _트레이닝복_, _ibina_,
   {{0x32e93056,0x90af6232,0x6e13917d,0x72fdf0a9}},	//   _diriša_, _ezimisel, _ollenkaa, _abuga_,
   {{0x32d98159,0x654b0226,0xb300e389,0xdeea7180}},	//   _keres_, _विवेकको_, _tafarki_, _おめでとう_,
   {{0xf2cd329b,0x22d9840b,0xd0eec34f,0x729081a0}},	//   _abadlali_, _jeres_, _maligall, _dokana_,
   {{0xc2d981db,0xb9870266,0xe207019e,0x527e00f0}},	//   _deres_, _takitaha_, _takitahi_, _bains_,
   {{0xb2f1e086,0x72924365,0x72a6d1b9,0x9e5465cd}},	//   _christi_, _thwart_, _tsebo_, _agocotwe_,
   {{0x825a5299,0x32d9e238,0x3c520061,0x3953c022}},	//   _della_, _betek_, _تحقيقي_, _сының_,
   {{0x10ae1065,0x830ea2b7,0xe35bd223,0x19f67336}},	//   _רומיאו_, _tawagar_, _hongera_, _hinakaue,
   {{0x135bd55f,0x33869006,0x40dd457d,0xf277a2ca}},	//   _kongera_, _charo_, _وياريت_, _радиосу_,
   {{0x1a8fc176,0x412b8031,0x52908425,0x17b8600c}},	//   _kelingan_, _የበዛበት_, _bokana_, _amatagof,
   {{0x226e50db,0xb31d516d,0xa2d98202,0xc2d982db}},	//   _matona_, _flecken_, _beres_, _seret_,
   {{0x427a12cb,0xd36360bf,0x29881165,0xc27ed3f1}},	//   _karibuni_, _kengash_, _wichtige, _azongi_,
   {{0xf2019062,0xa386d0b4,0x826e0215,0xc793136f}},	//   _sosia_, _akere_, _kosovu_, _bakwetli,
   {{0xf85ca3db,0x92002244,0xcc6f2027,0x6b6e242a}},	//   _detaljer_, _ankir_, _emprema_, _chronisc,
   {{0x0a6eb4d7,0x358b9251,0xe5d1e267,0xc394e2b8}},	// [ee0] _aragenda_, _достигну, _amachagh, _meisie_,
   {{0xeaf9205d,0x5541705b,0x43f99316,0xb577d086}},	//   _entschat, _الماني_, _hesus_, _xsitepro_,
   {{0xc386d47e,0x76b8b244,0xdb81022e,0x72e993f7}},	//   _fjords_, _arkatasi, _neunkirc, _rezidan_,
   {{0xf2d963c8,0xd20270a7,0x429274a7,0x2b91c12c}},	//   _angegh_, _cirihu_, _aisake_, _ayangulo_,
   {{0xbd1940f1,0x82a6e0cb,0x420191f2,0x094f93df}},	//   _absolutt_, _heibio_, _kosin_, _vedlegge,
   {{0xe4fb1030,0xd040517d,0x126f419e,0xf0dcd1a1}},	//   _دارالحفا, _valtakun, _weriweri_, _earningl,
   {{0xd3f8901d,0x64335085,0xc2b6701a,0x3644e144}},	//   _ngaun_, _শেরিফ_, _mercat_, _akukenti,
   {{0xe201915d,0x025a5177,0x4200d29d,0x1a57d1ed}},	//   _eosin_, _celli_, _snein_, _табарга_,
   {{0xd98812cd,0x9b26c121,0x12d9e075,0xdc6274dc}},	//   _richtige, _विद्यानं, _petek_, _veturin_,
   {{0xb44802a7,0x215724d2,0xb280f1ac,0xd26e51fa}},	//   _سورلگن_, _charghbo, _mariazy_, _hatona_,
   {{0x0d093043,0x5ea360e9,0xb2d9a176,0x3652c0df}},	//   _конца_, _cañada_, _cepet_, _opinionw,
   {{0x0c932004,0x23415499,0xb2d98396,0x83f9919a}},	//   _تالار_, _कैमूर_, _seres_, _mesur_,
   {{0x5382b365,0x47d96148,0x52208352,0x427e60c1}},	//   _nourishm, _kulawarg, _وینداری_, _ibong_,
   {{0x4386936f,0x0de652ae,0xc2a652ae,0xabd0e0cc}},	//   _tharo_, _miljonit_, _miljoni_, _compañer,
   {{0x32a6d00a,0x327ed053,0x99648060,0x82d8b1b3}},	//   _global_, _abend_, _hypokale, _ardera_,
   {{0x7290812d,0x627ed095,0x88b6d11c,0x0b64a0ce}},	//   _tokana_, _scones_, _لرئيس_, _keressen_,
   {{0x51f340d7,0xd291122e,0x46ed7063,0xa386d206}},	// [ef0] _sabantuy_, _alcala_, _barchami, _nheri_,
   {{0xd3866309,0x020193af,0x13f88135,0xa98380c9}},	//   _chorr_, _gosin_, _bukura_, _народної_,
   {{0x125a51e7,0x4bea620a,0x8d716106,0xe3662077}},	//   _telli_, _kabonero_, _allmhara, _alagolo_,
   {{0x33ea92dd,0x125b422e,0x7120a264,0xb4926285}},	//   _kwato_, _imelda_, _آآآآآآآآ, _abagolok,
   {{0x42d9a0be,0x2594312f,0x9ce0801a,0xc2915266}},	//   _neper_, _ﺭﻩﻫﻤﻪﺕ_, _айлыгы_, _engata_,
   {{0xc3870023,0xcb79d287,0xf2fb23a5,0xe2c25396}},	//   _sharti_, _легенды_, _qaphela_, _inglesa_,
   {{0x9ae07036,0xc104f03b,0x761373ed,0x905e1105}},	//   _contenut, _akukenel, _ettersom_, _וואהלן_,
   {{0xa2d9a03a,0xc2da5422,0x620042d4,0xa8d032fc}},	//   _repet_, _bowery_, _simin_, _издавачк,
   {{0x4c7544bd,0x0d5ab01a,0xcfbda27a,0x1dec50c9}},	//   _वाक्यं_, _абонентт, _poplatko, _практиці_,
   {{0xa2d9e24e,0x02d9808b,0xf05b41c1,0x3278747e}},	//   _tetep_, _kerep_, _oorspron, _caunas_,
   {{0xda5fc2aa,0x026e5187,0x9c52c085,0xbfb7e404}},	//   _matetika_, _matola_, _অরণ্য_, _فرانسيسي_,
   {{0x92fcd1a7,0xab8d2126,0x16c2112c,0xf27ed1e7}},	//   _lingue_, _dalisoro_, _akhandzi, _laenu_,
   {{0xe3966018,0x46d4a3b2,0x6ea07096,0x93e64332}},	//   _reusit_, _gerarchi, _magunkat_, _fatulisi_,
   {{0x76e3d0ea,0xdd80d038,0xe27ef256,0x928381bc}},	//   _शक्तिशाल, _माध्यमात, _izindi_, _رومانتىز,
   {{0x9c07c35e,0xdbeed2df,0x5503250c,0x8f46014c}},	//   _kamutamb, _davodavo_, _evalyasy, _জনকন্ঠ_,
   {{0x61e0241e,0x81549137,0x06bbe256,0x444bc048}},	//   _रोटरी_, _sumusuno, _abafungw, _काँधमा_,
   {{0xd201917d,0xa27ef3ff,0xf20a5141,0x8da8d272}},	// [f00] _tosin_, _bagni_, _премьерл, _linguist_,
   {{0x62da40ee,0xef9ec41d,0xb29033e6,0x4633823c}},	//   _stanice_, _محصور_, _timata_, _istituzi,
   {{0x63eb70c6,0x327e00ef,0xf0fa4009,0xeac8f214}},	//   _abatoo_, _mbinu_, _происхож, _ءﺩﺍﺳﺘﯘﺭﯨ,
   {{0x22d8c10c,0xc200f05d,0x4c932351,0x850c80f7}},	//   _atlega_, _ingio_, _سالاد_, _胶南市农业机械管,
   {{0x5691608a,0xd7460173,0xd25a51fe,0x857e007f}},	//   _elithaty, _kompaniý, _dellu_, _табаҕәуа_,
   {{0xc5381030,0xdb9ac03b,0x8e3ff214,0x940241fb}},	//   _انکارایت, _akanalic, _ءبىيكەش_, _imigenzo_,
   {{0xc2fd24c4,0xa440c03b,0x13e470ac,0x104a20cb}},	//   _boliger_, _akakabik, _바이올린의_, _affrican,
   {{0xb38663f4,0x7eb63152,0x23035075,0x6d1e00aa}},	//   _chorp_, _системы_, _hranjenj, _arongowe_,
   {{0x62fd70b1,0x9d30b0a2,0xfa17d394,0xd1908182}},	//   _taagan_, _quintile_, _quranaka_, _anantāḥ_,
   {{0xf27ed3ec,0xf2019063,0x3317813c,0x61a47189}},	//   _maent_, _hosil_, _zarza_, _nemoguće_,
   {{0x73e53456,0x2ab4930a,0x425a521c,0xd2fd302a}},	//   _ज्वालामु, _blakskin_, _kellu_, _conifer_,
   {{0xa2d9a0be,0x023ba34e,0xd9bba5ce,0xfcfd8248}},	//   _teper_, _abadingi_, _abadinga_, _ንኣሕዋትና_,
   {{0x32497106,0x1225613a,0xa290334f,0xaa14c38f}},	//   _agamsa_, _angkel_, _simata_, _verberge,
   {{0x526e61e4,0x017e5152,0xcb0a613f,0x3a90c07f}},	//   _aarona_, _познаком, _comprise, _амхаџьыр,
   {{0x227e900b,0x82a7f4ec,0x5287a0f6,0x72ee11fe}},	//   _maani_, _grubu_, _химиясы_, _gannaaw_,
   {{0xe8dc021d,0x09866056,0xc747e3d6,0xd50aa163}},	//   _प्रकृतम्_, _dikhonfe, _графичес, _segurado_,
   {{0xd27e90e3,0xd34bf194,0x22bbb065,0x4c6ea011}},	// [f10] _ibang_, _bedenkt_, _שהופך_, _catafóri,
   {{0xf321e2e5,0x7b60b2ae,0xc55b0195,0xd803d0f8}},	//   _dotyk_, _तोहनी_, _akaweluk, _altmış_,
   {{0x927ed1e7,0x6386d0b4,0xb25a5122,0xfe4e5316}},	//   _vaenu_, _akera_, _bellu_, _kasalana,
   {{0xbfee1392,0x1380618e,0xc43c8022,0x5d74e36f}},	//   _क्लार्क_, _kouran_, _ﺍﻟﻌﺩﺩ_, _атрибутт,
   {{0x9a0a21c9,0x53869218,0xa2019334,0x6ac680f7}},	//   _posavina_, _bharr_, _losis_, _法人或者其他组织,
   {{0xb394d0e8,0x55281224,0x92903076,0x638692e8}},	//   _prostu_, _matswalo_, _dimara_, _charr_,
   {{0xba0a3418,0xc20201e9,0x1417c1bd,0x06d1d275}},	//   _ababatat, _desini_, _potravin_, _айаллар_,
   {{0x7b7fc3a2,0xa3ffc16e,0x9fcfe428,0xcec91026}},	//   _poslanic, _poslanik, _peningar_, _abonnees_,
   {{0x4c76b22b,0xdda743c6,0x6463639d,0xaa7121b5}},	//   _ditukar_, _tarutaru_, _studirao_, _ابايلاڭى,
   {{0xf37a4080,0xb6ffe1c5,0xf519c031,0xd2d983e5}},	//   _fajardo_, _besteifö, _እስፓንያ_, _perex_,
   {{0x62004018,0x075885c2,0xa8276083,0xc54a00f4}},	//   _nimic_, _पूर्णता_, _تارتىبى_, _نىمانچە_,
   {{0xdf60424b,0x22d9c007,0x4316c435,0x1c6d91d5}},	//   _изготовл, _heves_, _akozwa_, _iskrena_,
   {{0xdb6c2215,0xc6ae4214,0xdf3f130e,0x09e9b3bf}},	//   _spomenic, _اتاۋدان_, _व्दितीय_, _нараства,
   {{0x52494009,0x13a9c0b1,0xd9e050f4,0x4e72606a}},	//   _ngemva_, _پٲراو_, _ақсүңәк_, _शिस्त_,
   {{0x331a54bd,0x7f23a2a1,0x5394d123,0x4628b3c6}},	//   _manasā_, _penerban, _belser_, _poronihi,
   {{0xa25b704b,0xd25b705e,0xcb257234,0xd0272330}},	//   _amalga_, _alelé_, _porovnať_, _注册通行证_,
   {{0xc2006405,0x13ea0266,0x03e9e28c,0x2290c1ef}},	// [f20] _anois_, _etita_, _разнаста, _bulasi_,
   {{0x4df2e22e,0x02010052,0x75c3a022,0xc2f23367}},	//   _niedersa, _skaits_, _кодексі_, _potovanj,
   {{0x69df505a,0x22ddf4b0,0x5386d35e,0x839570ec}},	//   _contingu, _narodni_, _chero_, _flasim_,
   {{0x938072d5,0xa212e589,0xe6053064,0x224973fa}},	//   _thuras_, _imihla_, _formulai, _afamba_,
   {{0x3c77130c,0x732070cf,0x338692bd,0x46d49177}},	//   _pensate_, _ninyo_, _pharr_, _aggattii,
   {{0xe362917d,0x71ee70f4,0x8a3e4156,0x4db902d5}},	//   _одноврем, _позитсий, _шампиони_, _airighea,
   {{0x18c680cc,0x3996f011,0xfb191146,0xe8bb3303}},	//   _উদ্যোগ_, _рартист_, _empangan_, _manualer_,
   {{0xfb1e816f,0xef5e816f,0x243843a1,0x567843c2}},	//   _komprene, _komprena, _abakabak, _abakabaw,
   {{0x91b39214,0xe721d279,0xc4aa44ab,0x635d11c8}},	//   _номері_, _primærva, _arababaz, _ranging_,
   {{0x0115a0bb,0x533221ba,0x9672e008,0xf27c6169}},	//   _власност, _свободно_, _мухаммет_, _virstell,
   {{0x327ee244,0xc7d72155,0xf2019469,0x1c1b82c1}},	//   _asinxa_, _оқутқучи, _posit_, _zamanlar,
   {{0x62d8e44e,0xe5bb927d,0x9d7bc403,0xa464b5cf}},	//   _geneen_, _walaalah, _abaminya, _acredito_,
   {{0x92d47222,0xe200930a,0x32d9c50b,0xf2d8a238}},	//   _verdur_, _inait_, _jever_, _europat_,
   {{0xd2d9c183,0x931d3438,0xaaeca2bc,0x9200f071}},	//   _dever_, _اصطلاحات, _etterlys, _kriich_,
   {{0xf21b85d0,0x12d8e44e,0x835d11ab,0x2c334248}},	//   _phakathi_, _beneen_, _tanging_, _ተወዳደርቲ_,
   {{0x92e5f42e,0x1d7f41d4,0x51bf41d4,0x6c7f41d4}},	//   _vinnuna_, _kommunea, _kommunem, _kommuneq,
   {{0x7b1e847e,0x0cbec009,0x6575a012,0x97de847e}},	// [f30] _comprene, _ранее_, _وهنوار_, _compreni,
   {{0xc27ff585,0x6f40f026,0x73a275d1,0x02c360a1}},	//   _khung_, _인도네시아_, _konpa_, _suellen_,
   {{0x6916139e,0x8289c34d,0xe824c0d2,0x84de23be}},	//   _chacharu, _baskhem_, _турушат_, _временем_,
   {{0xa2c0c13c,0xbc08f0ea,0x227ed285,0xb20200b9}},	//   _анвар_, _सर्वोच्च_, _nsonga_, _sesini_,
   {{0x9386d1af,0x92d901cd,0xf38660c4,0x725b7063}},	//   _whero_, _arbeta_, _ukora_, _amalda_,
   {{0x6386d39b,0xbfc9617a,0xa412c13c,0x4a6be2d7}},	//   _thero_, _varierar_, _авини_, _bagomots,
   {{0xf27ff1b8,0x6486c3d0,0x8a07d1d0,0x226c8187}},	//   _nhung_, _аманд_, _getacode, _makolo_,
   {{0x0a7e01fb,0x9f9450bc,0x12d9e01c,0x6cc4e2cb}},	//   _byandits, _agége_, _hetes_, _نظامن_,
   {{0xbf409200,0x13bd30fc,0xc34e0073,0xf6533127}},	//   _churasja, _bakwang_, _majetok_, _daunilaw,
   {{0x4a7e02fe,0x60aad0de,0x62ff6202,0x6ed434bc}},	//   _vyandits, _اعىتۇۇ_, _basisir_, _achievin,
   {{0x93e5c044,0x6320a582,0x2f856031,0x127f5369}},	//   _manuhiri_, _qibya_, _ለመብላት_, _evenit_,
   {{0xca701137,0xb2b58201,0xf40d148f,0xc0223115}},	//   _ginagawa_, _svedese_, _опрема_, _acceloro,
   {{0x155190f6,0xec907352,0x4527f15f,0x42153144}},	//   _ойланып_, _تاریکه_, _karitauy, _akahlali_,
   {{0xa2d8e086,0xe84a0032,0x82f0114d,0xce4d2218}},	//   _munera_, _danmerku, _pekingi_, _calafort_,
   {{0x02d9e102,0x33792015,0xd2fd94ff,0xaee0109a}},	//   _heter_, _piraña_, _anvites_, _مۆمىن_,
   {{0x0f5d3300,0x03eae319,0x4ec6703d,0x1316e4d7}},	//   _vogalenn, _gentra_, _اولادونو_, _akizwa_,
   {{0x72fcd4be,0x7fd231c7,0xa25cc1ce,0x804a110a}},	// [f40] _bloger_, _ءبىتمىمى, _impeachm, _ujeruman,
   {{0xa2d9e101,0xf37204f1,0x7d3ec031,0x125b5048}},	//   _petet_, _allagad_, _አሳውቀዋል_, _anglie_,
   {{0x42d9e00f,0xe9ee51d8,0xcb05a2f9,0xadc2e4de}},	//   _leter_, _paribasa_, _ahasanga_, _deskriva,
   {{0x9ad5e44d,0xe200c307,0xecc830a2,0x20473358}},	//   _perković_, _avling_, _دتېلو_, _сексе_,
   {{0x72d8c193,0xc32650f7,0xe332d05d,0x32b5714c}},	//   _homely_, _图片和音视频稿件_, _proxim_, _টাইগার_,
   {{0x5f127228,0x096200c9,0x8c26510e,0xce53d24a}},	//   _wintersa, _федераці, _wersję_, _trochdat_,
   {{0xcd161352,0x766253dd,0xf46530da,0x09f5220f}},	//   _حکومی_, _krajnjem_, _osservaz, _ordusunu,
   {{0x520191f8,0xcc046075,0x92cae33b,0x4cbc92f4}},	//   _josip_, _brisati_, _mondok_, _indartsu_,
   {{0x9982e1db,0x567c013f,0xcc53040a,0xdf531128}},	//   _beskrive, _להימנע_, _diptera_, _slippage_,
   {{0x160341bf,0x4386947b,0xb2d7324e,0xaa4482e5}},	//   _тестамен, _ikari_, _شکاری_, _predseda_,
   {{0x827ed1aa,0xf2d9e074,0x32915012,0x2290812d}},	//   _tsonga_, _vetes_, _ingawa_, _mikasa_,
   {{0x98c381e0,0xbbb7c12a,0xf0bb141e,0x7e5631d9}},	//   _malesuad, _emphatic, _ट्यूमर_, _салтын_,
   {{0xc64364b6,0x42910223,0x89403085,0x1481c0f7}},	//   _bankruti, _ambalo_, _escuchar_, _劳动的财政贡献率,
   {{0x62fe45d2,0x0386d265,0xa1f8215d,0xe200f223}},	//   _artigos_, _diery_, _مقوله_, _ingia_,
   {{0x622ef501,0x020162a6,0xa0f9c13f,0x72c27284}},	//   _ukuvikel, _regiji_, _obviousl, _analysa_,
   {{0xa2d9e0bd,0xc57b6004,0xaedb2138,0xb440221d}},	//   _beter_, _دیکتاتور, _zasigurn, _aaśvina_,
   {{0x4ff82026,0x14362048,0xdf9fb096,0x0a125267}},	// [f50] _담당중개업소_, _nedaleko_, _بوسنیا_, _amachara_,
   {{0x3a07315f,0xef440031,0x3fd68012,0xb1850370}},	//   _kamagitt, _መመላለስ_, _changamo, _ababhidl,
   {{0xb9b722a7,0xe386d47b,0x73656186,0xa2903114}},	//   _دامفریوی, _ekere_, _urugaga_, _helang_,
   {{0x18822108,0x12d98378,0x3c00b086,0x43ea9128}},	//   _عبدالشکو, _afrek_, _possent_, _swath_,
   {{0xb9c710d7,0xc3f403cc,0xfc5bd3aa,0x5a095398}},	//   _чарада_, _postaz_, _tottori_, _vocalist,
   {{0x406df1bc,0xa2d9e453,0xed95e3aa,0xb502b23c}},	//   _ачылды_, _reter_, _अविश्वास_, _ingresso_,
   {{0x825a5129,0x4eea62fe,0xeb6aa0d7,0x5d84455e}},	//   _kelli_, _urakabon, _dumasına_, _abamufaa,
   {{0x6379625d,0x3c0490e9,0xe7eb81f6,0x7f41b1c3}},	//   _hurayra_, _автономт, _तिसकोपी_, _bharabha,
   {{0x463650c0,0x8386924e,0xb200b0cb,0x268021fa}},	//   _apoiridi, _ukara_, _licio_, _chikisiw,
   {{0x541333f1,0x98f2e24f,0x51a63264,0x21e4c36d}},	//   _abunelak, _nangillu, _معلقة_, _一個班停課_,
   {{0xd200b1bf,0xfc3a2085,0xdba92293,0xffc59292}},	//   _nicio_, _কিংকর্তব, _ubukerar, _اعتبارقر,
   {{0x526c8161,0x66cf1223,0xf8543264,0x53bbc171}},	//   _jakobo_, _kikamili, _جوزيف_, _وستار_,
   {{0x971140e5,0x34a3020f,0x9d77f005,0x4b61649e}},	//   _गर्दन_, _futbolçu, _называец, _aireasan_,
   {{0xab0af1c6,0xbf4af28b,0xfb8cc2f4,0x04f71061}},	//   _klassika_, _klassike_, _nazinoar, _قادرپور_,
   {{0x2ece50e5,0xdbff924f,0x0201f49b,0xdb13116e}},	//   _कार्यवाह, _takutits, _bluit_, _послао_,
   {{0x9248d069,0x32d9e16a,0x96e9430f,0xe29150c3}},	//   _agomba_, _often_, _इतिहासाच, _nogama_,
   {{0x448745d3,0x6320710f,0x163b9554,0x3cbb9554}},	// [f60] _पुजारी_, _annyi_, _ministai, _ministaq,
   {{0xc9d24326,0xd30ca34d,0x1b8ca200,0xf27ed455}},	//   _abafulat, _maramot_, _marimoto_, _abeno_,
   {{0xc3866208,0x3c04f025,0x56d753c9,0x7e0141d9}},	//   _phort_, _adasesi_, _peccatum_, _ەدىڭىز_,
   {{0xc25a3007,0xe4b5f37f,0x22d8c00c,0xce2ae248}},	//   _állam_, _adaberek, _aulega_, _ሃተውተው_,
   {{0xe200603c,0x1b71a0b1,0xa3207007,0xf2d8e196}},	//   _gioia_, _guurtida_, _ennyi_, _denean_,
   {{0x8377c162,0x0daa9521,0xc532711b,0x13794169}},	//   _بىراق_, _mienskip, _септемба, _besonneg_,
   {{0x3d1310fe,0x62f6b2ff,0xaf9512b9,0x86b6c2d7}},	//   _bikomeye_, _bangoyli_, _tenderer_, _belegelw,
   {{0x838695d4,0x52f1f0e5,0x8fd230d7,0xe2d9804a}},	//   _bharu_, _यपुरी_, _росстат_, _agreg_,
   {{0xc2787005,0x679d8225,0x5f38f121,0x69463148}},	//   _kaunas_, _сообраќа, _विशिष्ठ_, _ngaliwat,
   {{0x206372e2,0x6c6000f7,0x02d462ef,0x69c873f9}},	//   _redaksyo, _中国视觉网_, _aardig_, _суверенн,
   {{0x38591015,0x52d9e095,0xc236e11b,0xec537244}},	//   _terrenos_, _aften_, _manjih_, _kastata_,
   {{0xe27e9125,0xe1fa101a,0x5b0981e5,0x4286125a}},	//   _abana_, _كىشىنىن_, _башламаг, _בשכנות_,
   {{0x6e68c5d5,0x728da266,0xe793e345,0x92fd05d6}},	//   _adiciona, _atikolo_, _नवरात्री_, _klager_,
   {{0x1201f08c,0xc27861da,0xd248d181,0xe2bb22c6}},	//   _sluit_, _irunda_, _ugomba_, _funebre_,
   {{0xa387f115,0x0e37d462,0x020ec0f4,0x8f9b9272}},	//   _estre_, _सर्वहारा_, _капал_, _digester_,
   {{0x7200f032,0xd29030fb,0xb85d60fb,0x47460140}},	//   _engin_, _vimada_, _व्यवधानम, _kompaniä,
   {{0xf466b1c7,0x49917144,0xe3235048,0x2201f010}},	// [f70] _ﺒﻌﻨﻭﺍﻥ_, _akahlele, _řečeno_, _fluir_,
   {{0xa22663a4,0x2fe3d09a,0x730071af,0xe387f44d}},	//   _birkin_, _باشتا_, _manaaki_, _istre_,
   {{0xba73020d,0xce00d5d7,0xbb57a358,0xbb3ee0ea}},	//   _bilaketa_, _aludinga, _задачу_, _छत्रमानस,
   {{0xeeb13236,0x12d9815e,0x266cc030,0x7c56612f}},	//   _prostire_, _berez_, _яширинча_, _телевийә_,
   {{0xa20ec01a,0x12d8c00c,0x73207110,0x6321c101}},	//   _талаш_, _pulega_, _linya_, _anvye_,
   {{0x72a7c23c,0x12003024,0xf57062a0,0x72fd04e7}},	//   _такова_, _hamiti_, _هیچمان_, _opcijas_,
   {{0x12fb32c5,0x0ac852d4,0x22319284,0x7367b053}},	//   _tromsø_, _zacarías_, _inimico_, _langsam_,
   {{0xeb05a030,0x62e96055,0xd27e05d8,0x8f4d92f7}},	//   _албатта_, _scritta_, _ucing_, _башланди_,
   {{0x2d19346c,0xa30310d0,0x23869033,0x38d930be}},	//   _personar, _hilakut_, _akaro_, _personav,
   {{0x9639631c,0x520044f7,0x9c71105b,0xf2b5713d}},	//   _prihvati, _limit_, _دپلار_, _riacho_,
   {{0x194e936d,0x938692e8,0x438740c9,0x82d83169}},	//   _在烈日炎炎的夏季_, _thart_, _eieren_, _alleng_,
   {{0xf3207148,0x801e22ab,0xcc1632b8,0xb61ab031}},	//   _dinya_, _komentuo, _gespeel_, _የሚታዩት_,
   {{0xab7bf1ab,0x417c531b,0xb992a01a,0x6a799030}},	//   _pangalan_, _nabadlal, _استرولوگ, _бирданиг,
   {{0xbb914023,0x8fed120e,0x4f82d18a,0x7d2fb0e2}},	//   _akraaró_, _изрази_, _afectiun, _andikape_,
   {{0xb28791fa,0x62c2505f,0x73874169,0x497cb343}},	//   _avekile_, _apelila_, _hieren_, _ainitene,
   {{0xd74a7009,0x18675210,0xd3203579,0xa0442031}},	//   _требован, _ualified, _volcans_, _ተከናውነዋል_,
   {{0xb355b317,0x82003378,0x53ffb437,0xcc5d0034}},	// [f80] _degemer_, _kominn_, _avmektig_, _mattino_,
   {{0x66c5308a,0xa6303135,0xae4342c4,0x1ef77131}},	//   _abashish, _tranzici, _turbojet_, _तपशीलवार_,
   {{0xf74430a1,0xa765a041,0x49e3c1e5,0x6c51811d}},	//   _bubangêr, _دوامداره_, _томаша_, _kuitika_,
   {{0x6bed410f,0x0fa4c2cd,0xea77600f,0x61c38251}},	//   _szoftver, _dezember_, _applikas, _guilherm,
   {{0xbeb32104,0x9876025a,0xf3eae16f,0x06dae388}},	//   _derechos_, _משניות_, _montri_, _ڕیفراندۆ,
   {{0x83869288,0x41e73057,0x92eff250,0xff4c20b7}},	//   _shart_, _уните_, _aliikoa_, _adaptira,
   {{0x2bf3617a,0x3dd93068,0xb2d85199,0x330e050e}},	//   _avellino_, _berkenaa, _galed_, _amababa_,
   {{0x5cad106d,0xf35745d9,0x50ccf171,0x5ac640f4}},	//   _isigungu_, _diretor_, _hirondel, _خاككېر_,
   {{0x63966254,0xd369c032,0xc2cac1a0,0xc25ad21c}},	//   _shusha_, _tenglar_, _goldik_, _moolah_,
   {{0x6c553272,0x6c535284,0xd5d2f072,0x427ff067}},	//   _atitude_, _littera_, _железниц, _ihuna_,
   {{0xd30dc1a3,0x1c141210,0x324981e7,0x5489e20e}},	//   _humbela_, _udystay_, _surma_, _прогласе,
   {{0x929075da,0xb25a9408,0xeecda2f4,0x837ce25a}},	//   _iznad_, _nuklir_, _батзориг_, _vivante_,
   {{0x22d8538d,0x530ca029,0xe30392ea,0x1c17a3c1}},	//   _malee_, _parabot_, _organet_, _kunskaps,
   {{0x8d8f033c,0x7139713f,0xd1e8a1a1,0xd2d85010}},	//   _fotosura, _graduall, _achinesm, _agley_,
   {{0x3f58f138,0xc4791346,0x025ad177,0xb02c117b}},	//   _obramben, _protéin_, _boolah_, _اقبيىك_,
   {{0x235d1351,0x5200f179,0xb3ead1b9,0x5964e031}},	//   _nanging_, _eigin_, _hantle_, _ጀርመኖች_,
   {{0xfc2850c6,0x6ccc135b,0x299d20f6,0x0b258287}},	// [f90] _akasakas, _служб_, _шахыр_, _германіі_,
   {{0x01c5b17a,0x531d7018,0x5783f180,0x6386d267}},	//   _শর্তাবলী, _sarcina_, _総スクラップ数_, _ikeri_,
   {{0x72d85199,0x9b308180,0x6381408b,0x4f687202}},	//   _caled_, _クチコミを投稿す, _سازگاری_, _salawasn,
   {{0x1f5990b2,0xf71f54f5,0x20528368,0xa20192b8}},	//   _bliajyob_, _حساسيت_, _endrocin, _insig_,
   {{0x53061023,0x4d7cf0de,0xa2012395,0xc3869394}},	//   _afdaguk_, _الچۇۇلار, _onyin_, _ukaru_,
   {{0x99cfe206,0x42004369,0xe2bd126e,0x105972e4}},	//   _corecode, _simil_, _спроба_, _vulanpro,
   {{0xaf5d604f,0xe9cd70d1,0x597ce0e7,0xb2d85266}},	//   _sepanjan, _alifabet, _tshikone, _falee_,
   {{0xf37902e4,0xdc2af140,0x43878084,0xb9a5741d}},	//   _megavnn_, _inspekts, _abiyamọ_, _رئیسانی_,
   {{0xfea8c124,0xbca5e004,0xd2efd0c8,0x2dba2252}},	//   _анатоли_, _letzebur, _aplinka_, _اۋتور_,
   {{0x825b10bf,0x92d543e3,0xcc553123,0x22d893b0}},	//   _amaliy_, _adjourn_, _abitiye_, _herning_,
   {{0x12ca90ea,0x061203bf,0xc15610c2,0x6c126329}},	//   _akademii_, _здравосл, _башыма_, _prosekus,
   {{0x72c611ca,0x5197a19d,0x13aff43d,0xdc1990e8}},	//   _بدلنہٕ_, _murchadh_, _trevlig_, _पान्चजन्,
   {{0xc036e13e,0xe307f258,0x0498b05a,0xa6183333}},	//   _छमाही_, _pisanik_, _суммасын, _kotlovni,
   {{0x4826b292,0xfc65216b,0x4ffbb358,0x53ead23f}},	//   _جاناتان_, _kuntatt_, _ставить_, _avetz_,
   {{0x0187f09a,0xe27f2200,0x4200d3d0,0xd3a25434}},	//   _تالانتلى, _mayni_, _balitz_, _colpa_,
   {{0x82fe65af,0xb200c113,0xaae6c04d,0xc6cd022c}},	//   _haugen_, _paliek_, _inntinne, _aavanoai,
   {{0x337c631f,0xd3ead421,0x707d3251,0xe232814c}},	// [fa0] _alcance_, _aantee_, _шанси_, _নগরবর্নর,
   {{0x9420d12f,0x6e720041,0x4290322e,0x31579102}},	//   _نىمانداق_, _مخابراتي_, _himaya_, _банках_,
   {{0x8d817086,0x2c93205a,0x0294406e,0x8386d40f}},	//   _truetype_, _چاچار_, _sukabumi_, _skera_,
   {{0xc6e7c0c8,0x7d7a923c,0xf8fb90d8,0x5346a00f}},	//   _баранаві, _качество, _ullachad, _fordelt_,
   {{0xed8cd373,0xbb644053,0x73ca50fb,0x8b878165}},	//   _སྐྱོལ_, _arbeiten_, _सञ्चलने_, _behinder,
   {{0x1c01c469,0xc200d587,0xa2fb14ef,0x334b7346}},	//   _exister_, _kalisz_, _kwahban_, _pameget_,
   {{0x12f07005,0x6b7be2d5,0xd4496031,0xe581c03b}},	//   _pinigai_, _ainglean_, _የከነዓን_, _anetisek,
   {{0x65b593be,0xab7f5110,0x6aa801a1,0xd7c7d048}},	//   _клиента_, _brouhaha_, _itchings, _रुमल्लिए,
   {{0x5b1ed064,0x5f8d414d,0x93ea0145,0x9cd272b5}},	//   _点击此处查看原文_, _सलीका_, _etiti_, _dockyard_,
   {{0xa3ea6466,0x72131030,0xb61b5351,0x0a341009}},	//   _mtoto_, _pochta_, _پرستار_, _перечисл,
   {{0x5be9a078,0x7353813e,0x70d56560,0x720041ab}},	//   _جرينتش_, _produkcj, _bergerak_, _gimik_,
   {{0x19c7c1aa,0x08fe3018,0x598ec5b5,0x2c5fb01c}},	//   _балалар_, _кореспун, _малих_, _voltunk_,
   {{0x4b0c251d,0x026e5280,0x199a2121,0xfdf9e1f0}},	//   _باپیر_, _natoka_, _कार्क्रम_, _геройы_,
   {{0x2387f038,0xbc751121,0x83e9620e,0x84692396}},	//   _istri_, _गोर्की_, _exposiçã, _conflito_,
   {{0xe2d8c31b,0x9d29e15f,0x620cb1d9,0x33866387}},	//   _kuleya_, _enmikkot_, _مەكتەبىن, _akori_,
   {{0x52fd5249,0x8b0c32d1,0x9d5ca132,0x30321013}},	//   _eleger_, _هادین_, _комисару, _apatamen,
   {{0x02e601b9,0x825b8308,0x8200f0c9,0x92d040f0}},	// [fb0] _ananela_, _berlo_, _angis_, _adultes_,
   {{0xc3f01037,0xe926c132,0x2587e141,0x02fcd1a7}},	//   _тәртип_, _бричень_, _аламатла, _fingre_,
   {{0x36d6105a,0x822505db,0xb59c344f,0x59c7c33c}},	//   _باتمان_, _ngakau_, _legislaç, _малака_,
   {{0xe290c39b,0x06b60111,0x2faba335,0x027ed060}},	//   _molato_, _informoj_, _ulteriur_, _abena_,
   {{0x42b400fe,0xf96e4158,0xce4f0008,0x020192d5}},	//   _kwica_, _varijant, _makalala, _aisig_,
   {{0x0fbbd320,0x1642501d,0xe4b5a203,0xdeae1121}},	//   _zingstar_, _standhaf, _kutandik, _tellimin,
   {{0x6682e0ea,0xe0ddd245,0x97798064,0xf5c71085}},	//   _उपचार_, _ngendlel, _青岛市公安局_, _তেহরান_,
   {{0xeb829085,0x58f8e1a1,0x33579116,0x37fe30a9}},	//   _নামতে_, _istanced, _छ्ोलक_, _amaparaw,
   {{0x3fe3c007,0xb2012103,0x8778e2fd,0x7c7ea13d}},	//   _ساختہ_, _biyin_, _ڕوکاری_, _opisyal_,
   {{0xf3f882df,0x2f6b24da,0x9dacd0a9,0x1c7c0057}},	//   _tukuna_, _horarios_, _achinanp, _clasica_,
   {{0x427ff320,0xb7eb9062,0xa9e641de,0xb99f31aa}},	//   _chung_, _talafeag, _otvorena_, _boikethe,
   {{0x9595529a,0x1c4d9128,0xf35ef22c,0xd26f53e6}},	//   _kepercay, _bravely_, _alafoti_, _kirikiri_,
   {{0xb3ea945b,0xd26e611d,0x227f72c2,0x93f82080}},	//   _stata_, _maroja_, _sranja_, _hakun_,
   {{0xa20e11f7,0x526e639b,0x32cc30b6,0x523c8227}},	//   _татар_, _baroma_, _incluso_, _시작합니다_,
   {{0x2983c009,0x474a8292,0x12d87185,0xdb0c00b0}},	//   _болезни_, _ускунала, _kanee_, _keistime,
   {{0xe34783f2,0x9dbc31ce,0x2ae1820d,0x926e635e}},	//   _ethenga_, _milanese_, _daitekee, _varoma_,
   {{0x220124d2,0xa26e6435,0x4386d387,0x627ed5dc}},	// [fc0] _yiyin_, _waroma_, _akero_, _iconos_,
   {{0x86ccc0b4,0x627cb1d9,0x83f96293,0x13f3e39a}},	//   _ainapuni, _қаражаты_, _kugura_, _सेटअप_,
   {{0x1e6c2228,0x4fd3a13f,0xf37a0262,0xb8f8b15e}},	//   _بیرون_, _קניין_, _magambo_, _askatasu,
   {{0xa7a6c233,0x2b443094,0xd2b902de,0x5c2ac5dd}},	//   _mandaing, _хүжий_, _lúcia_, _መለኽትን_,
   {{0xd59960d3,0xcaee3419,0x0eae2062,0x6556b401}},	//   _substanz, _sentimie, _aliliuin, _جانبها_,
   {{0x4d912140,0xf96f5101,0x127e90d2,0x1c3902bd}},	//   _bastıru_, _difikilt, _abans_, _аралашыр,
   {{0xc03fb0a3,0x78472141,0x1b63f30e,0x8a31606a}},	//   _vertalin, _захария_, _रिजनल_, _विश्वकोश_,
   {{0x2d9f7020,0x22da51ba,0xf6437428,0x620092df}},	//   _emonstra, _attesa_, _leikriti, _nakiti_,
   {{0x32fd703c,0x02a4f14f,0xa2fde28c,0xe2efc129}},	//   _spagna_, _राजपुत्र, _muzikos_, _arminia_,
   {{0x52d81100,0x6b6a0114,0xec66b1d4,0xb2da004a}},	//   _kahel_, _bakteria_, _partiit_, _kupeta_,
   {{0xf9fb1057,0x28e92287,0xc0424264,0x1731a0f4}},	//   _maramure, _партугал, _رووووووع, _ئۈلپىتىل,
   {{0x49d94162,0xd14520d2,0x6ab6e455,0xa30520de}},	//   _دوستقا_, _курман_, _dichrois, _кургак_,
   {{0xf177244f,0x22eee149,0x24b930ea,0x72019267}},	//   _вести_, _afifio_, _प्रेमका_, _jisie_,
   {{0x527ff039,0xdfc2d0d2,0x67ed427a,0xc3f82141}},	//   _thung_, _تاگور_, _futbalov, _makul_,
   {{0x92ca630a,0xc135f09b,0xee572264,0xbe23e008}},	//   _abiliti_, _bekrigön_, _فرفشة_, _берилмей,
   {{0x43ac713a,0x1e49007c,0x0179e3af,0xe38ce10d}},	//   _respek_, _angaziba, _conhgyah_, _музея_,
   {{0x6fc231ca,0x53860195,0xb345b368,0x2163256c}},	// [fd0] _ژایوس_, _njira_, _graduet_, _починал_,
   {{0x7c683154,0xd27e92e4,0xeb954012,0x2317126d}},	//   _петрика_, _ebank_, _mazingir, _akanyang_,
   {{0xc3877130,0x930050ef,0xa2aa31f3,0xf2bca0e9}},	//   _anaran_, _halaiki_, _وسیلہ_, _mandell_,
   {{0x920200ec,0x772621ca,0xb77cf293,0xc2921177}},	//   _besimi_, _ہوشہٕ_, _abavandi, _anqasa_,
   {{0x8aea6126,0xc54a727c,0x8c70f151,0x4e496031}},	//   _barthele, _アクセサリ_, _tojsiab_, _ከጥንታዊ_,
   {{0xa527f328,0x8ce61105,0x94d0108a,0xb1898063}},	//   _qaritauy, _איבריג_, _البلاوي_, _senatorl,
   {{0xe74ee25c,0x23805067,0xbc0eb03e,0xc290322d}},	//   _اتابابال, _latrik_, _atupale_, _opmaak_,
   {{0xf290e25a,0x53f820d7,0x960aa03d,0xd3450191}},	//   _monato_, _fakul_, _abambeki, _tildelt_,
   {{0x627f74d7,0x09cdf4ad,0xac0952ac,0xa0f9c248}},	//   _isanga_, _baperofe, _بوودجه_, _ተጸንቢሩ_,
   {{0x830e0100,0xd27f7256,0xf8c045de,0xa3f88438}},	//   _sapatos_, _asanga_, _सांप्र_, _kukuba_,
   {{0x1290a204,0xd342129d,0xe2911263,0x8292503c}},	//   _sedang_, _skreaun_, _micasa_, _ettari_,
   {{0x71d7a020,0xe6565144,0xb6d2013c,0x32c94185}},	//   _orderway_, _afungelw, _аднаулеи, _malloch_,
   {{0xa88a30a0,0xd2009218,0xfe48a100,0x8bfe5358}},	//   _رسميت_, _riail_, _makataba, _триникси_,
   {{0x903d60df,0xc2ea02c4,0xe2cb022b,0xe37bb267}},	//   _onventio, _beriman_, _ibadat_, _mahadum_,
   {{0xc3ead277,0x42ea8206,0x529024be,0xf27ee1c6}},	//   _cuotas_, _helical_, _nemate_, _spinta_,
   {{0xd34481b6,0xf924e115,0x42d85018,0xe3000161}},	//   _kreditu_, _cavalièr, _calea_, _achanzi_,
   {{0x994160f0,0xc2d900c0,0x4387f1df,0x72f502ff}},	// [fe0] _commence, _apondre_, _estro_, _chandoq_,
   {{0x534aa4f5,0x286b72c3,0x4e7231ed,0x70f48116}},	//   _خریداری_, _эстетика, _постына_, _कर्रूँ_,
   {{0x41e6e225,0x2f330089,0xe27f7196,0x7e1d01d9}},	//   _словенеч, _forewarn, _esanda_, _اشىمايدى_,
   {{0x4c0ed345,0x3b4c4031,0xb7a9141d,0x3c0a4177}},	//   _teatamis, _ከመስከረም_, _دوستانہ_, _agarraab,
   {{0x22e82143,0x615ba064,0xb340b12b,0x4b9230ca}},	//   _bibilia_, _添加到收藏夹_, _maketin_, _anantapr,
   {{0xe89303a1,0x8d8860f7,0x5bbe423c,0xf7597003}},	//   _abakalud, _défense_, _часовник_, _निस्पंद_,
   {{0x992073ab,0x8de071b0,0xe82071b0,0x766071b0}},	//   _mobilní_, _mobilné_, _mobilný_, _mobilná_,
   {{0xed8f72dd,0x1290c0ef,0xe2d8c075,0x22d8110c}},	//   _kuhlanga, _fulani_, _izleti_, _baheb_,
   {{0x62b4d09c,0xfc57806a,0x1b1a8248,0xb33100de}},	//   _chocho_, _ट्रेक_, _ኩዉንነት_, _ابونىتتو,
   {{0xc498213f,0xf201d2bc,0x0a1440ff,0x5be0e0c0}},	//   _מתמטיקה_, _unwin_, _vakantie, _artenher,
   {{0xc71a30bf,0x83f880db,0x337444b4,0x0278a246}},	//   _закачкал, _athuto_, _labultam, _aukilani_,
   {{0x1909024f,0xe407306a,0x92d8515d,0x42c2109e}},	//   _ippassaq_, _संसदेत_, _kalen_, _obalama_,
   {{0x5c1fc07e,0xeb0b708a,0xe2cb7238,0x13ea91b3}},	//   _slipper_, _abaswele, _peadra_, _etate_,
   {{0x13a8e1ab,0x628e038b,0xa27a31b5,0x9fb365df}},	//   _dalawang_, _parkson_, _ءۋالي_, _कलाकारले_,
   {{0xd23cd026,0x8e2850df,0xc9cdd10c,0x7c51d1b3}},	//   _환영합니다_, _uestionq, _alefabet, _tentava_,
   {{0x227f7533,0x0d44b07f,0xc3fa711a,0xfc7c10c5}},	//   _usanga_, _аелектро, _itsura_, _arasama_,
   {{0x4278717d,0xdc67b137,0x1012f3ef,0x03a2547e}},	// [ff0] _kaunis_, _libreng_, _imediaso, _colps_,
   {{0x5a8ca0f5,0x4e7380ea,0x9b1f81d8,0x059c916c}},	//   _optionen_, _दृष्य_, _rohangan_, _imigrasy,
   {{0xf3f820ee,0x7489f20e,0xf200f216,0xf42a81ac}},	//   _jakub_, _опасност_, _ligia_, _malahelo_,
   {{0x95f3a517,0x071253c4,0x138660fe,0x8527f092}},	//   _момента_, _construí, _ijoro_, _qarirauy,
   {{0xcdaf9388,0x0c5d01c2,0x1abf706a,0x938660bc}},	//   _سیمیناره_, _mortero_, _berjalan_, _ajoro_,
   {{0xfeaf2174,0xf85f5550,0x40737393,0xaa0a0169}},	//   _kretanje_, _entregas_, _concepto, _mataarbe,
   {{0xaa58a198,0x03df71a0,0x1a43b01b,0x132070ef}},	//   _pergunta_, _beimalek, _меселеле, _ninyi_,
   {{0x1fdd7015,0x42d8e006,0x6968d443,0x147fa0ff}},	//   _gobierno, _kunena_, _antilite, _wettelij,
   {{0x53f8401f,0x325de3f9,0x9c93212f,0x5c27d24f}},	//   _samun_, _raffinem, _تاقاق_, _alcoallu_,
   {{0x83a733af,0xf5d150e8,0xe3a982c2,0xf2497293}},	//   _bityenz_, _produktó, _previse_, _ngamba_,
   {{0x32002004,0xd3eb0004,0x526c835a,0xf2d851eb}},	//   _mikir_, _ngatur_, _aakoko_, _aalen_,
   {{0x92fd5104,0x32910223,0xfd9ce4a2,0xf89031c7}},	//   _elegir_, _ambako_, _inceleme_, _авторлар_,
   {{0xcb7fe04b,0x0b6850c8,0xd8f90139,0x0317b13f}},	//   _چیلتانلر_, _atitinka_, _basaastu, _rescued_,
   {{0xe29155ce,0xe36bd1d2,0x6f91e0d2,0xd04b219a}},	//   _ingaba_, _nangdep_, _sindicar_, _aberpenn,
   {{0xc34330a7,0x2387f0aa,0x027f0238,0x2302a2c0}},	//   _odselio_, _akure_, _dianav_, _atubuye_,
   {{0xec30b3a1,0xc6c77319,0x62498249,0x1a45b256}},	//   _akasiris, _timsanph, _furma_, _mugesera_,

   {{0x541ab2b9,0x62d8e320,0x45d5114e,0x0386d261}},	// [1000] _frankrik, _cafef_, _রোজনামচা_, _scorsi_,
   {{0xb27e9221,0xb37f9336,0x4d8a00f9,0x7bd630de}},	//   _ubani_, _tokanga_, _danmarka, _اچىتۇۇنۇ,
   {{0x00942065,0x9168a2fc,0xa290d176,0xd49d3245}},	//   _ונהנים_, _sposobno, _wenang_, _angazenz,
   {{0x22497510,0x54fbd464,0x1828e273,0xc34f81ad}},	//   _agamba_, _práctica_, _hiệu_, _buffing_,
   {{0x9b7dd2ab,0xb2ca442c,0xe9a7d20e,0xf2da50ff}},	//   _prenumer, _galleri_, _лидерот_, _meteen_,
   {{0x838711bd,0x22d56133,0x414721d9,0xcaee9113}},	//   _sparty_, _motorka_, _дариға_, _pretinie,
   {{0x83869213,0x2d17923a,0x0e4a5122,0x165da065}},	//   _akaru_, _adelbert_, _incarica, _יבואו_,
   {{0xd20191a2,0x51181375,0x99a561ca,0xa4aa2248}},	//   _ensin_, _заңға_, _کھنجہِ_, _ብኣእምሮ_,
   {{0x55f7409a,0x82d98052,0xb276f012,0xf2f4440b}},	//   _мусулман, _ogres_, _miongoni_, _barnets_,
   {{0xc12f21a7,0x53f82003,0x5fd99124,0x0c0700f5}},	//   _minorité_, _pakub_, _анемец_, _wörter_,
   {{0x6ca313d0,0x6387415c,0x620043a4,0x8723c393}},	//   _хорвоо_, _wieren_, _nimis_, _impresió,
   {{0x727285e0,0x227ff363,0x7503506a,0x7236d45d}},	//   _povedať_, _sauni_, _अन्यायाव, _znojmo_,
   {{0x8efb317d,0xe40a2033,0x49092063,0x3975a1df}},	//   _страниц_, _ekonomiz, _бераман_, _atribuit,
   {{0x9c4e2004,0x6a45b256,0x39fe0046,0x0264741a}},	//   _زمینی_, _bugesera_, _novament, _opslag_,
   {{0x7de0a3ab,0x70d120af,0x62d8737e,0xd820a558}},	//   _povinné_, _この人とブロとも, _tanea_, _povinný_,
   {{0x627ef0ef,0xbc766067,0xe6eef1a6,0x92cad0af}},	//   _nyingi_, _adiriri_, _abhadalw, _kalder_,
   {{0xf27ed26c,0x8849b27c,0x174df27c,0xfb71810e}},	// [1010] _ocena_, _コメント記入欄を, _バックナンバ_, _उग्रवादि,
   {{0x93e3b105,0x17bd6175,0xda086222,0x65d370f9}},	//   _ברוסט_, _envestig, _limalist, _myndafrá,
   {{0x71941105,0xd54a12e8,0xee5281a6,0x2a507252}},	//   _ערכאות_, _labharth, _angavaka, _чехиянын_,
   {{0x92019218,0xd2da113f,0x127ff21f,0xbda73227}},	//   _ansin_, _papers_, _ebune_, _국가종합전자조달,
   {{0x2c6fd148,0x6207f266,0x7e3bc59c,0xa2d85176}},	//   _barudak_, _pasifiki_, _drinkers_, _malem_,
   {{0xa7125198,0x1387f374,0x6317201d,0x313205e1}},	//   _construç, _mhuri_, _beichte_, _gratuito,
   {{0xe3ea02c6,0x2e4424be,0x6394e2ae,0x6386f115}},	//   _quita_, _katapult_, _naiste_, _atirat_,
   {{0x433cc358,0x85e360af,0x28cda566,0x037c51aa}},	//   _глаза_, _広告掲載について_, _entendid, _baballe_,
   {{0xf3f820a4,0x61b4c008,0x4a87f21e,0x6cc17214}},	//   _kakua_, _ыздан_, _perindus, _ءﺗﻮراﻋﺎﺳ,
   {{0x4b7c61a3,0x1d5ac370,0xbae0d42a,0xa8b14115}},	//   _divulela_, _лоден_, _kortinge, _filtratg,
   {{0x13f82356,0x52c200a9,0xada1338d,0x827ff3c6}},	//   _makua_, _atalaya_, _akroobaa, _maunu_,
   {{0x0290e01f,0x753de0de,0x636a63ec,0x33ea02ea}},	//   _tunani_, _اسىقبەك_, _morgais_, _drite_,
   {{0xa247b2ab,0x3d65c225,0xc27ee2f6,0x43ea0033}},	//   _bendruom, _главно_, _mpinga_, _erite_,
   {{0xe27ef1da,0xcc749205,0x0290339e,0x53ea0272}},	//   _iyindi_, _arduous_, _jamach_, _frite_,
   {{0x33866130,0x528c7143,0xcb011262,0x82d652eb}},	//   _akory_, _alakisa_, _akoreshe, _афизикеи_,
   {{0x320042c8,0x3e591360,0x396f803c,0x126d63c0}},	//   _limir_, _شرمناک_, _prononce, _magomo_,
   {{0xcc7c5095,0x5f3f9288,0x6a84d009,0x972ae248}},	// [1020] _barrels_, _belgilan, _ukuzinge, _ብምጥማት_,
   {{0x527ff5bd,0x4553008a,0x52920262,0x7135a0f9}},	//   _jaunu_, _abakuluh, _impano_, _gundadal,
   {{0x4340600d,0xcb03906c,0x0a32b005,0xc8965226}},	//   _agadiir_, _saksamaa_, _называлі_, _शत्रुपक्,
   {{0x334c7018,0xdb7c107e,0x1c178090,0x06e043c9}},	//   _nivelul_, _aktuella_, _bakanyer, _sanctifi,
   {{0x7387f200,0x0b8e6579,0x82fce0d2,0xe37fd1f0}},	//   _churi_, _اتكارۇۇچ, _tingut_, _belaela_,
   {{0x52fe85e2,0x6f64d0d2,0x4166013f,0x127f7395}},	//   _inviter_, _экспертт, _חילופי_, _asanka_,
   {{0xcf53d036,0x04ddd1a8,0xd2d98079,0x035cd155}},	//   _домашни_, _французы_, _egrer_, _достуңла,
   {{0x6c6f61ce,0xa2d8705a,0x8c2a30a2,0x4f4af272}},	//   _dourada_, _manel_, _ګړدود_, _geoplant_,
   {{0xf316e4e2,0xcf418200,0xb33d0096,0x6f46e14c}},	//   _seizde_, _churaska, _مینار_, _অপছন্দ_,
   {{0xd2ca74d5,0x8a57311b,0x8b6b82fa,0x0fe0b14c}},	//   _munde_, _милана_, _aikonzer, _বিলম্ব_,
   {{0x0cd7257d,0x8290312e,0x7387f181,0xe619d0f9}},	//   _لعلاج_, _ramach_, _shuri_, _hundrað_,
   {{0xcbf58597,0x22d5805e,0x2e559137,0x5348045b}},	//   _कांग्रेस_, _fanongo_, _katangia, _scherzi_,
   {{0x820194ff,0xf92fe29e,0xe7a83064,0x13eae2ae}},	//   _bisin_, _augmente, _librairi, _esitab_,
   {{0x12fca060,0x5a93d1e2,0xc65ae119,0xdebca050}},	//   _apricot_, _мондани_, _akikilli, _一中各表緊掐台灣_,
   {{0xd2d8e24a,0x504d30b5,0x142b72e5,0x73f5d1c7}},	//   _kafee_, _كلارا_, _podarilo_, _ﺳﯘﻳﻪﻣﻪﻟﺪ,
   {{0x84fc1009,0x19ffa003,0x3e499248,0xe394f152}},	//   _установк, _आक्रामकत, _መለኰታዊ_, _naiset_,
   {{0x78dc229b,0x522473d5,0x29128144,0x1a0a22f2}},	// [1030] _сурия_, _lenke_, _angataku, _rosalina_,
   {{0x7d90c037,0xd8b2c064,0x97a6b1de,0x32bd8009}},	//   _аенда_, _查看详细资料_, _protivni, _позволяю,
   {{0x4c35f206,0x1b59751f,0xe24902e9,0xb5ffe026}},	//   _temporib, _tentunya_, _chamwi_, _vermeldi,
   {{0x53f40383,0xf8a41456,0x8c75011e,0x15d59293}},	//   _lister_, _प्रश्नोत, _hyosung_, _batangiy,
   {{0xf27ff592,0xf2d511cd,0x13ea9213,0x33a9a4cf}},	//   _taunu_, _vanligt_, _atati_, _najsmešn,
   {{0x5941921f,0xe4ec8180,0xe3f820f3,0x1b3d9031}},	//   _overseer_, _キャッシング_, _cipriani_, _ተባባሪዎች_,
   {{0x82ca73b0,0xe3ea658e,0x127f0181,0xc2d810af}},	//   _hunde_, _atoto_, _ayandi_, _nyhed_,
   {{0xd2247053,0x8250c481,0xde559278,0x0bf853c2}},	//   _denke_, _ренат_, _fatangia, _abatasob,
   {{0x2bdf41fd,0x0a5e044c,0xed8d6101,0x83499008}},	//   _yemekler, _лондонги, _kalobora, _meredow_,
   {{0xf2660482,0xf9df903b,0x82d80113,0xd698117d}},	//   _osaragel, _afunelwa_, _remonts_, _контроля_,
   {{0xfc00f378,0xc2a061c9,0xf30e11b9,0x1757809a}},	//   _loksins_, _corbin_, _arabela_, _тайлор_,
   {{0x85d59098,0x16f07218,0xf9f9a442,0x33957069}},	//   _yatangiy, _الوندوز_, _achamure, _ifashe_,
   {{0xc341c012,0xba6cc0db,0x67b58096,0x4179f1df}},	//   _انعام_, _илгиз_, _عاشورہ_, _respondo,
   {{0x107411ca,0xf3870286,0x3200f30a,0xf9b88303}},	//   _مضموٝن_, _tubrog_, _digim_, _театру_,
   {{0x12d8a165,0x203e213b,0xd2c9404d,0xdd131030}},	//   _haben_, _ilitarin, _eallach_, _қурултой_,
   {{0xf8ca3011,0x03eb009b,0x885c848e,0x4942b14c}},	//   _nostálgi, _diatek_, _deintydd, _পালনে_,
   {{0x030e40cf,0xaf697038,0x154900f7,0xf394e10b}},	// [1040] _matapos_, _वाढदिवस_, _情牵汶川大地震_, _ajisha_,
   {{0xd251d425,0xc39e54b2,0x82c072f2,0xa4851153}},	//   _aretikel, _playler_, _rouminq_, _arrangör,
   {{0xc7b65050,0x1108d241,0xb7b3f13b,0x1f3b5111}},	//   _唯一的唯一_, _абеба_, _ivaraigi, _apartena,
   {{0x6c5d7585,0xdb0c701a,0x3c00b086,0xf7cc7469}},	//   _viettel_, _possible, _possunt_, _possibli,
   {{0x4c6aa0a8,0x0c4e25e3,0x52d5802a,0x1321e0ca}},	//   _गुल्मी_, _नियुक्ती_, _deflect_, _antya_,
   {{0x80685174,0x72d8709c,0x0db9b438,0xf2d0547d}},	//   _neophodn, _aanee_, _abanobha, _bhaltar_,
   {{0x529152c1,0x23b02429,0x09da1031,0x23600065}},	//   _sigara_, _clavado_, _ያሳድጋል_, _המעיין_,
   {{0x24fba0ea,0x39c1d0e5,0xb066d199,0xf529e09c}},	//   _घोटाला_, _सांचे_, _stratego, _godinich,
   {{0x59f67294,0x8308615b,0x8667a4a7,0x7c56923c}},	//   _merçi_, _bagarap_, _alokilaf, _mettere_,
   {{0x23ea03ce,0x5ba692b2,0xdecb8469,0xb2542116}},	//   _buite_, _भारतले_, _samidean, _अमरइया_,
   {{0xbdc803d7,0x32e9738d,0xf2f522f5,0x18b6d15d}},	//   _अध्यापक_, _afrikaa_, _burioum_, _گرديد_,
   {{0x0a85d288,0x52d83317,0x9472e21d,0x19c5d108}},	//   _шундай_, _kement_, _प्रभो_, _шундан_,
   {{0x23ea626b,0x99b6b104,0x5f23839b,0x327ed367}},	//   _utoto_, _pendient, _biletsan, _ocene_,
   {{0xa39e5086,0x344f3248,0x19e03149,0xf38b9159}},	//   _draynor_, _ተጽዕኖን_, _alagatat, _máris_,
   {{0x848620c3,0x32d8a01f,0x531d40bd,0xc2d85196}},	//   _stručnja, _zaben_, _kopiereg_, _kalea_,
   {{0xcde0c0fb,0x42fce289,0x129110b2,0x25e88319}},	//   _संस्कृतम, _divizet_, _nicaea_, _ôxtrâyli,
   {{0x7dfa113f,0xd4ed514c,0x13ead0da,0x35d410b1}},	// [1050] _הכפתור_, _বেহাল_, _stete_, _islaamiy,
   {{0xf5bfc1c2,0x53517270,0xcac0921a,0xf27e05e4}},	//   _alliktam_, _diserap_, _techniką_, _ucini_,
   {{0x20add3b9,0x325a5199,0xf290c4b0,0x9e2a629a}},	//   _اشاره_, _felly_, _izdao_, _menghada,
   {{0x3c610069,0x2eb172fb,0x5ab44080,0x127e64e4}},	//   _kurusha_, _diferans_, _sirvient, _ncono_,
   {{0xdb8831d0,0x5e48305b,0xc27e6419,0x6d62a180}},	//   _pacifier, _شيرون_, _icono_, _読み込み中_,
   {{0x12002120,0xefc520f6,0xc01bf2bf,0x92d87395}},	//   _makit_, _аграмлы_, _atawuren, _sanee_,
   {{0xc2d8a004,0xd4132352,0xe29080c4,0x62d8c13f}},	//   _saben_, _ماندا_, _zikaba_, _laden_,
   {{0x0e48c01a,0x3e0a4548,0x423210fe,0x42efd356}},	//   _ويرون_, _тропикал, _akamaro_, _pilikia_,
   {{0x0d380009,0x2c6053c1,0x325ad45b,0xe2e07212}},	//   _дальнейш, _platser_, _isoler_, _abenako_,
   {{0x275342f4,0xeeab10f6,0x62ee82b7,0x8386047b}},	//   _телевизэ, _астындак, _tsanani_, _ijiri_,
   {{0xa29055a9,0xa50a0057,0x834a0241,0xf3957220}},	//   _azlan_, _domeniul_, _domeniu_, _ufashe_,
   {{0x13076304,0x8f7b702b,0x604ac19a,0x1a2be0af}},	//   _bimbang_, _غنیمتھ_, _peiriann, _オプション_,
   {{0x320e120d,0x42d8c0fd,0x5affa126,0x7881721d}},	//   _гарах_, _jaden_, _boroatun_, _महावीर्य,
   {{0x5470013f,0x83f8b004,0x8200215e,0xa95a0248}},	//   _יזרעאל_, _macul_, _dakit_, _ንተቓውሞ_,
   {{0xc12d109a,0xe5b972e9,0xe29030d7,0xd200923a}},	//   _вақти_, _bilachch, _kamada_, _khaid_,
   {{0xe288400a,0x026c0199,0x4926f09a,0x57ed4221}},	//   _methods_, _gwion_, _муддәрис, _engalung,
   {{0x40418063,0x3c87b13c,0xe3f88113,0x79e1209e}},	// [1060] _زمانوی_, _драматә_, _tukuma_, _ratovima_,
   {{0x8ad87050,0x2d91e040,0x8292709b,0xeaf1b078}},	//   _消化道出血_, _batlhjup, _kosada_, _characht,
   {{0xa290c35a,0x85c22223,0xc00d80d1,0x42d83188}},	//   _hioana_, _مصالحو_, _erivalen, _zement_,
   {{0xc2d8c31d,0x67b36406,0xd975741f,0x33f46369}},	//   _baden_, _konstati, _burghdaq_, _airtam_,
   {{0xd3f471a2,0x9c51e39e,0xcbdf0085,0x4977e289}},	//   _kartat_, _muntaxa_, _comentó_, _skrivade,
   {{0xb290e356,0x420092fa,0x15baf594,0xd1d8c264}},	//   _iniana_, _nakiri_, _watakuch, _ويؤكد_,
   {{0x612d22ab,0xbf245135,0x52fce121,0x43860145}},	//   _часта_, _መናፍስቲ_, _mingit_, _ejiri_,
   {{0x4290622e,0x6f875075,0x92ef5313,0xa700f1c5}},	//   _islas_, _tišine_, _raffia_, _besteigä,
   {{0x12d8c368,0x22010343,0x627b8234,0x6f7122e2}},	//   _gaden_, _agaioi_, _orientác, _advantis_,
   {{0x8c618168,0x2fa3012e,0x1ed97264,0xf3e0516b}},	//   _overige_, _dyrektor_, _احتياجات_, _hlstatsx_,
   {{0x93ea9299,0x72903127,0x2c05f1e2,0xf2d9b249}},	//   _stato_, _tamada_, _ekuseni_, _savens_,
   {{0xfe52306a,0xd2b4e200,0xd2eab1df,0xec76c00c}},	//   _dikataka, _punchu_, _pozicio_, _averesi_,
   {{0xb27ff3a8,0x0248324a,0x61af13ea,0x43f460ea}},	//   _mbung_, _nimmen_, _adamukum, _koutek_,
   {{0x80bf3071,0xb2ea130a,0x65874394,0xf389d052}},	//   _nammentl, _desison_, _mistunak, _māris_,
   {{0xf20141c3,0x76ea929b,0x90216110,0x8184a2ff}},	//   _breith_, _абдуллоҳ, _hardwick_, _biratlhl,
   {{0x7fa25150,0x953c53df,0x8907c16f,0x36b91421}},	//   _nedenfor_, _установо, _disponig, _afgaansi,
   {{0xe200f3af,0x73d501c6,0xe85161b3,0x90e5b14c}},	// [1070] _digih_, _adottati_, _astutias_, _জুরাইনের_,
   {{0x7f5f30a3,0x02009200,0xbe9440a2,0x03f88207}},	//   _hospitaa, _jakiri_, _abamelan, _hukuka_,
   {{0xccf2c466,0x529182b7,0x66e9d056,0xe36b1277}},	//   _عالمي_, _ziyara_, _tlhagišo_, _добредој,
   {{0xf2918054,0x07bc31f6,0x469bb5c7,0xfed9610e}},	//   _siyasa_, _zatrudni, _गृहयुद्ध_, _kulinarn,
   {{0xa3ead4ee,0xf29df39d,0x64c85031,0xd25ac1cf}},	//   _hteti_, _manjina_, _በስልጠናው_, _mellen_,
   {{0x83ea035e,0x5d7f84bf,0xb99f1283,0x52009542}},	//   _kuita_, _ngamunye_, _alokuthe, _shaid_,
   {{0x337954a2,0xfc4de16b,0xbdb1b448,0x1673c2ac}},	//   _antalya_, _servizz_, _prinsipp, _فاتحی_,
   {{0x92d85075,0xaebac009,0x4739a1e2,0x79f6900c}},	//   _izlet_, _возле_, _инглиси_, _apineina_,
   {{0xe347c076,0xa1c3c018,0x82009181,0xe4a6d06a}},	//   _simeona_, _полония_, _bakiri_, _बंगालमध्,
   {{0x220040e2,0x0394f4ec,0x9c1de425,0xc9942037}},	//   _mamit_, _sonsuz_, _dikantor, _apqır_,
   {{0x72903308,0xa584f026,0xd30dc1a3,0x4c67105b}},	//   _timali_, _브라우저입니다_, _humbula_, _درياب_,
   {{0x9230531c,0xf2cae004,0x6d3ef0af,0xd9d1a338}},	//   _vremena_, _tindak_, _初めての方は_, _kolovoza_,
   {{0x33954165,0xd22ac0f6,0xae2cc48f,0xf27f7143}},	//   _diesem_, _ковал_, _владо_, _apanza_,
   {{0xe2e37309,0x52915221,0xe3ea00a4,0x9e9ec1a5}},	//   _bartimay_, _engama_, _buita_, _кабли_,
   {{0x0314303e,0x1b53007c,0x0485c0e8,0xa5dac0b5}},	//   _iranlọwọ_, _kukwakha_, _व्यावस_, _ﮔﺎﺯﻩﺗﯩﻨﻪ,
   {{0x2c02a06a,0x9b8ea185,0x82d8315c,0xdd26018a}},	//   _नेतृत्वा, _akannifo_, _gemeet_, _europene_,
   {{0x1223227d,0x12002114,0xa98ec15e,0x52c240a0}},	// [1080] _نگارا_, _homing_, _таних_, _ngelixa_,
   {{0x920042d2,0x432b4271,0x114691a9,0xf7c63221}},	//   _damit_, _procesy_, _جاپاكەش_, _abashici,
   {{0xf2ca706a,0x4a1f2483,0x48c7b3b6,0x22f0a195}},	//   _sunda_, _айрып_, _मणिपुर_, _kabichi_,
   {{0x52388283,0xd200920a,0x127f42d9,0x2389d4e7}},	//   _egameni_, _wakiri_, _asenia_, _pāris_,
   {{0xc2004424,0x8c70603f,0x62d8c0d3,0xd0f1327f}},	//   _gamit_, _लिट्टे_, _madem_, _پێشره_,
   {{0x266f9004,0xda77a1b5,0x588a93d5,0xb1680282}},	//   _prajanji, _сырдария, _matvarer_, _מעמארי_,
   {{0x12019171,0x22e9b0be,0x79e0a1cc,0x426d126c}},	//   _hisia_, _ideologj, _kalorija_, _odbori_,
   {{0x5200d109,0x8f8020f0,0x7512512f,0x96d070cf}},	//   _theia_, _prochain, _ﻧﻪﺷﺮﯨﻴﺎﺗ, _magagami,
   {{0x42009334,0xc7a420af,0x63b063b5,0x992180f7}},	//   _thaib_, _マの記事一覧へ_, _elevado_, _浙江省产品质量监,
   {{0x5200b11e,0x607c31b5,0xe4fd208a,0x1aab50dc}},	//   _bicis_, _ستامبول_, _اجندا_, _travessa_,
   {{0x71862198,0xc2f2122c,0x9bb64121,0x6f6f3339}},	//   _економск, _molimau_, _न्यूट्रा, _komandas_,
   {{0x04ba1061,0x3edca12a,0xd9c7c005,0xf339a441}},	//   _سفرناما_, _actiones_, _палаца_, _богатите_,
   {{0x1f9c60af,0xbf2bd088,0xf2b5711d,0x2c08109a}},	//   _このブログをリン, _kebudaya, _chacho_, _сәуди_,
   {{0x5e5c7198,0x3c7740fb,0x22927052,0x02d100c3}},	//   _коалициј, _पूर्वे_, _nosaka_, _povodom_,
   {{0x0e911016,0x701d103d,0xbb561088,0xa201915e}},	//   _mystère_, _اتباعو_, _berwarna_, _aisia_,
   {{0x7c00b086,0x57a9915c,0x8d2e33df,0xd2e9723e}},	//   _possint_, _sportspi, _набагато_, _bariwaa_,
   {{0x48dc23d0,0x936bf1f8,0xc2ea01a7,0x42b49376}},	// [1090] _шутис_, _dimenzij, _acrimen_, _kwace_,
   {{0x12cb7203,0x11fd34e5,0xe83220c5,0x232075e5}},	//   _abadde_, _amrisaam, _aramwiru, _sanyi_,
   {{0xf9f6601a,0x93ea62ef,0xa99f1248,0x0249a2f4}},	//   _força_, _grote_, _ንምግልጋል_, _бизнесмэ,
   {{0xe321e293,0x7523d16e,0x6f62c366,0x4e4de3ba}},	//   _bityo_, _поздрав_, _sebalikn, _nazalost_,
   {{0x8201f55d,0x02b4e38b,0x1617b2b6,0x89e3c3bf}},	//   _inuit_, _vincom_, _opposizi, _показа_,
   {{0xf2004140,0xc27ed187,0x32019004,0xb3f962f4}},	//   _ramil_, _mponda_, _sisih_, _dugula_,
   {{0x72489322,0xaf081065,0x656ba009,0xe36630f6}},	//   _akame_, _התעסוקה_, _скажите_, _ашырян_,
   {{0x4223c04c,0x8379b55e,0x97fa4217,0x9f34d270}},	//   _تدارک_, _abirabam, _alabugag, _kehutana,
   {{0x62019309,0xb2a77300,0x0200430a,0xb34134f5}},	//   _visih_, _arabeg_, _bamim_, _خندان_,
   {{0x5018c0c3,0x9b2750f0,0x4a6c0220,0xbb44f2cd}},	//   _preporuč, _rembours, _habonets, _barcodes,
   {{0x32268248,0x4ca4b07e,0xd29272fa,0xd090c330}},	//   _ውልቀምልካዊ_, _bakgrund_, _aisava_, _内蒙古自治区_,
   {{0x23f96195,0xdd918155,0xc405f30e,0x3300c0c6}},	//   _kugula_, _رەۋىشتە_, _doručení_, _dawasih_,
   {{0xbdb58207,0xc274d0db,0x77ca101c,0x9139533c}},	//   _olanakla, _batsetel, _energiaf, _фармонла,
   {{0x73a9c342,0x529030c1,0x6e2a4248,0xd137d0af}},	//   _تزداد_, _mamaya_, _ከይወደኣ_, _landshol,
   {{0xc200031e,0x4ad8e0ab,0xa48c40de,0x8b9c00f4}},	//   _abiil_, _umiddelb, _اتقىچا_, _تەيىنلەن,
   {{0xe8c5d20e,0xb3f0e05e,0xd27ed2d9,0x6147e1c3}},	//   _атрактив, _feluteni_, _wonnye_, _caillich_,
   {{0x6af7b21c,0x010ee008,0x435d40f7,0xa31d7132}},	// [10a0] _konsumat, _айдандыр_, _régime_, _discuta_,
   {{0xeaf7b018,0xd3177356,0xa2d8c126,0x8bf7224b}},	//   _consumat, _ahazia_, _sulema_, _жителей_,
   {{0x9290b0ed,0x32c5a150,0xc944b422,0xaf2b02f2}},	//   _indawo_, _stemmer_, _promptne, _qaytarma,
   {{0xe3c8f434,0x3248624d,0x12fc0179,0x3394e064}},	//   _форумите_, _thomi_, _leigu_, _laisse_,
   {{0xaef12152,0x039570bd,0x7c75a3af,0xc1422043}},	//   _образом_, _laaste_, _byasang_, _стран_,
   {{0xafb50248,0xbc2400bf,0x85759387,0x7fd7f063}},	//   _ምቁጵጳር_, _aylantir, _agologaà, _aksiyado,
   {{0xba446393,0x427e9051,0x0200919d,0x239572b8}},	//   _necesita_, _scant_, _abaid_, _naaste_,
   {{0x8f0ef174,0x82317135,0x52b7d0f6,0x120041f8}},	//   _примећен_, _shumica_, _алинизде, _samim_,
   {{0x8410b01d,0xf387007e,0xd2d83381,0x5810223f}},	//   _tauschen_, _starkt_, _aimeha_, _concedig,
   {{0xab6d3027,0xe7e33043,0xa2da4271,0x329ad3f9}},	//   _enconusc, _ролики_, _hranice_, _способів_,
   {{0x9c749213,0x43354454,0xa6b402f2,0x2f340421}},	//   _altupat_, _compañía_, _abdullay, _abdullaa,
   {{0x2b7480ac,0xb2fc55bd,0xd0ccf0e4,0xe5a250fb}},	//   _개인정보보호_, _papildu_, _ansorsel, _भारते_,
   {{0x72da54e6,0x827f7285,0x3a89024f,0x7c339065}},	//   _gutera_, _mpanga_, _misilits, _קארין_,
   {{0x4c23140b,0x327ee2a2,0x3394e0c8,0x220022c1}},	//   _mulighed_, _gainen_, _keista_, _rakip_,
   {{0x53e73437,0x1c95d5a0,0x20dc5031,0xe5dc5031}},	//   _måtte_, _амбасада_, _በመመስረት_, _በመመሥረት_,
   {{0x43ea9284,0x877ab225,0x92da41f8,0x9b8b817d}},	//   _irate_, _спортови_, _granice_, _seminaar,
   {{0x22639129,0xc2d983f4,0xd3bea26d,0xf9ecc0bb}},	// [10b0] _definiti_, _eared_, _baswing_, _albumsid,
   {{0xd2d47238,0x59e871f2,0x6313d140,0xe3dd3022}},	//   _hirder_, _kapteinu, _ремонтла, _талантты_,
   {{0xb987f49b,0xfbd8c152,0x126cf336,0x0b0af22f}},	//   _basilika_, _сначала_, _enioku_, _vlasnika_,
   {{0x420021fd,0xdc80c20e,0x89c240e5,0x1316e4d7}},	//   _takip_, _девет_, _ढांचे_, _agizwe_,
   {{0xd2da5052,0xe02065e6,0x0201941f,0x22e9c16e}},	//   _atrodas_, _numeroso, _bisiv_, _делова_,
   {{0x72fc94fe,0xdc7fc56f,0xd42c4380,0x5645e008}},	//   _leago_, _gällande_, _separado_, _etekleri,
   {{0xc9580031,0xd3207004,0x7f631113,0x8b0db2a7}},	//   _ወልደገብርኤል_, _banyu_, _finanses_, _دسیمبر_,
   {{0x735b617d,0x2184514c,0xbef45182,0x073ac1a2}},	//   _достоинс, _সলিমুল্ল, _anavarop, _мозги_,
   {{0x52d9838d,0x2b893078,0xe76ae063,0x157ca455}},	//   _maree_, _thairisc, _айлантир, _handfull_,
   {{0xb1e78162,0x5c06d271,0x8394e078,0x0a9eb102}},	//   _ﺋﯩﻠﮕﯩﺮﻯ_, _ostrovy_, _paiste_, _aarhanen_,
   {{0x6c5c60cc,0xc8d162a0,0xdc56a0be,0x30c7c340}},	//   _সমগ্র_, _ئیحسان_, _partive_, _дивине_,
   {{0x0e9f03a5,0xb753a21d,0x4955532d,0x741a8031}},	//   _ngamalun, _पुरस्ताद, _puraskṛt, _የመስሪያ_,
   {{0xadbc43f1,0x56ce40bf,0x243e1370,0x5f6c4188}},	//   _bulgarie_, _jarayoni, _карни_, _verbrann,
   {{0xdc05d1b7,0x53207293,0x0f1f325b,0x1925d4ec}},	//   _overway_, _zanyu_, _saltanga, _şanlıurf,
   {{0x01d13263,0xe7d0c4b2,0x43207262,0x3a2010f7}},	//   _остонаи_, _congdong, _yanyu_, _中国地震局_,
   {{0xd27f4435,0xfe45f124,0x07e7e192,0x88b20121}},	//   _mpenza_, _афракциа_, _башлауы_, _heategev,
   {{0x829031d8,0xcee02083,0x42a68124,0x5321e2e2}},	// [10c0] _kamana_, _ىچكىچ_, _аланархә, _sitye_,
   {{0xd3c5f150,0x7920f1bf,0x1c5202c0,0x13a38129}},	//   _virkelig_, _адверсар, _amatuma_, _korpi_,
   {{0xa27fd3c8,0x3c6793e6,0xb2489186,0x02da13ce}},	//   _pawns_, _tukunga_, _shami_, _wapens_,
   {{0x8e68359b,0x699e1245,0x8d7de403,0x1e716121}},	//   _अनुभूति_, _isikhoke, _abamanga, _जिल्द_,
   {{0x8d6ec009,0x920193c9,0xec6193fa,0x24369251}},	//   _советско, _misit_, _abereke_, _автобусо,
   {{0xb2903130,0x73b632f4,0x03f4041b,0x33f9712b}},	//   _namana_, _хайрын_, _gister_, _brauza_,
   {{0x0290b139,0x92e31185,0xc0a9f2f4,0x228f40f7}},	//   _sudaan_, _akunkum_, _инфляци_, _中国中小企业安徽,
   {{0x3631340b,0x1248926d,0x327ff4e7,0x924bd12f}},	//   _お問い合わせ_, _okama_, _jauns_, _دىگۈدەك_,
   {{0xd37b8105,0x225144c4,0x47a9544d,0x921ab0d7}},	//   _פּטור_, _deltagel, _studenog, _balanıñ_,
   {{0x52eb726a,0xec4454cc,0xcd39e069,0xb7b52422}},	//   _medical_, _isewula_, _urupapur, _parentag,
   {{0x32489344,0x92c5d009,0xf200f04b,0xa2d911ed}},	//   _akama_, _lihlale_, _yigit_, _gazel_,
   {{0x157731b3,0x4a9540c7,0x927681bc,0xbd92826d}},	//   _sentiero_, _انسانس_, _акциясын, _atlegile_,
   {{0x822b43a3,0x62fd3101,0x2b1e8085,0xb27f816e}},	//   _poradiť_, _manhole_, _সাম্প্রদ, _poznat_,
   {{0x2309c5aa,0x2988856c,0xc24592c8,0xd342328f}},	//   _também_, _местото_, _dámar_, _excepto_,
   {{0xf25403a4,0x527ff37f,0x9cccc009,0x32ca741a}},	//   _bitterbl, _mbuna_, _ближе_, _sunde_,
   {{0x7c569299,0xd547a0b4,0x8da5e200,0x92f30024}},	//   _settore_, _kaikuwah, _uchuniru_, _योगयुक्त,
   {{0x727ff030,0x5ac5f1de,0x937d3271,0xd38db018}},	// [10d0] _obuna_, _privreme, _chlapec_, _grupului_,
   {{0xa2915181,0xf2ec91fe,0xc234137b,0x8250721b}},	//   _ingana_, _addinab_, _pozdravi_, _vélin_,
   {{0x5f45320f,0x1a17b213,0x09ec4113,0x930f52b7}},	//   _formalaş, _chachata_, _kabineta_, _fasahar_,
   {{0x023bb3f4,0x5863c340,0x827ff19f,0x301a54a2}},	//   _adamant_, _вокация_, _abuna_, _geldiniz_,
   {{0xb31bf4bd,0x62d7f099,0x8386d492,0xf2019114}},	//   _tapasā_, _nemozem_, _fjern_, _jisim_,
   {{0xab7731c5,0xcbd110a8,0xe371f0d7,0xe133f47c}},	//   _beravön_, _projektů_, _bitaraf_, _softwaro,
   {{0x83d52242,0xd2d52516,0x5b552178,0x6ac1a064}},	//   _kontakti_, _kontakty_, _kontakta_, _情节严重的_,
   {{0x399a4242,0x1641c11b,0x730f802b,0x3e7300ef}},	//   _atpakaļ_, _стари_, _نظرنٕے_, _امتحانن_,
   {{0x3683200f,0x6c22d3cd,0x7c898085,0x003d9036}},	//   _послуги_, _zebrafis, _কাঠগড়ায, _attenzio,
   {{0x7000d1ca,0x860fe248,0x5db57435,0xbe4890f7}},	//   _یرِہے_, _ዘይተባህለ_, _akangola, _最高人民法院关于,
   {{0x831e5108,0x690a010f,0x438770b4,0x18c53297}},	//   _васаллам_, _مریضوں_, _azaria_, _spreagad,
   {{0xcd9d501a,0x77386227,0x324e1087,0x92fce0e3}},	//   _connecta, _것만으로도_, _bildedim, _aangal_,
   {{0xf25ae1fe,0xc546c43f,0x129032f8,0x42fcd3bb}},	//   _dooley_, _zároveň_, _tamana_, _pulgar_,
   {{0x88898410,0xeb2dc21e,0xd3f471f8,0x3695527f}},	//   _макалала, _tembakan_, _unutar_, _سنیشان_,
   {{0x45a150ea,0x12d880a1,0x1c6b4345,0xf2903202}},	//   _प्रत्याय, _lekere_, _कुर्मी_, _ramana_,
   {{0xdd5c01d9,0x53ea9006,0xf3ea00ec,0x7d785244}},	//   _تۇتۇق_, _itatu_, _drita_, _tiempomp,
   {{0xf92d7026,0xbb77b290,0x03ea047b,0x32d5813f}},	// [10e0] _자바스크립트를_, _रेग्युले, _erita_, _reflect_,
   {{0xd2da63b2,0x63ea213b,0xf8336248,0xfcedf2ac}},	//   _spreme_, _tuktu_, _ጽውጽዋያት_, _ئاکیلدرم_,
   {{0x5d99c42f,0x72eac30d,0xe2f54123,0xc8fd4034}},	//   _actorsfa, _usiness_, _fernwar_, _поставян,
   {{0x02d880bc,0x322453ce,0x3dc9223f,0x32ee5580}},	//   _kekere_, _volke_, _cichlida, _wonntsi_,
   {{0x422453ad,0x458eb220,0x8b6d000a,0xe061c264}},	//   _wolke_, _amadosiy, _disorder, _لنصرة_,
   {{0x82cad4dc,0xd859114c,0xf248f49b,0x3290305e}},	//   _valdir_, _আইসক্রিম_, _shimti_, _hamala_,
   {{0xe3ea0291,0x7324f2e8,0xee42c00d,0x30453366}},	//   _crita_, _nascadh_, _alkaande_, _argumenn,
   {{0xddaa2200,0x73a38111,0x6dabf180,0x62caf1d8}},	//   _isinisip, _korpo_, _課題を解決するた, _kandar_,
   {{0xa2292217,0xd3ea9195,0x9264635a,0xd7248031}},	//   _läkin_, _atatu_, _liuliu_, _ኢንተርፕራይዝ_,
   {{0x45ec909b,0x929033fa,0x22016177,0x674ba07f}},	//   _bedekefö, _mamama_, _aggili_, _акадртә_,
   {{0x42ca717e,0x8229b03e,0xf2da6094,0xeb78a42a}},	//   _hunda_, _nìkan_, _berean_, _vergeten_,
   {{0x620020e3,0x8d6f50de,0x5b7bd025,0x25fff14c}},	//   _bakit_, _شەرمەندە_, _adesanya_, _বোধগম্য_,
   {{0x427870e1,0x82915346,0x0c61c0aa,0x9c1ee2f4}},	//   _bernat_, _jigana_, _abireke_, _синглтон_,
   {{0xb20191e7,0x62d9b18c,0x425fe44d,0xa20022c1}},	//   _ansip_, _kuvela_, _frendovi_, _vakit_,
   {{0x3226700d,0xedbd2421,0x09c49088,0x82ca7222}},	//   _jurkat_, _kiristaa, _memerint, _lunda_,
   {{0xc2caf146,0xf6e7627c,0x22cad0c7,0x62d411fe}},	//   _bandar_, _人が役に立つと評, _muddo_, _soudé_,
   {{0xf3a38546,0x32915395,0x326111a5,0x5eb4b52a}},	// [10f0] _corpo_, _enfato_, _abatakul, _baruulee_,
   {{0x0387751c,0x9378209c,0xb45711d9,0xd1764424}},	//   _starte_, _habasha_, _ادالدانى, _adlawadl,
   {{0x82d8808c,0x05b69013,0x8c58d111,0xce541036}},	//   _sekere_, _зыҧсҭаза, _ekstraj_, _rilascia,
   {{0xd2ca7187,0xa0ddd308,0x6ad9a25c,0x275e301c}},	//   _bunda_, _maendlel, _макроэко, _ہمسفر_,
   {{0x54311232,0x0aab205a,0x2b07740f,0x327ff1a3}},	//   _تجارتي_, _бирдиктү, _samskipt, _mbuno_,
   {{0x22977162,0x62903114,0x33ead5e7,0xc2fc004d}},	//   _террорчи_, _samada_, _frete_, _deigh_,
   {{0xad2ca2c6,0x13ea904a,0x7387123e,0x2af851c5}},	//   _veritate_, _utatu_, _aparey_, _letedels,
   {{0x8380d129,0x8f48c0b5,0x429030d7,0xd2d9c1c5}},	//   _སྐྱོགས_, _қажыгелд, _qamada_, _daved_,
   {{0xb2ca7047,0xf3ea945b,0xac6060d2,0x5382d276}},	//   _gundi_, _statu_, _nostres_, _جابلو_,
   {{0x1c61f25a,0x051bc291,0x099d2008,0x73416089}},	//   _kolumno_, _مساحت_, _залым_, _sweeten_,
   {{0x4b65429d,0x2c3ac1ba,0x7407e1d8,0xa2d4a1e8}},	//   _aspekten_, _условият, _dunungan_, _aikojen_,
   {{0xbb426591,0x6b824138,0x4643a105,0x227ff0ee}},	//   _yokwenza_, _planinar, _באיאן_, _sauny_,
   {{0x028f41e5,0xaf1071d3,0x74a31317,0x72f07137}},	//   _nähili_, _cuntinua, _relijiel_, _malinaw_,
   {{0x734c323a,0xa9c8400f,0x0d1fe529,0xa2fc21e0}},	//   _jasebel_, _подорожі_, _trendove_, _talibus_,
   {{0x6387413c,0x1d1a2381,0xf29170b4,0x8afb403a}},	//   _fuerte_, _oponerse_, _anaana_, _degrenne,
   {{0xfb1a004b,0x23ea00e7,0x2c079446,0x628681e8}},	//   _mutaxass, _muiti_, _рамонт_, _карьера_,
   {{0x6407d43a,0xcf39a16f,0x12908012,0x68d78417}},	// [1100] _tulungan_, _שקצים_, _jakaya_, _यथोचित_,
   {{0xb290e26f,0x7e444009,0x9b674059,0xb0dcd292}},	//   _kunaon_, _интерфей, _jurutera_, _avtomatl,
   {{0xe3dcd0b2,0x71c73291,0x3200b287,0x12da71f1}},	//   _brower_, _داستانی_, _audito_, _tareas_,
   {{0x6b8530b3,0xf0dd2352,0xa262e06a,0xca7e925d}},	//   _яңадан_, _زیاره_, _रक्षण_, _atelemis,
   {{0x87ce33af,0xe6325249,0xc2d8e080,0x13875119}},	//   _bangbouj_, _indicazi, _conejo_, _uterit_,
   {{0xbf5cf1ba,0x50756128,0x32918202,0x4e7140ea}},	//   _компютър, _stockbro, _inyana_, _अगस्ट_,
   {{0x623661f8,0x12910224,0xd2d125a5,0x31cef1e3}},	//   _dvoje_, _robago_, _notodom_, _datoform,
   {{0x92fc900c,0xb27f709c,0xf29035e8,0x274ef0f9}},	//   _leaga_, _waanan_, _mamaca_, _grundleg,
   {{0x027ee12e,0x03ead0d9,0xc20022c9,0x03ea01d6}},	//   _opinia_, _gueto_, _zakir_, _asite_,
   {{0x1638e152,0xc29710ff,0xb2d8331f,0xd16d00f1}},	//   _perintei, _bescherm, _pilotos_, _konsesjo,
   {{0x129152dc,0xfa1510e5,0x93f8b023,0x4f5f5319}},	//   _sigana_, _redakcja_, _addude_, _uppppppp,
   {{0x13410122,0x42ca724e,0x798c1105,0xa26cb0b4}},	//   _insegna_, _pundi_, _עליכמס_, _gedora_,
   {{0xf2fc91c3,0x39c4929a,0x12cb7106,0xf2910059}},	//   _beaga_, _pemerint, _agadsa_, _cubaan_,
   {{0xbde074d5,0xd7eb1360,0xe25710ef,0xe38bb405}},	//   _societé_, _سرخیاں_, _لاتعلقي_, _víris_,
   {{0x78a3e0af,0xacf5113d,0xb2ca70fe,0x62c94297}},	//   _メロディアス_, _mandated_, _wundi_, _míonna_,
   {{0x9373738b,0xe248d0ec,0x82ca72ae,0x32fd61d8}},	//   _rongbay_, _themi_, _tundi_, _angger_,
   {{0x02915018,0x142bc172,0x27095004,0x8f37d34e}},	// [1110] _legate_, _pabalelo_, _قانونگذا, _грозний_,
   {{0xe3ea9253,0x1eaca2c5,0x1347c064,0x5a0f6245}},	//   _fuata_, _sentrale_, _vendeur_, _akaphind,
   {{0x74bd51c2,0x3281043a,0x538795e9,0xc3ba90f0}},	//   _montaño_, _ahhhhhh_, _styret_, _privés_,
   {{0x429260fc,0xf290d266,0x920041fe,0x8cdd0217}},	//   _boraro_, _ahoafi_, _tamit_, _косовоны,
   {{0x12247514,0x1c779039,0x5808c0af,0x998e1192}},	//   _sonke_, _berriew_, _リンク切れ報告_, _хасил_,
   {{0x92915283,0xa6261026,0x53eb00a1,0xb6172078}},	//   _ligama_, _미디어다음_, _faatir_, _شاءالله_,
   {{0x92908076,0x8f64c031,0xdf240031,0xf200406e}},	//   _makana_, _ይገኙባቸዋል_, _መናፍስት_, _kamis_,
   {{0xd2eb023c,0xfea435cd,0x5ad021f3,0xb3aa0038}},	//   _scritto_, _adlulise_, _سرسید_, _karawang_,
   {{0x3292139e,0xb2d98026,0x12cad169,0x03ea020d}},	//   _aspati_, _jaren_, _gudde_, _aritu_,
   {{0x4453a135,0xd2ca715e,0xb14fc340,0x2ec25369}},	//   _ትምህርቶም_, _mundu_, _guvernul, _tranchan,
   {{0x8386e054,0x23ea00e6,0xcbac7287,0x8c6164b9}},	//   _shirin_, _dritt_, _прасторы_, _gestuur_,
   {{0xa2d77030,0x19bf00af,0x02d98407,0xcc606252}},	//   _رکورد_, _に選ばれた回答_, _oaren_, _postres_,
   {{0x43ea02b9,0x729082df,0x62d9e4a5,0xcd928192}},	//   _fritt_, _kakana_, _matee_, _atlehile_,
   {{0x020ed04b,0x3c61608c,0xec702024,0x5a1bd30e}},	//   _қадар_, _bestuur_, _दीर्घं_, _क्लबले_,
   {{0x0618639f,0x6b96d340,0xc2d874ec,0x82ba7104}},	//   _beslutni, _духовнич, _aynen_, _humedad_,
   {{0x034cb14c,0x636570e7,0x1165e039,0x6394f39d}},	//   _মায়ের_, _vhugala_, _khonglah_, _utisak_,
   {{0x8d96a2b9,0x93ea0188,0x1b9e4375,0xb2d8e1d0}},	// [1120] _milliona, _kritt_, _бюджетте, _chiefa_,
   {{0x62b3406a,0x420021a0,0x155401e2,0x227ef1a7}},	//   _नाजुक_, _dakip_, _abakuley, _clinar_,
   {{0xf2d9839b,0xc2ead431,0x820041ab,0x2745e3a7}},	//   _mareo_, _connais_, _tamis_, _akuzindi,
   {{0x1290e47b,0x6b88e183,0x72d985e9,0xf2cd91f5}},	//   _abiara_, _attinger, _faren_, _reklám_,
   {{0x82d984b4,0x0e507288,0x02bcd275,0xdb55b166}},	//   _garen_, _masalala, _гуажу_, _adattata_,
   {{0x69fd2284,0x03f99015,0xb6278057,0x7b8f13d0}},	//   _attaccat, _kasun_, _achiziti, _өмчлөн_,
   {{0x8338014f,0x037962d5,0x813e72e5,0x73785124}},	//   _प्रणिपत्, _breacan_, _svietidl, _ианрыбжь,
   {{0xb2ca70f9,0xf2915090,0x3147217f,0x1c76121d}},	//   _kundu_, _angaka_, _василаи_, _दिस्वा_,
   {{0x0119211b,0x2650b296,0x9fd0234e,0x727822bf}},	//   _технике_, _abakwaxi, _abangaco, _bangayim,
   {{0xb69c6310,0x9bf163a4,0x81b4d252,0x21dd0438}},	//   _saifuddi, _filebarr, _ыздар_, _abanedum,
   {{0x82d9836b,0x12a63351,0x65bb0309,0x56c40221}},	//   _waren_, _gimbal_, _bitaghch, _abasemth,
   {{0x5a6261bc,0x99d222f4,0x00f70159,0x6587f048}},	//   _алдыдагы_, _erregist, _مالدیپ_, _ostravsk,
   {{0xf26d1283,0xb7b791c5,0xcf5df005,0x3c23103d}},	//   _imboni_, _dedietön_, _daugelis_, _abasukub,
   {{0x423ca218,0x3b5e0050,0xf200f01d,0xc7f920f6}},	//   _ويندوز_, _北京石景山路甲_, _magit_, _кесилен_,
   {{0x5ea2a049,0x2e9012af,0x739663af,0x787b216e}},	//   _corrente_, _atamalen, _yousim_, _страха_,
   {{0x163dc32f,0x9b887248,0x87f9d2db,0x793bc187}},	//   _ишора_, _ብሕጋውን_, _демирел_, _adamenye,
   {{0xb386d0be,0xbdc75078,0x529152ee,0x9378e030}},	// [1130] _njeri_, _زائرنا_, _cigaba_, _bilaman_,
   {{0x82927030,0x4c614067,0x62ca70e7,0x78641437}},	//   _turadi_, _detukwa_, _vundu_, _akkordmu,
   {{0x75fda23f,0x8316e1fd,0x72920114,0x2ef9e0f9}},	//   _forestiè, _benzer_, _sepang_, _pussaður_,
   {{0x42ca71fe,0xe2ee05b5,0xf8192041,0xbad77026}},	//   _tundu_, _činili_, _کورسونه_, _netwerke,
   {{0xe24861a5,0x6200420f,0xf35f301f,0xaa0a01f3}},	//   _ukoma_, _samir_, _dangane_, _magatart,
   {{0x255100af,0x5dcc118b,0x73f3c3e4,0x5c09b5ea}},	//   _サイトデザインが, _shakhmat_, _atausili_, _dépend_,
   {{0x52915283,0xdc49d0af,0x2691d0de,0x062961d4}},	//   _sigaba_, _みんなへの一言_, _ئشتەتە_, _aalisari,
   {{0x11b3e08a,0x82908012,0xf373d2e8,0x726e7061}},	//   _خاطرې_, _nakala_, _abhaile_, _masomo_,
   {{0x925ac178,0xb6713217,0xfea8a248,0x0290817d}},	//   _mellan_, _юстиция_, _ዘይንፈልጥ_, _takana_,
   {{0x527f7187,0x8856403e,0xa3957401,0x19cd3114}},	//   _mpanda_, _adámù_, _feasta_, _seumpama_,
   {{0x82d9a5eb,0x422471b1,0x04551120,0x1e9514e7}},	//   _hapen_, _jonka_, _produkto_, _produkts_,
   {{0x5b9aa57a,0xb8c0e291,0x22b1f1ac,0x226ca4ad}},	//   _संयुक्त_, _قربانیان_, _handeha_, _bojosi_,
   {{0x72d984ff,0xc3ea0213,0x7f26d1a1,0x80b8d12f}},	//   _harel_, _asita_, _addressa, _испат_,
   {{0xb1dfa155,0x42cb42ae,0x0200b26c,0x5c60e3cd}},	//   _بۈركۈت_, _meedia_, _vodite_, _flytter_,
   {{0x93eae0fd,0xf2fe4566,0xa291835e,0xa2cb8407}},	//   _kontni_, _estilos_, _siyana_, _hurde_,
   {{0xbdb080a4,0x127b7558,0x95c8c022,0x39382031}},	//   _manumanu_, _kalendár, _кадрлард, _እባክዎን_,
   {{0x03ea02bd,0xe5ebf1bf,0xeae64229,0x42927171}},	// [1140] _esita_, _докторат, _strument, _kisasa_,
   {{0x837f92a8,0x7b51c2bc,0xe6545440,0x07d98574}},	//   _tikanga_, _територі, _heyyyyyy, _बालकलाई_,
   {{0xc24862ce,0x4390d084,0x2bbbf031,0xf2480440}},	//   _ahomu_, _adeyemi_, _ለማለዘብ_, _akimi_,
   {{0x32c0d0e9,0xf20105ec,0x264c03f2,0x04ad2190}},	//   _андаа_, _imbibe_, _okuhambi, _marautak,
   {{0x62fcf437,0x5c673030,0x3e3e11b8,0x8aa8b2e8}},	//   _begge_, _sentabr_, _kidautop, _sathairn_,
   {{0x622580bd,0x8be10008,0x62d9a1cd,0xd83c8031}},	//   _kerke_, _keseller, _vapen_, _ያለአንዳች_,
   {{0x1292726c,0x72d9a3ce,0x464c002f,0x50ce702d}},	//   _strani_, _wapen_, _akuhambi, _bhardwaj_,
   {{0xf291b125,0xe71b3102,0x3290c390,0x936bd0b0}},	//   _ndwaye_, _спору_, _bulaan_, _bangkep_,
   {{0xa387f0fe,0x169b127d,0x44361162,0x927b7198}},	//   _ukuri_, _maleeshi, _ﯬﺭﻛﯩﻦ_, _calendár,
   {{0x93eb20f1,0x6e34c1d6,0x3b264360,0xb2908137}},	//   _bryte_, _angagcwa, _ماسوائے_, _aakala_,
   {{0x2c5511ec,0xc290837c,0xbbe532ab,0xc9d535ed}},	//   _proteze_, _bakala_, _aksesuar, _अर्पित_,
   {{0x030e51cc,0xf2d98139,0x866cb0fb,0xb0d960f4}},	//   _trebala_, _garee_, _ग्राह्यम, _تېببىي_,
   {{0xa2d9a5ee,0xa200c22e,0xcf1b238a,0xd2cad09c}},	//   _lapel_, _molise_, _украине_, _gudda_,
   {{0xef72021a,0x4200c138,0x72d98104,0x928c1404}},	//   _dienoraš, _volite_, _pared_, _vyakula_,
   {{0x753bf225,0xa2d981fe,0x3706834e,0x2298727a}},	//   _sugestõe, _baree_, _панчох_, _očami_,
   {{0xc30c2566,0x0c3063af,0x829085ef,0xebe401cd}},	//   _semanas_, _foengdou_, _hakaba_, _underbar,
   {{0xac194027,0x6af6015c,0xae56c0db,0x52c8b031}},	// [1150] _secapesc, _autobunn_, _юристар_, _በዋስትና_,
   {{0xf6397031,0xac67f044,0x541a8031,0xc2d50043}},	//   _የታሰበው_, _tanumia_, _የመሳሪያ_, _tasolla_,
   {{0x930970cf,0x199550db,0xab1fb093,0xa9f1d242}},	//   _masarap_, _bakhatla_, _hidangan_, _anonīma_,
   {{0xbc7f4258,0x22d9a3e1,0x5a9a91a6,0xd360d048}},	//   _sammineq, _dapel_, _anenshis, _तराईका_,
   {{0x62cad1fe,0x6b900155,0x4a7c50dc,0xc394e118}},	//   _guddi_, _بۇيەرنى_, _ستاندا_, _alista_,
   {{0x32d5a111,0x14a30207,0x725ac051,0xc3207199}},	//   _rakonto_, _bilimsel_, _sellin_, _canys_,
   {{0x1db1a144,0x0111101d,0x6346a18d,0x22d8c5d6}},	//   _libalave_, _ticklish_, _studiet_, _lyden_,
   {{0xeec811df,0x82fcd46e,0xc477a0d6,0xc26cc278}},	//   _געפונען_, _langid_, _проекта_, _kolosi_,
   {{0x83ea0218,0x305ed2f2,0xd0342105,0x2d3ad0fd}},	//   _frith_, _agentlik_, _ראדאמסק_, _danièle_,
   {{0x1fe7b0e9,0xdc6973f7,0x83eaf06a,0x4fa33031}},	//   _править_, _zantray_, _kritis_, _በሚሌኒየም_,
   {{0x626df388,0x1b5510ff,0x825ac1c4,0x0c00a00f}},	//   _بیروباوه_, _kinderen_, _tellin_, _motsatt_,
   {{0x50c7f23c,0x11162105,0x82019163,0x129241d8}},	//   _науката_, _איזביצע_, _misis_, _ketang_,
   {{0x1f964224,0x8c27a381,0x3c1b2059,0xec690184}},	//   _bašweu_, _крамер_, _petronas, _antrano_,
   {{0xb32391b9,0x9c931041,0x8378e2c4,0x33f0a39e}},	//   _полиэф_, _رایاد_, _silakan_, _sarsnati_,
   {{0x0eba2135,0xe316706a,0x0d34109a,0x32d98234}},	//   _ይመስለካ_, _pribadi_, _خېنىم_, _marec_,
   {{0x6201244e,0xae95105a,0x10b79009,0x8b2de057}},	//   _kayit_, _contacte_, _панель_, _кириличе_,
   {{0x87d23020,0x529251d8,0xfecd45a5,0x82d8208c}},	// [1160] _outgoing, _astati_, _pasifean, _hemele_,
   {{0x03ead233,0x863f35f0,0xc2918245,0xeb8d124b}},	//   _ireto_, _podijeli, _unyaka_, _nemiraro_,
   {{0x12d9a32b,0x9b13631e,0xd3950384,0x6387f48c}},	//   _capel_, _alimiñom_, _časom_, _ekuru_,
   {{0xed4ce135,0x8b1fc114,0xc4ba308a,0xab85907f}},	//   _ነፍስወከፍ_, _bilangan_, _ababesak, _акнферен,
   {{0xf387f0c4,0x12d9c05d,0xec1ba1ac,0x225ad121}},	//   _nkuru_, _naven_, _manambar, _vallas_,
   {{0x81775221,0xc29251d1,0x2e3bc102,0x862b30d0}},	//   _kulandel, _mutani_, _основног, _nipitiri,
   {{0xb2d9c13f,0x53f1622e,0xc93f34a2,0x92925170}},	//   _haven_, _greening_, _milletve, _ustati_,
   {{0xc29240db,0x73ea0127,0x3b9b8384,0x5c7d607d}},	//   _fetang_, _driti_, _prevažne_, _kwestin_,
   {{0x83ea01e7,0x8f59603c,0x72cad0bf,0x0b426245}},	//   _eriti_, _dispiace_, _xuddi_, _nokwenza_,
   {{0x0376b1d9,0xef659244,0xd20191fc,0x99d882a1}},	//   _تۇراقتى_, _estantin, _bisis_, _diperole,
   {{0xf2480045,0xb2927262,0x2e7352e2,0x72019257}},	//   _ekimu_, _burayi_, _disparèt_, _misir_,
   {{0xd7df2059,0xa29251fa,0x4fa9327c,0xbd03c0d1}},	//   _አጠያያቂ_, _kutani_, _インテリア_, _afambile_,
   {{0x83ea9235,0x09d2c575,0xf28b829a,0xb25b73e1}},	//   _arata_, _confront, _memahami_, _dogley_,
   {{0x937fc1d4,0x5b05a01a,0x555401a5,0xdee0109a}},	//   _tamanna_, _алмашты_, _abakiley, _ھۆسىن_,
   {{0xd641c036,0x620122e2,0x7eb343c1,0x23f80039}},	//   _втора_, _sayil_, _forskare_, _lyiuh_,
   {{0xc26460f9,0x21d6f30f,0x226cd2f6,0x326cc23c}},	//   _skuldu_, _प्रदेशात_, _nanone_, _colori_,
   {{0x93ebf14f,0xa224746a,0x737ff278,0x8697555b}},	// [1170] _stute_, _lonke_, _anianga_, _jugendli,
   {{0x92e991fd,0xc362113f,0x57b3301a,0x7e88b0c9}},	//   _haziran_, _בקיבוץ_, _diputaci, _прогнозу,
   {{0xc2ca717e,0xb7b5f36b,0xa2ddb3a2,0x838800bc}},	//   _hundi_, _startsei, _formacij, _adayeba_,
   {{0x1c78b043,0x62924114,0xc387719f,0xe9e635f1}},	//   _запомнит, _petang_, _axarra_, _estupend,
   {{0x925af166,0x8b544248,0x627f701e,0xc8fd7591}},	//   _dunlap_, _ማህረምቲ_, _baanan_, _labafund,
   {{0xc5606162,0x7f392200,0xe413201a,0x376b8031}},	//   _техником_, _aruskipa, _چاندا_, _በጥርጣሬ_,
   {{0xe2d9e0ff,0x429035f2,0x7248928d,0x1581b132}},	//   _laten_, _hamama_, _shamu_, _атентате_,
   {{0xc2f4e2a4,0xa4b5a1b9,0xe387416f,0x60d82018}},	//   _podstawy_, _алманым_, _eterne_, _мурибунз,
   {{0xb7ff913f,0xe27ec42e,0xb706d0ac,0x122500b4}},	//   _ומידע_, _komnar_, _오스트리아_, _akakuu_,
   {{0x1b44b059,0x2249409b,0xc2d9e19e,0xa2d5419c}},	//   _እንዲሸጋገር_, _diemen_, _watea_, _haalulu_,
   {{0xc386c0bd,0xfdf8b026,0x9c147105,0x6e9012d7}},	//   _storie_, _빌라연립다세대_, _גרשוני_, _atamelen,
   {{0xd3191493,0x72c89124,0xfac811de,0x2c5a3345}},	//   _دينار_, _саратовт, _dozvolje, _राजनिती_,
   {{0x0ee59121,0x8291b20c,0x127f702d,0x42e9d0c8}},	//   _दृष्टिपा, _niwaba_, _spanja_, _паспяхов,
   {{0x922471e2,0x02ec115e,0x62d9e36b,0xf67e6211}},	//   _konke_, _алтан_, _daten_, _finefeui,
   {{0x3e2f05f3,0xe8fd746a,0x3c5e318d,0x337290ab}},	//   _células_, _nabafund, _kastell_, _stilling_,
   {{0x93f40378,0x1683f0ca,0x93ea012b,0xb29141a4}},	//   _listir_, _धीमान_, _isite_, _kaeaea_,
   {{0xcc73e140,0x9249748b,0xe6882030,0x02d9e135}},	// [1180] _pensiya_, _anamon_, _خواهله_, _naten_,
   {{0x437b33c0,0x4f4a43d2,0x6518d0f4,0x4c8df227}},	//   _kopanyo_, _persoona, _ﺋﯩﺴﺮﺍﺋﯩﻠ, _뿌리깊은나무_,
   {{0x12d401b7,0x9e726038,0xa2d9e1eb,0x3290307b}},	//   _oesday_, _अशक्य_, _haten_, _wamama_,
   {{0x42d9e196,0x5ed1104a,0x62fc93f4,0x426ce10c}},	//   _baten_, _kunyange_, _beagh_, _bonosi_,
   {{0x3e96309a,0x6fd72287,0x03795252,0xfe736050}},	//   _ئىدىڭ_, _наталля_, _setanta_, _一位難求的義大利,
   {{0xabde1213,0x3ed4520e,0x11e7d14d,0x92d9801d}},	//   _condorir, _автоматс, _इयारी_, _earea_,
   {{0x560315f4,0x4d8542b1,0xc0373455,0x53165353}},	//   _निंदक_, _nesesite_, _resteran, _probudi_,
   {{0x929270be,0x9ec32100,0xdb2a52df,0xd6213050}},	//   _kurani_, _kliyente_, _ikabakab, _一個小時過後_,
   {{0x0d86f0af,0x02d8c084,0x53ea911c,0xd2da4139}},	//   _明日の日経平均を, _aileto_, _fuath_, _amantee_,
   {{0x62d8c150,0xe2ea1040,0x19e1b0a4,0xc595e034}},	//   _bydel_, _biriyin_, _dalosika_, _attribuz,
   {{0x5e5255f5,0x6a604345,0x362012ae,0x9967417c}},	//   _sedangka, _koolitus, _planeeri, _geliebte,
   {{0xe28da221,0x1d7eb09f,0x2f920351,0x8254b050}},	//   _isikolo_, _abelanwa, _headwear_, _一周前誕生了一隻,
   {{0x7364d159,0x425a517e,0x243930ac,0xa2fe543d}},	//   _عوامی_, _malle_, _인천광역시_, _inrikes_,
   {{0x325a5389,0x0b927155,0xd362f3ef,0xaf5f35f6}},	//   _lalle_, _جەزمەن_, _mystorem, _domaneab_,
   {{0x8af722fc,0x931c20c2,0xec1a033e,0xb84ed20a}},	//   _наредио_, _аңлар_, _furqaan_, _agalamid,
   {{0x722410ce,0x4b991140,0xf9e1b10c,0xbaf7c009}},	//   _leginkáb, _камилләш, _balosika_, _панели_,
   {{0x5378e026,0x17d9a1a7,0x78b9b0d7,0xc20190fd}},	// [1190] _geladen_, _apostrof, _балаларг, _disip_,
   {{0x3376d17d,0xce7242b4,0xd8a721ca,0xa371919a}},	//   _простой_, _अधर्म_, _گوسکھ_, _organig_,
   {{0xc2d9e1fd,0x675e113f,0x12df1222,0x23a870ce}},	//   _zaten_, _מוצגים_, _kanning_, _képre_,
   {{0xa3ffa198,0x7466d5f7,0x45720105,0x226ce15a}},	//   _останати_, _dezembro_, _עקיבֿא_, _ponosi_,
   {{0xa25a523c,0x3466b046,0x33ea61cd,0x09dc9136}},	//   _dalle_, _setembro_, _brott_, _astelehe,
   {{0x8e482264,0xfb6c92e5,0xd64fa3e1,0x231c710b}},	//   _ايفون_, _majiteľo, _eksklizi, _aracura_,
   {{0xc3bb2049,0xaa9785f8,0xa25d90be,0x79dd9053}},	//   _través_, _मधुमास_, _integrim, _integrie,
   {{0x65ff1445,0x474ce009,0x3291b111,0x32dd8129}},	//   _ተግባራዊ_, _пожалуйс, _movado_, _esposti_,
   {{0xd791412f,0xc23174d6,0x53ea656f,0x6e70e4c0}},	//   _كوللېكتى, _arumena_, _trott_, _carolíng,
   {{0x695971d9,0x426ce272,0xf25a5053,0x24742322}},	//   _қайтарыл, _sonori_, _halle_, _ellecabo_,
   {{0xd7b6e4d2,0xc2e8e054,0x72d723c1,0x1cc4c2eb}},	//   _chernobi, _dalilin_, _villkor_, _агарала_,
   {{0x29df9207,0x52ec6130,0xc20313d0,0x5b30f27d}},	//   _gittigid, _febroary_, _босоод_, _garanayn_,
   {{0x827ed010,0x79c65144,0x22c5a106,0xf49be171}},	//   _bonnie_, _kusebent, _bremner_, _majambaz,
   {{0x8fc2210a,0x525af0c3,0xe30ba114,0x4c7671ff}},	//   _پاڙون_, _javnosti_, _membiak_, _सिल्वा_,
   {{0x8a45f127,0x2d05301a,0x357da257,0xd3f41086}},	//   _rajendra_, _restricc, _markalı_, _justfx_,
   {{0x69d8701b,0xeb34d2d7,0x929270da,0x8d1a3180}},	//   _meselele, _babatlis, _murali_, _ありません_,
   {{0xcb2a30aa,0x4cd4d21d,0x7586f0ab,0xb259739f}},	// [11a0] _ababirab, _प्रयोगे_, _overrask, _forekomm,
   {{0xf39541cd,0x83869012,0x0ac7205b,0xc55360db}},	//   _flesta_, _idara_, _معلومولو_, _boikhath,
   {{0xb25b1027,0xacafc012,0x92975027,0x22842293}},	//   _tablas_, _تماشو_, _menaschi_, _amahano_,
   {{0x92fc4018,0xa0f6717f,0xd632906e,0x8274c342}},	//   _subiect_, _олимпӣ_, _निवासस्थ, _قوالب_,
   {{0x53f905f9,0xe33d2030,0xc290832d,0xecfe44c7}},	//   _nebude_, _ایراد_, _bahavo_, _doktorir,
   {{0x59d97095,0xa6e864dc,0x923b113f,0x520264c8}},	//   _resentme, _atlantsf, _ceiling_, _hauiti_,
   {{0x13ea95fa,0x458a6009,0xe08790f7,0x027f01ba}},	//   _usate_, _ledemokh, _并自负法律责任_, _avanti_,
   {{0x08abd168,0x1e91600a,0x43ea61cd,0x7394e110}},	//   _자기소개서_, _abstract_, _trots_, _winsor_,
   {{0xcae0745b,0x9c4461d9,0xf3ea629f,0x6c73812c}},	//   _mantenut, _держател, _asota_, _cristia_,
   {{0x1d6c1083,0x492e61e5,0xd3791411,0x9c5cb14c}},	//   _партиясы_, _марксизм_, _bapanya_, _মিশ্র_,
   {{0x03869067,0x7200c086,0xd7a9e23c,0x18674174}},	//   _adara_, _golive_, _valutazi, _proizved,
   {{0x02927005,0x13ea9142,0x120ec23c,0xd2c37203}},	//   _visada_, _vratu_, _макар_, _okulaba_,
   {{0xe73ee13c,0x1c9101ab,0x89b77022,0x1834911b}},	//   _искандер_, _magulang_, _جاۋسىن_, _култури_,
   {{0xe248924b,0x9f5be1d4,0x325ad431,0xb291818e}},	//   _ijame_, _kujataan, _salles_, _abyata_,
   {{0xf3ea9431,0x32ea1257,0x756f30e0,0x12d6a44b}},	//   _santé_, _birinin_, _प्रतिदिन, _farligt_,
   {{0x4290f328,0x593f83a1,0x81bf8285,0x94ecb180}},	//   _ahiani_, _abamenya_, _abamenyi_, _配送と返品につい,
   {{0xcedf405a,0x93eb936b,0xbc75b107,0x6bfd010e}},	// [11b0] _اتىڭىز_, _erste_, _टिक्का_, _kulturys,
   {{0xaedec162,0xcaf4a0a0,0xcc6692db,0xc2ef306b}},	//   _динда_, _ahlukene, _кадынын_, _fungalei_,
   {{0xd2de4263,0xe90aa408,0xb2d95071,0x7c5bc132}},	//   _хатарнок_, _jayaward, _hegere_, _сконтат_,
   {{0xb758c0e5,0x2af5c1c7,0x33e1827a,0x253325cd}},	//   _संन्यास_, _ﻛﻮﺭﻛﻪﻡ_, _klientov_, _alenyony,
   {{0x22dc126c,0x2291a2e2,0x529080e0,0x0d24e030}},	//   _promocij, _espas_, _mahato_, _افتخارین,
   {{0x2db432a7,0x6dfbd109,0x026cc25d,0xb200c138}},	//   _دوروم_, _bakerste_, _beloya_, _molite_,
   {{0x0c030120,0x7f6412ab,0x73a4138c,0xc943230a}},	//   _sloping_, _finansin, _finansij, _evaluese,
   {{0x52925138,0xf30e50c8,0x9d95f214,0x181cc009}},	//   _ostavi_, _paramos_, _ءارينە_, _содержат,
   {{0xd394f200,0x62d8b18e,0xaaeeb1c3,0x133c7105}},	//   _ayistu_, _videyo_, _aistidhe, _פּטירה_,
   {{0xd38054ee,0xced16026,0x3c6b00fb,0x1e39607e}},	//   _ostrvo_, _상품가치가_, _कार्ये_, _relatera,
   {{0x947b4050,0x72eb94b4,0x55f52225,0xa582e287}},	//   _南方人物周刊_, _bilivim_, _diferenç, _славамір_,
   {{0xc25180e4,0xd1e2b152,0x3e753287,0x56b9506f}},	//   _whitfiel, _техничес, _пытанні_, _críticas_,
   {{0xfa0173eb,0x8a10506a,0xc200431e,0xd9fb9443}},	//   _allavega_, _polandia_, _bamiy_, _amoangat,
   {{0xb25b63c8,0x72d95076,0xb9d9025d,0x72271292}},	//   _anglah_, _degere_, _akonyata_, _карнай_,
   {{0x7d863036,0x1efe62ab,0x9207b144,0xa6e9d056}},	//   _напред_, _elektros_, _akakenti_, _tlhakišo_,
   {{0xa3eb95b0,0xf290850e,0xd8c210ac,0x962200ce}},	//   _vrste_, _gahato_, _자세히보기_, _finanszí,
   {{0x73ea6010,0x62250120,0x522b803e,0xb2cf20d9}},	// [11c0] _broth_, _agakak_, _asemase_, _binonde_,
   {{0x78c9925c,0xd27ff2f8,0xaec5e1e0,0x12dfb3f9}},	//   _шаралард, _ucuna_, _princeps_, _aabning_,
   {{0xe3870051,0x5290c03a,0x5fbe1248,0x08e7e0f7}},	//   _beards_, _irlann_, _ብላዕለዎት_, _华夏大地教育网博,
   {{0x3ea18168,0xa2eca299,0xfd7ee3d9,0x408ae0d2}},	//   _부동산써브_, _notizie_, _abalanwa, _دايرىتتا,
   {{0x73eb9118,0xe200f206,0xf305c4b5,0x0274c24c}},	//   _gusto_, _magis_, _سوران_, _سوالا_,
   {{0x93ead1df,0x22d8e3c7,0x22d9c246,0x7291c1f8}},	//   _preta_, _dinero_, _lavea_, _izvan_,
   {{0x92d434c0,0xb6d3216e,0x53ebf47b,0x1d9790ff}},	//   _boileau_, _послова_, _etuto_, _veroorza,
   {{0xd15c2136,0xce54200a,0x6200f07e,0xab0c23d6}},	//   _тутам_, _financia, _tagit_, _кухни_,
   {{0xe6b8d0d7,0x9305025c,0x24b60105,0x33860327}},	//   _redaktsi, _تويات_, _אביעקט_, _adiro_,
   {{0xaf5c65fb,0x525701c5,0x9f2ba2db,0x73ea9043}},	//   _blogthis_, _húliu_, _гөркезме, _osata_,
   {{0x3655809a,0x4e9e3296,0xb9ed9191,0x2d487005}},	//   _мухлиси_, _халли_, _abdisera_, _pagaliau_,
   {{0x92eb02c6,0xb27714ab,0xe8e904ec,0xf33d1041}},	//   _scripto_, _akanyoni_, _dosyalar_, _کیداي_,
   {{0x925ad09c,0x398281c7,0xe2db415e,0xfa18d0bf}},	//   _mallas_, _докторы_, _europar_, _роҳманир_,
   {{0x4d928332,0x329251f8,0x43eb944d,0x4395412b}},	//   _polepole_, _ostati_, _prste_, _emesia_,
   {{0xf0ce2060,0x7c7c546c,0x1ecc60bc,0x57c7c427}},	//   _ribonucl, _startar_, _abinitun, _банков_,
   {{0xbe56300f,0x6235f05a,0x426da086,0x829cb200}},	//   _частина_, _ئندوستان, _maxout_, _qullañ_,
   {{0x147a831c,0x3248022f,0xb343211b,0xf2019018}},	// [11d0] _postavlj, _njima_, _posebno_, _gasit_,
   {{0x5fd4f12b,0x55cc203b,0x62566048,0x6f4561a8}},	//   _ezinaulo, _angatiph, _जितेका_, _евангель,
   {{0x2c7ea06e,0xb249721f,0xb3866064,0x5200f0ea}},	//   _mansell_, _anaman_, _adore_, _sagit_,
   {{0x33fb331a,0xd4b15225,0xa38751e0,0x85ef71ca}},	//   _aturiami_, _inscriçõ, _fuerat_, _ژیوٝنمُت_,
   {{0x22fcd2cc,0x929252e2,0xa89b829b,0xf3aa009f}},	//   _keegi_, _estati_, _abakhulu, _baratang_,
   {{0x0c7d823c,0xf2adb248,0x6da1b3e4,0x8a091121}},	//   _докладва, _ኣፍቅዱለይ_, _aletatau_, _magamist,
   {{0x73f94123,0xaacb91b8,0x12d885fc,0x0f17b2a1}},	//   _reduit_, _kiemtien_, _yekeee_, _mendoron,
   {{0x6f5e1011,0xd292516b,0x1236605c,0xd8d9f20e}},	//   _иофициал, _istati_, _svoja_, _сервиси_,
   {{0x9473012e,0xd2a03339,0x24dfd3bf,0x52ea0146}},	//   _literack, _kanjonu_, _основата_, _garisan_,
   {{0xd29081e7,0x1e7770d2,0x9f6ff3bb,0x70eef0a9}},	//   _sakala_, _داندان_, _achanpas_, _achinall,
   {{0xb26cd016,0x9e696268,0xec93301c,0x02c87251}},	//   _proofs_, _بیروزیرل, _کانام_, _египетск,
   {{0xd29082bf,0x238751e0,0x5344526a,0xa27ee043}},	//   _bakama_, _fuerit_, _license_, _hinnat_,
   {{0x126c2137,0x032030d2,0x240d314c,0xbb61c230}},	//   _bukod_, _balcons_, _মতবিনিময, _ôfleveri,
   {{0x97d0424f,0xc65b9316,0x7c714183,0xd2d870ea}},	//   _itisilii, _halimbaw, _possede_, _synem_,
   {{0x17ad317a,0xc25a5322,0x83a3a38b,0x6e48d4c6}},	//   _ফাইলৰ_, _yalla_, _coppy_, _tamahine_,
   {{0x525a517e,0xd300e09b,0x03792316,0x49bef3d0}},	//   _calla_, _lefaili_, _akbayan_, _баделхан_,
   {{0xddc82162,0x8b3f3105,0x3da691d4,0x1cfca401}},	// [11e0] _усули_, _וווּהין_, _tikillua, _إقتصاد_,
   {{0x86360019,0x407072fc,0x23ea647b,0xf43ec0d7}},	//   _ייִוואָ_, _течности_, _osote_, _санны_,
   {{0x627f423c,0xf30e7484,0x97dcd2a7,0x0c5be3cc}},	//   _eventi_, _alabesa_, _талаблар_, _европт_,
   {{0xe85424f5,0x2201931e,0x588920bf,0xc7ecd11d}},	//   _توليد_, _aasim_, _мартабал, _achateng,
   {{0x42d8c056,0x926cc233,0x03ea9218,0x226e73d0}},	//   _bilego_, _velona_, _brath_, _jasoko_,
   {{0xf1950212,0x8291021c,0x12ac003d,0x1c5a6025}},	//   _ababalul, _shaadi_, _ټيليفون_, _amititi_,
   {{0x42d90050,0xcc07b0c0,0x8dfa00bf,0x6200b44d}},	//   _libero_, _grasset_, _сайловчи, _ludilo_,
   {{0x9ae88026,0xd31b608e,0x820190a9,0xc887d217}},	//   _geworden_, _gencinh_, _wasim_, _кабарда_,
   {{0x7a85109a,0x9d4b552e,0x72901334,0x926ce22c}},	//   _قويدى_, _निरीक्षक_, _nphau_, _fonoti_,
   {{0xa25a51fe,0x3157b301,0xa3c5305b,0x83795304}},	//   _walla_, _pristupo, _تاريخچه_, _katanya_,
   {{0xe883d05f,0x620d5026,0xec9162d7,0x62919200}},	//   _alekaned, _positief_, _bodutung_, _niyaki_,
   {{0x23806391,0x928d6439,0x1033725a,0x8db0632d}},	//   _sauran_, _ibukota_, _eksteraj_, _parikalp,
   {{0x238694a5,0x6189a06d,0xbe2bf032,0x82920056}},	//   _ndare_, _фармонде, _laugarda, _bopago_,
   {{0x32267004,0x32eb13e3,0xc0639105,0xdd289022}},	//   _berkas_, _difisil_, _בארגן_, _насихатт,
   {{0x7291601f,0xa23695fd,0x81a930db,0x3d9b6394}},	//   _magana_, _dvaja_, _приятиел, _parlasma,
   {{0xf648e0fe,0xa874c11b,0xde4c60d0,0xf23b4064}},	//   _bishingi, _гласова_, _tipaakut_, _médicame,
   {{0xca15b27d,0x62fe60c3,0x8614b07d,0x6359e05a}},	// [11f0] _islaamka_, _drugom_, _akseptem_, _situació_,
   {{0xf138e0ce,0x14a8c2f2,0xc37d41f8,0xbc582031}},	//   _لبنانی_, _başlanıb_, _pisanje_, _ስልጣናቸውን_,
   {{0x8291a0d2,0x4b93b012,0x2386d295,0xc247606e}},	//   _espai_, _انفراديت_, _adera_, _evaluasi_,
   {{0xd9aaa0e5,0x7a75b1d4,0x3c7c503e,0x174ef1f0}},	//   _मुख्यालय_, _akiligas, _adesina_, _тәртипле_,
   {{0xc86400b6,0xcfd82041,0xb94e2129,0x5d9202b5}},	//   _fernánde, _تقويه_, _adoloxxe, _foregone_,
   {{0x825af071,0xf27ef11e,0x9fd6835b,0xa9d84501}},	//   _spiler_, _joiner_, _кваліфік, _okuthand,
   {{0xe2916378,0x4386907b,0xa64f2022,0x52026228}},	//   _dagana_, _adare_, _ипотекал, _syriac_,
   {{0x426460f9,0x0201d3c8,0x23188249,0x186c2225}},	//   _skullu_, _dawiv_, _tinizong_, _notifiqu,
   {{0xa2020200,0x8a22c0dc,0x62925024,0x09da40e3}},	//   _pasiri_, _откон_, _antato_, _amandeep_,
   {{0xefeeb00e,0x8b5f70fb,0x53ea9055,0x086af15f}},	//   _partlayı, _श्रेष्ठत, _frati_, _titiqiru,
   {{0xe92400ce,0x0897c2cb,0xacfe1031,0x9d5ac0bf}},	//   _مسلمانوں_, _مرتبي_, _ትፈልጋለች_, _жомеъ_,
   {{0xc22472d6,0x9d9b80b2,0xf69e0121,0x8265f009}},	//   _tonko_, _onionhea, _स्वार्थभ, _скопиров,
   {{0x4291f16f,0x561b455d,0xc9fa104a,0x7af09213}},	//   _estas_, _tunngavi, _musikana_, _janukast,
   {{0x1f072225,0xc98e1481,0x2f02c022,0xf86311e2}},	//   _disponív, _фатир_, _лекцияла, _мотами_,
   {{0x1249f1fa,0xb2925057,0xf3828209,0x525a5229}},	//   _akume_, _astazi_, _ekeresim, _dallo_,
   {{0x79a8e059,0x830cb257,0x7fd4f314,0x39cfb034}},	//   _እናያለን_, _hesabat_, _bižuteri, _bellezza_,
   {{0x0ae56128,0xa2df6191,0x12d8a0b8,0x8b4360fc}},	// [1200] _appealab, _anmodet_, _oybek_, _төрөнә_,
   {{0x92019595,0xe290f076,0x225b5109,0x1291622c}},	//   _masih_, _ahiahi_, _spelar_, _gagana_,
   {{0xf3a950c1,0x8e542261,0x1c048253,0x83443223}},	//   _madaling_, _minaccia, _amasani_, _sanduku_,
   {{0x9200c1d1,0xfcb06085,0xd0d41019,0xbb0d8118}},	//   _kulilo_, _স্প্যানি, _קרובֿים_, _kissimme,
   {{0x2394e395,0xf3ac731f,0xd3f474e0,0x22e3a06e}},	//   _shishe_, _grupos_, _pastaj_, _तपशील_,
   {{0xf3ea921d,0xb531f34f,0x3b18e455,0x450a8208}},	//   _prati_, _maligakh, _entamoeb, _agallamh,
   {{0x3c68e04b,0x8871a082,0x32019148,0xa8f9621f}},	//   _bugungi_, _spinosau, _tasik_, _belageru,
   {{0xe73590d7,0x5f073080,0x2ac1a03b,0x53ea91f8}},	//   _алалар_, _pinceles_, _abukisis, _vrati_,
   {{0x2763b030,0xb4724041,0x6236644d,0x97b81276}},	//   _تحصیلات_, _تصنيفات_, _tvoju_, _سوجهرو_,
   {{0x3b7e10ea,0xdc5502d5,0xf3ead579,0x57eca08b}},	//   _ekologic, _ailtire_, _drets_, _salajeng,
   {{0x88ce411b,0x9c5bf063,0x6b7e7443,0xcb325475}},	//   _источној_, _tartibi_, _pronombr, _mencetus,
   {{0xf3eb917d,0x5c673228,0x9236c2ae,0xe3806033}},	//   _musta_, _حرکات_, _hiljem_, _antret_,
   {{0x7d50717f,0x03ea9005,0x36b97284,0x137af4f1}},	//   _хабарӣ_, _esate_, _menageri, _asmaral_,
   {{0x8f9ed268,0x429160c7,0xe37971f3,0x92e941b3}},	//   _محبوس_, _lagala_, _baranya_, _cavilia_,
   {{0x2387f067,0xe219935b,0x02cae0e4,0x3a060065}},	//   _ajuru_, _режиму_, _gendoo_, _אברבנאל_,
   {{0x82f9e5fe,0x9179e5fe,0xf291f1c3,0xb41e00b5}},	//   _canhgya_, _canhgyah_, _astar_, _ءماجىلىس,
   {{0x727e019e,0xd20110e8,0xf86df0e5,0xf373f0a4}},	// [1210] _teina_, _kobiet_, _आदिवासिय, _chaghry_,
   {{0xfd8750d2,0x668de178,0x40521401,0xe8bc02ac}},	//   _desembre_, _arbetsgi, _phortain, _بازاڕێکی_,
   {{0xe2cf9128,0xa2019266,0x6a7f1009,0x038d2012}},	//   _astound_, _masii_, _обновить_, _umaskini_,
   {{0xead3309a,0xf250c340,0x24f7e25c,0xdb33124e}},	//   _تۇردى_, _легат_, _پالاتاسى, _احتراما_,
   {{0x61b1a0d2,0xfe13205c,0xa3ebf4d8,0x533e2025}},	//   _туруктуу_, _strelica, _erute_, _alhajì_,
   {{0x0249421f,0x0201b128,0x72009334,0x62d38148}},	//   _riemen_, _bowing_, _ncaim_, _bobotoh_,
   {{0x13eb9291,0x17e35170,0x21bb00f7,0xe27e0378}},	//   _gusti_, _oglašiva, _东方神起吧_, _neinn_,
   {{0x3387022e,0xed9370e8,0x723c90ac,0x8d9282df}},	//   _learns_, _listopad_, _생성합니다_, _bolebole_,
   {{0x77cc21d4,0x86d230ef,0x3b1b91dd,0x97db91ef}},	//   _napparsi, _kuhakiki, _delainab, _delainav,
   {{0x6bef21a5,0x227e01c3,0x4eb231b3,0xb2e973c6}},	//   _racecour, _beinn_, _excessos_, _miriona_,
   {{0x8d33f132,0x1593a0c3,0xd2ec6525,0x7e45d271}},	//   _теодоров, _prilikom_, _anbisie_, _reklamač,
   {{0x698e11aa,0x89ea6264,0x32b64186,0xe2b1f2c4}},	//   _насип_, _مراهقات_, _abadage_, _घरकुल_,
   {{0x5e49b009,0x630f423a,0xd9de1015,0x8290c0a3}},	//   _bayaziba, _barabor_, _multimid, _boland_,
   {{0x32fc6262,0x86d61061,0xe26e6293,0xd9f200a4}},	//   _ngoga_, _عالمانه_, _serivisi_, _daligada_,
   {{0x7bdfc10e,0x53f8c399,0x52916281,0x2c1d9118}},	//   _klientów_, _ahlula_, _lagama_, _ireport_,
   {{0x1e622548,0xe00350ac,0xc9a650bf,0xaf5b83bb}},	//   _imobilia, _인기검색어_, _амалдаги_, _balansan,
   {{0x927ee03a,0xdd33e0bc,0xb3c5827f,0xead170ae}},	// [1220] _kannel_, _atannije_, _بازووی_, _normadan_,
   {{0x38805241,0x725a514a,0xe9805241,0x45984296}},	//   _articolu, _aalle_, _articole, _abasayaz,
   {{0x0c5742ed,0x865a40bf,0x4e9740be,0xc30d12ca}},	//   _postime_, _turkmani, _postimet_, _demanar_,
   {{0x239675ff,0xd5cd3213,0x8b1300ac,0x3c6051d7}},	//   _cursus_, _jasaptay, _belangen_, _gartens_,
   {{0xd4068256,0x5291f07d,0x55f940d2,0x3396514b}},	//   _bahinduk, _istap_, _اياكتاشى_, _fausse_,
   {{0xe2ca0223,0xd2fe559c,0xdb654307,0xaf41a31d}},	//   _dhidi_, _thrives_, _aksenden_, _spessart_,
   {{0xb25a51e7,0x403721ef,0xb2a701fd,0x9b659510}},	//   _talle_, _dautagan, _çabuk_, _addukira_,
   {{0x32d9b3dd,0x3ed351bf,0xeb0c351d,0x545c817a}},	//   _dovelo_, _иеромона, _سابیر_, _সমকালীনভ,
   {{0x5c5bf13c,0x6d30e012,0x7c5583e5,0x9d93910c}},	//   _bertoni_, _hatimaye_, _pretoze_, _bolesome_,
   {{0x98aae248,0x40e1c049,0x59fa525b,0x4201d217}},	//   _ብምግሃስ_, _depósito, _russland, _rawil_,
   {{0xf248d166,0xd290e00c,0xab61d0df,0x82927005}},	//   _skemi_, _taiala_, _ememberr, _nesate_,
   {{0x9fa292ac,0xa27f05cb,0xf2373063,0xc2831287}},	//   _میزڵدان_, _nuanom_, _hammaga_, _palaikym,
   {{0xb2179009,0xb2ea100e,0x3f1fa4df,0xbc57c2c4}},	//   _просматр, _tarixin_, _vorderin, _क्रेग_,
   {{0x7cf2d004,0xf38773c1,0x40f81187,0xd68c311b}},	//   _خاتمه_, _svarta_, _kupindul, _образовн,
   {{0x43ead199,0x55fbf388,0x79cba062,0xf2f1009b}},	//   _dreth_, _پلاندانا, _agaleaga_, _leziomi_,
   {{0x429254fe,0xa40e10c0,0xb249f538,0x56b970a3}},	//   _lotago_, _amarnian_, _okuma_, _benaderi,
   {{0xb42c8121,0x327e01c3,0xddf020c7,0x7b995352}},	// [1230] _बराबर_, _seinn_, _انہور_, _هاریکاری,
   {{0x38cfb222,0x6320b430,0xf202423b,0x42e8e135}},	//   _stuttlig, _şeyin_, _cawiri_, _kalimin_,
   {{0xa62c3375,0xa386d459,0x2249417d,0xeddc2007}},	//   _ستالين_, _edere_, _hieman_, _الیون_,
   {{0x04533059,0xe40df0d8,0x91d31330,0x6b1ea2ca}},	//   _ትምህርቱን_, _cairdean_, _安全生产监督管理, _جامعىردا_,
   {{0x7493f026,0x827e20f9,0x6348c034,0xe83ee248}},	//   _블로거뉴스_, _tekna_, _modelli_, _ፋይናንሳዊ_,
   {{0x02c590da,0x4ecda074,0x7ed6c13c,0x954cf063}},	//   _inglese_, _komision, _адиле_, _гулистон_,
   {{0xc72661e6,0xfba0c0e9,0x52da6256,0xedccc0d7}},	//   _pratisaṃ, _анзор_, _kurema_, _ачарга_,
   {{0xe305c218,0x03cf43f7,0x129783e1,0x06e8e005}},	//   _دورات_, _preval_, _adekwat_, _манастыр,
   {{0x8c1c0600,0x63807095,0xb386e372,0x369223aa}},	//   _umlungis, _forrit_, _ukirin_, _aksesibi,
   {{0xa5c110de,0xf6e8c200,0xc3172365,0xad320049}},	//   _ئشتۅۅچۉ_, _janchini, _brandung_, _calidade_,
   {{0xc25a3169,0xf937a14c,0x42ca05e5,0x91dc7282}},	//   _kolleg_, _পদত্যাগে, _akida_, _אפרוען_,
   {{0x62cfe30d,0xc29161ca,0x9be5b342,0xc301203e}},	//   _permezz_, _magaca_, _randamac, _adobaje_,
   {{0xdc6f70ee,0x307070aa,0x23ead1ac,0x37078330}},	//   _heureka_, _bagatomo, _areti_, _请输入关键字_,
   {{0xc2eb63bb,0x5b7881f6,0xeb629332,0x13e2906b}},	//   _divisio_, _दर्शनों_, _feituuna_, _feituuni_,
   {{0x82c59201,0x135bf221,0x2a02f14c,0x630c1065}},	//   _anglese_, _bengena_, _কেউবা_, _בפקולטה_,
   {{0x829d8601,0xa7d91345,0x63781293,0xb2cb80ae}},	//   _všade_, _लालकिला_, _rubanda_, _yurdu_,
   {{0x0ebca0e8,0x43ead3ec,0xa272a159,0xff76210e}},	// [1240] _publiczn, _treth_, _tűnik_, _बाँझपन_,
   {{0xb968d168,0xd628d00a,0x72cad075,0x41b3214c}},	//   _activite, _activiti, _ugodna_, _সমবেত_,
   {{0x429262af,0x20580033,0x2b81b1b0,0xd30781c3}},	//   _morago_, _presedan, _sledovať_, _agbaidh_,
   {{0x5cf7c378,0x158a63be,0xe2927166,0xdaaf70ac}},	//   _leitaror, _yedemokh, _rurali_, _원칙적으로_,
   {{0x43f43009,0xe63644ac,0xa66051a1,0xd5bdd118}},	//   _влияние_, _galipedi, _opticalw, _binayloh,
   {{0x72d60509,0x92fdf171,0x1c8500b5,0xec28c264}},	//   _negosyo_, _ndugu_, _иқсанов_, _ديانا_,
   {{0x08f6607c,0xe789e1a9,0x847e613f,0x72906334}},	//   _kuzakuvu, _наразили, _חשבונאות_, _nplas_,
   {{0xf3ebf313,0xd2925280,0x5d9c3303,0x3ab410a3}},	//   _itutu_, _autaki_, _споруд_, _prakties,
   {{0x0b846102,0xdc62a033,0xbc56b1d0,0x303fb302}},	//   _рекламно, _antrene_, _vertice_, _posterin,
   {{0x1291620c,0x23a8e137,0x12dc82d7,0x19ed8164}},	//   _bagaca_, _malaking_, _babotsi_, _majistra_,
   {{0xd8d2812f,0x144b22cb,0x33d511df,0x247b8008}},	//   _ئەلئارا_, _انگلنڊ_, _protekti_, _üstesine_,
   {{0x66a16245,0x85472011,0xa386b0a3,0x2ab9a248}},	//   _imitheth, _германиа_, _opdrag_, _ዘልዓልዎ_,
   {{0xb27e03e4,0xfbdff384,0xfb812163,0x8bded59d}},	//   _teine_, _aplikáci, _autonomo_, _stadtkir,
   {{0x13ead055,0x0b9680e7,0x625b5168,0xedee303d}},	//   _preti_, _ndingano_, _speler_, _لمسون_,
   {{0xfea28602,0x13ac7242,0x5f15821f,0x279c0196}},	//   _landsins_, _grupas_, _bilderan, _puntuazi,
   {{0x2e1f7059,0x1292654e,0xf2db41b3,0xdc55b603}},	//   _ሲጠናቀቅ_, _morado_, _arrogar_, _kostrad_,
   {{0x13f96316,0x73ebf363,0xf5e6956c,0x2c6273f3}},	// [1250] _siguro_, _atutu_, _прошири_, _maturin_,
   {{0xfba41407,0x927ed3e5,0x22924283,0x323441fb}},	//   _allinnic, _hronom_, _akwati_, _ndamage_,
   {{0xa094113f,0xda2871d9,0x2c6fd04b,0xf25ad1e7}},	//   _פרידמן_, _سوققان_, _احاطه_, _kallis_,
   {{0x6ff9b41e,0xbc7f724e,0x2fb9d4ad,0x7c2a9248}},	//   _रचनाहरू_, _abimanyu_, _bogologo, _ኣምነስቲ_,
   {{0x0146017a,0x42d87437,0x69fa024e,0x3e27f47e}},	//   _গিয়েছে_, _synet_, _kirimana_, _animalas_,
   {{0x0623c01f,0x22fcf089,0x320191df,0x33847083}},	//   _taimakaw, _spigot_, _lasis_, _existeix_,
   {{0x137363ce,0x04ef0248,0x63c6b0e5,0x43d18227}},	//   _stelling_, _ብምልካዊ_, _फ्रान्सि_, _글루코사민_,
   {{0xa27e0165,0x52c30142,0x52c273ab,0xb3eb50ec}},	//   _seine_, _poslana_, _kvalita_, _mbetur_,
   {{0x625a5027,0xafd9f248,0xf38693fa,0xc61d0199}},	//   _dalla_, _ብቴሌፎን_, _adaro_, _aruthrol_,
   {{0x903aa17d,0xeaa7a441,0x099d21d9,0x37d983d0}},	//   _заключен, _задайте_, _жалын_, _сарантуя,
   {{0x975e20e5,0xa5330087,0xd9fc218c,0xd484d13e}},	//   _चित्रों_, _енергети, _umgangat, _विषाणु_,
   {{0xc200b229,0x6fc771a1,0x52d911b3,0xa2019207}},	//   _codice_, _ashingto, _recede_, _basit_,
   {{0xd9e9501d,0xca1ac388,0x12021455,0xef99523c}},	//   _einginge, _وزایی_, _alpint_, _високока,
   {{0x836af5fe,0xa396607d,0x53860248,0xa12715b5}},	//   _lingziq_, _hausat_, _ilire_, _парови_,
   {{0x03d7127c,0xe1b2b0af,0x9638b5cd,0x9f2312b5}},	//   _参考になった_, _名無しさん_, _akhlélwa, _coplanar_,
   {{0x923660ea,0xd2496329,0x73531342,0xe8bdd26e}},	//   _svoji_, _bigman_, _نهيان_, _нямала_,
   {{0xc9f23213,0x12924025,0x938771e6,0x9a5f1012}},	// [1260] _apanisma_, _akwasi_, _akaron_, _rwamakub,
   {{0x90f1b340,0x79598221,0xf78942f4,0x03fa01ad}},	//   _персониф, _abalahle, _гандантэ, _repute_,
   {{0x69ae033c,0x8291a16c,0x638740e3,0xa3070041}},	//   _خیریه_, _espay_, _sheryn_, _abayifum,
   {{0x32d8757c,0x190d00c8,0xc200f08e,0x8dbf3143}},	//   _synes_, _народная_, _dagiz_, _andimela,
   {{0xa17f305e,0x5233151d,0x55d063be,0x4225b40e}},	//   _kitautol, _پێشڕه_, _квартиры_, _xavkom_,
   {{0x5ece625d,0xaa719054,0x735be057,0x4c51f213}},	//   _plaisirs_, _larabawa_, _asigura_, _muntana_,
   {{0xfeaa8262,0xd2cad0cb,0xd3dde01e,0x3e488172}},	//   _baturage_, _rhodri_, _betwa_, _senamune_,
   {{0x337520e1,0x22247395,0x198020ce,0x77e8f121}},	//   _actualam, _donku_, _kivitele, _strateeg,
   {{0xbdb9b126,0xc278b35b,0x8290746c,0x9ec1d0f2}},	//   _ankaboot_, _закарпат, _opnar_, _कलाकारहर,
   {{0x2c49a327,0x8ae310b9,0x1d14f0aa,0x1ad28303}},	//   _abiyamo̟_, _toplanan_, _akarutur, _apotekse,
   {{0x68124078,0x9201900a,0x15273009,0x4d05d3db}},	//   _عبدالعزي, _basis_, _целях_, _enkleste_,
   {{0x7872b30f,0x324974b4,0xed3903ab,0x2b0c244c}},	//   _हरिश्चंद, _kiaman_, _digizone_, _зурна_,
   {{0x5a51224f,0x8cb1a190,0xd27f4138,0x39e5c3df}},	//   _naammass, _babalavu_, _krenem_, _andrestu,
   {{0xfe5ba517,0xbe3183f7,0x198770a8,0x89028180}},	//   _изберете_, _prezante_, _सभामुख_, _は参考になりまし,
   {{0xe7d0c24b,0xf247a4ec,0x32fe406c,0xdc77001c}},	//   _книге_, _otelleri_, _haridus_, _بالعموم_,
   {{0x83ebf0f9,0xb2ca3311,0x3247f225,0xdf3b8169}},	//   _stutt_, _kimden_, _кариера_, _appleric_,
   {{0x9291f21c,0xc27e217a,0xddf6a17d,0x9200b033}},	// [1270] _istat_, _tekne_, _ресурсов_, _andire_,
   {{0xf3876486,0x194391c7,0x12e37438,0x029241ca}},	//   _regras_, _секторын, _welizwe_, _hawada_,
   {{0x39dea26d,0xf986115b,0x5d2a7251,0xd413c1a2}},	//   _baanelwa_, _edukeise, _советник_, _колеса_,
   {{0x6c73201a,0x939ab248,0xc83ec381,0xa5811292}},	//   _تارقالدى_, _መዘኻኸሪ_, _викки_, _европага_,
   {{0xec00d431,0x7dbc32ae,0xa63c320e,0x0a8ca437}},	//   _maisons_, _regionaa, _regionai, _antikken_,
   {{0x1daba123,0x91241019,0x8278b07c,0x9d2112f7}},	//   _minisipa, _שטאפלן_, _nejimeni_, _тәрбийә_,
   {{0x027e0032,0xa296a275,0x02906100,0x363f3364}},	//   _meina_, _يانداش_, _aplay_, _daleelá_,
   {{0xf27e03d9,0x3410b3c3,0x03a3a365,0x7baa00c2}},	//   _leina_, _forsiden_, _rippe_, _наркопол,
   {{0xf38e03f2,0xd9aac16e,0xbb6c7121,0xa997e180}},	//   _ebusweni_, _водио_, _वामना_, _相田すみれ_,
   {{0x8c70f286,0xbe3bc04a,0xe6bbc04a,0x2344b12a}},	//   _kajsiab_, _achakupa, _achakupi, _aquelle_,
   {{0x11b3c2d1,0xd20ec0d7,0x52e5b395,0x73ea947b}},	//   _کابرا_, _камаз_, _ahengua_, _asato_,
   {{0xa95d212f,0xf3f40111,0x895a730e,0x938062f5}},	//   _ۋەئەلەيك, _ekster_, _विरुद्धक, _eburen_,
   {{0x527e0109,0xd14c0005,0x425aa01d,0x027c11b1}},	//   _beina_, _наколькі_, _rable_, _играл_,
   {{0x9ae0f2bd,0x12b4d4d5,0xedd8616e,0x729a534e}},	//   _mosebets, _chocar_, _владавин, _ababeham,
   {{0xbf12f521,0xe59fb1ab,0x1b8321fc,0xfc933352}},	//   _ferdigen, _pangunah, _avunatar, _ئالای_,
   {{0x50991037,0xb2a6c05d,0x1857b141,0x9089d0bf}},	//   _информ_, _dumber_, _алмандыг, _машинаси,
   {{0x9dcec2a3,0x798ec415,0x927e0083,0x7295808a}},	// [1280] _тимер_, _тамир_, _feina_, _amabhayi_,
   {{0x94b28036,0xb2a6d2e8,0x026c209e,0x8dc5e1df}},	//   _organizz, _phobal_, _sukob_, _efektive_,
   {{0xc12d31d9,0x29d793d2,0x605ae10f,0x75c7616e}},	//   _қайта_, _embezzle, _بربادی_, _критериј,
   {{0x63eb95b5,0x96fd93ac,0x847ed3be,0xe28cf1d5}},	//   _vrsta_, _lindolên, _видов_, _varaždin_,
   {{0x4394e1a5,0x93db1248,0x00bc31ca,0x46d161a6}},	//   _elisha_, _ጉርብትና_, _ناشہٕ_, _akagcinw,
   {{0x3a89623f,0xf248e281,0xd3e1e22c,0x6721342c}},	//   _altiplan_, _dhiman_, _alititai_, _helsingø,
   {{0xd085d159,0x3e5402ff,0x374f921d,0xb3866201}},	//   _عباسی_, _coupland_, _साहसदण्ड, _alora_,
   {{0x84d79287,0x71265105,0xed889030,0xfaf980d7}},	//   _фанаты_, _שטיפֿמאַ, _синовлар, _байлыкла,
   {{0x02907103,0x2951315e,0x6fc7d102,0xdc6d3234}},	//   _aqnaw_, _borondat, _дизайну_, _darujem_,
   {{0x22d6b080,0xbc1a52c8,0x526474e2,0x61969040}},	//   _mayoreo_, _sparikas, _yauliz_, _buschugh_,
   {{0xf3866309,0x6cce10c5,0x9c4d5429,0x5c743225}},	//   _elora_, _akavumer, _aguivévo_, _colunas_,
   {{0x8789b287,0x54efc227,0x786a61bf,0xeebb236d}},	//   _pasveiki, _부모교육의_, _лигациун, _excommun,
   {{0x5386d35f,0x42d83055,0xac704033,0x39ca2247}},	//   _tvorba_, _numeru_, _asasine_, _süleyman_,
   {{0x682e2162,0xc24c8248,0x4c62b1d0,0x1946e1e9}},	//   _архип_, _ተስፋኣለም_, _lazurio_, _drimmele,
   {{0xdb245248,0x92c5b0f0,0x62fe6341,0xf7d53136}},	//   _ቀልጢፎም_, _analyse_, _lapidus_, _умард_,
   {{0xefaa7032,0x57eca439,0x8183c358,0x89c73371}},	//   _nemendur_, _belakang, _платы_, _kreditne,
   {{0xae1c9080,0x06b713b1,0x730c331f,0x29ccb243}},	// [1290] _creencia, _प्रयुक्त_, _relatos_, _kesejaht,
   {{0x42cae41a,0xdee0c1b1,0xf5c1212f,0x931f41e5}},	//   _munden_, _земле_, _даңқини_, _agzıbirl,
   {{0xd455c428,0x9bf20222,0xec5b8387,0x43f8d4f4}},	//   _tilveran_, _justinus, _baptisi_, _hulutu_,
   {{0x826cc496,0xde3451ab,0x930fa4be,0x2fe6a14c}},	//   _veloma_, _kinatawa, _tribalo_, _শেষমেষ_,
   {{0x12eb9368,0x2394e2bf,0x6c537213,0x98df929d}},	//   _bilipim_, _akishe_, _mistupa_, _dongerad,
   {{0x125ab059,0x2200c4b5,0x425b5010,0x7972d06a}},	//   _afdlin_, _culimo_, _bieldy_, _कन्हैयाल,
   {{0x19968124,0x12ee40e4,0xbb8452d2,0xf201013d}},	//   _сантос_, _veritab_, _beantwor, _urbino_,
   {{0xc9e093e9,0x026c6095,0x363723d0,0x227e015c}},	//   _लपेटे_, _stoop_, _тарианы_, _weini_,
   {{0x3b0cd15d,0x02ca632b,0x3c00d0f0,0x5354f339}},	//   _تالیا_, _chodi_, _raisons_, _anketas_,
   {{0x061f2213,0xae801123,0xf3957135,0xc941f168}},	//   _amanqasi, _gouverne_, _thashe_, _hierover_,
   {{0x6810e166,0x825aa223,0x52eaa068,0xc3b6811b}},	//   _བསྐྱབ_, _kabla_, _manipal_, _razvila_,
   {{0x32320152,0x12ca52db,0x63f8c367,0x899d22ca}},	//   _varmaan_, _belledi_, _deluje_, _сарык_,
   {{0x195f80ef,0x0378b07e,0x82d8c55a,0x5e38f442}},	//   _kiingere, _utvalda_, _nyder_, _aisanota,
   {{0x03fa52bf,0xe59c5009,0x29aa11e2,0x93ca715d}},	//   _gituma_, _yokuphik, _ботил_, _نوشیدنی_,
   {{0x2f31d0bb,0x2b6101c4,0x22d8c19a,0x32fd410f}},	//   _республі, _doorstep_, _hyder_, _idegen_,
   {{0x3b8755a5,0xcecd6077,0xbb71e317,0xf887233c}},	//   _filimler, _alaininn, _mouladur, _ватанда_,
   {{0x327e90db,0xb3fa5604,0x5d8b1031,0x79742105}},	// [12a0] _teana_, _bituma_, _የመሰብሰቢያ_, _מרחשון_,
   {{0xc9139445,0xb7ef9180,0xda6cd192,0x19c9e01a}},	//   _merangku, _ジャケット_, _райондар_, _القووسۇن,
   {{0x1386c193,0xfadfa2ae,0xb201d13d,0x739310f4}},	//   _arorae_, _korterit, _aawit_, _موتسىكىل,
   {{0xb96d0431,0x027e92fb,0x930df1d8,0x1efd4231}},	//   _proposer_, _deann_, _réaksi_, _तहलका_,
   {{0xb95d0331,0x91c6447e,0x1aa840c5,0x01ccd0d7}},	//   _absolutt, _beatritz_, _arakigab, _чылар_,
   {{0x35be4031,0x113a414b,0xb291f157,0xa72b20b5}},	//   _እንዳየነው_, _quantité_, _ustaz_, _ءﺍﻳﭙﻴﯔ_,
   {{0x0545c023,0x826cc1ac,0xb94413db,0x84a7a370}},	//   _afriikiy, _heloka_, _evaluere, _техникии_,
   {{0xeb3d912f,0x338691e5,0x33fa5181,0x62da620e}},	//   _конферан, _olara_, _zituma_, _direto_,
   {{0x2320f1c5,0x7330e342,0x1248d012,0x2070d113}},	//   _baryonyx_, _اقتصاديا, _njema_, _pamatojo,
   {{0x0eda9198,0xe27e919d,0x3cf99026,0x426cc079}},	//   _втората_, _beann_, _ingelogd_, _deloka_,
   {{0x43869484,0x2ed6813f,0xb2ca6067,0x338863aa}},	//   _alara_, _opinions_, _ekoda_, _ekspansi_,
   {{0x3cee437c,0xce394605,0x0c753083,0xc478b12c}},	//   _centrafr, _deportes_, _этникалы, _awugusto_,
   {{0x1255a01c,0xc29272df,0x3e643252,0x3a77239e}},	//   _problémá, _sasaga_, _алатоо_, _parlatas,
   {{0xcf25b036,0x02d8e13c,0x527e0378,0x71c7d007}},	//   _selezion, _pinedo_, _neinu_, _دراندازی_,
   {{0xaf65a051,0xd2ca6336,0x420111d8,0x6a6b639c}},	//   _attachin, _akilisi_, _cicing_, _ئىمران_,
   {{0x7fc2d2cb,0xc2d8c27c,0x519930de,0xa3eb905c}},	//   _يادون_, _byder_, _اقدئل_, _vrstu_,
   {{0x3b4d00d7,0x55b700d7,0x03875598,0x022ac287}},	// [12b0] _премьеры_, _sabantuy, _zuerst_, _домам_,
   {{0xb29161d8,0x9660a1f3,0x83ead289,0xd24a6346}},	//   _sagala_, _antikvár_, _pontif_, _inuman_,
   {{0x8200c0ef,0x2b09d447,0xf3167045,0xd201d22b}},	//   _kuliko_, _реально_, _baibuli_, _sawit_,
   {{0x4386002e,0xf50a0218,0x152d1606,0x6cdab300}},	//   _koira_, _gaillimh, _proposto_, _norvegeg_,
   {{0xe2f4815f,0xf72f9184,0xb26c93e3,0x84739309}},	//   _kinguani_, _solombav, _lakour_, _daleghmo_,
   {{0x927e936f,0xb386f0d9,0x9d0c63fb,0x49940094}},	//   _leano_, _degre_, _smartfor, _emakumee,
   {{0x5c643431,0xb311b016,0xd973834f,0x6a1e5041}},	//   _contenu_, _taubhau_, _titigakt, _ويلاديمي,
   {{0xd3f833a5,0x8bce600f,0xf836f227,0x000d72c1}},	//   _amaziko_, _додержан, _제공사선택_, _kahveren,
   {{0x93cf0315,0x5386f2ca,0x138023bf,0x827491fa}},	//   _clavis_, _negre_, _verrà_, _cristibl,
   {{0x1e7771be,0x435614a9,0xb2ed7051,0xd9624196}},	//   _خاندان_, _atafika_, _reproach_, _planteat,
   {{0x5ee361bd,0xd54ec35b,0x33877054,0xa2fcf44e}},	//   _spokojen, _дивно_, _akarin_, _dongay_,
   {{0x79c710d7,0xed277175,0xa27c50a1,0x9c060105}},	//   _карала_, _redouble_, _nînga_, _אױסזען_,
   {{0x626da22e,0xed07c2f4,0x6ad2f1af,0x2262a20b}},	//   _savoie_, _дажгүй_, _tautohet, _भक्षक_,
   {{0x027e947d,0xa8ea31d4,0x4b6d421c,0xcc6af060}},	//   _teann_, _pitsanng, _karriera_, _fortify_,
   {{0x8bee10bf,0x67dc304b,0xc8b8c34e,0x70d53102}},	//   _катор_, _хайрулла_, _бумбгузо, _журнали_,
   {{0x9e539243,0x127e0188,0xb3957106,0x42026181}},	//   _perangka, _keint_, _alasga_, _muriro_,
   {{0xf27e904d,0xb30fd24b,0xd283f356,0x43000453}},	// [12c0] _seann_, _nombuso_, _alikona_, _bombard_,
   {{0x72f162c0,0x9c1d4266,0x82ca90c3,0xd93a109a}},	//   _matukaay_, _akapulu_, _ikada_, _параванл,
   {{0x42d62083,0x2ee6e0f5,0x2326e0ff,0xb3f7f0fb}},	//   _millors_, _richtlin, _richtlij, _प्रधानस्,
   {{0x17a56284,0x19f0a358,0x60686030,0xa7b3f182}},	//   _appellav, _kunnolla_, _والسوالی, _ananurūp,
   {{0xcc152121,0x8df7235b,0x6f99e031,0xef5bb2fa}},	//   _विक्रान्, _заявила_, _ችግሮቻቸውን_, _achatsan,
   {{0x7eb1734a,0xfdc6223e,0x32d50395,0x65bca5e4}},	//   _bafumane_, _afaktira, _kurotia_, _karleuša_,
   {{0x03412193,0xce539243,0xbc5a508c,0xb6f2c0c2}},	//   _anbeten_, _serangka, _voltooi_, _курсында_,
   {{0x2e8fd2c2,0xe3f43538,0x0d46a0f6,0x33018438}},	//   _premalen, _kartı_, _гырылмаг, _acebise_,
   {{0x5e0ab15d,0xb27e440a,0xb290319d,0x2248e16c}},	//   _کتابخانه_, _femna_, _cumail_, _chimen_,
   {{0xab14e213,0x4a139332,0x9d08b289,0xaea6c227}},	//   _arusakha_, _angamahe, _enrollet_, _제로마켓의_,
   {{0xc2fe6231,0xe2da0395,0xb30d441e,0xa5981179}},	//   _drugie_, _casely_, _posadit_, _kennurum_,
   {{0xa5c7a17d,0xc2b66053,0xb2e3916c,0x7a0de04a}},	//   _германии_, _kirche_, _latitid_, _achangoe,
   {{0x4b1b0124,0x4db172ab,0x23966447,0x0632a44c}},	//   _squadron_, _marijamp, _alusta_, _nabigazi,
   {{0x999c41e8,0x7348021a,0x668313e6,0x6dbd1292}},	//   _sarjassa_, _sukelti_, _hereturi, _mushtara,
   {{0xdd9c804b,0x22ec6113,0x776280f4,0x021c548e}},	//   _munosaba, _mobilie_, _ئەلخۇش_, _bethan_,
   {{0x73aa1316,0x8e553041,0xa828c1ed,0xc9faf087}},	//   _maraming_, _بوخته_, _киресенч, _unnskyld,
   {{0xe26c6151,0x01580083,0xf2d56409,0x641191b1}},	// [12d0] _ntoos_, _pressupo, _birokra_, _регулиру,
   {{0xe28960d7,0x929163b4,0x22b1e142,0x171aa56c}},	//   _bashkir_, _bagaka_, _prodana_, _florianó,
   {{0xc63bc244,0x03eae024,0x3947c241,0xcdcec01a}},	//   _askitapx, _yantra_, _бикаме_, _билек_,
   {{0x760cc39b,0xda831196,0xe21c5199,0x410e6288}},	//   _bokomisi, _genituen_, _gethin_, _хомиладо,
   {{0x77b4917a,0x6e4ab325,0xfc2740ec,0xd292419e}},	//   _armering, _behandle_, _serbisë_, _kawana_,
   {{0xa27e929d,0x42fc6187,0xa200c3de,0x9395749e}},	//   _geane_, _agogo_, _folije_, _blasda_,
   {{0x02d8808c,0xe3a2e0fd,0x7060715f,0xb2d905b2}},	//   _beheer_, _tanpri_, _maniknik_, _becomes_,
   {{0xc72e4019,0x6280b144,0x3c2880f8,0x2a47434d}},	//   _inkluziv, _abukene_, _милицияс, _harendra_,
   {{0xa3b61065,0x63ebf4d8,0x3c7c9079,0x527e950b}},	//   _אימיול_, _eruta_, _konsiyn_, _beane_,
   {{0xcc46e08a,0x19c23368,0x726c616d,0xce1d4264}},	//   _ګرامر_, _koperese, _eroof_, _وتجارب_,
   {{0x92927203,0x524d6487,0x5340e1fc,0x9320e395}},	//   _masaza_, _métaboli, _bulekon_, _kanyan_,
   {{0x5623008f,0xc28af04b,0x867a6041,0xa2924404}},	//   _naturiol_, _samarali_, _وکیلانو_, _hawana_,
   {{0xb320e054,0x72015004,0x7ba90256,0x823400ca}},	//   _manyan_, _anging_, _arahagur, _परिचर्या,
   {{0x62910172,0x42d3c16c,0xd101f15f,0x415ac263}},	//   _babaso_, _istorik_, _nguyunik_, _abafuyil,
   {{0xc29e1083,0xf6d071bc,0x865c500e,0x62cad084}},	//   _تۅكمۅ_, _ئشەمبى_, _yetkinli, _akede_,
   {{0x0394e1a3,0xae947217,0xbfc8e060,0xc37a71d8}},	//   _aniswa_, _konkursı, _arringto, _citakan_,
   {{0x0b63008f,0x1499e0cc,0xe347e1df,0x6e00e17d}},	// [12e0] _materion_, _ডেস্কটপ_, _orienta_, _toteutta,
   {{0x6ba04392,0x80b57182,0x226e6230,0xef468205}},	//   _पैलतीर_, _विपुलं_, _jeropa_, _teesside_,
   {{0xe6170252,0x9b63019a,0xc02e10bb,0xd50c6036}},	//   _تاتاال_, _faterion_, _заяву_, _espresso_,
   {{0x442a83dd,0xf38661ec,0xd3eab437,0xe413c152}},	//   _nalazilo_, _plore_, _midten_, _совета_,
   {{0xc0536198,0x5248d189,0xa3a2b3bc,0x7200c319}},	//   _mensagen, _njemu_, _sleppe_, _polime_,
   {{0x7e4b1248,0x087ed15f,0x62245005,0x8289f174}},	//   _ፈረንሳን_, _quliarlu, _pilka_, _бранисла,
   {{0xbe51a216,0xc8c72275,0xf641f30f,0x327a81ef}},	//   _tagblatt_, _خرىستىئا, _beriklim_, _kilikali_,
   {{0xc224507e,0x70bf2360,0x2c7c0262,0x427e9025}},	//   _vilka_, _قصوری_, _abasaba_, _adanu_,
   {{0x527ed246,0x07a91351,0xc3957075,0x5ab9e031}},	//   _teena_, _دوستانی_, _glasba_, _እንደልብ_,
   {{0xe53240bb,0xe386d0bc,0x8a15d051,0x83966266}},	//   _централь, _ilera_, _checkere, _amusia_,
   {{0x53170285,0xa386e328,0x83ff7181,0xce1a6179}},	//   _amazzi_, _quirke_, _isuzuma_, _aftengja,
   {{0x0b913403,0x93722249,0xc2e8c297,0x7d8051cf}},	//   _abanjalo_, _sanadad_, _páiste_, _sommersp,
   {{0x8f596080,0xd2924100,0x73eb9027,0xcf372358}},	//   _despiece_, _mawala_, _custs_, _грузии_,
   {{0x9f322087,0xf2f3f1ae,0x31b66195,0x2b115036}},	//   _гостей_, _didapati_, _kwambiri_, _официалн,
   {{0xa01050c7,0x151711a8,0xf78f2141,0xf249f095}},	//   _ملاقاتھ_, _brazausk, _имринип_, _chums_,
   {{0x8292432f,0xe2924424,0x10b6c1e2,0x1e553264}},	//   _akwazi_, _nawala_, _одоби_, _عودته_,
   {{0x4b26c17d,0x146c608d,0x037b9542,0x8379f1e2}},	// [12f0] _одной_, _swifundz, _amlarem_, _nalapho_,
   {{0x5e9650c6,0x93965177,0xbe5051a0,0xc7ec02c4}},	//   _doctrate_, _aliyyak_, _natanola, _प्रियाली_,
   {{0x93860587,0x5b1e2404,0x1edec287,0xb161743f}},	//   _loire_, _اسپورٽس_, _treneris_, _ponožky_,
   {{0xb84cb0ea,0xb94d214c,0xdc80c136,0xc379f144}},	//   _सर्वोच्च, _সাধনা_, _жекей_, _balapho_,
   {{0xcc7a4009,0x6b5a20f6,0xa342716d,0x03f90095}},	//   _произошл, _башланын, _elteren_, _rebuke_,
   {{0xa386f2c0,0xbda3913f,0x726ce0e4,0x70e39065}},	//   _mbirum_, _שנצפו_, _konomi_, _שרעבי_,
   {{0xb1c3d17d,0xc9f3917d,0xe386011c,0xc228610f}},	//   _говорит_, _неприятн, _boird_, _címmel_,
   {{0xb386d07e,0x7201621b,0xb3786187,0x52e1b4b1}},	//   _flera_, _daginn_, _maganga_, _jabieng_,
   {{0xf779317a,0xef516026,0x32da12c6,0xe47c71bf}},	//   _স্মৃতিশক, _클릭하시면_, _appeti_, _консакра,
   {{0x138601c3,0x65e9b1f7,0xb45a2031,0x9048a031}},	//   _doire_, _tatarnıñ_, _ያስቀምጡ_, _አይገኙም_,
   {{0x04e88248,0xa27ed0c7,0xe26c608c,0x969ce270}},	//   _እትምራሕ_, _keeno_, _troon_, _perganti,
   {{0xbaded3c9,0xa7498383,0x62cab1ad,0xc26c4063}},	//   _auctorit, _alvorlig, _bedded_, _lumot_,
   {{0x6dbf31d0,0x4147c0f7,0xf30f8444,0x04e92031}},	//   _cadillla, _怒龙大都奢靡之始_, _odobrio_, _አልሰራም_,
   {{0xba7e8032,0x82926127,0xf64b5031,0xd1547199}},	//   _gunnarss, _gauana_, _የባሕርይ_, _amhriodo,
   {{0x52d9f125,0x827e0027,0x031da13f,0x997e1341}},	//   _inzego_, _meini_, _שילחו_, _qualitéi,
   {{0xd5841248,0x8db99429,0xe03ce1b3,0xeb97705b}},	//   _መንበራት_, _аномер_, _decennio, _بالران_,
   {{0x32e5c212,0x890b10ac,0xcfb92049,0x8290e51f}},	// [1300] _مبارز_, _감사드립니다_, _métodos_, _manado_,
   {{0xe26e60a7,0x022470bc,0x32d8a4e0,0xd27e91a3}},	//   _istoku_, _yinka_, _sidomos_, _neana_,
   {{0x9d439248,0x6623e0dc,0x8ae6a261,0x1f922296}},	//   _ሰንሰለታዊ_, _ئىنتماقى, _feltrine, _abamapro,
   {{0xa26c249b,0xb3860297,0x0d96c372,0x59d71356}},	//   _rukom_, _foirm_, _imillana, _aukekule,
   {{0x6f6c60f7,0x83ebe15a,0xdcfec248,0x637fc207}},	//   _vacances_, _zgromadz, _ክትመላለስ_, _almanca_,
   {{0xa3860335,0x3c74d249,0x32026105,0x6ec450d9}},	//   _plirs_, _minutas_, _striko_, _banyokwa,
   {{0xd29272ee,0x36d33116,0x97b4d1fa,0x437372aa}},	//   _masana_, _सुखिन_, _bohekang, _rangahy_,
   {{0x32b6606a,0x5c774257,0x527ef427,0xaa0c814b}},	//   _कर्मचाऱ्, _tutulur_, _segna_, _compliqu,
   {{0x9dc6a097,0x42d87289,0xb724a191,0xd3e4a109}},	//   _beskrive_, _evned_, _allmenng, _allmennk,
   {{0x83eb9142,0x1c229100,0xe3cff11b,0x96e592b1}},	//   _prsti_, _stereois, _razvio_, _entansif,
   {{0x827ef179,0x82ca9009,0xa85c82cf,0x6238b42d}},	//   _vegna_, _ekade_, _berlanju, _válido_,
   {{0xe3eb9367,0x830e6124,0xef3b71d0,0x92bc0281}},	//   _vrsti_, _nasales_, _jengglen, _suudaan_,
   {{0xa386613a,0x9201a464,0xe2374368,0xeabd32a0}},	//   _glori_, _éxito_, _badjet_, _تیشدا_,
   {{0x9d6f739e,0xb2247005,0xb97741b1,0x6200b291}},	//   _chimputa, _tinka_, _valitett, _bodine_,
   {{0x53f47036,0xcc53a107,0x6290e16f,0x82fd813f}},	//   _nostro_, _मुलेन_, _kanado_, _obvious_,
   {{0xd26c60bd,0xc13f2004,0x5ee14007,0x3395426c}},	//   _droom_, _دیکتاتور_, _الجزیرہ_, _plesna_,
   {{0xf341536b,0xa5652223,0x0248035e,0xd2b9e238}},	// [1310] _anderen_, _انسانيت_, _ndima_, _nedeleg_,
   {{0x0610f40d,0x5c34310f,0xf76a61ba,0x8a9b7175}},	//   _مانچھہ_, _قبیلہ_, _забавлен, _diminyas,
   {{0x96cda2f7,0xc81830c8,0xa387f03e,0x0287331e}},	//   _аяллар_, _супернік, _adura_, _ajikane_,
   {{0x8d684155,0x93866018,0x16d370e5,0xf2b280a3}},	//   _русларни, _flori_, _शातिर_, _vandaan_,
   {{0x1682e274,0xc25b8378,0x5f3f919e,0x438690b2}},	//   _उदगार_, _varla_, _kingitan, _xmary_,
   {{0xe0ce01d9,0x642e73d7,0xd2b28316,0x2f5d41aa}},	//   _بەرگەندە, _प्रतिभाग, _tandaan_, _bapatsan,
   {{0xc2c59332,0x16cc91a0,0x0f2240d8,0xf95120dc}},	//   _emeline_, _bomalini, _stornowa, _اساباداع,
   {{0xc2428003,0xd950f21d,0x0414f005,0x199e600f}},	//   _्यालय_, _नोपलभ्यत, _выпускні, _повернен,
   {{0x190a7225,0xadb250ac,0xdf5d5223,0x6292712d}},	//   _последен_, _탄핵소추의_, _mapamban, _fasana_,
   {{0xa85b4365,0xd248c07e,0xa3eb90e8,0x72927293}},	//   _timotheu, _rummet_, _pusty_, _gasana_,
   {{0x726cc0a0,0xa8040105,0x59f3e052,0x87b4f210}},	//   _koloni_, _אָנטייל_, _francija_, _arketing,
   {{0x56d8f212,0x326b73af,0x374dc32d,0x3721c111}},	//   _مبارکی_, _gingniem, _प्रहृष्ट, _komentoj_,
   {{0x0639327c,0x056b512e,0x929272df,0xb2ea1054}},	//   _ブログ内検索_, _napisał_, _yasana_, _tarihin_,
   {{0x278a0340,0xed13538f,0x2dcc5165,0x02ca0459}},	//   _валабили, _kunstwer, _wichtige_, _ijide_,
   {{0xfb057389,0xd386d27a,0xf2bb00f3,0xd26ce030}},	//   _shugaban_, _smeru_, _celente_, _minoti_,
   {{0x93eae004,0x6e3450cf,0x4a8d40ac,0x22d01242}},	//   _dinten_, _tinatawa, _papieren_, _asamblej,
   {{0x7384213f,0x024943f7,0x727ed20a,0xd87582a7}},	// [1320] _מנהיגות_, _chemen_, _beene_, _موضوعلری_,
   {{0x1f63a307,0x97dcd1ed,0x0317020d,0xdc2e500d}},	//   _alfarnes_, _малайлар_, _atazak_, _banneexu_,
   {{0x7fcb02aa,0x12cad267,0xcdb4d213,0xf634d213}},	//   _verindro, _chedo_, _kusisiya, _kusisiyi,
   {{0x74fb314d,0xe27e6273,0x53f09044,0x0248d28c}},	//   _खलनायक_, _sfone_, _ipurangi_, _tuomet_,
   {{0xc2cae17d,0x752d6078,0x126731bf,0xc680e0f8}},	//   _niiden_, _lonnaith, _депун_, _infektsi,
   {{0xc27800cc,0x4c66d0b2,0x5a7d0169,0x03eae24e}},	//   _সম্পাদক_, _mentsis_, _besonnes, _kinten_,
   {{0xe320b3c7,0xa3a8e4ad,0x32ea0181,0xc14ec218}},	//   _precios_, _atlageng_, _bugingo_, _dealramh_,
   {{0x3185d292,0xa2d921e0,0x328a108a,0x5ecd5367}},	//   _نظاره_, _quinque_, _اړینه_, _sluznice_,
   {{0x8eb091a6,0x0440b0af,0xddcc52cd,0x726e6496}},	//   _achumane_, _もっと詳しく_, _richtige_, _marobe_,
   {{0xb26a20f7,0x0386600d,0xfb5360f6,0xe66d3171}},	//   _编辑个人资料_, _doora_, _hemmetar, _سلاست_,
   {{0xd27f2378,0xd1fc54b5,0xd15a45f6,0x8fd6a264}},	//   _reyna_, _تصویٖر_, _astonish_, _والآخر_,
   {{0x12494165,0xf739c4da,0xb3f271d4,0xbd01e0aa}},	//   _themen_, _deportiv, _matumani_, _amuterur,
   {{0xd2908278,0xfc1a928d,0x7406a4f5,0x3b3b2243}},	//   _mahalo_, _reunited_, _بالاتر_, _perbatas,
   {{0x9c922387,0xbd0031ca,0xe93c3405,0x6379110a}},	//   _adahunṣe_, _ژھٲنڈ_, _deimhnit, _kupanda_,
   {{0x5f25b33d,0x521c62d7,0x6c679293,0x62cad0b4}},	//   _selecion, _bathes_, _bakunda_, _enelani_,
   {{0x5e42a0fb,0x9274102f,0x0c3372e9,0xac3d822e}},	//   _शिक्षाकर, _دوژلو_, _bidalahc, _campobas,
   {{0x330182b7,0x62e760d7,0x7bec4271,0x40cae159}},	// [1330] _wasanni_, _planın_, _relaxačn, _نعمانی_,
   {{0xe1ab7166,0xba043044,0xb2008336,0x32a672b1}},	//   _kummenti_, _manaakit, _ashiko_, _konba_,
   {{0xd668010a,0x2c89f034,0xebe0f0c9,0x02fc0531}},	//   _مومنين_, _равенств, _insekter, _maige_,
   {{0xf386d28a,0xb5d1503d,0x3b1d2264,0x0c7783ae}},	//   _flere_, _ګیلاني_, _للنجم_, _naproti_,
   {{0x3f80b0af,0xd3f462c6,0xd5a0c007,0x2e3240f4}},	//   _placerin, _fortia_, _الوطنی_, _ﺋﻪﺳﺴﺎﻻﻣﯘ_,
   {{0xc2927137,0xcf91f01f,0x1ea4330d,0xee03f3be}},	//   _masama_, _rundunar_, _kontenut_, _формате_,
   {{0xc27860e7,0xc27dd0a9,0xaa1e8248,0x99df90a9}},	//   _thungo_, _atuntaki_, _ክንግንዘቦ_, _awtorida_,
   {{0xbd8d5533,0x1b8bf086,0x5386d2b8,0xc45cf031}},	//   _demokara, _aleinwar, _klere_, _ያመላክታል_,
   {{0xf27802b9,0xef6c50aa,0x220253bf,0xf26c0297}},	//   _সম্পাদন_, _ababaron, _ottimo_, _crios_,
   {{0x4857830f,0xf35f32e8,0xff47829b,0xc290c1ab}},	//   _fakultas_, _taighde_, _мусофирб, _malayo_,
   {{0x5af3f3e1,0xfed7b0b9,0x22d4c1f8,0x226d204b}},	//   _underpas, _карьерас, _priliku_, _buyon_,
   {{0xfc33724c,0x2c6b02b5,0x5340a1ba,0x3b8c0065}},	//   _حقیقتھ_, _diluent_, _diventa_, _להנדסה_,
   {{0x1301f20d,0x0be55131,0x6f4143e5,0x927e9343}},	//   _arrazoi_, _diperbar, _bažant_, _feanu_,
   {{0xcb9132c6,0x06669004,0xc37f933c,0xaf98721d}},	//   _scandalo_, _يهوديان_, _mahalla_, _गहेत्वा_,
   {{0xcfed72b8,0x1dacd1db,0x00dd1031,0xf787c045}},	//   _verklaar_, _grafiske_, _የፕላስቲክ_, _akawunyi,
   {{0xa585d008,0xaa8950f6,0xc29270f6,0xd2fce387}},	//   _алайын_, _башланма, _hasaba_, _adigun_,
   {{0x73f4604a,0x63591414,0x02c870f6,0x32918231}},	// [1340] _portia_, _belfort_, _ашырылма, _spraw_,
   {{0xe5b192e5,0x6af5224a,0x32948045,0x827ed17a}},	//   _technoló, _sitewaas, _amakumi_, _edens_,
   {{0x0386d21f,0x62927414,0x8201a3e1,0x6985c2ce}},	//   _adorei_, _pasada_, _envite_, _amahanye,
   {{0xc438125c,0x8a23d0d7,0x270b7276,0x907760f7}},	//   _агенттіг, _номерлы_, _دعوائون_, _国务院环境保护行,
   {{0xa27e93ec,0x7305c176,0x5231d086,0x6c83a02f}},	//   _ifanc_, _اوراق_, _commodo_, _overberg_,
   {{0x370b73f9,0x881b60ec,0x4b197063,0x5f72a121}},	//   _anschiow, _domethën, _yaratgan_, _klubides_,
   {{0x2461415e,0xdf5d3163,0x9e48e0d8,0x618c42aa}},	//   _baldintz, _paraiban, _artaigea, _misafidy_,
   {{0x29fb043e,0x827e0032,0x12ab11d8,0x473180ac}},	//   _विज्ञापन_, _beint_, _mindeng_, _농업기술센터_,
   {{0x49db7064,0x227e0027,0x9974f212,0xb634f289}},	//   _第二十七条_, _meins_, _quintile, _quintili,
   {{0xf2247230,0xf27ed23e,0x5729c1e6,0x02d9e269}},	//   _tinke_, _neena_, _viũvāmit, _sytem_,
   {{0xe399d42e,0xea77b10f,0xf4121096,0xd27e0194}},	//   _næstu_, _villamos, _احمقانہ_, _weint_,
   {{0x828f300c,0xddffe3f2,0xe9bfe263,0x067fe34e}},	//   _tamaitai_, _abadinga, _abadinge, _abadingi,
   {{0xc27ed076,0xecc470f6,0xc38660bd,0xdf665249}},	//   _keena_, _швецияны, _moord_, _relaziun,
   {{0xe944908e,0xc388739e,0xf7e61065,0x939891ea}},	//   _doudangq_, _irayata_, _הביצים_, _заманлар,
   {{0xab6144c4,0xf85f6123,0x622790ba,0x37bbf2f5}},	//   _billiger, _emerzans_, _табият_, _ibugibug,
   {{0x27f38172,0x50081105,0xadc270c2,0xb2909228}},	//   _ditabakg, _הענעטי_, _субъекты_, _jajalo_,
   {{0xa2116438,0x097f9020,0xc27e91ad,0x00374088}},	// [1350] _ngakumbi_, _encircle, _jeant_, _pertahan,
   {{0x14155085,0xc9058560,0xd45d00b9,0xd3869414}},	//   _উদাহরন_, _sekaligu, _гүрләп_, _klaro_,
   {{0x0be7d2cb,0x22da5098,0x12495341,0xf5d4106a}},	//   _ارادي_, _intego_, _stemmt_, _ब्रिटनमध,
   {{0x13f2655f,0x326cb01d,0x72fc9387,0xfeb26058}},	//   _amashuri_, _arcol_, _agagi_, _amashure_,
   {{0x2b92d1fa,0xf2026446,0x9befe163,0xc61ad4de}},	//   _ahincinc, _norite_, _rotenbur, _horologi,
   {{0x827e0109,0x53966370,0x141d34b2,0x3f041345}},	//   _reint_, _omusha_, _vulanpro_, _प्रदेशो_,
   {{0x927e017a,0x7a8e92e4,0x93870071,0x1290c09b}},	//   _seint_, _changmin_, _moarns_, _malano_,
   {{0xedd5d12a,0x8290c0dd,0x1db0a13a,0x6e4c6008}},	//   _rochdale_, _eiland_, _hauslotu_, _бөлүмлер,
   {{0xb477c225,0x33877224,0xe386f0f9,0x34072030}},	//   _намера_, _swarwa_, _teirri_, _نداردنه_,
   {{0x427ee240,0x827ed2d7,0xac7c503e,0xff0410e0}},	//   _kvinna_, _afeng_, _afesona_, _प्रदेशे_,
   {{0xb2644105,0x32ca944b,0xd03fb373,0xe549a0bb}},	//   _דעליווער, _skada_, _kartolin, _запорізь,
   {{0x325ab2ae,0x2d70a47d,0x52d1309e,0x0f5c5335}},	//   _meelde_, _achmhasa, _narodom_, _arpagaus_,
   {{0x42c65010,0x3b824068,0x310720f4,0x59f2e065}},	//   _enclose_, _dianggar, _ئېلھامجا, _גינזבורג_,
   {{0xd2025537,0xac6a0021,0x32eb6228,0x86cca3a4}},	//   _artigo_, _overarm_, _ngantos_, _pelagoni,
   {{0xf387f14a,0xa25b80f0,0x67efc0ac,0x725ae2d5}},	//   _adure_, _parle_, _소요됩니다_, _ceilpe_,
   {{0xd386d41b,0xfa2c012f,0x9b18e04b,0x6631e0d3}},	//   _boere_, _франсийә_, _بازارلری, _obligazi,
   {{0x820163aa,0xe08ae28f,0xfb0ae606,0xa2d8e521}},	// [1360] _bagian_, _concello, _conselle, _menear_,
   {{0x9349e1a2,0x42a6a17e,0x82021369,0x9e9412eb}},	//   _hotelli_, _bobba_, _copiat_, _ahetũve_,
   {{0xff5b7288,0xc2a6a1cd,0xa2d9b25a,0x6c6161fc}},	//   _samarqan, _jobba_, _nivelo_, _fatuana_,
   {{0xbb1780db,0x160393df,0xb2da6074,0xa307b340}},	//   _kakarets, _поверх_, _mirepo_, _притяжат,
   {{0xad36910a,0xea5420af,0xc840c264,0x72b322f3}},	//   _mwingine_, _検索オプション_, _بخطوة_, _формуле_,
   {{0x6386641b,0xf27f43a5,0xd300c23c,0x286e4233}},	//   _woord_, _kwenza_, _infatti_, _herinand,
   {{0x8cf2c063,0x32da510b,0x395e13a4,0xb648d1d9}},	//   _باسمه_, _mitego_, _atrovast, _есеге_,
   {{0x72f504b2,0x42cae24a,0xc52940af,0x68d7315d}},	//   _vovinam_, _bondel_, _商品の詳細_, _sitegrou,
   {{0xaf414378,0x03bef065,0x02eec332,0x7cfb24a7}},	//   _hinsvega, _preview_, _atenisi_, _finematu_,
   {{0x101a21de,0x5776617d,0x833aa248,0x02d980a2}},	//   _životinj, _свободно, _ኣካላተይ_, _abenaye_,
   {{0x185fc2c1,0x93f9112a,0xf3eac40b,0xa2b20018}},	//   _zamanlar_, _siculo_, _ailton_, _gradina_,
   {{0xc27ed00d,0x42eca284,0x3e69306a,0xf8c6f0ea}},	//   _seeni_, _scripte_, _percobaa, _राजपुर_,
   {{0x1b398252,0x42494064,0x20d24030,0xedb4305b}},	//   _ракетала, _chemin_, _farovonl, _موسول_,
   {{0xb97e2174,0x39d2c4d9,0xe38e1230,0x0f7b82d4}},	//   _групу_, _confrunt, _reagearj, _allinyaš,
   {{0x9d2d034d,0x3ec610b6,0x715920b3,0x1c93d264}},	//   _mobilise_, _negocios_, _belderä_, _واضاف_,
   {{0x22d05267,0x96b760a8,0x29841065,0x81ffd2ff}},	//   _achorom_, _प्रयाप्त_, _שנקראת_, _dalanlah_,
   {{0xd843829e,0x5386929d,0x5c77c287,0xd34b919e}},	// [1370] _communau, _moard_, _кнехт_, _kawerau_,
   {{0x0065300b,0x7386d311,0x67dba0e5,0x686fa155}},	//   _allanngo, _ileri_, _परिक्षा_, _توققۇز_,
   {{0x1505512a,0x8a1d20f7,0x72911511,0x85fdf14c}},	//   _alquanto_, _européen, _debark_, _ছোনগাছা_,
   {{0x116322a0,0xec01301d,0x7bb3c136,0xc98741c7}},	//   _ناوزه_, _finster_, _коледж_, _ماتروس_,
   {{0xa6335027,0xb5811030,0xa96f12a5,0xf290c19c}},	//   _navigazi, _европада_, _abanigbe, _malalo_,
   {{0xa4dac23c,0x829044f1,0x837963fa,0x0572938c}},	//   _война_, _umman_, _kutanda_, _britansk,
   {{0xa2d8d039,0x6a8980d7,0x9de880f7,0x3507d0f4}},	//   _haneng_, _сайланга, _转载目的在于传递, _ﺋﯜﭼﯩﻨﭽﻰ_,
   {{0x929173c2,0x5395427a,0xc226610e,0x89d24142}},	//   _abaana_, _miesta_, _drukuj_, _napetost,
   {{0x60cbe2a3,0xb25ba16c,0xa9d45463,0x028d6167}},	//   _этапта_, _raple_, _angolapa_, _apaakunm,
   {{0xa3eae04f,0x3cfb000a,0xa58e82cb,0x32dcc52d}},	//   _pantai_, _selected_, _uchunguz, _redovni_,
   {{0x92c2e053,0x2ed0a263,0x62caf376,0xd2494135}},	//   _sollten_, _асорати_, _saidai_, _premte_,
   {{0xc48040c5,0x64a97023,0xb35955dd,0x82d8d0db}},	//   _akagagaz, _dariifal_, _ኣዝማዶም_, _faneng_,
   {{0x42c0109a,0x43a0b049,0x8f750061,0x061a812f}},	//   _инсан_, _máximo_, _اڻبڻت_, _ойлаватс,
   {{0xfc9330ef,0x52f38287,0x76d6108a,0x03869010}},	//   _خانان_, _padaryti_, _ظالمانه_, _hoard_,
   {{0x2c62b4c4,0x2c75f607,0x6f094280,0x33189102}},	//   _forrige_, _skjuler_, _akowanga, _бразильс,
   {{0x6a72d246,0x89f20216,0x7ce4a218,0x42da6369}},	//   _lavalava_, _obligada_, _استعماله_, _besones_,
   {{0x730d20e9,0xf909c427,0x9241d42f,0xeb1a62c0}},	// [1380] _relator_, _темата_, _undeterm, _andaloon_,
   {{0x727f7363,0xed033007,0xe0642065,0x80ab6022}},	//   _avanoa_, _نگراں_, _ברוסיה_, _ءىيتتىڭ_,
   {{0xba0a31a7,0xda36b264,0xe26c907d,0x0752314c}},	//   _masajist, _غالبية_, _kraon_, _বক্সে_,
   {{0x8823a608,0x784d6041,0x75099031,0x2f5c0281}},	//   _སྒྲིམ_, _ناقانونه_, _መድረኩን_, _madaxban,
   {{0x42247240,0xb26e523d,0x8063d2fc,0x726c9368}},	//   _einki_, _fetola_, _поводом_, _draon_,
   {{0x1f2db0ff,0x92258271,0x240d1264,0xc2f6e3de}},	//   _maatscha, _yorku_, _الفحم_, _kopiraj_,
   {{0xa3fb63c1,0xeb455248,0x42924404,0xe2f160bf}},	//   _människo, _መቕዘፍቲ_, _tawala_, _butunlay_,
   {{0xfc14c041,0x6ed0729a,0x46ca40de,0x50e5f00e}},	//   _روانه_, _penyakit_, _excavaci, _formasın,
   {{0xafae137c,0x86d6102f,0x0290e0cf,0xd61b5004}},	//   _assousso, _عالمانو_, _manalo_, _پرستاری_,
   {{0xd3869300,0x5aa9d083,0xb30a11cd,0x13a2d0cb}},	//   _doare_, _маселеси, _fotboll_, _stopio_,
   {{0x03f89151,0x1416a064,0xee896241,0xa24861e4}},	//   _txaus_, _依法追究刑事责任_, _латиниза, _edoma_,
   {{0x42d9a0bb,0x2280b144,0xd26e61c9,0x9fbc10c9}},	//   _typer_, _abukane_, _gerona_, _традиції_,
   {{0xaf5c303d,0x4187f381,0xa6287095,0x818050da}},	//   _angaphan, _farandul, _devonshi, _citadell,
   {{0x426412ff,0x12ee3252,0x455a703d,0x47b35358}},	//   _beplaw_, _ئشتەش_, _abakuhoy, _prosenti,
   {{0xc27ef0c0,0x62da5256,0x22fe53c9,0xa25fc177}},	//   _regni_, _inteko_, _equites_, _bisleemi_,
   {{0xca6522e8,0x32d981bb,0xc7b52209,0x4386f18b}},	//   _طبيعي_, _üyeye_, _blastosi, _mairom_,
   {{0x22f37081,0x8b1865d8,0xf22660e7,0x0338e3ab}},	// [1390] _imminut_, _pagawean_, _thukhu_, _nevadí_,
   {{0x4ae6b038,0x32924609,0x426c9218,0xd291a258}},	//   _parlemen_, _sawala_, _araon_, _appat_,
   {{0x027ef354,0xeb6df60a,0x22e85075,0x2f4f40be}},	//   _vegni_, _यातना_, _naslednj, _seksuale_,
   {{0xc472b3d0,0x116311ed,0x9da742b1,0x13d9d248}},	//   _импортоо, _сочида_, _felisita, _ተኣታትዩ_,
   {{0x822b3041,0x325b0048,0x235d13b0,0x22fd500a}},	//   _elimele_, _realit_, _dengang_, _regions_,
   {{0xb146f01a,0xaaf5600f,0xc2cae1d2,0xf0e5c03d}},	//   _ingresso, _tilsvare, _mondal_, _داخليږي_,
   {{0xb290f208,0x0ce4f0a8,0xd69a62fd,0xb3dd0395}},	//   _triall_, _podobně_, _حکومیه_, _tiawah_,
   {{0xf27f7171,0x90825393,0xeb58f50e,0xcff12061}},	//   _mwanza_, _asociado, _bafungwa_, _انِبَ_,
   {{0xfdd46502,0xc3fb643d,0xf9aac174,0x1dc3b293}},	//   _лениного, _människa, _позив_, _basirika,
   {{0xcceec11b,0xf4a3815e,0xf2c1f0b4,0x33cd3548}},	//   _америке_, _болгоё_, _hailona_, _норведжь,
   {{0x1d0b625d,0x3290d20d,0xf237048f,0x9c58b01c}},	//   _repondre_, _bilatu_, _viajar_, _لاقانونی,
   {{0x8a6362f3,0xa9688248,0xd34240ca,0x22f23076}},	//   _интереса, _ክትከዉን_, _anavagam, _kanikau_,
   {{0x5b3b2243,0x720e112f,0x6f483402,0xb17e11ba}},	//   _berbatas, _нарат_, _minghlin, _барби_,
   {{0xd27f72cb,0xa201037e,0x48471296,0x3373625f}},	//   _kwanza_, _ambiwa_, _хатари_, _progeny_,
   {{0x34d710ba,0x6eac123c,0x9ae2901b,0xc303b025}},	//   _баскан_, _gestione_, _векиллер, _afonifoj,
   {{0x7200b0d8,0x23bbe2fa,0x8f075075,0x4940560b}},	//   _ridire_, _agowana_, _pošasti_, _sommarst,
   {{0x9d0520f0,0x344be022,0x5c681223,0x7ea240fb}},	// [13a0] _commence_, _аталады_, _makundi_, _कार्यत्व,
   {{0x637fd2c8,0xf37d5224,0xc070f407,0x633770f2}},	//   _einasta_, _kopanye_, _solarsjo, _पदयात्रा_,
   {{0x8c05539a,0x39cd33d7,0x52cad1c6,0xa93610ac}},	//   _choroby_, _ढांचा_, _skeda_, _네티즌리뷰_,
   {{0x7cdd112c,0x9305d33c,0xc173315a,0x136f101d}},	//   _amakwenu_, _قوشان_, _उड़ीसा_, _rangaet_,
   {{0xc29091e8,0xfa6fb031,0x2249747e,0x2386606c}},	//   _omaan_, _ይወስናል_, _chamin_, _noori_,
   {{0xe2184372,0x09eed407,0x128f124a,0xfc4e03f4}},	//   _anakamam, _mienskip_, _nochris_, _plucking_,
   {{0xe27f7098,0x623003fd,0x62909281,0x47272212}},	//   _mwanya_, _chamada_, _imaan_, _دورځي_,
   {{0x738703ad,0xef5e9216,0x50bb415a,0x326c608c}},	//   _daarom_, _campiuna, _अँगूठी_, _troos_,
   {{0x3c5371de,0xfa0f02c1,0xb3790256,0xed8f1262}},	//   _nastupa_, _makalele, _wasanga_, _bakeneye_,
   {{0x5a833194,0x92c6d330,0xf8726084,0xec5bf24c}},	//   _genialen_, _第五十六条_, _faramọ_, _hortagi_,
   {{0x760b913a,0xa3115329,0x366f428c,0x0b847140}},	//   _defendem_, _atabulu_, _bendravi, _акцияләр,
   {{0x61d071a1,0x7e2aa19a,0x625ad2ff,0xb0602057}},	//   _argerlay_, _diffinia, _cholup_, _consecin,
   {{0x563c935b,0x53eae05d,0xc2dde395,0xef4f3221}},	//   _літерату, _ainten_, _farossi_, _abaswele_,
   {{0xc200d336,0xe7e3c087,0x3a1f0050,0x8571a3e7}},	//   _ainise_, _дописи_, _一個以為金錢就是, _biddiwal_,
   {{0xefc00064,0x5eeb2143,0x79a6d456,0x52afd0db}},	//   _提问者对于答案的, _calvaire_, _प्रश्नाव, _именлек_,
   {{0x43be02b9,0xe2909281,0x7277b0f9,0xd395406e}},	//   _shivaji_, _amaan_, _einsamal, _gresik_,
   {{0x0c4ed171,0x73dc70e7,0x9beff2c2,0x726404ff}},	// [13b0] _زماني_, _manwe_, _redovito_, _anplen_,
   {{0x9d86723c,0xd2fd4181,0x5b17c3d0,0x60ec800e}},	//   _dicembre_, _aregwa_, _мандал_, _başlanıl,
   {{0xac77344a,0x4b95a214,0xf7bab2ab,0xbe3742f4}},	//   _mensahe_, _сынады_, _sportini, _bilaketa,
   {{0xe20ec13c,0xc37a738f,0x32f33316,0xa73ac48f}},	//   _магас_, _betalen_, _mukhang_, _долга_,
   {{0xd7bee10f,0xf8fa51bc,0x6fc6b0ce,0x675e60fb}},	//   _اسلامیہ_, _ئراندا_, _مانسہرہ_, _टिप्पणि_,
   {{0xab0ae019,0x13a3a027,0xbf2ff137,0x23f98257}},	//   _צוואנציג_, _sappi_, _endorser_, _arzusu_,
   {{0x6387f064,0x7a0a013d,0xa193f105,0xe9cd40e5}},	//   _heure_, _vorarlbe, _אָװנט_, _सांचा_,
   {{0x926d90b1,0x425b40e5,0x44d6b1e6,0x2359e424}},	//   _kusoo_, _wielka_, _प्रियो_, _firebox_,
   {{0xa27f9075,0x92258349,0xd865c48f,0x3b628029}},	//   _desno_, _lirke_, _близина_, _mantenna_,
   {{0xc3957249,0x43e341c7,0x686e40da,0xf291603d}},	//   _fiasta_, _ﺍﻟﻭﻀﻊ_, _scrivend, _abachasi_,
   {{0xb9d7a3cb,0x92e1b4b1,0x385950dc,0x747e460c}},	//   _प्रयास_, _babiang_, _aguantar_, _पहुना_,
   {{0xd248005e,0x7ba721c5,0xed46c34e,0xd3fa7168}},	//   _feime_, _nevifiko_, _бруссел_, _gerust_,
   {{0x82ee91c3,0x8fa0a15d,0x83eae24e,0x0f2c12ab}},	//   _stafa_, _رجیستری_, _sinten_, _atitinka,
   {{0x4c801192,0x53eae291,0xa224c24a,0xb3eb7121}},	//   _ветер_, _pinten_, _folken_, _teated_,
   {{0x02caf39e,0xa14780d7,0x5aef122d,0x9eccf328}},	//   _awaliti_, _артисты_, _uploaden_, _tikitinn,
   {{0x26e7001b,0xa90a00bf,0x7ae58127,0x2eae30f5}},	//   _adresiňi, _далалари, _daireket, _vorteile_,
   {{0xa3870423,0x9387f185,0x427f744d,0xd8533264}},	// [13c0] _waarom_, _aduro_, _sranje_, _ودمتم_,
   {{0xf84c2026,0x830132bf,0x026e61af,0x87e1f1f0}},	//   _있었습니다_, _abibone_, _maroke_, _зинһар_,
   {{0x7f53160d,0xec57e171,0xd1b15314,0xbe4ed1e2}},	//   _अभागा_, _خوشبودار_, _इतिहासको_, _мадди_,
   {{0x99fa42ed,0x91c923f9,0x9f36f07e,0x0380606c}},	//   _pershend, _кошти_, _motsvara, _suurem_,
   {{0xd9bf442e,0x1c532106,0xd2dde584,0xbe0202e2}},	//   _fundarge, _chatain_, _oprosti_, _enteresa,
   {{0x929260b4,0x82258097,0x83a2d427,0x375790dc}},	//   _kauaka_, _kirke_, _troppo_, _жайлар_,
   {{0xf2d882f8,0xcb4aa2bf,0xe248026b,0x738d24f4}},	//   _jakete_, _adatabwa_, _ndimo_, _anaseini_,
   {{0x941c201b,0x6c623293,0x1dafb174,0x5fef32c1}},	//   _турма_, _kibungo_, _primećen_, _fonksiyo,
   {{0x1577c233,0x9275a12c,0x537a001d,0x6849c031}},	//   _fantatro_, _cristicl, _keramen_, _አይሻልም_,
   {{0xd3410075,0xcb5650aa,0x5969d469,0x127f73ba}},	//   _veselja_, _akamutor, _propagar_, _pranje_,
   {{0x8448c1c7,0xd26d60c6,0xe291524a,0xff026340}},	//   _орналаст, _begoro_, _pleats_, _ефектуяз,
   {{0xa1ff72ab,0x734221ba,0x6c3812e5,0xd2c83031}},	//   _papildom, _roberto_, _generáci, _ጳውሎስም_,
   {{0xe2da6329,0x0210f2eb,0x820f51a5,0x5aadb248}},	//   _eksodas_, _акаталог_, _abahwebi_, _ተዳጕኖምሉ_,
   {{0xbaf1207f,0x920271f5,0x3adbe0e5,0x4749816e}},	//   _ҟаиҵеит_, _forint_, _महारानी_, _михаилов,
   {{0x9273a3fa,0xe3216284,0xbfe3d078,0xe3eb023b}},	//   _maridadi_, _bracios_, _ساعتي_, _edatou_,
   {{0xe386614a,0x5d1922d5,0xb2fd7230,0x42d9e1cd}},	//   _dooro_, _aguscear, _seagen_, _byter_,
   {{0x2290b2b8,0x1ef63287,0x0e5142f2,0x30589227}},	// [13d0] _bedank_, _партала_, _tullantı, _저작권등록_,
   {{0xd27e925f,0x38951295,0x8cd2c282,0x1fed9065}},	//   _leans_, _amakumbu, _אַלבאָם_, _הסעיף_,
   {{0x254e046a,0x92cb7257,0x626c22f4,0xc249f35c}},	//   _ngokwakh, _anadan_, _askok_, _ajuma_,
   {{0x9c53f59b,0xf290b0cb,0xd297405b,0x3d802057}},	//   _होटेल_, _amcan_, _abakolu_, _incercat_,
   {{0x427ed0c7,0x1c5741e0,0x8283c370,0x5ec81065}},	//   _keeni_, _nostrae_, _сулхи_, _התמכרות_,
   {{0x7225e43f,0xec6ce0b5,0xa56f30e0,0x53f432a7}},	//   _fotku_, _блогстан_, _प्रतिभान, _турсин_,
   {{0x09b73401,0x425f925d,0xd25ac0b2,0xb26c013f}},	//   _polasaí_, _fauteuil, _famliy_, _prior_,
   {{0xab971526,0x8c93c0ef,0x33794285,0x5d6db2db}},	//   _hlangano_, _شاباس_, _mawanga_, _гарамаяк_,
   {{0x6c800443,0x1201f25a,0xd063f080,0xed23f080}},	//   _libertad_, _muziko_, _abusakun, _abusakur,
   {{0x164af24c,0xf588233c,0x4a1271cc,0xc6ef540f}},	//   _مرکزٕے_, _قوانرلی_, _jutarnje, _leitarvé,
   {{0xa778c1fa,0xbddbc349,0xf3869407,0x658ed4a7}},	//   _ahikhong, _tyrkiske_, _moarn_, _akatemik,
   {{0xd3a37365,0xbc652064,0x586cd187,0x53bfd0a2}},	//   _elapse_, _montant_, _achilend, _akhwele_,
   {{0x520e1196,0x0d16108a,0xc202126c,0x427e00f5}},	//   _зарах_, _حکیمی_, _kupimo_, _heinz_,
   {{0x517fd0a9,0x597b60ee,0x945fe5d6,0xf25be308}},	//   _allichay_, _neplatí_, _foretruk, _hatla_,
   {{0x9c55e0c8,0x16d4324b,0x79490231,0x225ac309}},	//   _своеасаб, _площадь_, _आहिस्ता_, _cholha_,
   {{0x521c60b2,0x73018067,0x00f800d2,0xfa15b076}},	//   _nathis_, _elebere_, _informàt, _hooakaka_,
   {{0x2046e166,0xe9c0139b,0x22a6a0ce,0xfd0b22d5}},	// [13e0] _nutrijen, _babeelet, _hobbi_, _caileige_,
   {{0x12dae460,0x23eae06e,0xb06ba065,0xf3dd00d7}},	//   _lwgleux_, _bintan_, _ההפסד_, _болгарст,
   {{0x0a95c60e,0x21261388,0x0af243cf,0x698b8399}},	//   _आत्मिक_, _قانوون_, _særinter, _anakanya_,
   {{0xb37d4020,0xec6c100a,0x7d7c003b,0xd6d8f0e8}},	//   _aterialm, _natural_, _abomasip, _doradztw,
   {{0x8449b39e,0x624905a5,0x93f8e30d,0x0f09a031}},	//   _chijinak, _gramat_, _ajnuna_, _ተተርጉሞ_,
   {{0x775cd1a3,0x6c11f2fb,0x13dcc3ea,0x5fa861a2}},	//   _tshitang, _eksplik_, _adamaliz, _кулинарн,
   {{0x4eba516d,0x4383a585,0x07416360,0xc0f6f0f7}},	//   _vergiess_, _petrolim, _نیکیوں_, _雅虎知识堂不保证,
   {{0x5faa5064,0xe72130ac,0x42450360,0x4e471333}},	//   _字母不区分大小写_, _기술적분석_, _سٹوڈیو_, _označite_,
   {{0x868c1499,0x6ff78406,0x4c53639e,0x72927220}},	//   _नवजात_, _בעריש_, _juttana_, _masaha_,
   {{0x3249010e,0x014a9031,0x835661df,0x66c2e09a}},	//   _dramat_, _በመነሣት_, _posedas_, _сәнәтчи_,
   {{0x801af113,0xb619c0a7,0x3d1b2025,0x1a11a2f4}},	//   _pieprasī, _izvesnim_, _afonrere_, _espainia_,
   {{0x630ed393,0x2c68f031,0x027e918c,0xc79d2428}},	//   _tambien_, _በበሽታው_, _afana_, _landsbyg,
   {{0x331970b2,0x4dd2d17d,0x326331a3,0x9b26e06a}},	//   _lijchoj_, _столь_, _tshikati_, _समर्थकां,
   {{0xfeb01437,0x019cd351,0xf3168296,0x802d63b5}},	//   _habermas_, _جلالی_, _ababili_, _conflito,
   {{0x72d4645e,0x7186134e,0xbc6ad262,0xb1e85280}},	//   _ferdig_, _ababamel, _bukungu_, _bakondim,
   {{0x02fd7218,0x5ebf2041,0x33b30005,0xc316c067}},	//   _leagan_, _دستراتیژ, _статкеві, _ghozie_,
   {{0xc2c891ba,0x80373036,0x8386d258,0xbaf3d3da}},	// [13f0] _ottobre_, _ristoran, _storch_, _unprofit,
   {{0xb26cf206,0x665d40fb,0x2af7060f,0x82910610}},	//   _ergon_, _समाधि_, _forsvare, _tabaco_,
   {{0xac3490d9,0x029272b7,0x234800a9,0xc0a5249c}},	//   _rifampic, _fasaha_, _ahlfeld_, _bhàrdach,
   {{0x2befe05d,0xc27e628d,0x5290c07d,0x442b937b}},	//   _ulteriur, _agone_, _kilaud_, _nalazimo_,
   {{0x62fd71c3,0xf29272a2,0x92fde097,0xa2573483}},	//   _beagan_, _goraeu_, _arkivar_, _mälik_,
   {{0x529b2286,0x427e9405,0xc4071198,0x79701288}},	//   _khejdaj_, _seans_, _comissão_, _تفسیز_,
   {{0x7212d0b2,0x7b19629a,0x3744c2ac,0x47c910f7}},	//   _neohom_, _perairan_, _لۆکاڵی_, _第四十九条_,
   {{0x984ad031,0x6f4d7284,0x45ab6218,0x226c9401}},	//   _በአምልኮ_, _complite_, _rangaith, _draoi_,
   {{0x07b37224,0xe3cc70ce,0x726ce233,0xa59a71ce}},	//   _bolelwag, _néven_, _manova_, _weilheim_,
   {{0xcf33c036,0xdaf3c00a,0x33caa0d7,0xf3f8d127}},	//   _presenta, _presente, _teması_, _banuve_,
   {{0x32025079,0x5b61b45f,0xa84a8248,0xa96d2429}},	//   _antite_, _अग्रस्था, _ክትመውት_, _afrikape,
   {{0x627ef122,0x8eae6453,0x7299b1bf,0x6b026050}},	//   _legni_, _schultze_, _формацие_, _一年每天病假得_,
   {{0x526e74a5,0x453db1df,0x62eec1ad,0x6c9072a0}},	//   _porodi_, _respondo_, _easterly_, _باپیره_,
   {{0xe27f72e0,0xd2c40197,0x53f47018,0x22311222}},	//   _rwanda_, _muawiyah_, _ajutor_, _marknaði,
   {{0x08dd927c,0x40733152,0xea8e620e,0x1d828020}},	//   _ベストアンサ_, _пусть_, _опозициј, _imilarsa,
   {{0x69bce434,0xf386603c,0x438061e7,0x6387031e}},	//   _коментир, _onore_, _suurim_, _baaram_,

   {{0xe6032008,0xd290b1f8,0xd1f330b9,0x52efc023}},	// [1400] _белалары, _nadamo_, _mahabaty_, _falitta_,
   {{0x2386638f,0x1f8990c9,0x8a58f17d,0xf38660e4}},	//   _soort_, _народног, _ongelmia_, _anord_,
   {{0xac5283f7,0x2677227c,0xdc3d60de,0xd197a065}},	//   _haitian_, _高等専門学校_, _تاپتىڭىز_, _בתואר_,
   {{0xf2484064,0x9c55b0bb,0xa64b0031,0x6c536027}},	//   _femme_, _kostnad_, _ኮንሰርት_, _tuttina_,
   {{0xd12d30f6,0x7248415c,0xdda12177,0x19fbb4c7}},	//   _палта_, _nemme_, _borograa, _linijama_,
   {{0xfd16526a,0x836201ab,0x4dfcf020,0xf98361e7}},	//   _insuranc, _isumbong_, _accesswa, _konkreet,
   {{0x12e86310,0x124842db,0x42f522a6,0xf63dd12e}},	//   _baginda_, _hemme_, _citiram_, _problemó,
   {{0xf2d82098,0xd2cb4168,0xcc341208,0x974132fc}},	//   _kamere_, _bieden_, _chlasaic, _источно_,
   {{0x79425128,0xc06f417e,0x80c61065,0x8bf630f4}},	//   _inductor_, _barattoo, _משכורות_, _ﺩﻩﺭﻫﺎﻝ_,
   {{0x83f8d32d,0x9b1780cc,0xac607387,0x2310b478}},	//   _manute_, _limpieza_, _dagunla_, _bruckle_,
   {{0xb3f47611,0xd9aa1196,0xec5212bf,0x3d23d004}},	//   _vestig_, _хорин_, _agatuma_, _حمایتی_,
   {{0xd25ae17d,0xb99d3008,0x430ae1f5,0x49c195c8}},	//   _meille_, _чакыр_, _végső_, _साँचो_,
   {{0x6c5a537d,0xec00d521,0x2c5ac06a,0x093b915e}},	//   _menteri_, _fansels_, _राजनीती_, _bermatze,
   {{0x02a785b5,0x83225143,0x42bd5612,0xe373b42a}},	//   _borbe_, _garcons_, _महसुस_, _spaanse_,
   {{0x253b9385,0x62014099,0x104dc022,0xe3419272}},	//   _menyatak, _vidiet_, _грнти_, _agnello_,
   {{0x504391c7,0x7b197445,0xe42410d0,0x1d4e51ba}},	//   _каталогі_, _barangan_, _qaliriik, _задавани_,
   {{0x72d82036,0x27672227,0x20af6144,0xd48c037f}},	// [1410] _camere_, _마찬가지다_, _atimisel, _anagonek,
   {{0xac0ae026,0x3a126187,0x1cd7f234,0x6975c373}},	//   _stoppen_, _akachira_, _postieľk, _arrikkit,
   {{0x135d1004,0x7201a4ce,0x634eb029,0x020270cf}},	//   _kenging_, _lovile_, _samemeh_, _gising_,
   {{0x83eaf2df,0x00bfa059,0x1b8a4200,0x49f7b168}},	//   _keitou_, _አፈወርቅ_, _iqinchir, _gedachte,
   {{0xb4efe059,0x5202513f,0x4ca5f4d7,0xcb77a1e5}},	//   _ወንድማችን_, _entire_, _abuzukur, _арзасы_,
   {{0x73a30613,0xa2311222,0x7373d23e,0x9379619e}},	//   _klappt_, _marknaða, _alkande_, _tauanga_,
   {{0x996432c1,0xbc6a003d,0x32920033,0x346fb196}},	//   _favorile, _kuluntu_, _deranz_, _bederatz,
   {{0x754db0f6,0x220260c7,0xfd5a134e,0x46d33167}},	//   _хорматла, _arrimo_, _хохем_, _achanchi,
   {{0xfe4391c5,0x013b21f7,0x776b056c,0x825ae043}},	//   _betaalde_, _kaldıkla, _колумбиј, _heille_,
   {{0x5e24b2d4,0x3ff5f121,0xfbfce125,0x321d213c}},	//   _mormones_, _सदबुद्धि_, _ubugeser, _малуп_,
   {{0x427f9142,0x826c62b8,0x0a89e248,0x36961276}},	//   _desni_, _asook_, _ዲክታተርያዊ_, _عالمگير_,
   {{0x459ef27c,0xf3177027,0x87aa722d,0x83871095}},	//   _クレジットカ_, _plazza_, _instelli, _starry_,
   {{0x0941539f,0x62ca640c,0x45ce1162,0x25e7c005}},	//   _billette, _utiliti_, _барму_, _малдова_,
   {{0x3855d107,0xaa76502f,0xa4616196,0x63f6b264}},	//   _गर्लफ्रे, _ادبياتو_, _hondartz, _والآثار_,
   {{0x24f85538,0xb24801e4,0xbc07d1a2,0x281c501a}},	//   _otomobil_, _elima_, _tekstit_, _россиялы,
   {{0x22fc9177,0xb3869173,0x7eb36231,0x419a9113}},	//   _waaga_, _olary_, _chronion, _sekretār,
   {{0xfa4922db,0xf1cc2008,0x258161af,0xc26e11ba}},	// [1420] _тетелли_, _хытай_, _koitarek, _popoli_,
   {{0x224a6187,0x0a824425,0x73f4627c,0x5b64300e}},	//   _nyumba_, _porofens, _nettet_, _fondunun_,
   {{0x87ce6085,0x1af783b4,0x831c13ef,0xec3372ff}},	//   _মাদরা_, _bobusale, _peccata_, _dadalahc,
   {{0x305a8135,0xe387f3c9,0xce319111,0x0c53621c}},	//   _ኣምሊጦም_, _plura_, _inkludas_, _buttuna_,
   {{0xcac9d135,0xc20211fe,0xb3fa50c6,0x820c008b}},	//   _ኣልዒሎም_, _yaqiin_, _betume_, _شيريني_,
   {{0x7ab19225,0xf27ba248,0x8905e0ac,0x0be2a071}},	//   _областа_, _መተግበሪ_, _축하드립니다_, _sloveens,
   {{0x32ee04ff,0x1c93d1d9,0xf4d790f6,0x5d2380be}},	//   _grife_, _نارات_, _назары_, _mitrovic,
   {{0x827e63ea,0x4168a065,0x0290811d,0xa95d1330}},	//   _agona_, _המיתולוג, _achazo_, _aéroport_,
   {{0x8f3010e9,0x838ae248,0x930052a1,0x9200b121}},	//   _impunida, _ምሕረቱን_, _dinasti_, _endine_,
   {{0x65240395,0x7291c0e4,0xd876837f,0x1a9d3264}},	//   _kristofo_, _konkour_, _amangomu, _احتياجات,
   {{0x6290c00c,0xfee03113,0xdba030c8,0xde514287}},	//   _salamo_, _konkurss_, _konkurso_, _ligoninė,
   {{0x6061c15f,0x2ecbb443,0xc27e6614,0xef4970d7}},	//   _haviknik_, _bernadin, _egona_, _маршрутл,
   {{0xb3866177,0x9c361199,0xbd763041,0x938a2007}},	//   _goori_, _grantiau_, _ترینه_, _körbe_,
   {{0x3d8820af,0xf27ed203,0xeb197217,0x8c8c0128}},	//   _質問者のみ_, _bwonna_, _karalgan_, _abutting_,
   {{0x286ea0f7,0xa57cc0af,0x52d9b0f0,0x9a7e923b}},	//   _conseils_, _ジに対するお問い, _bernard_, _bukawaqa_,
   {{0x927f40ef,0x7f5cb4e7,0x92926186,0xd200201d}},	//   _kwenda_, _saraksts_, _maraso_, _mekin_,
   {{0xc2002288,0x32002278,0x4327513d,0xef4740de}},	// [1430] _lekin_, _pekia_, _aracaju_, _ئدەولوگى,
   {{0xf201e007,0x59fe603d,0x7b0cd096,0xa27ed0a3}},	//   _akció_, _البرادعي_, _ناہید_, _weens_,
   {{0x3364202f,0x42500122,0x1b8a1396,0x12e89389}},	//   _دویمه_, _hélas_, _fronteir, _yayinda_,
   {{0xe9ee4496,0x527f4169,0xcf7ee52d,0x137b11a7}},	//   _tetikasa_, _svenia_, _fiziološ, _veraneo_,
   {{0x720e115e,0xee66c0d7,0x2248d1d1,0x417730bf}},	//   _царай_, _ictimagı, _ndeme_, _нечта_,
   {{0x026c2079,0x4599b1fc,0xd248d1b0,0x7857b0c0}},	//   _lemond_, _hallivim_, _ideme_, _classats_,
   {{0x6394b0c6,0xd29030e0,0xae1ce198,0x72b2d03e}},	//   _adesre_, _samaye_, _pergunta, _abidún_,
   {{0xe4b5f0aa,0x217f0594,0x930cd2d5,0x5368a2db}},	//   _akabarek, _achaqull, _amharus_, _орнашдыр,
   {{0xac60b02a,0xad30011d,0x18276227,0x73866322}},	//   _charred_, _omnilife_, _어렵습니다_, _coori_,
   {{0xc0537245,0x85d1e267,0xbae061f2,0x826cb44c}},	//   _imiseben, _abachagh, _samuelse, _andoni_,
   {{0xadfd13dd,0x62130250,0x2b87214a,0x6f46b4d7}},	//   _usmerava, _akahai_, _allaaqâ_, _amasinde_,
   {{0x7486006a,0xfcd471ed,0x22fcf082,0xb278715d}},	//   _ड्रामा_, _авторлар, _bukilas_, _warnet_,
   {{0x5523f110,0x4b25117f,0x5248c30c,0x372ed036}},	//   _teknoloh, _ababekus, _gemmas_, _esclusiv,
   {{0x385cc212,0x229040c6,0xc6d38241,0xe79160bb}},	//   _بازارونو_, _emmah_, _пенализа, _bindsutg,
   {{0xd292621d,0x00460264,0x5c9321d9,0xcb8de0e5}},	//   _parato_, _ماعندي_, _ءارقايسى_, _बालमा_,
   {{0x0506d0f6,0xf290e211,0xf8483275,0x2486d013}},	//   _адамы_, _manako_, _сәлим_, _аманы_,
   {{0xabfa5273,0x795d1349,0x0bf62065,0x331ef0af}},	// [1440] _vietcomb, _varmebøl, _דיזנגוף_, _frankrig_,
   {{0xc2a785f0,0x5b0c0455,0x13d130c7,0xe386d381}},	//   _borba_, _diagenes, _یێران_, _flers_,
   {{0x750881da,0x9da630dc,0x72332121,0x82f524a5}},	//   _bwampamy, _لىمون_, _दिनचर्या, _bitigam_,
   {{0xd26e100c,0xfb67d47d,0x71d9d0f5,0x02a0a0ac}},	//   _lipoti_, _centrica_, _willkomm, _궁금합니다_,
   {{0x43875004,0x02ee94e0,0x54ae6005,0x71f1a55e}},	//   _nyerat_, _stafi_, _nepakank, _adonikam,
   {{0x699d10a2,0xa67c607f,0x64f8109a,0x2200b238}},	//   _kwakhona_, _иадҳәало, _қалаймиқ, _seniñ_,
   {{0x2ae9c198,0x1a5412dd,0xc3dc7459,0x1d575002}},	//   _комисија_, _kwemhlab, _banwe_, _binaqchu_,
   {{0x4d81601a,0xb3fa62fc,0x2b88f420,0xd6258502}},	//   _diferent_, _veruje_, _birimler, _agroximi,
   {{0x1d4d500b,0xe86b5003,0x83018079,0x61f421a0}},	//   _pisariaq, _hinnangu, _anparti_, _elenadom,
   {{0x34132096,0x2aaf12ca,0x5e91f42c,0xb2740028}},	//   _شاہدہ_, _travesse, _kendskab_, _redakamü_,
   {{0x4d2e217a,0xb19cd218,0x5c6050e6,0xd2b2809c}},	//   _এককালীন_, _هلالي_, _sigurta_, _windown_,
   {{0x6c148121,0x4c2401ad,0xd643f47e,0x184e1419}},	//   _allpool_, _ceaseles, _descendé, _fallecid,
   {{0xa2026423,0x8386924a,0x12489071,0xd29260c2}},	//   _vorige_, _doarp_, _neame_, _bararo_,
   {{0xa386d335,0x4290e05f,0xdd10b0fb,0xf729a212}},	//   _blers_, _banako_, _क्षेत्रे_, _حيواناتو_,
   {{0x86f75299,0x53cff3ea,0xa58ed336,0x1ed01119}},	//   _огранича, _adamupez, _ekatemik, _qaangern,
   {{0x0ee4c0fb,0x4283e440,0x8c7c824a,0xfe52f0cf}},	//   _संस्कृता, _abikisa_, _huisman_, _pamamaha,
   {{0x23dc524d,0xb26c80db,0xec55b13f,0xb934c2f4}},	// [1450] _malwa_, _tekolo_, _instead_, _эзний_,
   {{0x13ead31c,0x13dc5091,0xf0f5e0e5,0x42659065}},	//   _protiv_, _lalwa_, _चतुर्थ_, _אוסקר_,
   {{0x447de231,0x33ebe010,0xe2fe5277,0xc147b15c}},	//   _यमुना_, _nitty_, _equipes_, _englesch_,
   {{0x384dd314,0xc34164b4,0x9b0713e1,0x2200215e}},	//   _nedoporu, _intefea_, _kargezon_, _rekin_,
   {{0x5364847e,0x32002152,0xa39634d9,0xd200421c}},	//   _sanguin_, _sekin_, _passà_, _lemin_,
   {{0x5689b2bd,0x4fb64064,0x2cbee015,0x1a8f8177}},	//   _процентҡ, _gratuits_, _aanikulq, _bakistan_,
   {{0x9cc3e434,0x030e110b,0x5c7633f7,0x02247089}},	//   _неактиве, _akabima_, _aristid_, _winks_,
   {{0xc2fa0510,0x9200c2db,0x6248f2ea,0x61eb74c9}},	//   _swahaba_, _diline_, _krimit_, _споразум_,
   {{0x794f70ee,0xf25172bd,0x72741144,0x50cf70c3}},	//   _samostat, _akitofel, _akasikel, _samostal,
   {{0x322ac1ed,0xcc22e13e,0x53335083,0xa16d2575}},	//   _ходай_, _romantyc, _جەلدەن_, _salivary_,
   {{0x06bb01d0,0x4b6820ba,0x9686548e,0x93860006}},	//   _setattri, _ясына_, _academai, _anira_,
   {{0x8a69f036,0xa26c839b,0xc2910387,0x2851e155}},	//   _финансов, _sekolo_, _aabajo_, _шәрбәт_,
   {{0x02d55601,0x926c835a,0xfc62a45b,0x723851b0}},	//   _levoča_, _aekomo_, _patrone_, _filmami_,
   {{0x8d3b50a1,0xdc56b20c,0x02d8819e,0xf3862079}},	//   _jathiyat_, _urutoke_, _makere_, _dikre_,
   {{0x22026249,0xc2245288,0x49965056,0x9e51e0e8}},	//   _equipa_, _balki_, _dikhwama_, _ostatnie_,
   {{0xa3c380ee,0x60141422,0x2a2d3018,0x92b543bb}},	//   _dávno_, _burdenso, _politică_, _addcat_,
   {{0xac765005,0xaeec4064,0xd27ed010,0x4b35c087}},	// [1460] _forumas_, _编译或摘编自其它, _teeny_, _agrarhis,
   {{0x52e960b1,0xdb2270af,0x43b09443,0x7cae90bb}},	//   _arrinta_, _afspille, _апринцип, _baggerud_,
   {{0xc28c0213,0x34d795a0,0xf394e372,0xcf47d06c}},	//   _anakana_, _палаты_, _kunsai_, _saksamaa,
   {{0xf27e91eb,0xbcbed20e,0x4c6fc12e,0xb290b18b}},	//   _ufank_, _надеж_, _gatunek_, _sydang_,
   {{0xc378e615,0x5992410a,0xd20250ec,0x6c612049}},	//   _melawan_, _عبدالرشي, _botime_, _daquela_,
   {{0x42910187,0x12e02403,0x2ca56053,0x72004428}},	//   _adaati_, _akanalo_, _konzentr, _femin_,
   {{0x07af725f,0x4f4e30bf,0x75ad1003,0x12fc94fa}},	//   _synuclei, _одатий_, _धारति_, _raage_,
   {{0x02f1e2c9,0x04363516,0x1319108a,0xe2ea046c}},	//   _ictimai_, _praktick, _پيمان_, _striden_,
   {{0x1d3b324f,0xe8c101a1,0x3c493606,0x86d6108a}},	//   _angajoqq, _emperatu, _circulac, _ظالمانو_,
   {{0xb349c166,0x72e3920f,0x73866423,0x826cb3c2}},	//   _livelli_, _istinad_, _hoort_, _sidoni_,
   {{0x2b13d365,0x4213705f,0x8f177022,0x02ca906c}},	//   _ankaufen_, _haahaa_, _اناڭنىڭ_, _ajada_,
   {{0x5394b08c,0xda1e1063,0xa200d29f,0x0e1ac102}},	//   _meeste_, _ширин_, _dinine_, _юридично,
   {{0x427ff148,0x5202610c,0xf3ae6214,0x2fb93061}},	//   _keuna_, _diriwe_, _жетiстiк, _محرڪن_,
   {{0x9c77f533,0xa61cf00c,0x054410bf,0x9474007f}},	//   _ururimi_, _amanatui, _amnistiy, _атомтә_,
   {{0xd962c089,0x674d4065,0xe394c231,0x1e34a248}},	//   _unintent, _בפלייסטי, _wiosna_, _ወላዲተይ_,
   {{0x427e91ab,0xd2f7c3d0,0x4e289083,0xb248f057}},	//   _ngang_, _кинонд_, _райондор, _primit_,
   {{0x98d293ca,0x923f2275,0xf27e927c,0xe3db314c}},	// [1470] _विघटन_, _умумән_, _igang_, _আশীর্বাদ_,
   {{0x122450e8,0x12910262,0x65fec38a,0x0f25518e}},	//   _walki_, _habaho_, _подмоско, _esperyan,
   {{0xf763c16f,0x02da624a,0xc2f64329,0xc9e4145b}},	//   _blokitaj_, _petear_, _frensip_, _quattord,
   {{0x03fa6592,0x7c1430f7,0xbb9b4169,0xd2bac471}},	//   _tutupu_, _没有相关文章_, _technesc, _втором_,
   {{0xd225e4b6,0x127f7296,0x9300933c,0x13f95616}},	//   _sitka_, _uwanda_, _sababli_, _taguig_,
   {{0x4e9631d9,0x2e1f5059,0x3713b0af,0x027f2378}},	//   _مىسىر_, _ተጠንቀቁ_, _アビシニアン_, _reynt_,
   {{0x4601f0b1,0xe1579121,0x1d81f02b,0x73162016}},	//   _maalinti, _मल्लाह_, _maalinta, _xubntiag_,
   {{0x5daa1401,0x42ee02a9,0xb2fa112e,0xcb41b2b8}},	//   _phrionsa, _griff_, _archiwa_, _potchefs,
   {{0xe64651ca,0x6ab3e1cd,0x02e58076,0xaa9ca18d}},	//   _خاموٝشی_, _marknads, _hainaka_, _julijans,
   {{0xc2004436,0x2d13f3d0,0xfdea4248,0x597e30c9}},	//   _zemio_, _хоцорч_, _ሓድነቱን_, _групі_,
   {{0x12d76189,0x538b50b9,0x81b26238,0x7d7be0fb}},	//   _stvorio_, _dürre_, _videoioù_, _anumīyat,
   {{0x72ca836f,0x2378e079,0x427ee220,0xfc890051}},	//   _baalafi_, _delavan_, _atinya_, _profited_,
   {{0x6c375083,0x1b05a1e2,0x98a7a251,0xf27c13bf}},	//   _مۇندان_, _алмаато_, _правец_, _играй_,
   {{0x52bb1302,0x1322413d,0x887821b9,0x5c21f2df}},	//   _seneste_, _bouches_, _төҫлө_, _bogilevu_,
   {{0xb386d15c,0xeed87064,0xd9575030,0x120842cb}},	//   _anere_, _fichiers_, _қурултой, _موالات_,
   {{0x2246203f,0xeb1bd1f3,0xa85f9389,0xe347403d}},	//   _कोहली_, _funkciók_, _takardar_, _مادريد_,
   {{0x89d0c01a,0xf2f5d447,0x0a67a2a7,0x0496d04a}},	// [1480] _темир_, _näihin_, _аризаси_, _angatadz,
   {{0x0c5c7008,0xa6df52c3,0xd341e1df,0x026c73fc}},	//   _üstün_, _ءساتىسز_, _komerco_, _pinoy_,
   {{0x2b5dc16e,0x2c73f00d,0xbe1850ee,0x2979c223}},	//   _дивизија_, _arisona_, _skóre_, _mwanashe,
   {{0xedfde020,0xa6a9205d,0x4dd90171,0x485c0264}},	//   _appearwa, _represch, _بڪواس_, _مممممممم,
   {{0xaa7b2337,0x62fc9281,0xc9cb921b,0x6540121d}},	//   _opište_, _kaaga_, _unglinga_, _विषदूषिण,
   {{0x6b17a0f6,0x0200e0c7,0xc287324a,0x829030b0}},	//   _агитацио, _amniga_, _funksje_, _semata_,
   {{0x02fcf0b1,0x82fc9100,0xd793e41d,0x62fa1209}},	//   _ragga_, _maaga_, _baktériu, _mechara_,
   {{0x4b23d281,0x0f60d47c,0x4eb7f1b0,0xddc32064}},	//   _isbahays, _displeje_, _podstate_, _volonté_,
   {{0x5e3c43c0,0x0c55027c,0xdd40f218,0x0d5dc3bf}},	//   _mebasepa, _deltage_, _tugaimid_, _миналата_,
   {{0xf301b033,0x2301e004,0xa2b4e32b,0x322580f6}},	//   _elabore_, _piranti_, _glicio_, _birki_,
   {{0xe257c056,0x42247054,0xc25184f4,0x0d37b44d}},	//   _boitapol, _yanki_, _asitelel, _inspirir,
   {{0x52fcf177,0x69f7b3ab,0x22d4448b,0x82c9121c}},	//   _wagga_, _dodavate, _ambebuei_, _profitti_,
   {{0x017d91df,0xd290908c,0xf2dbc1a0,0xe2640248}},	//   _עירוב_, _smaak_, _filosop_, _ንውድባት_,
   {{0xb435a438,0xc30c3206,0xe95140bd,0xd36470bc}},	//   _kumaziko_, _senatus_, _verseker_, _alagata_,
   {{0xa10263af,0x4e38e038,0xa82e21e2,0x56865106}},	//   _ginhveih_, _perawata, _артиш_, _acadamai,
   {{0xbb890078,0xff4943c9,0x5162d231,0x92d410d7}},	//   _ويوجد_, _tempesta, _zabronio, _kullanu_,
   {{0x116cf4b1,0xd283d39b,0xaf2532c1,0x629ad08a}},	// [1490] _divinity_, _bothati_, _smileler_, _akachazi_,
   {{0x13eca033,0xe2247247,0x537d7428,0x22fe61c8}},	//   _santrali_, _sanki_, _innflytj, _lesions_,
   {{0xff99126a,0x2200d3c9,0x52ea80d7,0x0c92043a}},	//   _provides_, _minime_, _anatoliy_, _marunong_,
   {{0xcf27f07e,0xdae7f07e,0x327ed250,0x32fae12e}},	//   _intressa, _intresse, _agena_, _informuj,
   {{0x7290337d,0x7c7550cc,0xee1c9228,0x220e10f8}},	//   _semasa_, _algunos_, _pungkasa, _сарае_,
   {{0xaeb84111,0x89e68196,0xa4f21291,0x0c6f1115}},	//   _komencis_, _сайтар_, _امامان_, _adarron_,
   {{0x4e1dc0c0,0x39ef4174,0x9c2f422f,0xe3860421}},	//   _essencia, _karijera_, _karijeru_, _aniru_,
   {{0xb7be6617,0x83f4045b,0x22cb122d,0xfeb3a264}},	//   _prestazi, _nostru_, _allerlei_, _أيقونة_,
   {{0x03f4736b,0x8c66a1f2,0xef4f10e1,0xf248e27c}},	//   _ersten_, _hittast_, _compeire_, _grimme_,
   {{0x777b709a,0x724802b7,0x4194133c,0xca7de35e}},	//   _қирғизла, _ilimi_, _حضوریگه_, _achakura_,
   {{0xbc605086,0xb27ee36b,0xd3f8c23c,0x727f7223}},	//   _busters_, _meinen_, _salute_, _uwanja_,
   {{0xa27ee230,0x722580f9,0xdab41054,0x6b76319d}},	//   _leinen_, _virki_, _dukkanin_, _bhallrac,
   {{0x2dbe52aa,0x72b4021d,0x329402ea,0xa7c590de}},	//   _atsinana, _apica_, _ndikimi_, _террорду_,
   {{0x36a523a4,0xac801043,0x594c51a5,0x2aa710fc}},	//   _alternaf, _несет_, _эстемиро, _барлап_,
   {{0x738b2279,0x9f4c327c,0xe92ae315,0xf3210123}},	//   _førte_, _ガイドライン_, _unicellu, _bhayat_,
   {{0x31c5d0db,0x7248d31c,0x837a11d4,0x8cf7225b}},	//   _планын_, _idemo_, _amerikam, _luttakar,
   {{0xd2903098,0x09f723be,0x3292621d,0xb2b40055}},	// [14a0] _bamaze_, _kungakhe, _varado_, _epica_,
   {{0x2394f11b,0x727ef185,0x729034d0,0xd95cd202}},	//   _spisak_, _eyinom_, _mamaye_, _automatt,
   {{0xba7cb1d6,0xf2480195,0x672962e5,0x42d9a1b3}},	//   _kusakata_, _alimi_, _nasledov, _exper_,
   {{0x32dc02c6,0xc4f2a182,0x625ae0f0,0x4420556f}},	//   _bakonyi_, _alamāryā, _veille_, _artikelk,
   {{0x2773c20c,0x77e79108,0x43008078,0xd57081f3}},	//   _arayanyw, _йиллар_, _tapaidh_, _kielégít,
   {{0x2d2b7081,0x7280e051,0xde420196,0x5292540d}},	//   _kinguneq, _thrifty_, _finantza, _intaad_,
   {{0xa4d790d2,0x12b49037,0xb017c39c,0xe699c04b}},	//   _базасы_, _сулышы_, _районни_, _шекилли_,
   {{0x22494164,0x78b7d009,0x93a300af,0x4b71a018}},	//   _premye_, _прежде_, _以外の回答_, _acestora_,
   {{0x927ee55b,0xdf1e7420,0xe3bc3264,0xe51045e4}},	//   _keinen_, _maddesin, _الذنب_, _vlastito_,
   {{0x1a89512f,0x6386019f,0x2be7412e,0x114171a1}},	//   _ташланға, _biiro_, _dyrektor, _olumncay_,
   {{0x324892f8,0x0394c218,0x5ad07369,0xe75350a2}},	//   _alama_, _diosca_, _hindukus, _abanyang,
   {{0x396d6476,0xa387f19e,0xf46bb06f,0x8a51509f}},	//   _habitant, _koura_, _parecido_, _bademona_,
   {{0xd29032c0,0xae88b342,0x6195835f,0x0fd63030}},	//   _almasi_, _أوباما_, _sedačky_, _homilado,
   {{0xe72294db,0x33948204,0x7ef8e07f,0x637cf50c}},	//   _operació, _laksda_, _аинистрр, _divalye_,
   {{0x72aed108,0x79765225,0x22247449,0x80ebc0e7}},	//   _абдуллоҳ_, _atendime, _kanku_, _tshinyal,
   {{0x8386d261,0x6e095063,0x97ecd4d7,0x12cc207d}},	//   _sforzi_, _kreditla, _bahasang, _paslain_,
   {{0x32480006,0x3ecf7299,0x4f6fd167,0x6b79b3e7}},	// [14b0] _ulimi_, _posizion, _canastas_, _arrondir,
   {{0x7dd54132,0xe8faf0ac,0x224a012a,0x63dc910a}},	//   _ексклузы, _verpleeg, _mesmes_, _نيوجرسي_,
   {{0xc1d7c263,0xc0f06074,0xa3fa61fd,0xf33c10f7}},	//   _милиса_, _artikull, _kutusu_, _访问我的博客_,
   {{0x22e60283,0x326ce37f,0xd25ae39b,0x16951506}},	//   _emandla_, _sinodi_, _agilwe_, _histoary,
   {{0x137c62a2,0x6823d1b6,0x1d0f71de,0x125b418b}},	//   _bingmax_, _སྒྲིན_, _pomozite_, _shella_,
   {{0xa3f450fc,0xf25ae079,0x9c66b032,0x613bd41f}},	//   _fluted_, _afilye_, _birtist_, _bohevmeh_,
   {{0x2c96359f,0x53d0a339,0x00c651a5,0xf20a621d}},	//   _उदासीनता_, _olimpisk, _abalimal, _परतापवान_,
   {{0x13fa7196,0x4547c076,0x293661c3,0xac7692ad}},	//   _burutu_, _kaikamah, _chamorra_, _aparimi_,
   {{0x73860510,0x7c6d8012,0x283513fb,0xe5c18241}},	//   _siiro_, _shirika_, _firkløve, _истенцэ_,
   {{0xe2e6f052,0x927ed228,0x38d39080,0x9d2f41ba}},	//   _biznesa_, _ageng_, _aboutpag, _scrivere_,
   {{0xe2915095,0x4958e0a9,0xd28eb038,0xd98d7358}},	//   _pleads_, _escondit, _earhart_, _начинать_,
   {{0x3200f08d,0xc200415b,0xc69b21c8,0xbadb430a}},	//   _bihile_, _hemia_, _ownershi, _ikamdaun_,
   {{0x703c5086,0x0681506a,0x126e417f,0x41dda13c}},	//   _rejectio, _गुलाब_, _талаботи_, _грызлови_,
   {{0x647854f6,0xe16cf1c4,0xfb6e00f9,0x62c301d5}},	//   _unutarnj, _civility_, _kollafir, _zaslona_,
   {{0x9044f24f,0x12004027,0xc9c392f4,0xd356430c}},	//   _takutinn, _memia_, _konektat, _alteros_,
   {{0xe20140da,0x9bcfe345,0x020101fa,0xbb9af500}},	//   _infine_, _स्वीडेन_, _bibile_, _antikorr,
   {{0xc26e7002,0x0066c1c7,0xe36a707f,0x1f346469}},	// [14c0] _moroni_, _ﻧﻪﮔﯩﺰ_, _дыкҿацал, _deformar_,
   {{0xfb9ca20d,0xf2ea307e,0x6f4cf3de,0x78e7e03d}},	//   _компаниу, _funnits_, _zaostaja, _دپلوماتا,
   {{0x98d723d0,0x4379353d,0xa04b1011,0xb7499358}},	//   _пирамид_, _masaža_, _abogádon, _железы_,
   {{0xd27e0117,0xf2a783c9,0x530514f5,0xdd479174}},	//   _agini_, _morbi_, _فولاد_, _животу_,
   {{0x52004033,0x47b3e098,0x326c2292,0xd68ff1b9}},	//   _admir_, _ararangi, _وتاوان_, _basebedi,
   {{0xee4eb281,0xf79ed241,0x3adf72bd,0x0ea6137e}},	//   _somalila, _дроби_, _tshehets, _omelelan,
   {{0x36272352,0xa26e73c6,0xf3207033,0x3c3820f7}},	//   _باسانه_, _koroni_, _benye_, _禄口机场到达厅出,
   {{0xe954f434,0x8bc460f0,0xdc66b032,0x16b5717e}},	//   _известен_, _prochain_, _virtist_, _arkayivi,
   {{0x1248414b,0x327ee35e,0xf2cbf320,0x03416424}},	//   _comme_, _upinde_, _chudu_, _direkta_,
   {{0x83b3d5e4,0x5322425d,0x432070ef,0x02925618}},	//   _travanj_, _boucles_, _wenye_, _matayo_,
   {{0x9e707619,0x968a904d,0xae180249,0x8c5652e2}},	//   _चार्ज_, _acadaimi, _rinforza, _pratike_,
   {{0x18a3c17d,0x0c7c1220,0x78a1001a,0x92cae1bf}},	//   _команды_, _amasuka_, _الاستوو_, _fondul_,
   {{0x5248461a,0x13530083,0xd3737036,0x470dc07f}},	//   _gomme_, _قۇلاق_, _domande_, _ааҵра_,
   {{0x8044f1d4,0x23fa63c6,0x126c5177,0x8379919e}},	//   _takusinn, _tuturu_, _biloy_, _maketū_,
   {{0x7c56b237,0x63207171,0xac5212bf,0x7320b095}},	//   _partije_, _yenye_, _agatama_, _obeyed_,
   {{0x32da50dc,0x02484425,0x4c34304d,0xbafa50a9}},	//   _ítems_, _bomme_, _cananaic, _amarakae,
   {{0x2c2ca3f4,0x8ae1f00a,0x191b7319,0x1b58f141}},	// [14d0] _ratified_, _institut, _phạm_, _барлагчы,
   {{0x430240aa,0xf26cf410,0x70dc7258,0xf7b7f1f3}},	//   _ababone_, _lahora_, _aligumik_, _التنزیل_,
   {{0x721c0040,0x32251205,0xee1950df,0x826cc336}},	//   _bashey_, _necked_, _attersma, _kalofi_,
   {{0x327e624e,0x6301201e,0x8031d3af,0x5dab542e}},	//   _ngono_, _anibere_, _saethoen, _minninga,
   {{0xc2da703d,0x225b4032,0x3f310029,0x5ce7c09a}},	//   _apreli_, _skella_, _disebutn, _йилмаз_,
   {{0x427ed228,0x962203ef,0xf29260b1,0x42515102}},	//   _ngene_, _opentopi, _marayo_, _deltakel,
   {{0x6cd99105,0x82136040,0x0787209a,0x3d0f81c9}},	//   _החסיד_, _baghha_, _فارابى_, _sudoeste_,
   {{0x8e92334b,0x226e1266,0x8afac20a,0xd87cd2c0}},	//   _почтала_, _aipoti_, _abafugib, _asiyeing,
   {{0x737191ab,0x3c54934d,0xc38bc39f,0x82f11002}},	//   _tagalog_, _curteng_, _færre_, _biyitdi_,
   {{0x638bd41a,0x9bc45443,0x37201040,0x484642f2}},	//   _været_, _conjetur, _bibeljaj_, _italiyad,
   {{0x82d52320,0x611ac1a8,0x7a5e1065,0xf3a2c230}},	//   _robocon_, _бомбы_, _אולביז_, _hoopje_,
   {{0x025ad010,0xe9f390bf,0xe2a6a552,0x3b8ac11b}},	//   _cellar_, _natijada_, _dobby_, _собом_,
   {{0x2382d0bf,0x85c891bf,0xb2fdf47b,0x3a49801a}},	//   _یاشلی_, _матернит, _ogugu_, _بەيتانىش_,
   {{0x9908339a,0x93337320,0x29e5208c,0xd25b7078}},	//   _pieniądz, _braxin_, _bestuurd, _bhalla_,
   {{0xf2eed00f,0x78f0046c,0x526cf256,0x087f91d8}},	//   _treff_, _stegosau, _bahora_, _sabilulu,
   {{0x42906266,0xe9c41163,0x634120f1,0x755de335}},	//   _afioná_, _nordwest, _bibelen_, _conjugal_,
   {{0x7646101a,0x3221b0be,0x97e3d1ba,0x42d461ad}},	// [14e0] _قالدىڭ_, _diskutim, _комисия_, _corded_,
   {{0xb28b0009,0x4387502e,0x4b3c2065,0x73e3321a}},	//   _использу, _vieras_, _להזדהות_, _jablonsk,
   {{0xb2013207,0xc10843ea,0x399d22db,0x12903018}},	//   _linkleri_, _anakubal, _гарып_, _ramane_,
   {{0x62d462f2,0x027f412b,0x62c2010c,0x3bd4a464}},	//   _burdan_, _adenin_, _abalana_, _campañas_,
   {{0x32fdd3a5,0xd45f3005,0x53bd3358,0x88c182f4}},	//   _emzantsi_, _работнiк, _подводны, _doktoreg,
   {{0xc225e234,0x1eb8a15a,0xf30d10b1,0xc2903345}},	//   _bitka_, _lubuskie_, _samatar_, _temaga_,
   {{0xf320c137,0x88ea3031,0x3143f299,0x326e1061}},	//   _medyo_, _የኢፌዲሪ_, _spettaco, _ripoti_,
   {{0xc249435b,0x62006336,0x73bbc61b,0x22002207}},	//   _fremme_, _aeoia_, _edowara_, _tekil_,
   {{0xff238197,0xb3737354,0xc35fc10e,0xa43cf2ca}},	//   _cemerlan, _romande_, _mateusz_, _الاسىزدا,
   {{0x27e7d011,0xcfccb383,0x05d6412b,0xd200211b}},	//   _визитла_, _perioder_, _basketbọ, _nekim_,
   {{0x437c53a5,0x5386948c,0xf9f8400d,0x62d9e11e}},	//   _nabanye_, _anara_, _abdillaa_, _exter_,
   {{0x49f6c086,0x747921c2,0xc344a28b,0x3d8a106a}},	//   _tristiqu, _salguero_, _betelle_, _रोजगाराच,
   {{0x36dca0e5,0x225ae0a9,0x3aab1231,0x20ec225d}},	//   _माहिर_, _akilla_, _प्रलेखन_, _bafilial,
   {{0x4867540b,0xaa08f1ca,0xe2f5214f,0xb8f1b330}},	//   _mulighed, _daraadee, _antikam_, _镜像站服务_,
   {{0x4f76213f,0xf9879182,0x2977d180,0xe874b124}},	//   _מיליוני_, _संयम्य_, _fornøjel, _атележур,
   {{0x3248d1e7,0x52d911e0,0xcd9d4443,0x43e85392}},	//   _olema_, _facere_, _amongeta, _वस्तूमधू,
   {{0x1ba5161c,0xbc60f089,0x8d30500b,0x02eef054}},	// [14f0] _abazakub, _pierced_, _politiit_, _haifar_,
   {{0x19699052,0x92d54085,0x53796376,0x63f8f044}},	//   _autortie, _আশাকরি_, _karanta_, _pahure_,
   {{0x5248d246,0x925ad049,0xcc1720f2,0x490521d4}},	//   _alema_, _mellor_, _पूर्वाञ्, _tamatigu,
   {{0x1b0b027c,0x7ce1a060,0x73870346,0xac600278}},	//   _アドバイス_, _snowstor, _ngarti_, _akauola_,
   {{0x22646495,0xf200b35e,0xc43380c3,0x725ac18b}},	//   _voulet_, _recio_, _gospodin_, _myllen_,
   {{0x6c777038,0x922661c9,0x290780e5,0x92e9760b}},	//   _पेक्षा_, _borken_, _jednakże_, _skrivna_,
   {{0x962ef1a1,0x1dcf6076,0x03f4761d,0x3ec25284}},	//   _octoberw, _anahuina, _gustan_, _avantian,
   {{0xc27e9100,0x42fcf42f,0x83a22055,0xcb79503e}},	//   _ngano_, _aingay_, _compie_, _alafikun_,
   {{0x02d7f150,0x93f47428,0x52fcf44e,0x9ed85303}},	//   _skyldes_, _austan_, _bingay_, _пропорці,
   {{0xb3173168,0x7712e121,0x8f22f1c3,0xc386d1eb}},	//   _functie_, _शब्दन_, _airtigea, _bierg_,
   {{0x3bda72bd,0xaec3b250,0xb3207185,0x224841a2}},	//   _китапхан, _oponopon, _benya_, _homma_,
   {{0x524841cd,0x921d21ea,0x3b8a115e,0xc02a520d}},	//   _komma_, _фарук_, _дорой_, _mundutik_,
   {{0x0c8011d9,0xfb8d524f,0x162872f3,0xd8f800f7}},	//   _десек_, _pisiniar, _климатск, _陈乔恩首映会上笑,
   {{0xf1c302fc,0x73f470f1,0xb2910616,0x225b6369}},	//   _nastanak_, _bosted_, _vlaams_, _anglum_,
   {{0x49eab026,0x0a90608f,0x446670f7,0x9319c012}},	//   _알려드립니다_, _comisiwn_, _国防科工委_, _ميران_,
   {{0x62da604c,0x163f33e2,0xb200201c,0xdc030247}},	//   _bareng_, _kalendár_, _nekik_, _hastanes,
   {{0x12484166,0x6c1720fb,0x22908059,0x5846d466}},	// [1500] _gomma_, _पूर्वान्, _pekara_, _عبدالنبي_,
   {{0x5c21b3f1,0xdfc6d04c,0x22f0c376,0xcb01a16f}},	//   _clergé_, _نظرخواهی_, _addinai_, _ilustrit,
   {{0x9d5cc15d,0x22486345,0xb852a01a,0xa8562418}},	//   _مجسمه_, _soome_, _entrades_, _даруни_,
   {{0x0386031e,0xddb871c2,0x2602c096,0x337c901c}},	//   _biiri_, _alliyasp, _تھرپارکر_, _pizzéria_,
   {{0x32f3b197,0xcc610012,0x3292511a,0x99eeb015}},	//   _harimau_, _masuala_, _matalo_, _antiqira_,
   {{0xc3950244,0xfc0cb010,0x23860267,0x69c0c61e}},	//   _akasti_, _swapped_, _diiri_, _tredjede,
   {{0x4b67c2f4,0x59fa1463,0xf30f6142,0xbf7190fb}},	//   _галерей_, _agradese, _nadzorni_, _उपन्यासः_,
   {{0xb200f032,0xdf576339,0xd387005d,0xf2b54038}},	//   _megin_, _financen, _biaras_, _sidcup_,
   {{0xf64b3059,0xe341557c,0xec1720e0,0xa67a1378}},	//   _መረባረብ_, _videoen_, _पूर्वार्, _erlendum_,
   {{0xa2f051ce,0x029261a0,0x0852404a,0xc2d8836f}},	//   _galilei_, _muskuls_, _aitotund, _boketa_,
   {{0x92cbf189,0xfa59f13c,0xfc03634d,0xdf1621c7}},	//   _ljude_, _herencia_, _bampong_, _ﻛﻮﺑﯩﻨﺸﻪ_,
   {{0xc29e1481,0xf2009266,0xb9d6c3b4,0x1ce8a0b3}},	//   _хисап_, _aeaia_, _atlegile, _еренцияс,
   {{0x886c7385,0x27ed3262,0xad854230,0xfc67919f}},	//   _noinclud, _mafarang, _haadside_, _achuuma_,
   {{0xa5f530fb,0x5175e0df,0x02cbf0af,0x4f659076}},	//   _प्रतिनिर, _ayingsay_, _skudt_, _kawaikin,
   {{0x65c9109b,0x62f643f7,0x539544fc,0x561fc09a}},	//   _lesbisch, _prensip_, _dneska_, _амиллар_,
   {{0x3c7694c4,0xda01b262,0x42da63b9,0xb563d20e}},	//   _forslag_, _imbaraga_, _pareng_, _агенција_,
   {{0xcc47e0f7,0x29de3048,0x974912c5,0x82914228}},	// [1510] _并自负版权等法律, _नदुखाउने_, _papirutg, _andaku_,
   {{0x7c1720e0,0x3854310a,0xc386d4df,0x80265573}},	//   _पूर्वाह्, _ڪوريا_, _diere_, _koreansk_,
   {{0x325b0465,0x06a292eb,0x5fbf33c0,0x9c9603ba}},	//   _biblio_, _sinfónic, _dumeletš, _lubenicu_,
   {{0x5c76748c,0x726c33a3,0x2aa5c13e,0x7590d2ca}},	//   _adirigi_, _nemozu_, _शुक्रिया_, _الماگۉل_,
   {{0x820020c3,0x6386d21f,0x5e6850af,0xa25b71ab}},	//   _nekih_, _niere_, _総合ランキング_, _ilalim_,
   {{0x53f47336,0x67a9e0d0,0xfe3a00c0,0x1c1c0180}},	//   _tustin_, _naittumi, _andromaq, _ご利用規約_,
   {{0x62efd05d,0x29f9e246,0x92e79036,0x031ce469}},	//   _polizia_, _malietoa_, _gennaio_, _colchon_,
   {{0x6c62a280,0x795ad248,0x530c4285,0x1c90a114}},	//   _tournee_, _ሃብታውን_, _essanyu_, _sekurang_,
   {{0xc375d0a6,0x2706e234,0x0290800d,0x0fa2215d}},	//   _विलियम्स_, _štruktúr, _bakane_, _سهميه_,
   {{0xd44f3248,0xef1d2030,0xf37f317d,0xdecf70df}},	//   _ታሪኽናን_, _билдириш_, _samassa_, _ansition,
   {{0x82925111,0x3292031e,0xf29090d1,0x6bf62118}},	//   _batalo_, _alsaas_, _bokati_, _sheetroc,
   {{0x335f2144,0x320e115e,0x7e4a802f,0x03867189}},	//   _nangabe_, _наран_, _برابرې_, _blizini_,
   {{0x9395a36d,0x837a037c,0x2202518a,0x50a630db}},	//   _我的想法是_, _varawen_, _citite_, _станцияһ,
   {{0x3037d03d,0x7373d0e4,0xad0982ea,0x8f65a463}},	//   _lentshon, _erkarne_, _realisht_, _altarnin,
   {{0x0b6d00f5,0x26376358,0x3dab0153,0x73c7021d}},	//   _besonder, _пластико, _irritera, _सोऽतिसन्,
   {{0x523b10e5,0xd27ee438,0xf0ec8140,0xb2cae14d}},	//   _न्यायालय_, _printa_, _başlanğa, _kindel_,
   {{0x4fdda141,0xe259c16c,0x32d99005,0x92ee925a}},	// [1520] _хабарына_, _reflechi_, _viename_, _grafo_,
   {{0xa97ac291,0xab9c20a8,0x3926b15a,0x8290f0c6}},	//   _اقلیت_, _postupně_, _गांजे_, _emiali_,
   {{0x724864b5,0xd393c288,0x1c0af10b,0xdbb6310e}},	//   _looma_, _ضابطی_, _aragetur, _बिल्लियो,
   {{0x3395724a,0xc2ca639d,0x5341961f,0x631f13bf}},	//   _measte_, _okolini_, _cedeño_, _cercano_,
   {{0xab2d3258,0x252cf06a,0xf30de2b7,0x697b5288}},	//   _qarasaas, _प्रायोजक, _dakatar_, _абдуманн,
   {{0x653c90af,0x92a971f0,0x2c845095,0x28610341}},	//   _希望小売価格_, _законыны, _rebelled_, _eroberer_,
   {{0xb0d360ac,0x20e7e0f5,0xd27e04f4,0x010e4013}},	//   _언더웨어l남녀속, _offiziel, _faing_, _ацәикуеи,
   {{0xf29260fd,0x8248d06c,0xe34854ec,0x22d460b9}},	//   _aprann_, _toomas_, _eklendi_, _yurdun_,
   {{0x3db8e100,0xdc00b0bd,0x6310b1b3,0x929082c1}},	//   _filament_, _presies_, _nascite_, _makale_,
   {{0x936e33af,0x3248924f,0x2200f2ae,0x38c9b031}},	//   _singriu_, _ilami_, _tegin_, _መሆንዋን_,
   {{0x8a87a34e,0x729260c4,0x39ba9506,0xdb91523e}},	//   _amazinga_, _bitatu_, _boadskip_, _bisaawóo_,
   {{0xf26e503e,0x82c254ad,0x7248d2ae,0xd9c521e5}},	//   _nitori_, _abelana_, _oleme_, _нурдан_,
   {{0xb29263ea,0x32012539,0xdff3e1cc,0x3ead52ca}},	//   _vitatu_, _leyin_, _najdraža_, _ايشادان_,
   {{0x510b5620,0x4ae93271,0x8486a621,0x029261c9}},	//   _owthgray_, _nakupujt, _बलशाली_, _sarado_,
   {{0x8f162196,0x9e562225,0x254182bd,0x8409e135}},	//   _настай_, _настан_, _bapholoh, _titullin_,
   {{0xbbfb90cc,0x5b0390f0,0x92fa1250,0x924890bf}},	//   _septiemb, _entretie, _alahaka_, _olami_,
   {{0x62909054,0x9c031114,0x2e0d21ba,0xd2a6313a}},	// [1530] _kokari_, _taiping_, _киселина_, _hambak_,
   {{0xf2926195,0x5c0c05b2,0x62483113,0x6134c2a3}},	//   _zitatu_, _stopped_, _mammam_, _алдыра_,
   {{0xd617921a,0x9037d438,0x628c505e,0x845e31fd}},	//   _eurovizi, _bentshon, _anekina_, _kendiniz,
   {{0x2387f0fd,0x499d2005,0x6c7c700c,0x7210716f}},	//   _kouri_, _барыс_, _agasiva_, _אמריקא_,
   {{0xcb5532ad,0xcc6ad59b,0x2e560097,0x65c6007f}},	//   _maumahar, _कित्ता_, _kjæreste, _аҳкәажә_,
   {{0xc730e007,0xf7ac9367,0x938690d8,0x0f33c071}},	//   _پیشانی_, _postelji, _anart_, _presinta,
   {{0x030990cb,0x0a6fa405,0x469de135,0x51b2b14c}},	//   _broblem_, _prionsab, _perfundi, _স্টেট_,
   {{0x82d8816f,0x53950148,0x4a72945b,0x9305c288}},	//   _pokera_, _kaasup_, _casanova_, _اوراب_,
   {{0x29e3801b,0x627f7256,0x30452038,0x35ec8009}},	//   _gündogar_, _itanga_, _petualan, _приводит_,
   {{0x2bd43217,0xa2908421,0xad78c1ba,0x3194b288}},	//   _ветеранн, _makame_, _енергия_, _حضوریده_,
   {{0x32f1e003,0x7344b1ad,0x2c31e1e7,0x464b0296}},	//   _artikli_, _foresee_, _artiklid_, _cruiserw,
   {{0x9387424e,0xe58220af,0xfa9d330e,0x95b8a23e}},	//   _ngerti_, _アフィリエイト_, _विरुद्धम, _alxiyaam_,
   {{0xb27ee193,0xd3f8c1b6,0xf4a61418,0x940903ef}},	//   _spinne_, _allura_, _ababekez, _nourison_,
   {{0xd38b3150,0x327e01e7,0xd24803f1,0x727f7262}},	//   _først_, _naine_, _moimi_, _mpande_,
   {{0x9248d285,0x6387032d,0x72c1936f,0xa501936f}},	//   _aleme_, _acaram_, _bahlola_, _bahloleh,
   {{0x127ee36b,0x6bfd3056,0x4470e45f,0x279524e7}},	//   _seinen_, _tokologo_, _nalezeno_, _pastipri,
   {{0x49881369,0x6a7991c7,0x7b0e702e,0x7cf43184}},	// [1540] _technica_, _долларға_, _viestike, _septambr,
   {{0x4e54e2bc,0xe966910d,0xef40c5b2,0x1d928250}},	//   _економіч, _простых_, _subscrip, _halelole_,
   {{0x1c4f5036,0xbb210168,0xcc537083,0x42fcf369}},	//   _специалн, _proberen_, _sortida_, _arighi_,
   {{0xcab520fc,0xa00ef261,0xfb5f1181,0x43790364}},	//   _drakensb, _pouvaien, _nyamukur, _assaama_,
   {{0xc6ae2257,0x8bcc4275,0x9170303e,0xcc386007}},	//   _abituriy, _киродийә_, _asisebio, _moderáci,
   {{0x9249912a,0xc9799622,0x415e1065,0x55b9311c}},	//   _mesme_, _ngenarhe, _בוסקילה_, _fillteán_,
   {{0x2be3a19e,0xf292724d,0x615cc11c,0x7b5ed2f4}},	//   _hinengar, _miraru_, _اشتقت_, _ираны_,
   {{0x06ab31d9,0x075330f5,0x22fce2c8,0x4413a3ba}},	//   _өзара_, _grundlag, _ringja_, _istaknuo_,
   {{0x5cf232f4,0x7d9d62bc,0x856731e8,0x6c2355ec}},	//   _бодрол_, _funnkata, _терминов_, _imuryé_,
   {{0x42a78189,0xeb5970fb,0x1663f050,0xf8305264}},	//   _borbi_, _maitreya_, _一九六七年九月三, _كلاهما_,
   {{0xd3a2d565,0xf24800ef,0xb24b1012,0x6e240003}},	//   _propio_, _elimu_, _shilingi_, _koolitus_,
   {{0xde55c030,0xbe0cc101,0xc9ccc03a,0x18fc6281}},	//   _دوستم_, _ansennya, _ansennye, _qabashad,
   {{0x59341340,0x1611e13c,0x650162ff,0x538b9276}},	//   _asemanat, _абрахь_, _bireqtal_, _شيڪسپيئر_,
   {{0x82a78623,0xa596321e,0x48f4224b,0xe2129509}},	//   _forbi_, _isteriny, _wamavowu, _imahe_,
   {{0x7f38818c,0xf29261a0,0xe5cec2f3,0x2c121149}},	//   _impumala, _caraco_, _наиме_, _asalalau_,
   {{0x26667624,0x425b4431,0xde25c0fb,0xd2c6b1e7}},	//   _सरासरी_, _quelqu_, _संस्कृतल, _oluline_,
   {{0xa4c7239c,0xbc6e112b,0x0d1e3314,0xf2d7c520}},	// [1550] _бағдад_, _akaraka_, _प्रकृतिक, _skiller_,
   {{0x7317d1c4,0x9b42c403,0x170bc48f,0xa2025100}},	//   _infancy_, _ababonis, _образлож, _istilo_,
   {{0x72640314,0x4545411a,0x2cb9a225,0x69d043ea}},	//   _poslat_, _ahhhhhhh, _додавање_, _akulemba_,
   {{0x6c6e7510,0x33875216,0x32ca0067,0x05c2e2d6}},	//   _mbarara_, _fieras_, _odide_, _autopoťa,
   {{0xdcf3f036,0x42fd9011,0x62777022,0x4dae2109}},	//   _settembr, _rasgo_, _бастамас, _stigande_,
   {{0x225b4498,0xef47d121,0xa452d147,0x3ea4f536}},	//   _kjelda_, _maksimaa, _krajolik, _flettede_,
   {{0x1bdcb231,0xaf23a180,0x7c75b2b2,0x2c0a72a8}},	//   _तकिया_, _人気ブログランキ, _निम्तो_, _arapata_,
   {{0xc7aa7102,0xdb676003,0x9d8c0075,0x3f25d0bd}},	//   _instilli, _छानने_, _ovčar_, _makliker_,
   {{0x13051579,0xf27f72cb,0xea14c40b,0xe2f7f037}},	//   _پولات_, _upande_, _forbruge, _архивы_,
   {{0x6c036392,0x13a5f0f2,0x54719271,0x96b961df}},	//   _gampang_, _प्रयोगकर, _genetick, _malaperi,
   {{0x7ae8529e,0xabeec1a5,0x634270ff,0x226e7186}},	//   _certaine, _халос_, _citeren_, _birori_,
   {{0x8f358405,0xc868f246,0xb2903371,0xa38693e6}},	//   _sinseara, _perisitu, _nemala_, _tiare_,
   {{0x3290310c,0xc2258339,0x82c39224,0xad82c264}},	//   _temana_, _pirkt_, _tiilego_, _بهدوء_,
   {{0xc061c51d,0x5256906c,0xb49cc162,0x027e244d}},	//   _بناری_, _पुछेला_, _елани_, _jakne_,
   {{0x5bcfe271,0x99c9e195,0x45d54228,0x5d8744ec}},	//   _seminárk, _akawungu, _allbadth, _elemanla,
   {{0x96f8c124,0x4c2fa374,0xd84021e0,0x22131334}},	//   _приднест, _mwanangu_, _spiritus_, _tobhau_,
   {{0xefe7b156,0x8972509b,0x46e14222,0x42d463c9}},	// [1560] _правата_, _seanakae, _avtalað_, _gaudia_,
   {{0xf27ff283,0x44302198,0xbdfca42f,0x33f4640d}},	//   _ufuna_, _processo_, _effectwa, _kartaa_,
   {{0xfd9a6141,0x854a2228,0x5ebf1063,0xac0343b8}},	//   _barlagla, _معالجه_, _قویولگن_, _forsker_,
   {{0xaaf85431,0xb2fce0d3,0x4386d496,0xa24800bf}},	//   _actuelle, _lingia_, _piera_, _doimo_,
   {{0x6a22c085,0xa27ff0d1,0xa27ed300,0x42c1907c}},	//   _সাময়িকী_, _pfuna_, _ugent_, _yahlela_,
   {{0xdc5c5567,0x17ecc0d0,0x02cf8319,0x43ead49c}},	//   _cartón_, _hananing, _cyworld_, _tiotal_,
   {{0x9ce3b00e,0x82903008,0x4f1f54fb,0xe31a125b}},	//   _yarısı_, _kemala_, _tentanga, _umsiting_,
   {{0x0f231469,0xc2d9812b,0xe695223f,0x8a91d2db}},	//   _insupera, _bayere_, _abstrach, _tehnikas,
   {{0x89f770f7,0x58f7e144,0x36dbc0f7,0x42d9612a}},	//   _爱情两好三坏片尾, _anganced, _全国企业信息化工, _damnate_,
   {{0xa3f46139,0xe3eba567,0xf29091f2,0x167bd009}},	//   _bartaa_, _textus_, _takast_, _отличие_,
   {{0x1477021d,0x7387630a,0x4f59d4c8,0x79f4d1e4}},	//   _प्रियदर्, _aigris_, _taupatup, _kahunanu,
   {{0x1976b3a4,0xb2668141,0x42eab0f1,0x705723bf}},	//   _undisput, _суратлар, _dernest_, _дискове_,
   {{0x8394f2ae,0xd36c7386,0xded4015f,0x8291d039}},	//   _siiski_, _lingani_, _mamihain, _umwai_,
   {{0x2649d135,0x2aa7e251,0x222543a2,0xe7c8d36f}},	//   _ዝበልክዎ_, _бараат_, _stekao_, _adothilw,
   {{0x2b5450b3,0x0e9453b4,0xc2ef03aa,0xe332e0d1}},	//   _atamalar, _atamalan, _grafis_, _caixao_,
   {{0xf1d7d020,0x8200d1c9,0xc7bc5080,0x7dcec1aa}},	//   _ownerway_, _polity_, _adurarni, _тинем_,
   {{0x8235829e,0xb299b0c9,0x6722c5e6,0x6cd560ac}},	// [1570] _travaill, _заборгов, _aparició, _페이지까지_,
   {{0xd1314057,0xd2d76089,0x96f2f48f,0x373d5227}},	//   _produsel, _toallas_, _sustentá, _법적책임은_,
   {{0xdbe1423f,0xce54b1d8,0xe20260c1,0x5c8cd009}},	//   _productr, _kasalaha, _enrile_, _очереди_,
   {{0x38b852f7,0x927ed0af,0xd200f335,0x6aa6b0ea}},	//   _вәкиллик_, _ugens_, _legia_, _दिल्लीमा_,
   {{0xe5fd31d0,0xef0d7115,0x3335b096,0xbebcd271}},	//   _filmmagi, _cercadas_, _prémium_, _nebudeme_,
   {{0xe9bf3168,0x6386d49e,0xc3dde392,0x89d312aa}},	//   _gemeente, _dhoras_, _satwa_, _mbaliana_,
   {{0xe89c5004,0x4c67d2d1,0x78fd404d,0xf26f5090}},	//   _جزئيات_, _برسان_, _obrachad, _biriviri_,
   {{0xb27f442e,0x2c77626a,0x86d4115f,0xeebdd0ff}},	//   _prenta_, _popular_, _aularnii, _evenemen,
   {{0x8c5f3436,0xccb301d7,0x3b2ce214,0x827ff55e}},	//   _dalembë_, _remarked_, _ءﺩﺍﯞﯨﺮﯨﻨ, _afunn_,
   {{0xb34d13ef,0x5ea5214b,0xd386d1f1,0x7e19a330}},	//   _ceterum_, _sondages_, _kiero_, _为贯彻落实_,
   {{0xc8d92248,0xd248d2c1,0x462702a0,0x07d7c22a}},	//   _ኣይፈቱን_, _alemi_, _ناگاته_, _nadaljev,
   {{0xedd04334,0x0386d340,0x2d84824f,0xadef22d1}},	//   _fatherna, _florin_, _aallaqqa, _نورویژ_,
   {{0x40fca0f7,0xe25b72b7,0xfe453378,0x358892b2}},	//   _胶南市交通局_, _akalla_, _allavega, _स्रोतको_,
   {{0xe8eae059,0xfd231109,0xf1e7b3bf,0xaa1e4025}},	//   _እንዲሄድ_, _allierte_, _алуминие, _balẹ̀_,
   {{0x875e013f,0xb200f2a2,0x524a7208,0xb76f13a4}},	//   _מותגים_, _segih_, _seumas_, _gravissi,
   {{0x5c588009,0xf3dd815d,0x5fee043b,0x8283c1af}},	//   _содержит_, _garwa_, _agħlaq_, _amokura_,
   {{0x94ac71ba,0x9294f3c2,0x0cbed01a,0xd301c3bf}},	// [1580] _консулта, _abakopi_, _кажет_, _cavalli_,
   {{0x13948358,0x52fc90e7,0xdfeb120b,0x6082f3a1}},	//   _maksaa_, _nyaga_, _त्यागें_, _abacondo,
   {{0x44e40009,0x66bd62c4,0x7545a063,0x924fb0ed}},	//   _необходи, _दत्ता_, _اندیجان_, _ngolwazi_,
   {{0xa3794152,0xd863c0c9,0xb9e3c152,0x530bd0b2}},	//   _tavalla_, _товари_, _товара_, _nyablaj_,
   {{0x221c50e7,0x61411191,0xec650437,0xd46f5110}},	//   _mitheo_, _supercel, _slottet_, _kolehiyo_,
   {{0x37dd2080,0x73871051,0xf38691ac,0xb3fa5463}},	//   _despreci, _quarry_, _miara_, _matute_,
   {{0xb387f527,0x81160105,0xed050207,0x0c84c009}},	//   _jours_, _מיצוות_, _milliyet_, _русские_,
   {{0xaeb77048,0x527e9062,0x926ce05d,0x928ea184}},	//   _populace_, _aganu_, _canoni_, _ofisialy_,
   {{0x027f4474,0xf26e509e,0x4248d044,0x15a0b261}},	//   _cuenta_, _ratova_, _noema_, _trascriz,
   {{0xdcea80fb,0x1af91056,0xcc5211f8,0x2213f30f}},	//   _प्रमाणं_, _ditshepe, _vratila_, _अन्नधान्,
   {{0xb25b732e,0xf22582fa,0x63f4616b,0x197f6196}},	//   _gjalda_, _barki_, _hertom_, _argitale,
   {{0x43869395,0x427e0130,0xb15cd340,0x8a482124}},	//   _biara_, _saina_, _тулар_, _аҭахым_,
   {{0x1c202111,0x7667213c,0x86662105,0xfd03d004}},	//   _priskrib, _харитон_, _דיאמאנט_, _فدرال_,
   {{0x5e8d21c7,0xc27f703c,0x9209f58b,0x53a0b3d0}},	//   _шаршы_, _stanca_, _abahlwem, _академич_,
   {{0xb46b9013,0x4387f29e,0xb064d0e0,0x135f3573}},	//   _obtenido_, _cours_, _लक्षणं_, _pengene_,
   {{0x827e01a4,0xa9ec9196,0xbb2b70af,0x2770821d}},	//   _waina_, _спортын_, _ボタンをクリック, _अनवस्थित,
   {{0x4527d174,0x1053d0f6,0x46959032,0x9298414c}},	// [1590] _прикажи_, _полицей_, _myndasaf, _মনোনয়ন_,
   {{0x7386d4f1,0x0b63b0af,0x4ab45032,0x648650e5}},	//   _dooran_, _アクセス解析_, _velkomin_, _बुझाने_,
   {{0x61e1e625,0x17e3c296,0x001a100a,0xf5b6930a}},	//   _हजारो_, _полиси_, _providin, _bringinm_,
   {{0xd29262d9,0xadb0723c,0x7926c218,0x1219d3ab}},	//   _abrabo_, _взаимопо, _تعميم_, _jednoráz,
   {{0x15f8b022,0xb0e2409c,0xd962409c,0x1c6690d7}},	//   _басталад, _amantaal, _amantaat, _сагынып_,
   {{0xf3792616,0xa27ef2d5,0x1212d067,0x526e5186}},	//   _elbasan_, _bainns_, _imehe_, _intoki_,
   {{0xa26c819a,0x626ce3c6,0x1dfc02cd,0x338070d3}},	//   _achosi_, _panoni_, _verdient_, _maurus_,
   {{0x75a410b1,0xd6b85020,0x2c02524a,0xb2ab4342}},	//   _آسہِ_, _actually, _harsels_, _كردستان_,
   {{0xff06d0d7,0x1977b486,0x627ef152,0x42963234}},	//   _яраткан_, _novidade, _mainos_, _funkciu_,
   {{0x02258054,0x92e952ee,0xc321824a,0x027e02d5}},	//   _sarki_, _addinin_, _deryn_, _bainn_,
   {{0xd22581c2,0xa7741105,0x4a1442d4,0x0248021f}},	//   _parki_, _פרילינג_, _abyayala_, _enime_,
   {{0x0ad6c2e8,0x3f8ec041,0x040d7094,0xb386e152}},	//   _coitiant, _تمديد_, _gainditz, _koiran_,
   {{0x927301e7,0x4387f03a,0x52ee6211,0xe96a70c8}},	//   _politsei_, _sours_, _akonaki_, _лабарато,
   {{0x5f4e023c,0x836580fb,0x9060c296,0x738e0034}},	//   _versione_, _aligato_, _abasadin, _versioni_,
   {{0x7d23e431,0xa2925246,0xc26e639d,0x0147b053}},	//   _plusieur, _tatalo_, _parova_, _englisch_,
   {{0x3045403c,0xde54a258,0xb37c9064,0x2d2f80de}},	//   _impurtan, _arfannia, _attaque_, _اۋگۇست_,
   {{0x4318740e,0x8dae24ca,0xa3f9510b,0x0201907d}},	// [15a0] _hwjchim_, _stigende_, _amfuba_, _lesin_,
   {{0xa479f197,0x0be0e005,0x62002175,0x4f5d10d7}},	//   _meletakk, _interjer, _dekip_, _елгән_,
   {{0x92ca0185,0xe27e61ab,0xe27f7500,0xc9c7c01a}},	//   _adidi_, _taong_, _fransa_, _саналат_,
   {{0x7290613b,0xc7b4e085,0xc386d053,0x855953fa}},	//   _atlan_, _অবহেলা_, _tiere_, _akakweny,
   {{0xcdbf6257,0xd075a062,0x22d911ce,0x93f96230}},	//   _regionla, _matafaio, _nocera_, _figuer_,
   {{0xa7e79481,0xf20194ec,0xfbefe249,0xeb6d0068}},	//   _сайлау_, _kesin_, _anteriur, _aaronier,
   {{0x0999d13c,0xf2fcf2e9,0xa8b63004,0xd2ca048b}},	//   _ребекка_, _bangoy_, _طرفين_, _edidi_,
   {{0x9200401b,0xdbc80050,0x23fa74ec,0x726e7224}},	//   _demir_, _青少年科普_, _kurulu_, _lesolo_,
   {{0x8ee260e5,0x92d9107e,0x990f1408,0xddec3180}},	//   _युक्तिया, _vinnare_, _निरीक्षक, _このブログの新着,
   {{0xa37e5148,0x2db43360,0x8d3bb1b5,0x827ff07d}},	//   _kusabab_, _گوشوں_, _станның_, _nguna_,
   {{0x127e0094,0x93860421,0x0a85d030,0x7b758200}},	//   _baino_, _shira_, _توردی_, _jallupac,
   {{0x0c76c1f9,0xf2b9638b,0xdf2a53a4,0xb638b293}},	//   _निर्बल_, _loidich_, _smartypa, _twandiki,
   {{0xc2019222,0x327e64fe,0xb28c0015,0xf08af096}},	//   _hesin_, _kaone_, _chakana_, _کردئیے_,
   {{0xf27e91eb,0x565bd591,0x7ff43203,0x6bd693e9}},	//   _laang_, _ngokwemi, _benyamin, _चप्पू_,
   {{0x327e049c,0xeb094546,0x237a0004,0x3a67a1ed}},	//   _uainn_, _composte, _perawan_, _кризисы_,
   {{0xe947c11b,0x8386d25d,0xe290c394,0x325b71be}},	//   _финале_, _piere_, _samart_, _ufalme_,
   {{0x671da049,0xe3cda063,0x22ee92cd,0x1ff3e37b}},	// [15b0] _situació, _ватанини_, _kraft_, _najdraže_,
   {{0xd27e9168,0x92004030,0x4e552351,0x2ecb9326}},	//   _maand_, _temir_, _بولتن_, _ebuntwin,
   {{0x12d6a381,0xd2ca503e,0xbada215f,0xd212613c}},	//   _турсунов, _afolabi_, _taimatun_, _amohe_,
   {{0xe382d405,0x2ee3d226,0x479fd1d4,0x77c95290}},	//   _قائلا_, _पूर्वाधा, _katersug, _dostosow,
   {{0x4609d132,0xec53733d,0x09c1c258,0xe3ce9007}},	//   _анексей_, _certeza_, _sivertse, _ahová_,
   {{0x8290836f,0x08a20226,0x70b842ca,0x887a1102}},	//   _lekala_, _zapomněl, _туристти, _призначи,
   {{0x83aab318,0x29f910fb,0x729274d6,0x928ab048}},	//   _norveje_, _प्रेक्ष्, _essaal_, _stromů_,
   {{0x2e857135,0x0c933228,0xa27e91eb,0x522585c6}},	//   _ወልደሱስ_, _بالای_, _gaang_, _markt_,
   {{0xe63ba009,0x8e51121c,0x029253c9,0x59cdd262}},	//   _введите_, _finanzja, _octavo_, _bagerage,
   {{0xc51f7341,0x42d9b4f4,0xd744341d,0xf7c1d42f}},	//   _hannesch, _akanete_, _بنيادی_, _acetonew,
   {{0x43fa735c,0xfa8901ec,0x4e9453b4,0x5de9b248}},	//   _gurubu_, _fasilman_, _atamelan, _ናጽነቱን_,
   {{0xd5c4332d,0x396dc4c8,0x79c71083,0x5a887030}},	//   _sambandh, _maniapot, _карама_, _اینترنیت_,
   {{0x7b7343a5,0x0f681027,0x0248c008,0x7fd2c1c7}},	//   _inkundla_, _vacanzas_, _gymmat_, _бокстан_,
   {{0xe86ce1fd,0xb230037e,0xb2a6a2f2,0x62307121}},	//   _sahibind, _kwamana_, _tibbi_, _kaamera_,
   {{0x928cf015,0xd2c86300,0x12a010a8,0x76a6b30f}},	//   _wiosenny_, _enklask_, _servisní_, _प्रयोगात_,
   {{0xfb1323b0,0x0f66424f,0x1fd3a065,0xb3f883bb}},	//   _hinanden_, _tamakkun, _קנביס_, _achual_,
   {{0xf23e417f,0x02019141,0xac522264,0xeb0211b3}},	// [15c0] _кормандо, _nesil_, _بحريني_, _floricie,
   {{0x4237a030,0x8c6dc30a,0xe2026177,0xb9b7d2e8}},	//   _شیرپور_, _biruaim_, _amrisa_, _ionadaí_,
   {{0x065e4588,0xc9d0d036,0xc307a1ce,0xea16c2dd}},	//   _استوار_, _медии_, _alabang_, _angafaka_,
   {{0x538b2279,0x82d85105,0xb967f0e5,0xa27a8207}},	//   _mørke_, _ערדציטער, _samodzie, _kaliteli_,
   {{0xe37f31d4,0x9a23b113,0x86d100a8,0x0211f1d9}},	//   _tamaasa_, _darbinie, _symbolem_, _әйтеуір_,
   {{0xdd23027a,0x2e5cd018,0x6ed55298,0x100940f4}},	//   _položiek_, _autorită, _munyanga, _مەغفىرەت_,
   {{0x2f227041,0xf422a026,0xd2322566,0x2e218324}},	//   _سريلانکا_, _개인정보를_, _chamado_, _primeros_,
   {{0x629260e0,0xcb5b939c,0xd20112b7,0x43874407}},	//   _paramo_, _абдулхәм, _kabilu_, _boeren_,
   {{0xd373c3b4,0x1c75c01f,0x84660076,0x0291b1d2}},	//   _akhaefe_, _manufar_, _bapetiso_, _osward_,
   {{0xa7a132ac,0x3edda48f,0x6b1fc281,0x44b8e06a}},	//   _ژێرزه_, _лидерите_, _salaysan_, _सिनेमात_,
   {{0xe30012bf,0xb29010b2,0xb27e0374,0xdc5b8353}},	//   _makambi_, _nthaw_, _vaine_, _kostimi_,
   {{0x0ee950c6,0x7387f2a8,0x5a10738b,0x240a00e5}},	//   _abakɔnnw, _pouri_, _megacame, _kuriersk,
   {{0x7c17d1b9,0x727f72b8,0xa9c2b032,0xa46ed11b}},	//   _ҡырмыҫҡа, _spanne_, _tilvitnu, _драме_,
   {{0x87f6f037,0x36b9d0be,0xf2e3708c,0x9e42c322}},	//   _әлбәттә_, _pavaresi, _dominee_, _cizbitte_,
   {{0x727a922c,0xa29111d6,0x3c1b15f0,0x89d9430d}},	//   _mulimuli_, _bacale_, _vatrogas, _avvenime,
   {{0xf29081da,0x227f7256,0x19c290c9,0x32916004}},	//   _bakame_, _utanga_, _handelst, _segara_,
   {{0x9036100a,0x527e93af,0x52b9b13f,0xd5169155}},	// [15d0] _נסיעות_, _nganx_, _חחחחח_, _مۇختەر_,
   {{0x9d3515c2,0x44af0477,0x50a83626,0xebb3c030}},	//   _स्वर्गीय_, _dihasilk, _अल्पकाली, _соглом_,
   {{0xa2cbf01a,0x523605ec,0x63bbc15d,0xb27ff220}},	//   _ajuda_, _izija_, _اسکار_, _ifuni_,
   {{0x08e31050,0xdf6f6059,0xd12d21d9,0xe1250213}},	//   _一九八四年_, _ለመተግበር_, _тарту_, _kutiyaña,
   {{0x82646627,0xfc7c5010,0x68c5f207,0xd30de01f}},	//   _boulot_, _berries_, _sayesind, _takarar_,
   {{0xa38b52a9,0x17659183,0x7aa7c1ed,0xa27e0208}},	//   _würde_, _bewillig, _сайлап_, _uaine_,
   {{0x9d44527c,0x727e0351,0xb249f3f2,0x7daaa628}},	//   _最近の記事_, _raine_, _udumo_, _tunineqa,
   {{0x66272228,0xd2412121,0x520211e0,0xb967d115}},	//   _کاراته_, _सुतले_, _oppido_, _diboishe,
   {{0x727e434f,0x527e011d,0x5f1e40bb,0x4d3713e1}},	//   _tamna_, _paine_, _проектів_, _anvizaze_,
   {{0x0292535a,0x8ec7f011,0x8539e3ef,0x337a001f}},	//   _mataio_, _regimien, _salactol_, _fararen_,
   {{0xd5070196,0xee1a709c,0xb2489627,0xf200f018}},	//   _сурталчи, _ameerika, _elamu_, _regim_,
   {{0x1aa7543e,0x6c6db09b,0x2ea0f155,0x4a64f3e1}},	//   _साक्षरता_, _balugik_, _мәхсус_, _boulvers,
   {{0xd20190c6,0xd381d2f7,0x0b9880bf,0x9057f343}},	//   _besie_, _террорлу, _фамилияс, _alaalato,
   {{0x0e3510ce,0xe96b930d,0xf889e2db,0x8fa4f272}},	//   _kellemes_, _allinjat, _salşykla, _diverger_,
   {{0xd27f70f9,0x729260e7,0x92ab202a,0xf2e974a2}},	//   _standa_, _faraho_, _disallow_, _karizma_,
   {{0x2386d206,0x620253a3,0xc04c415f,0xc1d161a1}},	//   _fieri_, _zatial_, _ayurnann, _etterbay_,
   {{0x727ed249,0xd10001ba,0xc386016c,0x2983e3b0}},	// [15e0] _gronda_, _изложени, _chire_, _bagkante,
   {{0x37bab067,0x0aa6f4a8,0xedc41241,0x02041299}},	//   _chorioni, _पूर्णिमा_, _articole_, _articoli_,
   {{0x42cac00f,0x579dd231,0x9ff14155,0x0b1f12cb}},	//   _trodde_, _forumowi, _ﺋﯚﻳﮕﻪ_, _قصيدا_,
   {{0x62b17264,0xa0f17264,0x03dde098,0x857e3175}},	//   _النخيل_, _النعيم_, _gatwa_, _lenteliz,
   {{0xde18507f,0x89c16121,0xb39902e5,0xa5ca010b}},	//   _alóha_, _kandidee, _kúsok_, _bararush,
   {{0xa9fbd1a6,0x9c5fd0fd,0xf5b270f4,0x4c0da03a}},	//   _achashat, _septanm_, _كوررېكتو, _distenks,
   {{0x94c89022,0xa6b76187,0xe1dbd28e,0x6a9f21bf}},	//   _мамандар, _zinapati, _pengarah_, _адресез_,
   {{0x9386f0ad,0x4c75205a,0x12caf1b0,0x496ed050}},	//   _yngri_, _saludar_, _pridat_, _一位媽媽的經驗_,
   {{0xd060239e,0x949e914c,0x295751bd,0xb3ca4227}},	//   _isisirin, _যৌক্তিক_, _novoroze, _뷰어다운로드_,
   {{0x2e592431,0xf2ee0221,0xa3f8f224,0x62b5713f}},	//   _推荐给朋友_, _isifo_, _mohuta_, _placed_,
   {{0xd2b4023f,0x35186299,0x1aa6f12e,0x139670c8}},	//   _epics_, _annuncio_, _पूर्णिया_, _kursai_,
   {{0x2250e284,0x202be024,0x5cbf30a2,0x80d4b061}},	//   _externem, _व्यजिज्ञ, _ولیږل_, _مرسڊيز_,
   {{0x3386f111,0x12927629,0x12ed40bb,0x59c720b3}},	//   _nigra_, _geraak_, _afsiede_, _баралар_,
   {{0xa635d15f,0x92ca95aa,0x3ee99031,0x7dfca020}},	//   _huginngi, _idade_, _ይፈለጋል_, _affectwa,
   {{0x09838258,0x3d06d299,0xc292624d,0xa7ed13a4}},	//   _fleische, _attraver, _mitanu_, _badabing,
   {{0x325ba033,0xa601e0fb,0x9eb560df,0xa200304e}},	//   _explo_, _sundaram_, _orizonta, _kumita_,
   {{0x7fdd1352,0xd27e635e,0x627ef287,0x02408116}},	// [15f0] _هاریکاری_, _yaona_, _kainas_, _खोललन_,
   {{0x70bf317b,0xd38ff3a5,0x32b7b37f,0x0b05a5ef}},	//   _форумдар_, _minyaka_, _fredric_, _ugasanga_,
   {{0x3d5a1296,0x4cf23124,0x213b12e9,0x6386f62a}},	//   _дорем_, _моррель_, _bilesmeh_, _shires_,
   {{0x4ac3124e,0x7b5df06a,0x63be92ac,0xd386d3c1}},	//   _زندگی_, _norwegia_, _ساغکردنه_, _gjorts_,
   {{0xc27e02ab,0x525ad0c9,0x72fdf2df,0xece800ac}},	//   _kaina_, _vanlig_, _bauga_, _은평뉴타운_,
   {{0x127ed460,0x8201d0e4,0xdf8940f7,0x1f5b9080}},	//   _laeng_, _bewin_, _雅虎知识堂仅提供, _allaukan,
   {{0xaebbe0fa,0x9b7be0fa,0x7d1fa3c1,0x9636c34f}},	//   _eparhije_, _eparhija_, _beroende_, _titigagi,
   {{0x227ed447,0x73eae3c7,0xfbecb3a2,0xccd7d08a}},	//   _vuonna_, _ventas_, _izdavačk, _شعراو_,
   {{0xae96201a,0xc2fcf1cd,0x03875059,0x73423085}},	//   _تىلىم_, _bygga_, _cheras_, _cabello_,
   {{0x1735c111,0xa2026311,0x5386d384,0x61708063}},	//   _prezenti, _birine_, _mieru_, _اجراتی_,
   {{0x9ee1f13e,0x6c6dc329,0x635aa13f,0x727ed39b}},	//   _konieczn, _abrusim_, _perfect_, _baeng_,
   {{0xd305a215,0x41c731b5,0x82ca60ec,0x5200f235}},	//   _članak_, _داستانى_, _ndodh_, _legii_,
   {{0x327e0094,0x827e6496,0x129260c4,0xb0f04207}},	//   _baina_, _taona_, _bitanu_, _indiriml,
   {{0xb27e02df,0xb2871401,0x63cf8007,0xf197c508}},	//   _jaina_, _سفيان_, _durva_, _ракомет_,
   {{0xc2d5519e,0x527e0376,0x01410023,0x7a7f84c8}},	//   _rotorua_, _daina_, _asseleel, _hukapapa_,
   {{0xc347c0f9,0xdfd182e5,0x8a8d4153,0xd2486338}},	//   _almenna_, _čitateľo, _visionen_, _onome_,
   {{0x3b582290,0x427f751f,0x237a0094,0xb52cf3bf}},	// [1600] _पूर्वानु, _tuanya_, _garapen_, _консулти,
   {{0x9a11a020,0x216c926a,0xe2e8c012,0x7a8ce0c9}},	//   _elective, _activity_, _مقدمي_, _visnings,
   {{0x751ff0cc,0x9065c22c,0xc2df81ba,0xca4fe244}},	//   _দ্বিতীয়, _atuanofo, _alberghi_, _warmirus,
   {{0x9033202a,0xcea5b42a,0xc9eef48c,0x9cf0d3d5}},	//   _casebook_, _gestelde_, _itunanya_, _mastergr,
   {{0x029152df,0x5200b027,0xfea031ca,0xb27ed2a2}},	//   _tagane_, _decis_, _تھٲوم_, _vaeng_,
   {{0x52a7635b,0x8a0040bf,0x6a1773e6,0x4cc1f216}},	//   _dagbok_, _чемпиони_, _tohatoha_, _assistiu_,
   {{0x5343044f,0xdb1e50ac,0xb2cc61fa,0x299cb351}},	//   _direito_, _본격적으로_, _endlelo_, _پيدايش_,
   {{0xf20fd405,0x4089d3b9,0x21251244,0xa274f08c}},	//   _محارم_, _مغازه_, _puriyaña, _versamel,
   {{0x20ca511b,0x83ec22ae,0xf023d105,0x62cd00bd}},	//   _запослен, _loomulik, _באקטעריע_, _stelsel_,
   {{0x2501f0cc,0x5f5da3be,0x989ae248,0xcd08009a}},	//   _দায়ী_, _namakhon, _ብሽክለታ_, _رايونعمع,
   {{0x62838267,0xdfeaf12e,0x651e00d7,0x9c2231ad}},	//   _mashini_, _विभागों_, _kollegiy, _shirveis,
   {{0x8b7db35d,0x8e12d078,0xecad4207,0x2970113d}},	//   _atención_, _حدثنا_, _dosyalar, _bernkast,
   {{0x7225e0ee,0x8ae833ed,0x3387f3f9,0xf3731040}},	//   _matku_, _значно_, _inurl_, _boladbe_,
   {{0xce17344f,0xf3392031,0x662540ce,0x12d0d1fa}},	//   _значи_, _ሴክሬተሪ_, _felbontá, _domeyini_,
   {{0x115fb475,0xbc09d01a,0x0386f0f9,0x58e5e0bf}},	//   _pengenal, _либералд, _sigri_, _олтмиш_,
   {{0x832c2252,0x32f05350,0xbdb940ce,0x9c5bd036}},	//   _булардын_, _policii_, _javaslat_, _settori_,
   {{0xb386604b,0x6e029101,0x44a6e21d,0x12cf8195}},	// [1610] _chora_, _anzenera, _प्रभास्व, _ambewuyi_,
   {{0x4dc41057,0x325b742e,0xf3957023,0xc92b61ad}},	//   _ultimele_, _fjalla_, _caasna_, _discolou,
   {{0x99dfa1d5,0xc2e293d2,0xd386d188,0xf2486443}},	//   _osigurat, _engined_, _fiert_, _anome_,
   {{0x4200b62b,0xe2371198,0x07be00ac,0x8e4273d7}},	//   _decir_, _британиј, _토지문학공원_, _सशक्तिकर,
   {{0x23eae30c,0x52df1378,0xfd11915c,0xacdfc46a}},	//   _centos_, _menning_, _geklappt_, _abakhulu_,
   {{0xfa10422e,0xa5aac1d5,0x7349d29a,0xf386d1cf}},	//   _calabria_, _poznajem_, _ditemui_, _hiert_,
   {{0xfcb97421,0xdc740303,0xab6d5049,0xc29153d9}},	//   _polysacc, _romulus_, _carreira_, _bagale_,
   {{0x3283e0fa,0xc26e5336,0xd94ce368,0x3e969271}},	//   _slikara_, _aitoli_, _gutolget, _šampioná,
   {{0xb22ac10d,0x4c21f2b5,0x33ea5407,0x727ed3a8}},	//   _годам_, _drapery_, _helte_, _ngenx_,
   {{0xa41e50f4,0x029182ce,0xb73a3252,0x7dddf1d9}},	//   _принсипи_, _adyaha_, _бараткан, _қайтарып_,
   {{0xa530512f,0x52ca0052,0xadb7a346,0xdaba9031}},	//   _шериксиз_, _alida_, _blogsome_, _ጉባዔውን_,
   {{0x648641e7,0x8e55c533,0xa2e92159,0x19c0e196}},	//   _सुधारी_, _bigamije_, _mennyit_, _astearte,
   {{0x1f81f198,0x4c8bc096,0x829160d2,0x62f3b32d}},	//   _германиј, _گھوٹکی_, _vegada_, _abdaiḥ_,
   {{0x68e632f4,0xc25ae2d5,0xe0d530c9,0x620140c8}},	//   _сайтаас_, _failte_, _журналу_, _sveika_,
   {{0x6cf23375,0x12906137,0x338313e1,0x9f0f1155}},	//   _سالما_, _tulad_, _dinyite_, _йипәк_,
   {{0x427e927d,0xfd02e339,0x2e54223f,0x888303c2}},	//   _waana_, _lattelec, _bonaudia, _abakunuu,
   {{0x65290164,0xf41d762c,0x16b933e9,0xe607f022}},	// [1620] _definisy, _dessutan_, _संघर्षशी, _бағдар_,
   {{0xbc9a50c8,0x8dee606a,0x7b34e007,0x9057b005}},	//   _абслугоў, _berjumla, _مندانہ_, _нарыхтоў,
   {{0x6fc5b248,0xe212613c,0x1a814007,0x81b3e351}},	//   _ይኹንእምበር_, _amohu_, _الاشاعت_, _حاضرم_,
   {{0x1f6960ce,0xabd160ab,0x528e50cf,0x73831077}},	//   _hatalmas_, _kundeser, _masasabi_, _akoyege_,
   {{0xf9c0e196,0x3386d051,0x530181e4,0x039570c7}},	//   _azterket, _thorns_, _hapanui_, _taasna_,
   {{0x557e113c,0xa2b5747e,0xe386949c,0x2053d18a}},	//   _violació, _placid_, _mhara_, _reprezin,
   {{0xaa1e8248,0x795bf08c,0xd355b14b,0xb2130100}},	//   _ክንግንዘብ_, _veroorde, _acteurs_, _alahas_,
   {{0xd18801b5,0x3a0841a8,0x1237e293,0x138694a2}},	//   _نومىرىم_, _буржуазн, _akimara_, _ohara_,
   {{0x1c518244,0x1335f244,0xbb9080cb,0x83869459}},	//   _chitama_, _cusconx_, _posibilr, _ghara_,
   {{0xd059917d,0xd2ca9012,0x2b60f44e,0xc2fce46c}},	//   _неделю_, _idadi_, _aarmustr, _lengst_,
   {{0xe5c56262,0xf344a369,0xb2907261,0xcd11316e}},	//   _imibereh, _foreste_, _lunae_, _осталог_,
   {{0x2057101a,0x323b1582,0x1790627c,0x14c2c045}},	//   _кишинин_, _syiling_, _landbrug, _ababinik,
   {{0x827e94ad,0xa213241f,0x261bd085,0x23ce0374}},	//   _maano_, _avchoh_, _কাঁশিপাড, _chivi_,
   {{0xbd934314,0x4f2181c3,0x5d0c7097,0x6373a191}},	//   _विज्ञप्त, _coitchea, _klargjor, _angande_,
   {{0x01dcc120,0xec9cc11e,0x0886c0ea,0x32d8e1e0}},	//   _superfly_, _superflu_, _सिनेमामा_, _aliena_,
   {{0xaee9362d,0x625b7221,0x886ce00e,0x60618207}},	//   _markaman, _adalwa_, _sahilind, _eksiklik_,
   {{0xd97e5030,0x440cc3f9,0xe29260ef,0x2199d434}},	// [1630] _болаларн, _mozillaz, _kitabu_, _манипула,
   {{0x6c67e2d2,0x2316329a,0x73603041,0x388ac004}},	//   _betreff_, _hamzah_, _سپرلی_, _اسليم_,
   {{0x00fd7050,0x33cf7246,0x52b4d111,0x153ab0d7}},	//   _第二天一大早_, _agavaa_, _speco_, _stantsiy,
   {{0x4a08407b,0x1200d4a7,0xb200d37f,0xaa8120f6}},	//   _sadarkaa_, _afeia_, _salimu_, _билҗек_,
   {{0x43869195,0x235f3012,0x22ca6387,0x06c2d140}},	//   _chara_, _mengine_, _adodo_, _doktorı_,
   {{0xd26e62eb,0x0a5530e8,0x82fce38f,0x075b94dd}},	//   _carota_, _भारोत्तो, _hengst_, _ugunstig,
   {{0x62dab356,0x9aa3f01f,0xe6187263,0x8248935c}},	//   _bernice_, _yankunan_, _махалгар, _aname_,
   {{0x973fd0fb,0x4652d500,0xf173d16e,0x6c5b9245}},	//   _चिकित्सा, _braziliy, _наставку_, _bafunge_,
   {{0x9db2c221,0x0f35e1e7,0xc3874169,0x12e95053}},	//   _inqununu_, _suurenda, _joeren_, _medizin_,
   {{0xe26db12b,0x127e4012,0x87efc057,0xb4a5f0aa}},	//   _adword_, _namna_, _адмите_, _akubahuk,
   {{0x3ea5b15e,0xf15761bf,0x4b73e1df,0x53869376}},	//   _bestalde_, _агонисеш, _komunuma_, _shara_,
   {{0x5224b0d7,0x11f42311,0xd290309b,0xaecc0065}},	//   _elekke_, _кемпирле, _fomami_, _הפרצוף_,
   {{0xab51809c,0x1836a524,0xe27e441e,0x43ea73b0}},	//   _daimlerc, _इस्लामपु, _kamna_, _hente_,
   {{0x33fa60e7,0x19aa60e5,0xf27e0262,0x8470e2e2}},	//   _lutuku_, _सूर्यादय_, _nyine_, _derespek,
   {{0x0202723e,0x32cad143,0xedc8f0c5,0x6a0f61a6}},	//   _kirist_, _adede_, _amahenda, _angayile,
   {{0xc6a7e020,0x0a1062eb,0xaf4b05cf,0x227e9137}},	//   _ildrench, _sanabria_, _resposta, _gaano_,
   {{0x7c67c176,0x4053446a,0xa3fa70a4,0x53a6025a}},	// [1640] _گردان_, _nomseben, _burumu_, _tempolim,
   {{0xe2ca9079,0xe736013f,0x57edb3d9,0xf27ff281}},	//   _meade_, _פיננסי_, _boipelaf, _uguna_,
   {{0xb2a104f7,0xbf1732a1,0xf31e33ef,0xd3866405}},	//   _project_, _perdagan, _peccato_, _bhord_,
   {{0x52d830fc,0x3f64d414,0x8efcd06a,0x1053446a}},	//   _romela_, _tocantin, _भयंकर_, _komseben,
   {{0x5e6831ea,0x0200f199,0x227eb1c9,0x3aee215e}},	//   _бәлки_, _megis_, _tacna_, _галлерэй_,
   {{0x6395418a,0x93f951b9,0xd27e4335,0x414ec2e8}},	//   _acesta_, _mofuta_, _jamna_, _agallamh_,
   {{0x8248418f,0x799d30d7,0x527ed0cb,0x2200d02a}},	//   _kommt_, _санын_, _cronfa_, _spoilt_,
   {{0x23caa259,0x8f0b51bc,0xe29032a1,0xd99be09a}},	//   _zamanı_, _كىرزىس_, _hujan_, _хәрәктир,
   {{0x03473298,0x02fcc337,0x727f707e,0xfea8a248}},	//   _kumenya_, _belgie_, _stanna_, _ዘይንፈልጦ_,
   {{0x759d2162,0x423b30af,0x79aa31e2,0x0553f041}},	//   _контролл, _cykling_, _солим_, _abakhath,
   {{0xb27e90cf,0xc3f4008f,0x6158606d,0x927ed199}},	//   _paano_, _costau_, _бармегар, _gronfa_,
   {{0x6f83a009,0x480de327,0xd2367351,0xd651914f}},	//   _помощью_, _abiyamó, _aramaic_, _समाधौ_,
   {{0xb2eb01da,0x32fd91db,0xdc56b29f,0xf378e47d}},	//   _harimwo_, _rediger_, _vertige_, _allaban_,
   {{0x53860106,0xc24864a5,0x4eb3b23c,0x637ce0f1}},	//   _gairm_, _moomu_, _potrebbe_, _bevarte_,
   {{0x3b1de381,0x02cb4261,0xba2b3225,0xe290b285}},	//   _akatuàpe_, _fredde_, _впечаток_, _addayo_,
   {{0xa1f1c064,0xed1903d2,0xf24990bf,0x937b1309}},	//   _订阅该问题_, _elongate_, _bosma_, _biradmo_,
   {{0x560de135,0xcbca1065,0x0aec3166,0x3ff65351}},	// [1650] _ዘይተኣደነ_, _אכסניות_, _attraent, _جهانيان_,
   {{0x3045d1a1,0x1e06d42e,0x8d66c196,0x1c5f20af}},	//   _overnmen, _myndirna, _эротик_, _ゲストさん_,
   {{0x4212d192,0xd849f123,0x5cee144c,0x42da7339}},	//   _ameha_, _destriks_, _малайзын_, _toreiz_,
   {{0xb315d028,0xab2c31d4,0x616d023f,0xb3013245}},	//   _burbank_, _angallas, _alternàn, _adibane_,
   {{0x7394e2cb,0x05323244,0xd07380a8,0x65f5e0d2}},	//   _maisha_, _apaniway, _moravsko, _туруктуу,
   {{0x0ed6010e,0xb2ca00af,0x83a3044b,0xf290a04e}},	//   _बांटने_, _smidt_, _knappt_, _tubag_,
   {{0xd2cbf0b7,0x326cb3a3,0xbe373008,0xb3fa605e}},	//   _ljudi_, _budove_, _gumanita, _tutuku_,
   {{0xd27f40ec,0x50dd4149,0xa5c9a009,0x52486332}},	//   _brenda_, _afonotel, _входят_, _foomu_,
   {{0x835b1009,0x0224b4df,0x9344e11e,0x63651230}},	//   _изменить_, _plekke_, _sovente_, _flaggen_,
   {{0xd7197198,0x5516c1ca,0xea17862e,0x947752a7}},	//   _conferên, _siilaany, _yabatjha_, _тараккиё,
   {{0xe25a93af,0x6977d396,0xd2ca0591,0x430e658f}},	//   _bohliz_, _entidade, _elide_, _vasaras_,
   {{0xddf1e385,0x155a3287,0x32d8b266,0x27c2f510}},	//   _mendapat_, _гарвыкан, _ekeeke_, _abasindi,
   {{0x7249f057,0x527e938d,0x82da7062,0x26b9c140}},	//   _glume_, _taane_, _pasese_, _mikroray,
   {{0xcfd3d276,0x526de309,0x227e6171,0xec92920e}},	//   _بئنڪن_, _bitoy_, _naona_, _реформит,
   {{0xf2cb4521,0xa84f827a,0x9465717d,0xaeb920f0}},	//   _tredde_, _mimoriad, _страхова, _chiffres_,
   {{0x2249f193,0xef2a80c0,0xfdb354c0,0x48487330}},	//   _blume_, _gastrula, _acantona, _新浪特许频道免责,
   {{0xf27e6076,0x52c94002,0x50707067,0xba70128d}},	// [1660] _kaona_, _bisovbe_, _ensaiklo, _achaitwa_,
   {{0x0c829470,0x69bbd009,0x226d8089,0xfbefd28b}},	//   _inneheld_, _обозначе, _throu_, _speerstr,
   {{0x19db6064,0x2c5b80be,0x7c67e16d,0x49f0f395}},	//   _第三十七条_, _postimi_, _getraff_, _nkurɔfɔ_,
   {{0x4e838209,0x284cd026,0xb344d22e,0x52ea756f}},	//   _abawanye_, _않았습니다_, _mayenne_, _butiken_,
   {{0x7c85a019,0xf9d0c15f,0x324f7009,0x520190ec}},	//   _רואיג_, _inuttivu, _ngimuphi_, _besim_,
   {{0x63869216,0x7b7022f1,0x10f6531a,0x57b5101b}},	//   _biars_, _kwirinda_, _maligaul, _bellemek_,
   {{0x630f62c1,0x73eae0fb,0xb61d0123,0xfc4781dc}},	//   _misafir_, _caitad_, _chetlall_, _समुदायका_,
   {{0x4f183009,0xf202f042,0x36015119,0x39c0e23f}},	//   _центре_, _akakuvum, _salliuti, _botelhet,
   {{0x732a90e5,0xffae3043,0x04b5618b,0x439672fc}},	//   _समाप्ति_, _жалко_, _luizinho_, _turski_,
   {{0xbcc4116b,0x8a58c272,0x8204130d,0xf2eb02a6}},	//   _artikolu_, _videncia_, _artikoli_, _aktivno_,
   {{0x84273171,0xa3a254e7,0xc89513c2,0x7ba4d163}},	//   _matatizo_, _telpa_, _abakyabu, _pabianic,
   {{0x03f8e138,0xd23e22c0,0xe249b309,0x2527e23c}},	//   _ponuda_, _guérilla_, _boqma_, _maurizio_,
   {{0xa86e500e,0xc2cb000b,0x7f6e3214,0xe91af214}},	//   _tarixind, _gradit_, _омаров_, _кодексін_,
   {{0x8278618a,0x63866342,0x2200c292,0x7e2ac180}},	//   _atunci_, _mbord_, _solish_, _中央道伊那スキ_,
   {{0x427f721e,0x7d8fe253,0xff3be0a8,0x1f44d2a9}},	//   _duanya_, _agaleaga, _hasičů_, _entsteht_,
   {{0x20d3c1b9,0x63aa1304,0x2895d3c9,0x2c04405e}},	//   _власы_, _terasing_, _pulvinar_, _ahosivi_,
   {{0x90f94140,0x522e01fa,0xeea5e426,0xb39bf031}},	// [1670] _başların, _alavelel, _fokusere_, _ፕላስቲክ_,
   {{0xb2181094,0xaa83e370,0x7ec3a330,0xa497d2e7}},	//   _элементи, _abazonge, _为汶川人民祈福_, _angaupez,
   {{0x520192c1,0x88645443,0x96530037,0xcbd57009}},	//   _resim_, _унивирси, _tamaşaçı, _ikambiso_,
   {{0x4772b0c8,0xf2cf3369,0xc378e008,0x92cd94bc}},	//   _загрузкі_, _abhorre_, _ullakan_, _ongoing_,
   {{0xc49c23c7,0x22906281,0xa3ead47b,0x292e911b}},	//   _শক্তি_, _kulan_, _aputaghi_, _америци_,
   {{0x64b60166,0x0beec225,0x7c55262f,0x74e2814c}},	//   _kumpanij, _таков_, _vontade_, _সোহাগ_,
   {{0xb26461b8,0xcedae10c,0xada941a7,0x32e97230}},	//   _farlin_, _botheken, _debilisa, _bruinja_,
   {{0xcb7bd202,0x10d800a4,0xf2fcd343,0x1dbcc2db}},	//   _nungguan_, _domolail, _apogai_, _şyhmyrad,
   {{0xa249f2db,0xec6e10bc,0xe6d2611c,0xf378b184}},	//   _umumy_, _abarika_, _caipitil_, _anjaran_,
   {{0xe3eb70ce,0xe2556037,0x6d852263,0x8ae73101}},	//   _fiatal_, _iğlan_, _шуъбаи_, _kordinas,
   {{0x1d38f248,0x19c7c008,0x7386d193,0xf2486547}},	//   _ትሕዝትኡ_, _канага_, _anoren_, _gnomo_,
   {{0x204390df,0x5afc53a4,0x6e6790b3,0x1e06d009}},	//   _annuitan, _neurorne, _саммиты_, _просьба_,
   {{0x071ac155,0x5592b115,0xc3eae16f,0x97b630c8}},	//   _بىچارە_, _abondanç, _sentis_, _titulini,
   {{0xdf979056,0xf1b4116e,0x41317271,0x127f701d}},	//   _ditheriš, _израз_, _kontexto, _eranga_,
   {{0x9c4c7399,0x7386011d,0xc9aa1248,0x2c60b202}},	//   _akiweni_, _mairi_, _ሃለውለው_, _jujutan_,
   {{0x84e83050,0x56d323c6,0x384ce0ac,0x784c2065}},	//   _屏幕分辨率_, _manakohi, _알았습니다_, _ספוילר_,
   {{0x0d8530a5,0x62da557e,0x52484230,0x82b4d0ee}},	// [1680] _permulaa, _franske_, _jimme_, _plochu_,
   {{0xac6933c2,0xa485d2ae,0xb2019008,0x9d3b545f}},	//   _kivumbi_, _रामायन_, _mesih_, _majitele_,
   {{0xe27c12c0,0x52903127,0x425b046e,0x93866064}},	//   _yëngu_, _momani_, _kablig_, _abord_,
   {{0x527e935e,0x43b88124,0x32f0709c,0x92cb03c9}},	//   _haana_, _британиа, _achitti_, _tradit_,
   {{0x027f725a,0xa1c9217f,0x223b006a,0xd614b0c9}},	//   _granda_, _рости_, _melewati_, _складаєт,
   {{0x330e5424,0x227f720f,0xd63dd009,0x350511ca}},	//   _heralds_, _iranda_, _появлени, _پُھٹاں_,
   {{0x153c3527,0xa27e90ef,0x5cefe063,0xd2906027}},	//   _recherch, _maana_, _مسئوللری, _vulan_,
   {{0xca0f54e4,0x1b0f508a,0xe2906176,0x14d3c2a0}},	//   _ngaphand, _ngaphant, _wulan_, _پاسپۆرتی_,
   {{0xa38605ba,0x329070a9,0xa1507142,0xee9dd229}},	//   _ibiro_, _kunan_, _veleposl, _частично_,
   {{0x838794a5,0xfc95b438,0xb61c2199,0x23860327}},	//   _misra_, _تايلند_, _statudol_, _abiro_,
   {{0xd2b21009,0xe58c3357,0xaff1024e,0xc29031ba}},	//   _связи_, _annualiz, _الحسنه_, _domani_,
   {{0x73f8f0d1,0xd7f1f0fb,0x63168086,0x427e61ab}},	//   _akhume_, _ग्राह्यं_, _sunnking_, _nyong_,
   {{0xf27e648d,0xff61f2c9,0xf27e9045,0x89687437}},	//   _iyong_, _çünki_, _baana_, _allianse,
   {{0x3a12d0df,0x7401e509,0x83d831bd,0x29f123d0}},	//   _isabilit, _solusyon_, _त्रिपुरे, _автын_,
   {{0x82d884e7,0x6200d1f8,0x4c5a8322,0x52da8364}},	//   _hokeja_, _obliku_, _baatili_, _baatilih_,
   {{0x5368a36d,0xcc7c1256,0x4378244f,0x2a2420c9}},	//   _快速引用第_, _amasaka_, _recarga_, _невеличк,
   {{0xf93440f3,0x7b5b6155,0x8da5f1fa,0x3b1fc40d}},	// [1690] _esaminat, _ھەرۋاقىت_, _etinhomp, _galabsan_,
   {{0xd38694fa,0x15b9216e,0x6d00d2c3,0x66b872f2}},	//   _gaari_, _нормална_, _ءپاني_, _bilavasi,
   {{0xc27ee2cf,0xd20ec13c,0x92d852e9,0x3afce09c}},	//   _isinya_, _закан_, _boqoypu_, _biiroole,
   {{0xa3866327,0x9489e2f3,0x1b23e2fc,0x339891d9}},	//   _abore_, _проглаше, _простору_, _сапарлар,
   {{0xe58b430d,0x3262c1d9,0x566e714f,0x702c2275}},	//   _approvaz, _تالقى_, _सामान्यम, _ақлап_,
   {{0xeecd5171,0x9813c0b9,0xae46c3bf,0xe30e4392}},	//   _wasilian, _батылдыр_, _агенцият, _seratus_,
   {{0x84e8e135,0x1b37f00f,0x7c46e041,0xb30e4445}},	//   _ንምልካዊ_, _читайте_, _ډرامه_, _peratus_,
   {{0x92901208,0x377f1155,0x72ca6142,0xeee2801d}},	//   _athar_, _ئەگرى_, _ploda_, _bashfuln,
   {{0xb27ef1e0,0xec141264,0xb8fc547f,0xfabb6248}},	//   _magno_, _بوينت_, _alcanzad, _ንከይፍኖ_,
   {{0xdf55809a,0x5a887352,0x95198141,0xa33d12fd}},	//   _турмуши_, _ئینترنێت_, _белент_, _دیبان_,
   {{0x6a95c06a,0xd29ec09a,0x33548630,0xe565002f}},	//   _स्वीकारल, _зигар_, _objetos_, _بنجاري_,
   {{0x62fe4064,0x52d08631,0x8ef8e022,0xe76dc0b3}},	//   _petites_, _सांत्वना_, _министір, _романияд,
   {{0x0b1cb482,0x5a918197,0x5ae6349f,0x5f991024}},	//   _kuzakwab, _kesinamb, _estudant, _वस्तुतः_,
   {{0x0838d2f4,0x274be1ba,0xd2d882df,0x0e9b82c6}},	//   _үсний_, _svantagg, _dikeva_, _defuncte_,
   {{0x6b39e217,0xe4da120e,0x3c64414a,0x5577e264}},	//   _проектла, _босна_, _amburre_, _indinéis,
   {{0xbbea561e,0x72c91063,0x32fdc11b,0x3386d113}},	//   _underskr, _tiklash_, _изложби_, _miers_,
   {{0xb24891f8,0x6b138026,0xcdebb0e5,0xc20272b7}},	// [16a0] _znamo_, _bedanken_, _najbliżs, _jaridu_,
   {{0xc387f39a,0x1c1b94bb,0x6e434262,0xeeb1327c}},	//   _biuro_, _melancar, _ambasade_, _danskere_,
   {{0xc286f3af,0xe45e2105,0x43052215,0xe264a1fa}},	//   _ancienz_, _מוזעאם_, _ustavom_, _enkoveni_,
   {{0x2e5630b8,0xb2907114,0x830d40c1,0x3a0a12b1}},	//   _шайтон_, _arnab_, _masakit_, _lasanmbe,
   {{0xeceec00f,0x43a79140,0x638692ae,0xd3fa51fb}},	//   _америки_, _балигъ_, _paari_, _bitume_,
   {{0xee5a3358,0xbb1380f5,0x1c37e0de,0x03f24270}},	//   _варианто, _gedanken_, _аудиторд, _persepsi_,
   {{0x04665326,0x2999d009,0x11a012c4,0x697c5022}},	//   _emsebenz, _ребенка_, _pancasil, _форумыны,
   {{0x923fb04b,0x5248f004,0xc2490431,0x29cd9374}},	//   _hammasi_, _ngimpi_, _champs_, _hurongwa_,
   {{0x07f6d078,0xe3f4713f,0x72f27231,0x72ca93c1}},	//   _تعبّر_, _listed_, _अवसरवादी_, _glada_,
   {{0x727e9176,0xc5d9d1ba,0xbec9c1c4,0x62da5036}},	//   _hyang_, _анализи_, _spindles_, _neanche_,
   {{0x6249f332,0x8241e0db,0x12ca92db,0x8ae5512a}},	//   _houma_, _именлеге, _alada_, _claudent,
   {{0x7386d209,0x537d4057,0x96971226,0x9249f525}},	//   _ohere_, _departe_, _प्रवर्द्, _kouma_,
   {{0x9431312a,0x87b7814c,0x825b70e8,0x6103d251}},	//   _banchero_, _ঊশৃংখল_, _mialem_, _роднина_,
   {{0xaeb5c3e3,0x50d2b134,0x7697121d,0xd735c0be}},	//   _prezanta, _asgalluk_, _प्रवर्त्, _prezanti,
   {{0xc177413a,0x52ca9003,0x6fd63415,0x4d133632}},	//   _bilakpel, _elada_, _вирусны_, _batohoze_,
   {{0x027f22d4,0xf6399115,0xd27e91ab,0xc73ee292}},	//   _wayna_, _ionizaci, _nyang_, _искандар_,
   {{0x046650ed,0x42ca0120,0x827e9110,0xd27f258e}},	// [16b0] _umsebenz, _noida_, _iyang_, _tayna_,
   {{0xe928844f,0xa386d0d3,0xff5e5258,0x46ab01ca}},	//   _центар_, _tiers_, _sisamann, _آفتابٕچ_,
   {{0x6a8521a9,0xe27f7183,0x2156b10e,0x4ab870f4}},	//   _بولدى_, _franca_, _वकीलों_, _مۈشكۈل_,
   {{0x50b80009,0xb786127f,0x72a06230,0x5709c443}},	//   _получить_, _واشنتن_, _gerben_, _девиси_,
   {{0x820e115e,0x3855b00e,0x2503008d,0xb43e7102}},	//   _татан_, _birlikdə_, _avumbirh, _широкого_,
   {{0xd3d200bb,0x375e315d,0x9e989050,0x3af0325b}},	//   _педагогі, _همسفر_, _一九九七年_, _lærisvei,
   {{0x9380617d,0x128c1185,0xee14038f,0x0816e352}},	//   _suurta_, _alakija_, _inderdaa, _ئاندریا_,
   {{0x3386911d,0xc386d0d3,0x343ec0dc,0xe26da16b}},	//   _abare_, _viers_, _даана_, _ajpod_,
   {{0xa386d209,0x3af49025,0x10f46105,0x2d0721ba}},	//   _chere_, _adelakun_, _װאָסער_, _svolgere_,
   {{0x4ea3218a,0x7290d076,0x527f702d,0x68edc09a}},	//   _suplimen, _aloali_, _franza_, _болалайд,
   {{0xaa1ec0d7,0x10eee321,0xeff92271,0x744d13bf}},	//   _диния_, _annikill, _ilustrač, _машината_,
   {{0xa3f8335f,0xe94ae633,0x0c62a155,0xd306212e}},	//   _tomuto_, _pattedyr_, _دەھشەت_, _podatek_,
   {{0xd346000a,0xd3ce9399,0x27d92024,0x427f20c7}},	//   _רישיון_, _chavi_, _महाकपिः_, _mayno_,
   {{0x326e1473,0x4494330d,0xd1f4b1bc,0x62ca95b5}},	//   _napoli_, _skillful_, _شئنحۇا_, _vlada_,
   {{0x32a620cc,0x72fd021f,0xb3f3c405,0xa7bd6026}},	//   _hombre_, _meager_, _أطباق_, _bevestig,
   {{0x0cc3a0c4,0x98f8e1b8,0x4c1b9146,0x3290a110}},	//   _abahungu_, _txtadded, _pelancar, _auban_,
   {{0x727f4256,0xdd354120,0x51b920f6,0x7c910004}},	// [16c0] _irenga_, _barnhart_, _пермана_, _angusing_,
   {{0xa40460f6,0x227e9316,0xb261a493,0xd3ce91dd}},	//   _экранлар, _syang_, _cíosa_, _ikava_,
   {{0x53ea7245,0xdc190115,0x0c0b7333,0xec70105c}},	//   _umntu_, _turquia_, _skupina_, _uporabu_,
   {{0x75a91235,0xe0216330,0xf2fcf40f,0xa18a901c}},	//   _терито_, _électron, _byggt_, _عزیزاللہ_,
   {{0xac534085,0x8ac6531f,0x214bf2e9,0xc3076146}},	//   _সৃষ্ট_, _previame, _binoblah_, _lombong_,
   {{0xdd90f0d8,0x4af0c292,0xde24d290,0xd27e9033}},	//   _seallada, _سیاستی_, _पूर्वावल, _azans_,
   {{0x2823e1b6,0xa99a4059,0xaa2322f3,0x8a0b00c2}},	//   _འབྱིད_, _ያነጋገርናቸው_, _порекла_, _baratuoa_,
   {{0x0962d010,0x60511192,0xe84b6031,0x39fa039b}},	//   _colourle, _зворыкин_, _የአምልኮ_, _boripana_,
   {{0x9ec241d4,0xb575105d,0x9b130057,0x34317229}},	//   _avannaan, _instrucz, _антиромы, _successo_,
   {{0xd290613b,0xbb7f1346,0x2311a212,0xa537e328}},	//   _atlat_, _ngaranna_, _عبدالکري, _titirauh,
   {{0x92fa42fa,0xe28521d1,0xd7cca2bc,0x4c6e44b5}},	//   _madhila_, _mushumo_, _krypteri, _geerida_,
   {{0xb478d4b2,0x959bf059,0xb2ca922a,0x3c21e155}},	//   _bongdaso_, _መገናኘት_, _mlado_, _мәхмут_,
   {{0x3d8e6257,0x8c696048,0xbc241065,0x93b9d00f}},	//   _süleyman, _svitavy_, _הנונסנס_, _баннерна,
   {{0xca98409a,0xc7bef030,0x4290f246,0xf796517a}},	//   _مۇراسىمى, _استالیف_, _aliali_, _murmansk_,
   {{0x938693f4,0x127ee043,0xb21671ca,0x298802f4}},	//   _haart_, _kuinka_, _کاڈى۪ن_, _exekutat,
   {{0x82f391a5,0x5517c141,0x52a60113,0xab9612ac}},	//   _инандата, _ваклады_, _mīklas_, _عوبێد_,
   {{0x8261a493,0xf37a909e,0x8290d078,0x5a8651ec}},	// [16d0] _píosa_, _koeficij, _galair_, _evennman_,
   {{0xd6ceb15f,0x9f322148,0xa13c7276,0x81347105}},	//   _kamagili, _sabenern, _اقليتن_, _שטײגער_,
   {{0x60e4e121,0x3adec22d,0xa2568240,0x0f2fb191}},	//   _आइसीसी_, _forumove, _sólin_, _badevatn,
   {{0x3832c0b5,0x727f7185,0xdaf07225,0x0224e3a5}},	//   _جالىن_, _afanan_, _colunist, _anikwe_,
   {{0xfd3e517a,0xb2fe5289,0xa9aac44c,0xbb42d09c}},	//   _skrivast_, _skrivas_, _болив_, _babbalis,
   {{0x953230e0,0xf26ce039,0xd995346a,0x0215346a}},	//   _प्रतिभात, _eriong_, _abahlala_, _abahlali_,
   {{0x1e6c10ce,0x9d13f0bc,0x624954e7,0xc2026205}},	//   _تیمور_, _ahasewer, _ziemas_, _shrill_,
   {{0x57bb201c,0x395fa0de,0xe3f46123,0xb983517d}},	//   _citromai, _ايىقانىڭ, _foutou_, _linkitet,
   {{0x07b2c0e5,0x837b031f,0x925b42d7,0xa36f001a}},	//   _अनुत्तरि, _estando_, _beelwa_, _malgrat_,
   {{0xf98e11e2,0x120e1030,0x3a46606a,0x2e63f16b}},	//   _қариб_, _ҳасан_, _संरक्षित_, _teknoloġ,
   {{0xc7a91041,0x5224e387,0x43ce92fa,0x79623277}},	//   _دوستانو_, _kankan_, _chavo_, _постави_,
   {{0x3386001e,0x67a58271,0xc201908c,0x0355a23f}},	//   _abira_, _komentov, _besit_, _arverns_,
   {{0x6c05e378,0x8c92806a,0xfdb4c342,0xcc67c0d4}},	//   _forseti_, _अवरोह_, _لوجود_, _dulunya_,
   {{0x73b0622e,0x9c60a2e9,0x6632103b,0x05231040}},	//   _treviso_, _biyudha_, _aphindzi, _chungtah,
   {{0x13dd7039,0x0290d27d,0xb4e5f0bb,0x8859309a}},	//   _chawla_, _mudan_, _страхови, _көрәй_,
   {{0xa28471c9,0xee1a70e5,0xa047c370,0xfe0292a9}},	//   _alghero_, _potencja, _такозои_, _wunderba,
   {{0x03b0a007,0xd1954218,0xa38604e7,0x37d931e3}},	// [16e0] _القاعدہ_, _مناسبات_, _vairs_, _angstanf,
   {{0x1f6fa1df,0x1e00636b,0xd290133e,0x12ca92a6}},	//   _המדרש_, _gemeinsa, _zuhal_, _mlade_,
   {{0x02480086,0x37c5f358,0xb226335b,0x2c5da11b}},	//   _animi_, _страдани, _валюти_, _учинити_,
   {{0x63ea5036,0x0d795248,0x138691cf,0x62c24067}},	//   _volte_, _እንተዳኣ_, _waarm_, _epelata_,
   {{0x42882019,0xe07d3299,0x45b0b203,0xb53333d1}},	//   _התאחדות_, _такса_, _abaserik, _afunekay,
   {{0xfbe55093,0xab0e2263,0x42efd278,0xf248f3b2}},	//   _dipengar, _пизишкон_, _eilifia_, _dogmu_,
   {{0x238741eb,0xdcb4d20c,0x7290d15e,0x2d741180}},	//   _aneren_, _ndayakir, _dudan_, _このサイトについ,
   {{0xfc00b21e,0x95c682fe,0xc3f46266,0x6e4eb40c}},	//   _spesies_, _abepisik, _toutou_, _jamadila,
   {{0xc2906411,0x20733041,0x39e4e1e7,0x0201925b}},	//   _julai_, _رهبرۍ_, _dokumend, _hesir_,
   {{0xe8fd420e,0xa2cae0fb,0xe9fb3172,0xc200f196}},	//   _поставен, _sindhu_, _mehutahu, _begiz_,
   {{0x2386d544,0xa3866044,0xdc5ec395,0x99df009a}},	//   _mbere_, _maori_, _akatram_, _سەندە_,
   {{0xdb8b9292,0x2945a05e,0xf2879263,0x607a6227}},	//   _bilimlar, _etolumat, _миллиюн_, _회원가입시_,
   {{0x4386d48c,0xd2cc0634,0x5273b12a,0x27a812ca}},	//   _obere_, _møller_, _horribil, _сурамжыл,
   {{0x3201f148,0xbbaaa1ca,0xa69a9500,0x0290a4b1}},	//   _deuih_, _پروازس_, _ingiltər, _jubab_,
   {{0xaaabb026,0x23f8b3a7,0x0316e07c,0xd291a1d5}},	//   _비밀번호를_, _poduka_, _ubizwa_, _otpad_,
   {{0xb41282f4,0xfa43b072,0x39f8d222,0x5e405264}},	//   _шонхор_, _интелиге, _kristind, _وجامعة_,
   {{0xb2019238,0x03cee233,0xd2b9b065,0x82a5e287}},	// [16f0] _resis_, _anivon_, _הקוסם_, _служыў_,
   {{0x06d1a635,0xb27e0256,0xc65130f7,0x3f5f1085}},	//   _कोसिस_, _nyina_, _无标题文档_, _শহরহানর_,
   {{0xd27ef1e0,0xb224e2ee,0xb00f110e,0xefa4b0c9}},	//   _magna_, _yankin_, _zawartoś, _insekter_,
   {{0xc2019341,0x32352048,0x9aa4400e,0xe387f10e}},	//   _desir_, _olomouc_, _tikintis, _biura_,
   {{0xb2ca946d,0x32924308,0xd38660a4,0xd2d95308}},	//   _glade_, _aswaku_, _iboro_, _engeta_,
   {{0x53866117,0x1d33b328,0xe8616180,0x91f5e102}},	//   _aboro_, _tariumut_, _と思いました_, _судова_,
   {{0xe386d2e1,0xb27f719e,0x41c7305b,0xca091124}},	//   _ibere_, _oranga_, _داستاني_, _аиҕьтәра,
   {{0x7be10321,0x7c0502cb,0xc3ee604c,0x50b8c0d7}},	//   _taperser, _دسترخوان_, _مسافران_, _ослан_,
   {{0x4860b183,0xe37cb1d0,0xb2eb6195,0xb624a12f}},	//   _persones_, _lesabre_, _mawindo_, _كىمئارتۇ,
   {{0x32b22080,0xe3eba064,0xa2ca95b5,0x82e93231}},	//   _roldán_, _textes_, _vlade_, _biznesu_,
   {{0x5291705e,0x0e0012ff,0xe2caf2ae,0x92f3a30d}},	//   _aeaaia_, _bibechta, _leidis_, _artiklu_,
   {{0x920273b2,0xde96301a,0x0ac66463,0x9eb0e284}},	//   _marinu_, _قىمىز_, _serville, _volumine_,
   {{0x9377c1c7,0x7215c1ca,0xa57711ea,0x15871548}},	//   _مىسال_, _صداقٔژ_, _маркел_, _дискул_,
   {{0x1290921c,0x28a2233c,0xcbee10c8,0x3e5100b0}},	//   _lokali_, _انتظارنی_, _дарог_, _membiaya,
   {{0x624b317a,0xf629f16b,0x52025040,0x343000d2}},	//   _খাদ্যক_, _antiossi, _botich_, _polítiqu,
   {{0x5386d01e,0x3ea4c04b,0xd2cc0636,0xdae6014c}},	//   _abere_, _улардан_, _gäller_, _ছ্যাকা_,
   {{0xec686172,0x0c5cb290,0xe410b1eb,0x92d9513c}},	// [1700] _swerego_, _पावेल_, _verstoen_, _angeta_,
   {{0xc80ed16e,0xae6181c7,0x385f822e,0x4401347e}},	//   _историју_, _ﺍﻟﻭﺍﻗﻊ_, _emiratos_, _gaireben_,
   {{0xbc7680e9,0x5290d04d,0x9b45e0ac,0x7d8d6308}},	//   _guarani_, _rudan_, _행정정보공개_, _ahivanhu_,
   {{0xf51e1256,0x7b47d296,0x4ece5231,0xe133d2ac}},	//   _birorosh, _гандуми_, _zaginion, _حقووقی_,
   {{0x2df48241,0x1248d3af,0xaf64a06e,0xd6d6810d}},	//   _економис, _boemz_, _प्रकाशना, _крычаць_,
   {{0xf382310a,0xda93e022,0x7c1bd1b6,0x337b44e7}},	//   _قافلي_, _ءﺑﯩﻠﯩﻢ_, _allaħare, _saprotam,
   {{0x0d030146,0xc2c300bf,0x6c19f0f7,0x8b626003}},	//   _muslimat_, _muslima_, _九三学社四川省委, _ओहिना_,
   {{0x96d441fa,0x0d3a1225,0x1c1b61ac,0x120190b9}},	//   _tumbulux, _contrári, _famantar, _kesip_,
   {{0x0ec32554,0x8cf28518,0xd30b216e,0x3c67b137}},	//   _akunngan, _sentyabr, _октобар_, _sobrang_,
   {{0x23a2508f,0xf236e24a,0x1248c480,0x4a4492ab}},	//   _helpu_, _krijen_, _khomob_, _naudinga_,
   {{0x0b60f513,0x5c0c72a5,0x22fc6065,0xd9aa144c}},	//   _permanec, _adarọ_, _ופנטהאוז, _хорио_,
   {{0xe983a2bf,0x1203a285,0x3190a007,0x4a5e7266}},	//   _abahinga_, _abahingi_, _القدیر_, _fekefeka_,
   {{0x35be2441,0xa27ff148,0xda862018,0xe00e23d0}},	//   _други_, _maung_, _марчин_, _бригадын_,
   {{0x0296c3ba,0x94e43009,0x1c765113,0xb5dad088}},	//   _suradnji_, _случаев_, _sarunas_, _akibatny,
   {{0x21408019,0x227ed10f,0x111b5276,0x8709201a}},	//   _האריקעין_, _szent_, _سرپرستي_, _берилип_,
   {{0x83b6e260,0x126f5067,0xa6a88041,0xe6d1a0ea}},	//   _halvdan_, _mirimiri_, _بېنظير_, _कोशिस_,
   {{0x80969352,0x6827a516,0x0de7a516,0x69031119}},	// [1710] _دارانی_, _rodinný_, _rodinné_, _kalaaleq_,
   {{0x23877071,0x59ee831a,0x66f200c0,0x3075c2b5}},	//   _swarte_, _parnaiya_, _bastiguè, _impassio,
   {{0xc78c4041,0xb8ccd225,0x1346c5a8,0x4386012d}},	//   _اطلاعاتو_, _necessid, _brodkas_, _ocirc_,
   {{0x3e53616e,0xf24841cd,0x12d833a1,0x02918424}},	//   _дефиниса, _timme_, _kimera_, _murag_,
   {{0x6a0ef39f,0x5e4ef07e,0xb90ef0f5,0x43ea74e0}},	//   _behandle, _behandla, _behandlu, _sonte_,
   {{0xd27ed4a4,0xd91ae09f,0x2a72a1b3,0x9cae1208}},	//   _nyene_, _асфальтт, _separava_, _farsaing_,
   {{0x553641ba,0xe3a25113,0x13635040,0x8d87c2ac}},	//   _страхотн, _telpu_, _bongach_, _خشانێک_,
   {{0x426db2b8,0xd79fb085,0x5312208c,0x526460b9}},	//   _geword_, _আবূসামীহ, _kombuis_, _notlar_,
   {{0xc2d8c1a5,0xb2ca9281,0xee96309a,0xe93d02ac}},	//   _kulesi_, _caalami_, _تىزىپ_, _شقارته_,
   {{0xa269410a,0xa443d252,0x09917221,0x96b0d0d0}},	//   _زوردار_, _ئزىلدۅ_, _abahlele, _taigurni,
   {{0x9b1b60ca,0x5302f139,0x1169c23c,0xc3f8c225}},	//   _samantab, _abdatuu_, _мелодия_, _coluna_,
   {{0x620261d8,0xf8f7b131,0x3485230f,0x12fe2210}},	//   _katilu_, _hidayatu, _विषारी_, _aapgay_,
   {{0x248060ea,0xfe5b316e,0x3cf74196,0x0e105291}},	//   _विभाजन_, _странке_, _partehar, _الامکان_,
   {{0x74144248,0x1306212e,0x02eac522,0x3bdf82fa}},	//   _ንበጻሕቲ_, _dodatek_, _moznost_, _achember,
   {{0x0d8ea0f7,0xa9dd0241,0x397b101b,0xa394d3fa}},	//   _可以并处罚款_, _конестит, _усуллары, _amoses_,
   {{0x3308354e,0xb9c53299,0x99411472,0x92e921f2}},	//   _trabaho_, _riservat, _populyar_, _minnast_,
   {{0xe4cea4ea,0x629061ab,0xe290c3b5,0x8c9320f4}},	// [1720] _concello_, _iulat_, _relato_, _شايار_,
   {{0x57314009,0xc25b0094,0x78c991bc,0x3365935e}},	//   _страницы_, _atalak_, _чаралард, _sangano_,
   {{0x73f8e637,0xbc51e44b,0xd85150ff,0x4b18f0f4}},	//   _ponuka_, _hantera_, _willekeu, _ئەزرائىل_,
   {{0xa1648601,0x7369b27a,0xb25ae394,0x52903004}},	//   _tvnoviny_, _likvidác, _imilla_, _rujak_,
   {{0xed77423e,0x555a20b9,0x2a7b8180,0x2056a2ac}},	//   _brumaire_, _таквалык, _クリエイタ_, _بچوکتر_,
   {{0xa2924213,0x82da44e8,0x3d05f098,0xb8c01210}},	//   _jawart_, _abanale_, _amarorer, _accessed,
   {{0xe80bf248,0xcc724333,0x8248935c,0x02cad00f}},	//   _ፕሮፈሰር_, _starost_, _anamu_, _kledd_,
   {{0xa2ca617e,0xa291608d,0x0ba3f262,0x62d77038}},	//   _booda_, _angari_, _amakoper, _andosol_,
   {{0xff73e0f7,0xac04f0f3,0x8290146e,0x028c8071}},	//   _编译或摘编的目的, _forsyth_, _nrhau_, _stikken_,
   {{0x22e92437,0xd6d3410e,0x0c34447d,0x027ff1d8}},	//   _finnast_, _मैजिक_, _achanaic, _saung_,
   {{0x4f9ac0a7,0xb26f5185,0xce1be04f,0x07cff252}},	//   _čedomir_, _biribiri_, _pergurua, _اتكىرتكا,
   {{0xe29163c6,0xf496f455,0xb579a352,0x690b307b}},	//   _engari_, _aberrasj, _موسیقای_, _barbadad,
   {{0x32483071,0x529fe12b,0x83053264,0xb7d1f3df}},	//   _nommen_, _kpojoro_, _أوتار_, _flygning,
   {{0x52ca91de,0x1a7ca223,0x52486051,0xd52f813b}},	//   _mladi_, _kutafuta_, _roomy_, _nipilioh,
   {{0xbbd16187,0x93eae3e8,0x3c7d44dc,0xdd8461b3}},	//   _wanderer, _contas_, _spurdir_, _excedite_,
   {{0x02483169,0x96fd7152,0xe2c0c140,0x329270f3}},	//   _kommen_, _проблемы_, _аннан_, _casale_,
   {{0xbc683638,0xf2b3716e,0x4abc92fc,0x8a7091f6}},	// [1730] _hebrifo_, _studija_, _областим, _फ़ोनों_,
   {{0x9c933041,0xd29160b0,0x52020039,0xa2e92179}},	//   _قاچاق_, _segala_, _casius_, _finnist_,
   {{0x323001d8,0xd1501221,0xe38d13bf,0xfd6b7426}},	//   _utamana_, _impendul, _критерии_, _nummeret_,
   {{0x73f472c1,0xc27e916c,0x6c358128,0xf378e228}},	//   _destek_, _vyann_, _cowardic, _dolanan_,
   {{0x826e71d2,0x6060d11c,0xc26c1030,0x0ec3340f}},	//   _baroli_, _substain, _кайтариш_, _barnalan,
   {{0xb3eae0b2,0xda167187,0xb5540105,0x071751e6}},	//   _mentsi_, _makamaka_, _שטרײַמל_, _ahesuṃ_,
   {{0x42c50173,0x19cae340,0x89c30076,0x3d7eb127}},	//   _millete_, _моментан_, _isemaela_, _iseleiwa,
   {{0x4287a0fb,0x7a6c044d,0x52caf038,0x325ae278}},	//   _पर्यवाप्, _usporedb, _koalisi_, _epiloo_,
   {{0x627ff2ab,0x48f36022,0xac60e445,0x96818003}},	//   _kaune_, _احپارات_, _bulusan_, _टीदार_,
   {{0x726d84f6,0x1d7f818c,0x3039c1ba,0xb582a096}},	//   _skroz_, _ngamanye_, _напослед, _وینڈوز_,
   {{0x0f31514e,0x3950921f,0x683f709a,0x6daf60de}},	//   _গণকযন্ত্, _ankleide, _قۇرامىغا_, _ادوسكىنا_,
   {{0x9bedf236,0x46b920ce,0x438602f9,0xa30dc383}},	//   _ograniče, _عبداللہ_, _acira_, _alvorlig_,
   {{0x89b14381,0xfcfa613f,0x5200318a,0xd2cad22a}},	//   _garantía_, _חחחחחחחח, _lumina_, _glede_,
   {{0x33bbc004,0xdc75821c,0xf7ed313a,0x4341104c}},	//   _دستان_, _ourself_, _leranbag, _منوال_,
   {{0x52a07205,0xa7aa7086,0x5956a1d4,0xb2fce1d8}},	//   _tarbes_, _cortisli, _sullinne, _bungsu_,
   {{0x355661b5,0x0bd6601a,0xd73203fb,0xb896b214}},	//   _تۇرماي_, _تۇرماق_, _dialektv, _ءﺗﯘﺑﯩﻦ_,
   {{0x400c611b,0xabe84031,0x5111815d,0x8c78a09b}},	// [1740] _privredn, _ይሻለኛል_, _ریسیور_, _pärmik_,
   {{0x7d03b2db,0x628d90a7,0x420033ea,0xb1be20f4}},	//   _kanunlar, _čikago_, _kumina_, _شەرمى_,
   {{0xb38053a8,0x1f2c1272,0xf488a180,0x25a3921a}},	//   _dourug_, _ernestin, _プレイステ_, _колеру_,
   {{0xadffa07c,0x12d980db,0x62d60065,0x397b2012}},	//   _ubudosip, _anyesa_, _פילינג_, _خراساني_,
   {{0x227ef171,0x39669287,0x63eb828b,0x02486209}},	//   _msingi_, _простыя_, _herte_, _nnomi_,
   {{0xec2be031,0xcf259033,0x7e798140,0xb248648c}},	//   _ውድነትን_, _angleter_, _ministrı, _inomi_,
   {{0xa46675fd,0xb2906008,0xbef0b293,0x2e21614d}},	//   _hyperinz, _gulak_, _abakorin, _कमर्शियल,
   {{0x328ba0fb,0x63866463,0x7345404d,0xcc5f501a}},	//   _aanandam, _abora_, _aiseige_, _اسپاپتا_,
   {{0x22489299,0xb290d05c,0x9e3ba1a0,0x2243329f}},	//   _siamo_, _sudac_, _diplomis_, _asambeli_,
   {{0x5eed90d2,0x6db36216,0x3e54f418,0xf29062c1}},	//   _маселеси_, _chantuna, _ababhada, _kulak_,
   {{0xae9a4259,0xd2fb50db,0xff9a40ae,0xa96d2244}},	//   _bildirib_, _mathata_, _bildirir_, _purintat,
   {{0xe4afb46c,0xd3ea5441,0x4a83e08a,0x42899105}},	//   _ফোল্ডাৰ_, _molte_, _abazinge, _אַכצן_,
   {{0x83004246,0xd9fe507b,0x8db95083,0x984542c0}},	//   _lumanai_, _angafoot, _endavant_, _baatinub_,
   {{0xa6b0102f,0x7d73b39e,0x4a13a1fa,0x32484261}},	//   _مجرمين_, _chimpupa, _angatshe, _dimmi_,
   {{0xfe4c3128,0x32881124,0x5c27a1e8,0xde1a5009}},	//   _broadest_, _агроаагл, _примеры_, _создании_,
   {{0xc29180a8,0x62cad0fd,0xe372b4de,0xbb7781ba}},	//   _stran_, _plede_, _japaneg_, _crescita_,
   {{0x12907004,0x7a167045,0xe2027198,0x65ce4093}},	// [1750] _lunak_, _bakabaka_, _assine_, _kurangny,
   {{0xeb6c40d2,0x5f24745d,0x7c527195,0x62906100}},	//   _terrassa_, _pište_, _mbatata_, _bulak_,
   {{0xffc01101,0xc3451097,0xfd8b33d2,0xb25af218}},	//   _transpor_, _vinduet_, _azimutha, _seilbh_,
   {{0x48b6c041,0x508d9065,0x8394f29e,0x52c275a0}},	//   _برلين_, _רבעון_, _pensez_, _anglija_,
   {{0x0135d241,0x5a5d009e,0x82dd0215,0xad06807f}},	//   _економие, _singlova_, _singlovi_, _иуашәшәы,
   {{0x0290d2a1,0xfc46e3b9,0x8d92f2c0,0x42bb0111}},	//   _sudah_, _گرامی_, _alawtiku_, _komence_,
   {{0x7bee1152,0x01b03276,0x32f3030d,0x45c0449e}},	//   _часов_, _جنرلن_, _relatati_, _armadail_,
   {{0xa3eae159,0xe27e9182,0x0290d1f3,0x94c614cd}},	//   _fontos_, _ayane_, _budai_, _asociado_,
   {{0xec278496,0x255120f7,0xc7bf243d,0xdbb71326}},	//   _maharitr, _违反上述声明者_, _människa_, _akayikub,
   {{0x73019395,0x5851718a,0xcb69f17d,0x137a70ae}},	//   _adebone_, _recomand, _paremmin_, _imtahan_,
   {{0x73eba248,0x9054f221,0x52f301f3,0x838691cf}},	//   _jepte_, _aluseben, _felirat_, _waart_,
   {{0x8e2722f3,0xd730d17d,0x8248d303,0x72918113}},	//   _интереса_, _mielikuv, _boomen_, _otram_,
   {{0xe2cad2ef,0xa86e51fd,0x69aa3248,0x2c0ab140}},	//   _goede_, _tarihind, _ይኽእልዩ_, _проектын,
   {{0xb2906250,0xb5c13022,0x326951ca,0x3e3742df}},	//   _iulai_, _жарқын_, _ہوشدارن_, _dalagata,
   {{0x6278d278,0x8386004a,0x73d1e3d9,0x63d69358}},	//   _komisoni_, _mbiri_, _baithepi_, _авторско,
   {{0x6be04210,0x4bd3b290,0xa8aa61e2,0xb21180af}},	//   _ommentsc, _एरिया_, _баландпо, _おすすめ商品を見,
   {{0xee002065,0xb28cf601,0x029034a7,0xbc01e0f9}},	// [1760] _המדריך_, _archív_, _mamata_, _næstan_,
   {{0xf29060b0,0x137a3056,0x9e46814c,0x8db7a21a}},	//   _mulai_, _tebanyo_, _ধানঘরা_, _рабочых_,
   {{0x3277a1f7,0x5667806a,0x73869181,0x44847116}},	//   _радиосы_, _नुकसान_, _ibara_, _झुलावऽ_,
   {{0xb3860045,0x43eae198,0x908cf252,0x602532d1}},	//   _abiri_, _pontos_, _тартипте_, _شوکری_,
   {{0x8213122e,0xf9f0c228,0xc8c832d5,0x4ef2506a}},	//   _vechta_, _مونالیزا_, _casruisg, _सिक्युरि,
   {{0xe14172eb,0x625b419a,0x2e9b80be,0x42d911ce}},	//   _apóstol_, _apelio_, _sistemit_, _docena_,
   {{0x626461d0,0xd2f620c3,0x859bd3c9,0xb340519f}},	//   _kotler_, _nadimak_, _paulatim_, _areedaa_,
   {{0x13a701d9,0x4f18a102,0xcb357248,0x9313146f}},	//   _سىلكىندى_, _правопор, _ኣይንተሃመል_, _lembrar_,
   {{0x397761b6,0x924a604b,0xa7b4d144,0x5a92b2e1}},	//   _manifatt, _umuman_, _achumani, _afonsans,
   {{0x7f26e024,0x5fa4b272,0x53869145,0xc217f227}},	//   _त्यक्त्व, _inserter_, _gbara_, _대한주택공사_,
   {{0xde520052,0x615cd1e2,0x62da0060,0xa103c180}},	//   _bibliotē, _худам_, _empero_, _をクリックします_,
   {{0xf386912b,0x527e618c,0xd2cad0be,0x72d560b1}},	//   _abara_, _eyona_, _ndodhi_, _intooda_,
   {{0xb622f1bc,0x02a06131,0x83565442,0xff63c3aa}},	//   _دەيبىز_, _diubah_, _acaesar_, _प्रकर्षा,
   {{0x3b6d30e1,0x42ec81fa,0xcc531008,0x245ae04b}},	//   _arboresc, _aswinge_, _adatdan_, _sirdaryo_,
   {{0xe290301f,0xfc00f1d8,0x1ea6c35b,0xb107211c}},	//   _kamata_, _prosés_, _кадрів_, _ضرورى_,
   {{0x09899222,0x484ac277,0x7293b22d,0xa933208a}},	//   _kunngjør, _топка_, _negatief_, _ضايعه_,
   {{0x03788304,0x93866271,0xf517a3c0,0x0f021008}},	// [1770] _sinaran_, _oboru_, _pharwago_, _акыла_,
   {{0xa2e7138f,0x14852121,0x8519e406,0x7b6c1105}},	//   _klanten_, _विकारी_, _situacio_, _שלימזל_,
   {{0xf317f004,0xb25ad579,0x9224e123,0x4290814f}},	//   _berbagi_, _millor_, _bonker_, _adhamo_,
   {{0x3c51e130,0xe2907039,0x33697083,0xd20ec05a}},	//   _tantara_, _kunai_, _كەتچۉ_, _талаа_,
   {{0x44fb714f,0x4248312a,0xafc1803e,0xc1a5f0e5}},	//   _ग्रामं_, _comman_, _aponbepo, _जनसम्पर्,
   {{0x425ae31d,0x43f900fa,0x8292c1b9,0x22cad0f3}},	//   _emilia_, _pobuna_, _педагогт, _inglesi_,
   {{0xa3ce9344,0xc8d57009,0xc20ec23c,0xe25f60f7}},	//   _shavu_, _yobulung, _казал_, _小说阅读网_,
   {{0x020044b5,0xdd14113c,0x53ea7639,0x73f8f2d7}},	//   _kamid_, _brasiler, _donte_, _bohula_,
   {{0x42a74105,0x6223c00f,0x54b49226,0x72fe5406}},	//   _סאפיסטיק, _являютьс, _albánie_, _skribas_,
   {{0xb10a011b,0xa99e700f,0x3dacc2ac,0xb6d62352}},	//   _католичк, _aksjealt, _واژۆی_, _سازمانه_,
   {{0xe27e00d6,0xd2e753e1,0x2c5b8133,0xcadd0214}},	//   _iyini_, _amennen_, _redukce_, _ايازدى_,
   {{0xb947500a,0x99c4e0da,0x99f6c2df,0xbcfdc358}},	//   _applicat, _diventat, _malumalu, _врачи_,
   {{0xa973e0eb,0xdd3d94dd,0x4248d238,0x07f9d2fc}},	//   _diminuit, _dedikert_, _chomas_, _знакове_,
   {{0xe3cef278,0xc3ea73f7,0x52d920a7,0xf38f127a}},	//   _vaivai_, _konte_, _hronike_, _partizán,
   {{0x7ed66111,0x82d92135,0x445ca041,0x931d61d0}},	//   _signifas_, _kronike_, _پاکستانه_, _mercora_,
   {{0xc9e5f4e7,0xcfe7e0db,0x5d0e23d5,0xb0f20116}},	//   _prognoze, _плакатта, _kjemiske_, _कउअवा_,
   {{0xa344a183,0x61b3c352,0x52008127,0x620142ab}},	// [1780] _directe_, _کادره_, _bukiya_, _ateina_,
   {{0xd3f1303d,0xb9bec0f0,0xe248e2b7,0x18349263}},	//   _lobunini_, _effectue, _ilimin_, _дуктур_,
   {{0x227e90c7,0x139401dd,0x927ff2a8,0xde3c0276}},	//   _iyana_, _amisi_, _rauna_, _گيسٽرو_,
   {{0x9ccc3004,0x22d913ab,0xb3866327,0x42003140}},	//   _پیانو_, _docela_, _aboru_, _armiya_,
   {{0xa9eb4078,0xc27862f6,0xc2f051ca,0x7290a118}},	//   _مراعاة_, _urundi_, _xiligii_, _hubak_,
   {{0xff0f1566,0xd28f1110,0x4200421a,0x59e80102}},	//   _mercados_, _merkado_, _namie_, _конкурсі_,
   {{0xa6679381,0x5545b063,0x6e89527f,0xa45a1142}},	//   _conjunci, _اندیوال_, _خوراسان_, _provizij,
   {{0x2dbf40ea,0xd5d9c35b,0x22a7820d,0x57aa42b9}},	//   _विज्ञापन, _правовог, _garbi_, _aetolisk_,
   {{0xb163427c,0x7223304c,0x431911b5,0xe41680a2}},	//   _ペタを残す_, _نگاری_, _ايلان_, _abangamk,
   {{0x85ad91b6,0x81b5b050,0xc262b14c,0x94adb5f9}},	//   _propagaz, _一名幸存者躺在一, _আসবাবপত্, _chladnok,
   {{0xb290711e,0xd2cad416,0x7290a30f,0x148760e5}},	//   _ornat_, _sledi_, _kubah_, _यायावर_,
   {{0x234ab059,0xfa0ba199,0xa27e9148,0xadbec030}},	//   _እንፈልጋለን_, _asiantae, _ayana_, _nalishla,
   {{0xf2a78113,0x3132f1e0,0xd1422057,0xeeda1271}},	//   _darbi_, _porttito, _атраг_, _pochopen,
   {{0x253f1218,0xd29121ba,0x736c44ec,0xeb875141}},	//   _استايل_, _locali_, _belgesi_, _deliller,
   {{0x84bed059,0x19c7c4c9,0x8b65844b,0xa248e175}},	//   _የተያዘውን_, _запада_, _billigar, _elimin_,
   {{0x229082df,0x8a0f6172,0x73410062,0x4c75f2b4}},	//   _makawa_, _nagadile, _aeseina_, _फोल्डर_,
   {{0x827f92e9,0x388ac0ef,0x2dbf4376,0x2a6fe3f9}},	// [1790] _basna_, _قسمين_, _firamare_, _etalings,
   {{0xe8e1c168,0x42f151b0,0x42014228,0x42caf428}},	//   _aangebod, _adminov_, _abdiku_, _leiddi_,
   {{0xa2497300,0xd9c2a381,0xd36f110d,0x6d8e7214}},	//   _alaman_, _apyetere, _adresą_, _қоректен,
   {{0xe2a784f1,0x72d5042c,0xd2d95404,0xd386663a}},	//   _carbi_, _tilladt_, _ongeza_, _sboru_,
   {{0xacc8f225,0xd6dc1381,0x72c503d5,0xc29030ec}},	//   _проширув, _carbónic, _tillate_, _bujar_,
   {{0x22ca90af,0xcd6d913f,0x490f824b,0xed370030}},	//   _plads_, _תינתן_, _nebandlu, _وکلات_,
   {{0xd0f5b27a,0x30ce32c1,0xcc70a438,0x827f811b}},	//   _najstarš, _edilebil, _akusoze_, _raznih_,
   {{0x13ea5036,0x0b5ac2e1,0x425b7138,0x26b2e004}},	//   _molti_, _adedoyin_, _uzalud_, _penggali,
   {{0x19ad74b5,0xe9786104,0x926d12e4,0x8051c0e9}},	//   _ناموٝسُک_, _suminist, _weboys_, _bangbroo,
   {{0x825af0d0,0xd3f4632d,0xfea614ad,0x927c62d2}},	//   _atilik_, _kartum_, _agelelan, _darstell,
   {{0x027ff28c,0xe2006039,0x532051ab,0xac0154e7}},	//   _kauno_, _haoid_, _kalye_, _augstas_,
   {{0x15fe10ef,0xf27ff52f,0xddd2621f,0x20d1c056}},	//   _مسلمانن_, _jauno_, _fatherla, _kgethetš,
   {{0x029180b1,0xacbe1370,0x8c4f4008,0x72736336}},	//   _furan_, _баред_, _sütün_, _hoosikel,
   {{0x8c64b29e,0xd29071d4,0x35c6714e,0x9200b1c3}},	//   _ensuite_, _arnat_, _অচিরেই_, _aidich_,
   {{0x2ab9224a,0xb7628022,0x2249f18a,0x125b735c}},	//   _frekwins, _тереңдет, _anume_, _amalna_,
   {{0x030d406f,0xa952008c,0x7200d0e4,0xc48c0105}},	//   _lugares_, _publisee, _bility_, _כּישוף_,
   {{0x623661f8,0x3290d06a,0xdb0f220e,0xf7cf2115}},	// [17a0] _spoji_, _rudal_, _conselhe, _conselhi,
   {{0xd248d3a3,0x9f5b8252,0xba701200,0xef364029}},	//   _vieme_, _vilafran, _qanapawa_, _tarumana,
   {{0x825ad369,0xa386d1eb,0x609981b5,0x19a5f18e}},	//   _tiller_, _waert_, _ءۇيىمىزد, _darkonia_,
   {{0x33ebe49d,0x094db026,0xd90f8009,0x3bf6a41e}},	//   _dette_, _formulie, _webandlu, _studentů_,
   {{0x6c51e011,0x8201600a,0xa29030d2,0x7248048c}},	//   _cantera_, _region_, _pujar_, _chima_,
   {{0x9295f01b,0x4a7f42aa,0x849d1171,0x8f4e1235}},	//   _merkezi_, _serasera_, _matangaz, _versiune_,
   {{0x3b0a3229,0x4afe1188,0x1b189140,0x6fd5d15e}},	//   _икации_, _vergiess, _талиплар, _зуданд_,
   {{0x490a0162,0x085ca1b3,0x12e920f9,0xc2ca617d}},	//   _палатаси, _strasser_, _minnist_, _koodi_,
   {{0x4b91318c,0x73ebe07e,0x78bf605e,0x7e57211e}},	//   _icandelo_, _hette_, _finematu, _concedet_,
   {{0xdab0b026,0x730e83af,0x229200d1,0xd25b7152}},	//   _알려주세요_, _guhangq_, _ansati_, _omalla_,
   {{0xa3c862e2,0xe218a009,0xf2906093,0x72480376}},	//   _souvan_, _требуетс, _bulat_, _shima_,
   {{0xff2e10c9,0x9b1c648f,0xc2546421,0x4c4e409a}},	//   _подивити, _музичари_, _bebeekam, _باشقارما_,
   {{0x5940803e,0x553bb0c4,0x735a5248,0xb47090fb}},	//   _àdúgbò_, _binyamak, _ንወለዶም_, _लग्ने_,
   {{0x5eae6101,0xdcf182bc,0x725b7287,0xae0d75e9}},	//   _regroupe_, _fakturer, _spalio_, _middelha,
   {{0x135bf0db,0x1a8810c9,0x19d7c4d2,0x2349900c}},	//   _bongaka_, _основним_, _damechme, _elefane_,
   {{0x575e4200,0x72901294,0x3283f3ba,0x6c531238}},	//   _chuymani, _tsham_, _slikica_, _aostria_,
   {{0xa200200e,0xa5b591ba,0xdc3940cc,0x930f0373}},	// [17b0] _lakin_, _клиенти_, _suscripc, _lisbona_,
   {{0xc387f205,0xf07393a4,0x3e6ac471,0xe03bb15e}},	//   _churn_, _greatsho, _фонда_, _papereko,
   {{0x2da681d5,0x6b40e004,0x925b723e,0x82da711e}},	//   _narodnja, _تعلیق_, _baalul_, _alsena_,
   {{0x66dd137c,0xb290742e,0xb22791ba,0x1386d186}},	//   _batangaf, _arnar_, _самият_, _abera_,
   {{0x520021a2,0x52fc02f1,0x2095f214,0xe8c6b002}},	//   _takia_, _kwiga_, _ﺟﺎﻧﺴﯩﺰ_, _baltiqng,
   {{0x73ea5299,0x66f41121,0xa6ad9057,0x38d9f174}},	//   _molto_, _देशद्रोह, _autentif, _занимљив,
   {{0xd3a93272,0xa1cc6122,0x5c67d2a0,0x7f4bf249}},	//   _convene_, _facilità_, _ترسان_, _singulas_,
   {{0x75bd513e,0x020140ea,0x220022b7,0x929030e4}},	//   _archiwum_, _rodiny_, _dakin_, _anmani_,
   {{0x7627e176,0x4590c0ec,0xf320748c,0xd30510ac}},	//   _mycorrhi, _pikerish, _danye_, _두산벤처다임_,
   {{0xc73de0db,0x02906424,0x7201416f,0x737ab56c}},	//   _рядовой_, _sulat_, _kreiva_, _способни_,
   {{0x1386d252,0x52d7d17d,0x820ec136,0x7b63a2e8}},	//   _aporta_, _машину_, _даван_, _chomhlac,
   {{0x23ea7055,0xcdb9049c,0xf39d11ee,0x1c1d1293}},	//   _monti_, _dhonncha, _yatangaj, _yatangar,
   {{0x43010006,0x154f3169,0x9da8a4e9,0x1831a10f}},	//   _sayansi_, _kommenté, _istoryha, _formátum,
   {{0x02002054,0x2ee9e0af,0x62db323f,0xa193a225}},	//   _bakin_, _ありがとう_, _amoniac_, _главните_,
   {{0x63207144,0x33884086,0x16d502e9,0x2248d076}},	//   _kanye_, _classnam, _banglojw, _enemi_,
   {{0x84d7a252,0x184830d7,0xe292700e,0x7bf720f4}},	//   _талашып_, _хәлим_, _hesaba_, _ﯞﻩﻳﺮﺍﻥ_,
   {{0xa290d310,0x741020cc,0x8d9db019,0x6290649b}},	// [17c0] _mudah_, _ফারহান_, _אַדמיניס, _kular_,
   {{0xf291f240,0x33f89313,0x9287b1de,0x420023d2}},	//   _uttan_, _tukuni_, _znakove_, _fakin_,
   {{0xd200924a,0x4dcc82a5,0xb95c914c,0xe30da0e4}},	//   _maaie_, _akehinde_, _বাদেহরিন, _kreater_,
   {{0xb56f0050,0xa291b144,0x9248d16d,0xf2d82191}},	//   _而在此之前_, _acwabe_, _thomes_, _beinved_,
   {{0x626e758f,0xb2ff42c8,0x0767b287,0xb5d2012f}},	//   _paroli_, _skrivar_, _reikalav, _инсанийә,
   {{0x3fe8206a,0x9c67f0b0,0x71857050,0xf0b4a51d}},	//   _स्थानिक_, _manusia_, _我的美女大小姐_, _شێرزاد_,
   {{0xd274c218,0xfb18f217,0x22b8311b,0x4b6e233e}},	//   _سوالف_, _stranits, _urednik_, _gnutella_,
   {{0x6745d320,0x8fdd21f0,0x082291d9,0x01472063}},	//   _hagiangv, _паркында_, _рефератт, _тариқа_,
   {{0x1248d2d9,0xb4b5555f,0xd290601b,0x0290d20f}},	//   _niema_, _inyandik, _bular_, _ordan_,
   {{0x739571e2,0xa2908121,0x12f20105,0x5f25353c}},	//   _abasha_, _hakata_, _אקטועל_, _disentan,
   {{0x3386d242,0x1864a161,0x1d09e0be,0xcf2c1022}},	//   _sporta_, _nicodemu, _anglisht_, _ﺟﻮﻟﻌﻰ_,
   {{0x42907030,0xd2bc4393,0x904ab11c,0xa38f20ce}},	//   _hunar_, _jardín_, _teorainn, _mostanáb,
   {{0x82e68141,0xfb6a0387,0x2200d1d2,0xf3f8b2a1}},	//   _elinden_, _aileesun_, _ngeit_, _diduga_,
   {{0x8c759543,0x921d306d,0x0373017d,0x5ea2b2ca}},	//   _मुर्दा_, _набуд_, _palaute_, _شەربەت_,
   {{0x12c9e26a,0xbc49613a,0x2380013c,0xdaba50c9}},	//   _english_, _alawens_, _virrey_, _компаній_,
   {{0x9290d11d,0x625ad153,0x1a609105,0x9c1d30aa}},	//   _kudai_, _gillar_, _נאכקומען_, _barangar,
   {{0x829271e2,0x6b63a5e7,0xa2002004,0xd05200e5}},	// [17d0] _besaba_, _abertura_, _nakil_, _regularn,
   {{0x19b051ea,0x3e3a9081,0x029dc25b,0x92d81065}},	//   _ехникини_, _allagaqa, _seljara_, _removes_,
   {{0xf14471ca,0xe20170e9,0xd3ce90c5,0x920ec15e}},	//   _پھرى۪م_, _guaira_, _akavi_, _балай_,
   {{0x2291c22f,0x1fce0200,0x6fd9a037,0x4347936f}},	//   _stvar_, _iqinchir_, _урамында, _behella_,
   {{0x3fae21d9,0x0201401a,0x4f3fb3c6,0xd300d1fe}},	//   _مەزگىلسى, _queixa_, _tangihan, _bagaasi_,
   {{0x34206085,0xe67330fb,0x92ca6177,0xb0036339}},	//   _মুখপাত্র_, _प्रतिभास, _boodo_, _konsultā,
   {{0x8f5b801b,0xd1f3201b,0xfdb43292,0xbaa75124}},	//   _tamamlan, _senagaty_, _بورون_, _serranía_,
   {{0x73596064,0x225b11c4,0x6f0fe06e,0xd6e8925f}},	//   _compléme, _cycled_, _sastrawa, _vanquish,
   {{0x254fc021,0xf5d76022,0xf547e1bf,0x0641c11b}},	//   _elementæ, _باستىعى_, _белорушь_, _старе_,
   {{0xfb036424,0x83ea71df,0xe29260c0,0x4faec0d7}},	//   _sunscree, _monto_, _estats_, _банкы_,
   {{0x0291c040,0x86cb60a2,0x9378b411,0x51cc41a8}},	//   _duvan_, _درستیز_, _anjalan_, _органамі_,
   {{0x72d8c0d1,0xaea7a20e,0xfff3e26c,0x36054536}},	//   _kuleni_, _интереси_, _nepremič, _tålmodig,
   {{0x82fcd4ad,0x4d0e3200,0x9c0e3200,0x5248f1c4}},	//   _mangwe_, _chitanic, _chitanis, _chimes_,
   {{0xa29184f6,0xd29071e6,0x022650d7,0xe9805251}},	//   _kurac_, _punas_, _satkan_, _treiname,
   {{0xd20040e3,0xdc7822b8,0x20bc11fd,0x8b8b11d9}},	//   _namin_, _herstel_, _otomobil, _اتاعىمەن_,
   {{0xa2924067,0x52662155,0xf6b9604b,0xdca3136f}},	//   _agwara_, _روجەك_, _bolalari, _ихтирамы,
   {{0xd3f91501,0x3290a121,0x898ec56c,0xb3f703c6}},	// [17e0] _umculo_, _lubas_, _самит_, _arorangi_,
   {{0xb2ca61a0,0x42e5e121,0x6b583308,0x7387722e}},	//   _blods_, _hinnaga_, _arhumiwa_, _agaron_,
   {{0xa3866579,0x0a8fd21e,0x22004115,0x5248d0e5}},	//   _acord_, _penipuan_, _camin_, _ziemi_,
   {{0xda97735e,0x726e72bd,0x2914f419,0x46264261}},	//   _kunyanya_, _baroki_, _যুক্তিযু, _bilingui,
   {{0xd200437c,0xb224e0dd,0x221314d2,0x906940c8}},	//   _mamio_, _donker_, _bachbe_, _правінцы,
   {{0x1dffd06e,0x93205004,0xb2926124,0x3a167076}},	//   _ketentua, _salya_, _aguata_, _hakahaka_,
   {{0x4d41704f,0xe200b0e8,0x267ea159,0x52f1e057}},	//   _membantu_, _macie_, _عزیزالدی, _ultimii_,
   {{0x51c7315d,0xc7c103c2,0xb761335b,0x1679907f}},	//   _کارتون_, _abatabuf, _твору_, _дрбанзаа,
   {{0x0d9340d9,0x63f900bc,0x4f9c1288,0xe61172ec}},	//   _makelele_, _aibura_, _истикбол, _wahlkrei,
   {{0xa2ca93dd,0xaa77a63b,0x111c1252,0xd277c26e}},	//   _vladu_, _प्रभाग_, _اقتىعىن_, _akvarium,
   {{0xd2fcd2d7,0x4236d382,0xd3a3a407,0xd15311ca}},	//   _bangwe_, _svojoj_, _beppe_, _تماشہٕ_,
   {{0xbc7c4060,0xf27ff2fa,0xa65e1517,0x03f713e6}},	//   _carrots_, _hauna_, _фирми_, _irirangi_,
   {{0xc2907024,0xf2fcd44c,0x8a17d0b1,0x3db43212}},	//   _punar_, _blogak_, _quraanka_, _کوزوو_,
   {{0xed8dc281,0x46767004,0xd39481d8,0x509390de}},	//   _dhalinya, _benjamim_, _bangkong_, _بايسەركە_,
   {{0x427ff19c,0x438693a1,0xdc6323bf,0xe1072342}},	//   _mauna_, _mbari_, _appunto_, _غروري_,
   {{0x7c0f403c,0x327ff076,0x0e53021d,0xd27bf193}},	//   _dispone_, _launa_, _samartha, _einsamml,
   {{0x92002290,0x32906030,0x2cfe3293,0x6f49d11b}},	// [17f0] _takie_, _qulay_, _kwitabir, _glasanje_,
   {{0x6225218b,0x0287c32f,0x034671c5,0x56ba40bf}},	//   _wicket_, _ҳилманд_, _ispetob_, _жаҳаннам,
   {{0x738073c9,0xb5d7920e,0x8c23b065,0x028fe243}},	//   _mauris_, _хуманита, _לרחוב_, _menandai_,
   {{0x995a8481,0xd2792345,0x53ef310a,0xd2cb41ca}},	//   _вәкилләр, _sotsiaal, _matumizi_, _geeddi_,
   {{0xfed3f080,0x3c02b63c,0x42caf07d,0x73eae50c}},	//   _génesis_, _básico_, _gaidim_, _santim_,
   {{0x32004130,0x127ff4e7,0x736f2039,0xffe3141d}},	//   _tamin_, _jauna_, _bangeit_, _ساوتھ_,
   {{0x0c06f1d7,0xe847614c,0xa4dd7031,0x30faf2d7}},	//   _merrily_, _reptiles_, _የምናያቸው_, _dishirel,
   {{0xa2f1e055,0xf5f851a2,0xd3792202,0xd2fcf351}},	//   _scritti_, _заставля, _tibatan_, _ewiges_,
   {{0xe291c317,0x829d01ba,0xe29e11b9,0xc6d341f6}},	//   _duval_, _системно_, _мираҫ_, _आफ़िस_,
   {{0x8a04c21c,0x58fd738e,0x747e21b6,0xa65fd16e}},	//   _dibattit, _kubafund, _editorij, _контролу_,
   {{0x7290323b,0x47a1e2a1,0x4fe8158d,0xda8ad326}},	//   _tamata_, _pertandi, _रेकार्ड_, _abanemib,
   {{0x4ceec15e,0x22dda075,0xe2906008,0x12000336}},	//   _америкт_, _ribolov_, _yslam_, _aaiia_,
   {{0xd5f3a48f,0x126ce101,0xc10a7510,0x036571d8}},	//   _моменти_, _denons_, _abakomol, _margina_,
   {{0xeba770e7,0xc31003d2,0xd2ca91e9,0x20a67105}},	//   _tshilaho_, _shunting_, _klads_, _עבֿודת_,
   {{0xb351d064,0x296d11a7,0x7e041105,0x57e410d0}},	//   _其版权属于商务部, _satisfat, _קרינסקי_, _pulammiv,
   {{0x22486399,0x132781f7,0xfe96b3db,0x5b9e30ee}},	//   _khoma_, _alekseev_, _bestemte_, _antikonc,

   {{0x3f552309,0xc249f387,0x498ad187,0xe2ca63ce}},	// [1800] _chipewya, _anumo_, _amakonza_, _roodt_,
   {{0x52d8c17f,0x6264743f,0x72918114,0xefcd424a}},	//   _kuleli_, _zaslal_, _surah_, _desimber_,
   {{0x42fc3280,0xd9bab0ac,0xca17e181,0xa30a3263}},	//   _nazareti_, _뮤직비디오_, _impanuka_, _ширмакон,
   {{0x02495284,0x19df1440,0xf7d0c0d0,0xb5bc1248}},	//   _themas_, _afilíka_, _taiguang, _እተካይድዎ_,
   {{0x8290a176,0xcd8642e2,0x832183bb,0x426cd169}},	//   _bubar_, _enterese_, _agryl_, _geloos_,
   {{0x8cff9120,0xbe9c2169,0x09f9215d,0x3387f052}},	//   _adjuster, _erstaunt_, _wibisana_, _cauri_,
   {{0xd2480217,0x1fcf91d9,0xae7661f5,0x2ead820e}},	//   _daimi_, _адамды_, _مطالبات_, _комисија,
   {{0x7f54013f,0xaa1012f8,0xc1f6f0ac,0x119bd155}},	//   _תאילנד_, _sakarame, _verzamel, _خەتتاتلى,
   {{0x127f4474,0xd71ed0ac,0x92f730c6,0x4c7dc4be}},	//   _ciento_, _모델하우스_, _sadieah_, _jamstvo_,
   {{0xa32072ee,0xf3454075,0x0291f039,0x3fea3078}},	//   _sanya_, _veselje_, _artad_, _زكريا_,
   {{0xf305c0ce,0x4db42252,0xaa429180,0x1346d051}},	//   _خوراک_, _سونور_, _プラズマ処理室内, _maidens_,
   {{0x3291f595,0xa3ea7339,0x22ca4103,0xe53b015a}},	//   _hutan_, _konts_, _bomdi_, _korytarz,
   {{0xfbad412a,0x8d43d484,0x82e0006e,0x982392f3}},	//   _bisyllab, _cingalès_, _akuntan_, _неверова,
   {{0x1f0e3471,0xe68a738c,0x430dc381,0x53eb83d5}},	//   _социальн, _организо, _михаилов_, _borte_,
   {{0xf2fcf3d7,0xe3acb238,0x23053215,0xcc61600c}},	//   _सत्रह_, _ukraineg_, _upravom_, _fetuuna_,
   {{0x22901137,0xa2257459,0x9a34310f,0x42016163}},	//   _buhay_, _amakwa_, _مسکین_, _nagios_,
   {{0x4387f2f8,0xfc6832eb,0x6dacc4f7,0x8291941d}},	// [1810] _tauri_, _sobrino_, _wednesda, _anyagi_,
   {{0x9c76b2ee,0xa9ab008e,0x5394e175,0x936c13d9}},	//   _matukar_, _yendaiva_, _aziste_, _bakgadi_,
   {{0xcea581c6,0x49fe423c,0x50488031,0x2fd5f09a}},	//   _tolleran, _verament, _አላገኙም_, _ﻗﺎﺯﺍﻗﯩﺴﺘ,
   {{0x229271c3,0x7e7160fb,0xd8c52177,0xef1770a1}},	//   _turais_, _कुत्र_, _riferend, _helodoâb,
   {{0xf2e7515c,0x4469520e,0x842d114e,0x85e80016}},	//   _klengen_, _пристигн, _চিনৎহান_, _thomkhwm_,
   {{0x9db430c7,0x62b5822e,0x1847101a,0xd38d1214}},	//   _زورور_, _piedade_, _хатами_, _таратуды_,
   {{0xcf2091fa,0x127f45cc,0xbf5c510c,0xfe2170c8}},	//   _anyenyen, _siento_, _bobaakan, _terminas_,
   {{0x92918376,0x93fa0211,0x65af3434,0x3079e026}},	//   _turai_, _popula_, _споразум, _praktijk_,
   {{0xd24803e4,0x934441ec,0xb9c441e0,0x9c6182e2}},	//   _taimi_, _liberte_, _libertat, _vedrine_,
   {{0xe9e0e3a2,0xb29261b9,0x62ee1039,0xa3c1f0c9}},	//   _izborima_, _lerato_, _bynniaw_, _географі,
   {{0x6f3b703e,0x229080a1,0x224970cf,0x2a8b3079}},	//   _abdullha, _takapa_, _alamin_, _desizion_,
   {{0xb2486386,0x3b696315,0x8b8a1057,0xd34880f6}},	//   _thoma_, _montanha_, _норок_, _портрете_,
   {{0xa290363d,0x022662b7,0xe2bb336f,0x1aefb0cb}},	//   _yamara_, _farkon_, _akhente_, _hystyrie,
   {{0x548fa29a,0x983ab031,0x63ea510f,0x425ab248}},	//   _mengadak, _በየወቅቱ_, _bolti_, _thelle_,
   {{0x06ac75a8,0x3c6181bf,0xb48bc00a,0x63656428}},	//   _myoglobi, _operare_, _memorial_, _borgara_,
   {{0xccc523db,0x0248307e,0xdbcd80ac,0xff1e93be}},	//   _forstå_, _kommun_, _영업소재지_, _основных_,
   {{0x82483183,0x85b0b262,0xedb6219a,0x0324f111}},	// [1820] _commun_, _abasirik, _hinsawdd_, _diskutej,
   {{0x0004c4b1,0xe291835e,0x425b03a1,0xb3f4612a}},	//   _ilektrik_, _murau_, _abagulum, _bottas_,
   {{0xa37a12a3,0x964fc0d1,0x0290a22e,0x858342ff}},	//   _союзы_, _anakanyi, _subay_, _bopeghch,
   {{0x26ca529a,0xc290d4da,0x13ea745b,0x0ac0c149}},	//   _khususny, _dudas_, _contr_, _afakanis,
   {{0xf34af516,0x60eec1d4,0xce85a1e6,0xda6cb0d1}},	//   _majetku_, _nalikill, _antaḥpur, _atameris,
   {{0x2fe2c438,0x3d9eb116,0x71d2a23f,0x59fa7080}},	//   _abazidin, _गोएड़वा_, _deuriatz_, _antisana_,
   {{0x99752517,0x42e88103,0xd27f4104,0x528e1296}},	//   _клубове_, _biyinqa_, _pienso_, _abakuwo_,
   {{0xd2490059,0xfacaf01c,0x65eb72cb,0x6204130e}},	//   _khamis_, _látogató, _عرفانه_, _probíhá_,
   {{0x73207100,0xdb22f63e,0x2ac1a15a,0x0d2a5013}},	//   _banyo_, _estratég, _कैंपस_, _арглараз,
   {{0x3479f197,0x562722db,0xd4e4a337,0xdfe3d01a}},	//   _diletakk, _komiteti, _प्रभावका, _پاستا_,
   {{0x1e55e20d,0x395f6025,0x4290d046,0x33790012}},	//   _espainia, _afonrere, _mudar_, _faragha_,
   {{0xae9f0012,0x7544c245,0x51fca0ee,0xdc697033}},	//   _utamadun, _abayinik, _parapety_, _montany_,
   {{0x97293427,0x42135309,0x0e3e4449,0x39ffb421}},	//   _добри_, _baghbe_, _akrananp, _badiyyaa_,
   {{0x42489139,0xa3f47309,0x622c1282,0x3e1ac186}},	//   _dhama_, _bortas_, _חפיצים_, _abafilip,
   {{0x8c61a294,0x339b127c,0x5bfc90a0,0x885d620e}},	//   _ferrand_, _こんばんは_, _مجاهدینو_, _brinqued,
   {{0x515c32bd,0x4fa6c2aa,0x498ec0e9,0x320ec0c8}},	//   _сайтында_, _olombelo, _рамин_, _раман_,
   {{0x7387b430,0x0ee3b27b,0xd29181fd,0x272c955b}},	// [1830] _fevral_, _महत्वाका, _murat_, _ehemalig,
   {{0xcfc65026,0x62918183,0x85be75b5,0xce717345}},	//   _openbaar_, _strax_, _формиран, _छुद्र_,
   {{0x8c627019,0xf3cff4ce,0x24b400d0,0x234541a7}},	//   _אַצינד_, _akuva_, _nalautik, _caserne_,
   {{0xbc36c05b,0x3c1d925d,0x32d8836f,0x5f643043}},	//   _دعلمي_, _batungis, _dikela_, _старинны,
   {{0x32489012,0xf9c5b1ca,0x72501005,0xca8e1020}},	//   _chama_, _kaalinta_, _цераз_, _acancies,
   {{0x62011190,0x9224f015,0x1b73c1a6,0xa2986128}},	//   _bucina_, _achkan_, _babuyela_, _purplish_,
   {{0x19c5b0b1,0x72011427,0x6386d11d,0x0966d3ef}},	//   _maalinta_, _cucina_, _mberi_, _musicove,
   {{0xe2d3d44d,0x72ca41c6,0x1278d1e2,0xd47bc2eb}},	//   _kokoši_, _komdu_, _abagijim, _акалам_,
   {{0x44bf04bd,0x622663c1,0x52906140,0x49e680fc}},	//   _शकुंतला_, _varken_, _oslan_, _мастеры_,
   {{0xa5bee415,0xdd942086,0xaf7ec0f7,0xc3f46063}},	//   _урагш_, _gamefest_, _中国经济网_, _tortib_,
   {{0x12d8b1ac,0x35921005,0x4f6b01b3,0xca0802df}},	//   _andevo_, _унутраны, _detalios_, _isaaaaaa_,
   {{0xd20272dd,0x95fe1351,0x729182dc,0x9386d374}},	//   _kusita_, _مسلمین_, _gurat_, _aberi_,
   {{0xec65b03c,0x11b922f4,0xb5a180e5,0xf24940ac}},	//   _martinu_, _германд_, _बरसती_, _noemen_,
   {{0xf3bbc004,0xa24990c3,0x7ea5d0ac,0x2f5d3093}},	//   _استان_, _bismo_, _권리침해신고센터_, _merancan,
   {{0x08db5309,0x337ca5cf,0x12916245,0xb3ea950c}},	//   _bijeqchu, _garante_, _angayi_, _laktoz_,
   {{0x46a5b231,0xf1fc83c8,0x0184d192,0x634a01f2}},	//   _energety, _bivalmeh_, _аямай_, _almennu_,
   {{0xc2f1201d,0xd69a500e,0x1142d0d7,0xfef241f6}},	// [1840] _sägen_, _sakinlər, _атлар_, _कशमकश_,
   {{0x6f3df185,0xd2d880ce,0x03eb844b,0x89e10174}},	//   _abrokyir_, _fekete_, _borta_, _izvorima_,
   {{0x525ae1c3,0x4da4c1a1,0x5103f08a,0x7983f03d}},	//   _chille_, _enginewa, _abakhwel, _abakhwet,
   {{0xb2fcd0c3,0x12e4b22e,0xc4de216e,0x3200422c}},	//   _svega_, _casualty_, _временом_, _aamia_,
   {{0xee55c0ef,0xba82830c,0x5681742e,0x7ae3012f}},	//   _دوستن_, _recognos, _myndskei, _مەشئەل_,
   {{0x30373093,0xbcc891a9,0xb236e3de,0xe9e742d7}},	//   _pertaman, _قۇتراتقۇ, _manjka_, _kokotela_,
   {{0xfc4ed292,0xd320712b,0xa28001c5,0xee569018}},	//   _گمانه_, _banye_, _dinamafi_, _stabilit_,
   {{0x25820563,0x42918113,0xa2fca4d5,0x89938139}},	//   _amategek, _kuram_, _derivat_, _bakkeett,
   {{0x6ec79502,0xc3aa763f,0xa2265043,0xec693404}},	//   _киносы_, _petaling_, _matkan_, _muvunyi_,
   {{0xe25a5135,0xfc5bd0a2,0xf8275022,0x82b3922e}},	//   _ብህድኣት_, _kakuhle_, _جاعادان_, _sondrio_,
   {{0x229000c0,0x3f1fd083,0x8200b0c3,0x53a9c04c}},	//   _chiao_, _segureta, _nacin_, _دزدان_,
   {{0x8b80f007,0x638c113f,0x41d1234e,0x848741b4}},	//   _قربانیاں_, _להקטין_, _остона_, _नारायन_,
   {{0xe24864de,0x440d60c5,0x5126711b,0x03a3a2e9}},	//   _chome_, _akononek, _ranjenih_, _deppu_,
   {{0xed1500bd,0x824992fc,0x0ead80b7,0x82a0c040}},	//   _verseker, _pismo_, _доминира, _chijchu_,
   {{0x23263096,0xff242038,0x27a01282,0xf2484261}},	//   _عبدالغنی_, _निवेदनात_, _המכפלה_, _dammi_,
   {{0xd29061ab,0x22d882d9,0x530e41c4,0xf382d438}},	//   _kulay_, _ankeka_, _stuarts_, _داخلې_,
   {{0x530e0058,0x12484261,0xe386d424,0xc2003231}},	// [1850] _ahabona_, _fammi_, _faery_, _pomimo_,
   {{0x1b2dc445,0xd42020ac,0xd291b3b5,0x2f6a0102}},	//   _timbalan_, _개인정보는_, _levado_, _budbehan,
   {{0xfe591009,0x8847e09a,0xbe9171c8,0x768cf2eb}},	//   _первой_, _بارىكالل, _district_, _далагоит_,
   {{0x28b90031,0xe4f7f083,0x92fe4281,0xf170e4f5}},	//   _የካፒታል_, _بالاساعى, _weeraray_, _اجمالی_,
   {{0x894fb3a5,0xb29271aa,0x03a3a227,0x929060c1}},	//   _unelunge, _lesaka_, _무료다운로드_, _gulay_,
   {{0xc245809a,0x53866228,0xeee2f371,0x52e91363}},	//   _ماڭىدۇ_, _acoro_, _artritíd, _kopiina_,
   {{0xd27e9431,0x43796072,0xe1e0d14f,0x57ecc06e}},	//   _ayant_, _ustanka_, _anyonyam, _ऑफिसमध्य,
   {{0xea85e402,0x2b8a134b,0xf54d621c,0x169a5257}},	//   _stoneman_, _зотов_, _privatez, _hakimlər,
   {{0x3c773553,0x42ea023c,0x42917246,0xb56e3031}},	//   _kristne_, _ufficio_, _agaaga_, _የአትክልት_,
   {{0xfa0671d9,0x0f15a3f2,0x9386b1d9,0xdf39060d}},	//   _تۇتقىن_, _yindodan, _قالدىرۋ_, _सपरिवार_,
   {{0x2f2b63a4,0xd225121f,0x8a60f44c,0x358640b1}},	//   _gettyima, _fackel_, _айхтар_, _raadinay,
   {{0x82ca6209,0x9200b1df,0x39db910b,0x4d1b910b}},	//   _koodu_, _nacio_, _ahengera_, _ahengere_,
   {{0x327ed161,0xe5f8c01b,0x0ad84283,0x63866478}},	//   _bennie_, _парахатч, _akutsint, _scorn_,
   {{0xb27ed1c4,0x1c7e3293,0xf29b1640,0x1200607d}},	//   _jennie_, _amasoko_, _akubitam, _naoia_,
   {{0x815cd28c,0x1394e19a,0xa38771df,0x129e100f}},	//   _нумар_, _lansio_, _aparta_, _писав_,
   {{0x929181e6,0x5348416b,0xe3452053,0xfd131256}},	//   _puram_, _alleati_, _handelt_, _bakomeye_,
   {{0xf248411d,0x953b3146,0x977610f7,0xddc5a303}},	// [1860] _tammi_, _sepanyol_, _大家看出了什么_, _avskrift_,
   {{0x95e580db,0xf7efa111,0x05a9c1a2,0xd15891c3}},	//   _аңлатып_, _אמונת_, _целиком_, _aigneadh_,
   {{0xbdb431be,0x52ba20c3,0x42026198,0xbdfec1ba}},	//   _مولوي_, _ponekad_, _equipe_, _effettua,
   {{0x6ee414df,0xdfba6252,0x0e27412f,0x93f47398}},	//   _artikels_, _innovado, _ﺭﺍﻣﯩﺰﺍﻥ_, _mortes_,
   {{0x92266200,0x03eac0ab,0xc26ca067,0x06f67241}},	//   _markan_, _endte_, _heboe_, _сентинцэ_,
   {{0x22918023,0x429192e2,0x23f460bd,0xcb6af4ac}},	//   _kurak_, _siyati_, _partye_, _reducida_,
   {{0x037fc304,0xaf1e12db,0xe27f701e,0xf38a22e0}},	//   _galanya_, _tenderin, _nnanfo_, _akayabo_,
   {{0xe200b469,0x9291f17e,0x0291611a,0x1349837b}},	//   _facil_, _kutaa_, _magawa_, _dosegni_,
   {{0xb29081d8,0xcc93c2fd,0xe1540138,0xf433c190}},	//   _kakara_, _بابان_, _vlastito, _atekisek,
   {{0x8b303152,0x67bc81a0,0x12bb80f8,0x8248924e}},	//   _целом_, _badereig, _kaderle_, _dhame_,
   {{0x92a6706d,0x0c63413f,0xfda3413f,0x514bf248}},	//   _kanjani_, _improve_, _improved_, _ንሓሙሽተ_,
   {{0xa344918a,0xde09e5de,0xc395030b,0x2f1510fa}},	//   _citeste_, _टिपण्णी_, _klases_, _mostobra,
   {{0x43f46148,0x9d3b7126,0xd355a1e0,0xa7b36164}},	//   _leutik_, _bisharat_, _videtur_, _konstiti,
   {{0x4d07e17d,0x7ea700f7,0x83efa21f,0x0ed5d2d5}},	//   _органов_, _掘进工作面_, _babueiyi_, _argyllga,
   {{0x8376c198,0x59132217,0xa2786110,0x5b0da276}},	//   _простор_, _депутатл, _catnip_, _ڊسيمبر_,
   {{0x12927184,0x53207148,0x6e72239a,0x72f152ec}},	//   _resaka_, _nanya_, _डेस्क_, _rügen_,
   {{0x527ed0a1,0xec744065,0xc637c036,0xf317f21c}},	// [1870] _tennie_, _examined_, _камион_, _gurbani_,
   {{0x78674050,0x4ae6e180,0x3c5a919e,0xf2a6704c}},	//   _沙特阿拉伯_, _auktione, _arataki_, _aanjani_,
   {{0x6950c307,0x3248d058,0xbf21e29a,0x1291611a}},	//   _ettlinge, _ahema_, _bertinda, _nagawa_,
   {{0xf2fce312,0xe201d12f,0x7291851f,0x4da5e0df}},	//   _sangat_, _обамани_, _curah_, _insidewa,
   {{0x32919500,0xf3eba016,0x6c0ae115,0x429082b7}},	//   _siyasi_, _sixtus_, _agassiz_, _takara_,
   {{0x44133007,0xa203d102,0x02918030,0x52916365}},	//   _چاندی_, _процедур_, _yurak_, _bagawa_,
   {{0x8fce61cb,0xfe70b547,0x50533291,0xaf64c0e5}},	//   _muinntir_, _sarcopha, _نانسی_, _negatywn,
   {{0x8291f2ab,0xf2909056,0xd2e9f22a,0xfc80e3dc}},	//   _butai_, _mejako_, _solidno_, _однознач,
   {{0x3decc296,0x8c01f168,0x085a213f,0x53807364}},	//   _кулли_, _bestands, _journals_, _barrih_,
   {{0x063770c7,0x53ea700d,0xac16d0e8,0x427f4104}},	//   _barnaami, _tontu_, _भाग्वाद्, _viendo_,
   {{0x420110c5,0xc25b700c,0xd2918044,0x62908339}},	//   _kucica_, _toalua_, _hurai_, _vakara_,
   {{0x82004207,0xf666f03f,0x5cbac009,0x2046d033}},	//   _izmir_, _महासभा_, _предприн, _antreten,
   {{0x8d38e018,0x42480054,0xebe640f3,0x76558225}},	//   _milioane_, _kaimi_, _dialetto_, _сторител,
   {{0x49cfb0d3,0xba34241d,0x8e0a65c1,0x22918641}},	//   _violenza_, _نسرین_, _tvrdogla, _murai_,
   {{0x40cfb13c,0x1eb713cd,0x942c115e,0x9b1df0ac}},	//   _америкат, _sørensen_, _агсны_, _성공적으로_,
   {{0x524801a3,0xf8f99009,0x45922292,0x929183f4}},	//   _laimi_, _многих_, _توافقنام, _arran_,
   {{0xcc00d15b,0x10d10429,0xe386720f,0xc89f1031}},	// [1880] _krismas_, _acusatór, _faizini_, _እመኛለሁ_,
   {{0x7c66d484,0x93a2c026,0x8387f2a5,0xc1545178}},	//   _cantons_, _helpen_, _aburo_, _arbetspl,
   {{0xdea4f1d7,0xbb9350a2,0xc7535212,0xae53406a}},	//   _likeness_, _abaneenc, _abaneeng, _kekalaha,
   {{0x12003206,0x8ae53036,0x58e8d36b,0x92da5141}},	//   _domino_, _risultat, _leistung, _ertesi_,
   {{0xcd997203,0xde97c124,0xb32610f4,0x8d2a5296}},	//   _enkolaga, _арбџьарт, _خاھىشى_, _ғалладон,
   {{0x52900057,0x3af0c108,0xa3f470d2,0xa64080df}},	//   _chiar_, _ریاستی_, _partit_, _ossibili,
   {{0x19afb248,0xa0ea706d,0xdc66a335,0x7da43057}},	//   _ተንኮልን_, _вазифаҳо, _partent_, _гласул_,
   {{0x341f415b,0x8606b3b0,0x50dd717f,0x8a73115e}},	//   _viradoro_, _sammenli, _izindlel, _banaketa_,
   {{0x62900218,0x44bad226,0xa47db038,0x01529424}},	//   _thiar_, _विवेचना_, _diresmik, _nutrisyo,
   {{0x72499393,0x7be721f3,0xd2f74202,0x8a8fc110}},	//   _misma_, _خریدا_, _kalimah_, _namibian_,
   {{0x9af40177,0xfa753024,0xafeeb0dc,0xf26e5122}},	//   _abbootan_, _adhīte_, _اقبايبىچ, _ottone_,
   {{0xd2009336,0xd0443116,0xc5fb15b5,0xe2918292}},	//   _aaaia_, _गयिलीन_, _karadžić, _asrab_,
   {{0x0200d3d2,0x9ec44193,0x4c75f2d7,0x397ec1fd}},	//   _gaeil_, _drunkenn, _apesang_, _kelimele,
   {{0x79db21da,0x32f3209a,0x5ddc2466,0x5bb660f7}},	//   _nkongera_, _алтун_, _گليور_, _如擅自篡改为_,
   {{0x225ac3a3,0x32cbf3e1,0x92247005,0xce55a075}},	//   _okolie_, _soude_, _tenka_, _ozračje_,
   {{0x4fef0059,0x0200f240,0xc39481fc,0xb2bf14b5}},	//   _መስተንግዶ_, _dagin_, _fiksim_, _گۅبان_,
   {{0x40e7c217,0xb7a7e3db,0xef83b065,0xb885e1ed}},	// [1890] _агентлыг, _overskri, _ונותן_, _выдача_,
   {{0x1c6101fc,0x6c6740f9,0x9dffc095,0xf32481a6}},	//   _amorite_, _sostatt_, _hardship, _akaceli_,
   {{0xa200f22e,0xe3eae339,0xfe6b0024,0x495ec100}},	//   _nagin_, _softs_, _akliṣṭām, _tablevie,
   {{0x2ec78287,0x129141a4,0x03ea5135,0xb9c1e238}},	//   _краязнаў, _egeana_, _dilte_, _studiade,
   {{0x398733d3,0x45ba221d,0x047a70b2,0xe851a362}},	//   _भ्रमित_, _nopalabh, _pontmain_, _maloprod,
   {{0x22d95627,0x6d3e0642,0x6e1dc009,0x625b00b2}},	//   _kufeli_, _seriøst_, _проще_, _sablaj_,
   {{0x3a12e14b,0x7aa431a3,0xd9e281b3,0x22d76075}},	//   _inscrive, _tshiitis, _arrivava_, _prvotno_,
   {{0xfebce38c,0xf54ba1ed,0x2b7e119f,0x7bf6a26e}},	//   _verovatn, _marşrut_, _amarikaa_, _studentų_,
   {{0xbc672218,0x5cbec0c8,0xa472b2f4,0xb26c111b}},	//   _ارقام_, _памер_, _импортло, _pohod_,
   {{0x377860d3,0xba11f41d,0x4b20e59b,0xd7c3a033}},	//   _prevenzi, _garancia_, _प्रकारका_, _apersevw,
   {{0x337b9048,0x8f1ea0fb,0xbd8a94d5,0xd38743a4}},	//   _skladem_, _kartavya, _academie_, _iterum_,
   {{0x22fcc101,0x23080364,0xa8f38166,0x8f7a7089}},	//   _malgre_, _assamaq_, _abdideeq_, _traction,
   {{0x6c60447e,0xdfd6309a,0x82909177,0xf327007e}},	//   _neutres_, _картнер_, _ahaak_, _blocket_,
   {{0x9eb0913c,0x62d8328d,0x5b6b5295,0x52d9c3dc}},	//   _leyendas_, _mameya_, _kilomber, _знаний_,
   {{0x8ff82026,0x32857192,0x525a825d,0xe42ff0b4}},	//   _클린중개업소_, _dithuto_, _violé_, _ainaonao_,
   {{0x635f9516,0xa853c0d9,0x53f9023b,0x9e4a6248}},	//   _recepty_, _echanger_, _dibuna_, _ብምእሳር_,
   {{0xd4d69643,0x3f952140,0x127e940f,0x9de6301a}},	// [18a0] _मिलियन_, _nindider_, _teknar_, _اعىنى_,
   {{0x82cad1a0,0xfdb962bc,0x49afa13f,0x227ff443}},	//   _valdez_, _datatype_, _גמילה_, _ayuno_,
   {{0xec25c4b5,0xe291414f,0x65879105,0xac5d1005}},	//   _اخبارچھُ, _abdair_, _נאכשרייע, _pastato_,
   {{0x82489134,0x5487521d,0x93f471c5,0x7d40f1c3}},	//   _saami_, _पितामह_, _distuk_, _argamaid_,
   {{0xd3f9614c,0x833d001c,0xb1e3c227,0xbe8d11b5}},	//   _alguno_, _کینال_, _대전영어학원_, _моңғол_,
   {{0xf2245423,0x2290908c,0xe9db2318,0xb200b111}},	//   _welke_, _schatz_, _ukongera_, _nacia_,
   {{0xa3ebe3dc,0xa8b6c588,0xbb1624a7,0xa398904b}},	//   _jotta_, _ترسيل_, _amipasit, _каналлар,
   {{0x5200b4da,0xd47a709b,0x79c7c140,0x003a60e5}},	//   _hacia_, _bonthain_, _салават_, _wirtualn,
   {{0x1591d168,0x021940fa,0x9291a100,0xada0e34e}},	//   _안녕하세요_, _funkciji_, _supak_, _zululand_,
   {{0x8aad628e,0x52efc439,0xaf249150,0x13981065}},	//   _berkesan_, _aslinya_, _brødre_, _פעמונים_,
   {{0x93fa60c3,0xd2a06171,0x62e832c7,0x18dcd264}},	//   _poruka_, _mkubwa_, _milión_, _تشجيع_,
   {{0x92d8c4ed,0x8291a0e4,0x6a0f809c,0x60ff21b5}},	//   _kamery_, _arpan_, _abaabile, _әйтсе_,
   {{0x146b91c9,0xe2fcd368,0x06c83185,0xf6c6b0f7}},	//   _detenido_, _hangre_, _bengalif, _中国建筑机械市场_,
   {{0xdf2d63e8,0xad28105a,0x5c28105d,0xbbe4f3da}},	//   _através_, _societat_, _societad_, _invercar,
   {{0xd27ef473,0x2b82438f,0xf27ed097,0x0dcec0d7}},	//   _meiner_, _standaar, _byens_, _динен_,
   {{0xeaa7901a,0x7af040ac,0x8109412e,0xb3ea7057}},	//   _талашта_, _구매평가를_, _doskonal, _minte_,
   {{0xa3ea71ec,0x22fce06a,0x324990b8,0xffdff1c3}},	// [18b0] _linte_, _banget_, _qismi_, _chunnaic_,
   {{0x85edd059,0x020122c0,0x032d33f9,0x6dc4332f}},	//   _በማደራጀት_, _kayin_, _føyer_, _сухроб_,
   {{0xfaa850ac,0x16b7d156,0x020ec09a,0x5a5e40de}},	//   _개인적으로_, _шампион_, _макан_, _اقمۅۅر_,
   {{0xf629d40f,0x7290c20d,0xa3c6d264,0xdf0ea102}},	//   _vandamál_, _delako_, _يعالج_, _сферах_,
   {{0xf2efd049,0xb2ff442e,0xc53a0041,0x3200b03c}},	//   _galicia_, _skrifar_, _تصویرونه_, _facia_,
   {{0x95f530e5,0x1fd833ed,0xd9bf9187,0x8224e3b0}},	//   _प्रतिधार, _електрое, _achechet, _unikke_,
   {{0xf2ca6101,0xc9bfc0ce,0x99495022,0x930072c4}},	//   _unodc_, _befektet, _наразылы, _dinamai_,
   {{0x27c9612e,0x23ea70ec,0xd425d142,0x4c8e5214}},	//   _postanow, _dinte_, _zapisnik, _ادەﺑﻴﻪﺗﯩ,
   {{0xa32182e2,0x62259067,0x926e7445,0x42fe6095}},	//   _marye_, _amabeghị_, _serous_, _purged_,
   {{0x72fa84b2,0x42e5c026,0xb1f5202f,0xf6afb376}},	//   _tinhvan_, _통신판매업_, _وګرځي_, _birtaniy,
   {{0x00c8d12f,0x5ecc42c7,0x36407266,0x22918208}},	//   _چىڭگىزخا, _rasizmus_, _hisitoli, _urras_,
   {{0xc7c4b2fc,0xff15c009,0x69d9e1e5,0x6ac9c292}},	//   _околност, _отрицате, _ахбетин_, _сайланад,
   {{0x72318267,0x51471030,0x42dbf0d7,0x92786589}},	//   _akomako_, _васила_, _акциясе_, _oluntu_,
   {{0x1b35a00a,0xc8ea2031,0x73b60105,0xe4133388}},	//   _establis, _እንዲሄዱ_, _איציקל_, _بانده_,
   {{0xb77d21bf,0xe387f4c8,0xe3cf044d,0x152b71b1}},	//   _презинтэ_, _rauru_, _stavit_, _достовер,
   {{0x32fce08b,0x0217d2f3,0xd46c742f,0x4d7632fd}},	//   _sanget_, _сигнала_, _undersiz, _سرینی_,
   {{0xf03721ba,0x92d83098,0xac630006,0x937cb22c}},	// [18c0] _settiman, _kamena_, _matumbo_, _faraile_,
   {{0xe2012054,0x9248409c,0x8efb50f4,0x82d6324f}},	//   _yayin_, _nammi_, _بىپايان_, _villads_,
   {{0xe290305e,0x8d570041,0xc9d9a196,0xe3a2d109}},	//   _mamani_, _استراليا_, _esperime, _isopor_,
   {{0xefc232cb,0x8c7d81d6,0xd3f9809c,0x2ea6b1f1}},	//   _ڀالوا_, _asisiwo_, _ayyuub_, _jardines_,
   {{0xcd8fd428,0x96407422,0x92fcd1f1,0x7e509285}},	//   _unglinga, _sprinkli, _sangre_, _abaasima,
   {{0x58823288,0x08c890af,0x337391dd,0x12918355}},	//   _портлаш_, _と投票しています_, _gagadre_, _hayata_,
   {{0x3bb7a098,0x42918114,0xf2cbf479,0x229181ab}},	//   _urukundo_, _surau_, _gludo_, _burat_,
   {{0x32918213,0x127f40ef,0x526c13c6,0xa3807453}},	//   _jayata_, _mpenzi_, _mohoa_, _serret_,
   {{0x7e5424d9,0xf5f91059,0x4053700f,0x8a1420f5}},	//   _finanzia, _ኮንፌዴሬሽን_, _episoden, _finanzie,
   {{0x425ab470,0x8d3cd064,0xa51330e7,0x522511ad}},	//   _kjelde_, _发表评论于_, _ngauralo_, _fickle_,
   {{0xfa697135,0x322ba1d9,0xfe1db015,0x4c0ba4a7}},	//   _ደቀምሓረ_, _پەرىشتەم, _herencia, _epipilo_,
   {{0x8c5c024e,0xfa049262,0x60b1c133,0x1a93d009}},	//   _gittern_, _ayisumbu, _kapitálo, _создана_,
   {{0x3295b4b2,0xae123388,0x82da7313,0x6e3a43bb}},	//   _vinaxuki_, _بگرنه_, _sureti_, _pillapis_,
   {{0x4386d200,0xd658a0a2,0x3a7e7125,0xf175103a}},	//   _nyorai_, _abantakw, _kubarura_, _konpasyo,
   {{0x6387f256,0x42da5086,0xe249701f,0x503b926e}},	//   _mbura_, _altero_, _alamun_, _абанента,
   {{0x62e30043,0xa3be7349,0xe7c740e8,0xb127920e}},	//   _valitse_, _såvidt_, _zastanaw, _агенција,
   {{0x82012095,0x42ed40c5,0xee1db225,0xf2da70b4}},	// [18d0] _sayin_, _masinde_, _gerencia, _gosena_,
   {{0x2a06004c,0x66201058,0xf059a2aa,0x2867809c}},	//   _ابراهیمی_, _akanyari, _ankamaro, _achiistu,
   {{0xeb8ac1e2,0xd5c010a0,0xeb0b30af,0xde32e475}},	//   _болои_, _ځلانده_, _一部例外あり_, _menghala,
   {{0xe3c331ca,0x62257322,0x927ed0a3,0xb977e11e}},	//   _وُجار_, _amaksa_, _hennie_, _baricade,
   {{0xb291f1f6,0x42019267,0x02918050,0x0c787378}},	//   _tutaj_, _kasie_, _auras_, _flestum_,
   {{0xf27863a5,0x2b61617d,0x6807d0f6,0x72da7057}},	//   _uluntu_, _ostetaan_, _сыналанд, _dureri_,
   {{0xb54ec063,0xa2337028,0x96a6d505,0xc248d195}},	//   _бизни_, _bandjerm, _bidragsy, _nsomba_,
   {{0x1212d2e9,0x32c521bb,0xa2a6c46e,0x2785f052}},	//   _yudha_, _filmler_, _coobme_, _normatīv,
   {{0x92d831b9,0x2069911e,0x39f2e115,0xb2a6204c}},	//   _mamela_, _fanatico, _benghale, _فابریک_,
   {{0x329181c3,0x72d30204,0x3291f138,0xef1fb4fe}},	//   _turas_, _sekolah_, _kutak_, _phethaga,
   {{0xe29204be,0x9ec3a271,0x52c52207,0xb37840c7}},	//   _pisati_, _orientač, _hileleri_, _badanaa_,
   {{0x1c66a0d9,0x2c5350a1,0x4e38f2e8,0xc107f278}},	//   _miettes_, _pattara_, _carachta, _anekival,
   {{0xc5196061,0x48a6c03d,0x23eac2d5,0xdc6db1b3}},	//   _طوفاني_, _عبدالولي_, _alltan_, _aperiva_,
   {{0xcd24726b,0x2c149287,0x32a25182,0x52d4123e}},	//   _blantyre_, _мемарыял, _aparijñā, _dolliku_,
   {{0xe2245359,0xe2c7848f,0xb2caf23c,0xca18f3be}},	//   _belki_, _rádio_, _analisi_, _местах_,
   {{0xb2903012,0x73fe5159,0x7234a47a,0x9f5db28e}},	//   _zamani_, _amerikai_, _igumire_, _pelancon,
   {{0xd68f90af,0xd291a0c0,0xf248d435,0xcdc07177}},	// [18e0] _新しくブラウザが, _arpas_, _asomba_, _dokkoowa,
   {{0x8b04b0de,0x4d26032d,0x6190d0dc,0x2f33a644}},	//   _ارىباعىل, _ajanayat_, _керметоо_, _profeson,
   {{0x399d31b9,0xf8e3628c,0xb62ad11b,0x489a6031}},	//   _табып_, _prisireg, _користио_, _ካሪኩለም_,
   {{0x825b113f,0x628130fa,0x7286e3f7,0xc7b9d392}},	//   _really_, _proslavl, _lachanm_, _memungki,
   {{0xf353c04c,0x529031d4,0x9985b291,0x834370fc}},	//   _شهرام_, _tamani_, _ماليات_, _хупланды_,
   {{0x111b0026,0xefed6392,0x82d8e299,0xec0b61d9}},	//   _개인정보취급방침_, _berkisar_, _chiesa_, _ءتىرىمىن_,
   {{0x57adc1a1,0x4db66481,0x74105102,0xf3d4c00e}},	//   _espectiv, _jurnalla, _websiden_, _ustası_,
   {{0x5441115e,0xcdb473ef,0xd789e0bf,0x8501d223}},	//   _америкий, _mediapip, _ватаними, _wakristo_,
   {{0x841da11e,0x9b06a119,0x025ae18a,0x97b5b309}},	//   _omission_, _tassunga_, _doilea_, _bolehbog,
   {{0xa7b9d088,0x12da537f,0xc20270b1,0xc15830d8}},	//   _kemungki, _motero_, _nasiib_, _chinnidh_,
   {{0x997e43df,0xf23e931f,0x4c90b09f,0x85fd10de}},	//   _повернул, _válida_, _bakuding_, _اقجاۋىن_,
   {{0x126c50bf,0x898d411b,0xfd0d43bf,0xdd9f9163}},	//   _alloh_, _популарн, _популяри, _weinstra,
   {{0x645c50a8,0xc201144d,0x996ac403,0x486ac212}},	//   _provozuj, _lucija_, _abanezit, _abanezid,
   {{0x669701b5,0x34ab20ee,0xbfb851b0,0x3ef623d0}},	//   _ұлтаралы, _keramick, _posledno, _гартал_,
   {{0xa2903076,0xb607d085,0x9db80124,0x8c6060b0}},	//   _kamali_, _শতাব্দীর_, _арҕьарах, _lagunya_,
   {{0xc3589645,0x47fcc2f4,0x1291f06a,0x17e5b23c}},	//   _página_, _ологи_, _kutai_, _disattiv,
   {{0x24d6b21d,0x371e7038,0xd36870c9,0x22b362a1}},	// [18f0] _प्रिये_, _प्रवेशिक, _наприкла, _saudara_,
   {{0x8e99d241,0x32a78141,0xac6051c0,0xed877191}},	//   _кампание, _harby_, _seguita_, _alpestre_,
   {{0x82e0b493,0xa9e39065,0x42d9735a,0x82cb7208}},	//   _mhargadh_, _בנצרת_, _enaena_, _amadan_,
   {{0x32d940bd,0x766040e0,0x33eb8111,0x024a629f}},	//   _tydens_, _प्रसीद_, _forto_, _agumbi_,
   {{0xaeba1162,0x72fc1065,0x4fc673c1,0xee35d1d4}},	//   _جۇمھۇرىي, _והדיון_, _planerar_, _aperineq,
   {{0xa6b8e2aa,0x32486327,0x6272f3e3,0x13f8206a}},	//   _madagasi, _abomo_, _endividi_, _uskup_,
   {{0xa800414e,0x584741c2,0x82cbf289,0x22ca9047}},	//   _মেসবাহ_, _bastones_, _houde_, _abalimi_,
   {{0x5313913f,0x1ebec13d,0x7f3cc2d2,0x620e115e}},	//   _סטיפס_, _hérault_, _lieferun, _махан_,
   {{0x0744c04b,0xc290909b,0xd037630c,0xed00e053}},	//   _юзага_, _chaam_, _septiman, _herunter,
   {{0xc2392141,0x567fc2ac,0x234a000d,0x7ee7a223}},	//   _полуң_, _ڵماسی_, _domeenu_, _alikutan,
   {{0x1fbe1135,0xb3788152,0x726ca31f,0x41c073f2}},	//   _ንምክልኻል_, _ainakin_, _ambos_, _upatrick_,
   {{0xa9f1e2c8,0x12f05012,0xf225447b,0x70e94180}},	//   _endiliga_, _bilioni_, _elekwa_, _これにより_,
   {{0xb7fab349,0xf168b122,0x9c43a065,0x2db2c2b5}},	//   _erobring, _monsigno, _שניצל_, _fixative_,
   {{0x5200b37e,0x62ca03a9,0xa2f00328,0xa9149214}},	//   _gidima_, _diida_, _kihiani_, _курстық_,
   {{0x9202720f,0x12a78234,0x0200b2bd,0xd9a3632d}},	//   _rusiya_, _farby_, _sidila_, _kākutsth,
   {{0x808fa13f,0xc0c23085,0xf4b8610e,0x3f414442}},	//   _במאגר_, _জগদীশ_, _proponuj, _agosanga,
   {{0x9b32e0af,0x62b352e8,0xdc6f701f,0x43ea7136}},	// [1900] _ジの先頭へ_, _cumarsái, _sarrafa_, _zinta_,
   {{0xe3876292,0xbbc34022,0xd340922d,0xc6b10210}},	//   _باردور_, _ءماجيت_, _beheren_, _absencew,
   {{0xc6b540a6,0xd08a42db,0xf2247171,0xef0ea33c}},	//   _उपायुक्त_, _принципл, _benki_, _молларин,
   {{0xf291c18d,0xc2ca0145,0x838771ca,0xb85240f7}},	//   _arvar_, _biidi_, _saaran_, _中文科技期刊数据,
   {{0x272e112e,0xa964406a,0x72e68378,0x8c04631c}},	//   _zapamięt, _प्रसंगी_, _manninn_, _opisati_,
   {{0x8051d441,0x218a8135,0xe3add052,0x1c5d2111}},	//   _условия_, _ብድፍረት_, _tāpat_, _sistemo_,
   {{0x127f429c,0x841b8009,0x8c71f0f0,0xb2765006}},	//   _siendo_, _nemiphak, _endroit_, _achikazi_,
   {{0xf29111d8,0x42da5187,0x853cb13f,0xd364710b}},	//   _sacara_, _potero_, _parallel_, _aragora_,
   {{0xae379148,0xf1807022,0x23614309,0x767b30a2}},	//   _kajahata, _باسۇدى_, _dungmaj_, _قرضاوي_,
   {{0xbee222c4,0x027ff463,0x24506088,0x8ecad03c}},	//   _विश्वासा, _uyuni_, _menduduk, _franchin,
   {{0xde329085,0x9fcd63be,0x86be5033,0x4355e00c}},	//   _কাজটা_, _процессе_, _chernomy, _elifasa_,
   {{0xe2903080,0xba887272,0xdbc0507e,0x32909171}},	//   _aymara_, _politess, _betydels, _wakazi_,
   {{0x63eb844c,0xf22601ec,0x6abd0291,0xd2fd404e}},	//   _sortu_, _diskit_, _لیندا_, _badget_,
   {{0x526c54f4,0x417e80da,0xe8bfc020,0x920172f4}},	//   _koloa_, _campagno, _affected, _iraila_,
   {{0xc290909c,0x92918185,0x826cd4b6,0x8f4fa246}},	//   _shaam_, _asram_, _dilots_, _atopetop,
   {{0xd31720c9,0xe387f322,0x52003207,0x1753558b}},	//   _skanning_, _aburu_, _ismini_, _abanjeng,
   {{0x427ef0e5,0x3660630e,0x4200c25d,0xbb6b7165}},	// [1910] _opinii_, _भिमसेन_, _bilima_, _ignorier,
   {{0x02247007,0x7b500252,0x326c10b2,0xd3ce0442}},	//   _senki_, _disminuc, _plhom_, _idiva_,
   {{0xfe725003,0xc273a4fb,0xf2a1d327,0x701c4428}},	//   _लास्ट_, _peribadi_, _alómìnir, _tilverun,
   {{0x9395f2a3,0xb3cf718b,0x024a6164,0x6a57c156}},	//   _mmuso_, _bhavan_, _kouman_, _лигата_,
   {{0x87e620ea,0xa347f2d4,0x1739c0de,0x093fe1c1}},	//   _अवार्ड_, _acherqa_, _меккеге_, _vermoede,
   {{0x5052c1b8,0xbe4ec1d9,0xe3f472db,0xf445b14c}},	//   _smartfin, _қанды_, _tertip_, _আনিসুল_,
   {{0x47a7329e,0x1e53614b,0x0378801f,0xd70583f3}},	//   _partenai, _inscrire_, _kananan_, _nakrantí,
   {{0x22017241,0xb997c264,0x4814b252,0xf2d8d027}},	//   _braila_, _hashjama_, _بئنادان_, _ardez_,
   {{0xe2fca453,0x724a72e8,0xd9aac00f,0xc26c1395}},	//   _skrivet_, _chumas_, _годин_, _hohom_,
   {{0x4e314078,0xc2489327,0x4c445155,0x6eca545b}},	//   _العتيبي_, _abamo_, _ﺳﻮﯞﯦﺖ_, _tranches_,
   {{0x3c734105,0x15a71103,0x484d4430,0x7eac1064}},	//   _מערבֿדיק, _bingaghh, _rəhbər_, _certaine_,
   {{0x4e76614e,0x7290443d,0xd27e62c2,0x25bd42ff}},	//   _ময়মনসিং, _ekman_, _zvone_, _dapabtah,
   {{0x21b3c096,0x97b4c2b3,0xf604a231,0xc2cbf127}},	//   _نادرا_, _menerang, _promieni, _emuloni_,
   {{0x9d27a252,0x9d99c2d3,0xddb8a200,0xfad4509e}},	//   _иранды_, _toropofa, _kuananka, _janković_,
   {{0xd2909076,0xac1630fb,0x053bc223,0x62a0c05b}},	//   _makani_, _निर्दिश्, _alhidaay, _پنامه_,
   {{0x32ca9582,0x3d9bd336,0xf3870365,0x8a5350c9}},	//   _tiada_, _alangava, _ataram_, _сертифік,
   {{0x52019246,0x738703c1,0xa7a760ac,0x63f8d238}},	// [1920] _pasia_, _klarar_, _디지털가전_, _dreuz_,
   {{0x0c9330d2,0x6ece90f7,0x0db8609b,0xb25b705f}},	//   _سالام_, _上海联放贸易有限, _calilaba, _alalia_,
   {{0xc9c17217,0x32ca02ae,0x12fc328d,0x64a143d7}},	//   _mendelee, _liidu_, _lolitas_, _अभिमन्यु_,
   {{0x31eb10af,0x20cb4228,0x13c8737b,0xf2936175}},	//   _マタニティ_, _مرکزیت_, _horvat_, _enskrir_,
   {{0x92019126,0xec60d137,0xbaf2e254,0x9ec250fb}},	//   _tasia_, _simulan_, _ascribit, _निर्वाणस,
   {{0x4c6a017d,0x82caf039,0xbc2b10b5,0x99d10510}},	//   _tammikuu_, _mynder_, _ارەدىك_, _abattidd,
   {{0xed1231a8,0x4291c4ec,0x8d9d614d,0xddd23287}},	//   _добрай_, _duvar_, _tunnusta, _добрае_,
   {{0x5379640a,0xf27f438b,0xbc4dc128,0xf290d19d}},	//   _batalha_, _cienco_, _brevity_, _shean_,
   {{0x9292426f,0x83003406,0x50ab9023,0xbde8e0ac}},	//   _kiwari_, _redakti_, _akummuuy_, _커뮤니케이션_,
   {{0x627863a5,0x73bc2174,0xac1b94bb,0x5d62d007}},	//   _ilungu_, _слободно_, _dilancar, _ندامت_,
   {{0xa9d7c1e4,0xe26c12a2,0xf56a303f,0x0c55800c}},	//   _kamehame, _lohok_, _ब्रह्मां, _eletise_,
   {{0xbbe67089,0xc291f02e,0x1984d2ab,0x1765617e}},	//   _ancestor, _ostaa_, _papildyt, _xiyyeeff,
   {{0x14d79008,0xcba79407,0xd5901171,0xa2019130}},	//   _хабары_, _blokkear, _kupunguz, _hasin_,
   {{0xa200e0bd,0x9c89017a,0xb3f470b2,0xcbeec14c}},	//   _geniet_, _সমাধানৰ_, _tustub_, _আলাউদ্দি,
   {{0x23ea7245,0x497fd30c,0xe290908c,0x797d7007}},	//   _zinto_, _feliceme, _skaam_, _hulladék,
   {{0xe291f5ac,0x02da049f,0x5340e2d2,0x13ea73a5}},	//   _artar_, _áreas_, _gelesen_, _yinto_,
   {{0xb2260019,0x4990c08a,0x326c73e6,0xab1853e1}},	// [1930] _diskut_, _abakwixe, _honoa_, _idealman_,
   {{0x820194b4,0x7200c0a4,0x2346c424,0x8fe97041}},	//   _fasin_, _wilika_, _gliders_, _تحقیقاتو_,
   {{0xf418a00b,0x02a7431c,0x3e79b214,0x82127395}},	//   _maannakk, _trebao_, _ارەنادا_, _wunhu_,
   {{0xa3218308,0x326d8374,0xd2cad279,0x3332d19d}},	//   _taryn_, _herod_, _kloden_, _etext_,
   {{0x13f4015e,0x1c2721d0,0xd9f4e06a,0xc077c26c}},	//   _laster_, _socaleur, _berstatu, _gospodin,
   {{0xc29161d8,0x426c5007,0x925b706e,0x8dbc909b}},	//   _nagara_, _dolog_, _कालावधीत_, _botarate_,
   {{0xf617d1c5,0xbef18003,0x891e133c,0x6280e0bf}},	//   _volendam_, _तनिको_, _جلریز_, _erishish_,
   {{0x7b6c748f,0x684282fc,0x26a2e057,0x227fb174}},	//   _imprensa_, _покрета_, _дестойни, _оставили_,
   {{0x8daa8086,0xf22472b2,0x79de2180,0x6f9b730f}},	//   _hovnanya, _venku_, _有料老人ホ_, _दस्तऐवज_,
   {{0xd60075b1,0xa37a20e9,0x6201409b,0xfc45f00a}},	//   _адреслар, _assasin_, _breina_, _comparis,
   {{0xb15c834c,0x0291603c,0xa559b0d7,0x2b968220}},	//   _induccio, _pagata_, _putinnıñ_, _rihindur,
   {{0xac620148,0x498c5022,0xff38c063,0xd245b3ea}},	//   _turunan_, _салынады_, _ваколатх, _sandalam,
   {{0xe30d41a7,0x1d4231d9,0x1429a059,0x9c0c80ac}},	//   _organes_, _болсын_, _እንዲነሳ_, _무이자할부_,
   {{0x2201913a,0xb6db0264,0x226e0085,0xb8a041bd}},	//   _pasin_, _رااااااا, _supone_, _celosvět,
   {{0xb201442e,0x874100f7,0x520190eb,0x43f8d238}},	//   _greina_, _政治交接学习教育, _basio_, _dreux_,
   {{0x4d2952e2,0x7d113005,0xe70cc0d7,0x8d8b90fd}},	//   _patisipe_, _устаноў_, _тоташтыр, _sikonsta,
   {{0xaffc310d,0xa3df5085,0xc5874372,0xe20192c1}},	// [1940] _спосаб_, _শেকড়ের_, _kastanak, _nasil_,
   {{0x4f02c2ab,0x2b61b067,0xdb1dc007,0x0d818290}},	//   _школы_, _emeliter, _الرجی_, _श्रोताओं_,
   {{0x0dcad01a,0x93f8b01f,0x5b1db0ac,0x6ea5100a}},	//   _июлда_, _kaduna_, _세계적으로_, _produces_,
   {{0x0386d3ef,0x542bb4e5,0x420190e2,0x6c52a21d}},	//   _conroe_, _agnatimo_, _rasin_, _विधेम_,
   {{0xa3900041,0x03191012,0xa01c314f,0x73073103}},	//   _المالکي_, _ميلاپ_, _nimittān, _bodameh_,
   {{0x42fa30e5,0x13423036,0x43870206,0x34432227}},	//   _kuchnia_, _accesso_, _quarum_, _프로젝트를_,
   {{0x49c0e246,0xf3160409,0xb291f0d7,0x8f20b0e7}},	//   _peresete, _amize_, _urtak_, _tshumisa,
   {{0x620192e2,0x7daa23aa,0xe200d3c9,0x2208e2dd}},	//   _fasil_, _pariwisa, _venire_, _abuyisel,
   {{0xf75325cd,0x034670a8,0x63eb808f,0xa340e5a5}},	//   _ngenyang, _liberec_, _porth_, _dilekan_,
   {{0x2291f005,0xe378107b,0x729190e2,0x59e0c2d7}},	//   _butas_, _abbabaa_, _miyami_, _bopolola_,
   {{0x12da05fe,0x04c07630,0x9bb590e5,0x89c8a14c}},	//   _buhleix_, _públicos_, _पंक्तियो, _বিপজ্জনক_,
   {{0xb2019004,0x13f8b23f,0x5c60224c,0x09ab401c}},	//   _kasil_, _caduna_, _shirkad_, _عموماًلو,
   {{0xf3f8c05f,0x026e1164,0xea09813f,0x32924076}},	//   _maluna_, _repons_, _combinat, _hawawa_,
   {{0x33169361,0xa378e148,0xb37a7114,0x3968a365}},	//   _imaze_, _kalayan_, _kitaran_, _dogoreie,
   {{0xed1c8100,0x53aa10cf,0x32019199,0x8355016f}},	//   _follicle_, _darating_, _pasio_, _necesas_,
   {{0xa3792004,0x0e8383a5,0x737a61b3,0xc378e146}},	//   _babagan_, _ndawonye_, _theatro_, _malayan_,
   {{0xd7b531d0,0xfe015455,0x3321803a,0xa291f090}},	// [1950] _wireimag, _armenara, _varye_, _kutar_,
   {{0x9bda42f7,0xbfc2d01a,0x4200b4ca,0x8ac3e0ac}},	//   _комитети_, _داروو_, _ledige_, _베트남경제_,
   {{0x59cba3d8,0xa71cc30e,0xa3eb8055,0xfb67904b}},	//   _emalunga_, _पारदर्शी_, _corti_, _سینماسی_,
   {{0xa2d43320,0x327ef36b,0x1ae110c8,0x4edb101a}},	//   _tailieu_, _seiner_, _projektą_, _digitals_,
   {{0xe7a543ff,0x34b4332d,0xf64182cb,0x92e6017e}},	//   _aspettav, _abhautik, _kusimami, _amantaa_,
   {{0x42011407,0xa968d26a,0x6bde1502,0x902e4133}},	//   _gebiet_, _estimate, _модераци, _kolemjdo,
   {{0x012411df,0xaaefe240,0x5c67c3d8,0x59d7c5a7}},	//   _הרבנים_, _adressub, _lilunga_, _définiti,
   {{0xd2fc126a,0xa4a5010a,0x7ad0c08a,0x8e35d1a1}},	//   _actually_, _فنڪارن_, _ورایه_, _israelwa,
   {{0x12489185,0xee015164,0x6291a0be,0x46423200}},	//   _paamu_, _komemora, _aspak_, _askiraki,
   {{0x92e95038,0x2291f2b7,0x12405214,0x97c98370}},	//   _artinya_, _cutar_, _جانۋار_, _баландта,
   {{0x0837c057,0x6b7c13da,0x30d11429,0x75a2d243}},	//   _халате_, _uncorrec, _autoeval, _bersangk,
   {{0x393b4437,0xbdbcc27a,0xea7f53e6,0xbcf762ac}},	//   _framtida_, _investíc, _purapura_, _جارجاره_,
   {{0x4847123c,0xcc7590e5,0x4290d106,0xb26c1273}},	//   _заради_, _तान्या_, _sheas_, _sohoa_,
   {{0xcb27b1c7,0x82e71230,0x5b9f6116,0xa65cc0de}},	//   _ﺍﻟﻌﺩﻴﺩ_, _moannen_, _शंभुनाथ_, _بەرچۉۉ_,
   {{0x7c0ba245,0x7b82424f,0xa35852e4,0xc27f7036}},	//   _amalungu_, _nuannaar, _seagame_, _bianco_,
   {{0x9212d1e6,0xcf0de443,0xc7ca6135,0xfa0a6287}},	//   _yudhi_, _trocitos_, _kompensi, _kompensu,
   {{0x0477a1ba,0x5695e009,0xd35500cc,0xd375d3d6}},	// [1960] _проекти_, _службы_, _recetas_, _окончате,
   {{0xe248d327,0xfd8ac0b9,0x51b422b9,0xd94a825f}},	//   _abemo_, _яраларын, _promessi_, _platonic_,
   {{0xc1cc005e,0x13c610a2,0x82c8b3e1,0x83eb830d}},	//   _anomasim, _باميانو_, _deroule_, _qorti_,
   {{0xf26c102e,0x43f4622e,0xa2480440,0x26b8a130}},	//   _johon_, _sarthe_, _abimi_, _mahamasi,
   {{0xcb060180,0x62016421,0x7200d5ee,0x129181ec}},	//   _glostrup_, _argina_, _laliny_, _kuraz_,
   {{0x6f340019,0xca1a0162,0x756791c7,0xc39502ae}},	//   _סטעיטס_, _پىشقان_, _англияда_, _alasti_,
   {{0x4ef161f6,0xf63c7329,0xc2da5223,0x89ebd0f1}},	//   _हाइकु_, _longtaim_, _luteni_, _undersøk,
   {{0x9b65b18a,0xa725b115,0x75fd3078,0xc37c5067}},	//   _utilizar, _utilizav, _monatóir, _debanye_,
   {{0xb2f101c0,0xc248900a,0xb2ae91cc,0x139501de}},	//   _anziani_, _obama_, _kazališt, _vlasti_,
   {{0x0d41b0ed,0x237242a2,0xe1f7b009,0x9e31a282}},	//   _ngabantu_, _dinggiz_, _загрузит, _נדברו_,
   {{0xafa6d092,0xc35f137c,0x4c687008,0x62fd01cc}},	//   _piomatlo, _yengere_, _билдирйә, _dragim_,
   {{0x131074ee,0x33d240ef,0xc57b40f9,0x928d7316}},	//   _kurziv_, _عبدالحسي, _sunnukvø, _barkada_,
   {{0x43ea517d,0x8291837b,0xddb7a21a,0x403fb2b5}},	//   _silti_, _buraz_, _рабочыя_, _festerin,
   {{0x539501c6,0xc248324a,0xc2da522b,0xb3cf5426}},	//   _klassi_, _nammen_, _isteri_, _drevet_,
   {{0x9aeec307,0x23028309,0xdb0d0546,0x93723121}},	//   _histolyt, _bidachu_, _composta_, _tahavad_,
   {{0xbaee14e0,0x5291f1d8,0x1bf2a2a7,0xd24a70f6}},	//   _rendesis, _ustad_, _تینگلب_, _barmak_,
   {{0x23ea71b1,0x57465328,0xa847c288,0xdab05131}},	// [1970] _hinta_, _maliglug, _тамаки_, _निगडीत_,
   {{0x398e22f7,0xce679022,0x4aa5a13c,0xe7aff032}},	//   _таҗик_, _саммиті_, _албаара_, _algerleg,
   {{0xa10325a5,0x62918238,0x9c46d1f3,0xcc90b09f}},	//   _bulgarän_, _auray_, _ورحمۃ_, _bakuling_,
   {{0x33cf505c,0xc297c17f,0xc2cad1f1,0xe378e30f}},	//   _krevet_, _такмил_, _miedo_, _jalanan_,
   {{0xf36de2db,0xb2cee23f,0xcebac3bf,0xac00e118}},	//   _sergisi_, _aramotz_, _топло_, _tsismis_,
   {{0xcb61f067,0x7a223140,0xead8e2f4,0x42924200}},	//   _amaliter, _авторның_, _kontsult, _lawata_,
   {{0x42564104,0x52ff5074,0xe3f8e141,0xf2d8e4b1}},	//   _যুক্তি_, _arritur_, _kanuna_, _jonesu_,
   {{0x037953a7,0x9a7de496,0xb29180c7,0x8379507b}},	//   _kuwaona_, _mahantra_, _furay_, _abdatan_,
   {{0xd68e73ec,0x027f4185,0x926c5250,0xb3f8c06d}},	//   _proffesi, _ahenfo_, _solom_, _kalula_,
   {{0x626c146e,0x4af7046a,0x7b8150d2,0xb3ea707b}},	//   _mlhos_, _enkundle, _associac, _binta_,
   {{0x7395f386,0x933b73df,0x2c9e00cb,0xa9baa011}},	//   _amusi_, _способом_, _ngogledd_, _абаксиор,
   {{0xd14a736b,0x48db4088,0x1200d12d,0x02d94045}},	//   _kostenlo, _diketahu, _valiny_, _abeera_,
   {{0xfabdf0b0,0x4e36c427,0xa7b9a065,0x35a2d32d}},	//   _pinjaman_, _красив_, _וקיבל_, _anarthik,
   {{0x2723132d,0xd6ac8262,0x78a321d9,0x1c3720f4}},	//   _vistareṇ, _bangambi, _سىلكىنگە, _پاسسىپ_,
   {{0x7ae2f407,0x32cbf2da,0xae3551e6,0x027ed258}},	//   _portugee, _soudu_, _mahadeva, _svend_,
   {{0xe27f4161,0x3e39f1ac,0x3c1de2af,0x82da61aa}},	//   _nhengo_, _mifanara, _bakantor, _bereng_,
   {{0xce14a2e5,0x0496c3ab,0x12573140,0x0c89014c}},	// [1980] _zamestna, _obrazovk, _cälil_, _সমাধানে_,
   {{0xfb092317,0x90dd605b,0xcc01322d,0x7fe7d30e}},	//   _gresiane, _ebonelel, _venster_, _समेटेर_,
   {{0x8dfbe38b,0x23e6d15d,0xe4d500a0,0x4130a0f7}},	//   _nukeviet_, _فانتزی_, _هنداره_, _基本比萨汁_,
   {{0x9766a0ac,0x429122f8,0xd28ad1d9,0x52d1a3a4}},	//   _마찬가지로_, _aiyaz_, _тілек_, _zamorak_,
   {{0x59dfd0aa,0xf26c71cd,0x75691471,0xd0dd6245}},	//   _duuuuuuu, _honom_, _настройк, _ibonelel,
   {{0x7e03c192,0x6ed160de,0x226c7082,0x3f26c3e4}},	//   _чемпионд, _ئلوسوفى_, _konom_, _amituana,
   {{0x018dd2c9,0x0c4590e7,0x427f7012,0xd3f40300}},	//   _probleml, _manwalo_, _chanzo_, _justis_,
   {{0xb3f8c217,0x62d83646,0x94561138,0x0317742c}},	//   _saluda_, _yamema_, _pravilan_, _grundlag_,
   {{0x02019266,0x52ca9335,0x22a060bf,0xf28891b5}},	//   _kasia_, _giada_, _shubha_, _дейсің_,
   {{0xd26e101a,0xbbe333d0,0x814871bf,0xe9f6c378}},	//   _suport_, _голлон_, _комуникэ_, _umtalsve,
   {{0xdc463288,0x79da5148,0xf29261f1,0x1c036185}},	//   _کریمه_, _sedengke, _verano_, _bempong_,
   {{0x3147d17f,0x9340e42a,0xc9596031,0x3b6d3370}},	//   _заминаи_, _gelegen_, _ጨረታውን_, _abathola_,
   {{0x097a3335,0x027133ec,0xcf21215e,0x12916195}},	//   _musicist, _llanelli_, _espedien, _magadi_,
   {{0x786d7377,0xf2912177,0x926c70e4,0x7068121d}},	//   _दरोगा_, _miyay_, _bonom_, _बालपृथग्,
   {{0x0e0b201a,0xaaa79173,0x42014099,0xa2d63003}},	//   _aliments_, _balkanab, _vediet_, _selleks_,
   {{0x238fc31b,0x43877423,0xadd55009,0x8341000c}},	//   _itoyota_, _waarin_, _yakhutha, _aepeita_,
   {{0x53ea7394,0x477f312f,0x6340e168,0x937841fe}},	// [1990] _sinti_, _نەشرى_, _geleden_, _aadamaa_,
   {{0xe2fe640a,0xe22572b8,0xe2eb91de,0x53f331f3}},	//   _cargue_, _skakel_, _velikim_, _خطبات_,
   {{0xfa45c2ca,0xb249f1fa,0x72258005,0x1063c043}},	//   _finestra_, _ahuma_, _perka_, _золото_,
   {{0xfe68416e,0x33ea5378,0xc971b030,0x429122e9}},	//   _дискусиј, _viltu_, _استقامتگ, _biyay_,
   {{0x75704526,0xa321e045,0xdbf0e12e,0xbe469047}},	//   _elawulak, _batyo_, _internec, _obusungu_,
   {{0xd26c51b9,0x527e031b,0x83f9755b,0x9d6c2198}},	//   _koloi_, _uwine_, _frauen_, _титулата_,
   {{0x234c214c,0xc84e11cd,0xe8f5f3c8,0xbd0531ed}},	//   _কেশবপুর_, _hittills_, _chinadaq_, _okruglar,
   {{0x1e2312c6,0xbc7f40f7,0xb290301f,0x437f8293}},	//   _germanos_, _返回黑龙江主站_, _mamaki_, _muhanda_,
   {{0xfc26d579,0xdc32b5bc,0xd26ca13c,0xb2f0d322}},	//   _avançada_, _ababarir, _amboy_, _batilih_,
   {{0x329243d9,0xf3eae091,0x72ebd052,0x698c2186}},	//   _ngwana_, _kontan_, _bizness_, _imihanda_,
   {{0x599d11b9,0xe1e7e345,0xe290919e,0x66372340}},	//   _башын_, _उधारी_, _takahi_, _татиана_,
   {{0xb2fd60bb,0x0378e0e3,0x53f99081,0x028d002d}},	//   _ligger_, _malaman_, _assut_, _turkija_,
   {{0x9f28d02a,0xa29270c0,0x5201d40d,0xa292001f}},	//   _dogmatic_, _basava_, _cawil_, _bisani_,
   {{0xd60190ee,0xfc5bf220,0xed153165,0xbeb90022}},	//   _cyklisti, _urutoki_, _klassisc, _поэзиясы_,
   {{0xf4978121,0x2173f358,0x72ec9280,0xe8c384de}},	//   _जम्मो_, _приходят_, _antiose_, _gemennad,
   {{0xa660736d,0xb310612b,0x6c1a12e8,0x2363c289}},	//   _汶川大地震抗震救, _kwuzie_, _thuarasc, _gregach_,
   {{0xab9281fd,0x28bfe0cc,0xe3ce9374,0x9551e0f7}},	// [19a0] _ingilizc, _enfermed, _ndava_, _山重水复疑无路_,
   {{0x82d70256,0x5af4645e,0x635bd018,0xe5dc0212}},	//   _gitondo_, _prosesse, _singura_, _ويتنام_,
   {{0xd249f647,0x3291f309,0xd3bb30de,0xce4d4478}},	//   _shuma_, _ostah_, _اسلان_, _pegatina,
   {{0xd723c606,0xf7c1e20a,0x62924203,0x25fa1447}},	//   _represió, _agasangi, _agwana_, _очистить_,
   {{0x22e610f8,0x56e8909a,0x375e6248,0xd9bff085}},	//   _buença_, _турмушин, _ኣማራጽታት_, _স্মৃতিচা,
   {{0x74c9c1f0,0x4eb0a405,0x63f97341,0xdb5cc55e}},	//   _белергә_, _farraige_, _trauen_, _abamalir,
   {{0x02499445,0x43f8f19e,0xe75e525b,0xd4737184}},	//   _rasmi_, _tahuna_, _umsiting, _mametrak,
   {{0x224893c2,0x5e38e2a8,0xde71514a,0x20f7a3be}},	//   _abamu_, _maramata, _deraafél_, _таблицы_,
   {{0x23f4715c,0x0658a34a,0x626c123a,0x02258135}},	//   _lauter_, _abangakw, _mohor_, _kerko_,
   {{0x1e3830b0,0x9eeaa3df,0xe4737184,0xd2da72ea}},	//   _rangkaia, _forvente_, _nametrak, _biseda_,
   {{0x52ca001f,0xaf64a009,0xea92509f,0x3186b072}},	//   _shida_, _выбрать_, _ananaias, _ustanovl,
   {{0x106921ba,0xc76fd009,0xe2a6d4be,0x6da5c42f}},	//   _competen, _изображе, _osobno_, _actionwa,
   {{0x3292001f,0x927862c9,0xc979a4b5,0x5341500f}},	//   _misali_, _olundu_, _طریقتس_, _lederen_,
   {{0xeff11178,0x8c662032,0x5ef180fb,0xd4692056}},	//   _miljoner_, _samtals_, _विद्यावि, _tshelago_,
   {{0x82cad0e4,0x52aef2a6,0xd2fdf256,0xb2008118}},	//   _siede_, _stratešk, _mwuga_, _likido_,
   {{0xb8b531f7,0x9fc0d052,0x534b73eb,0x815c20c7}},	//   _mintimer_, _literatū, _almennt_, _geeriyoo,
   {{0xc378e09b,0x025af081,0x49aac1bf,0xd2fe7238}},	// [19b0] _dalaban_, _isilik_, _моний_, _karget_,
   {{0x25e5e2a0,0xb35fa2d5,0xfdaa71fc,0x02d9a335}},	//   _هاملتۆن_, _airgiod_, _kontiniu_, _aspet_,
   {{0xdc6dd142,0xf2910246,0xd053c20e,0xe660e13c}},	//   _kupujem_, _faaali_, _молиме_, _акавалер_,
   {{0x7a06c2bc,0xf213f3a5,0x847371ac,0xe7e501e6}},	//   _vidareut, _kuthe_, _hametrak, _संचरति_,
   {{0x026ca199,0x12903012,0x884653c9,0x32d9a123}},	//   _pobol_, _samaki_, _doctores_, _espes_,
   {{0x03ea7045,0x73f901a5,0x12012048,0x1b4f31b6}},	//   _bintu_, _zabuna_, _kabiny_, _mammifer,
   {{0x927e0187,0xc10a5266,0x29ee6251,0x3fa7e2c0}},	//   _mwina_, _avakatol, _директни_, _bineegar_,
   {{0xcec2107e,0x198832bf,0x2956803d,0xe26c55a5}},	//   _eveneman, _amakarat, _مداخلې_, _golon_,
   {{0x2c29300e,0x9341005b,0x93a2e065,0x7f4e048f}},	//   _missiyas, _بچیان_, _biopsy_, _милениум_,
   {{0xe4dac446,0xec9321d9,0x527ee169,0x23ea7261}},	//   _можна_, _بايان_, _shingo_, _tintu_,
   {{0x3d20d19f,0x96cfb135,0x43e6c07f,0x720140ec}},	//   _ribosome_, _ዳንኬራን_, _степашин, _mediat_,
   {{0x227ed041,0xee3991fb,0xd27e056d,0xb3188316}},	//   _phondo_, _bahagara, _awina_, _ganitong_,
   {{0xb3ebe1fe,0xf6bb031e,0x92f40207,0x42f180b9}},	//   _sotti_, _antarpri, _indirim_, _kesildi_,
   {{0x426c50eb,0x939670ce,0x92a630b0,0xc2fc314d}},	//   _illos_, _versek_, _sambal_, _allikas_,
   {{0x7b9e4164,0xf1b5e2f3,0xfdb3334f,0x7f38f0f6}},	//   _prezidan_, _стандард, _annigiya, _петрус_,
   {{0xc2f99296,0x32247341,0x420093c0,0x538061f2}},	//   _kukhona_, _lenks_, _rejine_, _aftrat_,
   {{0xca1441a4,0xcdd9308b,0x634841c6,0x724a711e}},	// [19c0] _eliakima_, _وتمام_, _allerti_, _cosman_,
   {{0x3b99b0d2,0x27f4055d,0x612fe4d5,0x9d0984e3}},	//   _тарабына, _allaffig, _majorité_, _ngalinye_,
   {{0x026c50cc,0x8948c12f,0x4c66b13c,0x918a061b}},	//   _ellos_, _گۇۋاھنام, _bigtits_, _ewebatal,
   {{0xd20274a5,0xf1b4230d,0x4378b0b1,0x438dc264}},	//   _musiba_, _promossi_, _wajahan_, _أشجار_,
   {{0x426ca1de,0x83eb821f,0x4235216b,0xe1a2309a}},	//   _sobom_, _hirte_, _evidenti_, _بۆلەك_,
   {{0xceae90ac,0x39332342,0x1e86f034,0x6e2b8330}},	//   _쿠폰적용가_, _بإرسال_, _conviene_, _我也要用手机发表,
   {{0x63786126,0x922472c0,0x13ce004a,0xc340e168}},	//   _boganda_, _penku_, _ndivo_, _gelezen_,
   {{0xf291f01a,0x51072007,0xa01f4484,0x3301a193}},	//   _estan_, _فروری_, _phleboto, _disavow_,
   {{0x3c93c1d9,0x22008262,0x526c725a,0x0efe00fc}},	//   _ساداق_, _inkiko_, _monon_, _barwetsa,
   {{0xc3452060,0xa26c5496,0x337c9100,0x2d4ab15a}},	//   _handout_, _solon_, _detalye_, _चरिगढ़_,
   {{0x52c74241,0x8052e0ac,0x237881ab,0x5e5571a7}},	//   _masline_, _생각됩니다_, _nanaman_, _brochura,
   {{0x0b7f513c,0x4316d138,0x22d9a2b1,0x949873e5}},	//   _asunción_, _trebali_, _esper_, _holandsk,
   {{0x21e0a23f,0x5a20129a,0x31ad8105,0x9236d226}},	//   _ajustatz_, _mencerit, _רבֿקה_, _spojen_,
   {{0xef4e244f,0xba83b0ff,0xf2d86334,0x62c0e0c3}},	//   _политичк, _beginnen_, _nplej_, _poštovan,
   {{0x1e616086,0xf37f334e,0x7290c1d8,0xe27851b8}},	//   _seacrest_, _namanga_, _mulang_, _netnam_,
   {{0x9db031d6,0x83eb9086,0xb9fd001c,0x020dc11b}},	//   _abhaliwe_, _daytek_, _javaslat, _спомен_,
   {{0x8853f3ef,0xfe56300f,0x647ec17f,0x59f020c2}},	// [19d0] _hijacker_, _частини_, _симои_, _ananeloa_,
   {{0x222584df,0x5290d11c,0x26b87030,0x3e398249}},	//   _werke_, _theas_, _malakasi, _finamira,
   {{0x42bca490,0x42f041a8,0x52d98128,0x6ea1f13a}},	//   _mondyal_, _atlikti_, _arrey_, _pulumaot_,
   {{0xa2789006,0xe27aa166,0x4af86143,0xd62a03e4}},	//   _achipani_, _annimali_, _bafukame, _fatisisi,
   {{0xec616252,0x6386a012,0xdf320425,0x30af7241}},	//   _estudia_, _مالدار_, _barutaba, _animalel,
   {{0xc3ea53f7,0x739fb430,0x3bde0381,0x261f4252}},	//   _kilti_, _dövrdə_, _аоперати, _servirà_,
   {{0xb31690fe,0x02a62193,0x28a5c009,0x1d65c152}},	//   _amaze_, _nimble_, _сложно_, _словно_,
   {{0x39e8805c,0xbc5e31d2,0xd0c1f03d,0xbcd2c287}},	//   _učitavam_, _festval_, _abalasel, _скажа_,
   {{0x726c5134,0xd287d31e,0x02bbf1f1,0xe772f290}},	//   _bolol_, _bakkane_, _novedad_, _तेनालीरा,
   {{0x324a6033,0x53f40335,0xe30d8206,0xa291f1de}},	//   _poumon_, _paster_, _vivamus_, _ostao_,
   {{0xe26c70a1,0xf288e0e7,0x3b2d30ae,0x2e0b800a}},	//   _fonon_, _mulayoni_, _yaranmas, _elements_,
   {{0xaeb25120,0x826cc0c3,0xa372018e,0x3a5e2075}},	//   _seashore_, _vodom_, _galarad_, _štednjak_,
   {{0x963741e7,0xa37381b0,0x9c41a23c,0x049ba472}},	//   _politsei, _dodanie_, _уважение_, _tutulmuş_,
   {{0xbb3ca1b6,0x1248646a,0x2321e15f,0x2af71648}},	//   _འཚེངས_, _ubomi_, _hatya_, _гардан_,
   {{0xd2caf41f,0x7291f27a,0xa29260cb,0x7e4d713f}},	//   _angdi_, _ostal_, _straen_, _composed_,
   {{0xf3f46241,0xf9fcf256,0x728e2065,0x9287812b}},	//   _martie_, _kwandika_, _אוחיון_, _elekere_,
   {{0xf30362c0,0x7dc3a065,0x7069348f,0xe677c228}},	// [19e0] _dinañu_, _האנטי_, _compreen, _adikakaw,
   {{0x129091d8,0xa50c513f,0xcdf980e5,0x53fa51d8}},	//   _sakali_, _פרשנויות_, _आत्मकथा_, _kituna_,
   {{0x39d30015,0x6c686285,0x0af522b1,0x0eac612a}},	//   _distritu, _ennungi_, _larestas, _jerraise_,
   {{0x4f452031,0x2b42b418,0xb963a080,0x120b527f}},	//   _ለማርገብ_, _ababesis, _dicotyle, _حرارودی_,
   {{0xf3169069,0x5d1b308c,0xf114209a,0x3557e3be}},	//   _umaze_, _avonture_, _учрап_, _квартиру_,
   {{0x33eae04c,0x1303c0f5,0xeb597083,0xcf1e315e}},	//   _konten_, _bekannt_, _muntanya_, _hondakin,
   {{0xc3eae545,0x31f2446e,0x66392252,0x023873b2}},	//   _gifta_, _luangnam, _палатаны, _crimini_,
   {{0x927e02f2,0x6af22186,0x7f5d20da,0x8d9d3202}},	//   _evini_, _iciririt, _ottavian, _bluefame_,
   {{0x5f5bc221,0xf6b8709f,0x3d3c7649,0x220ed2f4}},	//   _inkampan, _ahlamisi, _फ्लॉप_, _садар_,
   {{0x437885d8,0xef2970a3,0xd7cf91b7,0x6e7aa0de}},	//   _sanajan_, _plattela, _abushiki, _мандатын,
   {{0x5762c1f0,0xd37892d4,0x8b635287,0x522e0090}},	//   _геройҙар, _achawan_, _paprasta_, _chavelel,
   {{0x1278819e,0xd2014130,0xc412d439,0x13d4227c}},	//   _kanikani_, _vadiny_, _diingink, _landbrug_,
   {{0xb3a301eb,0xbd16932f,0x5ef97248,0xd2ef5064}},	//   _ipaper_, _нетаняҳу_, _ኣጠንቂቑ_, _suffit_,
   {{0x4979f3c1,0x78429434,0x326f40de,0x1292621d}},	//   _gymnasie, _доброто_, _ەسترادا_, _agrato_,
   {{0x1249f5dd,0x0226630a,0xd950e04d,0xea57e0b3}},	//   _shume_, _burkim_, _aislinge, _краенда_,
   {{0xf305a333,0x12b49389,0xa386808d,0x2e387137}},	//   _članek_, _itace_, _ebazini_, _palakasa,
   {{0x4bcb723c,0x3dc7e336,0xc6f6a0d7,0x19f2b2fa}},	// [19f0] _commento_, _faahinga, _муллалар, _akahakwa_,
   {{0x0a07402e,0x13950344,0x61472128,0x04590275}},	//   _tilantee, _amashi_, _colliery_, _биарамли,
   {{0x4f9e11ba,0xd2fd625b,0x4421912d,0x12027147}},	//   _родители, _riggar_, _misakafo_, _pusica_,
   {{0x926c10a8,0xe967346e,0x62489293,0x0034d14f}},	//   _mohou_, _immitate, _abami_, _abhedeno,
   {{0x0992c375,0x93012036,0xefc3b3db,0x77a6f0b3}},	//   _ресурста, _страната_, _regioner_, _migratsi,
   {{0x72cbf0ac,0x828d33fa,0x4f7401e9,0x726cc0b0}},	//   _houdt_, _aisatsam, _redakams_, _jodoh_,
   {{0x626c5100,0xd881b1e6,0xadfaf003,0xb2916239}},	//   _kolor_, _maheṣvās, _मर्माहत_, _magani_,
   {{0x4e2fa3ef,0xdf8180e8,0xb291d039,0x7b17d1a8}},	//   _berossus_, _हरुको_, _khwai_, _гандаль_,
   {{0xf26c5206,0x8380658e,0x50588106,0x7247f036}},	//   _dolor_, _terrie_, _donaldso, _кариери_,
   {{0x8b9e73a3,0x025ad04b,0xda85333c,0x66f910c8}},	//   _zaciatoc, _adolat_, _روحده_, _балтыйск,
   {{0x19438492,0x43636004,0xe2e5f2f8,0x0201b216}},	//   _spillere, _munggah_, _fainala_, _zivila_,
   {{0x99d5a105,0x7c617124,0x721cc579,0xc0bed076}},	//   _יודלס_, _jesuita_, _ئيىتكەن_, _elemakul,
   {{0x6a10318a,0xa5a3e36b,0x52d9f398,0x6fe36019}},	//   _consiliu, _versandk, _estes_, _venkinto,
   {{0xdeb630c9,0x49f560ee,0x43fa643d,0xdb056078}},	//   _системі_, _orgán_, _kiruna_, _íosparta,
   {{0x226c7199,0xf201a492,0x33329243,0xdc292033}},	//   _annog_, _bevise_, _craxi_, _crespons,
   {{0xc26c54cb,0x12c53177,0x60ec2335,0xc34123c8}},	//   _polos_, _agilibe_, _uffizial, _daperha_,
   {{0x8c93325c,0xba1a53c7,0x83f30105,0x8ebe512f}},	// [1a00] _قامال_, _descuent, _זשוליאני_, _долларғи,
   {{0xc837d0ac,0x32e0234a,0xf29090db,0x4a071560}},	//   _반갑습니다_, _abanayo_, _bakaki_, _bakarnya_,
   {{0x2c0eb2e5,0xb29192ff,0xc389b026,0x33f95246}},	//   _skupine_, _lisay_, _vergelij, _tafuna_,
   {{0x63bbc48c,0x29aaa031,0x753070b3,0x8290919e}},	//   _akowara_, _መለዋወጥ_, _nomerlı_, _nakahi_,
   {{0xc23d50ac,0xd1525357,0x43f8c1d1,0x027f0121}},	//   _필요합니다_, _evelslay_, _talula_, _omanik_,
   {{0xa74651d4,0x25fe108a,0xc224e314,0x63e111bd}},	//   _malillug, _مسلمانو_, _linkuj_, _भर्त्सना_,
   {{0x3ad614a1,0xa26ce238,0x82d9f1fd,0x02dde337}},	//   _pretplat, _benoni_, _ister_, _potomci_,
   {{0x238992bd,0x7394f402,0x129192ff,0x938712ed}},	//   _lenyalo_, _yinsiz_, _bisay_, _librat_,
   {{0x3d9a42b8,0x1c24d1ca,0x2e5ce031,0x55bbe083}},	//   _heeltema, _صبحٕچ_, _ከማመልከቻ_, _مۉنۅزۉ_,
   {{0x58ba913d,0xeab6f0ac,0xf3f40428,0xd2a63029}},	//   _göttinge, _올려주세요_, _fastir_, _sambel_,
   {{0xc6c90134,0xec51c36f,0xc729344c,0x82d67084}},	//   _assalaam_, _akotisa_, _зоорь_, _alamọ_,
   {{0x035331d9,0x5afb24e9,0x73860076,0x2249f313}},	//   _تۇرار_, _etermine, _seira_, _saumi_,
   {{0x63eac01b,0xd290d238,0x4d1b5031,0x61a9e113}},	//   _soltan_, _selaou_, _የካንሰር_, _personāl,
   {{0xace0a300,0xac68004d,0xf292419e,0x82efb142}},	//   _divizoù_, _earrann_, _wawata_, _ovulacij,
   {{0xf387f18a,0x1394f250,0xc290f120,0x6e6e6292}},	//   _scurt_, _elisai_, _duhang_, _chaqaloq,
   {{0x02d9f0e4,0x0ed6c288,0xde5b32f3,0x68c0632d}},	//   _aster_, _karimovn, _странка_, _aditiruv,
   {{0xfc85b00a,0x9710d0ac,0xec6152b5,0x82ca6161}},	// [1a10] _שווים_, _고객센터의_, _decreed_, _choda_,
   {{0x0d9901fd,0xaeb641f8,0x22924148,0x92cbd02a}},	//   _reklamla, _gradonač, _kawasa_, _dowdy_,
   {{0xf3169125,0x1b7fb168,0x3fbfb349,0xdc0db123}},	//   _amazi_, _reageren_, _reagerer_, _destriks,
   {{0xa2ca0003,0xac5c81d0,0xc61c813f,0xe213f2bc}},	//   _saidi_, _footbal_, _football_, _authn_,
   {{0x920e115e,0xb87b90e5,0x02d8c521,0xfbe41369}},	//   _хатан_, _पन्द्रह_, _ommers_, _greencar,
   {{0x6aa2d2bd,0x63f8f463,0x79289162,0x28c1c0fc}},	//   _авторлыҡ_, _achura_, _еливатим, _мәкерле_,
   {{0x929191d2,0xa2d8c22d,0x2f81a23c,0xcad76007}},	//   _eksam_, _immers_, _mercatin, _کاربند_,
   {{0x62008262,0x82d4734d,0x22e94111,0xfc05e2c6}},	//   _mikino_, _mardor_, _antikva_, _cursori_,
   {{0xa213f1e2,0x55cd70e0,0xc04712ca,0xcacfa15a}},	//   _lutho_, _दूरदर्शन, _натого_, _जनपरिषद_,
   {{0x224a6607,0x73416365,0x4474b3ba,0xfce2541f}},	//   _dermed_, _deretta_, _manekenk, _chavghac,
   {{0x68f8b15f,0xa290d23b,0x9a3500f0,0xe26cc111}},	//   _havakatu, _akeai_, _caractér, _kodon_,
   {{0xe3ebe3b3,0x8557a019,0xd9b5a385,0xe2025079}},	//   _mitte_, _מתפלל_, _mendapat, _nitish_,
   {{0x6ae885b9,0xd3ebe071,0xbb7d907b,0x57ac81c6}},	//   _अन्वेषण_, _litte_, _monosacc, _difensiv,
   {{0xb290d2f9,0x72fdf184,0xfda62275,0x925b0008}},	//   _renaud_, _miandry_, _بىلوگ_, _adalat_,
   {{0x4ad5e39d,0xd316d220,0x87e092c4,0xddf52431}},	//   _marković_, _ameze_, _पॅटर्न_, _conduite_,
   {{0x627e9370,0x5e8fe44f,0x626c518b,0x9e08d0b3}},	//   _zwane_, _projetos_, _doloi_, _soldatla,
   {{0x391fd21d,0xd5444251,0x89cfc2ac,0x43f8c356}},	// [1a20] _उदाहरणः_, _изложени_, _خماخه_, _saluma_,
   {{0x227e6431,0xd61ea290,0x92d9112e,0x998770af}},	//   _avons_, _परिणामों_, _reklamy_, _厚生労働省_,
   {{0x49ebd3b0,0xbb4ff1a1,0x727e902d,0x52f465e7}},	//   _undersøg, _arameter, _lvant_, _jornais_,
   {{0xfc7641d0,0x13021475,0x4c75e4a3,0x03a973b4}},	//   _rigueur_, _menantu_, _formátu_, _bogareng_,
   {{0x1c2c10b5,0x226ca08f,0x3fe33004,0x126e53ef}},	//   _ﺳﻮﺗﺴﻴﺎﻟﻴ, _bobol_, _سانتي_, _autome_,
   {{0x435f2002,0x5a7ee1c2,0x6f291428,0x7ea71238}},	//   _langage_, _cerdeña_, _akureyra, _dielfenn,
   {{0x908cd022,0x42cb11cf,0x1e90a057,0x72edb00e}},	//   _мамандар_, _braddy_, _единтелу, _yetirib_,
   {{0xf29191d1,0x750a60bb,0x3f30d0ee,0x6c90f1ad}},	//   _hayani_, _програмн, _satelitn, _scouring_,
   {{0xa2d4d013,0x26917111,0x915301a1,0x2ad17338}},	//   _дмитриев_, _normalaj_, _upplysay_, _normalan_,
   {{0xc3ebe1f7,0x7378b157,0xe378e376,0xa28891d9}},	//   _kitte_, _jajahan_, _kalaman_, _жемісін_,
   {{0xc3ce04cf,0xf2ca9134,0xd37a0062,0xf2fc90d2}},	//   _sliva_, _ahada_, _tafafao_, _entitat_,
   {{0xf31132f5,0x93f40030,0x736523a1,0xc2d4103c}},	//   _baibait_, _dastur_, _abeegunj, _accorta_,
   {{0x82f7130f,0xed5eb1c7,0x2efdf111,0x4c1950fb}},	//   _ंत्री_, _кодексін, _kalkulos_, _पार्किन्,
   {{0xf2b4019d,0x0249f041,0x298ef07f,0x12ca0339}},	//   _trice_, _ubume_, _аҧшыхәра, _naidu_,
   {{0x7e3b0181,0x93960363,0x6dee306a,0x92d8c48e}},	//   _biragara, _jessop_, _संप्रदाय, _arlein_,
   {{0x5394e49c,0xaa1fa3be,0xb3f8b176,0x5e2fb252}},	//   _uaisle_, _основные_, _paduka_, _europeus_,
   {{0x62e6e03a,0xd5c85031,0x02d911bf,0xa52470f4}},	// [1a30] _amontan_, _ሥልጣኑን_, _accesa_, _ﺳﺎﺑﯩﻖ_,
   {{0x9342f0a8,0xdc60a390,0x7eafa39e,0xf281b114}},	//   _kulturní_, _akkuman_, _parlawin, _dibahagi_,
   {{0xdfe33078,0xc4665221,0xd0aed252,0xf200d3b2}},	//   _ثابتة_, _sisebenz, _урмат_, _fenice_,
   {{0x2d963196,0x39563196,0xc129f1ed,0xf3ea530b}},	//   _bakoitza, _bakoitze, _germaniä_, _tilts_,
   {{0xe200c226,0xf249f266,0x4f07b180,0xb373a2b7}},	//   _velice_, _taumu_, _placeres_, _magance_,
   {{0xfc624049,0xade5c2c3,0x9e3860ce,0x1c0eb095}},	//   _aparece_, _афиша_, _hamarosa, _despise_,
   {{0x62255378,0x19879422,0x77ade50a,0x7201b469}},	//   _frekar_, _innkeepe, _trpezliv, _deviat_,
   {{0x52fe41e6,0x028d60fd,0x9611f168,0x22df81c6}},	//   _labhate_, _poukisa_, _kwalitei, _adegwati_,
   {{0xc305c0c7,0x14ea8358,0x91b4c25c,0xd2916137}},	//   _اوراد_, _закончил, _аздап_, _kagabi_,
   {{0x827f728d,0xe2d83368,0xbe38d2bc,0x226cc517}},	//   _mhando_, _memeim_, _datakata, _veloci_,
   {{0x7b615050,0x7daf60fd,0xc29202bd,0x6d23f193}},	//   _快去看看吧_, _ansiklop, _basadi_, _bediente_,
   {{0x926ca191,0x8248d0a0,0x537a00ae,0x0f701080}},	//   _anbod_, _abemi_, _haradan_, _ankallis_,
   {{0x10d99009,0xb9f2c2e1,0x9b2d5180,0x42d4706a}},	//   _заболева, _amaradid, _ステップマット_, _carder_,
   {{0x037f919e,0x4ae0f0db,0xddaa034e,0xedf63256}},	//   _pakanga_, _mesebets, _ганисози, _banditse_,
   {{0x35b9e1e2,0x15a291e6,0x53f9f12b,0xaa73223b}},	//   _хизматра, _झटिति_, _kruuz_, _kanavata_,
   {{0xc985a13e,0x684ca308,0xf205a0e8,0x214c042e}},	//   _polityka_, _bhumabhu, _polityki_, _almennil,
   {{0x951cf0bb,0x82d470f0,0x5ba150ae,0x02777005}},	// [1a40] _доступни, _garder_, _dostları_, _бухгалта,
   {{0xe26d143f,0xa1750110,0x738741e0,0x3d716198}},	//   _neboli_, _propesyo, _exerci_, _palmeira,
   {{0xbae3e436,0x342133c0,0xf25b44ee,0x4c05f041}},	//   _hujuraat, _lekanego_, _čelsi_, _abarhweb,
   {{0xbc172024,0xd27ed0fb,0xe81a4217,0x22e9e29f}},	//   _पूर्वोक्, _svena_, _тәрбиялә, _bolingo_,
   {{0xddfdc288,0xc92782a0,0x954b7007,0x92da5224}},	//   _الستر_, _پانێڵی_, _könnyű_, _potego_,
   {{0x16359546,0x33a2306e,0x32304256,0xfa428375}},	//   _económic, _sempat_, _kwemera_, _аталатын_,
   {{0xb3169262,0x206f11ab,0xc27f4075,0x071b3036}},	//   _amazu_, _makatulo, _imenik_, _спира_,
   {{0x78e79135,0x9bd5d17d,0x3ffc60e5,0xd3eae111}},	//   _ገብረድንግል_, _рублей_, _अधिकारों_, _konton_,
   {{0xf3f89069,0x205a500b,0x0234b08d,0xf1013043}},	//   _inkuru_, _missaann, _avumune_, _свете_,
   {{0x8395418a,0x5bee329b,0x127f70e7,0x97a4c214}},	//   _aceste_, _салом_, _shango_, _ءﺑﻴﺪﺍﻳﻌﺎ_,
   {{0x43a23385,0x5291d395,0x466c7105,0x79aa304b}},	//   _tempat_, _ahwam_, _בניברקער_, _сокин_,
   {{0xff3b708e,0x696c200a,0x3d11216e,0x927e935e}},	//   _cingsaen, _affiliat, _остало_, _awana_,
   {{0x4201404b,0x03eae004,0x1376d23c,0x637a0257}},	//   _badiiy_, _nonton_, _христов_, _yaradan_,
   {{0x498b0405,0x2292701f,0xb3eb82e5,0x2553f221}},	//   _roghanna_, _nasara_, _torty_, _abakheth,
   {{0xa7881012,0xd3ce95f6,0xf3a2521d,0xa38060f9}},	//   _نوجوانن_, _heave_, _kalpa_, _spurdi_,
   {{0x91ad4330,0x9368c43d,0x1c01b48e,0xe6c7f2f4}},	//   _中华全国妇女联合, _prognos_, _allgymor, _eleberri,
   {{0x4c76a400,0xaaf7c15e,0x83f8e0b4,0xf88f5287}},	// [1a50] _महत्वप_, _нандин_, _kanuha_, _спатканн,
   {{0x224da3d7,0x52e940fd,0xfcb99308,0x72927239}},	//   _पुतला_, _grangou_, _gazaland_, _basasa_,
   {{0x34087205,0xac1721e6,0xd9c521b3,0x068fa248}},	//   _exertion_, _पूर्वोत्, _arretrat, _ደጋጊምና_,
   {{0xe09801bc,0x528ed04c,0xf21d3447,0xe056d3df}},	//   _نوپوسى_, _اصالت_, _самую_, _betraktn,
   {{0x9a0de07c,0x194b810e,0x53821013,0x01f9a0d2}},	//   _zizakuba_, _prioryte, _амандари, _дармекте,
   {{0x13f475e1,0xd22bc01f,0x2d8e31b3,0x8b6ad007}},	//   _frutas_, _taimake_, _incombra, _افتادہ_,
   {{0x1ef8f007,0x8af0e455,0xe6de61d3,0x3aa9a26e}},	//   _خوردنی_, _adresses, _precauzi, _заплянав,
   {{0x62b1c3a2,0x8a0402e8,0xca1ed0f7,0x32020110}},	//   _brodova_, _cumasait, _亿元人民币_, _pipila_,
   {{0x826c526f,0x4cbec005,0x6f84c3ab,0x73954198}},	//   _kolot_, _намер_, _záchrann, _acesse_,
   {{0xfb7a24ac,0xb37e7252,0xa3f8f1e4,0x01ac02b2}},	//   _presenza_, _бараткан_, _mahuka_, _studijní_,
   {{0x1316d181,0x32b49058,0x096a6063,0xad76d264}},	//   _amezi_, _ataco_, _самарадо, _اردني_,
   {{0xdb1fc2a1,0xacb752a2,0xa83bf022,0xb364109a}},	//   _kalangan_, _riunyumq, _холдингі, _ئويما_,
   {{0x47643328,0xb3f901ab,0x7d05c2a6,0x8341845b}},	//   _arnitaig, _pabula_, _operater, _eternità_,
   {{0x7fd7412f,0x63ce01a5,0xd52cd2a0,0x22729223}},	//   _ﻗﻮﻳﻐﺎﻥ_, _ilive_, _ساڕێژ_, _mafisadi_,
   {{0x365e1225,0xb1db9132,0x2c6e61de,0xd4e4a0f7}},	//   _писма_, _авокаць_, _nagrada_, _先进生产者_,
   {{0x6b86553f,0x63574304,0xca5343b6,0xf2c201b0}},	//   _istočnoj_, _ditegur_, _सुपरस्टा, _skalica_,
   {{0x1d03f0af,0x570220ac,0x4d24a182,0x4e39926f}},	// [1a60] _リスト作成者_, _허브차입니다_, _aparāmṛṣ, _mahabara,
   {{0xa3f90387,0x5986e11e,0x6a070262,0x12027171}},	//   _aabuja_, _cochecit, _ambasade, _husika_,
   {{0x734222a0,0x3e398004,0x77a8324f,0x57fde0f7}},	//   _پێشخستنی_, _hanacara, _kattunni, _深入贯彻落实科学,
   {{0xb3f8e592,0x87be02e9,0x586021fc,0xc3ea7089}},	//   _manuia_, _anggarrg, _atanguru, _pints_,
   {{0xea7151ad,0x135ad0c0,0xd2fd62d5,0xf2f3c065}},	//   _sillines, _chifras_, _biggar_, _inhibit_,
   {{0xd719e64a,0x522a900a,0xf27f041e,0x56b60175}},	//   _komuniká, _forming_, _clanek_, _persepsy,
   {{0x72cae2f4,0x73e3a282,0x9c18e0bf,0xd974c30d}},	//   _handik_, _ארוסה_, _yakshanb, _ambigwit,
   {{0xe3ce00af,0xb213f24e,0xc89a324b,0x92ea6464}},	//   _blive_, _kutha_, _цветов_, _fusión_,
   {{0xd2eb10e3,0x7795c244,0x4c6d8285,0x3f1d939c}},	//   _soriano_, _chitamax, _afirika_, _башламчи_,
   {{0x204fd198,0x226ce07e,0x9f5891f8,0x53ecd0c9}},	//   _односно_, _annons_, _najproda, _посольст,
   {{0xd755d1e7,0xe2573085,0x0b59a1dd,0xa2927005}},	//   _positiiv, _নেক্সট_, _basulawa_, _vasara_,
   {{0x7291f0b2,0xb442606a,0xc31704ff,0xd8883442}},	//   _thuam_, _उत्पादका, _frazil_, _akakavad,
   {{0x72ecf103,0x4657b086,0xc95be41e,0xd62aa0aa}},	//   _bivihbe_, _sidyodth, _fotosout, _bazitiri,
   {{0xe853614f,0xc22ba0af,0x844a0370,0x0af613c1}},	//   _पूर्ववत्_, _formand_, _косоворо_, _leverans,
   {{0x0394e0a1,0xadc4b26c,0x49cb103b,0xfab92096}},	//   _teisha_, _oblikuje_, _alilunga_, _paraméte,
   {{0xe3cef007,0x419514d6,0x8143b053,0x787f70ac}},	//   _privit_, _peaceabl, _innerhal, _롯데포인트_,
   {{0x82cbd0a1,0x1beb7126,0x12b6b5a3,0x5f707002}},	// [1a70] _balonka_, _hollengo_, _studije_, _binapnis_,
   {{0x7644a0f3,0x82a774e5,0xc7a73218,0x2ae3a0af}},	//   _arricchi, _agabul_, _مفارش_, _overhove,
   {{0x5b1a7248,0xe37a01ac,0x64202050,0x03a27123}},	//   _ሓንጎሎም_, _karazan_, _一個人真正的偉大_, _kanpa_,
   {{0xe2e71395,0x5fbec0e8,0x13e78159,0xb30060f9}},	//   _amansan_, _znalezio, _látom_, _munandi_,
   {{0x9b0bf0d6,0x798bf5b5,0x276890e0,0xd25ae39b}},	//   _страны_, _страну_, _विद्महे_, _beilwe_,
   {{0x2278639b,0x95030120,0x863da031,0x627ed07d}},	//   _maungo_, _freefall_, _እናገራለሁ_, _ivent_,
   {{0x9b86553f,0xe442606a,0x6fe7a427,0x32b4d3f5}},	//   _istočnom_, _उत्पादना, _правят_, _steck_,
   {{0x588ae02f,0xb9de813b,0x096874ec,0xba9732f4}},	//   _وسايل_, _nakuatuu, _gaziante, _зэхэж_,
   {{0x9eb6c299,0xf0ec223c,0xc394f288,0x491ec15d}},	//   _профила_, _ufficial, _ilishi_, _علمیه_,
   {{0x13ebe4f1,0x02d474e5,0x5d6f0294,0x82ca4364}},	//   _titta_, _dardar_, _niamhlua, _camdu_,
   {{0x327ad122,0x599eb36f,0x97cef182,0x4287b1e7}},	//   _mensuell, _baiketla_, _adhīkārā, _olukord_,
   {{0x9a8d117f,0xceefb0de,0xa27e9113,0xc4fbd06c}},	//   _апрели_, _ابونىتۇ_, _zvani_, _कुटाला_,
   {{0x5497e069,0x926c709b,0xfae1f086,0xb2cbf1bf}},	//   _bitanduk, _konot_, _destitut, _ciuda_,
   {{0xea7211e2,0xfdc742a7,0x4c35d229,0xe0603308}},	//   _аксиз_, _نادرشاه_, _планове_, _etisudin,
   {{0xb2118392,0x838602b9,0xfecbb120,0x74123435}},	//   _बाभळी_, _deira_, _crunchin, _akanisak,
   {{0x9516213f,0x4c7c81fe,0xe94d02d2,0xf0f630a0}},	//   _ביאליק_, _emisyon_, _ansonste, _ضعيفه_,
   {{0xa386046f,0xcd8a049d,0xace27019,0xf2d6040c}},	// [1a80] _feira_, _allerede_, _אַרכיוו_, _fluorin_,
   {{0x938cf0f3,0x929032d9,0x4c742105,0x527e931a}},	//   _agostini_, _kumase_, _באגייט_, _uvani_,
   {{0x60e542cc,0xb2304009,0x03ea708d,0x14b350f7}},	//   _श्रीवा_, _ngemida_, _banti_, _中国科学院_,
   {{0xb3ce664b,0x93b0d549,0x8200b2a6,0x82d9400d}},	//   _olova_, _dunque_, _medije_, _ajeeri_,
   {{0xc2258378,0xa291d18b,0xa8de40b5,0x93717202}},	//   _merki_, _ikwah_, _ءسۇننات_, _silaing_,
   {{0xbce9f022,0x7b6032ae,0x052a0101,0x4e3fa013}},	//   _патентте, _लिहनी_, _estimasy, _biformes_,
   {{0x43ea7134,0x55d62405,0xe26ce0c6,0xc8590085}},	//   _fanti_, _deacrach, _fofor_, _estrenos_,
   {{0xf471f197,0x42cad117,0x1c25f0aa,0xcc837258}},	//   _rantaian_, _theda_, _araborer, _sammisaq,
   {{0x72e6e148,0xd01631aa,0xfaf961ba,0x62ca0459}},	//   _omongan_, _хатында_, _attualme, _ibido_,
   {{0x22903182,0xdfaad248,0xd0e8e07e,0xe5583221}},	//   _sumate_, _በስገዳድ_, _nationel, _abakhaph,
   {{0x675a900f,0xe19e7009,0x62b405ec,0x8fb82218}},	//   _скачати_, _возникно, _arico_, _blagadói,
   {{0xb2fd6642,0xd497e1ee,0x3340201a,0x7396020e}},	//   _liggur_, _zitanduk, _recerca_, _possui_,
   {{0x8698f0af,0x46ec6418,0x4b642249,0x6da971a1}},	//   _メルちゃん_, _ababezof, _cuntrada_, _unningra,
   {{0x22b55339,0xfb33021d,0x7eb4d1da,0x42e81122}},	//   _preces_, _puruṣa_, _kwaranze_, _incinta_,
   {{0x1292022c,0x12b46122,0x303f70e3,0x928d116e}},	//   _masani_, _croce_, _annulmen, _направио_,
   {{0x1c292248,0x420261e6,0x138710be,0xd26ca0ee}},	//   _ባርነትን_, _shriya_, _librit_, _dobou_,
   {{0x63b0d35d,0x803b6609,0xeb8de12b,0xf365d15a}},	// [1a90] _aunque_, _wewengko, _achikoro_, _एलआईसी_,
   {{0xa2ca9364,0xe26d825a,0x62c750f7,0x1ea4a13f}},	//   _gaadi_, _horoj_, _任何单位和个人不, _attempts_,
   {{0x645f510f,0x726ca175,0xb3ea5113,0xa26ce33e}},	//   _ellenkez, _nobou_, _baltu_, _bofor_,
   {{0x1ee7a46a,0x42fc93d5,0xa4ac31fd,0x0ec3b045}},	//   _ngokulan, _innovasj, _fiziksel_, _abonabon,
   {{0x7d82421d,0x9772730f,0x13ce6295,0x53a80105}},	//   _विज्ञायत, _सामान्या, _ulova_, _פענענקו_,
   {{0xb26d84a5,0x461d0080,0x1213f0e7,0x53ea709c}},	//   _borom_, _willachi, _muthu_, _wanti_,
   {{0x23ea7055,0x82f1b196,0xdea4c008,0xa7cd211c}},	//   _tanti_, _стратеги_, _аларман_, _leasainm_,
   {{0x70665051,0x2ec901ad,0xe224e39e,0xec05f15a}},	//   _cumberso, _disingen, _munkta_, _aparaty_,
   {{0xf17672aa,0x182dd12b,0x437b01ac,0xde2f9421}},	//   _frantsay_, _agumakwu, _hitanao_, _aangawaa,
   {{0xf9a5910e,0x3e194525,0x6c3bd031,0x13acb1b5}},	//   _बेल्जियम_, _guvernma, _የቅስቀሳ_, _اشىنىشتى_,
   {{0x2305c591,0x5d405342,0x53ebe012,0xb35f330c}},	//   _توپان_, _molaimid_, _zitto_, _frigide_,
   {{0x33869057,0x42c4201d,0x7f42f64c,0x1d05864d}},	//   _seara_, _heiland_, _traslada, _adelante_,
   {{0xbdae013e,0xa5bd61cd,0xe17e2065,0x57f9c1e8}},	//   _सांख्यिक, _tillstån, _מוזילה_, _знаков_,
   {{0x926de278,0x86aa8026,0xc20e117f,0x693422c6}},	//   _kotoa_, _최근검색매물_, _хатар_, _promissa_,
   {{0x82025190,0xe2267087,0x8526e13c,0x76d6909a}},	//   _sitila_, _bruker_, _borracho_, _байрақ_,
   {{0xe2a6364e,0x5559401a,0xe1c443ea,0x24d79022}},	//   _álbum_, _ئبادات_, _adamunam, _саналы_,
   {{0xf7e2b01a,0x63b79105,0xac696007,0xe3424026}},	// [1aa0] _сентябрд, _מײַקל_, _mintegy_, _leveren_,
   {{0xd7c4e598,0x9ce3b0f7,0xe3448203,0xbb04e169}},	//   _entschei, _国家海洋局_, _omwenge_, _entschee,
   {{0xd3cf709e,0xb40e7101,0x14d7a01a,0x726e51a0}},	//   _pravde_, _lagreman_, _саналып_, _vetoti_,
   {{0x4ac7c47b,0x7500417a,0xceea2196,0xa2116392}},	//   _abawanye, _স্থিতিমা, _тариалан, _साखळी_,
   {{0x034202c1,0xdc66f005,0xe3416373,0x3a096628}},	//   _nereden_, _тарыфы_, _attenda_, _allanert,
   {{0xf2bdb0ce,0x52d9e2b7,0x4474c093,0xe2ef81d8}},	//   _mondtam_, _makomar_, _menekank, _akhirna_,
   {{0xfbe43225,0x978230fb,0x1145945f,0x83b3c07f}},	//   _engenhar, _सामानाधि, _स्कूले_, _ахәмарга,
   {{0x7c1ec140,0xdea631ba,0xc9c7238c,0xd926c228}},	//   _бюджетын, _направя_, _zahvalju, _تعزيه_,
   {{0x19f870a8,0x8248e0e1,0xe07c311c,0x00751131}},	//   _recenzí_, _raimon_, _السقا_, _उच्चशिक्,
   {{0xf386947e,0x2202616c,0x36ea30e9,0xc045d00f}},	//   _bearn_, _verite_, _privació, _anerkjen,
   {{0x0ef912a7,0x22eee177,0xa2d8964f,0x43ebe0d7}},	//   _тергов_, _neffe_, _objeto_, _citte_,
   {{0xdb8bd430,0x14ad2054,0x83ea7261,0xab18c187}},	//   _sahibkar, _mataimak, _nantu_, _akwanits,
   {{0x121c013f,0xc1ccd0d7,0x8e1d640f,0xe4f6027f}},	//   _bishop_, _чыгар_, _bloggara, _قووربانی_,
   {{0x22f212a5,0x6395025b,0x52ab70af,0x8b377105}},	//   _milionu_, _knassi_, _kolding_, _ליפֿשע_,
   {{0x93ce94a7,0xc2910203,0x3e3a1137,0xfdf6b3e8}},	//   _elava_, _abaami_, _karanasa, _nordeste_,
   {{0xd3ea745b,0xc291d185,0xa31742e2,0x97e330b3}},	//   _cantu_, _ekwan_, _brezil_, _рлары_,
   {{0x6fb2d4b5,0x2998f2f3,0x3d9b20b2,0xef3240db}},	// [1ab0] _قداور_, _унутар_, _phonsava, _alafelan,
   {{0x33ebe2d2,0x7c552440,0xf28d2065,0xee9ec287}},	//   _bitte_, _vantare_, _פלייסטיי, _магло_,
   {{0xa2a6e15b,0x98d7c263,0x83683650,0xf94cf2f3}},	//   _baibel_, _милали_, _googles_, _принципу_,
   {{0xd2da6139,0xf7bdb04d,0x84167381,0x0a02f220}},	//   _tureen_, _aiseirig, _алимитқә, _agasandu,
   {{0x83ebe651,0x420e11c7,0x89def0d1,0x5394f0cb}},	//   _witte_, _тараз_, _amendiwa_, _canser_,
   {{0x925c91d0,0x4437e15e,0x3b03e27a,0x9e3993fa}},	//   _encompix_, _иракийн_, _preprava_, _acharara,
   {{0x5264601b,0x9890b042,0xed26f14c,0xdb5020f6}},	//   _berlen_, _akukenyu, _রূপচান_, _ердәки_,
   {{0x8356c078,0x020bb36f,0x9cf91337,0x30361262}},	//   _أرسلت_, _banyakal, _एशोसिएशन_, _goverino,
   {{0xdf325370,0xbe6ac287,0x134920c3,0x834cb3dc}},	//   _abafikan, _дождж_, _dovesti_, _космичес,
   {{0x3920736c,0x87c3e652,0x621203ac,0xfc74b2ea}},	//   _शिवजी_, _programv, _ikihi_, _forumit_,
   {{0x4a72d313,0x7d9e6220,0x953dc086,0x1790c4dd}},	//   _savasava_, _yiyemeje_, _tonygpok, _hurtigvi,
   {{0x73eae283,0x8291d0c6,0x44a88335,0xc27ed169}},	//   _kantsi_, _akwan_, _naziunal_, _owend_,
   {{0x19415085,0xe345d0cb,0x6200c11b,0x8ff780e5}},	//   _শুকনো_, _nwyddau_, _velike_, _शान्तीको_,
   {{0x32cad0f0,0xef39221e,0x226cd084,0x536441f1}},	//   _pieds_, _persimpa, _akoonu_, _asegura_,
   {{0x73567057,0x22912011,0x6db481cc,0xa5d112ac}},	//   _necesar_, _ahojane_, _pingvine_, _کامڕان_,
   {{0x727ed283,0xf3a3435f,0x5dc7a262,0xf1dc8083}},	//   _eveni_, _nadpis_, _abazungu_, _ئشتەيتۇر,
   {{0xa2e8423e,0xa2ca9134,0x43ebe071,0xd26d819e}},	// [1ac0] _madiina_, _kaadu_, _sitte_, _horoi_,
   {{0x42e601b0,0x4977e196,0x36461067,0xf0c3a14c}},	//   _stanica_, _orrialde, _atukwasi, _হাবীব_,
   {{0x388982ab,0x49c720c8,0x82f2100c,0x60608057}},	//   _галасава, _парадак_, _maliliu_, _presedin,
   {{0x026cc2e2,0x47fcc011,0xe3eae39b,0xd17ef0db}},	//   _vodou_, _британиа_, _bantsi_, _bahatell,
   {{0x32cad09b,0xc6032116,0xd316f03e,0xc3eef1b1}},	//   _ekodos_, _आबिदा_, _alabosi_, _automerk,
   {{0x43635309,0x6680e01b,0x9c37d16e,0x538051c3}},	//   _alngegh_, _hereketi, _бригаде_, _aotrom_,
   {{0xd7aa738f,0xe0e760af,0x09ea70f5,0xd2017202}},	//   _bestelli, _この回答にお礼を, _bestellu, _ngaing_,
   {{0x5dc9135e,0xe2f0b065,0x9bd74059,0x337a0365}},	//   _cachonda, _טריילרים_, _berdikar, _maraman_,
   {{0x99a0f3dd,0x9c6e4309,0x1df01212,0xa8ecd38a}},	//   _nebojša_, _ameriqa_, _ونېول_, _сортиров,
   {{0x72b4939a,0x428c4041,0xb496c13f,0x9201113d}},	//   _prace_, _مقدماتي_, _ניקלודיא, _ticino_,
   {{0x63eae07d,0x026d8398,0x0ae383b2,0x4bcfb48a}},	//   _kantri_, _coroa_, _allungat, _breddegr,
   {{0xd213f2d5,0x0c483159,0x49c791aa,0x8d262338}},	//   _ortha_, _pozitív_, _шундайҙа, _uspomene_,
   {{0xf3eae38b,0x9c1e2630,0x2c73e48c,0xf249029f}},	//   _dantri_, _compras_, _ebisara_, _ayambi_,
   {{0xfc53113d,0xdebdc252,0x9aeee008,0x2365618d}},	//   _pistoia_, _кандайча_, _билдирен_, _abugida_,
   {{0x922ab25f,0xb2d4d395,0x0f8031c3,0x68c54128}},	//   _clamped_, _bomodin_, _athchuin, _foreshad,
   {{0x78387290,0xc35080a3,0xee5582d5,0x14f43248}},	//   _स्प्रिंग_, _stoffel_, _beiceara, _ምምሰራት_,
   {{0x52786266,0x63bbd078,0x8b399481,0x8b1ca1d2}},	// [1ad0] _nounou_, _أسرار_, _газетала, _artatien_,
   {{0xa396602d,0xe71801b9,0x9242d11c,0x44fdd2cb}},	//   _flussi_, _сараларҙ, _أهالي_, _سجاده_,
   {{0x02fe611b,0xe43d41c7,0x926dc1de,0x337a60f7}},	//   _drugim_, _ﺍﻟﻌﺩﻭ_, _novom_, _高宇参加台湾_,
   {{0x9387419a,0x7e399161,0xa6b99161,0x39590248}},	//   _gwersi_, _achapara, _achapari, _ዓሌታውን_,
   {{0x726de121,0x4ccc90c4,0xea5d4009,0xd44cc263}},	//   _fotod_, _umuhungu_, _последую, _алҳол_,
   {{0x8981e3b8,0x12d862ff,0xe379510a,0xeb5a6213}},	//   _opskrift, _aqleh_, _kitaifa_, _muntanxa_,
   {{0xf34143d5,0x9213005f,0x1693f102,0x0c559283}},	//   _verdier_, _ahahui_, _dietrich, _aketame_,
   {{0xc7ef1155,0x9a9ba222,0x626dc1de,0x5f5ba603}},	//   _һәтта_, _peningas, _novoj_, _penangan,
   {{0xa3ea502d,0xe5a1110e,0xb2c37516,0xb305c04c}},	//   _malti_, _हंसते_, _doslova_, _جوراب_,
   {{0xc1b8f01a,0xe3eae06e,0x2215358b,0xb2cb5082}},	//   _барымтад, _santri_, _abahleli_, _kredoy_,
   {{0x62d8c169,0xf5067163,0x62694012,0x803e30f7}},	//   _immens_, _escudero_, _بوزدار_, _contrain,
   {{0xd9ab1135,0xf2fce4b2,0x96682041,0x32d4b054}},	//   _መዘናግዒ_, _bongda_, _قوانينو_, _dokokin_,
   {{0x53ebe44b,0xacae70cc,0xe2f2d1a3,0x12924100}},	//   _hitta_, _উপস্থিতি, _tshithu_, _kawani_,
   {{0x3af7c13c,0xbeb7d296,0xa991d2a9,0xcc47233c}},	//   _валерии_, _вагарна_, _verkaufe, _фаргона_,
   {{0x72d81151,0x32922177,0xa29dd0c4,0x7212d04c}},	//   _nqhes_, _baqali_, _binjira_, _akehe_,
   {{0x3301812b,0xd26d83ec,0xa26ca2af,0x9d7ec227}},	//   _edebere_, _coron_, _diboe_, _구내서점을_,
   {{0xb1f322b5,0xaa85b2f3,0x0822f030,0x525ac200}},	// [1ae0] _finality_, _imenovan_, _сентябри, _qullan_,
   {{0xb058113f,0x5ad2f53c,0xe3dd0015,0xd2b401bf}},	//   _מערבבים_, _castrate, _arawak_, _frica_,
   {{0xe291f4b2,0x026d8049,0x8905304f,0x22131040}},	//   _thuat_, _foron_, _membentu, _bachta_,
   {{0x126d848e,0x5386d17e,0xc2e5f387,0xa1d06020}},	//   _goron_, _seera_, _akinola_, _adgerbay_,
   {{0xc37862f1,0x7a83d406,0xa0c150bb,0xc2d8322e}},	//   _inganda_, _grandajn_, _bollemel, _malolos_,
   {{0x826de15c,0xe3ebe288,0x88dad26e,0x338691c5}},	//   _fotoe_, _bitta_, _skirting, _bearb_,
   {{0x72027475,0xe27603e2,0x8386d152,0xe4d0c3f0}},	//   _tarikh_, _starostl, _veera_, _सारिका_,
   {{0xc649d059,0xe29164e7,0x59696018,0x8f3d4109}},	//   _ፖለቲከኛ_, _edgars_, _aplicare, _andrepla,
   {{0x1c349050,0xb288d15f,0x6b1b12e2,0x424a6033}},	//   _省工商行政管理局_, _tamainni_, _kasasyon_, _fermal_,
   {{0x3da2b140,0xca04335e,0x4f25209f,0xe3fa5012}},	//   _remontla, _achakuit, _baretsan, _hatuna_,
   {{0xde3640ad,0x40c711b5,0xc15b3106,0x38453113}},	//   _íslands_, _انتروپول, _sionnach_, _meitenes_,
   {{0xa3947200,0x0587d1aa,0x4141b1c4,0xf851c48f}},	//   _kunsa_, _бракка_, _achmahoy_, _облаци_,
   {{0x85ba201b,0x826c53e1,0x8e08212b,0xa06892ce}},	//   _babalary, _dilon_, _iledoroa, _ephalabo,
   {{0x4c75f504,0x72b4005c,0x31f90134,0x884b81b1}},	//   _रिक्शा_, _prica_, _assannah_, _kokoontu,
   {{0xe9f722d4,0x72c3709e,0x826de17f,0xe2ea7063}},	//   _anankuna_, _poslova_, _notom_, _ustidan_,
   {{0xa27ed010,0x3213f555,0x6f0b0383,0x63ced447}},	//   _winnie_, _kuthi_, _kommuner_, _oleva_,
   {{0x2fc2d218,0x12cb912e,0x383c92a0,0x6e5101f8}},	// [1af0] _لاحول_, _schowka_, _بچوکترین_, _ponavlja,
   {{0xd291f11c,0x92fce21c,0xa138a180,0x484a71b3}},	//   _thuas_, _lingwa_, _続きをよむ_, _gentilis_,
   {{0xf04c2040,0x52d8c653,0x926464f7,0x8e50b0aa}},	//   _crouchin, _galego_, _berlin_, _akabande_,
   {{0x620e6200,0x13578299,0x3eab101a,0xaba01351}},	//   _pachamam, _profilo_, _galeries_, _تکریم_,
   {{0x73f4147f,0x05a4c342,0xd73d720e,0xc26d8365}},	//   _éstos_, _chailliú, _comparaç, _roron_,
   {{0xb6bb0176,0x36876654,0xf28891fa,0xeff7d257}},	//   _wiracari, _च्याउ_, _bohaneni_, _kadrları,
   {{0x12019180,0x399420af,0x1a08e2aa,0x1200f14f}},	//   _fysik_, _公式サイト_, _volamena_, _akhila_,
   {{0x1213f218,0xcc537142,0xc5194003,0x2638612e}},	//   _orthu_, _kartica_, _रामस्वरू, _realizow,
   {{0xc2c94562,0x82fce1df,0xf3566087,0x70967360}},	//   _soporte_, _lingva_, _basenes_, _دھاگوں_,
   {{0x00dd2159,0xd2fd562f,0x5601c2a0,0x9201a22e}},	//   _تیاری_, _chegar_, _ڵناسی_, _levice_,
   {{0x93ea758b,0x27cae248,0x7befa0f0,0xd26de105}},	//   _kanti_, _ዘይረብሕ_, _ouvertur, _fotoj_,
   {{0x7236e4ef,0x1db3218a,0x4387515c,0x1567f1e5}},	//   _ranjit_, _sanatate_, _anerer_, _китабың_,
   {{0x453d0004,0x4386d322,0xb3ea716c,0x023160c5}},	//   _ايتاليا_, _deero_, _manti_, _avumura_,
   {{0x1400608b,0xd2da4256,0xc386d285,0x7f3632f3}},	//   _kagungan_, _ukwezi_, _leero_, _заиста_,
   {{0x55785655,0xad8084e0,0xe9e54180,0xeff6930b}},	//   _poslední, _deklarua, _おめでとうござい, _deklarāc,
   {{0xcee812dd,0xf2cac018,0x9e8ba065,0x9f40717d}},	//   _ngekulan, _acelasi_, _בהסכם_, _amerikka,
   {{0x42b273a2,0x49fcb309,0x93fa6190,0x72d9f500}},	// [1b00] _gradova_, _bisumchu, _daruna_, _aptek_,
   {{0xe2027045,0x0eb032c0,0xd1b16009,0x5dd4a09e}},	//   _ensigo_, _ballewun, _открытие_, _složenij,
   {{0x17aa73db,0xcdd6209a,0x8c77f23b,0xb3866187}},	//   _bestilli, _аъилисид, _ceuraki_, _aford_,
   {{0xd725b313,0xdd0742c6,0xb05370ac,0xf2e37075}},	//   _guilecav, _empleate_, _pensioen, _volitve_,
   {{0xca157075,0xd3a2e42e,0xf2957075,0xb3c58287}},	//   _lokacija_, _skipta_, _lokaciji_, _турніру_,
   {{0xdf0f142d,0x1da4d036,0x02fc31bf,0xd3ce62f8}},	//   _marcados_, _очила_, _vizitat_, _ilovi_,
   {{0x826c5309,0x4e18742f,0x1c4c6127,0x2a6520ea}},	//   _tilon_, _unregula, _alowini_, _कमर्शियल_,
   {{0xf2e672f5,0xa3d961a8,0x93ce9656,0x395f004c}},	//   _aranora_, _правесьц, _plave_, _سیسکو_,
   {{0x1a887144,0xffbec0be,0x9486d0e5,0xb26c72aa}},	//   _tinyatse, _koalicio, _स्याही_, _sinoa_,
   {{0xa26de2d6,0x7e3a22dc,0xb4a9600a,0xf2e7107e}},	//   _potom_, _sababara, _national_, _chansen_,
   {{0x8c0830c4,0x502802e5,0xfbde00ae,0x4c7d7063}},	//   _ibiganir, _konverzn, _bildirir, _versiya_,
   {{0x23fa51d4,0xe2fce039,0xb2ca92fa,0x08840105}},	//   _matuma_, _jongka_, _haadi_, _טאררענט_,
   {{0x327f7184,0xfadc0271,0x22e97233,0xe9b900ea}},	//   _akanjo_, _normální_, _variana_, _अकल्पनीय_,
   {{0x126d81af,0xf29143e5,0x82d5638d,0x9b7870c3}},	//   _porou_, _nedaju_, _karoora_, _potrebna_,
   {{0x20639019,0x47aa403c,0x644ae248,0x937a02f4}},	//   _מארגן_, _bottigli, _ኣይኩናት_, _garaian_,
   {{0x526d8474,0xc3484075,0x82fe404b,0x6b8300db}},	//   _foros_, _temelji_, _iqtibos_, _tokoloho_,
   {{0xa25aa03e,0xb248d10f,0x8248f3f3,0x6cdda0ac}},	// [1b10] _abilé_, _filmet_, _trimum_, _누가봤을까_,
   {{0xb54a90f6,0x83eae3aa,0x1c627036,0xd31d4257}},	//   _ойландыр, _britto_, _seguito_, _olublar_,
   {{0x6dc41039,0x92f6c0be,0xaed6d342,0x464912e2}},	//   _dushyant_, _artikuj_, _معاهد_, _machandi,
   {{0x232612c3,0x73f96336,0x639f6023,0xa26d8329}},	//   _ۋازىرى_, _angutu_, _currusaw_, _koros_,
   {{0x026c7101,0xf4a56404,0x12d8017d,0x496570f0}},	//   _annou_, _عنوانن_, _omien_, _absolume,
   {{0xffcaa431,0xe43b5031,0xdc8b23f9,0xc2b49585}},	//   _première_, _መንግስታዊና_, _операцій_, _quach_,
   {{0xec690111,0x0bf11401,0x8f5d61d8,0x8ed8b277}},	//   _patrino_, _سلطانك_, _sapanjan, _enviadas_,
   {{0x2dc3c152,0x32ff41d0,0x40565155,0x62cad1cc}},	//   _elokuvat_, _pariter_, _ﺋﻪﻧﮕﯩﻠﯩﻴ, _zgodan_,
   {{0xa6bc2322,0xd8fc2322,0x37155086,0x426c5177}},	//   _antafaqi, _antafaqu, _platnium_, _bilol_,
   {{0xf43230cc,0x2f6770b8,0x429242b7,0x317e30ae}},	//   _সম্বন্ধে_, _بایجان_, _jawabi_, _imtahanl,
   {{0xad29213e,0xcc614098,0x7b9d33f9,0x19bf4007}},	//   _komputer, _butumwa_, _musikkpr, _balesete,
   {{0xc8972004,0x716884d2,0x56fcb022,0x6f4d011c}},	//   _غریبه_, _biyintah_, _холдингт, _timpiste_,
   {{0x7e01c231,0x4248f206,0x0d3eb00f,0x72920439}},	//   _rejestra, _primum_, _aktivert_, _kupang_,
   {{0x9da40098,0x32e8c101,0xbeb2701e,0xc63354e0}},	//   _ishorama, _dominen_, _napolinn, _civilizi,
   {{0x639bc4bd,0x9a44b013,0x53fa52f8,0x5c12805f}},	//   _nāsti_, _cuadrada_, _katuba_, _anapuni_,
   {{0x2c72432d,0x1e32e0b0,0xdc7712e2,0x92e97044}},	//   _acirāt_, _panggila, _dansite_, _piringa_,
   {{0x8386d03e,0xabe1051b,0xfe02c3c1,0xdbfaf211}},	// [1b20] _beere_, _jugendsc, _leverera, _apalisio_,
   {{0x2db3334f,0xc3ea51df,0x1c34014c,0xead2e127}},	//   _saniraya, _saltu_, _কাঞ্চনেশ, _dauteite,
   {{0x43954281,0x0dd27030,0xea1d81bc,0x506492b1}},	//   _geeska_, _nishonla, _començar_, _latansyo,
   {{0xd301b47b,0x12cad1c8,0xe7c10167,0x73ebe152}},	//   _adabere_, _orodha_, _adorachi, _vittu_,
   {{0xc832c01a,0x912d323c,0x2b4fa59b,0x2f24011b}},	//   _نازىر_, _дайте_, _वर्षपछि_, _viših_,
   {{0x326ca123,0xac77e18e,0xd3967065,0xf9c86030}},	//   _anbon_, _ostrali_, _hassle_, _аллакачо,
   {{0x13801601,0x797c4050,0x729034e6,0xfddea17d}},	//   _patrí_, _的基本要求_, _rumaze_, _kaikille_,
   {{0x9870f2c4,0xbc769384,0x52494187,0xfcdc917d}},	//   _राजेंद्र_, _vybrali_, _mpemba_, _остально,
   {{0xa91131de,0xf46930dc,0x5d01e157,0x60ce8275}},	//   _pojavlju, _барскоон, _pertutur, _تەكەببۇر,
   {{0x4c90c1e7,0xe29e334e,0xa7e3311b,0x2d2da065}},	//   _क्रोध_, _дилам_, _долини_, _משלהם_,
   {{0x13574107,0xeeea10bf,0xccee43d0,0x167f4076}},	//   _ज्ञानकोष_, _тилларид, _бамбарыг_, _paleseti,
   {{0x1ccc033c,0xc05f0404,0xf290e365,0xbd13f228}},	//   _میوند_, _حميرا_, _eriare_, _abdurrac,
   {{0x7395427d,0xb4d10038,0xd31a2008,0xfbd4a35d}},	//   _meesha_, _मालिका_, _gözel_, _campaña_,
   {{0x334540fa,0x853e2009,0x9ce0706a,0x02c202e7}},	//   _biserje_, _коммерче, _किलोमीटर, _amaloza_,
   {{0xcb98e566,0xaa57212f,0xac7c8431,0x646f929f}},	//   _enriquec, _гиранат_, _poisson_, _bakendek,
   {{0x02fb0283,0x627a1036,0x2668b3d0,0x02926010}},	//   _kushona_, _трениров, _видеонуу, _strang_,
   {{0x2d1c024d,0xf3eab57c,0x0c4505dc,0xc7b8508d}},	// [1b30] _khulwane_, _slette_, _desconec, _arhwaliw,
   {{0x636c71e2,0x5200800a,0xfc53710e,0x0049c162}},	//   _bongani_, _taking_, _dostawa_, _халимайд,
   {{0xc3954281,0xe26c7086,0xbdb8f1b9,0x19cd7358}},	//   _beesha_, _annos_, _машинаһы, _принципы_,
   {{0xd767d01a,0x3291b2bf,0x126d8023,0xe09b5264}},	//   _اللوحۇ_, _atware_, _doroq_, _تراخيص_,
   {{0x4200806a,0xd05a53d5,0x4c78b358,0xc6f0c339}},	//   _saking_, _forsvunn, _напомнит, _sekundēs_,
   {{0x4acaf248,0xb34171a3,0x6792f1ad,0xdcf7221c}},	//   _ንባዕሎም_, _vuselwa_, _distenti, _partitar,
   {{0x437a2304,0xf86101da,0xf7a733ab,0xf3eb210e}},	//   _capaian_, _urunturu, _integrov, _klimatyz,
   {{0x134873b0,0xfafd824a,0x5386904a,0xdf7dd287}},	//   _samfund_, _hongaars, _afare_, _натальля_,
   {{0xcdbd7079,0x254152fd,0x027cc15e,0x3b1bd41d}},	//   _anbarase_, _سیمایه_, _агнах_, _funkció_,
   {{0xb2c82059,0x1bf720d7,0x29f0e560,0x47ebc33c}},	//   _ጴጥሮስም_, _китереп_, _aktifnya_, _акопян_,
   {{0x6373129f,0xbc24421d,0x3c5ca289,0x8bd8324e}},	//   _maladie_, _माहेश्वर, _hontrol_, _تحکیم_,
   {{0xc22481b8,0x7e01014f,0xa0e630a2,0x9f541282}},	//   _unikey_, _कामक्रोध, _abenguml, _באקימען_,
   {{0x6e39d26f,0x4b1fe1f7,0x820273d2,0x1a68b057}},	//   _kadahara, _sanalgan_, _marish_, _marginea_,
   {{0xa6955208,0x7349d3c9,0x687611ed,0x422b21a6}},	//   _capercai, _potenti_, _омски_, _alimate_,
   {{0x0e55c2ca,0x38c5b2d4,0xfeccd3a7,0xd70f404a}},	//   _دوستۇ_, _urlencod, _aliyense_, _agomusev,
   {{0x03958074,0xfd8d51b2,0x53f1b1a6,0x327eb0c3}},	//   _kurse_, _demokira, _agustusi_, _njenog_,
   {{0xe290c310,0xa3f0a02a,0xac3542cd,0x02528308}},	// [1b40] _jumaat_, _scheming_, _bernhard_, _etilweni_,
   {{0x429241fe,0xa312446d,0xecbec26e,0xd387442e}},	//   _diwaan_, _dobbelt_, _шанец_, _hvergi_,
   {{0xe053f011,0x55d711a5,0xd2d6a3f9,0x42647364}},	//   _европатә, _ababetsh, _attlist_, _bisleh_,
   {{0xf5389287,0xd3ce9656,0x4f38f06c,0xb2e7905e}},	//   _пастанов, _plavi_, _होसियार_, _emingao_,
   {{0x13869218,0x1beed01a,0x0c13c1bc,0xc5cb3146}},	//   _neart_, _ишине_, _ادجئى_, _perbalah,
   {{0x33f9f34e,0xd3ea745b,0x20171004,0xeb5fc180}},	//   _kazuma_, _santu_, _پادشاهی_, _ジリン急行_,
   {{0x2379d42d,0xa3ea7113,0x56560187,0x52fdb01f}},	//   _tomando_, _pantu_, _akukambi, _alfahari_,
   {{0xd26e80e7,0xdc6fe098,0x9e295137,0xd3479095}},	//   _mihumbul, _itorero_, _nanganga, _fiddler_,
   {{0x46ef71bd,0x01f40020,0x4c1c224f,0xa23b323a}},	//   _अभिनन्दन_, _amageday_, _angalaar, _suklang_,
   {{0x828950ed,0x28513495,0x026dc657,0x22129250}},	//   _endaweni_, _enrollad, _alvor_, _ikahi_,
   {{0xe909e081,0x98525329,0x0037c1b8,0x8c06513c}},	//   _allattoq_, _hebrides_, _thitruon, _malraux_,
   {{0xee68c431,0xfc09c2aa,0x938691d7,0xa3102048}},	//   _concerna, _sampana_, _feart_, _kurzů_,
   {{0x834e324a,0xa647009b,0x92b4051b,0xa386911e}},	//   _ingelsk_, _drukkeri, _krich_, _geart_,
   {{0x279ed1bf,0x9792f026,0x6f12f064,0x43ea111c}},	//   _араба_, _instanti, _instanta, _achta_,
   {{0x524a236c,0xc3eaf074,0xb26d80c6,0xd26dc0c8}},	//   _कामेडी_, _flitet_, _horow_, _lovos_,
   {{0x6c261105,0xaa329427,0x32cb214a,0x00e741bf}},	//   _אינטימע_, _добрият_, _haydu_, _instalaţ,
   {{0x995f813e,0xf26dc49f,0x6d475119,0xe3eab2bd}},	// [1b50] _zaintere, _novos_, _kalaaleq, _boetse_,
   {{0xb2fdb37c,0x1f5d31bf,0xbbfc92c2,0x9d9ec24a}},	//   _infitar_, _краковия_, _postrojb, _sitearje_,
   {{0xa22672b9,0xe2feb079,0xd2d9827c,0x943e83d0}},	//   _brukar_, _kishore_, _opret_, _арбитрын_,
   {{0xbf5b806e,0x648ef17a,0xa386f2ca,0x526c12ff}},	//   _ramadhan, _উদ্যোগিক_, _segre_, _dihom_,
   {{0x2e51e148,0xe9364163,0xa7f3314f,0x9c616267}},	//   _pamajika, _sarmient, _सामान्यं_, _burukwa_,
   {{0x8e1b1272,0x137a04a2,0x6c0252f2,0xfd1d90ff}},	//   _pulmones_, _karaman_, _diaspor_, _fulltime_,
   {{0xd6edb0e8,0x27c5f0c0,0x1c75709b,0xabca501a}},	//   _finansow, _atestaci, _lebukas_, _بارماقتا,
   {{0xc3ce9313,0x3c0f20ac,0xf3ce00f9,0x538b11b3}},	//   _ilavo_, _오피스텔분양권_, _blivu_, _beryllo_,
   {{0x902ec2bc,0x9f55813c,0xe2b6541e,0xc3ea7083}},	//   _назва_, _bangbros_, _patche_, _tants_,
   {{0x1386d4f1,0x8413e292,0x30e8315a,0x94b9f5a8}},	//   _geeri_, _هاردی_, _अनुकूलन_, _orihinal_,
   {{0xf34173d6,0xfd909140,0x9c67c030,0xb040215a}},	//   _kusekwa_, _августта_, _برداش_, _मॉडलों_,
   {{0x72131238,0x9a94521d,0xd788b200,0xa0631427}},	//   _kichen_, _आत्मनि_, _llawirix, _лошото_,
   {{0x1a896216,0x1317121f,0x5f46c0ac,0x8a477410}},	//   _impustüt_, _edangang_, _operatie_, _йапылорс,
   {{0xe2b465cf,0x1fc194a7,0xba2ae180,0xda831026}},	//   _troca_, _apongipo, _エンジェル_, _genieten_,
   {{0x753ae24c,0xe22bc20b,0xd2d84230,0x4379c5a4}},	//   _دفترٕے_, _प्राब्लम_, _immen_, _vilaĝo_,
   {{0x9d055037,0xc25ac25f,0x2290d071,0x1291424a}},	//   _populyar, _pullin_, _stikjes_, _greate_,
   {{0xdd9e40e5,0x349b016e,0x725b0004,0xd290337e}},	// [1b60] _कार्यस्थ, _добровољ, _ndalem_, _tumane_,
   {{0xf6dd00a6,0xa2375122,0x1c687496,0x0ae31195}},	//   _मालिश_, _frejus_, _averiko_, _amatembe,
   {{0x42ca9054,0xe37fc27a,0xe37a0004,0x4a8d50ac}},	//   _ibada_, _galanta_, _karajan_, _전문가들은_,
   {{0xea1730ea,0xead5c140,0xb3ea70d2,0x830c22b1}},	//   _सर्वेक्ष, _initsiat, _sants_, _gamatis_,
   {{0x54d03337,0xd3ebe032,0xa7311096,0x496a6263}},	//   _दैनिकी_, _hitti_, _پھنسے_, _самарано,
   {{0xe2b4908a,0x677de0c9,0x8f9860ac,0x425b4167}},	//   _kraca_, _справі_, _기타레포트_, _abelta_,
   {{0x2277217f,0x3e0f24da,0x03ce04cf,0x84a83217}},	//   _фармони_, _necesida, _slivu_, _başlanıp_,
   {{0x527f4581,0x026de1ab,0x57ddc0ee,0xf3872083}},	//   _mwenzi_, _totoo_, _financov, _escrit_,
   {{0x1269b2e8,0xa2ca92db,0x33347105,0x627ed039}},	//   _poirceal, _obada_, _קריסטנטו, _tynnad_,
   {{0x03a4039d,0x33eb04ff,0x4d10a17a,0x5c32c4ec}},	//   _galaksij, _alatet_, _pressefr, _olabilir,
   {{0x38840085,0xc6e53009,0x81d1742f,0x6e94b18d}},	//   _সমস্যায়_, _уважаемы, _egreeday_, _statique_,
   {{0xfc5021ca,0x5615213c,0x629251d8,0xe3eb8113}},	//   _پھٹمت_, _путини_, _hutang_, _pirts_,
   {{0x42b4911f,0x8c7c93ea,0x03f8911d,0x52fa0184}},	//   _araca_, _crispin_, _mikuru_, _arahina_,
   {{0x526ce08f,0xd106b202,0x459e0221,0xa2540121}},	//   _anfon_, _ngahasil, _abafiley, _कॉमेंट_,
   {{0xef4a10f7,0x6b69d0b1,0x12ef83c6,0xd29490e9}},	//   _régions_, _tartanka_, _takirua_, _ajakami_,
   {{0x647ec15e,0x78b5c43d,0x8695a184,0x22851157}},	//   _кинон_, _faktorer_, _tanterah, _adikung_,
   {{0xa55e61a9,0x1213f0b2,0x0be9a248,0x4f4e023c}},	// [1b70] _ташлашни_, _nsthe_, _መልክዑን_, _населено_,
   {{0xb37fc047,0xc7e3c34e,0x77693031,0x52e9512a}},	//   _talanta_, _комили_, _ተመሣሣይ_, _altiara_,
   {{0x4715444f,0x9ec2b0c6,0x0c65510b,0xd26c7147}},	//   _seguranç, _denneenn, _ampunge_, _sinoc_,
   {{0x126dc25a,0x84d72228,0x298ec00f,0x4641c434}},	//   _povos_, _خروجی_, _такий_, _второ_,
   {{0xe2d983f1,0xb6ba1030,0x437b0238,0x82c622a7}},	//   _apres_, _darajasi, _dispakañ_, _экспорти,
   {{0x93416442,0xf2a6c135,0x072ba131,0x72bbf427}},	//   _kutenda_, _humbur_, _प्रवासाच, _строит_,
   {{0x621294d7,0x4c75f3e2,0xfc697233,0x5ae51546}},	//   _shahu_, _napriek_, _fantany_, _pertence,
   {{0x526a6292,0xfdd0c227,0xa2a6c00d,0x0292709c}},	//   _کالیفورن, _회원에게만_, _cumbur_, _bisaan_,
   {{0xe7ee31db,0x926c7447,0xdb7520c3,0xc37a02c1}},	//   _betaling, _ainoa_, _tekstova_, _karahan_,
   {{0xe32721f5,0xa37f80e7,0x4a6161fe,0xa26c70db}},	//   _پاسبان_, _tshanda_, _anañas_, _binoa_,
   {{0xaf16c2e8,0xef72207b,0xaf5b8004,0xea55223c}},	//   _leideann, _globulin, _ramachan, _domenica_,
   {{0x92b673d4,0xb37aa23f,0xeb63121f,0x1ff970e5}},	//   _diucaz_, _canabal_, _forenoon_, _श्रावणी_,
   {{0x9b82b2e8,0x42181063,0x186d91e5,0x29f943fb}},	//   _mionsonr, _ибрат_, _бинамыса_, _jomfruøy,
   {{0x32b490e8,0x3a0b2126,0x77849059,0x92b6063c}},	//   _praca_, _bosangoa_, _ምክርቤት_, _buscas_,
   {{0xf7784056,0x43ced018,0x67129022,0x72ad11d9}},	//   _nyakegag, _elevi_, _берешект, _القاش_,
   {{0x9bb540d7,0xda2762cc,0x8dfad4a7,0x11080276}},	//   _deputatı_, _दगाबाज_, _lavelave_, _هوشوءَ_,
   {{0x1c63019a,0xc9e450c6,0xbc9332d1,0xcc0140f7}},	// [1b80] _astudio_, _kwankora_, _نامان_, _ressort_,
   {{0x744070cc,0x7947f0f6,0xcde0314c,0xd25731b1}},	//   _মানসিক_, _kanunlar_, _শঙ্কু_, _neutraal,
   {{0x6e53a148,0x22c6502d,0xe0569007,0xe3393248}},	//   _masaraka, _stampar_, _leggyako, _እትሕተም_,
   {{0x426de284,0xf6a9313f,0x2396741b,0x70eff14f}},	//   _totos_, _approach, _passie_, _adhaḥśir,
   {{0x4a89617a,0x14d7e0ba,0xa3f4612e,0x3ec96065}},	//   _polymere, _тарады_, _skutek_, _polymera,
   {{0x7a3dc1f7,0xdc7582b8,0x826cc096,0x726e5005}},	//   _ministrı_, _verskaf_, _andor_, _netoli_,
   {{0x3832c1d9,0x33430049,0x0d15e191,0x5f41d19e}},	//   _ءازىل_, _dereito_, _afesearc, _mongamon,
   {{0xa38602bf,0x40ad50cc,0xa2c203ea,0xbc69f045}},	//   _agire_, _ধ্বংস_, _amaliza_, _kirungi_,
   {{0x9eda105c,0xd317f29b,0xfc6100a1,0xb905329a}},	//   _pasijans_, _umuzi_, _mosumma_, _pembentu,
   {{0xdf10c4c9,0x02b37306,0x8104c140,0xb94850f9}},	//   _predsedn, _oludala_, _xakında_, _minuttir_,
   {{0xd2009151,0xaea8c0c8,0xc3df20af,0x23eb8322}},	//   _txais_, _анатоль_, _この質問内容が不, _barti_,
   {{0xfcd99065,0xf2497531,0x6201a075,0xe557b36f}},	//   _תחקיר_, _saamin_, _revije_, _арзанайғ,
   {{0xdf5c01ad,0x4c4bf056,0xbf2431d6,0x326e70a4}},	//   _sulphide_, _nneteng_, _angephan, _ieroni_,
   {{0xc3ea138f,0xec7cf642,0xdf67d244,0x841a60b5}},	//   _echte_, _styrkir_, _kawallun, _айырылға,
   {{0xe68c306a,0x021a9626,0xb337108b,0xfe1db23c}},	//   _सुहास_, _एकदिवशीय_, _دیالوگ_, _essenzia,
   {{0xc680321d,0x09d29363,0x17ea6330,0x49ba1076}},	//   _विशां_, _failaina_, _如何治腋臭_, _palekaua_,
   {{0xcef56018,0xf2b491c4,0xaafdd13a,0x3b4c4180}},	// [1b90] _активита, _quack_, _expendis, _名も無き飼い主さ,
   {{0x226ce5ea,0x4ec34024,0xf86f0174,0x4046313a}},	//   _infos_, _विज्ञानस, _očigledn, _bwatnapn,
   {{0xfb84513f,0xfc51f184,0x6891510b,0xe63d4213}},	//   _transpor, _ahitana_, _akikangu, _kusisipx,
   {{0x43872428,0xd386d1fe,0x33eb8018,0xbea2c44f}},	//   _heyra_, _weeru_, _carti_, _инсистир,
   {{0xb2a7817a,0xd9f6c152,0x3f6c70e5,0x234dd37b}},	//   _verba_, _причем_, _मुद्राओं_, _veselim_,
   {{0xc871d12f,0x6a99f296,0x2752d23a,0x4b935104}},	//   _ислаһат_, _abahlats, _sainding, _diciendo_,
   {{0xd2904089,0xa27a80e5,0x892b0328,0xfc2a035a}},	//   _weakest_, _कायाकल्प_, _tammaqta_, _hōnuanua_,
   {{0xbf114579,0x237892d4,0xf80d406a,0x3341719f}},	//   _ئشبارا_, _achalan_, _मोटरसायक, _arreeda_,
   {{0x33a3a036,0xd3fa5658,0xeadb0031,0x02cae411}},	//   _mappa_, _yatula_, _እስላሞች_, _bendul_,
   {{0x3c67c0b4,0x13987252,0x12ca01b9,0x911a73d0}},	//   _samuela_, _ئشتەتكەن_, _bolebedi_, _траншейн,
   {{0x05e19064,0x1be360b0,0xd1e22041,0x328723b3}},	//   _网站或个人转载使, _sementar, _همايون_, _isikute_,
   {{0x305323bf,0x5f81806c,0x2557d043,0xf99760c2}},	//   _носител_, _मट्की_, _прийти_, _аңламаға,
   {{0x284ef140,0xd3166101,0x36d0714f,0x1d4e50d7}},	//   _проектын_, _dekalaz_, _agrakuli, _докладын,
   {{0x4da94437,0x40c15659,0xd2915076,0x780ee3aa}},	//   _dominera, _verktøy_, _augate_, _पुनर्विक,
   {{0xf87d2287,0xf507f36f,0x0d26b1a6,0x6f9bf009}},	//   _кампанія_, _bahloloh, _ashonele_, _пользует,
   {{0x73ce82c1,0xf2e2015b,0x5c4740ac,0x3b18e210}},	//   _takvim_, _agensem_, _포트폴리오_, _andardss,
   {{0xca5552a9,0xd571037f,0xb348e08f,0xfc51b14c}},	// [1ba0] _verstoß_, _anatuluk, _anterth_, _রিস্ক_,
   {{0xe26d81a0,0x13df7076,0xe36cd0af,0x797522f3}},	//   _horoz_, _abimelek, _byggeri_, _клубова_,
   {{0xf4dad5b0,0xf37a507d,0x4573b031,0x56e6b1a1}},	//   _поена_, _gavaman_, _በዚምባብዌ_, _updatedw,
   {{0xe23692e1,0x627f624a,0x4fd7d1a9,0x3b970438}},	//   _itaja_, _eigner_, _рамалла_, _کامرون_,
   {{0x820270a0,0xdc652216,0x87c7b152,0xf5d71418}},	//   _sisifo_, _dentant_, _kansalai, _ababotsh,
   {{0x8862d3ac,0xaa1f20ac,0xeb171392,0x02cb3030}},	//   _takathur_, _쪽지보내기_, _दणदणीत_, _tomonga_,
   {{0x34c1f04f,0x061490f7,0xef674314,0xdb517352}},	//   _memberik, _经络锻炼法_, _परिचयपत्, _لێیده_,
   {{0x53f89221,0x9eb9b2b5,0xe0dd0007,0x8f2c1178}},	//   _enkulu_, _strollin, _ہیلری_, _anlednin,
   {{0x03abd13c,0x244d0251,0xf26d113d,0xfa01b0a3}},	//   _иванови_, _подготву, _dizon_, _verskeid,
   {{0xe3fa5344,0x1c58509a,0x4e59524b,0x5386f1bf}},	//   _yatuma_, _قاتارىدى, _минималь, _negru_,
   {{0x8016f0f7,0xce9453ea,0x825b018b,0x92b554c0}},	//   _新疆新华联泰德矿, _adamuman, _shalai_, _drechs_,
   {{0x529252ef,0x6dbce39f,0xdb8452e7,0x2b7fc220}},	//   _totaal_, _tilstand_, _afunanso_, _kuruhuka_,
   {{0xf9d7613c,0x0486115a,0xb7e0d06c,0xfcf73205}},	//   _vegetale, _ड्रायर_, _बिमर्श_, _birthmar,
   {{0xbdb3a0b6,0xa963304a,0x826de135,0x835fb08c}},	//   _arranque_, _amunamat, _botoi_, _liggame_,
   {{0x826c718b,0x557852e5,0x62b4e261,0x10411027}},	//   _minot_, _posledný, _ronchi_, _requiren,
   {{0x230d31c2,0xfb0380c8,0xa2b462b5,0x12100378}},	//   _kimbisa_, _генерата, _frock_, _femínist,
   {{0x4224716c,0x725b4425,0xc7ee708c,0x0201621f}},	// [1bb0] _manke_, _abelwa_, _bepaling, _begier_,
   {{0xc394a3f1,0xc3ebe1c6,0x8a7c93e4,0x4f3e0345}},	//   _baisé_, _mitts_, _aitagata_, _क्रियोल_,
   {{0xffe8006a,0x12d9b2fe,0x02f3b2a8,0x2721a1d0}},	//   _अर्थातच_, _nkanswe_, _parirau_, _terrarum_,
   {{0x9e3a01a0,0x6b09c548,0x3119d248,0xae57523f}},	//   _angatura, _деклин_, _ኣንጻሮም_, _barregèt_,
   {{0x2d019608,0x0d843491,0x3afd8258,0x1dc74024}},	//   _སྒྲུབས_, _अनुकरण_, _kinguars, _alābhe_,
   {{0xbb1b612a,0xcc7d71b3,0x026c7292,0x82b46169}},	//   _simplice, _cesseva_, _sinov_, _drock_,
   {{0x944ee0ea,0xd68e1121,0xd28c7510,0xc2f270c3}},	//   _souvisej, _अयोध्याप, _akakasa_, _napominj,
   {{0xbae13063,0xad15b141,0x72b494e5,0x2b41521d}},	//   _jumladan_, _birlikde_, _aract_, _श्रीवत्स,
   {{0xb224736b,0x5166e064,0xaa73f094,0x49c7c0b9}},	//   _danke_, _第二十八条_, _bidalita_, _дамара_,
   {{0x537fd26f,0xaa613067,0x1137c009,0x2adfe0ff}},	//   _balarea_, _agafeela_, _данным_, _maatrege,
   {{0x126dc337,0x33eba2ab,0xa09601c7,0x5b65a063}},	//   _novou_, _tapti_, _ﻣﯘﻗﻴﺎﺕ_, _tartibda_,
   {{0x638600fe,0x2d97c15e,0xa2027032,0x934923b2}},	//   _agira_, _билгийн_, _gerist_, _diventi_,
   {{0xec93665a,0xf6037369,0x129260b1,0xbf3fb04b}},	//   _निरोग_, _belletri, _qoraal_, _yangilan,
   {{0x10af4288,0xd3eb831e,0x4dbf3030,0x829264a7}},	//   _استحضا_, _aartu_, _hodisala, _etuate_,
   {{0x8212d5e5,0x5a60f14c,0x8ecf0159,0xc0c9d40f}},	//   _shehu_, _মহাদেব_, _elutasít, _fullkoml,
   {{0x1c82f155,0x235590c5,0xa3a23198,0x8c77606e}},	//   _قەيسەر_, _faveurs_, _secretár, _seputar_,
   {{0xea05308e,0xb4a070ac,0xa3f910e9,0x59e70373}},	// [1bc0] _beksingq_, _wedstrij, _vacuno_, _impreved,
   {{0x4d9693ef,0x1865c2f3,0x5248c2b8,0xa26c701c}},	//   _mattered_, _близини_, _nommer_, _finom_,
   {{0x03eb8121,0x43a22436,0x1d83e1b6,0x52d792a7}},	//   _tartu_, _tempie_, _སྣྲོན_, _графикас,
   {{0xb5563217,0x6ee832fd,0x62fc81c5,0xb0b1f0f7}},	//   _tannarı_, _وتونه_, _bukilis_, _中华人民共和国公,
   {{0x2248c2bc,0x93db60f7,0x130b8080,0x427ef223}},	//   _kommer_, _安徽省金企网络技, _allintaj, _mwingi_,
   {{0x1dc4f3ba,0x2b4da1fa,0x5606306a,0xa2969175}},	//   _prekrasa, _dlawanga_, _वेबसाइट्, _lesklav_,
   {{0x4863a1df,0xee78d052,0x82fcd14f,0xec552283}},	//   _קרוין_, _aktivitā, _amogho_, _avotele_,
   {{0xac65040b,0x3ea281e2,0x584b34de,0xb018711b}},	//   _最近のコメント_, _sundowns_, _sextilis_, _димитриј,
   {{0x66f16023,0xa83ec248,0xd806a14f,0x00472030}},	//   _ansaalá_, _ኣንጸላልዩ_, _agamyāga, _кетса_,
   {{0xbda010e9,0x9d0d210f,0xa9cb50fb,0x1fbc900f}},	//   _facultad_, _آزادانہ_, _कम्पने_, _апарату_,
   {{0xde0101f0,0xfd68709a,0x63659299,0xb0b650f2}},	//   _имтиханы, _музларни, _vengono_, _उपसभापति_,
   {{0x17b803f2,0x57c6e2af,0x13948244,0xe7a1f553}},	//   _sikudumi, _aperetsw, _jaksta_, _reguleri,
   {{0x7d85d35b,0x1024d248,0x82902114,0xec61322f}},	//   _словами_, _ጀርመናውያን_, _dekad_, _prirode_,
   {{0x7c09c163,0x4af700c9,0x03eb721f,0x335fe222}},	//   _campina_, _aarsbere, _flatte_, _herfyri_,
   {{0xb2a78169,0xbecd62ce,0xc84ef3d0,0x0a2b1022}},	//   _berbe_, _alayense_, _аргентин_, _ءىسزدى_,
   {{0xd3226200,0xa2923009,0xa26de138,0x12009267}},	//   _chuyma_, _порядка_, _gotov_, _kajite_,
   {{0x7bec6115,0x3a95524c,0xcf116121,0x42e361b3}},	// [1bd0] _confondr, _انصافس_, _suitseta, _admitte_,
   {{0xaf93854b,0x547833bc,0x237a701f,0x7ae3b0a1}},	//   _vendedor_, _levevilk, _matakan_, _nonekoab,
   {{0x9212905f,0xdbd002a7,0xf57e1008,0x52fc012b}},	//   _akahi_, _چیکلنمه_, _ekologiý, _iziga_,
   {{0x197441b3,0x0b9ac0da,0xcfdfb4ee,0x0239239c}},	//   _reunione, _pianific, _podvižni, _торус_,
   {{0x52b46489,0x1610d555,0xf2b66261,0xe1a6410e}},	//   _troch_, _ukulungi, _barche_, _kupować_,
   {{0x9b974098,0xa837e026,0x2920009a,0xfefd111b}},	//   _komisiyo_, _하겠습니다_, _аппарати, _управо_,
   {{0x42e77438,0xaf4201a9,0xd2129250,0x8e72316e}},	//   _nkundla_, _идиологи, _ekahi_, _постане_,
   {{0x46e8b375,0x0fc00056,0x44b15225,0x95b1c118}},	//   _қарастыр, _lebeletš, _inscriçã, _vengaboy,
   {{0x6386957d,0xedee3063,0x8f5f31de,0x4f03f5c3}},	//   _ceart_, _کمپوز_, _prepozna, _oficinas_,
   {{0xe68a0261,0x72d892a6,0x5241a59b,0xdc23815e}},	//   _spiegazi, _dajemo_, _ढंगले_, _голомт_,
   {{0x52fce309,0x7c61f018,0xe2fe406e,0x52b46055}},	//   _amigho_, _oferite_, _entitas_, _croci_,
   {{0xe2b54562,0xc1d6f41e,0x43fa60b4,0x7291d449}},	//   _efecto_, _anonymní_, _baruka_, _ajwan_,
   {{0x9eb122bb,0x29c7c21a,0xffbe3248,0x12fca406}},	//   _karolwan, _сабака_, _ቀርነልዮስ_, _indikas_,
   {{0xc2a782ea,0x234141af,0xf5a7c3d0,0x63416053}},	//   _serbe_, _kawenga_, _библид_, _offenen_,
   {{0xd3aac287,0xc1c54173,0xcc6ac1a8,0xb2fcf0c3}},	//   _старой_, _resminam, _старое_, _stigli_,
   {{0x9c74d248,0x12cb71d8,0x1290e3ce,0x9aa7f275}},	//   _መጽሄታት_, _ngadon_, _finaal_, _баратти_,
   {{0x57a91162,0x43eb747f,0x09a0314c,0x9618d1b5}},	// [1be0] _دوستانە_, _cuatro_, _পন্ডিত_, _ءادرىسىم,
   {{0xffb96049,0x2386d465,0xff65a07e,0xd189a263}},	//   _títulos_, _afero_, _betalnin, _ленинро_,
   {{0x2e55d2f4,0xc212f076,0xee3b0223,0xc3fa6522}},	//   _булаам_, _haihai_, _barabara, _zaruka_,
   {{0x79e484ee,0xd3860395,0x034202c1,0xd21312e9}},	//   _osnovana_, _afiri_, _gereken_, _bichen_,
   {{0x03ce9160,0x73a22161,0xac12b171,0x880a83cc}},	//   _glavu_, _dumped_, _utaratib, _авчрах_,
   {{0x1e9f007c,0x7c61b293,0x88895517,0x03966239}},	//   _abamalun, _rukundo_, _застрахо, _agusta_,
   {{0xf224e5bd,0x4876e12e,0xe39d35cd,0x12e670fb}},	//   _bankas_, _gimnazju, _angabanj, _क्लीं_,
   {{0xc20150e3,0xa3281135,0x5e93c01a,0x06821008}},	//   _maging_, _ዘርእሰናይ_, _келишимд, _derejesi,
   {{0xe302f16f,0x1bb40283,0xb2015316,0x9ddb7221}},	//   _redaktu_, _abakacec, _laging_, _abakwala,
   {{0x73869342,0x6efbb048,0xd2cd207f,0x24087206}},	//   _fearr_, _prevence_, _аиуаанӡа_, _onlinesk,
   {{0xd9c391e9,0xd2f4530a,0xcb81b42e,0xf2f5b1e9}},	//   _beleseat, _bihinim_, _vinnumar, _militik_,
   {{0xe73253dd,0x1386918a,0x96973056,0x927a8076}},	//   _bogoslov, _afara_, _thutamah, _halihali_,
   {{0x12eee0f5,0x1df6e1fd,0x44378533,0xb20061a2}},	//   _hoffe_, _kuruluşl, _habayeho_, _avoin_,
   {{0xdd2ff085,0xdb73c33c,0x7e363443,0xfa90c1f2}},	//   _চানাচুর_, _فرزندلری, _adolfobs_, _freistin_,
   {{0xb3fcd196,0x7224e13a,0xe3967051,0x3dbec063}},	//   _antolatz, _bankis_, _lassie_, _moliyala,
   {{0x71cc01d4,0x3d8c01d4,0xd886a022,0x63967287}},	//   _kommunim, _kommunia, _функцияс, _kursas_,
   {{0x32c6518a,0x0c8c029e,0x5202749f,0x23eb7198}},	// [1bf0] _publice_, _communiq, _ensino_, _quatro_,
   {{0x2387343f,0xaf5f01fc,0xe47ff15e,0x1387450e}},	//   _staré_, _envairon, _papereko_, _aterwa_,
   {{0x73ebe03c,0xceace11b,0xf2131341,0x9801b206}},	//   _fatti_, _користит, _sichen_, _temporis_,
   {{0x1358e0ee,0xedcec043,0x125ae500,0x63bf9387}},	//   _letenky_, _живет_, _ikincisi_, _angware_,
   {{0x1290d1dd,0x1c621419,0x5841e167,0xf534e041}},	//   _balavu_, _resumen_, _puntadas_, _akusekho_,
   {{0x1dc7c620,0x6283f438,0x07fc20ac,0x025af428}},	//   _urtherfa, _ngasentl, _민간인학살_, _skildi_,
   {{0x82a6646c,0x826c1241,0xd8fcb2db,0xc3ce9338}},	//   _panjabi_, _bihor_, _halatynd, _slavu_,
   {{0x67546011,0xd39670eb,0x3918a292,0xfc6154f4}},	//   _genérico_, _bursas_, _мукаррам, _fatunga_,
   {{0x0bb2923c,0x07b57169,0x2e3ce264,0x32d98138}},	//   _archivio_, _onbeding, _لشؤون_, _oprez_,
   {{0x2792f11e,0x1248d04a,0x0e1c9258,0x63814388}},	//   _distanti, _ainmge_, _anigaasa, _کارگێر_,
   {{0xd097e0b7,0x7600d17a,0xc25ae22c,0xa5dd6157}},	//   _времена_, _সপ্তাহলৈ_, _sailia_, _percival_,
   {{0x73790012,0x1ebce214,0x86dc6388,0x13ea7089}},	//   _misaada_, _ءﺷﻮﻟﺴﯩﺰ_, _مغاویری_, _canty_,
   {{0xbe56e307,0xaf6ec1bc,0x45d0a035,0xc200c118}},	//   _kubanske_, _ئستودەنى, _augustā_, _salive_,
   {{0x52fce595,0xbefbc414,0xf7017041,0x827875dd}},	//   _hingga_, _provence_, _میاشتنۍ_, _besnik_,
   {{0x34f640f7,0x13987185,0x4a0bc2ce,0xd77320e5}},	//   _一年赚一生工资_, _awerehow_, _ambalela_, _लावण्यम्_,
   {{0x617e11bc,0x16e7f3ab,0x73958171,0xb2917336}},	//   _كۅپكۅ_, _starožit, _fursa_, _avaava_,

   {{0xe200c005,0xd51c02f7,0x9de82022,0x154a42fc}},	// [1c00] _galite_, _тәрбийил, _бюджетті_, _половини_,
   {{0x83eb826f,0x7f12f347,0x7348c261,0xdf6cd0d2}},	//   _harti_, _distinta, _difetti_, _жылкы_,
   {{0xc22472bf,0x0681424c,0x12412654,0xeb61a0e5}},	//   _yanka_, _قبرستانا_, _संघले_, _मिलनी_,
   {{0x9c615044,0xe2d8c115,0x114710c2,0x37c7109f}},	//   _patunga_, _almens_, _aparetso, _aparetsw,
   {{0xe2b4d252,0xb0eac199,0xd433e316,0x6637e087}},	//   _grecs_, _llandeil, _atupagin_, _frontski,
   {{0x22b663a4,0x1146112f,0xb26d8219,0x2f11c169}},	//   _tercia_, _داموللا_, _anron_, _diddelen,
   {{0x4d0a51d4,0xc7a020eb,0x5465a3b5,0x0290e08c}},	//   _biologit_, _ascendev, _perdendo_, _triade_,
   {{0x2ae7a2f3,0x8b9511ba,0xa26c7247,0x326cc278}},	//   _медицине_, _столицат, _sinop_, _haloti_,
   {{0xbbfc30bf,0x82f4c22e,0x7209a1a5,0xd236912e}},	//   _تدبیر_, _kapital_, _нотамоми_, _staje_,
   {{0xc2cad46a,0xb2914299,0xdcdf60f7,0x7189010c}},	//   _nceda_, _creare_, _县级以上各级人民, _dipapetl,
   {{0x32247200,0x32fce30a,0x0fac111a,0x1db3f262}},	//   _panka_, _fingga_, _paborito, _badafite_,
   {{0x7ec243af,0x940ef11c,0xd13d203a,0xf58fd024}},	//   _ndangcan, _teorainn_, _ezitasyo, _अवबोधने_,
   {{0xa7caa1bd,0xef64b283,0xc3958205,0x7cf30419}},	//   _असामान्य_, _angaphin, _cursi_, _hosteler,
   {{0x75e8c060,0xe2bf80af,0x49f7417d,0x8ec9245b}},	//   _psychoph, _ザ操作端末_, _palautet, _moindres_,
   {{0x3caad2e6,0xffd665a2,0xfed8e1a0,0x348df231}},	//   _पूर्वांच, _councilo, _iblibons_, _eleganck,
   {{0x41ce50bb,0x6248c65b,0x21cf3031,0x9c74d248}},	//   _положенн, _sommar_, _የአርሰናል_, _መጽሔታት_,
   {{0x239541b1,0x03f403ba,0x39827075,0xef75e1bf}},	// [1c10] _viesti_, _sustav_, _možnosti_, _активити,
   {{0x67b570f5,0xabda11d9,0x7496b3fb,0xe7e820e8}},	//   _unbeding, _сапарынд, _rekreasj, _कामकाजी_,
   {{0x458be12b,0x237a128f,0x426ce1cc,0x5175f1a1}},	//   _anamachọ, _pasaron_, _fanovi_, _asinsbay_,
   {{0x39b9638c,0xf2e81411,0x7e70c0ea,0xb2026521}},	//   _материја, _dicipta_, _चुस्त_, _striid_,
   {{0x52c592e4,0x9c04f012,0xe3cf005d,0x83869258}},	//   _beeline_, _taasisi_, _anavos_, _peary_,
   {{0xe18b11e6,0x09e7816c,0xf2d8d1fe,0xe2377290}},	//   _krameṇa_, _gregorye, _ameel_, _प्रतिभास_,
   {{0xd2ee52f2,0xd5b7601b,0xed135109,0x00a9c0c9}},	//   _verilib_, _senagaty, _kunstver, _французь,
   {{0xf6b90111,0xf386959c,0xdb8f524f,0x3951e1e2}},	//   _ensaluti, _weary_, _misissor, _okulande,
   {{0xb290e3e4,0xca0592a2,0xe3eae351,0x4006c225}},	//   _manatu_, _begsingq_, _manten_, _енергија_,
   {{0xb1a99502,0x7c6843a7,0xe9dc82c1,0xd3eae039}},	//   _gammävi_, _samueli_, _başlangı, _lanten_,
   {{0xe2247130,0xff3ee314,0x0c28c02f,0x0e2623f9}},	//   _manko_, _चिनियाँ_, _خيانت_, _фактом_,
   {{0x59743037,0xce08c1f0,0x52b4d16d,0x9378a120}},	//   _белешмәл, _метрҙан_, _freck_, _bakakon_,
   {{0xdc7e22b8,0xeb6e10a1,0x728d03a7,0x7373e057}},	//   _verskyn_, _willybir, _kuwanyam, _инундаци,
   {{0x94bd910e,0x384c920e,0x6c78365c,0x638665d8}},	//   _ट्रेनों_, _поставув, _årstal_, _ngora_,
   {{0xf27c62d2,0x926d833c,0x8c50b071,0x9810b0ff}},	//   _herstell, _biron_, _prachtic, _prachtig,
   {{0xb3eae2dc,0xa40190e2,0xf2cd01a3,0x0c7c4387}},	//   _janten_, _ameriken_, _khuliso_, _ajesara_,
   {{0x427f509b,0xf2266053,0x584ad005,0x3ae21105}},	// [1c20] _tiener_, _merken_, _ложку_, _אָבאַמאַ_,
   {{0x8236024a,0xb260408d,0x32b4d16d,0x0e4fb351}},	//   _krije_, _ikhonomi_, _dreck_, _اونوقت_,
   {{0x42cb50b2,0x137380e5,0xcdd1e28d,0x2d1b0031}},	//   _dogdig_, _badanie_, _akakanga, _የዶክተር_,
   {{0xa2e1b02d,0xccf8b3cb,0xcb83a2b5,0x4a1451ab}},	//   _minnhom_, _इन्सुलिन_, _stonewor, _makasama_,
   {{0x42ef334d,0x3c51d121,0x036cc494,0x13f0e131}},	//   _hangamei_, _बारें_, _şəhidlər, _buleleng_,
   {{0xdd0dc207,0xdacaf45f,0x72cbf339,0x32ca518a}},	//   _arkadaşı, _सुदर्शन_, _naudu_, _conditii_,
   {{0x626463bc,0x53d102fd,0xbe27e0cc,0x6c09312d}},	//   _forlag_, _ڕێناس_, _primeras_, _mompera_,
   {{0x93866017,0x12b4d02a,0x07c5f252,0x6ed4001a}},	//   _agora_, _breck_, _prestaci, _келишими,
   {{0x3c3ad3ed,0xf20060f0,0x52eee3ec,0x42cbf1e7}},	//   _людей_, _avoir_, _hoffi_, _kaudu_,
   {{0x82eee435,0x198064d5,0x4975e295,0x9c76665d}},	//   _koffi_, _articule, _ndondome, _पित्ती_,
   {{0x11703026,0x96ab6381,0xb60b01fc,0x17b6525f}},	//   _책임한계와_, _абатальо, _kolektem_, _forefing,
   {{0x8e45d47a,0x3236038f,0x34d7e0f6,0xd386621f}},	//   _mugaraga, _vrije_, _параны_, _egora_,
   {{0xc1b30238,0xf166113f,0xa6b9e2ae,0xd2f46208}},	//   _notennoù_, _ריקודים_, _seisukoh, _airneis_,
   {{0x12360521,0x5ba7f308,0x645ec296,0xa2266051}},	//   _trije_, _akuyalus, _abadiliz, _herken_,
   {{0x003fb4d2,0x9d29d1f3,0x62b5f20c,0xc3ced2f8}},	//   _earthlin, _ڈیموکریٹ, _uruce_, _alevu_,
   {{0xbad58140,0x329462af,0x83870183,0x3bdbc182}},	//   _zamança_, _baikepi_, _aparit_, _amarṣaḥ_,
   {{0x26de7524,0x83958369,0x52bf10c7,0x1afb53b4}},	// [1c30] _प्रहेलिक, _cursu_, _لۅتان_, _arogants,
   {{0x6e45d125,0x5da9d12e,0x1cac90f7,0xe860f032}},	//   _kugaraga, _zapomnia, _商务部网站_, _raunveru,
   {{0x25e1e2eb,0xb10202a7,0xd37ac049,0x82eee3ec}},	//   _inverosí, _bunyodko, _tocando_, _coffa_,
   {{0x79d6a10f,0x9d1ec155,0x26c93248,0x8316418b}},	//   _واقعات_, _вәкилләр_, _ኮርኮራን_, _kalbari_,
   {{0xd5815198,0x8c7510c2,0xbc610027,0xf5f3513c}},	//   _associaç, _atisang_, _insumma_, _ахирурги,
   {{0xa89f50c8,0xad3b1248,0x73f461ac,0x55c3b364}},	//   _спрабава, _መጻወድያ_, _martsa_, _angagoyy,
   {{0xf7c8a135,0xa20090f0,0x92da403d,0x33657477}},	//   _ቤተሰብን_, _avait_, _okweli_, _berguna_,
   {{0x94133352,0x8893f439,0xb0533291,0x8e5071d7}},	//   _شاندی_, _berkedud, _شانسی_, _caratula,
   {{0x97c7c32f,0x1c52f249,0x0525e0ff,0x82da5367}},	//   _радиои_, _cuntegn_, _verzendk, _katero_,
   {{0xd23603ba,0x837335f6,0xde45d098,0x3305c14f}},	//   _prije_, _binaine_, _bugaraga, _लिखित्वा_,
   {{0xba7c73c6,0x1c98541b,0x58f810b1,0xd007430f}},	//   _tangohia_, _gelukkig_, _dabadeed, _विषयांचा_,
   {{0xa25ad2ff,0xdea39168,0xe6b643b4,0x29fd2018}},	//   _cholli_, _meerdere_, _berekanw, _duminica_,
   {{0x026d8196,0xd097e011,0x0d76c291,0x79d88048}},	//   _kirol_, _франциа_, _گرسنه_, _desetile,
   {{0x5387f20d,0xd2fc6262,0xe3a94214,0x83f4743d}},	//   _geure_, _nzoga_, _сайтыңыз, _kusten_,
   {{0xa20101b3,0x129101c4,0x2526915a,0x4ec50227}},	//   _habite_, _buckles_, _विज़ेट_, _이메일무단수집거,
   {{0x9a35b085,0x12900019,0xde45d293,0x02d8e2f6}},	//   _দ্বিধা_, _alian_, _rugaraga, _maneko_,
   {{0x526d00c3,0x13957220,0x0387f4de,0x3706e21d}},	// [1c40] _izbora_, _ifasha_, _beure_, _व्यशेम_,
   {{0x779b824f,0x59f691a1,0xe26e7215,0x42ed6227}},	//   _chemnitz_, _invasive, _heroji_, _기술공학계열_,
   {{0x4387f1bc,0xa38691f8,0x4a173075,0x1913e3a7}},	//   _veure_, _igara_, _istarska_, _anabangu,
   {{0x24f53262,0x5cac92d2,0x3387f067,0x5c6f61ac}},	//   _itumanah, _leistung_, _eduru_, _ratrema_,
   {{0x521c51f0,0xdf9b0188,0x11b0c02f,0x726d8502}},	//   _motheo_, _alleguer_, _انجلۍ_, _birol_,
   {{0x31fc32aa,0x9200929e,0x55330238,0x4386947e}},	//   _malagasy_, _avais_, _atlantel_, _afars_,
   {{0xf75323af,0x6344a03a,0xb950d221,0xad90d03d}},	//   _gyengang, _aprepre_, _akulunge, _akulunga,
   {{0xca6c20f7,0xb35600f7,0xc79d23bf,0x0c8b80f4}},	//   _climatis, _均转载自其它媒体_, _цифри_, _يەرتەۋرە,
   {{0x329122b5,0x6784e32d,0x69e322db,0x5417e20d}},	//   _pecans_, _acireṇai, _горамак_, _begiratz,
   {{0x7290c225,0xd2a702b7,0xe224701f,0xb2da4438}},	//   _demais_, _asabar_, _wanke_, _akweli_,
   {{0x42ee72f5,0x5429a4b5,0x73877005,0xdfbf8056}},	//   _confi_, _inkastoo_, _tvarka_, _tshebotš,
   {{0xe5c8d65e,0x2386912b,0xa0c5e20e,0x08db52c0}},	//   _intaneth, _agara_, _евровизи, _kaaraang,
   {{0x82009027,0x52cbd2e9,0x2cf2842e,0xd2d8e496}},	//   _avair_, _biloyha_, _myndband_, _maneho_,
   {{0xc61380e9,0xf3eb8196,0xd2b4d113,0x426d1101}},	//   _violenci, _sartu_, _preci_, _bizou_,
   {{0x927e13eb,0xb570601a,0xb40c8275,0xc3eb8123}},	//   _einstakl, _берилген_, _алданған_, _partu_,
   {{0xf387f01e,0xac7693af,0x4976b42f,0x03468205}},	//   _aduru_, _dopraih_, _undivide, _sawdust_,
   {{0xb66f30fb,0xa25b4177,0x35545457,0xd6b91421}},	// [1c50] _सुभाषितम, _ceelam_, _nervioso_, _aspaalti,
   {{0x668230e8,0x203fb0be,0x69e9d192,0xf683c06c}},	//   _akcesori, _historin, _талантта, _सेयान_,
   {{0x876dd264,0x953ce212,0x850db326,0x3980a37f}},	//   _الشأن_, _دزلزلې_, _aluminiy, _akukhota_,
   {{0x828d9056,0x846e4098,0x57a430f7,0xf0c6303d}},	//   _boikano_, _ibidukik, _胶南市乡镇及街道, _abalusal,
   {{0x5c5fc3c9,0x0224c3ab,0xa290c10f,0x03954369}},	//   _nostram_, _radka_, _kaland_, _avesol_,
   {{0x899131a9,0x625b4036,0xf1d380e5,0x83790301}},	//   _ئويمانلى, _scelta_, _गोपालगंज_, _zdravia_,
   {{0x92480013,0x9dc3c0c8,0xc5b9a080,0x820273bf}},	//   _reime_, _anekdota, _achakach, _fisico_,
   {{0x9259c358,0xdc188251,0x6dc910ca,0xc349f31e}},	//   _появится_, _раководс, _acchanda, _alseeri_,
   {{0x8c0470a0,0x9d529008,0x322660b1,0xe5154096}},	//   _ofisini_, _руссияда_, _markab_, _پروڈکشن_,
   {{0xad12c0fe,0x4816f005,0xe67b2018,0x4c5fc251}},	//   _iharanir, _pareigūn, _атримис_, _mostram_,
   {{0x67914210,0xb37fd1e4,0x9ac480af,0x826d10bf}},	//   _isotreti, _malaila_, _質問をみる_, _nizom_,
   {{0xa9286224,0xafd55140,0xd283b08d,0xe2c2105f}},	//   _gammalwa_, _leninogo, _atekiwa_, _amaleka_,
   {{0xc3eb83a4,0x77580345,0x1290c063,0xac60d029}},	//   _barts_, _विश्वाश_, _baland_, _sumuhun_,
   {{0xe0bc2215,0x026c71f1,0x093c2215,0x55b7b166}},	//   _promenil, _vinos_, _promenit, _dispoziz,
   {{0x99436431,0xec7692b8,0xfb5be213,0xdf92415d}},	//   _imprimer_, _verslag_, _lurtanxa_, _adedasar_,
   {{0xeec31492,0xa383165f,0x463bf22c,0x6a8a403b}},	//   _benyttet_, _benytte_, _aleituai, _atinamib,
   {{0xac6f7098,0xf26c51d2,0xc341410f,0xe9e86043}},	// [1c60] _afurika_, _daloi_, _hardver_, _maatalou,
   {{0xf9fd23f9,0xb8cfc2ac,0x1db31033,0x926da2a8}},	//   _datatype, _بلۆکی_, _kalamiet_, _ripoo_,
   {{0xc342708c,0x1868c004,0x32f3e05c,0x0d827168}},	//   _beteken_, _ويديو_, _objaviti_, _betekent_,
   {{0x83eb7407,0xa27e04ef,0xaae8101b,0xcecd40c2}},	//   _moatte_, _flintoff_, _мумкинчи, _ausinyan,
   {{0x2ce15300,0x62252089,0x10363293,0x2c1f90a3}},	//   _skridoù_, _dickey_, _abateran, _skepper_,
   {{0x92fcd4ad,0x035bf01d,0x82feb1f4,0x5d9af442}},	//   _lengwe_, _mungana_, _antasari_, _akandiwa,
   {{0x49cc141d,0xabf5c388,0xa09891b5,0x03eb8027}},	//   _rendelke, _بورجه_, _ادامگەرش, _varts_,
   {{0xf0d31030,0x241f603d,0x30f430c2,0x6ba41060}},	//   _takomill, _sesikhok, _алтынды_, _artikilo_,
   {{0x5c60500f,0x4202742a,0x532ae007,0xed1b61a5}},	//   _skatter_, _risico_, _klikkelj, _abangase_,
   {{0xb3a3418c,0x936161cf,0x5231a23c,0x063b0572}},	//   _phepha_, _stemmung_, _местонах, _activaci,
   {{0xd27f70a1,0x21dae275,0x42fc316f,0x77ce84ce}},	//   _omenë_, _жамаъәтк, _validas_, _enetisiw,
   {{0x5386d0e8,0xa26c514a,0x535bf256,0x746140a3}},	//   _ofert_, _aalow_, _bungana_, _samewerk,
   {{0xa3eb826a,0x05d9a0c2,0x730873ba,0xe0aed17b}},	//   _parts_, _индексы_, _trebamo_, _ержан_,
   {{0xe2d4662b,0x525c6299,0xd84a3140,0xb7629447}},	//   _verdad_, _località_, _актуаль_, _реальнос,
   {{0xc1de6218,0xa2d9b0a4,0xefc2e404,0x56436395}},	//   _chinntiú_, _bavelo_, _باجوڙ_, _mpanyinf,
   {{0xb5d1402f,0x32ba70be,0x6e3af1ab,0xa18a41e2}},	//   _میلادي_, _mendimi_, _patakara, _ababenal,
   {{0xcee5a0db,0x63eac3ef,0x920113a7,0xa8b6d11c}},	// [1c70] _агентлығ, _multum_, _ambiri_, _ورئيس_,
   {{0x1387f148,0x4c0342c1,0x6dba80ea,0x3eea12d4}},	//   _geura_, _dersler_, _kotouče_, _anchatas_,
   {{0x6000d30b,0xfd90c0de,0x93d75660,0x2d62639c}},	//   _informāc, _келди_, _abatutsi_, _кесингир,
   {{0xfbe7d352,0xb24803eb,0x2c49702f,0xf26d940f}},	//   _براده_, _heima_, _داعلانات, _vandamál,
   {{0x54124244,0x7c1d0272,0x526de0ee,0xdd55a308}},	//   _chaninak, _adoptet_, _miton_, _himasiku_,
   {{0x0353c288,0xa2424290,0x7e9ad180,0x318ac248}},	//   _کهزاد_, _बंगले_, _このエリア_, _ምፍጣርን_,
   {{0xa2d1a2e5,0xc911c31a,0x62ca40b9,0xe2d821df}},	//   _človek_, _kivalliq_, _milleti_, _memoras_,
   {{0xb9483396,0x023bf21c,0x7386d2e1,0xbc16d0ac}},	//   _escritor_, _dueling_, _adorin_, _스포츠산업의_,
   {{0x973ee25a,0xd3ab34ee,0x0e531366,0x162cf20d}},	//   _publikig, _zapadnog_, _pelabuha, _emanaldi,
   {{0x1a721156,0x02fcd4ad,0x245d2225,0x9a120114}},	//   _акции_, _sengwe_, _alteraçõ, _membabit,
   {{0xc2486174,0xcbea0046,0x1dc9f171,0xa2ff401f}},	//   _veoma_, _encontro_, _mashinda, _moriyar_,
   {{0xe20ec2bd,0xf223e20e,0x94ea1031,0xfd8af07e}},	//   _табан_, _judiciár, _ኤርሚያስ_, _sammanha,
   {{0xba88d4d5,0x2365728c,0xa24861d0,0x4387f1fe}},	//   _socorris, _mergina_, _teoma_, _beuri_,
   {{0xf26ca53e,0x2289615b,0x0bea0229,0x2d8f0307}},	//   _libor_, _bataflai_, _incontro_, _akvedukt_,
   {{0xb2904152,0x3f46235b,0xddf02212,0x5c9070bf}},	//   _ilman_, _reisende_, _ځنډوي_, _یاپیله_,
   {{0x9c61f169,0x8e2260e9,0x501151ba,0x252ab180}},	//   _cadrage_, _quemados_, _produtto, _総合行政ネットワ_,
   {{0xba8980d7,0xe57c80ee,0x326de2e2,0x92480278}},	// [1c80] _сайланма, _anglické, _antou_, _feima_,
   {{0x6948217a,0xd200d407,0x05b841fe,0xe30640ea}},	//   _চেন্ট্ৰে, _talint_, _addinaam_, _स्थितिमा_,
   {{0xf2fcd22e,0x78d3114d,0xce642065,0xbd37a0b3}},	//   _dengue_, _विंटर_, _בנהריה_, _бизнесы_,
   {{0x53f4507e,0x37862501,0x126e00e8,0x12fc40d7}},	//   _mitten_, _sekwenzi, _europy_, _tabigat_,
   {{0x43f45071,0x763b152d,0x45faa022,0xe7d7041f}},	//   _litten_, _varijaci, _саммитін, _calgaryv,
   {{0x0c6d036f,0xa36403a5,0x634402f4,0x97c7223c}},	//   _конкурст, _amagama_, _gelditu_, _насилие_,
   {{0x8c53017a,0xe26de5dd,0xd26c546f,0x026c3007}},	//   _মিল্ক_, _fiton_, _falou_, _bajom_,
   {{0x02c410f0,0x02fc4114,0xa2ec9079,0x2843e0ac}},	//   _vendredi_, _puchong_, _butikye_, _하셨습니다_,
   {{0x630cb218,0x0879d2f4,0x0f27e382,0x586a1050}},	//   _cosaint_, _замбараа, _primorac_, _一定要把我的布袋,
   {{0x0b0940d2,0x4f0ac124,0x9b6700d2,0xa2da6419}},	//   _comparte, _аанҿасыр, _esquerra_, _laredo_,
   {{0x03eb800a,0x6d81d269,0x82b5907e,0x62fcd026}},	//   _party_, _pyelonep, _dusch_, _lengte_,
   {{0xfa39d427,0x5387f1d8,0x45c7f086,0x124a7369}},	//   _предстоя, _seuri_, _gwebcach, _llumar_,
   {{0xa2f4c26c,0xef0b9065,0x226c54b1,0x42da53f7}},	//   _napisal_, _תפסיק_, _lalot_, _tranble_,
   {{0x3683a009,0xbb2a347b,0x0c2a3459,0xccaba1b9}},	//   _создать_, _anabatab, _anabatar, _объектта,
   {{0x726ca063,0x2d021340,0x026ca4ad,0x80e003d2}},	//   _tibor_, _declarat_, _badirisi_, _countabl,
   {{0xc3131039,0x0c980205,0x73f98182,0xc378806a}},	//   _gambhir_, _courting_, _acyuto_, _senapan_,
   {{0x1c14d041,0x829170c6,0x72266135,0x13cf522e}},	// [1c90] _رواني_, _asaase_, _kerkon_, _nieves_,
   {{0x726cc00c,0xec832009,0x25ab3248,0x02efd1df}},	//   _malosi_, _некоторы, _ምስጋናይ_, _religia_,
   {{0xb123b200,0x2a736049,0x43a2d00d,0x13f8a291}},	//   _kikipaña, _ningunha_, _boopam_, _ambuk_,
   {{0xe29044f1,0x625af222,0xb8771345,0x9ea5809c}},	//   _ummat_, _skilji_, _muinasju, _callisan,
   {{0x126cc3c8,0x4cf6c17b,0x62d830c4,0x25840135}},	//   _arloqh_, _протон_, _bemera_, _perditsh,
   {{0xf6a2e501,0x29aac0f4,0x2d7d3351,0x3395f0e7}},	//   _okuthath, _пойиз_, _اجناس_, _mutsu_,
   {{0x0facb54b,0x62915453,0x03ecb07e,0x08481192}},	//   _favorito, _bugale_, _favoritk, _һәҙиә_,
   {{0xdea9f51d,0x82bba140,0x0cf04019,0xfca3d061}},	//   _رژمێری_, _ägerce_, _עלימיניר, _عارضي_,
   {{0x593b9057,0xf6c683fa,0x16a2e221,0x0a0930e0}},	//   _asemenea_, _achabudi, _akuthath, _ambarast,
   {{0x4f4e9112,0xd26cc1ab,0x5c7eb2c0,0x1359e05a}},	//   _diasaska, _ondoy_, _andsél_, _actuació_,
   {{0x533d1030,0xa200c0d9,0x533a0085,0x62d83262}},	//   _پیکان_, _salite_, _সপ্তাশ্চ, _remera_,
   {{0x2248918a,0x495fd0c5,0x29ea60d0,0xb386e455}},	//   _seama_, _ahengere, _ngutillu, _leiren_,
   {{0x620e12bd,0xc17722e9,0xd2d83181,0x92904390}},	//   _насар_, _bangheyl, _yemera_, _ammas_,
   {{0xa18fc041,0xc30d204f,0x6abe80e6,0xe1e2920e}},	//   _bioassay_, _membawa_, _provvist, _властите_,
   {{0x5267c09a,0x7201037e,0xa26d80d7,0x02ece4dd}},	//   _районда_, _bebiwa_, _kirov_, _avviste_,
   {{0x440f204d,0xf74b8113,0x1c166164,0x350540a0}},	//   _fearainn_, _noliktav, _abstrè_, _سناتوره_,
   {{0x15231087,0xd5409264,0x1354b43d,0x32489340}},	// [1ca0] _agentenh, _للنجاح_, _baserat_, _teama_,
   {{0xa2369135,0xe9e92626,0x1feb4228,0xb5200164}},	//   _tuaja_, _आशावादी_, _سرداران_, _anfouray,
   {{0x27f4d026,0xa5880351,0x0f5f2059,0xc136e08a}},	//   _사업계획서_, _ژورنال_, _keupayaa, _عراقه_,
   {{0x41c73351,0x525ae5f0,0x02c25250,0x23eae051}},	//   _باستانی_, _zbilja_, _ameleka_, _wanton_,
   {{0xf6ccf0c9,0xd9788317,0xbc779437,0xcc5282d2}},	//   _avkastni, _vanifest, _aktsemd_, _dritten_,
   {{0x1225746a,0x02366207,0x026de033,0xe140e484}},	//   _kwakho_, _proje_, _antor_, _arrecuel,
   {{0xc2c2642e,0x5d390115,0x8a7c9336,0x61d921f3}},	//   _daglega_, _chapadur, _fatafata_, _وغيرہ_,
   {{0x8e3c115f,0xd5b9a2d4,0xc65c313c,0xf1b71057}},	//   _nalunaiq, _achalach, _апошта_, _deputaţi,
   {{0xf201a079,0x5173f17d,0xe3cff027,0xdfed3031}},	//   _arvind_, _приходит_, _nouva_, _እናየዋለን_,
   {{0x62918334,0x0290d196,0x3b8d013c,0xf3645250}},	//   _guyane_, _salatu_, _incienso_, _aleguma_,
   {{0x44d7f063,0x5280e00a,0x5616b119,0x3956b119}},	//   _футболчи, _variety_, _aallarni, _aallarne,
   {{0xe2ddc059,0x9c87d56c,0xa31950db,0x0f63c2c3}},	//   _እንቅሰቃሴ_, _правни_, _badimong_, _батырлар_,
   {{0xec6d8395,0x28f0d011,0xe437620d,0x8344901c}},	//   _abireka_, _аматериа, _bezalako_, _hetente_,
   {{0xf29ed15d,0xfa89f5a5,0x3df99037,0xfe497252}},	//   _تمامی_, _anniston_, _сезоны_, _viladeca,
   {{0x716c3078,0x57b3c056,0x001f60eb,0x154e845f}},	//   _العكس_, _tshenyag, _alienato, _slovansk,
   {{0x123692fe,0x426c7177,0x62da616d,0xa37fc3bb}},	//   _iraje_, _manot_, _poteau_, _allampa_,
   {{0x0c85b13f,0x326c7039,0xda6cd212,0xc64f8005}},	// [1cb0] _תווים_, _lanot_, _abamakis, _technini,
   {{0xbaf8656d,0xc2904054,0x70fbb019,0x8af73437}},	//   _ierusale, _ummar_, _גלוסט_, _aftenpos,
   {{0x42e8859e,0x97b65661,0xb3949278,0x5200b07d}},	//   _treneru_, _forening, _ahasi_, _midiam_,
   {{0xe9c7c022,0xbd4ed041,0xf8421305,0x045c5182}},	//   _далада_, _محکمی_, _lecturas_, _amitrān_,
   {{0x527f4517,0xf84bf093,0xdda8b0c7,0x91fd52f3}},	//   _utenti_, _tertulis_, _muhiimsa, _настанак_,
   {{0x0394e5da,0x726cc44b,0x53445395,0xb536b175}},	//   _zaista_, _sidor_, _beberee_, _endividy,
   {{0x726de04b,0xff839662,0xd39490ec,0x926de1ab}},	//   _kitob_, _एक्का_, _thash_, _antok_,
   {{0xe2486203,0x1ae792f3,0x241020c6,0x4d193238}},	//   _edomu_, _величине_, _ghanafoכ_, _bennaket_,
   {{0x726c10b2,0xed866171,0xf26cc1ba,0xe1fc737f}},	//   _ibhom_, _نااميد_, _valori_, _akazikol,
   {{0x19ca91f5,0x92266168,0x839402db,0x5e48d15e}},	//   _وزیرستان_, _werken_, _ikisi_, _bitartea,
   {{0xc3b611fa,0x6c52106e,0x22486287,0x02eee32b}},	//   _chavaka_, _तेथेच_, _idomu_, _coffi_,
   {{0x298e10bf,0x4301203c,0xd2484178,0x5db4209a}},	//   _карим_, _davanti_, _hemma_, _بولوپ_,
   {{0xcb8c9011,0xccbe1136,0x779fc258,0xb2cae18b}},	//   _escorpio_, _варез_, _mittarfi, _pondit_,
   {{0x63ce6374,0xa3a78159,0x33cef37e,0x57b4a24f}},	//   _inova_, _مجبوری_, _nyambedz, _malugini,
   {{0x530051c5,0xa26dc237,0x8f0045a3,0x1a091012}},	//   _pulaski_, _nivoa_, _oslobođe, _عقيدي_,
   {{0xb6e0f0f7,0xc9f3f104,0xbc56a036,0x33433225}},	//   _多种方式看新闻_, _vivienda_, _partire_, _откривањ,
   {{0x426c73ba,0xe7d710bf,0x1349e124,0xdeaca3e8}},	// [1cc0] _danom_, _ماکاروف_, _aiterei_, _envolven,
   {{0x9200d01d,0x526e01b3,0xec68c031,0x9eaa40a0}},	//   _zweig_, _expone_, _ይመለሳል_, _هرصورت_,
   {{0x52f9111b,0x13eac2f4,0x5379043d,0x8263a105}},	//   _потребно_, _faltan_, _anpassa_, _חנינא_,
   {{0x72fc60ee,0x5c53726c,0x73e6b115,0x4b97f262}},	//   _drogy_, _portala_, _certanei_, _kurimbur,
   {{0xa51f132d,0x0dc342ab,0x8db864a5,0x2386f478}},	//   _anantabh, _atviruka, _defaraat_, _cairts_,
   {{0x41c92005,0x9d3ab187,0x7c148083,0x026e6048}},	//   _кошты_, _achibale_, _disseny_, _autory_,
   {{0x88d9f358,0xb26c7028,0x28c0c23b,0x262a2342}},	//   _сервисы_, _kanom_, _davuilev, _inaistri,
   {{0xafb133dd,0x437d4248,0x23c3a352,0xe26c5137}},	//   _veroispo, _ኣወሃሃዲት_, _کاروباره_, _aalok_,
   {{0xd8968037,0x2f23a387,0xdf5cb4e7,0xf25b41aa}},	//   _максаты_, _abouthap, _apraksts_, _abeloa_,
   {{0xd386f11b,0x4a8613e1,0x7cebf105,0x2c27a4ff}},	//   _širom_, _avansman_, _הפֿקר_, _fristras,
   {{0x439490c6,0xcda2c10f,0xe2e5210f,0x496ce233}},	//   _akasa_, _جاننے_, _عبوری_, _tahirint,
   {{0xba16012d,0x0395f2d5,0xb3877129,0xc1bf55b5}},	//   _mikasika_, _ortsa_, _dwarna_, _karadžić_,
   {{0x5e0c123a,0xa486414d,0x95740506,0x00db8030}},	//   _tendulka, _सुधारे_, _wittensk, _vakolatl,
   {{0x047c0218,0xe28c9012,0xb2fda17c,0x4a35b4e7}},	//   _cartlann_, _دانشگاهه_, _dividas_, _politikā_,
   {{0x124891df,0x23e7a0ea,0xb2d94169,0x0a4752a8}},	//   _teamo_, _zítra_, _tseell_, _parekura_,
   {{0xff46012e,0xb7a2e0ac,0xdc7d203a,0x07adb14c}},	//   _zakresie_, _테마스토리_, _praslin_, _মেঘলা_,
   {{0x2946b0f7,0xea17e218,0x664a4031,0x7291f0c3}},	// [1cd0] _国家外国专家局_, _tagartha_, _ለመትከል_, _pripreml,
   {{0x68972004,0x6313d218,0x42bbd16d,0x937fb131}},	//   _کروبی_, _saibhir_, _erkenne_, _bedanya_,
   {{0x9341722e,0x6341f2e9,0x681d00c9,0x6200f262}},	//   _cosenza_, _bilesmo_, _ситуацій_, _bahise_,
   {{0x126e20fa,0x826d8199,0xd7dd212a,0xe8ea6253}},	//   _varoš_, _sirol_, _displaci, _agasolog,
   {{0x02904173,0x31dcf004,0xd340f15c,0xe2b5f344}},	//   _almak_, _اتحادیه_, _aaneren_, _aruca_,
   {{0x738662d9,0xef34c13c,0xfc10f131,0x4290931e}},	//   _agoro_, _сулхан_, _kesukses, _amaat_,
   {{0x92497233,0xa23830d1,0x626c5074,0x02dab199}},	//   _mbamin_, _boheriwi_, _kaloi_, _trundle_,
   {{0x64b9320e,0xa95a6005,0xcbf190f5,0x8cd970de}},	//   _просветл, _намаганн, _urheberr, _بولدۇنۇ_,
   {{0x057500e9,0x485bd0a2,0xee83b04c,0xd26ca22e}},	//   _maltrato_, _abangavu, _نتونستم_, _labot_,
   {{0xb3866067,0x8b9dc1c9,0x2dfcf0df,0xd2fca1a7}},	//   _egoro_, _meningoc, _excesswa, _cadidas_,
   {{0xb46d012f,0x9c2a523c,0xcb8433b0,0x1f53c34e}},	//   _ﺋﻪﻳﻨﻰ_, _compless, _svendbor, _бомбаи_,
   {{0x83449246,0x5f03b345,0xf9669369,0xf290f32b}},	//   _aeteete_, _निर्मोही_, _anarchic_, _asiant_,
   {{0x2d9c32e2,0x02d83006,0xc2c5106c,0x4eecd132}},	//   _pagename_, _pamene_, _kellele_, _reevalua,
   {{0xa9b19007,0xd29041e0,0x826cc4b5,0x82eb6089}},	//   _terjeszt, _romae_, _cadow_, _glances_,
   {{0x09d16050,0xb26c71ab,0xfa669124,0xab1a10f3}},	//   _男生女生配_, _manok_, _аунивирс, _paradoss,
   {{0x531f3369,0x42c2519c,0x8e408155,0x323690e9}},	//   _glacial_, _amelika_, _ﻗﻮﺷﯘﻟﺪﻯ_, _itaju_,
   {{0x217da019,0x563ce46e,0x8af3f0af,0x6c62a0f3}},	// [1ce0] _פיגור_, _arianism_, _anbringe, _terrore_,
   {{0x1d85b2e6,0x3634531a,0x7017d1ed,0xd340e1b8}},	//   _बायोग्रा, _parnaini, _таможня_, _skydoor_,
   {{0x76d23663,0x6c66a051,0x12b673ef,0x32d6d28b}},	//   _एकदिन_, _fattest_, _crucis_, _einliks_,
   {{0xb14c301b,0x4248d36f,0x5e772030,0x8898d005}},	//   _hormatly_, _seema_, _کاردان_, _каардына,
   {{0x14275374,0x599321ca,0xc2598146,0x22d83127}},	//   _bulawayo_, _چھُکھ_, _identiti_, _damele_,
   {{0x32fb2221,0x3621d121,0xc5a953dc,0xc3567393}},	//   _kuphela_, _गांधीगिर, _заработа, _acceder_,
   {{0x6dd233ed,0x82ea107d,0xa0d332fc,0x74f2203d}},	//   _доступу_, _disisen_, _класе_, _امامانو_,
   {{0x229112b7,0x62b4d168,0x426c718b,0xf34892e9}},	//   _labaru_, _ilocal_, _ianoh_, _dabejdi_,
   {{0x5248d1b4,0xb317200a,0xb4476121,0x6201a147}},	//   _teema_, _planning_, _चन्द्रभू, _javite_,
   {{0x9290906e,0xcec7c3ef,0x737fd0c7,0xe13990dc}},	//   _bekasi_, _audiocen, _kulanka_, _мазмунда,
   {{0xa9847043,0x930e10aa,0x7c752057,0x22fe90c3}},	//   _mediatie, _arabaha_, _valutar_, _novinar_,
   {{0x12ee1142,0xf2f50052,0x82feb00e,0x3f2e31b3}},	//   _izolacij, _pavisam_, _intizar_, _montania,
   {{0xfbee4248,0x715cd15e,0xeaeed34e,0x926d825a}},	//   _ብሚልዮናት_, _сугар_, _abadukis, _viroj_,
   {{0x026d1406,0xe51b63ef,0xdd129476,0xae3c3213}},	//   _labori_, _skinligh, _guerreir, _saranaqa,
   {{0xfd84a2d7,0x842630ea,0x006bd00f,0x1c61f1eb}},	//   _keresete_, _खराबी_, _станом_, _kadrage_,
   {{0x5e54221f,0x68e521bf,0x2b4c22c1,0xd26c14b5}},	//   _strangle_, _адмитеря_, _numarası_, _kahor_,
   {{0x82d9d2e2,0x396d1041,0x2af80144,0x6841f240}},	// [1cf0] _omwen_, _abanakut, _anesizat, _realkred,
   {{0xf7b5b664,0xb60150d0,0x2f2fd426,0xb091614c}},	//   _najstari, _qulliuti, _akkorder_, _ট্রুথ_,
   {{0xb3eb813e,0x92da40dd,0xb30f7025,0x02d8305b}},	//   _karty_, _rowers_, _amubina_, _bamele_,
   {{0x7a03a3ef,0x81b0c40d,0x53508121,0xb258704b}},	//   _paralyze, _جنگلس_, _वसूले_, _ватанпар,
   {{0x520e11b9,0x030050bf,0x8c84913f,0xc65b709a}},	//   _фараз_, _aylandi_, _detected_, _بىناسى_,
   {{0x0c76c1e7,0x83601434,0xbd8150ce,0xa2d8f567}},	//   _नृत्यं_, _анимации_, _hallotta, _prnews_,
   {{0x66db02e8,0x256e7013,0xa29bc078,0xcdeb3139}},	//   _اااااااا, _convenio_, _مكسات_, _turjumaa,
   {{0xd386919e,0x7fe3d083,0x0bd3b0dc,0x026c3007}},	//   _ngaro_, _شارتى_, _perjudic, _lajos_,
   {{0xfbc712bd,0xd24b913f,0x83869196,0xaddc858b}},	//   _башлана_, _בהיקף_, _igaro_, _abakwama,
   {{0x62fce146,0x185d9241,0x79b98263,0xc2be2049}},	//   _mangga_, _минерале_, _намедиҳа, _cordial_,
   {{0x32906010,0xe26dc09e,0xc3f8b129,0xc87a30f7}},	//   _cloak_, _nivou_, _veduta_, _依法给予行政处分_,
   {{0x3248042e,0xb2d832dd,0x645a812f,0xa2d9d101}},	//   _heimi_, _ummeli_, _тарихшун, _amwen_,
   {{0x28541404,0x829120ac,0x38455222,0xb8de6061}},	//   _سوويت_, _사랑합니다_, _frammanu, _لسانيات_,
   {{0x24a8e031,0xef928155,0xb6cc7264,0x02b5f500}},	//   _ተገንዝቦ_, _رومانتىك, _بيكهام_, _orucu_,
   {{0x6387461f,0x06ab838c,0xa057724f,0xb30cb368}},	//   _huerta_, _položaj_, _sanaarto, _breakas_,
   {{0x2202704f,0xe3f8e0ff,0x65171162,0x3dad12e2}},	//   _masing_, _vanuit_, _башлиди_, _patisipa,
   {{0xc0600365,0x1202711a,0xd2ffc463,0x1c7191dc}},	// [1d00] _aussöhne, _lasing_, _allanapi_, _बहिस्कार_,
   {{0xc3f473aa,0x69e4e19c,0xf2fc9048,0x0de2221d}},	//   _partai_, _solomona_, _aktivit_, _निश्चितम,
   {{0x02b5f116,0x726d841d,0xca4a8246,0xe27765ef}},	//   _कुलदेवता_, _sirok_, _aotelega_, _inzitizi_,
   {{0xc353205a,0xbad3309a,0x82e0a289,0xab1ad08b}},	//   _تۇرات_, _قۇردى_, _skinwel_, _کریستین_,
   {{0xb26e043f,0xc9e49184,0xe31c60d8,0x9f21e25b}},	//   _stromy_, _loholona_, _chabair_, _vanligar_,
   {{0xd2e021d6,0x17d4f1ca,0x020270cf,0xae722665}},	//   _abanalo_, _کھاسى۪ن_, _kasing_, _तुच्छ_,
   {{0xe8c4c08a,0xca885144,0x819d5005,0x7db531d4}},	//   _wineland, _akhohlis, _просьбай_, _aalisaga,
   {{0x6e9c32f4,0x1b13113d,0x2f9a0008,0x038ca0a0}},	//   _алдартай_, _erlangen_, _билишими, _abuyise_,
   {{0x17e1540d,0xd2d8700a,0xc201f3f7,0x9f7e50e5}},	//   _بیچارٕ_, _owner_, _egzije_, _पार्षदों_,
   {{0x25b6f51d,0xf3f4732b,0x91b0d2d1,0xe394d459}},	//   _کابرایه_, _ofsted_, _مناله_, _ikesa_,
   {{0x0ae50169,0xcc71806a,0x83662063,0x92e5e262}},	//   _kollegen_, _फिल्टर_, _бердилар_, _iminota_,
   {{0x5adb80f5,0xce541248,0x73387248,0x729201ec}},	//   _bestimmt, _ንድኻታት_, _ሰለስተን_, _lesans_,
   {{0xd8d4f0d0,0x32a784df,0x626c33c7,0x7b6404b3}},	//   _hakuging, _verby_, _bajos_, _skuldabr,
   {{0x026c300a,0x83f471e7,0x59f875a5,0x1c6290be}},	//   _major_, _testid_, _delagase, _letrare_,
   {{0xa35e948c,0xbf39b4f9,0x65639105,0xda3c2508}},	//   _trafiki_, _अपरिचित_, _מאפעס_, _духот_,
   {{0x1f6d80fb,0x43eb7160,0x32ab111a,0x04e2e14c}},	//   _संस्कृतं_, _slatke_, _gandang_, _আশবাফ_,
   {{0x027f701e,0x1343037e,0x47dd4086,0xa53874b1}},	// [1d10] _amanfo_, _lutendo_, _supplici, _politish,
   {{0x9f9e02f7,0x9386d3c2,0x77db9258,0xeffd8231}},	//   _комитети, _ngeri_, _qularnav, _प्रकरणों_,
   {{0x6394d2df,0x305370c2,0xf26ca49b,0xe6536118}},	//   _akesa_, _ahisanen, _jaboh_, _anthelmi,
   {{0x15380007,0x427ed261,0xb980614a,0x8859d0c0}},	//   _روزنامہ_, _pronti_, _akriyele, _almansor_,
   {{0x73ced3a6,0xf49de20c,0x598e1030,0x6379f222}},	//   _nieve_, _inyamanz, _харид_, _eldrasam,
   {{0xae2a2008,0x5290d193,0x929203bd,0x43ac652d}},	//   _билдирме, _glean_, _nesans_, _stupio_,
   {{0xc3eae015,0x32646203,0xa394d47b,0xae41f2ea}},	//   _kantun_, _okulya_, _ekesa_, _izraelit_,
   {{0x43eae216,0x6a0181d4,0x0290d012,0xeb66b0a4}},	//   _cantun_, _sapaatip_, _filamu_, _buturara_,
   {{0x7373a101,0x32fce1d1,0xf29090c7,0xca8fc03d}},	//   _regarde_, _langea_, _ilaah_, _lemicimb,
   {{0xe2f04285,0xd349e166,0x1c07a23c,0x93172018}},	//   _poliisi_, _diretti_, _радост_, _mancare_,
   {{0x6b878026,0x52f1e469,0xcd8c112a,0x824dc2c4}},	//   _schilder, _seriosi_, _ascolata, _येवला_,
   {{0x493f007e,0x705ca47b,0x7317145b,0x88616180}},	//   _framtide, _kwesịghị_, _puzza_, _国立教育政策研究,
   {{0x5305c4b5,0x8c4b11ad,0x22fc30b2,0x4d1d720e}},	//   _پوران_, _baiting_, _ualicas_, _партиски_,
   {{0x527f715e,0x4e544283,0x34a51392,0xd5a10105}},	//   _emango_, _adzalule_, _शोभायात्, _דאמינירט_,
   {{0x23906450,0xbfbd1307,0x02dc111b,0xa2da5005}},	//   _emoyeni_, _callipho, _vrhovni_, _parodos_,
   {{0x178b539c,0xc41205c1,0x7273a078,0x80523200}},	//   _абдуллан, _trenutak, _línte_, _phirunin,
   {{0x7236024a,0x23f45026,0x92da4002,0x766401ca}},	// [1d20] _krijt_, _zitten_, _ballbox_, _کھسٕوُن_,
   {{0x829190cb,0x7378e20f,0x729090c7,0x826c50c1}},	//   _nesaf_, _adlanan_, _alaah_, _balot_,
   {{0x13860478,0xae8ec132,0x82b9b33c,0x026c343f}},	//   _laird_, _ематикэ_, _норасмий_, _nemohl_,
   {{0x72489141,0xe185f0a2,0x0d479043,0x768c2121}},	//   _adamy_, _ababesel, _никому_, _परमाण_,
   {{0x039464e8,0xa2cae0f5,0x95abf030,0xe9daf246}},	//   _nkosi_, _findet_, _بنگلدیش_, _amalosia_,
   {{0x129044df,0xc394d1ec,0xbe67f0c8,0xf290f161}},	//   _almal_, _inosan_, _шахматы_, _ndiani_,
   {{0xac68e364,0x2ffe22a0,0xd30e10aa,0x23789351}},	//   _abuuruh_, _وتوێژه_, _arabuha_, _adhakan_,
   {{0xd26c51ab,0x27c5d3ec,0x4a73b192,0x0c21f3d0}},	//   _halos_, _aberystw, _телендәг, _жигүүр_,
   {{0xb3f4502e,0x835661e0,0xe200d16e,0xa9cf52e9}},	//   _sitten_, _impetus_, _linije_, _chomusha_,
   {{0x70f7434f,0x5ce3a121,0x51655210,0x4041b4de}},	//   _aglivatl, _प्रोफेसर, _istonpay_, _skingomz_,
   {{0x9c6812b7,0x227f02b1,0x0fbf7381,0xb99c0230}},	//   _hukunci_, _fransi_, _amondoro, _neikomme,
   {{0xd5d200de,0x540e21a0,0x32c8e368,0x39b9c381}},	//   _ئشتەدىم_, _fabrikan_, _esalaek_, _adjetiva_,
   {{0x226c5039,0x60e983d0,0xac0c1264,0xd1a452a7}},	//   _nalor_, _блүүминг, _لتزيين_, _англияли,
   {{0x02fcb3c1,0x20781180,0x2a8fc403,0x0c7cf5ee}},	//   _skrivit_, _カッコいい_, _bemicimb, _prosenn_,
   {{0x68e7e196,0x56a2e5d0,0x0394d089,0x13f8e0f3}},	//   _засвар_, _ukuthath, _sensed_, _venuta_,
   {{0x5a1b43a3,0xe451d45e,0x17b6c2c5,0x4036c2c5}},	//   _absolútn, _kredittk, _kontoinf, _kontoinn,
   {{0xf3f8e0d3,0x52258118,0xbe63a292,0x263920f8}},	// [1d30] _tenuta_, _barko_, _موجودلیگ, _лауреатл,
   {{0x3942b0cc,0x627ef1df,0xe6831291,0xaa65d1a5}},	//   _ঘোষনা_, _atingi_, _aksesori, _муодили_,
   {{0x627ed280,0xa509e13c,0xd652f35e,0x5f230272}},	//   _atondi_, _ambotavy, _akakandi, _deplorar_,
   {{0xf164608f,0x627f4256,0xb290216f,0xca92f087}},	//   _ehangach_, _amenyo_, _lokaj_, _adminsys,
   {{0x92258054,0x560a015d,0xd9e2246c,0x9532d009}},	//   _farko_, _معلمان_, _utforska_, _многочис,
   {{0x2a6c342e,0x0533e00e,0x42a63038,0x98474111}},	//   _heimilis, _qabiliyy, _limbah_, _esplorad,
   {{0x52904138,0xb2471155,0x441ab182,0xa017c0db}},	//   _komad_, _ﺋﻮﭼﯘﻕ_, _amanasik, _ихата_,
   {{0x2c05d42f,0xd290e195,0xd03eb140,0x1afde210}},	//   _userway_, _binamu_, _ekaterin, _impermis,
   {{0x027e7248,0x974253d7,0xc5a84181,0xc23a409a}},	//   _መተሓሳሰቢ_, _त्रिनिदा, _amashyak, _билимсиз,
   {{0x8387f064,0x73443053,0x6d2f70be,0x97e3d0f9}},	//   _leurs_, _rezepte_, _biznesit_, _tilbúgvi,
   {{0xf2cb03dd,0xa38601fd,0x4fcc5198,0x268162ce}},	//   _vladar_, _daire_, _apontado, _baleseri,
   {{0x83f472c7,0x2386b31e,0x1378e445,0x0290f0d7}},	//   _dostal_, _amerig_, _gelaran_, _algan_,
   {{0xc386014b,0x7c74a0f7,0xfc76d06a,0x02fe61aa}},	//   _faire_, _查看评论信息_, _मित्रा_, _dibasari_,
   {{0x646f814c,0xbe07903d,0xb3eae32b,0xceb8d58f}},	//   _কন্ডিশনা, _ریپورت_, _britho_, _džungļie,
   {{0x09cc11df,0xc51910ef,0x398f6221,0x620f6221}},	//   _konektit, _روحانيت_, _abahamba_, _abahambi_,
   {{0x2317809b,0x226c70e4,0x72c4b47f,0x2914a031}},	//   _kurze_, _lanos_, _tiempos_, _ማሳደጊያ_,
   {{0x6486d013,0x3b196304,0x1a851041,0x414c9030}},	// [1d40] _иманы_, _letakkan_, _شویده_, _آنلاماغا_,
   {{0xe2904207,0xb394918b,0x1224b0ec,0x4f71d287}},	//   _olmak_, _akash_, _vdekje_, _sutartis_,
   {{0xe3ac6434,0x62f202e5,0x1394e184,0xef26b0f5}},	//   _gruppo_, _nasleduj, _anisan_, _berliner_,
   {{0x2eeaa311,0x1b78e477,0xec06346e,0xe3ce61c0}},	//   _залларын, _berusaha_, _tsistau_, _piove_,
   {{0xc373a2b5,0x02489057,0x32b69251,0x00a35275}},	//   _strayed_, _neamt_, _планирањ, _سەلبىي_,
   {{0x02f76408,0xf3963064,0x9b5a23d0,0xbdbe31c5}},	//   _menikah_, _passé_, _томиллоо_, _fitifana,
   {{0x326c7284,0xb35fa4e9,0xb25a02d7,0xd32e1105}},	//   _manos_, _incesay_, _amile_, _נבוכדנצר_,
   {{0xe200c13c,0x5c0a42a9,0x73786262,0x57d9133c}},	//   _bolita_, _einsatz_, _rugamba_, _صورتده_,
   {{0x07da42e3,0x9394947b,0xc2917076,0x6526212f}},	//   _प्रकल्प_, _nkasi_, _awaawa_, _ﻧﻪﺷﯩﺮ_,
   {{0xd171e26c,0x3c60e473,0x52fc422b,0xe66e9101}},	//   _aktivnih_, _flyttar_, _kuching_, _konvansy,
   {{0x422a31d9,0x126c113d,0xbbba10bf,0xa0649219}},	//   _солай_, _ochoa_, _газетани, _extansyo,
   {{0x28fd80f6,0x5038e0b7,0x929041e9,0x4932016d}},	//   _babatynd, _centraln, _fomam_, _vermesse,
   {{0xfbb220e5,0x73f16283,0x136cf0ce,0x126c7082}},	//   _केन्द्रो, _aholelek, _reggeli_, _kanos_,
   {{0x675a9293,0xee95b03c,0x2789a0b5,0xacbad06a}},	//   _igenamig, _rustique_, _ءىلياس_, _परीक्षां,
   {{0x0387f18d,0xb22582c0,0xc3eae16f,0xe3b93227}},	//   _seurt_, _barke_, _britio_, _대전지방검찰청_,
   {{0xb2903666,0x35fa7064,0xfa36214e,0xe680f22d}},	//   _ammann_, _劳动和社会保障部_, _দ্বিমত_, _gerechti,
   {{0xda898367,0x4905f3da,0x9378e376,0x77b67270}},	// [1d50] _ministrs, _impactfu, _halayen_, _dipering,
   {{0xa6dc53ca,0xacf9720b,0x3f1cb0c9,0xcc64f387}},	//   _सुनिल_, _अभिमानी_, _процесів_, _adetutu_,
   {{0x6290420f,0xefc4510e,0xa119220e,0xf21833c2}},	//   _almaq_, _मालिकों_, _границат, _abakutam,
   {{0xa205c2f4,0xf26cc17e,0x82904019,0x4346a369}},	//   _олимпод_, _abdoo_, _homaj_, _studiat_,
   {{0x025a034e,0xedf7d3df,0x9394603e,0x8b85441a}},	//   _umile_, _назвали_, _akoso_, _grundfor,
   {{0xcfabe12a,0xc37a2421,0xa2903395,0xa3793233}},	//   _commotio, _abaaboo_, _gemani_, _ambanin_,
   {{0x92d6a3ec,0xb281e1a5,0x6c184051,0xe34163c6}},	//   _benodol_, _meshack_, _surpass_, _hatepea_,
   {{0xd3cf4152,0x0a4204b5,0xdd9fa07b,0xc200c196}},	//   _olevan_, _ہێکیا_, _afooshaa, _polita_,
   {{0x27fea064,0xddbc406a,0x304582fc,0xb27ed13d}},	//   _的所有作品_, _संस्थांन, _pokriven, _alonzo_,
   {{0xb0716667,0xc85f824f,0x683a4264,0x8b7bf019}},	//   _redaksjo, _ikinneru, _لفضيلة_, _originan_,
   {{0x71fa327c,0x9a5b610b,0xd143f30d,0x2def2171}},	//   _詳細はこちら_, _agafumba_, _pedestal, _ايمبولين,
   {{0x6ed010ac,0xe26d8335,0xcdd3924a,0xd4bb9031}},	//   _없으신가요_, _biros_, _bakkefea, _መበራከት_,
   {{0xeb30c057,0xea6c930c,0xf26c7039,0x1a6322c4}},	//   _невой_, _dogmatis, _janor_, _performa_,
   {{0x923175ce,0x2aa9a26e,0xba7e4098,0xb53704c9}},	//   _thumela_, _запланав, _kuganira_, _дубровни,
   {{0xc3cff3e3,0x6fb8454e,0xc378e038,0xf291262f}},	//   _nouvo_, _eclectic_, _delapan_, _locais_,
   {{0xf290941b,0x12da5164,0xf9941502,0x2fe831ca}},	//   _slaan_, _asanble_, _декабрьд, _یتیٖم_,
   {{0x7224b2fb,0xe05371ba,0xd26930f4,0x23833012}},	// [1d60] _afekte_, _consulen, _ئىلھاملا, _kinyume_,
   {{0x03ead1c5,0x22e200af,0xd29032dd,0xe386920d}},	//   _wolter_, _igennem_, _lemali_, _ugari_,
   {{0xc3946401,0x726da040,0x63f8e15f,0x4259f1b9}},	//   _phost_, _lipos_, _nanuit_, _тренерҙа,
   {{0xd38662d9,0xdc0be15c,0xb2d46668,0xe27f4250}},	//   _agoru_, _zampano_, _fordel_, _atenai_,
   {{0x6f7dd0e5,0xd84a31bf,0x53735008,0x03410104}},	//   _संस्करणः_, _актуалэ_, _sungaty_, _derecha_,
   {{0xf23691b0,0x31c371de,0x73417340,0x529043c9}},	//   _kraja_, _nastavak_, _parerea_, _romam_,
   {{0x629040fb,0xfe96201a,0xb2cae405,0x0a7c91dd}},	//   _somam_, _تىلىڭ_, _maidin_, _batabata_,
   {{0x73ce91ce,0xb5e9b0ae,0x0e62522c,0xd366d669}},	//   _piave_, _masallı_, _anscombe_, _आरआईएल_,
   {{0x0b11a31d,0x823171b2,0x42e771ca,0x433d3388}},	//   _nurserie, _shumela_, _marnaba_, _ڕیزان_,
   {{0x561ee283,0x130cb134,0xfea55113,0x896b543d}},	//   _njengesi, _assakat_, _projektē, _sanninge,
   {{0x878c70e0,0x22da6100,0xd26d804b,0x2010e182}},	//   _भाषार्थः_, _pareho_, _biror_, _anantāya_,
   {{0x19953285,0x4395839a,0xc26d8159,0x725680f7}},	//   _abakrist, _kursy_, _piros_, _胶南市国土局_,
   {{0x564801a1,0xcc4634f5,0x526ce0a1,0x2264646c}},	//   _againstw, _جریمه_, _mafoi_, _skulda_,
   {{0x62bf0007,0xda770084,0x53f90186,0x5a074439}},	//   _اموات_, _adegbola_, _kabuye_, _temannya_,
   {{0xa7cd8082,0x53f8c038,0xae185248,0x9200b292}},	//   _avisitom_, _solusi_, _ተጠንቀቑ_, _oldiga_,
   {{0xc3f8b36f,0x1202509c,0xc912e102,0x63cf542f}},	//   _madume_, _dative_, _етапі_, _otevay_,
   {{0x1307624e,0x6f5190ac,0x6d8ac009,0x32d91085}},	// [1d70] _tembang_, _유념하시기_, _ввести_, _receta_,
   {{0xc26d8063,0x42fcc14d,0x53e0325d,0xda8a4033}},	//   _biroq_, _blogid_, _asirazui_, _dividenn_,
   {{0x958a30ac,0xb3954188,0xb9e3c036,0x52267007}},	//   _아르바이트_, _liesen_, _колата_, _farkas_,
   {{0x097340d7,0xcad2702e,0x395ee1ad,0x115ce15e}},	//   _arxitekt, _jälleen_, _inundate, _хужаа_,
   {{0x851010b5,0xfd79804b,0xf2cb0564,0x55ee61c5}},	//   _ресми_, _сайловла, _blader_, _benefidö,
   {{0x88080286,0xe518723c,0xfc60b13f,0xc1845449}},	//   _dabqhuas_, _картинка, _charged_, _achachil,
   {{0x729021e9,0x91afa0f7,0x920ec2f3,0x39cd20ce}},	//   _dokan_, _请您发表感言_, _важан_, _rendelhe,
   {{0x2f63d008,0x4dbe14b2,0x6394e176,0x5e7c1669}},	//   _mukaddes_, _hdvietna, _ponsel_, _मौर्य_,
   {{0x53f4707b,0xb291b1e5,0x0df9b16b,0xc42133b4}},	//   _aartii_, _nurberdi_, _akriliċi_, _dikamego_,
   {{0x33954053,0xcc045344,0x0af82221,0xe920605a}},	//   _diesen_, _amosozi_, _bavumele, _тендерге_,
   {{0xe2ca70e7,0xa290d266,0x60472009,0x2da4966a}},	//   _mbiluni_, _aleai_, _народов_, _ribosoma,
   {{0xf26da31f,0x69be24e4,0x73ced0c8,0xeda5310f}},	//   _tipos_, _afidavit, _dievo_, _kisgépek_,
   {{0x426ca1d8,0x4a5980c8,0x13449175,0x19873358}},	//   _sabot_, _nereikia_, _detekte_, _kaikesta_,
   {{0x3386919e,0x43f470ea,0xbdc800fb,0x425b745b}},	//   _ngaru_, _kostel_, _अध्यायः_, _scalda_,
   {{0x22fce2e9,0xc26c8613,0x9e41e16b,0x526da039}},	//   _bangna_, _schons_, _garantit_, _kipor_,
   {{0x7c67c041,0x22d94203,0xe200c05e,0xc0620131}},	//   _عربان_, _abeere_, _folipa_, _कोळसा_,
   {{0x624b8003,0xb26d84d2,0x8fae1251,0x6faff0ac}},	// [1d80] _ट्रेवल_, _birop_, _новогоди, _도서관에서_,
   {{0x8334b0dc,0x92369234,0xa089d1d9,0xfe5630d7}},	//   _دراماتۇر, _traja_, _принтерд, _урысча_,
   {{0x7290419e,0x3a5d912f,0x19aad251,0xe3dda24b}},	//   _homai_, _жайларға_, _водич_, _способст,
   {{0x2052366b,0xa290401f,0xa073212f,0xd2e8409c}},	//   _iphrovin, _komai_, _ھۇررا_, _addigna_,
   {{0xba6bf14f,0x198b84ad,0xc290238d,0x4e1991a2}},	//   _प्रश्नः_, _baakanya_, _yokan_, _снимать_,
   {{0x5a1670a1,0x137921d8,0x326ca079,0x8f5820f8}},	//   _kakawaka_, _lebaran_, _dabor_, _lukaşenk,
   {{0x4f524141,0x8387f47b,0x52934109,0xad0b11ad}},	//   _алышмагы_, _ifuru_, _aksjane_, _spillage_,
   {{0xa386d45b,0x63869267,0x68d150ef,0x92480322}},	//   _storia_, _agaru_, _مشابهت_, _agime_,
   {{0x147a72b8,0xce379477,0x5c75906a,0x6c35d48f}},	//   _ongelukk, _kejahata, _मास्तर_, _планови_,
   {{0x229120ba,0x625ad2bb,0xe68b80a8,0x4386c192}},	//   _locals_, _mmele_, _kancelář_, _ашырыла_,
   {{0x8203e13c,0x03ead3e1,0x3f8fe338,0xecb9c275}},	//   _чеботаре, _koltar_, _psihološ, _пәхәс_,
   {{0x1d9db13a,0x5386005d,0xd26cc049,0x91d02008}},	//   _analkaha, _saira_, _lados_, _айрыла_,
   {{0x23ead218,0x2248d0ff,0xa3f8c2c6,0x9fc3d358}},	//   _moltar_, _neemt_, _palude_, _подарки_,
   {{0xa5f3911b,0xa4a260fb,0x629024ad,0x3d91f521}},	//   _болести_, _परिणामयत, _bokao_, _realisea,
   {{0x92d470c0,0x425ac010,0x21fd5252,0x0290208c}},	//   _atudat_, _willed_, _ардактуу_, _ookal_,
   {{0xa9c720d2,0x0379e12e,0x0b431262,0x39e6015f}},	//   _каралат_, _telewizj, _amacakub, _uyaraktu,
   {{0xf2e5e1da,0x8dd5205b,0x5fec6234,0xc94bb113}},	// [1d90] _iminuta_, _abakwiba, _dobrovoľ, _oldomete,
   {{0xdd6e639c,0xab17e03b,0x783fd180,0xc7ee53a4}},	//   _гирамдин_, _angatits, _プンしました_, _tarquini,
   {{0x129043e3,0x694fe1d6,0x3a2a00af,0x5ffbf45f}},	//   _moman_, _emalunge, _イタリアン_, _विभागले_,
   {{0xcc9ac011,0x62902159,0x121c70a1,0x23dd0039}},	//   _аверсиа_, _sokan_, _tashia_, _khawai_,
   {{0xe292635e,0x83020278,0xc2910322,0x0ddec192}},	//   _matatu_, _talaatu_, _awaash_, _башланыҡ_,
   {{0x52fd7165,0x129090bd,0x45f2000a,0xa26db1ba}},	//   _fragen_, _plaas_, _permissi, _lavori_,
   {{0x1200b086,0xb25910a4,0xb27e6319,0x9ba7c06a}},	//   _godiva_, _amonaiti_, _vzone_, _yoshihir,
   {{0xe38740cc,0x12d72291,0x075fa0fb,0x9ea3954b}},	//   _puerta_, _اکثرا_, _विद्यां_, _cuidados_,
   {{0x0a8ce17a,0xf29043e1,0x5ef43474,0xc26cc004}},	//   _ক্ষেত্ৰ_, _koman_, _archivos_, _kados_,
   {{0x89cab20c,0x1055c339,0xf6c410af,0x0c595322}},	//   _bitorera_, _sagatavo, _おすすめ度_, _amotlih_,
   {{0x526cc004,0xe26d833e,0xb445b12f,0x9c6a114f}},	//   _dados_, _paroi_, _ۋايىغا_, _कृष्णो_,
   {{0x284b00af,0x32fce169,0xd2e67293,0x2386d367}},	//   _sommerhu, _dengem_, _amanota_, _skoraj_,
   {{0x42cad0c9,0x03ced086,0x1c047069,0xce41f20d}},	//   _bildet_, _gieve_, _imisozi_, _zalantza,
   {{0xa0531009,0xa45fc013,0x357b3292,0x22904176}},	//   _хотите_, _адлеиба_, _азият_, _noman_,
   {{0xd2814407,0x460fe4e3,0x294fe3a5,0xff39e0a8}},	//   _turkske_, _amalungi, _amalunge, _televizn,
   {{0x829260fe,0x3a7f72d4,0xc2904469,0x16d4c1ab}},	//   _gatatu_, _apurimaq_, _homan_, _sasabihi,
   {{0x824990fa,0xe290d405,0xb2129011,0x026c1369}},	// [1da0] _pesma_, _plean_, _ndaha_, _schol_,
   {{0x82e303f7,0xc22510c7,0x314d21b3,0x774910f8}},	//   _delivre_, _saakay_, _gentilho, _партнерл,
   {{0xa9fd623f,0xf1fc220d,0x218d114d,0xdc2a4248}},	//   _abbasant, _тасалбар_, _detailpl, _ዓይነትን_,
   {{0xd20141a5,0x705255b0,0x69d85071,0x1a0a21a8}},	//   _nifike_, _pokrajin, _besteand, _вандроўк,
   {{0x8eb9c1b3,0xf131d1bc,0x5dcb2180,0x5e512445}},	//   _disordin, _التۉگۉل_, _allerød_, _sivakuma,
   {{0x32fd72d2,0xb290418e,0x8a803033,0x9e57b146}},	//   _tragen_, _goman_, _atansion_, _leachate_,
   {{0x435fe1a1,0xc3ac63ab,0x026e73a2,0x13ced35e}},	//   _angeray_, _koupit_, _parovi_, _sylver_,
   {{0x2b95700e,0x80f40382,0xf964403b,0xd2e3136d}},	//   _sevindir, _pomislil, _akungant, _proinde_,
   {{0x1cee3094,0xcc4ec404,0x405bd0ea,0xca7c30c2}},	//   _америк_, _آمدني_, _अनुमानित_, _ahlamisa_,
   {{0x9387f37c,0x459e8105,0x203d2264,0xf1fe71ac}},	//   _ngura_, _סודילקאו, _وجلست_, _sipagasy_,
   {{0xe290307b,0x8f2710c8,0xe212927d,0x83f8c2d6}},	//   _ammaan_, _paprasta, _adaha_, _palube_,
   {{0xbdb1850e,0x298a80ae,0x0c29b1a7,0xff4943c9}},	//   _intambwe_, _müraciət_, _monstros, _propheta,
   {{0xb34020b7,0xd68b215e,0xb3fe7514,0xfe31d013}},	//   _licenca_, _lizentzi, _kwaziwa_, _академиа_,
   {{0xee351474,0xee92e0d7,0x62de8140,0x425a024f}},	//   _millones_, _protsent_, _morozov_, _imilu_,
   {{0x339460c6,0xb292701f,0xd29022c1,0x07d77061}},	//   _akosi_, _karatu_, _tokat_, _کاڌائون_,
   {{0x9a8fc2a1,0x83eab1bf,0x93ced03c,0xf2cfd10b}},	//   _demikian_, _pietre_, _pieve_, _ashonje_,
   {{0x3249962f,0xf0cae063,0xaeafa519,0x99e93016}},	// [1db0] _mesmo_, _اعلامیه_, _samtykke_, _mainidea_,
   {{0xef1641bc,0x89f2c072,0x09d8a031,0x03874161}},	//   _بئنتسىلى, _могућа_, _ያለብንን_, _arerwa_,
   {{0xf2fce0a1,0x73946266,0x7c2c5457,0xcfbab0a0}},	//   _kangba_, _ekosi_, _embarcac, _abengowo,
   {{0x321dd176,0xd318a1bc,0x0290418e,0x63f91132}},	//   _تجاري_, _رومانتك_, _nomal_, _joburi_,
   {{0x926e732d,0x4b02b14a,0xeda4c252,0xf6a76041}},	//   _karoti_, _afarfrie, _буйругу_, _abathuny,
   {{0x4a8810d6,0x4d8c6233,0x0316a080,0x616f71e5}},	//   _основном_, _kolontsa, _taizé_, _айтсанам_,
   {{0x3092d1dc,0x3978715c,0xfedb54cb,0x963c42d5}},	//   _समुदायको_, _polizist, _enviados_, _alaisdai,
   {{0xa25a9664,0x826de005,0xa82cf009,0xabb6317f}},	//   _imalo_, _kitos_, _получени, _имлоӣ_,
   {{0x926c831c,0x225a9363,0x5c1b8063,0xbf236050}},	//   _uskoro_, _amalo_, _tumanlar, _一八九五年以前大,
   {{0xc236d40a,0xf048105b,0x129092b8,0xa2ba7032}},	//   _freja_, _موجوديت_, _slaap_, _punduli_,
   {{0x41d72036,0xa3dfe124,0xf24a621f,0x9349d18a}},	//   _цитирай_, _ацаҳуеиж, _ibumin_, _pitesti_,
   {{0xd3ca212f,0xa290f343,0x8b25a2c3,0x7ae5a44c}},	//   _ﺗﯘﺭﯨﺪﯨﻐﺎ, _fogaa_, _сулары_, _суларч_,
   {{0x79ade176,0x6ba72019,0xef48313d,0x022d60d1}},	//   _تجربی_, _venkinto_, _passable_, _dlivetel,
   {{0x22916004,0xe3ea307e,0x4341019a,0x33ced142}},	//   _negari_, _samtal_, _offeryn_, _dnevi_,
   {{0xbf6ae3cf,0xdb990441,0x1e9ec0b8,0x82fce4b1}},	//   _likbrenn, _заплатит, _фазли_, _tangba_,
   {{0x16e8b11b,0x15395225,0xa29024e7,0x83a33225}},	//   _карактер, _estadual_, _rokas_, _amapá_,
   {{0x43eb7075,0xdbcd4252,0x011090ee,0x03877428}},	// [1dc0] _kratko_, _кармалды_, _techniky_, _starfa_,
   {{0x1ae313a7,0xc25ac19a,0x75eda113,0xbf473437}},	//   _anatembe, _dillad_, _personām_, _nærmast_,
   {{0x0da2b110,0x73f473f4,0xb2902054,0xd34fa09f}},	//   _terraced_, _costal_, _dokar_, _alafang_,
   {{0x39abc1a8,0xc904e281,0x128c70c5,0x7b6dd66c}},	//   _складае_, _xabashid, _amakera_, _मेघना_,
   {{0xcb87e0df,0xfda011e6,0xe56fa1a0,0x194db0f3}},	//   _equiredr, _anantara, _benovipö, _permalie,
   {{0x275fa13e,0x4df722ac,0x243091a9,0x4fbe837f}},	//   _विख्यात_, _بدرخان_, _ئىسرائىل_, _alongoso,
   {{0x08e16050,0x417723bf,0xab892022,0x229462c1}},	//   _交通十分便利_, _теста_, _процесте, _etiketi_,
   {{0xd1fe427a,0x72486062,0xb2cf43d9,0xf276e26e}},	//   _publikác, _afoma_, _bommenej, _moterišk,
   {{0x026de123,0x6f397197,0x09c6b198,0x023f70ce}},	//   _ditor_, _terutama, _paulista_, _kalkulát,
   {{0x7733b059,0xc38692c0,0xd65b71a5,0xf08b0388}},	//   _አስነብበኝ_, _jaare_, _abakhali, _گرفتانه_,
   {{0x8386924a,0x729041df,0xa29020c6,0xf3c381f5}},	//   _waard_, _nomas_, _ankae_, _dávid_,
   {{0x4c916408,0x6202f283,0xe79381ac,0x6153e0e9}},	//   _didukung_, _abakavum, _eritreri, _морель_,
   {{0xa38602e8,0x2ef5d2a7,0x54bb0370,0x5eb810f0}},	//   _taire_, _ائکونومی, _истаравш, _lorraine_,
   {{0x2f0ce66d,0x2e3d6083,0x5e72106a,0xcccc30c7}},	//   _འགྲུལ_, _بازارلىق_, _वृद्ध_, _بیانن_,
   {{0x625a922c,0x1642f27c,0xacb7b2f3,0x026de2c6}},	//   _umalo_, _最近の記事一覧_, _границу_, _sitos_,
   {{0x4da6b3a5,0x42d960b0,0xb02d60bf,0xa38690f5}},	//   _kubonaka, _segera_, _хотирала, _haare_,
   {{0xd9f7a35b,0x53082387,0x827840a2,0x1759a0f4}},	// [1dd0] _органу_, _daabobo_, _awasenal, _ﭼﺎﻗﭽﺎﻕ_,
   {{0x2fc2c10f,0x4394d394,0xc2d96369,0x5a1460c5}},	//   _لاشوں_, _diosan_, _algeti_, _bakakima_,
   {{0x0316d12e,0x627e0256,0x6c4990c9,0xfdab5222}},	//   _ludzi_, _izina_, _ремонту_, _kanninga,
   {{0x2e96304b,0xf58424d9,0x89c41404,0x5e2490c9}},	//   _chempion, _infurmaz, _انتقامي_, _abelshus_,
   {{0xfaf7c15e,0x462b50f9,0x1dab51f2,0x22d8b369}},	//   _балдан_, _manningi, _manninga, _besonat_,
   {{0x93ced5bd,0x1843966e,0xaa071439,0xbd14c0df}},	//   _dieva_, _contamos_, _dekatnya_, _iteratur,
   {{0x728700c3,0xc9b01065,0x227f00fb,0x626da0ce}},	//   _blokove_, _המסעדות_, _dhanur_, _napot_,
   {{0x6f86b048,0xd2904113,0x37b641d8,0x826d1347}},	//   _टर्की_, _domas_, _sarupani, _lazos_,
   {{0x63860315,0x05a9c16e,0xfa160127,0xc237d293}},	//   _paire_, _великог_, _bikabika_, _akomeza_,
   {{0xdc6a0343,0xf859f034,0x3d0e6252,0xe37c80b9}},	//   _samuelu_, _среднове, _кодексти, _докатмас,
   {{0x315da0d2,0x22fc921f,0x0f4c01e0,0xe29042e2}},	//   _actuacio, _apago_, _existima, _almay_,
   {{0xd962323c,0xeab7b074,0x4387f421,0x525ac41a}},	//   _постове_, _dashuris, _afuri_, _tillid_,
   {{0x4edf71c3,0x73cef120,0x8da1a24f,0xa829f009}},	//   _lochlann, _chives_, _minnerpa, _сервере_,
   {{0xb259966f,0x3290d095,0x1200e1df,0x73874179}},	//   _वाशिंगटन_, _pleas_, _donita_, _sterka_,
   {{0x8ad30426,0xba8071a7,0x6690009b,0x356790d7}},	//   _erstatte, _atention_, _nesekidi, _ликаның_,
   {{0x92d88510,0xac61b18e,0x2930e12c,0xe3f47073}},	//   _makeke_, _charite_, _chumbute, _kostol_,
   {{0xf2e5d395,0xd3ce0429,0x22e38419,0x72da715c}},	// [1de0] _akontaa_, _chive_, _refiere_, _zereck_,
   {{0x32fc9238,0x4200b01f,0xcaf523e1,0x326da1ce}},	//   _spagn_, _godiya_, _enternas, _kapot_,
   {{0xfae30003,0xa202026d,0x8da1e278,0xcc520291}},	//   _postimee, _bapise_, _faitatau_, _ajatana_,
   {{0xd8c96050,0x43fa7100,0x0488c295,0xb2904287}},	//   _ケンシロウ_, _kasuko_, _adaganiz, _romas_,
   {{0xfc84a13f,0x2594d262,0x9bffb258,0xe0e5d1f7}},	//   _attended_, _nderabuz, _kinguaar, _туполев_,
   {{0xa38621e6,0x79e6f043,0x1f26f043,0x6bb7b01c}},	//   _cakre_, _harrastu, _harrasta, _میانمر_,
   {{0x03eae3a4,0xa25a9437,0x4a4721bf,0x7b9712ac}},	//   _fonter_, _smale_, _индикаць_, _داخرانی_,
   {{0xd2fce3f4,0xb6dc7290,0x718870f4,0x87d7e4b5}},	//   _sangha_, _पोलित_, _گۈزىلى_, _baraarug,
   {{0xac76b2e9,0xcdfc5086,0x326e53c1,0xf7e0707e}},	//   _antumir_, _pchelpwa, _motorn_, _tidskrif,
   {{0x229022df,0x9aaee4c4,0x52fe6389,0xc7f7c063}},	//   _dokai_, _forvente, _cibiyar_, _линклар_,
   {{0xc26da01c,0xdeb6c0be,0x80d5608e,0xfc00b2b5}},	//   _kapom_, _njerezit_, _simsangj_, _dissect_,
   {{0xaa0ff064,0x3223c15d,0x2c6e113c,0xa2e9f199}},	//   _没收违法所得_, _مدارک_, _mbaraka_, _monitro_,
   {{0xc24990fa,0x36b1d670,0xc2904339,0xc2d8316d}},	//   _pesme_, _भक्ती_, _somas_, _nujee_,
   {{0xb3f995b2,0x9ebfc1af,0x9c623174,0x7ef26085}},	//   _בקרוב_, _motuhake_, _sadrže_, _পিরোজপুর_,
   {{0xe200c030,0xadda7252,0x93dcd3ea,0xde58c251}},	//   _moliya_, _кореянын_, _atamaliz, _обиде_,
   {{0x838740d7,0x93eb4052,0xb0008182,0xd83f1418}},	//   _andrey_, _lietot_, _adhobhāg, _abamajud,
   {{0x3d3b1328,0xc2904566,0x8641e197,0xf1753328}},	// [1df0] _angayuqq, _tomar_, _perkahwi, _kalaligl,
   {{0x038602e1,0x9706b0a8,0xf51f10fb,0x691210aa}},	//   _naira_, _kulturní, _ananyabh, _bahasuku,
   {{0xe96a24d4,0x0218c225,0x53ac50d9,0xa202023c}},	//   _diinstit, _облак_, _poupee_, _capire_,
   {{0x1757602b,0x6200b288,0xe2ef906d,0xc2486144}},	//   _مارتورٕ_, _oldida_, _othisha_, _agome_,
   {{0x5d7230cc,0xf27f4291,0x9edb75dc,0x0a50d1f1}},	//   _ভিত্তিতে_, _mlengo_, _antiguos_, _femenina_,
   {{0x02eee1ac,0x32d5b15f,0xea72130e,0x32e9f199}},	//   _fiffi_, _rurlugu_, _pračka_, _fonitro_,
   {{0x8143f109,0x8354b392,0x3545c004,0xffa80133}},	//   _greenwal, _merebut_, _مبتدی_, _ovladače_,
   {{0x7e72a0ea,0x52da741b,0x83866351,0x1fd1a007}},	//   _सुस्त_, _bereik_, _saora_, _زمیندار_,
   {{0x067b61e0,0xa2ea5335,0xdf16335b,0xc9ea52d5}},	//   _dicendum_, _inviern_, _партій_, _bearghad,
   {{0xaf01214c,0x5978e152,0xd8778183,0x80dc8437}},	//   _কয়জন_, _periaatt, _preciser_, _akkadisk_,
   {{0x739fc11c,0xa1c53231,0xf3a90036,0x33419257}},	//   _إصدار_, _sklepach_, _trovare_, _yunesko_,
   {{0x7038302e,0xe7c7e1fc,0xde4e1263,0xad5cc276}},	//   _tietokon, _aburusim_, _дарди_, _مجسمي_,
   {{0x5d17f275,0xf202723a,0x6382c360,0x13877095}},	//   _бардуқ_, _pariat_, _مارلن_, _bearin_,
   {{0xf3966465,0xc2d881af,0xb9ffc213,0x334312fc}},	//   _versio_, _pakeke_, _armasimt, _мотора_,
   {{0xac868064,0x16596180,0xf2a190bf,0xbdb40020}},	//   _中签号公布_, _総コメント数_, _вертолёт, _ormingfa,
   {{0xc1c4713f,0x040960e8,0x9ab21031,0x1290602a}},	//   _האנציקלו, _politycz, _ተገንዝበው_, _hooar_,
   {{0x5fe51257,0x6c759400,0x854f2338,0x6255b41e}},	// [1e00] _dostları, _महत्ता_, _slavonsk, _मेहेनत_,
   {{0xb25a91de,0x5eab6036,0x3935213d,0x7b6b61ba}},	//   _imala_, _conoscen, _palmeira_, _conoscer,
   {{0x226c10f5,0xa2fd7315,0xcdd000ef,0x813ee2df}},	//   _schon_, _aragon_, _ازانسواء, _gusunivo,
   {{0xd318d304,0x974d742e,0x9266a174,0x51b9e0f7}},	//   _gemilang_, _sennileg, _osnovali_, _高考复习古典诗歌,
   {{0x6edc3248,0x2290919f,0x4e18535e,0xaa8d7089}},	//   _ብምምሕዳር_, _alaas_, _aingokwa, _penniles,
   {{0x424972cb,0x42903042,0x527f03e6,0x59f4924f}},	//   _kwamba_, _semali_, _erangi_, _danskisu,
   {{0x6ad331d9,0xc226618d,0x22c582b5,0xa3ce6096}},	//   _تۇردە_, _turkia_, _deflate_, _ahova_,
   {{0xb200f637,0x2621310e,0xce29e13c,0xf3f472b8}},	//   _meniny_, _logowani, _кондаков_, _rustig_,
   {{0xb59bd038,0xcb732261,0xe89d9296,0x4516e443}},	//   _dibutuhk, _anguilla_, _abakwaju, _ahasávo_,
   {{0xe0393171,0x0c5a91f8,0x5c72d00d,0xbf15d03d}},	//   _زيارت_, _vratili_, _bayruut_, _انقلابون,
   {{0x52499671,0x52d81193,0xbdd1f1a5,0xbc5a72a5}},	//   _mesma_, _athem_, _abakumga, _alawọ_,
   {{0xeacb700f,0x57e5a08c,0x92eb12ab,0x326c1203}},	//   _sommeren_, _bespreki, _turizmo_, _schoo_,
   {{0xb29090bd,0x3e8d209a,0x9fd4d1d0,0xd0454293}},	//   _klaar_, _марши_, _iconpilo, _marushan,
   {{0xbec7f22d,0xdcf1723a,0x8ee4f03b,0x8ff79065}},	//   _beginnen, _mantomer, _alukamen, _מעסיק_,
   {{0xe27f4033,0xf57ac030,0x72ca05bd,0x277e4075}},	//   _prensi_, _ضرورتی_, _veida_, _ekološka_,
   {{0xc158304b,0x748421ca,0x9bf6817b,0x52904246}},	//   _агентлик, _ٲویُل_, _сайттың_, _fomai_,
   {{0x4f33b020,0x826dc288,0x2c1ea1a7,0x963382f4}},	// [1e10] _eneralga, _davom_, _adeptes_, _онлайнаа,
   {{0x8d0210ac,0x3a7dc05d,0xf6b1759b,0x9db9624f}},	//   _알고싶어요_, _finamira_, _झाडापखाल, _nalilerp,
   {{0x12fca030,0xae6932ca,0x43eb42d2,0x635673d9}},	//   _harakati_, _تياتر_, _bietet_, _alafiwa_,
   {{0xc568555b,0xec51819e,0xff25e291,0xa63cd006}},	//   _europäis, _taitama_, _legrotta, _achipani,
   {{0x437982a3,0x8bc8040d,0x82c7721a,0x148370c2}},	//   _mananeo_, _یوسفہٕ_, _засталас, _пландары_,
   {{0xe9e60044,0xf2efa224,0x038750f1,0x6847c1e2}},	//   _horomona_, _sedirwa_, _caeres_, _қадами_,
   {{0xbda8e077,0xa0ce3278,0x7394f1d4,0xf26c31ba}},	//   _abuibuta, _efilifil, _atisat_, _pazienti_,
   {{0x127ef1e7,0xc2cae09b,0x27daf1f2,0xa7be7030}},	//   _prindi_, _hindut_, _trupulei, _jarrohli,
   {{0xcac792f4,0xff0470b3,0xc136a41e,0xacf6a30b}},	//   _талаарх_, _күрде_, _studenty_, _studentu_,
   {{0xf249f460,0xeeba80fb,0xa12f01ba,0xc2cb01d0}},	//   _heumo_, _प्रधानं_, _velocità_, _quadam_,
   {{0x3ee7d13c,0x360fc020,0xc37fe06e,0x99d0c39c}},	//   _армавир_, _elementw, _kroasia_, _гегил_,
   {{0x899d310d,0xf86d22e8,0x5394e18b,0xac7fb022}},	//   _малых_, _scriosad, _konsil_, _холдингі_,
   {{0x626dc04b,0xb3909025,0xe38692a8,0x9805e009}},	//   _savol_, _abayomi_, _paara_, _уважение,
   {{0x9290b00a,0x6b0745b8,0xba0745b8,0xed9f01b7}},	//   _local_, _priprave, _pripravu, _istorica,
   {{0x9c6d83a2,0xf4b1129b,0xd352015a,0xef51b369}},	//   _pokreta_, _umnyango_, _यस्ले_, _composit_,
   {{0x53869177,0x6cfa65b5,0x32904246,0x9c2b22f4}},	//   _waara_, _придружи, _tomai_, _norberar,
   {{0x238692e1,0xd8c7906e,0x72cae004,0x0b0ae0c9}},	// [1e20] _taara_, _संतप्त_, _kandel_, _kanselle,
   {{0xf26e1671,0x42ee5010,0xc9b062c8,0xa38740cc}},	//   _época_, _milfs_, _ongantíð_, _fuerza_,
   {{0x4497a44d,0x3d974015,0x2db332bd,0x5057a5b0}},	//   _lansiraj, _distritu_, _akhaonte_, _lansiran,
   {{0xe6a11085,0x33ce030b,0xc3ad50f7,0x2bae2094}},	//   _ভয়ংকর_, _laivu_, _胶南市海渔局_, _сибирийн_,
   {{0xb3ead44f,0xc200c095,0x92d94672,0x7dc7d307}},	//   _voltar_, _relish_, _ndeema_, _bekkenet_,
   {{0xb2ca0287,0xa20142ab,0x425b0171,0xe2e93163}},	//   _leido_, _sveiki_, _maalum_, _hainaut_,
   {{0xf26de45c,0x1f1fc0e1,0xb8cc70df,0x42fce14d}},	//   _tatou_, _auderien, _onductiv, _vangla_,
   {{0xceb331bf,0x0202621c,0x9d8893dd,0x750893dd}},	//   _autohton, _ferita_, _sprečiti_, _sprečili_,
   {{0x2396610d,0x32eb212e,0x1c072200,0xc0f6534f}},	//   _verslo_, _dopiero_, _bautisas, _maliraul,
   {{0x0eae1031,0x9da10256,0x82d11005,0x1f5f4122}},	//   _syarikat_, _nyungura, _neseniai_, _mutazion,
   {{0x7f6270e5,0x32926181,0x726ca2bc,0x03966043}},	//   _रेस्तरां_, _batatu_, _andong_, _tausta_,
   {{0xb20250ca,0x14a68171,0x940ac1a5,0x227ee169}},	//   _patite_, _uchambuz, _abaniniz, _weineg_,
   {{0x3316008d,0xf862f4a7,0x03e781f5,0xd0b011e2}},	//   _chizi_, _asiopulu, _hátha_, _abamukel,
   {{0xd50893dd,0xe97962b1,0x82926171,0xe9dd30e3}},	//   _sprečilo_, _lalibert, _watatu_, _maalaala_,
   {{0x89ddd206,0x69e85371,0x28e1e1bc,0xc3f1713f}},	//   _imperdie, _postihnu, _ئچىبئزدە_, _offering_,
   {{0xcf8f3043,0xfa4e42c8,0x23178271,0x7290d24a}},	//   _kommento, _kommunus, _kurzu_, _bleau_,
   {{0x8386c373,0x96c7445e,0x9be0f0f1,0xb27ed185}},	// [1e30] _སྤྲོའི_, _samarbei, _aksepter, _bronyi_,
   {{0xac17213e,0x9947c2c0,0xa30d30e4,0x231600c4}},	//   _पूर्ववर्, _armuwaar_, _donater_, _ikiza_,
   {{0xd92814f5,0x196730e0,0x23bda193,0xd0da62f3}},	//   _شمشیر_, _राजन्न_, _arawong_, _радикалн,
   {{0x847da009,0xbdb952ca,0xa433f14c,0x3386c18d}},	//   _животные_, _الۋااقنا_, _শিথিল_, _aloreg_,
   {{0x53ce9399,0xb281c38f,0x8a01c341,0x5287f048}},	//   _chava_, _verschil, _verschid, _regiony_,
   {{0x23f821af,0xb99c82db,0x17ae209a,0x9341e111}},	//   _tukua_, _merkezle, _биргә_, _komenco_,
   {{0xac01f3d9,0x32904278,0x92018026,0xe3966027}},	//   _diateres, _homau_, _muziek_, _caussa_,
   {{0x420121d0,0xc37803f2,0xec56b333,0x725b1175}},	//   _orbitz_, _embalwa_, _kartice_, _deblok_,
   {{0xd2ef80e5,0x427ef299,0x126e5113,0xbf11608a}},	//   _पदार्थों_, _quindi_, _datori_, _ارمانونه_,
   {{0xddbed4cf,0xd3eae057,0x2c2331c8,0xa9e64220}},	//   _proizila, _suntem_, _achieved_, _kuruhand,
   {{0xa6bc9141,0x2f64d020,0x1d07c492,0xfb6782a4}},	//   _правовых_, _embarkin, _spillere_, _ईरानी_,
   {{0xfd2030b4,0xf3878587,0x82904115,0x82495673}},	//   _hikiwawe_, _styria_, _nomat_, _efemis_,
   {{0xb69872e4,0xf38641b6,0x216ca133,0x35b8817d}},	//   _careerli, _kamra_, _varianty_, _позволит_,
   {{0xef66c16e,0x2beec087,0x636d8052,0xa22571de}},	//   _имало_, _разом_, _intervij, _odakle_,
   {{0x3158023f,0xfde352a7,0x9ffae45f,0xf378a0c5}},	//   _estrasbo, _сериалла, _बिहारले_, _biyanka_,
   {{0xf50893dd,0xac67b0bd,0x315bd04c,0xaaea70dc}},	//   _sprečila_, _gebring_, _اسپری_, _castelle,
   {{0xe2904341,0x62b5b2fc,0xa7c22065,0x47622003}},	// [1e40] _domat_, _gradove_, _חחחחחח_, _अर्धम_,
   {{0x80390101,0x2c33b0d2,0xe62d61a3,0xb9f8e00a}},	//   _profesyo, _чеченста, _khonthei, _paramete,
   {{0x924890ed,0xf2fdd01f,0xd4690086,0xf1bd714c}},	//   _igama_, _nahiyar_, _profecto_, _বড়ইল_,
   {{0xd7ac938c,0x5353105b,0x0ebd0199,0x83780041}},	//   _простире_, _مهمات_, _llandudn, _ambalwa_,
   {{0x5224712e,0xe341c022,0xbf25e183,0xa7380264}},	//   _rynku_, _انسار_, _regretta, _موسوعه_,
   {{0xaff40105,0xa2fce1d8,0x7352230e,0x8200b1aa}},	//   _לנעילת_, _mangka_, _गर्ला_, _bodiba_,
   {{0xe2cb52ef,0xc1e680b3,0x13eae24e,0x825a9363}},	//   _moeder_, _җентекле_, _montor_, _amalu_,
   {{0x42902529,0xaf57d340,0xf379617d,0x928cd293}},	//   _nikad_, _армате_, _parasta_, _inyangam,
   {{0x4b20530a,0x13954036,0x43a9b272,0x61290009}},	//   _eksplene, _stesse_, _bravore_, _доступен_,
   {{0xd25ad647,0x6c73d00f,0x98be719a,0xf38691ca}},	//   _imela_, _gården_, _hanesydd, _saaro_,
   {{0xb2cb703e,0x4ca43296,0x4c672322,0xa48cb0ac}},	//   _ibadan_, _султон_, _ammunta_, _사업자번호_,
   {{0x726d0349,0x3970014c,0x8946d00c,0x62b4029e}},	//   _naboen_, _সামুদ্রি, _asomuale, _débit_,
   {{0x8c7c0033,0x3b76411c,0xf3f90308,0x5a0d50f1}},	//   _asasina_, _sealadac, _bebula_, _forbetra_,
   {{0x7290d071,0xbd84e3f9,0x729f1080,0xc26dc123}},	//   _sleat_, _bevertet_, _anajman_, _lavoi_,
   {{0x6290d2d5,0x5290f0b9,0x2b77524e,0x5d5f9065}},	//   _cleas_, _dogan_, _ساعتها_, _נמשיך_,
   {{0x2d8fc200,0x6290c09b,0x8fe8c674,0x18eac248}},	//   _parlakip, _limans_, _रातारात_, _ዝፈትዎም_,
   {{0xadb43030,0xe26d816f,0xd061b2e2,0x72d1a5a5}},	// [1e50] _شوروی_, _faros_, _toussain, _demodik_,
   {{0x0528714c,0x62d8e19e,0xa075c2a7,0xf768b1e8}},	//   _শীতকালে_, _kaieke_, _суғориш_, _проконсу,
   {{0x9c9203b9,0x5c0d5319,0x0f322030,0xea7da027}},	//   _pitulung_, _hotstep_, _عنوانیده_, _tavanasa_,
   {{0x7471d0ce,0xc954806d,0x46ab529d,0xeb61d437}},	//   _pontosan_, _сербисто, _jongerei, _adelsher,
   {{0xd21c21d9,0x12eed231,0x32ca42c4,0x7627d2c6}},	//   _қайтарды_, _समारोहों_, _pemda_, _defianti,
   {{0xe395f2a3,0x6b2dc2c4,0x62483120,0x4290f157}},	//   _thuso_, _sembilan_, _lemmon_, _cogan_,
   {{0x62d88039,0xa04e4321,0x53fb4009,0xa85d23d0}},	//   _zaheer_, _illuatun, _встроенн, _голланды,
   {{0xf290f22f,0xf396518b,0x0da01038,0x9b5891fa}},	//   _mogao_, _yousuf_, _diantara, _anguriwa_,
   {{0xc29261ca,0x0a577018,0xc693b106,0x737be3c9}},	//   _garaad_, _biserica_, _aineolai, _romanum_,
   {{0xc3fc5007,0x5b1b14a5,0x557f4317,0x922df1fa}},	//   _aktuális_, _waraloon_, _kumuniez, _alavetel,
   {{0xd25ad440,0x1e92e3b5,0x1248d0a1,0xaa0710dc}},	//   _ameli_, _líderes_, _ngemb_, _escapade,
   {{0x8ff3d08a,0xda586086,0x82494291,0xd20f6403}},	//   _orthotic_, _scientia_, _ademan_, _baphakam,
   {{0xe2fc01e0,0x7ae581e8,0xad6ef08d,0x43872128}},	//   _dominus_, _edelleen_, _enamaqua, _fayre_,
   {{0x98acd0af,0xbe3750d0,0xb973a105,0xa2ba5261}},	//   _最新の日記_, _pulaaqta, _טריטי_, _banditi_,
   {{0xbed65088,0xa3b770d1,0x93f9f221,0xf75922fa}},	//   _melindun, _chuveka_, _bazuze_, _akayambi,
   {{0x93ea54f1,0xab0251c5,0x73df7240,0x7aeb61de}},	//   _celta_, _einsiede, _týdning_, _neprijat,
   {{0x529163f2,0x6c7c845b,0x74179152,0xf2902290}},	// [1e60] _yegazi_, _caisson_, _viestien_, _pokaz_,
   {{0x110b8121,0xa5c0704d,0x5849c212,0x62fce258}},	//   _चरितार्थ_, _ionadail_, _بيابه_, _kangia_,
   {{0x13ce61d7,0xef21c579,0xe2912057,0x830e7005}},	//   _shove_, _millorar_, _becali_, _vasaris_,
   {{0x326da123,0x0ecd0162,0x237a01d8,0x82257221}},	//   _lapos_, _түрмигә_, _seratan_, _afakwe_,
   {{0x06a163a5,0xc290f04d,0xf33d2352,0x19ce5435}},	//   _emithath, _mogal_, _میزاد_, _asimbaka_,
   {{0x0212b067,0x93ed50ad,0xb0fb2009,0x526da007}},	//   _meche_, _akureyri_, _yaphumel, _napos_,
   {{0x6387737c,0x157f4317,0xb386035e,0xf212b0cc}},	//   _starla_, _gumuniez, _dziri_, _leche_,
   {{0x982c9289,0x7d2d61da,0x2202520f,0xd290f08c}},	//   _སྦྱིས_, _arongoye_, _imtina_, _nogal_,
   {{0x5f4302e4,0xf3ac516c,0xd3ea50ad,0x63f90138}},	//   _chiplove_, _souple_, _velta_, _jabuke_,
   {{0x47f981e2,0x6da9231a,0xb27872b7,0x1cc4008a}},	//   _барандаг, _takulugu_, _kaunar_, _اېهود_,
   {{0x9f52e2ae,0xc08d9447,0x32d370f7,0x2294e0b3}},	//   _majandus_, _mennään_, _装潢使用在_, _avgustın,
   {{0xd4a380ea,0x5d33b62a,0x0ebdf098,0xd9df1275}},	//   _ज्ञानेन्, _menneske_, _yibukije_, _رەڭدە_,
   {{0x3290f1fe,0x0340909c,0x0cd8a009,0x826d8287}},	//   _dogal_, _mohegan_, _разнообр, _paros_,
   {{0x4e95442e,0x9c4502a0,0x434c01bd,0x92b411c8}},	//   _mismunan, _ژێرخانی_, _modelem_, _hundred_,
   {{0xf2d94035,0x375a6231,0x429040e4,0x1652f3fa}},	//   _rudens_, _पार्श्व_, _domaz_, _akakundi,
   {{0xa1352633,0xb2d8600c,0x46d8a0f4,0xe435c1ca}},	//   _vesteuro, _pulea_, _يذقعرع_, _qaranimo_,
   {{0xef274675,0x7837c005,0x9741e16e,0xb13521a7}},	// [1e70] _orrespon, _канале_, _основне_, _westeuro,
   {{0xf6c5f114,0x3b989226,0x12d8637e,0x8d9db1ca}},	//   _dibahagi, _मुकुन्द_, _vulea_, _maalmaha,
   {{0x13166045,0x498421e7,0xc2a6734d,0xe37882a1}},	//   _akoze_, _गतिमान_, _kanba_, _menahan_,
   {{0x08efa601,0x4447a1f0,0x5709c141,0xf62890b3}},	//   _vyoperov, _призлы_, _векили_, _системаг,
   {{0xe2a670bf,0xd047c370,0x2424e59d,0x0dbbb1d4}},	//   _manba_, _такозо_, _aggstein_, _tunillaa,
   {{0xe0ecc1ba,0xe2ecc1c0,0xd26d844b,0x44315180}},	//   _nazional, _nazione_, _varor_, _お気に入りに追加_,
   {{0x52cfe1a3,0x7bc85676,0x9e35e137,0x945d2225}},	//   _mukovhe_, _श्रीसंत_, _karaniwa, _alteraçã,
   {{0x237c4003,0xd3fa501d,0xd2ca01e7,0x627ee168}},	//   _lisatud_, _obtuse_, _leida_, _weinig_,
   {{0x183ce0af,0xac3db404,0x42904453,0x3293543d}},	//   _産学官連携リンク, _matibabu_, _tomaz_, _muskler_,
   {{0x33296107,0x62feb2f2,0x93c1b168,0x3d2cb186}},	//   _प्रपत्र_, _intihar_, _inschrij, _sosiyete_,
   {{0xa15bc1d2,0x7d023484,0x10ae115e,0xc225807e}},	//   _agoramoo, _ambulacr, _аршад_, _kyrka_,
   {{0x8eed1078,0x3f662292,0x9378e0ae,0xe4b45080}},	//   _النثر_, _шартли_, _allahin_, _ankallik,
   {{0xc3a23582,0x6a14921c,0x129191de,0xbc7c1295}},	//   _tempoh_, _benefiċċ, _dosad_, _adaseka_,
   {{0xc84dd0f7,0xc95bf57c,0xaa807085,0xc6a210c5}},	//   _天使的翅膀_, _vellykke, _atencion_, _atatekey,
   {{0xffece0b5,0x42c940d8,0xe6591221,0xf3b7e06a}},	//   _ﺟﺎﭘﺎﻛﻪﺵ_, _tulloch_, _abayitsh, _संचालकां,
   {{0x3520e098,0x0f62729f,0x73ce0313,0x1b995087}},	//   _inkotany, _gaspilla, _laivi_, _seminarr,
   {{0x876b5271,0x08fe4292,0x556db141,0x527f53b8}},	// [1e80] _diskutov, _qaragand, _germaniý, _tjener_,
   {{0x2e2aa5b5,0x8d3c407f,0x52e0234a,0xf2d86184}},	//   _старост_, _аицҵараз, _afanayo_, _gulen_,
   {{0xb7a390c8,0x22caf437,0x16c40218,0x8291909b}},	//   _сакратар_, _fridom_, _measarth, _kosad_,
   {{0x0cb1217a,0xf96871fc,0x83f84285,0xbc03649b}},	//   _বিচ্যুতি, _aplikese, _mumum_, _lympung_,
   {{0x8cfbf009,0xbf2a7199,0xf303028e,0x52258437}},	//   _обществе, _dystiola, _melawat_, _dyrka_,
   {{0xc2e60318,0x38e713c8,0x62c4a01b,0x1c0d00f3}},	//   _amanama_, _alngeghd, _hereketi_, _campane_,
   {{0x921261a4,0x8d27b0d2,0x1da4615e,0x32d960fb}},	//   _aloha_, _ирандын_, _тендерий, _vegena_,
   {{0x6c7c8064,0x12a62238,0xe27d71cf,0x4373b283}},	//   _贴子相关图片_, _kembre_, _versamml, _angahle_,
   {{0x53f123dd,0x1d866003,0x426de322,0x53f8624a}},	//   _erozije_, _प्रोटोका, _abtol_, _troud_,
   {{0x7afa71e7,0xb2912430,0x9ba2a050,0x726c146f}},	//   _tingimus, _qoyan_, _一個問題殘酷地擺, _achou_,
   {{0xd2d830c0,0x46c82251,0x1d07f0df,0x50e60024}},	//   _domeni_, _jusbrasi, _iteriacr, _किरीटी_,
   {{0x70e9803d,0x901b5031,0xecf2d0a2,0x8638f1ba}},	//   _abenguhl, _መገንጠል_, _فاطمې_, _affidabi,
   {{0x0386912b,0xd2fd22b8,0x6e4a9248,0xd3731362}},	//   _baara_, _kalahari_, _ዘገድሶም_, _rolanje_,
   {{0x826da0e4,0x3a89e5ee,0x35f31171,0xd6ab134e}},	//   _rapor_, _solisyon_, _اصحابن_, _иҷора_,
   {{0xea09037f,0x238691fe,0x1356713f,0xc26cd0cf}},	//   _kugawana_, _daara_, _depends_, _sinong_,
   {{0xd290f4da,0xd679b00c,0xc8830256,0x850a810f}},	//   _hogar_, _bankstow, _palipehu, _erőtelje,
   {{0xb2e7112a,0xdc7451c8,0x0271c23a,0x3f6a412d}},	// [1e90] _stanton_, _himself_, _khanduli_, _ohabolan,
   {{0xc3cff248,0x0df41143,0x4253707e,0x30a6256c}},	//   _እንዳኾነ_, _prodigue_, _gemensam, _ексклузи,
   {{0x6e6c10bf,0xabd25227,0xf26d01ab,0xa4b20116}},	//   _ایرور_, _가능하다는_, _libong_, _खडबडा_,
   {{0x79b623f0,0x3ca9423f,0x92ca0184,0xb423029f}},	//   _पुनर्निर, _arrestèt_, _adidy_, _azakoluk,
   {{0xf4b11306,0xfe57054e,0xdeccb04e,0x40a42037}},	//   _emnyango_, _cerciora, _pasyente_, _mäşhür_,
   {{0xa291621c,0xcb67139e,0x8dc5a180,0x1e3a21ca}},	//   _legali_, _amulatar, _opskrift_, _kusaabsa,
   {{0xf2ca0113,0xd3f8905d,0xec01c101,0x73eb0200}},	//   _veidi_, _staus_, _bonswar_, _khatat_,
   {{0x637b116f,0x215184e9,0x49d0c043,0xadb03221}},	//   _israelo_, _obilemay_, _tekemist, _athathwe_,
   {{0x2386d027,0xbcb74352,0xb89de048,0x57a9e176}},	//   _fuorma_, _پاداشت_, _soutěží_, _ملانصرال,
   {{0x0290203e,0x7386d0f1,0xf290f20e,0xf2f9f21f}},	//   _nnkan_, _caere_, _jogar_, _derugaiy_,
   {{0xdd183118,0x087863c9,0x827f02ea,0x45a29455}},	//   _glasswar, _militibu, _pranoi_, _bagratik,
   {{0xd2d47238,0xd225701f,0x99b160f5,0xcd866404}},	//   _brudet_, _shakka_, _mindeste, _نااميدي_,
   {{0x6f8be28b,0x71b39244,0xb20e112f,0xb26d81fa}},	//   _nederlân, _jananiña, _барай_, _ccrob_,
   {{0x8d37c4f5,0xe224e0c9,0x626da1d2,0x8e9ec11b}},	//   _تکرار_, _lenker_, _bapop_, _павла_,
   {{0xe26dc216,0x1809b0f7,0x0a1a309a,0x134bb3e1}},	//   _davos_, _查看该公司所有供, _بايقالغا, _apretou_,
   {{0x7a7ef20c,0xbd3f21b3,0x12c64677,0x7d2f9177}},	//   _aryamira_, _stupefac, _skalice_, _dakiikat_,
   {{0xda99c291,0x1adf1601,0x38d3a115,0x32912007}},	// [1ea0] _زيادي_, _tešíme_, _orientau, _anyag_,
   {{0x9b5802ac,0xfc629025,0xf2f3a1ca,0xaf647106}},	//   _شاروێران, _akurete_, _arrintu_, _breatuin,
   {{0x523d0026,0xd2d871ce,0xa8e3c2f4,0x7c14714b}},	//   _죄송합니다_, _cuneo_, _болжмор_, _grossess,
   {{0x52a6a38d,0xdb7734aa,0x3fc991b9,0x82919309}},	//   _jabba_, _barakön_, _белгес_, _bosam_,
   {{0x75ba32b1,0xb2cad031,0xe307d057,0x4072928c}},	//   _reparasy, _ኬሚስትሪ_, _прагул_, _terapijo,
   {{0xcb5b82f5,0x323311e2,0x8c9e921c,0x2a6d1117}},	//   _gedenken_, _khumalo_, _skirting_, _wanganga_,
   {{0x5200c00c,0x4d9d6043,0xc5f42105,0xe3957376}},	//   _foliga_, _sunnunta, _האמבורג_, _kwashe_,
   {{0x8290f2a9,0x59f1c37e,0x3149d41d,0x7641324e}},	//   _sogar_, _shandula_, _آزاری_, _سياستمدا,
   {{0x21485317,0x2265d036,0x249df0af,0xc35c0421}},	//   _testenno, _агенция_, _ルディングス_, _aangoof_,
   {{0xf615123f,0x4aad10ef,0xeb3432e9,0xa3f8d0a3}},	//   _ebullici, _وزارتن_, _binaynis, _steun_,
   {{0x221294a7,0xf36284dd,0xa96cf358,0x24936187}},	//   _alaha_, _produksj, _занимает_, _akazinso_,
   {{0x39fd3023,0x3d89d42f,0x8e52b390,0x77938345}},	//   _barakaat, _abroadwa, _barbadee_, _kriteeri,
   {{0x7d8931b1,0x126c81e4,0x92ce1065,0x5224e2a6}},	//   _valokuva, _kokoke_, _honored_, _klikom_,
   {{0xc29091c5,0x33967169,0x435ef064,0xc8349057}},	//   _anaal_, _missen_, _recevez_, _културэ_,
   {{0x249f4085,0x38ea0248,0x23b5e1fa,0x09c4d3a4}},	//   _সদস্যের_, _ዓንደብርሃን_, _alovola_, _vehement,
   {{0xd290f173,0x7c2d62b5,0xa0593678,0x5c4453c0}},	//   _jogap_, _compatab, _okuseman, _segwera_,
   {{0xdcb331b9,0xb6aed06d,0x41317266,0x2313f1fa}},	// [1eb0] _akhauntu_, _abadakiw, _ekitauto, _cincela_,
   {{0x765c61a5,0xbafdc14c,0xdceee241,0xba1ec0d2}},	//   _abukhali, _অবহেলিত_, _предэ_, _дигин_,
   {{0xc3169267,0x72d8a0ea,0x461420cc,0xc30ca086}},	//   _ahazi_, _duben_, _evaluaci, _sodales_,
   {{0x1bfaa0f4,0xc2f4c13f,0xfeef6031,0xc394e186}},	//   _جىمجىت_, _typical_, _ተችሎዋል_, _uwishe_,
   {{0xf26de0ec,0x74bf03cb,0xbe5dc0af,0xe3f8e0ec}},	//   _fatos_, _अवहेलना_, _セキュリティ_, _menuja_,
   {{0x3e704679,0x7c0e3130,0x029120fb,0x82d8a48e}},	//   _गोल्ड_, _jentilis, _anyad_, _arbed_,
   {{0x23f893d2,0xf27ed1d1,0xf2c9419d,0xab6db41e}},	//   _graue_, _dzena_, _mullach_, _kosmetic,
   {{0x820262e2,0x9200b36f,0x4523c0f4,0xce6660ae}},	//   _dirije_, _hodima_, _фондта_, _olunmalı,
   {{0xb3ced16c,0x7746515f,0x2c32f2ff,0x7e373221}},	//   _cheve_, _malikhug, _bimatlhc, _zangapha,
   {{0xe29020bc,0xde9a0026,0x3aac52a1,0x6e373283}},	//   _nikan_, _브라우저로_, _angkatan_, _yangapha,
   {{0x113c12e5,0xb2ca052f,0x0365a1a0,0xa290216f}},	//   _posledné_, _veidu_, _klotamam, _ankau_,
   {{0x731321a5,0x7a120105,0x529082aa,0x3d36c141}},	//   _grobler_, _אקסלען_, _ariary_, _байрыев_,
   {{0xa3ea7637,0x9e38e088,0x12cad367,0x31c4a040}},	//   _tento_, _peralata, _prodam_, _botemmeh_,
   {{0x427e0233,0xf3b5c1b3,0x1a683031,0xeb76501a}},	//   _mpino_, _trovava_, _ከአምናው_, _بارلارى_,
   {{0x513c145d,0xd20e115e,0xc29042b5,0x97af8057}},	//   _poslední_, _татах_, _inman_, _апаратул,
   {{0xaacb759d,0x999d30d7,0x7cc8f20b,0xbdab1258}},	//   _sommaren_, _ханым_, _कर्पूरी_, _misilera,
   {{0x01de119d,0xcc933096,0xf3161052,0x300722a7}},	// [1ec0] _chogaidh_, _وامان_, _nedaudz_, _парижда_,
   {{0x72902269,0xef579044,0xabd6033c,0x4b79d0d2}},	//   _gikan_, _takawaen, _moddalar, _йеменде_,
   {{0x2e1984c2,0xd2a7855b,0xfeae341a,0xb3799233}},	//   _keselama, _farbe_, _bestille_, _tenanao_,
   {{0x83e124f5,0x742e71ba,0xc5fa8011,0x3290e25f}},	//   _عضلات_, _дискусии_, _amigokué, _lanark_,
   {{0xe822e453,0xcd3ea0ea,0xe41720cc,0xe27ea0ea}},	//   _སྒྲིང_, _navigace_, _হারহান_, _navigaci_,
   {{0xe7ce1213,0xc2902171,0xf2a78239,0x24fb2031}},	//   _asiskaki, _kikao_, _harbe_, _ውጤታማና_,
   {{0x3ec54064,0x02026111,0x143a50aa,0x7a5de0d7}},	//   _derniers_, _aprilo_, _agakorok, _башларга_,
   {{0x998e21e2,0x62919146,0xa21d1434,0x82d99047}},	//   _тариқ_, _rosak_, _прозорец_, _abambejj,
   {{0x2248661c,0xa8cda11b,0x3af2c2d7,0x034bf500}},	//   _mgomo_, _asteroid, _akaredit, _vergilər_,
   {{0xc26de1cd,0x33ea72dd,0x34aaa136,0xe61891fc}},	//   _dator_, _wente_, _урамшуул, _acceptim_,
   {{0x52647519,0xb98c4187,0x728a4120,0x631690fe}},	//   _perler_, _machinga_, _dunkirk_, _akaza_,
   {{0x9fd85226,0xd3d41105,0xbb2a43a1,0x95bed11b}},	//   _odstraně, _נאכטאן_, _ababodab, _драги_,
   {{0x2a1dc47e,0xdb0c1019,0x3d98836f,0xe15c2030}},	//   _cambiame, _אלימלך_, _милләттә, _кураш_,
   {{0x58741105,0x02b1e333,0xcd7621ca,0xc7bc30c3}},	//   _טאהשער_, _prodaja_, _کرِنم_, _potrebni,
   {{0xd14b32d7,0x12d9600a,0x7d91f2bc,0xdab91227}},	//   _gomorrah_, _ability_, _analysea, _다우메디텍_,
   {{0x09cc0075,0xd3f4705a,0x83733144,0x1d0d90b9}},	//   _temeljit, _instal_, _abhalwe_, _arkalaşy,
   {{0xd3245088,0xce242096,0x38c111b7,0xcdeef418}},	// [1ed0] _mencari_, _بریگیڈ_, _expended, _abadakwa,
   {{0xbed1307f,0x9395727a,0x6d846287,0x0280e1a1}},	//   _нанҳәа_, _konzoly_, _nesvarbu_, _antiway_,
   {{0x13ac123e,0x8177b0d7,0x913c12e5,0x7e395366}},	//   _koppar_, _invalidl, _posledná_, _नातेवाईक_,
   {{0x33f8667a,0xfb190392,0x6200e149,0xbd9f91a1}},	//   _atout_, _kesamaan_, _alnima_, _adingtra,
   {{0x2c7d7213,0x98775345,0xe7cae152,0x2bce1105}},	//   _arusina_, _जीतेंद्र_, _kansalli, _אובאמא_,
   {{0xd63ec0d0,0x5815d0d7,0x626e7397,0x2321c1b3}},	//   _maligali, _буларак_, _musoro_, _cliccar_,
   {{0xac6102e4,0xf29022c9,0xeea4c275,0xdb191321}},	//   _ciputra_, _inkar_, _бузуши_, _ungasiss,
   {{0x72902223,0x850cb1e6,0x4eb72218,0x4c19508c}},	//   _vikao_, _alamariy, _عرفته_, _bespaar_,
   {{0xef79d431,0x0a8b224f,0x239d4030,0x08510095}},	//   _fonction, _nipilers, _مقدارده_, _choruses_,
   {{0xa2b35039,0x52489059,0xd278e3de,0xf42b426d}},	//   _buddien_, _ugama_, _velikani_, _dikanelo_,
   {{0x3665c043,0x4da0f24f,0x7620f24f,0xa6e8e01a}},	//   _сфере_, _akunnera, _akunneri, _сабактар,
   {{0x9153b124,0x490d647e,0xfb1fc004,0x3e43414f}},	//   _германие, _absorbís_, _kelangan_, _adhayaya,
   {{0xc24993dd,0x902411c7,0x5200f177,0xeae59383}},	//   _pesmu_, _реформал, _akhine_, _rekrutte,
   {{0x22c21171,0xe2f36063,0x730c25aa,0x4387467b}},	//   _usalama_, _kengashi_, _poderá_, _queria_,
   {{0xa301f0ae,0x28b6b307,0x53f82110,0xb2cae31e}},	//   _maraqli_, _austover_, _dukut_, _dandal_,
   {{0xb26c84ad,0xbc0f847b,0x63eb3516,0xc55e7314}},	//   _bokone_, _agamnihu_, _zlaté_, _हस्तकलाक,
   {{0x2b4ff0e5,0x6c67911e,0xae1700f8,0xfa46843d}},	// [1ee0] _आयुषवेद_, _ametter_, _raketala, _leverera_,
   {{0x93b3914f,0x59f7b1bd,0xc60e33d9,0xacbda105}},	//   _प्रबुद्ध, _zadavate, _boporesi, _ליביע_,
   {{0x12d8d076,0x72434131,0xa3bdc0ca,0xd37212d5}},	//   _hooemi_, _मुबलक_, _संयुक्तः_, _colaisd_,
   {{0x982cf373,0xcaae62f4,0x4e37b1e9,0xfc61e2f3}},	//   _འདྲིལ_, _тариалан_, _ladatata, _стадиона_,
   {{0x22904328,0xf27e9007,0x12da05af,0x936121d8}},	//   _inmat_, _arany_, _basert_, _nyambung_,
   {{0xf2cad051,0xd5b200af,0xd2fed31a,0x96ce4048}},	//   _candid_, _詳しくはこちら_, _maligaq_, _strakoni,
   {{0x2290e10d,0xbd9c6294,0x32ca9071,0x453a10c5}},	//   _šiame_, _ameliska, _reade_, _baribesh,
   {{0x58543342,0xd869b11c,0xca8da182,0xa9eb13b0}},	//   _روسيا_, _معلومة_, _श्रीमद्भ, _anerkend,
   {{0xb3fa6366,0x63034221,0x3c629018,0x3c07d05c}},	//   _berupa_, _zabantu_, _intrare_, _taksist_,
   {{0xa48c80e5,0xddaac0a2,0xc9298256,0x7bbbb004}},	//   _श्रमिकों_, _abanedip, _arumirwa_, _banyumas,
   {{0x93eb70c3,0x12026089,0x16d92276,0xa453a1bd}},	//   _smatra_, _thrice_, _ڪينسر_, _अग्निप्र,
   {{0x8b1ae059,0xbc41f0f7,0x72d872f8,0xc2d8d39f}},	//   _በመጪዎቹ_, _县级以上人民政府, _kunea_, _huden_,
   {{0x599d3375,0x188a53ac,0x09fa0185,0x12e86071}},	//   _табыс_, _markound, _mbrantse, _derfan_,
   {{0x930c3305,0xb2927148,0x908d1180,0x3e57a102}},	//   _enlaces_, _piraku_, _それにしても_, _духовног,
   {{0x7c51e301,0xc70390c9,0x01d65211,0x368e52af}},	//   _smotana_, _доларів_, _epalaham, _bonesedi,
   {{0x72dbb00a,0x78b01041,0x627ed0a1,0x5853120e}},	//   _הלהקה_, _استعمالو, _ngonzo_, _assuntos_,
   {{0x86a1f221,0x32d872f4,0x969893fe,0x53ea552f}},	// [1ef0] _amathath, _gunea_, _प्रवेशद्, _velti_,
   {{0x604b9345,0x03ea7437,0xdb61001a,0x6200c019}},	//   _महागुरु_, _henta_, _стандагы_, _milita_,
   {{0x6cb9f0c8,0x2afd71d0,0x77c470f7,0x33ea7300}},	//   _калектыв, _blogburs, _大兴区教师进修学, _kenta_,
   {{0xe2e8e329,0xdb1ad0cb,0xab503395,0xd386f2c5}},	//   _apliken_, _amcanion_, _merebɛbe, _lagra_,
   {{0x53ea7148,0x965e111b,0x3c7ad359,0x9c0d017a}},	//   _menta_, _фирме_, _süresi_, _kampane_,
   {{0x3698213f,0x41525020,0x0fbec031,0xf74e70ac}},	//   _מגודלים_, _inglesay_, _ወንድወሰን_, _국가보안법_,
   {{0x90f3f15e,0xf2d8d13c,0x6d1622a9,0x6539f140}},	//   _техникий, _judeo_, _wissensc, _gimnaziy,
   {{0xf394e015,0x06c71418,0x000c1180,0x12fce08d}},	//   _quispe_, _ababassi, _お問い合せ_, _bikawusi_,
   {{0xaabf245f,0x3386f173,0x3290403a,0x0bdca08b}},	//   _slavnost, _bagra_, _dimal_, _سيمبيان_,
   {{0xc2919364,0x9a3c1005,0x596fa22a,0xc37fc207}},	//   _alsat_, _душой_, _poznanst, _malatya_,
   {{0x9c4d2128,0x9c6450ef,0xa27f71df,0xab6323aa}},	//   _exacting_, _wabunge_, _flanko_, _essendon_,
   {{0xa2cab217,0x6837e0ac,0x40ecc1d3,0x0379a438}},	//   _fondı_, _되겠습니다_, _naziunal, _uphando_,
   {{0x5d91c15d,0xe24a22c4,0xd43ec0bf,0x929043e1}},	//   _صنعتي_, _क्षेत्_, _оавни_, _anmas_,
   {{0x0e1c824f,0x42009220,0x3e9532ca,0xe621013f}},	//   _imigassa, _tukiri_, _руханий_, _boundari,
   {{0x068c94a6,0xdc4bf292,0x12eb1164,0x43f8213a}},	//   _फ्राय_, _усуллари, _digicel_, _lukuk_,
   {{0x83cf1101,0x23ead629,0xa497d09a,0x77c8c362}},	//   _travay_, _groter_, _نۇسقىسىن, _pristani,
   {{0x3a0b3484,0xc2d98008,0xa380b077,0xfa19c330}},	// [1f00] _barbelat, _etrek_, _amogbonj, _万元人民币_,
   {{0xbdbe404e,0x23a2e43d,0x8108d500,0xa514b1a5}},	//   _catalase_, _klippa_, _yəhudilə, _abashiwo_,
   {{0xcc29a031,0x8730e24e,0xb28e01e2,0x8646f030}},	//   _ዓይነትና_, _شیطانی_, _болорави, _کنفرانسل,
   {{0x2b8023c0,0x72d8d17c,0x729f210e,0xc3f8218b}},	//   _diforamo_, _suden_, _spośród_, _rukum_,
   {{0xf075d242,0x1f562007,0xf3ea54a5,0xa471f091}},	//   _materiāl, _تاجروں_, _deltu_, _santiman_,
   {{0xe63b50f7,0x52e77308,0x12d960d1,0x03789341}},	//   _小仓优子性感泳装, _chuncha_, _engeti_, _schafen_,
   {{0xcd0d9207,0x62909281,0x28ec7071,0x63ea70ce}},	//   _arkadaşl, _inaan_, _tongersd, _fenti_,
   {{0x4ed07202,0x3c0bf403,0xd2e974b5,0xbb47d180}},	//   _panyakit_, _abelungu_, _huriwaa_, _コメント削除機能,
   {{0xa30e52eb,0x8b2000b5,0xc27e625d,0x22db04d2}},	//   _jurados_, _ﺍﻷﻫﺩﺍﻑ_, _apona_, _damupmeh_,
   {{0x9ae3d0df,0x929062e4,0x3a6d13c6,0xc4452030}},	//   _ogethert, _gioan_, _hanganga_, _мушкул_,
   {{0xb394e1fa,0x03f820b9,0x021c74ff,0xed4da1d4}},	//   _kriste_, _hukuk_, _sushil_, _allattoq,
   {{0xfe6c8469,0xb33fa407,0x429be043,0x0c6635e1}},	//   _concerne_, _ekskurzj, _гостиниц, _filtros_,
   {{0x2200c4a7,0x60c3d276,0xe44860bb,0x2b079065}},	//   _lolina_, _مدرسن_, _плануван, _מתקשר_,
   {{0x82919189,0xe96b7340,0xe2607300,0x6c614012}},	//   _posao_, _dimineat, _montroul, _kuvutia_,
   {{0x9200b09c,0xb212b0a9,0x3909a526,0x038311e6}},	//   _godina_, _elche_, _bazakubu, _manyate_,
   {{0xe290909c,0x0e780217,0x90e21646,0x524a61fb}},	//   _anaan_, _kabinetı, _weenkhal, _ntumwa_,
   {{0x2dbe41c8,0xce9b1086,0x7290f4de,0xbe4fc123}},	// [1f10] _database_, _aplusnet_, _ingal_, _komannma,
   {{0x56d200b3,0x22acc2c4,0x7b39f358,0xb5cb8307}},	//   _yazuçı_, _जयवर्धने_, _охраны_, _aplacoph,
   {{0x33f8c322,0x7249f386,0x2394e405,0xda45c30c}},	//   _abluke_, _pfumo_, _briste_, _fenestra_,
   {{0xd2b21367,0x7aa38086,0x52026177,0xf4e89052}},	//   _gradnja_, _areyouhe, _akriye_, _pagaidām_,
   {{0x2756f030,0x08b6b2c6,0x69d3c1d9,0x52ebc239}},	//   _شهرانی_, _destruer_, _фильмдер_, _amintar_,
   {{0x7200e1af,0xe386d00f,0xd72e4516,0x22e8200c}},	//   _minita_, _nyere_, _exkluziv, _apineru_,
   {{0xb3f8f04b,0xaf8e101a,0xa464a224,0x82ca91e9}},	//   _bugun_, _بارماقتا_, _direkoto_, _deadi_,
   {{0x130db249,0x7e2a2008,0xe40d615e,0x82d910ff}},	//   _votants_, _билдирже, _gainontz, _abonnee_,
   {{0x23eaf177,0x4d0c717e,0xab47c1a5,0x97579252}},	//   _abittu_, _industir, _гандум_, _жайлары_,
   {{0xdc160492,0xb6ba0276,0xf290f0d3,0x59d4101a}},	//   _søster_, _ريسٽورنٽ_, _angal_, _acollida_,
   {{0x083fe10f,0x93f82131,0xf3e5b13d,0x1ebc31c5}},	//   _مصرعے_, _dukuh_, _segeberg_, _pageboms_,
   {{0xa193f1a9,0x94d611bc,0x4e55c262,0xa05c5048}},	//   _германий, _شامكۅل_, _bagamije_, _दैनिकीको_,
   {{0x830ca348,0xa16e5007,0x0395005c,0x9576e1d9}},	//   _enfants_, _استفادہ_, _glasaj_, _арттыруғ,
   {{0xe200e1e9,0xa3f8f032,0x7972c079,0x9a1cf094}},	//   _dinita_, _augun_, _dennsine, _уранбаяр_,
   {{0x73136395,0xe20962b5,0xb2d5b056,0x5411a0d9}},	//   _lubbers_, _polycycl, _tlhotlo_, _amonanak,
   {{0x4200b3ab,0x6c874140,0xe27e0295,0x88542065}},	//   _rodina_, _субъектл, _mpini_, _תרגילי_,
   {{0xc25bf028,0x4cc48179,0xa6809231,0x73fa6322}},	// [1f20] _amulo_, _hamingju_, _गुमान_, _barule_,
   {{0xddbef063,0x9aed1106,0x66c63018,0x13f821e4}},	//   _sahifala, _aintighe, _consumul_, _kukui_,
   {{0xab944262,0x0d9c61d8,0xc8fe40aa,0x0394e135}},	//   _ishingir, _kaloloba, _baraband, _priste_,
   {{0x12010174,0x3ee0e225,0x5e3b04ab,0x00041434}},	//   _dobija_, _digitais_, _baragera, _технопол,
   {{0xcc1c3108,0xc2fe62ee,0xe8754009,0x32da415c}},	//   _organlar, _kabilar_, _neenkulu, _strooss_,
   {{0x417725a0,0x6c77d0e8,0xaf2b0230,0x25b6d04c}},	//   _нешта_, _potrafi_, _earnewâl, _نامرئی_,
   {{0x4280e121,0xc9f735ab,0xf84b30cc,0xf320d1e0}},	//   _प्रधानता_, _nangaphe, _manuales_, _cunctis_,
   {{0xd29020a4,0x02d810b2,0xcbb560ff,0xf8c2f193}},	//   _bikai_, _tshee_, _prijsver, _liederbu,
   {{0x42d8e5a2,0x9723c4ac,0xe3f84032,0xe8fb940d}},	//   _veneto_, _expresió, _sumum_, _allaybad,
   {{0x58768207,0x6387722e,0xb227b263,0xc25ad264}},	//   _olabilir_, _ngaran_, _кургонте, _seolta_,
   {{0x52a7828c,0xf2919104,0xf8a1727c,0x314da39f}},	//   _darbo_, _cosas_, _お気に入り_, _forestil,
   {{0xf2d96285,0x035e902a,0x4bfe8056,0x14ab82d4}},	//   _engeri_, _purging_, _latolago_, _mamallak,
   {{0x7c7c0213,0x9e373438,0x527e919c,0x92cb2472}},	//   _apasina_, _langapha, _apana_, _peyda_,
   {{0x87293517,0x647f624b,0x98c7c0af,0x0eb7d004}},	//   _добре_, _enzekako_, _知恵袋に投稿され, _پرستو_,
   {{0x52cad3b3,0x0eb340e9,0x094e354b,0xab6be225}},	//   _reede_, _saussure_, _escolare, _portaria_,
   {{0x6b4f40c9,0x2ee99265,0x4200e1ac,0x63a300fd}},	//   _kommuner, _štefánik, _monina_, _chapit_,
   {{0x4a87736f,0xf28c22e4,0xd13ec418,0x7b63800c}},	// [1f30] _kenyelet, _tinhyeu_, _abadicil, _faitotoa_,
   {{0x8c5e60f7,0x7e6f704c,0x3386d293,0xe694e031}},	//   _查看同主题问题_, _تحقيقاتي_, _nzeri_, _የመረጡት_,
   {{0xf2077075,0xa21294a7,0x77eb825b,0x22d92160}},	//   _uživali_, _alahi_, _samanlag, _poceli_,
   {{0x6c59e15e,0x125af039,0x99dc601b,0x9394f07e}},	//   _besteak_, _bailut_, _başlangy, _priset_,
   {{0x6722e0e5,0xd25ae240,0xd31f33bf,0x0c15b15c}},	//   _अर्थव्यव, _heilsa_, _rischio_, _düster_,
   {{0x2623a46e,0x0200b045,0xbdb4305a,0x517d9105}},	//   _daimntaw, _endiga_, _سوروس_, _דינוב_,
   {{0x426e6083,0x2c70a13e,0xe9211009,0x82e6523b}},	//   _aprova_, _मुर्गी_, _общего_, _chaudary_,
   {{0x73eaf193,0x326de177,0x2f02c124,0xd61f80d0}},	//   _suitor_, _abtok_, _акала_, _piinnari,
   {{0xc2cb45b8,0xf2cd31aa,0x6252925b,0x5502815c}},	//   _predam_, _bakoang_, _deildini_, _allefall_,
   {{0xabb3f40c,0xe291024a,0xddbf25c4,0x4f2a840f}},	//   _perkubur, _fraach_, _humenné_, _austurla,
   {{0x0201029f,0xf291024a,0x134c6300,0x03ea7093}},	//   _bobika_, _graach_, _niverel_, _tentu_,
   {{0xf290230b,0x431e9326,0x87b5340c,0xf2e77077}},	//   _tikai_, _namhlanj, _subspesi, _adunola_,
   {{0xce01d356,0xb394f35e,0xf29190f9,0x30403033}},	//   _aldebara, _mbishi_, _tosar_, _grandioz_,
   {{0x324801de,0x701b9292,0x325b019f,0x74d000ca}},	//   _naime_, _محرومیتل, _amalli_, _होलिका_,
   {{0xf212b2d2,0x4bcef180,0x49916510,0x02d873ef}},	//   _woche_, _brevkass, _abakamba_, _yunel_,
   {{0xab980396,0xd5fea218,0x2c688102,0xee1c20b3}},	//   _ficheiro_, _catalóin, _законнос, _грузиядә_,
   {{0xf08d83bf,0x4c580430,0x0d82800f,0xd3a370bd}},	// [1f40] _половина, _reallaşd, _illegalt_, _kaapse_,
   {{0x9639e0de,0x1248d03e,0xff3a0005,0xce3721d8}},	//   _dedicaci, _agemo_, _profesin, _manggiha,
   {{0x4682f207,0x23448288,0x6b8da036,0xc716425b}},	//   _siteleri, _قبرستاند, _indietro_, _listanum_,
   {{0x7347b37e,0xc94f246d,0xb29120c7,0xbd8f243d}},	//   _midenya_, _imponere, _niyad_, _imponera,
   {{0x13f8f086,0xf27e91ac,0x375440d0,0x82e3d1c2}},	//   _augue_, _asany_, _ukununng, _adantaj_,
   {{0x5cce40ac,0x718941ca,0x83bcc404,0x5e17d1bf}},	//   _이메일주소_, _jawaabay_, _الانا_, _telecoma,
   {{0xb7e60019,0x8628021f,0xfb7630c0,0x637a51de}},	//   _ליצנות_, _jubilati, _avalorac, _pojavio_,
   {{0x831d7251,0x1d2f10d7,0xaf55d159,0xe201b367}},	//   _torcida_, _iminlege_, _اندیشے_, _novica_,
   {{0xb291901a,0x237fd0c7,0xf57d9196,0x4e952227}},	//   _posar_, _filayaa_, _instrukz, _자치행정과_,
   {{0x288af257,0x6386d0f8,0x975970e5,0x2c8031b5}},	//   _tamamilə_, _egorov_, _साक्ष्य_, _белең_,
   {{0xfd9df0aa,0xb2555257,0x519d50af,0x3a8940f9}},	//   _abanyata, _həlak_, _名様にプレゼント_, _ávirkan_,
   {{0x8212b055,0x23eb23c9,0xac92548e,0x12494196}},	//   _poche_, _auctor_, _gwartheg_, _eremua_,
   {{0x32eab54b,0x7ccc113f,0xd2c1d200,0xe72d5180}},	//   _eventos_, _להפריד_, _kullaka_, _わかんねぇだろ_,
   {{0x0af1c1d9,0x630ce228,0x02f181ba,0x8c5394e6}},	//   _بىلگە_, _yohanes_, _инсталир, _igitabo_,
   {{0xc2257301,0xf2904304,0x02906076,0x425bf4c4}},	//   _vlakom_, _timah_, _anoai_, _smule_,
   {{0x73d5121c,0xd93431c9,0x0db4310f,0xbee06500}},	//   _protetti_, _itamarat, _یوروپ_, _aktyorla,
   {{0x64bd8264,0x86b772ad,0x9d07a1bf,0xbfd6d0a2}},	// [1f50] _الزنجبيل_, _maharati, _пионере_, _دفايل_,
   {{0x8d6cf0d1,0x992cf0d1,0x1394e064,0xe845220e}},	//   _avamakwa, _avamakwe, _puisse_, _leitores_,
   {{0x3e2a1080,0x2d2871d0,0x7159c4a0,0x2c08f0d7}},	//   _profecia, _digichat_, _wandarä_, _милләтар,
   {{0xc2ed0121,0x3fbd40d9,0xd2ea21b9,0x26e28009}},	//   _निरीह_, _réguler_, _mabitso_, _ukuqatjh,
   {{0x7ec6d317,0x027e6161,0xd3eb1008,0xc3a3715b}},	//   _skrivagn, _apone_, _amatly_, _inapim_,
   {{0x12340057,0xfc0b739d,0x73ea5329,0xbda31463}},	//   _меломани, _grupama_, _helti_, _akunatap,
   {{0x4290f266,0xc8f7439e,0x8db0d1d0,0x665a60fb}},	//   _angaa_, _qalayitu, _consensu_, _apabhraṃ,
   {{0xa202f213,0xcc03003d,0x0a14620d,0x378ea105}},	//   _anakarum, _scoping_, _pribatut, _פולשטענד,
   {{0x70dbb17a,0xf3272096,0x724ef271,0x3eb0f48a}},	//   _উদ্যোগীক, _پاسبانی_, _autorovi_, _aldrende_,
   {{0xab6352d7,0x539664ff,0xe2cad0b1,0xbea353b4}},	//   _akaretsa_, _morsel_, _geedi_, _akaretse_,
   {{0xa94971ff,0xb3eb7527,0x303fc0ff,0xef251335}},	//   _अलास्का_, _chatte_, _vestigin, _pertucca,
   {{0xd403c01a,0xcf8631b5,0x8135a20d,0x752cc4d2}},	//   _بئزگە_, _ەرلىك_, _mendebal, _biyintah,
   {{0xb25ae10c,0x898ed340,0x52d8a3c9,0x3615a064}},	//   _abilwe_, _надия_, _urbem_, _utilitai,
   {{0x735e2110,0xb56b60de,0xc6368494,0xdb8b55dd}},	//   _hangtod_, _بىلئگى_, _sahibidi, _ሓንጎልካ_,
   {{0x6848632d,0xc22b23c0,0x12a6c0cf,0x0c2e6049}},	//   _paripṛcc, _thomile_, _tambay_, _bosques_,
   {{0x73eb005d,0xf2ecb175,0x3c0e74e7,0xf9c20253}},	//   _quater_, _ensiste_, _cenuklub, _atumuina_,
   {{0xddef81bd,0x92ca0113,0x3b8b91de,0x1ecb9328}},	// [1f60] _पृष्ठभूम, _veids_, _ministar, _ministan,
   {{0x935d406a,0x0b02c257,0x3c615288,0xb2025633}},	//   _सल्ला_, _konfrans, _postlar_, _estisk_,
   {{0x939542bd,0xb2646008,0x92da600c,0xe34170e2}},	//   _kreste_, _barlag_, _foueti_, _berekya_,
   {{0x22da630d,0x90ebb276,0x02bb8358,0xd41d826e}},	//   _istess_, _آئوٽرام_, _строить_, _akcinink,
   {{0xc33d204c,0xd9f7a098,0x602742e8,0x53413388}},	//   _میراث_, _bibiliya_, _firework_, _منتان_,
   {{0xc3410352,0x7ee84310,0xc2fce09b,0xe95413bb}},	//   _دۆلار_, _adakalan, _bungil_, _gualbert,
   {{0x52919054,0x7f652135,0x59e1211d,0x6d21211d}},	//   _sosai_, _ወለዶታት_, _adzingwa_, _adzingwe_,
   {{0xb1c201a1,0xe212b223,0x4e96a27c,0xb3d0f072}},	//   _anadacay_, _kocha_, _fortalte_, _plemensk,
   {{0x027e9316,0x79fcd1c2,0xf02d70dc,0x27b61253}},	//   _upang_, _achamant, _барскоон_, _aletulaf,
   {{0x4a1d10f8,0x307cb14c,0x4bfbe272,0x87a3c21c}},	//   _минималь_, _ফটোশপ_, _borgesuc, _attribwi,
   {{0x97adb115,0xd227f1bf,0x3a082365,0x895503c9}},	//   _insectiv, _вариатэ_, _ausblase, _adulesce,
   {{0x631780ee,0x32d8d0a4,0x56eab35b,0x03ce90aa}},	//   _kurzy_, _tudei_, _приміщен, _abava_,
   {{0xc822b2bd,0x8a1520f6,0x53f82395,0x0bd793d0}},	//   _делегатт, _гурлэн_, _sukuu_, _чимгээ_,
   {{0x17c2414c,0xa08be0de,0x9779c214,0xa29023ba}},	//   _অনবরত_, _بئلمدە_, _кілті_, _nikaj_,
   {{0x12307098,0x4290f40c,0x513c12e5,0xa909367c}},	//   _nyamara_, _dngan_, _posledný_, _विवेकानं,
   {{0x5212b1b9,0x5290f032,0x5c55d192,0x02d8d225}},	//   _bocha_, _engan_, _пландар_, _ordem_,
   {{0x83a34240,0xf2960076,0xf290f222,0x442da0ac}},	// [1f70] _sleppa_, _makahiki_, _ongan_, _여러분들의_,
   {{0x7212b1c3,0x4262d096,0x2291d0dd,0x4341745b}},	//   _docha_, _ذائقہ_, _sowat_, _purezza_,
   {{0x7921c121,0x92909336,0x1768a031,0xe31e2221}},	//   _समाजे_, _anaai_, _ይታሰባል_, _amacebo_,
   {{0xf98ec009,0xd31783e5,0x9212b067,0xd2e71233}},	//   _каким_, _burzy_, _focha_, _kianjan_,
   {{0x4249f1fa,0x727ed3e4,0x05f8406a,0x46218258}},	//   _mfumo_, _apena_, _व्यवस्थे, _ilimmarf,
   {{0x220e117f,0x563d7180,0xc201018a,0x985e02e7}},	//   _расад_, _発明の詳細な説明_, _mobila_, _akanditu,
   {{0x22903012,0x8bdf93ea,0x97ad9163,0x63eb735c}},	//   _kamati_, _achenjer, _partenki, _baatal_,
   {{0x92cf7175,0xc2da61c5,0xd2f411ed,0xda08d11a}},	//   _armonye_, _lesonas_, _ixtimal_, _gumagana_,
   {{0x92e713aa,0xae37b094,0xf2b673ff,0x41472214}},	//   _ग्रीक_, _bidalita, _parchi_, _насихат_,
   {{0x90c7a277,0xd5e2e2fc,0x6c520213,0x3f2cd31d}},	//   _рамките_, _железнич, _imatana_, _vicentin,
   {{0x0056b155,0x424840da,0xa249f2e7,0x1e48511a}},	//   _يامغۇر_, _mamme_, _mfumu_, _lumalaba,
   {{0xd8542065,0xf2cad1e7,0x5f06c16e,0x7d86c508}},	//   _ברזילי_, _leedu_, _кратка_, _кратки_,
   {{0xa340d16f,0x2b1a70a9,0x8e443068,0x02a780b1}},	//   _someron_, _aleacion_, _pemburua, _marba_,
   {{0x03946209,0xb2ff4054,0x3201011b,0x82ffb0e2}},	//   _idosa_, _jaridar_, _dobila_, _andikap_,
   {{0x360ef188,0xc8f580c8,0x3779300f,0xeb7a322e}},	//   _fotoseri, _складана, _гість_, _cuaresma_,
   {{0xf249f2fe,0xb3955238,0x6b0792c6,0xb75e42aa}},	//   _agume_, _treset_, _apprecia_, _sarivong,
   {{0x01da6405,0x1291d0f5,0xf96df43d,0x62903123}},	// [1f80] _beagnach_, _sowas_, _blankett, _komann_,
   {{0x8261003b,0xb2fe6111,0x372ba0c9,0xcc495330}},	//   _acatulul, _skribis_, _столиці_, _讨厌干妹妹_,
   {{0x7378c10a,0x82a7748b,0x84dad20e,0x32d87193}},	//   _ريشمي_, _biabia_, _воена_, _erneu_,
   {{0x1b71d2bf,0x77de92ae,0x5f2a3248,0x4158d1bf}},	//   _akishura_, _kampaani, _ዓጀውጀው_, _пионерес,
   {{0x72a78052,0x8387f055,0x1291d0e5,0xcc6ee168}},	//   _darba_, _paura_, _towar_, _soorten_,
   {{0x5248424a,0xa38700d4,0xa2cb4169,0x510502d6}},	//   _namme_, _nyaris_, _gudder_, _mamičky_,
   {{0x82d830cc,0x92a78234,0x7c688425,0x0350106e}},	//   _mujer_, _farba_, _babuisi_, _वसुली_,
   {{0x127a424a,0xb94dd256,0x1a85e057,0x9dcf0214}},	//   _persoanl, _indorere, _публикэ_, _оптикалы,
   {{0xc387f1ef,0xb3a373f9,0x43f47384,0xe201f0e2}},	//   _taura_, _skapte_, _zistil_, _ekzije_,
   {{0xc2ca724d,0x122664f2,0xa2640271,0xcc0173aa}},	//   _ndilani_, _phukha_, _zaslat_, _drastis_,
   {{0x13f820be,0x4993d2b9,0x7e6c81df,0xf1300579}},	//   _bukur_, _eutheria_, _koncerne_, _السىقى_,
   {{0x929202c1,0x4c9cd292,0xf057c01a,0xad27c2fc}},	//   _lisans_, _тунда_, _пикири_, _произвођ,
   {{0x28f8716e,0x37c72124,0x860d10de,0x825ad035}},	//   _византиј, _антро_, _ايعاعى_, _nulles_,
   {{0x39e30336,0x2cfb7126,0x3249f2fe,0xdc6e110b}},	//   _tokotaha_, _fulundïg, _ugume_, _akaruha_,
   {{0xaf97a056,0x02d96101,0xcbf41587,0x92d76100}},	//   _dithekiš, _labours_, _offenbac, _azaleas_,
   {{0xe394f1d4,0x102a2009,0x78bfb36d,0xb7731124}},	//   _puisit_, _химическ, _videbatu, _игәра_,
   {{0x0713e0fa,0xcbe7241d,0xa9c53422,0xfaf85144}},	// [1f90] _zajmodav, _خریدی_, _desecrat, _akasakat,
   {{0xd3eb837d,0x222ac00f,0x0fee93b6,0x383d30f6}},	//   _serta_, _понад_, _अपमानित_, _аррык_,
   {{0x437b91d5,0x8197c2f3,0xfa363358,0x89fb90e0}},	//   _odlazim_, _законе_, _научной_, _क्रमशो_,
   {{0x7ef9040a,0xdb9711b2,0x02d9820d,0x05992248}},	//   _japonés_, _dzangano_, _euren_, _መሃንዘል_,
   {{0x03eb8473,0x63f84004,0x3c6dc023,0x33f8616d}},	//   _verta_, _tumut_, _doorita_, _brout_,
   {{0x5a773424,0xb290f193,0xf35f4050,0x1e1ec2ca}},	//   _flagella_, _engat_, _一意孤行追求自我, _бараарын_,
   {{0xbe83d043,0x99dd7387,0x49e5f1fc,0xa2d8a079}},	//   _подарок_, _alifabee, _klinimap_, _irben_,
   {{0x9f472013,0xd6c5014e,0x95b922e8,0x32d98168}},	//   _анышә_, _রণদীপম_, _ballstát_, _huren_,
   {{0xb633d20f,0xf202601f,0xca971360,0x4290f2f8}},	//   _yubileyi, _koriya_, _اوجھل_, _figan_,
   {{0x527ed079,0xe305c1a9,0x59755230,0x6a48f0e3}},	//   _apenn_, _قوپال_, _berneboe, _pasensya_,
   {{0xb2d9f043,0x62d8a18b,0x4c5a910c,0xc23b2304}},	//   _ettei_, _hubei_, _akatemi_, _menepati_,
   {{0x13954299,0xa283a3d9,0x62cbd36f,0xb20c91bf}},	//   _queste_, _barapedi_, _balolla_, _комбинэр,
   {{0xf7da80fb,0xd847d1bf,0x084a10bf,0xf3cff251}},	//   _प्रकारः_, _интенция_, _борки_, _chuva_,
   {{0x92d9838d,0x984dc545,0xbc69d533,0x3a5260de}},	//   _irree_, _aqalsayu, _batutsi_, _اشكەەرە_,
   {{0x3fa5144d,0x2c21a25a,0x2097e0f4,0x32902039}},	//   _navečer_, _גדליה_, _принсип_, _hikai_,
   {{0x9224e47b,0x13d172a0,0xef0b4248,0xc2d982b7}},	//   _adikwa_, _ڕێوان_, _ግዳማዉን_, _auren_,
   {{0xf2caf32e,0xe486313c,0x8edaa427,0x22cb510e}},	// [1fa0] _fundur_, _шанцев_, _старите_, _kredyt_,
   {{0xf213106e,0xc50130c5,0x1290d3d2,0x7290f11a}},	//   _अडथळा_, _aramwish, _broach_, _angat_,
   {{0x926cc424,0x7c01430f,0xa24802ab,0xa6174043}},	//   _snooze_, _photores, _kaimo_, _englanni,
   {{0xe8b1d31c,0x222542b8,0xee0f522c,0x2227f20e}},	//   _predsjed, _hoekom_, _aeleelea, _патишта_,
   {{0x42900267,0x2c67c2ff,0xe2da7247,0x13f863c9}},	//   _chiaa_, _bimusha_, _mesela_, _prout_,
   {{0x1f33616f,0x44752127,0x47b3616f,0xb60e3463}},	//   _konsista, _bureitak, _konsisti, _albostri,
   {{0x039570fc,0x83906387,0x7fa162b9,0x264612b8}},	//   _traste_, _akiyasi_, _arteriar_, _verkiesi,
   {{0x273f7056,0x55eb2041,0x9a287218,0xed487363}},	//   _bolokwag, _ارزانه_, _موفقين_, _fugalaau_,
   {{0x3b8de166,0x2680d028,0x5c6f129d,0x63a37222}},	//   _fornitur, _literati, _soarten_, _slappa_,
   {{0xfc6f4284,0x2c60b1c0,0xc9f9904a,0x13fa6012}},	//   _entrava_, _réunit_, _achabere, _karume_,
   {{0x3249f5ec,0xce63d03d,0x139490c5,0x6c28c020}},	//   _iguma_, _piecemea, _adasa_, _ovisions,
   {{0x42d8d196,0x2db8e342,0x88ae40de,0x135451c2}},	//   _ordea_, _scriptea, _اينۇرا_, _amperyu_,
   {{0xcc5be1a0,0x3290f222,0x43780266,0x52da7033}},	//   _alutosi_, _ongar_, _ataaina_, _desela_,
   {{0x2e3871fd,0x02a2667d,0x0c895257,0xe2f9f256}},	//   _galatasa, _उच्चस्तर, _kreditlə, _kwihana_,
   {{0x43f84086,0x2212f19e,0x9b0ac2b9,0x96b02438}},	//   _sumus_, _heihei_, _apostele, _مجرمينو_,
   {{0x725b00fb,0xf507b152,0xfe55b2c6,0xdc072086}},	//   _phalam_, _средств_, _arrangia, _grisoft_,
   {{0x49cef39f,0x80d04099,0x6212b305,0x92c652c1}},	// [1fb0] _forfatte, _vlastnej_, _noche_, _derecesi_,
   {{0xf4551299,0x9387f11d,0xe5ffe041,0x2dba21c3}},	//   _prodotto_, _sauro_, _ټلویزیون_, _tacharta,
   {{0x330c93c1,0xc3195172,0xb2912316,0x6387f35e}},	//   _antalet_, _medirong_, _diyan_, _pauro_,
   {{0x030dc0d1,0x46046206,0x596780ce,0xea2841f6}},	//   _hambana_, _imperium_, _tekintet, _इतेहसिक_,
   {{0x353cc124,0x624821d2,0x925b43d9,0xe0cae096}},	//   _мгимо_, _takma_, _abelwe_, _اعلامیہ_,
   {{0x027861a5,0x994e7378,0x241e9009,0xff09e1b5}},	//   _umuntu_, _snarsvar_, _городско, _ادامشىلد,
   {{0x9290f47e,0x53885248,0xa2919153,0xb27e60b4}},	//   _ligam_, _ትካላቱን_, _ensam_, _apono_,
   {{0x7d4ae007,0x9f25b225,0x41dc1292,0x7212f2d5}},	//   _آسانی_, _qualquer_, _клуби_, _bogha_,
   {{0x33f47027,0x92912054,0x519b3212,0xc46ff0b4}},	//   _surtut_, _biyan_, _دګازو_, _bapetizo_,
   {{0xa7c8e04b,0xe37b24da,0x1f1e304c,0xc2d8a008}},	//   _اصطلاحلر_, _horario_, _sandpoin, _erbet_,
   {{0x27bda35b,0xa27ed20d,0x93f40407,0x2be732bc}},	//   _ytterlig, _egongo_, _juster_, _etterfor,
   {{0xeb8ac196,0x5619c34d,0x9290f179,0x52d8d019}},	//   _домог_, _ballarmi, _engar_, _dudek_,
   {{0x098da105,0xc2e710b1,0x4e84f086,0x930960f4}},	//   _קיילי_, _dhanaan_, _showfont_, _ئېتراپ_,
   {{0x830f32c2,0x0318a3d9,0x93f8f0ec,0xa2d98340}},	//   _voditelj, _bakiwang_, _jugut_, _aurel_,
   {{0x4a5e72aa,0xfb2c4484,0x33042366,0x0a66c09a}},	//   _takelaka_, _albarras, _berawal_, _бигунаһ_,
   {{0x42d99010,0x1276842e,0x760b90ac,0x63ea7083}},	//   _favours_, _vinnunni_, _afkomsti, _lents_,
   {{0x93ea5224,0x72d864ff,0xb27ed0c6,0xb2da7381}},	// [1fc0] _pelts_, _kuler_, _apene_, _reseda_,
   {{0xaf6a02ab,0x7c99b031,0xa3d6b1c6,0xd3f89169}},	//   _straipsn, _ማስፈጸሚያ_, _distinti_, _draus_,
   {{0x62919123,0x2c0965d8,0x438d9271,0xe24890c6}},	//   _ansam_, _restenos, _ventilát, _maame_,
   {{0x6a937216,0x93f8b177,0xe7e31288,0x92489173}},	//   _decisiun_, _baduwa_, _вориси_, _agamy_,
   {{0xe07a4198,0xaa9822f3,0x8304414f,0x50e5821d}},	//   _временск, _приказуј, _adharam_, _साधीयः_,
   {{0x75eec5e6,0x93b630db,0xd2d9a102,0x029120e0}},	//   _tradició, _хайран_, _cupen_, _anyat_,
   {{0x65efd1a0,0xb0b4a024,0xc7ac716e,0xae8cf47b}},	//   _betenidü, _स्तुतौ_, _докумена, _mbuwanye_,
   {{0xd3f803ef,0x5063a3cf,0x12912257,0xb81c50ac}},	//   _prius_, _livsgrun, _ziyan_, _자동차용품_,
   {{0x186f13a3,0x027ee256,0xc224924a,0x22dfa0ff}},	//   _filmový_, _ngingo_, _makket_, _maandag_,
   {{0x9239339c,0x430f31de,0xcbf9304b,0x6200c2c0}},	//   _номус_, _roditelj, _партияси, _kilifa_,
   {{0xf2027063,0x5da5609f,0xea39211b,0xe237e256}},	//   _berish_, _ditokoma, _вечери_, _akomoka_,
   {{0xd75323be,0x835e9200,0xe03c50f7,0x3b7f5121}},	//   _neending, _payatańa, _广州同志会所_, _आदेशपाल_,
   {{0xc2484389,0xef77b16f,0x93f8f3eb,0x0346809a}},	//   _yamma_, _demandis_, _augum_, _дастаниғ,
   {{0x42d83235,0xd3f4c155,0xe2e7d225,0x79f892aa}},	//   _nimeni_, _курсини_, _драган_, _nahitana_,
   {{0x727ee094,0xe8c35287,0x73432192,0x62bb01c6}},	//   _egingo_, _нелегаль, _фотолар_, _valette_,
   {{0xc3801335,0xe2d83076,0xcc0d237f,0x8e1823a9}},	//   _emprem_, _himeni_, _alipire_, _blogiwwa,
   {{0xc387f47e,0x86a8d202,0x168b30b2,0x6283d2d7}},	// [1fd0] _paure_, _multiply, _tsimmeej_, _bathati_,
   {{0x0a83325a,0x3b2743d6,0x4096e2d1,0x53eb8053}},	//   _kontraŭ_, _yamaphes, _سالانی_, _werte_,
   {{0x12129639,0xc27ee19a,0x12909285,0x5248446c}},	//   _llahu_, _gennym_, _kakati_, _ramma_,
   {{0x6248407e,0xa4ee135b,0xcdf150a5,0xd386d0c6}},	//   _samma_, _підготов, _mendafta, _ayera_,
   {{0x9ec56104,0x29c7d1a5,0x715a42d4,0xf2e9043d}},	//   _নিবেদীতা_, _садамаи_, _qallariy_, _fysiska_,
   {{0xd69aa12e,0x12ca62df,0x72d87272,0x6f05944d}},	//   _lubelski, _agilosi_, _yunes_, _pitomača_,
   {{0xa200b3a5,0x1067b12b,0xe3fa62d6,0x8d6f4328}},	//   _indima_, _akwarado, _zaruke_, _tammaqta,
   {{0x3dbcd200,0x0425c37f,0x729002d5,0xb11e2156}},	//   _achilana, _kusindik, _chiad_, _приведен_,
   {{0xd3f1f1a6,0x56e1a20e,0x0b499287,0x7c02113f}},	//   _andzise_, _convocaç, _problemą_, _pictures,
   {{0x03b62102,0xcc3f0007,0x72d9c547,0x2681810e}},	//   _значення_, _العالمین_, _juven_, _एतराज_,
   {{0x67d594ba,0xdb69f218,0xf79b00de,0x63eaf17a}},	//   _ekspanzi, _bratacha_, _تۉستۅن_, _britar_,
   {{0xe2912228,0xdf2d500a,0xbea96261,0xc2d8e0e7}},	//   _anyar_, _conferen, _critiche_, _yeneyo_,
   {{0x69aa62ca,0x02da6465,0x3a3e2228,0x4f5791fa}},	//   _кризисти, _adreso_, _مستقيما_, _dlhadlen,
   {{0x6b30124b,0x22da712c,0x9f6ca527,0xa30233c8}},	//   _летом_, _baseke_, _horaires_, _boharpu_,
   {{0x2937b105,0x94fbb003,0xe3eb8064,0x82d910c3}},	//   _ירושלימע, _कुहासा_, _perte_, _muzej_,
   {{0x22d860fa,0xe151a13f,0xb9c411f3,0x6a0111cc}},	//   _usled_, _לכבוש_, _انتقامی_, _dražen_,
   {{0x027eb0ea,0xa26e4137,0x1dfc21a1,0x8c3aa1ba}},	// [1fe0] _jednom_, _nitong_, _unlesswa, _историят,
   {{0x2c7582e6,0x23dd0365,0xd9c7d287,0x3175d030}},	//   _सदस्यो_, _drawal_, _кавалак_, _сунний_,
   {{0x058e31c5,0x5db311c3,0x3f1f524e,0xe200c127}},	//   _baitonik, _colaiste_, _suntinga, _biliga_,
   {{0xdf6ff163,0xf2d0f41d,0xa248e0f9,0xd2d52122}},	//   _canarias_, _سیوریج_, _heimin_, _cipolla_,
   {{0x7df16008,0x40f21430,0x129021ab,0xcf23a321}},	//   _hindista, _yenilikl, _likas_, _amerlava,
   {{0x1c84b00a,0x1dbb8328,0x787b8328,0x368e1018}},	//   _observed_, _maliktaa, _maliktau, _conditii,
   {{0xf34150fd,0x43fc43d0,0x330f524b,0xf0e51167}},	//   _andedan_, _жигүүрий, _областях_, _aparikuš,
   {{0x5a864327,0x0647a0c8,0x0290b00e,0x0585509b}},	//   _adeniran_, _tinklapi, _nicat_, _smalikum_,
   {{0xaae8a164,0xe2aa20c8,0x24132352,0x2faea180}},	//   _retounen_, _фармальн, _زاندا_, _ブログ連載中_,
   {{0x4ed9b54c,0x5667313c,0x4ec2436f,0x927f748e}},	//   _emehlwen, _валико_, _amangoan, _planed_,
   {{0x8d1b713b,0x2ee030db,0xa830f0ea,0xf0b9b008}},	//   _amigaitq, _телле_, _ब्रह्माय, _айрылышс,
   {{0x8378e148,0x92d860af,0x0471d24e,0xbf3b9131}},	//   _kalawan_, _gulex_, _rintisan_, _kerusaka,
   {{0x920033dd,0xb170d4a8,0xc99b71a5,0x295ae06d}},	//   _armiji_, _रस्सी_, _abakwele, _abangewe,
   {{0x22a6b051,0x8077167e,0x1d295041,0x52f39033}},	//   _feeble_, _parceiro, _wengingq, _defisit_,
   {{0x996d941d,0x718f9023,0x32e30443,0xd3a52094}},	//   _ڈیموکریٹ_, _arkahaay_, _akointe_, _лууван_,
   {{0xab183144,0x12d9f177,0x8ebd73ac,0x425f8009}},	//   _kungenis, _ittek_, _mursalat_, _nokulwel,
   {{0x4265e02e,0x1f9ec264,0x146121c7,0xf2d83100}},	// [1ff0] _sukupuol, _محمول_, _ﺍﻟﻔﻭﻀﻰ_, _lamesa_,
   {{0x2394e3e3,0x085110f7,0xc3f8f19f,0x1ae97367}},	//   _asiste_, _衣锦荣归回乡路_, _ergun_, _sprememb,
   {{0x5c93c388,0x41a7a08b,0xfbdc2050,0xe95cc423}},	//   _ڵاتان_, _علیپور_, _一家報紙刊出標題, _geblokke,
   {{0xce9c1105,0x8b114120,0xb29b103d,0xf45a00c8}},	//   _והארות_, _kompanya_, _زراعتي_, _kalvarij,
   {{0x22e3203c,0x02d98329,0xc1e4a5fb,0x7d86b064}},	//   _finisce_, _atres_, _brøkdel_, _attendre_,
   {{0x32d9830a,0x779333c9,0x408452e4,0xf290b3c9}},	//   _stret_, _doctissi, _stockbiz_, _dicam_,
   {{0xf0317272,0x53949025,0x024430b9,0xaa12d1a1}},	//   _contenen, _adase_, _адреслер_, _apabilit,
   {{0xc27ed187,0x722540e4,0xe395708e,0xb1d9111b}},	//   _mpeni_, _adekwa_, _yakyawj_, _методе_,
   {{0x32a620f0,0x92fc71fe,0xf2d9c28b,0xc39560e2}},	//   _semble_, _amnga_, _duvel_, _setyèm_,
   {{0x1307701c,0x7635e55d,0x73967010,0x838160ec}},	//   _anyagok_, _tapiiffi, _missin_, _berishës_,
   {{0xadba10df,0x602061e2,0x7adfb271,0x03eb007e}},	//   _urchasep, _shadrack_, _zastupit, _pratar_,
   {{0x8af9321f,0xed9011e5,0x4628d272,0x23f8f295}},	//   _worshipe, _дерди_, _mutilati, _achule_,
   {{0xc7c723ef,0x89c71009,0x63eb044d,0x2b87c38f}},	//   _disssoci, _масала_, _vratar_, _gefilter,
   {{0x1201f22a,0xf26631bf,0x6212b046,0xf186e14c}},	//   _vozila_, _ансамблу_, _rocha_, _কুসুম্বী_,
   {{0x191f3401,0x43eb0550,0x52480171,0x9fa06168}},	//   _aistriúc, _tratar_, _daima_, _eigenaar_,
   {{0xa202643d,0xf9fa9076,0x026a42ac,0x52d9c4dc}},	//   _ulrika_, _kanikela_, _زرێپۆشی_, _juvel_,

   {{0x7201b131,0xafbdc252,0xddfb9057,0xcfdd62bf}},	// [2000] _lovina_, _участокт, _referate_, _babinono,
   {{0xe2ca6191,0x3c7140fb,0x67c950e5,0x349ae085}},	//   _ugode_, _मार्गे_, _zastosow, _মেন্টাল_,
   {{0xd2e8c012,0x9e1ac408,0xc27f701d,0x2f5f400c}},	//   _مقدمو_, _kecelaka, _aranon_, _autaunon,
   {{0x1177e009,0xf4c6c0ee,0xe387f145,0x93a99128}},	//   _negandel, _psychick, _ezuru_, _crevice_,
   {{0x99da41a2,0x72d9f043,0x0fa373bb,0x08b70171}},	//   _galleria_, _kuten_, _villarro, _لامحدود_,
   {{0x94f300be,0x12903285,0x7d7ef428,0x28cc7517}},	//   _shembull_, _kamasi_, _framunda, _осветлен,
   {{0x4e46512c,0xa3169256,0xac7f704e,0xf200e365}},	//   _membersa, _akazu_, _kanunay_, _biniga_,
   {{0x72ff411a,0x4a7f43e6,0xe2c4116c,0x93eb8005}},	//   _marimar_, _maramara_, _vandredi_, _gerti_,
   {{0x8a3e52c1,0x238740cc,0x624dd0e5,0x3853217d}},	//   _haritası_, _cierto_, _मंगला_, _рекламны,
   {{0xe9666050,0x22d8e0e7,0x6471f137,0xdae2f15e}},	//   _手拉手向前走_, _lenelo_, _puntahan_, _болсны_,
   {{0xf291900e,0x63dc9244,0x0364b3a2,0x7ddb80bb}},	//   _insan_, _amawa_, _podrazum, _обслугов,
   {{0x32c8c17f,0x625ad0c9,0xb2df12c8,0x53548188}},	//   _арманист, _faller_, _kunning_, _beweist_,
   {{0x6b9a2516,0x2e3fa469,0xd386d159,0x42616115}},	//   _ekonomic, _reformes_, _nyert_, _controtl,
   {{0x5c604280,0xeccea064,0xe2484064,0x92fa10e4}},	//   _kufutwa_, _县级以上地方人民, _gamme_, _bachara_,
   {{0x825ad317,0xd3ebe23c,0xc177e24b,0xb134201a}},	//   _haller_, _detto_, _yegandel, _берилген,
   {{0x53ebe299,0x030c4453,0x7c01d052,0x1290301f}},	//   _letto_, _dibabet_, _pretties, _lamari_,
   {{0x0b22546a,0x3202505d,0xa967f0e5,0x691c0212}},	// [2010] _ekuphele, _entira_, _skontakt, _ټيلفون_,
   {{0xabd7c54b,0x6219e0a8,0x32d9f0f5,0xa2903211}},	//   _vendedor, _podnikán, _guten_, _tamasi_,
   {{0x841a63f9,0x1c51f1c2,0x22490322,0x1cdcd37f}},	//   _правилам, _alitana_, _daamis_, _akuwawer,
   {{0x53eb845b,0x339400a9,0x62d98044,0xb27f70ec}},	//   _certi_, _klisa_, _purei_, _pranon_,
   {{0x029031d8,0x84b2e06c,0xc3f882cf,0xd58130fd}},	//   _kamari_, _टुकडा_, _dihuni_, _liberasy,
   {{0xe25a6003,0xf455b21d,0x621f02ab,0x2d644030}},	//   _mulle_, _रसेन्द्र, _pasirašy, _аппарати_,
   {{0x310453df,0x4fc221ed,0x543e120d,0xb3f99346}},	//   _депозитн, _сколково_, _хасна_, _rusuh_,
   {{0x62020079,0x5c09c197,0xf27f72aa,0x7224c58e}},	//   _popila_, _sempena_, _tranon_, _ndokua_,
   {{0x0d809272,0xdee92394,0x233c120d,0xc2014428}},	//   _adherent_, _markasan, _олигархи_, _steini_,
   {{0x53eb8123,0xf0284191,0xc6d5b14c,0x52d52180}},	//   _serti_, _schwabin, _ইদ্রিস_, _stillet_,
   {{0x30da6124,0xf34480c4,0x725b00b4,0x52d71533}},	//   _пропоган, _ubwenge_, _alalai_, _murongo_,
   {{0x62d9f3cc,0x7274f67f,0x23eb135f,0x921c1140}},	//   _zuten_, _forskjel, _platby_, _orphus_,
   {{0xb25a63ce,0x628e2045,0xfc07a392,0xa290f0cf}},	//   _julle_, _kaakano_, _bersatu_, _sigaw_,
   {{0xa2914010,0xcdc052c1,0xd2d83135,0x6e4744ec}},	//   _preach_, _antikala, _ahmeti_, _osmaniye_,
   {{0x32feb2a1,0x5e1ba06a,0x11661105,0x32e9240f}},	//   _matahari_, _kesepaka, _ריווקין_, _kannast_,
   {{0xa248428a,0x53729443,0x5394922e,0x42ee242e}},	//   _samme_, _skillung_, _ndash_, _gangandi_,
   {{0xf25a612a,0xd3fa15ff,0x394e7387,0x439672a9}},	// [2020] _nulle_, _populi_, _abayọri_, _musste_,
   {{0x6360208c,0x429122c1,0xa248d223,0x89761105}},	//   _liggaam_, _siyah_, _kuomba_, _אבארשען_,
   {{0xea7f4171,0x0642c042,0x3243f1d9,0x2d274144}},	//   _barabara_, _ahlolelw, _глубокое_, _ashonile_,
   {{0x9aa7c5c2,0x81b3c33c,0x95c7461c,0x8827641c}},	//   _जिज्ञासा_, _نادری_, _ihlabath, _پاراسات_,
   {{0xf2919054,0x122670c9,0x32ee72ee,0x6862a25d}},	//   _kisan_, _merker_, _fannoni_, _akondend,
   {{0x18ac8680,0x149f4085,0xdfbc40e5,0x8dc1522a}},	//   _preskoči_, _বৃদ্ধির_, _अलिकांते_, _prikriva,
   {{0x827ee0af,0x83eaf0ec,0xaed60041,0x82919079}},	//   _gennem_, _pritur_, _abanefas_, _disan_,
   {{0x02c65008,0xa98260b5,0x2c69f395,0x203853f1}},	//   _derejesi_, _احانتاي_, _perunni_, _batesalo,
   {{0xa2eba1b8,0xdd9f2245,0xe95f2221,0x2000914f}},	//   _ictnews_, _abangasa, _abangase, _aghoryād,
   {{0xb2d8d234,0xe39650f4,0xe3f32264,0xe1fed502}},	//   _budes_, _پاسپورت_, _لطلاب_, _ураза_,
   {{0xf838f2bd,0x504c5009,0x33f8f19e,0x9b72314c}},	//   _башланғы, _kokugcin, _mahuta_, _ভাষণে_,
   {{0x0c08a2e8,0x42d8d469,0x963ec076,0xf5a4e026}},	//   _رونالدو_, _luder_, _halihali, _verstrek,
   {{0x62919060,0x1acb1121,0x894d8273,0x3c55f3b4}},	//   _bisan_, _फेडरेशन_, _innostre, _abetswe_,
   {{0x30b522c4,0xab977009,0x71a850f4,0x1f403186}},	//   _permasal, _yikhongr, _абабәкри_, _nyagasan,
   {{0x225ae431,0x72d9f0be,0x665b71d9,0x22ecb28c}},	//   _taille_, _lutem_, _قىلامىز_, _kuriame_,
   {{0x2efe9026,0x9ffb5351,0x2291922f,0x631b9011}},	//   _이용하시기_, _داستانها, _misao_, _lombriz_,
   {{0x22a69337,0x82cc3126,0x4e96c342,0xc32a801f}},	// [2030] _životní_, _kualimo_, _هرمون_, _dunhuang_,
   {{0xb2ecc09f,0x3c034349,0xda7dd11d,0xbb8c50f8}},	//   _алмай_, _forsvar_, _achafara_, _tabiblar,
   {{0xffe8330e,0xf226701d,0xc269a0d7,0x520250d2}},	//   _रिचार्ज_, _kerker_, _bernindi_, _botiga_,
   {{0x529192e1,0xec259293,0xb3047238,0x8944a2a9}},	//   _aisan_, _batangir, _kevatal_, _darunter_,
   {{0x32cad08c,0x1b95f031,0xc53cc07f,0x9d481009}},	//   _reeds_, _ገልፃለች_, _агимн_, _общей_,
   {{0x63ebe0dd,0x5e677113,0x228d916c,0x15e8c2c1}},	//   _wette_, _autorizē, _chikago_, _rahatsız_,
   {{0xd198a217,0x93eb8004,0x926a3203,0xf6db0264}},	//   _органнар, _kertu_, _bannabbi_, _عااااااا,
   {{0x137cb0d9,0x558eb1da,0xaef53330,0x2d7723d0}},	//   _israele_, _amatarik, _中国轻工业联合会_, _уршгаар_,
   {{0x13761019,0xac6a0600,0x9ce9e0af,0x61786422}},	//   _חשובֿע_, _umlungu_, _インタビュ_, _palatabl,
   {{0x437a7351,0x42f38162,0x034c2095,0xd29193b0}},	//   _ketaman_, _толиму_, _fateful_, _ansat_,
   {{0xd2902266,0x0c66b24a,0x9212b1c4,0xea7dd04a}},	//   _vakai_, _bestiet_, _bocht_, _achagara_,
   {{0xb2484268,0xcf5a7132,0xc2caf0f9,0xd2249440}},	//   _hamma_, _абсолвир, _sundur_, _aloká_,
   {{0x429192dc,0x478760e5,0xc26d113f,0x320090bc}},	//   _pisan_, _सर्विस_, _income_, _aijina_,
   {{0xa20121dd,0x0d2310aa,0xea17e27d,0xdc8494bc}},	//   _bucini_, _arasekur, _insaanka_, _patented_,
   {{0xb212b521,0x42c5c16c,0xa2d8d41a,0xa27860e7}},	//   _tocht_, _deklare_, _ruder_, _pfunzo_,
   {{0x92025206,0x7fd663bb,0x850c2009,0xdc16522f}},	//   _altima_, _tornillo, _установл, _sigurnos,
   {{0x99ac625c,0x13ebe00f,0xc6a180af,0x093f61f4}},	// [2040] _бюджетті, _rette_, _ご了承ください_, _aromanya_,
   {{0xf249f5ec,0x0290a1e5,0x46d611a1,0xe686c36e}},	//   _uguma_, _arkaly_, _aracteri, _condemni,
   {{0xaf212036,0xa27eb189,0xd26c3135,0x125004dd}},	//   _esperien, _jednim_, _lejon_, _ombestem,
   {{0xa212b28b,0x8ae1f2bc,0x2709a063,0x1cf1819e}},	//   _dochs_, _kostnade, _оналари_, _taitoker,
   {{0x1ef03287,0x97f0704b,0xf047317d,0xbecba00e}},	//   _reikalin, _yaratilg, _секса_, _turnirin,
   {{0x8212f493,0xcee2d07f,0x13f970e7,0xb7e052ae}},	//   _rogha_, _итика_, _ndaulo_, _hispaani,
   {{0x02902076,0x7dd3605f,0x8ba04121,0x2c605027}},	//   _makau_, _apokelea, _सहित्य_, _chattar_,
   {{0x571201df,0x1a7694bd,0x33c190e5,0x2f3b734d}},	//   _החרדית_, _नमोनमः_, _प्राकृति_, _kongwien,
   {{0xc3954403,0x0c073430,0xe6b87292,0x5c9ef3b0}},	//   _ixesha_, _partiyas, _palatasi, _thorning_,
   {{0x63cf73f2,0x9c7d6177,0x0f4d0393,0xa212b010}},	//   _ugavin_, _onusida_, _comparte_, _socht_,
   {{0x8c1971e6,0xfc52314c,0x3d98d0bf,0x64a311c9}},	//   _निश्चित्, _অদম্য_, _insoniya, _proyekto_,
   {{0x028d703b,0x8370a0ac,0x68ae5120,0x8f25306a}},	//   _abukana_, _톡톡궁금증_, _galvanic_, _berencan,
   {{0x1286500f,0x2202006e,0x7ecd30f0,0xf2d900d9}},	//   _становил, _musisi_, _dirigean, _alongwe_,
   {{0x17f0704b,0x72e5d0f9,0x229040c0,0xd80180fb}},	//   _qaratilg, _hennara_, _jamai_, _परिवर्तत,
   {{0x52ed4520,0xa2e5d032,0x0212d100,0x4bff710b}},	//   _kopiere_, _kennara_, _amohan_, _bahubats,
   {{0xb29090b1,0xb29044f1,0xb046c1ca,0x7e30b1c7}},	//   _ahaan_, _tamah_, _شٹھٕراوِ_, _ەلتابار_,
   {{0xb26c20de,0x73f9f266,0xc20265c4,0xefa3106a}},	// [2050] _ئللپاللا, _atuuu_, _skrine_, _akseptor_,
   {{0x39f5e468,0x7ee03681,0xe27ff169,0xd1b19300}},	//   _योगेन्द्, _छात्रावा, _fruny_, _menezioù_,
   {{0x32d881aa,0x9e9e336b,0x53950489,0x402e1287}},	//   _pehelo_, _erstellt_, _hlasuj_, _заяве_,
   {{0xe3417511,0x1c7c11f5,0x925c4005,0x5303f0f5}},	//   _diferan_, _forrás_, _pakeitim, _gedacht_,
   {{0xf2025322,0xe25ad0de,0x174a11df,0xc046d03a}},	//   _fotima_, _callar_, _regionoj_, _katriyen,
   {{0x42786308,0x6a7ae0af,0xfc8b80ac,0x629022df}},	//   _mfungo_, _エグザイル_, _저작권정책_, _cakau_,
   {{0xcc197116,0xe2902177,0xdaf520f1,0x8db9c0a2}},	//   _निश्चिन्, _lakat_, _arrestas, _abanorha,
   {{0x23950089,0xf2fd41df,0x9a4960a0,0x23a5b293}},	//   _teases_, _ensaluti_, _امتيازات_, _yarangij,
   {{0x1744e4f5,0x5d86424a,0xf651b393,0x5ad9f1ac}},	//   _اندازی_, _tegearre_, _discusió, _tendromb,
   {{0x171da457,0x6c602106,0x42fe65c4,0xadfe2665}},	//   _actuació, _mairead_, _kuchyne_, _नेस्तनाब,
   {{0x8212b034,0xa2904310,0xf3940370,0x717c007b}},	//   _anche_, _ramai_, _umiss_, _fedaraal,
   {{0x6ab9916e,0x229090d9,0x923dc2f7,0x4213214b}},	//   _политике_, _makasi_, _японийә_, _fiches_,
   {{0xa02d60af,0x5290221e,0x97ed303b,0xce38d3e6}},	//   _コミュニティ_, _bakau_, _angaleng, _patapata,
   {{0xd29092cb,0xca7f31bc,0x6b7fc38c,0xfec4203c}},	//   _wakati_, _ئيمەگىرە, _posledic, _viendron,
   {{0xde5431ed,0xe8daf510,0x0303f22d,0xedc403bf}},	//   _ansamble_, _abagituu, _bedacht_, _comincia,
   {{0xe7a910c7,0x829022c1,0xba86403e,0x136084b2}},	//   _فقیری_, _fakat_, _abenugan_, _phimvang_,
   {{0xc2904266,0xa8db9064,0x8a7e2276,0xd9a34218}},	// [2060] _tamai_, _胶南市城建局_, _مسافري_, _limistéi,
   {{0xaf31520e,0xd938109a,0x6c593180,0x8f2531d8}},	//   _квалитет_, _дурданил, _ジェニファ_, _rerencan,
   {{0xec6b41b4,0xe3961096,0x643890f7,0xc2919079}},	//   _जयन्ती_, _پہننے_, _警惕高仿真的古币, _disab_,
   {{0xc2ee824a,0x130e447b,0xb7c574d2,0xf460b031}},	//   _moandei_, _elebara_, _burghdaj_, _dikelask,
   {{0xf8754501,0x33940175,0x93f893d9,0xeb84e358}},	//   _ngenkulu, _glise_, _bajuta_, _экологич,
   {{0x937f21c7,0x6dbbe174,0xab088434,0x5e4de287}},	//   _астанада_, _podršku_, _шампионс, _спробы_,
   {{0xd4ecb27c,0x1c6171f8,0x85274061,0x109032c3}},	//   _ファッション_, _siguran_, _جائداد_, _айрылды_,
   {{0x835bf1e2,0xc29093c6,0xc6c220aa,0xb24940c3}},	//   _kungaba_, _hakari_, _akirariy, _premda_,
   {{0xe3ebe07e,0x5883c431,0xf25a6617,0x129022aa}},	//   _detta_, _您现在的位置_, _culla_, _fakam_,
   {{0x5c36013f,0x2a976105,0x2387f1be,0x1ea7c2a9}},	//   _בשכונת_, _אנאליטיק, _uzuri_, _editiert_,
   {{0x06408223,0x62909187,0x2249418a,0x1290911e}},	//   _kusikili, _pakati_, _vremea_, _makari_,
   {{0x52025339,0x0b2780d7,0x5b6bf0cc,0xa2d73085}},	//   _notika_, _батырлар, _gustaria_, _supongo_,
   {{0x6af1f174,0x2fbf4248,0x62902008,0xdabd32d1}},	//   _непријат, _ብዘይፈልጥ_, _kakam_, _میشدا_,
   {{0x235e5682,0xf3792093,0x03e43440,0x3c5af4b1}},	//   _पल्ला_, _jabatan_, _akamatak, _mastieh_,
   {{0xa291d300,0x025a6299,0x027ae0f7,0x20c6f05b}},	//   _diwan_, _sulla_, _conseill, _ناکامۍ_,
   {{0xa2595036,0xbc537278,0x738cb316,0xe0c9c009}},	//   _particol, _kautama_, _karylle_, _кнопки_,
   {{0x92c97123,0x220ec0d2,0x73ebe03c,0x3ec57115}},	// [2070] _kailash_, _тамак_, _detti_, _arrondas_,
   {{0x0a7271b5,0x7c2f32c6,0x42d88683,0x0a2ae252}},	//   _كەتكىن_, _hospitab, _cakera_, _осетияда,
   {{0x259ca07a,0x30e9a2bd,0xfeb540d2,0x550771ba}},	//   _ditubuhk, _башлаяса, _aspectes_, _sportivo_,
   {{0x42d9f260,0x125a6152,0x52ad10d2,0xc29024e5}},	//   _etter_, _tulla_, _اللاح_, _aakam_,
   {{0xa248d0c2,0xd290b286,0xf508d159,0x128400ac}},	//   _maemo_, _licas_, _freemail_, _verschul,
   {{0x285aa281,0x9c820109,0x7202619e,0xb305108a}},	//   _دعوادار_, _moreland_, _hiriwa_, _طوفات_,
   {{0x0a1ac2fd,0x515d01fe,0x623140dd,0xc3ebe030}},	//   _رزایی_, _akafuful, _parkview_, _yetti_,
   {{0x9f29f284,0xcbe9f25a,0xa76d1264,0xe95a7247}},	//   _germanic_, _germanio_, _اليأس_, _birlikle,
   {{0xf2904266,0xab18c503,0x59a34218,0xe25a6684}},	//   _kamau_, _проприет, _limistéa, _qulla_,
   {{0x7290408f,0x1f3500de,0x42020244,0xe3560083}},	//   _camau_, _suportar_, _pusiri_, _accedir_,
   {{0x13a48339,0xa394c101,0x22a771a5,0x5cbc50b1}},	//   _redakcij, _asosye_, _shabba_, _dabadeed_,
   {{0xf2e1a2c2,0x465331e2,0x42da747e,0x123171dd}},	//   _kolovoz_, _пурра_, _arrens_, _daumaka_,
   {{0x637f8294,0x6f243031,0x0b87c121,0x52912309}},	//   _hahaaaa_, _ውክፐድያ_, _redigeer, _biyaj_,
   {{0x0200b1fb,0x9d56052e,0x822b3175,0x327e613e}},	//   _andika_, _लैंगिक_, _akimile_, _opony_,
   {{0x920250d9,0xf884300b,0x83eb8258,0x03f9b30a}},	//   _botika_, _sanilliu, _gerth_, _livusi_,
   {{0x7604815f,0xa2d9820d,0x3c38422e,0xcdb7b104}},	//   _aallatqi, _arren_, _breisgau_, _vivienda,
   {{0x6226717a,0xd3f8b0fb,0x5f3fa2af,0x039401c3}},	// [2080] _verkar_, _yaduta_, _aroganan, _coise_,
   {{0x630df2bf,0x48754319,0x6c590263,0xf5d1d212}},	//   _abibona_, _mrnicegu, _консерти_, _کرهڼې_,
   {{0xb20250d9,0xd3eb8007,0x73ebe03c,0x002db0dc}},	//   _totika_, _kerti_, _tetti_, _الاقاسىن_,
   {{0x785d751d,0x5290b198,0xbc74f026,0xec5d929d}},	//   _شیوعی_, _dicas_, _rubriek_, _sintrum_,
   {{0xfe494248,0x730614fb,0x8b1fc0b1,0xdbdf41eb}},	//   _ባህግኹም_, _disokong_, _ramadaan_, _alleguer,
   {{0xa9f892aa,0xa983a214,0x2d779287,0xbdefd10e}},	//   _sahirana_, _бомбасы_, _файлаў_, _studiowa,
   {{0xa2489266,0xa387f5ba,0x43f5204c,0xe26e70c6}},	//   _maama_, _vyura_, _ابوذر_, _bosome_,
   {{0xf39401a0,0xc212b055,0xb53bc0d2,0x18cd52cb}},	//   _boise_, _pochi_, _sabadell_, _نقشبندي_,
   {{0x429093e6,0x2301c177,0xd200c0c8,0xab87b288}},	//   _pakari_, _afwargi_, _aplink_, _равнақи_,
   {{0x0a350405,0xe2909246,0xdd0c8394,0xa104c0e9}},	//   _straitéi, _lakapi_, _jallallt_, _адержава_,
   {{0x2290b23f,0x427ae652,0x925a6050,0x64d79141}},	//   _picat_, _innstill, _nullo_, _даваны_,
   {{0x7290311b,0x62d863c8,0x0212b2fa,0x80c6f0f7}},	//   _člana_, _azmubawy_, _tochi_, _中国新闻社_,
   {{0x346225b8,0x2d14617a,0x1a61600b,0x6290b20e}},	//   _stredisk, _মিডিয়াৰ_, _anillats, _ficar_,
   {{0x020020b2,0xad17c13f,0xb8b9216e,0xd25a6239}},	//   _askiv_, _violence_, _наставил, _bullo_,
   {{0xadc3921e,0xe7add0db,0x556ff11b,0x6ed3e20e}},	//   _disiarka, _премияһы_, _posvetio_, _дефинити,
   {{0x92919395,0x49ecc12c,0x62ad30dc,0x2046e1ba}},	//   _bisaa_, _anyiketa_, _ئلدام_, _altrimen,
   {{0x936900d2,0x007e508b,0x8fbfb1b5,0x6d9f3143}},	// [2090] _بىيلىگ_, _مسافرت_, _قوشقار_, _akangisa,
   {{0x230e034e,0x9932d096,0x464f40c6,0x6b07a13f}},	//   _ababona_, _رائٹر_, _korintof, _consumpt,
   {{0x329122e9,0xbc21a267,0xb2902120,0xce3743c9}},	//   _biyah_, _issiokwu_, _bakak_, _calamita,
   {{0x67e1f15e,0x4282904b,0x6de63264,0x95a40296}},	//   _konpromi, _boradagi_, _اعلنت_, _abasolek,
   {{0xe2e3746a,0x140660b3,0xf27ff3bb,0x49f0c3a4}},	//   _neminye_, _автобусл, _apuna_, _sanguine,
   {{0xa37d4301,0x6266739e,0x39b7c31f,0x9dce1251}},	//   _zdravie_, _ajanupax_, _bandeira_, _сител_,
   {{0xe2904003,0x3cfdf009,0x12d98083,0xe959b33e}},	//   _samal_, _поскольк, _arreu_, _merozoit,
   {{0x5ec3a4df,0x69c4017d,0x526c72e9,0x781871ba}},	//   _christus_, _moderaat, _benon_, _лицензир,
   {{0x00de7248,0xb2ebd18b,0x8e4ec296,0xd25b4041}},	//   _ሕብረትሰብ_, _saindur_, _панду_, _ecelwe_,
   {{0x7bf5c264,0x7396630a,0xb304e3fc,0xf2d98177}},	//   _يواجه_, _brusse_, _allowing_, _bayewa_,
   {{0xc27a80af,0x92cae026,0x9f27d003,0x3b218161}},	//   _氏名又は名称_, _meiden_, _प्रजहि_, _aisafamb,
   {{0xb5651061,0xf287f12c,0x334452a9,0x11289272}},	//   _انساني_, _atekiwe_, _tabelle_, _autoritá_,
   {{0xcd523078,0xf9c71410,0x22c8402a,0x71288180}},	//   _ههههه_, _барада_, _deposed_, _発明の名称_,
   {{0xeae3c21c,0xdd8964c7,0xcbf7509a,0xe291f316}},	//   _ikkuntat, _iskopava, _قۇلاققا_, _anuat_,
   {{0x628e3276,0x426c708d,0x6a65c0f7,0xc3f8d289}},	//   _اصولن_, _aenon_, _有难题就提问_, _breur_,
   {{0x8c5d215e,0x03f461d4,0xaf27e0d8,0xb3f8d083}},	//   _bertako_, _vittus_, _bhernara, _preus_,
   {{0x1a851352,0x2ab5e4ec,0x9a259053,0x3f20d0d7}},	// [20a0] _سویده_, _herkesin_, _verpacku, _ителергә_,
   {{0xe4335049,0x8959d009,0xabc8140d,0x4201f3ea}},	//   _terceiro_, _ребенок_, _یوسفنٕس_, _adziwe_,
   {{0x42902076,0x13940266,0x8a6c2171,0x953c60f4}},	//   _makai_, _alisi_, _kuimaris, _ﻣﺎﺗﯩﺮﻳﺎﻟ,
   {{0x5dfc71a1,0xb0f662a1,0xf9f65381,0xf2257026}},	//   _objectwa, _menimbul, _retén_, _maakte_,
   {{0x0d9a333c,0xd15c22ca,0x4212b168,0x8356857c}},	//   _tomonida, _сурап_, _mocht_, _driften_,
   {{0x42f65063,0x827f4199,0xf29192ff,0x809360de}},	//   _экспертл, _brenin_, _bisaw_, _ابىيىرىڭ,
   {{0x52d5b1d0,0xc36a50f1,0x4016c121,0x2941c4e9}},	//   _italjet_, _bergens_, _उदेश्य_, _atellite,
   {{0x5212b010,0xf290421d,0x199541bf,0x32f044f4}},	//   _nocht_, _samam_, _екстерми, _folingi_,
   {{0xa907b08c,0x72904031,0xb70a20f7,0xdf047290}},	//   _redakteu, _mamak_, _社会消费品零售总, _महादेवी_,
   {{0x52919005,0xe224313c,0xeae51188,0x8e0e348f}},	//   _visai_, _аплан_, _wolleken_, _воскресн,
   {{0xe683b5f8,0x92d8c09f,0x1eada140,0x3391a042}},	//   _सोनार_, _selemo_, _kurkınıç, _akusesim,
   {{0x92f1e176,0xe29160fb,0x726c70c0,0xfecc55bd}},	//   _skripsi_, _jagati_, _tenon_, _papildus_,
   {{0xb212b521,0xd291f11c,0x3dbbf0df,0xc2904019}},	//   _docht_, _anuas_, _oughtbra, _samaj_,
   {{0x72e710c6,0xa3a34336,0x8f08b031,0x9f65c128}},	//   _akanman_, _alepea_, _የሚለዉን_, _disarmin,
   {{0xfe68a08b,0x82da5076,0xd6c2414c,0x9a50d496}},	//   _عبورتان_, _ietero_, _প্রীটি_, _mamerina_,
   {{0xfaba9140,0x7e72c66c,0xdcb9307f,0xddfe71f6}},	//   _talantlı_, _सुज्ञ_, _амаҭәа_, _ओल्मर्ट_,
   {{0xe5d8236f,0x3d87f381,0x04384143,0xb4ead1a2}},	// [20b0] _мәңге_, _мармара_, _alakelak, _исправле,
   {{0x8ef1a06a,0x0b9ba1ca,0x94d64024,0x33412288}},	//   _perkawin, _ژھێپِتھ_, _सुचिरं_, _ونماق_,
   {{0x22c5a28a,0x2212b29d,0xbafa425c,0xde73630f}},	//   _daglige_, _kocht_, _بىرنەشە_, _सार्थ_,
   {{0xeb29d012,0xb29ec0f6,0x2b07c0bf,0x5227e3d0}},	//   _آزادي_, _дивар_, _дилдан_, _парист_,
   {{0xb4d79083,0x73949057,0x346e3233,0x9e9ec0bb}},	//   _талабын_, _clasa_, _mandinik, _файлу_,
   {{0x8059d23c,0x66a3d0e9,0x429041d8,0x47812227}},	//   _редовно_, _анимациа, _mamah_, _마일리지존_,
   {{0xbc6b64b5,0x8d4bd040,0x1a0412e8,0x0b176083}},	//   _केन्या_, _bobaghlu_, _polasait, _etiquete,
   {{0xe185a2f8,0x4c7120e5,0x0a816587,0xcc38210e}},	//   _mataveil, _बाल्टी_, _impormas, _आशियाना_,
   {{0x420ec141,0xb2914199,0xf26c750a,0x0380617d}},	//   _манат_, _addasu_, _menom_, _suuren_,
   {{0x29d62013,0x9e4d700a,0xd37a713c,0xb3960225}},	//   _villalba_, _compared_, _астандар, _desses_,
   {{0x425a6036,0xede68251,0x2fcc93f1,0x0eb58048}},	//   _sulle_, _агровест, _fatiguer_, _prodavač,
   {{0x43f99039,0x7387837d,0xcd1c5224,0xf395230e}},	//   _arsut_, _asyraf_, _semorafe_, _kdysi_,
   {{0x3f3b706d,0xb6ccb0d0,0x13797185,0xa34b405a}},	//   _esigaben, _pulaarni, _karataa_, _اربدار_,
   {{0xc355219a,0x420261ab,0x82d8c292,0xf2aa4031}},	//   _calendr_, _korina_, _teleko_, _አፈጉባኤ_,
   {{0xac825028,0x39ee0222,0xfc09e14a,0xcb07c01a}},	//   _loveland_, _borgarst, _aroppaa_, _билебиз_,
   {{0xca8303c1,0x0a192463,0xd290f2b1,0x2378e004}},	//   _familjen_, _terciope, _angaz_, _jalaran_,
   {{0x6a57b1ca,0xbccc70c7,0xe37b9353,0xd62e34e9}},	// [20c0] _دُژیۆت_, _پیونت_, _dolazim_, _encoderw,
   {{0x6290428c,0x23106319,0xdc969105,0x15030072}},	//   _namai_, _gruzia_, _ישראלדיג, _sastojao_,
   {{0xc2d9f3a4,0xbf271182,0x2a0bb161,0xcbe0f2c6}},	//   _autem_, _प्रकुर्व, _achatuma_, _disesper,
   {{0xba3f12d1,0xa2ca0387,0x14d7a0f8,0x6411a048}},	//   _رموده_, _agidi_, _каманың_, _službě_,
   {{0x238c5161,0xa2da04a2,0x32904039,0x79e01272}},	//   _frazier_, _lisesi_, _kamai_, _maculatu,
   {{0x6201f241,0x92e95040,0xcee84640,0x79ae30bd}},	//   _vizita_, _biwihha_, _amakaman, _wonderwe,
   {{0x8dffe328,0x2300218b,0x601180e5,0xa05361ce}},	//   _aggegota, _bajanai_, _रवीन्द्र_, _geoscien,
   {{0xa80691d9,0xb96dd0c9,0x23fe90c9,0x7256f116}},	//   _арттыру_, _означає_, _учасника, _मानेले_,
   {{0x67fd2248,0x404082d4,0x3ecb82d4,0xb530703d}},	//   _ማሕለኻታት_, _akitikun, _allinyan, _قراردادي_,
   {{0x5061821d,0xefe3d5b1,0xf2008328,0x5d3b7018}},	//   _दिवसे_, _كارتا_, _kihimi_, _medicale_,
   {{0xa47320f7,0x89d990ec,0xc2fc961b,0x52da517c}},	//   _网站或个人未经本, _bisedime, _nwagi_, _vetero_,
   {{0x3c59f06a,0x01c1b0e5,0xc83901bf,0xa2bb328b}},	//   _listrik_, _नन्ही_, _политикэ_, _schelte_,
   {{0x839543a3,0x239464f7,0x2f4d6086,0xa25210f6}},	//   _presne_, _close_, _clustrma, _дүшүнишм,
   {{0x8379f13c,0x33f4731f,0xc286914d,0xb2489185}},	//   _hilario_, _mortos_, _seekord_, _nyame_,
   {{0x520e11ea,0xaea981c7,0x7b4d0252,0x97a1618e}},	//   _қарап_, _филиалда, _ирандагы_, _alleborg,
   {{0xe30e4685,0xe27ee2e2,0x7829f009,0x42d980dc}},	//   _estamos_, _osinon_, _сервера_, _dures_,
   {{0x92d801b8,0x4290f0c0,0xa8f6a2a7,0xd1cc1105}},	// [20d0] _chieu_, _aigas_, _لایتهد_, _אלקהאל_,
   {{0x40383009,0xdfc44013,0xaae490e5,0x42025049}},	//   _особенно_, _черкесск, _पदार्थो_, _antiga_,
   {{0x2f5cb2d9,0x5d3c4129,0xdc51f076,0x13a3723f}},	//   _adapaade_, _kabinett_, _ahituba_, _chaple_,
   {{0xb2d9f235,0x26a8f2bd,0xcb00a5e6,0xa356801d}},	//   _putem_, _системаһ, _división_, _stiffen_,
   {{0x1248d402,0x7417c58b,0x5c4a1287,0xc2ca6145}},	//   _baema_, _kudingek, _дасканал, _igodo_,
   {{0x1e32c018,0x0e5311d9,0x002d60eb,0xb21323cc}},	//   _скиде_, _құрған_, _conforto, _мормоны_,
   {{0xc2910316,0x177110c7,0x4fb8343f,0x1f3541d8}},	//   _maaari_, _تلپتال_, _naplánov, _kasundaa,
   {{0xd2d8f1ce,0x8b02d44b,0xb2d984dd,0xd266325d}},	//   _chieti_, _torsdage, _lurer_, _bafungol,
   {{0x12919338,0xf28c5041,0xd14a7124,0x9e4ac009}},	//   _nisam_, _مقاماتو_, _australo, _статей_,
   {{0x82f540d3,0xa25a6152,0x41795233,0x15e41105}},	//   _turnier_, _mulla_, _andininy_, _לטובֿת_,
   {{0x79f61030,0xf7eb7196,0xb27a0129,0x89fa01ac}},	//   _روسیه_, _zumarrag, _afrikani_, _afrikana_,
   {{0xf2ce0438,0x77bdb2ae,0x02e600cc,0x32cac0a2}},	//   _piloted_, _खड़गपुर_, _granada_, _abelusi_,
   {{0xf8ea629a,0x8378e06e,0xd14012bd,0x0d9bd212}},	//   _mengandu, _balapan_, _babelael, _abangeva,
   {{0xb43e115e,0x5b1902c0,0xed689248,0xeae23360}},	//   _гарна_, _nasaraan_, _ብብርሃን_, _کھویا_,
   {{0x2291d039,0x5055313f,0xf2eae40d,0xf9c5121c}},	//   _aiwai_, _ואקטואלי, _شکارى۪ن_, _valletta_,
   {{0x4dd2d043,0xddc32293,0xd2fc410e,0x329111c3}},	//   _стиле_, _inziraka, _gabinet_, _bocain_,
   {{0xa1880052,0x6e38e316,0x106d60f7,0x726c722f}},	// [20e0] _festivāl, _karapata, _生命的艳遇狂奔_, _odnos_,
   {{0x5291d07d,0x51bef3f1,0x0432414c,0xb200901d}},	//   _diwai_, _babetaká_, _বোলিং_, _oraiy_,
   {{0xf37840e5,0xc3f99148,0xa2504085,0xb282d030}},	//   _badania_, _husus_, _লাঙ্গল_, _کنفرانسی_,
   {{0xa950f25d,0x914e03a5,0x430e0293,0x6ec8e10e}},	//   _wakorint, _abafanel, _ababana_, _polegają,
   {{0x0c056375,0x3e33915f,0x8d1840d2,0xd428a0fc}},	//   _экология, _halummaq, _تورنادو_, _dikamano_,
   {{0xd29020c1,0xc249f012,0x4f5b1110,0x228e1025}},	//   _lakas_, _ngumu_, _seaplane_, _alakoro_,
   {{0xc2de520f,0x12912402,0x2356429f,0xf8069049}},	//   _dilində_, _siyau_, _adefisa_, _rápidas_,
   {{0x899d515d,0x24f7a35b,0x4a31b1a2,0x6c067105}},	//   _ويرايش_, _методики_, _активный_, _שבֿטים_,
   {{0xf25a62c0,0x32d98102,0xfe38e394,0xda083388}},	//   _julli_, _turer_, _saraqata, _بڵیین_,
   {{0xf3ebe036,0xcc6fa293,0x52fa2034,0x93959437}},	//   _letti_, _akiriho_, _bacheca_, _bryskt_,
   {{0x92d802e4,0x3ceed0d6,0x5290219e,0x926cf613}},	//   _thiet_, _среди_, _rakau_, _schonn_,
   {{0x73f91284,0xc200f395,0xf665d009,0x62902005}},	//   _seculo_, _hihiaa_, _сферы_, _sakau_,
   {{0x6842e056,0x69ead0f5,0x1290b018,0x03f9918b}},	//   _ditlwaed, _vergange, _bacau_, _musur_,
   {{0x61411264,0x3291d19e,0xbb7660de,0x4c339282}},	//   _الأظافر_, _riwai_, _بۇككۅن_, _סאפיע_,
   {{0x0212d233,0x6c12d076,0x111313c2,0xab192421}},	//   _alohan_, _elepani_, _abakamul, _baqataan_,
   {{0xa212b431,0xc2d890cb,0x0290d258,0x5ce1a269}},	//   _fiche_, _chael_, _allaat_, _snowspor,
   {{0x627ff018,0x13eae06e,0x27a6b2b6,0x4f3e014f}},	// [20f0] _spune_, _rentan_, _mantegni, _क्रियेत_,
   {{0xefc3a431,0x52d730bf,0xad8a72d2,0xbf301093}},	//   _afficher_, _ayollar_, _gemeinde_, _dipergun,
   {{0xb9da9219,0x6b77b140,0xbe7280fb,0xe1749218}},	//   _artfisye, _урманын_, _दुष्ट_, _انفراد_,
   {{0x19f20443,0xcec71221,0x3f85a251,0xa26cf0ac}},	//   _molienda_, _azizange_, _евроинте, _schoon_,
   {{0xa24a046e,0x43806152,0xd2d8d09c,0x30538124}},	//   _kasmas_, _suurin_, _sheek_, _seiscien,
   {{0x7309a059,0x2b6fa0be,0x4347237e,0xd26e7425}},	//   _በተፋጠነ_, _momentin_, _rumelwa_, _bosole_,
   {{0x939492a5,0xe29020f9,0x6d6af248,0x82646437}},	//   _alase_, _nakar_, _ብፍርሃት_, _titlar_,
   {{0xc200c062,0x1c2d4054,0x93c2c1ba,0x891b9065}},	//   _taliga_, _masallac, _оказа_, _ספירס_,
   {{0x5597d009,0x50a7c10f,0xe9db23fb,0x56992358}},	//   _каждого_, _معجزہ_, _banebryt, _сериала_,
   {{0x28685012,0x026cc238,0x111b51c5,0xd2d98020}},	//   _توانائي_, _redon_, _bestepön_, _egallay_,
   {{0x3386b58f,0x0642f03d,0x53f990d4,0x4d64b121}},	//   _modrim_, _akholelw, _busur_, _उद्वीप्त_,
   {{0xc200a12b,0xb2b9e097,0xd2902138,0x040f5175}},	//   _jijiji_, _endelig_, _makar_, _antretan_,
   {{0xb3173294,0x1ed060fb,0x334921c5,0xefd800d0}},	//   _concile_, _शिक्षामह, _bukemav_, _naonaiko,
   {{0xb2d830f0,0x565e1043,0x829021ab,0x42fce0c1}},	//   _samedi_, _фирмы_, _wakas_, _pangit_,
   {{0xac23514f,0x92f09025,0x825ad32e,0x034e2207}},	//   _सुरेश्वर, _agbinni_, _hallur_, _giderek_,
   {{0x62be511b,0x348c30ac,0xa348410f,0x92a7021f}},	//   _празници_, _예정입니다_, _feletti_, _ngabet_,
   {{0x597243af,0x06c951ed,0x237fa047,0x829082b8}},	// [2100] _ndangdae, _профильн, _wajamaa_, _behaal_,
   {{0x834c206a,0xa431f057,0x6f73a290,0x834860e7}},	//   _मंजूर_, _кларинет_, _समर्थकों_, _henegei_,
   {{0x9fc03192,0x12cd0056,0xb22c22fd,0xa7b5103f}},	//   _акциялар_, _matlalo_, _قیبله_, _सत्यापित_,
   {{0x63792148,0x52bca408,0x137a0115,0x7a0410f6}},	//   _babasan_, _jendral_, _agradan_, _беденими,
   {{0x349c31f0,0xaf4f0506,0x1a33f124,0xca8a3118}},	//   _яһаны_, _spesjale_, _angakuér, _dibisyon_,
   {{0xe2630336,0x0303a4b0,0xe25a6121,0x79805076}},	//   _tokolahi_, _ostavku_, _mullu_, _galilaia_,
   {{0xc29551b4,0xda08a2aa,0x02919040,0x0ae7514c}},	//   _probleem, _ankapobe, _bisah_, _মোশারফ_,
   {{0x8b6b8011,0x0b82719e,0xa27c4248,0xa347341a}},	//   _justicia_, _tokotoko_, _ድኽመታትን_, _pendler_,
   {{0xde04d591,0xd26cc07d,0xfa392252,0xbb55f1f5}},	//   _عبدالهاد, _aedol_, _беребиз_, _rögtön_,
   {{0xe2904123,0xbf282083,0x3d32b287,0xd378801f}},	//   _lamas_, _expressa, _фундатар_, _yanayin_,
   {{0x0c7f90cf,0x26fd6350,0xe2a6e30d,0xbf1db3ab}},	//   _mabuhay_, _nakupová, _bribed_, _nafukova,
   {{0xc26c50ea,0x029042ab,0xd300501f,0xb2d883f7}},	//   _celou_, _namas_, _malamai_, _ankenn_,
   {{0xd3e4b30e,0xc249025d,0x50f022a4,0xcd6f417d}},	//   _dětem_, _asambi_, _लखनवी_, _valmenta,
   {{0x2e50a1b3,0x8291d22e,0xc8e2722d,0xa13fb26e}},	//   _cruciate_, _liwat_, _overtuig, _kretingo,
   {{0x4212b015,0x61289096,0x5be430d7,0xee173264}},	//   _ancha_, _beavatko, _lagerlar, _ardeagla,
   {{0x626d5224,0x1e9fc169,0x725a6032,0xd37b329f}},	//   _digole_, _bestemmt_, _fullu_, _saleté_,
   {{0x651723ef,0x6290406e,0xb93450fb,0xa291723e}},	// [2110] _consulto_, _camat_, _agamakat, _awaase_,
   {{0xd2f1a2cc,0x24384313,0x9290201f,0x5e086202}},	//   _मसूरी_, _ilakolak, _yakar_, _ngadagoa,
   {{0x92d8d0b2,0xfc18f0ff,0x53949289,0xd30cd374}},	//   _dheev_, _verander, _glask_, _dynamos_,
   {{0xff3ca3aa,0xbd607352,0x62902005,0x12caf03d}},	//   _perusaha, _باسیان_, _vakar_, _abalusi_,
   {{0x2290b004,0x160770c0,0x7290201f,0x425a6177}},	//   _macak_, _champoli, _wakar_, _cullu_,
   {{0x93949570,0xb20200ef,0xedae8188,0x22ca8221}},	//   _klask_, _kusini_, _wonnerba, _abalobi_,
   {{0xc9e3019e,0x4bb1254b,0xc8eab176,0x1993c096}},	//   _tokomaha_, _conjunto_, _برقراری_, _کھڑکی_,
   {{0xc3f8113b,0xe29190b3,0x0b5be24a,0xdc073115}},	//   _akhut_, _xisap_, _elkenien_, _apareiss,
   {{0x12fcd332,0xa9c721b9,0xe832d085,0xb201f009}},	//   _hangee_, _барасаҡ_, _মঞ্চে_, _onzima_,
   {{0x02902197,0x8200c141,0xe3f8a3c8,0xd676a18c}},	//   _pakar_, _bilimi_, _bibuy_, _kuthathw,
   {{0xf290418b,0xc37a0137,0x43a9c4b5,0x624970f3}},	//   _namar_, _larawan_, _پٲغام_, _dramma_,
   {{0x26c31412,0x64e2e14c,0xfea321a1,0x6200d300}},	//   _jilawayi, _আলতাফ_, _upplemen, _greiz_,
   {{0xdc6f60e4,0xe2d8b301,0xe676a31b,0xf2c5e1fd}},	//   _patrona_, _chcem_, _luthathw, _gazetesi_,
   {{0xeaf1421c,0x5b45e131,0x8ed9932b,0xe2132393}},	//   _laburist, _उलाढाल_, _phensiyn, _dichas_,
   {{0x8dc1e0d0,0xf24891be,0xe278618e,0x2e7c641e}},	//   _humilika, _vyama_, _jounal_, _पदस्थ_,
   {{0xd319044a,0x8db001b8,0x029021fc,0xcade4033}},	//   _magiging_, _asiasoft_, _bakap_, _britalit,
   {{0x1368001a,0x12902304,0x93f95171,0xcea6a0b3}},	// [2120] _ئىنگىلىس, _cakap_, _tafuta_, _millionn,
   {{0x8200f0b8,0x47c251d9,0xc3a37076,0x83640413}},	//   _sahifa_, _сессиясы, _alapia_, _abagula_,
   {{0x6ddf6218,0xc2d96293,0x029121d8,0x9282f223}},	//   _اجتماعية_, _kigeli_, _sayah_, _dhahiri_,
   {{0x426c5234,0x728c03ea,0x9eafc2aa,0x2200c476}},	//   _celom_, _adakana_, _fokontan, _galiza_,
   {{0xc84d1565,0x9afaf3a1,0xfc65b21c,0x35561180}},	//   _partidos_, _abagerus, _adattat_, _しばらく経ってか,
   {{0xc06a0120,0x137cb07b,0x9937932f,0xfb8233fa}},	//   _adapalen, _barayee_, _хайбар_, _akanorar,
   {{0x6d8742f8,0x42912004,0xb1628036,0x89c542f6}},	//   _kerekere_, _wayah_, _operazio, _itsembat,
   {{0x97dd22ab,0x3da47048,0xdd1b200f,0x03f4610f}},	//   _aptarnav, _nesouhla, _abonnere_, _tartom_,
   {{0xb20091be,0x1290b005,0x620271d7,0x85202418}},	//   _majina_, _sudaro_, _adrift_, _abangach,
   {{0xe57dd0b9,0x1ee6e38b,0xbd700063,0x6ffc635c}},	//   _мазмунда_, _hochimin, _ahamiyat_, _barkeelo,
   {{0xf23b7493,0xeae930db,0x8c65547f,0x4d9c0216}},	//   _nollaig_, _донья_, _paquete_, _capogrup,
   {{0xebba7009,0x2edc50de,0x6f657015,0x8d8dc296}},	//   _предназн, _racistes_, _tawantin, _abalinya,
   {{0x93f9b369,0xc21c7028,0x69c100a0,0x726c557f}},	//   _esque_, _washoe_, _capegate, _velom_,
   {{0x529041e7,0x5200c1ca,0x2fd94180,0xbbe843d9}},	//   _samas_, _kaliya_, _お支払いについて_, _diboroto_,
   {{0xaf766275,0xbeb133e2,0x43eae24e,0x1d442686}},	//   _инглизчә_, _porovnan, _benten_, _utspring_,
   {{0x7cda83ab,0xe200c011,0xe2ca6327,0xd356e0ff}},	//   _rekreačn, _caliza_, _agodi_, _stoffen_,
   {{0xb93a206a,0xd2cae36b,0xeae010d9,0x0301d244}},	// [2130] _अमेरिकेच, _beiden_, _accusate, _pitampi_,
   {{0x9ff1e2d9,0x32b4727a,0x326e53c1,0x03cf0115}},	//   _turkeyfo, _konca_, _datorn_, _clavar_,
   {{0x73eae368,0xc2646426,0xd39494f4,0x1200c0f8}},	//   _tenten_, _titler_, _alasi_, _galiya_,
   {{0x894f228a,0x9f4f00bd,0x42d9c29d,0x8fe80199}},	//   _samlinge, _spesiale_, _suver_, _technego,
   {{0x4290422e,0x1a7cf1e7,0xbee0b264,0x92a0b264}},	//   _samar_, _prantsus, _الآتية_, _الأئمة_,
   {{0xa49041d8,0x14f1614f,0xe15c317d,0x385a000a}},	//   _ngagunak, _प्रथमोऽध, _картинка_, _bedrooms_,
   {{0x8224b1e4,0x29796081,0x62d8d151,0xc71f5358}},	//   _kiekie_, _aalisart, _nkeeg_, _спутнико,
   {{0x220260a1,0xbad8f054,0x2486c48f,0xb50aa3f8}},	//   _girisa_, _kwamitin_, _имено_, _seguindo_,
   {{0x01c840b3,0x3dc8e030,0x0226007d,0xd2cdc23c}},	//   _брюссель, _پغانه_, _masket_, _износа_,
   {{0x7c72a13f,0xf3b0e12a,0x1c2275a7,0x22b280e4}},	//   _torrent_, _alique_, _chargé_, _kondann_,
   {{0x74292411,0x8317f47b,0x4202500f,0x1a0f423b}},	//   _tempatan_, _akuzi_, _optisk_, _butakoca_,
   {{0x52d6013f,0x6c9842a7,0x9383a0c8,0x53957005}},	//   _ליסינג_, _مخلصلریگ, _sutrikim, _prasme_,
   {{0xa290f0fb,0xf3b113ab,0x82ca011c,0x72e8c262}},	//   _jagat_, _personál, _faide_, _imigambi_,
   {{0xebd6c5b1,0x339400d7,0x0319044a,0xa84a1031}},	//   _رومانتىك_, _poisk_, _pagiging_, _የሚሸፍን_,
   {{0x1db94271,0x82d9f0f5,0x0b2c20ac,0xb394d18d}},	//   _interiér_, _gutes_, _찾아오시는_, _alese_,
   {{0x1212b0ef,0xc26c73ab,0xc290f1ab,0xc2cae084}},	//   _picha_, _jenom_, _tagal_, _adidun_,
   {{0x32d6426c,0xf6809499,0xf2d8d0b2,0xbe9ec0e9}},	// [2140] _žalost_, _विदाई_, _cheem_, _раиль_,
   {{0x23f463c9,0xca40d13c,0xf29125a8,0x427f70c7}},	//   _partem_, _андир_, _sayaw_, _maanso_,
   {{0xc99d30d7,0xa34eb15c,0x316561a1,0x7c0a33be}},	//   _балык_, _komesch_, _ottombay_, _включая_,
   {{0xa379537d,0xae51f261,0x726e60ff,0xc2026121}},	//   _hadapan_, _sincères_, _stroom_, _pirita_,
   {{0xc39403e8,0xd2910406,0x0157c116,0x8379717e}},	//   _coisa_, _arbaro_, _पल्लवे_, _barataa_,
   {{0xb26d1101,0xa7f60124,0x1f5de1a1,0xeb38b050}},	//   _rezon_, _аквалифи, _adiation, _一上車就累癱呼呼,
   {{0xc3e36543,0x0343913e,0x786a255d,0xa7ec93a5}},	//   _सत्येन्द, _polecam_, _tapiissu, _namalung,
   {{0x038693db,0xb9800235,0x93f99322,0xb2c5a0be}},	//   _svare_, _echipame, _assuh_, _angleze_,
   {{0x12d960fe,0xa0ed0124,0x725e013a,0xa476916e}},	//   _bagera_, _transcul, _comtabil, _процеса_,
   {{0xa290f1fe,0x946a509a,0x7649f0f6,0x6e3792db}},	//   _ragal_, _билгинин, _дөвүрине_, _меселеси_,
   {{0xd2d9f176,0xe2ee901f,0xe7e870f6,0x71dc0214}},	//   _muter_, _kwanaki_, _аллащлап, _ءتۇندى_,
   {{0x926c71cd,0x8290f26e,0xbe2881d9,0x6a09217d}},	//   _genom_, _pagal_, _كەلدىڭىز_, _говорить_,
   {{0x5d8f50cf,0x72bf31f3,0x101383c1,0x31e9920e}},	//   _kailanga, _لمحات_, _landskro, _заборава,
   {{0x13959307,0x29e23072,0x5381136b,0x62ca600e}},	//   _desse_, _istorija_, _prozent_, _ekoloji_,
   {{0x64a3815e,0x06c8a0ac,0x3afeb365,0x4d5f35c7}},	//   _агентлаг_, _반송비용은_, _bagonoun_, _वीरभद्र_,
   {{0xb3a91311,0x12d9f027,0xc7129155,0x2b02d0cd}},	//   _янында_, _auter_, _достиға_, _forslage,
   {{0xff9a34a6,0xf2ba831b,0x7cf8d022,0x929ed05b}},	// [2150] _भक्तिमय_, _ewadini_, _транзитт, _امامه_,
   {{0x70f781ff,0x6200e100,0x454a9252,0x6f6db365}},	//   _मद्रास_, _kaniya_, _айландыр, _emarañat,
   {{0x2b97a1f7,0x53959414,0x92fcd39a,0x12d89280}},	//   _заманча_, _hesse_, _swego_, _bakeli_,
   {{0x1223d232,0x62ca9459,0x19f620aa,0xf7a86257}},	//   _ادارو_, _agadi_, _agashuru, _tiptroni,
   {{0x7212b0ef,0x529192ae,0xe779043f,0x3e389121}},	//   _hicho_, _lisas_, _hypotéky_, _kanalisa,
   {{0xc26c7033,0x693a0292,0x42016144,0xe3ea32cd}},	//   _zenom_, _харажатл, _angiwo_, _alltag_,
   {{0xf52a3033,0xef5593c9,0x9212b012,0xe35be1fa}},	//   _aspirasy, _singulos_, _jicho_, _hungasa_,
   {{0x3212b305,0x038330d1,0x62e5d2e5,0x25a22428}},	//   _dicho_, _ariyexe_, _gelnica_, _peningum_,
   {{0xd06c8064,0x13cff3ab,0xbc68466a,0x33949084}},	//   _第二十四条_, _obuvi_, _patrón_, _alaso_,
   {{0x40a83198,0x1c6261c0,0x62b52133,0xf5821580}},	//   _контрола_, _réunis_, _prodeje_, _nyamesom_,
   {{0x1200c045,0x06b8429a,0xf2ef522e,0x7576307f}},	//   _balina_, _kemanusi, _baffin_, _быҭәба_,
   {{0xf242a06e,0x2c6192d4,0xb26ca3ce,0xbb1592eb}},	//   _जगाला_, _negrete_, _gebou_, _rapsodia_,
   {{0xd20e128c,0xedbc90a4,0xc3eae2c8,0x893e6138}},	//   _зараз_, _matabete_, _mentan_, _spomenut,
   {{0x743cd085,0xa40750e8,0x436c8041,0xbe389335}},	//   _মেশিন_, _देवदास_, _abagadi_, _canalisa,
   {{0xa23a1375,0x4b50621f,0xaa922041,0xf200b2dc}},	//   _министрд, _dolmetsc, _محافظه_, _tadina_,
   {{0xbc65116a,0x01f97026,0x025a614a,0xc0564584}},	//   _contact_, _스크랩하기_, _kulli_, _trenutak_,
   {{0x329121e6,0xa779030e,0x1c536127,0xf041123c}},	// [2160] _yayau_, _hypotéku_, _jiutasa_, _acquiren,
   {{0xc2014169,0x83f833dd,0xb2eeb266,0x4c5e50f7}},	//   _kreien_, _zemunu_, _anefee_, _蛮儿初遇天赐_,
   {{0x32fc910e,0xc2efb501,0x83f8c23b,0xa6d50369}},	//   _uwagi_, _zidinga_, _baluni_, _descriti,
   {{0xac61b170,0x23875281,0xf394d246,0x7c5c124a}},	//   _udarite_, _weerar_, _toese_, _bestean_,
   {{0x73cef27c,0x3e5620c9,0x1a737213,0x6248f018}},	//   _bliver_, _частин_, _qamaskta_, _primii_,
   {{0x3768b059,0x58f8526f,0x2394d0ee,0x926c84e0}},	//   _የባንኩን_, _lumangsu, _blesk_, _dakord_,
   {{0xd7cae17d,0x47096063,0x87a93276,0x0a0ae358}},	//   _opiskeli, _тарафида, _مقبري_, _opiskelu,
   {{0xb319d012,0xa29121d8,0x2a143005,0x22e76202}},	//   _ويران_, _hayam_, _negalima_, _ajengan_,
   {{0x5a7ca3ef,0x6202408d,0x4b1632ae,0xc29211c2}},	//   _teradata_, _aswiri_, _armastus, _ajpaku_,
   {{0xfae81311,0xc6ca1223,0xda7de115,0x6c25852f}},	//   _мумкинди, _kusababi, _borgesia_, _dažreiz_,
   {{0x839463a6,0x6c3aa124,0x127ff05c,0xa291900b}},	//   _hoose_, _ассоциат, _neznam_, _pisat_,
   {{0xfb0d03f1,0x4967b224,0x38636205,0x0f4d0143}},	//   _propheta_, _dipoloke, _atrociou, _prophete_,
   {{0xfa759124,0x2212b169,0xbf45614c,0x2a8d726d}},	//   _академиа, _sicho_, _চাইনিজ_, _bannales,
   {{0xead6a0d7,0x6db130a8,0x1eb13142,0x37b7112f}},	//   _protsent, _prostoru_, _prostore_, _ئاخشام_,
   {{0x3200c203,0x727a800c,0x1ded7119,0xf29191fa}},	//   _talina_, _silisili_, _kaajalla, _dayari_,
   {{0x62d9f3c7,0xb283f126,0xea5be1ab,0x7c854205}},	//   _usted_, _lishiri_, _pangarap_, _streaked_,
   {{0x52267240,0x7c0732b1,0x726ca0ee,0x2d0731df}},	// [2170] _merkir_, _restoras, _neboj_, _restorac,
   {{0xec127121,0xfac1d140,0x7c30c489,0x3212b0ee}},	//   _कृष्णपक्, _тәрбия_, _časopiso, _ticho_,
   {{0xce0d2193,0x4310e0ee,0x20281065,0x8fcc4033}},	//   _kundscha, _detaily_, _בעפולה_, _arbitrer_,
   {{0x827f4171,0x652781f8,0xf75d61a1,0x8471f004}},	//   _maeneo_, _napravio_, _emaining, _tontonan_,
   {{0x99b2a159,0x67c7c173,0x55c9101d,0x996e70f5}},	//   _انتظامیہ_, _кабири_, _zerbrech, _donnerst,
   {{0x96d9224b,0xa2a722ab,0x1d7b318c,0xef49517d}},	//   _bebasusw, _народаў_, _kwiminya, _helpotta,
   {{0xf3eae2b3,0xf2d9f2ca,0x3d3c3194,0xf7272007}},	//   _pantas_, _estem_, _polizist_, _کریسی_,
   {{0x3f63e131,0x03954687,0x8305c2d1,0xa84a4248}},	//   _प्रकल्पा, _nyeste_, _فورات_, _ዝዓብለሎ_,
   {{0x53786308,0xad8ed14c,0x7e00e2ad,0x8f68e08b}},	//   _muganga_, _অনুধাবন_, _marenata, _andadosn,
   {{0x438063ef,0x09f8e246,0x953d2466,0xf61ab0c7}},	//   _terram_, _taliaina_, _پيشاني_, _گرفتارس_,
   {{0x5d1c909e,0xf2b3f2b2,0x7c93e401,0x349c9367}},	//   _naročito_, _मजबुत_, _واشار_, _naročilo_,
   {{0x1d541418,0xa741e1ba,0xc37a70e3,0x5cc0f054}},	//   _апрел_, _основни_, _katawan_, _dukkansu_,
   {{0xc8db7199,0xf15c232f,0x55840105,0x42d8d08f}},	//   _cadeiryd, _рушан_, _זאפארט_, _deledu_,
   {{0x72b470a8,0x3f139126,0x1344b0e4,0x63f463ef}},	//   _konce_, _leithira, _ansekre_, _partim_,
   {{0x3e38d054,0x72c5f1ff,0x78430115,0x023f03f8}},	//   _majalisa, _क्रिस्टल_, _misticas_, _célula_,
   {{0xa47ac102,0xf386d299,0x9e15c369,0xda72024f}},	//   _промисло, _avere_, _trimmers_, _tamakkua_,
   {{0xf2129250,0xd29120d7,0xae38f213,0x2ead5214}},	// [2180] _unahi_, _mayak_, _maranita, _ءيشارات_,
   {{0xc9c2a585,0x920ec005,0xdefe4257,0xc4fa1438}},	//   _vozexpre, _тамах_, _yaralanı, _وفرمايل_,
   {{0xd2fcd26f,0xe291907e,0x67a86078,0x129133f9}},	//   _mangle_, _visar_, _chathaoi, _brokkar_,
   {{0xa249f2f8,0xb2024144,0x2b1a7031,0x3300a015}},	//   _sauma_, _kuwili_, _በማረሚያ_, _alcaldi_,
   {{0xa200f076,0x4230120c,0xee7f22a7,0x7fef70e5}},	//   _mahina_, _ikamuha_, _سیمیناری_, _जीवाश्म_,
   {{0x24281019,0xb2fce0f9,0xe2b54367,0x3d57c2eb}},	//   _דעילייט_, _longri_, _precej_, _далгеит_,
   {{0x6899a580,0xafc1b1df,0xe2e13131,0xcbfaf089}},	//   _ahobammɔ_, _principo, _करशील_, _abalorio_,
   {{0xa158c196,0xca31a124,0xa3485363,0x841640d2}},	//   _програмт, _бџьаршьҭ, _felelei_, _تاقمازا_,
   {{0x6b7d306a,0xf7045159,0x9dc181af,0xca85e10d}},	//   _terutama_, _منافقت_, _pirihima, _клубах_,
   {{0xad445043,0xee014163,0x0248948b,0xa99f31e2}},	//   _уникальн, _almendra, _gyama_, _abakhala_,
   {{0x42fcd039,0x27c843ce,0xc34851e4,0x8201014a}},	//   _dangle_, _verteenw, _helelei_, _cabiya_,
   {{0x1b5371d4,0xf580d12e,0x9290b057,0xf3949395}},	//   _timmisar, _matematy, _macar_, _foase_,
   {{0xab4cd646,0xdf3a439a,0x0291d542,0x83eae2dc}},	//   _kwamaafr, _बेहिसाब_, _khwan_, _kantos_,
   {{0xe3fc30f4,0xc6af8009,0xcdfb8182,0x1efb821d}},	//   _ئاتەش_, _yokuleth, _abravãd_, _abravãt_,
   {{0x5ea4309a,0x6e4a107b,0x42d8d3ec,0xc9461060}},	//   _уларда_, _stratosp, _teledu_, _myelinat,
   {{0x6147c32f,0x52ab1304,0x12d9f2c1,0x31c671a6}},	//   _замина_, _gendang_, _istek_, _alamakom,
   {{0x82499481,0x6d5c5205,0xdecdc113,0x6a9c5335}},	// [2190] _basma_, _seaboard_, _ministrs_, _posiziun_,
   {{0x021c6308,0x226d8316,0xd2fca688,0xac02c064}},	//   _mather_, _meron_, _radices_, _confianc,
   {{0x8201f689,0x6c01c0da,0x9213733e,0x4a0d724c}},	//   _nizina_, _kingspor, _alahan_, _labaduba_,
   {{0x32902164,0xa772f06a,0xfe908315,0x852922fc}},	//   _lakay_, _प्राण्या, _aquitàni, _наступил,
   {{0x3675c17a,0xf54172a0,0xa2011018,0x0020f3b4}},	//   _অধিবেশনৰ_, _لیزاده_, _lucian_, _basenato,
   {{0x639494dd,0xb700026f,0x958612a7,0x6ea1f187}},	//   _plass_, _kabupaté, _بدنلره_, _adaliten,
   {{0xc3940218,0xa253a078,0x02b67155,0xd37fc184}},	//   _poist_, _feithicl, _ﺑﯘﺭﯗﻧﻘﻰ_, _ramatoa_,
   {{0x6198c0e5,0xad5f913f,0x3c5c108c,0x32dfc2a9}},	//   _हत्याकां, _תמשיך_, _bestaan_, _bekommt_,
   {{0xf53b1064,0xf2fc61de,0x2035d0f7,0x1c00b015}},	//   _内容读取中_, _stoga_, _推荐给好友_, _efesios_,
   {{0x01b64166,0x0e3b1020,0x1dbb6032,0x2b13017d}},	//   _permessi_, _ogrampra, _palestín, _ilmainen_,
   {{0xa19e317f,0x3395f4ff,0xdaa971e8,0x78fdb084}},	//   _вошингто, _adusi_, _гиперссы, _biotilẹr,
   {{0x2dc05063,0xae1313cc,0x22019321,0xcf7f60c8}},	//   _natijala, _босгож_, _assit_, _futbolas_,
   {{0xec93d030,0x29e7613f,0xa74510fb,0x46a7613f}},	//   _تاپار_, _performe, _सुविक्रा, _performi,
   {{0xae2631b6,0xec7ea30d,0x33f8c1cf,0x97dbc343}},	//   _སྐྱིའི_, _kunsill_, _stoung_, _alialiav,
   {{0xd27a8246,0x92851186,0xf510b28f,0x7ad531c8}},	//   _filifili_, _inshuro_, _apartado_, _restrict,
   {{0x03e61019,0x5577420d,0xb3fb830f,0xbf1280e5}},	//   _הייצונג_, _instalaz, _इतिहासात_, _समस्याएँ_,
   {{0x78c9c375,0xdd17b3c9,0xf316937a,0x7bb2c296}},	// [21a0] _балалард, _consular, _ndaza_, _abazazis,
   {{0xd37ca48b,0x2134c1b9,0x8d0c1085,0xfd193248}},	//   _abrante_, _алдынан_, _মাধ্যমেই_, _ትምኒተይ_,
   {{0xd200f137,0x02ee3039,0x3f09302f,0x31dea4f1}},	//   _pahina_, _dienkti_, _دغلته_, _burhantó_,
   {{0xe202604b,0x4378e2b7,0x0340411d,0x29cdb0de}},	//   _birida_, _malamin_, _adeedza_, _اۋتومات_,
   {{0x95f2e064,0x6c7c7250,0x3c40c10b,0x5413d08b}},	//   _获取免费代码_, _arasesa_, _aracanir, _قاصدک_,
   {{0x43005266,0xdbd741da,0xb3940121,0x157fc08b}},	//   _talamai_, _ntumbero_, _poiss_, _تصاحب_,
   {{0xa2ca6204,0xb291934d,0x41ad0171,0x1395c30e}},	//   _daode_, _basaw_, _بيابان_, _názoru_,
   {{0x72ca60e8,0x40e8a0c2,0xf24a6223,0x2be5b218}},	//   _zgody_, _видеоғыҙ, _muumba_, _paidreac,
   {{0xe2ebf088,0xb2893007,0x1f52b0b9,0x52803039}},	//   _mengenai_, _اقدار_, _бельгияд, _banshail,
   {{0x3a08b200,0xdc6b00e1,0xb26d825a,0xc75e5290}},	//   _apkasina_, _afluent_, _veron_, _कार्मिक_,
   {{0xf7c370e5,0xb0c620d0,0x829120b0,0xc212b012}},	//   _सुविधाओं_, _magligal, _sayap_, _licha_,
   {{0x91562022,0x89e23466,0xc461f146,0xe3b96227}},	//   _басына_, _ناچيز_, _digelark, _춘천지방검찰청_,
   {{0xbd29546e,0x9e4ec192,0xb552f1c7,0xa3e1b4b1}},	//   _antipope_, _малды_, _ەرەنقابى, _kharsati_,
   {{0x429040d7,0xd24a604a,0x0f3910a8,0x1c6241cd}},	//   _kamaz_, _kuumba_, _milionů_, _svarade_,
   {{0x5e9c21c5,0xb7c37231,0xcd41f00c,0x229190b3}},	//   _sanmarin, _सुविधाएं_, _aitalafu_, _yasaw_,
   {{0x3db4b3ef,0x0a4122cb,0xe9cdb5ee,0x04078262}},	//   _mariamya, _بخوبي_, _larealit, _ruzinduk,
   {{0x73ea70e9,0xa4a4a105,0x0a01503b,0xd202736f}},	// [21b0] _mante_, _נעווזלין_, _atisungu, _bosiyo_,
   {{0x4212b47b,0x1ece82b5,0x8345636f,0x023170a9}},	//   _dicha_, _dividers_, _rapelle_, _hormiga_,
   {{0xb517c1ea,0x4386d1c4,0x129ec1e2,0x6524a0b8}},	//   _миллий_, _exert_, _милал_, _буйруқ_,
   {{0x5e0301a1,0xe26e63d2,0xf7d7310f,0x7b3a62f4}},	//   _interpra, _throng_, _بازاروں_, _мандалго,
   {{0x329041ab,0x9ac8f063,0x7c62701f,0x149ef0ac}},	//   _kamay_, _маслаҳат, _mutumin_, _업그레이드_,
   {{0x5ef31121,0x3ee481c7,0x42fd4129,0xbfaec1e2}},	//   _अधिका_, _автоматт, _separati_, _макка_,
   {{0x19332223,0x5251c237,0x8394d4b4,0xc2f4907f}},	//   _واقعي_, _svetitel, _aposel_, _háicha_,
   {{0x4200c4be,0x9395f2b8,0x42d46186,0xee453127}},	//   _palica_, _keuse_, _bigomba_, _bolataga,
   {{0xd38ba043,0x84577022,0x0897230e,0x122660e5}},	//   _станет_, _футболда, _हेरफेर_, _अध्यक्षो,
   {{0x0381818a,0xb2b470ee,0x67f42057,0x19b30223}},	//   _prezent_, _konci_, _перверси, _عمارتن_,
   {{0x6290c0e7,0xdeafb141,0x71d47105,0x7f2702ac}},	//   _mulayo_, _birligin, _נאַקעט_, _بکێشن_,
   {{0xa290317d,0x52d12048,0xe34ef4de,0x37c8d12a}},	//   _samaan_, _motorem_, _tibetek_, _disprovi,
   {{0x78471263,0x1291246e,0xfc1d40e4,0xc909c008}},	//   _ватани_, _obyam_, _deerpals, _беладан_,
   {{0x90843004,0x04ecc085,0xc5bbc0c7,0x5f02d68a}},	//   _وظيفه_, _তিশার_, _bakaarah, _सिद्दीकी_,
   {{0x737aa2e2,0xbd14f030,0x48e6a277,0xb472804d}},	//   _kanaval_, _اعتبارین, _третата_, _cantuinn_,
   {{0x5557d381,0x2270724b,0x62d8d205,0x999d315e}},	//   _фролов_, _elungeni_, _cheet_, _ханын_,
   {{0x926c51bf,0x1e0302e9,0x4292700d,0x967ea10a}},	// [21c0] _celor_, _enterpra, _cosaan_, _لڳاتار_,
   {{0x8197d193,0x32d8a1db,0x42a47022,0x3ee7c200}},	//   _stealthy_, _visning_, _медиафай, _luphiwin,
   {{0x0746f01a,0xe392b37a,0x33eae2dc,0x6c2371c8}},	//   _алмаштыр, _akayesu_, _pantes_, _believed_,
   {{0x6059321e,0x8b4b945b,0xfb4aa285,0x17da8024}},	//   _persidan, _trattava_, _abatubwa_, _प्रकाशं_,
   {{0x0e4e639e,0xc290f007,0x298fc4ad,0xf2025233}},	//   _amparana, _magas_, _baakanye, _entina_,
   {{0x3291909b,0xd290923e,0x52015079,0xa2ca001d}},	//   _masat_, _abaas_, _difiki_, _gaide_,
   {{0x23160187,0x64b4417a,0xb29120b2,0x3104c496}},	//   _ndizo_, _ফিল্টাৰ_, _ibyam_, _hopitaly_,
   {{0x1c242075,0xf3a4205c,0x4acaf06a,0x57964082}},	//   _financir, _financij, _संवर्धन_, _beataspi,
   {{0x92db75fd,0xe8d8f0e5,0x5290e12d,0x43db7445}},	//   _komunity_, _निर्यातक_, _asiana_, _komuniti_,
   {{0xa290d39b,0x7796011b,0xe2cfc226,0x29f00304}},	//   _monate_, _predstav, _kancelář, _lazimnya_,
   {{0x42d9f007,0xcbb490e5,0x82d96047,0x38372009}},	//   _isten_, _संस्थानो, _magezi_, _заранее_,
   {{0xf37cd1c7,0x272523a8,0x59787345,0x4386d287}},	//   _الەۋمەتت, _soemsang, _valimist, _svoris_,
   {{0x526a120e,0x3290f13c,0xa386d321,0x6e39025d}},	//   _заборави, _dagas_, _tooruk_, _bafalisa,
   {{0xaed40113,0x63dce102,0xd929d2f3,0x6daa4015}},	//   _salidzin, _спостері, _северно_, _chinchip,
   {{0x7c56a24a,0x260300ae,0x3bae22e8,0x838700c3}},	//   _grutste_, _inflyasi, _aighneac, _dobrim_,
   {{0xd249450d,0x438740fd,0xe3946185,0xc65950bf}},	//   _tiempo_, _amerik_, _dooso_, _кадрларн,
   {{0x1d3d30a8,0x50762244,0xfa000489,0xa2da003a}},	// [21d0] _politice_, _atipirin, _dražba_, _anseki_,
   {{0x53f88224,0xc34062fe,0xc00c417d,0xd37c21cc}},	//   _bahumi_, _wogenda_, _партнеры_, _bijaše_,
   {{0x3290f2db,0x8df171e6,0x8a0121ab,0x322a12db}},	//   _sagat_, _striyaḥ_, _mahalaga_, _горап_,
   {{0x14292304,0x8131b2c2,0x42cf94ee,0x82139135}},	//   _jemputan_, _gledatel, _preotme_, _kishe_,
   {{0xa290f17a,0xd8f0c0b1,0xc857b11b,0x029190d7}},	//   _lagar_, _یُتھُے_, _културно, _yasau_,
   {{0x7394002e,0xe63a00eb,0xc0604121,0x19fa0148}},	//   _voisi_, _caritabi, _reisimin, _caritana_,
   {{0x329193c8,0xc9c8422d,0xe522c2f3,0x8c6ae01b}},	//   _dasam_, _verdiene, _свима_, _kartasy_,
   {{0x6951f1e7,0x43a0f06e,0xdaa9214c,0x631a2424}},	//   _kvalitee, _ठिकठिकाण, _ভিওআইপি_, _gisiling_,
   {{0x09b9c0e9,0x537860c0,0x4f3e50cc,0x126d6314}},	//   _objetiva_, _regarda_, _estrella, _धनुषा_,
   {{0xc3f9b3af,0x5a14646a,0x3da23214,0x9c75d04d}},	//   _danzgim_, _imibande, _ءاننڭ_, _bagradh_,
   {{0x53b4704b,0x22d8d334,0x2c5b50b2,0xa292028d}},	//   _دنمارک_, _nkees_, _nomtswv_, _pasati_,
   {{0x729194ec,0xe394932b,0x4900615e,0xfdd5a205}},	//   _yasal_, _flasu_, _barakald, _nightsha,
   {{0x73431009,0x3290f493,0x5290f225,0x8917f447}},	//   _города_, _eagar_, _vagas_, _другую_,
   {{0xb2e9823a,0x94d7f1b9,0xd51f70df,0xb26c70e4}},	//   _dienjat_, _сараның_, _econdary, _denor_,
   {{0xe201b19c,0x92ab90f7,0xbd0e8034,0x87db63ba}},	//   _davida_, _并不代表本站及其, _elettric, _komplici,
   {{0x7628e2d3,0x2da362c2,0x221c149b,0x39f4e381}},	//   _didiposi, _naprijed_, _bapher_, _manía_,
   {{0xa48641e6,0x32026293,0x82fcd225,0x3bc4101c}},	// [21e0] _संसारे_, _biriya_, _meninas_, _innováci,
   {{0x98d45065,0x57ec918c,0x4ffde27c,0xde4ec022}},	//   _ההתבגרות_, _yamalung, _folkesko, _санды_,
   {{0xd25ae196,0x72da1246,0xa5ae20f7,0xae57a370}},	//   _egilea_, _pepelo_, _规范性文件_, _akabange_,
   {{0xf3fa04f5,0x23f982f3,0x164ab403,0x99de7169}},	//   _gapura_, _okrug_, _abanesif, _profilbe,
   {{0x121c6086,0xa2020374,0x930fe034,0x89a10264}},	//   _cathar_, _musiki_, _bambino_, _التذاكر_,
   {{0x82018280,0xfceed13c,0x2248f207,0x9379122e}},	//   _miziki_, _броди_, _isimli_, _espanya_,
   {{0xc3eb960b,0xee158192,0x9f266124,0x13eae110}},	//   _texten_, _экологта, _alberzon, _bantas_,
   {{0x2dd2d0d6,0xe202016e,0xb2026181,0x92d9f123}},	//   _стали_, _rusiji_, _ziriya_, _butey_,
   {{0x431d70da,0xf2ff5329,0x33eae1c9,0x9356e3df}},	//   _nascita_, _masanori_, _dantas_, _proffen_,
   {{0xb277832f,0xd5a210bf,0x3067b52d,0xe29222df}},	//   _натоиҷи_, _امانتنی_, _pristupn, _faqasi_,
   {{0x804c2108,0x702e2315,0xa10430c9,0x39974022}},	//   _қурби_, _fondacio, _методичн, _процессі,
   {{0x5f6170e5,0x04864121,0x1bab2008,0x2dcec0ae}},	//   _छात्राओं_, _सुधारक_, _акылына_, _müraciət,
   {{0x727ed187,0xbd3a212e,0x217a210e,0xd379d406}},	//   _ubongo_, _napisane_, _napisany_, _demando_,
   {{0x726ca0ee,0x0291916b,0xe153b086,0x92fc1455}},	//   _sebou_, _qasam_, _chiefspl, _pamiers_,
   {{0x11f5d21a,0x7ed5b00b,0x330370c1,0x6b702024}},	//   _субота_, _kisitsin, _lumapit_, _anavaśeṣ,
   {{0x1200e1e0,0xb3870484,0x1f6170e5,0xb2927190}},	//   _veniam_, _avaris_, _छात्राएं_, _karaik_,
   {{0x3e7a80af,0xb469d225,0xf6af824b,0xe2d8d039}},	// [21f0] _アイコンの説明_, _годината_, _lokuleth, _buneng_,
   {{0x5af3a423,0x852df438,0x57b3b105,0xd03164a5}},	//   _betreffe, _amanyath, _האוסט_, _astemaak_,
   {{0x7e4f31c3,0x4650c0ac,0x030d005a,0x42ebb02a}},	//   _cheangla, _전자상거래_, _escales_, _fatness_,
   {{0x83f982a2,0x36bdd121,0xd2fe80d0,0x83565381}},	//   _ciruz_, _बस्ता_, _mikiyuq_, _crueles_,
   {{0xf709d01a,0x00e1f10e,0xb6c58026,0x81c670f4}},	//   _келишим_, _ewentual, _verschil_, _ﻣﯧﮭﻤﺎﻥ_,
   {{0x9290c1a3,0xbee41105,0x4ecc50c9,0x26175053}},	//   _mulalo_, _שניצלער_, _основном, _italieni,
   {{0xb2f3f312,0xc2ca0376,0xd200946e,0x623110d9}},	//   _sedikit_, _maida_, _npaim_, _crampon_,
   {{0x429122ee,0xa3fa6202,0xb0f47171,0x62d890d7}},	//   _mayar_, _sarupa_, _منصفاڻيو, _akaev_,
   {{0xd3949664,0x4eb263b5,0xb154d2bf,0xc3a803be}},	//   _vlast_, _modernos_, _amurongo, _системны,
   {{0x2f63f0ac,0x52ca0052,0xd712647e,0xe85d7043}},	//   _참고하시기_, _gaida_, _consequé, _mainittu,
   {{0xb849207f,0xf874310a,0xe9db92ea,0xe2912079}},	//   _азәымзар_, _آبهوا_, _referohe, _gayar_,
   {{0xd29072c8,0x2d5fa13f,0x2bdc5121,0x1ffe61d9}},	//   _sambandi_, _שמגיע_, _हरियर_, _подкасти,
   {{0xdbe99252,0x82dab68b,0xc29173fe,0x02ca02f5}},	//   _گۉلنۇر_, _anuncie_, _निरोगी_, _baida_,
   {{0x12026510,0x2b8f901d,0x5c1941f8,0x19fcc1e6}},	//   _kirina_, _zurückko, _mozgalic, _jayadrat,
   {{0xd2cb8430,0xb200b189,0x03a03007,0xc2a621f1}},	//   _meydan_, _radila_, _javasolj, _hambre_,
   {{0xf1c954a6,0x12acf225,0x926dc07d,0x63940166}},	//   _पद्मविभू, _карактер_, _devol_, _joist_,
   {{0x8dd4d007,0xeeba4031,0xccf2905d,0x42ca0171}},	// [2200] _technika, _ያገለገሉ_, _contonsc, _faida_,
   {{0xdc6fa185,0x140e9293,0xe7f8e06a,0xc433a14c}},	//   _ankrato_, _ubugingo_, _अग्निशमन_, _তাগিদ_,
   {{0x3ddcc264,0x039661bd,0x0ecbd177,0x02ea0118}},	//   _ملحوظ_, _brusle_, _arkitaan, _foriegn_,
   {{0x1deb5486,0x91e1f13b,0x43ea538a,0x222573c2}},	//   _municípi, _takoyaom, _aalto_, _abakol_,
   {{0xb4b15225,0x9290f0c7,0x730322e4,0x0e55c11c}},	//   _descriçã, _tagay_, _vinasat_, _صورته_,
   {{0xf201549b,0x2074d275,0x48fca308,0x839493d2}},	//   _safina_, _ئىسرائىل, _palamend, _blass_,
   {{0xdc74d29a,0x938d60f6,0x55613030,0x7d3a212e}},	//   _menulis_, _протесте_, _истисно_, _zapisane_,
   {{0xe9285252,0x36f49031,0x4cf631d4,0xeb6be272}},	//   _партияны, _መዋቅሮች_, _saattuar, _lettonia_,
   {{0xe56c517a,0x6200c2b7,0xe2c644ad,0x7e031078}},	//   _মানসম্পন, _halima_, _bareetsi_, _forbraío,
   {{0xd2d99101,0xa2027436,0x7b49c0e5,0xf3eae20e}},	//   _aksed_, _qariah_, _ईर्ष्या_, _edital_,
   {{0xb3866032,0x1643b28c,0x23c6d007,0x32025295}},	//   _hvort_, _susitiki, _معطلی_, _mitima_,
   {{0x426d80cb,0x19d4e0ca,0xefd450dd,0x024d061f}},	//   _efrog_, _विजयते_, _geantwoo, _aviñón_,
   {{0x1503d288,0xa8be524f,0xa29122ee,0x11ba410e}},	//   _مارجه_, _innersuu, _sayar_, _napisać_,
   {{0x9258424e,0x236e41d0,0x2ebbd2d8,0x22b52333}},	//   _otomotif_, _bioflex_, _kwesinye_, _prodaje_,
   {{0x5200c26e,0xdb23a0f0,0x24ad63c1,0x95d15267}},	//   _galima_, _supprime, _fullstän, _esichagh,
   {{0xb606115f,0x0200c148,0x62d9610a,0xcc30c41e}},	//   _aatlatqi, _salila_, _wageni_, _časopise,
   {{0xf200c09c,0xae793131,0x52fc6143,0x4808d351}},	// [2210] _aalima_, _अनुभूती_, _atogi_, _متحول_,
   {{0xe2ab146c,0x42fc30b2,0xed9722d2,0x937fa4fb}},	//   _hending_, _melikas_, _stellena, _didakwa_,
   {{0x122ac2ab,0xaf29f1c7,0x52c1c0a4,0xb2426155}},	//   _голас_, _герольд_, _apolosa_, _ﺑﻮﭘﺘﯘ_,
   {{0x4318e0cc,0xa35be2f6,0x3bf5910f,0x72919136}},	//   _উদ্যোগে_, _kangura_, _pontosab, _lasai_,
   {{0xf74b22d4,0x62917076,0xd30100fd,0xcecb71ca}},	//   _amazónic, _isaaka_, _mezanmi_, _aaminsan,
   {{0x3200f37f,0x22912244,0x5d68f132,0x59d0c0f6}},	//   _achira_, _mayap_, _конкомит_, _гепиң_,
   {{0x9fce931e,0x628d8123,0x44739115,0x5b5a009a}},	//   _awantiir_, _fonksyo_, _contenon_, _калламди,
   {{0x025ae308,0xa26de1d0,0xb29190b3,0xe386900a}},	//   _kailua_, _teton_, _yasap_, _aware_,
   {{0x2379050e,0x0236524a,0xd291d411,0x7a59f135}},	//   _dusanga_, _helje_, _tawau_, _perendia_,
   {{0xd290c29b,0x1dbea1af,0x83fcd1d9,0xa47e504e}},	//   _kulabo_, _rawakore_, _نالەت_, _genetiko_,
   {{0x8c90b626,0x439490ee,0x729220db,0x726641a2}},	//   _क्रोम_, _hlasy_, _baqapi_, _pienempi_,
   {{0xe2ca93b3,0x3e86c4c9,0x67b373c0,0x739490e5}},	//   _saada_, _график_, _belegwag, _klasy_,
   {{0xa200c291,0x752f41ba,0x0433008a,0x096d4038}},	//   _nalika_, _rispetto_, _abakuzuz, _basisdat,
   {{0x6f20768c,0x94730304,0xdc1d73e7,0x88258096}},	//   _mendukun, _pastikan_, _comprit_, _واجپئی_,
   {{0x823174e4,0x8e974426,0x9f21a17e,0xc93cf32d}},	//   _tfumela_, _erstatte_, _achuurra, _agurucūr,
   {{0x92c5c109,0x4c13e0ac,0xe2e6e07d,0x4291d07d}},	//   _enklare_, _생각되시면_, _maonten_, _tawal_,
   {{0xe29245c9,0x037f929f,0x1200c006,0x32c8a175}},	// [2220] _rawati_, _mikanda_, _salima_, _afronte_,
   {{0x72fc0521,0xa928215d,0xd8713036,0x82025055}},	//   _krige_, _غمگین_, _остават_, _litica_,
   {{0x415d903c,0x8317726a,0x22461263,0x73e82022}},	//   _situazio, _finally_, _ёдрас_, _естен_,
   {{0xa145d013,0x234a14fb,0xcfc2c2cb,0xb3e1c41d}},	//   _лукман_, _menentu_, _ناسور_, _خضدار_,
   {{0xee1b4041,0x0bfbf3a1,0xd2dc419e,0xbdd101f6}},	//   _iphetsha, _abagerer, _hemokai_, _दुआएं_,
   {{0x42900111,0x6626418a,0x6178a573,0x02da02af}},	//   _scias_, _sistemul_, _advarsel, _basegi_,
   {{0x4200c3ac,0xf22391ed,0xd3ea5657,0xf8ee008c}},	//   _halika_, _чистарту_, _talte_, _krugersd,
   {{0x8eb852e9,0x0c447054,0x3290309c,0x98625186}},	//   _bilesnis_, _shawara_, _lamaan_, _bisobanu,
   {{0x534dd427,0x13792044,0x920250f3,0xa290843a}},	//   _магазина_, _tapahia_, _mitica_, _wikang_,
   {{0x1995c02b,0x7d7ef085,0x022a309a,0x49e450ae}},	//   _دوزخک_, _সুবিধার_, _долан_, _olanlara_,
   {{0x9b16a1e7,0x9c127387,0x8793849d,0xfa31b14c}},	//   _majandus, _akasọ_, _kvitteri, _নলদিঘী_,
   {{0x2395911e,0x7dbd9004,0x9292720d,0x162bb2e8}},	//   _posse_, _javanese_, _geratu_, _chiallaí,
   {{0x138691bd,0x22c6a12a,0x0da08180,0xb0e57128}},	//   _tvaru_, _parlate_, _アルファグランデ, _channell,
   {{0x7324c24b,0x813a11d4,0xb3ea7300,0x1d7dd218}},	//   _abayilim, _malugiuk_, _ganto_, _نجران_,
   {{0x92910126,0x794bf284,0xdb109053,0x4a05f48f}},	//   _mobaye_, _teutonic_, _entstehe, _embalage,
   {{0x738695bb,0xac14c141,0x7c67819e,0xe2caf657}},	//   _kvart_, _аларын_, _tahunga_, _lagde_,
   {{0x9202524a,0xc28d742f,0xb27f0395,0x23eaa21c}},	// [2230] _matich_, _oursecay_, _ananmu_, _rabta_,
   {{0x2dd1446a,0x7cd14438,0x3c64a271,0x42cbc1ce}},	//   _ngokunga, _ngokungq, _situace_, _polonya_,
   {{0x1c6bd3ac,0xd4fc1041,0xdc6f508c,0x37e4a4a7}},	//   _hujurat_, _نامعلومو_, _toerien_, _angavaiv,
   {{0x1310406d,0xf8fec320,0x6e0d21d0,0xf85df342}},	//   _сенарияи_, _haiphong, _wundacha, _cairdeas_,
   {{0xdd24d053,0xd2fd75e1,0x1842f00a,0xeb0de0f7}},	//   _entsprec, _bebidas_, _proteins_, _违反本法规定_,
   {{0xea475198,0x239490ee,0xba41510f,0x826d10e4}},	//   _ситуациј, _vlasy_, _تجربات_, _labous_,
   {{0xa3949185,0x0727806a,0x6c6ab33c,0x2e8ad121}},	//   _anase_, _पुनरावलो, _شاعرایجا, _भारतीयन_,
   {{0xe02532fd,0xc212218b,0x7b83d439,0x53f8c143}},	//   _سواره_, _sakhi_, _adinegor, _baluki_,
   {{0x43ea7148,0x6e3b0496,0x4227f33c,0x5a09e3ef}},	//   _panto_, _varavara, _фаришта_, _perpetuu,
   {{0x46d61299,0x137a706a,0xbe1b9369,0xdea612af}},	//   _discussi, _catatan_, _exemples_, _abelelan,
   {{0xeacca01a,0x6c6f51ce,0xdb1682ae,0x54a4b0e5}},	//   _областын, _viersen_, _rahandus, _व्याधिग्,
   {{0x1db8e159,0x9396727c,0x42ebc153,0x035ec1d0}},	//   _valamint_, _kurser_, _kvinnor_, _justplym,
   {{0xa386b09a,0x1e3521ef,0x12d8c253,0xbe2fb29e}},	//   _بالدۇر_, _delaniva, _atoese_, _martiniq,
   {{0x0d4232f4,0xd3fa5113,0x72e90262,0xaec43579}},	//   _боксын_, _satura_, _itsinda_, _atencion,
   {{0xc3960286,0x12d9408c,0xc26e70a2,0x797b032d}},	//   _lossis_, _tweede_, _rasool_, _parivart,
   {{0xc200c05f,0x0abe1408,0x6e3b014f,0x0cd4d271}},	//   _palika_, _diajukan_, _agrahara, _nefunkčn,
   {{0x93f40296,0x42e6143d,0xf349e13c,0xb568d180}},	// [2240] _hyster_, _franska_, _aeterei_, _発行済株式数_,
   {{0xee8fc276,0xfb0e50ac,0xbb300438,0x7291d316}},	//   _دماغي_, _상대적으로_, _uqhagams, _hawak_,
   {{0xc9c3304c,0xdb60a17f,0x5da3900f,0x746f8087}},	//   _جالبه_, _осетияи_, _колись_, _ankertek,
   {{0x599d30b5,0x13ea7300,0x3b8ae031,0xbe73e2c4}},	//   _сайын_, _gante_, _ለመፈለግ_, _फोर्ड_,
   {{0x43869267,0xf02140c9,0xacc8c264,0x8307b424}},	//   _kwara_, _квартири_, _اتصلت_, _pamaagi_,
   {{0x76e40171,0xbf3560ac,0x240ab296,0xe158605e}},	//   _kimataif, _공급면적당_, _abanosiz, _fetukulo,
   {{0xb7b2b185,0x0394f185,0xc1f530d7,0x83a2e076}},	//   _aburokyi, _seisei_, _смотр_, _onipaa_,
   {{0x01e1914d,0x8d9c013f,0x3200e11d,0x571ab10f}},	//   _मदारी_, _להיחשף_, _fanika_, _koordiná,
   {{0x314fb0cc,0xa378e04e,0x03ea718e,0xd961402f}},	//   _posterio, _salamin_, _vante_, _abangaqe,
   {{0x7d59813c,0x520ed3cc,0x13ea71fe,0x03869459}},	//   _economía, _шадар_, _wante_, _gwara_,
   {{0x3f41d010,0x999d315e,0x3f27d2a7,0x3d181230}},	//   _nuisance_, _багын_, _ерларда_, _prestear,
   {{0xa38694a0,0x89c72030,0x184e438d,0x99c29121}},	//   _awara_, _қарамай_, _overlaps_, _kindlast,
   {{0xa2fce08e,0xb2eee079,0xec25d3ef,0x127a8278}},	//   _cengca_, _konfor_, _lionhead_, _talitali_,
   {{0x8f704195,0x43ea7033,0x36dd20cb,0xd991a2fa}},	//   _luscious_, _zante_, _baragraf, _aichovha_,
   {{0x6c5a9203,0x723040fe,0x2b7d6264,0x02fcd228}},	//   _awatali_, _kwemeza_, _ليفربول_, _utege_,
   {{0xed5b7405,0x96b8b1d6,0xd54cf009,0xe689e0be}},	//   _aistriú_, _abhalisi, _хозяйств, _prodhimi,
   {{0x0386d42e,0x0b63a0d3,0x587a812e,0x6ed4b43d}},	// [2250] _hvern_, _avertura_, _scenariu, _omgivnin,
   {{0xb21391d6,0x4750512e,0x0df71447,0xa94a0300}},	//   _tisho_, _क्रिश्चि, _заявил_, _komunour_,
   {{0xc9f8f4d6,0x5364e136,0x22da7184,0x1dab540f}},	//   _barajite, _blogean_, _masera_, _kenninga,
   {{0x2379f3dd,0x7644d200,0x126cb271,0x1f47c030}},	//   _nalazio_, _inqinchi, _budova_, _женевада_,
   {{0x3dab542e,0x0213917f,0xd00ac09a,0x3a6850f7}},	//   _menninga, _cishe_, _орнатқан, _双击自动滚屏_,
   {{0x2c67c05b,0x129190e4,0x4e6c1176,0xfc339105}},	//   _malunga_, _lasas_, _میرود_, _טאמיר_,
   {{0x242370e6,0xbdcc4280,0xfd6b40ec,0xbd87d1b1}},	//   _ottimizz, _rechange_, _partisë_, _molemmat_,
   {{0x1acb34bd,0x537952ff,0x53fa5197,0xac0a702f}},	//   _भरतर्षभ_, _astalya_, _dituai_, _abapasa_,
   {{0xb394d185,0x525a03d9,0x93066238,0x6e6da5f0}},	//   _abosom_, _shilo_, _saharek_, _proizvođ,
   {{0xb26d8407,0xbc0c1026,0x69e9a3ea,0xdb0c32fd}},	//   _werom_, _geopend_, _akunyada_, _شادین_,
   {{0xf7c2e23c,0xcebe226f,0x0ff5f0af,0x3681a4a8}},	//   _messaggi, _sanggeus_, _ランキング一覧_, _अवसाद_,
   {{0xf3fa751a,0x129e11e2,0xf2139293,0x7a1e11ba}},	//   _resumo_, _зирак_, _bishe_, _пирин_,
   {{0x6bcfa521,0xbf591167,0xb743a019,0x0c34f22e}},	//   _nederlân_, _casamien, _טאונס_, _kirchber,
   {{0x41bd802e,0x2cbe1009,0xcc3161b5,0x23523264}},	//   _развития_, _затем_, _سۇرگەن_, _مايكل_,
   {{0xe98401d5,0xf9819396,0x527a8127,0x42139181}},	//   _godinama_, _rapidame, _bilibili_, _wishe_,
   {{0x42cbf37e,0x4395f302,0xa29213c6,0xc29194de}},	//   _ngudo_, _bluse_, _tupato_, _gasas_,
   {{0xc200f244,0xbc9334f5,0x118d639f,0x8e959127}},	// [2260] _uchiwa_, _مامان_, _forbehol, _commison,
   {{0x74cea12a,0x1394d68d,0x5b6cb14f,0xd058f3df}},	//   _cancello_, _agosti_, _समाना_, _bakskinn,
   {{0x96b00065,0x6348c427,0x5c662065,0x1eaff437}},	//   _סמסונג_, _effetti_, _filters_, _aldobran,
   {{0xcd83e369,0x4e4c4266,0x3168b2de,0x535732c4}},	//   _ameliora, _ataaaaaa, _привлеку, _sumenep_,
   {{0x2a107262,0x09e4e24b,0xf9ecb1d0,0xacc312a0}},	//   _kambanda_, _nokuband, _guruvayu, _پێشڤه_,
   {{0xa26de211,0x02ea3457,0x52e94387,0x65e5f192}},	//   _aetoa_, _recinto_, _alanamu_, _аңланы_,
   {{0x9e4385d5,0x426d83e2,0x62ea113a,0x4fabe216}},	//   _atualiza, _perom_, _desisen_, _bellinzo,
   {{0xf31600e4,0x17c6243e,0x927e03c2,0x9c6b021d}},	//   _blize_, _परिभाषित_, _owino_, _काश्यप_,
   {{0xe39403ce,0xa2c24143,0x4226615e,0x430c42f4}},	//   _unisa_, _apelisa_, _daukat_, _esparru_,
   {{0xe60ff381,0x8c5320fb,0xf2017057,0x8290f033}},	//   _biológic, _विवेश_, _traian_, _bagaz_,
   {{0xd71c80e9,0xe317f326,0x8245809a,0x980be009}},	//   _reducció, _ekubeni_, _ماڭىمۇ_, _обращени,
   {{0xc37901af,0xc27e026b,0x6f361262,0xa357530c}},	//   _karakia_, _bwino_, _abashora, _asserer_,
   {{0xc2817294,0x2bd17538,0xc2bb3169,0x1017c0b3}},	//   _hahhaah_, _kendiler, _annemie_, _законны_,
   {{0xac65f2e4,0xd15fb068,0x72b4722a,0x329e224e}},	//   _biethet_, _mengekal, _koncu_, _ضميمه_,
   {{0x4eb5d23f,0xe2d7a4ec,0x6c55c1bf,0x126ce05d}},	//   _benefics_, _oteller_, _spitale_, _affon_,
   {{0xa58a3213,0xd47532f4,0xa1d161ed,0xa15b7221}},	//   _kusisisñ, _daitezen_, _armiyagä_, _bangacel,
   {{0x7290f0e2,0x61d78300,0xd3ea82e9,0x615c32a3}},	// [2270] _bagay_, _pennadoù_, _whitty_, _мартында_,
   {{0x39aac06d,0x73413228,0xa27ee431,0xce5821c7}},	//   _комил_, _مندان_, _bonnes_, _құнды_,
   {{0xee695200,0x2c135084,0xd25a60bc,0x3d9cc360}},	//   _chachana, _ahusọ_, _akole_, _صاحبزادی_,
   {{0x77d8106d,0xb2c6239c,0x20add2d1,0xaa7da339}},	//   _quarterf, _експорти, _بشاره_, _kadastra_,
   {{0x33ea7015,0x86394516,0x8436e110,0xcb8c346c}},	//   _manta_, _materiál_, _serbisyo_, _regionar,
   {{0x7f73739c,0x429242f5,0x4394d113,0x1d8f9256}},	//   _سەرسان_, _apwawa_, _inese_, _bibereye_,
   {{0x6386d1db,0x0227f192,0x541dc1f3,0x0f2bc18b}},	//   _hvert_, _тарихты_, _کارگل_, _salonsar_,
   {{0x9d07e0c9,0x720095f6,0xf1c430aa,0xd7da806e}},	//   _органом_, _apait_, _akamaram, _प्रकाशा_,
   {{0x2fefd06a,0xc67de1bc,0x8afd8135,0x4292118d}},	//   _वैधानिक_, _اكۇنوۋا_, _raportin_, _ampart_,
   {{0xe348c0e6,0xf6b15345,0x63ea74b5,0xadfdd267}},	//   _offerti_, _तख्ती_, _aanta_, _deregawa,
   {{0xe2026436,0x6fe043a4,0xa2ecb29d,0x22ee7012}},	//   _qariya_, _linkedwo, _feriene_, _fainali_,
   {{0xc200c1de,0x22e72185,0xb68350f7,0x0b511388}},	//   _oblika_, _amansin_, _福星上战场_, _رێکده_,
   {{0x19f1307c,0x53c800af,0x5dfb9241,0xd1f3012f}},	//   _elandela_, _besvar_, _diferite_, _دەسسەپ_,
   {{0xc4e2f17a,0xb35360df,0xa428a46a,0x2b6ab062}},	//   _মিলাই_, _exotherm, _ngokwenz, _tupulaga_,
   {{0xf386d0d3,0x2732f058,0xc3eae02e,0x8212b010}},	//   _avert_, _abazokwi, _tuntia_, _ticht_,
   {{0xae8f359d,0xb473114f,0xd5bf54ee,0xae3980f6}},	//   _sommaren, _अधुना_, _konfučij, _биологла,
   {{0x50729030,0xe83033d0,0xf2d9d10e,0x8889243d}},	// [2280] _белгилар, _төөрөг_, _zielony_, _verkstad,
   {{0x8295e101,0x8e563021,0xc833f235,0x875a868e}},	//   _efektiv_, _ungarske_, _жералдик, _शिष्टता_,
   {{0xcc1850d3,0x524a501d,0x5f3d84ce,0xba666246}},	//   _rumantsc, _stumpf_, _gabriela, _taamilos,
   {{0xf67d2180,0x12d6b431,0x03f91435,0xfa17600e}},	//   _アカウント情報の, _quelles_, _babuki_, _azalması_,
   {{0xab1fd20f,0x65af202d,0xc15de4d2,0xb201c04b}},	//   _onlardan_, _korporaz, _chorammo, _banklari_,
   {{0x925a8402,0x5386d3eb,0xa395018c,0xd3f47339}},	//   _dailix_, _hvers_, _agasti_, _pirtis_,
   {{0x7bc05155,0xa29190f6,0x69d1213c,0x14b5b00d}},	//   _ﭼﺎﻏﺪﺍ_, _hasap_, _абраҟа_, _birabbik,
   {{0x421391be,0x52fc0159,0xac05f043,0x37e050ac}},	//   _kisha_, _origo_, _torstai_, _등록자에게_,
   {{0xd9f13009,0x6212b010,0xd2dff257,0x538691cc}},	//   _alandela_, _richt_, _birində_, _tvari_,
   {{0x7212b1c4,0x74440050,0x7757c378,0x5c1882db}},	//   _sicht_, _刑事訴訟法_, _yndisleg, _syyahatc,
   {{0x9f27233c,0x056555d7,0x526da06e,0x337950da}},	//   _دعوتی_, _projekth, _depok_, _ottanta_,
   {{0x43a9725c,0xa2eeb4d8,0x5b840018,0x9e00e2eb}},	//   _بولدىما_, _chefue_, _женераци, _abrelata,
   {{0xc2ca90ef,0xb9b772fc,0x72cb7057,0xc4886180}},	//   _baada_, _класифик, _oradea_, _おすすめ商品_,
   {{0x63955053,0x5290e1d0,0xfc2b1083,0xe5af2249}},	//   _dieses_, _bonart_, _ايتچۇ_, _corporaz,
   {{0xa2d70187,0x87d53096,0x22918120,0x8386d4a9}},	//   _matondo_, _نوازا_, _unyang_, _mwera_,
   {{0xa3940192,0x2b97753d,0x83959036,0xa21394b5}},	//   _tiisa_, _trenutno_, _fosse_, _bisha_,
   {{0x2ddcd004,0xd3406027,0xc7ca42ab,0x7a62a13e}},	// [2290] _علاوه_, _regenza_, _druskini, _शिवराजसि,
   {{0xc21392d7,0xb2e93464,0x02a6c1c2,0x7288767a}},	//   _disha_, _reciben_, _agobie_, _egzaktem,
   {{0x3294709b,0x7a7d1366,0xe56050d7,0x3c6a8075}},	//   _alikani_, _नातेवाईक, _kullanuç, _forumov_,
   {{0x8952c1bf,0x7c57438c,0xa202623f,0x437a73d5}},	//   _реализат, _postaje_, _abrita_, _avtalen_,
   {{0x521290db,0x12919175,0x4cfdc38c,0xd3ead2a9}},	//   _baahi_, _absan_, _приче_, _montag_,
   {{0x225bf1fd,0x96d5b00b,0xe201f171,0x8c286248}},	//   _mutlu_, _pisassii, _hazina_, _ስእነትን_,
   {{0xd2c18283,0x657930af,0x9fd45168,0x19c7d38c}},	//   _umhlaba_, _酢酸ビニル共重合, _beantwoo, _задатак_,
   {{0xfc5900b2,0x09e4529a,0x9c649163,0x026d3464}},	//   _khouang_, _diantara_, _oktubre_, _sexos_,
   {{0x7307536d,0x80ac81e6,0x225a6309,0xeb3d9431}},	//   _最近更新日期_, _lokadhāt, _choli_, _fonction_,
   {{0xae4a2292,0xf2bca314,0xa53182ac,0xf06f02af}},	//   _наширнин, _फलफुल_, _ریبیتان_, _dikanelo,
   {{0x4ed0e0ea,0xbeaaa008,0xb025b0ca,0x826de2df}},	//   _policejn, _билдирйн, _anapatyā, _ketou_,
   {{0xab5ed0bf,0xd2fca304,0x0a1e11bc,0xcb18f009}},	//   _принт_, _berikat_, _бирин_, _версию_,
   {{0x2492947e,0x98b600c7,0x352a2033,0x81512180}},	//   _aserbaij, _waddamad, _eksitasy, _albertsl,
   {{0x2202601f,0xe6b72063,0x7a49e0f7,0x23806463}},	//   _jarida_, _kengashi, _个国家中排名第_, _aburro_,
   {{0x539482aa,0xd25a9095,0x7b62f30f,0xa316418a}},	//   _kristy_, _chalk_, _अभिनव_, _membrii_,
   {{0xfaa972ec,0xaccbc248,0xfa572292,0xad0c504a}},	//   _mecklenb, _ሓሳባተይ_, _ватанга_, _aakumbir,
   {{0x783231bc,0x7bb9c264,0xebe901bd,0x1a8b5133}},	// [22a0] _دايىم_, _يغادر_, _अफ्रिकी_, _postaví_,
   {{0xecd73228,0xed06e01a,0x79f950a8,0xb3592150}},	//   _اعلام_, _carreter, _firemní_, _stiftet_,
   {{0x8027a105,0x33fa13e6,0x8d19a194,0x7e5a419f}},	//   _געיעג_, _kapuni_, _henridac, _arabiyaa,
   {{0x1485024a,0xa291d0e3,0x32fd2143,0xa269d030}},	//   _sortearj, _bawat_, _obliger_, _баробари,
   {{0xfc4ec1ca,0x920271d2,0x32da608c,0xe15cd05a}},	//   _زمانا_, _arsien_, _gereed_, _чулар_,
   {{0x2c69231c,0xd327d174,0xb1023251,0xa35720f7}},	//   _zapravo_, _провео_, _турската_, _consulté_,
   {{0xe9a5c1e2,0x92fe51d0,0x6201f58f,0x923c40ac}},	//   _аллакай_, _veritas_, _pazina_, _중요합니다_,
   {{0xb21293c6,0xe291d424,0xa1f90229,0xfb0c81df}},	//   _waahi_, _gawas_, _построен_, _kristana_,
   {{0xca7331d9,0x84ead064,0xa56ad064,0x73ce51ba}},	//   _алдын_, _第二十二条_, _第二十五条_, _магазини_,
   {{0xf68db3d9,0xac338105,0x1c6fc1c6,0xa25ad342}},	//   _apeesegi, _קאריץ_, _akkużi_, _saolta_,
   {{0xe2fca3aa,0xc86630b8,0xfc63306d,0xd25a6285}},	//   _serikat_, _دکتور_, _ройгон_, _ekola_,
   {{0x5977f667,0x56d342b2,0x8c551117,0x82c94393}},	//   _menneske, _मौलिक_, _khotabe_, _deporte_,
   {{0x0b5e51bf,0x72d1f304,0xf3a612ea,0xf08d209a}},	//   _фамилией_, _tentulah_, _propozim, _бирси_,
   {{0xe2fc9165,0x4c6994e6,0x2f116036,0x025a62a3}},	//   _frage_, _impunzi_, _contatta, _kholo_,
   {{0x1e2210a6,0x9b00b44d,0x6c8c6229,0x62d0e337}},	//   _वास्तुकल, _neprimje, _доходнос, _dovnitř_,
   {{0x7f01c2e6,0xb69cd07b,0x13908221,0x67c0b3a5}},	//   _शास्त्री_, _accentii, _abayeni_, _akhulisw,
   {{0xc3eb0119,0xec4ce4ad,0x06e27034,0xe291d1d8}},	// [22b0] _imatut_, _bagwebi_, _регулира, _hawar_,
   {{0x425a6250,0xaa9491ca,0x4429e09c,0xd38061c4}},	//   _oholo_, _شنیاہس_, _ammammoo_, _burrel_,
   {{0x260e0105,0x0a5434d7,0xa304710f,0x80a803aa}},	//   _הורקנוס_, _akamusab, _hivatal_, _प्रदीर्घ_,
   {{0x57239217,0x73aab058,0xf03db210,0x52f0000e}},	//   _советы_, _norvege_, _ossessio, _tikinti_,
   {{0x801431e5,0x7f2a2009,0x0912a1fe,0x43b9c1d9}},	//   _сырына_, _nekufeza, _asaabaku, _мініп_,
   {{0xae5242a0,0x02f101c0,0x52fcd1e9,0xde416372}},	//   _بۆنموونه_, _nazioni_, _menikas_, _tatamamp,
   {{0xc9eca1b3,0x0d24a0db,0xdd2ca1b3,0x89ecc009}},	//   _arrivata_, _tokomane_, _arrivate_, _создават,
   {{0x2201f285,0xcc73f24d,0x4a69132f,0x5c09400a}},	//   _mazima_, _imisela_, _задухурд, _reported_,
   {{0xc2cb21e4,0x1201f0ef,0x1936e2ab,0x2ce2f16e}},	//   _haydn_, _lazima_, _struktūr, _функцију_,
   {{0x2dc45229,0x83eb80be,0xb73015e6,0x02d96121}},	//   _европейс, _larte_, _oposició, _sageli_,
   {{0xa3868213,0x0349734d,0x213e136f,0x261d123f}},	//   _iwirix_, _nenebev_, _пособиел, _callorhi,
   {{0x3b19f434,0x26bad2ab,0xebe3d1d4,0xb1d713df}},	//   _risponde, _pavasari, _tikeraar, _кирила_,
   {{0x38ff00ac,0x410250b3,0x99d0d1ba,0xe184a0db}},	//   _프로그램의_, _bäreleşl, _медия_, _boramahl,
   {{0xc2fc91bf,0x6c7d4007,0x303450ce,0x75e0f083}},	//   _trage_, _karrier_, _embernek_, _ارماندۇۇ_,
   {{0xc3fa1266,0xd80fb030,0x7815d447,0x5fbfe0de}},	//   _tapuni_, _усуллари_, _думала_, _اۋازدارى,
   {{0x21b910bb,0x650bd248,0x7292632d,0xf37610a2}},	//   _термін_, _ምጣኔሃብታዊ_, _purato_, _راټيټه_,
   {{0x86cec00b,0x527ee368,0xcd8c6251,0x337c50aa}},	// [22c0] _kalaalli, _apinun_, _фондациј, _ararisom,
   {{0x5c574048,0xabf40369,0x5257411b,0x6b714148}},	//   _postoje_, _follando_, _postojal, _indungna_,
   {{0xb3e7d0c8,0x82fd90bf,0xef126443,0xa9c331bc}},	//   _сакратар, _dedilar_, _araméore_, _باقبى_,
   {{0xda8b52fb,0xe963b264,0xfecab352,0xa60fe047}},	//   _divizyon_, _لتوفير_, _وینداران, _abalangi,
   {{0xdaf602b6,0xf7b602b6,0x6290d1c6,0x5aac7296}},	//   _emprende, _emprendi, _vonage_, _abakhumb,
   {{0x5b3c91b6,0x627e001d,0x9b114083,0xdd2a419f}},	//   _སྡོངས_, _bwini_, _campanya_, _amanamee_,
   {{0xc5f0e115,0xac669311,0x12d880a4,0x02015295}},	//   _parmenti, _газынын_, _bukete_, _wafika_,
   {{0x6177f1a6,0xa2d8e06e,0x332554d2,0x37b60229}},	//   _angahlel, _penemu_, _chobmey_, _imprendi,
   {{0x24132352,0x025a91e6,0x7394d0ac,0x4c93c275}},	//   _راندا_, _khalv_, _moest_, _سادام_,
   {{0xb94d00bb,0x8c39d264,0xfc4b101d,0x3b7250f0}},	//   _gamlebye, _ثغرات_, _ngitang_, _classera_,
   {{0x32d9b055,0x225a9137,0x925a0378,0x17be9388}},	//   _devenu_, _akala_, _skila_, _ئسرائیل_,
   {{0x2290b0e8,0x6b1de11d,0x76dde04a,0xbc1de04a}},	//   _dodaje_, _achangob, _achangof, _achangor,
   {{0x7249029d,0x31d5a4c0,0x41fa1248,0xdc5e21aa}},	//   _keamer_, _amolonam, _ከምዝሕብርዎ_, _boutril_,
   {{0xb27e90ef,0x2f78201d,0xdc1e2064,0xc8c591a0}},	//   _kwani_, _diabolos_, _compris_, _dimetrod,
   {{0xf2d8c027,0xe069b146,0xd4b4b2ce,0x256e23df}},	//   _mument_, _oddparen, _byaafrik, _føderalt_,
   {{0x604d9424,0x358a120e,0x4200e2a0,0x926ce1d7}},	//   _estuarin, _проблеми, _هیستریک_, _gloomy_,
   {{0xad85c3dc,0x364920ac,0x929154ca,0x02a630ce}},	// [22d0] _словам_, _촛불문화제_, _engang_, _gombra_,
   {{0x6291d039,0x925a91d1,0x126d80c8,0x01893031}},	//   _pawar_, _khalo_, _geros_, _አሻፈረኝ_,
   {{0xf37a505c,0xc19c82ca,0xbf2853df,0xe3023246}},	//   _objavio_, _минскиде_, _bustadna, _fananau_,
   {{0x52caf27c,0x42c8a256,0xe2ea101a,0xd29150ac}},	//   _sagde_, _rutonde_, _ارقىلىق_, _ingang_,
   {{0x22fb0589,0xda73c1ac,0xfc6ac159,0xd565f17d}},	//   _ntshona_, _mahavita_, _akartam_, _служить_,
   {{0xd386d145,0xc394046c,0xa27ed023,0x9cad8008}},	//   _nwere_, _riise_, _abonno_, _bildirýä,
   {{0xe212b449,0x122c2041,0x586964a2,0x198ec0bf}},	//   _machu_, _فیصله_, _biliyoru, _шаҳид_,
   {{0x79c4a21c,0x5dfdd1a1,0xc2e210c6,0xb5232585}},	//   _rilevant, _assetswa, _ahennim_, _dienlanh,
   {{0xe292508c,0x22da6149,0x52026256,0x727e819e}},	//   _betaal_, _peteru_, _hariya_, _koinā_,
   {{0x765e1155,0x82026376,0x12c0c2f4,0x67c790de}},	//   _қисми_, _kariya_, _бнмау_, _ئلىياس_,
   {{0x83445478,0x125a93a7,0x6644c250,0xada490df}},	//   _deceive_, _chalo_, _bipiwahi, _addingwa,
   {{0xc3ce933f,0x078680ab,0xeac683d5,0x0868304c}},	//   _weave_, _ansvarli, _ansvarle, _بيسيم_,
   {{0x7349e2d7,0xf6d8a0d2,0x662891b6,0xe2910193}},	//   _kereiti_, _лидерлер, _retouchi, _dobage_,
   {{0xa3174236,0x9ed8f06a,0x624601ca,0xfed1f15f}},	//   _zvezda_, _berikutn, _پُھٹرنم_, _nguyunit_,
   {{0x6aa7413c,0x6c76e22a,0x79c3025c,0xccfb015e}},	//   _herrería_, _nagradi_, _ارباۋىنا_, _kaleratu_,
   {{0x5290f056,0x4dcfc03d,0xa8be2026,0xffae1018}},	//   _tlhale_, _abakunya, _handleid, _паркэ_,
   {{0x12b4e3a7,0x76f53031,0x44510212,0x5f388219}},	// [22e0] _benchi_, _ቤተመንግስት_, _دتاجکستا, _debursma,
   {{0x13f133ff,0xc711c10a,0xe3949200,0xf2026098}},	//   _canzone_, _جنازي_, _inasa_, _bariya_,
   {{0xe202521c,0xa443f1bc,0x8b1ab031,0x32be23aa}},	//   _katina_, _союздун_, _አውጪዎች_, _cardeel_,
   {{0xdc2a0059,0x1c6050d6,0x225a90e6,0xbc68420a}},	//   _ሕፃናትን_, _lifunda_, _ghall_, _balungi_,
   {{0x8cc9f135,0x2486c5b9,0x43a53144,0x5e016020}},	//   _ዲክታተር_, _ब्रायन_, _akapheli_, _esidentp,
   {{0xd212b36b,0xb30123a2,0xad8ac3d6,0xb84bd0f7}},	//   _macht_, _osobine_, _второго_, _法规的规定_,
   {{0x74a31026,0x8d0e023f,0x7d88f63d,0x5c84500a}},	//   _대구광역시_, _ipotetic, _yerekeye_, _received_,
   {{0x82014320,0x79cd21c9,0x028c0285,0x828c042f}},	//   _pleiku_, _heidenhe, _abakaba_, _abasabay_,
   {{0x52a6e0a1,0x47b88427,0x52e88082,0xb291a455}},	//   _kembé_, _repubbli, _finikon_, _alvane_,
   {{0x1249f2e0,0x02873306,0x9202719e,0xd9bd207f}},	//   _nyuma_, _unikeze_, _ririki_, _азызуаз_,
   {{0x2d1a10df,0x42bad1d5,0x2bfc80c6,0x8313c4e4}},	//   _opertypr, _gledali_, _begorofo_, _ahocisa_,
   {{0xb26d83c1,0xc3258040,0x32cae08d,0x8a16f390}},	//   _beror_, _chabmey_, _eindia_, _barbadee,
   {{0x3212b012,0xffecf1a5,0x3786321d,0x960b8182}},	//   _bachu_, _самимият_, _पर्वतं_, _aspṛśad_,
   {{0xec4a7199,0x4212b22d,0x026da08c,0x003d9105}},	//   _pentref_, _dacht_, _gepos_, _שיקסע_,
   {{0xd25a919d,0xa0461020,0x62916390,0x1995a2f6}},	//   _bhall_, _epartmen, _ragaan_, _amakenga_,
   {{0x925a630d,0xe25a904d,0x49f131f0,0x0971a1b3}},	//   _ukoll_, _chall_, _мәлендә_, _compatir_,
   {{0x23966206,0xdab31296,0x54331296,0x92601143}},	// [22f0] _causam_, _abakakub, _abakakuz, _batoboli_,
   {{0x84fdf0f6,0x3a852030,0x62d8e1d7,0x6c70a042}},	//   _симпатия_, _قولدن_, _grieve_, _akusiye_,
   {{0xf25a90d8,0x98df9418,0xbc76c3d7,0x5b1874b3}},	//   _thall_, _freshlyg, _माल्या_, _tæplega_,
   {{0xe2910262,0x13940119,0xf2e4925f,0xe373712d}},	//   _kubaho_, _kiisa_, _futurity_, _tongony_,
   {{0x829160c7,0x6366a290,0x668b238d,0xed60f2c4}},	//   _tagaan_, _अर्थव्यव_, _bineeyyi, _एक्सएमएल_,
   {{0xfc53020f,0x02fcd521,0x62d61517,0x339402aa}},	//   _dostuna_, _frege_, _negozio_, _miisa_,
   {{0x2394017d,0x54a830d7,0xe32f9065,0x0951f139}},	//   _liisa_, _польшада_, _במצפה_, _asallatt,
   {{0x33a3413a,0xc2774061,0x03959239,0x768692d4}},	//   _diepla_, _مهاراجا_, _dosso_, _anawarkh,
   {{0xf2026233,0xc4aac248,0x07c690ac,0x81a3f3c9}},	//   _marina_, _ምዃኖምን_, _주상복합분양권_, _discipul,
   {{0x427f7041,0x32f5c2c1,0x4ec1b11e,0xcdd2e21a}},	//   _ibango_, _gerilim_, _benneman, _сталы_,
   {{0xbaf7a1bd,0xd2fce1b6,0x340e912e,0x12b391df}},	//   _spisovat, _lingwi_, _drugiego_, _londono_,
   {{0x018dc264,0x0057b3a4,0x6e68e579,0xd58a4262}},	//   _مؤخرا_, _cuislean, _талиптер, _agaragaz,
   {{0x9d37f48f,0x1e4da105,0x115a2214,0x82caf2aa}},	//   _личност_, _שייטל_, _ارﻧﺎۋﻟﻰ_, _finday_,
   {{0x67849050,0x62d761e7,0xa364516e,0x126c6579}},	//   _一一個獎項_, _avaldas_, _sporazum, _sobrevol,
   {{0x7c09447e,0x12fcd1b3,0xd3406045,0x26e5933e}},	//   _deuteros, _grege_, _kigenda_, _ditakrif,
   {{0xac6f5200,0xe60fe221,0xc94fe03d,0x329d4360}},	//   _churata_, _abalungi, _abalunge, _عزادار_,
   {{0xe0e9d0af,0x822670f9,0xa9e222f8,0xb302b03b}},	// [2300] _とりあえず_, _virkar_, _basubasu, _akubike_,
   {{0x3f2741df,0xf2b3f46a,0x926d829d,0x01fd4276}},	//   _interkon, _yendawo_, _berop_, _ڪامپليڪس_,
   {{0x82b471fa,0x87afa13f,0xec66b0f5,0x4304f21c}},	//   _cinca_, _יציבה_, _besteht_, _grooving_,
   {{0x42257032,0xb26d829d,0xf1633030,0xc3511266}},	//   _hlakka_, _derop_, _путур_, _haufano_,
   {{0xa5ce4252,0x22916174,0x737fc363,0xd25ac3d2}},	//   _cataluny, _proglaše, _tamaloa_, _celled_,
   {{0xc01d027c,0x58685007,0x13a2f42e,0x2d026075}},	//   _もっと見る_, _توانائی_, _skipti_, _pogledat_,
   {{0x73032218,0x420261fe,0x7f5d4321,0x4af54258}},	//   _fanacht_, _barina_, _ungasinn, _jeremias,
   {{0x726c9184,0xf2d9d300,0x0c5d527a,0x9bc97252}},	//   _tokony_, _skwer_, _koktail_, _жайларды,
   {{0xca4ab0e6,0x57bd8392,0xed246142,0xcdd252aa}},	//   _perfetta_, _pengharg, _avanture_, _fethulla,
   {{0x429261b2,0x4d584282,0xfb871227,0xdef0c374}},	//   _murado_, _מאגנאטיש, _노짱토론방_, _akakiyin,
   {{0x23334057,0x6aec01f3,0x95eda105,0x1744c2ac}},	//   _албастру_, _fantaszt, _בילעט_, _ئۆباڵی_,
   {{0xcd9d7121,0xa91510ff,0xc55800f8,0xc25ac199}},	//   _tunnista, _geschied, _filialı_, _belled_,
   {{0xb29721ec,0xcf0b9105,0x4983b405,0x82b6407e}},	//   _bankrut_, _מפקיר_, _shainche, _skadade_,
   {{0xc3959427,0x279fc020,0xecd72401,0xe2dc1189}},	//   _posso_, _underdev, _أعوام_, _dalmacij,
   {{0xc245a267,0xa32c20bf,0x8a36b14c,0x32fd9086}},	//   _adultgui_, _булардан_, _কিরিটি_, _ttsgb_,
   {{0xc2139030,0x325ad35a,0x825011d9,0xf9bf6109}},	//   _kishi_, _okela_, _كىرەر_, _annetste,
   {{0x5378a13a,0xa63120db,0x52a6d141,0x6c72a064}},	// [2310] _advaesa_, _сентябрҙ, _dilber_, _alertes_,
   {{0xc394d2d2,0xb3eb826f,0x0394031e,0x52916218}},	//   _diese_, _sarta_, _riisi_, _tagann_,
   {{0xd213904b,0xc035f3a3,0xaef70227,0xdc08e4e7}},	//   _lishi_, _svetovej_, _유비쿼터스_, _starpā_,
   {{0x53dca2cb,0x1e0ad059,0x7394849d,0x548a501a}},	//   _kubwa_, _በማግስቱ_, _boksen_, _كەلگەنچە_,
   {{0x123670fd,0x83f40378,0x22cb21ed,0xc2d13455}},	//   _sonje_, _systir_, _kayda_, _akronym_,
   {{0x9bda141c,0x8eb1c550,0x500b90af,0xeabd12fd}},	//   _саласынд, _momentos_, _質問投稿日時_, _سیادت_,
   {{0x82918316,0x42cb21ce,0x027ee119,0x17938358}},	//   _niyang_, _mayda_, _nannut_, _twitteri,
   {{0x629215a4,0x5212005f,0x02a97263,0x127f717f}},	//   _antaŭ_, _abihu_, _задухӯрд, _abanlo_,
   {{0x9b27c086,0x52e691ab,0xf9e81114,0x624861d5}},	//   _breakdes, _maynila_, _pengkrit, _tvome_,
   {{0xaf2712bd,0x0e6bf020,0xb2d9a128,0x826462c0}},	//   _akaretsa, _edicalma, _stunted_, _amulum_,
   {{0x53949012,0xb181a208,0x2a15a0c7,0xfa778024}},	//   _siasa_, _marbhadh_, _ammaanka_, _महाभाग_,
   {{0xf63e30ea,0x12fce3ff,0xc4e8916e,0xab28d25a}},	//   _साहित्यम, _longhi_, _напредов, _retadres,
   {{0x037fc0a1,0x0c56a49d,0x8928d06e,0x39f7c07e}},	//   _namakoa_, _nyttige_, _उदाहरणे_, _medarbet,
   {{0x025a93ed,0xc2b3112f,0x086f81e6,0x8fc2c404}},	//   _skall_, _нормал_, _प्रवर्तय, _ناروي_,
   {{0x690f90b3,0x2b8c0472,0x115cd162,0x026dc1df}},	//   _bulaçaq_, _iddialar, _гуман_, _devos_,
   {{0x21c79381,0xb2cad109,0x86d04229,0xc862d446}},	//   _нинель_, _bendte_, _аномалии_, _мюнхене_,
   {{0x7bf4b10e,0x1d3171a6,0x719ba548,0x4e015437}},	// [2320] _rezerwac, _anentele_, _консекут, _biletfra,
   {{0x0f468257,0x3c7de110,0x0c6ad20b,0x727f718b}},	//   _konfrans_, _proseso_, _कान्ति_, _thanad_,
   {{0x90aed2bd,0xbbe203be,0x52c0c15e,0xd394e0e8}},	//   _урман_, _ibumbano_, _унгар_, _prosty_,
   {{0xe200d3c9,0x5248622f,0xe1d5e340,0x82c010f4}},	//   _illius_, _svome_, _инстигат_, _ﻣﻪﻧﭙﻪﺋﻪﺗ,
   {{0x7d8441b3,0xdc963121,0x0fbe03ce,0x4381b10c}},	//   _liberate_, _कवनों_, _brandsto, _batshabi_,
   {{0xc030c1de,0x0d8f5292,0x7ea64296,0x4d2ff121}},	//   _prethodn, _دارالشفا_, _abalalan, _मंत्रिमण,
   {{0xf2ea534d,0xf3038309,0xdd4ea031,0x7b1280fb}},	//   _divison_, _arealit_, _ይመስለናል_, _प्रेक्षण,
   {{0xbbfe8224,0x4f09911b,0x52efc26c,0x234081c6}},	//   _fetogago_, _задовоља, _položaje, _arzella_,
   {{0x20efc15f,0x0eff8015,0x937d4272,0x3707926e}},	//   _immaqaak_, _allwisap, _coragie_, _намеры_,
   {{0x53ebe36b,0xb975256c,0x0482f129,0x7ffff004}},	//   _hatte_, _клубови_, _pretensj, _banyumas_,
   {{0xb9ccc06d,0xc56c50c8,0x15d6002f,0x3953f14f}},	//   _ntambama_, _аблвыкан, _ababemth, _abhaviṣy,
   {{0x726de075,0x025a6367,0xea89c28f,0xce4310e3}},	//   _letos_, _okoli_, _deportis, _kalagaya,
   {{0x54409356,0x337963b4,0x9202510a,0x9fb571d9}},	//   _apekanik, _baratwa_, _ratiba_, _күмән_,
   {{0xa3eba32d,0xd27e60cf,0x8d257256,0x7291b168}},	//   _sapta_, _itong_, _ingorane_, _alvast_,
   {{0xc2cad35b,0xaee16041,0xbd1253d5,0x395dc296}},	//   _sendte_, _ntsholon, _epostadr, _abalithe,
   {{0x13cf71a7,0xd7092008,0xa286e098,0x290ed0f6}},	//   _slavic_, _кесилип_, _imbabazi_, _даниелиң_,
   {{0x22e6d315,0xd2918531,0x19f9e1e7,0x537a70ce}},	// [2330] _frança_, _siyang_, _tavalise, _katalin_,
   {{0xbe19f615,0xf94972db,0x711c541c,0xcc1400aa}},	//   _menemuka, _папасыны, _сайттағы_, _agashits,
   {{0x82cae0ec,0x2212b012,0xb2d9b0ee,0x955ef27f}},	//   _vendet_, _machi_, _stanete_, _مساردی_,
   {{0x6399c40b,0x723671ac,0xd26dc053,0x60b18007}},	//   _næste_, _monja_, _bevor_, _optimáli,
   {{0xfdbca13d,0x2f514038,0x19e6f258,0x57959032}},	//   _pilipina, _kampanye_, _amerlasu, _danmörku_,
   {{0x94c8604b,0xf2fd6102,0x3c29a09f,0x62cad1c6}},	//   _шартнома, _tagger_, _agosetos, _hoodoo_,
   {{0x5c05a3ab,0x7e293469,0x2a719161,0x8560b195}},	//   _rubriky_, _geoghega, _airangwa_, _amakasiy,
   {{0x2506c0f6,0x8419d5fd,0xe27ed300,0xb72270e9}},	//   _адама_, _nachádza, _gwenn_, _aceptáir,
   {{0x2ef8e1ba,0x87c7c2f3,0x25405210,0x6147c2f3}},	//   _министър, _радили_, _artially, _радила_,
   {{0xdb01c3ba,0x0c67841e,0x46f7b30e,0xef41c271}},	//   _prosinca_, _fakulta_, _प्रविण_, _prosince_,
   {{0x6a17207c,0x31c7d0c9,0xef3030e5,0xf2d8e3f4}},	//   _ababumbe, _whitlock_, _konserwa, _anneal_,
   {{0x01cc5248,0x33944015,0x998fb031,0xe2367174}},	//   _ኣመሓደርቲ_, _kimsa_, _በጉባዔው_, _donja_,
   {{0xc2267150,0x24bdc11b,0xd28d323f,0x74132352}},	//   _virker_, _изглед_, _arrancam, _دایده_,
   {{0xf4df00f7,0xba0a104a,0x052b7283,0xa0da50d6}},	//   _法定代表人_, _aisagona_, _ayisekho_, _санитарн,
   {{0x7f6a917d,0x025af2bf,0x2d9e0144,0x92e711c3}},	//   _вторых_, _akagisum, _akanamta, _amannan_,
   {{0xed93117f,0xe246e1e6,0x93eb8004,0x6a10c12a}},	//   _гуруххои_, _केवलः_, _sarto_, _infantia_,
   {{0x150bf3a2,0x22cae004,0x22482289,0x362df053}},	// [2340] _postavio_, _pendet_, _tammig_, _frankrei,
   {{0x4b9c520d,0xf30331e6,0x527f4023,0x6f99412e}},	//   _egindako_, _abhavat_, _abenno_, _doskonał,
   {{0x127e0316,0xf7ddb23f,0xe941001a,0x221c64a7}},	//   _ating_, _milankov, _impulsar_, _afuhia_,
   {{0xd3eb81f6,0x92cad431,0xcf8f2258,0xb89a31aa}},	//   _warto_, _rendre_, _erhvervs_, _свитов_,
   {{0xb301f3e6,0xc6c37405,0x1353c342,0xc2cae031}},	//   _haramai_, _tuismith, _طهران_, _ለማስጀመር_,
   {{0x5224e121,0x9ada1192,0xb3037100,0x946ed136}},	//   _punkti_, _галереяһ, _gumamit_, _арима_,
   {{0xebf54252,0xe3c16009,0xc02af437,0x23794316}},	//   _expectac, _сформиро, _bundefjo, _datapwa_,
   {{0xf3eb829e,0xd2cad29e,0x9ba7a2ab,0xfc7e0071}},	//   _carte_, _vendre_, _laikotar, _persoan_,
   {{0x38ab7064,0xd5113601,0x94484275,0xe478f290}},	//   _第二十一条_, _čoskoro_, _турмасли, _मातृत्व_,
   {{0xa021f0b5,0x1c185369,0x2d8932ea,0x4aa93037}},	//   _ﺩﻭﻛﻼﺕ_, _stapler_, _kuvendit_, _белеме_,
   {{0x9b64d17d,0x82fb1155,0x72e011d6,0x5c185089}},	//   _рядом_, _явропа_, _akanawo_, _trapper_,
   {{0xd25ad2c7,0x0d3ae031,0xfd8fe221,0x5345008c}},	//   _biely_, _ብንወስድ_, _abalinga, _soldaat_,
   {{0x32e6804b,0x39d0a1e7,0x02fc601d,0xb08650ac}},	//   _olingan_, _investee, _eroga_, _스퀘어백화점_,
   {{0xf25ad2c7,0x9ef07261,0x127ed2af,0x4bf4016f}},	//   _diely_, _souvient_, _bannye_, _pollando_,
   {{0xda0de0d6,0x325b6337,0xab30c018,0xe290f35e}},	//   _bazakuba_, _anglii_, _непот_, _johane_,
   {{0xf81960de,0xa3fa500c,0x0a3c4140,0xd27681ed}},	//   _سوقسۇن_, _matuai_, _kabinetı_, _акциясен,
   {{0x6dc5d176,0xa75ea0ea,0x1b428548,0xc052a1ca}},	// [2350] _ابراز_, _अंग्रेज_, _понтиф_, _کٔٹھِش_,
   {{0x33eb810e,0xc2926075,0xd7973200,0xec6de5ba}},	//   _warte_, _morate_, _mistusax, _aririra_,
   {{0x03eb82f4,0x2248f081,0xc25ad47b,0x19fe0115}},	//   _tarte_, _reimer_, _ekele_, _cavament,
   {{0x025a60d6,0xe26de135,0xb2b472e8,0x21d61065}},	//   _ikolo_, _tetor_, _rince_, _השמאלי_,
   {{0xc2b4700a,0xd59ca120,0x447ec23c,0x825a6266}},	//   _since_, _parenchy, _никой_, _akolo_,
   {{0x2291617e,0x0c0bd2e5,0xcdacc17a,0xe3fa50cf}},	//   _nagaan_, _najbližš, _setninga, _bituin_,
   {{0xfbc14352,0x5db42264,0x324900a0,0x83a91048}},	//   _کارکردن_, _موقوف_, _swamps_, _provede_,
   {{0x51ad820f,0x031601f8,0x34f43248,0x5be0e31f}},	//   _dayandır, _blizu_, _መስመራት_, _entender,
   {{0xb277920f,0xc25a6280,0xe394d0dd,0xc8597502}},	//   _yubileyi_, _ekolo_, _goosen_, _sorawlar_,
   {{0x357e9295,0xb2fc6005,0xce3a1457,0xb80441d9}},	//   _kukumbuk, _proga_, _atravesa, _түгелдей_,
   {{0xe3954004,0xd5bdc059,0xa7a0e1b3,0x0b61b0c7}},	//   _alesan_, _መልእክተኛ_, _intendev, _sharafta_,
   {{0xbd321144,0xb627101a,0xd39420d4,0x7fa623d6}},	//   _alungele_, _تاپقىردى, _biksu_, _чистой_,
   {{0x8532e27c,0x42d7c41a,0x91b55227,0xbbb4645d}},	//   _この回答へのお礼_, _driller_, _동일조건변경허락_, _benefičn,
   {{0x45f0e405,0xccb2720e,0x537a12b7,0x2090b17d}},	//   _mbreiseá, _странски_, _karamin_, _entistä_,
   {{0x53eac38b,0xf2d460ac,0xa3413118,0x7cd5a0c5}},	//   _tamtay_, _houden_, _macedon_, _amakungu_,
   {{0xf25a914f,0x62d83057,0x49c31317,0xe30f6445}},	//   _khalu_, _numele_, _darempre, _empayar_,
   {{0x930d1148,0xaff92031,0x0ae7309b,0xa1bdd14c}},	// [2360] _dumasar_, _ይሳተፋሉ_, _kosikön_, _ভালো_,
   {{0x927ed123,0x6395f21c,0x525ad0e4,0xd2d8e474}},	//   _mwens_, _fluss_, _violan_, _quiere_,
   {{0x626de0af,0x2f40b085,0xefa250b5,0xa06750ea}},	//   _netop_, _বিষন্ন_, _ءﺟﯘﺭﯨﭗ_, _हर्षित_,
   {{0xa9e9d252,0xe3eba1a7,0x8adfe08f,0xab7ef23b}},	//   _مۇزيكالا, _capte_, _gatehous, _ceburaka_,
   {{0x53053388,0xa01a64e7,0x347690e5,0x7a093041}},	//   _موتان_, _kompensā, _द्विवार्, _مقتدي_,
   {{0x5040e1d9,0xfb27b291,0x2a09a371,0x03eb7221}},	//   _الاتاۋ_, _کابینت_, _nezamest, _amatye_,
   {{0x43780424,0xe347c074,0xdc558042,0xa3eaf238}},	//   _subasta_, _menduar_, _anetise_, _keitat_,
   {{0xdd0551e7,0xe8b240fa,0x6395903c,0x2a116064}},	//   _populaar, _svetozar_, _possi_, _totaleme,
   {{0x12bbf147,0xf27e0228,0x130c20cf,0x13790023}},	//   _studeni_, _atine_, _lumabas_, _ansaala_,
   {{0xc3955339,0x52ed50eb,0x43169419,0xd6dda0ac}},	//   _viesis_, _impinge_, _plazo_, _풍림아이원_,
   {{0x6daa013f,0x52dc03a8,0x22d7c40b,0xd7e75009}},	//   _registra, _dangzrwi_, _briller_, _вынужден,
   {{0xe24801de,0x825a948e,0x36d82005,0x02fa254b}},	//   _svima_, _thalu_, _становiш, _mochila_,
   {{0x686fc02a,0xd3b7805e,0x430093b0,0xd236e1f8}},	//   _shippers_, _ahovelo_, _misbrug_, _sanjam_,
   {{0x9ef620c8,0x53f8d258,0x126e5100,0x4364e071}},	//   _партал_, _tuluit_, _adtoan_, _njoggen_,
   {{0xd054f03b,0xf2d610b6,0xe8c510fd,0x626c50c3}},	//   _ekuseben, _negocio_, _endepand, _malog_,
   {{0xe4f4d17d,0x2aadd265,0x9c61738d,0xb3ebe1b3}},	//   _отправле, _štefánik_, _abuunaa_, _catta_,
   {{0xecc410f4,0x7a538027,0xa236718e,0x5b6cc49f}},	// [2370] _ئېتوت_, _communab, _lonje_, _estatíst,
   {{0xe61bf04b,0xd395f13d,0xc2da7342,0xf3f4b238}},	//   _mustaqil_, _pouso_, _misean_, _koreaneg_,
   {{0x1295f200,0x2c093206,0x025a6052,0xef4c2216}},	//   _amukini_, _tempora_, _skolu_, _respunsa,
   {{0xdf3ab02d,0x8394e17d,0xab68d119,0xd290f2ae}},	//   _sfortuna, _toisen_, _aggustip_, _kohale_,
   {{0x2320646a,0x126460f5,0x5beb43c6,0x7c6240aa}},	//   _umoya_, _verlag_, _korokoro_, _amarobe_,
   {{0x69fa1137,0xe304a1df,0xc0e992e4,0x00bd9065}},	//   _marikina_, _rilataj_, _vinabook_, _ובעצם_,
   {{0xd592d3d7,0x18b6d264,0x704721e0,0xd85a8252}},	//   _कर्मचारि, _برأيك_, _reprehen, _бюджетин_,
   {{0xfe696192,0x0c5bf142,0x09575008,0xc37a022d}},	//   _колледжы_, _kartici_, _гурултай, _straten_,
   {{0xd289308c,0xc50610e9,0x89ed20a4,0x4bc6f1e5}},	//   _beskerm_, _адума_, _bulisara_, _abadanįy,
   {{0xb1e3c408,0xdc6780a2,0x4fb6816e,0x726c5075}},	//   _उतारा_, _ibhunga_, _олимпијс, _nalog_,
   {{0xd3ebe14a,0x220261c6,0x630320cf,0x82cae0be}},	//   _tatta_, _ibrida_, _ginamit_, _rendit_,
   {{0x0d1e71c4,0x5291824c,0xb479f19a,0xe0b8e00f}},	//   _lemonade_, _hayaan_, _mireinio_, _покриття_,
   {{0xc25b427a,0xfef483d7,0xe135b109,0x2eea8319}},	//   _nielen_, _विक्टोरि, _hundehal, _hackphon,
   {{0x0290c0e9,0xd233c27c,0x43eb80be,0x23a23218}},	//   _enlace_, _ショッピング_, _larta_, _sampla_,
   {{0x5897f0cc,0xcbb540e5,0xb93e424a,0x4c7fb124}},	//   _salvador_, _स्त्रियो, _jammerde, _апрессма,
   {{0xf3eb8300,0x4212b11c,0x1b5b0175,0xa14da303}},	//   _garta_, _tacht_, _anmennen_, _systemko,
   {{0xe1fd6405,0xd87e22ff,0xfc124171,0xdb1dc264}},	// [2380] _ballstái, _avghanpu, _kampeni_, _علاجه_,
   {{0x6fc231f5,0x52a7c2ab,0xd97fa0c8,0xb2da71a0}},	//   _نامور_, _законам_, _спартыўн, _disein_,
   {{0x93eb811f,0xa39491ac,0x39fa1184,0x7cd94387}},	//   _barta_, _hiasa_, _marihina_, _akikanju_,
   {{0x6d4620de,0xbc90215a,0x0c158320,0x2dbe5079}},	//   _تاشپاقا_, _गहलोत_, _xemphim_, _corizina,
   {{0x0da9f437,0x3212b188,0x727f0010,0x5eb3536f}},	//   _aggitera, _dachs_, _stanes_, _borokgon,
   {{0xc27862fa,0x13cce01a,0x1278b020,0x21c921ba}},	//   _nyundo_, _пайдалуу_, _echanism, _шоуто_,
   {{0xc3d12489,0x7b1fc385,0x63165259,0x6353133c}},	//   _história_, _kematian_, _halbuki_, _دهفان_,
   {{0xe2a07005,0xfdf9b121,0x6cca2199,0x4250d406}},	//   _klubas_, _सम्मिलन_, _archifau_, _intertem,
   {{0x69880341,0x52ea13e3,0x9c77e48c,0xc3eae134}},	//   _informéi, _aksidan_, _aturiri_, _afitte_,
   {{0x5d74d2e2,0xe0eba06a,0x32d8e32b,0xcc128149}},	//   _konmanse_, _परीक्षक_, _linell_, _anapogi_,
   {{0x0083d392,0x02b47057,0x27dca210,0xfe25b34e}},	//   _mencetak_, _cinci_, _ebruaryf, _рузгори_,
   {{0xf3ebe030,0x0316d0fd,0x9a1822fc,0x23dd815d}},	//   _hatto_, _plezi_, _истом_, _purwa_,
   {{0x23ebe039,0xc752d263,0x1a4350ac,0xcb2c3283}},	//   _katto_, _izinking, _찾아오시는길_, _angaphas,
   {{0x7b035152,0x385c03cd,0x8b216186,0xea0945ac}},	//   _prosentt, _webshops_, _batagomb, _brødfør_,
   {{0x895e2065,0xad8b101a,0x64cb6182,0xca70e09a}},	//   _abilitie, _باستىرعا, _कामिनी_, _көрсит_,
   {{0x9b0d111c,0x1d9ac405,0x83949496,0x85b8a401}},	//   _leasanna_, _strongvp, _fiasa_, _لإسرائيل_,
   {{0x2f271233,0xf3305168,0xe730227f,0x33ec91c6}},	// [2390] _ikaretsa, _makkelij, _دیوالی_, _multipli_,
   {{0x8290e121,0x220271df,0xb1471292,0x525ad2df}},	//   _ennast_, _skribi_, _сафига_, _ikeli_,
   {{0x8c46d05b,0x85d9d1bf,0x9534c14a,0x07b49095}},	//   _کرامت_, _анализэ_, _afrikiyy, _nonsensi,
   {{0xb999e1a8,0x9d19f043,0xf6b7004c,0x93875169}},	//   _запатраб, _прекраще, _بالايي_, _hierer_,
   {{0xdc4e20bf,0xa3eb7378,0x9394d053,0x5f4933db}},	//   _هملند_, _skatta_, _wieso_, _morsomme_,
   {{0x42139239,0xf60ce299,0x6e92f091,0x920e10db}},	//   _gashi_, _пояснени, _kontrent_, _сауап_,
   {{0xcfa45086,0x23eba41d,0xda363214,0x2da413da}},	//   _adcenter_, _kapta_, _научное_, _admirewa,
   {{0xd29251d1,0xd3f960cc,0xfd8100be,0xf38f218d}},	//   _lutamo_, _miguel_, _realizua, _hungareg_,
   {{0xeafc3023,0x749ff17a,0xf2e31258,0xf213901f}},	//   _entraine, _উদ্যোগীক_, _juliane_, _bashi_,
   {{0x9c621385,0x863ca1c6,0x4d08d0db,0xb290c019}},	//   _pasukan_, _kwalunkw, _артистар, _rilate_,
   {{0x12139376,0x127ef1d7,0xab9190a1,0xc576420e}},	//   _dashi_, _stinks_, _wagihngo_, _realizaç,
   {{0x8c51820c,0x960200d0,0xd2025063,0xea0fe14b}},	//   _arituma_, _ilaliuti, _natija_, _finaleme,
   {{0x6b0712db,0x5c2af36d,0xce4e109a,0x6dee22ca}},	//   _бирден_, _男性更年期_, _барди_, _кризисти_,
   {{0x33870587,0xc382b525,0x4290e179,0xaef7a370}},	//   _umbria_, _prezans_, _annast_, _симмати_,
   {{0xf5583244,0x134c25b8,0x667410ea,0x43dc855b}},	//   _arakitay, _stretol_, _प्रत्यास, _schwer_,
   {{0xa31602b2,0xa8582105,0x251991e2,0x6f975075}},	//   _knize_, _מגולגל_, _семент_, _pošast_,
   {{0x1a8fd054,0x42ee6101,0x595b21ba,0x028041a6}},	// [23a0] _ministan_, _akonpli_, _студио_, _afakaze_,
   {{0xc9fe42bd,0x437e621c,0x6386d032,0x947e6007}},	//   _parament, _professj, _hvorki_, _professz,
   {{0xf20803e5,0xd3949336,0x33c87317,0x4e5585cd}},	//   _informác, _siasi_, _marvet_, _alabanye_,
   {{0x7d058336,0x2753e072,0xc3f81291,0x6e1bc169}},	//   _atelaite_, _рехабили, _adhuh_, _theguita,
   {{0xf7beb064,0x16e092cb,0xb316d404,0x26175299}},	//   _违者本网将依法追, _برادريءَ_, _elezo_, _rivoluzi,
   {{0x825a90f9,0x4b25a0f6,0xe43031ba,0x5d4eb252}},	//   _skalt_, _булашып_, _concorso_, _اسماندا_,
   {{0x041810ef,0x8bd1a21d,0x4290d1c8,0xdfa11049}},	//   _mapinduz, _मुनयः_, _kinase_, _servizos_,
   {{0x4ae2f2e8,0xaaa581ca,0xa25af412,0xb64d30d6}},	//   _pholainn_, _کُکلِہٕ_, _jailli_, _названия_,
   {{0xf2e81480,0x714fa22e,0x3daa522d,0x5eac53fb}},	//   _jacinta_, _battalio, _reageert_, _smartere_,
   {{0xd23651f5,0xe2f7d2db,0x4e93a0ee,0xfc28c2c4}},	//   _tolja_, _ярамаз_, _animovan, _efisiens,
   {{0xe287304c,0x62918311,0x668d614d,0xd87d104b}},	//   _گفتار_, _özara_, _बनवास_, _портлашл,
   {{0xb25a90be,0xbb9fa264,0x34b95031,0x2303d366}},	//   _fjale_, _رووووعه_, _ስመለከት_, _dijabat_,
   {{0xd2fc90af,0x5e529026,0x121392ee,0x57ea0504}},	//   _fragt_, _써브를시작페이지, _tashi_, _लाभकारी_,
   {{0x32ff41fd,0x8a71531c,0x82fe40dc,0xc20910e5}},	//   _kariyer_, _članova_, _actives_, _समाजवाद_,
   {{0xfcad1179,0x0a7c9246,0x427e6120,0x641640bc}},	//   _tengingu_, _fitafita_, _atong_, _ajoriwin_,
   {{0x5a1ad22e,0xca73d0f4,0xd7d5302d,0x8394d057}},	//   _piacenza_, _خۇشپۇراق_, _karuizaw, _piese_,
   {{0x32cff064,0x34859121,0x52025138,0x0e7d5121}},	// [23b0] _只显示最新_, _दिवाना_, _satima_, _मसल्स_,
   {{0x972800bb,0x5304033e,0xd82d214c,0xc1b7c2f7}},	//   _продукці, _didalam_, _তিলপা_, _дилоси_,
   {{0x62bb15b8,0xcb37f2f4,0xe2ba01eb,0x600d22c1}},	//   _balenie_, _дараахь_, _mécht_, _vatandaş,
   {{0x226e9283,0x7cebb0bb,0x700d2140,0x127e0208}},	//   _lokukhul, _norvegic, _watandaş, _puing_,
   {{0xe317f300,0x92fb2437,0x838702b7,0xaf2790d7}},	//   _neuze_, _daphnia_, _kwarai_, _темасына_,
   {{0xab99a2c3,0x1a446213,0xe63412b8,0x625b613a}},	//   _тарапына, _lucecita_, _finansië, _inglan_,
   {{0x54dac02e,0x08b53272,0x22370487,0x68afe41e}},	//   _можно_, _contener_, _ngajak_, _प्रशंसाप,
   {{0x59d2026a,0xb27ee36b,0x4519a443,0x43cf03ba}},	//   _interest, _kannst_, _комиссиа_, _spavat_,
   {{0xb2fcd256,0xf3763056,0x625ab143,0x9394d00a}},	//   _erega_, _mebušoma, _abengisi_, _choses_,
   {{0x63e43059,0x4202509b,0x4c680157,0xb3437202}},	//   _ውስብስብ_, _datika_, _fakulti_, _katempo_,
   {{0x8458b022,0x78cc52bd,0x22393030,0x13bfd192}},	//   _орналасу, _athetoid, _нохуш_, _амантай_,
   {{0x327e057d,0xa28282f6,0x68283303,0x37bb1307}},	//   _duine_, _isahani_, _центрах_, _bidronni,
   {{0x8869213b,0xc2d8908c,0xd7091275,0xc1ff4041}},	//   _kuinguyu, _tekens_, _кесили_, _سیاستوال_,
   {{0x22e2c00d,0x02cbf20d,0x61901292,0x1be5a0dc}},	//   _maanaam_, _gaude_, _mahalliy_, _sindicac,
   {{0x3660521b,0x425a637b,0x9905c1ca,0xa3c281f5}},	//   _meginmál_, _skoli_, _masaajid, _jóval_,
   {{0x20cce38d,0xbbeb5463,0x69bf600a,0xbbdc1290}},	//   _cytoskel, _tesorero_, _generate, _रजिया_,
   {{0xf3ebe21f,0xc250e431,0x7001801c,0xa97b91a0}},	// [23c0] _ratte_, _directem, _محاورہ_, _kilidnae,
   {{0x261a3135,0xc72c03b0,0x1d8f8194,0x8ae4e26d}},	//   _ምንባሩን_, _hemmelig, _arbescht_, _dikurant,
   {{0xf43801a2,0xcb54410b,0xf3d440c5,0x6dbae078}},	//   _планиров, _akamubar, _akamubaz, _تساهم_,
   {{0x34d5d009,0xdfb4e248,0x2dd94041,0xf2cae0f9}},	//   _следует_, _ምንጪታት_, _beskibaa, _londum_,
   {{0x60f1f3dd,0x13806196,0x2ec111e9,0xa95e013f}},	//   _saradnik_, _gaurko_, _edunikob_, _gallerie,
   {{0xd19b554b,0xee5b5685,0x1ae273bd,0x60072083}},	//   _mercadol, _mercadop, _regleman_, _парижде_,
   {{0x5290b1e7,0x39592443,0x1ae53085,0x6a660105}},	//   _endale_, _чеченов_, _শুমারি_, _טשעכיי_,
   {{0x82fc94ad,0x32d820ce,0xcea4b2b5,0x34885005}},	//   _brags_, _neked_, _insulate_, _каралеўс,
   {{0xd23b0205,0x12d120a7,0xecf00057,0x4394d221}},	//   _ailment_, _istokom_, _андардул_, _unesi_,
   {{0x4395d1bb,0xe45e2031,0x4daeb3a1,0x400cb0db}},	//   _arası_, _በበላይነት_, _abagudde_, _көрсөккә_,
   {{0xfbf1f14d,0x3248d11d,0xa27e0062,0xca2750e0}},	//   _postitus, _chombo_, _atino_, _ciccheda_,
   {{0x9d09d3e9,0x42e98115,0x94f6c00f,0xa290e0d8}},	//   _वोटबैंक_, _atengut_, _супровод, _annait_,
   {{0xc380601a,0x89dac440,0xb25ac143,0xa26c1215}},	//   _altres_, _abongisa_, _abongisi_, _mahom_,
   {{0xf15c2030,0xeaeeb01d,0x12026345,0x93fa539e}},	//   _турар_, _ersteche, _parima_, _ratuki_,
   {{0x220262d4,0x438ce1c7,0xa16613ab,0xfc65b035}},	//   _tarija_, _библиогр_, _suroviny_, _partiju_,
   {{0x7f060064,0x626c122c,0xefa4b0e4,0x030e0293}},	//   _采煤工作面_, _wahoo_, _berenger_, _ndabona_,
   {{0xd292109f,0x5e808128,0x0ee79205,0x3657d44c}},	// [23d0] _inpact_, _solvable_, _ditherin, _байлтай_,
   {{0x427e9525,0x1a6a1162,0xb27e01eb,0x3a9b023c}},	//   _atann_, _материял, _stinn_, _асоциаци,
   {{0x32c380c3,0x3c5d4085,0x3dea0008,0x222a1225}},	//   _ukoliko_, _ফিল্ম_, _ишсизлик, _горан_,
   {{0x72fc60e8,0x6950f1e2,0xb3bb11f3,0x427e6026}},	//   _drogi_, _abalande, _نسواں_, _stond_,
   {{0x2e32c083,0x9bfe20cc,0x221390e7,0xab13a2d2}},	//   _териштир, _conocido_, _yashu_, _gefallen_,
   {{0x427ed479,0xbb1ad4f7,0xf31700c6,0x1ba7b640}},	//   _gwent_, _occasion_, _mpazel_, _aruhukir,
   {{0x89aac44c,0x32ead2fa,0xe9ec80b0,0x225a6076}},	//   _сонин_, _phineas_, _pertunju, _ekolu_,
   {{0xc3795223,0x7c519148,0xe119a28b,0xf2910262}},	//   _mataifa_, _waktuna_, _trijetal, _mibare_,
   {{0x73078291,0xbc530121,0xf622468f,0x09f4a2c4}},	//   _ambabah_, _postiga_, _forordni, _प्रशासका,
   {{0x247fc069,0x637a701f,0xbeaec08a,0x9c69f381}},	//   _mategeko_, _matakin_, _abaludin, _ajatapy_,
   {{0x4dfe91de,0xa262c0fb,0x01eb8096,0xdc71059b}},	//   _poveziva, _पक्षे_, _ننانوے_, _मान्छे_,
   {{0x330cc304,0x83eb70d2,0x73ebe109,0xd8c83032}},	//   _isyarat_, _teatre_, _natta_, _vettvang,
   {{0xd9c92313,0x9ec5c56c,0xa2fe4339,0x4c5410de}},	//   _buloudra_, _славни_, _noticis_, _интербил,
   {{0x92cab010,0xacc87048,0x85cd2167,0x0e4cc17d}},	//   _meddle_, _směsi_, _antashay, _asiasana,
   {{0x43ebe288,0x1a6700ac,0x030c816d,0xa878b276}},	//   _katta_, _드리겠습니다_, _gewarnt_, _اڻوڻندڙ_,
   {{0xa202621e,0x85415292,0x29f664a2,0xa9aa11e2}},	//   _meriam_, _بینانه_, _parça_, _зохир_,
   {{0xf25a94e1,0xc16990b8,0xc1ccd0f8,0xc1891180}},	// [23e0] _ukali_, _ترانزیت_, _сынап_, _スイングリセッタ_,
   {{0x32fc610f,0xd27d62db,0xac6e7690,0xded80271}},	//   _progi_, _вакалары_, _ararira_, _princezn,
   {{0xba34d0af,0xe25a6076,0x42d8c27c,0xc74333d0}},	//   _をご覧ください_, _akolu_, _troede_, _курст_,
   {{0x39f4a06a,0x620ff29a,0x4f19f176,0xf200a0b0}},	//   _प्रशासना, _hanyalah_, _formulir_, _ambil_,
   {{0xe27c24b2,0x738d60ce,0xb406d009,0xdb6101b5}},	//   _lênin_, _kulturál, _выступле, _стансасы_,
   {{0xd26c514a,0x8c56b300,0x5f61f2fb,0x027ed249}},	//   _malon_, _marteze_, _eksplike_, _gronds_,
   {{0x9dc7738b,0xa3ebe3a1,0x59d302f4,0x3be972d7}},	//   _hihihehe_, _batta_, _erreport, _dibokoso_,
   {{0x0d15410e,0xd9e58538,0x529263eb,0x082e144f}},	//   _warunkac, _grafikle, _notast_, _раиконен_,
   {{0x8a09c005,0xf290b2eb,0x99d12341,0x687bf19c}},	//   _гарантав, _andaje_, _symétrie_, _ladiapau,
   {{0x32cbf339,0x8b9c2048,0xd2b5316c,0xafccf252}},	//   _nauda_, _sestupně_, _kondane_, _guanyado,
   {{0x4a61b386,0x4b2ad11b,0x918fd1ca,0xea4b90b4}},	//   _lingedza_, _сцене_, _illaahay_, _beteseda_,
   {{0xb26c5238,0x52fc90b2,0x6fd72292,0x260cd120}},	//   _kalon_, _iragi_, _махалла_, _awtomoti,
   {{0xe239332f,0xf4d7e0d2,0xcb7c2435,0x4040f2bf}},	//   _кобул_, _басары_, _bafutama_, _ayatavun,
   {{0x3291465b,0xcc93241d,0x426c51a0,0x2394d339}},	//   _endast_, _تالاب_, _dalon_, _viesi_,
   {{0x62bbd0a3,0xc68a2031,0xae55d067,0xfbb07552}},	//   _bekende_, _ማቅረቡን_, _elebanye_, _bunyamin_,
   {{0x49c6c1e8,0x36f0002f,0x3631e20d,0xcdd2f344}},	//   _одним_, _ziyacelw, _aplikazi, _agakunda,
   {{0xf364e0ac,0xc6433076,0x54a7b2bd,0x44e40282}},	// [23f0] _자연경치풍경_, _kahilahi, _didaerek, _קארנעגי_,
   {{0x327ed0a3,0x23651118,0xed08716d,0x818020f4}},	//   _tannie_, _anagyan_, _geklickt_, _قامۇسى_,
   {{0x094990dc,0x48064264,0x879b2358,0xe39462e8}},	//   _requerir_, _عالميا_, _авторов_, _chosc_,
   {{0xf897c2cb,0xdc1fb0f9,0xd28d11fa,0x32c65278}},	//   _مرتبو_, _tillukku_, _brakpan_, _epalame_,
   {{0xf248e435,0x4c036202,0xe2ea12c4,0x5a7171c4}},	//   _akimbo_, _sumping_, _resimen_, _manlines,
   {{0xbbd9e410,0x53054105,0x0bb80009,0xcc030120}},	//   _тарапынд, _פראקטיצי, _существе, _tropang_,
   {{0xe26c5076,0xc843746e,0xc9fcc184,0xa22a10f6}},	//   _maloo_, _lostsuas_, _manatant, _доэан_,
   {{0xfbf7d0b3,0x30c61144,0xa316922a,0xf9e6f009}},	//   _тибешен_, _anelical, _plazu_, _хаттар_,
   {{0xa3786316,0xb0531132,0x726c5238,0xaa5e1124}},	//   _maganda_, _мотиве_, _galon_, _богданчи,
   {{0xb95721e8,0x8bd9f083,0xda2e0180,0x757a7282}},	//   _edelline, _катарынд, _街遊びのスポット, _זכרונו_,
   {{0xa94b51a0,0xff3d101a,0xef30b067,0xa327f1e2}},	//   _benogete, _التنچىسى_, _kwesikwa, _киштиниш,
   {{0x9c7e6258,0x7356c12f,0x05d1e0aa,0x851373d9}},	//   _schultz_, _ﺟﺎﻳﻼﺭﻧﯩﯔ_, _aracumvy, _bodutelo_,
   {{0xc26c50c7,0x785e10af,0xf855641f,0x2a1721bc}},	//   _kaloo_, _産学連携本部_, _boqubnes_, _تاازىم_,
   {{0x0224c12b,0x4af7c036,0xb4bcb1f3,0x5d1832ac}},	//   _chokwa_, _галерии_, _غیرجانبد, _ناوهێنان,
   {{0x02e9b044,0xc2370086,0xd316718c,0x4437e358}},	//   _pounamu_, _jibjab_, _emibini_, _включает_,
   {{0x5453621c,0x9c6c7400,0x7057d23c,0xd26c549b}},	//   _sovjetik, _बुन्देलख, _линкове_, _laloo_,

   {{0xa2d830e7,0x59fcc184,0xa4610276,0x5c7390f7}},	// [2400] _rumele_, _fanatant, _اوڇنگارو, _alerter_,
   {{0xd4852121,0xf26c505b,0xbc35614e,0x063111ac}},	//   _संपादक_, _naloo_, _দলিলসমূহ_, _fotodraf,
   {{0x1097e152,0x9540f392,0xe27ed005,0xb27bc0ee}},	//   _времени_, _लोंढे_, _utena_, _pojednáv,
   {{0x79fcc184,0x603bc3a0,0x537fc01f,0x01c520c0}},	//   _hanatant, _گلوبالیز, _halatta_, _dintratz_,
   {{0xd379501f,0x610af030,0xd290d368,0xd2fcd0f1}},	//   _kudaden_, _inshootl, _kilaut_, _tregt_,
   {{0x72fc924e,0x37a8d11b,0xfd9bd4fc,0xf1a7d418}},	//   _osage_, _особе_, _fungovat_, _оромии_,
   {{0xc27e64b2,0xf3786203,0x427e63a5,0xa3869230}},	//   _huong_, _baganda_, _ntoni_, _stifting_,
   {{0x729250c5,0x61217126,0xb39462f8,0x121f414a}},	//   _intare_, _lipandä_, _bhosa_, _bakkeeli_,
   {{0xe2fc3292,0x7248c048,0xa78d6428,0x03806469}},	//   _palatasi_, _filmem_, _fulltrúa, _altris_,
   {{0x827e62e4,0xcfbd7288,0x425b42d2,0x3394d1eb}},	//   _duong_, _партияси_, _vielen_, _liest_,
   {{0x027e638b,0x426c70b4,0x5316818c,0x525b4169}},	//   _luong_, _panoa_, _amabini_, _wielen_,
   {{0x53fb350e,0x6e0d3004,0x029270cf,0x595e03c2}},	//   _intsinzi_, _زیستی_, _iisang_, _abanneet,
   {{0x7464121d,0x33b0a30f,0xd37953e4,0x122660ca}},	//   _एकोनविंश, _प्रभावीप, _autauta_, _anukta_,
   {{0x2efb317d,0xdf2b31a0,0x772a5175,0xbb649341}},	//   _страция_, _lestümab, _lenterim_, _akteuren_,
   {{0x742a6152,0x02760050,0x825b41cf,0xe09fe013}},	//   _правильн, _我也不知道_, _zielen_, _апривати,
   {{0x0ef485c2,0x627e6316,0xc0f0c17a,0x42c53075}},	//   _संस्कृति, _buong_, _সংযোগী_, _krompir_,
   {{0x821392ee,0xf292521d,0x2213f4f4,0x120db007}},	// [2410] _kashi_, _antare_, _tauhi_, _بالترتیب_,
   {{0xe394d339,0x73a93342,0xd9ed44c4,0xb9fc40c0}},	//   _viesu_, _يزداد_, _overhold, _capitada_,
   {{0xc3940288,0xe303239e,0xf3209295,0xa56ab271}},	//   _raisi_, _aynacht_, _amayi_, _motorový,
   {{0x8c84b1d7,0x2c621259,0xd394002e,0x62fdf11b}},	//   _deserved_, _forumun_, _saisi_, _druge_,
   {{0xc26c54a1,0xae38f0f5,0x82fce3af,0x12ed43db}},	//   _malom_, _veransta, _ginggi_, _fysiske_,
   {{0xfe770012,0xedeae022,0xc30332c4,0xe183d00d}},	//   _خانداني_, _ﺷﻪﻛﺎﺭﺍ_, _sahabat_, _alkandey_,
   {{0xa683449a,0xc70fc292,0xc27e00d2,0x926c7238}},	//   _रमजान_, _نمازی_, _quina_, _hanon_,
   {{0x69647162,0x73f890e8,0xb9c7c01a,0x9e0d2438}},	//   _түрки_, _zakupu_, _газада_, _امتيازات,
   {{0x1394609f,0xc27e6273,0xbf9f2013,0xb2fcd23b}},	//   _xhosa_, _xuong_, _хьыбла_, _esega_,
   {{0x95b01123,0xb7aa62b8,0x727ed033,0x326d0220}},	//   _konstrik, _letterli, _atenn_, _mubona_,
   {{0x988f817d,0xd645246a,0x8aa9f227,0x9111b245}},	//   _объектов_, _amakhosi, _일시적으로_, _iliverpo,
   {{0x941dc352,0x653b764c,0x7d0b2196,0xa830d0ac}},	//   _رایگه_, _española_, _herritar, _좋겠습니다_,
   {{0xf22b41b0,0xe2909192,0x826c71ab,0x6d3ba2c3}},	//   _upraviť_, _lijane_, _ganon_, _атанды_,
   {{0x323651f8,0x05a7a1d9,0x82feb0f0,0x12fdf118}},	//   _bolji_, _аралас_, _activer_, _duugo_,
   {{0x727e6320,0xdb879207,0xe305a145,0x327ed01d}},	//   _suong_, _sahipler, _braụza_, _eteng_,
   {{0x93c455b0,0xf27e63fa,0x939570ec,0xe65240ea}},	//   _револуци, _muone_, _flasin_, _हस्तान्त,
   {{0x23fa632d,0x2607b121,0x7fd0507b,0xa2fdb0aa}},	// [2420] _kurute_, _आनंदे_, _ministir_, _arahise_,
   {{0xab751198,0x1395907e,0xa0e780f7,0xd224e12b}},	//   _квалитет, _vissa_, _页面访问量_, _chikwa_,
   {{0x4b7ca145,0x7319c404,0x225a90f9,0x572be1f2}},	//   _belụsọ_, _پيشاب_, _fjall_, _málninga,
   {{0x92e971af,0x52fce29a,0x827e6691,0x8d01213c}},	//   _taringa_, _tinggi_, _tuong_, _dictadur,
   {{0xbc5212ae,0xcbed73a4,0x12fce2e4,0x82ed40f3}},	//   _teataja_, _covergir, _kangta_, _fisiche_,
   {{0xa27e90b2,0xaa5cc18e,0xd3041137,0x33807003}},	//   _muang_, _kosmofys, _matagal_, _korras_,
   {{0xc2ca6248,0x9b03f365,0x5ae53018,0x2201800d}},	//   _ንኹላትና_, _aussonde, _sigurant, _amrig_,
   {{0x126c71d8,0xc03c7163,0x839403ea,0xe057d1a2}},	//   _panon_, _liveliho, _abise_, _милиции_,
   {{0x7a105315,0xd27e0132,0xdff4c1e2,0x2534c1e2}},	//   _dinastia_, _prind_, _abayizin, _abayiziz,
   {{0x9759403f,0x795111a7,0x986a024f,0x7b1d415c}},	//   _समन्वयक_, _indolent, _neriorsu, _oppassen_,
   {{0xdc07a1a3,0x727d61b9,0x675ce031,0x33949443}},	//   _matsilu_, _палатаһы_, _kakitang, _ahasa_,
   {{0x799d201a,0x225bf1d1,0x72d8f010,0x0141e1e6}},	//   _нарын_, _phuli_, _driest_, _asmadīyā_,
   {{0x79420064,0x82da12e5,0x095f2418,0x261f234e}},	//   _applique, _jeseň_, _abangese, _abangesi,
   {{0xeb01a056,0x227e0180,0xd2a70300,0x031601ac}},	//   _botsebit, _trine_, _arabek_, _moizy_,
   {{0x05807445,0x429480d1,0x0262d223,0x62b5822d}},	//   _televisy, _anakeni_, _wasomaji_, _airco_,
   {{0x625bf306,0xd61511c5,0x59b963bf,0xb2902207}},	//   _thuli_, _bemagivö, _растител, _mekan_,
   {{0x237b2045,0xd4cb80ac,0xad6071e7,0x4be72438}},	// [2430] _musango_, _멀티미디어_, _इन्स्टाल_, _جريده_,
   {{0x4cec1198,0xe39500aa,0xe27e9295,0xf3515217}},	//   _компаниј, _agashi_, _otani_, _kiterep_,
   {{0xc25bf076,0x1c67c06d,0x0a5fe2f8,0x32dfe2f8}},	//   _akula_, _namuhla_, _besetaka_, _besetaki_,
   {{0x730de01f,0x3c654267,0x328e1296,0x2e9e43fb}},	//   _bukatar_, _buruzie_, _abakuso_, _kalmarun,
   {{0x53949216,0xe7e1f20b,0x7859247e,0xbc124195}},	//   _chasa_, _अर्धांगि, _osmoregu, _kampani_,
   {{0xe7a3017a,0xd96d2177,0xf3eaf1cf,0x425b23eb}},	//   _জ্বলি_, _istiraat, _neitst_, _skylt_,
   {{0x259b3094,0x64430038,0x125bf4f4,0xd035b0f7}},	//   _horrelak, _हृदयविका, _ekula_, _contenan,
   {{0xab0850af,0x526c717d,0xd3959198,0xf18c5418}},	//   _アルバイト_, _sanoo_, _disso_, _ababasol,
   {{0x29b920b5,0x1348f2b0,0xc434f4ce,0xd8596257}},	//   _болып_, _beseech_, _amukelek, _kitablar_,
   {{0xd26e03bd,0x6d4ff01b,0x1471f0bc,0x0d8493e6}},	//   _reponn_, _мүмкинчи, _akitiyan_, _wetewete_,
   {{0x31780056,0x68e2f1bf,0x8687c2d5,0x0726b0a8}},	//   _dibatsel, _депутаци, _aindheoi, _postupem_,
   {{0x858451b0,0xdbbf60ac,0xcf2b5031,0xb305b263}},	//   _fotogalé, _전자민원창구_, _የካቶሊክ_, _кумунист,
   {{0x7440f06a,0xc8b5a128,0xda3162ca,0xef8d7124}},	//   _उत्पन्ना, _softener_, _استرولوع, _ацәнакуа,
   {{0x625ac349,0xd672746e,0xe27e61eb,0xd3eb709e}},	//   _stolte_, _waldensi, _stonn_, _odatle_,
   {{0x00cfb3f2,0x3d98e17d,0x90cad292,0x32b4708f}},	//   _nonobhal, _начинающ, _دعوانی_, _lincs_,
   {{0x34b5e187,0xd5171293,0xd2da016b,0x05b9e027}},	//   _kupachik, _imirongo_, _adsens_, _sefatsch,
   {{0xd27ed3ac,0x0f248196,0xcdffd005,0xf3ea80b9}},	// [2440] _atene_, _dekretua, _referata, _mehter_,
   {{0xb8e9606e,0xe5c420dc,0xf5aa80c3,0xcf4d211b}},	//   _निश्चितच_, _maragall_, _egipatsk, _управни_,
   {{0x237b90cf,0x986d9141,0xdd23f1a7,0x3296c37f}},	//   _malalim_, _зиналыьа_, _audiente_, _amapanil,
   {{0x62367174,0xc379623f,0x04c6004c,0xa9ea83d2}},	//   _donji_, _attalea_, _مهرماه_, _jefferie,
   {{0xe27e938b,0x130600d0,0x3248918c,0x37d50083}},	//   _quang_, _atkanik_, _kwama_, _companyi,
   {{0x85f6345d,0x3598c0da,0xa6a28036,0xd2b241fe}},	//   _veteriná, _esistenz, _решениет, _aaddina_,
   {{0xec1930f9,0x89d930f9,0xbc6a4248,0x97f82012}},	//   _seinastu_, _seinasta_, _ንምህዳም_, _خبرنامو_,
   {{0xc38fe042,0x5afc414c,0xa306b2e2,0x08dde0ae}},	//   _ajoyina_, _কনটেন্ট_, _dimanch_, _şəffaflı,
   {{0xb2926318,0xd2900121,0x68d0e3ce,0x3c1763d0}},	//   _murako_, _leiab_, _direkteu, _рекламны_,
   {{0x36a1f221,0x96ec2287,0xc000430b,0x7d8301fc}},	//   _abathath, _кантролю_, _demokrāt, _katemaot_,
   {{0x17b1416f,0xe38770de,0x952480ac,0x129252df}},	//   _konservi, _podré_, _롯데캐슬비치_, _butako_,
   {{0xef3561fe,0x4f5813e2,0x33ce9062,0xd28f015b}},	//   _oktoobar_, _označeni, _agava_, _esekiel_,
   {{0xe200b1ad,0x52fe7004,0xdaa9513c,0x9b9e6111}},	//   _dyeing_, _sauger_, _савченко, _ekonomio_,
   {{0xe29022b3,0x33c41065,0x5c55f2d7,0x026c34ff}},	//   _pekan_, _פנטזיה_, _beetswe_, _demont_,
   {{0x6136d01a,0x16d5c281,0xac5c1300,0xa2da70e4}},	//   _ارتقى_, _saraakii, _listenn_, _anseyn_,
   {{0x9615e1e2,0xd9c72292,0x453d300d,0x8b04a44b}},	//   _аудити_, _қарасам_, _bariwaay, _prislist,
   {{0xddbad009,0x34f3f192,0xd763c1a5,0x52249102}},	// [2450] _lithinta, _мораҙым_, _abayophi, _dekket_,
   {{0x2290224e,0x3fd271b5,0xce51c285,0x47d240f1}},	//   _tekan_, _школьник_, _ababonya, _forgjeng,
   {{0xbea2f5a7,0xeaf482e1,0x4b2d916e,0x13954060}},	//   _seulemen, _adelodun_, _дивизије_, _seesaw_,
   {{0x81e1451d,0xfc0a6258,0x02902038,0x437bc1df}},	//   _شیوعیه_, _berthels, _rekan_, _japanio_,
   {{0x4db48086,0xb5f63178,0x40760035,0xb3d8206a}},	//   _sanguine_, _veterinä, _aksesuār, _बिहारमधी,
   {{0x839592aa,0xe2d9147f,0x0e14922d,0x22fc6432}},	//   _rossy_, _sucede_, _domeinna, _isogo_,
   {{0x5f463164,0x939ae176,0x1e9521b2,0x826cc039}},	//   _aristide_, _اسامی_, _shumisan, _ladon_,
   {{0x1394626a,0x930e01f7,0xc2da008c,0xe18a306d}},	//   _those_, _alabuga_, _lesers_, _ababeval,
   {{0x09c4d4d5,0x06f4c231,0x925af43b,0xbdfba1d0}},	//   _adherent, _कारवाँ_, _ġilda_, _infernet_,
   {{0xa3be6004,0x72d9b30d,0xeb2dc100,0x0248d11e}},	//   _privasi_, _livell_, _simbahan_, _calmat_,
   {{0x8b8b818a,0xd368b051,0x62b350fd,0xde28d225}},	//   _timisoar, _maggots_, _koudeta_, _кариерат,
   {{0x92d9b0d2,0x9053c11b,0xe950f413,0xc4fb314f}},	//   _nivell_, _новине_, _abalinde, _कुमारं_,
   {{0x93ac0440,0xd7c060f7,0x6efb9057,0x36f504dd}},	//   _respet_, _抗震救灾特别专题_, _иконицэ_, _kartområ,
   {{0xd4bfb60c,0x2290239b,0x1ec3f0e0,0xa25b403c}},	//   _संवेदना_, _sekao_, _राजकुमार, _scelti_,
   {{0xd29042ee,0x7f76807f,0x7049a20e,0x2c0b60f7}},	//   _neman_, _авидецкл, _можноста_, _imprimab,
   {{0x02f4144e,0x828a11ef,0x12e71004,0x4988014f}},	//   _artikal_, _eisamoni_, _alangan_, _anekarat,
   {{0x93030316,0x8d959193,0x393c01d9,0x2ea9b1ca}},	// [2460] _salamat_, _wretched_, _تارىتقان_, _تر٘ووتھ_,
   {{0xc62a1363,0xb949e272,0x1ff8e031,0xabf7d319}},	//   _tusitusi, _geomarke, _ይቀበላል_, _geleximc,
   {{0xa7a02012,0xa2b47007,0xe8e38192,0x8627d3ef}},	//   _مشاهدي_, _sincs_, _аңлашыла_, _cogitati,
   {{0xed9300bd,0x9ca590da,0x3d2bc230,0xe29023aa}},	//   _vorentoe_, _longwood_, _meindert_, _bekal_,
   {{0x129021de,0xba08e39b,0xc33d22a0,0x629e40de}},	//   _rekao_, _melawana_, _میرات_, _ئمىرقايد,
   {{0x40dd32d1,0xc298b33c,0xcdecd309,0x6d83115b}},	//   _میسری_, _قالدقلری, _chevchuq, _karemaot_,
   {{0x023e3012,0xdf21415d,0xd5ae10f1,0x82d9205e}},	//   _محققن_, _عبدالرضا_, _bergensh, _asinate_,
   {{0xe2d96431,0x21582193,0xa412d200,0x63a6408b}},	//   _argent_, _admonish_, _waynanak, _شارلوت_,
   {{0xf87cc00f,0x32910233,0x17809159,0x5d9f655e}},	//   _поставле, _ambara_, _اشرافیہ_, _abongera,
   {{0xe26c3217,0xc2ac40c9,0x4f234022,0x2c04406e}},	//   _remont_, _контроль, _ﻁﺒﻴﻌﺔ_, _oposisi_,
   {{0xc698c225,0x4f2fb15e,0xf029a0de,0xfbaef048}},	//   _предвиду, _busturia, _ايعىردىن_, _कानुनको_,
   {{0xc861b128,0xe3d5b0c8,0x627e44b1,0x33f85321}},	//   _innocuou, _platinti_, _kumno_, _illua_,
   {{0xc3f890c4,0x47e312db,0x1b910340,0xd304944d}},	//   _makuru_, _bolandyg, _ефектуар, _domagoj_,
   {{0x623041da,0x32cb7004,0x82927137,0x7292606b}},	//   _aremera_, _ngadeg_, _nasaan_, _apuaka_,
   {{0x1be10469,0xc24973a7,0x995e2210,0x977760ac}},	//   _rosenber, _chambo_, _acilitie, _속성신고하기_,
   {{0x39e4a27c,0x725a90be,0xd64f5005,0x31a8c0c9}},	//   _ありがとうござい, _fjala_, _установы_, _проводят,
   {{0x484ed33d,0xfc124012,0x52da51a7,0x697fd24f}},	// [2470] _publicid, _kampuni_, _intell_, _politime,
   {{0x92b1f35e,0x72497329,0x0394d329,0xf290416c}},	//   _handina_, _gyaman_, _inosen_, _peman_,
   {{0x8a400385,0x03dc6387,0x5394d429,0x525bf090}},	//   _beberapa_, _akowe_, _ahesa_, _ekule_,
   {{0x52129086,0x1fe3d1b5,0x5216f0bf,0x9db9b223}},	//   _jcaho_, _باستا_, _террорга_, _mwanacha,
   {{0xb47f921d,0x92a86085,0xb290427a,0x5a9bb198}},	//   _स्मृताः_, _এমনভাবে_, _nemal_, _jornalis,
   {{0x40ea94a6,0xf2786256,0x83eb4413,0x424db1f6}},	//   _समीक्षक_, _ukuntu_, _kwethu_, _फिसला_,
   {{0x258f5155,0xf7d9f30a,0x73949443,0xaa966024}},	//   _ﻗﯩﺘﯩﻢﻛﯚﺭ, _ekspendi, _ahase_, _शरीमान_,
   {{0x2205b0a4,0xf10a63c2,0x12904552,0x82d95437}},	//   _bilitaki_, _abakugol, _reman_, _augene_,
   {{0x1291a14f,0x93eb43a5,0x53f01105,0x6b90a1ba}},	//   _divase_, _lwethu_, _דזישקוב_, _pannello_,
   {{0xe387c3ab,0xdebe61d6,0x1f30514c,0xc330c5ad}},	//   _stará_, _achubeke_, _য়াযাদ_, _loggað_,
   {{0x13f894e6,0xb5d9c0ac,0xe56db248,0x30edf096}},	//   _bakuru_, _크라운제이_, _መንቆርዮስ_, _benzinmo,
   {{0x0e6ac1b5,0xa1eb7219,0x40b00392,0x127ed36f}},	//   _толды_, _gaspiyaz_, _alamsyah_, _bueng_,
   {{0xa5ff2048,0x54876121,0x20af61d6,0x427f514b}},	//   _विरोधमा_, _पखवारा_, _alomphel, _prends_,
   {{0x327e0368,0x02fdf11b,0x8c5a640d,0xac3c42e2}},	//   _dring_, _drugo_, _کراماتھ_, _segondè_,
   {{0xbb224276,0x523040b3,0x718960df,0xc6979063}},	//   _محبوبا_, _premera_, _entalmay_, _диндор_,
   {{0xde43526a,0x527ed08e,0x2f4350f5,0x829042c1}},	//   _password_, _fueng_, _passwort_, _kemal_,
   {{0xbb81b691,0x627ed3f1,0xdeb4a272,0x4ed7728c}},	// [2480] _mainboar, _eteni_, _materies_, _jaunimas_,
   {{0x779d940b,0xef44213f,0x5344a429,0x8aca6264}},	//   _トラックバック_, _שרותים_, _airespe_, _شراميط_,
   {{0x4aa66085,0xed8492b5,0xc317f18e,0x8e43a07b}},	//   _librería_, _birdcage_, _wouze_, _barabade_,
   {{0x727e6191,0xe36ab064,0x9409b375,0x0ed60105}},	//   _trong_, _文化东路街道办事, _پاراقتار, _מבעלזא_,
   {{0x4342050e,0x6ef7f1a8,0x82ed4218,0x9404b124}},	//   _ingendo_, _пароляў_, _eisithe_, _авиациат,
   {{0x92d804df,0x7a8c4071,0x125ad074,0x32ea308c}},	//   _kliek_, _gebieten_, _sjell_, _wenners_,
   {{0x286861e7,0x3477c2fc,0x92a075fe,0x33959030}},	//   _ekspress_, _меморија_, _saubit_, _hissa_,
   {{0x5fd21085,0xb38711b8,0x42d844d5,0x72f30272}},	//   _ওপেনসোর্, _starex_, _almen_, _aplicat_,
   {{0x69943475,0x367f61e0,0x378790f7,0x427e6437}},	//   _penyelid, _venenati, _型男大主厨_, _trond_,
   {{0x26e2f3e2,0x3f74336f,0xe1d9e3d0,0xfecdd11d}},	//   _životnéh, _федоровк, _машинууд, _achikuon,
   {{0xf01b60e5,0x77bf017d,0x2249f3a5,0xfc5522c6}},	//   _अध्यात्म_, _обратная_, _mvume_, _evitate_,
   {{0xb998d138,0x2d8673e4,0x3e48e2fc,0x27bb710a}},	//   _troši_, _atamaioa, _omladine_, _vinginev,
   {{0xfb9f10f2,0x5f340248,0x432b11d2,0xae189026}},	//   _विरुद्ध_, _ንውድቀት_, _shahlang_, _oppervla,
   {{0x66e2f048,0xa98381b5,0x6b8da14c,0xba82341a}},	//   _životníh, _теледида, _ভিসতা_, _regnskab,
   {{0xd26e9009,0x631c209f,0x427e6358,0x7c760404}},	//   _nokuthul, _аңлай_, _huono_, _بدنيتي_,
   {{0x395d631d,0x04a1b096,0xcd3a826a,0xd3959177}},	//   _rainwate, _الایمان_, _reliable_, _bissa_,
   {{0x724895cb,0x1e58228c,0xeae6209b,0x96c31244}},	// [2490] _kwame_, _насельні, _bigikön_, _qalakayi,
   {{0xd3949387,0xd95e1484,0xa3530162,0x15cd40fe}},	//   _gaasi_, _aeropost, _كۇچار_, _kugabany,
   {{0x82d8d211,0xc3a91065,0xbde9126a,0xc3eb7187}},	//   _eeeee_, _provide_, _provided_, _chatha_,
   {{0x72fcd1e7,0x8dd5f43d,0xbf69e26e,0x0d8ae135}},	//   _isegi_, _blekinge_, _palangos_, _informua,
   {{0x5378b2b7,0x32e03124,0x75cf9180,0x82cad065}},	//   _dakarun_, _amancio_, _middelvæ, _funded_,
   {{0x02b471d8,0xd985b0a4,0xbbdec12c,0xa38050c6}},	//   _wanci_, _biliraka_, _badescuc, _katree_,
   {{0xacb8e050,0x83762276,0x41d7c579,0x237ca3e6}},	//   _祝您旅途愉快_, _پاڪيزه_, _паанек_, _matapae_,
   {{0xc580256c,0x1239d059,0x03eae056,0x03eab026}},	//   _informaç, _የሕዝብን_, _dintlo_, _beetje_,
   {{0xa454b49a,0x6316965e,0x12fdf069,0x899972d3}},	//   _जनाधार_, _anazo_, _urugo_, _mucklene,
   {{0xb7a2540e,0x79ada030,0x1eb7e012,0x05acc48f}},	//   _suavdlaw, _билдириб_, _فرشتن_, _племе_,
   {{0x12d84165,0x9859f225,0x9b848266,0x2c6210b6}},	//   _immer_, _предводе, _fanofano_, _orgullo_,
   {{0xb29d608c,0x6efdd011,0x2117621d,0xd27e9370}},	//   _verkoop_, _политике, _puruṣott, _erand_,
   {{0x6b01c320,0x23eae199,0x09df90a2,0xbea9c05b}},	//   _naiscorp_, _menter_, _abangeva_, _afutheke_,
   {{0xf27e900a,0x5a99139e,0x3277112f,0xbae97056}},	//   _grand_, _awaytana_, _барман_, _kgathele,
   {{0x026ce0cb,0x770b9218,0xd95f1248,0x7b5b7085}},	//   _safon_, _custaimé, _ንምሕዝነት_, _explicó_,
   {{0x57ca1185,0xac6810e1,0xa394d3e2,0xf472915a}},	//   _amerikaf, _hokusai_, _ciest_, _नरेन्_,
   {{0x22902039,0x9fc4c09a,0x22b47055,0xb226d360}},	// [24a0] _adkar_, _илатниң_, _mancu_, _حدیبیہ_,
   {{0xb27e9062,0x261c717d,0xb3eb7044,0xda6cd1f8}},	//   _tuana_, _mielenki, _ahatia_, _automats,
   {{0x8ee7b333,0x03949135,0xe5f3911b,0xa227f12f}},	//   _prikazan, _mbase_, _болест_, _تېجەشلىك_,
   {{0x73942100,0xc290921c,0x8b8ca059,0xa7dd44e9}},	//   _laksi_, _iskart_, _pilihanr, _overallw,
   {{0x93eae0d3,0x517e6288,0x6af71426,0x62d861cf}},	//   _denter_, _kiritish_, _akkumule, _bloen_,
   {{0x2bfb7081,0x73401546,0xe3eb7221,0x927e9004}},	//   _kinguner, _licenza_, _thatha_, _orane_,
   {{0x63f853c9,0xc3dc648c,0xb3eae199,0x75eb30ac}},	//   _illud_, _akowa_, _fenter_, _공정거래위원회_,
   {{0x027e92e4,0x7afc8027,0x7a0e7136,0x641860ce}},	//   _trang_, _indemnis, _prestaku, _adminisz,
   {{0x127e9392,0x72e6e0b1,0xa394927d,0xdcfb1043}},	//   _urang_, _doonaan_, _taasi_, _операции_,
   {{0x93959032,0x63794012,0x8ff29257,0x638062f2}},	//   _vissi_, _matakwa_, _arzuları, _oturub_,
   {{0xa2d8202a,0xab80f1f3,0xbc061065,0x2e43d0e3}},	//   _poked_, _قربانیوں_, _השמונים_, _kababaya,
   {{0xf379619d,0x0345d601,0x1316d4e0,0x52e71123}},	//   _furasta_, _portégé_, _poezi_, _alankan_,
   {{0x8fbf20fa,0xb26c719a,0xf5843248,0x02910186}},	//   _porodico, _hynod_, _ህዝቅያስ_, _imbaga_,
   {{0x22fce445,0x263721d9,0xd0041065,0x3c6ff1ba}},	//   _mangsa_, _بىلسە_, _דנידין_, _storico_,
   {{0x9845939a,0xa3169438,0x19f6c10f,0xc421e1b3}},	//   _रजिस्ट्र, _unazo_, _سونیا_, _paradoxo_,
   {{0xa2caf2d2,0xb30d3041,0x76d0b3f0,0xc10ed264}},	//   _leider_, _hambisa_, _क्वार्टर, _يحافظ_,
   {{0xa20264b4,0xbcf740c8,0x73805122,0x0f389421}},	// [24b0] _auriel_, _электрыч, _altrui_, _abbuumma,
   {{0x2c13217a,0xdfb30248,0xc2910203,0xa9ce32d2}},	//   _মাধ্যমেৰ, _ሰንከልከል_, _embaga_, _gemeinde,
   {{0xe8806094,0x5044d13d,0xcec55306,0xbc7fd41d}},	//   _artikulu, _bourgogn, _okungcon, _تحائف_,
   {{0xfe61c251,0xde34a214,0xf305221e,0x3dec21aa}},	//   _trabalha, _ﺩﯨﻨﯩﻤﯩﺰ_, _ditanam_, _нурлы_,
   {{0x92300405,0xbdd1b3f2,0xa3df60f9,0x2fd0500e}},	//   _shampla_, _obekunga, _heimspek, _malikdir_,
   {{0x9b5b607e,0x62dba230,0x32ea912e,0x11f6e124}},	//   _samtliga_, _kânsen_, _jezioro_, _имаҷхеит_,
   {{0xe2d4d0f7,0x6963e0de,0xb39591a2,0x13fcc15e}},	//   _第四十六条_, _ارەناسىن, _lissu_, _спортод_,
   {{0xc290239b,0xab051025,0xe69eb185,0xd947e381}},	//   _sekai_, _afasegbe, _kurdishf, _арадиои_,
   {{0xf28181d2,0x9394b1b8,0x427ec636,0x727e605e}},	//   _lisieux_, _bacsi_, _hamnar_, _etonu_,
   {{0x22fa21c4,0x1bb46105,0x92ff4249,0xb6d5c0b1}},	//   _terribly_, _נאָבעל_, _scriver_, _maraakii,
   {{0xe239209a,0xe2a6540d,0x437282bd,0x0dbca0c5}},	//   _тосуп_, _برونٹھہٕ_, _bataung_, _badafise_,
   {{0x720ec5b1,0x245c020e,0x52bb2089,0xbc73e54b}},	//   _давам_, _federaçã, _anoedle_, _consiga_,
   {{0x1340113d,0xa41f5443,0x527e43a9,0x7395f320}},	//   _vicenza_, _pasajero_, _humna_, _giuse_,
   {{0xe394e152,0xb26d8199,0x6317b192,0x5a771264}},	//   _voisin_, _barod_, _тренеры_, _ماجستير_,
   {{0xf30dc22b,0xb49f8159,0x774e2248,0xf2a6d15e}},	//   _membina_, _مبالغہ_, _በብዓይነቱ_, _probak_,
   {{0x7c5fc4b4,0xcd1fb3b0,0xb7529041,0x8f3cc56f}},	//   _fastaem_, _tillykke_, _abayenzi, _sportbla,
   {{0xf5c8021d,0xddd932a0,0x2983a4ab,0xc5e5f0fc}},	// [24c0] _nopapady, _وتمان_, _arahunga_, _аңлатыу_,
   {{0xd3dc92f6,0xa303c169,0x1a94621d,0x6a070175}},	//   _ikawa_, _erkannt_, _कर्मसु_, _anbasade,
   {{0xc2d860bd,0xcdb43128,0xcaf1207f,0xf25bf222}},	//   _bloed_, _countena, _ҟалҵеит_, _skula_,
   {{0xb3f472b8,0x805ed07d,0x14906360,0x88d581c9}},	//   _gestel_, _ikenomik_, _پیرمحل_, _jacuting,
   {{0xb39591eb,0x327e6062,0xf3949168,0x4a83555c}},	//   _misst_, _atonu_, _naast_, _jazzkafe,
   {{0x13dc9523,0xf5e7215a,0x12d8c227,0xe3c87428}},	//   _mkawa_, _पोज़िशन_, _groene_, _úrval_,
   {{0x886d7216,0x63f4708c,0x631684ab,0x5fa542bc}},	//   _persunas_, _bestel_, _akababi_, _avsender_,
   {{0xa2bf1264,0xef5e912a,0x6f8a6162,0xa9d1504c}},	//   _عملاق_, _nication, _милләтни, _بفرمایید_,
   {{0xf2d89692,0x88700198,0x126d1424,0x39520506}},	//   _blaen_, _músicas_, _yazoo_, _bibletee,
   {{0xa27e90ec,0x420110f6,0x7c6251d7,0x1c93456f}},	//   _prane_, _nebiti_, _startle_, _forsberg_,
   {{0x3ea76263,0xe4b38105,0x7e00626e,0x32b1c22b}},	//   _emperors_, _הארבע_, _bendrada, _biodata_,
   {{0x93f00142,0x130351ef,0xd75d6013,0x5ee7f374}},	//   _preobraz, _babakau_, _норвегиа, _chekutan,
   {{0x6394931e,0x034082f4,0xd2fe6284,0xb27f0453}},	//   _taasu_, _benetan_, _desiros_, _aianek_,
   {{0x2dffe04f,0x1a2322f3,0x12fc30d2,0x0200c0b1}},	//   _perempua, _порекло_, _milions_, _taliye_,
   {{0x635301bc,0xff321064,0xcb1d2205,0x5d9e0044}},	//   _تۇمان_, _国土资源部_, _attainab, _tiketike_,
   {{0x82946440,0x0a059171,0x18cf1248,0xec09e05f}},	//   _abikisi_, _kumaliza_, _ብሓለንጊ_, _hoopuka_,
   {{0xaaaf23c0,0xce78d018,0x16b250db,0x65cc203b}},	// [24d0] _bathobas, _activită, _курстары_, _angaboph,
   {{0xc7484041,0x427f50cc,0x63801040,0xc200d272}},	//   _امکاناتو_, _buenas_, _beprup_, _folies_,
   {{0xf85cb08c,0xcf52b2b2,0xed1833a2,0xae0161e6}},	//   _verander_, _orgasmus_, _engleske_, _katamaḥ_,
   {{0x3afcb2a9,0xcc0a7200,0xf13fd37f,0x2c3ba251}},	//   _gesundhe, _arapiwa_, _greenbel, _издавање_,
   {{0x14b2120f,0xfaa161e6,0x4e2f6276,0x417ec44c}},	//   _dolları_, _paraṃtap, _اٻوجهه_, _балба_,
   {{0x0161127d,0x0431b085,0xc386e5c6,0x1e3cc049}},	//   _doorasho, _জামিন_, _wolfgang_, _teclados_,
   {{0x8cf2f18a,0xd3dff1a5,0x0dbc3332,0x79df4242}},	//   _partener, _abamatek, _falanise_, _domubied,
   {{0xd3da21ba,0xa63804d7,0x4348d04d,0xfa9d314c}},	//   _правилни, _ahinduki, _aiteamh_, _দাইড়_,
   {{0x42c5112e,0xc5bcf39c,0xf473516c,0x8c6320f8}},	//   _okolice_, _бостанли, _toutotan_, _формада_,
   {{0xb27e9261,0xc3160238,0x526ca367,0xa372618d}},	//   _quand_, _inizi_, _izbor_, _romaned_,
   {{0x13a962b5,0xc9daa3bb,0x7c765186,0x59c0728c}},	//   _smearing_, _akunanta_, _aborozi_, _bendraut,
   {{0x029e112f,0x33ebe17a,0x439400aa,0x48a53096}},	//   _гирам_, _nytta_, _abisa_, _بادلوں_,
   {{0x3290d126,0xe3b62009,0x2c79e007,0x6384d09c}},	//   _pulaar_, _значения_, _kérlek_, _aidsiifi_,
   {{0x8290206a,0x7bf5208c,0x9675a155,0x1340a1e8}},	//   _dekat_, _bestuurs, _ﻧﻮﺭﻣﺎﻝ_, _navetta_,
   {{0x95bd916e,0x79d6315e,0x90ca220e,0x1302c043}},	//   _министра_, _винтов_, _можности_, _lokakuu_,
   {{0x427e9069,0x0163d141,0x031753c7,0xf2dd3350}},	//   _itanu_, _будур_, _piezas_, _nikoliv_,
   {{0x929022ad,0xb29272e9,0xe27e0047,0x094c22f4}},	// [24e0] _tekau_, _upsala_, _erina_, _машинаар_,
   {{0x927e611d,0x861d1168,0xb30070a5,0x438610d2}},	//   _kuona_, _개인정보보호정책_, _senarai_, _сессиясы_,
   {{0xfa7e929e,0x926cc0fc,0xa2913207,0x10e7515a}},	//   _connaiss, _moloko_, _linkler_, _पोजीशन_,
   {{0x3348e0d8,0x704a3457,0xea09218c,0x6278823b}},	//   _aireamh_, _edificio, _nabasebe, _benisini_,
   {{0x027ed44d,0x13a630db,0x892e9041,0xd38743c9}},	//   _frend_, _декабрҙә_, _abachuku, _operam_,
   {{0x0b8d82b9,0x72926365,0x2d05f5ba,0xc26c82e2}},	//   _huancayo_, _enrage_, _akarorer, _dekore_,
   {{0x320090cb,0x93fc225c,0xb177306d,0x31840113}},	//   _owain_, _ءازەل_, _теотр_, _salaspil,
   {{0xeb13a024,0x03ce2336,0x1305a44a,0xb2d8030d}},	//   _श्रीमद्व, _agkvi_, _bumalik_, _kliem_,
   {{0xc27e9181,0x43dc92b7,0x630ca223,0x62ee93c6}},	//   _atanu_, _shawo_, _kilimanj, _inanahi_,
   {{0x9843438c,0x027e6036,0x5292622d,0xe2d8e29d}},	//   _централн, _buona_, _citaat_, _griene_,
   {{0x2394d689,0x725ad41a,0xe5992429,0xda08417e}},	//   _mbese_, _skolen_, _crescenz, _abdallaa_,
   {{0xe15c220d,0x323fd0bd,0x52b470fd,0x33a23004}},	//   _гурав_, _vermaak_, _manch_, _kumpul_,
   {{0x4f5f225d,0x3c06f1ed,0x22c3a009,0xa0d7d3d0}},	//   _remplace_, _korrupts, _umhlobo_, _киногоо_,
   {{0xcd5c21d9,0x652c1393,0x765ba288,0x029022c2}},	//   _تۇيۇپ_, _términos_, _ترغیبات_, _cekam_,
   {{0xa5eb00b8,0x29eeb2f4,0x2b7d413c,0xf4ff3083}},	//   _سرمایه_, _arduradu, _amonguer, _solució_,
   {{0x9a1fb07f,0x33eae1de,0x3b032155,0xb27ed0a3}},	//   _апрезиде, _centar_, _бурнумға_, _arend_,
   {{0x512d2009,0xcfda01c7,0xd2f74106,0x0a0032bd}},	// [24f0] _часть_, _бюджетке_, _shliabh_, _bajalefa_,
   {{0x0200c121,0x03f45164,0xe200b23e,0x1508520d}},	//   _valige_, _moutre_, _addina_, _kontrako_,
   {{0x83a96155,0xdf20f099,0xa25a90ef,0x807b4217}},	//   _بولدۇم_, _upresnen, _ajali_, _elemtälä,
   {{0x629120d8,0xbeac5407,0xb349a206,0x8230029f}},	//   _socair_, _meardere_, _imperii_, _akamola_,
   {{0x32e790a1,0x88d4e21d,0x5f65b0b0,0x0913748f}},	//   _alindao_, _निःस्पृह, _disampin, _театарск,
   {{0x953d2404,0xf70071e7,0x029271ac,0x03d3126e}},	//   _ايرانين_, _पतनशील_, _nasain_, _формай_,
   {{0x0241c213,0x14c880db,0x87b53213,0x0233b0fd}},	//   _jallumpi_, _наградла, _larusipx, _kanmenm_,
   {{0x2201f0d2,0xa6819231,0x3013812b,0xb20181fe}},	//   _equip_, _ग्रास_, _gondotro, _bayiko_,
   {{0x401b2427,0xa123b200,0x8e4d3007,0x33401011}},	//   _активен_, _lakiraña, _felfelé_, _cabecea_,
   {{0x727ed1f8,0xacf99048,0x663f30ae,0x005a9248}},	//   _krene_, _aktivně_, _endirili, _ኣፍሊጦም_,
   {{0xa7858388,0x9c84c009,0x53eae3e8,0x8c0782bc}},	//   _واشنتۆن_, _русских_, _tentar_, _amespot_,
   {{0x5eac925c,0x17a930fc,0x528824a2,0x6d238182}},	//   _دينارا_, _ихтирам_, _hastalığ, _nakshatr,
   {{0xce4e11bf,0xf25012a7,0x5928f30b,0x3e48f0d8}},	//   _дарде_, _десак_, _institūt, _barailea,
   {{0xd290408f,0xe27e03e6,0x13dc9051,0xb61f3248}},	//   _gemau_, _kuini_, _shawl_, _ትሪብዩን_,
   {{0x325bf240,0xc607e17a,0x19fd03ab,0x9a0925ab}},	//   _skulu_, _শতাব্দীৰ_, _interiér, _yabasebe,
   {{0xf26cc07c,0x5fc3a039,0x0cd1e03d,0x0386d31d}},	//   _soloko_, _joginder_, _abakungq, _azores_,
   {{0xcc758384,0xd149b271,0x85a61105,0xb27ed064}},	// [2500] _január_, _autobusy_, _קינגדאם_, _prend_,
   {{0xc68193aa,0xb294f5c1,0x929044de,0xdb881207}},	//   _ग्लास_, _znakovi_, _demat_, _tabirler,
   {{0xa3f473b0,0xc6739085,0xc304247d,0xee4eb4a2}},	//   _bestil_, _উপমহাদেশ, _barabal_, _numarala,
   {{0x927ed474,0x62fdf0c3,0x7f6a50c8,0xb60fe187}},	//   _bueno_, _drugu_, _padangos_, _adalangi,
   {{0x42257015,0xf26c2489,0x1a03a030,0x236830dd}},	//   _chakra_, _nemoze_, _darajada_, _vingers_,
   {{0xcc607086,0x2c0b822a,0x864042eb,0x7f2db42c}},	//   _nostris_, _približn, _radioemi, _beretnin,
   {{0x83f403ed,0x743443d8,0x4c1d9349,0x1a03a0c7}},	//   _kostet_, _umyalelo_, _romanfor, _qaramada_,
   {{0xb27e6381,0x471f30bb,0xf6dc4102,0x05daa2b2}},	//   _prono_, _збору_, _програмі_, _autorům_,
   {{0x5e464013,0x01f90040,0x13d45262,0x84ac3220}},	//   _enlazada, _bisaplah_, _kwamamaz, _bagashak,
   {{0x79f61352,0x4c6a114f,0x629215c1,0x729032ea}},	//   _سوریا_, _कृष्णं_, _ispalo_, _osmane_,
   {{0xc2ff5101,0x489a21a1,0x59a971b1,0x5f9ed297}},	//   _anrisir_, _erivativ, _почитать_, _محجوب_,
   {{0x9681a2e6,0xabee10b8,0xcf5d441d,0x23c91005}},	//   _क्रास_, _харом_, _magasabb_, _vakarų_,
   {{0x826ce0a1,0xe2fd405c,0x139490b1,0x89e063e6}},	//   _konoko_, _napisat_, _kaasi_, _tokorima_,
   {{0x8680701b,0x8b95a285,0xcc5ca018,0xc990509f}},	//   _delegasi, _katikkir, _centrul_, _atshwane,
   {{0x97740248,0x0394b00f,0xd9f25428,0x5307e13d}},	//   _ምድርባይ_, _eldste_, _borgarne, _dieburg_,
   {{0xb27e929a,0xc1b32096,0x840cb0f3,0x6bd95484}},	//   _orang_, _قاہرہ_, _penitenz, _aprengó_,
   {{0x226ce1d1,0xef361402,0x025a01b2,0xc28580af}},	// [2510] _honoho_, _hausaksa, _ndila_, _回答は役に立ちま,
   {{0xc2e0b49c,0x447c702e,0x92927334,0xaa7d4372}},	//   _gearradh_, _особенно, _ntsaim_, _mapasata_,
   {{0x4f310148,0x43f8c36d,0x325b903c,0x73dcd2e7}},	//   _paguyuba, _veluti_, _stylet_, _akewa_,
   {{0x131a2008,0x5158c018,0xa60bb295,0xc26c3693}},	//   _gözle_, _джермана_, _adamuchi, _ramoth_,
   {{0x0e5121bc,0x7914f1ba,0xbc5eb08b,0x127ff25d}},	//   _ابئيىرسى, _mercoled, _اسمارت_, _atuna_,
   {{0xd3eb40ec,0xd64c6085,0xf2d8d2d6,0xc3f87186}},	//   _vjetra_, _সেইসব_, _dilemu_, _monuc_,
   {{0x4b9d40de,0x13f980f5,0xcf183144,0x9f1e3024}},	//   _ئدارادان_, _beruf_, _anetibop, _निश्चिनु_,
   {{0xe26d8100,0xf2f1c5f6,0x12d8d062,0xee72c3d3}},	//   _karon_, _emissary_, _filemu_, _शार्प_,
   {{0xd394d086,0x63484207,0x4b2901ca,0xd26d8111}},	//   _yaesu_, _eklenti_, _ٹوٝریُک_, _jaron_,
   {{0xe3949387,0x13f8c35c,0x688e10f7,0x127034d7}},	//   _abaso_, _delusi_, _面皮做好刺洞_, _aragaram,
   {{0x997e44df,0x33f8e0ba,0x625ae4b5,0x527e9060}},	//   _afrikane, _minuts_, _shilin_, _arano_,
   {{0x52d9d395,0xf200e245,0x62d8c44f,0x4ecad05e}},	//   _adwen_, _umnini_, _homens_, _amanekin,
   {{0x05b764b2,0x730cc22e,0xc2932376,0xf9601047}},	//   _finalsty, _henares_, _bambanci_, _abangere,
   {{0x5f5d400d,0x33eb0246,0xf4fb80ea,0xfb4712c3}},	//   _nasaraan, _atatau_, _चिरायु_, _бардым_,
   {{0x927e923c,0x3d99f08c,0x32130202,0xad3f2061}},	//   _erano_, _resensie_, _ilahar_, _سڀاويڪ_,
   {{0x52fce22d,0x6c6273a5,0x3309211d,0xa300622c}},	//   _dingen_, _zifundo_, _lesbico_, _hanalei_,
   {{0xd2a751d8,0x5e1d50de,0x22eb9426,0xc876c14c}},	// [2520] _weebly_, _اتبايبى_, _agenter_, _ডেমোক্র্,
   {{0x02b2836b,0x8c909121,0x5f28925d,0xbc7f2180}},	//   _sondern_, _त्यों_, _entourer_, _しかしながら_,
   {{0x7967a019,0xd200d0f9,0x9ccb90af,0xf97cd063}},	//   _מגילה_, _tveir_, _円以上国内配送料_, _تامانیدن_,
   {{0x02365519,0x52fa245d,0x32da00dd,0x69595248}},	//   _vilje_, _michala_, _wesens_, _ክንብልን_,
   {{0x1cbc92df,0xd2d992b8,0x2c1c15cd,0x12fcf0dc}},	//   _matanitu_, _besef_, _kulungis, _exigir_,
   {{0x51bd22f3,0xa3f81008,0xcee85124,0x861f415a}},	//   _ништа_, _tohum_, _алалараз, _इकनॉमिक_,
   {{0x8bb360fd,0x526e6048,0x7dbee1e9,0x0e4ea358}},	//   _rankontr, _beroun_, _dinitila, _opiskelu_,
   {{0x1953d292,0x19e5f009,0x578b51aa,0x9ba52005}},	//   _декабрда, _утвержде, _абдуллин, _sutikimo_,
   {{0x173a338a,0x83f47018,0xf26d808c,0x1fe322cb}},	//   _долго_, _destul_, _karoo_, _شانتا_,
   {{0x3a8013a6,0xd1406076,0xd3f5027a,0xe4d5e121}},	//   _grandson_, _illegibl, _kristovi_, _गोपिका_,
   {{0xb2fdd1b8,0x3231915f,0x6a991296,0x4231639d}},	//   _teenboy_, _taimalo_, _abahumus, _formira_,
   {{0x73eae00a,0x92c5308c,0xb5d73598,0xbe7270e5}},	//   _center_, _heilige_, _geschich, _आलस्य_,
   {{0x327e0407,0x57b7517a,0xbb03b419,0x5d903030}},	//   _grins_, _অমিতাক্ষ_, _herramie, _آئینه_,
   {{0xa27f72b7,0x0af93133,0xb8fd2292,0x52f4c335}},	//   _kwanan_, _nakupuje, _istashad, _ospidal_,
   {{0x72d8d010,0xb36142a2,0x52d84402,0x427f6431}},	//   _bleed_, _cingcuj_, _gomeg_, _gagner_,
   {{0x827e9130,0xa2b9d05d,0x526d81fe,0xbd0b22c4}},	//   _trano_, _tudestg_, _aaroo_, _sutradar,
   {{0x53f87356,0x5613e12e,0x80d7c3bf,0xbe45f1aa}},	// [2530] _honua_, _programó, _николов_, _зыянды_,
   {{0xf38060e2,0x49c620e5,0xbf266284,0x0330b238}},	//   _bourik_, _कैंची_, _excluder_, _euskareg_,
   {{0x8098b105,0x4273b0f9,0xef6fb065,0x39012122}},	//   _הלברשטאם_, _tínum_, _ממזרח_, _dépourvu,
   {{0x726d82ee,0xa85f612a,0x0e17622b,0xa112107c}},	//   _taron_, _barreras_, _kegemila, _текстовы,
   {{0x62d9638f,0x81e53241,0x8832c0f4,0x027f7424}},	//   _regels_, _курмале_, _خاھىش_, _awanan_,
   {{0x41f5e263,0x4c5c2180,0xc047f434,0x9fe3f210}},	//   _дубораи_, _sætter_, _мислите_, _ommissio,
   {{0x92e6406e,0x53f8e45b,0xb27ef199,0x60e0c292}},	//   _पाठपुराव, _venuti_, _sugno_, _анави_,
   {{0x42e323a3,0x961c5009,0x52027192,0x327e6262}},	//   _peniaze_, _составля, _masimo_, _tronc_,
   {{0xd250c38c,0x026da1f3,0xa27f70e7,0x1a7df221}},	//   _један_, _napon_, _ndango_, _akunakus,
   {{0xaaff539c,0xa5817188,0x7c729431,0x6344332b}},	//   _المفردات_, _ennersch, _extrait_, _bandiau_,
   {{0x6580e0fd,0x36f2803b,0x48c0b264,0xa26da22e}},	//   _federasy, _angabekw, _الجذور_, _hapon_,
   {{0x43f9842a,0x56331104,0xfa65208a,0xaa52b1fa}},	//   _terug_, _bienveni, _طبیعي_, _bohelela_,
   {{0xb27e0161,0xe26ce285,0xa2cae1f3,0x926d04ad}},	//   _asina_, _nonono_, _mondom_, _boboko_,
   {{0x1c53f44f,0x33952063,0x22010023,0x6d7f83a5}},	//   _contato_, _qaysi_, _abbire_, _kwamanye_,
   {{0x026e6290,0x9a091288,0xc292611b,0x8ae45087}},	//   _strona_, _حقيده_, _upravo_, _albumdat,
   {{0xf3f851d0,0x7ca0b0b2,0xca9f610e,0xd758d121}},	//   _illum_, _lausneeg_, _papieros, _स्त्रीक_,
   {{0x2520204d,0x0d0d401b,0x82137177,0x027ed234}},	// [2540] _beannach, _dolanyşy, _baahen_, _stenu_,
   {{0x025ae011,0x025b518f,0x876dd077,0xc2f741f8}},	//   _atilde_, _stellt_, _adiyelof, _velikih_,
   {{0x8f628242,0x9b847083,0x326da2a5,0x5e572419}},	//   _katalogs_, _акциялар, _aapon_, _alicante_,
   {{0x62636050,0xb3b17064,0xb9bcd33c,0x19c33264}},	//   _어서오세요_, _chaque_, _بیداوسوا, _شامبو_,
   {{0xa3f965ba,0x2eab5221,0x59a423bf,0x63f460f7}},	//   _maguru_, _kunokwen, _опция_, _plutot_,
   {{0xf290415b,0x82b474a5,0xb3033115,0x0305321d}},	//   _semak_, _sancu_, _achabat_, _abravam_,
   {{0x57aa403c,0x419990e8,0x5394e440,0x3b5650a2}},	//   _battagli, _problemy_, _priska_, _جاسوسان_,
   {{0x8f2fc449,0xe292522a,0x03c2f283,0x73cef45f}},	//   _justicia, _ostalo_, _incwadzi_, _živin_,
   {{0x138f6031,0x925bf2f6,0xbfcc707f,0x8fb82245}},	//   _ለዘለቄታው_, _ukuli_, _иадҧхьал, _ebloemfo,
   {{0xbb6c6083,0xb685131d,0xee87325c,0x6251714c}},	//   _expressa_, _prudenci, _ءارجىلى_, _সান্টা_,
   {{0x8a8860ee,0x725bf42e,0xcd3ab4ad,0xa27ff1cf}},	//   _moderáto, _skuli_, _athikele_, _stung_,
   {{0x027e6228,0x7290d191,0x19e8023f,0xb3f402ca}},	//   _drona_, _idear_, _alongada_, _costat_,
   {{0xa95a442f,0x8c00d2cd,0x1f36203d,0x6b0fd0de}},	//   _evelopme, _vertrags, _abasekra, _اكتەرۇ_,
   {{0xac6ac1fa,0x6290c3af,0x37a8d01a,0x02d8b16e}},	//   _mahungu_, _golaeh_, _асаба_, _организу,
   {{0x00f39019,0x0bf2d007,0xc2bc937f,0x736733dd}},	//   _נאטור_, _kattints, _goodall_, _partijam,
   {{0x1db62102,0x8f2be114,0xd94fe187,0x93044167}},	//   _burgoyne_, _semestin, _adalenge, _achatam_,
   {{0xe43f3026,0xe5c27328,0xe2e9009b,0x03f2b5b5}},	// [2550] _대전광역시_, _angayukh, _wasilla_, _verzije_,
   {{0xaaf7c196,0xa3952244,0xdf8ed212,0xaba7b258}},	//   _хандан_, _mayst_, _دماين_, _ulikkaar,
   {{0x93f40153,0x6200c127,0x26823419,0x99e18105}},	//   _postat_, _voliti_, _accesori, _הכּלל_,
   {{0xfbe7d171,0x1200d0cf,0x6290f172,0x1b73935b}},	//   _ارادو_, _maliit_, _segae_, _товару_,
   {{0xba15d140,0x6172c407,0x33ead102,0x027ed24a}},	//   _куллану_, _wikipedy_, _deltar_, _utens_,
   {{0xdd3e30ce,0x75f84152,0x127ed0af,0x82093180}},	//   _kialakít, _виртуаль, _dreng_, _タッチタイピング,
   {{0x1c52c038,0xfb8ac20c,0x6290008f,0x42d983f3}},	//   _तिथेच_, _vyananir, _seiat_, _majorur_,
   {{0xa200c278,0xe27ff1d0,0x5ea8e368,0xdc15230f}},	//   _kolisi_, _itune_, _diatheke_, _विक्रेत्,
   {{0x0b2b8009,0x41582365,0xa3f3a276,0x62f4528f}},	//   _исследов, _demolish_, _عقلمند_, _asuntos_,
   {{0xd25bf26b,0xf27e0249,0xdbf1f23e,0x006780f4}},	//   _mkulu_, _quint_, _ajiliyao_, _аллиқача,
   {{0xfc52f67f,0x83007029,0xe1192251,0x92e8d2b7}},	//   _kontoen_, _kaharti_, _границит, _almizan_,
   {{0xfc6ac4f3,0xf25bf4ec,0x94fd41bf,0x1f39e475}},	//   _bahungu_, _okulu_, _локалитэ, _meluaska,
   {{0xd57dc026,0x01fd7008,0xc37903e6,0xd2bbd36f}},	//   _엔터테인먼트_, _dabarasy_, _peratia_, _bokelle_,
   {{0xf25a02e1,0x8130202f,0x9200c247,0xf2b2e032}},	//   _idile_, _مجبوره_, _haline_, _haldinn_,
   {{0x834c32bc,0x9291830d,0xb85964ec,0x30a7d198}},	//   _eigedom_, _ingliż_, _kitaplar_, _животна_,
   {{0xa2fdf11b,0x1200c199,0x9420d245,0xe8625136}},	//   _drugi_, _bolisi_, _alwaziyo_, _asanblad,
   {{0x2f14a520,0xf2cae0bd,0xa8098241,0xf440b1aa}},	// [2560] _formater_, _rondom_, _бикамера, _atakisik,
   {{0x926dc0f5,0x923c6086,0x998410a4,0x721c0166}},	//   _davon_, _faxmail_, _batimala_, _rashmi_,
   {{0xefbf3012,0x30dae248,0x82d8f09c,0xdd1463b0}},	//   _محنتي_, _ምዕቃብን_, _algee_, _holstebr,
   {{0x6316d44c,0x73eae146,0x62d9b283,0x826cf2bd}},	//   _pieza_, _gentar_, _abanjwe_, _moholo_,
   {{0xe25bf399,0x10dfa15e,0xf200d185,0x4850b2c9}},	//   _nkulu_, _америкчу, _manine_, _salonund,
   {{0x1fe0d0c8,0x0e46333c,0x925bf223,0xe2d8d0ff}},	//   _komisijo, _tumanida, _ikulu_, _bleek_,
   {{0x927ed033,0x62d83351,0x86f50222,0x72e750ec}},	//   _trenn_, _remeni_, _partabrø, _gjenden_,
   {{0xc1475694,0x627e0080,0x12902113,0x42457102}},	//   _desenvol, _drini_, _nekas_, _стартово,
   {{0x82c3b1d6,0xf62e4185,0x926e6075,0x4528b03a}},	//   _luhlelo_, _mpofirim_, _otroka_, _lokipasy,
   {{0x47314664,0x76c6f217,0xb934404b,0xc75a30f9}},	//   _uspostav, _куллануч, _ahamiyat, _vinnulig,
   {{0x783ea124,0x6289208d,0xb291409c,0xcb1601b3}},	//   _ассоциац_, _ambalani_, _abdatu_, _componit,
   {{0xa4a24217,0x74ebf248,0x951cc2ea,0x02960340}},	//   _başladı_, _ሕርሕራይ_, _zakonish, _експерие,
   {{0x44fc732f,0x0290246e,0x3300e148,0xd3bfd010}},	//   _мобилӣ_, _mekas_, _maraneh_, _wayward_,
   {{0x62646240,0xce3c2081,0x8b8f8428,0x7278613d}},	//   _skuldi_, _attaveqa, _opinberr, _barnim_,
   {{0x53f1430d,0x53967169,0x19c72192,0x38e0d011}},	//   _esportaz, _lossen_, _хаталар_, _ahasamiv,
   {{0x42365428,0x45a74263,0x8b0d6253,0x62d84231}},	//   _vilji_, _гуруснан, _aseseina_, _domek_,
   {{0x8bb53009,0x6d8bb3f2,0x960bb3f2,0xeea4512a}},	// [2570] _amahlelo_, _kwamabha, _kwamabhi, _accusate_,
   {{0xd21d706a,0xd50d60d7,0x431920de,0xc2c971d0}},	//   _maskapai_, _корбанна, _ئيمان_, _skylook_,
   {{0x6d0733ab,0xf31693a5,0x5ae17152,0xb6a5f1c3}},	//   _testovac, _anazi_, _syntynee, _burraidh,
   {{0xfe5fe114,0x984ce04b,0x22d8907d,0xc9d0c0f6}},	//   _pembiaka, _портлати, _flaem_, _векил_,
   {{0xe1b7517a,0x4213766f,0x227ed05e,0x72d80238}},	//   _কামেই_, _baahan_, _neongo_, _alies_,
   {{0x195111b3,0x0b2fb248,0xd27f04b4,0x828d507d}},	//   _autocrat, _ምስፍሕፋሕ_, _franis_, _hetkota_,
   {{0xca7cd08d,0x30921057,0x5413d0f9,0xd4ecc1a2}},	//   _bananisa_, _елефанць_, _innsetan_, _поступле,
   {{0x7d8ba008,0x8876c48f,0x8638937e,0x41d1d144}},	//   _derejede_, _периодот_, _shanduki, _alelicem,
   {{0x527e026a,0xb3f85206,0x65ffa1ca,0xb2d80521}},	//   _using_, _solum_, _مویوٝس_, _flier_,
   {{0x12b52169,0x215f22e8,0x6200c1fe,0x2ec870ec}},	//   _sondage_, _coinnigh_, _galile_, _ekzisten,
   {{0x926e6115,0x529020b0,0x7b0d2004,0x54c870d7}},	//   _patois_, _bekas_, _کشیدن_, _тарафдар,
   {{0x6cc6713f,0xf26de004,0x1f4c9205,0x92a06287}},	//   _אינסטלטו, _katon_, _disprove_, _klubai_,
   {{0xe2ee9238,0x62d820c9,0x2262120d,0xcb4422f4}},	//   _bianchi_, _boken_, _аврах_, _гүний_,
   {{0x3ca663e7,0x32da00cc,0x32e5e0d9,0xa1c3c517}},	//   _adiratig_, _deseas_, _aponaka_, _половин_,
   {{0x9dcb8250,0x2386902a,0xd26c7155,0xb34d31f3}},	//   _akālai_, _stifling_, _көкйөтәл, _keresem_,
   {{0x04dfe050,0x64734224,0x86470150,0xd14b919a}},	//   _以上分辨率_, _diketelo_, _forklari, _effeithl,
   {{0x668a60f7,0x18524033,0x226de110,0xa25bf2e1}},	// [2580] _中小企业服务月专, _aprofond, _naton_, _ajulo_,
   {{0xd2787005,0x8cda7108,0x32bbc144,0x20bed06d}},	//   _pernai_, _видеобло, _aphenye_, _киеву_,
   {{0xb9673040,0xa9d180b2,0x9a08819e,0xe9a58018}},	//   _believet, _muitimed, _honatana_, _куражул_,
   {{0x187481bd,0x599c9076,0xb2d8421f,0xa2925164}},	//   _časopisy_, _kaikaina_, _komei_, _antame_,
   {{0x0386b0d2,0x727e916d,0xd3b603ea,0x62b4f095}},	//   _podria_, _drann_, _amavala_, _alicht_,
   {{0x63ce04bd,0xd9bf32f4,0x7849e0bb,0x43f871bb}},	//   _caiva_, _hemerote, _призначе, _konum_,
   {{0xb0b205a4,0xb33d04f5,0x4ad7d56c,0x40ba15b1}},	//   _מחלוקת_, _بیمار_, _прилика_, _кативашл,
   {{0x3b226240,0x22b584f1,0xbc53118e,0x303e80be}},	//   _trupulle, _garci_, _apatman_, _mbeturin,
   {{0x2adf3074,0x9ba5103d,0x65a484cd,0xe7e3d1bf}},	//   _komunite, _abakwabr, _radiació, _позицие_,
   {{0xf349e122,0x44b8b27a,0xc60491d4,0x3c6f71c9}},	//   _parenti_, _podpisuj, _kommuuni, _serrana_,
   {{0x53ce0374,0xa148e2eb,0xd407a524,0xd2b5801f}},	//   _raiva_, _contralo, _बहादूर_, _barci_,
   {{0xf26c51d0,0xf3f27588,0x627e9405,0x63ce00fb}},	//   _mylot_, _عبدالحمی, _crann_, _saiva_,
   {{0x33ce0397,0x43f8a3a8,0x93d720f7,0xe224f0ec}},	//   _paiva_, _gobug_, _心理健康方面的课, _ndikim_,
   {{0xb3f87086,0xdc1422fd,0xc2b50227,0xcc53e248}},	//   _bonum_, _هوونه_, _klacht_, _ኣሳናዳኢት_,
   {{0x60e7c15e,0x93ce035e,0x9c6305f3,0x3290d25d}},	//   _агентлаг, _vaiva_, _situado_, _malamu_,
   {{0x52da723c,0xc25b019a,0x1e1b53bf,0xc029e358}},	//   _essere_, _ofalus_, _progetta, _применяе,
   {{0xb2dac165,0x1295a2a8,0x625b4140,0x558731bc}},	// [2590] _können_, _tamariki_, _itelde_, _زارئينا_,
   {{0xc3f452d2,0x1ef6316e,0x026cb12b,0xd27f90d7}},	//   _hatten_, _настала_, _didoro_, _kaynar_,
   {{0x4a33d192,0xb0eab00a,0x94296388,0xe26de2b7}},	//   _поездан_, _tranquil, _مولازم_, _zaton_,
   {{0x92904290,0x2e4ec32f,0xe248c2d2,0x530052ab}},	//   _temat_, _пайдо_, _zimmer_, _nelabai_,
   {{0x538741e9,0xd1b9b1a2,0x93eae4dc,0x4fbdb133}},	//   _iperom_, _исправит, _dentur_, _nealkoho,
   {{0xa185f1e2,0xd887015f,0x5caa605b,0x52d5100f}},	//   _туркия_, _atukkiru, _خاندۍخند, _collett_,
   {{0xcd8c03d5,0x1205b2f8,0xad07c2f4,0xf290428e}},	//   _verdiene_, _bilicaki_, _чамгүй_, _kemas_,
   {{0x63cb5437,0xb9802009,0x9c187653,0xdd1ab320}},	//   _নভেম্বৰ_, _bavikele, _despois_, _phununet_,
   {{0x5c0472c8,0xd3078093,0x82904419,0xe653931e}},	//   _kristni_, _dibawah_, _demas_, _bakkanam_,
   {{0xdd105128,0x904a0069,0x64278012,0x5a729343}},	//   _stalwart_, _ugereran, _پروفائيل_, _aigaatua_,
   {{0x4981f009,0x758e60d2,0xd641004a,0xec5c1428}},	//   _belivike, _райондук_, _adzikami, _listinn_,
   {{0x7248c59c,0x52f9d1ca,0xf549e210,0x5200c31e}},	//   _simmer_, _وتھرٕ_, _oughtsth, _boliwi_,
   {{0xdd90105a,0xa27ff15f,0x8a7e81e0,0x627e6336}},	//   _берди_, _atuni_, _sceleris, _akonakii_,
   {{0x32d84206,0x3a520130,0x2a8a52ca,0xdf9512db}},	//   _nomen_, _firenena_, _майданын, _geldiler_,
   {{0xefda31da,0xab05a286,0xfaeb5205,0x325ad07e}},	//   _arazitan, _grignion_, _betterme, _skolan_,
   {{0xc3eae4dc,0x73f812ae,0x45840421,0x82919395}},	//   _gentur_, _kohus_, _abdulaaz, _sesaa_,
   {{0x3290215d,0x47739311,0x227e91f8,0xb2d4617d}},	// [25a0] _cekap_, _тойлары_, _hranu_, _kauden_,
   {{0x1d66307f,0xc291f4de,0xbd9d42e5,0x99f952db}},	//   _аинрал_, _dizale_, _generuje_, _medisina_,
   {{0xe136e041,0x2a71c3f3,0x7bdfd287,0xb3e49287}},	//   _عراقي_, _útlendsk, _зьлева_, _бульбы_,
   {{0x0212d4b2,0xd317744c,0xc3aa442c,0xf50da16e}},	//   _tinhte_, _plazan_, _gravide_, _животиње_,
   {{0x1ca92217,0xb99d2141,0xf2902322,0x03ced25b}},	//   _кабинеты, _сатын_, _afkan_, _stovna_,
   {{0x01bfa065,0xc27e6083,0x83f47007,0xfcf17071}},	//   _עצבני_, _osona_, _őstag_, _spitiger,
   {{0x127e90da,0xb2e3101b,0x63f72183,0xe3869315}},	//   _granu_, _dilinde_, _consenti_, _azard_,
   {{0x4b810075,0x9b2d206e,0xf7450180,0x8aea521f}},	//   _govorimo_, _jembatan_, _この部分はインラ, _emetsime,
   {{0x925a0642,0xf20101cc,0x72fc5180,0x63f8a1e9}},	//   _deild_, _jebiga_, _socialt_, _tobul_,
   {{0xa3cff04a,0x64d9f287,0xb304406a,0xa2e6e407}},	//   _nguva_, _праведзе, _mahakam_, _njonken_,
   {{0x82fce22d,0xf25a92aa,0x4200c101,0x84b8911b}},	//   _gingen_, _adala_, _bolivi_, _гитарист,
   {{0x6201010c,0xe27e9086,0x8d80e02a,0x9ddc3264}},	//   _labile_, _erant_, _farmstea, _الغوص_,
   {{0xa3410352,0x42fce2e9,0xa9d3b140,0x074bb096}},	//   _بنیات_, _bangli_, _бердәнбе, _ایکسپلور,
   {{0x225a9203,0x5394b189,0x63827155,0x7200c1ca}},	//   _ddala_, _često_, _مەخپىي_, _keliya_,
   {{0x22fd0137,0xe394d11d,0xe3f46053,0x475de544}},	//   _mabilis_, _mbesa_, _karten_, _bayitang,
   {{0xdf309420,0xf9be7085,0xca57c16e,0x59c1f41b}},	//   _tarafınd, _স্মৃতির_, _финала_, _verduide,
   {{0xc25a01c3,0x427e9026,0xaaccc050,0x01946031}},	// [25b0] _seilg_, _krant_, _一個受害者_, _በተሰማሩበት_,
   {{0x036482fa,0x1d5b6212,0x794fe187,0x56b19121}},	//   _langton_, _ababhinq, _adalonge, _सत्तो_,
   {{0xe8152052,0x82d963b0,0x4f8c9003,0xbdece0c9}},	//   _sacensīb, _mogens_, _हक्का_, _ситуацію_,
   {{0x0976c09e,0x2394d023,0x3249f2c0,0x0c615428}},	//   _podignut, _abesa_, _awuma_, _lestrar_,
   {{0x0b9711e2,0x62904004,0xb3a2c1a7,0x684aa04a}},	//   _таслим_, _semar_, _compus_, _akamboku,
   {{0x9c774290,0x198e120d,0xb30501e6,0x35ce1370}},	//   _पूर्वक_, _тариа_, _savanam_, _тарма_,
   {{0xff471083,0x430ca249,0x650b647f,0x9262f0db}},	//   _comprova, _uffants_, _recuerdo_, _baboloki_,
   {{0xcba29223,0x2201030c,0x427f701d,0xb374125d}},	//   _عبداللطي, _habile_, _mwanin_, _bifungam,
   {{0x325a9094,0x7a39c0b9,0x42f45095,0x327f017e}},	//   _udala_, _медени_, _slander_, _amanuu_,
   {{0xd1d0442f,0x4d89e3c9,0xc7bd12a7,0x6419a0f8}},	//   _olderhay_, _ostendit_, _متخصصلر_, _темасын_,
   {{0xe39542b2,0xbb3aa009,0x0cc52127,0x7fb47105}},	//   _šesti_, _статью_, _batinamu_, _הארלעם_,
   {{0x8290c43d,0x1249e2b1,0xc25a001d,0xfc7c5113}},	//   _ibland_, _malerezm, _feile_, _centrā_,
   {{0x525a03b3,0xe1b33288,0xf27e90d2,0xc37811ba}},	//   _neile_, _ژانری_, _grans_, _vacanza_,
   {{0x06d9f196,0x43cf4418,0xd2d82235,0x568b6031}},	//   _аравдуга, _jeevan_, _tokes_, _የምረጡኝ_,
   {{0x73eab4b3,0xf25a05bb,0x32bfc1ca,0xbee10100}},	//   _þetta_, _heile_, _ژمٹاں_, _backless_,
   {{0x6507d38f,0xeb2b65d1,0x328f60bc,0x485840e4}},	//   _allemaal_, _ogmantas, _adahuns_, _ankonsid,
   {{0xcc6f035f,0xa5cb20cc,0x3cf1f12e,0x52a460af}},	// [25c0] _doprava_, _গোপনীয়তা_, _instytuc, _広島県広島市中区,
   {{0x33bc2264,0xa25ac14d,0x0bfd824a,0x92eb501a}},	//   _بلغنا_, _millal_, _geweldic, _cognoms_,
   {{0xc3eae38b,0x54eac064,0x756ac064,0x12f20213}},	//   _toitim_, _第三十二条_, _第三十五条_, _camillu_,
   {{0x2d6f2078,0x7200b1de,0xeac791ca,0x3f6c734e}},	//   _رحلات_, _jedina_, _پرناوِہے_, _ababkhon,
   {{0x7ae0f36f,0x3a4c9245,0x5b48e370,0xb986f0a4}},	//   _basebets, _nendlela_, _басташав, _cibitaka_,
   {{0x281522bd,0xd34461ce,0x4e93e102,0x5e92f064}},	//   _турала_, _lucerne_, _формах_, _contient_,
   {{0x3eaa727c,0xe25a03ea,0xe23183c7,0x0c1cd455}},	//   _この回答内容が不, _ndilo_, _primero_, _albumlis,
   {{0x33fa61bb,0xa27e9175,0x539673d2,0x62027351}},	//   _avrupa_, _brans_, _possan_, _ajrihi_,
   {{0xd201a2e2,0x6da793d9,0x394cd057,0xcdfa0439}},	//   _navige_, _bogokaha, _мыния_, _simeulue_,
   {{0x60b96248,0x639661ec,0x927f5111,0xafadb033}},	//   _ኣጽዋርን_, _bouson_, _prenis_, _dekontro,
   {{0xf27e011d,0x531694d6,0x3f2fb2a1,0x82d84513}},	//   _usina_, _fainting_, _pertania, _nomes_,
   {{0x075a2059,0x03949018,0xfae41105,0xa200d4f6}},	//   _ምግባርና_, _acasa_, _ראפשיץ_, _splitu_,
   {{0x927862c1,0x7290e2d9,0x727e9202,0x1999d45d}},	//   _okundu_, _asiane_, _asana_, _neexistu,
   {{0x02f510f3,0xedb511ba,0xc645f0fb,0x4962323c}},	//   _stagioni_, _stagione_, _प्रतिनिव, _поставя_,
   {{0x2682c113,0x3b2d311a,0xc31c55bd,0xa3dcd089}},	//   _novembri, _tambayan_, _liecina_, _chews_,
   {{0xf3946084,0xfc5741d7,0x8133245f,0x73947251}},	//   _abosi_, _partake_, _toaletní_, _sério_,
   {{0x498ec102,0x63dc03a7,0x7847c1e2,0xab3a50c5}},	// [25d0] _самим_, _njiwa_, _санади_, _amabahas,
   {{0xd386053a,0xbcef42fd,0xf99b8296,0xe27e022e}},	//   _nzira_, _مستردام_, _abakhile, _tsina_,
   {{0x4bd7c030,0x6c339105,0x2f052241,0x83ea90ec}},	//   _билдим_, _פאניק_, _курате_, _faktet_,
   {{0x92da0086,0x1200e381,0xd7daf4dd,0xca02513c}},	//   _essent_, _ceniza_, _gruppeei, _вериковс,
   {{0x22d8413f,0xca8f31ca,0x0417e067,0x62921078}},	//   _homes_, _aaminsan_, _estrojin_, _capall_,
   {{0xf909c057,0xc3f85378,0xf9c2a387,0x8277c39c}},	//   _сепара_, _allur_, _abimbola_, _сайман_,
   {{0xc69c2036,0xfbdde358,0xe909d292,0xecb7b1b1}},	//   _достатъч, _сочетани, _бедарак_, _границы_,
   {{0xe2d84052,0xc27ed3f7,0xf2ca6161,0x306960c2}},	//   _domes_, _grenn_, _svoda_, _adopshen,
   {{0xe2919500,0xac5b302e,0xb25db0be,0xb5c7d439}},	//   _hesab_, _minulle_, _perendim, _kotamady,
   {{0x327e9089,0x552cb192,0x9749102f,0x13eb7238}},	//   _drank_, _контролд, _عبداله_, _statud_,
   {{0xe1f3d0fb,0xa3f850b2,0x9429c004,0xf31362a0}},	//   _शनिवासरः_, _lolus_, _tampilan_, _روناکبیر,
   {{0x12d8409b,0xf3860695,0xc4184358,0x88d2d096}},	//   _homer_, _azira_, _tekniikk, _دیےگئے_,
   {{0x941e45ef,0x02002414,0xe3fa0250,0x0778509f}},	//   _kiganiro_, _bukid_, _pupule_, _почтамты_,
   {{0x2b5ed1c7,0x42d8d0b2,0x6c7d7047,0xa96e616b}},	//   _әрине_, _plees_, _obusika_, _ospitant,
   {{0x226de3e6,0x152dc083,0xd63ec246,0x14007392}},	//   _katoa_, _трагедия_, _filifili, _मृतदेह_,
   {{0xb7bfc30f,0x943e31ca,0xb84e32d2,0x38274083}},	//   _इतिहासात, _kkkkkkkk, _erstmals_, _بابالا_,
   {{0x426de2aa,0xf2fce3c6,0x47602404,0x2a7f5395}},	// [25e0] _matoa_, _hangai_, _علاوهه_, _pirapira_,
   {{0x02d84140,0x0800007f,0x823070c5,0x063550f7}},	//   _gomer_, _амшхәаҧш, _aramira_, _新华网北京_,
   {{0x8a3fc11c,0x6418608d,0xc200d21c,0xe202720d}},	//   _جمادى_, _amihandz, _droids_, _hasiko_,
   {{0xf887d2ab,0xfc4fe597,0x42fce044,0x2341b284}},	//   _каманда_, _अमानवीय_, _mangai_, _objecto_,
   {{0x041e4181,0x126e6319,0x32fce0c8,0xb9cd612a}},	//   _biganiro_, _autoxp_, _langai_, _advertit,
   {{0x83eab2bd,0xfe518020,0x826de062,0x76cbd374}},	//   _kgethe_, _essagema, _aatoa_, _achashai,
   {{0x4201445c,0x89c17220,0x0b0d63e4,0x8977d2bf}},	//   _fafine_, _banezere, _iseseina_, _cashizwe,
   {{0x2edd4013,0x02db7008,0xf8c5c0af,0x8c60b25f}},	//   _misiones_, _günden_, _の検索結果_, _scarred_,
   {{0x422571e2,0x70e2709a,0xc3ecd51d,0xe249048e}},	//   _abakwa_, _بەرىبىر_, _یشتمه_, _siambr_,
   {{0xc3943374,0xca0a923b,0x3bfb5029,0x3136c30f}},	//   _samson_, _bulabula_, _pangawer, _mendownl,
   {{0x0c686229,0x4c34e407,0x2d2ad0c9,0x77b603c1}},	//   _annunci_, _kompetys, _кредитно, _taxering,
   {{0x92fce0d4,0x4a166434,0xb2efb09c,0x426cc17a}},	//   _dingin_, _отклонен, _abdissa_, _sydow_,
   {{0xa2fce240,0xb051d369,0xe15f60c8,0x025a926b}},	//   _eingin_, _fürstenf, _energijo, _ndale_,
   {{0x6ec5912a,0x67347282,0xb2fce222,0xe98171fb}},	//   _binomios_, _דאַקעגן_, _fingin_, _yariyeme,
   {{0x4200b04b,0xde4f5102,0xb9ddd1f1,0x43949248}},	//   _oldini_, _arealpla, _dependie, _mbasi_,
   {{0xec606284,0xfd2de2e2,0x554520ef,0xdae5114c}},	//   _bestias_, _rekipere_, _زبيده_, _খাগাইল_,
   {{0xd2d844d2,0x314e3453,0xb3caa0d7,0xfbfe04da}},	// [25f0] _tomer_, _kentelio, _duması_, _valorado_,
   {{0x13ce01e6,0x6c1d2222,0xec989050,0x888831bf}},	//   _naiva_, _uttangar, _一下去是自助式的_, _фестивэ_,
   {{0xe2266182,0xf3626024,0xac37f296,0x080a4041}},	//   _shukra_, _acetasaḥ_, _вароруд_, _akuchong,
   {{0x72b5800a,0xcdbee563,0x9b015053,0xe2b3f0e9}},	//   _march_, _unzanire_, _sonstige, _galdino_,
   {{0x39d1a1b6,0x621370b1,0xefad130c,0x4b98d3e8}},	//   _ཌེཝིཌ_, _kaahin_, _opposito, _feminino_,
   {{0x67f4913b,0xc32611d9,0x137f30b1,0x2d91e1f1}},	//   _algautig, _قارىسى_, _ummadda_, _cantidad_,
   {{0x525ad0e7,0x05bcd309,0x7254e1a2,0x325a908a}},	//   _edela_, _boyajlah, _soveltam, _adale_,
   {{0x73377252,0x974f90fb,0xaf83d3aa,0x7ef1313c}},	//   _климатты, _चिकित्सि, _उल्का_, _астатиа_,
   {{0x52da617a,0xfc6f602d,0x82fce478,0x3c1bd038}},	//   _barend_, _vetrina_, _singin_, _pekanbar,
   {{0xd3eac056,0x52fce004,0x9dbc93e6,0x8292601f}},	//   _kgothe_, _pingin_, _matakite_, _birane_,
   {{0xe3eba60b,0x8e9530f1,0xa9514249,0xf3f5c04c}},	//   _texter_, _imiterte_, _porscher_, _مبتذل_,
   {{0xba15a215,0xea0a91dd,0x3c5d9053,0x7f3aa048}},	//   _članaka_, _culacula_, _zentrum_, _turistů_,
   {{0xd92f6009,0x027ef007,0x3f15b386,0xb236716b}},	//   _enomthet, _akinek_, _tendelan, _linji_,
   {{0x92fce137,0xa9e4a161,0xd160b44b,0x22510105}},	//   _tingin_, _vakomana_, _blogginl, _מעקדאנעל,
   {{0xf2914098,0x371bf05b,0x13f85086,0x5f2122a1}},	//   _madamu_, _summativ, _solus_, _diperken,
   {{0x3386e0ae,0xee7ec3b9,0x550011d9,0x983ed2c0}},	//   _etiraf_, _محسنی_, _اقباراتت, _begloowu,
   {{0x93ce0696,0x0201b696,0x5325916d,0x8b98d1f9}},	// [2600] _faiva_, _tevita_, _mischii_, _गुरुचरण_,
   {{0xf4982248,0x73274256,0xe30f6490,0xc4133388}},	//   _ጸሓፉልና_, _amacumu_, _empawer_, _قانده_,
   {{0x4134c217,0xcc1bc58f,0x4287316c,0x98b6b579}},	//   _алдылар_, _printeru_, _etablism, _بانزاسى_,
   {{0xcc5d946c,0xf679c2fc,0x595cb25d,0x26c5137a}},	//   _sentrum_, _региону_, _bakomibe, _amashush,
   {{0x7ed400bd,0x127ed3ce,0x82fe8022,0x94a32008}},	//   _inligtin, _grens_, _корпусын, _йорелге_,
   {{0x22fcb3ef,0x69c62086,0x3fd1f198,0xa20733de}},	//   _legibus_, _wavesynt, _assistir_, _prikriti_,
   {{0xf6cb1630,0x1fa1a048,0x929ff116,0xdf5d21a0}},	//   _agradeci, _parkoviš, _ईतिहासिक_, _votaflan,
   {{0xbc6f6429,0xfc6e10ef,0xdc96328c,0x112a0104}},	//   _larrosa_, _nyaraka_, _занята_, _encontré_,
   {{0x231602c9,0xfd0a500b,0xa0bea031,0xf2fcb3d5}},	//   _faizi_, _februaar, _መዘገባችን_, _sosialt_,
   {{0x227e946c,0xdc5743ab,0xe9c72381,0x4691e252}},	//   _trani_, _dostane_, _мацара_, _ئشتەگەن_,
   {{0x838662a2,0x86ccb325,0x53164697,0x22da62e8}},	//   _cenzvei_, _belastni, _zombini_, _spreag_,
   {{0x5b6d9449,0xa7687248,0xda91a07e,0xca7b62bc}},	//   _neumatic, _ቤተሰባዊ_, _händelse, _avnotatb,
   {{0xf6a60585,0xad3ef180,0x562e520e,0xadc18365}},	//   _viethiph, _初めての方へ_, _заборави_, _boritima,
   {{0x25be20b7,0x31772043,0xa29262ea,0xa1e733f9}},	//   _друге_, _месте_, _tirane_, _знати_,
   {{0x320ec39c,0x79fa40ff,0x82d7512f,0x6af721bd}},	//   _қалар_, _vacature, _ﻣﯘﻫﻪﺑﺒﻪﺗ, _dovednos,
   {{0xa27ff4b2,0x9e53e306,0x328aa0ea,0xa26474ec}},	//   _trung_, _ababenga, _ज्योति_, _teslim_,
   {{0x22eba642,0xa29093a9,0x1a748218,0x6291b123}},	// [2610] _stendur_, _afaan_, _ranganna_, _aswafe_,
   {{0x7f3090f8,0x0e3fa037,0x93c5e292,0x56def0ea}},	//   _tarafınn, _иденты_, _ماموری_, _परिणामले_,
   {{0xa305b15f,0xd941409f,0xc320e38d,0x7200c2ab}},	//   _qilamik_, _atoloset, _abiyee_, _galime_,
   {{0xf31603fa,0xeec573f7,0x16499136,0x9610f187}},	//   _saizi_, _prizonye_, _тендерт_, _adalandi,
   {{0x3343c0c9,0x426db262,0x65fe124e,0x525ae17d}},	//   _голова_, _segiteri_, _مسلمانی_, _muille_,
   {{0xb237801f,0x2301a20f,0x74fb3337,0xe6f700de}},	//   _taimaka_, _babayev_, _क्यारे_, _بالاسنا_,
   {{0x52fe606a,0x8a67214c,0x5b67c358,0xa2cae698}},	//   _dirilis_, _হরিদাস_, _газете_, _fundou_,
   {{0x827f90fb,0xa19c6264,0xb3f45521,0x90627392}},	//   _krsno_, _فتافيت_, _gatten_, _ओरिसा_,
   {{0x45203395,0xb200b1d5,0xf29412c0,0x37b612c5}},	//   _akosombo_, _radije_, _bakkani_, _plasseri,
   {{0xf26e025a,0x3a8ac033,0x4ddf21d2,0x157ad292}},	//   _popolo_, _ambision_, _mankacha, _پرورلیک_,
   {{0xf386a23c,0x69b1f469,0x725a0449,0x3264600d}},	//   _messaggi_, _traducte, _alila_, _amulub_,
   {{0x5ad742f4,0x5ca622f4,0x72c743ba,0x961722ac}},	//   _partekat, _хаясан_, _krumpir_, _داگێرکه_,
   {{0x4687610e,0x61cda031,0x596ad421,0xc26ca2e5}},	//   _चुदाई_, _አካሂደዋል_, _amantiit, _úkony_,
   {{0x36086152,0x60cae438,0x949ac0ac,0x714b04ec}},	//   _normaali, _اعلامیې_, _전자상거래등에서, _bulunuyo,
   {{0xb27ff040,0xe98e607c,0x7a059249,0x32da624a}},	//   _grune_, _показало, _cumainza_, _bareld_,
   {{0x6292631e,0x44d480fb,0x17aa0248,0xb2908043}},	//   _birale_, _अन्तरिक्, _እነካይዶ_, _mukava_,
   {{0xea4ba13f,0x6e456137,0xd1bb1024,0x57ee13c2}},	// [2620] _צלילה_, _kahalaga, _उच्छिष्ट, _akwatang,
   {{0xf200d09b,0xd290d421,0xe0c38085,0xcdc0416c}},	//   _steif_, _galamu_, _প্লীজ_, _medikama,
   {{0x92904339,0x2da8d30d,0xf014f47c,0xd4cb532d}},	//   _nemaz_, _attivita, _outdooro, _क्विप्_,
   {{0x67ea310e,0x13da7248,0xa8fe4185,0x12e61007}},	//   _niesamow, _ንዕቀትን_, _mbrantsɛ_, _جہنمی_,
   {{0xa30dc13c,0x328d613c,0x8290d045,0x7603d2f4}},	//   _pinamar_, _аалакгьы_, _balamu_, _мобиком_,
   {{0xb394e17d,0x62fa2398,0x7500714c,0x4db35182}},	//   _naisen_, _fachada_, _সুবিধাবা, _ananyena,
   {{0x5ce5d228,0xc89e12bd,0x4ec923fb,0xce6c1388}},	//   _نظرات_, _командаһ, _foregått_, _لیپور_,
   {{0xe27e6181,0x9af86180,0x82cae13a,0x4394e1bf}},	//   _isoni_, _特典に関する注意_, _handet_, _sensul_,
   {{0x0b11a438,0xd2d15143,0xd3f46019,0xa1fe512d}},	//   _bursarie, _parleur_, _parton_, _taratasy_,
   {{0x23207283,0x3b8b5083,0x5072d0b5,0x6a05a044}},	//   _munye_, _اماندىعى, _پەرشتە_, _karaipit,
   {{0x431690b4,0xe1f40105,0xa25ae11c,0xd249021c}},	//   _ahaza_, _קרעסאן_, _buille_, _stampi_,
   {{0xd6794340,0xc30fd01b,0x2ea01369,0x8f15a1a0}},	//   _басарабя, _dolanyp_, _accurtat_, _lindiyan,
   {{0x8f8c02db,0x72ca12a7,0xec460249,0x6974e403}},	//   _гөркезил, _tahlili_, _cumponis, _elindele,
   {{0x4c7830bd,0x13f8c0b3,0x45ee80d7,0x2b43a234}},	//   _verskil_, _ildus_, _predpriä, _futbalis,
   {{0xdf5d21a3,0xc15bf064,0xe537e2f4,0x72e6137f}},	//   _mutangan, _月参加工作_, _мансууру, _adanama_,
   {{0x21e61232,0x46372155,0xca7d50ee,0x03175301}},	//   _جاسوسي_, _тарихни_, _kapacita_, _malacky_,
   {{0x2fcd339c,0x2290e1fe,0x2d81529a,0x2dcd209a}},	// [2630] _бағдадта_, _kanamu_, _setempat_, _сунән_,
   {{0xa85d03cf,0xdc1d0150,0x37eab0af,0xb3417699}},	//   _stolpehu, _stoppet_, _クラシック_, _aprenda_,
   {{0x725a9187,0xa9e9f114,0xbc778205,0xab03d034}},	//   _adali_, _baitulmu, _eyesore_, _модерен_,
   {{0xe3c8823c,0xa3f462d2,0x238695f6,0xcc37608a}},	//   _получите_, _garten_, _trifling_, _شهيدانو_,
   {{0x827d0516,0xd2d9f349,0xc224d0a1,0x049d2171}},	//   _materiál, _fluen_, _shokoi_, _kutangaz,
   {{0xae0f2087,0xf03b7258,0x4f75101a,0xb27ed529}},	//   _accessda, _eftersko, _ئىشەنبەي, _kreni_,
   {{0x02dbf0ba,0x3395f40f,0x86566403,0xe2ca000c}},	//   _акциясы_, _haust_, _avunyelw, _isilami_,
   {{0x0320708a,0xa516c232,0x209420f7,0x1e24b051}},	//   _kunye_, _izilwany, _行政许可法_, _stumbles_,
   {{0x93f46043,0xf1cbf15e,0x73f40097,0x9b0b812e}},	//   _varten_, _besterik_, _mistet_, _किरणले_,
   {{0xa3f983c6,0x31ed80e8,0x5306122a,0x86d4f469}},	//   _korua_, _नकारा_, _akvarij_, _nascenti,
   {{0x62008200,0x126d00a4,0xf653b187,0xaafcd309}},	//   _achikt_, _semineri_, _machinji, _bibejnis,
   {{0x9f50c20d,0xa394d025,0x24b63121,0x5e04c1d9}},	//   _англи_, _abesi_, _कुंडी_, _курстар_,
   {{0x0200d5da,0x3566b065,0xc846c0b3,0x32dbc07e}},	//   _ranije_, _הכיוונים_, _finlyand, _sängen_,
   {{0x127e609f,0x1982f11b,0x49e612f8,0xc793645e}},	//   _tsona_, _постер_, _basogana_, _filtreri,
   {{0xbfeda019,0x5f320123,0x4681517a,0x61b3c51d}},	//   _כסליו_, _preferan, _sandstei, _داخرا_,
   {{0xf2f4b4b1,0x0223c223,0x82d9646e,0x7e1fb029}},	//   _rounder_, _ادارا_, _ligers_, _pangacap,
   {{0x02f4b128,0x237ff28d,0xcd6510db,0x4ad0d13c}},	// [2640] _sounder_, _achaita_, _алымдар_, _ахлор_,
   {{0xc49d25ba,0x22d8213a,0x977b6031,0xa2d8d010}},	//   _gutangaz, _ankel_, _ወንድሙን_, _flees_,
   {{0xfef1013f,0x40958214,0x4c69c319,0xf81b7436}},	//   _projects_, _ﻧﯘﻗﺴﺎﻥ_, _vietkey_, _venezuël,
   {{0xa29035ee,0x13f8c3c9,0xe31701df,0xc2cbf0a4}},	//   _demann_, _modum_, _okazas_, _amuleki_,
   {{0x52eb3123,0xb043b3d9,0x01cdc264,0x05458008}},	//   _asontur_, _bohutsan, _اجازة_, _banklary,
   {{0x236363af,0x2cf8d25c,0x31dec401,0x3c768071}},	//   _bangcoh_, _асады_, _agallaim, _botsing_,
   {{0xf2d8f38f,0xd321709c,0xafb40065,0x9ae6c180}},	//   _mogen_, _waayee_, _האסלאם_, _betragte,
   {{0x73074204,0x142133c0,0xfc1d30d7,0xa290e10a}},	//   _wilayah_, _lekanago_, _qorallar, _sanamu_,
   {{0x8386047b,0x045d6248,0x498ef09a,0x4317615d}},	//   _esiri_, _ንኢሳይያስ_, _ечилмақч, _agenging_,
   {{0xbf201272,0xf3bb2012,0xc2ca92b7,0x5aa93034}},	//   _accepten, _مسمات_, _gwada_, _белене_,
   {{0x62d8b1b0,0xb3eae0af,0x47ad926a,0x098d1050}},	//   _pocet_, _fritid_, _extensiv, _一個單身女子_,
   {{0x34511264,0xa51f2036,0xb290f169,0xf28a80fc}},	//   _مؤخراً_, _giardino_, _jegas_, _balateli_,
   {{0x62e3f086,0x77a8639d,0xb2dfa048,0x98da51ca}},	//   _undique_, _dostupni, _metodou_, _galgaduu,
   {{0x4c72a104,0x80b0108d,0x6cb4d5ec,0x027ed1df}},	//   _viernes_, _ayamukel, _akayuhir, _preni_,
   {{0x97aeb06a,0x7b04e1a3,0xa25a929d,0x63788022}},	//   _राजस्थान, _matshaya_, _heale_, _ءﺗﻴﯩﺴﺘﻰ_,
   {{0xaf950383,0x7c7750fb,0x4066c1d8,0x2ea41282}},	//   _soldater_, _शुल्कं_, _kotabogo, _פאביעס_,
   {{0x627ff00c,0xf34ef159,0x64d79410,0xf29191cf}},	// [2650] _atunu_, _emberek_, _тамасы_, _gesat_,
   {{0xfcd9b0cc,0x7290d26f,0x548640a8,0xdb7c242f}},	//   _উল্লেখ্য_, _salaku_, _भुटानी_, _uncollec,
   {{0x83860397,0x7cefa086,0xe67cc180,0x9e46649e}},	//   _usiri_, _dnowshac, _総トラックバック, _banachda,
   {{0xe6a7c543,0xa9fc300b,0xf3f45365,0xe51a00ac}},	//   _महायुद्ध_, _angallat, _gattin_, _모르겠지만_,
   {{0x42d8f3b0,0x72a131b0,0x536fb287,0x29ecd0c5}},	//   _bogen_, _pravidlá_, _vertinim, _akandaza_,
   {{0xeaea71fd,0x53946124,0xb2919138,0x526e52df}},	//   _sistemle, _acoso_, _jesam_, _totolo_,
   {{0x8063c35b,0xeb61844b,0x821202d2,0xe26413df}},	//   _нового_, _schlager, _reihe_, _asplin_,
   {{0x49d6800f,0x3e274502,0xf4b3a2c1,0x76951071}},	//   _занять_, _версияне_, _notları_, _eastenry,
   {{0x72fd00d2,0x4043c421,0x3b02921d,0x3290f16f}},	//   _socials_, _achumaan, _श्रीभैरव, _regas_,
   {{0xf7b2516f,0xcf32516f,0x027d625c,0xe0cfc1aa}},	//   _konstrui, _konstrua, _саналады_, _bakonsal,
   {{0x924a2567,0x929213a2,0x536350d8,0x3363d041}},	//   _formé_, _zapadu_, _aingidh_, _کوندوليز,
   {{0x8f4bf0f0,0x4e017225,0x5a05a078,0x3ad44152}},	//   _consomma, _palestra, _matamait, _saaminen_,
   {{0x883990d7,0x4d9af03a,0xb39590da,0x03415365}},	//   _ictimaği_, _gratitid_, _passu_, _medenan_,
   {{0x4301e19e,0x32f7f2f4,0xe400100f,0xcc55120e}},	//   _karaiti_, _архины_, _зерна_, _contate_,
   {{0x6201f5ef,0x734920f0,0xfe6c22ac,0x379003e1}},	//   _bazize_, _chiffre_, _میحوه_, _reamenaz_,
   {{0x4200222b,0x739432b9,0x5c5e6368,0xe2026052}},	//   _mukim_, _hamsun_, _biktaim_, _doties_,
   {{0xc9d212b9,0x7c93c01c,0x1354a053,0xf2900094}},	// [2660] _sprengst, _باغات_, _anderes_, _agian_,
   {{0xad12b0ac,0xb181e10e,0xafef1248,0x5a4a8367}},	//   _클라이언트_, _कलेवर_, _ብተዳጋጋሚ_, _katerega_,
   {{0x08ab6064,0xb20042f5,0x19819064,0x00e2308a}},	//   _第三十一条_, _bumin_, _rapideme, _abanetal,
   {{0xd2002171,0x3577f287,0xcc5d1406,0xe6f77276}},	//   _tukio_, _кафедры_, _portalo_, _مالاڪنڊ_,
   {{0xad91e100,0x2635c3b4,0x5f9da225,0xb685b0f7}},	//   _kantidad_, _bogisegi, _дополнув, _lendemai,
   {{0xdec77111,0x118ca69a,0x653ce426,0x5906a0c9}},	//   _kontraŭl, _newberry_, _advarsel_, _аудиторс,
   {{0xfda2d096,0xd201f0c4,0x13c6105b,0x82fd93f9}},	//   _باطنی_, _yazize_, _واليانو_, _avvikes_,
   {{0x2c7693a4,0x06cfc0cf,0xaddf3006,0xde5163f1}},	//   _ibaraki_, _gumagami, _ngakhale_, _tarahuma,
   {{0x38b532c6,0xa24a612e,0x620260c7,0x62fcc368}},	//   _mantener_, _firmie_, _wariye_, _iunives_,
   {{0x4def71f3,0x12850166,0x7d15700f,0x8d0af168}},	//   _اجتماعات_, _broking_, _monsterc, _geslacht_,
   {{0x3aa1d0fb,0x93ac1087,0xeaf3607e,0xc6406223}},	//   _दृष्ट्वा_, _tepper_, _konserte, _serikali,
   {{0xa3959613,0x6290f437,0xad817303,0x4da6b04b}},	//   _passt_, _vegar_, _stillsta, _تاماندن_,
   {{0x52b581bc,0xd051317d,0x57bbe1ba,0x60b43082}},	//   _parcs_, _историю_, _останали, _diametal,
   {{0x53d52036,0x0292604d,0x2b552036,0x78f87258}},	//   _contatti_, _caraid_, _contatta_, _kinaassu,
   {{0xfcf2c0ce,0xd200c3f7,0xe0e1a4a3,0xbf66401d}},	//   _عالمی_, _oblije_, _nainstal, _kamadaun,
   {{0x22b4e011,0xb2d8342e,0x23874278,0x7da6f1f8}},	//   _juicio_, _almenn_, _arerei_, _ispitiva,
   {{0xc2cad2ec,0x320ec1b9,0xdf6650d0,0x1f48d0cb}},	// [2670] _pwede_, _тамам_, _qulaanun, _pensiyna,
   {{0xe3aa43f2,0x02ff501a,0x4c5af338,0xd25b60cc}},	//   _abavele_, _dirigir_, _vratiti_, _reglas_,
   {{0x726e62a3,0x03217128,0xbd9250e5,0xb3dd761f}},	//   _foromo_, _spayed_, _निर्वस्त, _aiawan_,
   {{0x3237b0db,0x9593c3cc,0x8395f2fa,0xd5d801d9}},	//   _приставт, _коллеж_, _hausi_, _ابىكەن_,
   {{0x237d4256,0x0d842210,0x423001ef,0x8c741104}},	//   _rusange_, _amplessa, _dramica_, _comunes_,
   {{0x347ec443,0xd782101a,0xeac03262,0xf2b4e054}},	//   _тиков_, _акшга_, _kwikinis, _wancan_,
   {{0x831690c5,0x130d569b,0xde019214,0x82551368}},	//   _ahaze_, _ligados_, _семинарғ, _oltestam,
   {{0xc2d993f4,0xb212f189,0x1eb7b0f7,0xf27ee1b8}},	//   _nosed_, _njihov_, _中华人民共和国行, _rinnai_,
   {{0xe45210f6,0x60e9a0d7,0xe27ed01d,0x94dd40ac}},	//   _актов_, _башлаяча, _atonin_, _일반사무직_,
   {{0xe2d9608c,0x2f20200a,0xcda7612f,0xb0c1e3bf}},	//   _engels_, _excellen, _بازاردا_, _основен_,
   {{0xbbefb226,0x63416185,0x9337c214,0x22d8f157}},	//   _pardubic, _betenaa_, _киноға_, _bogel_,
   {{0x3f5db3ff,0x420252b1,0x539db427,0x3e4651fb}},	//   _risponde_, _fatige_, _rispondi_, _bahagaze_,
   {{0xb3f87207,0x765e02bf,0x39e3006a,0x72026026}},	//   _konut_, _abokwiki, _walikota_, _jarige_,
   {{0x7e2cc3df,0x3213e0ea,0x0c5b317d,0x3e9e10f6}},	//   _влади_, _nichž_, _sinulle_, _шарлы_,
   {{0x327ff1b4,0xc2e9b0d0,0xb27c1427,0xa28c51c1}},	//   _juuni_, _ilangat_, _играя_, _slaapkam,
   {{0x32d80614,0xbf5a30d7,0xe25ae0f7,0x8b3d620e}},	//   _anien_, _милләтче, _grille_, _тренерот_,
   {{0x9fcfa1d9,0x990a0229,0x9255212f,0xfe8b3022}},	// [2680] _адамның_, _наказани, _нгтонда_, _ءسۇتى_,
   {{0x0244c17a,0x8f60f4cf,0xf65b71c7,0x6fe3f358}},	//   _সুবিধাৰ্, _vanparla, _شىنايى_, _komissio,
   {{0xfa09c01c,0x06153263,0x27adc4f7,0x929034a2}},	//   _کتابت_, _мусиқии_, _expensiv, _numara_,
   {{0x9c5bf147,0x2a2a42f4,0xbfed0248,0x13207385}},	//   _pustiti_, _долларыг_, _መስተንክር_, _punya_,
   {{0xb290f0b1,0x887ec2a7,0x63206616,0x12d8f261}},	//   _tegay_, _قشلاغیده_, _hulyo_, _thiers_,
   {{0x4645f026,0xc395f267,0xd37d60bb,0x5b6f0031}},	//   _소프트웨어_, _ebuso_, _ampanje_, _ለማደናቀፍ_,
   {{0x07297248,0x8372f095,0x07cae29e,0x977801ba}},	//   _ሓደገኛን_, _sheared_, _mensuali, _convenzi,
   {{0xd25a02af,0x40d33427,0xd0ea008a,0x7f288156}},	//   _boile_, _гласа_, _ګریوان_, _самоубис,
   {{0xd3445226,0xf2262025,0x2200611c,0xa0e1a0e8}},	//   _recenze_, _abuké_, _troid_, _zainstal,
   {{0x47b611ad,0x791dc35d,0x80dbc4ee,0xb200c093}},	//   _plasteri, _economía_, _preosetl, _kelima_,
   {{0x2e0132a1,0xc2d4659d,0xeea6b4d7,0xe2ea1165}},	//   _kebebasa, _avfolka_, _butumire_, _risiken_,
   {{0x9a18232f,0x7a6d11ed,0x729e1105,0x025a029e}},	//   _истон_, _oppozits, _זופניק_, _toile_,
   {{0x42da6106,0x2241f3b1,0xe29031d8,0xbb7ec3f1}},	//   _chreid_, _मंडली_, _rumasa_, _bafutaka_,
   {{0x7c19f009,0xd7a4d287,0xa291a122,0xe764206a}},	//   _предоста, _музыкаў_, _bavard_, _निर्जिव_,
   {{0x984e1392,0x525ad168,0x514e121f,0x2c75405a}},	//   _mengatur_, _beeld_, _mentatio, _algunes_,
   {{0x22e76320,0x0401f00a,0x6a7cf03b,0x7dbcf1d6}},	//   _diendan_, _solution_, _abhalisa_, _abhalise_,
   {{0x85ad136d,0x4c0b5115,0xd30d325d,0x898ec15e}},	// [2690] _值得注意的是_, _ocupava_, _menacer_, _чамин_,
   {{0x86a7f2e9,0x5f2770f7,0xea8f0160,0x14ac7263}},	//   _angrupch, _经营许可证编号_, _priznaje, _консулга,
   {{0x72c1c425,0xe1ed12de,0xf29192dc,0x4c3681b5}},	//   _atolosa_, _напредно_, _pesak_, _гектарға_,
   {{0x12f1f01b,0x4f1fb517,0x0386b03c,0xcea8c287}},	//   _birinji_, _partecip, _andria_, _анатоля_,
   {{0xdb900171,0x090e811b,0x50faf3d9,0x6300a07b}},	//   _muungano_, _смислу_, _atshirel, _albamii_,
   {{0x622ac358,0x9eff5550,0x261b02c1,0x740af13d}},	//   _попал_, _sanguíne, _bünyesin, _kostrzyn_,
   {{0xa2908304,0x326e6117,0xdb17312f,0x088720d7}},	//   _rekaan_, _doroko_, _ﺋﯚﺗﯜﭖ_, _каралды_,
   {{0x738604e1,0x73875123,0xc395f221,0x9c5741f8}},	//   _mpira_, _akerir_, _ubuso_, _postane_,
   {{0xf39590a1,0x67e9a27c,0x8afb5471,0x662b5381}},	//   _passy_, _ダイエット_, _buvuleke, _аморалтә_,
   {{0x0ba83213,0x6cbec036,0xf1d7f192,0x6b0db1e2}},	//   _anakapar, _памет_, _bahlokom, _сириллик_,
   {{0x8c6a200e,0x61e024cf,0xd68e43b4,0x221c62e1}},	//   _sonuncu_, _žandarme, _belesedi, _akuhan_,
   {{0xbae001b7,0x829500ef,0x22d9907d,0xc290c59e}},	//   _unaudite, _منتظمين_, _kosem_, _pamats_,
   {{0x34acb482,0xfd08c031,0x5e70b0a1,0x616762e4}},	//   _kuzakwak, _መንገደኞች_, _patassé_, _tienganh_,
   {{0x0595f03b,0x7c1b90ae,0x8edb1566,0x526a5342}},	//   _akhukhok, _silahlar, _variados_, _mearbhal,
   {{0xce69a009,0x3cabb14f,0x11d76124,0xdc9a611b}},	//   _создание_, _priyadar, _агроаага, _либералн,
   {{0xb3cf72e5,0xcce47086,0x3dc0e052,0x3132f060}},	//   _pravda_, _traveloc, _policija, _mistleto,
   {{0xc3f9e4a7,0xf25ad082,0x320040e5,0x3200c4ba}},	// [26a0] _lotua_, _adelo_, _sumie_, _selima_,
   {{0xaa096321,0xe71c0072,0x3e73e0ca,0xd79d9122}},	//   _allagart, _promotiv, _धार्तराष, _distinzi,
   {{0x6190004f,0xe29082e9,0x427f0045,0x32927011}},	//   _membunuh_, _bihagh_, _amangu_, _paragu_,
   {{0xa984414e,0x0e50008c,0xbb59c3d0,0xd4a860ff}},	//   _গাবতলী_, _vakansie_, _дөхөж_, _digitaal_,
   {{0xf2e8a673,0x83f81238,0x72009027,0x6c0412ec}},	//   _dokiman_, _dihun_, _duain_, _sieradz_,
   {{0x9d1b6122,0x6598c249,0xb25b645b,0x06498248}},	//   _francese_, _existenz, _francesi_, _ትእምርቲ_,
   {{0x321c6151,0x4341c264,0x5c296122,0x936c510f}},	//   _asthiv_, _آنذاك_, _almanacc, _tengeri_,
   {{0xe2025266,0x59db21da,0x32d453ba,0xd3017126}},	//   _setita_, _irongera_, _čudno_, _mambere_,
   {{0x35d860fb,0x9394e0f0,0xb202501a,0x74f791e2}},	//   _prakaraṇ, _raison_, _petita_, _тартибот,
   {{0xc27ed09f,0x58b6b1a5,0x2200c175,0xac0a30c9}},	//   _tsena_, _fortuner_, _delika_, _включає_,
   {{0x7830e1e0,0x62ef32ee,0xdf1c5020,0xa2861123}},	//   _fermentu, _kimiyya_, _annualwa, _badinaz_,
   {{0x20e542d2,0x7ca3d275,0x92b4908b,0x22d9241a}},	//   _ebenfall, _алматада_, _carding_, _licens_,
   {{0x93f873a4,0xf303f05a,0xe3f9432b,0x6a7bd362}},	//   _annum_, _ocupació_, _theulu_, _ortopeds,
   {{0x625a9514,0x841f1121,0x8e5a509a,0xd2019395}},	//   _dlala_, _versioon_, _дилдарли, _otsia_,
   {{0x6c6140a1,0x971ec0d2,0x7a5ca0aa,0x725a905f}},	//   _kauther_, _майга_, _akagenwa_, _elala_,
   {{0xbad0d0c9,0x7d2162f6,0x6a11912b,0x472c306e}},	//   _systemve, _bakomeje_, _edebanye, _प्रवेशाच,
   {{0xd91e315d,0xb765c2ab,0x23eae2ae,0x93f9a4d5}},	// [26b0] _دلایل_, _pasibaig, _kaitse_, _popul_,
   {{0xa62011a1,0xfe6ac140,0x9a6011a1,0x522b23c6}},	//   _examplew, _монда_, _examples, _waimate_,
   {{0x939662cb,0xa2d99007,0x85fd701a,0xee022609}},	//   _arusha_, _sosem_, _дайынсыз_, _kabenera,
   {{0x92eee045,0xd9d0c008,0xeac4213f,0xacd231ca}},	//   _gaffe_, _дейин_, _הנחשקים_, _چُھنہ_,
   {{0x1c06c05a,0x2e92f010,0xaa077169,0x9d1ec185}},	//   _كىشنى_, _ointment_, _probeire, _takorade_,
   {{0x967432c8,0x903970f1,0xf200b291,0x02cad07d}},	//   _landinum_, _infeksjo, _abdine_, _kandre_,
   {{0x7c1f2155,0x529030f0,0x422ac12f,0x8300e3aa}},	//   _нәччә_, _demain_, _мозат_, _ceramah_,
   {{0x09948237,0x1386d1e4,0xed216098,0xf5127075}},	//   _slikarst, _ezera_, _yakomeje_, _aktualno_,
   {{0x4efcc063,0x0c607218,0xaf1db320,0x9200c2d4}},	//   _мулки_, _costais_, _giadinhn, _allimi_,
   {{0x4200c1de,0xee45650e,0x73f8c395,0x7248d040}},	//   _velika_, _bahamaga, _koduu_, _chomer_,
   {{0xcf746038,0x2201434e,0xd66bc2e5,0x1375135e}},	//   _प्रकाशचि, _wafike_, _žurnál_, _aitungam,
   {{0x62573008,0xc628a0c7,0x8250c0f6,0x6a2ca579}},	//   _festiwal, _بولبوشا_, _девам_, _талиптер_,
   {{0xf224f4b4,0x552860e4,0x936362e9,0x32d8218d}},	//   _atikol_, _nominasy, _bangjoh_, _biken_,
   {{0xd20260ec,0x283e10db,0x125b60dc,0xa509c1ad}},	//   _derisa_, _киске_, _regles_, _dovetail_,
   {{0xac1d31ed,0xd345b19a,0x96c4c283,0x2f6bd0cf}},	//   _soraular, _gardiau_, _angawufi, _pribadon,
   {{0x5db575ab,0xf5525009,0x01125009,0x29925009}},	//   _ilandela, _ngokobuh, _ngokobul, _ngokobut,
   {{0xf03c743d,0x83564201,0x2394e258,0x2200c369}},	// [26c0] _bengtsso, _alteres_, _tonsit_, _bolidi_,
   {{0x0b4720e5,0x5e456256,0x29f2c0aa,0xb37e516c}},	//   _नुक्ताची, _yahamaga, _amanyama_, _karayib_,
   {{0xa41322f3,0xc290e0c0,0x3290313f,0x5aa230fb}},	//   _поредак_, _apiade_, _remain_, _पृष्ट्वा_,
   {{0x5e53e296,0x7466823c,0x31b2208b,0x627ff1a7}},	//   _ababanga, _алармира, _محبوبيت_, _trunc_,
   {{0x3bae7121,0x1290306a,0x741da02a,0xe2de33c8}},	//   _जनतंत्र_, _pemain_, _scission_, _bonoblu_,
   {{0x7074330b,0x9c73924a,0x0878b2c3,0xc200e176}},	//   _komentār, _fierder_, _виртуалд, _menika_,
   {{0x026c31ab,0x5395f339,0xfbe112a9,0xa45be33e}},	//   _lalong_, _kauss_, _inserier, _ariwatan_,
   {{0x3301e052,0x5e9f118c,0x8f9a30ac,0xd20260a1}},	//   _parasti_, _kwamalun, _지식포인트_, _terisa_,
   {{0x3d0510d2,0xbace1043,0xddb5765e,0x98ed20af}},	//   _instrucc, _поведени, _alandela, _よくあるご質問_,
   {{0xc00c80ac,0x4e35512f,0xca6d02af,0x126d8414}},	//   _기자회견문_, _ﻧﯩﻤﯩﺸﻘﺎ_, _bipolots, _tyrol_,
   {{0x5d1ba1ba,0x9345b0cb,0x1c7e222a,0x9c82145b}},	//   _prendere_, _cardiau_, _glasilo_, _edgewood_,
   {{0xccc0f4bd,0xa234b3ef,0xb307b193,0x0af0e1f3}},	//   _श्रीमान्_, _carmine_, _demangi_, _kiterjes,
   {{0xc2d8220d,0xecf941a5,0x11cf9065,0x208d2252}},	//   _mikel_, _lattimor, _המרצה_, _кирсе_,
   {{0x59816284,0xd9d99052,0x7320748c,0x3dd85370}},	//   _activeme, _dienesta_, _runye_, _туркзабо,
   {{0xe48be155,0xa37b25e6,0xe5474012,0xf8a0e004}},	//   _аталған_, _pasando_, _لاتعداد_, _استعداده,
   {{0x8f1fb3c7,0x8bd5846c,0x5603213c,0x7bd282a9}},	//   _particip, _soldatar, _починок_, _wundersc,
   {{0xed73c20d,0x0186442f,0x194790dc,0x8f6ee0f7}},	// [26d0] _конвенц_, _unlawful, _adjuntar_, _遵守国家有关法律_,
   {{0x4c80c009,0xec7f044a,0x7af2c0c2,0x447ec0bf}},	//   _семей_, _mahusay_, _akarelit, _синов_,
   {{0xb2020465,0xdc6ec25a,0x1166d064,0xc26c30c1}},	//   _rapide_, _forumoj_, _第三十八条_, _halong_,
   {{0xa395f187,0xe2d8418e,0x9c5b8142,0x674e2248}},	//   _abusa_, _limen_, _postaji_, _ብማዕርነት_,
   {{0xe516001a,0x6afa10fd,0x2226647b,0xac739341}},	//   _قالماق_, _benediks, _ebukwa_, _wierder_,
   {{0x01e61218,0xc20195f6,0xac93c24c,0x195dc2ab}},	//   _قانونية_, _atsin_, _یاداش_, _vieninte,
   {{0x75230026,0x2a3361f7,0x73f9847c,0xbbefe0fd}},	//   _선택하세요_, _komitetı_, _korun_, _waterbur,
   {{0x62010242,0x75234243,0xf29ec1bf,0x78c9c1e2}},	//   _nebija_, _pernikah, _бинар_, _тирандоз,
   {{0x1533501e,0x59c7c1a5,0x5a1170de,0x52ff74e9}},	//   _amanpany, _садама_, _اجوسۇن_, _aturenay_,
   {{0x305a31a1,0x432142c9,0xc2d842f5,0xde533401}},	//   _ofession, _aleyhi_, _jimen_, _íobairt_,
   {{0x62d84033,0x134b0007,0x1d0c73cd,0x2aa620f7}},	//   _dimen_, _baleset_, _formålet_, _西北轴承股份有限,
   {{0xeaf351e0,0x89620516,0xe486e1e7,0x76b5812e}},	//   _consecte, _podnikat, _भाषायी_, _komentow,
   {{0x34132352,0xbdd100f7,0xd30502d3,0x02099275}},	//   _بایده_, _山东省人民政府门, _magorong_, _تاجىكىست,
   {{0x084293bf,0x18c8c248,0xf603d018,0x02d8417d}},	//   _добрите_, _ኣጸሓሕፋ_, _кастаниу_, _nimen_,
   {{0x5394d235,0xefae1005,0xb3f8c0ce,0xc3966086}},	//   _acest_, _ласка_, _indul_, _mersal_,
   {{0x9cf2324c,0xf356717f,0x5761300f,0x46c53270}},	//   _عالما_, _abafisa_, _твори_, _membukti,
   {{0xc5c6715f,0x96bb0443,0x025fb0d0,0x42871212}},	// [26e0] _hanayauh, _surameri, _mauttail, _قفقاز_,
   {{0xac196051,0x0d1ee026,0x55a9c2f3,0x3f25d0af}},	//   _despair_, _애니메이션_, _великом_, _reklamer_,
   {{0x00f3d00e,0x38436484,0xf35e8077,0x3c9f83c8}},	//   _yekunlaş, _cortesas_, _anafani_, _dabejchu_,
   {{0x0a11c47b,0x530c869c,0x84da8227,0x6c6003d0}},	//   _adabanye, _deberá_, _서비스제공_, _laburra_,
   {{0xd07d304b,0x4f34e49e,0x69cda1b3,0x22d7e1e2}},	//   _кайси_, _marsanta, _attendit, _хариду_,
   {{0x935bf436,0x6dfc61c7,0x57b170db,0x0200d13a}},	//   _mingala_, _конкурсқ, _baithutw, _greid_,
   {{0xa3f812ff,0x0920606c,0x3a6d8309,0x61a1d09a}},	//   _bihub_, _मनीआर्डर_, _chellahb, _بەرىكەت_,
   {{0xa5bd4043,0x515cd252,0x33f8c35c,0x23eb3314}},	//   _построен, _сузак_, _andul_, _zlatá_,
   {{0xc280a31b,0xe29190f9,0x3f34e3a2,0xe9007153}},	//   _akukaze_, _hesar_, _dokumena, _koppling,
   {{0x33869054,0x7873359b,0x9269d214,0x14a703f9}},	//   _tsari_, _प्रकारको_, _ءجۇمادىل, _благоуст,
   {{0xb26e7075,0xe25ad492,0x208d2030,0xf5b5e30d}},	//   _visoka_, _synlig_, _ҳисси_, _kompetiz,
   {{0x82eee46c,0x92025560,0xb316640c,0x8291906e}},	//   _jaffa_, _ketiga_, _laozi_, _pesat_,
   {{0xa7a2c15f,0x3c1dc2ff,0x42b4e010,0x7ce020dc}},	//   _nakuutqi, _bisuvnis, _dancin_, _استورنوم,
   {{0x6dc001a1,0x20581216,0x1c52c443,0xe80aa1e6}},	//   _achinema, _preschan, _apatía_, _समुदाये_,
   {{0x7202515d,0x8291637f,0xde34f04e,0x6e0b10f8}},	//   _batine_, _kugawa_, _badlands_, _galereya,
   {{0xe20ec0ba,0x00551404,0x42d9f169,0xf5d77030}},	//   _жаман_, _اخبارون_, _roueg_, _турадига,
   {{0xbf5e53c0,0xa20080e0,0xcf3020d7,0x226c5063}},	// [26f0] _bahlakiš, _rohini_, _bazasınd, _avlod_,
   {{0x4eb0320e,0xfa9460aa,0xd1c0d113,0x7e1b6110}},	//   _зборови_, _abanonos, _pielikum, _sangputa,
   {{0xbb1cb295,0x9252605c,0xb290f0c7,0xdf6fb065}},	//   _akapanda_, _upotrebl, _degay_, _למזרח_,
   {{0xab07d375,0x025a62c0,0xe2d84345,0x7cf38132}},	//   _رۇحساتسى, _boole_, _nimel_, _невинова,
   {{0x1f5501fd,0x52009334,0x92fce008,0x36875138}},	//   _kampanya, _ntais_, _sungat_, _kladioni,
   {{0xae6ac0bf,0x908c2063,0x844611d9,0xaca7631a}},	//   _жойда_, _шартнома_, _تارقان_, _tunihitq,
   {{0x2321414b,0xa2cae0b0,0x820061e0,0xe2019116}},	//   _inscrit_, _rendah_, _proin_, _otsib_,
   {{0x805d92c7,0xe4734224,0xe8ea229f,0xe366307d}},	//   _nachádza_, _dikelelo_, _conficiu, _bwagilo_,
   {{0xbf48d399,0x2abca036,0xab60307f,0xcb08d090}},	//   _cristina, _министър_, _апрезден, _cristine,
   {{0x73177233,0xf8fa213c,0x89b903d0,0xbf64a32f}},	//   _manaiky_, _абаллонқ, _өсвөрийн_, _abaphaka,
   {{0xdec8f13f,0x8909e24f,0x2e9da043,0xd4e80031}},	//   _equipmen, _allappoq_, _давление_, _የሚለካው_,
   {{0xf6d4431d,0xb32070a5,0xeaea74d1,0x9e7250e8}},	//   _lombardi, _bunyi_, _cystadle, _असत्य_,
   {{0x82367664,0x75df1143,0x4188e10c,0xa25a01bf}},	//   _manji_, _accentué, _boramatl, _noile_,
   {{0x53dcc00a,0x2e879271,0x22574319,0xd2926181}},	//   _browse_, _kalkulač, _chuẩn_, _batanu_,
   {{0xa8d8d0f2,0x52025291,0xb200a2df,0x35fce28f}},	//   _माध्यमिक_, _patine_, _bojini_, _excepció,
   {{0xc61321d9,0xc248e013,0x3c6e0281,0x84a34227}},	//   _قۇرسا_, _olimpo_, _gaaraya_, _韓國審評會_,
   {{0x35f63443,0x22cc620e,0x0b67e1d8,0x79fbc246}},	// [2700] _artesaní, _огласник_, _jenengan_, _fakatuat,
   {{0x7c5b80c3,0x037fd253,0xbeeac08b,0x4cd73264}},	//   _postoji_, _silafia_, _مسدود_, _زعلان_,
   {{0x22926181,0x6d13a24d,0x5705e30e,0x742022c4}},	//   _gatanu_, _phurogir, _रामशरण_, _dikirimk,
   {{0xf25a6003,0x5342a164,0x83a3c1bc,0xf0c84248}},	//   _poole_, _jeneral_, _حادئس_, _ዝተዓብለለ_,
   {{0xd394255c,0x796df2f6,0x525b001f,0x82129250}},	//   _dêrom_, _jeannett, _adalci_, _keaha_,
   {{0xdffe8217,0x22b5109b,0xa3f8c29a,0x5da702d1}},	//   _конкурсл, _haldane_, _induk_, _بایدیهم_,
   {{0x99c3c096,0xc2919207,0xf63e300e,0x32d99219}},	//   _صاحبِ_, _hesap_, _katibini, _ilser_,
   {{0x7200413b,0x62538343,0xcd29116a,0xf3bc234e}},	//   _humit_, _aumeamam, _claimant_, _бунбасти_,
   {{0x43f87043,0xe354c1c2,0xd5b0b0ce,0xd3f87043}},	//   _minun_, _jinetes_, _versenyz, _sinua_,
   {{0xbb0cc27c,0x62919347,0xf2c840ea,0x3a6aa031}},	//   _でお届けします_, _pesar_, _odpoved_, _የሥርዓተ_,
   {{0xf12da065,0x8c7e724a,0xab6d00d7,0x0e0b1500}},	//   _שיאצו_, _útsein_, _күренми_, _qalereya,
   {{0xf2ad015d,0x6212b0e2,0x3394e336,0x344a201c}},	//   _شلوار_, _seche_, _apisia_, _حرکتوں_,
   {{0x3212b3bd,0xc25b44f2,0x875e6060,0x2eb04007}},	//   _peche_, _lwelwa_, _masiling, _البلاغہ_,
   {{0x915480c6,0xb25b7003,0x6b56e59b,0xac69c5a4}},	//   _abosonso, _avalda_, _सदस्यहरु, _esprimo_,
   {{0xd43ef362,0xcb82146c,0x87aa7300,0x9d22c1c3}},	//   _globalno_, _brennbar, _aostrali, _beartaic,
   {{0x92c3a3f2,0x7ab8e248,0x334db207,0x42fcd0cb}},	//   _kohlobo_, _ብሓይልን_, _gelecek_, _diogel_,
   {{0xddb3d01b,0xc2a6c082,0xa89270db,0x8be123ea}},	// [2710] _muhammet_, _gulben_, _отличник_, _anamwino_,
   {{0xbeab854e,0x12ea3010,0x038c5156,0x627ff45b}},	//   _makonten, _sinners_, _формирањ, _brunu_,
   {{0xa0fa0041,0x1c751316,0xe25b7365,0xc3ead4f7}},	//   _umphandl, _bansang_, _kralle_, _filter_,
   {{0x3300019c,0x644912f4,0xb200f02a,0x725ad1e7}},	//   _kahawai_, _британий, _argid_, _koolis_,
   {{0xb301e062,0x27d991ff,0xe1fd224c,0x0999d248}},	//   _fetalai_, _एरिक्सन_, _ixtiraam, _ተተርጒሙ_,
   {{0xa27ff3d2,0x0ea6f3ec,0xe3dd7139,0x1c61621f}},	//   _grunt_, _abertawe_, _dhawan_, _baruora_,
   {{0x33ead2e4,0xb2da0175,0xd515a0ac,0x494d822d}},	//   _tintuc_, _deseni_, _종합민원실_, _verlieze,
   {{0xf56a6225,0x5fa4a566,0xd200b5f0,0x89c2f256}},	//   _приближн, _entender_, _godini_, _bategere,
   {{0xee56c0c3,0x043ec043,0xda16c0c3,0x2a7f42ad}},	//   _zdravlje_, _ладно_, _zdravlja_, _taratara_,
   {{0x2f24124f,0xb2002030,0x0031b3af,0x89660456}},	//   _greenlan, _erkin_, _saetmuen, _अमान्य_,
   {{0x524800e7,0xe18a212d,0xb594c063,0x02d9939b}},	//   _dzime_, _ampahany_, _infratuz, _boset_,
   {{0xc2490266,0xb30e50a3,0x62a70131,0xab5ed050}},	//   _atamai_, _paradys_, _akabri_, _一個月之後_,
   {{0x92ecb064,0xa8d281ba,0x7fc2c012,0x92da0195}},	//   _musique_, _operativ, _چارون_, _beseni_,
   {{0x4973821d,0xf320a04e,0xc8f63251,0x39bad12a}},	//   _प्रवर्ति, _dubya_, _странски, _