#!/usr/bin/perl -w
# Copyright (C( 2007, 2010 by Christian Kuelker
use Test::More;
use English qw(-no_match_vars);

if ( not $ENV{TEST_AUTHOR} ) {
    my $msg = 'Author test. Set $ENV{TEST_AUTHOR} to a true value to run.';
    plan( skip_all => $msg );
}

eval { require CipUX::CAT::Web::L10N };
if ($EVAL_ERROR) {
    my $msg = 'CipUX::CAT::Web::L10N required';
    plan( skip_all => $msg );
}

plan( tests => 5 );

my @tag  = qw(en de fr da ja);
my @word = qw(firstname);

my %answer = (
    de => 'Vorname',
    en => 'firstname',
    fr => 'prénom',
    da => 'fornavn',
    ja => '名前',
);

foreach my $t (@tag) {
    my $lh = CipUX::CAT::Web::L10N->get_handle($t) || die "What language?";
    foreach my $w (@word) {

#diag(sprintf( "msgid %10s -> tag %5s -> i18n %10s\n", $w, $t, $lh->maketext($w) ));
        ok( $lh->maketext($w) eq $answer{$t} );
    }
}

