/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#include "REAL.H"
#include "CONSTANTS.H"
#include "BCTypes.H"

#if BL_USE_FLOAT
#define threehalves    1.5e0
#else
#define threehalves    1.5d0
#endif

#define DIMS lo_1,lo_2,hi_1,hi_2

c *************************************************************************
c ** SETSCALBC **
c ** Impose the physical boundary conditions on scalars s
c *************************************************************************

      subroutine setscalbc(s,DIMS,bcx_lo,bcx_hi,bcy_lo,bcy_hi,
     $                     irz,which_scal,dx,time)

      implicit none

      integer DIMS
      integer which_scal
      integer bcx_lo,bcx_hi
      integer bcy_lo,bcy_hi
      integer irz
      REAL_T  dx(2)
      REAL_T  time
      REAL_T  s(lo_1-1:hi_1+1,lo_2-1:hi_2+1)

c     Local variables
      integer is,ie,js,je,i,j

      is = lo_1
      ie = hi_1
      js = lo_2
      je = hi_2

      if (bcy_lo .eq. PERIODIC) then
        do i = is,ie 
          s(i,js-1)=s(i,je)
        enddo

      elseif (bcy_lo .eq. WALL) then

c     NOTE: THESE VALUES ARE DEFINED ON THE EDGE OF THE PHYSICAL BOUNDARY,
c           NOT IN THE GHOST CELL
        do i = is,ie 
c         s(i,js-1) = threehalves*s(i,js) - half*s(i,js+1)
          s(i,js-1) = s(i,js)
        enddo

      elseif (bcy_lo .eq. INLET) then

        call scalinflow(s,DIMS,time,dx(1),1,0,which_scal)

      elseif (bcy_lo .eq. OUTLET) then

        do i = is,ie 
c         s(i,js-1) = threehalves*s(i,js) - half*s(i,js+1)
          s(i,js-1) = s(i,js)
        enddo

      endif

      if (bcy_hi .eq. PERIODIC) then
        do i = is,ie 
          s(i,je+1)=s(i,js)
        enddo

      elseif (bcy_hi .eq. WALL) then

c     NOTE: THESE VALUES ARE DEFINED ON THE EDGE OF THE PHYSICAL BOUNDARY,
c           NOT IN THE GHOST CELL
        do i = is,ie 
c         s(i,je+1) = threehalves*s(i,je) - half*s(i,je-1)
          s(i,je+1) = s(i,je)
        enddo

      elseif (bcy_hi .eq. INLET) then

        call scalinflow(s,DIMS,time,dx(1),1,1,which_scal)

      elseif (bcy_hi .eq. OUTLET) then

        do i = is,ie 
c         s(i,je+1) = threehalves*s(i,je) - half*s(i,je-1)
          s(i,je+1) = s(i,je)
        enddo

      endif

      if (bcx_lo .eq. PERIODIC) then
        do j = js-1,je+1 
          s(is-1,j) = s(ie,j)
        enddo

      elseif (bcx_lo .eq. WALL) then

c     NOTE: THESE VALUES ARE DEFINED ON THE EDGE OF THE PHYSICAL BOUNDARY,
c           NOT IN THE GHOST CELL

        if (irz .eq. 1) then

          do j = js-1,je+1 
            s(is-1,j) = s(is,j)
          enddo

        else

          do j = js-1,je+1 
c           s(is-1,j) = threehalves*s(is,j) - half*s(is+1,j)
            s(is-1,j) = s(is,j)
          enddo

        endif

      elseif (bcx_lo .eq. INLET) then

        call scalinflow(s,DIMS,time,dx(2),0,0,which_scal)

      elseif (bcx_lo .eq. OUTLET) then

        do j = js-1,je+1 
c         s(is-1,j) = threehalves*s(is,j) - half*s(is+1,j)
          s(is-1,j) = s(is,j)
        enddo

      endif

      if (bcx_hi .eq. PERIODIC) then
        do j = js-1,je+1 
          s(ie+1,j) = s(is,j)
        enddo

      elseif (bcx_hi .eq. WALL) then

c     NOTE: THESE VALUES ARE DEFINED ON THE EDGE OF THE PHYSICAL BOUNDARY,
c           NOT IN THE GHOST CELL

        if (irz .eq. 1) then

          do j = js-1,je+1 
c           s(ie+1,j) = threehalves*s(ie,j) - half*s(ie-1,j)
            s(ie+1,j) = s(ie,j)
          enddo

        else

          do j = js-1,je+1 
c           s(ie+1,j) = threehalves*s(ie,j) - half*s(ie-1,j)
            s(ie+1,j) = s(ie,j)
          enddo

        endif

      elseif (bcx_hi .eq. INLET) then

        call scalinflow(s,DIMS,time,dx(2),0,1,which_scal)

      elseif (bcx_hi .eq. OUTLET) then

        do j = js-1,je+1 
c         s(ie+1,j) = threehalves*s(ie,j) - half*s(ie-1,j)
          s(ie+1,j) = s(ie,j)
        enddo

      endif

      return
      end
