{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetControlPoint: TAbstractCoordinateNode;
    procedure SetControlPoint(const Value: TAbstractCoordinateNode);
    function GetTessellation: Integer;
    procedure SetTessellation(const Value: Integer);
    function GetClosed: Boolean;
    procedure SetClosed(const Value: Boolean);
    function GetOrder: Integer;
    procedure SetOrder(const Value: Integer);
  public
    { X3D field "controlPoint". } { }
    property ControlPoint: TAbstractCoordinateNode read GetControlPoint write SetControlPoint;
    { X3D field "tessellation". } { }
    property Tessellation: Integer read GetTessellation write SetTessellation;
    { Set X3D field "weight". } { }
    procedure SetWeight(const Value: array of Double);
    { Set X3D field "weight". } { }
    procedure SetWeight(const Value: TDoubleList);
    { X3D field "closed". } { }
    property Closed: Boolean read GetClosed write SetClosed;
    { Set X3D field "knot". } { }
    procedure SetKnot(const Value: array of Double);
    { Set X3D field "knot". } { }
    procedure SetKnot(const Value: TDoubleList);
    { X3D field "order". } { }
    property Order: Integer read GetOrder write SetOrder;

{$endif read_interface}

{$ifdef read_implementation}

{ TNurbsCurveNode ----------------------------------------------- }

function TNurbsCurveNode.GetControlPoint: TAbstractCoordinateNode;
begin
  if FdControlPoint.Value is TAbstractCoordinateNode then
    Result := TAbstractCoordinateNode(FdControlPoint.Value)
  else
    Result := nil;
end;

procedure TNurbsCurveNode.SetControlPoint(const Value: TAbstractCoordinateNode);
begin
  FdControlPoint.Send(Value);
end;

function TNurbsCurveNode.GetTessellation: Integer;
begin
  Result := FdTessellation.Value;
end;

procedure TNurbsCurveNode.SetTessellation(const Value: Integer);
begin
  FdTessellation.Send(Value);
end;

procedure TNurbsCurveNode.SetWeight(const Value: array of Double);
begin
  FdWeight.Send(Value);
end;

procedure TNurbsCurveNode.SetWeight(const Value: TDoubleList);
begin
  FdWeight.Send(Value);
end;

function TNurbsCurveNode.GetClosed: Boolean;
begin
  Result := FdClosed.Value;
end;

procedure TNurbsCurveNode.SetClosed(const Value: Boolean);
begin
  FdClosed.Send(Value);
end;

procedure TNurbsCurveNode.SetKnot(const Value: array of Double);
begin
  FdKnot.Send(Value);
end;

procedure TNurbsCurveNode.SetKnot(const Value: TDoubleList);
begin
  FdKnot.Send(Value);
end;

function TNurbsCurveNode.GetOrder: Integer;
begin
  Result := FdOrder.Value;
end;

procedure TNurbsCurveNode.SetOrder(const Value: Integer);
begin
  FdOrder.Send(Value);
end;

{$endif read_implementation}
