{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetBottom: Boolean;
    procedure SetBottom(const Value: Boolean);
    function GetHeight: Single;
    procedure SetHeight(const Value: Single);
    function GetRadius: Single;
    procedure SetRadius(const Value: Single);
    function GetSide: Boolean;
    procedure SetSide(const Value: Boolean);
    function GetTop: Boolean;
    procedure SetTop(const Value: Boolean);
    function GetSlices: Integer;
    procedure SetSlices(const Value: Integer);
    function GetStacks: Integer;
    procedure SetStacks(const Value: Integer);
  public
    { X3D field "bottom". } { }
    property Bottom: Boolean read GetBottom write SetBottom;
    { X3D field "height". } { }
    property Height: Single read GetHeight write SetHeight;
    { X3D field "radius". } { }
    property Radius: Single read GetRadius write SetRadius;
    { X3D field "side". } { }
    property Side: Boolean read GetSide write SetSide;
    { X3D field "top". } { }
    property Top: Boolean read GetTop write SetTop;
    { X3D field "slices". } { }
    property Slices: Integer read GetSlices write SetSlices;
    { X3D field "stacks". } { }
    property Stacks: Integer read GetStacks write SetStacks;

{$endif read_interface}

{$ifdef read_implementation}

{ TCylinderNode ----------------------------------------------- }

function TCylinderNode.GetBottom: Boolean;
begin
  Result := FdBottom.Value;
end;

procedure TCylinderNode.SetBottom(const Value: Boolean);
begin
  FdBottom.Send(Value);
end;

function TCylinderNode.GetHeight: Single;
begin
  Result := FdHeight.Value;
end;

procedure TCylinderNode.SetHeight(const Value: Single);
begin
  FdHeight.Send(Value);
end;

function TCylinderNode.GetRadius: Single;
begin
  Result := FdRadius.Value;
end;

procedure TCylinderNode.SetRadius(const Value: Single);
begin
  FdRadius.Send(Value);
end;

function TCylinderNode.GetSide: Boolean;
begin
  Result := FdSide.Value;
end;

procedure TCylinderNode.SetSide(const Value: Boolean);
begin
  FdSide.Send(Value);
end;

function TCylinderNode.GetTop: Boolean;
begin
  Result := FdTop.Value;
end;

procedure TCylinderNode.SetTop(const Value: Boolean);
begin
  FdTop.Send(Value);
end;

function TCylinderNode.GetSlices: Integer;
begin
  Result := FdSlices.Value;
end;

procedure TCylinderNode.SetSlices(const Value: Integer);
begin
  FdSlices.Send(Value);
end;

function TCylinderNode.GetStacks: Integer;
begin
  Result := FdStacks.Value;
end;

procedure TCylinderNode.SetStacks(const Value: Integer);
begin
  FdStacks.Send(Value);
end;

{$endif read_implementation}
