#include <string>
#include <iostream>

#include "../canlxx.h"

int main(void) {
  AuthN::Context ctx(AuthN::Context::ClientFullContext);
  AuthN::IONetwork io(ctx);
  io.SetTimeout(10000);

  AuthN::Status st = io.Connect("download.nordugrid.org",443);
  if(!st) {
    std::cerr<<"Connect failed: "<<st.GetCode()<<": "<<st.GetDescription()<<std::endl;
    return -1;
  } else {
    std::cout<<"Connect succeeded"<<std::endl;
  };

  st = io.Write("GET / HTTP/1.0\r\n\r\n");
  if(!st) {
    std::cerr<<"Write failed: "<<st.GetCode()<<": "<<st.GetDescription()<<std::endl;
    return -1;
  } else {
    std::cout<<"Write succeeded"<<std::endl;
  };
  
  std::string str;
  st = io.Read(str);
  if(!st) {
    std::cerr<<"Read failed: "<<st.GetCode()<<std::endl;
    return -1;
  } else {
    std::cout<<"Read succeeded: "<<str<<std::endl;
  };

  return 0;
}
