/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2018 Univ. Grenoble Alpes, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

// Include .h file
#include "ComponentAddPropertyState.h"
#include "ComponentAddPropertyWidget.h"
#include "ComponentPropertyWidget.h"
#include "WizardMainWindow.h"
#include "ComponentCreationState.h"

// includes from coreschema
#include <Component.hxx>
#include <Parameters.hxx>
#include <Parameter.hxx>



ComponentAddPropertyState::ComponentAddPropertyState(QString name, ComponentAddPropertyWidget* widget, WizardMainWindow* mainWindow, ComponentCreationState* parent)
    : WizardState(name, widget, mainWindow, parent) {
    this->domComponent = nullptr;
}

void ComponentAddPropertyState::resetDomComponent(cepcoreschema::Component* domComponent) {
    this->domComponent = domComponent;
    auto* componentAddPropertyWidget = dynamic_cast<ComponentAddPropertyWidget*>(widget);
    if (componentAddPropertyWidget != nullptr) {
        componentAddPropertyWidget->setToDefault();
    }
}

void ComponentAddPropertyState::onEntry(QEvent* event) {
    WizardState::onEntry(event);
}

void ComponentAddPropertyState::onExit(QEvent* event) {
    addDomParameters();
    WizardState::onExit(event);
}


void ComponentAddPropertyState::addDomParameters() {
    auto* addParameterWidget = dynamic_cast<ComponentAddPropertyWidget*>((this->widget));
    QList<ComponentPropertyWidget*> parameterWidgets = addParameterWidget->getComponentPropertyWidgets();

    if (parameterWidgets.size() > 0) {
        cepcoreschema::Parameters domParameters;

        foreach (ComponentPropertyWidget* p, parameterWidgets) {
            QString name = p->getName();
            QString type = p->getType();
            QString defValue = p->getDefaultValue();
            QString description = p->getDescription();
            QString unit = p->getUnit();
            cepcoreschema::Parameter domParam(name.toStdString().c_str(), type.toStdString().c_str(), description.toStdString().c_str());
            domParam.unit(unit.toStdString().c_str());
            domParam.defaultValue(defValue.toStdString().c_str());
            domParameters.parameter().push_back(domParam);
        }
        this->domComponent->properties(domParameters);
    }
}
