//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/PropertyEditor/PropertyEditorFactory.h
//! @brief     Defines namespace GUI::View::PropertyEditorFactory
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_PROPERTYEDITOR_PROPERTYEDITORFACTORY_H
#define BORNAGAIN_GUI_VIEW_PROPERTYEDITOR_PROPERTYEDITORFACTORY_H

#include <QWidget>

//! Creates editors for SessionItems.

namespace GUI::View::PropertyEditorFactory {

//! Returns true if the index data has known (custom) conversion to string.
bool hasStringRepresentation(const QModelIndex& index);

//! Provides string representation of index data.
QString toString(const QModelIndex& index);

//! Creates an editor suitable for editing of item.value()
QWidget* CreateEditor(QObject* item, QWidget* parent = nullptr);

} // namespace GUI::View::PropertyEditorFactory

#endif // BORNAGAIN_GUI_VIEW_PROPERTYEDITOR_PROPERTYEDITORFACTORY_H
