//  Copyright John Maddock 2015.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#ifndef SC_
#define SC_(x) static_cast<typename table_type<T>::type>(BOOST_JOIN(x, L))
#endif
static const boost::array<boost::array<typename table_type<T>::type, 3>, 5456> powm1_big_data = {{
   {{ SC_(1.40358693897724151611328125000000000e-02), SC_(-9.68600749969482421875000000000000000e-01), SC_(6.13139649749185859889568752274202153e+01) }},
   {{ SC_(1.37798525393009185791015625000000000e-02), SC_(-4.72685337066650390625000000000000000e-01), SC_(6.57795125861153135596682898302650714e+00) }},
   {{ SC_(1.52787789702415466308593750000000000e-02), SC_(-9.95417833328247070312500000000000000e-01), SC_(6.32082071148443988316942482481809539e+01) }},
   {{ SC_(1.29717597961425781250000000000000000e+01), SC_(4.45825457572937011718750000000000000e-02), SC_(1.21037974465595417916623108558894713e-01) }},
   {{ SC_(1.57752342224121093750000000000000000e+01), SC_(3.72042804956436157226562500000000000e-02), SC_(1.08076713810552672198699988434807078e-01) }},
   {{ SC_(9.99499893188476562500000000000000000e+00), SC_(5.66981583833694458007812500000000000e-02), SC_(1.39425253943437098250855510809360606e-01) }},
   {{ SC_(9.99499893188476562500000000000000000e+00), SC_(5.44746965169906616210937500000000000e-02), SC_(1.33607895290495690108855139525559221e-01) }},
   {{ SC_(1.00000991821289062500000000000000000e+01), SC_(2.39999949932098388671875000000000000e-01), SC_(7.37804764999898165976148570593851312e-01) }},
   {{ SC_(1.00000991821289062500000000000000000e+01), SC_(2.59999990463256835937500000000000000e-01), SC_(8.19705511160314712073129220339084276e-01) }},
   {{ SC_(1.37798525393009185791015625000000000e-02), SC_(-4.72685337066650390625000000000000000e-01), SC_(6.57795125861153135596682898302650714e+00) }},
   {{ SC_(1.53191164135932922363281250000000000e-02), SC_(-4.99531507492065429687500000000000000e-01), SC_(7.06367354781946723343967050405632709e+00) }},
   {{ SC_(6.21584802865982055664062500000000000e-03), SC_(-4.21937108039855957031250000000000000e-01), SC_(7.53108099552312567063819546020830390e+00) }},
   {{ SC_(1.32666751742362976074218750000000000e-02), SC_(-4.73022699356079101562500000000000000e-01), SC_(6.72638136775087090925533797635650986e+00) }},
   {{ SC_(3.39388940483331680297851562500000000e-03), SC_(-3.82502675056457519531250000000000000e-01), SC_(7.80064981911041395171224050637383743e+00) }},
   {{ SC_(3.35320364683866500854492187500000000e-03), SC_(-4.85219240188598632812500000000000000e-01), SC_(1.48742952162308254716207417472426924e+01) }},
   {{ SC_(6.32373243570327758789062500000000000e-03), SC_(-4.30519104003906250000000000000000000e-01), SC_(7.84551094932430503184560723244625916e+00) }},
   {{ SC_(1.23675912618637084960937500000000000e-02), SC_(-4.84891176223754882812500000000000000e-01), SC_(7.41461228873111813391577678983782054e+00) }},
   {{ SC_(2.49752961099147796630859375000000000e-03), SC_(-4.70939874649047851562500000000000000e-01), SC_(1.58118694988516429640959904921099656e+01) }},
   {{ SC_(1.21638998389244079589843750000000000e-02), SC_(-4.69877481460571289062500000000000000e-01), SC_(6.93928063101788027934131132721178500e+00) }},
   {{ SC_(8.28581675887107849121093750000000000e-03), SC_(-4.34764146804809570312500000000000000e-01), SC_(7.03587488803114062999058693336289748e+00) }},
   {{ SC_(1.10541731119155883789062500000000000e-02), SC_(-4.80593323707580566406250000000000000e-01), SC_(7.71501656115011392187692033941163682e+00) }},
   {{ SC_(1.45965255796909332275390625000000000e-02), SC_(-4.91090774536132812500000000000000000e-01), SC_(6.97113452349364629811280252434960121e+00) }},
   {{ SC_(3.90971451997756958007812500000000000e-03), SC_(-3.89646291732788085937500000000000000e-01), SC_(7.67384692282039682403223907339597639e+00) }},
   {{ SC_(5.38974627852439880371093750000000000e-03), SC_(-4.12997841835021972656250000000000000e-01), SC_(7.64683929762525383920691783716911480e+00) }},
   {{ SC_(1.26898773014545440673828125000000000e-02), SC_(-4.99072313308715820312500000000000000e-01), SC_(7.84121376621578807091233318948741257e+00) }},
   {{ SC_(6.44005276262760162353515625000000000e-03), SC_(-4.27793860435485839843750000000000000e-01), SC_(7.65652626969064984357172044587710069e+00) }},
   {{ SC_(1.06915049254894256591796875000000000e-02), SC_(-4.76499319076538085937500000000000000e-01), SC_(7.69283928736174850057884929921240998e+00) }},
   {{ SC_(1.08045376837253570556640625000000000e-02), SC_(-4.68576669692993164062500000000000000e-01), SC_(7.34461421747499599556343261144210809e+00) }},
   {{ SC_(9.28939878940582275390625000000000000e-03), SC_(-4.60921764373779296875000000000000000e-01), SC_(7.64169108010368772145241105825353640e+00) }},
   {{ SC_(1.13556198775768280029296875000000000e-02), SC_(-4.49828743934631347656250000000000000e-01), SC_(6.49587027918336098975545793526501782e+00) }},
   {{ SC_(5.69070689380168914794921875000000000e-03), SC_(-4.16928052902221679687500000000000000e-01), SC_(7.62847764163587542321219291240974819e+00) }},
   {{ SC_(7.00179114937782287597656250000000000e-03), SC_(-4.42830801010131835937500000000000000e-01), SC_(7.99927984574078567649527298739248522e+00) }},
   {{ SC_(8.09568911790847778320312500000000000e-03), SC_(-4.49746012687683105468750000000000000e-01), SC_(7.72478036331216443386183042710734820e+00) }},
   {{ SC_(1.13619938492774963378906250000000000e-02), SC_(-4.69594597816467285156250000000000000e-01), SC_(7.18743826996095746389748569782530959e+00) }},
   {{ SC_(3.17379459738731384277343750000000000e-03), SC_(-4.77603077888488769531250000000000000e-01), SC_(1.46046361615961347563517242143979986e+01) }},
   {{ SC_(3.01454495638608932495117187500000000e-03), SC_(-3.67393970489501953125000000000000000e-01), SC_(7.43565334450580589483635528785488934e+00) }},
   {{ SC_(8.77318903803825378417968750000000000e-03), SC_(-4.47360277175903320312500000000000000e-01), SC_(7.32050405493998364367533159640395319e+00) }},
   {{ SC_(5.23655116558074951171875000000000000e-03), SC_(-4.08427000045776367187500000000000000e-01), SC_(7.54286344587137814322040506163569132e+00) }},
   {{ SC_(8.42629373073577880859375000000000000e-03), SC_(-4.55460309982299804687500000000000000e-01), SC_(7.80623356408757368614865549363936640e+00) }},
   {{ SC_(9.14872065186500549316406250000000000e-03), SC_(-4.53690528869628906250000000000000000e-01), SC_(7.41223687604779588185407693703222352e+00) }},
   {{ SC_(1.31538286805152893066406250000000000e-02), SC_(-5.00383377075195312500000000000000000e-01), SC_(7.73363467725571898975385139683455215e+00) }},
   {{ SC_(1.33334919810295104980468750000000000e-02), SC_(-5.05496263504028320312500000000000000e-01), SC_(7.86816674400926279633607829243321811e+00) }},
   {{ SC_(1.46741010248661041259765625000000000e-02), SC_(-5.05280017852783203125000000000000000e-01), SC_(7.44121357025654711205050424351104866e+00) }},
   {{ SC_(1.30087435245513916015625000000000000e-01), SC_(-5.15560150146484375000000000000000000e-01), SC_(1.86196919725389639759898143215677490e+00) }},
   {{ SC_(7.69089317321777343750000000000000000e+00), SC_(8.74754190444946289062500000000000000e-02), SC_(1.95366801091358573519837334230702545e-01) }},
   {{ SC_(7.03838920593261718750000000000000000e+00), SC_(1.05812937021255493164062500000000000e-01), SC_(2.29344596502088101870375840310013742e-01) }},
   {{ SC_(6.33947944641113281250000000000000000e+00), SC_(1.17388069629669189453125000000000000e-01), SC_(2.42085590743596131812345564594301785e-01) }},
   {{ SC_(7.22990989685058593750000000000000000e+00), SC_(8.41851532459259033203125000000000000e-02), SC_(1.81207602669328242933812573681544805e-01) }},
   {{ SC_(7.54215240478515625000000000000000000e+00), SC_(8.11126232147216796875000000000000000e-02), SC_(1.78083154335170385687692796416160408e-01) }},
   {{ SC_(5.58025741577148437500000000000000000e+00), SC_(1.09611749649047851562500000000000000e-01), SC_(2.07374715925532291917950445642458851e-01) }},
   {{ SC_(7.66306877136230468750000000000000000e+00), SC_(9.59842801094055175781250000000000000e-02), SC_(2.15874523555247580330391139347421385e-01) }},
   {{ SC_(6.64314460754394531250000000000000000e+00), SC_(1.07156187295913696289062500000000000e-01), SC_(2.24961476482137904711735795093497207e-01) }},
   {{ SC_(6.01063537597656250000000000000000000e+00), SC_(1.14902496337890625000000000000000000e-01), SC_(2.28852893626950739016978441459446116e-01) }},
   {{ SC_(6.70484733581542968750000000000000000e+00), SC_(1.04233473539352416992187500000000000e-01), SC_(2.19375275581195246579495724307696403e-01) }},
   {{ SC_(5.82308959960937500000000000000000000e+00), SC_(1.17083817720413208007812500000000000e-01), SC_(2.29099635042340858152263013264547386e-01) }},
   {{ SC_(4.79560470581054687500000000000000000e+00), SC_(1.34446084499359130859375000000000000e-01), SC_(2.34629717714579905263398532178314643e-01) }},
   {{ SC_(4.82458877563476562500000000000000000e+00), SC_(1.35542452335357666015625000000000000e-01), SC_(2.37764108898189475938528522974107900e-01) }},
   {{ SC_(7.03595352172851562500000000000000000e+00), SC_(9.54371988773345947265625000000000000e-02), SC_(2.04664548905371731722373788032349769e-01) }},
   {{ SC_(5.28019523620605468750000000000000000e+00), SC_(1.32636904716491699218750000000000000e-01), SC_(2.46952920335729148533947548336693092e-01) }},
   {{ SC_(6.38432312011718750000000000000000000e+00), SC_(1.13897681236267089843750000000000000e-01), SC_(2.35096001091238257597262997103130100e-01) }},
   {{ SC_(5.95332717895507812500000000000000000e+00), SC_(1.09638750553131103515625000000000000e-01), SC_(2.16028324915729991314503623074835064e-01) }},
   {{ SC_(6.98696708679199218750000000000000000e+00), SC_(1.03080242872238159179687500000000000e-01), SC_(2.21882610213145167381887304515801955e-01) }},
   {{ SC_(5.89052391052246093750000000000000000e+00), SC_(1.14364743232727050781250000000000000e-01), SC_(2.24837447230662785803610543834602456e-01) }},
   {{ SC_(6.37657356262207031250000000000000000e+00), SC_(1.16120278835296630859375000000000000e-01), SC_(2.40020629265553163399957803057905504e-01) }},
   {{ SC_(4.91455268859863281250000000000000000e+00), SC_(1.38538777828216552734375000000000000e-01), SC_(2.46801590503949137860198626154865489e-01) }},
   {{ SC_(7.93022537231445312500000000000000000e+00), SC_(8.48633646965026855468750000000000000e-02), SC_(1.92110177934672935437851267491699685e-01) }},
   {{ SC_(5.41107368469238281250000000000000000e+00), SC_(1.14726573228836059570312500000000000e-01), SC_(2.13744003209627429297910543734246465e-01) }},
   {{ SC_(5.32481956481933593750000000000000000e+00), SC_(1.22175633907318115234375000000000000e-01), SC_(2.26695468826182230025671853675799949e-01) }},
   {{ SC_(7.78324127197265625000000000000000000e+00), SC_(1.01823329925537109375000000000000000e-01), SC_(2.32369464626187330276207243581795541e-01) }},
   {{ SC_(7.22421264648437500000000000000000000e+00), SC_(8.20903778076171875000000000000000000e-02), SC_(1.76246755040825854317619959837773917e-01) }},
   {{ SC_(7.78170394897460937500000000000000000e+00), SC_(9.57216620445251464843750000000000000e-02), SC_(2.17012816050513980411234943455505539e-01) }},
   {{ SC_(6.27165412902832031250000000000000000e+00), SC_(1.03938728570938110351562500000000000e-01), SC_(2.10260562542707035636496502158615665e-01) }},
   {{ SC_(5.86248588562011718750000000000000000e+00), SC_(1.18854641914367675781250000000000000e-01), SC_(2.33928765017308206572327290021545948e-01) }},
   {{ SC_(7.53551864624023437500000000000000000e+00), SC_(8.63833129405975341796875000000000000e-02), SC_(1.90605651261541065564992958004178124e-01) }},
   {{ SC_(6.71205902099609375000000000000000000e+00), SC_(8.83181989192962646484375000000000000e-02), SC_(1.83113505846116122454206997905674119e-01) }},
   {{ SC_(5.62693214416503906250000000000000000e+00), SC_(1.12245619297027587890625000000000000e-01), SC_(2.13988881303110368259237670475270504e-01) }},
   {{ SC_(7.54092788696289062500000000000000000e+00), SC_(9.01910662651062011718750000000000000e-02), SC_(1.99874647706141013741400854752584126e-01) }},
   {{ SC_(7.33408737182617187500000000000000000e+00), SC_(1.10838532447814941406250000000000000e-01), SC_(2.47135637297999912019523638155767061e-01) }},
   {{ SC_(6.32725715637207031250000000000000000e+00), SC_(1.14337086677551269531250000000000000e-01), SC_(2.34834186427834038044954269377856227e-01) }},
   {{ SC_(6.19976615905761718750000000000000000e+00), SC_(1.01866602897644042968750000000000000e-01), SC_(2.04249794760256682779011141008923603e-01) }},
   {{ SC_(6.22207260131835937500000000000000000e+00), SC_(1.10271960496902465820312500000000000e-01), SC_(2.23344509486548398281678851060100230e-01) }},
   {{ SC_(7.66609573364257812500000000000000000e+00), SC_(1.02301567792892456054687500000000000e-01), SC_(2.31667073366673077892257579614151388e-01) }},
   {{ SC_(7.96978378295898437500000000000000000e+00), SC_(7.27940797805786132812500000000000000e-02), SC_(1.63107808332969206983131576581328314e-01) }},
   {{ SC_(7.08314132690429687500000000000000000e+00), SC_(8.53781998157501220703125000000000000e-02), SC_(1.81927281903233077251588392240409638e-01) }},
   {{ SC_(4.53972053527832031250000000000000000e+00), SC_(1.47384405136108398437500000000000000e-01), SC_(2.49786547829665616376329383966756501e-01) }},
   {{ SC_(5.75866317749023437500000000000000000e+00), SC_(1.26987159252166748046875000000000000e-01), SC_(2.48967363154409206501990340689616186e-01) }},
   {{ SC_(6.55630683898925781250000000000000000e+00), SC_(1.16656541824340820312500000000000000e-01), SC_(2.45284683139433036349647063492818770e-01) }},
   {{ SC_(5.31665611267089843750000000000000000e+00), SC_(1.20313137769699096679687500000000000e-01), SC_(2.22654789091726215698127280053560472e-01) }},
   {{ SC_(7.89138221740722656250000000000000000e+00), SC_(9.15054082870483398437500000000000000e-02), SC_(2.08076284255874365592718064128660801e-01) }},
   {{ SC_(4.42378044128417968750000000000000000e+00), SC_(1.46703600883483886718750000000000000e-01), SC_(2.43770469568639817250649993965874933e-01) }},
   {{ SC_(7.39138221740722656250000000000000000e+00), SC_(9.69834029674530029296875000000000000e-02), SC_(2.14093043846355418960157566041276970e-01) }},
   {{ SC_(6.14908790588378906250000000000000000e+00), SC_(1.16599947214126586914062500000000000e-01), SC_(2.35877103011213218716352940573710416e-01) }},
   {{ SC_(6.59487342834472656250000000000000000e+00), SC_(1.08138114213943481445312500000000000e-01), SC_(2.26273779750314345567319296111973674e-01) }},
   {{ SC_(7.27998161315917968750000000000000000e+00), SC_(9.67942476272583007812500000000000000e-02), SC_(2.11851073902311215837367671780373768e-01) }},
   {{ SC_(5.50705146789550781250000000000000000e+00), SC_(1.30372464656829833984375000000000000e-01), SC_(2.49094953580352544537366488631843784e-01) }},
   {{ SC_(5.49210357666015625000000000000000000e+00), SC_(1.14867419004440307617187500000000000e-01), SC_(2.16107249459074799812607952456216931e-01) }},
   {{ SC_(5.01198196411132812500000000000000000e+00), SC_(1.33224189281463623046875000000000000e-01), SC_(2.39533298570586677397584671737450715e-01) }},
   {{ SC_(4.60243225097656250000000000000000000e+00), SC_(1.44579887390136718750000000000000000e-01), SC_(2.46966092355122851149405376463154190e-01) }},
   {{ SC_(7.39781379699707031250000000000000000e+00), SC_(9.14975106716156005859375000000000000e-02), SC_(2.00938581490572250996056260674743317e-01) }},
   {{ SC_(7.51522254943847656250000000000000000e+00), SC_(9.43360924720764160156250000000000000e-02), SC_(2.09575359029133920659255772964193090e-01) }},
   {{ SC_(7.72433280944824218750000000000000000e+00), SC_(7.74428844451904296875000000000000000e-02), SC_(1.71543759710774344041542790561721342e-01) }},
   {{ SC_(5.27965545654296875000000000000000000e+00), SC_(1.24830186367034912109375000000000000e-01), SC_(2.30843933480363376116197550095393085e-01) }},
   {{ SC_(7.63476753234863281250000000000000000e+00), SC_(7.80032873153686523437500000000000000e-02), SC_(1.71820188299954340632187446146098180e-01) }},
   {{ SC_(4.86182785034179687500000000000000000e+00), SC_(1.38028085231781005859375000000000000e-01), SC_(2.43934836847155213074266392508968072e-01) }},
   {{ SC_(6.45785903930664062500000000000000000e+00), SC_(1.07723653316497802734375000000000000e-01), SC_(2.22547380126039460905092333857478186e-01) }},
   {{ SC_(5.92928886413574218750000000000000000e+00), SC_(1.23865902423858642578125000000000000e-01), SC_(2.46661839106784032889152611905211132e-01) }},
   {{ SC_(5.50461006164550781250000000000000000e+00), SC_(1.30213439464569091796875000000000000e-01), SC_(2.48684017557248238175415012758765873e-01) }},
   {{ SC_(7.51457786560058593750000000000000000e+00), SC_(8.61440896987915039062500000000000000e-02), SC_(1.89745315481497701378529792608489819e-01) }},
   {{ SC_(6.17707443237304687500000000000000000e+00), SC_(9.74213182926177978515625000000000000e-02), SC_(1.94095622446584984499001844747657638e-01) }},
   {{ SC_(7.37487983703613281250000000000000000e+00), SC_(1.09301805496215820312500000000000000e-01), SC_(2.44076775146222125382541991515221274e-01) }},
   {{ SC_(5.13651275634765625000000000000000000e+00), SC_(1.21811211109161376953125000000000000e-01), SC_(2.20583163178787351812187689524113723e-01) }},
   {{ SC_(7.19759368896484375000000000000000000e+00), SC_(1.00037693977355957031250000000000000e-01), SC_(2.18291021182809487011102927477045347e-01) }},
   {{ SC_(4.50801086425781250000000000000000000e+00), SC_(1.43011391162872314453125000000000000e-01), SC_(2.40301583236703987655918920396662327e-01) }},
   {{ SC_(5.53081893920898437500000000000000000e+00), SC_(1.18400186300277709960937500000000000e-01), SC_(2.24465091441829624911487889937942707e-01) }},
   {{ SC_(5.99872207641601562500000000000000000e+00), SC_(1.00901991128921508789062500000000000e-01), SC_(1.98140300301855849346087798106843940e-01) }},
   {{ SC_(6.97812271118164062500000000000000000e+00), SC_(1.14131569862365722656250000000000000e-01), SC_(2.48237458503988784813553872423666614e-01) }},
   {{ SC_(6.79132843017578125000000000000000000e+00), SC_(1.04874998331069946289062500000000000e-01), SC_(2.22506709349511372302815698085456558e-01) }},
   {{ SC_(5.84613800048828125000000000000000000e+00), SC_(1.08505666255950927734375000000000000e-01), SC_(2.11182643290007393839295522291364802e-01) }},
   {{ SC_(7.44551086425781250000000000000000000e+00), SC_(1.05419665575027465820312500000000000e-01), SC_(2.35705064956945213450947366461262504e-01) }},
   {{ SC_(6.75273323059082031250000000000000000e+00), SC_(1.14458471536636352539062500000000000e-01), SC_(2.44345456523290708061537905569149301e-01) }},
   {{ SC_(7.34200096130371093750000000000000000e+00), SC_(8.05962085723876953125000000000000000e-02), SC_(1.74306219235947703761629898562434147e-01) }},
   {{ SC_(7.42459297180175781250000000000000000e+00), SC_(8.75940918922424316406250000000000000e-02), SC_(1.91971248986898126536955727960723023e-01) }},
   {{ SC_(6.26563644409179687500000000000000000e+00), SC_(1.18135511875152587890625000000000000e-01), SC_(2.42080921115558827183549556956803147e-01) }},
   {{ SC_(6.77034759521484375000000000000000000e+00), SC_(1.07930213212966918945312500000000000e-01), SC_(2.29272082617475034399134841862490565e-01) }},
   {{ SC_(6.58103752136230468750000000000000000e+00), SC_(1.14761859178543090820312500000000000e-01), SC_(2.41392116055696197966907699566014202e-01) }},
   {{ SC_(7.06429672241210937500000000000000000e+00), SC_(1.00130766630172729492187500000000000e-01), SC_(2.16236193165486563280930892391404791e-01) }},
   {{ SC_(5.20499229431152343750000000000000000e+00), SC_(1.20423167943954467773437500000000000e-01), SC_(2.19757724008980592515761765589014378e-01) }},
   {{ SC_(4.34931755065917968750000000000000000e+00), SC_(1.50637447834014892578125000000000000e-01), SC_(2.47872252061080858493220431563391891e-01) }},
   {{ SC_(7.60806083679199218750000000000000000e+00), SC_(8.97354781627655029296875000000000000e-02), SC_(1.99724538308926070806237924030351344e-01) }},
   {{ SC_(5.38602828979492187500000000000000000e+00), SC_(1.31253123283386230468750000000000000e-01), SC_(2.47329781213476319411048768731538991e-01) }},
   {{ SC_(5.31787300109863281250000000000000000e+00), SC_(1.23066902160644531250000000000000000e-01), SC_(2.28327917713843330590704477335817376e-01) }},
   {{ SC_(7.19771003723144531250000000000000000e+00), SC_(9.22094285488128662109375000000000000e-02), SC_(1.99613655744550909205468619173509900e-01) }},
   {{ SC_(6.55326461791992187500000000000000000e+00), SC_(9.83700752258300781250000000000000000e-02), SC_(2.03136786743488177077890220843990206e-01) }},
   {{ SC_(6.57760429382324218750000000000000000e+00), SC_(1.05339348316192626953125000000000000e-01), SC_(2.19480114646979114882453327176988369e-01) }},
   {{ SC_(7.89247512817382812500000000000000000e+00), SC_(9.90322232246398925781250000000000000e-02), SC_(2.27023894546537205700265863480391126e-01) }},
   {{ SC_(5.34890556335449218750000000000000000e+00), SC_(1.24184101819992065429687500000000000e-01), SC_(2.31512789022954041973654771425276250e-01) }},
   {{ SC_(7.73207092285156250000000000000000000e+00), SC_(7.63295292854309082031250000000000000e-02), SC_(1.68969560598839516809361823648077525e-01) }},
   {{ SC_(5.01405715942382812500000000000000000e+00), SC_(1.25472486019134521484375000000000000e-01), SC_(2.24205960559116061692303103715296245e-01) }},
   {{ SC_(6.44014358520507812500000000000000000e+00), SC_(1.08382254838943481445312500000000000e-01), SC_(2.23685809220805429040736268180094623e-01) }},
   {{ SC_(7.68866729736328125000000000000000000e+00), SC_(8.87279808521270751953125000000000000e-02), SC_(1.98394415770430629353168355323442877e-01) }},
   {{ SC_(6.58283996582031250000000000000000000e+00), SC_(1.06701284646987915039062500000000000e-01), SC_(2.22716436171216937430154167919195672e-01) }},
   {{ SC_(4.99547386169433593750000000000000000e+00), SC_(1.34266495704650878906250000000000000e-01), SC_(2.41067618401819849802594041150757549e-01) }},
   {{ SC_(5.59232521057128906250000000000000000e+00), SC_(1.28472268581390380859375000000000000e-01), SC_(2.47512465880807687907256240025508441e-01) }},
   {{ SC_(4.36417007446289062500000000000000000e+00), SC_(1.48861408233642578125000000000000000e-01), SC_(2.45250323639311151883344776192648767e-01) }},
   {{ SC_(7.87688255310058593750000000000000000e+00), SC_(1.05877220630645751953125000000000000e-01), SC_(2.44238138947003630738567233565354695e-01) }},
   {{ SC_(6.97659873962402343750000000000000000e+00), SC_(8.85849595069885253906250000000000000e-02), SC_(1.87774909450731437747170680502541812e-01) }},
   {{ SC_(7.01679801940917968750000000000000000e+00), SC_(8.94375145435333251953125000000000000e-02), SC_(1.90355182023129333475690306868089271e-01) }},
   {{ SC_(6.58757400512695312500000000000000000e+00), SC_(1.16889655590057373046875000000000000e-01), SC_(2.46523707021662501656191674820471828e-01) }},
   {{ SC_(7.72528457641601562500000000000000000e+00), SC_(8.33877027034759521484375000000000000e-02), SC_(1.85881104599650692696443595738171085e-01) }},
   {{ SC_(5.38250160217285156250000000000000000e+00), SC_(1.18647605180740356445312500000000000e-01), SC_(2.21038958933343223998139249658882045e-01) }},
   {{ SC_(7.14856147766113281250000000000000000e+00), SC_(1.06240719556808471679687500000000000e-01), SC_(2.32403164263340181837577216473042961e-01) }},
   {{ SC_(7.94486236572265625000000000000000000e+00), SC_(8.27276408672332763671875000000000000e-02), SC_(1.87030895254530021672774262763467408e-01) }},
   {{ SC_(7.59248352050781250000000000000000000e+00), SC_(1.06722742319107055664062500000000000e-01), SC_(2.41529317967409872174641597721249804e-01) }},
   {{ SC_(7.25205421447753906250000000000000000e+00), SC_(8.69704782962799072265625000000000000e-02), SC_(1.88049971931993941282493991038324402e-01) }},
   {{ SC_(6.74076652526855468750000000000000000e+00), SC_(1.03223919868469238281250000000000000e-01), SC_(2.17706490387547044637424654068628723e-01) }},
   {{ SC_(7.38290977478027343750000000000000000e+00), SC_(9.74290072917938232421875000000000000e-02), SC_(2.15039927017844805697594639933608830e-01) }},
   {{ SC_(7.75609016418457031250000000000000000e+00), SC_(8.50152671337127685546875000000000000e-02), SC_(1.90236390883884693005353696900103047e-01) }},
   {{ SC_(5.46505928039550781250000000000000000e+00), SC_(1.12940073013305664062500000000000000e-01), SC_(2.11445885577238584280547323864367695e-01) }},
   {{ SC_(7.70184135437011718750000000000000000e+00), SC_(1.07421755790710449218750000000000000e-01), SC_(2.45201242130521466078063830848874674e-01) }},
   {{ SC_(5.90121078491210937500000000000000000e+00), SC_(1.02683454751968383789062500000000000e-01), SC_(1.99949304582865951676382608200683133e-01) }},
   {{ SC_(6.00864219665527343750000000000000000e+00), SC_(1.14778429269790649414062500000000000e-01), SC_(2.28532713595930908958911359534442312e-01) }},
   {{ SC_(7.69124412536621093750000000000000000e+00), SC_(7.75785148143768310546875000000000000e-02), SC_(1.71478439643487190287779048760370899e-01) }},
   {{ SC_(5.92211723327636718750000000000000000e+00), SC_(1.04586899280548095703125000000000000e-01), SC_(2.04456096589001681452118680314944923e-01) }},
   {{ SC_(6.62739562988281250000000000000000000e+00), SC_(9.71561074256896972656250000000000000e-02), SC_(2.01706689469928735778187243539656785e-01) }},
   {{ SC_(7.07572555541992187500000000000000000e+00), SC_(8.57559442520141601562500000000000000e-02), SC_(1.82695413889285008334297669507922120e-01) }},
   {{ SC_(7.50540161132812500000000000000000000e+00), SC_(9.68953967094421386718750000000000000e-02), SC_(2.15681211880577431041387591223887665e-01) }},
   {{ SC_(5.77297210693359375000000000000000000e+00), SC_(1.10998749732971191406250000000000000e-01), SC_(2.14826866558572130389074528653723486e-01) }},
   {{ SC_(4.93928337097167968750000000000000000e+00), SC_(1.34022474288940429687500000000000000e-01), SC_(2.38701198885152838883394779506229437e-01) }},
   {{ SC_(5.16066551208496093750000000000000000e+00), SC_(1.28286540508270263671875000000000000e-01), SC_(2.34327912683944404470541500238496931e-01) }},
   {{ SC_(6.55119895935058593750000000000000000e+00), SC_(9.78022217750549316406250000000000000e-02), SC_(2.01816014661073671793321341912504178e-01) }},
   {{ SC_(9.37734985351562500000000000000000000e+00), SC_(6.55488073825836181640625000000000000e-02), SC_(1.58027019140818501373179526096977174e-01) }},
   {{ SC_(8.07984161376953125000000000000000000e+00), SC_(9.75474119186401367187500000000000000e-02), SC_(2.26068682403697213397811458927298874e-01) }},
   {{ SC_(8.24467468261718750000000000000000000e+00), SC_(8.39999914169311523437500000000000000e-02), SC_(1.93874203004090574280037077953662734e-01) }},
   {{ SC_(8.38256835937500000000000000000000000e+00), SC_(9.46378707885742187500000000000000000e-02), SC_(2.22887323299614743375785420153911722e-01) }},
   {{ SC_(9.95129394531250000000000000000000000e+00), SC_(-5.67094534635543823242187500000000000e-02), SC_(-1.22169238039022470988312413811638117e-01) }},
   {{ SC_(9.09993362426757812500000000000000000e+00), SC_(6.26848340034484863281250000000000000e-02), SC_(1.48463380284136666198252369004089041e-01) }},
   {{ SC_(8.65277862548828125000000000000000000e+00), SC_(8.68087708950042724609375000000000000e-02), SC_(2.06016709779072012051017996780895380e-01) }},
   {{ SC_(8.01225662231445312500000000000000000e+00), SC_(9.99259054660797119140625000000000000e-02), SC_(2.31143061366864157409035210417701391e-01) }},
   {{ SC_(8.80384826660156250000000000000000000e+00), SC_(8.27540457248687744140625000000000000e-02), SC_(1.97224168225095801115368242742944605e-01) }},
   {{ SC_(9.75410461425781250000000000000000000e+00), SC_(8.98647010326385498046875000000000000e-02), SC_(2.27136943095352939828074627236949532e-01) }},
   {{ SC_(9.03805541992187500000000000000000000e+00), SC_(6.42104744911193847656250000000000000e-02), SC_(1.51834359243859987434565704037409541e-01) }},
   {{ SC_(9.37380218505859375000000000000000000e+00), SC_(7.78287351131439208984375000000000000e-02), SC_(1.90263116800782801756417246266180211e-01) }},
   {{ SC_(9.61176681518554687500000000000000000e+00), SC_(8.65036249160766601562500000000000000e-02), SC_(2.16230924028659627799594990769600853e-01) }},
   {{ SC_(8.29948425292968750000000000000000000e+00), SC_(9.64728593826293945312500000000000000e-02), SC_(2.26488521417622589238685445055156494e-01) }},
   {{ SC_(9.05094528198242187500000000000000000e+00), SC_(9.03826653957366943359375000000000000e-02), SC_(2.20305442497945356331928809790183735e-01) }},
   {{ SC_(8.71602630615234375000000000000000000e+00), SC_(9.86539721488952636718750000000000000e-02), SC_(2.38129747928269481125258838917612720e-01) }},
   {{ SC_(8.58335113525390625000000000000000000e+00), SC_(8.17390382289886474609375000000000000e-02), SC_(1.92109682386404977987937772723310990e-01) }},
   {{ SC_(8.73153686523437500000000000000000000e+00), SC_(9.94403958320617675781250000000000000e-02), SC_(2.40459047132197566457799449668792895e-01) }},
   {{ SC_(8.81718444824218750000000000000000000e+00), SC_(8.75837802886962890625000000000000000e-02), SC_(2.10028413879728094203926830793648322e-01) }},
   {{ SC_(9.70779037475585937500000000000000000e+00), SC_(6.65788352489471435546875000000000000e-02), SC_(1.63379283049700202180990001149472695e-01) }},
   {{ SC_(8.30752944946289062500000000000000000e+00), SC_(7.04651474952697753906250000000000000e-02), SC_(1.60889070172023965121223538643494480e-01) }},
   {{ SC_(8.23855972290039062500000000000000000e+00), SC_(1.00199133157730102539062500000000000e-01), SC_(2.35285961267286179661768954399162426e-01) }},
   {{ SC_(8.83529281616210937500000000000000000e+00), SC_(9.18915867805480957031250000000000000e-02), SC_(2.21658284083222181208732938214986324e-01) }},
   {{ SC_(9.68615722656250000000000000000000000e+00), SC_(8.12512636184692382812500000000000000e-02), SC_(2.02613449939999129089207392224745822e-01) }},
   {{ SC_(9.32432937622070312500000000000000000e+00), SC_(8.51489007472991943359375000000000000e-02), SC_(2.09377468972175388313779121582893047e-01) }},
   {{ SC_(9.25368881225585937500000000000000000e+00), SC_(9.66692268848419189453125000000000000e-02), SC_(2.39974955110650360747950887214350370e-01) }},
   {{ SC_(8.88903808593750000000000000000000000e+00), SC_(8.80582332611083984375000000000000000e-02), SC_(2.12144720910075517109787202449742318e-01) }},
   {{ SC_(9.49725723266601562500000000000000000e+00), SC_(7.39746987819671630859375000000000000e-02), SC_(1.81183937315013174232688099688771212e-01) }},
   {{ SC_(9.19234466552734375000000000000000000e+00), SC_(7.89662897586822509765625000000000000e-02), SC_(1.91456525903218890307928518942801249e-01) }},
   {{ SC_(9.42488479614257812500000000000000000e+00), SC_(7.41149783134460449218750000000000000e-02), SC_(1.80887290184340459296637231856565592e-01) }},
   {{ SC_(9.11682128906250000000000000000000000e+00), SC_(6.54513537883758544921875000000000000e-02), SC_(1.55641296100257767506375580573336497e-01) }},
   {{ SC_(8.00793457031250000000000000000000000e+00), SC_(9.01331901550292968750000000000000000e-02), SC_(2.06249611509324331324858740680376214e-01) }},
   {{ SC_(8.68663024902343750000000000000000000e+00), SC_(7.49134123325347900390625000000000000e-02), SC_(1.75797567136894822189439318388724198e-01) }},
   {{ SC_(9.25294876098632812500000000000000000e+00), SC_(7.65593349933624267578125000000000000e-02), SC_(1.85708044183072993964294946182589614e-01) }},
   {{ SC_(8.12383270263671875000000000000000000e+00), SC_(9.44455862045288085937500000000000000e-02), SC_(2.18773234854822155341918320174235640e-01) }},
   {{ SC_(9.56738662719726562500000000000000000e+00), SC_(8.26573967933654785156250000000000000e-02), SC_(2.05229693674186342806395437297192685e-01) }},
   {{ SC_(8.71606445312500000000000000000000000e+00), SC_(9.06837582588195800781250000000000000e-02), SC_(2.16947354248302453907559977933626760e-01) }},
   {{ SC_(8.19760131835937500000000000000000000e+00), SC_(1.00797653198242187500000000000000000e-01), SC_(2.36224893192049423363956265956609890e-01) }},
   {{ SC_(9.26792526245117187500000000000000000e+00), SC_(8.04753303527832031250000000000000000e-02), SC_(1.96239773239522427931643164112464645e-01) }},
   {{ SC_(8.98069000244140625000000000000000000e+00), SC_(9.84756350517272949218750000000000000e-02), SC_(2.41302924703678195674843083453590468e-01) }},
   {{ SC_(9.18965148925781250000000000000000000e+00), SC_(1.00046724081039428710937500000000000e-01), SC_(2.48460807954974779938047019976768932e-01) }},
   {{ SC_(9.27389144897460937500000000000000000e+00), SC_(8.23909044265747070312500000000000000e-02), SC_(2.01416498643115372751799850015859606e-01) }},
   {{ SC_(8.57521057128906250000000000000000000e+00), SC_(7.59616196155548095703125000000000000e-02), SC_(1.77309872838146132879458716806818065e-01) }},
   {{ SC_(9.97986602783203125000000000000000000e+00), SC_(7.94551372528076171875000000000000000e-02), SC_(2.00564759004605999394499514440611995e-01) }},
   {{ SC_(9.54933166503906250000000000000000000e+00), SC_(6.84743523597717285156250000000000000e-02), SC_(1.67086417954970805170752654569336000e-01) }},
   {{ SC_(8.79903793334960937500000000000000000e+00), SC_(8.55384767055511474609375000000000000e-02), SC_(2.04441046378334273205642375402381079e-01) }},
   {{ SC_(8.27149963378906250000000000000000000e+00), SC_(7.16885328292846679687500000000000000e-02), SC_(1.63537189545932046976979945666857488e-01) }},
   {{ SC_(9.93539810180664062500000000000000000e+00), SC_(6.78210854530334472656250000000000000e-02), SC_(1.68503957626391576277261292270254773e-01) }},
   {{ SC_(8.19038391113281250000000000000000000e+00), SC_(7.15736746788024902343750000000000000e-02), SC_(1.62434636443541172246088071094111312e-01) }},
   {{ SC_(8.24273300170898437500000000000000000e+00), SC_(8.03193151950836181640625000000000000e-02), SC_(1.84617690946538266335294405578897174e-01) }},
   {{ SC_(9.86737060546875000000000000000000000e+00), SC_(6.72295689582824707031250000000000000e-02), SC_(1.66379114023191429363508545108996606e-01) }},
   {{ SC_(9.34264373779296875000000000000000000e+00), SC_(8.40441286563873291015625000000000000e-02), SC_(2.06597129354865079145849252303511356e-01) }},
   {{ SC_(8.32001495361328125000000000000000000e+00), SC_(8.75530242919921875000000000000000000e-02), SC_(2.03814716655849947273090756334549013e-01) }},
   {{ SC_(9.86837768554687500000000000000000000e+00), SC_(9.18905138969421386718750000000000000e-02), SC_(2.34132399870019976754705905553498771e-01) }},
   {{ SC_(9.67834472656250000000000000000000000e+00), SC_(6.08305782079696655273437500000000000e-02), SC_(1.48065985777927758207031489384841414e-01) }},
   {{ SC_(8.38747406005859375000000000000000000e+00), SC_(7.73116946220397949218750000000000000e-02), SC_(1.78711423456417143950058174281850878e-01) }},
   {{ SC_(9.05358505249023437500000000000000000e+00), SC_(9.38565433025360107421875000000000000e-02), SC_(2.29713307257636441963030948423079479e-01) }},
   {{ SC_(8.02633666992187500000000000000000000e+00), SC_(9.27226543426513671875000000000000000e-02), SC_(2.13023603657323876789520775318566643e-01) }},
   {{ SC_(8.44375610351562500000000000000000000e+00), SC_(8.22365283966064453125000000000000000e-02), SC_(1.91777214112216537563177965577748123e-01) }},
   {{ SC_(8.24141693115234375000000000000000000e+00), SC_(7.76588916778564453125000000000000000e-02), SC_(1.77973962861084427285447894090311576e-01) }},
   {{ SC_(9.02873992919921875000000000000000000e+00), SC_(9.36643779277801513671875000000000000e-02), SC_(2.28876451048224601981453112486251762e-01) }},
   {{ SC_(9.47903060913085937500000000000000000e+00), SC_(6.38226270675659179687500000000000000e-02), SC_(1.54355668126392701267578836940253740e-01) }},
   {{ SC_(8.99235534667968750000000000000000000e+00), SC_(7.97294676303863525390625000000000000e-02), SC_(1.91384164186201038837920495296584537e-01) }},
   {{ SC_(9.34598159790039062500000000000000000e+00), SC_(9.94966328144073486328125000000000000e-02), SC_(2.49032996104213666879004400337607762e-01) }},
   {{ SC_(8.95864486694335937500000000000000000e+00), SC_(1.00298792123794555664062500000000000e-01), SC_(2.45973353598498475260986246298555438e-01) }},
   {{ SC_(8.81187057495117187500000000000000000e+00), SC_(7.56854712963104248046875000000000000e-02), SC_(1.79038333409596468119532138618359673e-01) }},
   {{ SC_(8.74928665161132812500000000000000000e+00), SC_(8.00567567348480224609375000000000000e-02), SC_(1.89628266821018075793702328814323234e-01) }},
   {{ SC_(8.43222045898437500000000000000000000e+00), SC_(7.29682743549346923828125000000000000e-02), SC_(1.68326927609834324154372064912694775e-01) }},
   {{ SC_(8.25551986694335937500000000000000000e+00), SC_(7.51850605010986328125000000000000000e-02), SC_(1.71994261421687824085174204613709418e-01) }},
   {{ SC_(8.04505157470703125000000000000000000e+00), SC_(9.61624681949615478515625000000000000e-02), SC_(2.22018800717506936742057661861894802e-01) }},
   {{ SC_(8.87688446044921875000000000000000000e+00), SC_(7.24205374717712402343750000000000000e-02), SC_(1.71314554970200883138641604849983929e-01) }},
   {{ SC_(8.62379837036132812500000000000000000e+00), SC_(8.21304023265838623046875000000000000e-02), SC_(1.93573868398173781197450356395150061e-01) }},
   {{ SC_(1.55334281921386718750000000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(4.49304552898364748929542132255939641e+307) }},
   {{ SC_(6.43772840499877929687500000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(4.49459742139385805478084770127453654e+307) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(9.59489440917968750000000000000000000e+01), SC_(4.49354430486862272177076186517987661e+307) }},
   {{ SC_(2.41287422180175781250000000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(4.49350651171174822860461334608120111e+307) }},
   {{ SC_(4.14443373680114746093750000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(4.49543904254081140988214360397587734e+307) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(1.05890319824218750000000000000000000e+02), SC_(4.49417490217509911168529630317766685e+307) }},
   {{ SC_(5.82196235656738281250000000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(4.49361400305658432636132699321009427e+307) }},
   {{ SC_(1.71763360500335693359375000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(4.49490745003344846118999844181506817e+307) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(1.18129852294921875000000000000000000e+02), SC_(4.49400184091400969164715453805551712e+307) }},
   {{ SC_(3.38952331542968750000000000000000000e+01), SC_(2.01061889648437500000000000000000000e+02), SC_(4.49328010227202896477180105618779615e+307) }},
   {{ SC_(2.95026600360870361328125000000000000e-02), SC_(-2.01061950683593750000000000000000000e+02), SC_(4.49466160491469841523315645437234269e+307) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(1.33568603515625000000000000000000000e+02), SC_(4.49303150625990574258640719539222715e+307) }},
   {{ SC_(1.14888769531250000000000000000000000e+03), SC_(1.00530944824218750000000000000000000e+02), SC_(4.49362010466394203588365590932207847e+307) }},
   {{ SC_(8.70407093316316604614257812500000000e-04), SC_(-1.00530975341796875000000000000000000e+02), SC_(4.49458679327016417238262327117058569e+307) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(1.53649597167968750000000000000000000e+02), SC_(4.49316308630469194737069693194178670e+307) }},
   {{ SC_(1.31994250000000000000000000000000000e+06), SC_(5.02654724121093750000000000000000000e+01), SC_(4.49354541982623329573838969463417147e+307) }},
   {{ SC_(7.57608404455822892487049102783203125e-07), SC_(-5.02654876708984375000000000000000000e+01), SC_(4.49461769919984359106896966827846791e+307) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(1.80837036132812500000000000000000000e+02), SC_(4.49347788310852382809183815034288175e+307) }},
   {{ SC_(1.74224886988800000000000000000000000e+12), SC_(2.51327362060546875000000000000000000e+01), SC_(4.49358862883539489060816093589373142e+307) }},
   {{ SC_(5.73970775422094625639601872535422444e-13), SC_(-2.51327438354492187500000000000000000e+01), SC_(4.49456241220651852404076498545958281e+307) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(2.19714233398437500000000000000000000e+02), SC_(4.49374345791964894307942427444206953e+307) }},
   {{ SC_(3.03543133699448503481139200000000000e+24), SC_(1.25663681030273437500000000000000000e+01), SC_(4.49359257952512928090607321440149969e+307) }},
   {{ SC_(3.29442414908975355525959583510195959e-25), SC_(-1.25663719177246093750000000000000000e+01), SC_(4.49456860636088997245958993270599696e+307) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(2.79885253906250000000000000000000000e+02), SC_(4.49373643078016291681232079572184454e+307) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(3.85442749023437500000000000000000000e+02), SC_(4.49375325036334461137330024035202620e+307) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(6.18832763671875000000000000000000000e+02), SC_(4.49340918624663034004828649351687675e+307) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(1.56869677734375000000000000000000000e+03), SC_(4.49244656637925058340223124756746043e+307) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-2.93253613281250000000000000000000000e+03), SC_(4.49746830449464930003719524119946400e+307) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-7.57876953125000000000000000000000000e+02), SC_(4.49492813615443770728986388879260209e+307) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-4.35170654296875000000000000000000000e+02), SC_(4.49451764376393828121449451802277021e+307) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-3.05210937500000000000000000000000000e+02), SC_(4.49452424953787378466930928302094357e+307) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-2.35023376464843750000000000000000000e+02), SC_(4.49463777345783952359800216580226760e+307) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-1.91081481933593750000000000000000000e+02), SC_(4.49454685627065323387370994888984121e+307) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-1.60982849121093750000000000000000000e+02), SC_(4.49512743883331738160379246797822860e+307) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-1.39075927734375000000000000000000000e+02), SC_(4.49433673254536924118107822471513022e+307) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-1.22417144775390625000000000000000000e+02), SC_(4.49436452060261557475003965313443102e+307) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-1.09322326660156250000000000000000000e+02), SC_(4.49493516526343408338062795544982188e+307) }},
   {{ SC_(1.00574254989624023437500000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(1.00000262593236315201471865998084954e+04) }},
   {{ SC_(9.94290113449096679687500000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(1.00020807515027575557313498440863352e+04) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(1.24751043319702148437500000000000000e+00), SC_(9.99996914606686679023901352919494405e+03) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-1.24751091003417968750000000000000000e+00), SC_(-9.99900010042538243977142331706514703e-01) }},
   {{ SC_(1.01151800155639648437500000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(9.99942898111232307108007098880426259e+03) }},
   {{ SC_(9.88612890243530273437500000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(1.00015881046963118708358302938607869e+04) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(1.37676620483398437500000000000000000e+00), SC_(9.99997683522128401528420412715477573e+03) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-1.37676668167114257812500000000000000e+00), SC_(-9.99900010086366062748644721458363307e-01) }},
   {{ SC_(1.02316856384277343750000000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(9.99902168778429860451222975745445621e+03) }},
   {{ SC_(9.77355718612670898437500000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(1.00004693473152193572593204515225077e+04) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(1.53590250015258789062500000000000000e+00), SC_(9.99998232750841841020724885019709863e+03) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-1.53590297698974609375000000000000000e+00), SC_(-9.99900010108229513457316730143979113e-01) }},
   {{ SC_(1.04687404632568359375000000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(9.99928344863777589003744694429405542e+03) }},
   {{ SC_(9.55224275588989257812500000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(1.00003117043657827601573685988788937e+04) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(1.73663473129272460937500000000000000e+00), SC_(9.99997769407378620711211408174740993e+03) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-1.73663520812988281250000000000000000e+00), SC_(-9.99900010028855866901020040697228214e-01) }},
   {{ SC_(1.09594583511352539062500000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(9.99980289102583972944360150668990876e+03) }},
   {{ SC_(9.12453651428222656250000000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(1.00000530302604614147105334004220682e+04) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(1.99772453308105468750000000000000000e+00), SC_(9.99999848687446329048838513777385648e+03) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-1.99772453308105468750000000000000000e+00), SC_(-9.99900009983871868131239650393974949e-01) }},
   {{ SC_(1.20109748840332031250000000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(9.99989283375751402692028178673868151e+03) }},
   {{ SC_(8.32571744918823242187500000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(1.00000053819282890671106830738140616e+04) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(2.35120964050292968750000000000000000e+00), SC_(9.99996439055999746499336124749297960e+03) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-2.35121059417724609375000000000000000e+00), SC_(-9.99900010016523513588964428692372742e-01) }},
   {{ SC_(1.44263553619384765625000000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(9.99995547735484852289176923760058793e+03) }},
   {{ SC_(6.93175554275512695312500000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(1.00000620079340333469995905931854874e+04) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(2.85668373107910156250000000000000000e+00), SC_(9.99997125077737373983338418659831798e+03) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-2.85668468475341796875000000000000000e+00), SC_(-9.99900010019015132545476243776207955e-01) }},
   {{ SC_(2.08119773864746093750000000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(9.99998255205337595567339964966934736e+03) }},
   {{ SC_(4.80492472648620605468750000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(1.00000296784026374081778838789502148e+04) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(3.63901710510253906250000000000000000e+00), SC_(9.99999433876522997385312240416073789e+03) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-3.63901710510253906250000000000000000e+00), SC_(-9.99900009942399041021151266453450843e-01) }},
   {{ SC_(4.33138275146484375000000000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(9.99996404200935306568911104881835100e+03) }},
   {{ SC_(2.30873048305511474609375000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(1.00000209596174253800752214279370186e+04) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(5.01145553588867187500000000000000000e+00), SC_(9.99997830032186885896229915442285369e+03) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-5.01145744323730468750000000000000000e+00), SC_(-9.99900010132558528617480648315796835e-01) }},
   {{ SC_(1.87608871459960937500000000000000000e+01), SC_(3.14159202575683593750000000000000000e+00), SC_(9.99998180446726669968476476909689078e+03) }},
   {{ SC_(5.33023774623870849609375000000000000e-02), SC_(-3.14159297943115234375000000000000000e+00), SC_(1.00000132799529388915955542377427101e+04) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(8.04594802856445312500000000000000000e+00), SC_(9.99995192897004392242844706543872933e+03) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-8.04595184326171875000000000000000000e+00), SC_(-9.99900009955020820031024311985597281e-01) }},
   {{ SC_(3.51970825195312500000000000000000000e+02), SC_(1.57079601287841796875000000000000000e+00), SC_(9.99997906804346158295619862952955537e+03) }},
   {{ SC_(2.84114386886358261108398437500000000e-03), SC_(-1.57079648971557617187500000000000000e+00), SC_(1.00000109260121038039745721681510842e+04) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(2.03959045410156250000000000000000000e+01), SC_(9.99993305804979319220796574886406090e+03) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-2.03959121704101562500000000000000000e+01), SC_(-9.99900009674207354467136623631889993e-01) }},
   {{ SC_(1.23883500000000000000000000000000000e+05), SC_(7.85398006439208984375000000000000000e-01), SC_(9.99998149080755581802767967060007274e+03) }},
   {{ SC_(8.07210017228499054908752441406250000e-06), SC_(-7.85398244857788085937500000000000000e-01), SC_(1.00000092827728820964313962713075414e+04) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-3.81282958984375000000000000000000000e+01), SC_(1.00000904539960656556376762418879852e+04) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(3.81282806396484375000000000000000000e+01), SC_(-9.99900010534792068466226869415260023e-01) }},
   {{ SC_(1.53471221760000000000000000000000000e+10), SC_(3.92699003219604492187500000000000000e-01), SC_(9.99998164530902999299537409091665883e+03) }},
   {{ SC_(6.51587950262211279550683684647083282e-11), SC_(-3.92699122428894042968750000000000000e-01), SC_(1.00000096543736676418346760964290746e+04) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-9.85377883911132812500000000000000000e+00), SC_(1.00000353750905046754726928604636379e+04) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(9.85377502441406250000000000000000000e+00), SC_(-9.99900009996151016779805073832817664e-01) }},
   {{ SC_(2.35534108755570458624000000000000000e+20), SC_(1.96349501609802246093750000000000000e-01), SC_(9.99998122570351254043623497506203200e+03) }},
   {{ SC_(4.24566766822893769712743091727935596e-21), SC_(-1.96349561214447021484375000000000000e-01), SC_(1.00000100711201060680949365156866115e+04) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-5.65801048278808593750000000000000000e+00), SC_(1.00000312486450381393450875483885866e+04) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(5.65800857543945312500000000000000000e+00), SC_(-9.99900010000965149468801119075887715e-01) }},
   {{ SC_(1.80263034450744468003628573594414811e-41), SC_(-9.81747806072235107421875000000000000e-02), SC_(9.99997687291307174177584355881549343e+03) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-3.96829700469970703125000000000000000e+00), SC_(1.00000165119005599455072352529918496e+04) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(3.96829605102539062500000000000000000e+00), SC_(-9.99900009942759665553517816122708363e-01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-3.05573081970214843750000000000000000e+00), SC_(1.00000106474035086419580375289411616e+04) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(3.05572986602783203125000000000000000e+00), SC_(-9.99900009818029297284199231840493645e-01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-2.48440647125244140625000000000000000e+00), SC_(1.00000117979376405363473644430271848e+04) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(2.48440551757812500000000000000000000e+00), SC_(-9.99900009763435154605345836950111714e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-2.09306907653808593750000000000000000e+00), SC_(1.00000075928634822918885796189926197e+04) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(2.09306907653808593750000000000000000e+00), SC_(-9.99900010074913493729270580061506644e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-1.80823993682861328125000000000000000e+00), SC_(1.00000142395909319304922841279739592e+04) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(1.80823945999145507812500000000000000e+00), SC_(-9.99900009898510134698130337535097552e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-1.59164524078369140625000000000000000e+00), SC_(1.00000018733895792026589504083183624e+04) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(1.59164524078369140625000000000000000e+00), SC_(-9.99900010017730246056275939398554372e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-1.42138862609863281250000000000000000e+00), SC_(1.00000058270111199120555855937093842e+04) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(1.42138862609863281250000000000000000e+00), SC_(-9.99900010057258524970897382543981401e-01) }},
   {{ SC_(1.00430440902709960937500000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(1.00000770529139949110940996678452334e+03) }},
   {{ SC_(9.95713949203491210937500000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(1.00015582927449764644356786712322423e+03) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(9.35758352279663085937500000000000000e-01), SC_(9.99999957535641059180411394529479821e+02) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-9.35758352279663085937500000000000000e-01), SC_(-9.99000998958619441754808603065182120e-01) }},
   {{ SC_(1.00862693786621093750000000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(9.99682004269730658808467594443577706e+02) }},
   {{ SC_(9.91446256637573242187500000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(1.00016557549252375140585515611067669e+03) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(1.03271293640136718750000000000000000e+00), SC_(9.99998856517156656883569464806710035e+02) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-1.03271341323852539062500000000000000e+00), SC_(-9.99001001046606446539977507685270664e-01) }},
   {{ SC_(1.01732873916625976562500000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(9.99855812184858579720382381995048601e+02) }},
   {{ SC_(9.82965946197509765625000000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(1.00005647346851334339716383783119215e+03) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(1.15208101272583007812500000000000000e+00), SC_(9.99998495364409951269664373601909591e+02) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-1.15208148956298828125000000000000000e+00), SC_(-9.99001000355987478339031425260430836e-01) }},
   {{ SC_(1.03495836257934570312500000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(9.99972295513867280290446370709269283e+02) }},
   {{ SC_(9.66222286224365234375000000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(1.00000755490769834869182111866554114e+03) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(1.30265045166015625000000000000000000e+00), SC_(9.99998788917723931856304956760484191e+02) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-1.30265092849731445312500000000000000e+00), SC_(-9.99001000318766868729514208043483902e-01) }},
   {{ SC_(1.07113885879516601562500000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(9.99976666079778297565963210071271109e+02) }},
   {{ SC_(9.33585405349731445312500000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(1.00001844693106622215438579453494838e+03) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(1.49849367141723632812500000000000000e+00), SC_(9.99998726522624545454645194581590516e+02) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-1.49849414825439453125000000000000000e+00), SC_(-9.99000999926308592272411063554497550e-01) }},
   {{ SC_(1.14733886718750000000000000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(9.99994749866767611022752877289941658e+02) }},
   {{ SC_(8.71582031250000000000000000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(9.99999848250749631248478282064579695e+02) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(1.76364374160766601562500000000000000e+00), SC_(9.99999314583830771606361448210962327e+02) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-1.76364421844482421875000000000000000e+00), SC_(-9.99001000183007597776112983360836408e-01) }},
   {{ SC_(1.31638669967651367187500000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(9.99999021563594985272080452771623122e+02) }},
   {{ SC_(7.59655237197875976562500000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(9.99999848250749631248478282064579695e+02) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(2.14279937744140625000000000000000000e+00), SC_(9.99997317453799952422813020497764830e+02) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-2.14280033111572265625000000000000000e+00), SC_(-9.99000999395543745242182068743327498e-01) }},
   {{ SC_(1.73287391662597656250000000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(9.99998829496085534140022478285268199e+02) }},
   {{ SC_(5.77075958251953125000000000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(1.00000248905147738692095196224361475e+03) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(2.72962760925292968750000000000000000e+00), SC_(9.99998337737861152806754732972801858e+02) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-2.72962856292724609375000000000000000e+00), SC_(-9.99000999753416012194029453467680518e-01) }},
   {{ SC_(3.00285148620605468750000000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(9.99997730480066026673823667183143905e+02) }},
   {{ SC_(3.33016753196716308593750000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(1.00000075897793952547179157911736964e+03) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(3.75909519195556640625000000000000000e+00), SC_(9.99999312504881679149389609060301273e+02) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-3.75909519195556640625000000000000000e+00), SC_(-9.99000998314876341941240317530327808e-01) }},
   {{ SC_(9.01711654663085937500000000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(9.99997555553997259331261355588750952e+02) }},
   {{ SC_(1.10900133848190307617187500000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(1.00000144127722263551397087932041714e+03) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(6.03527069091796875000000000000000000e+00), SC_(9.99998742392544156717437710609877227e+02) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-6.03527069091796875000000000000000000e+00), SC_(-9.99000997745901415425948605550285716e-01) }},
   {{ SC_(8.13084411621093750000000000000000000e+01), SC_(1.57079601287841796875000000000000000e+00), SC_(9.99998529169630381782472669597347600e+02) }},
   {{ SC_(1.22988447546958923339843750000000000e-02), SC_(-1.57079648971557617187500000000000000e+00), SC_(1.00000079345780605831403531840333194e+03) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(1.52989768981933593750000000000000000e+01), SC_(9.99995534649837919424202776766228726e+02) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-1.52989807128906250000000000000000000e+01), SC_(-9.99000996265482095016056664095191102e-01) }},
   {{ SC_(6.61106250000000000000000000000000000e+03), SC_(7.85398006439208984375000000000000000e-01), SC_(9.99998516776799075286281582745572981e+02) }},
   {{ SC_(1.51261570863425731658935546875000000e-04), SC_(-7.85398244857788085937500000000000000e-01), SC_(1.00000085290014576188087849027666061e+03) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-2.86000442504882812500000000000000000e+01), SC_(1.00000562398986048423761012274043390e+03) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(2.86000442504882812500000000000000000e+01), SC_(-9.99001004613726196877525557248226276e-01) }},
   {{ SC_(4.37061600000000000000000000000000000e+07), SC_(3.92699003219604492187500000000000000e-01), SC_(9.99998630290337497587298502328961649e+02) }},
   {{ SC_(2.28800658419459068682044744491577148e-08), SC_(-3.92699122428894042968750000000000000e-01), SC_(1.00000080098266811784411696561483839e+03) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-7.39132308959960937500000000000000000e+00), SC_(1.00000254420940209554767704425115016e+03) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(7.39132118225097656250000000000000000e+00), SC_(-9.99000999759083752658145516701683416e-01) }},
   {{ SC_(1.91022804395622400000000000000000000e+15), SC_(1.96349501609802246093750000000000000e-01), SC_(9.99998591398576170280371749020250566e+02) }},
   {{ SC_(5.23497489863969205081684066271918709e-16), SC_(-1.96349561214447021484375000000000000e-01), SC_(1.00000077209863236263138638094676287e+03) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-4.24407577514648437500000000000000000e+00), SC_(1.00000232405102798513381591139145238e+03) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(4.24407386779785156250000000000000000e+00), SC_(-9.99000998218612976648383194492506355e-01) }},
   {{ SC_(3.64897212796619250113695868518400000e+30), SC_(9.81747508049011230468750000000000000e-02), SC_(9.99998616931099895820412618169102647e+02) }},
   {{ SC_(2.74049768854660623108797448845076535e-31), SC_(-9.81747806072235107421875000000000000e-02), SC_(1.00000071939913449337135929024025794e+03) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-2.97662162780761718750000000000000000e+00), SC_(1.00000252640210700864957447467586937e+03) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(2.97662067413330078125000000000000000e+00), SC_(-9.99000999311079898557349433045135573e-01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-2.29210472106933593750000000000000000e+00), SC_(1.00000045324391717533158890410273459e+03) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(2.29210472106933593750000000000000000e+00), SC_(-9.99000999453337583446125183542709350e-01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-1.86355447769165039062500000000000000e+00), SC_(1.00000181462283034146891719012695185e+03) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(1.86355400085449218750000000000000000e+00), SC_(-9.99000999045983720270827648724030227e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-1.57001209259033203125000000000000000e+00), SC_(1.00000141571882735455222352668605539e+03) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(1.57001161575317382812500000000000000e+00), SC_(-9.99000998317688596211390166184674602e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-1.35636138916015625000000000000000000e+00), SC_(1.00000072874247888516480156777731521e+03) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(1.35636091232299804687500000000000000e+00), SC_(-9.99000997301895521765965377671302872e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-1.19389390945434570312500000000000000e+00), SC_(1.00000139424661362803615529737990168e+03) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(1.19389343261718750000000000000000000e+00), SC_(-9.99000997635882306344255304711527379e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-1.06618452072143554687500000000000000e+00), SC_(1.00000289139165688578022345498429422e+03) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(1.06618404388427734375000000000000000e+00), SC_(-9.99000998799847115271091894593779099e-01) }},
   {{ SC_(1.00287294387817382812500000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(9.99364168890846027717311114745743932e+01) }},
   {{ SC_(9.97134923934936523437500000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(9.99955740277211058155398676754380706e+01) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(6.25096321105957031250000000000000000e-01), SC_(9.99999567232745332237384598907579625e+01) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-6.25096559524536132812500000000000000e-01), SC_(-9.90099023086870389051888311678863561e-01) }},
   {{ SC_(1.00575494766235351562500000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(1.00001500891275016521218244164993806e+02) }},
   {{ SC_(9.94277954101562500000000000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(1.00003942111775402846190606754542909e+02) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(6.89862966537475585937500000000000000e-01), SC_(9.99998648675749445540456889357342967e+01) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-6.89863204956054687500000000000000000e-01), SC_(-9.90099012446063581734610966447021430e-01) }},
   {{ SC_(1.01154279708862304687500000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(9.99927619166705833197837755002371764e+01) }},
   {{ SC_(9.88588571548461914062500000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(1.00007165848592120782578054383539791e+02) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(7.69602298736572265625000000000000000e-01), SC_(9.99999722847275729593913495321403018e+01) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-7.69602298736572265625000000000000000e-01), SC_(-9.90099007184072146617699136392785950e-01) }},
   {{ SC_(1.02321910858154296875000000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(9.99982837379323682069538484773964776e+01) }},
   {{ SC_(9.77307558059692382812500000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(1.00003129085030450787454636056854465e+02) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(8.70184183120727539062500000000000000e-01), SC_(9.99999422740803049366221646014371271e+01) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-8.70184421539306640625000000000000000e-01), SC_(-9.90099016761739186220716013948655204e-01) }},
   {{ SC_(1.04697751998901367187500000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(9.99999888574166272309062886134266051e+01) }},
   {{ SC_(9.55130338668823242187500000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(1.00000198937181089581975082211853443e+02) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(1.00100946426391601562500000000000000e+00), SC_(9.99999163936811196191212553478001558e+01) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-1.00100994110107421875000000000000000e+00), SC_(-9.90099023471828633135179382701849345e-01) }},
   {{ SC_(1.09616184234619140625000000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(9.99995951106451741753121868928370034e+01) }},
   {{ SC_(9.12273883819580078125000000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(1.00000644284823453292057472420108305e+02) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(1.17813253402709960937500000000000000e+00), SC_(9.99999743514495505702567782973283506e+01) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-1.17813253402709960937500000000000000e+00), SC_(-9.90099007386672192649806920201128085e-01) }},
   {{ SC_(1.20157098770141601562500000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(1.00000024143057326244304624412883675e+02) }},
   {{ SC_(8.32243680953979492187500000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(1.00000516623980579772927736111767117e+02) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(1.43141269683837890625000000000000000e+00), SC_(9.99999106399143726273278744831394024e+01) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-1.43141317367553710937500000000000000e+00), SC_(-9.90099016362878399551437113297270279e-01) }},
   {{ SC_(1.44377231597900390625000000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(9.99995648145646995926718412550313426e+01) }},
   {{ SC_(6.92629814147949218750000000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(1.00000022486191007093451010178572376e+02) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(1.82342004776000976562500000000000000e+00), SC_(9.99999466767625403857934418530840504e+01) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-1.82342052459716796875000000000000000e+00), SC_(-9.90099016623099980170039838243419685e-01) }},
   {{ SC_(2.08447933197021484375000000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(9.99998179819985865519088514668982286e+01) }},
   {{ SC_(4.79735970497131347656250000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(1.00000140149967285966006367424438875e+02) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(2.51111412048339843750000000000000000e+00), SC_(9.99998014844025179088038145092926871e+01) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-2.51111507415771484375000000000000000e+00), SC_(-9.90099007794386583718007319948763225e-01) }},
   {{ SC_(4.34505462646484375000000000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(9.99998574927910527744445196637496092e+01) }},
   {{ SC_(2.30146646499633789062500000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(1.00000077956070221379111673131697627e+02) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(4.03162384033203125000000000000000000e+00), SC_(9.99998965748447526942564942387327263e+01) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-4.03162384033203125000000000000000000e+00), SC_(-9.90098999762252607003611913423857494e-01) }},
   {{ SC_(1.88795013427734375000000000000000000e+01), SC_(1.57079601287841796875000000000000000e+00), SC_(9.99998712389990543033321380472316931e+01) }},
   {{ SC_(5.29674887657165527343750000000000000e-02), SC_(-1.57079648971557617187500000000000000e+00), SC_(1.00000048390946532500466759233011722e+02) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(1.02198791503906250000000000000000000e+01), SC_(9.99998096381077784990475717030147252e+01) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-1.02198791503906250000000000000000000e+01), SC_(-9.90098991239853836801181253057466892e-01) }},
   {{ SC_(3.56435668945312500000000000000000000e+02), SC_(7.85398006439208984375000000000000000e-01), SC_(9.99998930475574771975983156265812984e+01) }},
   {{ SC_(2.80555430799722671508789062500000000e-03), SC_(-7.85398244857788085937500000000000000e-01), SC_(1.00000064172255926013955985878147958e+02) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-1.91051330566406250000000000000000000e+01), SC_(1.00000479047477546391311740816116068e+02) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(1.91051254272460937500000000000000000e+01), SC_(-9.90099038614224431247791175552355139e-01) }},
   {{ SC_(1.27046406250000000000000000000000000e+05), SC_(3.92699003219604492187500000000000000e-01), SC_(9.99998993392721505381866955697632023e+01) }},
   {{ SC_(7.87113822298124432563781738281250000e-06), SC_(-3.92699122428894042968750000000000000e-01), SC_(1.00000047806302065138341134054285779e+02) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-4.93748092651367187500000000000000000e+00), SC_(1.00000145676915899196368967262186280e+02) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(4.93747901916503906250000000000000000e+00), SC_(-9.90099006529932909241840893614226684e-01) }},
   {{ SC_(1.61407959040000000000000000000000000e+10), SC_(1.96349501609802246093750000000000000e-01), SC_(9.99999074028105518673049430257139567e+01) }},
   {{ SC_(6.19548023994553886950598098337650299e-11), SC_(-1.96349561214447021484375000000000000e-01), SC_(1.00000052455919102812926484850147554e+02) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-2.83508682250976562500000000000000000e+00), SC_(1.00000119755206662200757025087720733e+02) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(2.83508586883544921875000000000000000e+00), SC_(-9.90099006269772194946716696812424992e-01) }},
   {{ SC_(2.60525216406546939904000000000000000e+20), SC_(9.81747508049011230468750000000000000e-02), SC_(9.99999045099302756783826555803262413e+01) }},
   {{ SC_(3.83839915440734572940221841150232329e-21), SC_(-9.81747806072235107421875000000000000e-02), SC_(1.00000048286371370411953376590690772e+02) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-1.98841381072998046875000000000000000e+00), SC_(1.00000030241992113477622807263488736e+02) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(1.98841381072998046875000000000000000e+00), SC_(-9.90099012865599750833423203471903323e-01) }},
   {{ SC_(1.47332520539111266836920928387101782e-41), SC_(-4.90873903036117553710937500000000000e-02), SC_(1.00000067135605145969351447705159995e+02) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-1.53115034103393554687500000000000000e+00), SC_(1.00000150030416010697943029521050847e+02) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(1.53114986419677734375000000000000000e+00), SC_(-9.90099010378101174738074039451641086e-01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-1.24487400054931640625000000000000000e+00), SC_(1.00000160067696109418436252200679111e+02) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(1.24487352371215820312500000000000000e+00), SC_(-9.90099008089591382151943007684223635e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-1.04878473281860351562500000000000000e+00), SC_(1.00000192891379592000148234671604701e+02) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(1.04878425598144531250000000000000000e+00), SC_(-9.90099008034819743499053854897051899e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-9.06063556671142578125000000000000000e-01), SC_(1.00000023216209704874306251793211790e+02) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(9.06063556671142578125000000000000000e-01), SC_(-9.90099012176865441458404646176605429e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-7.97533512115478515625000000000000000e-01), SC_(1.00000025200141070399646567537111386e+02) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(7.97533512115478515625000000000000000e-01), SC_(-9.90099012371349356220573195137535446e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-7.12222337722778320312500000000000000e-01), SC_(1.00000140258825360353656256554760711e+02) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(7.12222099304199218750000000000000000e-01), SC_(-9.90099008354200644210135139823586185e-01) }},
   {{ SC_(1.00149154663085937500000000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(9.99409193034746373393078542779495484e+00) }},
   {{ SC_(9.98510360717773437500000000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(9.99966326031350062031882655029319827e+00) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(3.24783563613891601562500000000000000e-01), SC_(9.99999358367136495317472754114450837e+00) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-3.24783682823181152343750000000000000e-01), SC_(-9.09090936075076524947180919303389080e-01) }},
   {{ SC_(1.00298595428466796875000000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(9.99970286279308862256611319807243959e+00) }},
   {{ SC_(9.97022867202758789062500000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(1.00003132880748012071289668273984310e+01) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(3.58434677124023437500000000000000000e-01), SC_(9.99999372456984575305006495510488614e+00) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-3.58434796333312988281250000000000000e-01), SC_(-9.09090929727748845663703017443254279e-01) }},
   {{ SC_(1.00598049163818359375000000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(9.99823941864268632338318692630816772e+00) }},
   {{ SC_(9.94054555892944335937500000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(1.00004994409607808013341174384482432e+01) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(3.99865031242370605468750000000000000e-01), SC_(9.99999265124137176756796830677607316e+00) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-3.99865150451660156250000000000000000e-01), SC_(-9.09090913345482070973853920847752002e-01) }},
   {{ SC_(1.01199722290039062500000000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(9.99927377649217821439196120047401265e+00) }},
   {{ SC_(9.88144636154174804687500000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(1.00001053637812326630112733842835415e+01) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(4.52124834060668945312500000000000000e-01), SC_(9.99999747519447559461060139541597819e+00) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-4.52124953269958496093750000000000000e-01), SC_(-9.09090945701093446575385712334763269e-01) }},
   {{ SC_(1.02413892745971679687500000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(9.99986579628968597131783301814346653e+00) }},
   {{ SC_(9.76429939270019531250000000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(9.99997250594421207894109722910111451e+00) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(5.20098209381103515625000000000000000e-01), SC_(9.99999586786852018264597031954247656e+00) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-5.20098447799682617187500000000000000e-01), SC_(-9.09090974870182363453706399086003039e-01) }},
   {{ SC_(1.04886054992675781250000000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(9.99986958571060977298342785262580104e+00) }},
   {{ SC_(9.53415393829345703125000000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(9.99999133848494811493636202259680522e+00) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(6.12126588821411132812500000000000000e-01), SC_(9.99999429944046164102580882810354498e+00) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-6.12126827239990234375000000000000000e-01), SC_(-9.09090946884416616249664784125253245e-01) }},
   {{ SC_(1.10010862350463867187500000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(9.99991238512345446999351962103954018e+00) }},
   {{ SC_(9.09000873565673828125000000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(1.00000033899116935498229067392873575e+01) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(7.43724346160888671875000000000000000e-01), SC_(9.99999301963868926101273133278832815e+00) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-7.43724584579467773437500000000000000e-01), SC_(-9.09090921283982869885538737924012559e-01) }},
   {{ SC_(1.21023941040039062500000000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(9.99996114312219064165699980452180737e+00) }},
   {{ SC_(8.26282501220703125000000000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(1.00000179313183786598665866058836357e+01) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(9.47401046752929687500000000000000000e-01), SC_(9.99999514684051534080973790560531757e+00) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-9.47401285171508789062500000000000000e-01), SC_(-9.09090923840611791893254040147183536e-01) }},
   {{ SC_(1.46468019485473632812500000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(9.99999721192290885636273726698968751e+00) }},
   {{ SC_(6.82742834091186523437500000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(1.00000116278657429904370545736989262e+01) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(1.30470895767211914062500000000000000e+00), SC_(9.99999051916899231040990874404216986e+00) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-1.30470943450927734375000000000000000e+00), SC_(-9.09090910406716606586212516210253100e-01) }},
   {{ SC_(2.14528751373291015625000000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(9.99998819972044809880543977963284531e+00) }},
   {{ SC_(4.66137886047363281250000000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(1.00000035808219433217787848244490830e+01) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(2.09472560882568359375000000000000000e+00), SC_(9.99999247223037459270808390598309776e+00) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-2.09472656250000000000000000000000000e+00), SC_(-9.09090946123299128976630501182423619e-01) }},
   {{ SC_(4.60225868225097656250000000000000000e+00), SC_(1.57079601287841796875000000000000000e+00), SC_(9.99998882172249059324123125301024183e+00) }},
   {{ SC_(2.17284500598907470703125000000000000e-01), SC_(-1.57079648971557617187500000000000000e+00), SC_(1.00000058241045031649506628783466703e+01) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(5.30998039245605468750000000000000000e+00), SC_(9.99998874354556527751938608201841142e+00) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-5.30998039245605468750000000000000000e+00), SC_(-9.09090816062264846098129447409019317e-01) }},
   {{ SC_(2.11807937622070312500000000000000000e+01), SC_(7.85398006439208984375000000000000000e-01), SC_(9.99999240454260612153842898261783847e+00) }},
   {{ SC_(4.72125709056854248046875000000000000e-02), SC_(-7.85398244857788085937500000000000000e-01), SC_(1.00000027672407914774869917453810693e+01) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-9.92652511596679687500000000000000000e+00), SC_(1.00000279606104065214021143963598814e+01) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(9.92652130126953125000000000000000000e+00), SC_(-9.09091056397547665684767727509441078e-01) }},
   {{ SC_(4.48626220703125000000000000000000000e+02), SC_(3.92699003219604492187500000000000000e-01), SC_(9.99999429471399808222120707992762932e+00) }},
   {{ SC_(2.22902651876211166381835937500000000e-03), SC_(-3.92699122428894042968750000000000000e-01), SC_(1.00000034121098480292694812990246803e+01) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-2.56538581848144531250000000000000000e+00), SC_(1.00000139273182629585288123812507631e+01) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(2.56538486480712890625000000000000000e+00), SC_(-9.09090943155298214218043517981574820e-01) }},
   {{ SC_(2.01265500000000000000000000000000000e+05), SC_(1.96349501609802246093750000000000000e-01), SC_(9.99999444600011747618659838860220671e+00) }},
   {{ SC_(4.96856046083848923444747924804687500e-06), SC_(-1.96349561214447021484375000000000000e-01), SC_(1.00000028732987145584904523213826933e+01) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-1.47303676605224609375000000000000000e+00), SC_(1.00000103128061756066511813315723669e+01) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(1.47303628921508789062500000000000000e+00), SC_(-9.09090923754882260335909354192045730e-01) }},
   {{ SC_(4.05078016000000000000000000000000000e+10), SC_(9.81747508049011230468750000000000000e-02), SC_(9.99999444892600838019884086579266746e+00) }},
   {{ SC_(2.46865930475514971931261243298649788e-11), SC_(-9.81747806072235107421875000000000000e-02), SC_(1.00000028735373926595815952543070542e+01) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-1.03312778472900390625000000000000000e+00), SC_(1.00000081213261361219199079187231915e+01) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(1.03312730789184570312500000000000000e+00), SC_(-9.09090875596366091212792255471148783e-01) }},
   {{ SC_(1.64088258358276626841600000000000000e+21), SC_(4.90873754024505615234375000000000000e-02), SC_(9.99999464410173971096845744022382194e+00) }},
   {{ SC_(6.09427941627535714988798764115210393e-22), SC_(-4.90873903036117553710937500000000000e-02), SC_(1.00000028156522459076052126060151374e+01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-7.95545339584350585937500000000000000e-01), SC_(1.00000045678644327569093904274272081e+01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(7.95545101165771484375000000000000000e-01), SC_(-9.09090881511827322634978402386078838e-01) }},
   {{ SC_(3.71344093046076523794788339571827775e-43), SC_(-2.45436951518058776855468750000000000e-02), SC_(1.00000452153481141203183444162612692e+01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-6.46803617477416992187500000000000000e-01), SC_(1.00000016728097943267757142872220317e+01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(6.46803617477416992187500000000000000e-01), SC_(-9.09090922915781321789895122453228678e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-5.44920921325683593750000000000000000e-01), SC_(1.00000085139560301198892646844585184e+01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(5.44920682907104492187500000000000000e-01), SC_(-9.09090884077014851133863724623974924e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-4.70766782760620117187500000000000000e-01), SC_(1.00000003227089763877727740457285699e+01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(4.70766782760620117187500000000000000e-01), SC_(-9.09090911757925346449601899672813624e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-4.14377450942993164062500000000000000e-01), SC_(1.00000019358249426601379656775268567e+01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(4.14377331733703613281250000000000000e-01), SC_(-9.09090862377320118183440986909285440e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-3.70051980018615722656250000000000000e-01), SC_(1.00000065232835105754227613183219349e+01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(3.70051860809326171875000000000000000e-01), SC_(-9.09090892778416537347968363116906389e-01) }},
   {{ SC_(1.00043106079101562500000000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(1.00012520382516518520589793188926942e+00) }},
   {{ SC_(9.99569177627563476562500000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(9.99956060260098572084839564416069669e-01) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(9.38835144042968750000000000000000000e-02), SC_(9.99999810397226277539632455544230445e-01) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-9.38835442066192626953125000000000000e-02), SC_(-5.00000062615382793662851346421150660e-01) }},
   {{ SC_(1.00086212158203125000000000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(9.99826584946050313720026913853947866e-01) }},
   {{ SC_(9.99138355255126953125000000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(1.00025488297326006708201555313406263e+00) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(1.03610873222351074218750000000000000e-01), SC_(9.99999878011771009023305581689237657e-01) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-1.03610903024673461914062500000000000e-01), SC_(-5.00000069190321558089789912100921965e-01) }},
   {{ SC_(1.00172519683837890625000000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(9.99995516326963429685099265948404954e-01) }},
   {{ SC_(9.98277664184570312500000000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(1.00008468395600678834263541756624920e+00) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(1.15586936473846435546875000000000000e-01), SC_(9.99999861641556334294760206936280815e-01) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-1.15586966276168823242187500000000000e-01), SC_(-5.00000054769071542101804359850360644e-01) }},
   {{ SC_(1.00345325469970703125000000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(9.99949319194849993642378356967598085e-01) }},
   {{ SC_(9.96558427810668945312500000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(1.00003101487183125133016371593924084e+00) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(1.30693376064300537109375000000000000e-01), SC_(9.99999755211855061486224391449026217e-01) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-1.30693435668945312500000000000000000e-01), SC_(-5.00000096862928209937929216673552539e-01) }},
   {{ SC_(1.00691843032836914062500000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(9.99948512693084178759989357853765019e-01) }},
   {{ SC_(9.93128776550292968750000000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(1.00001552504439324148580979129313964e+00) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(1.50342106819152832031250000000000000e-01), SC_(9.99999858956013650351884830084772331e-01) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-1.50342166423797607421875000000000000e-01), SC_(-5.00000102141573571250012524718237014e-01) }},
   {{ SC_(1.01388502120971679687500000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(9.99977849379507825067471962915963650e-01) }},
   {{ SC_(9.86304759979248046875000000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(1.00001622151978225552739750574545639e+00) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(1.76944255828857421875000000000000000e-01), SC_(9.99999620062885638125716768300235763e-01) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-1.76944315433502197265625000000000000e-01), SC_(-5.00000021760898011713320600987801340e-01) }},
   {{ SC_(1.02796316146850585937500000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(9.99993752655009666426406286222060032e-01) }},
   {{ SC_(9.72797393798828125000000000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(9.99999984275432095463347880863870451e-01) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(2.14984595775604248046875000000000000e-01), SC_(9.99999935069972248685366223859104907e-01) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-2.14984595775604248046875000000000000e-01), SC_(-4.99999983767492535182761473962151847e-01) }},
   {{ SC_(1.05670833587646484375000000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(9.99995525511947635059135204752536058e-01) }},
   {{ SC_(9.46334600448608398437500000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(1.00000447080565484664457273779596180e+00) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(2.73860335350036621093750000000000000e-01), SC_(9.99999827528796764367567786229301380e-01) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-2.73860335350036621093750000000000000e-01), SC_(-4.99999956882195472802078104244844884e-01) }},
   {{ SC_(1.11663293838500976562500000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(1.00000037898320808386815266786508051e+00) }},
   {{ SC_(8.95549297332763671875000000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(1.00000276834522454341701329396085886e+00) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(3.77145528793334960937500000000000000e-01), SC_(9.99999724274678754151676514337206408e-01) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-3.77145648002624511718750000000000000e-01), SC_(-5.00000040614661059906961191444080841e-01) }},
   {{ SC_(1.24686861038208007812500000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(9.99997815537165797065446645734995342e-01) }},
   {{ SC_(8.02008867263793945312500000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(1.00000023542749800548111870025637436e+00) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(6.05511426925659179687500000000000000e-01), SC_(9.99999450113003623665895885811980406e-01) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-6.05511665344238281250000000000000000e-01), SC_(-4.99999998990644602631359130970387334e-01) }},
   {{ SC_(1.55468225479125976562500000000000000e+00), SC_(1.57079601287841796875000000000000000e+00), SC_(9.99999681144835201347336197601516526e-01) }},
   {{ SC_(6.43218040466308593750000000000000000e-01), SC_(-1.57079648971557617187500000000000000e+00), SC_(1.00000112778427119500400867526444688e+00) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(1.53492832183837890625000000000000000e+00), SC_(9.99999193385724075420581048965612379e-01) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-1.53492879867553710937500000000000000e+00), SC_(-4.99999906012040816028511878623179719e-01) }},
   {{ SC_(2.41703701019287109375000000000000000e+00), SC_(7.85398006439208984375000000000000000e-01), SC_(9.99999744073211684844850344235613694e-01) }},
   {{ SC_(4.13729667663574218750000000000000000e-01), SC_(-7.85398244857788085937500000000000000e-01), SC_(1.00000029220326861333068990765004760e+00) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-2.86940860748291015625000000000000000e+00), SC_(1.00000115496346843855869338047343752e+00) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(2.86940860748291015625000000000000000e+00), SC_(-5.00000288740700367159285628665300944e-01) }},
   {{ SC_(5.84206771850585937500000000000000000e+00), SC_(3.92699003219604492187500000000000000e-01), SC_(9.99999718511611968073942478236633037e-01) }},
   {{ SC_(1.71172261238098144531250000000000000e-01), SC_(-3.92699122428894042968750000000000000e-01), SC_(1.00000018514288075767581073144157080e+00) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-7.41562604904174804687500000000000000e-01), SC_(1.00000035593980151753451997349254047e+00) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(7.41562366485595703125000000000000000e-01), SC_(-4.99999977558605707631440938998851287e-01) }},
   {{ SC_(3.41297454833984375000000000000000000e+01), SC_(1.96349501609802246093750000000000000e-01), SC_(9.99999606394154395348433394217243228e-01) }},
   {{ SC_(2.92999446392059326171875000000000000e-02), SC_(-1.96349561214447021484375000000000000e-01), SC_(1.00000016340577183339314320597055156e+00) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-4.25803065299987792968750000000000000e-01), SC_(1.00000037389115195722892520740210286e+00) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(4.25802946090698242187500000000000000e-01), SC_(-4.99999996444819640260046115382869487e-01) }},
   {{ SC_(1.16483984375000000000000000000000000e+03), SC_(9.81747508049011230468750000000000000e-02), SC_(9.99999659826839044498368067204063400e-01) }},
   {{ SC_(8.58486862853169441223144531250000000e-04), SC_(-9.81747806072235107421875000000000000e-02), SC_(1.00000013893485547030650032062336037e+00) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-2.98640847206115722656250000000000000e-01), SC_(1.00000016478922475200934867011011981e+00) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(2.98640847206115722656250000000000000e-01), SC_(-5.00000041197302793566542554717739597e-01) }},
   {{ SC_(1.35685250000000000000000000000000000e+06), SC_(4.90873754024505615234375000000000000e-02), SC_(9.99999706019030538907266123103557337e-01) }},
   {{ SC_(7.36999481887323781847953796386718750e-07), SC_(-4.90873903036117553710937500000000000e-02), SC_(1.00000016714902026241378444491765626e+00) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-2.29964196681976318359375000000000000e-01), SC_(1.00000036827846317607338158056204997e+00) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(2.29964137077331542968750000000000000e-01), SC_(-5.00000002240836038221364863447115811e-01) }},
   {{ SC_(1.84104937062400000000000000000000000e+12), SC_(2.45436877012252807617187500000000000e-02), SC_(9.99999723719548086861268394575319238e-01) }},
   {{ SC_(5.43168374861346947568563336972147226e-13), SC_(-2.45436951518058776855468750000000000e-02), SC_(1.00000015462710356742671968128605329e+00) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-1.86968207359313964843750000000000000e-01), SC_(1.00000032527022035334879508735689469e+00) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(1.86968147754669189453125000000000000e-01), SC_(-4.99999970831380613852760670018738755e-01) }},
   {{ SC_(3.38946240217862335627264000000000000e+24), SC_(1.22718438506126403808593750000000000e-02), SC_(9.99999720946929072275671625452682012e-01) }},
   {{ SC_(2.95032006400395362694472954094348843e-25), SC_(-1.22718475759029388427734375000000000e-02), SC_(1.00000014439882435364969952973912317e+00) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-1.57517433166503906250000000000000000e-01), SC_(1.00000011027686304155789300997892503e+00) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(1.57517433166503906250000000000000000e-01), SC_(-5.00000027569214240266241783890789012e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-1.36082172393798828125000000000000000e-01), SC_(1.00000056807622797041425207806617117e+00) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(1.36082112789154052734375000000000000e-01), SC_(-4.99999990218078242037689088480772228e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-1.19781941175460815429687500000000000e-01), SC_(1.00000004721401158257455467814344307e+00) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(1.19781941175460815429687500000000000e-01), SC_(-5.00000011803502616998284032582835749e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-1.06968998908996582031250000000000000e-01), SC_(1.00000018183761271130575465508795061e+00) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(1.06968969106674194335937500000000000e-01), SC_(-4.99999948901523520309986755860218279e-01) }},
   {{ SC_(1.00034761428833007812500000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(7.48990433190207892894295543747657382e-01) }},
   {{ SC_(9.99652147293090820312500000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(7.50001925433222772488662250234981992e-01) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(7.57973194122314453125000000000000000e-02), SC_(7.49999891354036094830156558161111832e-01) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-7.57973492145538330078125000000000000e-02), SC_(-4.28571518827852820966001833309653323e-01) }},
   {{ SC_(1.00069570541381835937500000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(7.49490915972867540678010770747496417e-01) }},
   {{ SC_(9.99304294586181640625000000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(7.50172354062326159338293666283795084e-01) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(8.36507380008697509765625000000000000e-02), SC_(7.49999791201918404166269609961547044e-01) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-8.36507678031921386718750000000000000e-02), SC_(-4.28571474320896708760432987155912399e-01) }},
   {{ SC_(1.00139236450195312500000000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(7.49820904979166998257766670457740758e-01) }},
   {{ SC_(9.98609304428100585937500000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(7.50009384637292293068397358595810803e-01) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(9.33196842670440673828125000000000000e-02), SC_(7.49999925129224751800702279480006530e-01) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-9.33197140693664550781250000000000000e-02), SC_(-4.28571506248036007527072171477597174e-01) }},
   {{ SC_(1.00278711318969726562500000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(7.49977215614989567797578209894021635e-01) }},
   {{ SC_(9.97220516204833984375000000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(7.50018800415868841191906448518035661e-01) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(1.05515956878662109375000000000000000e-01), SC_(7.49999979591273026252651812151735878e-01) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-1.05515956878662109375000000000000000e-01), SC_(-4.28571421907354379834588757987205646e-01) }},
   {{ SC_(1.00558185577392578125000000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(7.49952966726046521708598819346742257e-01) }},
   {{ SC_(9.94448661804199218750000000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(7.50035808160932480209810655773659738e-01) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(1.21379435062408447265625000000000000e-01), SC_(7.49999861064427354034780324182335720e-01) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-1.21379464864730834960937500000000000e-01), SC_(-4.28571461720469258888386741560283068e-01) }},
   {{ SC_(1.01119518280029296875000000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(7.49980293342455558899500192996098214e-01) }},
   {{ SC_(9.88928556442260742187500000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(7.49998851258949810240673770809631447e-01) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(1.42856836318969726562500000000000000e-01), SC_(7.49999871760596303955755552667444769e-01) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-1.42856895923614501953125000000000000e-01), SC_(-4.28571520120398526796501136798124362e-01) }},
   {{ SC_(1.02251577377319335937500000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(7.49983564709347756664886744524421658e-01) }},
   {{ SC_(9.77979660034179687500000000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(7.50000187520576914890296150409718173e-01) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(1.73568844795227050781250000000000000e-01), SC_(7.49999803082415730151609396289034783e-01) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-1.73568904399871826171875000000000000e-01), SC_(-4.28571474086421342639218539702045052e-01) }},
   {{ SC_(1.04553890228271484375000000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(7.49991865821321083153808948491205677e-01) }},
   {{ SC_(9.56444025039672851562500000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(7.50004565340924797254544422437398189e-01) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(2.21102476119995117187500000000000000e-01), SC_(7.49999818005098704868384609537505532e-01) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-2.21102535724639892578125000000000000e-01), SC_(-4.28571455350683592357887635812046483e-01) }},
   {{ SC_(1.09315204620361328125000000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(7.49996392345841429819958602263611017e-01) }},
   {{ SC_(9.14785385131835937500000000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(7.50002015954529608989749063000469643e-01) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(3.04490327835083007812500000000000000e-01), SC_(7.49999897948981841463612352274617750e-01) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-3.04490327835083007812500000000000000e-01), SC_(-4.28571395248645188692787332023657091e-01) }},
   {{ SC_(1.19498205184936523437500000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(7.49999409178691769183259018096899527e-01) }},
   {{ SC_(8.36832523345947265625000000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(7.50000554213851396696474918355830595e-01) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(4.88862752914428710937500000000000000e-01), SC_(7.49999855987841255956923214454929794e-01) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-4.88862752914428710937500000000000000e-01), SC_(-4.28571381547046336265150842565196333e-01) }},
   {{ SC_(1.42798233032226562500000000000000000e+00), SC_(1.57079601287841796875000000000000000e+00), SC_(7.49999844387196099675681102344044157e-01) }},
   {{ SC_(7.00288772583007812500000000000000000e-01), SC_(-1.57079648971557617187500000000000000e+00), SC_(7.50000159896545786823291371381743329e-01) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(1.23923206329345703125000000000000000e+00), SC_(7.49999531058112770153927321752466430e-01) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-1.23923206329345703125000000000000000e+00), SC_(-4.28571275447505994862618583290192163e-01) }},
   {{ SC_(2.03913307189941406250000000000000000e+00), SC_(7.85398006439208984375000000000000000e-01), SC_(7.49999531761085949138483180573307934e-01) }},
   {{ SC_(4.90404367446899414062500000000000000e-01), SC_(-7.85398244857788085937500000000000000e-01), SC_(7.50000153054966400316719535345516157e-01) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-2.31663131713867187500000000000000000e+00), SC_(7.50000881217289971899852509285091777e-01) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(2.31663036346435546875000000000000000e+00), SC_(-4.28571584673455212455878829047628282e-01) }},
   {{ SC_(4.15806388854980468750000000000000000e+00), SC_(3.92699003219604492187500000000000000e-01), SC_(7.49999565416958565292754664032106076e-01) }},
   {{ SC_(2.40496456623077392578125000000000000e-01), SC_(-3.92699122428894042968750000000000000e-01), SC_(7.50000115872671083348277800761957520e-01) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-5.98704338073730468750000000000000000e-01), SC_(7.50000446086748711486045377704192696e-01) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(5.98704099655151367187500000000000000e-01), SC_(-4.28571446888004598485109492081868426e-01) }},
   {{ SC_(1.72895050048828125000000000000000000e+01), SC_(1.96349501609802246093750000000000000e-01), SC_(7.49999758266739987187670354244683543e-01) }},
   {{ SC_(5.78385442495346069335937500000000000e-02), SC_(-1.96349561214447021484375000000000000e-01), SC_(7.50000124182303123550136258147196833e-01) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-3.43774199485778808593750000000000000e-01), SC_(7.50000260963946447019304982238990800e-01) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(3.43774080276489257812500000000000000e-01), SC_(-4.28571402895042163342135457640967313e-01) }},
   {{ SC_(2.98927001953125000000000000000000000e+02), SC_(9.81747508049011230468750000000000000e-02), SC_(7.49999768979497270525432775790319285e-01) }},
   {{ SC_(3.34529764950275421142578125000000000e-03), SC_(-9.81747806072235107421875000000000000e-02), SC_(7.50000101143494670543756392398942506e-01) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-2.41109192371368408203125000000000000e-01), SC_(7.50000256349003086859391660306000680e-01) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(2.41109132766723632812500000000000000e-01), SC_(-4.28571433224218734502629942526763978e-01) }},
   {{ SC_(8.93573750000000000000000000000000000e+04), SC_(4.90873754024505615234375000000000000e-02), SC_(7.49999790612857642280192083214594589e-01) }},
   {{ SC_(1.11910158011596649885177612304687500e-05), SC_(-4.90873903036117553710937500000000000e-02), SC_(7.50000105462116379686192729112304254e-01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-1.85662686824798583984375000000000000e-01), SC_(7.50000053059539994872949284009950358e-01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(1.85662686824798583984375000000000000e-01), SC_(-4.28571445896992126080552702338791617e-01) }},
   {{ SC_(7.98474240000000000000000000000000000e+09), SC_(2.45436877012252807617187500000000000e-02), SC_(7.49999801011422002916695256129226541e-01) }},
   {{ SC_(1.25238819315143246058141812682151794e-10), SC_(-2.45436951518058776855468750000000000e-02), SC_(7.50000110725353810397871927286024641e-01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-1.50949716567993164062500000000000000e-01), SC_(7.50000321183314243747848407026046019e-01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(1.50949656963348388671875000000000000e-01), SC_(-4.28571407177697634089168956146936243e-01) }},
   {{ SC_(6.37561229185447362560000000000000000e+19), SC_(1.22718438506126403808593750000000000e-02), SC_(7.49999804960618080293961938564104106e-01) }},
   {{ SC_(1.56847661306832302318780940353359910e-20), SC_(-1.22718475759029388427734375000000000e-02), SC_(7.50000104882617209136911740927013856e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-1.27172470092773437500000000000000000e-01), SC_(7.50000040292227857466053860318034217e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(1.27172470092773437500000000000000000e-01), SC_(-4.28571441728074099517575447963632060e-01) }},
   {{ SC_(2.46011958396864884971369965642377676e-40), SC_(-6.13592378795146942138671875000000000e-03), SC_(7.50000101835016107258385635252906206e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-1.09866589307785034179687500000000000e-01), SC_(7.50000201830679236880015034725453181e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(1.09866559505462646484375000000000000e-01), SC_(-4.28571407731914803202608675862238128e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-9.67065393924713134765625000000000000e-02), SC_(7.50000029412798789871607828770044684e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(9.67065393924713134765625000000000000e-02), SC_(-4.28571438175607606700892471061571165e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-8.63619446754455566406250000000000000e-02), SC_(7.50000093288327647668525281040774471e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(8.63619148731231689453125000000000000e-02), SC_(-4.28571348681059797056426732146320381e-01) }},
   {{ SC_(9.99138355255126953125000000000000000e-01), SC_(1.60849511718750000000000000000000000e+03), SC_(-7.50063603364594569324239987475151444e-01) }},
   {{ SC_(1.00086212158203125000000000000000000e+00), SC_(-1.60849560546875000000000000000000000e+03), SC_(-7.49956745809549065141886329708290547e-01) }},
   {{ SC_(6.21698796749114990234375000000000000e-04), SC_(1.87767028808593750000000000000000000e-01), SC_(-7.49999977059143314995766214358250595e-01) }},
   {{ SC_(6.21698796749114990234375000000000000e-04), SC_(-1.87767088413238525390625000000000000e-01), SC_(3.00000139320399500899843012994017344e+00) }},
   {{ SC_(9.98277664184570312500000000000000000e-01), SC_(8.04247558593750000000000000000000000e+02), SC_(-7.50021064439664209601313906589440403e-01) }},
   {{ SC_(1.00172519683837890625000000000000000e+00), SC_(-8.04247802734375000000000000000000000e+02), SC_(-7.49998984285354380492272996263032978e-01) }},
   {{ SC_(1.24339759349822998046875000000000000e-03), SC_(2.07221746444702148437500000000000000e-01), SC_(-7.49999996497088768198781022013385616e-01) }},
   {{ SC_(1.24339759349822998046875000000000000e-03), SC_(-2.07221806049346923828125000000000000e-01), SC_(3.00000153895199333395442541251994573e+00) }},
   {{ SC_(9.96558427810668945312500000000000000e-01), SC_(4.02123779296875000000000000000000000e+02), SC_(-7.50007648331246570121229885522620782e-01) }},
   {{ SC_(1.00345325469970703125000000000000000e+00), SC_(-4.02123901367187500000000000000000000e+02), SC_(-7.49987434525831418752179922069884583e-01) }},
   {{ SC_(2.48679518699645996093750000000000000e-03), SC_(2.31173872947692871093750000000000000e-01), SC_(-7.49999995524705524480110132814692344e-01) }},
   {{ SC_(2.48679518699645996093750000000000000e-03), SC_(-2.31173932552337646484375000000000000e-01), SC_(3.00000135813463030492956958848319854e+00) }},
   {{ SC_(9.93128776550292968750000000000000000e-01), SC_(2.01061889648437500000000000000000000e+02), SC_(-7.50003776009097554462438103637506653e-01) }},
   {{ SC_(1.00691843032836914062500000000000000e+00), SC_(-2.01061950683593750000000000000000000e+02), SC_(-7.49987232884963050035853535179616391e-01) }},
   {{ SC_(4.97359037399291992187500000000000000e-03), SC_(2.61386752128601074218750000000000000e-01), SC_(-7.49999972853016149757531924104933268e-01) }},
   {{ SC_(4.97359037399291992187500000000000000e-03), SC_(-2.61386871337890625000000000000000000e-01), SC_(3.00000209460872001947815496790671983e+00) }},
   {{ SC_(9.86304759979248046875000000000000000e-01), SC_(1.00530944824218750000000000000000000e+02), SC_(-7.50003950123819535819139601016989213e-01) }},
   {{ SC_(1.01388502120971679687500000000000000e+00), SC_(-1.00530975341796875000000000000000000e+02), SC_(-7.49994567460779554130661290356373906e-01) }},
   {{ SC_(9.94718074798583984375000000000000000e-03), SC_(3.00684213638305664062500000000000000e-01), SC_(-7.50000003908220591572549442193165164e-01) }},
   {{ SC_(9.94718074798583984375000000000000000e-03), SC_(-3.00684332847595214843750000000000000e-01), SC_(3.00000226097372677691561017841901352e+00) }},
   {{ SC_(9.72797393798828125000000000000000000e-01), SC_(5.02654724121093750000000000000000000e+01), SC_(-7.49999890861593716097023502626504085e-01) }},
   {{ SC_(1.02796316146850585937500000000000000e+00), SC_(-5.02654876708984375000000000000000000e+01), SC_(-7.49998543363869000298449257145169615e-01) }},
   {{ SC_(1.98943614959716796875000000000000000e-02), SC_(3.53888511657714843750000000000000000e-01), SC_(-7.49999951115688226890596535593317817e-01) }},
   {{ SC_(1.98943614959716796875000000000000000e-02), SC_(-3.53888630867004394531250000000000000e-01), SC_(3.00000108577446149135031084467731681e+00) }},
   {{ SC_(9.46334600448608398437500000000000000e-01), SC_(2.51327362060546875000000000000000000e+01), SC_(-7.50001012490533220629588714355955633e-01) }},
   {{ SC_(1.05670833587646484375000000000000000e+00), SC_(-2.51327438354492187500000000000000000e+01), SC_(-7.49998986581615590243172259854227458e-01) }},
   {{ SC_(3.97887229919433593750000000000000000e-02), SC_(4.29969191551208496093750000000000000e-01), SC_(-7.50000039778269142860393178588924573e-01) }},
   {{ SC_(3.97887229919433593750000000000000000e-02), SC_(-4.29969191551208496093750000000000000e-01), SC_(3.00000063645240755366694802237070284e+00) }},
   {{ SC_(8.95549297332763671875000000000000000e-01), SC_(1.25663681030273437500000000000000000e+01), SC_(-7.50000586877686545339072109354186949e-01) }},
   {{ SC_(1.11663293838500976562500000000000000e+00), SC_(-1.25663719177246093750000000000000000e+01), SC_(-7.50000199953015443580883016180316141e-01) }},
   {{ SC_(7.95774459838867187500000000000000000e-02), SC_(5.47720670700073242187500000000000000e-01), SC_(-7.50000028232102479575700324107093570e-01) }},
   {{ SC_(7.95774459838867187500000000000000000e-02), SC_(-5.47720670700073242187500000000000000e-01), SC_(3.00000045171369068452003251662923740e+00) }},
   {{ SC_(8.02008867263793945312500000000000000e-01), SC_(6.28318405151367187500000000000000000e+00), SC_(-7.49999953649607210407072057784035908e-01) }},
   {{ SC_(1.24686861038208007812500000000000000e+00), SC_(-6.28318595886230468750000000000000000e+00), SC_(-7.49999559090712224391586079751226241e-01) }},
   {{ SC_(1.59154891967773437500000000000000000e-01), SC_(7.54291057586669921875000000000000000e-01), SC_(-7.50000029327866299498362617128155633e-01) }},
   {{ SC_(1.59154891967773437500000000000000000e-01), SC_(-7.54291296005249023437500000000000000e-01), SC_(3.00000222198296675493855614405435594e+00) }},
   {{ SC_(6.43218040466308593750000000000000000e-01), SC_(3.14159202575683593750000000000000000e+00), SC_(-7.50000176738598580177787007553467878e-01) }},
   {{ SC_(1.55468225479125976562500000000000000e+00), SC_(-3.14159297943115234375000000000000000e+00), SC_(-7.50000025493450548399330626900686191e-01) }},
   {{ SC_(3.18309783935546875000000000000000000e-01), SC_(1.21102285385131835937500000000000000e+00), SC_(-7.50000020284496935730442841917690385e-01) }},
   {{ SC_(3.18309783935546875000000000000000000e-01), SC_(-1.21102333068847656250000000000000000e+00), SC_(3.00000250795234576376228230933214845e+00) }},
   {{ SC_(4.13729667663574218750000000000000000e-01), SC_(1.57079601287841796875000000000000000e+00), SC_(-7.49999967843545909953424200335577364e-01) }},
   {{ SC_(2.41703701019287109375000000000000000e+00), SC_(-1.57079648971557617187500000000000000e+00), SC_(-7.50000041225549606343337396433326578e-01) }},
   {{ SC_(6.36619567871093750000000000000000000e-01), SC_(3.06985664367675781250000000000000000e+00), SC_(-7.50000198247204585146031331039244494e-01) }},
   {{ SC_(6.36619567871093750000000000000000000e-01), SC_(-3.06985759735107421875000000000000000e+00), SC_(3.00000489461206211386562413390358455e+00) }},
   {{ SC_(1.71172261238098144531250000000000000e-01), SC_(7.85398006439208984375000000000000000e-01), SC_(-7.49999941078455389589559683648001954e-01) }},
   {{ SC_(5.84206771850585937500000000000000000e+00), SC_(-7.85398244857788085937500000000000000e-01), SC_(-7.50000034835147850797219429457258949e-01) }},
   {{ SC_(1.27323913574218750000000000000000000e+00), SC_(-5.73881721496582031250000000000000000e+00), SC_(-7.49999541162089661123864428861080148e-01) }},
   {{ SC_(1.27323913574218750000000000000000000e+00), SC_(5.73881721496582031250000000000000000e+00), SC_(2.99999265860690861584193873782710680e+00) }},
   {{ SC_(2.92999446392059326171875000000000000e-02), SC_(3.92699003219604492187500000000000000e-01), SC_(-7.49999935644178941850532202603761507e-01) }},
   {{ SC_(3.41297454833984375000000000000000000e+01), SC_(-3.92699122428894042968750000000000000e-01), SC_(-7.50000006805772552629587931784958607e-01) }},
   {{ SC_(2.54647827148437500000000000000000000e+00), SC_(-1.48312520980834960937500000000000000e+00), SC_(-7.49999895782708247893858772608738535e-01) }},
   {{ SC_(2.54647827148437500000000000000000000e+00), SC_(1.48312473297119140625000000000000000e+00), SC_(2.99999654970478145498619691714758166e+00) }},
   {{ SC_(8.58486862853169441223144531250000000e-04), SC_(1.96349501609802246093750000000000000e-01), SC_(-7.49999929526450520911605182589817990e-01) }},
   {{ SC_(1.16483984375000000000000000000000000e+03), SC_(-1.96349561214447021484375000000000000e-01), SC_(-7.50000020163949499932164528813848474e-01) }},
   {{ SC_(5.09295654296875000000000000000000000e+00), SC_(-8.51606130599975585937500000000000000e-01), SC_(-7.49999982536636828659139236547163603e-01) }},
   {{ SC_(5.09295654296875000000000000000000000e+00), SC_(8.51605892181396484375000000000000000e-01), SC_(2.99999816813976182274150963051953359e+00) }},
   {{ SC_(7.36999481887323781847953796386718750e-07), SC_(9.81747508049011230468750000000000000e-02), SC_(-7.49999936579990926840871040782204494e-01) }},
   {{ SC_(1.35685250000000000000000000000000000e+06), SC_(-9.81747806072235107421875000000000000e-02), SC_(-7.50000031712001511785191931291964809e-01) }},
   {{ SC_(1.01859130859375000000000000000000000e+01), SC_(-5.97281694412231445312500000000000000e-01), SC_(-7.49999963391231171515795261382914666e-01) }},
   {{ SC_(1.01859130859375000000000000000000000e+01), SC_(5.97281694412231445312500000000000000e-01), SC_(2.99999941425978451716529281260817663e+00) }},
   {{ SC_(5.43168374861346947568563336972147226e-13), SC_(4.90873754024505615234375000000000000e-02), SC_(-7.49999933449512141483382388703480561e-01) }},
   {{ SC_(1.84104937062400000000000000000000000e+12), SC_(-4.90873903036117553710937500000000000e-02), SC_(-7.50000036137132272471540336326530085e-01) }},
   {{ SC_(2.03718261718750000000000000000000000e+01), SC_(-4.59928393363952636718750000000000000e-01), SC_(-7.50000032156131593979966034385403496e-01) }},
   {{ SC_(2.03718261718750000000000000000000000e+01), SC_(4.59928274154663085937500000000000000e-01), SC_(2.99999907723815310952233084052474432e+00) }},
   {{ SC_(2.95032006400395362694472954094348843e-25), SC_(2.45436877012252807617187500000000000e-02), SC_(-7.49999930892442611656840987962577599e-01) }},
   {{ SC_(3.38946240217862335627264000000000000e+24), SC_(-2.45436951518058776855468750000000000e-02), SC_(-7.50000035443977311408851308985243778e-01) }},
   {{ SC_(4.07436523437500000000000000000000000e+01), SC_(-3.73936414718627929687500000000000000e-01), SC_(-7.50000032605986343166303141070589317e-01) }},
   {{ SC_(4.07436523437500000000000000000000000e+01), SC_(3.73936295509338378906250000000000000e-01), SC_(2.99999875391758588808316136330946531e+00) }},
   {{ SC_(8.14873046875000000000000000000000000e+01), SC_(-3.15034866333007812500000000000000000e-01), SC_(-7.49999986530580282991366810547938984e-01) }},
   {{ SC_(8.14873046875000000000000000000000000e+01), SC_(3.15034866333007812500000000000000000e-01), SC_(2.99999978448929613907836421159283021e+00) }},
   {{ SC_(1.62974609375000000000000000000000000e+02), SC_(-2.72164344787597656250000000000000000e-01), SC_(-7.50000106564992275010155437401550339e-01) }},
   {{ SC_(1.62974609375000000000000000000000000e+02), SC_(2.72164225578308105468750000000000000e-01), SC_(2.99999927622521797360781888825246635e+00) }},
   {{ SC_(3.25949218750000000000000000000000000e+02), SC_(-2.39563882350921630859375000000000000e-01), SC_(-7.49999980596243305955289547305373910e-01) }},
   {{ SC_(3.25949218750000000000000000000000000e+02), SC_(2.39563882350921630859375000000000000e-01), SC_(2.99999968953991699165228838449949453e+00) }},
   {{ SC_(6.51898437500000000000000000000000000e+02), SC_(-2.13937997817993164062500000000000000e-01), SC_(-7.50000017590347872383528213341515821e-01) }},
   {{ SC_(6.51898437500000000000000000000000000e+02), SC_(2.13937938213348388671875000000000000e-01), SC_(2.99999873651989996114735168094323931e+00) }},
   {{ SC_(1.00025177001953125000000000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(4.99182374555405813321351639510539638e-01) }},
   {{ SC_(9.99747753143310546875000000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(5.00486129816804859070175901195828710e-01) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(5.49183338880538940429687500000000000e-02), SC_(4.99999900489036637611001244317785589e-01) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-5.49183487892150878906250000000000000e-02), SC_(-3.33333362450291330590144550206293306e-01) }},
   {{ SC_(1.00050401687622070312500000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(4.99680707506217610217969115916441438e-01) }},
   {{ SC_(9.99495983123779296875000000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(4.99987316378372518594960039486335487e-01) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(6.06084764003753662109375000000000000e-02), SC_(4.99999955495672730362842092491414956e-01) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-6.06084913015365600585937500000000000e-02), SC_(-3.33333380011886745816379049072774105e-01) }},
   {{ SC_(1.00100851058959960937500000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(4.99814941819009255400128718780503754e-01) }},
   {{ SC_(9.98992204666137695312500000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(4.99996744234326675868801836700763286e-01) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(6.76140189170837402343750000000000000e-02), SC_(4.99999898880769447616987408278741341e-01) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-6.76140487194061279296875000000000000e-02), SC_(-3.33333407536362982927100086753649150e-01) }},
   {{ SC_(1.00201845169067382812500000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(4.99939364358230355830072343462037506e-01) }},
   {{ SC_(9.97985363006591796875000000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(5.00015473903887407073364783792795970e-01) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(7.64507353305816650390625000000000000e-02), SC_(4.99999982027520004554081255727729629e-01) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-7.64507353305816650390625000000000000e-02), SC_(-3.33333325345564350761801726427712251e-01) }},
   {{ SC_(1.00404119491577148437500000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(4.99972012665561313800202846125401042e-01) }},
   {{ SC_(9.95974779129028320312500000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(5.00016328806781721659486444068711611e-01) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(8.79444777965545654296875000000000000e-02), SC_(4.99999820747248922010493504624281323e-01) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-8.79445075988769531250000000000000000e-02), SC_(-3.33333345267160321564301108888835448e-01) }},
   {{ SC_(1.00809907913208007812500000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(4.99998791414941999147864718215769082e-01) }},
   {{ SC_(9.91965770721435546875000000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(5.00015564124837967815136266140674335e-01) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(1.03505760431289672851562500000000000e-01), SC_(4.99999868882893037142162481842712289e-01) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-1.03505790233612060546875000000000000e-01), SC_(-3.33333352889184803476920014810066947e-01) }},
   {{ SC_(1.01626348495483398437500000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(4.99988835237849822771070591532125850e-01) }},
   {{ SC_(9.83996391296386718750000000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(5.00004031546529745302143622781874383e-01) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(1.25757873058319091796875000000000000e-01), SC_(4.99999711791793358203134471581906280e-01) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-1.25757932662963867187500000000000000e-01), SC_(-3.33333333357838556399354588684941477e-01) }},
   {{ SC_(1.03279209136962890625000000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(5.00000160295293741018470656983034795e-01) }},
   {{ SC_(9.68249082565307617187500000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(5.00000440124875095130315765655830050e-01) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(1.60198032855987548828125000000000000e-01), SC_(4.99999948028412047415180683855350457e-01) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-1.60198032855987548828125000000000000e-01), SC_(-3.33333310234848998541251297013925761e-01) }},
   {{ SC_(1.06665945053100585937500000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(4.99999687893086425048269342056091188e-01) }},
   {{ SC_(9.37506198883056640625000000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(5.00001314794372877419983400220685948e-01) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(2.20615983009338378906250000000000000e-01), SC_(4.99999855188432688522642409470953626e-01) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-2.20616042613983154296875000000000000e-01), SC_(-3.33333342003298768986006408132233991e-01) }},
   {{ SC_(1.13776206970214843750000000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(4.99998388589494139451178641727466819e-01) }},
   {{ SC_(8.78917932510375976562500000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(5.00000995425024898858988076559064495e-01) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(3.54201555252075195312500000000000000e-01), SC_(4.99999890526481893541713076072193518e-01) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-3.54201555252075195312500000000000000e-01), SC_(-3.33333284678432846180897290559864549e-01) }},
   {{ SC_(1.29450321197509765625000000000000000e+00), SC_(1.57079601287841796875000000000000000e+00), SC_(4.99999634888195455402890133119316694e-01) }},
   {{ SC_(7.72496938705444335937500000000000000e-01), SC_(-1.57079648971557617187500000000000000e+00), SC_(5.00000365221257726848388742346537430e-01) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(8.97875547409057617187500000000000000e-01), SC_(4.99999671751614127125737631297360433e-01) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-8.97875785827636718750000000000000000e-01), SC_(-3.33333259222247949138443660278289564e-01) }},
   {{ SC_(1.67573881149291992187500000000000000e+00), SC_(7.85398006439208984375000000000000000e-01), SC_(4.99999807608281305618227851773228619e-01) }},
   {{ SC_(5.96751689910888671875000000000000000e-01), SC_(-7.85398244857788085937500000000000000e-01), SC_(5.00000030396466741463918620906082823e-01) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-1.67849683761596679687500000000000000e+00), SC_(5.00000652730665143783325355917925246e-01) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(1.67849636077880859375000000000000000e+00), SC_(-3.33333546644411792844156743344397873e-01) }},
   {{ SC_(2.80810070037841796875000000000000000e+00), SC_(3.92699003219604492187500000000000000e-01), SC_(4.99999836143952193563356863747838046e-01) }},
   {{ SC_(3.56112480163574218750000000000000000e-01), SC_(-3.92699122428894042968750000000000000e-01), SC_(5.00000194563297086026499377201777963e-01) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-4.33786392211914062500000000000000000e-01), SC_(5.00000263284799869610350250224157785e-01) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(4.33786273002624511718750000000000000e-01), SC_(-3.33333376064564136573339478932208166e-01) }},
   {{ SC_(7.88542938232421875000000000000000000e+00), SC_(1.96349501609802246093750000000000000e-01), SC_(4.99999830125245493725072272007500212e-01) }},
   {{ SC_(1.26816153526306152343750000000000000e-01), SC_(-1.96349561214447021484375000000000000e-01), SC_(5.00000066832955470062506115679052764e-01) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-2.49078810214996337890625000000000000e-01), SC_(5.00000125752788487744335242316870496e-01) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(2.49078750610351562500000000000000000e-01), SC_(-3.33333324538152749814584849447666135e-01) }},
   {{ SC_(6.21800079345703125000000000000000000e+01), SC_(9.81747508049011230468750000000000000e-02), SC_(4.99999857102650069475293440688303016e-01) }},
   {{ SC_(1.60823315382003784179687500000000000e-02), SC_(-9.81747806072235107421875000000000000e-02), SC_(5.00000114970143924461482586970294434e-01) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-1.74693703651428222656250000000000000e-01), SC_(5.00000096152824268308432828748210055e-01) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(1.74693644046783447265625000000000000e-01), SC_(-3.33333283839417974382609223009303783e-01) }},
   {{ SC_(3.86635449218750000000000000000000000e+03), SC_(4.90873754024505615234375000000000000e-02), SC_(4.99999878154791470099376598770490914e-01) }},
   {{ SC_(2.58641550317406654357910156250000000e-04), SC_(-4.90873903036117553710937500000000000e-02), SC_(5.00000068676876866545187846534812911e-01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-1.34520411491394042968750000000000000e-01), SC_(5.00000070803469067759869157503673133e-01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(1.34520411491394042968750000000000000e-01), SC_(-3.33333364801540322521128396564096184e-01) }},
   {{ SC_(1.49486960000000000000000000000000000e+07), SC_(2.45436877012252807617187500000000000e-02), SC_(4.99999875546058326477653460831285048e-01) }},
   {{ SC_(6.68954385218967217952013015747070313e-08), SC_(-2.45436951518058776855468750000000000e-02), SC_(5.00000075847148261811208237503234414e-01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-1.09369367361068725585937500000000000e-01), SC_(5.00000016073696146099593189075658033e-01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(1.09369367361068725585937500000000000e-01), SC_(-3.33333340477198210603165853348058949e-01) }},
   {{ SC_(2.23463524532224000000000000000000000e+14), SC_(1.22718438506126403808593750000000000e-02), SC_(4.99999876570126114592111964395626839e-01) }},
   {{ SC_(4.47500211528655683634880801946565043e-15), SC_(-1.22718475759029388427734375000000000e-02), SC_(5.00000065891529024909363738503299649e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-9.21418070793151855468750000000000000e-02), SC_(5.00000150473859182689158059698919700e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(9.21417772769927978515625000000000000e-02), SC_(-3.33333312781558577785748393534489529e-01) }},
   {{ SC_(4.99359465733996671261558702080000000e+28), SC_(6.13592192530632019042968750000000000e-03), SC_(4.99999876529030742467831225988368996e-01) }},
   {{ SC_(2.00256450243372683068268754489970275e-29), SC_(-6.13592378795146942138671875000000000e-03), SC_(5.00000065389402252280058778997367543e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-7.96029567718505859375000000000000000e-02), SC_(5.00000164455809915716133045084343500e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(7.96029269695281982421875000000000000e-02), SC_(-3.33333305224160817304613713136212618e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-7.00679421424865722656250000000000000e-02), SC_(5.00000005881715906945168966085013506e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(7.00679421424865722656250000000000000e-02), SC_(-3.33333335947429281725384170301044072e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-6.25728666782379150390625000000000000e-02), SC_(5.00000211740319917558966089005207688e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(6.25728368759155273437500000000000000e-02), SC_(-3.33333298696301337180666567977389390e-01) }},
   {{ SC_(9.99569177627563476562500000000000000e-01), SC_(1.60849511718750000000000000000000000e+03), SC_(-4.99988909617452316271782677470834311e-01) }},
   {{ SC_(1.00043106079101562500000000000000000e+00), SC_(-1.60849560546875000000000000000000000e+03), SC_(-5.00031404207091945897264717563873290e-01) }},
   {{ SC_(6.21698796749114990234375000000000000e-04), SC_(9.38835144042968750000000000000000000e-02), SC_(-4.99999977059143841278647509501659007e-01) }},
   {{ SC_(6.21698796749114990234375000000000000e-04), SC_(-9.38835442066192626953125000000000000e-02), SC_(1.00000034830096842385845628307368925e+00) }},
   {{ SC_(9.99138355255126953125000000000000000e-01), SC_(8.04247558593750000000000000000000000e+02), SC_(-5.00063607410497239488572270335688186e-01) }},
   {{ SC_(1.00086212158203125000000000000000000e+00), SC_(-8.04247802734375000000000000000000000e+02), SC_(-4.99956747680312223515503619016832432e-01) }},
   {{ SC_(1.24339759349822998046875000000000000e-03), SC_(1.03610873222351074218750000000000000e-01), SC_(-4.99999996497088780469168033928366076e-01) }},
   {{ SC_(1.24339759349822998046875000000000000e-03), SC_(-1.03610903024673461914062500000000000e-01), SC_(1.00000038473796132766388471138226099e+00) }},
   {{ SC_(9.98277664184570312500000000000000000e-01), SC_(4.02123779296875000000000000000000000e+02), SC_(-5.00021064883393521983992162894560870e-01) }},
   {{ SC_(1.00172519683837890625000000000000000e+00), SC_(-4.02123901367187500000000000000000000e+02), SC_(-4.99998984286386054637826944489702175e-01) }},
   {{ SC_(2.48679518699645996093750000000000000e-03), SC_(1.15586936473846435546875000000000000e-01), SC_(-4.99999995524705544508370596168812059e-01) }},
   {{ SC_(2.48679518699645996093750000000000000e-03), SC_(-1.15586966276168823242187500000000000e-01), SC_(1.00000033953362875546112843429578182e+00) }},
   {{ SC_(9.96558427810668945312500000000000000e-01), SC_(2.01061889648437500000000000000000000e+02), SC_(-5.00007648389744435804020669062969158e-01) }},
   {{ SC_(1.00345325469970703125000000000000000e+00), SC_(-2.01061950683593750000000000000000000e+02), SC_(-4.99987434683718592003996790674469176e-01) }},
   {{ SC_(4.97359037399291992187500000000000000e-03), SC_(1.30693376064300537109375000000000000e-01), SC_(-4.99999972853016886716224077019424415e-01) }},
   {{ SC_(4.97359037399291992187500000000000000e-03), SC_(-1.30693435668945312500000000000000000e-01), SC_(1.00000052365211145198608171116346355e+00) }},
   {{ SC_(9.93128776550292968750000000000000000e-01), SC_(1.00530944824218750000000000000000000e+02), SC_(-5.00003776023355906846792108996149823e-01) }},
   {{ SC_(1.00691843032836914062500000000000000e+00), SC_(-1.00530975341796875000000000000000000e+02), SC_(-4.99987233047958114475658494459679222e-01) }},
   {{ SC_(9.94718074798583984375000000000000000e-03), SC_(1.50342106819152832031250000000000000e-01), SC_(-5.00000003908220606846737753974648277e-01) }},
   {{ SC_(9.94718074798583984375000000000000000e-03), SC_(-1.50342166423797607421875000000000000e-01), SC_(1.00000056524335181921720858876424581e+00) }},
   {{ SC_(9.86304759979248046875000000000000000e-01), SC_(5.02654724121093750000000000000000000e+01), SC_(-5.00003950139423137281362934993553437e-01) }},
   {{ SC_(1.01388502120971679687500000000000000e+00), SC_(-5.02654876708984375000000000000000000e+01), SC_(-4.99994567490291715861262708517964317e-01) }},
   {{ SC_(1.98943614959716796875000000000000000e-02), SC_(1.76944255828857421875000000000000000e-01), SC_(-4.99999951115690616566300430857366340e-01) }},
   {{ SC_(1.98943614959716796875000000000000000e-02), SC_(-1.76944315433502197265625000000000000e-01), SC_(1.00000027144359695243099609271784179e+00) }},
   {{ SC_(9.72797393798828125000000000000000000e-01), SC_(2.51327362060546875000000000000000000e+01), SC_(-4.99999890861605627286149756644717233e-01) }},
   {{ SC_(1.02796316146850585937500000000000000e+00), SC_(-2.51327438354492187500000000000000000e+01), SC_(-4.99998543365990782935257036999726231e-01) }},
   {{ SC_(3.97887229919433593750000000000000000e-02), SC_(2.14984595775604248046875000000000000e-01), SC_(-5.00000039778270725171215063602228502e-01) }},
   {{ SC_(3.97887229919433593750000000000000000e-02), SC_(-2.14984595775604248046875000000000000e-01), SC_(1.00000015911309555917244240000737305e+00) }},
   {{ SC_(9.46334600448608398437500000000000000e-01), SC_(1.25663681030273437500000000000000000e+01), SC_(-5.00001012491558359785338540956014859e-01) }},
   {{ SC_(1.05670833587646484375000000000000000e+00), SC_(-1.25663719177246093750000000000000000e+01), SC_(-4.99998986582642604983441758576232016e-01) }},
   {{ SC_(7.95774459838867187500000000000000000e-02), SC_(2.73860335350036621093750000000000000e-01), SC_(-5.00000028232103276627355746260170185e-01) }},
   {{ SC_(7.95774459838867187500000000000000000e-02), SC_(-2.73860335350036621093750000000000000e-01), SC_(1.00000011292841948292302640140006594e+00) }},
   {{ SC_(8.95549297332763671875000000000000000e-01), SC_(6.28318405151367187500000000000000000e+00), SC_(-5.00000586878030971162308697900207856e-01) }},
   {{ SC_(1.11663293838500976562500000000000000e+00), SC_(-6.28318595886230468750000000000000000e+00), SC_(-5.00000199953055424805256731423223615e-01) }},
   {{ SC_(1.59154891967773437500000000000000000e-01), SC_(3.77145528793334960937500000000000000e-01), SC_(-5.00000029327867159622154749571830610e-01) }},
   {{ SC_(1.59154891967773437500000000000000000e-01), SC_(-3.77145648002624511718750000000000000e-01), SC_(1.00000055549566454487630699757653802e+00) }},
   {{ SC_(8.02008867263793945312500000000000000e-01), SC_(3.14159202575683593750000000000000000e+00), SC_(-4.99999953649609358765784652796372463e-01) }},
   {{ SC_(1.24686861038208007812500000000000000e+00), SC_(-3.14159297943115234375000000000000000e+00), SC_(-4.99999559090906625220206650037888020e-01) }},
   {{ SC_(3.18309783935546875000000000000000000e-01), SC_(6.05511426925659179687500000000000000e-01), SC_(-5.00000020284497347191275470127582327e-01) }},
   {{ SC_(3.18309783935546875000000000000000000e-01), SC_(-6.05511665344238281250000000000000000e-01), SC_(1.00000062698798816245624557623975458e+00) }},
   {{ SC_(6.43218040466308593750000000000000000e-01), SC_(1.57079601287841796875000000000000000e+00), SC_(-5.00000176738629816721056499514737223e-01) }},
   {{ SC_(1.55468225479125976562500000000000000e+00), SC_(-1.57079648971557617187500000000000000e+00), SC_(-5.00000025493451198315384627788806629e-01) }},
   {{ SC_(6.36619567871093750000000000000000000e-01), SC_(1.53492832183837890625000000000000000e+00), SC_(-5.00000198247243887115740168588452122e-01) }},
   {{ SC_(6.36619567871093750000000000000000000e-01), SC_(-1.53492879867553710937500000000000000e+00), SC_(1.00000122365264119701982892283864103e+00) }},
   {{ SC_(4.13729667663574218750000000000000000e-01), SC_(7.85398006439208984375000000000000000e-01), SC_(-4.99999967843546943990897343652734783e-01) }},
   {{ SC_(2.41703701019287109375000000000000000e+00), SC_(-7.85398244857788085937500000000000000e-01), SC_(-5.00000041225551305889417870954013745e-01) }},
   {{ SC_(1.27323913574218750000000000000000000e+00), SC_(-2.86940860748291015625000000000000000e+00), SC_(-4.99999541162300193158628461939480196e-01) }},
   {{ SC_(1.27323913574218750000000000000000000e+00), SC_(2.86940860748291015625000000000000000e+00), SC_(9.99998164650885027367026977674898341e-01) }},
   {{ SC_(1.71172261238098144531250000000000000e-01), SC_(3.92699003219604492187500000000000000e-01), SC_(-4.99999941078458861337569838737148995e-01) }},
   {{ SC_(5.84206771850585937500000000000000000e+00), SC_(-3.92699122428894042968750000000000000e-01), SC_(-5.00000034835149064284829760401509368e-01) }},
   {{ SC_(2.54647827148437500000000000000000000e+00), SC_(-7.41562604904174804687500000000000000e-01), SC_(-4.99999895782719109135495057960639387e-01) }},
   {{ SC_(2.54647827148437500000000000000000000e+00), SC_(7.41562366485595703125000000000000000e-01), SC_(9.99999137426009355274215037415395968e-01) }},
   {{ SC_(2.92999446392059326171875000000000000e-02), SC_(1.96349501609802246093750000000000000e-01), SC_(-4.99999935644183083521703189877876451e-01) }},
   {{ SC_(3.41297454833984375000000000000000000e+01), SC_(-1.96349561214447021484375000000000000e-01), SC_(-5.00000006805772598948128600378123508e-01) }},
   {{ SC_(5.09295654296875000000000000000000000e+00), SC_(-4.25803065299987792968750000000000000e-01), SC_(-4.99999982536637133628181839121288487e-01) }},
   {{ SC_(5.09295654296875000000000000000000000e+00), SC_(4.25802946090698242187500000000000000e-01), SC_(9.99999542034888022674430306542890706e-01) }},
   {{ SC_(8.58486862853169441223144531250000000e-04), SC_(9.81747508049011230468750000000000000e-02), SC_(-4.99999929526455487432081347481617009e-01) }},
   {{ SC_(1.16483984375000000000000000000000000e+03), SC_(-9.81747806072235107421875000000000000e-02), SC_(-5.00000020163949906517040361342409201e-01) }},
   {{ SC_(1.01859130859375000000000000000000000e+01), SC_(-2.98640847206115722656250000000000000e-01), SC_(-4.99999963391232511717652272501549424e-01) }},
   {{ SC_(1.01859130859375000000000000000000000e+01), SC_(2.98640847206115722656250000000000000e-01), SC_(9.99999853564940768484680168802021316e-01) }},
   {{ SC_(7.36999481887323781847953796386718750e-07), SC_(4.90873754024505615234375000000000000e-02), SC_(-4.99999936579994948937911717522995471e-01) }},
   {{ SC_(1.35685250000000000000000000000000000e+06), SC_(-4.90873903036117553710937500000000000e-02), SC_(-5.00000031712002517436295597177914249e-01) }},
   {{ SC_(2.03718261718750000000000000000000000e+01), SC_(-2.29964196681976318359375000000000000e-01), SC_(-5.00000032156132627996831623707824424e-01) }},
   {{ SC_(2.03718261718750000000000000000000000e+01), SC_(2.29964137077331542968750000000000000e-01), SC_(9.99999769309524972856765647882123033e-01) }},
   {{ SC_(5.43168374861346947568563336972147226e-13), SC_(2.45436877012252807617187500000000000e-02), SC_(-4.99999933449516570450227095482383746e-01) }},
   {{ SC_(1.84104937062400000000000000000000000e+12), SC_(-2.45436951518058776855468750000000000e-02), SC_(-5.00000036137133578363963596846814403e-01) }},
   {{ SC_(4.07436523437500000000000000000000000e+01), SC_(-1.86968207359313964843750000000000000e-01), SC_(-5.00000032605987406316717881954996693e-01) }},
   {{ SC_(4.07436523437500000000000000000000000e+01), SC_(1.86968147754669189453125000000000000e-01), SC_(9.99999688479372210745405788001934821e-01) }},
   {{ SC_(2.95032006400395362694472954094348843e-25), SC_(1.22718438506126403808593750000000000e-02), SC_(-4.99999930892447387510669075943525302e-01) }},
   {{ SC_(3.38946240217862335627264000000000000e+24), SC_(-1.22718475759029388427734375000000000e-02), SC_(-5.00000035443978567684468015461156607e-01) }},
   {{ SC_(8.14873046875000000000000000000000000e+01), SC_(-1.57517433166503906250000000000000000e-01), SC_(-4.99999986530580464416629436102880949e-01) }},
   {{ SC_(8.14873046875000000000000000000000000e+01), SC_(1.57517433166503906250000000000000000e-01), SC_(9.99999946122323309068579649764486282e-01) }},
   {{ SC_(1.62974609375000000000000000000000000e+02), SC_(-1.36082172393798828125000000000000000e-01), SC_(-5.00000106565003631110154335921928915e-01) }},
   {{ SC_(1.62974609375000000000000000000000000e+02), SC_(1.36082112789154052734375000000000000e-01), SC_(9.99999819056296308245978299743621163e-01) }},
   {{ SC_(3.25949218750000000000000000000000000e+02), SC_(-1.19781941175460815429687500000000000e-01), SC_(-4.99999980596243682461048777738134766e-01) }},
   {{ SC_(3.25949218750000000000000000000000000e+02), SC_(1.19781941175460815429687500000000000e-01), SC_(9.99999922384977741890152064403094009e-01) }},
   {{ SC_(6.51898437500000000000000000000000000e+02), SC_(-1.06968998908996582031250000000000000e-01), SC_(-5.00000017590348181803877370432490264e-01) }},
   {{ SC_(6.51898437500000000000000000000000000e+02), SC_(1.06968969106674194335937500000000000e-01), SC_(9.99999684129950046814723563295345618e-01) }},
   {{ SC_(1.00013875961303710937500000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(2.50043907000482649955267535044361552e-01) }},
   {{ SC_(9.99861240386962890625000000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(2.50082706582895382465407495475274674e-01) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(3.02237421274185180664062500000000000e-02), SC_(2.49999972869366658663969782096773296e-01) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-3.02237495779991149902343750000000000e-02), SC_(-2.00000026642826986176665545234904610e-01) }},
   {{ SC_(1.00027751922607421875000000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(2.50024555381490979139796813640321872e-01) }},
   {{ SC_(9.99722480773925781250000000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(2.50102069852460517253241074368869827e-01) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(3.33552509546279907226562500000000000e-02), SC_(2.49999974857778744277242686723094708e-01) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-3.33552658557891845703125000000000000e-02), SC_(-2.00000063658883320292730493318655462e-01) }},
   {{ SC_(1.00055503845214843750000000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(2.49985863777871473645058980012186297e-01) }},
   {{ SC_(9.99445199966430664062500000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(2.50020891487235970745098693825509919e-01) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(3.72106730937957763671875000000000000e-02), SC_(2.49999903505457440294611492286179876e-01) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-3.72106879949569702148437500000000000e-02), SC_(-2.00000009730439642642767591264367155e-01) }},
   {{ SC_(1.00111007690429687500000000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(2.49908527072054599217321011712078082e-01) }},
   {{ SC_(9.98890638351440429687500000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(2.50038349495278511603328295447877020e-01) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(4.20738756656646728515625000000000000e-02), SC_(2.49999991153533112953745483926375793e-01) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-4.20738756656646728515625000000000000e-02), SC_(-1.99999994338261152221288917730654841e-01) }},
   {{ SC_(1.00222206115722656250000000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(2.49993168460290250094660812671735952e-01) }},
   {{ SC_(9.97782707214355468750000000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(2.50013182015760014675080285225848423e-01) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(4.83993440866470336914062500000000000e-02), SC_(2.49999948897431998938907457022289608e-01) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-4.83993589878082275390625000000000000e-02), SC_(-2.00000022255388235180968086263688013e-01) }},
   {{ SC_(1.00444889068603515625000000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(2.49982585491801152848657797454329484e-01) }},
   {{ SC_(9.95570421218872070312500000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(2.50007476515553248293246288393207338e-01) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(5.69633394479751586914062500000000000e-02), SC_(2.49999983625474156699237969257261928e-01) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-5.69633394479751586914062500000000000e-02), SC_(-1.99999989520303323007461046430689660e-01) }},
   {{ SC_(1.00891780853271484375000000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(2.49989888334472667294436696316666439e-01) }},
   {{ SC_(9.91160631179809570312500000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(2.50002165055373566484761051143193745e-01) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(6.92095756530761718750000000000000000e-02), SC_(2.49999963983303297340823387725222189e-01) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-6.92096054553985595703125000000000000e-02), SC_(-2.00000053819544256325317380046804386e-01) }},
   {{ SC_(1.01791572570800781250000000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(2.49998859141712757799472904275761828e-01) }},
   {{ SC_(9.82399463653564453125000000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(2.50001096118577797551905624032941714e-01) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(8.81633162498474121093750000000000000e-02), SC_(2.49999902735425645398059835114778095e-01) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-8.81633460521697998046875000000000000e-02), SC_(-1.99999998094985687639775714766918737e-01) }},
   {{ SC_(1.03615236282348632812500000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(2.49998390548596598375338550106535734e-01) }},
   {{ SC_(9.65108633041381835937500000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(2.50001691371295244105233810478277598e-01) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(1.21413737535476684570312500000000000e-01), SC_(2.49999935231629786998778060359715322e-01) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-1.21413767337799072265625000000000000e-01), SC_(-2.00000002366641095252890213368157413e-01) }},
   {{ SC_(1.07361173629760742187500000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(2.49998453874613102962134384897509164e-01) }},
   {{ SC_(9.31434869766235351562500000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(2.50000864198249599931428559991533814e-01) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(1.94931149482727050781250000000000000e-01), SC_(2.49999902781928857699207470493741335e-01) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-1.94931209087371826171875000000000000e-01), SC_(-1.99999992365397051439010488673913978e-01) }},
   {{ SC_(1.15264272689819335937500000000000000e+00), SC_(1.57079601287841796875000000000000000e+00), SC_(2.49999419031192652990624733608118202e-01) }},
   {{ SC_(8.67571115493774414062500000000000000e-01), SC_(-1.57079648971557617187500000000000000e+00), SC_(2.50000414096807255416551374457742565e-01) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(4.94136571884155273437500000000000000e-01), SC_(2.49999849810940474075553587731429176e-01) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-4.94136691093444824218750000000000000e-01), SC_(-1.99999946945258087658141961261003950e-01) }},
   {{ SC_(1.32858562469482421875000000000000000e+00), SC_(7.85398006439208984375000000000000000e-01), SC_(2.49999691570265347799070895135048410e-01) }},
   {{ SC_(7.52679824829101562500000000000000000e-01), SC_(-7.85398244857788085937500000000000000e-01), SC_(2.50000173590118476368582508114794462e-01) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-9.23743247985839843750000000000000000e-01), SC_(2.50000232845071509742137037330371036e-01) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(9.23743247985839843750000000000000000e-01), SC_(-2.00000149020818007224547437916641320e-01) }},
   {{ SC_(1.76514053344726562500000000000000000e+00), SC_(3.92699003219604492187500000000000000e-01), SC_(2.49999906064064446272431536108437960e-01) }},
   {{ SC_(5.66526889801025390625000000000000000e-01), SC_(-3.92699122428894042968750000000000000e-01), SC_(2.50000198634109270907252849240329701e-01) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-2.38729834556579589843750000000000000e-01), SC_(2.50000069186713985081016271885643476e-01) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(2.38729774951934814453125000000000000e-01), SC_(-1.99999999708961225051570816195138928e-01) }},
   {{ SC_(3.11572170257568359375000000000000000e+00), SC_(1.96349501609802246093750000000000000e-01), SC_(2.49999953309149428352228017907407100e-01) }},
   {{ SC_(3.20952892303466796875000000000000000e-01), SC_(-1.96349561214447021484375000000000000e-01), SC_(2.50000064475932230453978072407562269e-01) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-1.37077987194061279296875000000000000e-01), SC_(2.50000111010834192972997720238016066e-01) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(1.37077927589416503906250000000000000e-01), SC_(-1.99999993424563022290916589499916997e-01) }},
   {{ SC_(9.70771789550781250000000000000000000e+00), SC_(9.81747508049011230468750000000000000e-02), SC_(2.49999904862623935852820875974931006e-01) }},
   {{ SC_(1.03010773658752441406250000000000000e-01), SC_(-9.81747806072235107421875000000000000e-02), SC_(2.50000047105586645164303256463396499e-01) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-9.61408913135528564453125000000000000e-02), SC_(2.50000068891044606236072544622719740e-01) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(9.61408615112304687500000000000000000e-02), SC_(-1.99999988753166824529850152936261311e-01) }},
   {{ SC_(9.42398376464843750000000000000000000e+01), SC_(4.90873754024505615234375000000000000e-02), SC_(2.49999938008465285690437017661829916e-01) }},
   {{ SC_(1.06112211942672729492187500000000000e-02), SC_(-4.90873903036117553710937500000000000e-02), SC_(2.50000037249381249401382072907835488e-01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-7.40319192409515380859375000000000000e-02), SC_(2.50000011973336647915650690685212199e-01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(7.40319192409515380859375000000000000e-02), SC_(-2.00000007662935381265292417147963806e-01) }},
   {{ SC_(8.88114843750000000000000000000000000e+03), SC_(2.45436877012252807617187500000000000e-02), SC_(2.49999942975516131476089936201609606e-01) }},
   {{ SC_(1.12598034320399165153503417968750000e-04), SC_(-2.45436951518058776855468750000000000e-02), SC_(2.50000032048813229390486992613425821e-01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-6.01903200149536132812500000000000000e-02), SC_(2.50000071077698449569055596377137598e-01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(6.01903051137924194335937500000000000e-02), SC_(-2.00000001295258908900819026205911589e-01) }},
   {{ SC_(7.88747840000000000000000000000000000e+07), SC_(1.22718438506126403808593750000000000e-02), SC_(2.49999940336594378785378245542436643e-01) }},
   {{ SC_(1.26783170628641528310254216194152832e-08), SC_(-1.22718475759029388427734375000000000e-02), SC_(2.50000032375436816391006501940139683e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-5.07092922925949096679687500000000000e-02), SC_(2.50000050360781664802309507924303330e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(5.07092773914337158203125000000000000e-02), SC_(-1.99999979773474261188309159150735343e-01) }},
   {{ SC_(6.22123435845222400000000000000000000e+15), SC_(6.13592192530632019042968750000000000e-03), SC_(2.49999943797729154008255538105188260e-01) }},
   {{ SC_(1.60739801274113270138088616079130588e-16), SC_(-6.13592378795146942138671875000000000e-03), SC_(2.50000028666564162932929867280989722e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-4.38086688518524169921875000000000000e-02), SC_(2.50000078294340828277223775530635470e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(4.38086539506912231445312500000000000e-02), SC_(-1.99999989387993096243872686618792144e-01) }},
   {{ SC_(3.87037601149623530282182246400000000e+31), SC_(3.06796096265316009521484375000000000e-03), SC_(2.49999944112043310919840306705371772e-01) }},
   {{ SC_(2.58372717915258136421521915892219822e-32), SC_(-3.06796189397573471069335937500000000e-03), SC_(2.50000030436129324239963853484306565e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-3.85611802339553833007812500000000000e-02), SC_(2.50000068158668990602602561324336496e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(3.85611653327941894531250000000000000e-02), SC_(-1.99999974638204873641867143785170562e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-3.44363301992416381835937500000000000e-02), SC_(2.50000070350597375172601449793548598e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(3.44363152980804443359375000000000000e-02), SC_(-1.99999967778080420281994061217247845e-01) }},
   {{ SC_(9.99821186065673828125000000000000000e-01), SC_(1.60849511718750000000000000000000000e+03), SC_(-2.49973739201204574493284631554542411e-01) }},
   {{ SC_(1.00017881393432617187500000000000000e+00), SC_(-1.60849560546875000000000000000000000e+03), SC_(-2.49935229313843362185622276600710822e-01) }},
   {{ SC_(6.21698796749114990234375000000000000e-04), SC_(3.89651805162429809570312500000000000e-02), SC_(-2.49999993882066634229983145287042768e-01) }},
   {{ SC_(6.21698796749114990234375000000000000e-04), SC_(-3.89651954174041748046875000000000000e-02), SC_(3.33333469145134519327408878719906348e-01) }},
   {{ SC_(9.99642372131347656250000000000000000e-01), SC_(8.04247558593750000000000000000000000e+02), SC_(-2.49993033041934187739400806699798944e-01) }},
   {{ SC_(1.00035762786865234375000000000000000e+00), SC_(-8.04247802734375000000000000000000000e+02), SC_(-2.49915947776603479412056550180441388e-01) }},
   {{ SC_(1.24339759349822998046875000000000000e-03), SC_(4.30023968219757080078125000000000000e-02), SC_(-2.49999993311951198052336854836360596e-01) }},
   {{ SC_(1.24339759349822998046875000000000000e-03), SC_(-4.30024117231369018554687500000000000e-02), SC_(3.33333454359997392640744204336536031e-01) }},
   {{ SC_(9.99284744262695312500000000000000000e-01), SC_(4.02123779296875000000000000000000000e+02), SC_(-2.50031633041615998010192698929569304e-01) }},
   {{ SC_(1.00071525573730468750000000000000000e+00), SC_(-4.02123901367187500000000000000000000e+02), SC_(-2.49877396999234635906286910435970720e-01) }},
   {{ SC_(2.48679518699645996093750000000000000e-03), SC_(4.79729175567626953125000000000000000e-02), SC_(-2.50000017423057016682923029053242428e-01) }},
   {{ SC_(2.48679518699645996093750000000000000e-03), SC_(-4.79729175567626953125000000000000000e-02), SC_(3.33333364307657638103976605312285972e-01) }},
   {{ SC_(9.98570203781127929687500000000000000e-01), SC_(2.01061889648437500000000000000000000e+02), SC_(-2.50000877782958824330387594241522116e-01) }},
   {{ SC_(1.00143146514892578125000000000000000e+00), SC_(-2.01061950683593750000000000000000000e+02), SC_(-2.49943974284847564438300646778021652e-01) }},
   {{ SC_(4.97359037399291992187500000000000000e-03), SC_(5.42426556348800659179687500000000000e-02), SC_(-2.49999997661249235551917833827436999e-01) }},
   {{ SC_(4.97359037399291992187500000000000000e-03), SC_(-5.42426705360412597656250000000000000e-02), SC_(3.33333434548886778808990434088964441e-01) }},
   {{ SC_(9.97142314910888671875000000000000000e-01), SC_(1.00530944824218750000000000000000000e+02), SC_(-2.50011234481719046658321867102715372e-01) }},
   {{ SC_(1.00286531448364257812500000000000000e+00), SC_(-1.00530975341796875000000000000000000e+02), SC_(-2.49969169004851504310608109999129239e-01) }},
   {{ SC_(9.94718074798583984375000000000000000e-03), SC_(6.23976141214370727539062500000000000e-02), SC_(-2.50000009593958421067405822842101990e-01) }},
   {{ SC_(9.94718074798583984375000000000000000e-03), SC_(-6.23976141214370727539062500000000000e-02), SC_(3.33333350389259633409407359345815212e-01) }},
   {{ SC_(9.94292974472045898437500000000000000e-01), SC_(5.02654724121093750000000000000000000e+01), SC_(-2.50004474743456261014369727026323600e-01) }},
   {{ SC_(1.00573968887329101562500000000000000e+00), SC_(-5.02654876708984375000000000000000000e+01), SC_(-2.50001026486587438343154396418844595e-01) }},
   {{ SC_(1.98943614959716796875000000000000000e-02), SC_(7.34384953975677490234375000000000000e-02), SC_(-2.49999951781952021525732951476134576e-01) }},
   {{ SC_(1.98943614959716796875000000000000000e-02), SC_(-7.34385251998901367187500000000000000e-02), SC_(3.33333403272632574911750063128639930e-01) }},
   {{ SC_(9.88618612289428710937500000000000000e-01), SC_(2.51327362060546875000000000000000000e+01), SC_(-2.50002697654274887108269740543468615e-01) }},
   {{ SC_(1.01151227951049804687500000000000000e+00), SC_(-2.51327438354492187500000000000000000e+01), SC_(-2.50000238888204749549972717067646748e-01) }},
   {{ SC_(3.97887229919433593750000000000000000e-02), SC_(8.92266631126403808593750000000000000e-02), SC_(-2.50000010493529232319277365802127669e-01) }},
   {{ SC_(3.97887229919433593750000000000000000e-02), SC_(-8.92266929149627685546875000000000000e-02), SC_(3.33333480105579141261846800895492926e-01) }},
   {{ SC_(9.77366924285888671875000000000000000e-01), SC_(1.25663681030273437500000000000000000e+01), SC_(-2.50001118893867005370267571971907806e-01) }},
   {{ SC_(1.02315711975097656250000000000000000e+00), SC_(-1.25663719177246093750000000000000000e+01), SC_(-2.50000498195070978022541670012701586e-01) }},
   {{ SC_(7.95774459838867187500000000000000000e-02), SC_(1.13662302494049072265625000000000000e-01), SC_(-2.50000005728418265207696067433457464e-01) }},
   {{ SC_(7.95774459838867187500000000000000000e-02), SC_(-1.13662332296371459960937500000000000e-01), SC_(3.33333444091072869390174691552273107e-01) }},
   {{ SC_(9.55246210098266601562500000000000000e-01), SC_(6.28318405151367187500000000000000000e+00), SC_(-2.50000598888386450934743944955033388e-01) }},
   {{ SC_(1.04685020446777343750000000000000000e+00), SC_(-6.28318595886230468750000000000000000e+00), SC_(-2.49999205233960823078487553252221170e-01) }},
   {{ SC_(1.59154891967773437500000000000000000e-01), SC_(1.56529545783996582031250000000000000e-01), SC_(-2.50000030180668222154359425303467786e-01) }},
   {{ SC_(1.59154891967773437500000000000000000e-01), SC_(-1.56529545783996582031250000000000000e-01), SC_(3.33333386987856776269133177048750908e-01) }},
   {{ SC_(9.12495374679565429687500000000000000e-01), SC_(3.14159202575683593750000000000000000e+00), SC_(-2.50000462622403649538941673671476838e-01) }},
   {{ SC_(1.09589576721191406250000000000000000e+00), SC_(-3.14159297943115234375000000000000000e+00), SC_(-2.50000100969750033533173699535059149e-01) }},
   {{ SC_(3.18309783935546875000000000000000000e-01), SC_(2.51309990882873535156250000000000000e-01), SC_(-2.50000049088082548050801532495784495e-01) }},
   {{ SC_(3.18309783935546875000000000000000000e-01), SC_(-2.51309990882873535156250000000000000e-01), SC_(3.33333420601041352718476104134024670e-01) }},
   {{ SC_(8.32648038864135742187500000000000000e-01), SC_(1.57079601287841796875000000000000000e+00), SC_(-2.50000137125770904868840941545188965e-01) }},
   {{ SC_(1.20098733901977539062500000000000000e+00), SC_(-1.57079648971557617187500000000000000e+00), SC_(-2.49999911085921471318015227156033595e-01) }},
   {{ SC_(6.36619567871093750000000000000000000e-01), SC_(6.37052774429321289062500000000000000e-01), SC_(-2.50000110604573265355477220183162802e-01) }},
   {{ SC_(6.36619567871093750000000000000000000e-01), SC_(-6.37053012847900390625000000000000000e-01), SC_(3.33333673518121737462641696882216166e-01) }},
   {{ SC_(6.93302869796752929687500000000000000e-01), SC_(7.85398006439208984375000000000000000e-01), SC_(-2.50000040971449701620827220516750818e-01) }},
   {{ SC_(1.44237089157104492187500000000000000e+00), SC_(-7.85398244857788085937500000000000000e-01), SC_(-2.50000034862676986708531646837627815e-01) }},
   {{ SC_(1.27323913574218750000000000000000000e+00), SC_(-1.19091224670410156250000000000000000e+00), SC_(-2.49999727726570248022164166723367313e-01) }},
   {{ SC_(1.27323913574218750000000000000000000e+00), SC_(1.19091176986694335937500000000000000e+00), SC_(3.33332695709567776879320871007108168e-01) }},
   {{ SC_(4.80668902397155761718750000000000000e-01), SC_(3.92699003219604492187500000000000000e-01), SC_(-2.50000020672200093172300234804784209e-01) }},
   {{ SC_(2.08043289184570312500000000000000000e+00), SC_(-3.92699122428894042968750000000000000e-01), SC_(-2.49999907874692093010509833195206901e-01) }},
   {{ SC_(2.54647827148437500000000000000000000e+00), SC_(-3.07776331901550292968750000000000000e-01), SC_(-2.49999965125515267952875783222880446e-01) }},
   {{ SC_(2.54647827148437500000000000000000000e+00), SC_(3.07776212692260742187500000000000000e-01), SC_(3.33333122765901922115160276783665956e-01) }},
   {{ SC_(2.31042683124542236328125000000000000e-01), SC_(1.96349501609802246093750000000000000e-01), SC_(-2.49999963694915565480300027472044978e-01) }},
   {{ SC_(4.32820320129394531250000000000000000e+00), SC_(-1.96349561214447021484375000000000000e-01), SC_(-2.49999982176713757349450981918488392e-01) }},
   {{ SC_(5.09295654296875000000000000000000000e+00), SC_(-1.76724255084991455078125000000000000e-01), SC_(-2.50000008268782780657611191476135816e-01) }},
   {{ SC_(5.09295654296875000000000000000000000e+00), SC_(1.76724195480346679687500000000000000e-01), SC_(3.33333218662825233845223251719307487e-01) }},
   {{ SC_(5.33807277679443359375000000000000000e-02), SC_(9.81747508049011230468750000000000000e-02), SC_(-2.49999954946266654711638622220569443e-01) }},
   {{ SC_(1.87333526611328125000000000000000000e+01), SC_(-9.81747806072235107421875000000000000e-02), SC_(-2.50000020339498887213775530170974487e-01) }},
   {{ SC_(1.01859130859375000000000000000000000e+01), SC_(-1.23947143554687500000000000000000000e-01), SC_(-2.49999965280892537171197546917917131e-01) }},
   {{ SC_(1.01859130859375000000000000000000000e+01), SC_(1.23947143554687500000000000000000000e-01), SC_(3.33333271610478478920925331759157283e-01) }},
   {{ SC_(2.84950155764818191528320312500000000e-03), SC_(4.90873754024505615234375000000000000e-02), SC_(-2.49999961915143617048889184781782357e-01) }},
   {{ SC_(3.50938476562500000000000000000000000e+02), SC_(-4.90873903036117553710937500000000000e-02), SC_(-2.50000017678677370152932412661852545e-01) }},
   {{ SC_(2.03718261718750000000000000000000000e+01), SC_(-9.54437553882598876953125000000000000e-02), SC_(-2.49999998031595202000383767061972711e-01) }},
   {{ SC_(2.03718261718750000000000000000000000e+01), SC_(9.54437255859375000000000000000000000e-02), SC_(3.33333210062278402203972490973065143e-01) }},
   {{ SC_(8.11965946923010051250457763671875000e-06), SC_(2.45436877012252807617187500000000000e-02), SC_(-2.49999961139376299555159377590681570e-01) }},
   {{ SC_(1.23157843750000000000000000000000000e+05), SC_(-2.45436951518058776855468750000000000e-02), SC_(-2.50000022075634136314714495713189027e-01) }},
   {{ SC_(4.07436523437500000000000000000000000e+01), SC_(-7.75988101959228515625000000000000000e-02), SC_(-2.50000000749166096255822944538252831e-01) }},
   {{ SC_(4.07436523437500000000000000000000000e+01), SC_(7.75987803936004638671875000000000000e-02), SC_(3.33333187350323520626509593837053945e-01) }},
   {{ SC_(6.59289012272523677893332205712795258e-11), SC_(1.22718438506126403808593750000000000e-02), SC_(-2.49999956765469234329751731326776083e-01) }},
   {{ SC_(1.51678525440000000000000000000000000e+10), SC_(-1.22718475759029388427734375000000000e-02), SC_(-2.50000020902595005173432450066450625e-01) }},
   {{ SC_(8.14873046875000000000000000000000000e+01), SC_(-6.53756558895111083984375000000000000e-02), SC_(-2.50000038925703867272793075448542772e-01) }},
   {{ SC_(8.14873046875000000000000000000000000e+01), SC_(6.53756260871887207031250000000000000e-02), SC_(3.33333227676527675968393356516775347e-01) }},
   {{ SC_(4.34661924587735271136964740855412881e-21), SC_(6.13592192530632019042968750000000000e-03), SC_(-2.49999957581922641920052417968813314e-01) }},
   {{ SC_(2.30063783320687214592000000000000000e+20), SC_(-6.13592378795146942138671875000000000e-03), SC_(-2.50000021553172550189348534487376819e-01) }},
   {{ SC_(1.62974609375000000000000000000000000e+02), SC_(-5.64791858196258544921875000000000000e-02), SC_(-2.49999994877820370444791536991694813e-01) }},
   {{ SC_(1.62974609375000000000000000000000000e+02), SC_(5.64791709184646606445312500000000000e-02), SC_(3.33333223026612170433217453715871595e-01) }},
   {{ SC_(1.88937071944915085672646459714979392e-41), SC_(3.06796096265316009521484375000000000e-03), SC_(-2.49999883495738188698385086634772438e-01) }},
   {{ SC_(3.25949218750000000000000000000000000e+02), SC_(-4.97139990329742431640625000000000000e-02), SC_(-2.49999995336121590847503137951948841e-01) }},
   {{ SC_(3.25949218750000000000000000000000000e+02), SC_(4.97139990329742431640625000000000000e-02), SC_(3.33333325041993990844181412881440416e-01) }},
   {{ SC_(6.51898437500000000000000000000000000e+02), SC_(-4.43961471319198608398437500000000000e-02), SC_(-2.50000017387301836228789705058560301e-01) }},
   {{ SC_(6.51898437500000000000000000000000000e+02), SC_(4.43961322307586669921875000000000000e-02), SC_(3.33333235500273146986993437085263453e-01) }},
   {{ SC_(1.00005912780761718750000000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(9.97732016467354613205043554192177356e-02) }},
   {{ SC_(9.99940633773803710937500000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(1.00201283992182845210650629785845982e-01) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(1.29093155264854431152343750000000000e-02), SC_(9.99999976307250127430592278000292271e-02) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-1.29093155264854431152343750000000000e-02), SC_(-9.09090889510124030081902128083334657e-02) }},
   {{ SC_(1.00011825561523437500000000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(9.97701097536315633199424264202402772e-02) }},
   {{ SC_(9.99881505966186523437500000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(9.99934364616254927509135944437464403e-02) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(1.42468586564064025878906250000000000e-02), SC_(9.99999796589750741202808697432742763e-02) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-1.42468623816967010498046875000000000e-02), SC_(-9.09090967545500885872507846888923509e-02) }},
   {{ SC_(1.00023698806762695312500000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(9.99747740703820314524469140899990044e-02) }},
   {{ SC_(9.99763011932373046875000000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(9.99996486856313600239666750863859176e-02) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(1.58936083316802978515625000000000000e-02), SC_(9.99999715087540270856336597986856049e-02) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-1.58936157822608947753906250000000000e-02), SC_(-9.09091079801910117418432985913941535e-02) }},
   {{ SC_(1.00047397613525390625000000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(9.99623587713192641966171070041333011e-02) }},
   {{ SC_(9.99526023864746093750000000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(1.00012076184515980869549547944599781e-01) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(1.79708003997802734375000000000000000e-02), SC_(9.99999853387981064404223297351534911e-02) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-1.79708078503608703613281250000000000e-02), SC_(-9.09091147151169123128523206152252255e-02) }},
   {{ SC_(1.00094842910766601562500000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(9.99902192512094547821762731138379104e-02) }},
   {{ SC_(9.99052286148071289062500000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(1.00010552512707940827378485209075062e-01) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(2.06725671887397766113281250000000000e-02), SC_(9.99999778367510870269902580691762187e-02) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-2.06725746393203735351562500000000000e-02), SC_(-9.09091038202155019926637736490087163e-02) }},
   {{ SC_(1.00189781188964843750000000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(9.99932079813883245181827467016086335e-02) }},
   {{ SC_(9.98105525970458984375000000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(1.00007477247285435807300661869250243e-01) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(2.43304595351219177246093750000000000e-02), SC_(9.99999749350012870499078091457788109e-02) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-2.43304669857025146484375000000000000e-02), SC_(-9.09090967272125254783857091017937545e-02) }},
   {{ SC_(1.00379943847656250000000000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(9.99990744738080400539716091799841402e-02) }},
   {{ SC_(9.96214866638183593750000000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(1.00001214767378117060677139038057379e-01) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(2.95611396431922912597656250000000000e-02), SC_(9.99999956998778710617846816754999928e-02) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-2.95611396431922912597656250000000000e-02), SC_(-9.09090873552709539270569149313829520e-02) }},
   {{ SC_(1.00761318206787109375000000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(9.99972825857522269575778101564427447e-02) }},
   {{ SC_(9.92444038391113281250000000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(1.00001522858159541672838166242053941e-01) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(3.76567542552947998046875000000000000e-02), SC_(9.99999678277054017177929490551364486e-02) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-3.76567691564559936523437500000000000e-02), SC_(-9.09090986069602765855198899187821482e-02) }},
   {{ SC_(1.01528453826904296875000000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(9.99987366016144855307779347518969271e-02) }},
   {{ SC_(9.84945297241210937500000000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(1.00000625342203333551928782164753457e-01) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(5.18588423728942871093750000000000000e-02), SC_(9.99999856115608551973902240380236587e-02) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-5.18588423728942871093750000000000000e-02), SC_(-9.09090790178187330502971560898244343e-02) }},
   {{ SC_(1.03080272674560546875000000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(9.99988475601218103138169385466847153e-02) }},
   {{ SC_(9.70117330551147460937500000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(1.00000297642524341031049385548251066e-01) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(8.32599699497222900390625000000000000e-02), SC_(9.99999773982105479805176509793174238e-02) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-8.32599699497222900390625000000000000e-02), SC_(-9.09090722299256889088448432521909507e-02) }},
   {{ SC_(1.06255483627319335937500000000000000e+00), SC_(1.57079601287841796875000000000000000e+00), SC_(9.99997822833430523155798221861083232e-02) }},
   {{ SC_(9.41127777099609375000000000000000000e-01), SC_(-1.57079648971557617187500000000000000e+00), SC_(1.00000036818300349888534869537999237e-01) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(2.11058080196380615234375000000000000e-01), SC_(9.99999525294536092343683624064910784e-02) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-2.11058080196380615234375000000000000e-01), SC_(-9.09090516772326947445028647343964666e-02) }},
   {{ SC_(1.12902307510375976562500000000000000e+00), SC_(7.85398006439208984375000000000000000e-01), SC_(1.00000008032195820486609327361712866e-01) }},
   {{ SC_(8.85721445083618164062500000000000000e-01), SC_(-7.85398244857788085937500000000000000e-01), SC_(1.00000083388902157987087244955679392e-01) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-3.94553780555725097656250000000000000e-01), SC_(1.00000083612529707585633675487424876e-01) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(3.94553780555725097656250000000000000e-01), SC_(-9.09091600103498777532714807871446814e-02) }},
   {{ SC_(1.27469301223754882812500000000000000e+00), SC_(3.92699003219604492187500000000000000e-01), SC_(9.99999768961060406245244698775215012e-02) }},
   {{ SC_(7.84502506256103515625000000000000000e-01), SC_(-3.92699122428894042968750000000000000e-01), SC_(1.00000067985032992362261219181928506e-01) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-1.01967483758926391601562500000000000e-01), SC_(1.00000039774441687973100549332323256e-01) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(1.01967453956604003906250000000000000e-01), SC_(-9.09090984563623655143416979855839371e-02) }},
   {{ SC_(1.62484216690063476562500000000000000e+00), SC_(1.96349501609802246093750000000000000e-01), SC_(9.99999624673958768272143728354274878e-02) }},
   {{ SC_(6.15444183349609375000000000000000000e-01), SC_(-1.96349561214447021484375000000000000e-01), SC_(1.00000067624440650276792522716364803e-01) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-5.85494190454483032226562500000000000e-02), SC_(1.00000023160683773786704582743459657e-01) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(5.85494041442871093750000000000000000e-02), SC_(-9.09090879983426731647653066274063028e-02) }},
   {{ SC_(2.64011192321777343750000000000000000e+00), SC_(9.81747508049011230468750000000000000e-02), SC_(9.99999565722288004870213395291641903e-02) }},
   {{ SC_(3.78771662712097167968750000000000000e-01), SC_(-9.81747806072235107421875000000000000e-02), SC_(1.00000033441462939836484676245638704e-01) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-4.10641729831695556640625000000000000e-02), SC_(1.00000023074908289728873763569769382e-01) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(4.10641580820083618164062500000000000e-02), SC_(-9.09090785377284302596681827618188581e-02) }},
   {{ SC_(6.97019386291503906250000000000000000e+00), SC_(4.90873754024505615234375000000000000e-02), SC_(9.99999790051607718425326256020795374e-02) }},
   {{ SC_(1.43468022346496582031250000000000000e-01), SC_(-4.90873903036117553710937500000000000e-02), SC_(1.00000014671153183392766238027685000e-01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-3.16208899021148681640625000000000000e-02), SC_(1.00000036213701338621690303749221562e-01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(3.16208750009536743164062500000000000e-02), SC_(-9.09090800065094733316335578084067546e-02) }},
   {{ SC_(4.85836029052734375000000000000000000e+01), SC_(2.45436877012252807617187500000000000e-02), SC_(9.99999792378086096964437531203166889e-02) }},
   {{ SC_(2.05830708146095275878906250000000000e-02), SC_(-2.45436951518058776855468750000000000e-02), SC_(1.00000018109554935934362994264192674e-01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-2.57087871432304382324218750000000000e-02), SC_(1.00000023792213093853225078500334804e-01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(2.57087796926498413085937500000000000e-02), SC_(-9.09090854615842055691774029623186527e-02) }},
   {{ SC_(2.36036621093750000000000000000000000e+03), SC_(1.22718438506126403808593750000000000e-02), SC_(9.99999777490294680102925414295459434e-02) }},
   {{ SC_(4.23662946559488773345947265625000000e-04), SC_(-1.22718475759029388427734375000000000e-02), SC_(1.00000013572301780368656528615676950e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-2.16592028737068176269531250000000000e-02), SC_(1.00000012024811766733186825502058955e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(2.16591954231262207031250000000000000e-02), SC_(-9.09090710415964318515387936265488634e-02) }},
   {{ SC_(5.57132800000000000000000000000000000e+06), SC_(6.13592192530632019042968750000000000e-03), SC_(9.99999769618924960590695280214075055e-02) }},
   {{ SC_(1.79490371010615490376949310302734375e-07), SC_(-6.13592378795146942138671875000000000e-03), SC_(1.00000010612013301199635740563128596e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-1.87117755413055419921875000000000000e-02), SC_(1.00000027932562719958834998208889153e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(1.87117680907249450683593750000000000e-02), SC_(-9.09090794936352851918209415898465633e-02) }},
   {{ SC_(3.10397118709760000000000000000000000e+13), SC_(3.06796096265316009521484375000000000e-03), SC_(9.99999787218485416784393950018971970e-02) }},
   {{ SC_(3.22167829523364868116175330214900896e-14), SC_(-3.06796189397573471069335937500000000e-03), SC_(1.00000011694431050382630959611219120e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-1.64704397320747375488281250000000000e-02), SC_(1.00000008273684583989839338624798259e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(1.64704397320747375488281250000000000e-02), SC_(-9.09090977468467121975711435116363197e-02) }},
   {{ SC_(9.63463703088978962260426752000000000e+26), SC_(1.53398048132658004760742187500000000e-03), SC_(9.99999787044325468624753662757928068e-02) }},
   {{ SC_(1.03792139525719139103458641042669200e-27), SC_(-1.53398094698786735534667968750000000e-03), SC_(1.00000011220597215886476156261016551e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-1.47086158394813537597656250000000000e-02), SC_(1.00000024853430437478524701358624495e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(1.47086121141910552978515625000000000e-02), SC_(-9.09090895041442445631898670184597988e-02) }},
   {{ SC_(9.99934434890747070312500000000000000e-01), SC_(1.60849511718750000000000000000000000e+03), SC_(-1.00093685007226878678667371695223065e-01) }},
   {{ SC_(1.00006532669067382812500000000000000e+00), SC_(-1.60849560546875000000000000000000000e+03), SC_(-9.97423355773231661909298823331214924e-02) }},
   {{ SC_(6.21698796749114990234375000000000000e-04), SC_(1.42705850303173065185546875000000000e-02), SC_(-9.99999964965816430753628612440346556e-02) }},
   {{ SC_(6.21698796749114990234375000000000000e-04), SC_(-1.42705887556076049804687500000000000e-02), SC_(1.11111137345928624612268614831669551e-01) }},
   {{ SC_(9.99868869781494140625000000000000000e-01), SC_(8.04247558593750000000000000000000000e+02), SC_(-1.00096796643533432834022503608018175e-01) }},
   {{ SC_(1.00013065338134765625000000000000000e+00), SC_(-8.04247802734375000000000000000000000e+02), SC_(-9.97392461211916147137994867204523570e-02) }},
   {{ SC_(1.24339759349822998046875000000000000e-03), SC_(1.57491713762283325195312500000000000e-02), SC_(-9.99999877938372707160241352604679794e-02) }},
   {{ SC_(1.24339759349822998046875000000000000e-03), SC_(-1.57491788268089294433593750000000000e-02), SC_(1.11111151423659846064970608754304961e-01) }},
   {{ SC_(9.99737977981567382812500000000000000e-01), SC_(4.02123779296875000000000000000000000e+02), SC_(-1.00016717414309956787268576084275247e-01) }},
   {{ SC_(1.00026178359985351562500000000000000e+00), SC_(-4.02123901367187500000000000000000000e+02), SC_(-9.99056303467735693463494305937313039e-02) }},
   {{ SC_(2.48679518699645996093750000000000000e-03), SC_(1.75695717334747314453125000000000000e-02), SC_(-9.99999978451505408171814489121211574e-02) }},
   {{ SC_(2.48679518699645996093750000000000000e-03), SC_(-1.75695791840553283691406250000000000e-02), SC_(1.11111158094523255087105650784019950e-01) }},
   {{ SC_(9.99475955963134765625000000000000000e-01), SC_(2.01061889648437500000000000000000000e+02), SC_(-1.00029147222102290367369373002703812e-01) }},
   {{ SC_(1.00052404403686523437500000000000000e+00), SC_(-2.01061950683593750000000000000000000e+02), SC_(-9.99794817883996464982103760191935801e-02) }},
   {{ SC_(4.97359037399291992187500000000000000e-03), SC_(1.98657959699630737304687500000000000e-02), SC_(-9.99999854861224310982869774437340340e-02) }},
   {{ SC_(4.97359037399291992187500000000000000e-03), SC_(-1.98658034205436706542968750000000000e-02), SC_(1.11111137098297829672925881926879904e-01) }},
   {{ SC_(9.98952388763427734375000000000000000e-01), SC_(1.00530944824218750000000000000000000e+02), SC_(-1.00010832460856108977331653522877601e-01) }},
   {{ SC_(1.00104856491088867187500000000000000e+00), SC_(-1.00530975341796875000000000000000000e+02), SC_(-9.99977588414767695607185808434133861e-02) }},
   {{ SC_(9.94718074798583984375000000000000000e-03), SC_(2.28524655103683471679687500000000000e-02), SC_(-1.00000001894261048609220482339574558e-01) }},
   {{ SC_(9.94718074798583984375000000000000000e-03), SC_(-2.28524729609489440917968750000000000e-02), SC_(1.11111151617093895723011563131090077e-01) }},
   {{ SC_(9.97905969619750976562500000000000000e-01), SC_(5.02654724121093750000000000000000000e+01), SC_(-1.00006543756447744234381183613645734e-01) }},
   {{ SC_(1.00209808349609375000000000000000000e+00), SC_(-5.02654876708984375000000000000000000e+01), SC_(-9.99911761392974507458277905623926477e-02) }},
   {{ SC_(1.98943614959716796875000000000000000e-02), SC_(2.68960744142532348632812500000000000e-02), SC_(-9.99999871923702208290241547729781591e-02) }},
   {{ SC_(1.98943614959716796875000000000000000e-02), SC_(-2.68960818648338317871093750000000000e-02), SC_(1.11111127728445405720171801887229652e-01) }},
   {{ SC_(9.95816469192504882812500000000000000e-01), SC_(2.51327362060546875000000000000000000e+01), SC_(-1.00003250405551959867372735771347988e-01) }},
   {{ SC_(1.00420093536376953125000000000000000e+00), SC_(-2.51327438354492187500000000000000000e+01), SC_(-9.99994296747342025598992387171469900e-02) }},
   {{ SC_(3.97887229919433593750000000000000000e-02), SC_(3.26783210039138793945312500000000000e-02), SC_(-1.00000003347666526853060553917036872e-01) }},
   {{ SC_(3.97887229919433593750000000000000000e-02), SC_(-3.26783359050750732421875000000000000e-02), SC_(1.11111168626148628586924573226041708e-01) }},
   {{ SC_(9.91650581359863281250000000000000000e-01), SC_(1.25663681030273437500000000000000000e+01), SC_(-1.00001641799651684539765427409884980e-01) }},
   {{ SC_(1.00841951370239257812500000000000000e+00), SC_(-1.25663719177246093750000000000000000e+01), SC_(-9.99993749094882728288706278285388446e-02) }},
   {{ SC_(7.95774459838867187500000000000000000e-02), SC_(4.16276156902313232421875000000000000e-02), SC_(-1.00000002132451343571519215814449341e-01) }},
   {{ SC_(7.95774459838867187500000000000000000e-02), SC_(-4.16276305913925170898437500000000000e-02), SC_(1.11111155649551404614819878868997261e-01) }},
   {{ SC_(9.83371019363403320312500000000000000e-01), SC_(6.28318405151367187500000000000000000e+00), SC_(-1.00000814580890324553596414194255072e-01) }},
   {{ SC_(1.01691007614135742187500000000000000e+00), SC_(-6.28318595886230468750000000000000000e+00), SC_(-1.00000267565760309047952816695042683e-01) }},
   {{ SC_(1.59154891967773437500000000000000000e-01), SC_(5.73272854089736938476562500000000000e-02), SC_(-1.00000005300673090886787094877548702e-01) }},
   {{ SC_(1.59154891967773437500000000000000000e-01), SC_(-5.73273003101348876953125000000000000e-02), SC_(1.11111148084605051416447871951330700e-01) }},
   {{ SC_(9.67018842697143554687500000000000000e-01), SC_(3.14159202575683593750000000000000000e+00), SC_(-9.99999930529900215073873722963051278e-02) }},
   {{ SC_(1.03410577774047851562500000000000000e+00), SC_(-3.14159297943115234375000000000000000e+00), SC_(-9.99993783622329614362817737106750051e-02) }},
   {{ SC_(3.18309783935546875000000000000000000e-01), SC_(9.20396149158477783203125000000000000e-02), SC_(-1.00000010605239327975737706226761394e-01) }},
   {{ SC_(3.18309783935546875000000000000000000e-01), SC_(-9.20396447181701660156250000000000000e-02), SC_(1.11111162110243393542892313914884267e-01) }},
   {{ SC_(9.35125350952148437500000000000000000e-01), SC_(1.57079601287841796875000000000000000e+00), SC_(-1.00000130897055524894878303949500718e-01) }},
   {{ SC_(1.06937503814697265625000000000000000e+00), SC_(-1.57079648971557617187500000000000000e+00), SC_(-9.99997466602006551613748990758912243e-02) }},
   {{ SC_(6.36619567871093750000000000000000000e-01), SC_(2.33313858509063720703125000000000000e-01), SC_(-1.00000056425364530186508689722239804e-01) }},
   {{ SC_(6.36619567871093750000000000000000000e-01), SC_(-2.33313918113708496093750000000000000e-01), SC_(1.11111210679223711370558853369349553e-01) }},
   {{ SC_(8.74459505081176757812500000000000000e-01), SC_(7.85398006439208984375000000000000000e-01), SC_(-1.00000063734096121250606891294261436e-01) }},
   {{ SC_(1.14356327056884765625000000000000000e+00), SC_(-7.85398244857788085937500000000000000e-01), SC_(-9.99999310804547715036610850706345814e-02) }},
   {{ SC_(1.27323913574218750000000000000000000e+00), SC_(-4.36159014701843261718750000000000000e-01), SC_(-9.99998809831645451974103303345094828e-02) }},
   {{ SC_(1.27323913574218750000000000000000000e+00), SC_(4.36158895492553710937500000000000000e-01), SC_(1.11110932180446935846428244850864052e-01) }},
   {{ SC_(7.64679431915283203125000000000000000e-01), SC_(3.92699003219604492187500000000000000e-01), SC_(-1.00000061012491163753659411041190215e-01) }},
   {{ SC_(1.30773687362670898437500000000000000e+00), SC_(-3.92699122428894042968750000000000000e-01), SC_(-9.99999094143942779554530396481081662e-02) }},
   {{ SC_(2.54647827148437500000000000000000000e+00), SC_(-1.12719804048538208007812500000000000e-01), SC_(-9.99999665390262949136382693385871518e-02) }},
   {{ SC_(2.54647827148437500000000000000000000e+00), SC_(1.12719804048538208007812500000000000e-01), SC_(1.11111069801268566610417157845221173e-01) }},
   {{ SC_(5.84734916687011718750000000000000000e-01), SC_(1.96349501609802246093750000000000000e-01), SC_(-9.99999754581404137328650694228078981e-02) }},
   {{ SC_(1.71017646789550781250000000000000000e+00), SC_(-1.96349561214447021484375000000000000e-01), SC_(-9.99999855956136668266565013342468210e-02) }},
   {{ SC_(5.09295654296875000000000000000000000e+00), SC_(-6.47233724594116210937500000000000000e-02), SC_(-9.99999795975548796333836479523169766e-02) }},
   {{ SC_(5.09295654296875000000000000000000000e+00), SC_(6.47233724594116210937500000000000000e-02), SC_(1.11111085922907829807685509432888980e-01) }},
   {{ SC_(3.41914892196655273437500000000000000e-01), SC_(9.81747508049011230468750000000000000e-02), SC_(-9.99999833648058235798825968500554405e-02) }},
   {{ SC_(2.92470359802246093750000000000000000e+00), SC_(-9.81747806072235107421875000000000000e-02), SC_(-9.99999870058154818015387135968281333e-02) }},
   {{ SC_(1.01859130859375000000000000000000000e+01), SC_(-4.53943312168121337890625000000000000e-02), SC_(-9.99999870851398006482374838882085301e-02) }},
   {{ SC_(1.01859130859375000000000000000000000e+01), SC_(4.53943312168121337890625000000000000e-02), SC_(1.11111095166839488857373540243096485e-01) }},
   {{ SC_(1.16905778646469116210937500000000000e-01), SC_(4.90873754024505615234375000000000000e-02), SC_(-9.99999889801586353501181354167632210e-02) }},
   {{ SC_(8.55389404296875000000000000000000000e+00), SC_(-4.90873903036117553710937500000000000e-02), SC_(-1.00000002018085489860945125898101410e-01) }},
   {{ SC_(2.03718261718750000000000000000000000e+01), SC_(-3.49552631378173828125000000000000000e-02), SC_(-9.99999921433833360953855730599827090e-02) }},
   {{ SC_(2.03718261718750000000000000000000000e+01), SC_(3.49552631378173828125000000000000000e-02), SC_(1.11111101411584450222595172088147563e-01) }},
   {{ SC_(1.36669650673866271972656250000000000e-02), SC_(2.45436877012252807617187500000000000e-02), SC_(-9.99999825370334907145695652413126445e-02) }},
   {{ SC_(7.31691284179687500000000000000000000e+01), SC_(-2.45436951518058776855468750000000000e-02), SC_(-1.00000009601554713033021665983522945e-01) }},
   {{ SC_(4.07436523437500000000000000000000000e+01), SC_(-2.84197404980659484863281250000000000e-02), SC_(-9.99999909156288019964693378009616494e-02) }},
   {{ SC_(4.07436523437500000000000000000000000e+01), SC_(2.84197404980659484863281250000000000e-02), SC_(1.11111099895838140360249155202374522e-01) }},
   {{ SC_(1.86785939149558544158935546875000000e-04), SC_(1.22718438506126403808593750000000000e-02), SC_(-9.99999822415966267218124189752293528e-02) }},
   {{ SC_(5.35372070312500000000000000000000000e+03), SC_(-1.22718475759029388427734375000000000e-02), SC_(-1.00000008259951882581873344063597772e-01) }},
   {{ SC_(8.14873046875000000000000000000000000e+01), SC_(-2.39431411027908325195312500000000000e-02), SC_(-1.00000012116532756564287489194447489e-01) }},
   {{ SC_(8.14873046875000000000000000000000000e+01), SC_(2.39431336522102355957031250000000000e-02), SC_(1.11111089641030718285673717003500821e-01) }},
   {{ SC_(3.48889841461641481146216392517089844e-08), SC_(6.13592192530632019042968750000000000e-03), SC_(-9.99999827034373926698670923070291798e-02) }},
   {{ SC_(2.86623280000000000000000000000000000e+07), SC_(-6.13592378795146942138671875000000000e-03), SC_(-1.00000008767235057212608324052452493e-01) }},
   {{ SC_(1.62974609375000000000000000000000000e+02), SC_(-2.06849053502082824707031250000000000e-02), SC_(-1.00000002493166789152027966846954686e-01) }},
   {{ SC_(1.62974609375000000000000000000000000e+02), SC_(2.06848978996276855468750000000000000e-02), SC_(1.11111072022166894250125903472499551e-01) }},
   {{ SC_(1.21724182586247474391338840860044002e-15), SC_(3.06796096265316009521484375000000000e-03), SC_(-9.99999813172057128287776010432538241e-02) }},
   {{ SC_(8.21529264783360000000000000000000000e+14), SC_(-3.06796189397573471069335937500000000e-03), SC_(-1.00000009501291792538437446012083909e-01) }},
   {{ SC_(3.25949218750000000000000000000000000e+02), SC_(-1.82072296738624572753906250000000000e-02), SC_(-1.00000015920874721735670174150653402e-01) }},
   {{ SC_(3.25949218750000000000000000000000000e+02), SC_(1.82072222232818603515625000000000000e-02), SC_(1.11111082861418453555737642566495071e-01) }},
   {{ SC_(1.48167771536967037974436928054559845e-30), SC_(1.53398048132658004760742187500000000e-03), SC_(-9.99999812680635616640915558508173242e-02) }},
   {{ SC_(6.74910341862262969593447317504000000e+29), SC_(-1.53398094698786735534667968750000000e-03), SC_(-1.00000009519634044704783827188645211e-01) }},
   {{ SC_(6.51898437500000000000000000000000000e+02), SC_(-1.62596181035041809082031250000000000e-02), SC_(-1.00000001118988259425211512367460986e-01) }},
   {{ SC_(6.51898437500000000000000000000000000e+02), SC_(1.62596106529235839843750000000000000e-02), SC_(1.11111058849319763892201604102313340e-01) }},
   {{ SC_(1.00000619888305664062500000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(1.00207166976218077059713702339521553e-02) }},
   {{ SC_(9.99993801116943359375000000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(1.00207821824021889117968452886146780e-02) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(1.34772527962923049926757812500000000e-03), SC_(9.99999806352775695722628127022895851e-03) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-1.34772574529051780700683593750000000e-03), SC_(-9.90099160465675367500994257102945918e-03) }},
   {{ SC_(1.00001239776611328125000000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(1.00206854841894048138027403425411172e-02) }},
   {{ SC_(9.99987602233886718750000000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(1.00208133966210190035423053925649637e-02) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(1.48736452683806419372558593750000000e-03), SC_(9.99999969755964921137518806837621438e-03) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-1.48736452683806419372558593750000000e-03), SC_(-9.90098980252881984198673410636618060e-03) }},
   {{ SC_(1.00002479553222656250000000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(1.00206230581014308834284169521779642e-02) }},
   {{ SC_(9.99975204467773437500000000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(1.00208758258355619912723920408575834e-02) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(1.65928434580564498901367187500000000e-03), SC_(9.99999904786726781583839107638920187e-03) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-1.65928481146693229675292968750000000e-03), SC_(-9.90099193044879244742125753076779161e-03) }},
   {{ SC_(1.00004911422729492187500000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(9.92367314604778729497202960769987885e-03) }},
   {{ SC_(9.99950408935546875000000000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(1.00210006873722806137083397558902229e-02) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(1.87614187598228454589843750000000000e-03), SC_(9.99999914900366303993426971518959999e-03) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-1.87614234164357185363769531250000000e-03), SC_(-9.90099171001635369443345728499968837e-03) }},
   {{ SC_(1.00009870529174804687500000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(9.97183724407419618111135843108203848e-03) }},
   {{ SC_(9.99901056289672851562500000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(9.99703966847795875842113727282903404e-03) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(2.15820502489805221557617187500000000e-03), SC_(9.99999913918462971180434256628585764e-03) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-2.15820502489805221557617187500000000e-03), SC_(-9.90098925515599350861474815223315001e-03) }},
   {{ SC_(1.00019788742065429687500000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(9.99554568418564847492116132351129522e-03) }},
   {{ SC_(9.99801874160766601562500000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(1.00096432870122846215801110404211484e-02) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(2.54008639603853225708007812500000000e-03), SC_(9.99999630800875645468570998988811841e-03) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-2.54008732736110687255859375000000000e-03), SC_(-9.90099009193087532245305719021947615e-03) }},
   {{ SC_(1.00039577484130859375000000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(9.99455205683840715198709395782405110e-03) }},
   {{ SC_(9.99603986740112304687500000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(1.00045856362749036158421213477224972e-02) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(3.08616645634174346923828125000000000e-03), SC_(9.99999822160389309433618782184350078e-03) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-3.08616738766431808471679687500000000e-03), SC_(-9.90099132866853642288924454403786939e-03) }},
   {{ SC_(1.00079202651977539062500000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(9.99861280889707951196641696506965730e-03) }},
   {{ SC_(9.99208450317382812500000000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(1.00005208212013195882297227170349407e-02) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(3.93134541809558868408203125000000000e-03), SC_(9.99999892695777398954517327820467968e-03) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-3.93134541809558868408203125000000000e-03), SC_(-9.90098904711084486768527351349336464e-03) }},
   {{ SC_(1.00158452987670898437500000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(9.99765944365442495748110062745220368e-03) }},
   {{ SC_(9.98417615890502929687500000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(9.99995700639377018268083026158394581e-03) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(5.41403517127037048339843750000000000e-03), SC_(9.99999913430172043767259165294050403e-03) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-5.41403517127037048339843750000000000e-03), SC_(-9.90098925036929682938850461169757541e-03) }},
   {{ SC_(1.00317192077636718750000000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(9.99876739421878965529575249093864452e-03) }},
   {{ SC_(9.96837615966796875000000000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(1.00003381913700524997263734408103327e-02) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(8.69229435920715332031250000000000000e-03), SC_(9.99999650469398262476063867177946232e-03) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-8.69229808449745178222656250000000000e-03), SC_(-9.90099089480332694694819131680344534e-03) }},
   {{ SC_(1.00635433197021484375000000000000000e+00), SC_(1.57079601287841796875000000000000000e+00), SC_(9.99944423626111517798314084384065752e-03) }},
   {{ SC_(9.93685245513916015625000000000000000e-01), SC_(-1.57079648971557617187500000000000000e+00), SC_(1.00003175833449713828827388570524862e-02) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(2.20343470573425292968750000000000000e-02), SC_(9.99999474477734093465399932871789333e-03) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-2.20343545079231262207031250000000000e-02), SC_(-9.90098827857533286589827799580305850e-03) }},
   {{ SC_(1.01274967193603515625000000000000000e+00), SC_(7.85398006439208984375000000000000000e-01), SC_(9.99993805453892253399112981911318878e-03) }},
   {{ SC_(9.87410783767700195312500000000000000e-01), SC_(-7.85398244857788085937500000000000000e-01), SC_(9.99998288838768477399075010118787722e-03) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-4.11912053823471069335937500000000000e-02), SC_(1.00000093855794402501542930749873191e-02) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(4.11911904811859130859375000000000000e-02), SC_(-9.90099573570167239052898054603129090e-03) }},
   {{ SC_(1.02566194534301757812500000000000000e+00), SC_(3.92699003219604492187500000000000000e-01), SC_(9.99995635966788113212215929302975043e-03) }},
   {{ SC_(9.74979877471923828125000000000000000e-01), SC_(-3.92699122428894042968750000000000000e-01), SC_(1.00000554740133050184898021116006409e-02) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-1.06453485786914825439453125000000000e-02), SC_(1.00000026978487390608319344847147276e-02) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(1.06453448534011840820312500000000000e-02), SC_(-9.90098929610332049874451064086695083e-03) }},
   {{ SC_(1.05198240280151367187500000000000000e+00), SC_(1.96349501609802246093750000000000000e-01), SC_(9.99995196290694117154369937016062347e-03) }},
   {{ SC_(9.50585842132568359375000000000000000e-01), SC_(-1.96349561214447021484375000000000000e-01), SC_(1.00000386471088688029117211594539511e-02) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-6.11252710223197937011718750000000000e-03), SC_(1.00000016406810764222242348914971974e-02) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(6.11252523958683013916015625000000000e-03), SC_(-9.90098870526036588344696093101703134e-03) }},
   {{ SC_(1.10666751861572265625000000000000000e+00), SC_(9.81747508049011230468750000000000000e-02), SC_(1.00000005983969282630767978684888469e-02) }},
   {{ SC_(9.03613805770874023437500000000000000e-01), SC_(-9.81747806072235107421875000000000000e-02), SC_(9.99999886790071196491304121059115210e-03) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-4.28707711398601531982421875000000000e-03), SC_(1.00000017980791500213704429461236579e-02) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(4.28707525134086608886718750000000000e-03), SC_(-9.90098758125288147748648100013395359e-03) }},
   {{ SC_(1.22471284866333007812500000000000000e+00), SC_(4.90873754024505615234375000000000000e-02), SC_(9.99999460325482003489620769186436580e-03) }},
   {{ SC_(8.16517829895019531250000000000000000e-01), SC_(-4.90873903036117553710937500000000000e-02), SC_(1.00000037305751629128647579372960709e-02) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-3.30120325088500976562500000000000000e-03), SC_(1.00000021622572355432988179993387591e-02) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(3.30120231956243515014648437500000000e-03), SC_(-9.90098943930657746311733462661266579e-03) }},
   {{ SC_(1.49992179870605468750000000000000000e+00), SC_(2.45436877012252807617187500000000000e-02), SC_(9.99999852055427348656496586221936205e-03) }},
   {{ SC_(6.66701316833496093750000000000000000e-01), SC_(-2.45436951518058776855468750000000000e-02), SC_(1.00000055786195053695326770617724828e-02) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-2.68398318439722061157226562500000000e-03), SC_(1.00000015730383225913782839114482506e-02) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(2.68398225307464599609375000000000000e-03), SC_(-9.90098822254550854194825614443656825e-03) }},
   {{ SC_(2.24976539611816406250000000000000000e+00), SC_(1.22718438506126403808593750000000000e-02), SC_(9.99999848686265774988843765690538340e-03) }},
   {{ SC_(4.44490790367126464843750000000000000e-01), SC_(-1.22718475759029388427734375000000000e-02), SC_(1.00000015492666346006064347753286981e-02) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-2.26120930165052413940429687500000000e-03), SC_(1.00000025752214320799760070549328231e-02) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(2.26120837032794952392578125000000000e-03), SC_(-9.90098856582955430126448769061586519e-03) }},
   {{ SC_(5.06144332885742187500000000000000000e+00), SC_(6.13592192530632019042968750000000000e-03), SC_(9.99999725178427035754727774484172556e-03) }},
   {{ SC_(1.97572052478790283203125000000000000e-01), SC_(-6.13592378795146942138671875000000000e-03), SC_(1.00000018705421627402911731316638255e-02) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-1.95349939167499542236328125000000000e-03), SC_(1.00000037992935027351295887823178318e-02) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(1.95349846035242080688476562500000000e-03), SC_(-9.90098912663047044848874954505880610e-03) }},
   {{ SC_(2.56182098388671875000000000000000000e+01), SC_(3.06796096265316009521484375000000000e-03), SC_(9.99999740511019393652204567219074843e-03) }},
   {{ SC_(3.90347242355346679687500000000000000e-02), SC_(-3.06796189397573471069335937500000000e-03), SC_(1.00000012104952079507602183770345610e-02) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-1.71950506046414375305175781250000000e-03), SC_(1.00000015201281772405326680407325131e-02) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(1.71950459480285644531250000000000000e-03), SC_(-9.90098892120358083119091763851056458e-03) }},
   {{ SC_(6.56292724609375000000000000000000000e+02), SC_(1.53398048132658004760742187500000000e-03), SC_(9.99999752140173374333659981664765180e-03) }},
   {{ SC_(1.52370985597372055053710937500000000e-03), SC_(-1.53398094698786735534667968750000000e-03), SC_(1.00000010479792619055283217564013262e-02) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-1.53557118028402328491210937500000000e-03), SC_(1.00000004116572579150048059648974946e-02) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(1.53557118028402328491210937500000000e-03), SC_(-9.90099050255588446938628235779168035e-03) }},
   {{ SC_(9.99993562698364257812500000000000000e-01), SC_(1.60849511718750000000000000000000000e+03), SC_(-1.03009793044011156150848121508664116e-02) }},
   {{ SC_(1.00000619888305664062500000000000000e+00), SC_(-1.60849560546875000000000000000000000e+03), SC_(-9.92130117605377236493028122309683356e-03) }},
   {{ SC_(6.21698796749114990234375000000000000e-04), SC_(1.36127043515443801879882812500000000e-03), SC_(-9.99999842647001341321149221254338636e-03) }},
   {{ SC_(6.21698796749114990234375000000000000e-04), SC_(-1.36127090081572532653808593750000000e-03), SC_(1.01010119682612035159401017817197262e-02) }},
   {{ SC_(9.99987363815307617187500000000000000e-01), SC_(8.04247558593750000000000000000000000e+02), SC_(-1.01112193059536591428972907454273864e-02) }},
   {{ SC_(1.00001239776611328125000000000000000e+00), SC_(-8.04247802734375000000000000000000000e+02), SC_(-9.92127057889436296324860617480372682e-03) }},
   {{ SC_(1.24339759349822998046875000000000000e-03), SC_(1.50231318548321723937988281250000000e-03), SC_(-1.00000006148783177248265945209933420e-02) }},
   {{ SC_(1.24339759349822998046875000000000000e-03), SC_(-1.50231318548321723937988281250000000e-03), SC_(1.01010107283729396048575484656943159e-02) }},
   {{ SC_(9.99974966049194335937500000000000000e-01), SC_(4.02123779296875000000000000000000000e+02), SC_(-1.00163715565362549115567991549639812e-02) }},
   {{ SC_(1.00002479553222656250000000000000000e+00), SC_(-4.02123901367187500000000000000000000e+02), SC_(-9.92120938533136508419367449965320055e-03) }},
   {{ SC_(2.48679518699645996093750000000000000e-03), SC_(1.67596060782670974731445312500000000e-03), SC_(-9.99999848574796651574709849056193774e-03) }},
   {{ SC_(2.48679518699645996093750000000000000e-03), SC_(-1.67596107348799705505371093750000000e-03), SC_(1.01010113766784787831299686493345205e-02) }},
   {{ SC_(9.99949932098388671875000000000000000e-01), SC_(2.01061889648437500000000000000000000e+02), SC_(-1.00164963058826010224722675180043391e-02) }},
   {{ SC_(1.00004959106445312500000000000000000e+00), SC_(-2.01061950683593750000000000000000000e+02), SC_(-9.92108700122855492364955598520836239e-03) }},
   {{ SC_(4.97359037399291992187500000000000000e-03), SC_(1.89499789848923683166503906250000000e-03), SC_(-1.00000001844030953053573747599612609e-02) }},
   {{ SC_(4.97359037399291992187500000000000000e-03), SC_(-1.89499836415052413940429687500000000e-03), SC_(1.01010127837910591745773344736952253e-02) }},
   {{ SC_(9.99899864196777343750000000000000000e-01), SC_(1.00530944824218750000000000000000000e+02), SC_(-1.00167458170210221718795552849122519e-02) }},
   {{ SC_(1.00009965896606445312500000000000000e+00), SC_(-1.00530975341796875000000000000000000e+02), SC_(-9.96829771974743835056683539480928194e-03) }},
   {{ SC_(9.94718074798583984375000000000000000e-03), SC_(2.17989552766084671020507812500000000e-03), SC_(-9.99999861384097045980148045461776465e-03) }},
   {{ SC_(9.94718074798583984375000000000000000e-03), SC_(-2.17989645898342132568359375000000000e-03), SC_(1.01010130239096332228719944177174801e-02) }},
   {{ SC_(9.99799966812133789062500000000000000e-01), SC_(5.02654724121093750000000000000000000e+01), SC_(-1.00053782692302577225316639085104385e-02) }},
   {{ SC_(1.00019979476928710937500000000000000e+00), SC_(-5.02654876708984375000000000000000000e+01), SC_(-9.99152808311410390867395037548183869e-03) }},
   {{ SC_(1.98943614959716796875000000000000000e-02), SC_(2.56561581045389175415039062500000000e-03), SC_(-9.99999953086931370972269992951969118e-03) }},
   {{ SC_(1.98943614959716796875000000000000000e-02), SC_(-2.56561674177646636962890625000000000e-03), SC_(1.01010133074931069656043041628731181e-02) }},
   {{ SC_(9.99600172042846679687500000000000000e-01), SC_(2.51327362060546875000000000000000000e+01), SC_(-1.00004397052128410543754581962747912e-02) }},
   {{ SC_(1.00039958953857421875000000000000000e+00), SC_(-2.51327438354492187500000000000000000e+01), SC_(-9.99053525572835030235636689090336539e-03) }},
   {{ SC_(3.97887229919433593750000000000000000e-02), SC_(3.11718415468931198120117187500000000e-03), SC_(-1.00000012213669947221581927302217869e-02) }},
   {{ SC_(3.97887229919433593750000000000000000e-02), SC_(-3.11718415468931198120117187500000000e-03), SC_(1.01010113471757945403158700976898259e-02) }},
   {{ SC_(9.99200344085693359375000000000000000e-01), SC_(1.25663681030273437500000000000000000e+01), SC_(-1.00024300946062266697951132244730555e-02) }},
   {{ SC_(1.00080013275146484375000000000000000e+00), SC_(-1.25663719177246093750000000000000000e+01), SC_(-1.00004053610719701537108667839032020e-02) }},
   {{ SC_(7.95774459838867187500000000000000000e-02), SC_(3.97085584700107574462890625000000000e-03), SC_(-9.99999787348577954196688050273849780e-03) }},
   {{ SC_(7.95774459838867187500000000000000000e-02), SC_(-3.97085770964622497558593750000000000e-03), SC_(1.01010126933398768160993007977317232e-02) }},
   {{ SC_(9.98401641845703125000000000000000000e-01), SC_(6.28318405151367187500000000000000000e+00), SC_(-1.00004723795081204936477447182003590e-02) }},
   {{ SC_(1.00160074234008789062500000000000000e+00), SC_(-6.28318595886230468750000000000000000e+00), SC_(-9.99939073322871359589337710329698582e-03) }},
   {{ SC_(1.59154891967773437500000000000000000e-01), SC_(5.46844676136970520019531250000000000e-03), SC_(-9.99999880674101981236300286930259710e-03) }},
   {{ SC_(1.59154891967773437500000000000000000e-01), SC_(-5.46844862401485443115234375000000000e-03), SC_(1.01010123414154575151745663535780453e-02) }},
   {{ SC_(9.96805906295776367187500000000000000e-01), SC_(3.14159202575683593750000000000000000e+00), SC_(-1.00002606605230441508137280559792380e-02) }},
   {{ SC_(1.00320386886596679687500000000000000e+00), SC_(-3.14159297943115234375000000000000000e+00), SC_(-9.99883829948666574650355890258204273e-03) }},
   {{ SC_(3.18309783935546875000000000000000000e-01), SC_(8.77965614199638366699218750000000000e-03), SC_(-1.00000017225456805165395445702330219e-02) }},
   {{ SC_(3.18309783935546875000000000000000000e-01), SC_(-8.77965986728668212890625000000000000e-03), SC_(1.01010161660580668038382282784359271e-02) }},
   {{ SC_(9.93622064590454101562500000000000000e-01), SC_(1.57079601287841796875000000000000000e+00), SC_(-1.00001827759114719519730425671967841e-02) }},
   {{ SC_(1.00641870498657226562500000000000000e+00), SC_(-1.57079648971557617187500000000000000e+00), SC_(-9.99992375028290945219151106165568125e-03) }},
   {{ SC_(6.36619567871093750000000000000000000e-01), SC_(2.22558006644248962402343750000000000e-02), SC_(-1.00000059083038738221481612673693246e-02) }},
   {{ SC_(6.36619567871093750000000000000000000e-01), SC_(-2.22558081150054931640625000000000000e-02), SC_(1.01010195278176843608718688527692674e-02) }},
   {{ SC_(9.87284898757934570312500000000000000e-01), SC_(7.85398006439208984375000000000000000e-01), SC_(-1.00001107010308412248943198485497583e-02) }},
   {{ SC_(1.01287841796875000000000000000000000e+00), SC_(-7.85398244857788085937500000000000000e-01), SC_(-9.99977653027458232733243148514579010e-03) }},
   {{ SC_(1.27323913574218750000000000000000000e+00), SC_(-4.16051894426345825195312500000000000e-02), SC_(-9.99998667283753859827910499919050945e-03) }},
   {{ SC_(1.27323913574218750000000000000000000e+00), SC_(4.16051894426345825195312500000000000e-02), SC_(1.01009965032524415933162824590546500e-02) }},
   {{ SC_(9.74731683731079101562500000000000000e-01), SC_(3.92699003219604492187500000000000000e-01), SC_(-1.00000259789985547258901841152700087e-02) }},
   {{ SC_(1.02592325210571289062500000000000000e+00), SC_(-3.92699122428894042968750000000000000e-01), SC_(-9.99998969605640706025479891364890852e-03) }},
   {{ SC_(2.54647827148437500000000000000000000e+00), SC_(-1.07523389160633087158203125000000000e-02), SC_(-9.99999723284129003465734463957278539e-03) }},
   {{ SC_(2.54647827148437500000000000000000000e+00), SC_(1.07523351907730102539062500000000000e-02), SC_(1.01010037604233827113658852518701125e-02) }},
   {{ SC_(9.50101852416992187500000000000000000e-01), SC_(1.96349501609802246093750000000000000e-01), SC_(-1.00000265625507452182481291037301662e-02) }},
   {{ SC_(1.05251836776733398437500000000000000e+00), SC_(-1.96349561214447021484375000000000000e-01), SC_(-9.99996172640816274619179024026742149e-03) }},
   {{ SC_(5.09295654296875000000000000000000000e+00), SC_(-6.17396086454391479492187500000000000e-03), SC_(-9.99999892303874064505308321502129878e-03) }},
   {{ SC_(5.09295654296875000000000000000000000e+00), SC_(6.17395900189876556396484375000000000e-03), SC_(1.01010059394319053057326465613199225e-02) }},
   {{ SC_(9.02693748474121093750000000000000000e-01), SC_(9.81747508049011230468750000000000000e-02), SC_(-1.00000030358082771995161702686782862e-02) }},
   {{ SC_(1.10779523849487304687500000000000000e+00), SC_(-9.81747806072235107421875000000000000e-02), SC_(-9.99999015337059968971821623249277698e-03) }},
   {{ SC_(1.01859130859375000000000000000000000e+01), SC_(-4.33016382157802581787109375000000000e-03), SC_(-9.99999904941807125703303107979352727e-03) }},
   {{ SC_(1.01859130859375000000000000000000000e+01), SC_(4.33016382157802581787109375000000000e-03), SC_(1.01010091311275096110257798411282598e-02) }},
   {{ SC_(8.14856052398681640625000000000000000e-01), SC_(4.90873754024505615234375000000000000e-02), SC_(-1.00000001216248247668750076331313466e-02) }},
   {{ SC_(1.22721052169799804687500000000000000e+00), SC_(-4.90873903036117553710937500000000000e-02), SC_(-9.99999931131622658640496655962976994e-03) }},
   {{ SC_(2.03718261718750000000000000000000000e+01), SC_(-3.33438161760568618774414062500000000e-03), SC_(-1.00000000889477383110230241953223607e-02) }},
   {{ SC_(2.03718261718750000000000000000000000e+01), SC_(3.33438068628311157226562500000000000e-03), SC_(1.01010073562601888696775697680628597e-02) }},
   {{ SC_(6.63990259170532226562500000000000000e-01), SC_(2.45436877012252807617187500000000000e-02), SC_(-1.00000047676436283073862328400456851e-02) }},
   {{ SC_(1.50604581832885742187500000000000000e+00), SC_(-2.45436951518058776855468750000000000e-02), SC_(-1.00000017920927954650549762452948070e-02) }},
   {{ SC_(4.07436523437500000000000000000000000e+01), SC_(-2.71095801144838333129882812500000000e-03), SC_(-9.99999894708870797014504948473505348e-03) }},
   {{ SC_(4.07436523437500000000000000000000000e+01), SC_(2.71095801144838333129882812500000000e-03), SC_(1.01010090267204459646622192693125115e-02) }},
   {{ SC_(4.40883278846740722656250000000000000e-01), SC_(1.22718438506126403808593750000000000e-02), SC_(-9.99999885478691108023565563731459677e-03) }},
   {{ SC_(2.26817321777343750000000000000000000e+00), SC_(-1.22718475759029388427734375000000000e-02), SC_(-9.99999756522437610116809573968575272e-03) }},
   {{ SC_(8.14873046875000000000000000000000000e+01), SC_(-2.28393543511629104614257812500000000e-03), SC_(-1.00000015071500368822834008216172726e-02) }},
   {{ SC_(8.14873046875000000000000000000000000e+01), SC_(2.28393450379371643066406250000000000e-03), SC_(1.01010074991292207098283379088649934e-02) }},
   {{ SC_(1.94378077983856201171875000000000000e-01), SC_(6.13592192530632019042968750000000000e-03), SC_(-9.99999846673346819996644245443390242e-03) }},
   {{ SC_(5.14461135864257812500000000000000000e+00), SC_(-6.13592378795146942138671875000000000e-03), SC_(-9.99999946957965537104127848318398474e-03) }},
   {{ SC_(1.62974609375000000000000000000000000e+02), SC_(-1.97313260287046432495117187500000000e-03), SC_(-1.00000013448057850277251427065318081e-02) }},
   {{ SC_(1.62974609375000000000000000000000000e+02), SC_(1.97313167154788970947265625000000000e-03), SC_(1.01010066814244657681811502072460247e-02) }},
   {{ SC_(3.77828329801559448242187500000000000e-02), SC_(3.06796096265316009521484375000000000e-03), SC_(-9.99999880601382983477929760481437941e-03) }},
   {{ SC_(2.64670333862304687500000000000000000e+01), SC_(-3.06796189397573471069335937500000000e-03), SC_(-1.00000003135909025111495393674912502e-02) }},
   {{ SC_(3.25949218750000000000000000000000000e+02), SC_(-1.73678668215870857238769531250000000e-03), SC_(-9.99999988903605986102230512290316653e-03) }},
   {{ SC_(3.25949218750000000000000000000000000e+02), SC_(1.73678621649742126464843750000000000e-03), SC_(1.01010072659128018569545567650023787e-02) }},
   {{ SC_(1.42754288390278816223144531250000000e-03), SC_(1.53398048132658004760742187500000000e-03), SC_(-9.99999836357715530487618366423386609e-03) }},
   {{ SC_(7.00504150390625000000000000000000000e+02), SC_(-1.53398094698786735534667968750000000e-03), SC_(-1.00000009512274627543307808348627349e-02) }},
   {{ SC_(6.51898437500000000000000000000000000e+02), SC_(-1.55100459232926368713378906250000000e-03), SC_(-1.00000013866398513278669012860202763e-02) }},
   {{ SC_(6.51898437500000000000000000000000000e+02), SC_(1.55100412666797637939453125000000000e-03), SC_(1.01010084678918851308932807354622624e-02) }},
   {{ SC_(1.00000047683715820312500000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(7.67284269887446816497956799489388231e-04) }},
   {{ SC_(9.99999284744262695312500000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(1.15114818471871209367544961449497997e-03) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(1.35377573315054178237915039062500000e-04), SC_(9.99999642841977252222599723011315273e-04) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-1.35377631522715091705322265625000000e-04), SC_(-9.99001071877223027338080154335789379e-04) }},
   {{ SC_(1.00000095367431640625000000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(7.67284086882588770822860970562852304e-04) }},
   {{ SC_(9.99998569488525390625000000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(1.15114859663868893406037556091706401e-03) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(1.49404164403676986694335937500000000e-04), SC_(9.99999651336240055990229278941866053e-04) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-1.49404222611337900161743164062500000e-04), SC_(-9.99001040048352879875555963906092447e-04) }},
   {{ SC_(1.00000238418579101562500000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(9.59196392825862054041919322895025348e-04) }},
   {{ SC_(9.99997377395629882812500000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(1.05516958410414681888238634598449086e-03) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(1.66673387866467237472534179687500000e-04), SC_(9.99999963956165202440137669535049849e-04) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-1.66673387866467237472534179687500000e-04), SC_(-9.99000963029143884229933405995878810e-04) }},
   {{ SC_(1.00000476837158203125000000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(9.59195248830526788799736318010620071e-04) }},
   {{ SC_(9.99994993209838867187500000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(1.00718438645619043769148256900628496e-03) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(1.88456499017775058746337890625000000e-04), SC_(9.99999961538276881043121251932873699e-04) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-1.88456499017775058746337890625000000e-04), SC_(-9.99000960616084095290618405486370797e-04) }},
   {{ SC_(1.00000953674316406250000000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(9.59192960850770085854617441531065851e-04) }},
   {{ SC_(9.99989986419677734375000000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(1.00718690912489904342832177904193380e-03) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(2.16789427213370800018310546875000000e-04), SC_(9.99999860961270886536227194754377379e-04) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-2.16789485421031713485717773437500000e-04), SC_(-9.99001128336252091995143204016563710e-04) }},
   {{ SC_(1.00001955032348632812500000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(9.83179644408230291199738145172446147e-04) }},
   {{ SC_(9.99979972839355468750000000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(1.00719195451285804117294678612309168e-03) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(2.55149090662598609924316406250000000e-04), SC_(9.99999896512327025393344035142830582e-04) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-2.55149090662598609924316406250000000e-04), SC_(-9.99000895719991312078874747426230305e-04) }},
   {{ SC_(1.00003957748413085937500000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(9.95165634248928570170551559000404605e-04) }},
   {{ SC_(9.99960184097290039062500000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(1.00120367557413090093798681567427926e-03) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(3.10002244077622890472412109375000000e-04), SC_(9.99999982771731663771727575370488509e-04) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-3.10002244077622890472412109375000000e-04), SC_(-9.99000981807135585169287118688954792e-04) }},
   {{ SC_(1.00007915496826171875000000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(9.95145932546997132636437575763527117e-04) }},
   {{ SC_(9.99920368194580078125000000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(1.00122361865410667068810773105456194e-03) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(3.94899514503777027130126953125000000e-04), SC_(9.99999834157376674017503278995625552e-04) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-3.94899630919098854064941406250000000e-04), SC_(-9.99001127845187408579201202182041488e-04) }},
   {{ SC_(1.00015878677368164062500000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(9.98105098359199473913205849826872354e-04) }},
   {{ SC_(9.99840736389160156250000000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(1.00126350799186834444687550257487505e-03) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(5.43834175914525985717773437500000000e-04), SC_(9.99999917994686896526613872515561342e-04) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-5.43834175914525985717773437500000000e-04), SC_(-9.99000917159450828700231484789394764e-04) }},
   {{ SC_(1.00031805038452148437500000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(9.99524882355396708901989176871664208e-04) }},
   {{ SC_(9.99681711196899414062500000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(1.00059329670075341845421378832534558e-03) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(8.73131910338997840881347656250000000e-04), SC_(9.99999684163329665928518741308856659e-04) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-8.73132143169641494750976562500000000e-04), SC_(-9.99000950056943422703876482095817009e-04) }},
   {{ SC_(1.00063610076904296875000000000000000e+00), SC_(1.57079601287841796875000000000000000e+00), SC_(9.99365929150844778390091675918851569e-04) }},
   {{ SC_(9.99363899230957031250000000000000000e-01), SC_(-1.57079648971557617187500000000000000e+00), SC_(1.00000245043902570397976455261264156e-03) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(2.21332721412181854248046875000000000e-03), SC_(9.99999515152618349433368478813402093e-04) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-2.21332721412181854248046875000000000e-03), SC_(-9.99000515121859274183585658104528207e-04) }},
   {{ SC_(1.00127315521240234375000000000000000e+00), SC_(7.85398006439208984375000000000000000e-01), SC_(9.99797034323786594891863586715832801e-04) }},
   {{ SC_(9.98728036880493164062500000000000000e-01), SC_(-7.85398244857788085937500000000000000e-01), SC_(1.00013328498513398395470285351887714e-03) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-4.13761287927627563476562500000000000e-03), SC_(1.00000077863225555692967608061784021e-03) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(4.13761287927627563476562500000000000e-03), SC_(-9.99001776078322228487945306372012188e-04) }},
   {{ SC_(1.00254821777343750000000000000000000e+00), SC_(3.92699003219604492187500000000000000e-01), SC_(9.99909339215904655019617588499034759e-04) }},
   {{ SC_(9.97457981109619140625000000000000000e-01), SC_(-3.92699122428894042968750000000000000e-01), SC_(1.00001921123081145602871903981199089e-03) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-1.06931431218981742858886718750000000e-03), SC_(1.00000043239616644539288680500797951e-03) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(1.06931384652853012084960937500000000e-03), SC_(-9.99000995709366807198496989118775715e-04) }},
   {{ SC_(1.00510311126708984375000000000000000e+00), SC_(1.96349501609802246093750000000000000e-01), SC_(9.99944988857825703674923369106885290e-04) }},
   {{ SC_(9.94922399520874023437500000000000000e-01), SC_(-1.96349561214447021484375000000000000e-01), SC_(1.00002406271851846972254639308065427e-03) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-6.13996991887688636779785156250000000e-04), SC_(1.00000021860084591870718226839137896e-03) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(6.13996759057044982910156250000000000e-04), SC_(-9.99000838528467766180723662102096584e-04) }},
   {{ SC_(1.01023244857788085937500000000000000e+00), SC_(9.81747508049011230468750000000000000e-02), SC_(9.99962917021063140999745457449927544e-04) }},
   {{ SC_(9.89870786666870117187500000000000000e-01), SC_(-9.81747806072235107421875000000000000e-02), SC_(1.00000365119156003361481904037431302e-03) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-4.30632382631301879882812500000000000e-04), SC_(1.00000010426145639163336237268279116e-03) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(4.30632382631301879882812500000000000e-04), SC_(-9.99001103054244836855223374633996220e-04) }},
   {{ SC_(1.02057027816772460937500000000000000e+00), SC_(4.90873754024505615234375000000000000e-02), SC_(9.99995560464717729403700943959735553e-04) }},
   {{ SC_(9.79844093322753906250000000000000000e-01), SC_(-4.90873903036117553710937500000000000e-02), SC_(1.00000771180077191031146198118234811e-03) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-3.31602408550679683685302734375000000e-04), SC_(1.00000019341406124510425588029687828e-03) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(3.31602292135357856750488281250000000e-04), SC_(-9.99000841485716867818132505202519759e-04) }},
   {{ SC_(1.04156351089477539062500000000000000e+00), SC_(2.45436877012252807617187500000000000e-02), SC_(9.99991272560094378772795735622107568e-04) }},
   {{ SC_(9.60094690322875976562500000000000000e-01), SC_(-2.45436951518058776855468750000000000e-02), SC_(1.00000149093224384737917001878384546e-03) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-2.69603333435952663421630859375000000e-04), SC_(1.00000026103233793617437099081917836e-03) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(2.69603217020630836486816406250000000e-04), SC_(-9.99000828356619814165977735282784470e-04) }},
   {{ SC_(1.08485507965087890625000000000000000e+00), SC_(1.22718438506126403808593750000000000e-02), SC_(9.99997301340047048456467113581013524e-04) }},
   {{ SC_(9.21781778335571289062500000000000000e-01), SC_(-1.22718475759029388427734375000000000e-02), SC_(1.00000197136044758834477612659759310e-03) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-2.27136071771383285522460937500000000e-04), SC_(1.00000008489661964576434680126181788e-03) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(2.27136013563722372055053710937500000e-04), SC_(-9.99000827844192634242441209239724297e-04) }},
   {{ SC_(1.17691087722778320312500000000000000e+00), SC_(6.13592192530632019042968750000000000e-03), SC_(9.99999041200621068790986319602321054e-04) }},
   {{ SC_(8.49681854248046875000000000000000000e-01), SC_(-6.13592378795146942138671875000000000e-03), SC_(1.00000047230599996454223624334618517e-03) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-1.96226930711418390274047851562500000e-04), SC_(1.00000016825872062333972517140815484e-03) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(1.96226872503757476806640625000000000e-04), SC_(-9.99000870733649279760826863678560906e-04) }},
   {{ SC_(1.38511943817138671875000000000000000e+00), SC_(3.06796096265316009521484375000000000e-03), SC_(9.99999540580773670971001797748013515e-04) }},
   {{ SC_(7.21959352493286132812500000000000000e-01), SC_(-3.06796189397573471069335937500000000e-03), SC_(1.00000005095189585889334932516360399e-03) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-1.72722502611577510833740234375000000e-04), SC_(1.00000024802860876042204981499154514e-03) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(1.72722444403916597366333007812500000e-04), SC_(-9.99000910038066739991671265851848111e-04) }},
   {{ SC_(1.91855621337890625000000000000000000e+00), SC_(1.53398048132658004760742187500000000e-03), SC_(9.99999825007761942183415899329609984e-04) }},
   {{ SC_(5.21225214004516601562500000000000000e-01), SC_(-1.53398094698786735534667968750000000e-03), SC_(1.00000032389031761184311303757370552e-03) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-1.54246517922729253768920898437500000e-04), SC_(1.00000002801818699965195555580386524e-03) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(1.54246517922729253768920898437500000e-04), SC_(-9.99001026963233568497158174140075262e-04) }},
   {{ SC_(9.99999284744262695312500000000000000e-01), SC_(1.60849511718750000000000000000000000e+03), SC_(-1.14982421741200221163837664225221219e-03) }},
   {{ SC_(1.00000047683715820312500000000000000e+00), SC_(-1.60849560546875000000000000000000000e+03), SC_(-7.66696228761923880461869988127166965e-04) }},
   {{ SC_(6.21698796749114990234375000000000000e-04), SC_(1.35513022541999816894531250000000000e-04), SC_(-9.99999742566875347137296572034616651e-04) }},
   {{ SC_(6.21698796749114990234375000000000000e-04), SC_(-1.35513080749660730361938476562500000e-04), SC_(1.00100117323276952226682230453060048e-03) }},
   {{ SC_(9.99998569488525390625000000000000000e-01), SC_(8.04247558593750000000000000000000000e+02), SC_(-1.14982462838512745037266659875339382e-03) }},
   {{ SC_(1.00000095367431640625000000000000000e+00), SC_(-8.04247802734375000000000000000000000e+02), SC_(-7.66696046037520984824171291534621959e-04) }},
   {{ SC_(1.24339759349822998046875000000000000e-03), SC_(1.49553641676902770996093750000000000e-04), SC_(-9.99999718469958402741113276641582269e-04) }},
   {{ SC_(1.24339759349822998046875000000000000e-03), SC_(-1.49553699884563684463500976562500000e-04), SC_(1.00100110870072344214133268239772855e-03) }},
   {{ SC_(9.99997377395629882812500000000000000e-01), SC_(4.02123779296875000000000000000000000e+02), SC_(-1.05405705501722737014465659528132447e-03) }},
   {{ SC_(1.00000238418579101562500000000000000e+00), SC_(-4.02123901367187500000000000000000000e+02), SC_(-9.58277507535265650228490517893254690e-04) }},
   {{ SC_(2.48679518699645996093750000000000000e-03), SC_(1.66840094607323408126831054687500000e-04), SC_(-9.99999750983394876961133625072264183e-04) }},
   {{ SC_(2.48679518699645996093750000000000000e-03), SC_(-1.66840152814984321594238281250000000e-04), SC_(1.00100110089242153830385802787814997e-03) }},
   {{ SC_(9.99994993209838867187500000000000000e-01), SC_(2.01061889648437500000000000000000000e+02), SC_(-1.00617068146472432429545320345717902e-03) }},
   {{ SC_(1.00000476837158203125000000000000000e+00), SC_(-2.01061950683593750000000000000000000e+02), SC_(-9.58276365731061608067476532881859599e-04) }},
   {{ SC_(4.97359037399291992187500000000000000e-03), SC_(1.88645033631473779678344726562500000e-04), SC_(-9.99999973984281436257624915301257135e-04) }},
   {{ SC_(4.97359037399291992187500000000000000e-03), SC_(-1.88645091839134693145751953125000000e-04), SC_(1.00100128395311685867552624308045671e-03) }},
   {{ SC_(9.99989986419677734375000000000000000e-01), SC_(1.00530944824218750000000000000000000e+02), SC_(-1.00617319905874487568051869210451113e-03) }},
   {{ SC_(1.00000953674316406250000000000000000e+00), SC_(-1.00530975341796875000000000000000000e+02), SC_(-9.58274082133538617937482653698357981e-04) }},
   {{ SC_(9.94718074798583984375000000000000000e-03), SC_(2.17006308957934379577636718750000000e-04), SC_(-9.99999899595833868710750325347627245e-04) }},
   {{ SC_(9.94718074798583984375000000000000000e-03), SC_(-2.17006367165595293045043945312500000e-04), SC_(1.00100116902880599948120051248196555e-03) }},
   {{ SC_(9.99979972839355468750000000000000000e-01), SC_(5.02654724121093750000000000000000000e+01), SC_(-1.00617823429718802448569124536361452e-03) }},
   {{ SC_(1.00001955032348632812500000000000000e+00), SC_(-5.02654876708984375000000000000000000e+01), SC_(-9.82214249662860168478812429210365710e-04) }},
   {{ SC_(1.98943614959716796875000000000000000e-02), SC_(2.55404389463365077972412109375000000e-04), SC_(-1.00000011577467905105540797089670890e-03) }},
   {{ SC_(1.98943614959716796875000000000000000e-02), SC_(-2.55404389463365077972412109375000000e-04), SC_(1.00100111700757721131802620972263635e-03) }},
   {{ SC_(9.99960184097290039062500000000000000e-01), SC_(2.51327362060546875000000000000000000e+01), SC_(-1.00020196591226500792437535904843739e-03) }},
   {{ SC_(1.00003957748413085937500000000000000e+00), SC_(-2.51327438354492187500000000000000000e+01), SC_(-9.94176565842492350241411011531409977e-04) }},
   {{ SC_(3.97887229919433593750000000000000000e-02), SC_(3.10312374494969844818115234375000000e-04), SC_(-1.00000005749362961273268507809344653e-03) }},
   {{ SC_(3.97887229919433593750000000000000000e-02), SC_(-3.10312374494969844818115234375000000e-04), SC_(1.00100105860979058742577547577836547e-03) }},
   {{ SC_(9.99920368194580078125000000000000000e-01), SC_(1.25663681030273437500000000000000000e+01), SC_(-1.00022186911153184234687137359868419e-03) }},
   {{ SC_(1.00007963180541992187500000000000000e+00), SC_(-1.25663719177246093750000000000000000e+01), SC_(-1.00014256610681471402782476869052947e-03) }},
   {{ SC_(7.95774459838867187500000000000000000e-02), SC_(3.95294628106057643890380859375000000e-04), SC_(-1.00000008174526229169294746654799233e-03) }},
   {{ SC_(7.95774459838867187500000000000000000e-02), SC_(-3.95294744521379470825195312500000000e-04), SC_(1.00100137785498409729911399210589242e-03) }},
   {{ SC_(9.99840736389160156250000000000000000e-01), SC_(6.28318405151367187500000000000000000e+00), SC_(-1.00026167867914137383507211526056180e-03) }},
   {{ SC_(1.00015926361083984375000000000000000e+00), SC_(-6.28318595886230468750000000000000000e+00), SC_(-1.00010276920079119053808584701386971e-03) }},
   {{ SC_(1.59154891967773437500000000000000000e-01), SC_(5.44378068298101425170898437500000000e-04), SC_(-9.99999808655723688803668673507629690e-04) }},
   {{ SC_(1.59154891967773437500000000000000000e-01), SC_(-5.44378301128745079040527343750000000e-04), SC_(1.00100123761597902116969697975171526e-03) }},
   {{ SC_(9.99681472778320312500000000000000000e-01), SC_(3.14159202575683593750000000000000000e+00), SC_(-1.00034131049331359787554725826104750e-03) }},
   {{ SC_(1.00031852722167968750000000000000000e+00), SC_(-3.14159297943115234375000000000000000e+00), SC_(-1.00002318805710736418316739901124423e-03) }},
   {{ SC_(3.18309783935546875000000000000000000e-01), SC_(8.74005490913987159729003906250000000e-04), SC_(-1.00000015285929833363981782062317919e-03) }},
   {{ SC_(3.18309783935546875000000000000000000e-01), SC_(-8.74005723744630813598632812500000000e-04), SC_(1.00100142096154320975816668299300959e-03) }},
   {{ SC_(9.99363183975219726562500000000000000e-01), SC_(1.57079601287841796875000000000000000e+00), SC_(-1.00012625407962856238724671527993050e-03) }},
   {{ SC_(1.00063705444335937500000000000000000e+00), SC_(-1.57079648971557617187500000000000000e+00), SC_(-9.99864076422025255717083752450722953e-04) }},
   {{ SC_(6.36619567871093750000000000000000000e-01), SC_(2.21554096788167953491210937500000000e-03), SC_(-1.00000036169138872720423769284541733e-03) }},
   {{ SC_(6.36619567871093750000000000000000000e-01), SC_(-2.21554189920425415039062500000000000e-03), SC_(1.00100178440731676158071661883703551e-03) }},
   {{ SC_(9.98726844787597656250000000000000000e-01), SC_(7.85398006439208984375000000000000000e-01), SC_(-1.00007023791845928242873920365770235e-03) }},
   {{ SC_(1.00127458572387695312500000000000000e+00), SC_(-7.85398244857788085937500000000000000e-01), SC_(-9.99919712083787939152775452517305724e-04) }},
   {{ SC_(1.27323913574218750000000000000000000e+00), SC_(-4.14175353944301605224609375000000000e-03), SC_(-9.99998857591324454070799944114039602e-04) }},
   {{ SC_(1.27323913574218750000000000000000000e+00), SC_(4.14175167679786682128906250000000000e-03), SC_(1.00099940590537976375194800855806927e-03) }},
   {{ SC_(9.97455358505249023437500000000000000e-01), SC_(3.92699003219604492187500000000000000e-01), SC_(-1.00005135687259575921335111675167817e-03) }},
   {{ SC_(1.00255060195922851562500000000000000e+00), SC_(-3.92699122428894042968750000000000000e-01), SC_(-9.99843775842774453616309519470488125e-04) }},
   {{ SC_(2.54647827148437500000000000000000000e+00), SC_(-1.07038393616676330566406250000000000e-03), SC_(-9.99999664269988441451096085314487029e-04) }},
   {{ SC_(2.54647827148437500000000000000000000e+00), SC_(1.07038393616676330566406250000000000e-03), SC_(1.00100066459852099775307256869443579e-03) }},
   {{ SC_(9.94917392730712890625000000000000000e-01), SC_(1.96349501609802246093750000000000000e-01), SC_(-1.00001182333026931660428587783930956e-03) }},
   {{ SC_(1.00510835647583007812500000000000000e+00), SC_(-1.96349561214447021484375000000000000e-01), SC_(-9.99970039477391950973576629077373391e-04) }},
   {{ SC_(5.09295654296875000000000000000000000e+00), SC_(-6.14611431956291198730468750000000000e-04), SC_(-1.00000011932666555765009996745117960e-03) }},
   {{ SC_(5.09295654296875000000000000000000000e+00), SC_(6.14611199125647544860839843750000000e-04), SC_(1.00100074117193778392767603925321725e-03) }},
   {{ SC_(9.89860534667968750000000000000000000e-01), SC_(9.81747508049011230468750000000000000e-02), SC_(-1.00002011544694156532327807710763766e-03) }},
   {{ SC_(1.01024293899536132812500000000000000e+00), SC_(-9.81747806072235107421875000000000000e-02), SC_(-9.99982731793253831755108099957333653e-04) }},
   {{ SC_(1.01859130859375000000000000000000000e+01), SC_(-4.31063235737383365631103515625000000e-04), SC_(-9.99999891890068522682826593044400615e-04) }},
   {{ SC_(1.01859130859375000000000000000000000e+01), SC_(4.31063235737383365631103515625000000e-04), SC_(1.00100089267452490967672711004226712e-03) }},
   {{ SC_(9.79824304580688476562500000000000000e-01), SC_(4.90873754024505615234375000000000000e-02), SC_(-9.99998770576574016954639271381983611e-04) }},
   {{ SC_(1.02059078216552734375000000000000000e+00), SC_(-4.90873903036117553710937500000000000e-02), SC_(-9.99982077152512681971062891862814008e-04) }},
   {{ SC_(2.03718261718750000000000000000000000e+01), SC_(-3.31934192217886447906494140625000000e-04), SC_(-1.00000006656167749634368555802656668e-03) }},
   {{ SC_(2.03718261718750000000000000000000000e+01), SC_(3.31934075802564620971679687500000000e-04), SC_(1.00100071645117989602911640001018031e-03) }},
   {{ SC_(9.60055589675903320312500000000000000e-01), SC_(2.45436877012252807617187500000000000e-02), SC_(-1.00000076701204131175346727592165190e-03) }},
   {{ SC_(1.04160594940185546875000000000000000e+00), SC_(-2.45436951518058776855468750000000000e-02), SC_(-9.99991605121154077357652642996637682e-04) }},
   {{ SC_(4.07436523437500000000000000000000000e+01), SC_(-2.69873067736625671386718750000000000e-04), SC_(-1.00000010567238000189359697504795067e-03) }},
   {{ SC_(4.07436523437500000000000000000000000e+01), SC_(2.69872951321303844451904296875000000e-04), SC_(1.00100067486649548725665398002643572e-03) }},
   {{ SC_(9.21706676483154296875000000000000000e-01), SC_(1.22718438506126403808593750000000000e-02), SC_(-1.00000154890544273407118628683215419e-03) }},
   {{ SC_(1.08494329452514648437500000000000000e+00), SC_(-1.22718475759029388427734375000000000e-02), SC_(-9.99995454895363778246755534662648953e-04) }},
   {{ SC_(8.14873046875000000000000000000000000e+01), SC_(-2.27363314479589462280273437500000000e-04), SC_(-9.99999935570546008301971863204268294e-04) }},
   {{ SC_(8.14873046875000000000000000000000000e+01), SC_(2.27363314479589462280273437500000000e-04), SC_(1.00100093644249455908088440237647936e-03) }},
   {{ SC_(8.49543333053588867187500000000000000e-01), SC_(6.13592192530632019042968750000000000e-03), SC_(-1.00000057064310344605883237686858439e-03) }},
   {{ SC_(1.17710256576538085937500000000000000e+00), SC_(-6.13592378795146942138671875000000000e-03), SC_(-9.99998649348185161259648860772609250e-04) }},
   {{ SC_(1.62974609375000000000000000000000000e+02), SC_(-1.96423265151679515838623046875000000e-04), SC_(-1.00000011323870347714042431890898104e-03) }},
   {{ SC_(1.62974609375000000000000000000000000e+02), SC_(1.96423206944018602371215820312500000e-04), SC_(1.00100081768352236643725633331137424e-03) }},
   {{ SC_(7.21724033355712890625000000000000000e-01), SC_(3.06796096265316009521484375000000000e-03), SC_(-9.99999897043377420546025310263682347e-04) }},
   {{ SC_(1.38557100296020507812500000000000000e+00), SC_(-3.06796189397573471069335937500000000e-03), SC_(-9.99999871767588927443401587090408300e-04) }},
   {{ SC_(3.25949218750000000000000000000000000e+02), SC_(-1.72895321156829595565795898437500000e-04), SC_(-1.00000021333194792122027028052413364e-03) }},
   {{ SC_(3.25949218750000000000000000000000000e+02), SC_(1.72895262949168682098388671875000000e-04), SC_(1.00100087759039107515581952412385259e-03) }},
   {{ SC_(5.20885467529296875000000000000000000e-01), SC_(1.53398048132658004760742187500000000e-03), SC_(-1.00000022888343192063902025187479547e-03) }},
   {{ SC_(1.91980695724487304687500000000000000e+00), SC_(-1.53398094698786735534667968750000000e-03), SC_(-9.99999834251370888077162510359476316e-04) }},
   {{ SC_(6.51898437500000000000000000000000000e+02), SC_(-1.54400884639471769332885742187500000e-04), SC_(-1.00000022604670791840437248148741412e-03) }},
   {{ SC_(6.51898437500000000000000000000000000e+02), SC_(1.54400826431810855865478515625000000e-04), SC_(1.00100084994375588205759230372873797e-03) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(3.83568826179926935883897027459443539e-04) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(1.35438494908157736063003540039062500e-05), SC_(9.99999760355865066714776050686155269e-05) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-1.35438531287945806980133056640625000e-05), SC_(-9.99900038969881244800847994007217878e-05) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(1.91766025985602312591246377002915662e-04) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(1.49471416079904884099960327148437500e-05), SC_(9.99999888892229566760154635860403138e-05) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-1.49471452459692955017089843750000000e-05), SC_(-9.99900142266516200832032591680171239e-05) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(9.58784166574107902621754484211725504e-05) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(1.66748359333723783493041992187500000e-05), SC_(9.99999879622817389101341875442597351e-05) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-1.66748432093299925327301025390625000e-05), SC_(-9.99900325923973681392491463587238956e-05) }},
   {{ SC_(1.00000047683715820312500000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(9.58783532603688599168337559412404538e-05) }},
   {{ SC_(9.99999523162841796875000000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(9.58784280875607194173304748944919215e-05) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(1.88541234820149838924407958984375000e-05), SC_(9.99999697180368218775938955963164608e-05) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-1.88541307579725980758666992187500000e-05), SC_(-9.99900093089955272920292761933884088e-05) }},
   {{ SC_(1.00000095367431640625000000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(9.58783304001086448921624979189791675e-05) }},
   {{ SC_(9.99998807907104492187500000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(1.19849514294292296053192297440755946e-04) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(2.16886983253061771392822265625000000e-05), SC_(9.99999969611557167765608961670254907e-05) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-2.16886983253061771392822265625000000e-05), SC_(-9.99899979616634044697992404083648353e-05) }},
   {{ SC_(1.00000190734863281250000000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(9.58782846796318188289369765874446086e-05) }},
   {{ SC_(9.99997854232788085937500000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(1.07863967953873738493804318091798565e-04) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(2.55263876169919967651367187500000000e-05), SC_(9.99999877734765371436135352890455895e-05) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-2.55263948929496109485626220703125000e-05), SC_(-9.99900172752142452469903172297284850e-05) }},
   {{ SC_(1.00000381469726562500000000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(9.58781932388525822103110913317389755e-05) }},
   {{ SC_(9.99995946884155273437500000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(1.01871317228927682126844210273663928e-04) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(3.10141622321680188179016113281250000e-05), SC_(9.99999691832833530759016908526275851e-05) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-3.10141767840832471847534179687500000e-05), SC_(-9.99900171025208509085683661581509760e-05) }},
   {{ SC_(1.00000762939453125000000000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(9.58780103579917675112373671358058194e-05) }},
   {{ SC_(9.99991893768310546875000000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(1.01871523688823118835337679236939331e-04) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(3.95077222492545843124389648437500000e-05), SC_(9.99999947261169950052858501932605975e-05) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-3.95077222492545843124389648437500000e-05), SC_(-9.99899957270716233820821391001848645e-05) }},
   {{ SC_(1.00001573562622070312500000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(9.88739455356505681023279065092486944e-05) }},
   {{ SC_(9.99984025955200195312500000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(1.00373732747578408923852969236600233e-04) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(5.44078793609514832496643066406250000e-05), SC_(9.99999825012335263808459537782982583e-05) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-5.44078939128667116165161132812500000e-05), SC_(-9.99900102465869315832489916951966461e-05) }},
   {{ SC_(1.00003147125244140625000000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(9.88731675938311558384626030198377953e-05) }},
   {{ SC_(9.99968051910400390625000000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(1.00374534494274112450100889565325124e-04) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(8.73524695634841918945312500000000000e-05), SC_(9.99999647182400910300371576393903743e-05) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-8.73524986673146486282348632812500000e-05), SC_(-9.99899990378828255806194929953306694e-05) }},
   {{ SC_(1.00006341934204101562500000000000000e+00), SC_(1.57079601287841796875000000000000000e+00), SC_(9.96206526776912663884681599475973258e-05) }},
   {{ SC_(9.99936342239379882812500000000000000e-01), SC_(-1.57079648971557617187500000000000000e+00), SC_(1.00001569561486641438505549171364463e-04) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(2.21432303078472614288330078125000000e-04), SC_(9.99999538724906872948936669555738217e-05) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-2.21432303078472614288330078125000000e-04), SC_(-9.99899548816148133885334643217462198e-05) }},
   {{ SC_(1.00012731552124023437500000000000000e+00), SC_(7.85398006439208984375000000000000000e-01), SC_(9.99919906237794402146539848336736155e-05) }},
   {{ SC_(9.99872684478759765625000000000000000e-01), SC_(-7.85398244857788085937500000000000000e-01), SC_(1.00004752962598619631043568210439086e-04) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-4.13947505876421928405761718750000000e-04), SC_(1.00000094448230218694843429834994254e-04) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(4.13947389461100101470947265625000000e-04), SC_(-9.99900673102259151690176220316528855e-05) }},
   {{ SC_(1.00025463104248046875000000000000000e+00), SC_(3.92699003219604492187500000000000000e-01), SC_(9.99856262547766684187879583398361518e-05) }},
   {{ SC_(9.99745368957519531250000000000000000e-01), SC_(-3.92699122428894042968750000000000000e-01), SC_(1.00011120575613463159452322624138479e-04) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-1.06979539850726723670959472656250000e-04), SC_(1.00000043884305568238079867126876155e-04) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(1.06979510746896266937255859375000000e-04), SC_(-9.99900176744547564128889247677964913e-05) }},
   {{ SC_(1.00050926208496093750000000000000000e+00), SC_(1.96349501609802246093750000000000000e-01), SC_(9.99729007566838814135823077764218899e-05) }},
   {{ SC_(9.99490737915039062500000000000000000e-01), SC_(-1.96349561214447021484375000000000000e-01), SC_(1.00023859045891072135718037815567929e-04) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-6.14273303654044866561889648437500000e-05), SC_(1.00000034477306838459800754663759897e-04) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(6.14273012615740299224853515625000000e-05), SC_(-9.99899880981162421431049834307646652e-05) }},
   {{ SC_(1.00101900100708007812500000000000000e+00), SC_(9.81747508049011230468750000000000000e-02), SC_(9.99942331127125144581293140471627477e-05) }},
   {{ SC_(9.98981952667236328125000000000000000e-01), SC_(-9.81747806072235107421875000000000000e-02), SC_(1.00002483183411207013749698456645361e-04) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-4.30826185038313269615173339843750000e-05), SC_(1.00000025052430225127809570405654701e-04) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(4.30826039519160985946655273437500000e-05), SC_(-9.99899922756119597320653815709202054e-05) }},
   {{ SC_(1.00203895568847656250000000000000000e+00), SC_(4.90873754024505615234375000000000000e-02), SC_(9.99900840092665318157409022477843879e-05) }},
   {{ SC_(9.97964859008789062500000000000000000e-01), SC_(-4.90873903036117553710937500000000000e-02), SC_(1.00006553661351059336348085442640462e-04) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-3.31751652993261814117431640625000000e-05), SC_(1.00000036865179709030846026775046997e-04) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(3.31751507474109530448913574218750000e-05), SC_(-9.99899940003887964768315758503697515e-05) }},
   {{ SC_(1.00408220291137695312500000000000000e+00), SC_(2.45436877012252807617187500000000000e-02), SC_(9.99933645656017435853977404319260117e-05) }},
   {{ SC_(9.95934009552001953125000000000000000e-01), SC_(-2.45436951518058776855468750000000000e-02), SC_(1.00002863224091781461980746396427848e-04) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-2.69724623649381101131439208984375000e-05), SC_(1.00000024982533495047477143743627758e-04) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(2.69724550889804959297180175781250000e-05), SC_(-9.99899990059730259295805171633415276e-05) }},
   {{ SC_(1.00818157196044921875000000000000000e+00), SC_(1.22718438506126403808593750000000000e-02), SC_(9.99994726933797249036910134945227598e-05) }},
   {{ SC_(9.91884708404541015625000000000000000e-01), SC_(-1.22718475759029388427734375000000000e-02), SC_(1.00000920311261176161235402412357575e-04) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-2.27238269872032105922698974609375000e-05), SC_(1.00000013197837473398010364376536031e-04) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(2.27238197112455964088439941406250000e-05), SC_(-9.99899821808283644181462928196999318e-05) }},
   {{ SC_(1.01642990112304687500000000000000000e+00), SC_(6.13592192530632019042968750000000000e-03), SC_(9.99983804319756268039884427304137705e-05) }},
   {{ SC_(9.83835220336914062500000000000000000e-01), SC_(-6.13592378795146942138671875000000000e-03), SC_(1.00001259809966607422660262889948457e-04) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-1.96315231733024120330810546875000000e-05), SC_(1.00000026750459019719061788942789794e-04) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(1.96315158973447978496551513671875000e-05), SC_(-9.99899906879345671853323421014039893e-05) }},
   {{ SC_(1.03313016891479492187500000000000000e+00), SC_(3.06796096265316009521484375000000000e-03), SC_(9.99996426820601108957037183028063993e-05) }},
   {{ SC_(9.67931985855102539062500000000000000e-01), SC_(-3.06796189397573471069335937500000000e-03), SC_(1.00000482926329027949839983568864442e-04) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-1.72800209838896989822387695312500000e-05), SC_(1.00000024924152599077722812151351845e-04) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(1.72800137079320847988128662109375000e-05), SC_(-9.99899838191881273766306833850577582e-05) }},
   {{ SC_(1.06735801696777343750000000000000000e+00), SC_(1.53398048132658004760742187500000000e-03), SC_(9.99997447976237993066310351909213192e-05) }},
   {{ SC_(9.36892509460449218750000000000000000e-01), SC_(-1.53398094698786735534667968750000000e-03), SC_(1.00000187822831858479696868771102950e-04) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-1.54315930558368563652038574218750000e-05), SC_(1.00000014395001493244662754839190761e-04) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(1.54315857798792421817779541015625000e-05), SC_(-9.99899682493373101281560838582653502e-05) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(1.60849511718750000000000000000000000e+03), SC_(-3.83421641175753459487634311811927075e-04) }},
   {{ SC_(6.21698796749114990234375000000000000e-04), SC_(1.35452064569108188152313232421875000e-05), SC_(-1.00000001650117118084159807845287946e-04) }},
   {{ SC_(6.21698796749114990234375000000000000e-04), SC_(-1.35452064569108188152313232421875000e-05), SC_(1.00010002650547201021615279504316808e-04) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(8.04247558593750000000000000000000000e+02), SC_(-1.91729200631064043148157838603109891e-04) }},
   {{ SC_(1.24339759349822998046875000000000000e-03), SC_(1.49486368172802031040191650390625000e-05), SC_(-9.99999994908775698084221342581281002e-05) }},
   {{ SC_(1.24339759349822998046875000000000000e-03), SC_(-1.49486404552590101957321166992187500e-05), SC_(1.00010024831052015703757705650510332e-04) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(4.02123779296875000000000000000000000e+02), SC_(-9.58691957668805158045843424425348682e-05) }},
   {{ SC_(2.48679518699645996093750000000000000e-03), SC_(1.66765021276660263538360595703125000e-05), SC_(-9.99999884213912537803745653237201021e-05) }},
   {{ SC_(2.48679518699645996093750000000000000e-03), SC_(-1.66765094036236405372619628906250000e-05), SC_(1.00010033055713858418718881241359220e-04) }},
   {{ SC_(9.99999523162841796875000000000000000e-01), SC_(2.01061889648437500000000000000000000e+02), SC_(-9.58692071948354818715280495324633221e-05) }},
   {{ SC_(1.00000047683715820312500000000000000e+00), SC_(-2.01061950683593750000000000000000000e+02), SC_(-9.58691905840707721697984018296054242e-05) }},
   {{ SC_(4.97359037399291992187500000000000000e-03), SC_(1.88560079550370573997497558593750000e-05), SC_(-9.99999740640513008881377606676796086e-05) }},
   {{ SC_(4.97359037399291992187500000000000000e-03), SC_(-1.88560152309946715831756591796875000e-05), SC_(1.00010013651688119060286092763718843e-04) }},
   {{ SC_(9.99998807907104492187500000000000000e-01), SC_(1.00530944824218750000000000000000000e+02), SC_(-1.19835115734066412249525839249095043e-04) }},
   {{ SC_(1.00000095367431640625000000000000000e+00), SC_(-1.00530975341796875000000000000000000e+02), SC_(-9.58691677281865969157381522724307123e-05) }},
   {{ SC_(9.94718074798583984375000000000000000e-03), SC_(2.16908665606752038002014160156250000e-05), SC_(-1.00000004837896050170437486357854445e-04) }},
   {{ SC_(9.94718074798583984375000000000000000e-03), SC_(-2.16908665606752038002014160156250000e-05), SC_(1.00010005838963784561119443585640127e-04) }},
   {{ SC_(9.99997854232788085937500000000000000e-01), SC_(5.02654724121093750000000000000000000e+01), SC_(-1.07852301834800485494358461831994292e-04) }},
   {{ SC_(1.00000190734863281250000000000000000e+00), SC_(-5.02654876708984375000000000000000000e+01), SC_(-9.58691220164618389121703195435918795e-05) }},
   {{ SC_(1.98943614959716796875000000000000000e-02), SC_(2.55289414781145751476287841796875000e-05), SC_(-1.00000005363610627756417304904394234e-04) }},
   {{ SC_(1.98943614959716796875000000000000000e-02), SC_(-2.55289414781145751476287841796875000e-05), SC_(1.00010006364783520841521596894501666e-04) }},
   {{ SC_(9.99995946884155273437500000000000000e-01), SC_(2.51327362060546875000000000000000000e+01), SC_(-1.01860909601009962702905890675443059e-04) }},
   {{ SC_(1.00000381469726562500000000000000000e+00), SC_(-2.51327438354492187500000000000000000e+01), SC_(-9.58690305931866924867418852826008341e-05) }},
   {{ SC_(3.97887229919433593750000000000000000e-02), SC_(3.10172617901116609573364257812500000e-05), SC_(-9.99999788560673631715545181120405011e-05) }},
   {{ SC_(3.97887229919433593750000000000000000e-02), SC_(-3.10172763420268893241882324218750000e-05), SC_(1.00010026774504178949836780144468516e-04) }},
   {{ SC_(9.99991893768310546875000000000000000e-01), SC_(1.25663681030273437500000000000000000e+01), SC_(-1.01861116018784446069442907084919831e-04) }},
   {{ SC_(1.00000762939453125000000000000000000e+00), SC_(-1.25663719177246093750000000000000000e+01), SC_(-9.58688477473338744707064477418856831e-05) }},
   {{ SC_(7.95774459838867187500000000000000000e-02), SC_(3.95116658182814717292785644531250000e-05), SC_(-9.99999965832329606274839901166974409e-05) }},
   {{ SC_(7.95774459838867187500000000000000000e-02), SC_(-3.95116803701967000961303710937500000e-05), SC_(1.00010034417587966352240704185411678e-04) }},
   {{ SC_(9.99984025955200195312500000000000000e-01), SC_(6.28318405151367187500000000000000000e+00), SC_(-1.00363628407247220996382116659585293e-04) }},
   {{ SC_(1.00001573562622070312500000000000000e+00), SC_(-6.28318595886230468750000000000000000e+00), SC_(-9.88642004551683594460931565297976566e-05) }},
   {{ SC_(1.59154891967773437500000000000000000e-01), SC_(5.44133217772468924522399902343750000e-05), SC_(-1.00000013345638135220706551211101185e-04) }},
   {{ SC_(1.59154891967773437500000000000000000e-01), SC_(-5.44133363291621208190917968750000000e-05), SC_(1.00010041095718350180953765555048189e-04) }},
   {{ SC_(9.99968051910400390625000000000000000e-01), SC_(3.14159202575683593750000000000000000e+00), SC_(-1.00364429992774585959317182391537390e-04) }},
   {{ SC_(1.00003147125244140625000000000000000e+00), SC_(-3.14159297943115234375000000000000000e+00), SC_(-9.88634226669257986165211145038137275e-05) }},
   {{ SC_(3.18309783935546875000000000000000000e-01), SC_(8.73612007126212120056152343750000000e-05), SC_(-1.00000005047935325169517278801223583e-04) }},
   {{ SC_(3.18309783935546875000000000000000000e-01), SC_(-8.73612298164516687393188476562500000e-05), SC_(1.00010039368410876341576535635118770e-04) }},
   {{ SC_(9.99936342239379882812500000000000000e-01), SC_(1.57079601287841796875000000000000000e+00), SC_(-9.99915398952023919454416831344080404e-05) }},
   {{ SC_(1.00006341934204101562500000000000000e+00), SC_(-1.57079648971557617187500000000000000e+00), SC_(-9.96107596285433017071905316087192726e-05) }},
   {{ SC_(6.36619567871093750000000000000000000e-01), SC_(2.21454421989619731903076171875000000e-04), SC_(-1.00000057777365558453310615239850539e-04) }},
   {{ SC_(6.36619567871093750000000000000000000e-01), SC_(-2.21454480197280645370483398437500000e-04), SC_(1.00010085077243283850630998298506577e-04) }},
   {{ SC_(9.99872684478759765625000000000000000e-01), SC_(7.85398006439208984375000000000000000e-01), SC_(-9.99947226587434400587402847798617720e-05) }},
   {{ SC_(1.00012731552124023437500000000000000e+00), SC_(-7.85398244857788085937500000000000000e-01), SC_(-9.99820235746691583867395289938322610e-05) }},
   {{ SC_(1.27323913574218750000000000000000000e+00), SC_(-4.13988949730992317199707031250000000e-04), SC_(-9.99998901046638682275114941723582658e-05) }},
   {{ SC_(1.27323913574218750000000000000000000e+00), SC_(4.13988833315670490264892578125000000e-04), SC_(1.00009862958200335788553783123035753e-04) }},
   {{ SC_(9.99745368957519531250000000000000000e-01), SC_(3.92699003219604492187500000000000000e-01), SC_(-1.00001088996393239502359835078522091e-04) }},
   {{ SC_(1.00025463104248046875000000000000000e+00), SC_(-3.92699122428894042968750000000000000e-01), SC_(-9.99756604762754557741986800713116291e-05) }},
   {{ SC_(2.54647827148437500000000000000000000e+00), SC_(-1.06990220956504344940185546875000000e-04), SC_(-9.99999718897175888204002784255443414e-05) }},
   {{ SC_(2.54647827148437500000000000000000000e+00), SC_(1.06990191852673888206481933593750000e-04), SC_(1.00009945677793852338675323699199909e-04) }},
   {{ SC_(9.99490737915039062500000000000000000e-01), SC_(1.96349501609802246093750000000000000e-01), SC_(-1.00013824915047662862033075808427757e-04) }},
   {{ SC_(1.00050926208496093750000000000000000e+00), SC_(-1.96349561214447021484375000000000000e-01), SC_(-9.99629375185111221662842925907835169e-05) }},
   {{ SC_(5.09295654296875000000000000000000000e+00), SC_(-6.14334712736308574676513671875000000e-05), SC_(-9.99999989958506712038725992385706575e-05) }},
   {{ SC_(5.09295654296875000000000000000000000e+00), SC_(6.14334421698004007339477539062500000e-05), SC_(1.00009952614093423742061185787790130e-04) }},
   {{ SC_(9.98981714248657226562500000000000000e-01), SC_(9.81747508049011230468750000000000000e-02), SC_(-1.00015881531780535364782546806512123e-04) }},
   {{ SC_(1.00101900100708007812500000000000000e+00), SC_(-9.81747806072235107421875000000000000e-02), SC_(-9.99842656158831303608070472464788236e-05) }},
   {{ SC_(1.01859130859375000000000000000000000e+01), SC_(-4.30869258707389235496520996093750000e-05), SC_(-1.00000000024031972521929798409399046e-04) }},
   {{ SC_(1.01859130859375000000000000000000000e+01), SC_(4.30869113188236951828002929687500000e-05), SC_(1.00009967245680815821017890502717417e-04) }},
   {{ SC_(9.97964620590209960937500000000000000e-01), SC_(4.90873754024505615234375000000000000e-02), SC_(-1.00008249034313822797104334625796227e-04) }},
   {{ SC_(1.00203895568847656250000000000000000e+00), SC_(-4.90873903036117553710937500000000000e-02), SC_(-9.99801173408091892585320136147357109e-05) }},
   {{ SC_(2.03718261718750000000000000000000000e+01), SC_(-3.31784831359982490539550781250000000e-05), SC_(-1.00000020039875802946595854309701964e-04) }},
   {{ SC_(2.03718261718750000000000000000000000e+01), SC_(3.31784685840830206871032714843750000e-05), SC_(1.00009977177900640414789484909986872e-04) }},
   {{ SC_(9.95933532714843750000000000000000000e-01), SC_(2.45436877012252807617187500000000000e-02), SC_(-1.00004583248677372625481182378613277e-04) }},
   {{ SC_(1.00408267974853515625000000000000000e+00), SC_(-2.45436951518058776855468750000000000e-02), SC_(-9.99950518386147311641943957093851148e-05) }},
   {{ SC_(4.07436523437500000000000000000000000e+01), SC_(-2.69751544692553579807281494140625000e-05), SC_(-9.99999913648547534000379700418964584e-05) }},
   {{ SC_(4.07436523437500000000000000000000000e+01), SC_(2.69751544692553579807281494140625000e-05), SC_(1.00009992363227475337403888193805137e-04) }},
   {{ SC_(9.91883993148803710937500000000000000e-01), SC_(1.22718438506126403808593750000000000e-02), SC_(-9.99997392148520143981181283380793632e-05) }},
   {{ SC_(1.00818204879760742187500000000000000e+00), SC_(-1.22718475759029388427734375000000000e-02), SC_(-9.99953077542296240068111335795059339e-05) }},
   {{ SC_(8.14873046875000000000000000000000000e+01), SC_(-2.27260970859788358211517333984375000e-05), SC_(-9.99999908066176430130766914909942700e-05) }},
   {{ SC_(8.14873046875000000000000000000000000e+01), SC_(2.27260970859788358211517333984375000e-05), SC_(1.00009991804878700788974210277472429e-04) }},
   {{ SC_(9.83833789825439453125000000000000000e-01), SC_(6.13592192530632019042968750000000000e-03), SC_(-1.00000151044500873027947367109194510e-04) }},
   {{ SC_(1.01643180847167968750000000000000000e+00), SC_(-6.13592378795146942138671875000000000e-03), SC_(-9.99999251141308039186512379952710363e-05) }},
   {{ SC_(1.62974609375000000000000000000000000e+02), SC_(-1.96334876818582415580749511718750000e-05), SC_(-1.00000022925900062865000379306783567e-04) }},
   {{ SC_(1.62974609375000000000000000000000000e+02), SC_(1.96334804059006273746490478515625000e-05), SC_(1.00009986866102403781849483456598463e-04) }},
   {{ SC_(9.67928886413574218750000000000000000e-01), SC_(3.06796096265316009521484375000000000e-03), SC_(-1.00000276512888911452741847719232472e-04) }},
   {{ SC_(1.03313350677490234375000000000000000e+00), SC_(-3.06796189397573471069335937500000000e-03), SC_(-9.99995851380483989486803651345626837e-05) }},
   {{ SC_(3.25949218750000000000000000000000000e+02), SC_(-1.72817453858442604541778564453125000e-05), SC_(-9.99999945866116546354999667481836581e-05) }},
   {{ SC_(3.25949218750000000000000000000000000e+02), SC_(1.72817453858442604541778564453125000e-05), SC_(1.00009995585628824573434111984223727e-04) }},
   {{ SC_(9.36886310577392578125000000000000000e-01), SC_(1.53398048132658004760742187500000000e-03), SC_(-1.00000306925362371134413918936904876e-04) }},
   {{ SC_(1.06736516952514648437500000000000000e+00), SC_(-1.53398094698786735534667968750000000e-03), SC_(-1.00000054619253407409056892154028432e-04) }},
   {{ SC_(6.51898437500000000000000000000000000e+02), SC_(-1.54331355588510632514953613281250000e-05), SC_(-1.00000001600418681153431834331150791e-04) }},
   {{ SC_(6.51898437500000000000000000000000000e+02), SC_(1.54331282828934490680694580078125000e-05), SC_(1.00009955448727511552750659519902406e-04) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(1.35444588522659614682197570800781250e-06), SC_(9.99999753163926947218802757430296097e-06) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-1.35444633997394703328609466552734375e-06), SC_(-9.99990089007944143270151875579535170e-06) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(1.49478137245750986039638519287109375e-06), SC_(9.99999856176970285974132637508040658e-06) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-1.49478182720486074686050415039062500e-06), SC_(-9.99990160498558042460722319678076621e-06) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(1.66755853570066392421722412109375000e-06), SC_(9.99999824069199501569612279284874293e-06) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-1.66755899044801481068134307861328125e-06), SC_(-9.99990096871060194156594091221140127e-06) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(4.79380592999406728168727470650370602e-05) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(1.88549756785505451261997222900390625e-06), SC_(9.99999897713654666233170781888140313e-06) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-1.88549802260240539908409118652343750e-06), SC_(-9.99990138993673282149131509761163509e-06) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(2.39687423996642256776446105470373821e-05) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(2.16896751226158812642097473144531250e-06), SC_(1.00000000781826042865488379466892431e-05) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-2.16896751226158812642097473144531250e-06), SC_(-9.99990007918103065801146219315579202e-06) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(1.19842993881162008376494057399068064e-05) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(2.55275335803162306547164916992187500e-06), SC_(9.99999772076713667678594888201752669e-06) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-2.55275426752632483839988708496093750e-06), SC_(-9.99990128455742065509839458342300360e-06) }},
   {{ SC_(9.99999523162841796875000000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(1.19843008167650881739726309920080305e-05) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(3.10155610350193455815315246582031250e-06), SC_(9.99999794960411553941029523870603911e-06) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-3.10155701299663633108139038085937500e-06), SC_(-9.99990088298243865345430122721622811e-06) }},
   {{ SC_(1.00000047683715820312500000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(5.99212777927770112763176030289680548e-06) }},
   {{ SC_(9.99999046325683593750000000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(1.19843036740642253195488625139423640e-05) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(3.95094866689760237932205200195312500e-06), SC_(9.99999608449719941318522299290534283e-06) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-3.95095048588700592517852783203125000e-06), SC_(-9.99990068943538152592895499936525247e-06) }},
   {{ SC_(1.00000143051147460937500000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(8.98820084757632451861076515354336377e-06) }},
   {{ SC_(9.99998331069946289062500000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(1.04862616106319297282789279775513506e-05) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(5.44103204447310417890548706054687500e-06), SC_(9.99999692440584935942986843579534978e-06) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-5.44103386346250772476196289062500000e-06), SC_(-9.99990026851246516573784058863985064e-06) }},
   {{ SC_(1.00000286102294921875000000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(8.98819441869900326954271473259637167e-06) }},
   {{ SC_(9.99996662139892578125000000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(1.04862703611182916534117342746828455e-05) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(8.73564204084686934947967529296875000e-06), SC_(9.99999877011585122085422463948827401e-06) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-8.73564204084686934947967529296875000e-06), SC_(-9.99989877114043853345691175448636302e-06) }},
   {{ SC_(1.00000619888305664062500000000000000e+00), SC_(1.57079601287841796875000000000000000e+00), SC_(9.73719801617775371771641564062439398e-06) }},
   {{ SC_(9.99993562698364257812500000000000000e-01), SC_(-1.57079648971557617187500000000000000e+00), SC_(1.01117744824527003209101305915373276e-05) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(2.21442242036573588848114013671875000e-05), SC_(9.99999424661034108954437672262361349e-06) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-2.21442314796149730682373046875000000e-05), SC_(-9.99989753338770943139447544148182739e-06) }},
   {{ SC_(1.00001239776611328125000000000000000e+00), SC_(7.85398006439208984375000000000000000e-01), SC_(9.73716783643554096236690777908012414e-06) }},
   {{ SC_(9.99987125396728515625000000000000000e-01), SC_(-7.85398244857788085937500000000000000e-01), SC_(1.01118070292027287432850276592858542e-05) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-4.13966190535575151443481445312500000e-05), SC_(1.00000108323462587521048475095168063e-05) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(4.13966045016422867774963378906250000e-05), SC_(-9.99990731793608247122949979766624586e-06) }},
   {{ SC_(1.00002527236938476562500000000000000e+00), SC_(3.92699003219604492187500000000000000e-01), SC_(9.92435810763970084257757698340874456e-06) }},
   {{ SC_(9.99974489212036132812500000000000000e-01), SC_(-3.92699122428894042968750000000000000e-01), SC_(1.00182420146587471008989746964815249e-05) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-1.06984334706794470548629760742187500e-05), SC_(1.00000026018965572103930825934006096e-05) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(1.06984298327006399631500244140625000e-05), SC_(-9.99989920241659264911157295062230115e-06) }},
   {{ SC_(1.00005054473876953125000000000000000e+00), SC_(1.96349501609802246093750000000000000e-01), SC_(9.92423270574921314495075057638778910e-06) }},
   {{ SC_(9.99948978424072265625000000000000000e-01), SC_(-1.96349561214447021484375000000000000e-01), SC_(1.00183698068128868061976981582344521e-05) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-6.14300915913190692663192749023437500e-06), SC_(1.00000029690687524738899385286207907e-05) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(6.14300734014250338077545166015625000e-06), SC_(-9.99990000898063489315243009043534846e-06) }},
   {{ SC_(1.00010156631469726562500000000000000e+00), SC_(9.81747508049011230468750000000000000e-02), SC_(9.97079100642905026779168486185840553e-06) }},
   {{ SC_(9.99897956848144531250000000000000000e-01), SC_(-9.81747806072235107421875000000000000e-02), SC_(1.00186254041626106703950307131809776e-05) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-4.30845648224931210279464721679687500e-06), SC_(1.00000042798042125201720885279698968e-05) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(4.30845466325990855693817138671875000e-06), SC_(-9.99990005887511223015375587524176612e-06) }},
   {{ SC_(1.00020360946655273437500000000000000e+00), SC_(4.90873754024505615234375000000000000e-02), SC_(9.99368689170008785464871692588071201e-06) }},
   {{ SC_(9.99796152114868164062500000000000000e-01), SC_(-4.90873903036117553710937500000000000e-02), SC_(1.00074308003895667383030230123620055e-05) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-3.31766477756900712847709655761718750e-06), SC_(1.00000005602693330598245344346438775e-05) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(3.31766477756900712847709655761718750e-06), SC_(-9.99990056125811784102800350388974043e-06) }},
   {{ SC_(1.00040721893310546875000000000000000e+00), SC_(2.45436877012252807617187500000000000e-02), SC_(9.99266979261782965457984600874710559e-06) }},
   {{ SC_(9.99592542648315429687500000000000000e-01), SC_(-2.45436951518058776855468750000000000e-02), SC_(1.00025969968121705556555874400632366e-05) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-2.69736756308702751994132995605468750e-06), SC_(1.00000023251734514256410465292424572e-05) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(2.69736665359232574701309204101562500e-06), SC_(-9.99989895439042252214516028345820967e-06) }},
   {{ SC_(1.00081491470336914062500000000000000e+00), SC_(1.22718438506126403808593750000000000e-02), SC_(9.99648338851457403913693242101239003e-06) }},
   {{ SC_(9.99185323715209960937500000000000000e-01), SC_(-1.22718475759029388427734375000000000e-02), SC_(1.00017078175001566876415964209818012e-05) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-2.27248528972268104553222656250000000e-06), SC_(1.00000027990236495820762823223788663e-05) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(2.27248438022797927260398864746093750e-06), SC_(-9.99989879782375962110873653297024770e-06) }},
   {{ SC_(1.00163078308105468750000000000000000e+00), SC_(6.13592192530632019042968750000000000e-03), SC_(9.99825740496058968449775682157114972e-06) }},
   {{ SC_(9.98371601104736328125000000000000000e-01), SC_(-6.13592378795146942138671875000000000e-03), SC_(9.99992562136264667956282380470945316e-06) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-1.96324072021525353193283081054687500e-06), SC_(1.00000029962935843744534956595857581e-05) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(1.96323981072055175900459289550781250e-06), SC_(-9.99989836468236487851217466645972922e-06) }},
   {{ SC_(1.00326442718505859375000000000000000e+00), SC_(3.06796096265316009521484375000000000e-03), SC_(9.99887380634047383885958096596007240e-06) }},
   {{ SC_(9.96745824813842773437500000000000000e-01), SC_(-3.06796189397573471069335937500000000e-03), SC_(1.00000151255278174893729187282831562e-05) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-1.72807949638809077441692352294921875e-06), SC_(1.00000004074291054132718050456371336e-05) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(1.72807949638809077441692352294921875e-06), SC_(-9.99990040842094695332464704139420941e-06) }},
   {{ SC_(1.00654029846191406250000000000000000e+00), SC_(1.53398048132658004760742187500000000e-03), SC_(1.00000741420293681236800445865085590e-05) }},
   {{ SC_(9.93502140045166015625000000000000000e-01), SC_(-1.53398094698786735534667968750000000e-03), SC_(1.00001683529088965656965385932661618e-05) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-1.54322879097890108823776245117187500e-06), SC_(1.00000017300399902997543624890459101e-05) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(1.54322833623155020177364349365234375e-06), SC_(-9.99989878432235356384405796659510261e-06) }},
   {{ SC_(6.21698796749114990234375000000000000e-04), SC_(1.35445952764712274074554443359375000e-06), SC_(-9.99999896017132899554197364315122596e-06) }},
   {{ SC_(6.21698796749114990234375000000000000e-04), SC_(-1.35445998239447362720966339111328125e-06), SC_(1.00001023186087430476224641961742909e-05) }},
   {{ SC_(1.24339759349822998046875000000000000e-03), SC_(1.49479637912008911371231079101562500e-06), SC_(-9.99999973385605614036916308630692914e-06) }},
   {{ SC_(1.24339759349822998046875000000000000e-03), SC_(-1.49479683386744000017642974853515625e-06), SC_(1.00001027770989478857444477579520104e-05) }},
   {{ SC_(2.48679518699645996093750000000000000e-03), SC_(1.66757536135264672338962554931640625e-06), SC_(-1.00000000090253265362453637921209637e-05) }},
   {{ SC_(2.48679518699645996093750000000000000e-03), SC_(-1.66757581609999760985374450683593750e-06), SC_(1.00001027370637255154156414232641277e-05) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(2.01061889648437500000000000000000000e+02), SC_(-4.79357468013509595166655000616044904e-05) }},
   {{ SC_(4.97359037399291992187500000000000000e-03), SC_(1.88551621249644085764884948730468750e-06), SC_(-9.99999884359833183834003302247328916e-06) }},
   {{ SC_(4.97359037399291992187500000000000000e-03), SC_(-1.88551666724379174411296844482421875e-06), SC_(1.00001012564034256916781396844776076e-05) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(1.00530944824218750000000000000000000e+02), SC_(-2.39681606370376411786454508716912363e-05) }},
   {{ SC_(9.94718074798583984375000000000000000e-03), SC_(2.16898843063972890377044677734375000e-06), SC_(-9.99999765185800793667495833383073361e-06) }},
   {{ SC_(9.94718074798583984375000000000000000e-03), SC_(-2.16898934013443067669868469238281250e-06), SC_(1.00001018460474863930421757218216249e-05) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(5.02654724121093750000000000000000000e+01), SC_(-1.19841521284699397446163080215716202e-05) }},
   {{ SC_(1.98943614959716796875000000000000000e-02), SC_(2.55277882388327270746231079101562500e-06), SC_(-9.99999880882223293048453443288824781e-06) }},
   {{ SC_(1.98943614959716796875000000000000000e-02), SC_(-2.55277973337797448039054870605468750e-06), SC_(1.00001023726148585494700150955151189e-05) }},
   {{ SC_(9.99999523162841796875000000000000000e-01), SC_(2.51327362060546875000000000000000000e+01), SC_(-1.19841535570841513117972076670986999e-05) }},
   {{ SC_(3.97887229919433593750000000000000000e-02), SC_(3.10158702632179483771324157714843750e-06), SC_(-9.99999926623527766759334655974352028e-06) }},
   {{ SC_(3.97887229919433593750000000000000000e-02), SC_(-3.10158793581649661064147949218750000e-06), SC_(1.00001021996170592158255552748720983e-05) }},
   {{ SC_(9.99999046325683593750000000000000000e-01), SC_(1.25663681030273437500000000000000000e+01), SC_(-1.19841564143139368737734335632040793e-05) }},
   {{ SC_(1.00000047683715820312500000000000000e+00), SC_(-1.25663719177246093750000000000000000e+01), SC_(-5.99209369287559787652714232266466586e-06) }},
   {{ SC_(7.95774459838867187500000000000000000e-02), SC_(3.95098868466448038816452026367187500e-06), SC_(-9.99999942920547843050764693965449045e-06) }},
   {{ SC_(7.95774459838867187500000000000000000e-02), SC_(-3.95099050365388393402099609375000000e-06), SC_(1.00001040341469815612053402224996295e-05) }},
   {{ SC_(9.99998331069946289062500000000000000e-01), SC_(6.28318405151367187500000000000000000e+00), SC_(-1.04861484669017053614680381101243158e-05) }},
   {{ SC_(1.00000143051147460937500000000000000e+00), SC_(-6.28318595886230468750000000000000000e+00), SC_(-8.98812278900560801134009707528958872e-06) }},
   {{ SC_(1.59154891967773437500000000000000000e-01), SC_(5.44108661415521055459976196289062500e-06), SC_(-1.00000000519676902587849233371555185e-05) }},
   {{ SC_(1.59154891967773437500000000000000000e-01), SC_(-5.44108843314461410045623779296875000e-06), SC_(1.00001033960816638819425931793149021e-05) }},
   {{ SC_(9.99996662139892578125000000000000000e-01), SC_(3.14159202575683593750000000000000000e+00), SC_(-1.04861572172018940697433934847270816e-05) }},
   {{ SC_(1.00000286102294921875000000000000000e+00), SC_(-3.14159297943115234375000000000000000e+00), SC_(-8.98811636024190172076788894345248909e-06) }},
   {{ SC_(3.18309783935546875000000000000000000e-01), SC_(8.73572935233823955059051513671875000e-06), SC_(-1.00000032700591717903245134722973860e-05) }},
   {{ SC_(3.18309783935546875000000000000000000e-01), SC_(-8.73572935233823955059051513671875000e-06), SC_(1.00001032711245839655847606919369496e-05) }},
   {{ SC_(9.99993562698364257812500000000000000e-01), SC_(1.57079601287841796875000000000000000e+00), SC_(-1.01116691659799544379881116664511874e-05) }},
   {{ SC_(1.00000619888305664062500000000000000e+00), SC_(-1.57079648971557617187500000000000000e+00), SC_(-9.73710615989558955734751108044851017e-06) }},
   {{ SC_(6.36619567871093750000000000000000000e-01), SC_(2.21444424823857843875885009765625000e-05), SC_(-1.00000043562361929519322121228832161e-05) }},
   {{ SC_(6.36619567871093750000000000000000000e-01), SC_(-2.21444497583433985710144042968750000e-05), SC_(1.00001076430551465244471141715874291e-05) }},
   {{ SC_(9.99987125396728515625000000000000000e-01), SC_(7.85398006439208984375000000000000000e-01), SC_(-1.01117017120619012719481056799766197e-05) }},
   {{ SC_(1.00001239776611328125000000000000000e+00), SC_(-7.85398244857788085937500000000000000e-01), SC_(-9.73707598073193834266054681334662572e-06) }},
   {{ SC_(1.27323913574218750000000000000000000e+00), SC_(-4.13970265071839094161987304687500000e-05), SC_(-9.99998768810473941229147590515925141e-06) }},
   {{ SC_(1.27323913574218750000000000000000000e+00), SC_(4.13970119552686810493469238281250000e-05), SC_(1.00000841736022635319540361912662050e-05) }},
   {{ SC_(9.99974489212036132812500000000000000e-01), SC_(3.92699003219604492187500000000000000e-01), SC_(-1.00181386093599216979385624415957287e-05) }},
   {{ SC_(1.00002527236938476562500000000000000e+00), SC_(-3.92699122428894042968750000000000000e-01), SC_(-9.92426262836655387817113607917108063e-06) }},
   {{ SC_(2.54647827148437500000000000000000000e+00), SC_(-1.06985426100436598062515258789062500e-05), SC_(-9.99999904107128134665495297189153737e-06) }},
   {{ SC_(2.54647827148437500000000000000000000e+00), SC_(1.06985389720648527145385742187500000e-05), SC_(1.00000956415580815018453885614276307e-05) }},
   {{ SC_(9.99948978424072265625000000000000000e-01), SC_(1.96349501609802246093750000000000000e-01), SC_(-1.00182663989147861716920805952698048e-05) }},
   {{ SC_(1.00005054473876953125000000000000000e+00), SC_(-1.96349561214447021484375000000000000e-01), SC_(-9.92413722892701357033017310155847949e-06) }},
   {{ SC_(5.09295654296875000000000000000000000e+00), SC_(-6.14307100477162748575210571289062500e-06), SC_(-1.00000004440613460804530364834831098e-05) }},
   {{ SC_(5.09295654296875000000000000000000000e+00), SC_(6.14306918578222393989562988281250000e-06), SC_(1.00000974839832370114766652950619944e-05) }},
   {{ SC_(9.99897956848144531250000000000000000e-01), SC_(9.81747508049011230468750000000000000e-02), SC_(-1.00185219910655963212211166016664826e-05) }},
   {{ SC_(1.00010156631469726562500000000000000e+00), SC_(-9.81747806072235107421875000000000000e-02), SC_(-9.97069461747517908550921101260644711e-06) }},
   {{ SC_(1.01859130859375000000000000000000000e+01), SC_(-4.30849831900559365749359130859375000e-06), SC_(-9.99999913812153482450098792324797351e-06) }},
   {{ SC_(1.01859130859375000000000000000000000e+01), SC_(4.30849831900559365749359130859375000e-06), SC_(1.00000991391043069974733486076245963e-05) }},
   {{ SC_(9.99796152114868164062500000000000000e-01), SC_(4.90873754024505615234375000000000000e-02), SC_(-1.00073276148711254979750663934275321e-05) }},
   {{ SC_(1.00020360946655273437500000000000000e+00), SC_(-4.90873903036117553710937500000000000e-02), SC_(-9.99359005259882444443046296607591329e-06) }},
   {{ SC_(2.03718261718750000000000000000000000e+01), SC_(-3.31769842887297272682189941406250000e-06), SC_(-1.00000002617073265966091427746788616e-05) }},
   {{ SC_(2.03718261718750000000000000000000000e+01), SC_(3.31769751937827095389366149902343750e-06), SC_(1.00000975213290856725443510165957462e-05) }},
   {{ SC_(9.99592542648315429687500000000000000e-01), SC_(2.45436877012252807617187500000000000e-02), SC_(-1.00024939094841460653169866660853534e-05) }},
   {{ SC_(1.00040721893310546875000000000000000e+00), SC_(-2.45436951518058776855468750000000000e-02), SC_(-9.99257297353562114232023011964438470e-06) }},
   {{ SC_(4.07436523437500000000000000000000000e+01), SC_(-2.69739484792808070778846740722656250e-06), SC_(-1.00000020727107645902069827832077778e-05) }},
   {{ SC_(4.07436523437500000000000000000000000e+01), SC_(2.69739393843337893486022949218750000e-06), SC_(1.00000987019487518100554459074182168e-05) }},
   {{ SC_(9.99185323715209960937500000000000000e-01), SC_(1.22718438506126403808593750000000000e-02), SC_(-1.00016047482291939929284199715500708e-05) }},
   {{ SC_(1.00081491470336914062500000000000000e+00), SC_(-1.22718475759029388427734375000000000e-02), SC_(-9.99638649436059160367424975606864235e-06) }},
   {{ SC_(8.14873046875000000000000000000000000e+01), SC_(-2.27250802709022536873817443847656250e-06), SC_(-1.00000016694461543147819469223569497e-05) }},
   {{ SC_(8.14873046875000000000000000000000000e+01), SC_(2.27250711759552359580993652343750000e-06), SC_(1.00000976682560836545282232461137639e-05) }},
   {{ SC_(9.98371601104736328125000000000000000e-01), SC_(6.13592192530632019042968750000000000e-03), SC_(-9.99982258827897733952465332326517636e-06) }},
   {{ SC_(1.00163078308105468750000000000000000e+00), SC_(-6.13592378795146942138671875000000000e-03), SC_(-9.99816047587465158488997404366032348e-06) }},
   {{ SC_(1.62974609375000000000000000000000000e+02), SC_(-1.96325981960399076342582702636718750e-06), SC_(-9.99999925782929500981743351126131615e-06) }},
   {{ SC_(1.62974609375000000000000000000000000e+02), SC_(1.96325981960399076342582702636718750e-06), SC_(1.00000992588144613737142845231542023e-05) }},
   {{ SC_(9.96745824813842773437500000000000000e-01), SC_(3.06796096265316009521484375000000000e-03), SC_(-9.99991209062692757886454671710156206e-06) }},
   {{ SC_(1.00326442718505859375000000000000000e+00), SC_(-3.06796189397573471069335937500000000e-03), SC_(-9.99877686511557300231358394083473407e-06) }},
   {{ SC_(3.25949218750000000000000000000000000e+02), SC_(-1.72809677678742446005344390869140625e-06), SC_(-9.99999950418899668887093371756590030e-06) }},
   {{ SC_(3.25949218750000000000000000000000000e+02), SC_(1.72809677678742446005344390869140625e-06), SC_(1.00000995051790903204052638001157359e-05) }},
   {{ SC_(9.93502140045166015625000000000000000e-01), SC_(1.53398048132658004760742187500000000e-03), SC_(-1.00000653148969639773141972617453785e-05) }},
   {{ SC_(1.00654029846191406250000000000000000e+00), SC_(-1.53398094698786735534667968750000000e-03), SC_(-9.99997717716374418340661748533369767e-06) }},
   {{ SC_(6.51898437500000000000000000000000000e+02), SC_(-1.54324425238883122801780700683593750e-06), SC_(-1.00000011141013659349343279150099503e-05) }},
   {{ SC_(6.51898437500000000000000000000000000e+02), SC_(1.54324379764148034155368804931640625e-06), SC_(1.00000981683819345526330138427197741e-05) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(1.35445191062899539247155189514160156e-07), SC_(9.99999701786412772183272756625510413e-07) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-1.35445247906318400055170059204101563e-07), SC_(-9.99999121465638194519465994918877487e-07) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(1.49478807998093543574213981628417969e-07), SC_(9.99999843482130998502893412102698784e-07) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-1.49478864841512404382228851318359375e-07), SC_(-9.99999223760256913901302111833636726e-07) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(1.66756592534511582925915718078613281e-07), SC_(9.99999755496103374356071115563851458e-07) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-1.66756649377930443733930587768554688e-07), SC_(-9.99999096373589145607540710116933676e-07) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(1.88550586699420819059014320373535156e-07), SC_(9.99999799289515576596734297333096908e-07) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-1.88550643542839679867029190063476563e-07), SC_(-9.99999100766097645223517356591152846e-07) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(2.16897717564279446378350257873535156e-07), SC_(9.99999963119797447969406242921935959e-07) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-2.16897717564279446378350257873535156e-07), SC_(-9.99998963120871207262510698713145148e-07) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(2.55276518146274611353874206542968750e-07), SC_(9.99999903726335045974362521324198475e-07) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-2.55276518146274611353874206542968750e-07), SC_(-9.99998903727527592006182372072376566e-07) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(5.99213174123669825065206157054828829e-06) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(3.10157020066981203854084014892578125e-07), SC_(9.99999840163608083171619581582358861e-07) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-3.10157133753818925470113754272460938e-07), SC_(-9.99999206710392357366510397267545374e-07) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(2.99606138242644549179419920174814544e-06) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(3.95096776628633961081504821777343750e-07), SC_(9.99999942587795672206648594327011049e-07) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-3.95096776628633961081504821777343750e-07), SC_(-9.99998942588910495439772646376659949e-07) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(1.49802956916692769667159358783156784e-06) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(5.44105660083005204796791076660156250e-07), SC_(9.99999705632402039252873667469798152e-07) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-5.44105887456680648028850555419921875e-07), SC_(-9.99999123518391050836323257611331451e-07) }},
   {{ SC_(9.99999523162841796875000000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(1.49802974774616598632886207721939759e-06) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(8.73568069437169469892978668212890625e-07), SC_(9.99999801829350200469125112471515247e-07) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-8.73568069437169469892978668212890625e-07), SC_(-9.99998801830746540134942528875913634e-07) }},
   {{ SC_(1.00000047683715820312500000000000000e+00), SC_(1.57079601287841796875000000000000000e+00), SC_(7.49014008829822163292341084028919460e-07) }},
   {{ SC_(9.99999284744262695312500000000000000e-01), SC_(-1.57079648971557617187500000000000000e+00), SC_(1.12352223436044646007795187125708454e-06) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(2.21443224290851503610610961914062500e-06), SC_(9.99999360387625616479560148221086748e-07) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-2.21443315240321680903434753417968750e-06), SC_(-9.99998771101390241253785528286165575e-07) }},
   {{ SC_(1.00000095367431640625000000000000000e+00), SC_(7.85398006439208984375000000000000000e-01), SC_(7.49013830251027301422109658038553963e-07) }},
   {{ SC_(9.99998569488525390625000000000000000e-01), SC_(-7.85398244857788085937500000000000000e-01), SC_(1.12352263616396532358680080360899784e-06) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-4.13967973145190626382827758789062500e-06), SC_(1.00000088941280900165426969165765921e-06) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(4.13967791246250271797180175781250000e-06), SC_(-9.99999450008885273446512680451755667e-07) }},
   {{ SC_(1.00000238418579101562500000000000000e+00), SC_(3.92699003219604492187500000000000000e-01), SC_(9.36266705803656534008419650391288946e-07) }},
   {{ SC_(9.99997377395629882812500000000000000e-01), SC_(-3.92699122428894042968750000000000000e-01), SC_(1.02989631547123186711541297880124108e-06) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-1.06984816738986410200595855712890625e-06), SC_(1.00000026583236566685223831276654350e-06) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(1.06984816738986410200595855712890625e-06), SC_(-9.99999265832834001847735007325440833e-07) }},
   {{ SC_(1.00000476837158203125000000000000000e+00), SC_(1.96349501609802246093750000000000000e-01), SC_(9.36265589690237285786646445964980248e-07) }},
   {{ SC_(9.99994754791259765625000000000000000e-01), SC_(-1.96349561214447021484375000000000000e-01), SC_(1.02989766598252895601286492388404272e-06) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-6.14303644397296011447906494140625000e-07), SC_(1.00000023852465055161879872496497704e-06) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(6.14303417023620568215847015380859375e-07), SC_(-9.99998868393251461498188267785149111e-07) }},
   {{ SC_(1.00001001358032226562500000000000000e+00), SC_(9.81747508049011230468750000000000000e-02), SC_(9.83076313976309512728338676609219135e-07) }},
   {{ SC_(9.99989748001098632812500000000000000e-01), SC_(-9.81747806072235107421875000000000000e-02), SC_(1.00649340873225056348043984410760317e-06) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-4.30847535426437389105558395385742188e-07), SC_(1.00000030821587764297704464827145460e-06) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(4.30847421739599667489528656005859375e-07), SC_(-9.99999044348667958966981670118406868e-07) }},
   {{ SC_(1.00002002716064453125000000000000000e+00), SC_(4.90873754024505615234375000000000000e-02), SC_(9.83071391991003648152763440785058712e-07) }},
   {{ SC_(9.99979496002197265625000000000000000e-01), SC_(-4.90873903036117553710937500000000000e-02), SC_(1.00649856809884806850791421721720019e-06) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-3.31767978423158638179302215576171875e-07), SC_(1.00000007929775171291054299827830356e-06) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(3.31767978423158638179302215576171875e-07), SC_(-9.99999079298593116638723000577068917e-07) }},
   {{ SC_(1.00004053115844726562500000000000000e+00), SC_(2.45436877012252807617187500000000000e-02), SC_(9.94764430545203709285666719365453530e-07) }},
   {{ SC_(9.99959230422973632812500000000000000e-01), SC_(-2.45436951518058776855468750000000000e-02), SC_(1.00065696896916326577255443009525478e-06) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-2.69737938651815056800842285156250000e-07), SC_(1.00000011584943913390258760743035891e-06) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(2.69737824964977335184812545776367188e-07), SC_(-9.99998694379349718423601693877702493e-07) }},
   {{ SC_(1.00008153915405273437500000000000000e+00), SC_(1.22718438506126403808593750000000000e-02), SC_(1.00059547356205930735964544201235373e-06) }},
   {{ SC_(9.99918460845947265625000000000000000e-01), SC_(-1.22718475759029388427734375000000000e-02), SC_(1.00067736840757630589040827509454249e-06) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-2.27249529416440054774284362792968750e-07), SC_(1.00000018233506198565202408569384413e-06) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(2.27249472573021193966269493103027344e-07), SC_(-9.99998932199452341167731827303278685e-07) }},
   {{ SC_(1.00016260147094726562500000000000000e+00), SC_(6.13592192530632019042968750000000000e-03), SC_(9.97629322544859125708676734004695183e-07) }},
   {{ SC_(9.99836921691894531250000000000000000e-01), SC_(-6.13592378795146942138671875000000000e-03), SC_(1.00071817061155039051510427515150003e-06) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-1.96324947410175809636712074279785156e-07), SC_(1.00000025853482011233500682082217164e-06) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(1.96324890566756948828697204589843750e-07), SC_(-9.99998968998241952607103218800924585e-07) }},
   {{ SC_(1.00032567977905273437500000000000000e+00), SC_(3.06796096265316009521484375000000000e-03), SC_(9.99010677591770848130427206353930491e-07) }},
   {{ SC_(9.99674081802368164062500000000000000e-01), SC_(-3.06796189397573471069335937500000000e-03), SC_(1.00006808992261227647761213587036428e-06) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-1.72808768184040673077106475830078125e-07), SC_(1.00000027748594882077450749140643506e-06) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(1.72808711340621812269091606140136719e-07), SC_(-9.99998948548516642899140292594910396e-07) }},
   {{ SC_(1.00065183639526367187500000000000000e+00), SC_(1.53398048132658004760742187500000000e-03), SC_(9.99579061469389364023297983986571884e-07) }},
   {{ SC_(9.99348163604736328125000000000000000e-01), SC_(-1.53398094698786735534667968750000000e-03), SC_(1.00023113991313061898420748644466604e-06) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-1.54323572587600210681557655334472656e-07), SC_(1.00000016677198778615948892237820525e-06) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(1.54323515744181349873542785644531250e-07), SC_(-9.99998798433960919938673392233459889e-07) }},
   {{ SC_(6.21698796749114990234375000000000000e-04), SC_(1.35445361593156121671199798583984375e-07), SC_(-1.00000003139704765545826853294077075e-06) }},
   {{ SC_(6.21698796749114990234375000000000000e-04), SC_(-1.35445361593156121671199798583984375e-07), SC_(1.00000103139811045064875749559236792e-06) }},
   {{ SC_(1.24339759349822998046875000000000000e-03), SC_(1.49478978528350125998258590698242188e-07), SC_(-1.00000006220249329844127343365980963e-06) }},
   {{ SC_(1.24339759349822998046875000000000000e-03), SC_(-1.49478978528350125998258590698242188e-07), SC_(1.00000106220361770461834820669330158e-06) }},
   {{ SC_(2.48679518699645996093750000000000000e-03), SC_(1.66756763064768165349960327148437500e-07), SC_(-9.99999865017082169029841545615719841e-07) }},
   {{ SC_(2.48679518699645996093750000000000000e-03), SC_(-1.66756819908187026157975196838378906e-07), SC_(1.00000120589452034102820368475916752e-06) }},
   {{ SC_(4.97359037399291992187500000000000000e-03), SC_(1.88550757229677401483058929443359375e-07), SC_(-9.99999801964096551602235506705693197e-07) }},
   {{ SC_(4.97359037399291992187500000000000000e-03), SC_(-1.88550814073096262291073799133300781e-07), SC_(1.00000110344051369978284489734431777e-06) }},
   {{ SC_(9.94718074798583984375000000000000000e-03), SC_(2.16897888094536028802394866943359375e-07), SC_(-9.99999862362365902613200684151455974e-07) }},
   {{ SC_(9.94718074798583984375000000000000000e-03), SC_(-2.16897944937954889610409736633300781e-07), SC_(1.00000112443800892985395103861076500e-06) }},
   {{ SC_(1.98943614959716796875000000000000000e-02), SC_(2.55276745519950054585933685302734375e-07), SC_(-9.99999927438090710586701948825018012e-07) }},
   {{ SC_(1.98943614959716796875000000000000000e-02), SC_(-2.55276859206787776201963424682617188e-07), SC_(1.00000137278699235612781890348932225e-06) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(2.51327362060546875000000000000000000e+01), SC_(-5.99209401683032313918659602184119771e-06) }},
   {{ SC_(3.97887229919433593750000000000000000e-02), SC_(3.10157361127494368702173233032226563e-07), SC_(-1.00000010141418626424255353875084366e-06) }},
   {{ SC_(3.97887229919433593750000000000000000e-02), SC_(-3.10157361127494368702173233032226563e-07), SC_(1.00000110141538909392961085633911371e-06) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(1.25663681030273437500000000000000000e+01), SC_(-2.99605149657744664157218052015015016e-06) }},
   {{ SC_(7.95774459838867187500000000000000000e-02), SC_(3.95097117689147125929594039916992188e-07), SC_(-1.00000001169260355715031909728403168e-06) }},
   {{ SC_(7.95774459838867187500000000000000000e-02), SC_(-3.95097231375984847545623779296875000e-07), SC_(1.00000129943809404133462963271184082e-06) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(6.28318405151367187500000000000000000e+00), SC_(-1.49802687033097543759463914162504734e-06) }},
   {{ SC_(1.59154891967773437500000000000000000e-01), SC_(5.44106114830356091260910034179687500e-07), SC_(-9.99999824918705959177480119250819018e-07) }},
   {{ SC_(1.59154891967773437500000000000000000e-01), SC_(-5.44106342204031534492969512939453125e-07), SC_(1.00000124280471032229534824184768618e-06) }},
   {{ SC_(9.99999523162841796875000000000000000e-01), SC_(3.14159202575683593750000000000000000e+00), SC_(-1.49802704890962448449140820756703459e-06) }},
   {{ SC_(3.18309783935546875000000000000000000e-01), SC_(8.73568978931871242821216583251953125e-07), SC_(-1.00000029814353581053271986945907734e-06) }},
   {{ SC_(3.18309783935546875000000000000000000e-01), SC_(-8.73568978931871242821216583251953125e-07), SC_(1.00000129814513209958766356952191846e-06) }},
   {{ SC_(9.99999284744262695312500000000000000e-01), SC_(1.57079601287841796875000000000000000e+00), SC_(-1.12352063099940163186272732549003514e-06) }},
   {{ SC_(1.00000047683715820312500000000000000e+00), SC_(-1.57079648971557617187500000000000000e+00), SC_(-7.49013675181707880197863921998255229e-07) }},
   {{ SC_(6.36619567871093750000000000000000000e-01), SC_(2.21443497139262035489082336425781250e-06), SC_(-1.00000074639405519494502457352287906e-06) }},
   {{ SC_(6.36619567871093750000000000000000000e-01), SC_(-2.21443497139262035489082336425781250e-06), SC_(1.00000174639654798685170637168418392e-06) }},
   {{ SC_(9.99998569488525390625000000000000000e-01), SC_(7.85398006439208984375000000000000000e-01), SC_(-1.12352103280189565371233597430356783e-06) }},
   {{ SC_(1.00000095367431640625000000000000000e+00), SC_(-7.85398244857788085937500000000000000e-01), SC_(-7.49013496603126324057528148101905020e-07) }},
   {{ SC_(1.27323913574218750000000000000000000e+00), SC_(-4.13968518842011690139770507812500000e-06), SC_(-9.99999050566801309626641174087155203e-07) }},
   {{ SC_(1.27323913574218750000000000000000000e+00), SC_(4.13968336943071335554122924804687500e-06), SC_(9.99999611162826549694125622618122690e-07) }},
   {{ SC_(9.99997377395629882812500000000000000e-01), SC_(3.92699003219604492187500000000000000e-01), SC_(-1.02989494214701192829411517507746192e-06) }},
   {{ SC_(1.00000238418579101562500000000000000e+00), SC_(-3.92699122428894042968750000000000000e-01), SC_(-9.36266113425622252767741979621691988e-07) }},
   {{ SC_(2.54647827148437500000000000000000000e+00), SC_(-1.06984953163191676139831542968750000e-06), SC_(-9.99999983541152036761693550688098052e-07) }},
   {{ SC_(2.54647827148437500000000000000000000e+00), SC_(1.06984907688456587493419647216796875e-06), SC_(1.00000055848419080562240876054651252e-06) }},
   {{ SC_(9.99994754791259765625000000000000000e-01), SC_(1.96349501609802246093750000000000000e-01), SC_(-1.02989629265511728119496187024810743e-06) }},
   {{ SC_(1.00000476837158203125000000000000000e+00), SC_(-1.96349561214447021484375000000000000e-01), SC_(-9.36264997313954149104926489478032940e-07) }},
   {{ SC_(5.09295654296875000000000000000000000e+00), SC_(-6.14304326518322341144084930419921875e-07), SC_(-1.00000002882703101375150834953509834e-06) }},
   {{ SC_(5.09295654296875000000000000000000000e+00), SC_(6.14304099144646897912025451660156250e-07), SC_(1.00000065869554484110483913889860360e-06) }},
   {{ SC_(9.99989748001098632812500000000000000e-01), SC_(9.81747508049011230468750000000000000e-02), SC_(-1.00649209016965331506485800099420798e-06) }},
   {{ SC_(1.00001001358032226562500000000000000e+00), SC_(-9.81747806072235107421875000000000000e-02), SC_(-9.83075645964381981237418710999808557e-07) }},
   {{ SC_(1.01859130859375000000000000000000000e+01), SC_(-4.30847876486950553953647613525390625e-07), SC_(-9.99999875318292970869010055579680386e-07) }},
   {{ SC_(1.01859130859375000000000000000000000e+01), SC_(4.30847876486950553953647613525390625e-07), SC_(1.00000087531904360809645274849032064e-06) }},
   {{ SC_(9.99979496002197265625000000000000000e-01), SC_(4.90873754024505615234375000000000000e-02), SC_(-1.00649724952429887932591209196082041e-06) }},
   {{ SC_(1.00002002716064453125000000000000000e+00), SC_(-4.90873903036117553710937500000000000e-02), SC_(-9.83070723987259319251581065914897623e-07) }},
   {{ SC_(2.03718261718750000000000000000000000e+01), SC_(-3.31768319483671803027391433715820313e-07), SC_(-9.99999934432640730025420267624921433e-07) }},
   {{ SC_(2.03718261718750000000000000000000000e+01), SC_(3.31768319483671803027391433715820313e-07), SC_(1.00000093443350959611447806988566727e-06) }},
   {{ SC_(9.99959230422973632812500000000000000e-01), SC_(2.45436877012252807617187500000000000e-02), SC_(-1.00065566389288792449533022719334985e-06) }},
   {{ SC_(1.00004053115844726562500000000000000e+00), SC_(-2.45436951518058776855468750000000000e-02), SC_(-9.94763742964158462839301031966764943e-07) }},
   {{ SC_(4.07436523437500000000000000000000000e+01), SC_(-2.69738279712328221648931503295898438e-07), SC_(-1.00000023971097827833846918618230347e-06) }},
   {{ SC_(4.07436523437500000000000000000000000e+01), SC_(2.69738166025490500032901763916015625e-07), SC_(1.00000081824081628222042169375805592e-06) }},
   {{ SC_(9.99918460845947265625000000000000000e-01), SC_(1.22718438506126403808593750000000000e-02), SC_(-1.00067606328428241419620974753052609e-06) }},
   {{ SC_(1.00008153915405273437500000000000000e+00), SC_(-1.22718475759029388427734375000000000e-02), SC_(-1.00059477611609162109615505947239035e-06) }},
   {{ SC_(8.14873046875000000000000000000000000e+01), SC_(-2.27249756790115498006343841552734375e-07), SC_(-1.00000006446825564414814794892921566e-06) }},
   {{ SC_(8.14873046875000000000000000000000000e+01), SC_(2.27249699946696637198328971862792969e-07), SC_(1.00000081433266895430065116318400745e-06) }},
   {{ SC_(9.99836921691894531250000000000000000e-01), SC_(6.13592192530632019042968750000000000e-03), SC_(-1.00071686539420923210904527618609230e-06) }},
   {{ SC_(1.00016260147094726562500000000000000e+00), SC_(-6.13592378795146942138671875000000000e-03), SC_(-9.97628630125505029288873562111763409e-07) }},
   {{ SC_(1.62974609375000000000000000000000000e+02), SC_(-1.96325117940432392060756683349609375e-07), SC_(-1.00000002484788340900877679455071652e-06) }},
   {{ SC_(1.62974609375000000000000000000000000e+02), SC_(1.96325061097013531252741813659667969e-07), SC_(1.00000073531132256066196156784742243e-06) }},
   {{ SC_(9.99674081802368164062500000000000000e-01), SC_(3.06796096265316009521484375000000000e-03), SC_(-1.00006678620328213451803810512717519e-06) }},
   {{ SC_(1.00032567977905273437500000000000000e+00), SC_(-3.06796189397573471069335937500000000e-03), SC_(-9.99009982833680581236478763464603911e-07) }},
   {{ SC_(3.25949218750000000000000000000000000e+02), SC_(-1.72808938714297255501151084899902344e-07), SC_(-1.00000017425493503075459370529143366e-06) }},
   {{ SC_(3.25949218750000000000000000000000000e+02), SC_(1.72808881870878394693136215209960938e-07), SC_(1.00000084531777807929903916715722002e-06) }},
   {{ SC_(9.99348163604736328125000000000000000e-01), SC_(1.53398048132658004760742187500000000e-03), SC_(-1.00022983581815624819857695942100827e-06) }},
   {{ SC_(1.00065183639526367187500000000000000e+00), SC_(-1.53398094698786735534667968750000000e-03), SC_(-9.99578365747874993902105091072462901e-07) }},
   {{ SC_(6.51898437500000000000000000000000000e+02), SC_(-1.54323743117856793105602264404296875e-07), SC_(-1.00000019137567508640386824843631282e-06) }},
   {{ SC_(6.51898437500000000000000000000000000e+02), SC_(1.54323686274437932297587394714355469e-07), SC_(1.00000082303765745883460035655878209e-06) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(1.35445290538882545661181211471557617e-08), SC_(9.99999986223624788330825387158088667e-08) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-1.35445290538882545661181211471557617e-08), SC_(-9.99999886223637543604435451046063029e-08) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(1.49478864841512404382228851318359375e-08), SC_(9.99999773759788049917126990480644510e-08) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-1.49478935895785980392247438430786133e-08), SC_(-1.00000014910628721077682892324891562e-07) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(1.66756706221349304541945457458496094e-08), SC_(9.99999987249351885109932586800458910e-08) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-1.66756706221349304541945457458496094e-08), SC_(-9.99999887249364435238156787623639819e-08) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(1.88550686175403825473040342330932617e-08), SC_(9.99999876872127691640698772475744073e-08) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-1.88550757229677401483058929443359375e-08), SC_(-1.00000015371647728835741072366506120e-07) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(2.16897788618553022388368844985961914e-08), SC_(9.99999840713431658866726214687196881e-08) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-2.16897859672826598398387432098388672e-08), SC_(-1.00000006830672401648293146381371736e-07) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(2.55276617622257617767900228500366211e-08), SC_(9.99999843405845069041514541101415010e-08) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-2.55276688676531193777918815612792969e-08), SC_(-1.00000002174807241733591612540723393e-07) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(3.10157162175528355874121189117431641e-08), SC_(9.99999848346371689267644253149038034e-08) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-3.10157304284075507894158363342285156e-08), SC_(-1.00000020652865513724422941547213802e-07) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(3.95096861893762252293527126312255859e-08), SC_(9.99999708396244009890073709587408893e-08) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-3.95097004002309404313564300537109375e-08), SC_(-9.99999968076426506209520511048778109e-08) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(5.44105915878390078432857990264892578e-08), SC_(9.99999725753419414673929739368587313e-08) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-5.44106057986937230452895164489746094e-08), SC_(-9.99999886931469497879690249194098086e-08) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(7.49014504072100193148698381740048348e-07) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(8.73568239967426052317023277282714844e-08), SC_(9.99999547040880146524286089452008566e-08) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-8.73568524184520356357097625732421875e-08), SC_(-9.99999772392693322768194495719029765e-08) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(-1.57079648971557617187500000000000000e+00), SC_(3.74507181908235446150271656408670926e-07) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(2.21443372083740541711449623107910156e-07), SC_(9.99999577795384193634806295609657157e-08) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-2.21443372083740541711449623107910156e-07), SC_(-9.99999477795478634526475763549905584e-08) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(-7.85398244857788085937500000000000000e-01), SC_(1.87253573422167343389627785465968582e-07) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-4.13968223256233613938093185424804688e-07), SC_(1.00000104359228237035756450568311833e-07) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(4.13968109569395892322063446044921875e-07), SC_(-1.00000066896487092275233071990143153e-07) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(-3.92699122428894042968750000000000000e-01), SC_(9.36267823280964871384335626334088646e-08) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-1.06984856529379612766206264495849609e-07), SC_(1.00000018775797129469970376916056871e-07) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(1.06984856529379612766206264495849609e-07), SC_(-1.00000008775794374310655226318674547e-07) }},
   {{ SC_(1.00000047683715820312500000000000000e+00), SC_(1.96349501609802246093750000000000000e-01), SC_(9.36267204228523053261256901400007209e-08) }},
   {{ SC_(9.99999284744262695312500000000000000e-01), SC_(-1.96349561214447021484375000000000000e-01), SC_(1.40440210262952112287771279805630011e-07) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-6.14303985457809176295995712280273438e-08), SC_(1.00000034372321465788253233968362607e-07) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(6.14303701240714872255921363830566406e-08), SC_(-9.99999781057836964249174605420433496e-08) }},
   {{ SC_(1.00000095367431640625000000000000000e+00), SC_(9.81747508049011230468750000000000000e-02), SC_(9.36266981005175773636612920972180547e-08) }},
   {{ SC_(9.99998807907104492187500000000000000e-01), SC_(-9.81747806072235107421875000000000000e-02), SC_(1.17033535085765580151536534160575115e-07) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-4.30847677534984541125595569610595703e-08), SC_(1.00000018805073963183946338386101521e-07) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(4.30847535426437389105558395385742188e-08), SC_(-9.99999758215923605517003333756229938e-08) }},
   {{ SC_(1.00000190734863281250000000000000000e+00), SC_(4.90873754024505615234375000000000000e-02), SC_(9.36266534558906978488703752722546669e-08) }},
   {{ SC_(9.99997854232788085937500000000000000e-01), SC_(-4.90873903036117553710937500000000000e-02), SC_(1.05330231186259507990246671332923558e-07) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-3.31768177375124651007354259490966797e-08), SC_(1.00000022896976958012969278380324515e-07) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(3.31768035266577498987317085266113281e-08), SC_(-9.99999700632816428320794906577644281e-08) }},
   {{ SC_(1.00000381469726562500000000000000000e+00), SC_(2.45436877012252807617187500000000000e-02), SC_(9.36265641668072440334991165154052346e-08) }},
   {{ SC_(9.99995946884155273437500000000000000e-01), SC_(-2.45436951518058776855468750000000000e-02), SC_(9.94786462552879504802552105768108038e-08) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-2.69738080760362208820879459381103516e-08), SC_(1.00000019268877153664063840434616241e-07) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(2.69738009706088632810860872268676758e-08), SC_(-9.99999829269219849120963883268260542e-08) }},
   {{ SC_(1.00000810623168945312500000000000000e+00), SC_(1.22718438506126403808593750000000000e-02), SC_(9.94780112624548168092076966083016892e-08) }},
   {{ SC_(9.99991655349731445312500000000000000e-01), SC_(-1.22718475759029388427734375000000000e-02), SC_(1.02404708679594719511058464344751975e-07) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-2.27249614681568345986306667327880859e-08), SC_(1.00000010753996306970187849874464934e-07) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(2.27249543627294769976288080215454102e-08), SC_(-9.99999694869363941100847165675442246e-08) }},
   {{ SC_(1.00001621246337890625000000000000000e+00), SC_(6.13592192530632019042968750000000000e-03), SC_(9.94776080714336479181889467775469710e-08) }},
   {{ SC_(9.99983549118041992187500000000000000e-01), SC_(-6.13592378795146942138671875000000000e-03), SC_(1.00942193329872787676776565476880390e-07) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-1.96325018464449385646730661392211914e-08), SC_(1.00000017045659690676278878944335745e-07) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(1.96324947410175809636712074279785156e-08), SC_(-9.99999708534920723996353843585311037e-08) }},
   {{ SC_(1.00003242492675781250000000000000000e+00), SC_(3.06796096265316009521484375000000000e-03), SC_(9.94768017024644055410190013271098986e-08) }},
   {{ SC_(9.99967336654663085937500000000000000e-01), SC_(-3.06796189397573471069335937500000000e-03), SC_(1.00211540475502817180233737479820576e-07) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-1.72808825027459533885121345520019531e-08), SC_(1.00000015642422312088446107825291755e-07) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(1.72808753973185957875102758407592773e-08), SC_(-9.99999645251485273751259631515402047e-08) }},
   {{ SC_(1.00006484985351562500000000000000000e+00), SC_(1.53398048132658004760742187500000000e-03), SC_(9.94751890168160770835024320761559187e-08) }},
   {{ SC_(9.99934673309326171875000000000000000e-01), SC_(-1.53398094698786735534667968750000000e-03), SC_(1.00213177177852022581065745061751593e-07) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-1.54323629431019071489572525024414063e-08), SC_(1.00000008511122118560110816425516735e-07) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(1.54323629431019071489572525024414063e-08), SC_(-9.99999985111214163357699988648804809e-08) }},
   {{ SC_(6.21698796749114990234375000000000000e-04), SC_(1.35445290538882545661181211471557617e-08), SC_(-9.99999956799815505287956725660181621e-08) }},
   {{ SC_(6.21698796749114990234375000000000000e-04), SC_(-1.35445326066019333666190505027770996e-08), SC_(1.00000031909864202889496946150070648e-07) }},
   {{ SC_(1.24339759349822998046875000000000000e-03), SC_(1.49478864841512404382228851318359375e-08), SC_(-9.99999751648464781886135243799826727e-08) }},
   {{ SC_(1.24339759349822998046875000000000000e-03), SC_(-1.49478935895785980392247438430786133e-08), SC_(1.00000032699500111780793031306423763e-07) }},
   {{ SC_(2.48679518699645996093750000000000000e-03), SC_(1.66756706221349304541945457458496094e-08), SC_(-9.99999974140912511644333033565507762e-08) }},
   {{ SC_(2.48679518699645996093750000000000000e-03), SC_(-1.66756777275622880551964044570922852e-08), SC_(1.00000050023641902501093211683665223e-07) }},
   {{ SC_(4.97359037399291992187500000000000000e-03), SC_(1.88550686175403825473040342330932617e-08), SC_(-9.99999875119851324106153116321489702e-08) }},
   {{ SC_(4.97359037399291992187500000000000000e-03), SC_(-1.88550757229677401483058929443359375e-08), SC_(1.00000035196426371219965587477061904e-07) }},
   {{ SC_(9.94718074798583984375000000000000000e-03), SC_(2.16897788618553022388368844985961914e-08), SC_(-9.99999853731924494682534002941301479e-08) }},
   {{ SC_(9.94718074798583984375000000000000000e-03), SC_(-2.16897859672826598398387432098388672e-08), SC_(1.00000028132525828413498950324087514e-07) }},
   {{ SC_(1.98943614959716796875000000000000000e-02), SC_(2.55276617622257617767900228500366211e-08), SC_(-9.99999876422308908611007795155197812e-08) }},
   {{ SC_(1.98943614959716796875000000000000000e-02), SC_(-2.55276688676531193777918815612792969e-08), SC_(1.00000025476457291508647496501003436e-07) }},
   {{ SC_(3.97887229919433593750000000000000000e-02), SC_(3.10157162175528355874121189117431641e-08), SC_(-9.99999909959318505701231111628546822e-08) }},
   {{ SC_(3.97887229919433593750000000000000000e-02), SC_(-3.10157304284075507894158363342285156e-08), SC_(1.00000046814171929949167733107112570e-07) }},
   {{ SC_(7.95774459838867187500000000000000000e-02), SC_(3.95096861893762252293527126312255859e-08), SC_(-9.99999814268560277941722403988811176e-08) }},
   {{ SC_(7.95774459838867187500000000000000000e-02), SC_(-3.95097004002309404313564300537109375e-08), SC_(1.00000027394879329146610959710505634e-07) }},
   {{ SC_(1.59154891967773437500000000000000000e-01), SC_(5.44106057986937230452895164489746094e-08), SC_(-1.00000017044760967325134421779040118e-07) }},
   {{ SC_(1.59154891967773437500000000000000000e-01), SC_(-5.44106057986937230452895164489746094e-08), SC_(1.00000027044765376278229753676713717e-07) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(3.14159202575683593750000000000000000e+00), SC_(-7.49013715676260854376587145158441865e-07) }},
   {{ SC_(3.18309783935546875000000000000000000e-01), SC_(8.73568524184520356357097625732421875e-08), SC_(-1.00000022758111205093781987746382060e-07) }},
   {{ SC_(3.18309783935546875000000000000000000e-01), SC_(-8.73568808401614660397171974182128906e-08), SC_(1.00000065293309331838287081853610642e-07) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(1.57079601287841796875000000000000000e+00), SC_(-3.74506927965849974397464393635374107e-07) }},
   {{ SC_(6.36619567871093750000000000000000000e-01), SC_(2.21443372083740541711449623107910156e-07), SC_(-1.00000063166555964192955770641441332e-07) }},
   {{ SC_(6.36619567871093750000000000000000000e-01), SC_(-2.21443428927159402519464492797851563e-07), SC_(1.00000098836095290908432446528391287e-07) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(7.85398006439208984375000000000000000e-01), SC_(-1.87253481514858156916394933196325137e-07) }},
   {{ SC_(1.27323913574218750000000000000000000e+00), SC_(-4.13968223256233613938093185424804688e-07), SC_(-9.99998786537018926123205247436638708e-08) }},
   {{ SC_(1.27323913574218750000000000000000000e+00), SC_(4.13968109569395892322063446044921875e-07), SC_(9.99998611910110964742100435681410735e-08) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(3.92699003219604492187500000000000000e-01), SC_(-9.36267451404127812521016414873382395e-08) }},
   {{ SC_(2.54647827148437500000000000000000000e+00), SC_(-1.06984884951089043170213699340820313e-07), SC_(-9.99999795955231097779097888637522087e-08) }},
   {{ SC_(2.54647827148437500000000000000000000e+00), SC_(1.06984856529379612766206264495849609e-07), SC_(9.99999630294234187384653776760325700e-08) }},
   {{ SC_(9.99999284744262695312500000000000000e-01), SC_(1.96349501609802246093750000000000000e-01), SC_(-1.40440147906928818671353344325989048e-07) }},
   {{ SC_(1.00000047683715820312500000000000000e+00), SC_(-1.96349561214447021484375000000000000e-01), SC_(-9.36267400785903420270664793252522774e-08) }},
   {{ SC_(5.09295654296875000000000000000000000e+00), SC_(-6.14303985457809176295995712280273438e-08), SC_(-9.99999923629136935183276600109824292e-08) }},
   {{ SC_(5.09295654296875000000000000000000000e+00), SC_(6.14303701240714872255921363830566406e-08), SC_(9.99999560963868275360339545350257580e-08) }},
   {{ SC_(9.99998807907104492187500000000000000e-01), SC_(9.81747508049011230468750000000000000e-02), SC_(-1.17033485861765042493056671449771309e-07) }},
   {{ SC_(1.00000095367431640625000000000000000e+00), SC_(-9.81747806072235107421875000000000000e-02), SC_(-9.36267177562530177416554712331371592e-08) }},
   {{ SC_(1.01859130859375000000000000000000000e+01), SC_(-4.30847677534984541125595569610595703e-08), SC_(-9.99999863549865642262603333385911896e-08) }},
   {{ SC_(1.01859130859375000000000000000000000e+01), SC_(4.30847677534984541125595569610595703e-08), SC_(9.99999963549848352234500145905229576e-08) }},
   {{ SC_(9.99997854232788085937500000000000000e-01), SC_(4.90873754024505615234375000000000000e-02), SC_(-1.05330188117349028609212480546331834e-07) }},
   {{ SC_(1.00000190734863281250000000000000000e+00), SC_(-4.90873903036117553710937500000000000e-02), SC_(-9.36266731116209455829337042957599932e-08) }},
   {{ SC_(2.03718261718750000000000000000000000e+01), SC_(-3.31768177375124651007354259490966797e-08), SC_(-9.99999956096023409896258320080213551e-08) }},
   {{ SC_(2.03718261718750000000000000000000000e+01), SC_(3.31768035266577498987317085266113281e-08), SC_(9.99999627759095652064746462262955106e-08) }},
   {{ SC_(9.99995946884155273437500000000000000e-01), SC_(2.45436877012252807617187500000000000e-02), SC_(-9.94786061611634101042563415308739816e-08) }},
   {{ SC_(1.00000381469726562500000000000000000e+00), SC_(-2.45436951518058776855468750000000000e-02), SC_(-9.36265838225271064875502288936203854e-08) }},
   {{ SC_(4.07436523437500000000000000000000000e+01), SC_(-2.69738080760362208820879459381103516e-08), SC_(-9.99999952136917866797772467141230167e-08) }},
   {{ SC_(4.07436523437500000000000000000000000e+01), SC_(2.69738009706088632810860872268676758e-08), SC_(9.99999788717379484608508143191315298e-08) }},
   {{ SC_(9.99991655349731445312500000000000000e-01), SC_(1.22718438506126403808593750000000000e-02), SC_(-1.02404667106500224892563095033234113e-07) }},
   {{ SC_(1.00000810623168945312500000000000000e+00), SC_(-1.22718475759029388427734375000000000e-02), SC_(-9.94780315645219466712256980202625891e-08) }},
   {{ SC_(8.14873046875000000000000000000000000e+01), SC_(-2.27249614681568345986306667327880859e-08), SC_(-9.99999889127497472831140588352252565e-08) }},
   {{ SC_(8.14873046875000000000000000000000000e+01), SC_(2.27249614681568345986306667327880859e-08), SC_(9.99999989127485298329538250711510235e-08) }},
   {{ SC_(9.99983549118041992187500000000000000e-01), SC_(6.13592192530632019042968750000000000e-03), SC_(-1.00942152498142987415289948859740300e-07) }},
   {{ SC_(1.00001621246337890625000000000000000e+00), SC_(-6.13592378795146942138671875000000000e-03), SC_(-9.94776283734586006353532656627394494e-08) }},
   {{ SC_(1.62974609375000000000000000000000000e+02), SC_(-1.96325018464449385646730661392211914e-08), SC_(-9.99999968157929678051691964751904352e-08) }},
   {{ SC_(1.62974609375000000000000000000000000e+02), SC_(1.96325018464449385646730661392211914e-08), SC_(1.00000006815793330963777370472792689e-07) }},
   {{ SC_(9.99967336654663085937500000000000000e-01), SC_(3.06796096265316009521484375000000000e-03), SC_(-1.00211500012546330720388957705183996e-07) }},
   {{ SC_(1.00003242492675781250000000000000000e+00), SC_(-3.06796189397573471069335937500000000e-03), SC_(-9.94768220044050043606790146193973700e-08) }},
   {{ SC_(3.25949218750000000000000000000000000e+02), SC_(-1.72808825027459533885121345520019531e-08), SC_(-9.99999966379089599480000837044278079e-08) }},
   {{ SC_(3.25949218750000000000000000000000000e+02), SC_(1.72808825027459533885121345520019531e-08), SC_(1.00000006637909287529802514229347319e-07) }},
   {{ SC_(9.99934673309326171875000000000000000e-01), SC_(1.53398048132658004760742187500000000e-03), SC_(-1.00213136714070656913651263274960718e-07) }},
   {{ SC_(1.00006484985351562500000000000000000e+00), SC_(-1.53398094698786735534667968750000000e-03), SC_(-9.94752093185879696770284393653305160e-08) }},
   {{ SC_(6.51898437500000000000000000000000000e+02), SC_(-1.54323629431019071489572525024414063e-08), SC_(-9.99999904698141910470382251365791604e-08) }},
   {{ SC_(6.51898437500000000000000000000000000e+02), SC_(1.54323629431019071489572525024414063e-08), SC_(1.00000000469813285009781353410635357e-07) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(1.35445299420666742662433534860610962e-09), SC_(1.00000000679832463937888544235694168e-08) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-1.35445299420666742662433534860610962e-09), SC_(-9.99999996798324603412393232104442299e-09) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(1.49478873723296601383481174707412720e-09), SC_(9.99999788178123286649123048531376588e-09) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-1.49478918132217586389742791652679443e-09), SC_(-1.00000007526968180684276044224114562e-08) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(1.66756697339565107540693134069442749e-09), SC_(9.99999888987427593607609209901194693e-09) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-1.66756741748486092546954751014709473e-09), SC_(-1.00000014529706603296797032201756381e-08) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(1.88550686175403825473040342330932617e-09), SC_(9.99999831872141623147264935469858760e-09) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-1.88550774993245795485563576221466064e-09), SC_(-1.00000029292758119462744210448497000e-08) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(2.16897788618553022388368844985961914e-09), SC_(9.99999795713448844655166642398795061e-09) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-2.16897877436394992400892078876495361e-09), SC_(-1.00000019520505301001477172861060954e-08) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(2.55276599858689223765395581722259521e-09), SC_(9.99999728820307850735018331956563837e-09) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-2.55276688676531193777918815612792969e-09), SC_(-1.00000006674807722466284754073641308e-08) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(3.10157144411959961871616542339324951e-09), SC_(9.99999746073601498428092834095635700e-09) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-3.10157233229801931884139776229858398e-09), SC_(-1.00000002243753439799552599943813526e-08) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(3.95096932948035828303545713424682617e-09), SC_(9.99999843236349974418842494084698180e-09) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-3.95097110583719768328592181205749512e-09), SC_(-1.00000028283653639318178375798105772e-08) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(5.44105915878390078432857990264892578e-09), SC_(9.99999680753446946860246482923419786e-09) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-5.44106093514074018457904458045959473e-09), SC_(-9.99999997225964356692045830692709045e-09) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(8.73568239967426052317023277282714844e-09), SC_(9.99999502040923762831760740544590906e-09) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-8.73568595238793932367116212844848633e-09), SC_(-9.99999898730611154636152433202685262e-09) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(2.21443343662031111307442188262939453e-08), SC_(9.99999404447956222733008744410400975e-09) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-2.21443414716304687317460775375366211e-08), SC_(-9.99999715316633864663369525796991387e-09) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-4.13968166412814753130078315734863281e-08), SC_(1.00000086127856982796622016008649932e-08) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(4.13968166412814753130078315734863281e-08), SC_(-1.00000085127855270238766297680370062e-08) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-1.06984892056516400771215558052062988e-08), SC_(1.00000047483432010692115684538099789e-08) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(1.06984856529379612766206264495849609e-08), SC_(-1.00000013275795449132279266390099970e-08) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(-1.96349561214447021484375000000000000e-01), SC_(4.68133900683014987257420815514899652e-08) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-6.14303985457809176295995712280273438e-09), SC_(1.00000029872318657279062878530995150e-08) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(6.14303807822125236270949244499206543e-09), SC_(-9.99999999557330330281906674054160100e-09) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(-9.81747806072235107421875000000000000e-02), SC_(2.34066947602140695639546510348292544e-08) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-4.30847713062121329130604863166809082e-09), SC_(1.00000022550943173177372272562782442e-08) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(4.30847535426437389105558395385742188e-09), SC_(-9.99999803215904694950897881031375429e-09) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(-4.90873903036117553710937500000000000e-02), SC_(1.17033473116228656337422473169490054e-08) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-3.31768212902261439012363553047180176e-09), SC_(1.00000029105399294157947173562420586e-08) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(3.31768124084419468999840319156646729e-09), SC_(-1.00000001334338977788776110458870856e-08) }},
   {{ SC_(9.99999523162841796875000000000000000e-01), SC_(-2.45436951518058776855468750000000000e-02), SC_(1.17033487067710911261994026139674104e-08) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-2.69738098523930602823384106159210205e-09), SC_(1.00000021354364507613005190203440623e-08) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(2.69738009706088632810860872268676758e-09), SC_(-9.99999874269207333350808886077043485e-09) }},
   {{ SC_(1.00000047683715820312500000000000000e+00), SC_(1.22718438506126403808593750000000000e-02), SC_(5.85166976961296887530682521200846517e-09) }},
   {{ SC_(9.99999046325683593750000000000000000e-01), SC_(-1.22718475759029388427734375000000000e-02), SC_(1.17033514970688726291807502064499270e-08) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-2.27249685735841921996325254440307617e-09), SC_(1.00000037521057825547899136537549202e-08) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(2.27249596917999951983802020549774170e-09), SC_(-9.99999974372301150066125344063055689e-09) }},
   {{ SC_(1.00000143051147460937500000000000000e+00), SC_(6.13592192530632019042968750000000000e-03), SC_(8.77750048182414211137418584907013422e-09) }},
   {{ SC_(9.99998331069946289062500000000000000e-01), SC_(-6.13592378795146942138671875000000000e-03), SC_(1.02404362147135456016765949400900428e-08) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-1.96325000700880991644226014614105225e-09), SC_(1.00000003497616143996144449559116560e-08) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(1.96325000700880991644226014614105225e-09), SC_(-1.00000002497616084043821295589225403e-08) }},
   {{ SC_(1.00000286102294921875000000000000000e+00), SC_(3.06796096265316009521484375000000000e-03), SC_(8.77749420368000717244703773552953131e-09) }},
   {{ SC_(9.99996662139892578125000000000000000e-01), SC_(-3.06796189397573471069335937500000000e-03), SC_(1.02404447600208625623601651763248839e-08) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-1.72808833909243730886373668909072876e-09), SC_(1.00000016282080711661535973709068808e-08) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(1.72808789500322745880112051963806152e-09), SC_(-9.99999895837832980304136940949245735e-09) }},
   {{ SC_(1.00000619888305664062500000000000000e+00), SC_(1.53398048132658004760742187500000000e-03), SC_(9.50893618776157998346930569691778006e-09) }},
   {{ SC_(9.99993324279785156250000000000000000e-01), SC_(-1.53398094698786735534667968750000000e-03), SC_(1.02404618506925428741652439049449793e-08) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-1.54323664958155859494581818580627441e-09), SC_(1.00000027032313221546380186353908201e-08) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(1.54323620549234874488320201635360718e-09), SC_(-9.99999972558237864458620455234033199e-09) }},
   {{ SC_(6.21698796749114990234375000000000000e-04), SC_(1.35445299420666742662433534860610962e-09), SC_(-1.00000006737451354496405288082874646e-08) }},
   {{ SC_(6.21698796749114990234375000000000000e-04), SC_(-1.35445299420666742662433534860610962e-09), SC_(1.00000007737451499245439038571626307e-08) }},
   {{ SC_(1.24339759349822998046875000000000000e-03), SC_(1.49478873723296601383481174707412720e-09), SC_(-9.99999856066760745012270495364964379e-09) }},
   {{ SC_(1.24339759349822998046875000000000000e-03), SC_(-1.49478918132217586389742791652679443e-09), SC_(1.00000016315834123199601446515068788e-08) }},
   {{ SC_(2.48679518699645996093750000000000000e-03), SC_(1.66756697339565107540693134069442749e-09), SC_(-9.99999965878981182492586918143240858e-09) }},
   {{ SC_(2.48679518699645996093750000000000000e-03), SC_(-1.66756741748486092546954751014709473e-09), SC_(1.00000024218864518543516076215820385e-08) }},
   {{ SC_(4.97359037399291992187500000000000000e-03), SC_(1.88550686175403825473040342330932617e-09), SC_(-9.99999920119842934892612962969331382e-09) }},
   {{ SC_(4.97359037399291992187500000000000000e-03), SC_(-1.88550774993245795485563576221466064e-09), SC_(1.00000040117533324744428114086744577e-08) }},
   {{ SC_(9.94718074798583984375000000000000000e-03), SC_(2.16897788618553022388368844985961914e-09), SC_(-9.99999898731914180555657303147980480e-09) }},
   {{ SC_(9.94718074798583984375000000000000000e-03), SC_(-2.16897877436394992400892078876495361e-09), SC_(1.00000031822356670477714061435053561e-08) }},
   {{ SC_(1.98943614959716796875000000000000000e-02), SC_(2.55276599858689223765395581722259521e-09), SC_(-9.99999851836738610527555300608290806e-09) }},
   {{ SC_(1.98943614959716796875000000000000000e-02), SC_(-2.55276688676531193777918815612792969e-09), SC_(1.00000020976455283627396349524363567e-08) }},
   {{ SC_(3.97887229919433593750000000000000000e-02), SC_(3.10157144411959961871616542339324951e-09), SC_(-9.99999897686518451807561723416949870e-09) }},
   {{ SC_(3.97887229919433593750000000000000000e-02), SC_(-3.10157233229801931884139776229858398e-09), SC_(1.00000019405049623397816026697201092e-08) }},
   {{ SC_(7.95774459838867187500000000000000000e-02), SC_(3.95096932948035828303545713424682617e-09), SC_(-1.00000003910865670960511371274003572e-08) }},
   {{ SC_(7.95774459838867187500000000000000000e-02), SC_(-3.95097110583719768328592181205749512e-09), SC_(1.00000049870894232751687213629824580e-08) }},
   {{ SC_(1.59154891967773437500000000000000000e-01), SC_(5.44105915878390078432857990264892578e-09), SC_(-9.99999954269545075425346378456198018e-09) }},
   {{ SC_(1.59154891967773437500000000000000000e-01), SC_(-5.44106093514074018457904458045959473e-09), SC_(1.00000029074215427541138406698826072e-08) }},
   {{ SC_(3.18309783935546875000000000000000000e-01), SC_(8.73568239967426052317023277282714844e-09), SC_(-9.99999947229245420757315544664299531e-09) }},
   {{ SC_(3.18309783935546875000000000000000000e-01), SC_(-8.73568595238793932367116212844848633e-09), SC_(1.00000036391911505224700745550089442e-08) }},
   {{ SC_(6.36619567871093750000000000000000000e-01), SC_(2.21443343662031111307442188262939453e-08), SC_(-1.00000054831800499311153751347626734e-08) }},
   {{ SC_(6.36619567871093750000000000000000000e-01), SC_(-2.21443414716304687317460775375366211e-08), SC_(1.00000087918705834871473855481476623e-08) }},
   {{ SC_(1.27323913574218750000000000000000000e+00), SC_(-4.13968166412814753130078315734863281e-08), SC_(-9.99998694223590034509390357241104345e-09) }},
   {{ SC_(1.27323913574218750000000000000000000e+00), SC_(4.13968166412814753130078315734863281e-08), SC_(9.99998704223564018997850835340447784e-09) }},
   {{ SC_(2.54647827148437500000000000000000000e+00), SC_(-1.06984892056516400771215558052062988e-08), SC_(-9.99999907370449803435978276839728249e-09) }},
   {{ SC_(2.54647827148437500000000000000000000e+00), SC_(1.06984856529379612766206264495849609e-08), SC_(9.99999585294270310894058598436721115e-09) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(1.96349501609802246093750000000000000e-01), SC_(-4.68133736659523676200921281224421773e-08) }},
   {{ SC_(5.09295654296875000000000000000000000e+00), SC_(-6.14303985457809176295995712280273438e-09), SC_(-9.99999968629132911805416883621015225e-09) }},
   {{ SC_(5.09295654296875000000000000000000000e+00), SC_(6.14303807822125236270949244499206543e-09), SC_(9.99999689463368793270003173402718208e-09) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(9.81747508049011230468750000000000000e-02), SC_(-2.34066871069126844705023115071904772e-08) }},
   {{ SC_(1.01859130859375000000000000000000000e+01), SC_(-4.30847713062121329130604863166809082e-09), SC_(-9.99999991008542225028934856764083764e-09) }},
   {{ SC_(1.01859130859375000000000000000000000e+01), SC_(4.30847535426437389105558395385742188e-09), SC_(9.99999588715103832939417987292243201e-09) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(4.90873754024505615234375000000000000e-02), SC_(-1.17033436219404682018584741055111921e-08) }},
   {{ SC_(2.03718261718750000000000000000000000e+01), SC_(-3.31768212902261439012363553047180176e-09), SC_(-1.00000010818024277353456582067626933e-08) }},
   {{ SC_(2.03718261718750000000000000000000000e+01), SC_(3.31768124084419468999840319156646729e-09), SC_(9.99999850469688520437684115401523803e-09) }},
   {{ SC_(9.99999523162841796875000000000000000e-01), SC_(2.45436877012252807617187500000000000e-02), SC_(-1.17033450170882375218401254705689815e-08) }},
   {{ SC_(4.07436523437500000000000000000000000e+01), SC_(-2.69738098523930602823384106159210205e-09), SC_(-1.00000006299179386747735005111426138e-08) }},
   {{ SC_(4.07436523437500000000000000000000000e+01), SC_(2.69738009706088632810860872268676758e-09), SC_(9.99999743717401350040332622034659213e-09) }},
   {{ SC_(9.99999046325683593750000000000000000e-01), SC_(1.22718438506126403808593750000000000e-02), SC_(-1.17033478073851066794237462514058475e-08) }},
   {{ SC_(1.00000047683715820312500000000000000e+00), SC_(-1.22718475759029388427734375000000000e-02), SC_(-5.85167151172733547233644677199994724e-09) }},
   {{ SC_(8.14873046875000000000000000000000000e+01), SC_(-2.27249685735841921996325254440307617e-09), SC_(-1.00000024679806908116947095275892547e-08) }},
   {{ SC_(8.14873046875000000000000000000000000e+01), SC_(2.27249596917999951983802020549774170e-09), SC_(9.99999865959842879286714198104085341e-09) }},
   {{ SC_(9.99998331069946289062500000000000000e-01), SC_(6.13592192530632019042968750000000000e-03), SC_(-1.02404330012199816499054787714359776e-08) }},
   {{ SC_(1.00000143051147460937500000000000000e+00), SC_(-6.13592378795146942138671875000000000e-03), SC_(-8.77750306931295796932516956923380533e-09) }},
   {{ SC_(1.62974609375000000000000000000000000e+02), SC_(-1.96325000700880991644226014614105225e-09), SC_(-9.99999922677517752190388437356405700e-09) }},
   {{ SC_(1.62974609375000000000000000000000000e+02), SC_(1.96325000700880991644226014614105225e-09), SC_(9.99999932677516305740781072083604073e-09) }},
   {{ SC_(9.99996662139892578125000000000000000e-01), SC_(3.06796096265316009521484375000000000e-03), SC_(-1.02404415465245295481632856427553926e-08) }},
   {{ SC_(1.00000286102294921875000000000000000e+00), SC_(-3.06796189397573471069335937500000000e-03), SC_(-8.77749679116702742453822144157178226e-09) }},
   {{ SC_(3.25949218750000000000000000000000000e+02), SC_(-1.72808833909243730886373668909072876e-09), SC_(-1.00000006277567899156493768898646989e-08) }},
   {{ SC_(3.25949218750000000000000000000000000e+02), SC_(1.72808789500322745880112051963806152e-09), SC_(9.99999815792727367585102134731118920e-09) }},
   {{ SC_(9.99993324279785156250000000000000000e-01), SC_(1.53398048132658004760742187500000000e-03), SC_(-1.02404586371906717161931154051801803e-08) }},
   {{ SC_(1.00000619888305664062500000000000000e+00), SC_(-1.53398094698786735534667968750000000e-03), SC_(-9.50893898391260324899660245728716304e-09) }},
   {{ SC_(6.51898437500000000000000000000000000e+02), SC_(-1.54323664958155859494581818580627441e-09), SC_(-1.00000017991002890688832984089325918e-08) }},
   {{ SC_(6.51898437500000000000000000000000000e+02), SC_(1.54323620549234874488320201635360718e-09), SC_(9.99999902145160945309873121768380379e-09) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(1.35445266113976003907737322151660919e-10), SC_(9.99999756393217715435049579809473952e-10) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-1.35445321625127235165564343333244324e-10), SC_(-1.00000016523506220272978809373932474e-09) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(1.49478873723296601383481174707412720e-10), SC_(9.99999783678125221545793243014278452e-10) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-1.49478929234447832641308195888996124e-10), SC_(-1.00000015404257172716502342123366673e-09) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(1.66756664032874368785996921360492706e-10), SC_(9.99999684755199334834391630599257910e-10) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-1.66756719544025600043823942542076111e-10), SC_(-1.00000001664224811119375737903486493e-09) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(1.88550675073173579221474938094615936e-10), SC_(9.99999768490213003481177549957835894e-10) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-1.88550730584324810479301959276199341e-10), SC_(-1.00000006189986368526483580313676718e-09) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(2.16897777516322776136803440749645233e-10), SC_(9.99999740027000151229350147640365197e-10) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-2.16897833027474007394630461931228638e-10), SC_(-9.99999994959252962833727517528812508e-10) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(2.55276577654228731262264773249626160e-10), SC_(9.99999637338368400466953233579449572e-10) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-2.55276688676531193777918815612792969e-10), SC_(-1.00000007124807785389556852516424071e-09) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(3.10157122207499469368485733866691589e-10), SC_(9.99999669982621094504619400544515473e-10) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-3.10157233229801931884139776229858398e-10), SC_(-1.00000002693753462843333997192539786e-09) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(3.95096955152496320806676521897315979e-10), SC_(9.99999894936374929928131035831988277e-10) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-3.95096955152496320806676521897315979e-10), SC_(-9.99999893936375141055369821419571667e-10) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(5.44105871469469093426596373319625854e-10), SC_(9.99999594635321219554025493093424452e-10) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-5.44106093514074018457904458045959473e-10), SC_(-1.00000000172596436022572504499480587e-09) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(8.73568550829872947360854595899581909e-10), SC_(9.99999853394399853396582110683092731e-10) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-8.73568550829872947360854595899581909e-10), SC_(-9.99999852394400147607760469871198791e-10) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(2.21443308134894323302432894706726074e-09), SC_(9.99999239513627030976294323967138933e-10) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-2.21443396952736293314956128597259521e-09), SC_(-9.99999639599464201335938422620806374e-10) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-4.13968237467088329140096902847290039e-09), SC_(1.00000102842058739648321445417686823e-09) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(4.13968059831404389115050435066223145e-09), SC_(-1.00000059831552297003339543474964057e-09) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-1.06984865411163809767458587884902954e-09), SC_(1.00000022127704595809811855642700431e-09) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(1.06984865411163809767458587884902954e-09), SC_(-1.00000022027704551654397833953098314e-09) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-6.14303941048888191289734095335006714e-10), SC_(1.00000022193172052556430735313831148e-09) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(6.14303719004283266258426010608673096e-10), SC_(-9.99999859474403869529228421393846257e-10) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-4.30847690857660836627474054694175720e-10), SC_(1.00000016947273883545579466127172558e-09) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(4.30847579835358374111820012331008911e-10), SC_(-9.99999910789284536713094198578139607e-10) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-3.31768168493340454006101936101913452e-10), SC_(1.00000015269869015687910614844463716e-09) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(3.31768057471037991490447893738746643e-10), SC_(-9.99999817060440037473090078510213094e-10) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(-2.45436951518058776855468750000000000e-02), SC_(5.85167363869039062999910548674820556e-09) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-2.69738120728391095326514914631843567e-10), SC_(1.00000029136225248121830020249616387e-09) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(2.69738009706088632810860872268676758e-10), SC_(-9.99999878769206230273735479922810387e-10) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(-1.22718475759029388427734375000000000e-02), SC_(2.92583681506493478080489205861908600e-09) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-2.27249608020230198235367424786090851e-10), SC_(1.00000002872708515671414890057369753e-09) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(2.27249608020230198235367424786090851e-10), SC_(-1.00000002772708510025997784708123596e-09) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(-6.13592378795146942138671875000000000e-03), SC_(1.46291840646240225841919883638522063e-09) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-1.96325011803111237895791418850421906e-10), SC_(1.00000008702642500454080135635266683e-09) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(1.96324956291960006637964397668838501e-10), SC_(-9.99999803275106142666520230978552951e-10) }},
   {{ SC_(9.99999523162841796875000000000000000e-01), SC_(-3.06796189397573471069335937500000000e-03), SC_(1.46291858085592865911173078871227747e-09) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-1.72808822807013484634808264672756195e-10), SC_(1.00000009407506222805107330338279728e-09) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(1.72808767295862253376981243491172791e-10), SC_(-9.99999771846345424973808990752805523e-10) }},
   {{ SC_(1.00000047683715820312500000000000000e+00), SC_(1.53398048132658004760742187500000000e-03), SC_(7.31458719329009603385355159908388393e-10) }},
   {{ SC_(9.99999284744262695312500000000000000e-01), SC_(-1.53398094698786735534667968750000000e-03), SC_(1.09718906623649556573887216002839785e-09) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-1.54323664958155859494581818580627441e-10), SC_(1.00000026582312981105530599469254722e-09) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(1.54323609447004628236754797399044037e-10), SC_(-9.99999905117014737376196039925291074e-10) }},
   {{ SC_(6.21698796749114990234375000000000000e-04), SC_(1.35445266113976003907737322151660919e-10), SC_(-9.99999825969390425340564685373228445e-10) }},
   {{ SC_(6.21698796749114990234375000000000000e-04), SC_(-1.35445321625127235165564343333244324e-10), SC_(1.00000023681126382212000826275040999e-09) }},
   {{ SC_(1.24339759349822998046875000000000000e-03), SC_(1.49478873723296601383481174707412720e-10), SC_(-9.99999860566759478113198326308227422e-10) }},
   {{ SC_(1.24339759349822998046875000000000000e-03), SC_(-1.49478929234447832641308195888996124e-10), SC_(1.00000023293123494002687637406957064e-09) }},
   {{ SC_(2.48679518699645996093750000000000000e-03), SC_(1.66756664032874368785996921360492706e-10), SC_(-9.99999770646734661936112019550990127e-10) }},
   {{ SC_(2.48679518699645996093750000000000000e-03), SC_(-1.66756719544025600043823942542076111e-10), SC_(1.00000010453381193994923780040653171e-09) }},
   {{ SC_(4.97359037399291992187500000000000000e-03), SC_(1.88550675073173579221474938094615936e-10), SC_(-9.99999865737906415903261514574725237e-10) }},
   {{ SC_(4.97359037399291992187500000000000000e-03), SC_(-1.88550730584324810479301959276199341e-10), SC_(1.00000016114758588003822385531853042e-09) }},
   {{ SC_(9.94718074798583984375000000000000000e-03), SC_(2.16897777516322776136803440749645233e-10), SC_(-9.99999852045457054496102868491623059e-10) }},
   {{ SC_(9.94718074798583984375000000000000000e-03), SC_(-2.16897833027474007394630461931228638e-10), SC_(1.00000010897773848718566397441990875e-09) }},
   {{ SC_(1.98943614959716796875000000000000000e-02), SC_(2.55276577654228731262264773249626160e-10), SC_(-9.99999769354783990106926430048918768e-10) }},
   {{ SC_(1.98943614959716796875000000000000000e-02), SC_(-2.55276688676531193777918815612792969e-10), SC_(1.00000020526455097689280769177150235e-09) }},
   {{ SC_(3.97887229919433593750000000000000000e-02), SC_(3.10157122207499469368485733866691589e-10), SC_(-9.99999830595523414877190954756737260e-10) }},
   {{ SC_(3.97887229919433593750000000000000000e-02), SC_(-3.10157233229801931884139776229858398e-10), SC_(1.00000018955049451602354109568615837e-09) }},
   {{ SC_(7.95774459838867187500000000000000000e-02), SC_(3.95096955152496320806676521897315979e-10), SC_(-1.00000009980869206384981576128493218e-09) }},
   {{ SC_(7.95774459838867187500000000000000000e-02), SC_(-3.95096955152496320806676521897315979e-10), SC_(1.00000010080869226446721015118568168e-09) }},
   {{ SC_(1.59154891967773437500000000000000000e-01), SC_(5.44105871469469093426596373319625854e-10), SC_(-9.99999877151393086502241702228168827e-10) }},
   {{ SC_(1.59154891967773437500000000000000000e-01), SC_(-5.44106093514074018457904458045959473e-10), SC_(1.00000028624215168723163985062075619e-09) }},
   {{ SC_(3.18309783935546875000000000000000000e-01), SC_(8.73568550829872947360854595899581909e-10), SC_(-1.00000030758287782347162392437339487e-09) }},
   {{ SC_(3.18309783935546875000000000000000000e-01), SC_(-8.73568550829872947360854595899581909e-10), SC_(1.00000030858287843963747510229229141e-09) }},
   {{ SC_(6.36619567871093750000000000000000000e-01), SC_(2.21443308134894323302432894706726074e-09), SC_(-1.00000039238349057663596178920628995e-09) }},
   {{ SC_(6.36619567871093750000000000000000000e-01), SC_(-2.21443396952736293314956128597259521e-09), SC_(1.00000079446979061417367527375013945e-09) }},
   {{ SC_(1.27323913574218750000000000000000000e+00), SC_(-4.13968237467088329140096902847290039e-09), SC_(-9.99998870365233018304255994718664128e-10) }},
   {{ SC_(1.27323913574218750000000000000000000e+00), SC_(4.13968059831404389115050435066223145e-09), SC_(9.99998442261093133641333172957883431e-10) }},
   {{ SC_(2.54647827148437500000000000000000000e+00), SC_(-1.06984865411163809767458587884902954e-09), SC_(-9.99999662813318432934593004973335914e-10) }},
   {{ SC_(2.54647827148437500000000000000000000e+00), SC_(1.06984865411163809767458587884902954e-09), SC_(9.99999663813317759561342555141043169e-10) }},
   {{ SC_(5.09295654296875000000000000000000000e+00), SC_(-6.14303941048888191289734095335006714e-10), SC_(-9.99999900837692555393814096383893831e-10) }},
   {{ SC_(5.09295654296875000000000000000000000e+00), SC_(6.14303719004283266258426010608673096e-10), SC_(9.99999540380491122285925847658539976e-10) }},
   {{ SC_(1.01859130859375000000000000000000000e+01), SC_(-4.30847690857660836627474054694175720e-10), SC_(-9.99999943971862950476634352984334411e-10) }},
   {{ SC_(1.01859130859375000000000000000000000e+01), SC_(4.30847579835358374111820012331008911e-10), SC_(9.99999687288466213407724013478171172e-10) }},
   {{ SC_(2.03718261718750000000000000000000000e+01), SC_(-3.31768168493340454006101936101913452e-10), SC_(-9.99999978824966989713900332169012934e-10) }},
   {{ SC_(2.03718261718750000000000000000000000e+01), SC_(3.31768057471037991490447893738746643e-10), SC_(9.99999645186774314230216106346703750e-10) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(2.45436877012252807617187500000000000e-02), SC_(-5.85167182809126569276772472799155890e-09) }},
   {{ SC_(4.07436523437500000000000000000000000e+01), SC_(-2.69738120728391095326514914631843567e-10), SC_(-1.00000014981039202671724928538655093e-09) }},
   {{ SC_(4.07436523437500000000000000000000000e+01), SC_(2.69738009706088632810860872268676758e-10), SC_(9.99999739217403685083402789423641685e-10) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(1.22718438506126403808593750000000000e-02), SC_(-2.92583591832589075686681660783401902e-09) }},
   {{ SC_(8.14873046875000000000000000000000000e+01), SC_(-2.27249608020230198235367424786090851e-10), SC_(-9.99999909314622759556343801776866279e-10) }},
   {{ SC_(8.14873046875000000000000000000000000e+01), SC_(2.27249608020230198235367424786090851e-10), SC_(9.99999910314622579185597273671091713e-10) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(6.13592192530632019042968750000000000e-03), SC_(-1.46291796023300985761956340951285846e-09) }},
   {{ SC_(1.62974609375000000000000000000000000e+02), SC_(-1.96325011803111237895791418850421906e-10), SC_(-9.99999983727775037537221763338996236e-10) }},
   {{ SC_(1.62974609375000000000000000000000000e+02), SC_(1.96324956291960006637964397668838501e-10), SC_(9.99999701976484676744483569258632298e-10) }},
   {{ SC_(9.99999523162841796875000000000000000e-01), SC_(3.06796096265316009521484375000000000e-03), SC_(-1.46291813462648280848077452879237117e-09) }},
   {{ SC_(3.25949218750000000000000000000000000e+02), SC_(-1.72808822807013484634808264672756195e-10), SC_(-1.00000000302994204687578335399416707e-09) }},
   {{ SC_(3.25949218750000000000000000000000000e+02), SC_(1.72808767295862253376981243491172791e-10), SC_(9.99999682801253720626887617371009653e-10) }},
   {{ SC_(9.99999284744262695312500000000000000e-01), SC_(1.53398048132658004760742187500000000e-03), SC_(-1.09718873196564558381625762240398524e-09) }},
   {{ SC_(1.00000047683715820312500000000000000e+00), SC_(-1.53398094698786735534667968750000000e-03), SC_(-7.31458940838529568766759585366470208e-10) }},
   {{ SC_(6.51898437500000000000000000000000000e+02), SC_(-1.54323664958155859494581818580627441e-10), SC_(-1.00000018441003055457875124610687277e-09) }},
   {{ SC_(6.51898437500000000000000000000000000e+02), SC_(1.54323609447004628236754797399044037e-10), SC_(9.99999825703944587029517398088126444e-10) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(1.35445266113976003907737322151660919e-11), SC_(9.99999755943217934966126722508587650e-11) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-1.35445300808445523443879210390150547e-11), SC_(-1.00000001199437071374927872274813296e-10) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(1.49478901478872217012394685298204422e-11), SC_(9.99999968910348656758660701599404374e-11) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-1.49478901478872217012394685298204422e-11), SC_(-9.99999968810348662986590872657340658e-11) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(1.66756677910662176600453676655888557e-11), SC_(9.99999767526961746601057008542525807e-11) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-1.66756747299601215672737453132867813e-11), SC_(-1.00000018353577234869085840211694618e-10) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(1.88550702828749194850388448685407639e-11), SC_(9.99999915245038482932323699648317141e-11) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-1.88550772217688233922672225162386894e-11), SC_(-1.00000028315710160330931025680445425e-10) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(2.16897819149686199580173706635832787e-11), SC_(9.99999931526189814627933568590123709e-11) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-2.16897819149686199580173706635832787e-11), SC_(-9.99999931426189828332695134743054701e-11) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(2.55276633165379962520091794431209564e-11), SC_(9.99999854343223329900407243828523068e-11) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-2.55276702554319001592375570908188820e-11), SC_(-1.00000012606179155811936032207946150e-10) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(3.10157177718650700626312755048274994e-11), SC_(9.99999848510078025127418206687261669e-11) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-3.10157316496528778770880308002233505e-11), SC_(-1.00000029585371954925219725874964970e-10) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(3.95096871885769473919935990124940872e-11), SC_(9.99999683736287028933334693287313588e-11) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-3.95097010663647552064503543078899384e-11), SC_(-1.00000003488643368167447338224672911e-10) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(5.44106010247347171571163926273584366e-11), SC_(9.99999849241973320818487490791347873e-11) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-5.44106149025225249715731479227542877e-11), SC_(-1.00000010419862503612009328641967517e-10) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(8.73568439807570484845200553536415100e-11), SC_(9.99999725853874535567227537328518645e-11) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-8.73568717363326641134335659444332123e-11), SC_(-1.00000004348018815200965501457471182e-10) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(2.21443363646045554560259915888309479e-10), SC_(9.99999489742275271687299066403480219e-11) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-2.21443419157196785818086937069892883e-10), SC_(-9.99999740320922879601644012451192889e-11) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-4.13968193058167344133835285902023315e-10), SC_(1.00000092069432076053332339532835794e-10) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(4.13968082035864881618181243538856506e-10), SC_(-1.00000065240365635340283622910676244e-10) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-1.06984865411163809767458587884902954e-10), SC_(1.00000022082704575923375534953500801e-10) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(1.06984865411163809767458587884902954e-10), SC_(-1.00000022072704571507834132785365590e-10) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-6.14303885537736960031907074153423309e-11), SC_(1.00000013111739117341707229852018155e-10) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(6.14303885537736960031907074153423309e-11), SC_(-1.00000013101739114720359234859226252e-10) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-4.30847718613236452256387565284967422e-11), SC_(1.00000023344360224427756933365535871e-10) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(4.30847579835358374111820012331008911e-11), SC_(-9.99999911239284456708453786899683458e-11) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-3.31768224004491685263928957283496857e-11), SC_(1.00000031956781511129062000909940229e-10) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(3.31768085226613607119361404329538345e-11), SC_(-9.99999901170002402158260393847423811e-11) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-2.69738051339452056254231138154864311e-11), SC_(1.00000003366659839304450506908622367e-10) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(2.69738051339452056254231138154864311e-11), SC_(-1.00000003356659838632118527814233591e-10) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-2.27249608020230198235367424786090851e-11), SC_(1.00000002827708513114477191252555729e-10) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(2.27249608020230198235367424786090851e-11), SC_(-1.00000002817708512549935480718456113e-10) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-1.96325039558686853524704929441213608e-11), SC_(1.00000022795208442642594725239834852e-10) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(1.96324970169747814452421152964234352e-11), SC_(-9.99999874412935701723532951059086659e-11) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(-3.06796189397573471069335937500000000e-03), SC_(7.31459202963684846409464866994106338e-10) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-1.72808850562589100263721775263547897e-11), SC_(1.00000025423942062830786530088595442e-10) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(1.72808781173650061191437998786568642e-11), SC_(-9.99999852603524446178783317745362812e-11) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(-1.53398094698786735534667968750000000e-03), SC_(3.65729601414963352529158451560844416e-10) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-1.54323637202580243865668307989835739e-11), SC_(1.00000008552007210274468572625426795e-10) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(1.54323637202580243865668307989835739e-11), SC_(-1.00000008542007208565067057690165994e-10) }},
   {{ SC_(6.21698796749114990234375000000000000e-04), SC_(1.35445266113976003907737322151660919e-11), SC_(-9.99999826419390268998029548584097244e-11) }},
   {{ SC_(6.21698796749114990234375000000000000e-04), SC_(-1.35445300808445523443879210390150547e-11), SC_(1.00000008267056109365624312873539831e-10) }},
   {{ SC_(1.24339759349822998046875000000000000e-03), SC_(1.49478901478872217012394685298204422e-11), SC_(-1.00000004669899701854789115078633658e-10) }},
   {{ SC_(1.24339759349822998046875000000000000e-03), SC_(-1.49478901478872217012394685298204422e-11), SC_(1.00000004679899702789769077397751704e-10) }},
   {{ SC_(2.48679518699645996093750000000000000e-03), SC_(1.66756677910662176600453676655888557e-11), SC_(-9.99999854318503798189158251136318825e-11) }},
   {{ SC_(2.48679518699645996093750000000000000e-03), SC_(-1.66756747299601215672737453132867813e-11), SC_(1.00000027052735056421443308767006033e-10) }},
   {{ SC_(4.97359037399291992187500000000000000e-03), SC_(1.88550702828749194850388448685407639e-11), SC_(-1.00000001339274599925662637173512694e-10) }},
   {{ SC_(4.97359037399291992187500000000000000e-03), SC_(-1.88550772217688233922672225162386894e-11), SC_(1.00000038150484533530820321563274909e-10) }},
   {{ SC_(9.94718074798583984375000000000000000e-03), SC_(2.16897819149686199580173706635832787e-11), SC_(-1.00000004444466800617686552372652860e-10) }},
   {{ SC_(9.94718074798583984375000000000000000e-03), SC_(-2.16897819149686199580173706635832787e-11), SC_(1.00000004454466801507579932382909323e-10) }},
   {{ SC_(1.98943614959716796875000000000000000e-02), SC_(2.55276633165379962520091794431209564e-11), SC_(-9.99999987259667267149019586043377446e-11) }},
   {{ SC_(1.98943614959716796875000000000000000e-02), SC_(-2.55276702554319001592375570908188820e-11), SC_(1.00000025917827167439687875973692701e-10) }},
   {{ SC_(3.97887229919433593750000000000000000e-02), SC_(3.10157177718650700626312755048274994e-11), SC_(-1.00000001002300878530057779318941967e-10) }},
   {{ SC_(3.97887229919433593750000000000000000e-02), SC_(-3.10157316496528778770880308002233505e-11), SC_(1.00000045756672268330993672752677525e-10) }},
   {{ SC_(7.95774459838867187500000000000000000e-02), SC_(3.95096871885769473919935990124940872e-11), SC_(-9.99999889508560812662080131793618651e-11) }},
   {{ SC_(7.95774459838867187500000000000000000e-02), SC_(-3.95097010663647552064503543078899384e-11), SC_(1.00000024085877976299144450309127582e-10) }},
   {{ SC_(1.59154891967773437500000000000000000e-01), SC_(5.44106010247347171571163926273584366e-11), SC_(-1.00000013265811697405270792717772649e-10) }},
   {{ SC_(1.59154891967773437500000000000000000e-01), SC_(-5.44106149025225249715731479227542877e-11), SC_(1.00000038781484104943489042069846433e-10) }},
   {{ SC_(3.18309783935546875000000000000000000e-01), SC_(8.73568439807570484845200553536415100e-11), SC_(-1.00000018094229482578861441276624850e-10) }},
   {{ SC_(3.18309783935546875000000000000000000e-01), SC_(-8.73568717363326641134335659444332123e-11), SC_(1.00000049876875311251399284176507577e-10) }},
   {{ SC_(6.36619567871093750000000000000000000e-01), SC_(2.21443363646045554560259915888309479e-10), SC_(-1.00000064351242768667579133648445499e-10) }},
   {{ SC_(6.36619567871093750000000000000000000e-01), SC_(-2.21443419157196785818086937069892883e-10), SC_(1.00000089429136462213375633424449446e-10) }},
   {{ SC_(1.27323913574218750000000000000000000e+00), SC_(-4.13968193058167344133835285902023315e-10), SC_(-9.99998763539197713323354541530611171e-11) }},
   {{ SC_(1.27323913574218750000000000000000000e+00), SC_(4.13968082035864881618181243538856506e-10), SC_(9.99998495449111690915437163249360204e-11) }},
   {{ SC_(2.54647827148437500000000000000000000e+00), SC_(-1.06984865411163809767458587884902954e-10), SC_(-9.99999663263318129751630469212780603e-11) }},
   {{ SC_(2.54647827148437500000000000000000000e+00), SC_(1.06984865411163809767458587884902954e-10), SC_(9.99999663363318062414305424221301340e-11) }},
   {{ SC_(5.09295654296875000000000000000000000e+00), SC_(-6.14303885537736960031907074153423309e-11), SC_(-9.99999810923392256887624750903049394e-11) }},
   {{ SC_(5.09295654296875000000000000000000000e+00), SC_(6.14303885537736960031907074153423309e-11), SC_(9.99999811023392219082306771605636748e-11) }},
   {{ SC_(1.01859130859375000000000000000000000e+01), SC_(-4.30847718613236452256387565284967422e-11), SC_(-1.00000000884271198597655017076328940e-10) }},
   {{ SC_(1.01859130859375000000000000000000000e+01), SC_(4.30847579835358374111820012331008911e-11), SC_(9.99999686838466495133060149009803617e-11) }},
   {{ SC_(2.03718261718750000000000000000000000e+01), SC_(-3.31768224004491685263928957283496857e-11), SC_(-1.00000014659406310395720465595004637e-10) }},
   {{ SC_(2.03718261718750000000000000000000000e+01), SC_(3.31768085226613607119361404329538345e-11), SC_(9.99999728396322717086886712270694007e-11) }},
   {{ SC_(4.07436523437500000000000000000000000e+01), SC_(-2.69738051339452056254231138154864311e-11), SC_(-9.99999893014774543392619755545315073e-11) }},
   {{ SC_(4.07436523437500000000000000000000000e+01), SC_(2.69738051339452056254231138154864311e-11), SC_(9.99999893114774522005575805599129203e-11) }},
   {{ SC_(8.14873046875000000000000000000000000e+01), SC_(-2.27249608020230198235367424786090851e-11), SC_(-9.99999909764622678224507908775150476e-11) }},
   {{ SC_(8.14873046875000000000000000000000000e+01), SC_(2.27249608020230198235367424786090851e-11), SC_(9.99999909864622660187433255956323022e-11) }},
   {{ SC_(1.62974609375000000000000000000000000e+02), SC_(-1.96325039558686853524704929441213608e-11), SC_(-1.00000012555342003228817549058586300e-10) }},
   {{ SC_(1.62974609375000000000000000000000000e+02), SC_(1.96324970169747814452421152964234352e-11), SC_(9.99999772214307463943648211224878689e-11) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(3.06796096265316009521484375000000000e-03), SC_(-7.31458980384021048801997549485404665e-10) }},
   {{ SC_(3.25949218750000000000000000000000000e+02), SC_(-1.72808850562589100263721775263547897e-11), SC_(-1.00000016409428603986636652524910696e-10) }},
   {{ SC_(3.25949218750000000000000000000000000e+02), SC_(1.72808781173650061191437998786568642e-11), SC_(9.99999762658426017441464226683857410e-11) }},
   {{ SC_(9.99999761581420898437500000000000000e-01), SC_(1.53398048132658004760742187500000000e-03), SC_(-3.65729490258889554423512369481852656e-10) }},
   {{ SC_(6.51898437500000000000000000000000000e+02), SC_(-1.54323637202580243865668307989835739e-11), SC_(-1.00000000500698774998647944161278149e-10) }},
   {{ SC_(6.51898437500000000000000000000000000e+02), SC_(1.54323637202580243865668307989835739e-11), SC_(1.00000000510698775099787699426827965e-10) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(1.35445300808445523443879210390150547e-12), SC_(1.00000001204937071507250950931195806e-11) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-1.35445300808445523443879210390150547e-12), SC_(-1.00000001203937071483162209356224834e-11) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(1.49478866784402697476252797059714794e-12), SC_(9.99999736762569630151075105126420296e-12) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-1.49478910152489596896430157357826829e-12), SC_(-1.00000002688104341637398453074349233e-11) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(1.66756712605131696136595564894378185e-12), SC_(9.99999975536367068205061399908039502e-12) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-1.66756712605131696136595564894378185e-12), SC_(-9.99999975526367068694434052551904822e-12) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(1.88550650787044915546175616327673197e-12), SC_(9.99999639190991132640126350469817159e-12) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-1.88550737523218714386530336923897266e-12), SC_(-1.00000009919607006052776121028626428e-11) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(2.16897767107981920275960874278098345e-12), SC_(9.99999691544703055965313847321245243e-12) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-2.16897853844155719116315594874322414e-12), SC_(-1.00000009142884766218349117424993457e-11) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(2.55276615818145202752020850311964750e-12), SC_(9.99999786343581285767955783425158313e-12) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-2.55276702554319001592375570908188820e-12), SC_(-1.00000012610679156946777227850912710e-11) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(3.10157195065885460394383699167519808e-12), SC_(9.99999904395533231643810175464776762e-12) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-3.10157195065885460394383699167519808e-12), SC_(-9.99999904385533233555999419401077561e-12) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(3.95096975969178032528361654840409756e-12), SC_(9.99999947128897028486851839502835410e-12) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-3.95096975969178032528361654840409756e-12), SC_(-9.99999947118897029544373870963700749e-12) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(5.44105906163938612962738261558115482e-12), SC_(9.99999657904484549492383966624089393e-12) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-5.44106079636286210643447702750563622e-12), SC_(-9.99999976715299191453269682748975317e-12) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(8.73568231640753367628349224105477333e-12), SC_(9.99999487514139362828400828979584158e-12) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-8.73568578585448562989768106490373611e-12), SC_(-9.99999884662031360826434743870157817e-12) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(2.21443349768257746745803160592913628e-11), SC_(9.99999427027613434256466003498452256e-12) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-2.21443419157196785818086937069892883e-11), SC_(-9.99999740365922856233380103890331177e-12) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-4.13968165302591728504921775311231613e-11), SC_(1.00000085360165461454801268579859839e-11) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(4.13968165302591728504921775311231613e-11), SC_(-1.00000085359165459747607230740587025e-11) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-1.06984872350057713674686965532600880e-11), SC_(1.00000028564070971260341921083768753e-11) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(1.06984837655588194138545077294111252e-11), SC_(-9.99999961337389847170320958861840329e-12) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-6.14303920232206479568048962391912937e-12), SC_(1.00000018755009687696990227972114906e-11) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(6.14303746759858881887339521199464798e-12), SC_(-9.99999905151568302114041346131601756e-12) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-4.30847718613236452256387565284967422e-12), SC_(1.00000023339860222327049268134991982e-11) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(4.30847545140888854575678124092519283e-12), SC_(-9.99999830758205006252894492056968576e-12) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-3.31768206657256925495858013164252043e-12), SC_(1.00000026723558849612716810280235318e-11) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(3.31768119921083126655503292568027973e-12), SC_(-1.00000000578945556398530963402128133e-11) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-2.69738051339452056254231138154864311e-12), SC_(1.00000003362159839001736116299506788e-11) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(2.69738051339452056254231138154864311e-12), SC_(-1.00000003361159838934502918390068736e-11) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-2.27249642714699717771509313024580479e-12), SC_(1.00000018090328575887291370549179396e-11) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(2.27249555978525918931154592428356409e-12), SC_(-9.99999799215284187212934329423506443e-12) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-1.96325074253156373060846817679703236e-12), SC_(1.00000040462665876491325807282273551e-11) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(1.96324987516982574220492097083479166e-12), SC_(-9.99999962817722868156427299327407967e-12) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-1.72808815868119580727579887025058270e-12), SC_(1.00000005342647251769909316738795814e-11) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(1.72808815868119580727579887025058270e-12), SC_(-1.00000005341647251663066368850612356e-11) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-1.54323645876197623749703780049458146e-12), SC_(1.00000014167915254916572695420915718e-11) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(1.54323602508110724329526419751346111e-12), SC_(-9.99999860648750281377661842392347043e-12) }},
   {{ SC_(6.21698796749114990234375000000000000e-04), SC_(1.35445300808445523443879210390150547e-12), SC_(-1.00000008261556108456633103349456631e-11) }},
   {{ SC_(6.21698796749114990234375000000000000e-04), SC_(-1.35445300808445523443879210390150547e-12), SC_(1.00000008262556108621874232346398794e-11) }},
   {{ SC_(1.24339759349822998046875000000000000e-03), SC_(1.49478866784402697476252797059714794e-12), SC_(-9.99999814641199919814899321059524527e-12) }},
   {{ SC_(1.24339759349822998046875000000000000e-03), SC_(-1.49478910152489596896430157357826829e-12), SC_(1.00000010477969630058383284756737123e-11) }},
   {{ SC_(2.48679518699645996093750000000000000e-03), SC_(1.66756712605131696136595564894378185e-12), SC_(-1.00000006241792715977047274159349396e-11) }},
   {{ SC_(2.48679518699645996093750000000000000e-03), SC_(-1.66756712605131696136595564894378185e-12), SC_(1.00000006242792716101893132376760610e-11) }},
   {{ SC_(4.97359037399291992187500000000000000e-03), SC_(1.88550650787044915546175616327673197e-12), SC_(-9.99999737428671530803556099870861468e-12) }},
   {{ SC_(4.97359037399291992187500000000000000e-03), SC_(-1.88550737523218714386530336923897266e-12), SC_(1.00000019745379565085464434612012203e-11) }},
   {{ SC_(9.94718074798583984375000000000000000e-03), SC_(2.16897767107981920275960874278098345e-12), SC_(-9.99999804553154132891898562500185545e-12) }},
   {{ SC_(9.94718074798583984375000000000000000e-03), SC_(-2.16897853844155719116315594874322414e-12), SC_(1.00000020445734393246067415770581270e-11) }},
   {{ SC_(1.98943614959716796875000000000000000e-02), SC_(2.55276615818145202752020850311964750e-12), SC_(-9.99999919350016171033770647654303286e-12) }},
   {{ SC_(1.98943614959716796875000000000000000e-02), SC_(-2.55276702554319001592375570908188820e-12), SC_(1.00000025913327165107368128845503323e-11) }},
   {{ SC_(3.97887229919433593750000000000000000e-02), SC_(3.10157195065885460394383699167519808e-12), SC_(-1.00000006599847301705249083970724093e-11) }},
   {{ SC_(3.97887229919433593750000000000000000e-02), SC_(-3.10157195065885460394383699167519808e-12), SC_(1.00000006600847301837256034362607570e-11) }},
   {{ SC_(7.95774459838867187500000000000000000e-02), SC_(3.95096975969178032528361654840409756e-12), SC_(-1.00000015299122500305579455993049554e-11) }},
   {{ SC_(7.95774459838867187500000000000000000e-02), SC_(-3.95096975969178032528361654840409756e-12), SC_(1.00000015300122500611571929410065908e-11) }},
   {{ SC_(1.59154891967773437500000000000000000e-01), SC_(5.44105906163938612962738261558115482e-12), SC_(-9.99999941410573970406556028609292725e-12) }},
   {{ SC_(1.59154891967773437500000000000000000e-01), SC_(-5.44106079636286210643447702750563622e-12), SC_(1.00000026024147900159167478133500825e-11) }},
   {{ SC_(3.18309783935546875000000000000000000e-01), SC_(8.73568231640753367628349224105477333e-12), SC_(-9.99999942692451180393526333821123262e-12) }},
   {{ SC_(3.18309783935546875000000000000000000e-01), SC_(-8.73568578585448562989768106490373611e-12), SC_(1.00000033986052395666188113263258597e-11) }},
   {{ SC_(6.36619567871093750000000000000000000e-01), SC_(2.21443349768257746745803160592913628e-11), SC_(-1.00000058088769354980209492526049265e-11) }},
   {{ SC_(6.36619567871093750000000000000000000e-01), SC_(-2.21443419157196785818086937069892883e-11), SC_(1.00000089424636454165034753683143007e-11) }},
   {{ SC_(1.27323913574218750000000000000000000e+00), SC_(-4.13968165302591728504921775311231613e-11), SC_(-9.99998696536676165638540998949891356e-12) }},
   {{ SC_(1.27323913574218750000000000000000000e+00), SC_(4.13968165302591728504921775311231613e-11), SC_(9.99998696546676139569391512037990502e-12) }},
   {{ SC_(2.54647827148437500000000000000000000e+00), SC_(-1.06984872350057713674686965532600880e-11), SC_(-9.99999728166945915047655997679007021e-12) }},
   {{ SC_(2.54647827148437500000000000000000000e+00), SC_(1.06984837655588194138545077294111252e-11), SC_(9.99999403883806825127876282012450499e-12) }},
   {{ SC_(5.09295654296875000000000000000000000e+00), SC_(-6.14303920232206479568048962391912937e-12), SC_(-9.99999867446079875922270942630514132e-12) }},
   {{ SC_(5.09295654296875000000000000000000000e+00), SC_(6.14303746759858881887339521199464798e-12), SC_(9.99999585067641687380078771840222173e-12) }},
   {{ SC_(1.01859130859375000000000000000000000e+01), SC_(-4.30847718613236452256387565284967422e-12), SC_(-1.00000000888771198677524425309570071e-11) }},
   {{ SC_(1.01859130859375000000000000000000000e+01), SC_(4.30847545140888854575678124092519283e-12), SC_(9.99999606267405157412280224472115044e-12) }},
   {{ SC_(2.03718261718750000000000000000000000e+01), SC_(-3.31768206657256925495858013164252043e-12), SC_(-1.00000009435184557088022338046269795e-11) }},
   {{ SC_(2.03718261718750000000000000000000000e+01), SC_(3.31768119921083126655503292568027973e-12), SC_(9.99999832925757836172148790586554985e-12) }},
   {{ SC_(4.07436523437500000000000000000000000e+01), SC_(-2.69738051339452056254231138154864311e-12), SC_(-9.99999893059774533766799978598864866e-12) }},
   {{ SC_(4.07436523437500000000000000000000000e+01), SC_(2.69738051339452056254231138154864311e-12), SC_(9.99999893069774531628095583604238029e-12) }},
   {{ SC_(8.14873046875000000000000000000000000e+01), SC_(-2.27249642714699717771509313024580479e-12), SC_(-1.00000006248080521915067709051247938e-11) }},
   {{ SC_(8.14873046875000000000000000000000000e+01), SC_(2.27249555978525918931154592428356409e-12), SC_(9.99999680812848840155577711533086668e-12) }},
   {{ SC_(1.62974609375000000000000000000000000e+02), SC_(-1.96325074253156373060846817679703236e-12), SC_(-1.00000030231797632088428977054226388e-11) }},
   {{ SC_(1.62974609375000000000000000000000000e+02), SC_(1.96324987516982574220492097083479166e-12), SC_(9.99999860529085624861131675513861630e-12) }},
   {{ SC_(3.25949218750000000000000000000000000e+02), SC_(-1.72808815868119580727579887025058270e-12), SC_(-9.99999963371356049095294074423712421e-12) }},
   {{ SC_(3.25949218750000000000000000000000000e+02), SC_(1.72808815868119580727579887025058270e-12), SC_(9.99999963381356048362821208811206287e-12) }},
   {{ SC_(6.51898437500000000000000000000000000e+02), SC_(-1.54323645876197623749703780049458146e-12), SC_(-1.00000006125606368388779905323375500e-11) }},
   {{ SC_(6.51898437500000000000000000000000000e+02), SC_(1.54323602508110724329526419751346111e-12), SC_(9.99999780245684012253409335819392746e-12) }},
   {{ SC_(1.00060558319091796875000000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(1.64794212614586737572575459689074979e+00) }},
   {{ SC_(9.99394416809082031250000000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(1.64950535230652756018579409240419170e+00) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(1.31934106349945068359375000000000000e-01), SC_(1.64872044557198474665964051523689885e+00) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-1.31934165954589843750000000000000000e-01), SC_(-6.22459379732760062908660896309479816e-01) }},
   {{ SC_(1.00121164321899414062500000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(1.64817633493217189506553162189632228e+00) }},
   {{ SC_(9.98789548873901367187500000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(1.64876189944220130714822389588440070e+00) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(1.45603954792022705078125000000000000e-01), SC_(1.64872114146807754093609802442608065e+00) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-1.45603954792022705078125000000000000e-01), SC_(-6.22459312781510477805543784690262095e-01) }},
   {{ SC_(1.00242519378662109375000000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(1.64864302003380095464928929741858492e+00) }},
   {{ SC_(9.97580528259277343750000000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(1.64879892849881064564577200339853043e+00) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(1.62433862686157226562500000000000000e-01), SC_(1.64872100076266379321743195297922258e+00) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-1.62433922290802001953125000000000000e-01), SC_(-6.22459427671928928594914540992818066e-01) }},
   {{ SC_(1.00485610961914062500000000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(1.64855848148746301703316557612324001e+00) }},
   {{ SC_(9.95167016983032226562500000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(1.64874186992676642584705940991461875e+00) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(1.83662891387939453125000000000000000e-01), SC_(1.64872093124853873201697345554021254e+00) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-1.83662950992584228515625000000000000e-01), SC_(-6.22459402165587613467963108548337664e-01) }},
   {{ SC_(1.00973606109619140625000000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(1.64862705811973453051173462977178864e+00) }},
   {{ SC_(9.90357398986816406250000000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(1.64873990825261085658153529753075793e+00) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(2.11275160312652587890625000000000000e-01), SC_(1.64872093222100369222592123813435196e+00) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-2.11275219917297363281250000000000000e-01), SC_(-6.22459386706188411838527806056560620e-01) }},
   {{ SC_(1.01956748962402343750000000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(1.64870234422634020479003763225391385e+00) }},
   {{ SC_(9.80807781219482421875000000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(1.64873943429057064555363486146838472e+00) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(2.48659074306488037109375000000000000e-01), SC_(1.64872070116563381775775035425689367e+00) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-2.48659133911132812500000000000000000e-01), SC_(-6.22459338174243550704961294547923381e-01) }},
   {{ SC_(1.03951787948608398437500000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(1.64870321437170364341885944054780844e+00) }},
   {{ SC_(9.61984157562255859375000000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(1.64872186691832671491408699137494955e+00) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(3.02116990089416503906250000000000000e-01), SC_(1.64872106584966303460783600158856415e+00) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-3.02116990089416503906250000000000000e-01), SC_(-6.22459302003090451937797654634311898e-01) }},
   {{ SC_(1.08059787750244140625000000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(1.64871725184577207959419189791549979e+00) }},
   {{ SC_(9.25413370132446289062500000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(1.64872723573453567725317922487579070e+00) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(3.84854793548583984375000000000000000e-01), SC_(1.64872061631305919814055298623922609e+00) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-3.84854912757873535156250000000000000e-01), SC_(-6.22459351839667769702949986708370075e-01) }},
   {{ SC_(1.16769170761108398437500000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(1.64871632185441866986248351184779178e+00) }},
   {{ SC_(8.56389999389648437500000000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(1.64872541348341625624268221896343609e+00) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(5.30001163482666015625000000000000000e-01), SC_(1.64872098844348012202003279193185954e+00) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-5.30001163482666015625000000000000000e-01), SC_(-6.22459290969846688777860088678130851e-01) }},
   {{ SC_(1.36350440979003906250000000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(1.64871928638840839223394180248948701e+00) }},
   {{ SC_(7.33404159545898437500000000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(1.64872168641687734103871853507472578e+00) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(8.50922822952270507812500000000000000e-01), SC_(1.64872029531302977384770247041773163e+00) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-8.50923061370849609375000000000000000e-01), SC_(-6.22459295213339779955455245438610203e-01) }},
   {{ SC_(1.85914468765258789062500000000000000e+00), SC_(1.57079601287841796875000000000000000e+00), SC_(1.64872020871111111164024196155210010e+00) }},
   {{ SC_(5.37881612777709960937500000000000000e-01), SC_(-1.57079648971557617187500000000000000e+00), SC_(1.64872206127468013361850507970495879e+00) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(2.15702819824218750000000000000000000e+00), SC_(1.64871918852911069142922879460791064e+00) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-2.15702915191650390625000000000000000e+00), SC_(-6.22459197008054188830750975379568260e-01) }},
   {{ SC_(3.45641994476318359375000000000000000e+00), SC_(7.85398006439208984375000000000000000e-01), SC_(1.64872079561208495792743400639628790e+00) }},
   {{ SC_(2.89316654205322265625000000000000000e-01), SC_(-7.85398244857788085937500000000000000e-01), SC_(1.64872188265822355639328641381193361e+00) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-4.03236961364746093750000000000000000e+00), SC_(1.64872410877486800781449897261470890e+00) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(4.03236770629882812500000000000000000e+00), SC_(-6.22459561780975432807671645824979784e-01) }},
   {{ SC_(1.19468383789062500000000000000000000e+01), SC_(3.92699003219604492187500000000000000e-01), SC_(1.64872075594093300585752555669948533e+00) }},
   {{ SC_(8.37041437625885009765625000000000000e-02), SC_(-3.92699122428894042968750000000000000e-01), SC_(1.64872166690873556472930566786955422e+00) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-1.04211521148681640625000000000000000e+00), SC_(1.64872248640204936751743903691952198e+00) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(1.04211473464965820312500000000000000e+00), SC_(-6.22459336212372706524304864261026953e-01) }},
   {{ SC_(1.42726928710937500000000000000000000e+02), SC_(1.96349501609802246093750000000000000e-01), SC_(1.64872068838122156427683851211993148e+00) }},
   {{ SC_(7.00638443231582641601562500000000000e-03), SC_(-1.96349561214447021484375000000000000e-01), SC_(1.64872161129002151911606919641582918e+00) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-5.98379373550415039062500000000000000e-01), SC_(1.64872202863467971883329136403029351e+00) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(5.98379135131835937500000000000000000e-01), SC_(-6.22459292707518388772100145474905739e-01) }},
   {{ SC_(2.03709765625000000000000000000000000e+04), SC_(9.81747508049011230468750000000000000e-02), SC_(1.64872069327335526686494846189819148e+00) }},
   {{ SC_(4.90894308313727378845214843750000000e-05), SC_(-9.81747806072235107421875000000000000e-02), SC_(1.64872156881701572600530048452374128e+00) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-4.19678807258605957031250000000000000e-01), SC_(1.64872163231565131346435151880424187e+00) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(4.19678688049316406250000000000000000e-01), SC_(-6.22459278285393940591526011145251164e-01) }},
   {{ SC_(4.14976896000000000000000000000000000e+08), SC_(4.90873754024505615234375000000000000e-02), SC_(1.64872075903521370470524589989726249e+00) }},
   {{ SC_(2.40977282572885087574832141399383545e-09), SC_(-4.90873903036117553710937500000000000e-02), SC_(1.64872153609985652347004455390438793e+00) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-3.23167800903320312500000000000000000e-01), SC_(1.64872217346028688462586827409703660e+00) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(3.23167681694030761718750000000000000e-01), SC_(-6.22459324222460598531855959807819174e-01) }},
   {{ SC_(1.72205786020184064000000000000000000e+17), SC_(2.45436877012252807617187500000000000e-02), SC_(1.64872074461675225955120102421889651e+00) }},
   {{ SC_(5.80700476910804189818390841359985188e-18), SC_(-2.45436951518058776855468750000000000e-02), SC_(1.64872153948649112942351088278471971e+00) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-2.62745618820190429687500000000000000e-01), SC_(1.64872127153923437727411727339249135e+00) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(2.62745618820190429687500000000000000e-01), SC_(-6.22459331321458212947060714907098360e-01) }},
   {{ SC_(2.96548338340406559191241223999324160e+34), SC_(1.22718438506126403808593750000000000e-02), SC_(1.64872074581721420332340038969128870e+00) }},
   {{ SC_(3.37213054229931879507664289799983942e-35), SC_(-1.22718475759029388427734375000000000e-02), SC_(1.64872153848926598711130292841607066e+00) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-2.21358656883239746093750000000000000e-01), SC_(1.64872185691761991146108052335297524e+00) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(2.21358597278594970703125000000000000e-01), SC_(-6.22459315735445403971277004062685430e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-1.91235661506652832031250000000000000e-01), SC_(1.64872130628119199012706699241869166e+00) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(1.91235661506652832031250000000000000e-01), SC_(-6.22459336273471049198845553486809678e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-1.68329119682312011718750000000000000e-01), SC_(1.64872186041139638058741947471783742e+00) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(1.68329060077667236328125000000000000e-01), SC_(-6.22459285037407043789749011367348837e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-1.50323092937469482421875000000000000e-01), SC_(1.64872131655393278664666697768328237e+00) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(1.50323092937469482421875000000000000e-01), SC_(-6.22459337737716213221797094394801863e-01) }},
   {{ SC_(1.00062513351440429687500000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(1.73248115106962602865457747037702889e+00) }},
   {{ SC_(9.99375104904174804687500000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(1.73315112079042281329622507849392709e+00) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(1.36189222335815429687500000000000000e-01), SC_(1.73325286376867031676726033576269564e+00) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-1.36189222335815429687500000000000000e-01), SC_(-6.34135570383642593483337904966890955e-01) }},
   {{ SC_(1.00125074386596679687500000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(1.73267001368029935675881640939310066e+00) }},
   {{ SC_(9.98750448226928710937500000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(1.73348584088585228168585225832333669e+00) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(1.50299906730651855468750000000000000e-01), SC_(1.73325284371833789830723474097356228e+00) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-1.50299906730651855468750000000000000e-01), SC_(-6.34135567699769621117308779973538911e-01) }},
   {{ SC_(1.00250339508056640625000000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(1.73304599865952371318678468076374529e+00) }},
   {{ SC_(9.97502565383911132812500000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(1.73336732804338123071354330399862083e+00) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(1.67672574520111083984375000000000000e-01), SC_(1.73325219275156298700713480857115229e+00) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-1.67672634124755859375000000000000000e-01), SC_(-6.34135611336099084513392906029632626e-01) }},
   {{ SC_(1.00501346588134765625000000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(1.73326949101419757151935038820466906e+00) }},
   {{ SC_(9.95011568069458007812500000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(1.73325679661008470126317891543659682e+00) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(1.89586281776428222656250000000000000e-01), SC_(1.73325231668503010119046771254247579e+00) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-1.89586341381072998046875000000000000e-01), SC_(-6.34135612809824944246058581611659542e-01) }},
   {{ SC_(1.01005172729492187500000000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(1.73317718602221688951053411244229674e+00) }},
   {{ SC_(9.90047931671142578125000000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(1.73328147574307776860167638376438985e+00) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(2.18089103698730468750000000000000000e-01), SC_(1.73325254346407425594834132638442883e+00) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-2.18089163303375244140625000000000000e-01), SC_(-6.34135628050127875454067848550176059e-01) }},
   {{ SC_(1.02020502090454101562500000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(1.73324843652912852856506776121248899e+00) }},
   {{ SC_(9.80195045471191406250000000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(1.73326206778298876048433445497598227e+00) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(2.56678700447082519531250000000000000e-01), SC_(1.73325224381597736497178272733535592e+00) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-2.56678819656372070312500000000000000e-01), SC_(-6.34135658250394556415908843124552340e-01) }},
   {{ SC_(1.04081821441650390625000000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(1.73324379921870785243495134178037436e+00) }},
   {{ SC_(9.60782289505004882812500000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(1.73326476050370526055678470591591072e+00) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(3.11860680580139160156250000000000000e-01), SC_(1.73325233977208273712270708733874483e+00) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-3.11860799789428710937500000000000000e-01), SC_(-6.34135640863551140703145806262835964e-01) }},
   {{ SC_(1.08330249786376953125000000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(1.73324197304934968859888306491470343e+00) }},
   {{ SC_(9.23102855682373046875000000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(1.73325553818570659577107388833809934e+00) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(3.97266983985900878906250000000000000e-01), SC_(1.73325249344730827004399123757218365e+00) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-3.97267103195190429687500000000000000e-01), SC_(-6.34135631202801992103338776679227478e-01) }},
   {{ SC_(1.17354488372802734375000000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(1.73325048776382862015985870061329976e+00) }},
   {{ SC_(8.52118968963623046875000000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(1.73325378893176412952056865829865321e+00) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(5.47094345092773437500000000000000000e-01), SC_(1.73325181307867948020262497387633644e+00) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-5.47094583511352539062500000000000000e-01), SC_(-6.34135590057571145861395770537661184e-01) }},
   {{ SC_(1.37720775604248046875000000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(1.73325149730880209115480900585905474e+00) }},
   {{ SC_(7.26106643676757812500000000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(1.73325489571611832051764109187549479e+00) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(8.78366470336914062500000000000000000e-01), SC_(1.73325217690523719074787921944788443e+00) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-8.78366708755493164062500000000000000e-01), SC_(-6.34135578295788405057615133063681068e-01) }},
   {{ SC_(1.89670133590698242187500000000000000e+00), SC_(1.57079601287841796875000000000000000e+00), SC_(1.73325179747044417126373658325811401e+00) }},
   {{ SC_(5.27230978012084960937500000000000000e-01), SC_(-1.57079648971557617187500000000000000e+00), SC_(1.73325391835568524735684483448697296e+00) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(2.22659587860107421875000000000000000e+00), SC_(1.73325100621199438731775420218670828e+00) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-2.22659683227539062500000000000000000e+00), SC_(-6.34135479301129970970851787862297761e-01) }},
   {{ SC_(3.59747695922851562500000000000000000e+00), SC_(7.85398006439208984375000000000000000e-01), SC_(1.73325239514479512035103749694841291e+00) }},
   {{ SC_(2.77972579002380371093750000000000000e-01), SC_(-7.85398244857788085937500000000000000e-01), SC_(1.73325334049235100441670403623031801e+00) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-4.16242027282714843750000000000000000e+00), SC_(1.73325635090253059859662277080609775e+00) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(4.16241836547851562500000000000000000e+00), SC_(-6.34135868588412722769000003237982281e-01) }},
   {{ SC_(1.29418411254882812500000000000000000e+01), SC_(3.92699003219604492187500000000000000e-01), SC_(1.73325244932761697056347350083722097e+00) }},
   {{ SC_(7.72687494754791259765625000000000000e-02), SC_(-3.92699122428894042968750000000000000e-01), SC_(1.73325341275033796862996676197285352e+00) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-1.07572507858276367187500000000000000e+00), SC_(1.73325439251867923027857350627509955e+00) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(1.07572460174560546875000000000000000e+00), SC_(-6.34135611949406110485488579177172296e-01) }},
   {{ SC_(1.67491210937500000000000000000000000e+02), SC_(1.96349501609802246093750000000000000e-01), SC_(1.73325231866137382645208662901813689e+00) }},
   {{ SC_(5.97045943140983581542968750000000000e-03), SC_(-1.96349561214447021484375000000000000e-01), SC_(1.73325343199488206443173918480463034e+00) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-6.17677927017211914062500000000000000e-01), SC_(1.73325332813276955739586588998151080e+00) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(6.17677927017211914062500000000000000e-01), SC_(-6.34135632541915503755431014359045429e-01) }},
   {{ SC_(2.80533203125000000000000000000000000e+04), SC_(9.81747508049011230468750000000000000e-02), SC_(1.73325245803814640659629112036339589e+00) }},
   {{ SC_(3.56464006472378969192504882812500000e-05), SC_(-9.81747806072235107421875000000000000e-02), SC_(1.73325332039527427062549249899757005e+00) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-4.33214068412780761718750000000000000e-01), SC_(1.73325319423361419079236758295329089e+00) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(4.33214068412780761718750000000000000e-01), SC_(-6.34135614618610818800938407820964091e-01) }},
   {{ SC_(7.86988800000000000000000000000000000e+08), SC_(4.90873754024505615234375000000000000e-02), SC_(1.73325246135306422138371812441924387e+00) }},
   {{ SC_(1.27066579480583641270641237497329712e-09), SC_(-4.90873903036117553710937500000000000e-02), SC_(1.73325332929616582780476344621183416e+00) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-3.33590388298034667968750000000000000e-01), SC_(1.73325334790881125821836467272791710e+00) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(3.33590269088745117187500000000000000e-01), SC_(-6.34135503728462871857942466888870482e-01) }},
   {{ SC_(6.19351326513430528000000000000000000e+17), SC_(2.45436877012252807617187500000000000e-02), SC_(1.73325245649931990473302579570347702e+00) }},
   {{ SC_(1.61459203561573088519034979704258603e-18), SC_(-2.45436951518058776855468750000000000e-02), SC_(1.73325330962178435674182696716274894e+00) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-2.71219611167907714843750000000000000e-01), SC_(1.73325339987099382319775629951600258e+00) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(2.71219491958618164062500000000000000e-01), SC_(-6.34135480452721842408815865351933589e-01) }},
   {{ SC_(3.83596142231463129810508376759599104e+35), SC_(1.22718438506126403808593750000000000e-02), SC_(1.73325246319533866298117574507111697e+00) }},
   {{ SC_(2.60690768323878835322076186478301541e-36), SC_(-1.22718475759029388427734375000000000e-02), SC_(1.73325330651108742097520750409413568e+00) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-2.28497803211212158203125000000000000e-01), SC_(1.73325346747127468356685233574293901e+00) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(2.28497743606567382812500000000000000e-01), SC_(-6.34135555231791006290224187543764702e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-1.97403311729431152343750000000000000e-01), SC_(1.73325309470064964196082192676522703e+00) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(1.97403311729431152343750000000000000e-01), SC_(-6.34135601295451331503570384743578783e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-1.73757970333099365234375000000000000e-01), SC_(1.73325324767558922511528214558521036e+00) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(1.73757910728454589843750000000000000e-01), SC_(-6.34135495579420851222197007964551815e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-1.55171275138854980468750000000000000e-01), SC_(1.73325357545218011774824776688642503e+00) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(1.55171215534210205078125000000000000e-01), SC_(-6.34135524338923487795486312087602922e-01) }},
   {{ SC_(1.00064706802368164062500000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(1.83054469738366824217338388703287578e+00) }},
   {{ SC_(9.99353170394897460937500000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(1.83136580128147235015560681897075778e+00) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(1.40960454940795898437500000000000000e-01), SC_(1.83125108801584165713293074900459107e+00) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-1.40960514545440673828125000000000000e-01), SC_(-6.46799408159672209737781546295642348e-01) }},
   {{ SC_(1.00129461288452148437500000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(1.83067688295347205726705125171165295e+00) }},
   {{ SC_(9.98706817626953125000000000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(1.83123253756964950345297394531652314e+00) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(1.55565500259399414062500000000000000e-01), SC_(1.83125124346653773438374053699127279e+00) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-1.55565559864044189453125000000000000e-01), SC_(-6.46799412959848012293265153290719476e-01) }},
   {{ SC_(1.00259113311767578125000000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(1.83093952911033263291576158187884150e+00) }},
   {{ SC_(9.97415304183959960937500000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(1.83123640779072569124537090789904407e+00) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(1.73546850681304931640625000000000000e-01), SC_(1.83125139680264710989627720498134836e+00) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-1.73546910285949707031250000000000000e-01), SC_(-6.46799417496226522108522476389875443e-01) }},
   {{ SC_(1.00518941879272460937500000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(1.83118789210498546549676263073246867e+00) }},
   {{ SC_(9.94837284088134765625000000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(1.83123923006340331455275540972865148e+00) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(1.96228325366973876953125000000000000e-01), SC_(1.83125210044262231403091502504411761e+00) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-1.96228325366973876953125000000000000e-01), SC_(-6.46799379029629497200571267895685983e-01) }},
   {{ SC_(1.01040601730346679687500000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(1.83125821724635097300257445440705497e+00) }},
   {{ SC_(9.89701032638549804687500000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(1.83129363476412147054178827505891125e+00) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(2.25729703903198242187500000000000000e-01), SC_(1.83125204407074030037114580057539276e+00) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-2.25729703903198242187500000000000000e-01), SC_(-6.46799371997198818981654565201763150e-01) }},
   {{ SC_(1.02092027664184570312500000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(1.83125220065466928930834407529676006e+00) }},
   {{ SC_(9.79508399963378906250000000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(1.83125499307563994506111419449864644e+00) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(2.65671253204345703125000000000000000e-01), SC_(1.83125164345434070943357998339283078e+00) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-2.65671372413635253906250000000000000e-01), SC_(-6.46799486957899039392679872245738926e-01) }},
   {{ SC_(1.04227781295776367187500000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(1.83122500849279360846122693699609923e+00) }},
   {{ SC_(9.59436655044555664062500000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(1.83125874246586651318598905213418583e+00) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(3.22786450386047363281250000000000000e-01), SC_(1.83125134702884536593794895767833995e+00) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-3.22786569595336914062500000000000000e-01), SC_(-6.46799420793803433133333570952525519e-01) }},
   {{ SC_(1.08634376525878906250000000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(1.83124878130483848916739205211747751e+00) }},
   {{ SC_(9.20518875122070312500000000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(1.83125178230442483155805981586877999e+00) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(4.11184906959533691406250000000000000e-01), SC_(1.83125163385751037960880341392351090e+00) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-4.11185026168823242187500000000000000e-01), SC_(-6.46799427391060910593510523408975648e-01) }},
   {{ SC_(1.18014287948608398437500000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(1.83125033646255367224603025662044161e+00) }},
   {{ SC_(8.47354888916015625000000000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(1.83125410297033016310310288663974402e+00) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(5.66261529922485351562500000000000000e-01), SC_(1.83125185735837741422968594252672740e+00) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-5.66261529922485351562500000000000000e-01), SC_(-6.46799348704702372267777284739392606e-01) }},
   {{ SC_(1.39273738861083984375000000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(1.83125143882067923466132902535983610e+00) }},
   {{ SC_(7.18010425567626953125000000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(1.83125264370269957484178378085137146e+00) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(9.09139394760131835937500000000000000e-01), SC_(1.83125153920487564396095982357291379e+00) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-9.09139633178710937500000000000000000e-01), SC_(-6.46799405412049525326466695451695161e-01) }},
   {{ SC_(1.93971729278564453125000000000000000e+00), SC_(1.57079601287841796875000000000000000e+00), SC_(1.83125111588710270481744044353656047e+00) }},
   {{ SC_(5.15538930892944335937500000000000000e-01), SC_(-1.57079648971557617187500000000000000e+00), SC_(1.83125299161884052214820920479634819e+00) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(2.30460357666015625000000000000000000e+00), SC_(1.83125098231420531975492072110918663e+00) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-2.30460357666015625000000000000000000e+00), SC_(-6.46799239542295568156484326756217235e-01) }},
   {{ SC_(3.76250362396240234375000000000000000e+00), SC_(7.85398006439208984375000000000000000e-01), SC_(1.83125138067559677857389752046452867e+00) }},
   {{ SC_(2.65780448913574218750000000000000000e-01), SC_(-7.85398244857788085937500000000000000e-01), SC_(1.83125249257738623640611806721891581e+00) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-4.30824661254882812500000000000000000e+00), SC_(1.83125533133521416637402160038022120e+00) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(4.30824470520019531250000000000000000e+00), SC_(-6.46799619348862890870150049121464139e-01) }},
   {{ SC_(1.41564369201660156250000000000000000e+01), SC_(3.92699003219604492187500000000000000e-01), SC_(1.83125164769467224777193884372236219e+00) }},
   {{ SC_(7.06392228603363037109375000000000000e-02), SC_(-3.92699122428894042968750000000000000e-01), SC_(1.83125287291384355319003798584712087e+00) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-1.11341190338134765625000000000000000e+00), SC_(1.83125282018688056364308126941417988e+00) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(1.11341190338134765625000000000000000e+00), SC_(-6.46799468818191345535257463392055422e-01) }},
   {{ SC_(2.00404663085937500000000000000000000e+02), SC_(1.96349501609802246093750000000000000e-01), SC_(1.83125152789088470906578693052108852e+00) }},
   {{ SC_(4.98990155756473541259765625000000000e-03), SC_(-1.96349561214447021484375000000000000e-01), SC_(1.83125267781017256208557642863712529e+00) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-6.39317750930786132812500000000000000e-01), SC_(1.83125245647693485451762923988242913e+00) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(6.39317750930786132812500000000000000e-01), SC_(-6.46799423445146025365507726857313518e-01) }},
   {{ SC_(4.01620312500000000000000000000000000e+04), SC_(9.81747508049011230468750000000000000e-02), SC_(1.83125154355573309865394468190921811e+00) }},
   {{ SC_(2.48991273110732436180114746093750000e-05), SC_(-9.81747806072235107421875000000000000e-02), SC_(1.83125256889064140601900881294491868e+00) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-4.48391437530517578125000000000000000e-01), SC_(1.83125284205865427052296511466950442e+00) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(4.48391318321228027343750000000000000e-01), SC_(-6.46799373821229457142130254787815116e-01) }},
   {{ SC_(1.61298944000000000000000000000000000e+09), SC_(4.90873754024505615234375000000000000e-02), SC_(1.83125160265215623591735673472591455e+00) }},
   {{ SC_(6.19966744608291264739818871021270752e-10), SC_(-4.90873903036117553710937500000000000e-02), SC_(1.83125252321453721364695771514603155e+00) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-3.45277428627014160156250000000000000e-01), SC_(1.83125233373566488559071173935187558e+00) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(3.45277428627014160156250000000000000e-01), SC_(-6.46799408133092485121968176123069681e-01) }},
   {{ SC_(2.60173478238774886400000000000000000e+18), SC_(2.45436877012252807617187500000000000e-02), SC_(1.83125159861474539359606460633295332e+00) }},
   {{ SC_(3.84358777404655530690342352118094027e-19), SC_(-2.45436951518058776855468750000000000e-02), SC_(1.83125252086703815607857516265910874e+00) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-2.80721545219421386718750000000000000e-01), SC_(1.83125236855717256167227605414385224e+00) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(2.80721545219421386718750000000000000e-01), SC_(-6.46799412477098430151065929677957122e-01) }},
   {{ SC_(6.76902602811070392270012571013087232e+36), SC_(1.22718438506126403808593750000000000e-02), SC_(1.83125160965161654015843931730453329e+00) }},
   {{ SC_(1.47731700024852691527012545691116081e-37), SC_(-1.22718475759029388427734375000000000e-02), SC_(1.83125251375099397741260088232711217e+00) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-2.36503005027770996093750000000000000e-01), SC_(1.83125228792837543578448980315170242e+00) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(2.36503005027770996093750000000000000e-01), SC_(-6.46799402418602888248712170947392274e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-2.04319179058074951171875000000000000e-01), SC_(1.83125233903505297436249892702227265e+00) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(2.04319179058074951171875000000000000e-01), SC_(-6.46799408794194635460345860548887589e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-1.79845452308654785156250000000000000e-01), SC_(1.83125267169047914916756972944876429e+00) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(1.79845392704010009765625000000000000e-01), SC_(-6.46799328468380902803730980056237389e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-1.60607576370239257812500000000000000e-01), SC_(1.83125284652944036669754448918344077e+00) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(1.60607516765594482421875000000000000e-01), SC_(-6.46799335687245851236741219262503967e-01) }},
   {{ SC_(1.00067186355590820312500000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(1.94564077405233058342639872888817491e+00) }},
   {{ SC_(9.99328613281250000000000000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(1.94551970512101387338376485011251429e+00) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(1.46316945552825927734375000000000000e-01), SC_(1.94546280935885249772938375938801274e+00) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-1.46316945552825927734375000000000000e-01), SC_(-6.60494779692135062466389483274134653e-01) }},
   {{ SC_(1.00134372711181640625000000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(1.94457302376145242906144883264635648e+00) }},
   {{ SC_(9.98657703399658203125000000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(1.94545784813345662922038300342852822e+00) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(1.61476969718933105468750000000000000e-01), SC_(1.94546273716278632282676930722047008e+00) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-1.61477029323577880859375000000000000e-01), SC_(-6.60494906748068420037563673150509420e-01) }},
   {{ SC_(1.00268983840942382812500000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(1.94525635587759558622731543443798320e+00) }},
   {{ SC_(9.97317075729370117187500000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(1.94561560474752764548978692615189977e+00) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(1.80141568183898925781250000000000000e-01), SC_(1.94546217832039935098911492414216929e+00) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-1.80141627788543701171875000000000000e-01), SC_(-6.60494828307199528181979267386288426e-01) }},
   {{ SC_(1.00538730621337890625000000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(1.94548852981754731417650613976545532e+00) }},
   {{ SC_(9.94641542434692382812500000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(1.94550075022239762629466907387206997e+00) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(2.03684926033020019531250000000000000e-01), SC_(1.94546286530234341313185527893031352e+00) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-2.03684926033020019531250000000000000e-01), SC_(-6.60494786140393986985259017849458884e-01) }},
   {{ SC_(1.01080322265625000000000000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(1.94536759205590891664523250868652333e+00) }},
   {{ SC_(9.89311933517456054687500000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(1.94546016944614575807630172166190519e+00) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(2.34307348728179931640625000000000000e-01), SC_(1.94546284727459813703491801001349611e+00) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-2.34307348728179931640625000000000000e-01), SC_(-6.60494784062447724301609365971619078e-01) }},
   {{ SC_(1.02172374725341796875000000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(1.94545342212939462355160803955360946e+00) }},
   {{ SC_(9.78738069534301757812500000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(1.94546505033178190641908997489744839e+00) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(2.75766611099243164062500000000000000e-01), SC_(1.94546182673952190249532861798005722e+00) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-2.75766730308532714843750000000000000e-01), SC_(-6.60494824974080946850801666856616819e-01) }},
   {{ SC_(1.04391956329345703125000000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(1.94546388830927064355964131697832800e+00) }},
   {{ SC_(9.57928180694580078125000000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(1.94546721886696614794545602284516450e+00) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(3.35052251815795898437500000000000000e-01), SC_(1.94546243950491028559857098482813456e+00) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-3.35052371025085449218750000000000000e-01), SC_(-6.60494867550577925649282132006495776e-01) }},
   {{ SC_(1.08976793289184570312500000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(1.94545975360520887919376704233570169e+00) }},
   {{ SC_(9.17626380920410156250000000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(1.94546796301166206869096113204895379e+00) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(4.26809787750244140625000000000000000e-01), SC_(1.94546245796865370069631496835221232e+00) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-4.26809906959533691406250000000000000e-01), SC_(-6.60494841625610271252982633571242661e-01) }},
   {{ SC_(1.18759393692016601562500000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(1.94545647111212578147269121506700971e+00) }},
   {{ SC_(8.42038393020629882812500000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(1.94546317034617170290087609908529226e+00) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(5.87779283523559570312500000000000000e-01), SC_(1.94546278635757341541145058885594973e+00) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-5.87779283523559570312500000000000000e-01), SC_(-6.60494777040920333706604210833093091e-01) }},
   {{ SC_(1.41037988662719726562500000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(1.94545993278438098322952331466046013e+00) }},
   {{ SC_(7.09028482437133789062500000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(1.94546542663047179349084706549588949e+00) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(9.43686246871948242187500000000000000e-01), SC_(1.94546194170063826380348389079362337e+00) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-9.43686485290527343750000000000000000e-01), SC_(-6.60494772341944954609659402332104034e-01) }},
   {{ SC_(1.98917245864868164062500000000000000e+00), SC_(1.57079601287841796875000000000000000e+00), SC_(1.94546233792613747943639850938486832e+00) }},
   {{ SC_(5.02721548080444335937500000000000000e-01), SC_(-1.57079648971557617187500000000000000e+00), SC_(1.94546396170126003121902060678972284e+00) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(2.39217758178710937500000000000000000e+00), SC_(1.94546160233166631938926042023480564e+00) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-2.39217758178710937500000000000000000e+00), SC_(-6.60494640565544365557325578379696147e-01) }},
   {{ SC_(3.95680713653564453125000000000000000e+00), SC_(7.85398006439208984375000000000000000e-01), SC_(1.94546237668233791420874607515027992e+00) }},
   {{ SC_(2.52728939056396484375000000000000000e-01), SC_(-7.85398244857788085937500000000000000e-01), SC_(1.94546410676643983236488090069199735e+00) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-4.47195816040039062500000000000000000e+00), SC_(1.94546623937211318364827591416664233e+00) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(4.47195625305175781250000000000000000e+00), SC_(-6.60495018621795622925935624847285375e-01) }},
   {{ SC_(1.56563224792480468750000000000000000e+01), SC_(3.92699003219604492187500000000000000e-01), SC_(1.94546235921049185806188128774092453e+00) }},
   {{ SC_(6.38719499111175537109375000000000000e-02), SC_(-3.92699122428894042968750000000000000e-01), SC_(1.94546350418507684007371679022420734e+00) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-1.15572118759155273437500000000000000e+00), SC_(1.94546381156790022051859002244731593e+00) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(1.15572118759155273437500000000000000e+00), SC_(-6.60494895210513596046057936919670635e-01) }},
   {{ SC_(2.45120422363281250000000000000000000e+02), SC_(1.96349501609802246093750000000000000e-01), SC_(1.94546233275929815037848757797175642e+00) }},
   {{ SC_(4.07962687313556671142578125000000000e-03), SC_(-1.96349561214447021484375000000000000e-01), SC_(1.94546337834378711006461735118607172e+00) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-6.63611650466918945312500000000000000e-01), SC_(1.94546359320979430562087800771178707e+00) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(6.63611412048339843750000000000000000e-01), SC_(-6.60494738275759281551332648686049714e-01) }},
   {{ SC_(6.00840312500000000000000000000000000e+04), SC_(9.81747508049011230468750000000000000e-02), SC_(1.94546237987837353939619209052297901e+00) }},
   {{ SC_(1.66433528647758066654205322265625000e-05), SC_(-9.81747806072235107421875000000000000e-02), SC_(1.94546342280924052842678528376545354e+00) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-4.65430140495300292968750000000000000e-01), SC_(1.94546367512247325523555892069884322e+00) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(4.65430021286010742187500000000000000e-01), SC_(-6.60494785547148152887843878020041544e-01) }},
   {{ SC_(3.61009049600000000000000000000000000e+09), SC_(4.90873754024505615234375000000000000e-02), SC_(1.94546236725249450687880140136188154e+00) }},
   {{ SC_(2.77001310777791331929620355367660522e-10), SC_(-4.90873903036117553710937500000000000e-02), SC_(1.94546336215874866003004613451247994e+00) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-3.58397841453552246093750000000000000e-01), SC_(1.94546315038362269062854803353465040e+00) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(3.58397841453552246093750000000000000e-01), SC_(-6.60494818999939582003453474407504680e-01) }},
   {{ SC_(1.30327532165870387200000000000000000e+19), SC_(2.45436877012252807617187500000000000e-02), SC_(1.94546236629440517726221942789915664e+00) }},
   {{ SC_(7.67297389095134081991389854437990437e-20), SC_(-2.45436951518058776855468750000000000e-02), SC_(1.94546335015840762091410018727131722e+00) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-2.91388869285583496093750000000000000e-01), SC_(1.94546330377879434130403735507858661e+00) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(2.91388869285583496093750000000000000e-01), SC_(-6.60494836680844127303819823703904847e-01) }},
   {{ SC_(1.69852686466266890371577078013591814e+38), SC_(1.22718438506126403808593750000000000e-02), SC_(1.94546237269184192911455893164247958e+00) }},
   {{ SC_(5.88745460437128753665694333566258575e-39), SC_(-1.22718475759029388427734375000000000e-02), SC_(1.94546333928374646125386227479375806e+00) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-2.45490074157714843750000000000000000e-01), SC_(1.94546366623189437507481754411263617e+00) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(2.45490014553070068359375000000000000e-01), SC_(-6.60494789410710542701334363771056608e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-2.12083280086517333984375000000000000e-01), SC_(1.94546388875407459838058240574991703e+00) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(2.12083220481872558593750000000000000e-01), SC_(-6.60494801032865078042436879419588612e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-1.86679482460021972656250000000000000e-01), SC_(1.94546301074957437329850078012509659e+00) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(1.86679482460021972656250000000000000e-01), SC_(-6.60494802905192279207717663735915963e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-1.66710615158081054687500000000000000e-01), SC_(1.94546391609515603283858843685357390e+00) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(1.66710555553436279296875000000000000e-01), SC_(-6.60494776131126592696474289988582129e-01) }},
   {{ SC_(1.00069952011108398437500000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(2.07954335713649059861094340029142220e+00) }},
   {{ SC_(9.99300956726074218750000000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(2.07960463142861921135235583835396656e+00) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(1.52337312698364257812500000000000000e-01), SC_(2.07933804444019282061373774581443311e+00) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-1.52337372303009033203125000000000000e-01), SC_(-6.75255023805753736181704475155510419e-01) }},
   {{ SC_(1.00139904022216796875000000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(2.07833336130861405302323869826337934e+00) }},
   {{ SC_(9.98602390289306640625000000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(2.07963395867197453148154593204324266e+00) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(1.68121159076690673828125000000000000e-01), SC_(2.07933893018688046403766608956917019e+00) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-1.68121159076690673828125000000000000e-01), SC_(-6.75254974307322676265250001202924146e-01) }},
   {{ SC_(1.00280046463012695312500000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(2.07886034364960766780285877828572830e+00) }},
   {{ SC_(9.97206926345825195312500000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(2.07939496603075366184237295748290376e+00) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(1.87553763389587402343750000000000000e-01), SC_(2.07933879426428646913876780723665975e+00) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-1.87553763389587402343750000000000000e-01), SC_(-6.75254959973016116264035672220356015e-01) }},
   {{ SC_(1.00560951232910156250000000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(2.07931620022112704890092991133843094e+00) }},
   {{ SC_(9.94421720504760742187500000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(2.07935352912867051992229551986199466e+00) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(2.12065756320953369140625000000000000e-01), SC_(2.07933804418808297990418681799287458e+00) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-2.12065815925598144531250000000000000e-01), SC_(-6.75254983528850978156253491591478159e-01) }},
   {{ SC_(1.01125049591064453125000000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(2.07931761569259491721518486263545287e+00) }},
   {{ SC_(9.88874435424804687500000000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(2.07939196819388993767869751925406122e+00) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(2.43948221206665039062500000000000000e-01), SC_(2.07933874059472929018415853477436464e+00) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-2.43948221206665039062500000000000000e-01), SC_(-6.75254954313059884575159155406226806e-01) }},
   {{ SC_(1.02262735366821289062500000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(2.07928555641783849703024144637521811e+00) }},
   {{ SC_(9.77872848510742187500000000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(2.07936039368280520442996501523756870e+00) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(2.87113428115844726562500000000000000e-01), SC_(2.07933824139997955624157868802344866e+00) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-2.87113547325134277343750000000000000e-01), SC_(-6.75255053317972514051718466535554892e-01) }},
   {{ SC_(1.04576730728149414062500000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(2.07933016712903278407597092082190320e+00) }},
   {{ SC_(9.56235408782958984375000000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(2.07935222506387300500342088206959745e+00) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(3.48838448524475097656250000000000000e-01), SC_(2.07933876990777660094532633348823251e+00) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-3.48838448524475097656250000000000000e-01), SC_(-6.75254957404394615648501216003649223e-01) }},
   {{ SC_(1.09362936019897460937500000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(2.07933367784895733346977311441821341e+00) }},
   {{ SC_(9.14386272430419921875000000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(2.07934734055687991131501450317740236e+00) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(4.44371461868286132812500000000000000e-01), SC_(2.07933866829496394626705223845581831e+00) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-4.44371461868286132812500000000000000e-01), SC_(-6.75254946688373830551171293261535785e-01) }},
   {{ SC_(1.19602537155151367187500000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(2.07933681718322600332806069861347414e+00) }},
   {{ SC_(8.36102485656738281250000000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(2.07934200781162313555564446500261189e+00) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(6.11963987350463867187500000000000000e-01), SC_(2.07933743556637841287211812404680137e+00) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-6.11964225769042968750000000000000000e-01), SC_(-6.75254958983676197253826914648262290e-01) }},
   {{ SC_(1.43047666549682617187500000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(2.07933665556521925614368193043778563e+00) }},
   {{ SC_(6.99067592620849609375000000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(2.07933887893761799906861339332402839e+00) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(9.82515573501586914062500000000000000e-01), SC_(2.07933832373007868281902628913239271e+00) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-9.82515573501586914062500000000000000e-01), SC_(-6.75254910350781052291358885336068224e-01) }},
   {{ SC_(2.04626369476318359375000000000000000e+00), SC_(1.57079601287841796875000000000000000e+00), SC_(2.07933713833466088688406834451632593e+00) }},
   {{ SC_(4.88695383071899414062500000000000000e-01), SC_(-1.57079648971557617187500000000000000e+00), SC_(2.07934002689387881093027124615420648e+00) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(2.49060630798339843750000000000000000e+00), SC_(2.07933676153691548106839120897285603e+00) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-2.49060726165771484375000000000000000e+00), SC_(-6.75254885458403139748274507509573095e-01) }},
   {{ SC_(4.18719673156738281250000000000000000e+00), SC_(7.85398006439208984375000000000000000e-01), SC_(2.07933807580772128316245798346609707e+00) }},
   {{ SC_(2.38823235034942626953125000000000000e-01), SC_(-7.85398244857788085937500000000000000e-01), SC_(2.07933944360043038492165781288430564e+00) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-4.65596199035644531250000000000000000e+00), SC_(2.07934202387816428787320411460950242e+00) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(4.65596008300781250000000000000000000e+00), SC_(-6.75255150940087815804283739560619414e-01) }},
   {{ SC_(1.75326156616210937500000000000000000e+01), SC_(3.92699003219604492187500000000000000e-01), SC_(2.07933802013193204843802627749608026e+00) }},
   {{ SC_(5.70365339517593383789062500000000000e-02), SC_(-3.92699122428894042968750000000000000e-01), SC_(2.07933952079037327341616459122090354e+00) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-1.20327472686767578125000000000000000e+00), SC_(2.07933958284077644434829310714423109e+00) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(1.20327472686767578125000000000000000e+00), SC_(-6.75255043135751797754263538795777873e-01) }},
   {{ SC_(3.07392700195312500000000000000000000e+02), SC_(1.96349501609802246093750000000000000e-01), SC_(2.07933819372956300148184603666869117e+00) }},
   {{ SC_(3.25316749513149261474609375000000000e-03), SC_(-1.96349561214447021484375000000000000e-01), SC_(2.07933928105195522874528605573045586e+00) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-6.90916776657104492187500000000000000e-01), SC_(2.07933947607951322758764380054793358e+00) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(6.90916538238525390625000000000000000e-01), SC_(-6.75254905839393661637057664645770663e-01) }},
   {{ SC_(9.44902500000000000000000000000000000e+04), SC_(9.81747508049011230468750000000000000e-02), SC_(2.07933812291581294943685957624755133e+00) }},
   {{ SC_(1.05830986285582184791564941406250000e-05), SC_(-9.81747806072235107421875000000000000e-02), SC_(2.07933928456044663576459526085868182e+00) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-4.84580874443054199218750000000000000e-01), SC_(2.07933979619060167451614469461860404e+00) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(4.84580755233764648437500000000000000e-01), SC_(-6.75254975783243026291049511554392045e-01) }},
   {{ SC_(8.92841164800000000000000000000000000e+09), SC_(4.90873754024505615234375000000000000e-02), SC_(2.07933819576389683135388006437316875e+00) }},
   {{ SC_(1.12001991015020507802546489983797073e-10), SC_(-4.90873903036117553710937500000000000e-02), SC_(2.07933926508150788167121967957393131e+00) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-3.73144626617431640625000000000000000e-01), SC_(2.07933955569817825422028221874989889e+00) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(3.73144507408142089843750000000000000e-01), SC_(-6.75254923587528917704329205802306948e-01) }},
   {{ SC_(7.97165281542248857600000000000000000e+19), SC_(2.45436877012252807617187500000000000e-02), SC_(2.07933818969431370575377819622225566e+00) }},
   {{ SC_(1.25444492521338197253089551640170551e-20), SC_(-2.45436951518058776855468750000000000e-02), SC_(2.07933924543565970020855374818223886e+00) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-3.03378462791442871093750000000000000e-01), SC_(2.07933957543649389989947682334929448e+00) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(3.03378343582153320312500000000000000e-01), SC_(-6.75254898835567218530310241345966548e-01) }},
   {{ SC_(1.57363014946748307430592984744291002e-40), SC_(-1.22718475759029388427734375000000000e-02), SC_(2.07933929156478534484301561406307119e+00) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-2.55591034889221191406250000000000000e-01), SC_(2.07933910162117420928271099647593779e+00) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(2.55591034889221191406250000000000000e-01), SC_(-6.75254992386667720659946779007297052e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-2.20809698104858398437500000000000000e-01), SC_(2.07933960722449394020016086331432828e+00) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(2.20809638500213623046875000000000000e-01), SC_(-6.75254947114035622662621549843952642e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-1.94360673427581787109375000000000000e-01), SC_(2.07933940571084667535959121887804200e+00) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(1.94360613822937011718750000000000000e-01), SC_(-6.75254912445767255971309149789212813e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-1.73570096492767333984375000000000000e-01), SC_(2.07933914635071741151342820108524263e+00) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(1.73570036888122558593750000000000000e-01), SC_(-6.75254871677041078927387349412125227e-01) }},
   {{ SC_(1.00073051452636718750000000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(2.23684817130467252521865064665569166e+00) }},
   {{ SC_(9.99269962310791015625000000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(2.23714332655642609234390263520111804e+00) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(1.59111559391021728515625000000000000e-01), SC_(2.23726644699372681807418560614423647e+00) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-1.59111618995666503906250000000000000e-01), SC_(-6.91097542846863150883954036641796426e-01) }},
   {{ SC_(1.00146150588989257812500000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(2.23670048994758227847716683438553103e+00) }},
   {{ SC_(9.98540401458740234375000000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(2.23728964435128145698734108989964352e+00) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(1.75597250461578369140625000000000000e-01), SC_(2.23726649055918245771898563775819858e+00) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-1.75597310066223144531250000000000000e-01), SC_(-6.91097534241671723551515030717038445e-01) }},
   {{ SC_(1.00292539596557617187500000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(2.23702259174688848619481536233543755e+00) }},
   {{ SC_(9.97082948684692382812500000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(2.23726961740891602078807553619021396e+00) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(1.95894002914428710937500000000000000e-01), SC_(2.23726653313326460889587488816856259e+00) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-1.95894062519073486328125000000000000e-01), SC_(-6.91097525541882376151346929453373002e-01) }},
   {{ SC_(1.00585937500000000000000000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(2.23703885041662374343340671197836939e+00) }},
   {{ SC_(9.94174242019653320312500000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(2.23737734326253382944714037984997425e+00) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(2.21496045589447021484375000000000000e-01), SC_(2.23726635393205414115653989790710880e+00) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-2.21496105194091796875000000000000000e-01), SC_(-6.91097495680121145904735956568780591e-01) }},
   {{ SC_(1.01175355911254882812500000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(2.23719222500742550629081984641849832e+00) }},
   {{ SC_(9.88382577896118164062500000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(2.23732650224760588495069747454829799e+00) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(2.54796266555786132812500000000000000e-01), SC_(2.23726688276986561375602760240922559e+00) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-2.54796266555786132812500000000000000e-01), SC_(-6.91097448491987956032695923411039350e-01) }},
   {{ SC_(1.02364540100097656250000000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(2.23721394288655421785782019258490829e+00) }},
   {{ SC_(9.76900339126586914062500000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(2.23729004981592433825076430021784354e+00) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(2.99880981445312500000000000000000000e-01), SC_(2.23726646123507165332664423789245814e+00) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-2.99881100654602050781250000000000000e-01), SC_(-6.91097552520329763638349760018188346e-01) }},
   {{ SC_(1.04785060882568359375000000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(2.23726843714821667241735863969338251e+00) }},
   {{ SC_(9.54334497451782226562500000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(2.23727087886181639931884620027967696e+00) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(3.64350795745849609375000000000000000e-01), SC_(2.23726666689712845316696597569708815e+00) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-3.64350795745849609375000000000000000e-01), SC_(-6.91097427893240255757612814322906861e-01) }},
   {{ SC_(1.09799051284790039062500000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(2.23725415181537355024165825994884503e+00) }},
   {{ SC_(9.10754442214965820312500000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(2.23726600173630410861706422848623152e+00) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(4.64131951332092285156250000000000000e-01), SC_(2.23726594638710800349010612300645725e+00) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-4.64132070541381835937500000000000000e-01), SC_(-6.91097452344161416054529062282766158e-01) }},
   {{ SC_(1.20558357238769531250000000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(2.23726100315263944800204998525033134e+00) }},
   {{ SC_(8.29473495483398437500000000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(2.23726988923196441217309453638022408e+00) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(6.39177322387695312500000000000000000e-01), SC_(2.23726622022278214569941398597564898e+00) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-6.39177560806274414062500000000000000e-01), SC_(-6.91097520627362257642728636253831116e-01) }},
   {{ SC_(1.45343208312988281250000000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(2.23726333409811889075967250575759908e+00) }},
   {{ SC_(6.88026428222656250000000000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(2.23726769395820422285296132150143487e+00) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(1.02620649337768554687500000000000000e+00), SC_(2.23726564557846350917834047297483063e+00) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-1.02620697021484375000000000000000000e+00), SC_(-6.91097499052534576189998114279324243e-01) }},
   {{ SC_(2.11246585845947265625000000000000000e+00), SC_(1.57079601287841796875000000000000000e+00), SC_(2.23726583320300487911032923489100584e+00) }},
   {{ SC_(4.73380327224731445312500000000000000e-01), SC_(-1.57079648971557617187500000000000000e+00), SC_(2.23726810976361144108433796198610064e+00) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(2.60136032104492187500000000000000000e+00), SC_(2.23726491525343197297246954666581937e+00) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-2.60136127471923828125000000000000000e+00), SC_(-6.91097393782748311821723934125130460e-01) }},
   {{ SC_(4.46251106262207031250000000000000000e+00), SC_(7.85398006439208984375000000000000000e-01), SC_(2.23726529732780144432687225723254204e+00) }},
   {{ SC_(2.24088966846466064453125000000000000e-01), SC_(-7.85398244857788085937500000000000000e-01), SC_(2.23726773939075231243052638512216751e+00) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-4.86300659179687500000000000000000000e+00), SC_(2.23727072969092435433825927896582244e+00) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(4.86300468444824218750000000000000000e+00), SC_(-6.91097673241671341868889996468831976e-01) }},
   {{ SC_(1.99140167236328125000000000000000000e+01), SC_(3.92699003219604492187500000000000000e-01), SC_(2.23726604676114853887754320069247102e+00) }},
   {{ SC_(5.02158701419830322265625000000000000e-02), SC_(-3.92699122428894042968750000000000000e-01), SC_(2.23726761079318058305104262148670820e+00) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-1.25678300857543945312500000000000000e+00), SC_(2.23726869245558981034195565917076856e+00) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(1.25678253173828125000000000000000000e+00), SC_(-6.91097483494054225698721275336396715e-01) }},
   {{ SC_(3.96568115234375000000000000000000000e+02), SC_(1.96349501609802246093750000000000000e-01), SC_(2.23726613197658612251017184538106881e+00) }},
   {{ SC_(2.52163410186767578125000000000000000e-03), SC_(-1.96349561214447021484375000000000000e-01), SC_(2.23726748784423058673101347144391081e+00) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-7.21640825271606445312500000000000000e-01), SC_(2.23726726872970783750466139665958109e+00) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(7.21640825271606445312500000000000000e-01), SC_(-6.91097485320575201264622613414422549e-01) }},
   {{ SC_(1.57266250000000000000000000000000000e+05), SC_(9.81747508049011230468750000000000000e-02), SC_(2.23726609151727022950283828962170967e+00) }},
   {{ SC_(6.35864125797525048255920410156250000e-06), SC_(-9.81747806072235107421875000000000000e-02), SC_(2.23726735217922042070776005880109972e+00) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-5.06129503250122070312500000000000000e-01), SC_(2.23726786831123018876715572710259815e+00) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(5.06129264831542968750000000000000000e-01), SC_(-6.91097371595380879752013932418388188e-01) }},
   {{ SC_(2.47326801920000000000000000000000000e+10), SC_(4.90873754024505615234375000000000000e-02), SC_(2.23726613522654211853911426698295068e+00) }},
   {{ SC_(4.04323241554038759204559028148651123e-11), SC_(-4.90873903036117553710937500000000000e-02), SC_(2.23726733053228991338294451547569365e+00) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-3.89737844467163085937500000000000000e-01), SC_(2.23726762367577292264153944219036566e+00) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(3.89737725257873535156250000000000000e-01), SC_(-6.91097408196454926751546363793003294e-01) }},
   {{ SC_(6.11705641512248279040000000000000000e+20), SC_(2.45436877012252807617187500000000000e-02), SC_(2.23726615757184756354714952481207348e+00) }},
   {{ SC_(1.63477263500439065774887771121184898e-21), SC_(-2.45436951518058776855468750000000000e-02), SC_(2.23726734033076942103307820777165452e+00) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-3.16869258880615234375000000000000000e-01), SC_(2.23726742488494420185462334778007566e+00) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(3.16869139671325683593750000000000000e-01), SC_(-6.91097363703183483071128436651202845e-01) }},
   {{ SC_(2.67227617146742615425155231533387006e-42), SC_(-1.22718475759029388427734375000000000e-02), SC_(2.23727039373384319954188365125106872e+00) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-2.66956806182861328125000000000000000e-01), SC_(2.23726707786726700102792994567422118e+00) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(2.66956806182861328125000000000000000e-01), SC_(-6.91097467108334285052529329343099888e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-2.30628788471221923828125000000000000e-01), SC_(2.23726756467372719977442154560736482e+00) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(2.30628728866577148437500000000000000e-01), SC_(-6.91097419776375646028680753255014246e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-2.03003644943237304687500000000000000e-01), SC_(2.23726793006907012747628600419164628e+00) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(2.03003585338592529296875000000000000e-01), SC_(-6.91097441880434039332344472159678259e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-1.81288540363311767578125000000000000e-01), SC_(2.23726770448518015510557442992562033e+00) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(1.81288480758666992187500000000000000e-01), SC_(-6.91097407592800950724461370583406942e-01) }},
   {{ SC_(1.00076532363891601562500000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(2.42310663777752486469206678024795968e+00) }},
   {{ SC_(9.99234914779663085937500000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(2.42501970769265171234816056550434639e+00) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(1.66741967201232910156250000000000000e-01), SC_(2.42487508589282706848078871163485685e+00) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-1.66742026805877685546875000000000000e-01), SC_(-7.08018676635887164877050571349063035e-01) }},
   {{ SC_(1.00153160095214843750000000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(2.42411822502563523242932181168506470e+00) }},
   {{ SC_(9.98470306396484375000000000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(2.42531909920730717909184314628899348e+00) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(1.84018254280090332031250000000000000e-01), SC_(2.42487519436059155279862808846444369e+00) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-1.84018313884735107421875000000000000e-01), SC_(-7.08018673819956019113008112253272056e-01) }},
   {{ SC_(1.00306606292724609375000000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(2.42482554820159048077466461326422532e+00) }},
   {{ SC_(9.96943235397338867187500000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(2.42492861608730277905256731059994671e+00) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(2.05288410186767578125000000000000000e-01), SC_(2.42487617025831474388087859297228062e+00) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-2.05288410186767578125000000000000000e-01), SC_(-7.08018640590857651380068251251441057e-01) }},
   {{ SC_(1.00614118576049804687500000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(2.42459228850006892699886719000461342e+00) }},
   {{ SC_(9.93895769119262695312500000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(2.42496013078597135425377253090822307e+00) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(2.32118248939514160156250000000000000e-01), SC_(2.42487614521028443258790752437502465e+00) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-2.32118248939514160156250000000000000e-01), SC_(-7.08018638455435046086504107274839822e-01) }},
   {{ SC_(1.01232051849365234375000000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(2.42473948497967282041049124082756885e+00) }},
   {{ SC_(9.87828969955444335937500000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(2.42490084794753148714060301044663060e+00) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(2.67015337944030761718750000000000000e-01), SC_(2.42487518006596199623673706969446920e+00) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-2.67015457153320312500000000000000000e-01), SC_(-7.08018716649824292923592999410402960e-01) }},
   {{ SC_(1.02479362487792968750000000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(2.42487264884790161504766974210121932e+00) }},
   {{ SC_(9.75806236267089843750000000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(2.42487219987661255931173039370679386e+00) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(3.14262151718139648437500000000000000e-01), SC_(2.42487478506147865139310635698017107e+00) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-3.14262270927429199218750000000000000e-01), SC_(-7.08018658848161648784704276400837342e-01) }},
   {{ SC_(1.05020189285278320312500000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(2.42486603145158931299755182242272032e+00) }},
   {{ SC_(9.52197790145874023437500000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(2.42487406133356494799463833759581923e+00) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(3.81823778152465820312500000000000000e-01), SC_(2.42487590713607211265555694309234490e+00) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-3.81823778152465820312500000000000000e-01), SC_(-7.08018618158865317242926917783610626e-01) }},
   {{ SC_(1.10292387008666992187500000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(2.42486034734318868395293757239747840e+00) }},
   {{ SC_(9.06680583953857421875000000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(2.42487632103643263772532717371427057e+00) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(4.86390113830566406250000000000000000e-01), SC_(2.42487534142802052632979506896510415e+00) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-4.86390233039855957031250000000000000e-01), SC_(-7.08018658027561471848013927462247816e-01) }},
   {{ SC_(1.21644163131713867187500000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(2.42487039731132700550226802896194711e+00) }},
   {{ SC_(8.22069644927978515625000000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(2.42487727363383318502245969915341966e+00) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(6.69830083847045898437500000000000000e-01), SC_(2.42487582516626008654931133193978005e+00) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-6.69830083847045898437500000000000000e-01), SC_(-7.08018611170682327140298723446545134e-01) }},
   {{ SC_(1.47973060607910156250000000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(2.42487304171678232660587181586821688e+00) }},
   {{ SC_(6.75798416137695312500000000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(2.42487862653323476760333908388161133e+00) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(1.07541990280151367187500000000000000e+00), SC_(2.42487538686894271057642731191068516e+00) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-1.07541990280151367187500000000000000e+00), SC_(-7.08018573804458744741121707162514383e-01) }},
   {{ SC_(2.18960285186767578125000000000000000e+00), SC_(1.57079601287841796875000000000000000e+00), SC_(2.42487349699349810010102005052456549e+00) }},
   {{ SC_(4.56703662872314453125000000000000000e-01), SC_(-1.57079648971557617187500000000000000e+00), SC_(2.42487669917739113112124059647174975e+00) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(2.72611236572265625000000000000000000e+00), SC_(2.42487389560500292844516968541098519e+00) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-2.72611331939697265625000000000000000e+00), SC_(-7.08018572414968891555791359557615479e-01) }},
   {{ SC_(4.79436302185058593750000000000000000e+00), SC_(7.85398006439208984375000000000000000e-01), SC_(2.42487482833971603014347557450100367e+00) }},
   {{ SC_(2.08578228950500488281250000000000000e-01), SC_(-7.85398244857788085937500000000000000e-01), SC_(2.42487678597593814675406284212058377e+00) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-5.09622001647949218750000000000000000e+00), SC_(2.42488102060141778293028171803522475e+00) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(5.09621810913085937500000000000000000e+00), SC_(-7.08018919567443441130857721911055991e-01) }},
   {{ SC_(2.29859237670898437500000000000000000e+01), SC_(3.92699003219604492187500000000000000e-01), SC_(2.42487523685671550812740326679360706e+00) }},
   {{ SC_(4.35048788785934448242187500000000000e-02), SC_(-3.92699122428894042968750000000000000e-01), SC_(2.42487674620505358099159094285912147e+00) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-1.31705379486083984375000000000000000e+00), SC_(2.42487781497967999577597326757769334e+00) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(1.31705331802368164062500000000000000e+00), SC_(-7.08018650670789729134897318550328338e-01) }},
   {{ SC_(5.28352783203125000000000000000000000e+02), SC_(1.96349501609802246093750000000000000e-01), SC_(2.42487535366747541384589965640626333e+00) }},
   {{ SC_(1.89267424866557121276855468750000000e-03), SC_(-1.96349561214447021484375000000000000e-01), SC_(2.42487683061636854272444533521088857e+00) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-7.56248235702514648437500000000000000e-01), SC_(2.42487688172250849587454131691484573e+00) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(7.56248235702514648437500000000000000e-01), SC_(-7.08018701245383240679095593628170896e-01) }},
   {{ SC_(2.79156625000000000000000000000000000e+05), SC_(9.81747508049011230468750000000000000e-02), SC_(2.42487530727304561707424605561031084e+00) }},
   {{ SC_(3.58221677743131294846534729003906250e-06), SC_(-9.81747806072235107421875000000000000e-02), SC_(2.42487673995723769014811406902315909e+00) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-5.30401706695556640625000000000000000e-01), SC_(2.42487734241551120063466107029502191e+00) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(5.30401468276977539062500000000000000e-01), SC_(-7.08018578946867331845756945721696147e-01) }},
   {{ SC_(7.79284643840000000000000000000000000e+10), SC_(4.90873754024505615234375000000000000e-02), SC_(2.42487540026002634659673698422751024e+00) }},
   {{ SC_(1.28322769077371390267217066138982773e-11), SC_(-4.90873903036117553710937500000000000e-02), SC_(2.42487674169672683794323720232372877e+00) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-4.08428311347961425781250000000000000e-01), SC_(2.42487708070776793264583195496763916e+00) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(4.08428192138671875000000000000000000e-01), SC_(-7.08018613296190300913050025485659035e-01) }},
   {{ SC_(6.07284739233035373772800000000000000e+21), SC_(2.45436877012252807617187500000000000e-02), SC_(2.42487542560548091066046769224084738e+00) }},
   {{ SC_(1.64667405957460246926333003749352846e-22), SC_(-2.45436951518058776855468750000000000e-02), SC_(2.42487670324718113739939576891877860e+00) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-3.32065224647521972656250000000000000e-01), SC_(2.42487713898456945917448546608731163e+00) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(3.32065105438232421875000000000000000e-01), SC_(-7.08018594138167379939144184703359914e-01) }},
   {{ SC_(2.66246708221715243475508620825084065e-44), SC_(-1.22718475759029388427734375000000000e-02), SC_(2.42564432883582838824240370274351193e+00) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-2.79759168624877929687500000000000000e-01), SC_(2.42487716380427935856540646685221332e+00) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(2.79759049415588378906250000000000000e-01), SC_(-7.08018572127822049195972896426778603e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-2.41688907146453857421875000000000000e-01), SC_(2.42487643695591993412915289111628036e+00) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(2.41688907146453857421875000000000000e-01), SC_(-7.08018663327657284310495300505644628e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-2.12738990783691406250000000000000000e-01), SC_(2.42487741025804191810034839674717573e+00) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(2.12738931179046630859375000000000000e-01), SC_(-7.08018645595427457849938521389842073e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-1.89982473850250244140625000000000000e-01), SC_(2.42487645496079080202701991928896063e+00) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(1.89982473850250244140625000000000000e-01), SC_(-7.08018664862628350203126889110755526e-01) }},
   {{ SC_(1.00080490112304687500000000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(2.64792590603993435777647285112538484e+00) }},
   {{ SC_(9.99195337295532226562500000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(2.65032950756419525963892417285399155e+00) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(1.75344884395599365234375000000000000e-01), SC_(2.64946581436954300021293678135927738e+00) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-1.75344944000244140625000000000000000e-01), SC_(-7.25987415473702577187732054511591808e-01) }},
   {{ SC_(1.00161075592041015625000000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(2.64882176515874648061418927100878567e+00) }},
   {{ SC_(9.98391628265380859375000000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(2.64942926048414463150354399081488961e+00) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(1.93512558937072753906250000000000000e-01), SC_(2.64946670197406740986007202218242980e+00) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-1.93512618541717529296875000000000000e-01), SC_(-7.25987470796864044828497415055583304e-01) }},
   {{ SC_(1.00322437286376953125000000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(2.64921154174975476077471073767739300e+00) }},
   {{ SC_(9.96785640716552734375000000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(2.64972766025335208434680834486835354e+00) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(2.15880095958709716796875000000000000e-01), SC_(2.64946694123169925441321891011252400e+00) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-2.15880095958709716796875000000000000e-01), SC_(-7.25987379498634707558508238762762448e-01) }},
   {{ SC_(1.00645923614501953125000000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(2.64927995045203116108388133751231410e+00) }},
   {{ SC_(9.93581771850585937500000000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(2.64961073904030054673393766915193731e+00) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(2.44094192981719970703125000000000000e-01), SC_(2.64946681494011353576913331320237878e+00) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-2.44094252586364746093750000000000000e-01), SC_(-7.25987456637140440982288454796301539e-01) }},
   {{ SC_(1.01296043395996093750000000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(2.64936685036546420413511514373036423e+00) }},
   {{ SC_(9.87205028533935546875000000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(2.64950252228031726612489314733104780e+00) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(2.80791759490966796875000000000000000e-01), SC_(2.64946559575338439898471651086273535e+00) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-2.80791878700256347656250000000000000e-01), SC_(-7.25987429076342093845961676601391381e-01) }},
   {{ SC_(1.02608919143676757812500000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(2.64942954099535453240408255449697639e+00) }},
   {{ SC_(9.74573850631713867187500000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(2.64948703681487377704253368229980998e+00) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(3.30476284027099609375000000000000000e-01), SC_(2.64946591017164711471758225598097327e+00) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-3.30476403236389160156250000000000000e-01), SC_(-7.25987430042241118638204518153394001e-01) }},
   {{ SC_(1.05285930633544921875000000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(2.64945372011105191538671489460211112e+00) }},
   {{ SC_(9.49794292449951171875000000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(2.64947717560030206907797944027649349e+00) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(4.01523590087890625000000000000000000e-01), SC_(2.64946582072445758300183068242272458e+00) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-4.01523709297180175781250000000000000e-01), SC_(-7.25987400684738591350133593847888966e-01) }},
   {{ SC_(1.10851287841796875000000000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(2.64946031801120508734491841006281153e+00) }},
   {{ SC_(9.02109384536743164062500000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(2.64946769111213098623006591099676651e+00) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(5.11485099792480468750000000000000000e-01), SC_(2.64946684594213477455415180210229707e+00) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-5.11485099792480468750000000000000000e-01), SC_(-7.25987372344016136741108302402843727e-01) }},
   {{ SC_(1.22880077362060546875000000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(2.64945979555229633860484153089616610e+00) }},
   {{ SC_(8.13801288604736328125000000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(2.64946918629881646580658227104729489e+00) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(7.04389333724975585937500000000000000e-01), SC_(2.64946602184583267336230571476942195e+00) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-7.04389572143554687500000000000000000e-01), SC_(-7.25987430536392949024120886815348272e-01) }},
   {{ SC_(1.50995206832885742187500000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(2.64946531628600796383197684290777302e+00) }},
   {{ SC_(6.62272453308105468750000000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(2.64947064095347078312652361251902850e+00) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(1.13090515136718750000000000000000000e+00), SC_(2.64946542814096446167126967340918850e+00) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-1.13090562820434570312500000000000000e+00), SC_(-7.25987415461037063824232938607338171e-01) }},
   {{ SC_(2.27995491027832031250000000000000000e+00), SC_(1.57079601287841796875000000000000000e+00), SC_(2.64946446550563970033850399101257577e+00) }},
   {{ SC_(4.38604950904846191406250000000000000e-01), SC_(-1.57079648971557617187500000000000000e+00), SC_(2.64946870013261297534056344180679455e+00) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(2.86676406860351562500000000000000000e+00), SC_(2.64946470478779960758135553823433853e+00) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-2.86676502227783203125000000000000000e+00), SC_(-7.25987329586846586312339428505030482e-01) }},
   {{ SC_(5.19819641113281250000000000000000000e+00), SC_(7.85398006439208984375000000000000000e-01), SC_(2.64946557835705774440084048139065288e+00) }},
   {{ SC_(1.92374348640441894531250000000000000e-01), SC_(-7.85398244857788085937500000000000000e-01), SC_(2.64946801948954923969760122088425800e+00) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-5.35915374755859375000000000000000000e+00), SC_(2.64947103044184214317399230135383912e+00) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(5.35915374755859375000000000000000000e+00), SC_(-7.25987686528113140780427648209438814e-01) }},
   {{ SC_(2.70212554931640625000000000000000000e+01), SC_(3.92699003219604492187500000000000000e-01), SC_(2.64946608563228661896479196454908756e+00) }},
   {{ SC_(3.70078980922698974609375000000000000e-02), SC_(-3.92699122428894042968750000000000000e-01), SC_(2.64946770668820775899726419056578361e+00) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-1.38500595092773437500000000000000000e+00), SC_(2.64946828818805202729616714695347214e+00) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(1.38500595092773437500000000000000000e+00), SC_(-7.25987480632008333201793010881277876e-01) }},
   {{ SC_(7.30148193359375000000000000000000000e+02), SC_(1.96349501609802246093750000000000000e-01), SC_(2.64946603158881286360643650711289159e+00) }},
   {{ SC_(1.36958435177803039550781250000000000e-03), SC_(-1.96349561214447021484375000000000000e-01), SC_(2.64946779533447654560098031713623560e+00) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-7.95266389846801757812500000000000000e-01), SC_(2.64946864004407929544100455026391103e+00) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(7.95266151428222656250000000000000000e-01), SC_(-7.25987400702849872939911608578726829e-01) }},
   {{ SC_(5.33116500000000000000000000000000000e+05), SC_(9.81747508049011230468750000000000000e-02), SC_(2.64946610936885555751642117638036352e+00) }},
   {{ SC_(1.87576188181992620229721069335937500e-06), SC_(-9.81747806072235107421875000000000000e-02), SC_(2.64946768355945127686237231615037600e+00) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-5.57767391204833984375000000000000000e-01), SC_(2.64946865312967394316473786385720684e+00) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(5.57767152786254882812500000000000000e-01), SC_(-7.25987356402256757749999961993334895e-01) }},
   {{ SC_(2.84213379072000000000000000000000000e+11), SC_(4.90873754024505615234375000000000000e-02), SC_(2.64946622061855973840875772046710049e+00) }},
   {{ SC_(3.51848324781078858336513803806155920e-12), SC_(-4.90873903036117553710937500000000000e-02), SC_(2.64946765247483971335830621380781932e+00) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-4.29500818252563476562500000000000000e-01), SC_(2.64946780641890066650384599766771740e+00) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(4.29500699043273925781250000000000000e-01), SC_(-7.25987346002535043014163616371908052e-01) }},
   {{ SC_(8.07772474636605765713920000000000000e+22), SC_(2.45436877012252807617187500000000000e-02), SC_(2.64946622352394674754927190770564129e+00) }},
   {{ SC_(1.23797235588217945082623438984674707e-23), SC_(-2.45436951518058776855468750000000000e-02), SC_(2.64946765830871278448306942952612013e+00) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-3.49197864532470703125000000000000000e-01), SC_(2.64946815123931436521660457599924152e+00) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(3.49197745323181152343750000000000000e-01), SC_(-7.25987349251101728956515018651535509e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-2.94193148612976074218750000000000000e-01), SC_(2.64946864897099439422470882984368176e+00) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(2.94193029403686523437500000000000000e-01), SC_(-7.25987363980685483948454854158841246e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-2.54158735275268554687500000000000000e-01), SC_(2.64946889106555754963582809387685555e+00) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(2.54158616065979003906250000000000000e-01), SC_(-7.25987359516293327710258700237598920e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-2.23715066909790039062500000000000000e-01), SC_(2.64946798879003795342935742826641949e+00) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(2.23715007305145263671875000000000000e-01), SC_(-7.25987363640826777238982059211302848e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-1.99784457683563232421875000000000000e-01), SC_(2.64946714651508282114672892893251845e+00) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(1.99784457683563232421875000000000000e-01), SC_(-7.25987394911908924925156315001679983e-01) }},
   {{ SC_(1.00084972381591796875000000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(2.92041002397889716926449385634156461e+00) }},
   {{ SC_(9.99150991439819335937500000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(2.92045053931615662212006063022215091e+00) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(1.85051918029785156250000000000000000e-01), SC_(2.92061434104185875180718458670783892e+00) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-1.85051977634429931640625000000000000e-01), SC_(-7.44938044666227300817840654610666444e-01) }},
   {{ SC_(1.00169992446899414062500000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(2.91963832205011111036287489092398865e+00) }},
   {{ SC_(9.98302459716796875000000000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(2.92122119021197625516674388642668318e+00) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(2.04225301742553710937500000000000000e-01), SC_(2.92061411041561214204835433126042277e+00) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-2.04225361347198486328125000000000000e-01), SC_(-7.44938019124627761047969199467987208e-01) }},
   {{ SC_(1.00340318679809570312500000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(2.92034230266263791229719141220510649e+00) }},
   {{ SC_(9.96608018875122070312500000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(2.92087660809845208949804362821317785e+00) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(2.27831125259399414062500000000000000e-01), SC_(2.92061514917825873119187819301374452e+00) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-2.27831184864044189453125000000000000e-01), SC_(-7.44938076165187452733019292228980386e-01) }},
   {{ SC_(1.00681829452514648437500000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(2.92060790718396610467742302101506556e+00) }},
   {{ SC_(9.93227720260620117187500000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(2.92073614346092948833860963674045218e+00) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(2.57607102394104003906250000000000000e-01), SC_(2.92061417072828054078291819783994866e+00) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-2.57607221603393554687500000000000000e-01), SC_(-7.44938082602876236559928629112207148e-01) }},
   {{ SC_(1.01368284225463867187500000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(2.92051617115199661756103001354065596e+00) }},
   {{ SC_(9.86501455307006835937500000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(2.92067580690507526297204138388781374e+00) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(2.96336293220520019531250000000000000e-01), SC_(2.92061403299989652594592521988468215e+00) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-2.96336412429809570312500000000000000e-01), SC_(-7.44938052567070917176350436345001217e-01) }},
   {{ SC_(1.02755308151245117187500000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(2.92055008437702786930173656962057510e+00) }},
   {{ SC_(9.73185300827026367187500000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(2.92063945661380956685115303582419411e+00) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(3.48771333694458007812500000000000000e-01), SC_(2.92061435896828156932295316700718059e+00) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-3.48771452903747558593750000000000000e-01), SC_(-7.44938052697813218090837751959295955e-01) }},
   {{ SC_(1.05586576461791992187500000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(2.92059014644478157554378839405439423e+00) }},
   {{ SC_(9.47089672088623046875000000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(2.92063505121337673380313659180184442e+00) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(4.23751831054687500000000000000000000e-01), SC_(2.92061473384108003434736284527174537e+00) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-4.23751950263977050781250000000000000e-01), SC_(-7.44938056010109649293867241206906152e-01) }},
   {{ SC_(1.11485290527343750000000000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(2.92060748659828287774006630710183618e+00) }},
   {{ SC_(8.96979093551635742187500000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(2.92062150768475446063136132103285697e+00) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(5.39800643920898437500000000000000000e-01), SC_(2.92061453409314580345458834560507702e+00) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-5.39800882339477539062500000000000000e-01), SC_(-7.44938098897210500692956946021305466e-01) }},
   {{ SC_(1.24289703369140625000000000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(2.92060814649233437893466445968573181e+00) }},
   {{ SC_(8.04571628570556640625000000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(2.92061739569620319077487910680509172e+00) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(7.43384122848510742187500000000000000e-01), SC_(2.92061481613213565177591354180092937e+00) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-7.43384122848510742187500000000000000e-01), SC_(-7.44937963330316300181690844248167445e-01) }},
   {{ SC_(1.54479360580444335937500000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(2.92061268680010644920241293191322181e+00) }},
   {{ SC_(6.47335529327392578125000000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(2.92061694234049749674505772546659411e+00) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(1.19351148605346679687500000000000000e+00), SC_(2.92061303741985024223047281957731469e+00) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-1.19351196289062500000000000000000000e+00), SC_(-7.44937986838763158709564003908936898e-01) }},
   {{ SC_(2.38638782501220703125000000000000000e+00), SC_(1.57079601287841796875000000000000000e+00), SC_(2.92061408159639771082923744105760734e+00) }},
   {{ SC_(4.19043302536010742187500000000000000e-01), SC_(-1.57079648971557617187500000000000000e+00), SC_(2.92061672179765714555106733631548788e+00) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(3.02546691894531250000000000000000000e+00), SC_(2.92061265603506910638824508634775064e+00) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-3.02546787261962890625000000000000000e+00), SC_(-7.44937932647302366908843692876130008e-01) }},
   {{ SC_(5.69484710693359375000000000000000000e+00), SC_(7.85398006439208984375000000000000000e-01), SC_(2.92061421978326976412014489401676638e+00) }},
   {{ SC_(1.75597310066223144531250000000000000e-01), SC_(-7.85398244857788085937500000000000000e-01), SC_(2.92061635940319540425599468475180537e+00) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-5.65583419799804687500000000000000000e+00), SC_(2.92061978823899790215852792197545837e+00) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(5.65583419799804687500000000000000000e+00), SC_(-7.44938286798484937498387743822870467e-01) }},
   {{ SC_(3.24312896728515625000000000000000000e+01), SC_(3.92699003219604492187500000000000000e-01), SC_(2.92061450944190463779518992929577101e+00) }},
   {{ SC_(3.08344140648841857910156250000000000e-02), SC_(-3.92699122428894042968750000000000000e-01), SC_(2.92061642119943898373628305022642823e+00) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-1.46167945861816406250000000000000000e+00), SC_(2.92061731283593435449753203373305988e+00) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(1.46167898178100585937500000000000000e+00), SC_(-7.44938012074913460038481326025042879e-01) }},
   {{ SC_(1.05178857421875000000000000000000000e+03), SC_(1.96349501609802246093750000000000000e-01), SC_(2.92061452728163954593311331042189277e+00) }},
   {{ SC_(9.50761372223496437072753906250000000e-04), SC_(-1.96349561214447021484375000000000000e-01), SC_(2.92061619327583042883770649162481782e+00) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-8.39292049407958984375000000000000000e-01), SC_(2.92061742065809883398822464295555541e+00) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(8.39291810989379882812500000000000000e-01), SC_(-7.44938033779368931684172486978461390e-01) }},
   {{ SC_(1.10625900000000000000000000000000000e+06), SC_(9.81747508049011230468750000000000000e-02), SC_(2.92061445600484916754607775096955934e+00) }},
   {{ SC_(9.03947238839464262127876281738281250e-07), SC_(-9.81747806072235107421875000000000000e-02), SC_(2.92061617116496434503238822829782244e+00) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-5.88645219802856445312500000000000000e-01), SC_(2.92061768718132200226086329938949159e+00) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(5.88644981384277343750000000000000000e-01), SC_(-7.44938008967129098912430849947338073e-01) }},
   {{ SC_(1.22380930252800000000000000000000000e+12), SC_(4.90873754024505615234375000000000000e-02), SC_(2.92061450749821445736115761879502623e+00) }},
   {{ SC_(8.17120676677163260137604083865880966e-13), SC_(-4.90873903036117553710937500000000000e-02), SC_(2.92061615560339533215498010573278046e+00) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-4.53277826309204101562500000000000000e-01), SC_(2.92061645401535290454320615128359766e+00) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(4.53277707099914550781250000000000000e-01), SC_(-7.44937978237839200108019832566665636e-01) }},
   {{ SC_(1.49770902162779990183116800000000000e+24), SC_(2.45436877012252807617187500000000000e-02), SC_(2.92061449546268581743571119272093423e+00) }},
   {{ SC_(6.67686348152727845017849175555393285e-25), SC_(-2.45436951518058776855468750000000000e-02), SC_(2.92061613428825555656875135772927038e+00) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-3.68529319763183593750000000000000000e-01), SC_(2.92061668933473230541110929090161732e+00) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(3.68529200553894042968750000000000000e-01), SC_(-7.44937972471251651709243138398849819e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-3.10479521751403808593750000000000000e-01), SC_(2.92061651450121148688842196468130527e+00) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(3.10479402542114257812500000000000000e-01), SC_(-7.44937940021504345484106426474935008e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-2.68228769302368164062500000000000000e-01), SC_(2.92061567658217334460150117925106743e+00) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(2.68228769302368164062500000000000000e-01), SC_(-7.44938019308294549190078195649497145e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-2.36099839210510253906250000000000000e-01), SC_(2.92061639078866852965874272742589285e+00) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(2.36099779605865478515625000000000000e-01), SC_(-7.44937977797004378938106273712959855e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-2.10844457149505615234375000000000000e-01), SC_(2.92061583363375352157662898960149164e+00) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(2.10844457149505615234375000000000000e-01), SC_(-7.44938029525538168689139289229060368e-01) }},
   {{ SC_(1.00089979171752929687500000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(3.24889876576597117955249820570035426e+00) }},
   {{ SC_(9.99100685119628906250000000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(3.25117269254211890919705373046010221e+00) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(1.96011364459991455078125000000000000e-01), SC_(3.25103528350252223460090661361517928e+00) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-1.96011424064636230468750000000000000e-01), SC_(-7.64763288647219731090042591225766889e-01) }},
   {{ SC_(1.00180101394653320312500000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(3.25101715201552173663654277826438121e+00) }},
   {{ SC_(9.98202085494995117187500000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(3.25149299597913093264265175967295275e+00) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(2.16320276260375976562500000000000000e-01), SC_(3.25103532275063958889872339408251315e+00) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-2.16320335865020751953125000000000000e-01), SC_(-7.64763281100310882386127061797757091e-01) }},
   {{ SC_(1.00360488891601562500000000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(3.25036547328931111820880357587199103e+00) }},
   {{ SC_(9.96407508850097656250000000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(3.25131221800833632153566206608966934e+00) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(2.41324067115783691406250000000000000e-01), SC_(3.25103507623372843636250399235581200e+00) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-2.41324126720428466796875000000000000e-01), SC_(-7.64763257740210717243922746507482426e-01) }},
   {{ SC_(1.00722360610961914062500000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(3.25107234291176293836814104775675010e+00) }},
   {{ SC_(9.92828130722045898437500000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(3.25113397958184225654382520757297803e+00) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(2.72863507270812988281250000000000000e-01), SC_(3.25103456960487145779216799409264691e+00) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-2.72863626480102539062500000000000000e-01), SC_(-7.64763294349488597101802322749623194e-01) }},
   {{ SC_(1.01449918746948242187500000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(3.25098588724083128958211319634935423e+00) }},
   {{ SC_(9.85707759857177734375000000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(3.25110679320111114833384407878601269e+00) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(3.13886404037475585937500000000000000e-01), SC_(3.25103492309235854145869610511260869e+00) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-3.13886523246765136718750000000000000e-01), SC_(-7.64763294472681616899897971550380648e-01) }},
   {{ SC_(1.02920866012573242187500000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(3.25099808445792693744179772019628043e+00) }},
   {{ SC_(9.71620082855224609375000000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(3.25104191292282097066385473232021427e+00) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(3.69426846504211425781250000000000000e-01), SC_(3.25103544045298895068701313170476481e+00) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-3.69426965713500976562500000000000000e-01), SC_(-7.64763303664011556600222790009768490e-01) }},
   {{ SC_(1.05927085876464843750000000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(3.25103769147281470886278521580032173e+00) }},
   {{ SC_(9.44045543670654296875000000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(3.25104663641470927906518230858926057e+00) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(4.48847889900207519531250000000000000e-01), SC_(3.25103487044209817574143802240566756e+00) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-4.48848009109497070312500000000000000e-01), SC_(-7.64763252684183537692540478586304529e-01) }},
   {{ SC_(1.12205457687377929687500000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(3.25102934301025040671506702004866673e+00) }},
   {{ SC_(8.91222000122070312500000000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(3.25104594124664862883541901015529109e+00) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(5.71769475936889648437500000000000000e-01), SC_(3.25103419361293002282318958766241230e+00) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-5.71769714355468750000000000000000000e-01), SC_(-7.64763266769413767364920786695331517e-01) }},
   {{ SC_(1.25900650024414062500000000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(3.25102991074325323048352109714301349e+00) }},
   {{ SC_(7.94276714324951171875000000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(3.25104389586546704032179500729166235e+00) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(7.87410020828247070312500000000000000e-01), SC_(3.25103576128055285252657539683435139e+00) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-7.87410020828247070312500000000000000e-01), SC_(-7.64763211566404969608590315410615368e-01) }},
   {{ SC_(1.58509778976440429687500000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(3.25103346714730832770194425918263750e+00) }},
   {{ SC_(6.30875825881958007812500000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(3.25103697436669691555567268213307026e+00) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(1.26419591903686523437500000000000000e+00), SC_(3.25103548779320329263882460711141213e+00) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-1.26419591903686523437500000000000000e+00), SC_(-7.64763196432613221123054716917621759e-01) }},
   {{ SC_(2.51253509521484375000000000000000000e+00), SC_(1.57079601287841796875000000000000000e+00), SC_(3.25103371191628808009920996142724816e+00) }},
   {{ SC_(3.98004293441772460937500000000000000e-01), SC_(-1.57079648971557617187500000000000000e+00), SC_(3.25103721328607700253784273055585523e+00) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(3.20464611053466796875000000000000000e+00), SC_(3.25103345669174412621665290092853684e+00) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-3.20464706420898437500000000000000000e+00), SC_(-7.64763185346539443935257868528538209e-01) }},
   {{ SC_(6.31283378601074218750000000000000000e+00), SC_(7.85398006439208984375000000000000000e-01), SC_(3.25103433669937502967155410702696907e+00) }},
   {{ SC_(1.58407390117645263671875000000000000e-01), SC_(-7.85398244857788085937500000000000000e-01), SC_(3.25103779249208326008838469406825110e+00) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-5.99079322814941406250000000000000000e+00), SC_(3.25104153446270927706056459282949142e+00) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(5.99079322814941406250000000000000000e+00), SC_(-7.64763531032780094332078163180152848e-01) }},
   {{ SC_(3.98518829345703125000000000000000000e+01), SC_(3.92699003219604492187500000000000000e-01), SC_(3.25103486135637975025529051038679960e+00) }},
   {{ SC_(2.50929072499275207519531250000000000e-02), SC_(-3.92699122428894042968750000000000000e-01), SC_(3.25103739292248959148775423769019810e+00) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-1.54824542999267578125000000000000000e+00), SC_(3.25103872480338267149668774264996568e+00) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(1.54824495315551757812500000000000000e+00), SC_(-7.64763270710572992208376445710214471e-01) }},
   {{ SC_(1.58817285156250000000000000000000000e+03), SC_(1.96349501609802246093750000000000000e-01), SC_(3.25103500753282596718222067270393664e+00) }},
   {{ SC_(6.29654154181480407714843750000000000e-04), SC_(-1.96349561214447021484375000000000000e-01), SC_(3.25103718091686690909911555799876316e+00) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-8.88997793197631835937500000000000000e-01), SC_(3.25103758527140948039190763691831130e+00) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(8.88997554779052734375000000000000000e-01), SC_(-7.64763221201190998057493347140617183e-01) }},
   {{ SC_(2.52229400000000000000000000000000000e+06), SC_(9.81747508049011230468750000000000000e-02), SC_(3.25103517192945341079821430350448710e+00) }},
   {{ SC_(3.96464429286425001919269561767578125e-07), SC_(-9.81747806072235107421875000000000000e-02), SC_(3.25103710153696689136002494373202169e+00) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-6.23506784439086914062500000000000000e-01), SC_(3.25103772150435048586422434216636137e+00) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(6.23506546020507812500000000000000000e-01), SC_(-7.64763189864784640281617605079675650e-01) }},
   {{ SC_(6.36196644454400000000000000000000000e+12), SC_(4.90873754024505615234375000000000000e-02), SC_(3.25103515297462760230679197359664496e+00) }},
   {{ SC_(1.57184053099779230677768282475881279e-13), SC_(-4.90873903036117553710937500000000000e-02), SC_(3.25103708904407446386526544149429127e+00) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-4.80122566223144531250000000000000000e-01), SC_(3.25103747167585639113895838767189751e+00) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(4.80122447013854980468750000000000000e-01), SC_(-7.64763221689286452899681713052364421e-01) }},
   {{ SC_(4.04746283614246333254205440000000000e+25), SC_(2.45436877012252807617187500000000000e-02), SC_(3.25103518215528647630358468576512241e+00) }},
   {{ SC_(2.47068277286826318660683092664448837e-26), SC_(-2.45436951518058776855468750000000000e-02), SC_(3.25103708406178042400070122458290905e+00) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-3.90354871749877929687500000000000000e-01), SC_(3.25103652582811323544277656168899623e+00) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(3.90354871749877929687500000000000000e-01), SC_(-7.64763253873666179080808847381998782e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-3.28867197036743164062500000000000000e-01), SC_(3.25103685913478997693854006091498095e+00) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(3.28867197036743164062500000000000000e-01), SC_(-7.64763272317631897789998443494677354e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-2.84114241600036621093750000000000000e-01), SC_(3.25103661718864055380341632409662925e+00) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(2.84114241600036621093750000000000000e-01), SC_(-7.64763258929222060170859826896928541e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-2.50082492828369140625000000000000000e-01), SC_(3.25103675110263668095933644181897429e+00) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(2.50082492828369140625000000000000000e-01), SC_(-7.64763266339530151378506876511725908e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-2.23331451416015625000000000000000000e-01), SC_(3.25103754942812138295744333753876540e+00) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(2.23331391811370849609375000000000000e-01), SC_(-7.64763219660080068774226243291221927e-01) }},
   {{ SC_(1.00095701217651367187500000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(3.65812634109037972298317424854056210e+00) }},
   {{ SC_(9.99043941497802734375000000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(3.65783845291765819532537618926025492e+00) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(2.08389401435852050781250000000000000e-01), SC_(3.65783276768785870612809887018922552e+00) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-2.08389461040496826171875000000000000e-01), SC_(-7.85307972653521100323983122200815840e-01) }},
   {{ SC_(1.00191450119018554687500000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(3.65648502199271583379385414828200100e+00) }},
   {{ SC_(9.98088598251342773437500000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(3.65858462521565301391593991046968683e+00) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(2.29980826377868652343750000000000000e-01), SC_(3.65783324098452699206243454643622340e+00) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-2.29980885982513427734375000000000000e-01), SC_(-7.85307985599078397962059889656129756e-01) }},
   {{ SC_(1.00383329391479492187500000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(3.65765327699013345147990244357776915e+00) }},
   {{ SC_(9.96181249618530273437500000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(3.65783312279547687848558139002936765e+00) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(2.56563544273376464843750000000000000e-01), SC_(3.65783145540091723980283778554995773e+00) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-2.56563663482666015625000000000000000e-01), SC_(-7.85307971165159185314273805303709440e-01) }},
   {{ SC_(1.00768136978149414062500000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(3.65773488256726238504916090166683797e+00) }},
   {{ SC_(9.92377042770385742187500000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(3.65787023058191907489591499501531617e+00) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(2.90094733238220214843750000000000000e-01), SC_(3.65783212900878197461652309660499952e+00) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-2.90094852447509765625000000000000000e-01), SC_(-7.85307984473649081248102990232711802e-01) }},
   {{ SC_(1.01542186737060546875000000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(3.65779223238271304759052298117332086e+00) }},
   {{ SC_(9.84812259674072265625000000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(3.65783948775670589067764337082298594e+00) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(3.33708286285400390625000000000000000e-01), SC_(3.65783417421732661640035835452635291e+00) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-3.33708286285400390625000000000000000e-01), SC_(-7.85307943005928552903127555250705826e-01) }},
   {{ SC_(1.03108167648315429687500000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(3.65781669879010352457693273941180435e+00) }},
   {{ SC_(9.69855070114135742187500000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(3.65786765752737470277763091943111003e+00) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(3.92755985260009765625000000000000000e-01), SC_(3.65783268552464576518532530063601509e+00) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-3.92756104469299316406250000000000000e-01), SC_(-7.85307974645137477144540916354128611e-01) }},
   {{ SC_(1.06312942504882812500000000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(3.65781686060197233358783908015496662e+00) }},
   {{ SC_(9.40618991851806640625000000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(3.65785087778548892761959727314336090e+00) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(4.77192521095275878906250000000000000e-01), SC_(3.65783336358559613241024074421575947e+00) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-4.77192640304565429687500000000000000e-01), SC_(-7.85307988158873598404600990879422034e-01) }},
   {{ SC_(1.13024425506591796875000000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(3.65782103780056060758724145256854235e+00) }},
   {{ SC_(8.84764194488525390625000000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(3.65784382186268722455321470276410855e+00) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(6.07876539230346679687500000000000000e-01), SC_(3.65783216136704777958538588301966450e+00) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-6.07876777648925781250000000000000000e-01), SC_(-7.85307979782695554426786561245506237e-01) }},
   {{ SC_(1.27745246887207031250000000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(3.65783003585044082443074302985688224e+00) }},
   {{ SC_(7.82807826995849609375000000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(3.65783832062210277758657638632075570e+00) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(8.37134599685668945312500000000000000e-01), SC_(3.65783298341902377206787641696195739e+00) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-8.37134838104248046875000000000000000e-01), SC_(-7.85307982193456022065658249619140735e-01) }},
   {{ SC_(1.63188505172729492187500000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(3.65783220136462085004611857151102528e+00) }},
   {{ SC_(6.12788200378417968750000000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(3.65783578050914012865692419633449665e+00) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(1.34402894973754882812500000000000000e+00), SC_(3.65783076000652595863794262514598712e+00) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-1.34402942657470703125000000000000000e+00), SC_(-7.85307902825327745641092049038139537e-01) }},
   {{ SC_(2.66304874420166015625000000000000000e+00), SC_(1.57079601287841796875000000000000000e+00), SC_(3.65783198748007344594505596735331093e+00) }},
   {{ SC_(3.75509381294250488281250000000000000e-01), SC_(-1.57079648971557617187500000000000000e+00), SC_(3.65783572651384364974718498302145956e+00) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(3.40701770782470703125000000000000000e+00), SC_(3.65782961873693255330779323231640089e+00) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-3.40701866149902343750000000000000000e+00), SC_(-7.85307825491344131326238816882582060e-01) }},
   {{ SC_(7.09182929992675781250000000000000000e+00), SC_(7.85398006439208984375000000000000000e-01), SC_(3.65783234131190174032563576339437676e+00) }},
   {{ SC_(1.41007304191589355468750000000000000e-01), SC_(-7.85398244857788085937500000000000000e-01), SC_(3.65783549946469632940506458210500959e+00) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-6.36911010742187500000000000000000000e+00), SC_(3.65784089668597768486291558285792581e+00) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(6.36910820007324218750000000000000000e+00), SC_(-7.85308153943245993801799258781481855e-01) }},
   {{ SC_(5.02940521240234375000000000000000000e+01), SC_(3.92699003219604492187500000000000000e-01), SC_(3.65783267971206586662796350406461348e+00) }},
   {{ SC_(1.98830664157867431640625000000000000e-02), SC_(-3.92699122428894042968750000000000000e-01), SC_(3.65783489410495529350457100446065840e+00) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-1.64601659774780273437500000000000000e+00), SC_(3.65783723877831719797847069182490252e+00) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(1.64601612091064453125000000000000000e+00), SC_(-7.85307988570306964182503285960910763e-01) }},
   {{ SC_(2.52949121093750000000000000000000000e+03), SC_(1.96349501609802246093750000000000000e-01), SC_(3.65783251045983538775331377272136629e+00) }},
   {{ SC_(3.95336304791271686553955078125000000e-04), SC_(-1.96349561214447021484375000000000000e-01), SC_(3.65783495264118380426542706918053458e+00) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-9.45137739181518554687500000000000000e-01), SC_(3.65783621712830385813583579689124920e+00) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(9.45137500762939453125000000000000000e-01), SC_(-7.85307953844619286972242549714011465e-01) }},
   {{ SC_(6.39832800000000000000000000000000000e+06), SC_(9.81747508049011230468750000000000000e-02), SC_(3.65783266867702565414162009290790376e+00) }},
   {{ SC_(1.56290752784116193652153015136718750e-07), SC_(-9.81747806072235107421875000000000000e-02), SC_(3.65783507289880533382394012465373301e+00) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-6.62880897521972656250000000000000000e-01), SC_(3.65783470300350165297092756083407242e+00) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(6.62880897521972656250000000000000000e-01), SC_(-7.85307967379097389363467383748302739e-01) }},
   {{ SC_(4.09386216325120000000000000000000000e+13), SC_(4.90873754024505615234375000000000000e-02), SC_(3.65783278281658902222499612766358517e+00) }},
   {{ SC_(2.44268106718188715564821222869795747e-14), SC_(-4.90873903036117553710937500000000000e-02), SC_(3.65783496744630969539398609333767959e+00) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-5.10442256927490234375000000000000000e-01), SC_(3.65783739862482337262794008353560855e+00) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(5.10442018508911132812500000000000000e-01), SC_(-7.85307937343268377494108359127387231e-01) }},
   {{ SC_(1.67597081624948887986896896000000000e+27), SC_(2.45436877012252807617187500000000000e-02), SC_(3.65783278793787105600890581832828204e+00) }},
   {{ SC_(5.96669081989704081334322331229733938e-28), SC_(-2.45436951518058776855468750000000000e-02), SC_(3.65783496698785069847622262145782855e+00) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-4.15005683898925781250000000000000000e-01), SC_(3.65783529740431145001341437132671671e+00) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(4.15005564689636230468750000000000000e-01), SC_(-7.85307899894605649086904879602679447e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-3.49635124206542968750000000000000000e-01), SC_(3.65783663346845836828407001827480418e+00) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(3.49635004997253417968750000000000000e-01), SC_(-7.85307943737447458917224422100249286e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-3.02055954933166503906250000000000000e-01), SC_(3.65783469932131707244216885702216408e+00) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(3.02055954933166503906250000000000000e-01), SC_(-7.85307967209375674637469896187112165e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-2.65875101089477539062500000000000000e-01), SC_(3.65783452545861434254537935754547040e+00) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(2.65875101089477539062500000000000000e-01), SC_(-7.85307959195579376908681641504706698e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-2.37434744834899902343750000000000000e-01), SC_(3.65783553394797201549547738249391414e+00) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(2.37434685230255126953125000000000000e-01), SC_(-7.85307922758711878751406728730289010e-01) }},
   {{ SC_(1.00102090835571289062500000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(4.16181594649475195160384562355816854e+00) }},
   {{ SC_(9.98979806900024414062500000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(4.16452815473125281366909955406955872e+00) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(2.22371041774749755859375000000000000e-01), SC_(4.16434086438410005575152649285440314e+00) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-2.22371101379394531250000000000000000e-01), SC_(-8.06364532048558468836188176207849649e-01) }},
   {{ SC_(1.00204324722290039062500000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(4.16342471488122746163275874695698838e+00) }},
   {{ SC_(9.97960567474365234375000000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(4.16489076364358680608187128498338548e+00) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(2.45411098003387451171875000000000000e-01), SC_(4.16434073943989068722926141058093523e+00) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-2.45411157608032226562500000000000000e-01), SC_(-8.06364519363802001230556693842913007e-01) }},
   {{ SC_(1.00409078598022460937500000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(4.16366599047094940282670367798735147e+00) }},
   {{ SC_(9.95925426483154296875000000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(4.16461497502298640018877080799254691e+00) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(2.73777365684509277343750000000000000e-01), SC_(4.16433912454973005048835174776269153e+00) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-2.73777484893798828125000000000000000e-01), SC_(-8.06364520025986767481947699738211057e-01) }},
   {{ SC_(1.00819873809814453125000000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(4.16411046796985850332791653035317894e+00) }},
   {{ SC_(9.91867542266845703125000000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(4.16452373535795698527891142411695916e+00) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(3.09558272361755371093750000000000000e-01), SC_(4.16433945727521772723341740261017821e+00) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-3.09558391571044921875000000000000000e-01), SC_(-8.06364516501418342446160869208356801e-01) }},
   {{ SC_(1.01646518707275390625000000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(4.16436154030816438847093945659756464e+00) }},
   {{ SC_(9.83801364898681640625000000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(4.16444800674064606299906259697421302e+00) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(3.56097936630249023437500000000000000e-01), SC_(4.16433985450490026666896591149640257e+00) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-3.56098055839538574218750000000000000e-01), SC_(-8.06364515395415902017619289010147474e-01) }},
   {{ SC_(1.03320121765136718750000000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(4.16429649794108304283506516573413166e+00) }},
   {{ SC_(9.67865467071533203125000000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(4.16435641434448585633711728514642026e+00) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(4.19107437133789062500000000000000000e-01), SC_(4.16433983094667143186311054746828611e+00) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-4.19107556343078613281250000000000000e-01), SC_(-8.06364498512086597696629211571244311e-01) }},
   {{ SC_(1.06750488281250000000000000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(4.16431189750095899588892370027213251e+00) }},
   {{ SC_(9.36763525009155273437500000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(4.16436158809879655318100895847261514e+00) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(5.09209156036376953125000000000000000e-01), SC_(4.16434102519825292881838770819612488e+00) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-5.09209394454956054687500000000000000e-01), SC_(-8.06364601714197643984036776604169633e-01) }},
   {{ SC_(1.13956689834594726562500000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(4.16432462650325424935630650338603603e+00) }},
   {{ SC_(8.77526044845581054687500000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(4.16435100827866415392203481610644189e+00) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(6.48661375045776367187500000000000000e-01), SC_(4.16434117452850874946608740261775917e+00) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-6.48661613464355468750000000000000000e-01), SC_(-8.06364575313263943455892136840765124e-01) }},
   {{ SC_(1.29861307144165039062500000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(4.16433351277335744853678349719513426e+00) }},
   {{ SC_(7.70051956176757812500000000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(4.16435114335554761378626934612359537e+00) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(8.93301010131835937500000000000000000e-01), SC_(4.16433974255080323972202161203555791e+00) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-8.93301248550415039062500000000000000e-01), SC_(-8.06364489621633834338249906094254356e-01) }},
   {{ SC_(1.68639659881591796875000000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(4.16434014618536783580695096610584239e+00) }},
   {{ SC_(5.92980146408081054687500000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(4.16434755374409283562904415246586870e+00) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(1.43420505523681640625000000000000000e+00), SC_(4.16433892218028464134969620408797926e+00) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-1.43420553207397460937500000000000000e+00), SC_(-8.06364479709957138113355526937612282e-01) }},
   {{ SC_(2.84393310546875000000000000000000000e+00), SC_(1.57079601287841796875000000000000000e+00), SC_(4.16433905362108270137107617483465870e+00) }},
   {{ SC_(3.51625561714172363281250000000000000e-01), SC_(-1.57079648971557617187500000000000000e+00), SC_(4.16434506952413040798005882750724577e+00) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(3.63560771942138671875000000000000000e+00), SC_(4.16433758049212653029019879741554964e+00) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-3.63560867309570312500000000000000000e+00), SC_(-8.06364407099397568363613754962762204e-01) }},
   {{ SC_(8.08795547485351562500000000000000000e+00), SC_(7.85398006439208984375000000000000000e-01), SC_(4.16433903680718428356824589192087289e+00) }},
   {{ SC_(1.23640567064285278320312500000000000e-01), SC_(-7.85398244857788085937500000000000000e-01), SC_(4.16434403899510969902466528397868921e+00) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-6.79643821716308593750000000000000000e+00), SC_(4.16435073473134091028403997549201221e+00) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(6.79643630981445312500000000000000000e+00), SC_(-8.06364727704695518014515132525058369e-01) }},
   {{ SC_(6.54150695800781250000000000000000000e+01), SC_(3.92699003219604492187500000000000000e-01), SC_(4.16434045724530763373130526024749262e+00) }},
   {{ SC_(1.52869932353496551513671875000000000e-02), SC_(-3.92699122428894042968750000000000000e-01), SC_(4.16434358642893978086325946503860303e+00) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-1.75645399093627929687500000000000000e+00), SC_(4.16434546401195867180389315942554999e+00) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(1.75645351409912109375000000000000000e+00), SC_(-8.06364532993773264176657836784657675e-01) }},
   {{ SC_(4.27913085937500000000000000000000000e+03), SC_(1.96349501609802246093750000000000000e-01), SC_(4.16434034615689372526966816829717595e+00) }},
   {{ SC_(2.33692233450710773468017578125000000e-04), SC_(-1.96349561214447021484375000000000000e-01), SC_(4.16434327716705905018855674672901206e+00) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-1.00855064392089843750000000000000000e+00), SC_(4.16434499886315455502517157006631278e+00) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(1.00855016708374023437500000000000000e+00), SC_(-8.06364451553079481156231987410579964e-01) }},
   {{ SC_(1.83109680000000000000000000000000000e+07), SC_(9.81747508049011230468750000000000000e-02), SC_(4.16434054242434065789508353963886483e+00) }},
   {{ SC_(5.46120588751364266499876976013183594e-08), SC_(-9.81747806072235107421875000000000000e-02), SC_(4.16434328737967428087720180019315599e+00) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-7.07356214523315429687500000000000000e-01), SC_(4.16434444209328713456580759307756474e+00) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(7.07355976104736328125000000000000000e-01), SC_(-8.06364473829359327477701933000909385e-01) }},
   {{ SC_(3.35291588018176000000000000000000000e+14), SC_(4.90873754024505615234375000000000000e-02), SC_(4.16434057185145923058627790449607510e+00) }},
   {{ SC_(2.98247754618174987228940153727307916e-15), SC_(-4.90873903036117553710937500000000000e-02), SC_(4.16434323879487480630084700834453571e+00) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-5.44689655303955078125000000000000000e-01), SC_(4.16434446089764687841122546190663142e+00) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(5.44689416885375976562500000000000000e-01), SC_(-8.06364442534375010935201462624521890e-01) }},
   {{ SC_(1.12420467596535459171438428160000000e+29), SC_(2.45436877012252807617187500000000000e-02), SC_(4.16434059282349636768607185543098243e+00) }},
   {{ SC_(8.89517527278534013732484972476112754e-30), SC_(-2.45436951518058776855468750000000000e-02), SC_(4.16434319662613395016219527765610305e+00) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-4.42849993705749511718750000000000000e-01), SC_(4.16434375109129527059545149836347403e+00) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(4.42849874496459960937500000000000000e-01), SC_(-8.06364469496545003722923360625135915e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-3.73093366622924804687500000000000000e-01), SC_(4.16434287967391764277557770499930490e+00) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(3.73093366622924804687500000000000000e-01), SC_(-8.06364522399190289050221070152545327e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-3.22322010993957519531250000000000000e-01), SC_(4.16434233783427100271166927163957526e+00) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(3.22322010993957519531250000000000000e-01), SC_(-8.06364502083074141683827549549074043e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-2.83713698387145996093750000000000000e-01), SC_(4.16434360012635733549302208371342896e+00) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(2.83713579177856445312500000000000000e-01), SC_(-8.06364415836082721293479580220821502e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-2.53365159034729003906250000000000000e-01), SC_(4.16434450232802567202306844162457895e+00) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(2.53365039825439453125000000000000000e-01), SC_(-8.06364433663844536433706204704978171e-01) }},
   {{ SC_(1.00109338760375976562500000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(4.79936162597137205515150159482244912e+00) }},
   {{ SC_(9.98907327651977539062500000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(4.80383895813268124910335394026644946e+00) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(2.38160610198974609375000000000000000e-01), SC_(4.80287056344997627966516268989249813e+00) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-2.38160669803619384765625000000000000e-01), SC_(-8.27671572370685746693874958021180851e-01) }},
   {{ SC_(1.00218868255615234375000000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(4.80267548839216750858043891959320083e+00) }},
   {{ SC_(9.97815847396850585937500000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(4.80384756538698068125191301619606289e+00) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(2.62836694717407226562500000000000000e-01), SC_(4.80287264257488934682462974417496937e+00) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-2.62836694717407226562500000000000000e-01), SC_(-8.27671558279060673773832081729539298e-01) }},
   {{ SC_(1.00438213348388671875000000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(4.80262447143763655109629005121378362e+00) }},
   {{ SC_(9.95636701583862304687500000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(4.80329375840405165878779050280596189e+00) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(2.93217182159423828125000000000000000e-01), SC_(4.80287250597744464517746585919521209e+00) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-2.93217182159423828125000000000000000e-01), SC_(-8.27671554222513719786948729773771506e-01) }},
   {{ SC_(1.00878334045410156250000000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(4.80247457857206900788795460219641037e+00) }},
   {{ SC_(9.91292715072631835937500000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(4.80297180099050121380334484616264302e+00) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(3.31538677215576171875000000000000000e-01), SC_(4.80287080814643252416089898194772054e+00) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-3.31538796424865722656250000000000000e-01), SC_(-8.27671612754771656017008915516956970e-01) }},
   {{ SC_(1.01764440536499023437500000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(4.80280555469416085047575675083110568e+00) }},
   {{ SC_(9.82661247253417968750000000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(4.80297162446338311985015703540894213e+00) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(3.81382942199707031250000000000000000e-01), SC_(4.80287178970209306254819660020206502e+00) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-3.81382942199707031250000000000000000e-01), SC_(-8.27671532951215204109435012106215122e-01) }},
   {{ SC_(1.03560018539428710937500000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(4.80281953139486565212555348951022316e+00) }},
   {{ SC_(9.65623378753662109375000000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(4.80289553264107797515446136500757068e+00) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(4.48866486549377441406250000000000000e-01), SC_(4.80287190248155817387599133696800821e+00) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-4.48866486549377441406250000000000000e-01), SC_(-8.27671536300438255010443967600042409e-01) }},
   {{ SC_(1.07246780395507812500000000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(4.80282768599822066245983786767640257e+00) }},
   {{ SC_(9.32428598403930664062500000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(4.80288164200633788735113987746228384e+00) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(5.45365810394287109375000000000000000e-01), SC_(4.80287076414474969046618637847892527e+00) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-5.45366048812866210937500000000000000e-01), SC_(-8.27671634964395686557026680411200090e-01) }},
   {{ SC_(1.15018749237060546875000000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(4.80284682297401974265955893449988985e+00) }},
   {{ SC_(8.69423151016235351562500000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(4.80287661845594007084734201176635206e+00) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(6.94719791412353515625000000000000000e-01), SC_(4.80286927653151093873160621973984628e+00) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-6.94720029830932617187500000000000000e-01), SC_(-8.27671562307751246515122812849840245e-01) }},
   {{ SC_(1.32293176651000976562500000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(4.80286057292735601558827581679613081e+00) }},
   {{ SC_(7.55896568298339843750000000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(4.80287889633040130995558553243634431e+00) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(9.56730365753173828125000000000000000e-01), SC_(4.80286990718415998502836102483470120e+00) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-9.56730604171752929687500000000000000e-01), SC_(-8.27671552557456134524405531507735432e-01) }},
   {{ SC_(1.75014925003051757812500000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(4.80286881426305303832471196939414057e+00) }},
   {{ SC_(5.71379661560058593750000000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(4.80287763302795423112030448529309851e+00) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(1.53604173660278320312500000000000000e+00), SC_(4.80286972191761497581582063761439179e+00) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-1.53604221343994140625000000000000000e+00), SC_(-8.27671565609431086026299490584619584e-01) }},
   {{ SC_(3.06302261352539062500000000000000000e+00), SC_(1.57079601287841796875000000000000000e+00), SC_(4.80286945747421034390748405173093375e+00) }},
   {{ SC_(3.26474785804748535156250000000000000e-01), SC_(-1.57079648971557617187500000000000000e+00), SC_(4.80287573000112678892666881275573872e+00) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(3.89375591278076171875000000000000000e+00), SC_(4.80286668034808448265868837174976106e+00) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-3.89375686645507812500000000000000000e+00), SC_(-8.27671455433563284529691028622505216e-01) }},
   {{ SC_(9.38210678100585937500000000000000000e+00), SC_(7.85398006439208984375000000000000000e-01), SC_(4.80286909316388246151788086440000952e+00) }},
   {{ SC_(1.06585830450057983398437500000000000e-01), SC_(-7.85398244857788085937500000000000000e-01), SC_(4.80287381933916704389745383394225670e+00) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-7.27902221679687500000000000000000000e+00), SC_(4.80288168821356763823148779663065583e+00) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(7.27902030944824218750000000000000000e+00), SC_(-8.27671747507915893819015843504031788e-01) }},
   {{ SC_(8.80239562988281250000000000000000000e+01), SC_(3.92699003219604492187500000000000000e-01), SC_(4.80286983482528004782660322957128406e+00) }},
   {{ SC_(1.13605372607707977294921875000000000e-02), SC_(-3.92699122428894042968750000000000000e-01), SC_(4.80287421890125898671937697975696861e+00) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-1.88117170333862304687500000000000000e+00), SC_(4.80287505384262845283512115680868107e+00) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(1.88117170333862304687500000000000000e+00), SC_(-8.27671629886670383886377480268585471e-01) }},
   {{ SC_(7.74822070312500000000000000000000000e+03), SC_(1.96349501609802246093750000000000000e-01), SC_(4.80287039665591659979391269112883710e+00) }},
   {{ SC_(1.29061867482960224151611328125000000e-04), SC_(-1.96349561214447021484375000000000000e-01), SC_(4.80287368364725846424897463048739804e+00) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-1.08016347885131835937500000000000000e+00), SC_(4.80287729367990486482918869801265312e+00) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(1.08016300201416015625000000000000000e+00), SC_(-8.27671562637881353397727581097455003e-01) }},
   {{ SC_(6.00349280000000000000000000000000000e+07), SC_(9.81747508049011230468750000000000000e-02), SC_(4.80287043400301269400347188632464739e+00) }},
   {{ SC_(1.66569620319023670163005590438842773e-08), SC_(-9.81747806072235107421875000000000000e-02), SC_(4.80287380698826343364766858798998183e+00) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-7.57582426071166992187500000000000000e-01), SC_(4.80287521036814052169767374811935055e+00) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(7.57582187652587890625000000000000000e-01), SC_(-8.27671539173471849546418481304404526e-01) }},
   {{ SC_(3.60419374714060800000000000000000000e+15), SC_(4.90873754024505615234375000000000000e-02), SC_(4.80287052624757299956904334710959218e+00) }},
   {{ SC_(2.77454535719092246215389252483873861e-16), SC_(-4.90873903036117553710937500000000000e-02), SC_(4.80287365136199750519940284083562885e+00) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-5.83365678787231445312500000000000000e-01), SC_(4.80287591814982778500564095193324676e+00) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(5.83365440368652343750000000000000000e-01), SC_(-8.27671531713663498374663677856915143e-01) }},
   {{ SC_(1.29902077453624549102531882516480000e+31), SC_(2.45436877012252807617187500000000000e-02), SC_(4.80287047338423972763940920615483738e+00) }},
   {{ SC_(7.69810326554071452251083714716486138e-32), SC_(-2.45436951518058776855468750000000000e-02), SC_(4.80287362682146211101222653325900724e+00) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-4.74294781684875488281250000000000000e-01), SC_(4.80287403584494329657070868870743929e+00) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(4.74294662475585937500000000000000000e-01), SC_(-8.27671523495484955661850262031612732e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-3.99585127830505371093750000000000000e-01), SC_(4.80287497497759118554960149811607408e+00) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(3.99585008621215820312500000000000000e-01), SC_(-8.27671537145559428694821356089429799e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-3.45208764076232910156250000000000000e-01), SC_(4.80287574982092091253313657281477064e+00) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(3.45208644866943359375000000000000000e-01), SC_(-8.27671545916715740041184347157920916e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-3.03858995437622070312500000000000000e-01), SC_(4.80287594542104133038770669715217612e+00) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(3.03858876228332519531250000000000000e-01), SC_(-8.27671537486039188354822512906620780e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-2.71355509757995605468750000000000000e-01), SC_(4.80287604350239701533348730136530906e+00) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(2.71355390548706054687500000000000000e-01), SC_(-8.27671526159339523574532306761239667e-01) }},
   {{ SC_(1.00117540359497070312500000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(5.61619668486018381089530076143338998e+00) }},
   {{ SC_(9.98825550079345703125000000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(5.62074387043709688692267351284876831e+00) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(2.55981922149658203125000000000000000e-01), SC_(5.61889497543556351219079930621991313e+00) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-2.55982041358947753906250000000000000e-01), SC_(-8.48917512125062513211602452886338765e-01) }},
   {{ SC_(1.00235271453857421875000000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(5.61898838816555904237102794215110161e+00) }},
   {{ SC_(9.97652769088745117187500000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(5.61919839772118544738325528490169532e+00) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(2.82504439353942871093750000000000000e-01), SC_(5.61889516970651749648300273831950213e+00) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-2.82504558563232421875000000000000000e-01), SC_(-8.48917504075596065710029211991089151e-01) }},
   {{ SC_(1.00471067428588867187500000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(5.61822002174384238661476503948410683e+00) }},
   {{ SC_(9.95311021804809570312500000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(5.61926756995815741748328098876938734e+00) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(3.15158247947692871093750000000000000e-01), SC_(5.61889448103444623500280376299190252e+00) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-3.15158367156982421875000000000000000e-01), SC_(-8.48917475872122449380650368331894225e-01) }},
   {{ SC_(1.00944375991821289062500000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(5.61851121597238901522105570874845669e+00) }},
   {{ SC_(9.90644216537475585937500000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(5.61901714000213066724457658594111608e+00) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(3.56347441673278808593750000000000000e-01), SC_(5.61889767668813268442865687623997228e+00) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-3.56347441673278808593750000000000000e-01), SC_(-8.48917440811629922381752882830449146e-01) }},
   {{ SC_(1.01897716522216796875000000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(5.61881210289408471538823677689223642e+00) }},
   {{ SC_(9.81375932693481445312500000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(5.61903820393056821508551355608303105e+00) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(4.09921407699584960937500000000000000e-01), SC_(5.61889570640434430173708920967978697e+00) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-4.09921526908874511718750000000000000e-01), SC_(-8.48917478874574317154327529940003010e-01) }},
   {{ SC_(1.03831434249877929687500000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(5.61877341363955690659756836318486142e+00) }},
   {{ SC_(9.63099002838134765625000000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(5.61894093498000407350061375862235086e+00) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(4.82454657554626464843750000000000000e-01), SC_(5.61889548711215457799209354766678967e+00) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-4.82454776763916015625000000000000000e-01), SC_(-8.48917461385136984230661894385221425e-01) }},
   {{ SC_(1.07809734344482421875000000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(5.61887673313348499932527280056479103e+00) }},
   {{ SC_(9.27559852600097656250000000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(5.61891164240228377338982123608776605e+00) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(5.86174964904785156250000000000000000e-01), SC_(5.61889512342303101890181091934642135e+00) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-5.86175203323364257812500000000000000e-01), SC_(-8.48917498668446573213447711228422415e-01) }},
   {{ SC_(1.16229391098022460937500000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(5.61887881109005761219637937289326151e+00) }},
   {{ SC_(8.60367298126220703125000000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(5.61890990509084134790385465882103580e+00) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(7.46705055236816406250000000000000000e-01), SC_(5.61889508820227258459521560775648105e+00) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-7.46705293655395507812500000000000000e-01), SC_(-8.48917472896729311115756616474790790e-01) }},
   {{ SC_(1.35092735290527343750000000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(5.61888550375581286814922482525988962e+00) }},
   {{ SC_(7.40231990814208984375000000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(5.61890411107064964757826623005046848e+00) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(1.02832174301147460937500000000000000e+00), SC_(5.61889702060308834512480734822497755e+00) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-1.02832174301147460937500000000000000e+00), SC_(-8.48917425835870783744243940940217180e-01) }},
   {{ SC_(1.82500553131103515625000000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(5.61889482944079319162186294465579681e+00) }},
   {{ SC_(5.47943353652954101562500000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(5.61890587842457531136491533210035207e+00) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(1.65098237991333007812500000000000000e+00), SC_(5.61889568683447279103480547259966883e+00) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-1.65098237991333007812500000000000000e+00), SC_(-8.48917395391336633121943913952352603e-01) }},
   {{ SC_(3.33064556121826171875000000000000000e+00), SC_(1.57079601287841796875000000000000000e+00), SC_(5.61889599037038490821113425744387720e+00) }},
   {{ SC_(3.00242066383361816406250000000000000e-01), SC_(-1.57079648971557617187500000000000000e+00), SC_(5.61890076825516778057381468149279364e+00) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(4.18512153625488281250000000000000000e+00), SC_(5.61888991233622456566424845267329691e+00) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-4.18512344360351562500000000000000000e+00), SC_(-8.48917393714116981950892289776093213e-01) }},
   {{ SC_(1.10931968688964843750000000000000000e+01), SC_(7.85398006439208984375000000000000000e-01), SC_(5.61889459128163448666503611880239460e+00) }},
   {{ SC_(9.01453197002410888671875000000000000e-02), SC_(-7.85398244857788085937500000000000000e-01), SC_(5.61889954142734297462862952555813230e+00) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-7.82370376586914062500000000000000000e+00), SC_(5.61890837559641382210779036552391130e+00) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(7.82370376586914062500000000000000000e+00), SC_(-8.48917685023870357010011720716504121e-01) }},
   {{ SC_(1.23059051513671875000000000000000000e+02), SC_(3.92699003219604492187500000000000000e-01), SC_(5.61889532508773044980714132032047517e+00) }},
   {{ SC_(8.12617689371109008789062500000000000e-03), SC_(-3.92699122428894042968750000000000000e-01), SC_(5.61890010762608007915405968123632821e+00) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-2.02193832397460937500000000000000000e+00), SC_(5.61890350711917067640897747555139013e+00) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(2.02193737030029296875000000000000000e+00), SC_(-8.48917439220030210633798682458602239e-01) }},
   {{ SC_(1.51435351562500000000000000000000000e+04), SC_(1.96349501609802246093750000000000000e-01), SC_(5.61889575391320070436861403632277297e+00) }},
   {{ SC_(6.60347577650099992752075195312500000e-05), SC_(-1.96349561214447021484375000000000000e-01), SC_(5.61889997267221749110629403921364056e+00) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-1.16099071502685546875000000000000000e+00), SC_(5.61890022134975447281196819557904960e+00) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(1.16099071502685546875000000000000000e+00), SC_(-8.48917498895900304360363614535422580e-01) }},
   {{ SC_(2.29326656000000000000000000000000000e+08), SC_(9.81747508049011230468750000000000000e-02), SC_(5.61889575099866913919348690289789917e+00) }},
   {{ SC_(4.36059188757553783943876624107360840e-09), SC_(-9.81747806072235107421875000000000000e-02), SC_(5.61889957710357842828143816992508555e+00) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-8.14271450042724609375000000000000000e-01), SC_(5.61889936927301944687124721949108085e+00) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(8.14271450042724609375000000000000000e-01), SC_(-8.48917479446460589661435169810900463e-01) }},
   {{ SC_(5.25907063084154880000000000000000000e+16), SC_(4.90873754024505615234375000000000000e-02), SC_(5.61889569636232507920153581639837750e+00) }},
   {{ SC_(1.90147580827810700702246160531672103e-17), SC_(-4.90873903036117553710937500000000000e-02), SC_(5.61889963737286187519754603010329363e+00) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-6.27018213272094726562500000000000000e-01), SC_(5.61889923709043768787691793523171514e+00) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(6.27018213272094726562500000000000000e-01), SC_(-8.48917476429270433099712519094240272e-01) }},
   {{ SC_(2.76578335285068947333467515702476800e+33), SC_(2.45436877012252807617187500000000000e-02), SC_(5.61889575291564354727448236324211478e+00) }},
   {{ SC_(3.61561123819811615454947665729993499e-34), SC_(-2.45436951518058776855468750000000000e-02), SC_(5.61889959294838434532240298014715378e+00) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-5.09785890579223632812500000000000000e-01), SC_(5.61890220910665326852338527385269035e+00) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(5.09785652160644531250000000000000000e-01), SC_(-8.48917410728040374438471734311928566e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-4.29485678672790527343750000000000000e-01), SC_(5.61890065535560737692816094411944666e+00) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(4.29485559463500976562500000000000000e-01), SC_(-8.48917429548478015987827682217434241e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-3.71040344238281250000000000000000000e-01), SC_(5.61890017599539235943337220423699016e+00) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(3.71040225028991699218750000000000000e-01), SC_(-8.48917406122742766613623916760874552e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-3.26596379280090332031250000000000000e-01), SC_(5.61889888198309965907100390324736276e+00) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(3.26596379280090332031250000000000000e-01), SC_(-8.48917468323615138392780970672202640e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-2.91660785675048828125000000000000000e-01), SC_(5.61890272281999381797237862543120100e+00) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(2.91660666465759277343750000000000000e-01), SC_(-8.48917439288600648650830635881261647e-01) }},
   {{ SC_(1.00126791000366210937500000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(6.67628139671713804522275309436640049e+00) }},
   {{ SC_(9.98733520507812500000000000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(6.67845056450343413794093731605869731e+00) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(2.76077985763549804687500000000000000e-01), SC_(6.67753677257164679461178204509613137e+00) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-2.76077985763549804687500000000000000e-01), SC_(-8.69749891192635378913632356246721734e-01) }},
   {{ SC_(1.00253725051879882812500000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(6.67519098803779023195402884831983169e+00) }},
   {{ SC_(9.97468709945678710937500000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(6.67804840607280980668327922638677516e+00) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(3.04682612419128417968750000000000000e-01), SC_(6.67753384268060845774386887601728257e+00) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-3.04682731628417968750000000000000000e-01), SC_(-8.69749945361088448348314010464056072e-01) }},
   {{ SC_(1.00508165359497070312500000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(6.67738665061796041951863242498685227e+00) }},
   {{ SC_(9.94943857192993164062500000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(6.67795570640961935705416693684000901e+00) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(3.39899897575378417968750000000000000e-01), SC_(6.67753162699134095890596083157719145e+00) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-3.39900016784667968750000000000000000e-01), SC_(-8.69749897009197937731473282844029431e-01) }},
   {{ SC_(1.01018905639648437500000000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(6.67727358000473311277245188903963377e+00) }},
   {{ SC_(9.89913463592529296875000000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(6.67766779153739800018907623289540206e+00) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(3.84322643280029296875000000000000000e-01), SC_(6.67753458815744476722645709848662926e+00) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-3.84322762489318847656250000000000000e-01), SC_(-8.69749936483153961091560765043785526e-01) }},
   {{ SC_(1.02048206329345703125000000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(6.67737464692523717467244055863283529e+00) }},
   {{ SC_(9.79928731918334960937500000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(6.67761539975823901862816879066902423e+00) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(4.42102551460266113281250000000000000e-01), SC_(6.67753552308405220867527298479075204e+00) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-4.42102670669555664062500000000000000e-01), SC_(-8.69749941581758293737777851072706081e-01) }},
   {{ SC_(1.04138374328613281250000000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(6.67741236467257331017157328358672080e+00) }},
   {{ SC_(9.60260391235351562500000000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(6.67758662598139008752900611625723374e+00) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(5.20329952239990234375000000000000000e-01), SC_(6.67753168462766202229529516145840754e+00) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-5.20330190658569335937500000000000000e-01), SC_(-8.69749926523755608703001667758366504e-01) }},
   {{ SC_(1.08448076248168945312500000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(6.67753009763588551966192761449693623e+00) }},
   {{ SC_(9.22100067138671875000000000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(6.67757654734796430547131771761460311e+00) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(6.32192850112915039062500000000000000e-01), SC_(6.67753089699873204647689032517867046e+00) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-6.32193088531494140625000000000000000e-01), SC_(-8.69749891636530171018632549867278588e-01) }},
   {{ SC_(1.17609834671020507812500000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(6.67751553824676116560062098235049702e+00) }},
   {{ SC_(8.50268840789794921875000000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(6.67754171549493725392444526795691005e+00) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(8.05325508117675781250000000000000000e-01), SC_(6.67753265612543038868925024513851720e+00) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-8.05325746536254882812500000000000000e-01), SC_(-8.69749899955269201793516188681255207e-01) }},
   {{ SC_(1.38320779800415039062500000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(6.67753216905307942333000730903265157e+00) }},
   {{ SC_(7.22957134246826171875000000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(6.67753953833336064891142862156288731e+00) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(1.10905027389526367187500000000000000e+00), SC_(6.67752970365704806572436311088588471e+00) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-1.10905075073242187500000000000000000e+00), SC_(-8.69749885414826737679001725960368018e-01) }},
   {{ SC_(1.91326379776000976562500000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(6.67753198374320426270660772049763186e+00) }},
   {{ SC_(5.22666931152343750000000000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(6.67754354420451386697324032777263732e+00) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(1.78059339523315429687500000000000000e+00), SC_(6.67753182248274983554633365875145354e+00) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-1.78059387207031250000000000000000000e+00), SC_(-8.69749878310876199948597732746783776e-01) }},
   {{ SC_(3.66057872772216796875000000000000000e+00), SC_(1.57079601287841796875000000000000000e+00), SC_(6.67753319580619599499744563526112810e+00) }},
   {{ SC_(2.73180842399597167968750000000000000e-01), SC_(-1.57079648971557617187500000000000000e+00), SC_(6.67753818136856653572586374404306109e+00) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(4.51367759704589843750000000000000000e+00), SC_(6.67752967134985445901942647764397507e+00) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-4.51367759704589843750000000000000000e+00), SC_(-8.69749770719651136533137172180223474e-01) }},
   {{ SC_(1.33998374938964843750000000000000000e+01), SC_(7.85398006439208984375000000000000000e-01), SC_(6.67753358822572110790781756513210221e+00) }},
   {{ SC_(7.46277570724487304687500000000000000e-02), SC_(-7.85398244857788085937500000000000000e-01), SC_(6.67753944037075531428538234271323340e+00) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-8.43790817260742187500000000000000000e+00), SC_(6.67755046469020766345234054085604159e+00) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(8.43790817260742187500000000000000000e+00), SC_(-8.69750123480256353667341799589600979e-01) }},
   {{ SC_(1.79555603027343750000000000000000000e+02), SC_(3.92699003219604492187500000000000000e-01), SC_(6.67753288575641222017109300597170873e+00) }},
   {{ SC_(5.56930340826511383056640625000000000e-03), SC_(-3.92699122428894042968750000000000000e-01), SC_(6.67753874603007769360243752592705000e+00) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-2.18067169189453125000000000000000000e+00), SC_(6.67754384185772887325732898444919915e+00) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(2.18067073822021484375000000000000000e+00), SC_(-8.69749895017321330674338395808930697e-01) }},
   {{ SC_(3.22402265625000000000000000000000000e+04), SC_(1.96349501609802246093750000000000000e-01), SC_(6.67753344610054294588059563592990914e+00) }},
   {{ SC_(3.10171453747898340225219726562500000e-05), SC_(-1.96349561214447021484375000000000000e-01), SC_(6.67753850683867657974785940994275393e+00) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-1.25213479995727539062500000000000000e+00), SC_(6.67753819844418168492313679931319436e+00) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(1.25213479995727539062500000000000000e+00), SC_(-8.69749915382687973185476920742482273e-01) }},
   {{ SC_(1.03943244800000000000000000000000000e+09), SC_(9.81747508049011230468750000000000000e-02), SC_(6.67753361955444287878724007407197564e+00) }},
   {{ SC_(9.62063317899719550041481852531433105e-10), SC_(-9.81747806072235107421875000000000000e-02), SC_(6.67753849845650922244089977620378013e+00) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-8.78196239471435546875000000000000000e-01), SC_(6.67753806550051613707040785352284604e+00) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(8.78196239471435546875000000000000000e-01), SC_(-8.69749913127287408679831162251190031e-01) }},
   {{ SC_(1.08041970787129753600000000000000000e+18), SC_(4.90873754024505615234375000000000000e-02), SC_(6.67753358255043164725755218121205946e+00) }},
   {{ SC_(9.25565888200391063034451477609110270e-19), SC_(-4.90873903036117553710937500000000000e-02), SC_(6.67753847380097814381516190473304810e+00) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-6.76242589950561523437500000000000000e-01), SC_(6.67753782408986719405315855073022772e+00) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(6.76242589950561523437500000000000000e-01), SC_(-8.69749909031735069209147359382274196e-01) }},
   {{ SC_(1.16730686475331338970507829557225062e+36), SC_(2.45436877012252807617187500000000000e-02), SC_(6.67753360185656966309441364723147994e+00) }},
   {{ SC_(8.56672717881139463758020364805990571e-37), SC_(-2.45436951518058776855468750000000000e-02), SC_(6.67753836283447041826957630577736931e+00) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-5.49806833267211914062500000000000000e-01), SC_(6.67754005654467374107670909714310045e+00) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(5.49806594848632812500000000000000000e-01), SC_(-8.69749831778828446017299848803047052e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-4.63202595710754394531250000000000000e-01), SC_(6.67753724120627101214297992760765326e+00) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(4.63202595710754394531250000000000000e-01), SC_(-8.69749899143063866270796697202905090e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-4.00169014930725097656250000000000000e-01), SC_(6.67753758818881978488618379265741568e+00) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(4.00169014930725097656250000000000000e-01), SC_(-8.69749905029653342924630675914172247e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-3.52236032485961914062500000000000000e-01), SC_(6.67753924665795841427341349799941590e+00) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(3.52235913276672363281250000000000000e-01), SC_(-8.69749843314841240847029632706025249e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-3.14557671546936035156250000000000000e-01), SC_(6.67753774887059479404165829693127886e+00) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(3.14557671546936035156250000000000000e-01), SC_(-8.69749907755633616746809011730420623e-01) }},
   {{ SC_(1.00137186050415039062500000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(8.07132836455006413332621589994746143e+00) }},
   {{ SC_(9.98629808425903320312500000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(8.07441051614776370880709340746353855e+00) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(2.98709750175476074218750000000000000e-01), SC_(8.07379245768951553889125754965024407e+00) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-2.98709869384765625000000000000000000e-01), SC_(-8.89792595043951371636038719542813127e-01) }},
   {{ SC_(1.00274562835693359375000000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(8.07151278434223060700970500703132027e+00) }},
   {{ SC_(9.97261524200439453125000000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(8.07419153382670361390096837635071770e+00) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(3.29659342765808105468750000000000000e-01), SC_(8.07379317466183208095018319286955799e+00) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-3.29659461975097656250000000000000000e-01), SC_(-8.89792594645677448385091131186677008e-01) }},
   {{ SC_(1.00549936294555664062500000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(8.07357279422873559799205717446540353e+00) }},
   {{ SC_(9.94530677795410156250000000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(8.07371404286478504785363122981133896e+00) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(3.67763757705688476562500000000000000e-01), SC_(8.07379848685552433593220245457304390e+00) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-3.67763757705688476562500000000000000e-01), SC_(-8.89792571275566802054531128750187348e-01) }},
   {{ SC_(1.01102876663208007812500000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(8.07320784850491183009588320794565270e+00) }},
   {{ SC_(9.89091157913208007812500000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(8.07391908530537794646990789443986788e+00) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(4.15827989578247070312500000000000000e-01), SC_(8.07379542121085539711764570262918866e+00) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-4.15828108787536621093750000000000000e-01), SC_(-8.89792603718759580020093295298531766e-01) }},
   {{ SC_(1.02217960357666015625000000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(8.07359747235709439282808217513831063e+00) }},
   {{ SC_(9.78301286697387695312500000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(8.07394889060909748051824096021977338e+00) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(4.78344440460205078125000000000000000e-01), SC_(8.07379493985808863605320341047182137e+00) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-4.78344559669494628906250000000000000e-01), SC_(-8.89792588766011569117106424143758427e-01) }},
   {{ SC_(1.04485130310058593750000000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(8.07366780865571786562942353679402543e+00) }},
   {{ SC_(9.57073688507080078125000000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(8.07381499945850729701016623002901437e+00) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(5.62984704971313476562500000000000000e-01), SC_(8.07379281664900278180912798950952546e+00) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-5.62984943389892578125000000000000000e-01), SC_(-8.89792605336535330660818135127721470e-01) }},
   {{ SC_(1.09171485900878906250000000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(8.07379594519404383408197527625790623e+00) }},
   {{ SC_(9.15990114212036132812500000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(8.07379782596637674182571887929125229e+00) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(6.84017896652221679687500000000000000e-01), SC_(8.07379711094116716459778896267504269e+00) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-6.84017896652221679687500000000000000e-01), SC_(-8.89792554564152430000544964342809762e-01) }},
   {{ SC_(1.19184112548828125000000000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(8.07377605594862732402712573045393616e+00) }},
   {{ SC_(8.39037895202636718750000000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(8.07379702844672423192677995301657630e+00) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(8.71343135833740234375000000000000000e-01), SC_(8.07379355841069979355263746859522615e+00) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-8.71343374252319335937500000000000000e-01), SC_(-8.89792577920168401616340278941454215e-01) }},
   {{ SC_(1.42048549652099609375000000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(8.07378521154627988840800022706496100e+00) }},
   {{ SC_(7.03984498977661132812500000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(8.07380436639308311465431182118581253e+00) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(1.19996643066406250000000000000000000e+00), SC_(8.07379458809791009423480437674717147e+00) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-1.19996690750122070312500000000000000e+00), SC_(-8.89792620504755533065447273041458575e-01) }},
   {{ SC_(2.01777935028076171875000000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(8.07378951271817760030975488966359881e+00) }},
   {{ SC_(4.95594143867492675781250000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(8.07380614565527252207786640558924250e+00) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(1.92655992507934570312500000000000000e+00), SC_(8.07379272373400886205073436325552122e+00) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-1.92656040191650390625000000000000000e+00), SC_(-8.89792561435216139833453699979815538e-01) }},
   {{ SC_(4.07143402099609375000000000000000000e+00), SC_(1.57079601287841796875000000000000000e+00), SC_(8.07379131412261276669146781913019927e+00) }},
   {{ SC_(2.45613634586334228515625000000000000e-01), SC_(-1.57079648971557617187500000000000000e+00), SC_(8.07380155250118320544914096785637472e+00) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(4.88369178771972656250000000000000000e+00), SC_(8.07378759895614791174168263574530559e+00) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-4.88369369506835937500000000000000000e+00), SC_(-8.89792533959012124834860648064889486e-01) }},
   {{ SC_(1.65765762329101562500000000000000000e+01), SC_(7.85398006439208984375000000000000000e-01), SC_(8.07379184962005582707361057671196173e+00) }},
   {{ SC_(6.03260546922683715820312500000000000e-02), SC_(-7.85398244857788085937500000000000000e-01), SC_(8.07380188356426031793415123408619797e+00) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-9.12961959838867187500000000000000000e+00), SC_(8.07382225092971202616157256514447310e+00) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(9.12961578369140625000000000000000000e+00), SC_(-8.89792758350091196008217857791595796e-01) }},
   {{ SC_(2.74783081054687500000000000000000000e+02), SC_(3.92699003219604492187500000000000000e-01), SC_(8.07379446192819423051270875808129320e+00) }},
   {{ SC_(3.63923329859972000122070312500000000e-03), SC_(-3.92699122428894042968750000000000000e-01), SC_(8.07380146854613212996754094265486794e+00) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-2.35943508148193359375000000000000000e+00), SC_(8.07380728949611550983365704906418308e+00) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(2.35943412780761718750000000000000000e+00), SC_(-8.89792579949466932659921906315934412e-01) }},
   {{ SC_(7.55057500000000000000000000000000000e+04), SC_(1.96349501609802246093750000000000000e-01), SC_(8.07379465933468751427619349500459506e+00) }},
   {{ SC_(1.32440218294505029916763305664062500e-05), SC_(-1.96349561214447021484375000000000000e-01), SC_(8.07380108813771187420984930755882608e+00) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-1.35478019714355468750000000000000000e+00), SC_(8.07380041767512678706975608742243476e+00) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(1.35478019714355468750000000000000000e+00), SC_(-8.89792594726673716679950562313251122e-01) }},
   {{ SC_(5.70111795200000000000000000000000000e+09), SC_(9.81747508049011230468750000000000000e-02), SC_(8.07379460760513702063715566220704582e+00) }},
   {{ SC_(1.75404191171679713079356588423252106e-10), SC_(-9.81747806072235107421875000000000000e-02), SC_(8.07380069732086276255693669420911848e+00) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-9.50187683105468750000000000000000000e-01), SC_(8.07380344448737987631331440900462523e+00) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(9.50187444686889648437500000000000000e-01), SC_(-8.89792570503751753877027902109658546e-01) }},
   {{ SC_(3.25027423935235358720000000000000000e+19), SC_(4.90873754024505615234375000000000000e-02), SC_(8.07379455951747955791093737999279894e+00) }},
   {{ SC_(3.07666209923918724172342900602394877e-20), SC_(-4.90873903036117553710937500000000000e-02), SC_(8.07380083178635343485045613348036981e+00) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-7.31678485870361328125000000000000000e-01), SC_(8.07380048958263078237585073106532458e+00) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(7.31678485870361328125000000000000000e-01), SC_(-8.89792595600038680357760424849632963e-01) }},
   {{ SC_(9.46585520442199880311404875889838086e-40), SC_(-2.45436951518058776855468750000000000e-02), SC_(8.07380070164524451800649345302103420e+00) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-5.94877958297729492187500000000000000e-01), SC_(8.07380234633849638285211992366756827e+00) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(5.94877719879150390625000000000000000e-01), SC_(-8.89792520740409140243551277513436659e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-5.01174449920654296875000000000000000e-01), SC_(8.07380766515006703105199494706326632e+00) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(5.01174211502075195312500000000000000e-01), SC_(-8.89792567128155692437854845011472110e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-4.32973384857177734375000000000000000e-01), SC_(8.07379910934310739571573607179757108e+00) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(4.32973384857177734375000000000000000e-01), SC_(-8.89792578836099619148411229656229219e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-3.81111025810241699218750000000000000e-01), SC_(8.07380077395673999597437213053434044e+00) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(3.81110906600952148437500000000000000e-01), SC_(-8.89792523029179040074609155918096673e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-3.40343952178955078125000000000000000e-01), SC_(8.07379994641393197926586256548482183e+00) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(3.40343952178955078125000000000000000e-01), SC_(-8.89792589002889437492542263223889592e-01) }},
   {{ SC_(1.00148868560791015625000000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(9.94368893401035754860413208072936621e+00) }},
   {{ SC_(9.98513221740722656250000000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(9.94908463653127486611276172994430661e+00) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(3.24155926704406738281250000000000000e-01), SC_(9.94913888033951878673757214200287840e+00) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-3.24156045913696289062500000000000000e-01), SC_(-9.08668697072849670016132146815919426e-01) }},
   {{ SC_(1.00298023223876953125000000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(9.94934903576226629559178342738401641e+00) }},
   {{ SC_(9.97028589248657226562500000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(9.94965645749530798610140837990930470e+00) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(3.57742071151733398437500000000000000e-01), SC_(9.94914348518329753824171954848429924e+00) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-3.57742071151733398437500000000000000e-01), SC_(-9.08668655100444216224863364635250035e-01) }},
   {{ SC_(1.00596904754638671875000000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(9.94804167639378503772350736886020626e+00) }},
   {{ SC_(9.94065999984741210937500000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(9.94969098220270930076971064032795710e+00) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(3.99092316627502441406250000000000000e-01), SC_(9.94913897416010778312660037365603929e+00) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-3.99092435836791992187500000000000000e-01), SC_(-9.08668682762110000099433734867088866e-01) }},
   {{ SC_(1.01197385787963867187500000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(9.94833154207871122849786235738728722e+00) }},
   {{ SC_(9.88167285919189453125000000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(9.94952702229772012461394866221891642e+00) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(4.51251029968261718750000000000000000e-01), SC_(9.94913792363556951148062111212923622e+00) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-4.51251149177551269531250000000000000e-01), SC_(-9.08668666452577833302687833973963165e-01) }},
   {{ SC_(1.02409172058105468750000000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(9.94901032307281018493732272961897367e+00) }},
   {{ SC_(9.76474761962890625000000000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(9.94932749217355083288614018421412758e+00) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(5.19093036651611328125000000000000000e-01), SC_(9.94913637040958677199417459109841304e+00) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-5.19093275070190429687500000000000000e-01), SC_(-9.08668696146439413681770128095603852e-01) }},
   {{ SC_(1.04876375198364257812500000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(9.94895775250217060572825502378223477e+00) }},
   {{ SC_(9.53503131866455078125000000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(9.94922872244759733289472164036973094e+00) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(6.10943555831909179687500000000000000e-01), SC_(9.94913478046764560774117980900094687e+00) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-6.10943794250488281250000000000000000e-01), SC_(-9.08668667790731436801676314524324042e-01) }},
   {{ SC_(1.09990596771240234375000000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(9.94909791509858090805856563612092338e+00) }},
   {{ SC_(9.09168481826782226562500000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(9.94915022421601635891329043281421488e+00) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(7.42287158966064453125000000000000000e-01), SC_(9.94913984947264800309445717196958481e+00) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-7.42287397384643554687500000000000000e-01), SC_(-9.08668694980077698694275513267237384e-01) }},
   {{ SC_(1.20979309082031250000000000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(9.94909257101170459306748788502840266e+00) }},
   {{ SC_(8.26587200164794921875000000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(9.94917156107600467246426867458558739e+00) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(9.45570230484008789062500000000000000e-01), SC_(9.94914084564658711731332777102494735e+00) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-9.45570468902587890625000000000000000e-01), SC_(-9.08668688196240712892664174736006172e-01) }},
   {{ SC_(1.46360015869140625000000000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(9.94913187095362974282442009225671986e+00) }},
   {{ SC_(6.83246612548828125000000000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(9.94915010694938285067541227545319629e+00) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(1.30218791961669921875000000000000000e+00), SC_(9.94914152211776619956626019229043317e+00) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-1.30218791961669921875000000000000000e+00), SC_(-9.08668638725697872783280266390300556e-01) }},
   {{ SC_(2.14212512969970703125000000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(9.94912713678078872858862506719125480e+00) }},
   {{ SC_(4.66825962066650390625000000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(9.94914800641453788049196244623892323e+00) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(2.09067726135253906250000000000000000e+00), SC_(9.94913354612204468310863761241735789e+00) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-2.09067821502685546875000000000000000e+00), SC_(-9.08668671900940148536801044064952236e-01) }},
   {{ SC_(4.58870315551757812500000000000000000e+00), SC_(1.57079601287841796875000000000000000e+00), SC_(9.94913869673136658676425248764917327e+00) }},
   {{ SC_(2.17926502227783203125000000000000000e-01), SC_(-1.57079648971557617187500000000000000e+00), SC_(9.94914616217276649891730439370395742e+00) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(5.29971694946289062500000000000000000e+00), SC_(9.94912405606097801337485988077633049e+00) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-5.29971885681152343750000000000000000e+00), SC_(-9.08668571699894221127380227736735433e-01) }},
   {{ SC_(2.10561904907226562500000000000000000e+01), SC_(7.85398006439208984375000000000000000e-01), SC_(9.94913618148050065622666520787184228e+00) }},
   {{ SC_(4.74919527769088745117187500000000000e-02), SC_(-7.85398244857788085937500000000000000e-01), SC_(9.94914753765125766507487924303501005e+00) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-9.90734100341796875000000000000000000e+00), SC_(9.94916952317145253951269445100057891e+00) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(9.90733718872070312500000000000000000e+00), SC_(-9.08668788132263970076076325748874034e-01) }},
   {{ SC_(4.43363403320312500000000000000000000e+02), SC_(3.92699003219604492187500000000000000e-01), SC_(9.94913856076329880259663619886986980e+00) }},
   {{ SC_(2.25548539310693740844726562500000000e-03), SC_(-3.92699122428894042968750000000000000e-01), SC_(9.94914789119562260384964625235992518e+00) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-2.56042766571044921875000000000000000e+00), SC_(9.94915292409567169629890732212495439e+00) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(2.56042671203613281250000000000000000e+00), SC_(-9.08668652420554183849523154691258590e-01) }},
   {{ SC_(1.96571062500000000000000000000000000e+05), SC_(1.96349501609802246093750000000000000e-01), SC_(9.94913806965992670466362575782865304e+00) }},
   {{ SC_(5.08721677761059254407882690429687500e-06), SC_(-1.96349561214447021484375000000000000e-01), SC_(9.94914686888599318365494795273119199e+00) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-1.47019004821777343750000000000000000e+00), SC_(9.94915358362006844008419518885337076e+00) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(1.47018957138061523437500000000000000e+00), SC_(-9.08668668442099577829876982878423671e-01) }},
   {{ SC_(3.86401894400000000000000000000000000e+10), SC_(9.81747508049011230468750000000000000e-02), SC_(9.94913825959708955797584859935325903e+00) }},
   {{ SC_(2.58797844265856724632612895220518112e-11), SC_(-9.81747806072235107421875000000000000e-02), SC_(9.94914645834132393853438141141364049e+00) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-1.03113126754760742187500000000000000e+00), SC_(9.94915278800212955406343147982400786e+00) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(1.03113079071044921875000000000000000e+00), SC_(-9.08668631618840596202324250543035209e-01) }},
   {{ SC_(1.49306487366325842739200000000000000e+21), SC_(4.90873754024505615234375000000000000e-02), SC_(9.94913848771413383865957547745696372e+00) }},
   {{ SC_(6.69763052884714746552020545825728570e-22), SC_(-4.90873903036117553710937500000000000e-02), SC_(9.94914661007387678278477434289263201e+00) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-7.94008016586303710937500000000000000e-01), SC_(9.94915145670324191728625789766483553e+00) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(7.94007778167724609375000000000000000e-01), SC_(-9.08668655960712616437820390183254409e-01) }},
   {{ SC_(4.48415508583941462695593466652773162e-43), SC_(-2.45436951518058776855468750000000000e-02), SC_(9.94924669693996395629662358973866740e+00) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-6.45553827285766601562500000000000000e-01), SC_(9.94915272955209917907409645888862697e+00) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(6.45553588867187500000000000000000000e-01), SC_(-9.08668651484722315557004234357421557e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-5.43867826461791992187500000000000000e-01), SC_(9.94915142538328776104036870437684572e+00) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(5.43867588043212890625000000000000000e-01), SC_(-9.08668625512771539292598592361805146e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-4.69857096672058105468750000000000000e-01), SC_(9.94914892698363985819326189159821264e+00) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(4.69856977462768554687500000000000000e-01), SC_(-9.08668645036002213828641069781400330e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-4.13576722145080566406250000000000000e-01), SC_(9.94915010995655276560272092551372599e+00) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(4.13576602935791015625000000000000000e-01), SC_(-9.08668647356993544736859610648428226e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-3.69336843490600585937500000000000000e-01), SC_(9.94915035704324436030876225502387707e+00) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(3.69336724281311035156250000000000000e-01), SC_(-9.08668641871373232553880748528607679e-01) }},
   {{ SC_(1.00162029266357421875000000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(1.25193728916972121960595398050489813e+01) }},
   {{ SC_(9.98382329940795898437500000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(1.25193508419271199922639310535700110e+01) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(3.52710962295532226562500000000000000e-01), SC_(1.25188389537904271269359936681602024e+01) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-3.52711081504821777343750000000000000e-01), SC_(-9.26029215727039391094808125570915926e-01) }},
   {{ SC_(1.00324296951293945312500000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(1.25167594792046582686966785375142898e+01) }},
   {{ SC_(9.96767282485961914062500000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(1.25192881424530032505308985313500660e+01) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(3.89255642890930175781250000000000000e-01), SC_(1.25188377401862151228299417790581062e+01) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-3.89255762100219726562500000000000000e-01), SC_(-9.26029202974406930369337732680809666e-01) }},
   {{ SC_(1.00649642944335937500000000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(1.25166167288822316192852256499589107e+01) }},
   {{ SC_(9.93545055389404296875000000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(1.25190695207427102719330191699109877e+01) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(4.34248566627502441406250000000000000e-01), SC_(1.25188419540970694150072339501331059e+01) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-4.34248685836791992187500000000000000e-01), SC_(-9.26029219919410415069115655717473748e-01) }},
   {{ SC_(1.01303577423095703125000000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(1.25185262765464301041193990213737794e+01) }},
   {{ SC_(9.87131834030151367187500000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(1.25189127275154447751591360461800976e+01) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(4.91001963615417480468750000000000000e-01), SC_(1.25188402148957013541368602461764765e+01) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-4.91002082824707031250000000000000000e-01), SC_(-9.26029204290879724023141192113716820e-01) }},
   {{ SC_(1.02624130249023437500000000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(1.25182913759669618765790980924144442e+01) }},
   {{ SC_(9.74429130554199218750000000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(1.25190901409738664429471332743636140e+01) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(5.64820289611816406250000000000000000e-01), SC_(1.25188432579878566293803347648974224e+01) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-5.64820289611816406250000000000000000e-01), SC_(-9.26029174174415281533176661979267750e-01) }},
   {{ SC_(1.05317211151123046875000000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(1.25188724364319039860991686055739995e+01) }},
   {{ SC_(9.49512481689453125000000000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(1.25188387856659185660351546257773656e+01) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(6.64762020111083984375000000000000000e-01), SC_(1.25188431142694650264087047382756234e+01) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-6.64762020111083984375000000000000000e-01), SC_(-9.26029173388033782514569922098757795e-01) }},
   {{ SC_(1.10917139053344726562500000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(1.25188399870463847586165256136790634e+01) }},
   {{ SC_(9.01573896408081054687500000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(1.25188600691190764736853103473608058e+01) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(8.07675600051879882812500000000000000e-01), SC_(1.25188422018431404598220290185276995e+01) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-8.07675600051879882812500000000000000e-01), SC_(-9.26029168395525663623537872563238927e-01) }},
   {{ SC_(1.23026084899902343750000000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(1.25187951670849837928978991037685987e+01) }},
   {{ SC_(8.12835454940795898437500000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(1.25188675395627117517751948470766849e+01) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(1.02886581420898437500000000000000000e+00), SC_(1.25188379574286277902223787159661041e+01) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-1.02886629104614257812500000000000000e+00), SC_(-9.26029234445782151857720305157012538e-01) }},
   {{ SC_(1.51354217529296875000000000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(1.25188186655937077478801080356324989e+01) }},
   {{ SC_(6.60701513290405273437500000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(1.25188628493917375451826241613918131e+01) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(1.41689777374267578125000000000000000e+00), SC_(1.25188315173390628632156357570859934e+01) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-1.41689825057983398437500000000000000e+00), SC_(-9.26029174758941477906519648588041416e-01) }},
   {{ SC_(2.29081058502197265625000000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(1.25188310617310235084439258777333944e+01) }},
   {{ SC_(4.36526536941528320312500000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(1.25188582496651711284164738290716344e+01) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(2.27484607696533203125000000000000000e+00), SC_(1.25188341500545371423070948638009700e+01) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-2.27484703063964843750000000000000000e+00), SC_(-9.26029205092566286276631775824708807e-01) }},
   {{ SC_(5.24781417846679687500000000000000000e+00), SC_(1.57079601287841796875000000000000000e+00), SC_(1.25188352782673832185335934555091407e+01) }},
   {{ SC_(1.90555453300476074218750000000000000e-01), SC_(-1.57079648971557617187500000000000000e+00), SC_(1.25188542549757563135848615653952394e+01) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(5.76657295227050781250000000000000000e+00), SC_(1.25188290969867401705860852465637193e+01) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-5.76657295227050781250000000000000000e+00), SC_(-9.26029096689824006171509772445556548e-01) }},
   {{ SC_(2.75395584106445312500000000000000000e+01), SC_(7.85398006439208984375000000000000000e-01), SC_(1.25188371130357514781093102234091581e+01) }},
   {{ SC_(3.63113880157470703125000000000000000e-02), SC_(-7.85398244857788085937500000000000000e-01), SC_(1.25188521399421418934726891008216281e+01) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-1.07800827026367187500000000000000000e+01), SC_(1.25188793083578339719351785542229460e+01) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(1.07800788879394531250000000000000000e+01), SC_(-9.26029303266410891620592338099105931e-01) }},
   {{ SC_(7.58427246093750000000000000000000000e+02), SC_(3.92699003219604492187500000000000000e-01), SC_(1.25188368935253802381510987579720633e+01) }},
   {{ SC_(1.31851760670542716979980468750000000e-03), SC_(-3.92699122428894042968750000000000000e-01), SC_(1.25188492929940770852873894118356891e+01) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-2.78597640991210937500000000000000000e+00), SC_(1.25188523273070790464094319194111727e+01) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(2.78597640991210937500000000000000000e+00), SC_(-9.26029223798822466079447921324522815e-01) }},
   {{ SC_(5.75212000000000000000000000000000000e+05), SC_(1.96349501609802246093750000000000000e-01), SC_(1.25188374121349359439631404277286391e+01) }},
   {{ SC_(1.73848866324988193809986114501953125e-06), SC_(-1.96349561214447021484375000000000000e-01), SC_(1.25188493173356966992692023053506929e+01) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-1.59969949722290039062500000000000000e+00), SC_(1.25188537040402453955894755124757034e+01) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(1.59969902038574218750000000000000000e+00), SC_(-9.26029173913974838994735049880329088e-01) }},
   {{ SC_(3.30868981760000000000000000000000000e+11), SC_(9.81747508049011230468750000000000000e-02), SC_(1.25188379609424959413092377078461829e+01) }},
   {{ SC_(3.02234279270230388192430837079882622e-12), SC_(-9.81747806072235107421875000000000000e-02), SC_(1.25188493347016703472939606260173645e+01) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-1.12196397781372070312500000000000000e+00), SC_(1.25188548627459331513555858491912028e+01) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(1.12196350097656250000000000000000000e+00), SC_(-9.26029155805323733274959234860154621e-01) }},
   {{ SC_(1.09474328404453452939264000000000000e+23), SC_(4.90873754024505615234375000000000000e-02), SC_(1.25188382356212743431068271489006665e+01) }},
   {{ SC_(9.13455805402153028791512127723532279e-24), SC_(-4.90873903036117553710937500000000000e-02), SC_(1.25188491823286797594670616761830209e+01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-8.63952398300170898437500000000000000e-01), SC_(1.25188506578895248791385340359753090e+01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(8.63952159881591796875000000000000000e-01), SC_(-9.26029161506652665343352506726495784e-01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-7.02420711517333984375000000000000000e-01), SC_(1.25188459703378526809308303543601521e+01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(7.02420711517333984375000000000000000e-01), SC_(-9.26029189015531866201278293991796773e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-5.91777324676513671875000000000000000e-01), SC_(1.25188526235220845799385771835450025e+01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(5.91777086257934570312500000000000000e-01), SC_(-9.26029147813246835659114480587375670e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-5.11246919631958007812500000000000000e-01), SC_(1.25188461418475607567761006440057426e+01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(5.11246919631958007812500000000000000e-01), SC_(-9.26029189953978244313975833372570808e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-4.50008869171142578125000000000000000e-01), SC_(1.25188536446650427491272260968283728e+01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(4.50008749961853027343750000000000000e-01), SC_(-9.26029179979451439041900352741084347e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-4.01871800422668457031250000000000000e-01), SC_(1.25188469145604202994910031914396805e+01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(4.01871800422668457031250000000000000e-01), SC_(-9.26029194182016072879846015078846827e-01) }},
   {{ SC_(1.00176715850830078125000000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(1.61150337341141524484379174709149108e+01) }},
   {{ SC_(9.98235702514648437500000000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(1.61221187046493266138794399730449651e+01) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(3.84685039520263671875000000000000000e-01), SC_(1.61183423285806921214869652850523921e+01) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-3.84685158729553222656250000000000000e-01), SC_(-9.41583180153948958243706189362078146e-01) }},
   {{ SC_(1.00353765487670898437500000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(1.61179831214247786392757945184413050e+01) }},
   {{ SC_(9.96474742889404296875000000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(1.61190080976903949375125943541288770e+01) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(4.24542665481567382812500000000000000e-01), SC_(1.61183502984651898002465809151921191e+01) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-4.24542784690856933593750000000000000e-01), SC_(-9.41583202524433647484020498907056649e-01) }},
   {{ SC_(1.00708770751953125000000000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(1.61171818206998851925171027124875609e+01) }},
   {{ SC_(9.92961883544921875000000000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(1.61192138047610565553816703895610141e+01) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(4.73614215850830078125000000000000000e-01), SC_(1.61183461272218532887818749793073645e+01) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-4.73614335060119628906250000000000000e-01), SC_(-9.41583183463001237438395414665875665e-01) }},
   {{ SC_(1.01422595977783203125000000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(1.61182308729610175929995357685281438e+01) }},
   {{ SC_(9.85973358154296875000000000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(1.61190183760339190633537033701775159e+01) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(5.35512447357177734375000000000000000e-01), SC_(1.61183442891905222538676484071798858e+01) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-5.35512685775756835937500000000000000e-01), SC_(-9.41583209297149498459478597623793940e-01) }},
   {{ SC_(1.02865409851074218750000000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(1.61178979936113475734216876256757522e+01) }},
   {{ SC_(9.72143650054931640625000000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(1.61186872171664751972041428111186375e+01) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(6.16022586822509765625000000000000000e-01), SC_(1.61183491596051924977884643939198945e+01) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-6.16022825241088867187500000000000000e-01), SC_(-9.41583216263652093420845199251253129e-01) }},
   {{ SC_(1.05812978744506835937500000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(1.61183314692479496168471965808536556e+01) }},
   {{ SC_(9.45063591003417968750000000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(1.61184007208216119809371741147630247e+01) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(7.25024223327636718750000000000000000e-01), SC_(1.61183457015784672088415584294005070e+01) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-7.25024461746215820312500000000000000e-01), SC_(-9.41583194809137523809140790092053083e-01) }},
   {{ SC_(1.11963844299316406250000000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(1.61182530479066648251601667488652893e+01) }},
   {{ SC_(8.93145084381103515625000000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(1.61184520991434922733557674680311792e+01) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(8.80893230438232421875000000000000000e-01), SC_(1.61183435066027901570824614524127097e+01) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-8.80893468856811523437500000000000000e-01), SC_(-9.41583177664809766930711444389171069e-01) }},
   {{ SC_(1.25359058380126953125000000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(1.61183115241709311466951666910189337e+01) }},
   {{ SC_(7.97708511352539062500000000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(1.61183524303717556090532105654480419e+01) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(1.12213516235351562500000000000000000e+00), SC_(1.61183515830321333729837779287044295e+01) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-1.12213516235351562500000000000000000e+00), SC_(-9.41583160320692960620678515675031267e-01) }},
   {{ SC_(1.57148981094360351562500000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(1.61183429497052712623040490467643836e+01) }},
   {{ SC_(6.36338710784912109375000000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(1.61183791871001311739258238814919702e+01) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(1.54534339904785156250000000000000000e+00), SC_(1.61183482272757593393186550238583911e+01) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-1.54534339904785156250000000000000000e+00), SC_(-9.41583148869080953313460040636644159e-01) }},
   {{ SC_(2.46957969665527343750000000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(1.61183314246119535337806604998713548e+01) }},
   {{ SC_(4.04927015304565429687500000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(1.61183711571615499747641214914708105e+01) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(2.48106670379638671875000000000000000e+00), SC_(1.61183452278747388621685583151455929e+01) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-2.48106670379638671875000000000000000e+00), SC_(-9.41583138633537706421391687205917003e-01) }},
   {{ SC_(6.09882545471191406250000000000000000e+00), SC_(1.57079601287841796875000000000000000e+00), SC_(1.61183383756739676050523023794730888e+01) }},
   {{ SC_(1.63965940475463867187500000000000000e-01), SC_(-1.57079648971557617187500000000000000e+00), SC_(1.61183625061357568700505242765031000e+01) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(6.28932571411132812500000000000000000e+00), SC_(1.61183239110987675032901111272819289e+01) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-6.28932762145996093750000000000000000e+00), SC_(-9.41583116205276313976574969624977055e-01) }},
   {{ SC_(3.71956787109375000000000000000000000e+01), SC_(7.85398006439208984375000000000000000e-01), SC_(1.61183408277737266229265800220091450e+01) }},
   {{ SC_(2.68848314881324768066406250000000000e-02), SC_(-7.85398244857788085937500000000000000e-01), SC_(1.61183615799116310831965877183701799e+01) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-1.17573242187500000000000000000000000e+01), SC_(1.61184050795949591567600781335782674e+01) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(1.17573204040527343750000000000000000e+01), SC_(-9.41583289047849113760608686526300468e-01) }},
   {{ SC_(1.38351904296875000000000000000000000e+03), SC_(3.92699003219604492187500000000000000e-01), SC_(1.61183433942428286795193345127078936e+01) }},
   {{ SC_(7.22794327884912490844726562500000000e-04), SC_(-3.92699122428894042968750000000000000e-01), SC_(1.61183600570472361855159774127491233e+01) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-3.03853225708007812500000000000000000e+00), SC_(1.61183694632696656223049926134244216e+01) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(3.03853130340576171875000000000000000e+00), SC_(-9.41583169264061216147484530575403705e-01) }},
   {{ SC_(1.91412550000000000000000000000000000e+06), SC_(1.96349501609802246093750000000000000e-01), SC_(1.61183443736317864421643830688781223e+01) }},
   {{ SC_(5.22431719218729995191097259521484375e-07), SC_(-1.96349561214447021484375000000000000e-01), SC_(1.61183595500945179930978267976681804e+01) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-1.74471616744995117187500000000000000e+00), SC_(1.61183669691881879329779145162290120e+01) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(1.74471569061279296875000000000000000e+00), SC_(-9.41583167481810238047104476731383816e-01) }},
   {{ SC_(3.66387658752000000000000000000000000e+12), SC_(9.81747508049011230468750000000000000e-02), SC_(1.61183444459994376933733433921555833e+01) }},
   {{ SC_(2.72934886497155915208168153185397387e-13), SC_(-9.81747806072235107421875000000000000e-02), SC_(1.61183596409092351188411868811339719e+01) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-1.22367286682128906250000000000000000e+00), SC_(1.61183730011260447096888001424211750e+01) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(1.22367238998413085937500000000000000e+00), SC_(-9.41583168758103292639220277105590615e-01) }},
   {{ SC_(1.34239954220296384911769600000000000e+25), SC_(4.90873754024505615234375000000000000e-02), SC_(1.61183446822042392757171561578830442e+01) }},
   {{ SC_(7.44934418308944170858322415950897533e-26), SC_(-4.90873903036117553710937500000000000e-02), SC_(1.61183597586322695037270301026333968e+01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-9.42271709442138671875000000000000000e-01), SC_(1.61183583312118891523635955324743786e+01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(9.42271709442138671875000000000000000e-01), SC_(-9.41583183349030567139373750889525436e-01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-7.66097068786621093750000000000000000e-01), SC_(1.61183691432548512868105153109587680e+01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(7.66096830368041992187500000000000000e-01), SC_(-9.41583168611376923460000219526419448e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-6.45423412322998046875000000000000000e-01), SC_(1.61183674686038740140491263534352101e+01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(6.45423173904418945312500000000000000e-01), SC_(-9.41583153242672525672206241305428693e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-5.57592868804931640625000000000000000e-01), SC_(1.61183710046204291477370023411590897e+01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(5.57592630386352539062500000000000000e-01), SC_(-9.41583155655494650353619815080138066e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-4.90803241729736328125000000000000000e-01), SC_(1.61183637595172622787738475436623676e+01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(4.90803122520446777343750000000000000e-01), SC_(-9.41583161575376241616251199890081294e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-4.38302516937255859375000000000000000e-01), SC_(1.61183637318102935717988721920270765e+01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(4.38302397727966308593750000000000000e-01), SC_(-9.41583156653866324122875264667737754e-01) }},
   {{ SC_(1.00193119049072265625000000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(2.12716571916357438957733295767727322e+01) }},
   {{ SC_(9.98072147369384765625000000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(2.12854814778441925897340620791214069e+01) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(4.20404314994812011718750000000000000e-01), SC_(2.12839767810901438436228657679662397e+01) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-4.20404314994812011718750000000000000e-01), SC_(-9.55124706428136949666043192967019015e-01) }},
   {{ SC_(1.00386667251586914062500000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(2.12816878538850781706781511102151877e+01) }},
   {{ SC_(9.96148109436035156250000000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(2.12837168305443690527894610203695805e+01) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(4.63962674140930175781250000000000000e-01), SC_(2.12839614454829492925864624531185713e+01) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-4.63962793350219726562500000000000000e-01), SC_(-9.55124711333408550162601002047013039e-01) }},
   {{ SC_(1.00774860382080078125000000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(2.12844232163345762579598308905598567e+01) }},
   {{ SC_(9.92311000823974609375000000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(2.12842144841769015320922529710825390e+01) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(5.17590761184692382812500000000000000e-01), SC_(2.12839691358845926700868335323785129e+01) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-5.17590999603271484375000000000000000e-01), SC_(-9.55124755192210990749068501737833084e-01) }},
   {{ SC_(1.01555681228637695312500000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(2.12824987510866261287648504826966954e+01) }},
   {{ SC_(9.84681129455566406250000000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(2.12841821809353868979502115265266943e+01) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(5.85236310958862304687500000000000000e-01), SC_(2.12839518607760027637252135653207534e+01) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-5.85236549377441406250000000000000000e-01), SC_(-9.55124712987682987619285234203416882e-01) }},
   {{ SC_(1.03135633468627929687500000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(2.12840098570475239700255538322550757e+01) }},
   {{ SC_(9.69596862792968750000000000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(2.12843298520276127627311030114051497e+01) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(6.73222064971923828125000000000000000e-01), SC_(2.12839606023202407819393404681973743e+01) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-6.73222303390502929687500000000000000e-01), SC_(-9.55124723175294610052696140292688065e-01) }},
   {{ SC_(1.06369543075561523437500000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(2.12835272089685424097544715712130454e+01) }},
   {{ SC_(9.40118312835693359375000000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(2.12840480713269354784829706931737372e+01) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(7.92345046997070312500000000000000000e-01), SC_(2.12839756240759424024536658329152227e+01) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-7.92345046997070312500000000000000000e-01), SC_(-9.55124704098150916994631045827675805e-01) }},
   {{ SC_(1.13144874572753906250000000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(2.12839114749206724064861843811433200e+01) }},
   {{ SC_(8.83822441101074218750000000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(2.12840487227207977131814815949873776e+01) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(9.62687015533447265625000000000000000e-01), SC_(2.12839742528392432323170519164293170e+01) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-9.62687015533447265625000000000000000e-01), SC_(-9.55124701336765002231493622107433707e-01) }},
   {{ SC_(1.28017616271972656250000000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(2.12838892751289894299126266720750804e+01) }},
   {{ SC_(7.81142234802246093750000000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(2.12840030484642263735005400181476169e+01) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(1.22632837295532226562500000000000000e+00), SC_(2.12839480663427391160705605860300829e+01) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-1.22632884979248046875000000000000000e+00), SC_(-9.55124702761949355864896154805146161e-01) }},
   {{ SC_(1.63885164260864257812500000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(2.12839435269414080695254196326690114e+01) }},
   {{ SC_(6.10183238983154296875000000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(2.12839920362326519492497830707659666e+01) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(1.68883323669433593750000000000000000e+00), SC_(2.12839689148704585813370721262437361e+01) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-1.68883323669433593750000000000000000e+00), SC_(-9.55124690587201296531503809771444764e-01) }},
   {{ SC_(2.68583488464355468750000000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(2.12839481707991139366784374976873236e+01) }},
   {{ SC_(3.72323632240295410156250000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(2.12839831793067798296567477039442061e+01) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(2.71144104003906250000000000000000000e+00), SC_(2.12839580665330801103379975053875581e+01) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-2.71144199371337890625000000000000000e+00), SC_(-9.55124717731221518926280480518239200e-01) }},
   {{ SC_(7.21371078491210937500000000000000000e+00), SC_(1.57079601287841796875000000000000000e+00), SC_(2.12839566980705218679790450561880313e+01) }},
   {{ SC_(1.38624846935272216796875000000000000e-01), SC_(-1.57079648971557617187500000000000000e+00), SC_(2.12839933273548406839675024551383515e+01) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(6.87331008911132812500000000000000000e+00), SC_(2.12839478237649169511914074850384858e+01) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-6.87331008911132812500000000000000000e+00), SC_(-9.55124648114032066199936020638690264e-01) }},
   {{ SC_(5.20376434326171875000000000000000000e+01), SC_(7.85398006439208984375000000000000000e-01), SC_(2.12839634731742035575641347584461119e+01) }},
   {{ SC_(1.92168578505516052246093750000000000e-02), SC_(-7.85398244857788085937500000000000000e-01), SC_(2.12839845270003862099858877376307660e+01) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-1.28490257263183593750000000000000000e+01), SC_(2.12840399547125127569779807394210174e+01) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(1.28490219116210937500000000000000000e+01), SC_(-9.55124792293999848744797548104084479e-01) }},
   {{ SC_(2.70791601562500000000000000000000000e+03), SC_(3.92699003219604492187500000000000000e-01), SC_(2.12839624442496491074731336067783756e+01) }},
   {{ SC_(3.69287561625242233276367187500000000e-04), SC_(-3.92699122428894042968750000000000000e-01), SC_(2.12839860441364605122666041503977571e+01) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-3.32066917419433593750000000000000000e+00), SC_(2.12839980777455535186259191126934388e+01) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(3.32066822052001953125000000000000000e+00), SC_(-9.55124709312833675924366627882909517e-01) }},
   {{ SC_(7.33281000000000000000000000000000000e+06), SC_(1.96349501609802246093750000000000000e-01), SC_(2.12839629528250223111172692500095354e+01) }},
   {{ SC_(1.36373330406058812513947486877441406e-07), SC_(-1.96349561214447021484375000000000000e-01), SC_(2.12839851703207442809745757692476357e+01) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-1.90671825408935546875000000000000000e+00), SC_(2.12839912494450380948933926745925229e+01) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(1.90671777725219726562500000000000000e+00), SC_(-9.55124700731118706698216715687853648e-01) }},
   {{ SC_(5.37700880875520000000000000000000000e+13), SC_(9.81747508049011230468750000000000000e-02), SC_(2.12839623665901605726371297015269772e+01) }},
   {{ SC_(1.85976925591406494486790279552224092e-14), SC_(-9.81747806072235107421875000000000000e-02), SC_(2.12839843100495942203803780122507175e+01) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-1.33729457855224609375000000000000000e+00), SC_(2.12840021915978902056439710541183038e+01) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(1.33729410171508789062500000000000000e+00), SC_(-9.55124707934211738731521888795411012e-01) }},
   {{ SC_(2.89122283606373230304454246400000000e+27), SC_(4.90873754024505615234375000000000000e-02), SC_(2.12839625418065905591515440176571167e+01) }},
   {{ SC_(3.45874292038603789825787577948530444e-28), SC_(-4.90873903036117553710937500000000000e-02), SC_(2.12839839194230256533142704586808832e+01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-1.02976465225219726562500000000000000e+00), SC_(2.12839931566789569876173111373823623e+01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(1.02976417541503906250000000000000000e+00), SC_(-9.55124674907663356715708351283307809e-01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-8.37231397628784179687500000000000000e-01), SC_(2.12839891280796092481536496568217287e+01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(8.37231159210205078125000000000000000e-01), SC_(-9.55124691627602456717970572855663241e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-7.05352783203125000000000000000000000e-01), SC_(2.12839808719164657142613657484660937e+01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(7.05352783203125000000000000000000000e-01), SC_(-9.55124714666208647923682544178331141e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-6.09366893768310546875000000000000000e-01), SC_(2.12839820381120506443380510390870152e+01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(6.09366893768310546875000000000000000e-01), SC_(-9.55124717014682970835975556789510727e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-5.36375761032104492187500000000000000e-01), SC_(2.12839838694205979135585965668916029e+01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(5.36375522613525390625000000000000000e-01), SC_(-9.55124658789578167641329238324080675e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-4.79000210762023925781250000000000000e-01), SC_(2.12839868152402675993842297806800725e+01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(4.79000091552734375000000000000000000e-01), SC_(-9.55124691970317156807700445966525343e-01) }},
   {{ SC_(1.00211429595947265625000000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(2.88816506400174175858535088904278285e+01) }},
   {{ SC_(9.97889757156372070312500000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(2.89013252679294641197675801157691713e+01) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(4.60211873054504394531250000000000000e-01), SC_(2.88973322302791760559439991780259412e+01) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-4.60211992263793945312500000000000000e-01), SC_(-9.66552229069490112094068704223708216e-01) }},
   {{ SC_(1.00423336029052734375000000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(2.88887858835375545008271207347474080e+01) }},
   {{ SC_(9.95784044265747070312500000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(2.88994699341968575743450707459149764e+01) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(5.07894754409790039062500000000000000e-01), SC_(2.88973168544673487346115405226785586e+01) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-5.07894992828369140625000000000000000e-01), SC_(-9.66552235778519475722863182499501889e-01) }},
   {{ SC_(1.00848531723022460937500000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(2.88968352209745690556512829340278584e+01) }},
   {{ SC_(9.91585969924926757812500000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(2.88981712116848658448264685885559995e+01) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(5.66600799560546875000000000000000000e-01), SC_(2.88973241296254395247742629717899983e+01) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-5.66601037979125976562500000000000000e-01), SC_(-9.66552238390086189567990750828544046e-01) }},
   {{ SC_(1.01704263687133789062500000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(2.88968458738030790617009487239193519e+01) }},
   {{ SC_(9.83242750167846679687500000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(2.88980830754377882815060652806390614e+01) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(6.40651941299438476562500000000000000e-01), SC_(2.88973490698023542841965638394279387e+01) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-6.40651941299438476562500000000000000e-01), SC_(-9.66552218470431405016791057730765845e-01) }},
   {{ SC_(1.03437566757202148437500000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(2.88966783849035318960176197752600560e+01) }},
   {{ SC_(9.66766357421875000000000000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(2.88979224513630909832057412942167823e+01) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(7.36968755722045898437500000000000000e-01), SC_(2.88973272951720996458289714331981347e+01) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-7.36968994140625000000000000000000000e-01), SC_(-9.66552230876455904472081575796754224e-01) }},
   {{ SC_(1.06993341445922851562500000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(2.88972300875534122564760854885474288e+01) }},
   {{ SC_(9.34637546539306640625000000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(2.88973489129515967173581157130995975e+01) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(8.67371320724487304687500000000000000e-01), SC_(2.88973438336831816302953045753485560e+01) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-8.67371320724487304687500000000000000e-01), SC_(-9.66552212612500642873319111454210242e-01) }},
   {{ SC_(1.14475727081298828125000000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(2.88970721862671609343528189825529917e+01) }},
   {{ SC_(8.73547315597534179687500000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(2.88973728287829188410072950258350388e+01) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(1.05384254455566406250000000000000000e+00), SC_(2.88973189952411706019991425181724234e+01) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-1.05384302139282226562500000000000000e+00), SC_(-9.66552236247146165903792665880696182e-01) }},
   {{ SC_(1.31047010421752929687500000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(2.88973288139394661364988243302900403e+01) }},
   {{ SC_(7.63084888458251953125000000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(2.88973847087925832505940687293047181e+01) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(1.34244823455810546875000000000000000e+00), SC_(2.88973175906672109733383496568196617e+01) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-1.34244871139526367187500000000000000e+00), SC_(-9.66552223620671061371321533379219486e-01) }},
   {{ SC_(1.71733188629150390625000000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(2.88973279655055424362096757761994870e+01) }},
   {{ SC_(5.82298517227172851562500000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(2.88973943114281040658063734487480833e+01) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(1.84874677658081054687500000000000000e+00), SC_(2.88973226471091003869659181203813212e+01) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-1.84874725341796875000000000000000000e+00), SC_(-9.66552218222487022257931166282142185e-01) }},
   {{ SC_(2.94922828674316406250000000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(2.88973113752418101686454765707194421e+01) }},
   {{ SC_(3.39071631431579589843750000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(2.88973754010557911155048024318775986e+01) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(2.96818447113037109375000000000000000e+00), SC_(2.88973209975668340263204160142195168e+01) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-2.96818542480468750000000000000000000e+00), SC_(-9.66552223579407695920478722943055348e-01) }},
   {{ SC_(8.69794845581054687500000000000000000e+00), SC_(1.57079601287841796875000000000000000e+00), SC_(2.88973166043526119248755269825977239e+01) }},
   {{ SC_(1.14969581365585327148437500000000000e-01), SC_(-1.57079648971557617187500000000000000e+00), SC_(2.88973712656474120593479134835901605e+01) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(7.52413558959960937500000000000000000e+00), SC_(2.88972947839927463277366202930066765e+01) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-7.52413749694824218750000000000000000e+00), SC_(-9.66552186547309149369092326474057163e-01) }},
   {{ SC_(7.56543579101562500000000000000000000e+01), SC_(7.85398006439208984375000000000000000e-01), SC_(2.88973323001415620459982435708965593e+01) }},
   {{ SC_(1.32180079817771911621093750000000000e-02), SC_(-7.85398244857788085937500000000000000e-01), SC_(2.88973653279883406041810962042095046e+01) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-1.40656852722167968750000000000000000e+01), SC_(2.88974350688412745503439177238286639e+01) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(1.40656852722167968750000000000000000e+01), SC_(-9.66552314681931118440584859639131500e-01) }},
   {{ SC_(5.72358007812500000000000000000000000e+03), SC_(3.92699003219604492187500000000000000e-01), SC_(2.88973286228720416512146303425172178e+01) }},
   {{ SC_(1.74715765751898288726806640625000000e-04), SC_(-3.92699122428894042968750000000000000e-01), SC_(2.88973632619262736128118434428925888e+01) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-3.63510036468505859375000000000000000e+00), SC_(2.88973966320258521481507669444848054e+01) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(3.63509941101074218750000000000000000e+00), SC_(-9.66552241865102918411416809821419897e-01) }},
   {{ SC_(3.27593840000000000000000000000000000e+07), SC_(1.96349501609802246093750000000000000e-01), SC_(2.88973313268017928308324868025639197e+01) }},
   {{ SC_(3.05255980492802336812019348144531250e-08), SC_(-1.96349561214447021484375000000000000e-01), SC_(2.88973634067330806813233923542960370e+01) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-2.08726406097412109375000000000000000e+00), SC_(2.88974042625644224990282612048074174e+01) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(2.08726310729980468750000000000000000e+00), SC_(-9.66552228291581310120902504970074776e-01) }},
   {{ SC_(1.07317730423603200000000000000000000e+15), SC_(9.81747508049011230468750000000000000e-02), SC_(2.88973315023261168808076886000659051e+01) }},
   {{ SC_(9.31812051428509632855501365611416986e-16), SC_(-9.81747806072235107421875000000000000e-02), SC_(2.88973636739681402319822402579208199e+01) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-1.46392154693603515625000000000000000e+00), SC_(2.88973847895782597728778935746451599e+01) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(1.46392107009887695312500000000000000e+00), SC_(-9.66552221413987851959275372911667638e-01) }},
   {{ SC_(1.15170977842390800512568210227200000e+30), SC_(4.90873754024505615234375000000000000e-02), SC_(2.88973318235635950328120596848666485e+01) }},
   {{ SC_(8.68273918138835181262073455776293948e-31), SC_(-4.90873903036117553710937500000000000e-02), SC_(2.88973633038895884272934681390877080e+01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-1.12727212905883789062500000000000000e+00), SC_(2.88973879648984608483712534332399393e+01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(1.12727165222167968750000000000000000e+00), SC_(-9.66552213911280744141705918121530283e-01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-9.16507959365844726562500000000000000e-01), SC_(2.88973691257885734045672042803410583e+01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(9.16507720947265625000000000000000000e-01), SC_(-9.66552211344002306665331425698591676e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-7.72141933441162109375000000000000000e-01), SC_(2.88973617356047537020903925565527297e+01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(7.72141695022583007812500000000000000e-01), SC_(-9.66552197548650201641756736040742157e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-6.67067289352416992187500000000000000e-01), SC_(2.88973715660218824893714312922795607e+01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(6.67067050933837890625000000000000000e-01), SC_(-9.66552203018913593951027314351758755e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-5.87164640426635742187500000000000000e-01), SC_(2.88973651934672270893979054162325987e+01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(5.87164402008056640625000000000000000e-01), SC_(-9.66552190362035900522389761450021291e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-5.24356365203857421875000000000000000e-01), SC_(2.88973904405745019354980316710820921e+01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(5.24356126785278320312500000000000000e-01), SC_(-9.66552213079772146864837772740057546e-01) }},
   {{ SC_(1.00231790542602539062500000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(4.04308286085454262262333366555736516e+01) }},
   {{ SC_(9.97687101364135742187500000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(4.04544925622551590844358917879544467e+01) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(5.04472017288208007812500000000000000e-01), SC_(4.04523386940077506968091831720858961e+01) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-5.04472255706787109375000000000000000e-01), SC_(-9.75875951243040762433187893000241691e-01) }},
   {{ SC_(1.00464153289794921875000000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(4.04424173598797588593655519380236007e+01) }},
   {{ SC_(9.95379447937011718750000000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(4.04579858907096424487246880105919143e+01) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(5.56740760803222656250000000000000000e-01), SC_(4.04523255738389373884433998117702770e+01) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-5.56740999221801757812500000000000000e-01), SC_(-9.75875939620762057036088018437829911e-01) }},
   {{ SC_(1.00930500030517578125000000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(4.04488685418345745437386714323315937e+01) }},
   {{ SC_(9.90780591964721679687500000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(4.04521544573514907124399238500395224e+01) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(6.21092796325683593750000000000000000e-01), SC_(4.04523430113270811804651484064812900e+01) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-6.21093034744262695312500000000000000e-01), SC_(-9.75875945782153243259667698735108292e-01) }},
   {{ SC_(1.01869678497314453125000000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(4.04505156390344772013610644598225428e+01) }},
   {{ SC_(9.81646060943603515625000000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(4.04531772971398540071469228297501030e+01) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(7.02265501022338867187500000000000000e-01), SC_(4.04523377267225279862290257917321173e+01) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-7.02265739440917968750000000000000000e-01), SC_(-9.75875938719945269214632846685690323e-01) }},
   {{ SC_(1.03774356842041015625000000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(4.04522371433168394620147296237889735e+01) }},
   {{ SC_(9.63629007339477539062500000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(4.04530978393265668584810659369133380e+01) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(8.07845592498779296875000000000000000e-01), SC_(4.04523388283897424540720929170586931e+01) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-8.07845830917358398437500000000000000e-01), SC_(-9.75875935374361229482289711259193510e-01) }},
   {{ SC_(1.07691144943237304687500000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(4.04517256500961998405277695406898095e+01) }},
   {{ SC_(9.28580999374389648437500000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(4.04527935912611002211315702116250987e+01) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(9.50789213180541992187500000000000000e-01), SC_(4.04523297863659438272176772565924709e+01) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-9.50789451599121093750000000000000000e-01), SC_(-9.75875926125439242781612705702174327e-01) }},
   {{ SC_(1.15973854064941406250000000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(4.04519688488901218379558041413674266e+01) }},
   {{ SC_(8.62262964248657226562500000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(4.04524409678184998349644300462000483e+01) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(1.15519428253173828125000000000000000e+00), SC_(4.04523331428413517170071924289568350e+01) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-1.15519475936889648437500000000000000e+00), SC_(-9.75875942636313785422515080762639389e-01) }},
   {{ SC_(1.34499406814575195312500000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(4.04521955984865903483283611404780514e+01) }},
   {{ SC_(7.43497371673583984375000000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(4.04524744862501092987825923604418179e+01) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(1.47155618667602539062500000000000000e+00), SC_(4.04523301187790444180667460188070075e+01) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-1.47155666351318359375000000000000000e+00), SC_(-9.75875932902951880499152312255214770e-01) }},
   {{ SC_(1.80900955200195312500000000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(4.04522688320153568867999219665345920e+01) }},
   {{ SC_(5.52788496017456054687500000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(4.04524017707759123373483888440357872e+01) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(2.02654647827148437500000000000000000e+00), SC_(4.04522802210147662027111749764290650e+01) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-2.02654743194580078125000000000000000e+00), SC_(-9.75875917031975246607105740107167108e-01) }},
   {{ SC_(3.27251625061035156250000000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(4.04522963445623673294944949004747852e+01) }},
   {{ SC_(3.05575132369995117187500000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(4.04523970655516461739959008149499170e+01) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(3.25364494323730468750000000000000000e+00), SC_(4.04523242768813236942180323512179493e+01) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-3.25364589691162109375000000000000000e+00), SC_(-9.75875926724354711879212082121643332e-01) }},
   {{ SC_(1.07093658447265625000000000000000000e+01), SC_(1.57079601287841796875000000000000000e+00), SC_(4.04523160086613550111797554597760626e+01) }},
   {{ SC_(9.33761894702911376953125000000000000e-02), SC_(-1.57079648971557617187500000000000000e+00), SC_(4.04523775772479710084543422515848159e+01) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(8.24775695800781250000000000000000000e+00), SC_(4.04522744159820682925136755867334127e+01) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-8.24776077270507812500000000000000000e+00), SC_(-9.75875912927822791957160678152907541e-01) }},
   {{ SC_(1.14690551757812500000000000000000000e+02), SC_(7.85398006439208984375000000000000000e-01), SC_(4.04523259330228973886963311740236363e+01) }},
   {{ SC_(8.71911272406578063964843750000000000e-03), SC_(-7.85398244857788085937500000000000000e-01), SC_(4.04523777113931549105777336381314157e+01) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-1.54184303283691406250000000000000000e+01), SC_(4.04524966704098979927955099005078790e+01) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(1.54184265136718750000000000000000000e+01), SC_(-9.75875978485745528773075762299048056e-01) }},
   {{ SC_(1.31539218750000000000000000000000000e+04), SC_(3.92699003219604492187500000000000000e-01), SC_(4.04523249584590116297494073745810538e+01) }},
   {{ SC_(7.60229304432868957519531250000000000e-05), SC_(-3.92699122428894042968750000000000000e-01), SC_(4.04523769087887015208881388292194134e+01) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-3.98469924926757812500000000000000000e+00), SC_(4.04523937242102945818055624584645658e+01) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(3.98469924926757812500000000000000000e+00), SC_(-9.75875940804452278943619259479625766e-01) }},
   {{ SC_(1.73025728000000000000000000000000000e+08), SC_(1.96349501609802246093750000000000000e-01), SC_(4.04523281245577352261644219775909817e+01) }},
   {{ SC_(5.77948711111275770235806703567504883e-09), SC_(-1.96349561214447021484375000000000000e-01), SC_(4.04523752780978500662760512121074065e+01) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-2.28800296783447265625000000000000000e+00), SC_(4.04524217680295487546396567239514132e+01) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(2.28800201416015625000000000000000000e+00), SC_(-9.75875919673773647433184364322577377e-01) }},
   {{ SC_(2.99379063280107520000000000000000000e+16), SC_(9.81747508049011230468750000000000000e-02), SC_(4.04523286381264712408986752760162773e+01) }},
   {{ SC_(3.34024663422875160538605410209811453e-17), SC_(-9.81747806072235107421875000000000000e-02), SC_(4.04523758781616097721223057793905412e+01) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-1.60471153259277343750000000000000000e+00), SC_(4.04523860023961634707539348315534821e+01) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(1.60471105575561523437500000000000000e+00), SC_(-9.75875909611456002467597429733668456e-01) }},
   {{ SC_(8.96278182477919780724096406388736000e+32), SC_(4.90873754024505615234375000000000000e-02), SC_(4.04523285181957549019801209530964267e+01) }},
   {{ SC_(1.11572487118678977176668116706650907e-33), SC_(-4.90873903036117553710937500000000000e-02), SC_(4.04523756712784211531198211659253767e+01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-1.23568534851074218750000000000000000e+00), SC_(4.04523755549302280413401520139228773e+01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(1.23568534851074218750000000000000000e+00), SC_(-9.75875930230467507313920283968325191e-01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-1.00465154647827148437500000000000000e+00), SC_(4.04523783565479982849758738371228799e+01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(1.00465106964111328125000000000000000e+00), SC_(-9.75875889214876133549931114371084897e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-8.46401453018188476562500000000000000e-01), SC_(4.04523832413638360976702010373235205e+01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(8.46401214599609375000000000000000000e-01), SC_(-9.75875909394005905719233417503060439e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-7.31221437454223632812500000000000000e-01), SC_(4.04524013322966586057442766670840526e+01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(7.31221199035644531250000000000000000e-01), SC_(-9.75875915935676373714497288264623311e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-6.43634319305419921875000000000000000e-01), SC_(4.04524018301696296926261981636599575e+01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(6.43634080886840820312500000000000000e-01), SC_(-9.75875912238697572225634824119726133e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-5.74785470962524414062500000000000000e-01), SC_(4.04524183295974815006702618052177659e+01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(5.74785232543945312500000000000000000e-01), SC_(-9.75875917854153734566642032154846857e-01) }},
   {{ SC_(1.00254392623901367187500000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(5.85428967879652619421418524266795565e+01) }},
   {{ SC_(9.97462272644042968750000000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(5.85675810203077926280849704183861462e+01) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(5.53574085235595703125000000000000000e-01), SC_(5.85649632620630990100099483791264880e+01) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-5.53574323654174804687500000000000000e-01), SC_(-9.83211636757927298891532608334930709e-01) }},
   {{ SC_(1.00509452819824218750000000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(5.85526246617016563055576276814762711e+01) }},
   {{ SC_(9.94930982589721679687500000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(5.85677138453490239118863241778056562e+01) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(6.10930442810058593750000000000000000e-01), SC_(5.85649864390245496594735758024878742e+01) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-6.10930681228637695312500000000000000e-01), SC_(-9.83211640515912860693606402408213517e-01) }},
   {{ SC_(1.01021528244018554687500000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(5.85590687502348551278539369156844406e+01) }},
   {{ SC_(9.89887714385986328125000000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(5.85664006412558227746286579117055490e+01) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(6.81545972824096679687500000000000000e-01), SC_(5.85649666800577171581334236511055625e+01) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-6.81546211242675781250000000000000000e-01), SC_(-9.83211632172425373285131112190058402e-01) }},
   {{ SC_(1.02053546905517578125000000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(5.85655484301496702104750446694314638e+01) }},
   {{ SC_(9.79877710342407226562500000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(5.85661164680834252561940973288142647e+01) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(7.70619630813598632812500000000000000e-01), SC_(5.85649976801786874100102400835502006e+01) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-7.70619630813598632812500000000000000e-01), SC_(-9.83211616906806868068246727140982579e-01) }},
   {{ SC_(1.04149246215820312500000000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(5.85645052207784879106950506431490085e+01) }},
   {{ SC_(9.60160493850708007812500000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(5.85650772867980433445031714663109733e+01) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(8.86476039886474609375000000000000000e-01), SC_(5.85649478177600805807533730206063383e+01) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-8.86476278305053710937500000000000000e-01), SC_(-9.83211621307224808729221051861744295e-01) }},
   {{ SC_(1.08470630645751953125000000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(5.85638364905345419014451691168566874e+01) }},
   {{ SC_(9.21908140182495117187500000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(5.85651869584430251071843793777931027e+01) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(1.04333305358886718750000000000000000e+00), SC_(5.85649775738699373333198502272519651e+01) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-1.04333353042602539062500000000000000e+00), SC_(-9.83211642599233549711518451799824852e-01) }},
   {{ SC_(1.17658853530883789062500000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(5.85648086056017441374049117518605161e+01) }},
   {{ SC_(8.49914550781250000000000000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(5.85653070038960145457387490818656494e+01) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(1.26763343811035156250000000000000000e+00), SC_(5.85649466985181262673964488550330194e+01) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-1.26763391494750976562500000000000000e+00), SC_(-9.83211628348163798762083653430441096e-01) }},
   {{ SC_(1.38436079025268554687500000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(5.85649215198498783023480627848758974e+01) }},
   {{ SC_(7.22354888916015625000000000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(5.85651564552339003185680689289890661e+01) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(1.61478805541992187500000000000000000e+00), SC_(5.85649550894860224604133088932585478e+01) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-1.61478853225708007812500000000000000e+00), SC_(-9.83211625164291831915742134000970824e-01) }},
   {{ SC_(1.91645479202270507812500000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(5.85649204328209346757069417827006293e+01) }},
   {{ SC_(5.21796703338623046875000000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(5.85650719647846174532760025048208464e+01) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(2.22379779815673828125000000000000000e+00), SC_(5.85649032603628654354744050214189598e+01) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-2.22379875183105468750000000000000000e+00), SC_(-9.83211619720181515515402615286878470e-01) }},
   {{ SC_(3.67279911041259765625000000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(5.85649275936137435657659130993083760e+01) }},
   {{ SC_(2.72271752357482910156250000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(5.85651044443708632204700454516675906e+01) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(3.57033348083496093750000000000000000e+00), SC_(5.85649148932460209185638212640297216e+01) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-3.57033443450927734375000000000000000e+00), SC_(-9.83211611901175006031214429715585784e-01) }},
   {{ SC_(1.34894561767578125000000000000000000e+01), SC_(1.57079601287841796875000000000000000e+00), SC_(5.85649475093426512315222003205245372e+01) }},
   {{ SC_(7.41319358348846435546875000000000000e-02), SC_(-1.57079648971557617187500000000000000e+00), SC_(5.85650682171688494424805961829786500e+01) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(9.05054092407226562500000000000000000e+00), SC_(5.85648685321287663873691477622167659e+01) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-9.05054473876953125000000000000000000e+00), SC_(-9.83211609426930158310386036408837207e-01) }},
   {{ SC_(1.81965454101562500000000000000000000e+02), SC_(7.85398006439208984375000000000000000e-01), SC_(5.85649542341186702781202970228420772e+01) }},
   {{ SC_(5.49554638564586639404296875000000000e-03), SC_(-7.85398244857788085937500000000000000e-01), SC_(5.85650471479154163710158319369427598e+01) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-1.69191665649414062500000000000000000e+01), SC_(5.85652871779332525800725209600453120e+01) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(1.69191589355468750000000000000000000e+01), SC_(-9.83211667560559105714759544075623367e-01) }},
   {{ SC_(3.31114375000000000000000000000000000e+04), SC_(3.92699003219604492187500000000000000e-01), SC_(5.85649620145281597237142272072853221e+01) }},
   {{ SC_(3.02010375889949500560760498046875000e-05), SC_(-3.92699122428894042968750000000000000e-01), SC_(5.85650413295996578796977608257053761e+01) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-4.37254524230957031250000000000000000e+00), SC_(5.85651027029342143521872948769557213e+01) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(4.37254333496093750000000000000000000e+00), SC_(-9.83211616576735819034531659712723529e-01) }},
   {{ SC_(1.09636710400000000000000000000000000e+09), SC_(1.96349501609802246093750000000000000e-01), SC_(5.85649599949861898249815565444995589e+01) }},
   {{ SC_(9.12102837702377655659802258014678955e-10), SC_(-1.96349561214447021484375000000000000e-01), SC_(5.85650391978286768646611058741787974e+01) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-2.51070213317871093750000000000000000e+00), SC_(5.85650596567739738993865497000406523e+01) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(2.51070117950439453125000000000000000e+00), SC_(-9.83211608311806089027262906198123942e-01) }},
   {{ SC_(1.20202129585681203200000000000000000e+18), SC_(9.81747508049011230468750000000000000e-02), SC_(5.85649622772495058204668620460868951e+01) }},
   {{ SC_(8.31931731196379127578951345745039703e-19), SC_(-9.81747806072235107421875000000000000e-02), SC_(5.85650381810484178126694239899561358e+01) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-1.76090383529663085937500000000000000e+00), SC_(5.85650354800037323646782865429418611e+01) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(1.76090383529663085937500000000000000e+00), SC_(-9.83211627560673496308782832635192013e-01) }},
   {{ SC_(1.44485611145943370364662809480711373e+36), SC_(4.90873754024505615234375000000000000e-02), SC_(5.85649641304431912103099858316546942e+01) }},
   {{ SC_(6.92110324681749688552630222615569298e-37), SC_(-4.90873903036117553710937500000000000e-02), SC_(5.85650385219302640332610530293773127e+01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-1.35595941543579101562500000000000000e+00), SC_(5.85650908641509766396809829059723392e+01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(1.35595893859863281250000000000000000e+00), SC_(-9.83211619041393584044623270044654695e-01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-1.10243797302246093750000000000000000e+00), SC_(5.85650465352357401483764518624420145e+01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(1.10243749618530273437500000000000000e+00), SC_(-9.83211600998436506970168620966990882e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-9.28784847259521484375000000000000000e-01), SC_(5.85650623037096179525157924826150702e+01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(9.28784608840942382812500000000000000e-01), SC_(-9.83211617507419716779062745433858184e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-8.02393913269042968750000000000000000e-01), SC_(5.85650847306065105950315083872055508e+01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(8.02393674850463867187500000000000000e-01), SC_(-9.83211621053993538953613338307629114e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-7.06281423568725585937500000000000000e-01), SC_(5.85650183937759135570756749889836464e+01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(7.06281423568725585937500000000000000e-01), SC_(-9.83211622744928215932994803138691894e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-6.30731344223022460937500000000000000e-01), SC_(5.85650676332431006098214295451305464e+01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(6.30731105804443359375000000000000000e-01), SC_(-9.83211610686242300810641206934284590e-01) }},
   {{ SC_(1.00279426574707031250000000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(8.79696216866700201905137133543748488e+01) }},
   {{ SC_(9.97213363647460937500000000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(8.79922433843780281054386975981147321e+01) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(6.07939720153808593750000000000000000e-01), SC_(8.79835900913783628624192306799043609e+01) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-6.07939958572387695312500000000000000e-01), SC_(-9.88761992646988953023751343814160766e-01) }},
   {{ SC_(1.00559616088867187500000000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(8.79569194669926536407569359500189870e+01) }},
   {{ SC_(9.94434595108032226562500000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(8.79848686123649737579500261278480782e+01) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(6.70928955078125000000000000000000000e-01), SC_(8.79836282554579845024694772645313054e+01) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-6.70929193496704101562500000000000000e-01), SC_(-9.88761995609661120063544506348206880e-01) }},
   {{ SC_(1.01122426986694335937500000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(8.79792462510913696845408830812929869e+01) }},
   {{ SC_(9.88900184631347656250000000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(8.79841201854345222375579116491974350e+01) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(7.48479604721069335937500000000000000e-01), SC_(8.79836386043372975794631178469621228e+01) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-7.48479843139648437500000000000000000e-01), SC_(-9.88761995059468235425262252788215788e-01) }},
   {{ SC_(1.02257442474365234375000000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(8.79775103009161104534927689885615061e+01) }},
   {{ SC_(9.77923393249511718750000000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(8.79874484108387989491379211488062218e+01) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(8.46300840377807617187500000000000000e-01), SC_(8.79835876011524517972479762331316419e+01) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-8.46301078796386718750000000000000000e-01), SC_(-9.88761986760938063041857636487361079e-01) }},
   {{ SC_(1.04565906524658203125000000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(8.79827381120228867394925023499386821e+01) }},
   {{ SC_(9.56334590911865234375000000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(8.79834462195988121348689286808630280e+01) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(9.73535537719726562500000000000000000e-01), SC_(8.79836011607730924482787729489337482e+01) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-9.73535776138305664062500000000000000e-01), SC_(-9.88761986616239779969113881191060239e-01) }},
   {{ SC_(1.09340286254882812500000000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(8.79826637290928572977978896971679737e+01) }},
   {{ SC_(9.14575815200805664062500000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(8.79836153051172209694032372366954329e+01) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(1.14579725265502929687500000000000000e+00), SC_(8.79836522201436259559532721945415504e+01) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-1.14579725265502929687500000000000000e+00), SC_(-9.88761980711625302979312958206277151e-01) }},
   {{ SC_(1.19552993774414062500000000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(8.79828843015463634955177253201776787e+01) }},
   {{ SC_(8.36448907852172851562500000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(8.79836524641452391795187409682239923e+01) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(1.39212560653686523437500000000000000e+00), SC_(8.79835326241806854008051766628749063e+01) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-1.39212608337402343750000000000000000e+00), SC_(-9.88761982884855786445673739720071634e-01) }},
   {{ SC_(1.42929267883300781250000000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(8.79835467816032206927309307819734852e+01) }},
   {{ SC_(6.99646711349487304687500000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(8.79837549074017539081236946007207980e+01) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(1.77337408065795898437500000000000000e+00), SC_(8.79836319986806678138163391530532044e+01) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-1.77337408065795898437500000000000000e+00), SC_(-9.88761978157793933563810280734514573e-01) }},
   {{ SC_(2.04287719726562500000000000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(8.79834470243468767403650832926452507e+01) }},
   {{ SC_(4.89505529403686523437500000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(8.79837449687190366054860011547310743e+01) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(2.44219398498535156250000000000000000e+00), SC_(8.79835773604906402283259634329715179e+01) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-2.44219493865966796875000000000000000e+00), SC_(-9.88761990954641274918034421657896887e-01) }},
   {{ SC_(4.17334938049316406250000000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(8.79835901961675288230187445387648653e+01) }},
   {{ SC_(2.39615678787231445312500000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(8.79837269199234352922039921344874059e+01) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(3.92097091674804687500000000000000000e+00), SC_(8.79835753755812205467747717765497181e+01) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-3.92097187042236328125000000000000000e+00), SC_(-9.88761983275222341924381341570070792e-01) }},
   {{ SC_(1.74168395996093750000000000000000000e+01), SC_(1.57079601287841796875000000000000000e+00), SC_(8.79835464419138535074092383513634178e+01) }},
   {{ SC_(5.74156790971755981445312500000000000e-02), SC_(-1.57079648971557617187500000000000000e+00), SC_(8.79837133442158567334171418926037792e+01) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(9.93938064575195312500000000000000000e+00), SC_(8.79834515292759904167922887308652654e+01) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-9.93938446044921875000000000000000000e+00), SC_(-9.88761974724907914815571302706729407e-01) }},
   {{ SC_(3.03346435546875000000000000000000000e+02), SC_(7.85398006439208984375000000000000000e-01), SC_(8.79835772928573991937280605264717479e+01) }},
   {{ SC_(3.29655967652797698974609375000000000e-03), SC_(-7.85398244857788085937500000000000000e-01), SC_(8.79837245731416417122244910008140321e+01) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-1.85807647705078125000000000000000000e+01), SC_(8.79839845972122875263551894210488711e+01) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(1.85807647705078125000000000000000000e+01), SC_(-9.88762022688391409148808687500982534e-01) }},
   {{ SC_(9.20190937500000000000000000000000000e+04), SC_(3.92699003219604492187500000000000000e-01), SC_(8.79835901248155855059721040527784966e+01) }},
   {{ SC_(1.08673084469046443700790405273437500e-05), SC_(-3.92699122428894042968750000000000000e-01), SC_(8.79837157433958974221973035974293002e+01) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-4.80196571350097656250000000000000000e+00), SC_(8.79837957524813710268431813584601414e+01) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(4.80196380615234375000000000000000000e+00), SC_(-9.88761978803370123443697838019206148e-01) }},
   {{ SC_(8.46751334400000000000000000000000000e+09), SC_(1.96349501609802246093750000000000000e-01), SC_(8.79835895665182698554483510860177659e+01) }},
   {{ SC_(1.18098419932266551768407225608825684e-10), SC_(-1.96349561214447021484375000000000000e-01), SC_(8.79837117412083777801493879752847316e+01) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-2.75727462768554687500000000000000000e+00), SC_(8.79838077744789005354008335096587783e+01) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(2.75727367401123046875000000000000000e+00), SC_(-9.88761982910610337054045949991559559e-01) }},
   {{ SC_(7.16987662191799828480000000000000000e+19), SC_(9.81747508049011230468750000000000000e-02), SC_(8.79835876156238889462649785779027773e+01) }},
   {{ SC_(1.39472344799243821776384404803605932e-20), SC_(-9.81747806072235107421875000000000000e-02), SC_(8.79837131884536093233589016659197026e+01) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-1.93383979797363281250000000000000000e+00), SC_(8.79837877817931861576942819562806916e+01) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(1.93383932113647460937500000000000000e+00), SC_(-9.88761985394521163913304891015077191e-01) }},
   {{ SC_(1.94525450220642456151490293293139578e-40), SC_(-4.90873903036117553710937500000000000e-02), SC_(8.79837109299165387722591908651991951e+01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-1.48912572860717773437500000000000000e+00), SC_(8.79837148673724515154029480960738646e+01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(1.48912525177001953125000000000000000e+00), SC_(-9.88761972471571396143259360249542332e-01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-1.21070671081542968750000000000000000e+00), SC_(8.79837428724452911596199344597016512e+01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(1.21070623397827148437500000000000000e+00), SC_(-9.88761972294043665349927227981747105e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-1.01999950408935546875000000000000000e+00), SC_(8.79838178611966229825531112298056160e+01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(1.01999902725219726562500000000000000e+00), SC_(-9.88761978050221661682921292133894875e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-8.81195545196533203125000000000000000e-01), SC_(8.79836966561983200200628571847131196e+01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(8.81195545196533203125000000000000000e-01), SC_(-9.88761986323588600936778916865455255e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-7.75644302368164062500000000000000000e-01), SC_(8.79837309170978734398538653092131996e+01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(7.75644063949584960937500000000000000e-01), SC_(-9.88761975145777583987794470525561433e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-6.92674398422241210937500000000000000e-01), SC_(8.79837192148274788947433943742713841e+01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(6.92674160003662109375000000000000000e-01), SC_(-9.88761971810675211118024664219484615e-01) }},
   {{ SC_(1.00307083129882812500000000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(1.37635554807684863103752145447022690e+02) }},
   {{ SC_(9.96938228607177734375000000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(1.37712109548804184335851035892537997e+02) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(6.68030261993408203125000000000000000e-01), SC_(1.37670928530792708577405390426078392e+02) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-6.68030261993408203125000000000000000e-01), SC_(-9.92788683175378435411860044302454471e-01) }},
   {{ SC_(1.00615119934082031250000000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(1.37647383587589229463184912203556893e+02) }},
   {{ SC_(9.93885993957519531250000000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(1.37693893452068257644066732295901496e+02) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(7.37245321273803710937500000000000000e-01), SC_(1.37670793463613525461207377443310507e+02) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-7.37245559692382812500000000000000000e-01), SC_(-9.92788687653499914019924468930650690e-01) }},
   {{ SC_(1.01234054565429687500000000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(1.37664442050264288992364101113609737e+02) }},
   {{ SC_(9.87809658050537109375000000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(1.37677573649588827766910135342071820e+02) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(8.22461366653442382812500000000000000e-01), SC_(1.37670883904947752962857835126298537e+02) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-8.22461605072021484375000000000000000e-01), SC_(-9.92788691164992597067373141561050565e-01) }},
   {{ SC_(1.02483320236206054687500000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(1.37659599354436797254165941729040269e+02) }},
   {{ SC_(9.75768089294433593750000000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(1.37672751479235605591050124706628565e+02) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(9.29951667785644531250000000000000000e-01), SC_(1.37670905572576600634195958041654576e+02) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-9.29951667785644531250000000000000000e-01), SC_(-9.92788681981480051328260084421729720e-01) }},
   {{ SC_(1.05028390884399414062500000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(1.37670432292101893953499765551041152e+02) }},
   {{ SC_(9.52123403549194335937500000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(1.37672173653707245384429304706645036e+02) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(1.06976222991943359375000000000000000e+00), SC_(1.37670684959335440213558224181221651e+02) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-1.06976270675659179687500000000000000e+00), SC_(-9.92788686362554911252988487262426075e-01) }},
   {{ SC_(1.10309600830078125000000000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(1.37668657482082438473886278779371165e+02) }},
   {{ SC_(9.06538963317871093750000000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(1.37672267984793098218404996542708786e+02) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(1.25905084609985351562500000000000000e+00), SC_(1.37670838481231599264274279561718780e+02) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-1.25905132293701171875000000000000000e+00), SC_(-9.92788691962700494362518310010302057e-01) }},
   {{ SC_(1.21682119369506835937500000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(1.37669774969147546071618949742705877e+02) }},
   {{ SC_(8.21813106536865234375000000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(1.37671358218559433334339509421195012e+02) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(1.52972745895385742187500000000000000e+00), SC_(1.37670866633502169321017372050095443e+02) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-1.52972793579101562500000000000000000e+00), SC_(-9.92788691043235021196534372982250903e-01) }},
   {{ SC_(1.48065471649169921875000000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(1.37670833080215607020564559815270561e+02) }},
   {{ SC_(6.75376892089843750000000000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(1.37671074362410293191245324869963468e+02) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(1.94865894317626953125000000000000000e+00), SC_(1.37670781415456201423489400562101713e+02) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-1.94865942001342773437500000000000000e+00), SC_(-9.92788684228161746237947161828501769e-01) }},
   {{ SC_(2.19233798980712890625000000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(1.37670674243846918583683418709157284e+02) }},
   {{ SC_(4.56133961677551269531250000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(1.37671045120264230840243762802454976e+02) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(2.68358707427978515625000000000000000e+00), SC_(1.37670775647671189873795083890079825e+02) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-2.68358802795410156250000000000000000e+00), SC_(-9.92788687864512096580817321937658067e-01) }},
   {{ SC_(4.80634689331054687500000000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(1.37670767762394432534440111052614698e+02) }},
   {{ SC_(2.08058178424835205078125000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(1.37671071442006991668491969860893813e+02) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(4.30853080749511718750000000000000000e+00), SC_(1.37670847087200702989121799307475932e+02) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-4.30853080749511718750000000000000000e+00), SC_(-9.92788678940057474848388624431402033e-01) }},
   {{ SC_(2.31009750366210937500000000000000000e+01), SC_(1.57079601287841796875000000000000000e+00), SC_(1.37670810927212617946230869445671202e+02) }},
   {{ SC_(4.32882159948348999023437500000000000e-02), SC_(-1.57079648971557617187500000000000000e+00), SC_(1.37671019183351653960586749491494494e+02) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(1.09218139648437500000000000000000000e+01), SC_(1.37670430497746410783214685777655418e+02) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-1.09218177795410156250000000000000000e+01), SC_(-9.92788669698640717665432174308987142e-01) }},
   {{ SC_(5.33655029296875000000000000000000000e+02), SC_(7.85398006439208984375000000000000000e-01), SC_(1.37670807183100074401106759753787185e+02) }},
   {{ SC_(1.87386944890022277832031250000000000e-03), SC_(-7.85398244857788085937500000000000000e-01), SC_(1.37671030523729615712710977249578889e+02) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-2.04173431396484375000000000000000000e+01), SC_(1.37671643595114287555901759094247915e+02) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(2.04173355102539062500000000000000000e+01), SC_(-9.92788707070396749176581695996793846e-01) }},
   {{ SC_(2.84787625000000000000000000000000000e+05), SC_(3.92699003219604492187500000000000000e-01), SC_(1.37670794697887915948846948183220954e+02) }},
   {{ SC_(3.51138805854134261608123779296875000e-06), SC_(-3.92699122428894042968750000000000000e-01), SC_(1.37671009633613713155540203469365699e+02) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-5.27660560607910156250000000000000000e+00), SC_(1.37671221405503375305610417962238733e+02) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(5.27660369873046875000000000000000000e+00), SC_(-9.92788685549262187041204716490981354e-01) }},
   {{ SC_(8.11040112640000000000000000000000000e+10), SC_(1.96349501609802246093750000000000000e-01), SC_(1.37670801382289636435500758909777478e+02) }},
   {{ SC_(1.23298454779430244343529921025037766e-11), SC_(-1.96349561214447021484375000000000000e-01), SC_(1.37671011002149269933700319693573938e+02) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-3.02981090545654296875000000000000000e+00), SC_(1.37671116404429762273560455452000694e+02) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(3.02980995178222656250000000000000000e+00), SC_(-9.92788681750191677194568693594554796e-01) }},
   {{ SC_(6.57786078834535799193600000000000000e+21), SC_(9.81747508049011230468750000000000000e-02), SC_(1.37670801682876096061058046937655955e+02) }},
   {{ SC_(1.52025083225064861124237981999159780e-22), SC_(-9.81747806072235107421875000000000000e-02), SC_(1.37671011564967103246517368739988010e+02) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-2.12498569488525390625000000000000000e+00), SC_(1.37671109179312832619110157659890644e+02) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(2.12498474121093750000000000000000000e+00), SC_(-9.92788676607516104089920783033966038e-01) }},
   {{ SC_(2.24207754291970731347796733326386581e-44), SC_(-4.90873903036117553710937500000000000e-02), SC_(1.37877742751304776383729426666083322e+02) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-1.63631486892700195312500000000000000e+00), SC_(1.37670972295635690044424641380229614e+02) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(1.63631486892700195312500000000000000e+00), SC_(-9.92788685451284800633955436908416940e-01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-1.33037614822387695312500000000000000e+00), SC_(1.37671005831216219788908155756693834e+02) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(1.33037614822387695312500000000000000e+00), SC_(-9.92788687195237102156217621863937381e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-1.12081861495971679687500000000000000e+00), SC_(1.37670936315683980430107104706101208e+02) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(1.12081861495971679687500000000000000e+00), SC_(-9.92788683580216816821212949982403378e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-9.68295335769653320312500000000000000e-01), SC_(1.37671000091961961740668791145661298e+02) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(9.68295097351074218750000000000000000e-01), SC_(-9.92788678139299219216662394371130092e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-8.52311134338378906250000000000000000e-01), SC_(1.37671071966279740902895633883758700e+02) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(8.52310895919799804687500000000000000e-01), SC_(-9.92788680685248087809007760506154008e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-7.61140346527099609375000000000000000e-01), SC_(1.37671133994064345273114250489901570e+02) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(7.61140108108520507812500000000000000e-01), SC_(-9.92788682719144728658713490206122943e-01) }},
   {{ SC_(1.00337600708007812500000000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(2.25137932064613869996776047900380607e+02) }},
   {{ SC_(9.96634960174560546875000000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(2.25281352502108610755064735114483197e+02) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(7.34354734420776367187500000000000000e-01), SC_(2.25281746283158423481511711415470125e+02) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-7.34354972839355468750000000000000000e-01), SC_(-9.95580738366351124821960302565030271e-01) }},
   {{ SC_(1.00676393508911132812500000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(2.25232522539018848596994073835767879e+02) }},
   {{ SC_(9.93281126022338867187500000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(2.25302940157156402667791912271263540e+02) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(8.10441970825195312500000000000000000e-01), SC_(2.25281889217711267993231944728595105e+02) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-8.10442209243774414062500000000000000e-01), SC_(-9.95580740427524904423644299437246699e-01) }},
   {{ SC_(1.01357412338256835937500000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(2.25277618805795533017268324624360615e+02) }},
   {{ SC_(9.86607551574707031250000000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(2.25288527414722072743596882248269748e+02) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(9.04118537902832031250000000000000000e-01), SC_(2.25281961313977069630187562453168864e+02) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-9.04118537902832031250000000000000000e-01), SC_(-9.95580734786842102457941589418044080e-01) }},
   {{ SC_(1.02733230590820312500000000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(2.25268864528853552181437192968276606e+02) }},
   {{ SC_(9.73394393920898437500000000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(2.25291654605459933684947659570827741e+02) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(1.02228069305419921875000000000000000e+00), SC_(2.25281757541955363936128973915482101e+02) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-1.02228116989135742187500000000000000e+00), SC_(-9.95580741983329588183136770078451179e-01) }},
   {{ SC_(1.05541229248046875000000000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(2.25282350865498860017398598336228622e+02) }},
   {{ SC_(9.47496891021728515625000000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(2.25285774530333991007814625545806207e+02) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(1.17597246170043945312500000000000000e+00), SC_(2.25281673929612389970394740316390536e+02) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-1.17597293853759765625000000000000000e+00), SC_(-9.95580738889742487765345877748385674e-01) }},
   {{ SC_(1.11389493942260742187500000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(2.25280638494162725469383058500881198e+02) }},
   {{ SC_(8.97750616073608398437500000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(2.25282511081964849708938684447207706e+02) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(1.38405418395996093750000000000000000e+00), SC_(2.25281756473218443670297850899743791e+02) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-1.38405466079711914062500000000000000e+00), SC_(-9.95580739041164718510495711313929163e-01) }},
   {{ SC_(1.24076223373413085937500000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(2.25282002840344715503836866930845149e+02) }},
   {{ SC_(8.05956125259399414062500000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(2.25282817335389183588843997816960878e+02) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(1.68160438537597656250000000000000000e+00), SC_(2.25281653026950428746118885701923112e+02) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-1.68160486221313476562500000000000000e+00), SC_(-9.95580735560220452492856840872704416e-01) }},
   {{ SC_(1.53949069976806640625000000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(2.25281594836791845722549420370935641e+02) }},
   {{ SC_(6.49565458297729492187500000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(2.25282018618920403411281878370736593e+02) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(2.14212894439697265625000000000000000e+00), SC_(2.25281516043465534875704493688052604e+02) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-2.14212989807128906250000000000000000e+00), SC_(-9.95580736757843713767470842550955394e-01) }},
   {{ SC_(2.37003135681152343750000000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(2.25281440147534682125514579210669683e+02) }},
   {{ SC_(4.21935200691223144531250000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(2.25282301407514559921215856210233914e+02) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(2.95002365112304687500000000000000000e+00), SC_(2.25281596126014217057143417362907721e+02) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-2.95002460479736328125000000000000000e+00), SC_(-9.95580735400555149376184322736522622e-01) }},
   {{ SC_(5.61705017089843750000000000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(2.25281634873764268575857082397881521e+02) }},
   {{ SC_(1.78029358386993408203125000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(2.25282122498651190362528689074801721e+02) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(4.73629760742187500000000000000000000e+00), SC_(2.25281652413541752625526654342495527e+02) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-4.73629951477050781250000000000000000e+00), SC_(-9.95580738403057827740366168386646097e-01) }},
   {{ SC_(3.15512619018554687500000000000000000e+01), SC_(1.57079601287841796875000000000000000e+00), SC_(2.25281739412075698635333064216628967e+02) }},
   {{ SC_(3.16944420337677001953125000000000000e-02), SC_(-1.57079648971557617187500000000000000e+00), SC_(2.25282239287452562611089836260000570e+02) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(1.20061759948730468750000000000000000e+01), SC_(2.25281327383054679229666932318024574e+02) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-1.20061798095703125000000000000000000e+01), SC_(-9.95580730019061126527148621173715834e-01) }},
   {{ SC_(9.95482177734375000000000000000000000e+02), SC_(7.85398006439208984375000000000000000e-01), SC_(2.25281748362548445550291527609707026e+02) }},
   {{ SC_(1.00453803315758705139160156250000000e-03), SC_(-7.85398244857788085937500000000000000e-01), SC_(2.25282172531431349459643910396772105e+02) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-2.24444503784179687500000000000000000e+01), SC_(2.25282985409480978865796719885231398e+02) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(2.24444503784179687500000000000000000e+01), SC_(-9.95580754787239512752446457286487069e-01) }},
   {{ SC_(9.90984750000000000000000000000000000e+05), SC_(3.92699003219604492187500000000000000e-01), SC_(2.25281746911096554721838008367200073e+02) }},
   {{ SC_(1.00909710454288870096206665039062500e-06), SC_(-3.92699122428894042968750000000000000e-01), SC_(2.25282133390396458945630176703577535e+02) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-5.80048751831054687500000000000000000e+00), SC_(2.25282552812574009027462652560215801e+02) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(5.80048561096191406250000000000000000e+00), SC_(-9.95580738459976392004310566006229645e-01) }},
   {{ SC_(9.82050930688000000000000000000000000e+11), SC_(1.96349501609802246093750000000000000e-01), SC_(2.25281753966890302144926610626523658e+02) }},
   {{ SC_(1.01827704254708883979674283182248473e-12), SC_(-1.96349561214447021484375000000000000e-01), SC_(2.25282130067738949735437609305370680e+02) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-3.33062171936035156250000000000000000e+00), SC_(2.25282147785085417699777683026244957e+02) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(3.33062171936035156250000000000000000e+00), SC_(-9.95580738428602137210168272817313969e-01) }},
   {{ SC_(9.64424026750398226235392000000000000e+23), SC_(9.81747508049011230468750000000000000e-02), SC_(2.25281753881321962412154594015088795e+02) }},
   {{ SC_(1.03688784572290795866893826108619497e-24), SC_(-9.81747806072235107421875000000000000e-02), SC_(2.25282136273573532429902941257119895e+02) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-2.33596229553222656250000000000000000e+00), SC_(2.25282226528289412938463367805561800e+02) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(2.33596134185791015625000000000000000e+00), SC_(-9.95580730184474084683659022165237382e-01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-1.79877471923828125000000000000000000e+00), SC_(2.25282208638149265812409992106921126e+02) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(1.79877424240112304687500000000000000e+00), SC_(-9.95580733265422169557236422895887071e-01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-1.46246099472045898437500000000000000e+00), SC_(2.25282109037030880315711135585938200e+02) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(1.46246099472045898437500000000000000e+00), SC_(-9.95580737671857429852561514114628588e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-1.23209810256958007812500000000000000e+00), SC_(2.25282299740450547594212068170092507e+02) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(1.23209762573242187500000000000000000e+00), SC_(-9.95580732123342285468439507978621824e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-1.06443166732788085937500000000000000e+00), SC_(2.25282394773630360745169720400158639e+02) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(1.06443119049072265625000000000000000e+00), SC_(-9.95580732518680150404935258370120278e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-9.36931848526000976562500000000000000e-01), SC_(2.25282222211965732119512703093672392e+02) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(9.36931610107421875000000000000000000e-01), SC_(-9.95580733785038346834140596395266359e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-8.36709260940551757812500000000000000e-01), SC_(2.25282311877167123341130258904413397e+02) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(8.36709022521972656250000000000000000e-01), SC_(-9.95580734805864878498400903418580783e-01) }},
   {{ SC_(1.00371313095092773437500000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(3.87188847147554560548239887777720650e+02) }},
   {{ SC_(9.96300458908081054687500000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(3.87281360927315764165284555489717553e+02) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(8.07479619979858398437500000000000000e-01), SC_(3.87256377968393296448895087681949760e+02) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-8.07479858398437500000000000000000000e-01), SC_(-9.97424386831771150903721250922746956e-01) }},
   {{ SC_(1.00744009017944335937500000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(3.87201533227824549624156478092854342e+02) }},
   {{ SC_(9.92614507675170898437500000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(3.87311797980487769837069904788522198e+02) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(8.91143321990966796875000000000000000e-01), SC_(3.87256445796053227647569634525919129e+02) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-8.91143560409545898437500000000000000e-01), SC_(-9.97424386856082210093895976709894816e-01) }},
   {{ SC_(1.01493549346923828125000000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(3.87195099263205891970509857362736391e+02) }},
   {{ SC_(9.85283851623535156250000000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(3.87265717984928298655826072424402322e+02) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(9.94148015975952148437500000000000000e-01), SC_(3.87256811700914908200722140543854980e+02) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-9.94148015975952148437500000000000000e-01), SC_(-9.97424385175319659307666955639321923e-01) }},
   {{ SC_(1.03009462356567382812500000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(3.87238113944740386281582603448682415e+02) }},
   {{ SC_(9.70784187316894531250000000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(3.87272227879603808745036182117718582e+02) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(1.12407636642456054687500000000000000e+00), SC_(3.87256331896780763440505963138373546e+02) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-1.12407684326171875000000000000000000e+00), SC_(-9.97424388506020787023074140897624075e-01) }},
   {{ SC_(1.06109523773193359375000000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(3.87249304618788668307499333196222257e+02) }},
   {{ SC_(9.42422151565551757812500000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(3.87263396757655893073189280698352409e+02) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(1.29307270050048828125000000000000000e+00), SC_(3.87256882743522772696038369057803643e+02) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-1.29307270050048828125000000000000000e+00), SC_(-9.97424385646601437255230966921194214e-01) }},
   {{ SC_(1.12592315673828125000000000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(3.87250226746659515713281109985589303e+02) }},
   {{ SC_(8.88159751892089843750000000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(3.87258120208864806733502297722787626e+02) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(1.52187442779541015625000000000000000e+00), SC_(3.87256696985715159837751264398531502e+02) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-1.52187442779541015625000000000000000e+00), SC_(-9.97424384414322691626460735553215074e-01) }},
   {{ SC_(1.26770353317260742187500000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(3.87254678021370984997907479430661299e+02) }},
   {{ SC_(7.88827657699584960937500000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(3.87259198666050454797011739564181405e+02) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(1.84905385971069335937500000000000000e+00), SC_(3.87256519117019920622498196559994273e+02) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-1.84905433654785156250000000000000000e+00), SC_(-9.97424387194139712485273535503661105e-01) }},
   {{ SC_(1.60707283020019531250000000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(3.87256445485747723115564447715916138e+02) }},
   {{ SC_(6.22249364852905273437500000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(3.87256914602741573533059750816712952e+02) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(2.35543632507324218750000000000000000e+00), SC_(3.87256413244339104401484995185177587e+02) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-2.35543727874755859375000000000000000e+00), SC_(-9.97424388748986452280842427135902432e-01) }},
   {{ SC_(2.58268260955810546875000000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(3.87255999646883511365456607248058032e+02) }},
   {{ SC_(3.87194156646728515625000000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(3.87257641755782272420763930579842077e+02) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(3.24377918243408203125000000000000000e+00), SC_(3.87256700324248081096437217397707928e+02) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-3.24377918243408203125000000000000000e+00), SC_(-9.97424384436469836590371200984352964e-01) }},
   {{ SC_(6.67025184631347656250000000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(3.87256435702133854008727251880526101e+02) }},
   {{ SC_(1.49919331073760986328125000000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(3.87257510502265902789527811009581456e+02) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(5.20792388916015625000000000000000000e+00), SC_(3.87256063092100901127334681223574585e+02) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-5.20792579650878906250000000000000000e+00), SC_(-9.97424385832793638337252107658942734e-01) }},
   {{ SC_(4.44922485351562500000000000000000000e+01), SC_(1.57079601287841796875000000000000000e+00), SC_(3.87256282754099294017103304722861730e+02) }},
   {{ SC_(2.24758163094520568847656250000000000e-02), SC_(-1.57079648971557617187500000000000000e+00), SC_(3.87257226135234930977107339083030967e+02) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(1.32017173767089843750000000000000000e+01), SC_(3.87255880909611522421124937935488374e+02) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-1.32017173767089843750000000000000000e+01), SC_(-9.97424379000629210144653787178107883e-01) }},
   {{ SC_(1.97956103515625000000000000000000000e+03), SC_(7.85398006439208984375000000000000000e-01), SC_(3.87256414528240963889434253244459258e+02) }},
   {{ SC_(5.05162402987480163574218750000000000e-04), SC_(-7.85398244857788085937500000000000000e-01), SC_(3.87257175301903776438176500485169006e+02) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-2.46794052124023437500000000000000000e+01), SC_(3.87258945445171599595556794186272572e+02) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(2.46793975830078125000000000000000000e+01), SC_(-9.97424394583240514392587997135246901e-01) }},
   {{ SC_(3.91866200000000000000000000000000000e+06), SC_(3.92699003219604492187500000000000000e-01), SC_(3.87256418733866896591494027000324307e+02) }},
   {{ SC_(2.55189092968066688627004623413085938e-07), SC_(-3.92699122428894042968750000000000000e-01), SC_(3.87257151656375211669321620023174230e+02) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-6.37808227539062500000000000000000000e+00), SC_(3.87257632004302921262048855884480885e+02) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(6.37808036804199218750000000000000000e+00), SC_(-9.97424386025174421916077197099588387e-01) }},
   {{ SC_(1.53559131750400000000000000000000000e+13), SC_(1.96349501609802246093750000000000000e-01), SC_(3.87256425211486467409030643733168379e+02) }},
   {{ SC_(6.51214921831150261866127948451321572e-14), SC_(-1.96349561214447021484375000000000000e-01), SC_(3.87257129398614167315348021832715249e+02) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-3.66227531433105468750000000000000000e+00), SC_(3.87257183308169020696822317428843723e+02) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(3.66227531433105468750000000000000000e+00), SC_(-9.97424387640482427181591028700646442e-01) }},
   {{ SC_(2.35804065411442544763469824000000000e+26), SC_(9.81747508049011230468750000000000000e-02), SC_(3.87256424560385277306702932167402713e+02) }},
   {{ SC_(4.24080837439127378068568163219547401e-27), SC_(-9.81747806072235107421875000000000000e-02), SC_(3.87257132722113670147504315998891056e+02) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-2.56857109069824218750000000000000000e+00), SC_(3.87257768091986752340010218713502187e+02) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(2.56857013702392578125000000000000000e+00), SC_(-9.97424385818728694306216776158996647e-01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-1.97789144515991210937500000000000000e+00), SC_(3.87257282473853190869504682042757460e+02) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(1.97789096832275390625000000000000000e+00), SC_(-9.97424384596498283668672378492988584e-01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-1.60808849334716796875000000000000000e+00), SC_(3.87256964761464929314504139678111073e+02) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(1.60808849334716796875000000000000000e+00), SC_(-9.97424386190691069194181629000627961e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-1.35478687286376953125000000000000000e+00), SC_(3.87257530522187115236035448704734275e+02) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(1.35478639602661132812500000000000000e+00), SC_(-9.97424384539420903975238288822854420e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-1.17042446136474609375000000000000000e+00), SC_(3.87257241280268766770382695709366333e+02) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(1.17042398452758789062500000000000000e+00), SC_(-9.97424381769363008488688795809629005e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-1.03022861480712890625000000000000000e+00), SC_(3.87256932688121326927726235415891581e+02) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(1.03022861480712890625000000000000000e+00), SC_(-9.97424385977923337988270742936150664e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-9.20026302337646484375000000000000000e-01), SC_(3.87257427429628793411421979652893239e+02) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(9.20026063919067382812500000000000000e-01), SC_(-9.97424385280798157576093621358967097e-01) }},
   {{ SC_(1.00408411026000976562500000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(7.02376992439765643476469218280896696e+02) }},
   {{ SC_(9.95932102203369140625000000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(7.02832539201480959537073705267660536e+02) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(8.88036012649536132812500000000000000e-01), SC_(7.02746433474478573371347742193234283e+02) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-8.88036251068115234375000000000000000e-01), SC_(-9.98579036152542724029401312277831600e-01) }},
   {{ SC_(1.00818538665771484375000000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(7.02649839883777391878399909620598867e+02) }},
   {{ SC_(9.91880893707275390625000000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(7.02751786702350067459191052459014812e+02) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(9.80046272277832031250000000000000000e-01), SC_(7.02746738591730524053524502300294663e+02) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-9.80046510696411132812500000000000000e-01), SC_(-9.98579036533790239492283261452075017e-01) }},
   {{ SC_(1.01643800735473632812500000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(7.02714839942146974925710744130047393e+02) }},
   {{ SC_(9.83827590942382812500000000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(7.02785257902218485497275895009904171e+02) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(1.09332656860351562500000000000000000e+00), SC_(7.02745636295546540547798749228806200e+02) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-1.09332704544067382812500000000000000e+00), SC_(-9.98579036104877310540181278450011560e-01) }},
   {{ SC_(1.03314638137817382812500000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(7.02736558336751171127192364584033523e+02) }},
   {{ SC_(9.67916965484619140625000000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(7.02750641992724907414944616391309995e+02) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(1.23621749877929687500000000000000000e+00), SC_(7.02746996952251993979365039025336552e+02) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-1.23621749877929687500000000000000000e+00), SC_(-9.98579034789021134174091642037936013e-01) }},
   {{ SC_(1.06739139556884765625000000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(7.02733258502690294850258009378046272e+02) }},
   {{ SC_(9.36863183975219726562500000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(7.02755784521813312784129148014763474e+02) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(1.42207288742065429687500000000000000e+00), SC_(7.02746433945712296892885497941055542e+02) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-1.42207336425781250000000000000000000e+00), SC_(-9.98579036776137684782203279910078750e-01) }},
   {{ SC_(1.13932466506958007812500000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(7.02741757420250786073628957087092520e+02) }},
   {{ SC_(8.77712726593017578125000000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(7.02751709685587552203664510840794379e+02) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(1.67370033264160156250000000000000000e+00), SC_(7.02745737741665529222416640635183916e+02) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-1.67370080947875976562500000000000000e+00), SC_(-9.98579034900747276326352494772305554e-01) }},
   {{ SC_(1.29806089401245117187500000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(7.02744504042261873668862652549701802e+02) }},
   {{ SC_(7.70379781723022460937500000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(7.02748235992438309804380289172612397e+02) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(2.03352069854736328125000000000000000e+00), SC_(7.02747007451594370345939880873529447e+02) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-2.03352069854736328125000000000000000e+00), SC_(-9.98579034810220798395753372654912611e-01) }},
   {{ SC_(1.68496227264404296875000000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(7.02745491177655009094956913342839358e+02) }},
   {{ SC_(5.93484878540039062500000000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(7.02750166392837015190827228601161861e+02) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(2.59042072296142578125000000000000000e+00), SC_(7.02745751142873705521558800665878827e+02) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-2.59042167663574218750000000000000000e+00), SC_(-9.98579035703439342309094761584665909e-01) }},
   {{ SC_(2.83909797668457031250000000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(7.02745672544349854414282531041948972e+02) }},
   {{ SC_(3.52224469184875488281250000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(7.02748055717307167593810287711458372e+02) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(3.56738662719726562500000000000000000e+00), SC_(7.02745901907717009353670769637766396e+02) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-3.56738758087158203125000000000000000e+00), SC_(-9.98579035068545660142140105663359214e-01) }},
   {{ SC_(8.06047821044921875000000000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(7.02745916449664399830526470710277009e+02) }},
   {{ SC_(1.24062091112136840820312500000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(7.02747798748581760948704937840386133e+02) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(5.72747993469238281250000000000000000e+00), SC_(7.02745163692071322822170076022005086e+02) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-5.72748184204101562500000000000000000e+00), SC_(-9.98579034189936773482827998683545061e-01) }},
   {{ SC_(6.49713134765625000000000000000000000e+01), SC_(1.57079601287841796875000000000000000e+00), SC_(7.02745992936355920784777612532680337e+02) }},
   {{ SC_(1.53914056718349456787109375000000000e-02), SC_(-1.57079648971557617187500000000000000e+00), SC_(7.02747567429494896440691653211238505e+02) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(1.45187530517578125000000000000000000e+01), SC_(7.02744158604780435177997109511139874e+02) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-1.45187568664550781250000000000000000e+01), SC_(-9.98579031505805322655330000299489331e-01) }},
   {{ SC_(4.22127148437500000000000000000000000e+03), SC_(7.85398006439208984375000000000000000e-01), SC_(7.02745981087243194599843497739703293e+02) }},
   {{ SC_(2.36895342823117971420288085937500000e-04), SC_(-7.85398244857788085937500000000000000e-01), SC_(7.02747627466875716333074249012581884e+02) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-2.71414871215820312500000000000000000e+01), SC_(7.02750942487078588983456748371035365e+02) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(2.71414871215820312500000000000000000e+01), SC_(-9.98579042755572066928219868016234259e-01) }},
   {{ SC_(1.78191440000000000000000000000000000e+07), SC_(3.92699003219604492187500000000000000e-01), SC_(7.02746152544463346274936636818492365e+02) }},
   {{ SC_(5.61194042347779031842947006225585938e-08), SC_(-3.92699122428894042968750000000000000e-01), SC_(7.02747623608538104533477730112361463e+02) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-7.01437759399414062500000000000000000e+00), SC_(7.02749097680315152387380561418099750e+02) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(7.01437568664550781250000000000000000e+00), SC_(-9.98579036497355155793270824412059386e-01) }},
   {{ SC_(3.17521966137344000000000000000000000e+14), SC_(1.96349501609802246093750000000000000e-01), SC_(7.02746184419286257997635780420524638e+02) }},
   {{ SC_(3.14938792953705151700383169099950464e-15), SC_(-1.96349561214447021484375000000000000e-01), SC_(7.02747606151818503273344211064204315e+02) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-4.02763366699218750000000000000000000e+00), SC_(7.02747663558816808643846178068380290e+02) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(4.02763366699218750000000000000000000e+00), SC_(-9.98579036134993258929289392321967637e-01) }},
   {{ SC_(1.00820182115491421968383606784000000e+29), SC_(9.81747508049011230468750000000000000e-02), SC_(7.02746172862556907912435126826672791e+02) }},
   {{ SC_(9.91864453788809832019900040310611080e-30), SC_(-9.81747806072235107421875000000000000e-02), SC_(7.02747604708704357164000864196988574e+02) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-2.82481861114501953125000000000000000e+00), SC_(7.02748858753563139307666662303405683e+02) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(2.82481765747070312500000000000000000e+00), SC_(-9.98579035402973711976737865422053264e-01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-2.17521095275878906250000000000000000e+00), SC_(7.02747398782519568885846420872368780e+02) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(2.17521095275878906250000000000000000e+00), SC_(-9.98579035600373093598845792657274129e-01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-1.76851606369018554687500000000000000e+00), SC_(7.02748202285502700714945489108492001e+02) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(1.76851558685302734375000000000000000e+00), SC_(-9.98579034710806202142078562562246400e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-1.48994398117065429687500000000000000e+00), SC_(7.02748221444955013820039626826810743e+02) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(1.48994350433349609375000000000000000e+00), SC_(-9.98579034279836652577668332123151024e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-1.28718900680541992187500000000000000e+00), SC_(7.02747347706650834010524096685020889e+02) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(1.28718900680541992187500000000000000e+00), SC_(-9.98579035497243765454610009077607844e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-1.13300704956054687500000000000000000e+00), SC_(7.02747491865335088410987112228756429e+02) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(1.13300704956054687500000000000000000e+00), SC_(-9.98579035788320288578823099048743002e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-1.01181077957153320312500000000000000e+00), SC_(7.02749060405442858319079178673876379e+02) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(1.01181030273437500000000000000000000e+00), SC_(-9.98579034564848082828034268545649631e-01) }},
   {{ SC_(1.00449323654174804687500000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(1.35346309931409428235796788567411952e+03) }},
   {{ SC_(9.95526790618896484375000000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(1.35362299566609888640547001615640294e+03) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(9.76727724075317382812500000000000000e-01), SC_(1.35356254199321154331927068600455884e+03) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-9.76727962493896484375000000000000000e-01), SC_(-9.99261755578835988125506506854063997e-01) }},
   {{ SC_(1.00900650024414062500000000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(1.35328820029742586425943791464033052e+03) }},
   {{ SC_(9.91073608398437500000000000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(1.35360369438317690777425412614096725e+03) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(1.07792758941650390625000000000000000e+00), SC_(1.35356475349775925923863893097074893e+03) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-1.07792758941650390625000000000000000e+00), SC_(-9.99261755484617624657116498242649483e-01) }},
   {{ SC_(1.01809453964233398437500000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(1.35351400969225834242925007609192613e+03) }},
   {{ SC_(9.82226848602294921875000000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(1.35363068116401288171107475363377557e+03) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(1.20252180099487304687500000000000000e+00), SC_(1.35356354594938510444721678150538298e+03) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-1.20252227783203125000000000000000000e+00), SC_(-9.99261756937489973282597869021222698e-01) }},
   {{ SC_(1.03651666641235351562500000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(1.35355992879648149300991900452011447e+03) }},
   {{ SC_(9.64769840240478515625000000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(1.35355781162822679035212279846466334e+03) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(1.35968351364135742187500000000000000e+00), SC_(1.35356391185157037029677049794020620e+03) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-1.35968351364135742187500000000000000e+00), SC_(-9.99261755025915988356750522888164434e-01) }},
   {{ SC_(1.07436656951904296875000000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(1.35353074743255594836879522873400920e+03) }},
   {{ SC_(9.30780649185180664062500000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(1.35358640700148803364029846975090296e+03) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(1.56410121917724609375000000000000000e+00), SC_(1.35356391616053201997685983319304311e+03) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-1.56410121917724609375000000000000000e+00), SC_(-9.99261755028264396758484504161624715e-01) }},
   {{ SC_(1.15426397323608398437500000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(1.35355714632801289759095386270913449e+03) }},
   {{ SC_(8.66352796554565429687500000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(1.35357228735880841091448861952747166e+03) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(1.84085988998413085937500000000000000e+00), SC_(1.35356321938629869878172356590363933e+03) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-1.84086036682128906250000000000000000e+00), SC_(-9.99261756027502482837345501009234403e-01) }},
   {{ SC_(1.33232545852661132812500000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(1.35356068826061287624378731214921720e+03) }},
   {{ SC_(7.50567197799682617187500000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(1.35357094015103190847382326648961411e+03) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(2.23661613464355468750000000000000000e+00), SC_(1.35356193886235612748064375939860026e+03) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-2.23661708831787109375000000000000000e+00), SC_(-9.99261756220586491456203063638817284e-01) }},
   {{ SC_(1.77509117126464843750000000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(1.35356110852682474198746892695850114e+03) }},
   {{ SC_(5.63351154327392578125000000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(1.35356985496939065804954434931079657e+03) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(2.84913730621337890625000000000000000e+00), SC_(1.35356416968226113845915770370729251e+03) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-2.84913730621337890625000000000000000e+00), SC_(-9.99261755166435142697628487870091454e-01) }},
   {{ SC_(3.15094852447509765625000000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(1.35356072544221253165898732212044010e+03) }},
   {{ SC_(3.17364692687988281250000000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(1.35356530652106783080755850809291900e+03) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(3.92367649078369140625000000000000000e+00), SC_(1.35356311137285103081225096627128254e+03) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-3.92367744445800781250000000000000000e+00), SC_(-9.99261755883598459664671462676513980e-01) }},
   {{ SC_(9.92847824096679687500000000000000000e+00), SC_(3.14159202575683593750000000000000000e+00), SC_(1.35356142711446390125258561408877819e+03) }},
   {{ SC_(1.00720316171646118164062500000000000e-01), SC_(-3.14159297943115234375000000000000000e+00), SC_(1.35356665825714612201161899432056664e+03) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(6.29950714111328125000000000000000000e+00), SC_(1.35356118428371662401409994395615350e+03) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-6.29950904846191406250000000000000000e+00), SC_(-9.99261755151257656488916717360263743e-01) }},
   {{ SC_(9.85747375488281250000000000000000000e+01), SC_(1.57079601287841796875000000000000000e+00), SC_(1.35356266539469651882991761194436275e+03) }},
   {{ SC_(1.01445876061916351318359375000000000e-02), SC_(-1.57079648971557617187500000000000000e+00), SC_(1.35356550121943150800515022635780454e+03) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(1.59688034057617187500000000000000000e+01), SC_(1.35356039767714957824311848261045082e+03) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-1.59688034057617187500000000000000000e+01), SC_(-9.99261753110666134121261867546259630e-01) }},
   {{ SC_(9.71697656250000000000000000000000000e+03), SC_(7.85398006439208984375000000000000000e-01), SC_(1.35356241135265375624856650633932339e+03) }},
   {{ SC_(1.02912628790363669395446777343750000e-04), SC_(-7.85398244857788085937500000000000000e-01), SC_(1.35356580007360668559039995629291730e+03) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-2.98522186279296875000000000000000000e+01), SC_(1.35357291851862876404729689556349113e+03) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(2.98522186279296875000000000000000000e+01), SC_(-9.99261759934567710390844639600982945e-01) }},
   {{ SC_(9.44196480000000000000000000000000000e+07), SC_(3.92699003219604492187500000000000000e-01), SC_(1.35356249295070323930048107221240724e+03) }},
   {{ SC_(1.05910125114405673230066895484924316e-08), SC_(-3.92699122428894042968750000000000000e-01), SC_(1.35356563197465926469415857224742622e+03) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-7.71493148803710937500000000000000000e+00), SC_(1.35356808710357052941626452443962172e+03) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(7.71492958068847656250000000000000000e+00), SC_(-9.99261755985288830371958964173349056e-01) }},
   {{ SC_(8.91507220624179200000000000000000000e+15), SC_(1.96349501609802246093750000000000000e-01), SC_(1.35356256090536209855105233086606507e+03) }},
   {{ SC_(1.12169555650012400457860017866096314e-16), SC_(-1.96349561214447021484375000000000000e-01), SC_(1.35356560913471697677112753894398456e+03) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-4.42988967895507812500000000000000000e+00), SC_(1.35356539939845752578005644674987968e+03) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(4.42988967895507812500000000000000000e+00), SC_(-9.99261755836636543927219693067852678e-01) }},
   {{ SC_(7.94785358872098057541422982103040000e+31), SC_(9.81747508049011230468750000000000000e-02), SC_(1.35356260013315361417096537596862384e+03) }},
   {{ SC_(1.25820095785179283474190887124466566e-32), SC_(-9.81747806072235107421875000000000000e-02), SC_(1.35356560528960728704434493196493788e+03) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-3.10694408416748046875000000000000000e+00), SC_(1.35356620018349330640063951119218397e+03) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(3.10694313049316406250000000000000000e+00), SC_(-9.99261754638975190837700946838014998e-01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-2.39245891571044921875000000000000000e+00), SC_(1.35356841386215426322004940480788084e+03) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(2.39245796203613281250000000000000000e+00), SC_(-9.99261755357432558528557278877197534e-01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-1.94514465332031250000000000000000000e+00), SC_(1.35356533704656461733531668383218077e+03) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(1.94514465332031250000000000000000000e+00), SC_(-9.99261755802654483589926243612724713e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-1.63875055313110351562500000000000000e+00), SC_(1.35356574455740474424746979417399885e+03) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(1.63875007629394531250000000000000000e+00), SC_(-9.99261754475692909710954790802890275e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-1.41574573516845703125000000000000000e+00), SC_(1.35356454358476566663842510535636511e+03) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(1.41574573516845703125000000000000000e+00), SC_(-9.99261755370213983308936396243310521e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-1.24616527557373046875000000000000000e+00), SC_(1.35356695000415647851793636964589028e+03) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(1.24616479873657226562500000000000000e+00), SC_(-9.99261754644660121062353750575207566e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-1.11286401748657226562500000000000000e+00), SC_(1.35356498764362639977598248206493015e+03) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(1.11286401748657226562500000000000000e+00), SC_(-9.99261755612228262605651084709080889e-01) }},
   {{ SC_(1.00494337081909179687500000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(2.78343156505961181768615514121873337e+03) }},
   {{ SC_(9.95080709457397460937500000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(2.78450262926115830459564324319907537e+03) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(1.07433891296386718750000000000000000e+00), SC_(2.78371981668805558741053420097240895e+03) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-1.07433938980102539062500000000000000e+00), SC_(-9.99640898709630010828419583174922916e-01) }},
   {{ SC_(1.00991106033325195312500000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(2.78316943694210485038762193690776647e+03) }},
   {{ SC_(9.90185976028442382812500000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(2.78369348570139354200053954000179938e+03) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(1.18565225601196289062500000000000000e+00), SC_(2.78372243123117069164886328215917818e+03) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-1.18565273284912109375000000000000000e+00), SC_(-9.99640898928096518195834227688910147e-01) }},
   {{ SC_(1.01992082595825195312500000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(2.78369218960294030091852873485803195e+03) }},
   {{ SC_(9.80468034744262695312500000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(2.78395889835526340919404617453605084e+03) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(1.32269811630249023437500000000000000e+00), SC_(2.78372133938021388976160796383445547e+03) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-1.32269859313964843750000000000000000e+00), SC_(-9.99640898668608370928510173948659181e-01) }},
   {{ SC_(1.04023838043212890625000000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(2.78363255822986654927627821521747500e+03) }},
   {{ SC_(9.61317777633666992187500000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(2.78383630139281469217831052132292535e+03) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(1.49556636810302734375000000000000000e+00), SC_(2.78372634525512971283255589824687717e+03) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-1.49556684494018554687500000000000000e+00), SC_(-9.99640899195446100691290056961227418e-01) }},
   {{ SC_(1.08209609985351562500000000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(2.78368733386562191474542073976900550e+03) }},
   {{ SC_(9.24132108688354492187500000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(2.78376386976084720419057713800607880e+03) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(1.72041273117065429687500000000000000e+00), SC_(2.78372302669888751227881854637962495e+03) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-1.72041320800781250000000000000000000e+00), SC_(-9.99640898648815878408332528959837763e-01) }},
   {{ SC_(1.17093229293823242187500000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(2.78372601978408416461665939323353570e+03) }},
   {{ SC_(8.54020357131958007812500000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(2.78373062638759798620066909304399837e+03) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(2.02482986450195312500000000000000000e+00), SC_(2.78372193000028582772581863496722064e+03) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-2.02483081817626953125000000000000000e+00), SC_(-9.99640899059475959779096492115423349e-01) }},
   {{ SC_(1.37108230590820312500000000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(2.78371944830901659909258681549331291e+03) }},
   {{ SC_(7.29350566864013671875000000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(2.78375015720733076960161437320959653e+03) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(2.46013736724853515625000000000000000e+00), SC_(2.78372419636748615049013469414892793e+03) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-2.46013832092285156250000000000000000e+00), SC_(-9.99640899114353990738581138176181335e-01) }},
   {{ SC_(1.87986660003662109375000000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(2.78371778155648182612086342003919607e+03) }},
   {{ SC_(5.31952381134033203125000000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(2.78374149016990911524326059373887622e+03) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(3.13387107849121093750000000000000000e+00), SC_(2.78372125741207976679035487407109718e+03) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-3.13387203216552734375000000000000000e+00), SC_(-9.99640898497984817611136938750125336e-01) }},
   {{ SC_(3.53389930725097656250000000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(2.78372210549457373091999308616900823e+03) }},
   {{ SC_(2.82973408699035644531250000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(2.78373698225816898740979812748801881e+03) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(4.31579780578613281250000000000000000e+00), SC_(2.78372651434244356568937139750728234e+03) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-4.31579780578613281250000000000000000e+00), SC_(-9.99640898309098001450449637541475714e-01) }},
   {{ SC_(1.24884452819824218750000000000000000e+01), SC_(3.14159202575683593750000000000000000e+00), SC_(2.78372278373785565716151909511037612e+03) }},
   {{ SC_(8.00739824771881103515625000000000000e-02), SC_(-3.14159297943115234375000000000000000e+00), SC_(2.78373343731325050014842255243790302e+03) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(6.92906188964843750000000000000000000e+00), SC_(2.78372064753587423981919539072773780e+03) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-6.92906379699707031250000000000000000e+00), SC_(-9.99640898336611015638940574339779623e-01) }},
   {{ SC_(1.55961303710937500000000000000000000e+02), SC_(1.57079601287841796875000000000000000e+00), SC_(2.78372385372382579611621870845015674e+03) }},
   {{ SC_(6.41184672713279724121093750000000000e-03), SC_(-1.57079648971557617187500000000000000e+00), SC_(2.78373066931652341984666578517370570e+03) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(1.75646743774414062500000000000000000e+01), SC_(2.78371179613111808278634698517413229e+03) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-1.75646820068359375000000000000000000e+01), SC_(-9.99640897648333245043457314759459647e-01) }},
   {{ SC_(2.43239296875000000000000000000000000e+04), SC_(7.85398006439208984375000000000000000e-01), SC_(2.78372398250950407560541600740939423e+03) }},
   {{ SC_(4.11117653129622340202331542968750000e-05), SC_(-7.85398244857788085937500000000000000e-01), SC_(2.78373136831880847918111356580874845e+03) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-3.28355712890625000000000000000000000e+01), SC_(2.78375202998218131317737972970406555e+03) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(3.28355560302734375000000000000000000e+01), SC_(-9.99640900275778732629188786202355337e-01) }},
   {{ SC_(5.91653376000000000000000000000000000e+08), SC_(3.92699003219604492187500000000000000e-01), SC_(2.78372365084446820832342634753358740e+03) }},
   {{ SC_(1.69017821960437686357181519269943237e-09), SC_(-3.92699122428894042968750000000000000e-01), SC_(2.78373073913012427928396123197550440e+03) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-8.48593902587890625000000000000000000e+00), SC_(2.78373449540855544779158596008810417e+03) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(8.48593521118164062500000000000000000e+00), SC_(-9.99640898057858688660720825780972616e-01) }},
   {{ SC_(3.50053990836207616000000000000000000e+17), SC_(1.96349501609802246093750000000000000e-01), SC_(2.78372407805384343857988940018093529e+03) }},
   {{ SC_(2.85670215985699574930307964581999158e-18), SC_(-1.96349561214447021484375000000000000e-01), SC_(2.78373078777858240656739060662026466e+03) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-4.87260055541992187500000000000000000e+00), SC_(2.78373179442997071469055323839074857e+03) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(4.87260055541992187500000000000000000e+00), SC_(-9.99640898989985246283980963938815120e-01) }},
   {{ SC_(1.22537762183711852153029189523472384e+35), SC_(9.81747508049011230468750000000000000e-02), SC_(2.78372400149122574383349218869066307e+03) }},
   {{ SC_(8.16074612663576872338241958234341778e-36), SC_(-9.81747806072235107421875000000000000e-02), SC_(2.78373082474641324658309316028249444e+03) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-3.41744327545166015625000000000000000e+00), SC_(2.78373247324230312919142644286803849e+03) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(3.41744232177734375000000000000000000e+00), SC_(-9.99640898282655442907560267306143535e-01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-2.63155364990234375000000000000000000e+00), SC_(2.78373048579829648891848850624124107e+03) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(2.63155364990234375000000000000000000e+00), SC_(-9.99640898821232486062354647168014530e-01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-2.13953685760498046875000000000000000e+00), SC_(2.78373008060280799981683529676888898e+03) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(2.13953685760498046875000000000000000e+00), SC_(-9.99640898768981038584106615971477690e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-1.80252265930175781250000000000000000e+00), SC_(2.78373165969865935748236424845623944e+03) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(1.80252218246459960937500000000000000e+00), SC_(-9.99640898219109766087513573177614711e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-1.55723142623901367187500000000000000e+00), SC_(2.78372975458708281208846591391873405e+03) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(1.55723142623901367187500000000000000e+00), SC_(-9.99640898726940101558311770472752082e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-1.37070322036743164062500000000000000e+00), SC_(2.78372960746215156619982343096856055e+03) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(1.37070322036743164062500000000000000e+00), SC_(-9.99640898707967792732465843590740625e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-1.22408056259155273437500000000000000e+00), SC_(2.78373094775241602564491916994956052e+03) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(1.22408008575439453125000000000000000e+00), SC_(-9.99640897771232123746423969590103017e-01) }},
   {{ SC_(1.00543880462646484375000000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(6.15133197972914178798038360809382279e+03) }},
   {{ SC_(9.94590282440185546875000000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(6.15466760619350195870404283998540502e+03) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(1.18174171447753906250000000000000000e+00), SC_(6.15303510086243926148327888304291947e+03) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-1.18174171447753906250000000000000000e+00), SC_(-9.99837504989228960048844065439760309e-01) }},
   {{ SC_(1.01090717315673828125000000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(6.15125027962957719249475159965693915e+03) }},
   {{ SC_(9.89210128784179687500000000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(6.15317208973876714195939796162681368e+03) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(1.30418300628662109375000000000000000e+00), SC_(6.15303469222841371639087926453893020e+03) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-1.30418300628662109375000000000000000e+00), SC_(-9.99837504978439129684998814180126897e-01) }},
   {{ SC_(1.02193403244018554687500000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(6.15299282584328371332440481643062278e+03) }},
   {{ SC_(9.78536605834960937500000000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(6.15335684824856856344256302887055499e+03) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(1.45492935180664062500000000000000000e+00), SC_(6.15302776075858968643008047165381440e+03) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-1.45492982864379882812500000000000000e+00), SC_(-9.99837505260066807283695938268945248e-01) }},
   {{ SC_(1.04434919357299804687500000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(6.15302471279199607157833375167458708e+03) }},
   {{ SC_(9.57534074783325195312500000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(6.15311671491565992998113105651972231e+03) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(1.64507913589477539062500000000000000e+00), SC_(6.15303172926396010584025526945423180e+03) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-1.64507961273193359375000000000000000e+00), SC_(-9.99837505311146135537365654514365347e-01) }},
   {{ SC_(1.09066486358642578125000000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(6.15281226760996768518688735526341347e+03) }},
   {{ SC_(9.16871547698974609375000000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(6.15308747858226562797249345516442822e+03) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(1.89240360260009765625000000000000000e+00), SC_(6.15302544089694655245185491568810321e+03) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-1.89240407943725585937500000000000000e+00), SC_(-9.99837505091396671580249028875394431e-01) }},
   {{ SC_(1.18955039978027343750000000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(6.15295661930427792353897199324489944e+03) }},
   {{ SC_(8.40653419494628906250000000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(6.15309317675956568776498809304386116e+03) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(2.22725391387939453125000000000000000e+00), SC_(6.15303200574887266518064585793194533e+03) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-2.22725391387939453125000000000000000e+00), SC_(-9.99837504907503594975697003772547478e-01) }},
   {{ SC_(1.41503047943115234375000000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(6.15299223152987216463270650286911159e+03) }},
   {{ SC_(7.06698417663574218750000000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(6.15303934672273273181112573357180218e+03) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(2.70607852935791015625000000000000000e+00), SC_(6.15301832864932068652957846509066457e+03) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-2.70607948303222656250000000000000000e+00), SC_(-9.99837505046005458638905191776103605e-01) }},
   {{ SC_(2.00231170654296875000000000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(6.15300956604046499944584561918956423e+03) }},
   {{ SC_(4.99422550201416015625000000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(6.15305534655611160268494241611702395e+03) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(3.44716644287109375000000000000000000e+00), SC_(6.15302218805978137693193182044029721e+03) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-3.44716739654541015625000000000000000e+00), SC_(-9.99837505040496846023756992637314960e-01) }},
   {{ SC_(4.00925254821777343750000000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(6.15301321218589254021432841433525232e+03) }},
   {{ SC_(2.49422967433929443359375000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(6.15304235782169090498300522480107327e+03) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(4.74724960327148437500000000000000000e+00), SC_(6.15301642981894711127825665294077431e+03) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-4.74725151062011718750000000000000000e+00), SC_(-9.99837505065847925333143919465992344e-01) }},
   {{ SC_(1.60741119384765625000000000000000000e+01), SC_(3.14159202575683593750000000000000000e+00), SC_(6.15302036033426345750038919728747970e+03) }},
   {{ SC_(6.22118115425109863281250000000000000e-02), SC_(-3.14159297943115234375000000000000000e+00), SC_(6.15304395549594988242990601085744798e+03) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(7.62176513671875000000000000000000000e+00), SC_(6.15302003665578248903437769449086097e+03) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-7.62176704406738281250000000000000000e+00), SC_(-9.99837504946255066001106526423625569e-01) }},
   {{ SC_(2.58377197265625000000000000000000000e+02), SC_(1.57079601287841796875000000000000000e+00), SC_(6.15302494924787219568428152625705125e+03) }},
   {{ SC_(3.87030933052301406860351562500000000e-03), SC_(-1.57079648971557617187500000000000000e+00), SC_(6.15304436730630505103377716279470280e+03) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(1.93206329345703125000000000000000000e+01), SC_(6.15301397867359565611973532826246613e+03) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-1.93206329345703125000000000000000000e+01), SC_(-9.99837504431503495735003992248702999e-01) }},
   {{ SC_(6.67587812500000000000000000000000000e+04), SC_(7.85398006439208984375000000000000000e-01), SC_(6.15302532451050276126374044163526836e+03) }},
   {{ SC_(1.49792977026663720607757568359375000e-05), SC_(-7.85398244857788085937500000000000000e-01), SC_(6.15304327386256376939503561630514498e+03) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-3.61181640625000000000000000000000000e+01), SC_(6.15309238245101021725946073795971647e+03) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(3.61181488037109375000000000000000000e+01), SC_(-9.99837505902764342139767106877713084e-01) }},
   {{ SC_(4.45673676800000000000000000000000000e+09), SC_(3.92699003219604492187500000000000000e-01), SC_(6.15302635154624126599024346310343149e+03) }},
   {{ SC_(2.24379348434666781031410209834575653e-10), SC_(-3.92699122428894042968750000000000000e-01), SC_(6.15304339482048962433523657843916662e+03) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-9.33428573608398437500000000000000000e+00), SC_(6.15306145354830715971298419943038085e+03) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(9.33428192138671875000000000000000000e+00), SC_(-9.99837505105661150798421034121469610e-01) }},
   {{ SC_(1.98625016339129958400000000000000000e+19), SC_(1.96349501609802246093750000000000000e-01), SC_(6.15302629160345286692530625316186566e+03) }},
   {{ SC_(5.03461024137956777509573125933828308e-20), SC_(-1.96349561214447021484375000000000000e-01), SC_(6.15304314497684248885692797595568499e+03) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-5.35971832275390625000000000000000000e+00), SC_(6.15305137067863705891688313365018982e+03) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(5.35971641540527343750000000000000000e+00), SC_(-9.99837504914296928889722611290475716e-01) }},
   {{ SC_(2.53473031940315940983796271435646505e-39), SC_(-9.81747806072235107421875000000000000e-02), SC_(6.15304307558079615386025659341724467e+03) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-3.75908756256103515625000000000000000e+00), SC_(6.15304951714101054998374772552722784e+03) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(3.75908660888671875000000000000000000e+00), SC_(-9.99837505010204884019777155951586111e-01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-2.89463233947753906250000000000000000e+00), SC_(6.15305135072873284506935277133643273e+03) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(2.89463138580322265625000000000000000e+00), SC_(-9.99837504951204803202346820565793307e-01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-2.35342788696289062500000000000000000e+00), SC_(6.15304313685050499496885395601856496e+03) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(2.35342693328857421875000000000000000e+00), SC_(-9.99837504626905268523619401187811372e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-1.98272228240966796875000000000000000e+00), SC_(6.15305087795792126830331374127099162e+03) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(1.98272180557250976562500000000000000e+00), SC_(-9.99837505064853959600250478718621936e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-1.71290922164916992187500000000000000e+00), SC_(6.15305038015844482934957922523654045e+03) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(1.71290874481201171875000000000000000e+00), SC_(-9.99837504998002219986858093390788916e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-1.50773334503173828125000000000000000e+00), SC_(6.15303998224819376677228710748789827e+03) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(1.50773334503173828125000000000000000e+00), SC_(-9.99837505118120035349620028888664010e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-1.34645271301269531250000000000000000e+00), SC_(6.15304290789462796157287131655802120e+03) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(1.34645223617553710937500000000000000e+00), SC_(-9.99837504693284810711580958268992288e-01) }},
   {{ SC_(1.00598430633544921875000000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(1.47201462756327440435724808053764644e+04) }},
   {{ SC_(9.94050979614257812500000000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(1.47276454438598756678096169542798804e+04) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(1.29990053176879882812500000000000000e+00), SC_(1.47230313695800935205168140704998891e+04) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-1.29990100860595703125000000000000000e+00), SC_(-9.99932084056710341088349748954849864e-01) }},
   {{ SC_(1.01200437545776367187500000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(1.47195714508970309004113065337889203e+04) }},
   {{ SC_(9.88137722015380859375000000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(1.47231873796728127393626651591489942e+04) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(1.43458461761474609375000000000000000e+00), SC_(1.47230554825502579274511562300017139e+04) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-1.43458509445190429687500000000000000e+00), SC_(-9.99932084145486011144542995704648828e-01) }},
   {{ SC_(1.02415323257446289062500000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(1.47217484848821021294277672699488702e+04) }},
   {{ SC_(9.76416110992431640625000000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(1.47234704317273372416523434863490053e+04) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(1.60040378570556640625000000000000000e+00), SC_(1.47230475781249699099605479437330904e+04) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-1.60040426254272460937500000000000000e+00), SC_(-9.99932084086578762621966833322133456e-01) }},
   {{ SC_(1.04889011383056640625000000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(1.47225106070422905666126020567971307e+04) }},
   {{ SC_(9.53388452529907226562500000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(1.47233750246470216297264350686339259e+04) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(1.80956602096557617187500000000000000e+00), SC_(1.47230494918735792191439739855372452e+04) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-1.80956649780273437500000000000000000e+00), SC_(-9.99932084072958633420551479024388241e-01) }},
   {{ SC_(1.10017061233520507812500000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(1.47227009065044417550547378849355103e+04) }},
   {{ SC_(9.08949613571166992187500000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(1.47232575201671500112068536440289285e+04) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(2.08162021636962890625000000000000000e+00), SC_(1.47230630487640179370760010917109641e+04) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-2.08162021636962890625000000000000000e+00), SC_(-9.99932083963734185245654089830622437e-01) }},
   {{ SC_(1.21037578582763671875000000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(1.47229513505735052207238320511603078e+04) }},
   {{ SC_(8.26189517974853515625000000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(1.47231518456169371497041606655405260e+04) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(2.44995117187500000000000000000000000e+00), SC_(1.47230696503580433062790156384401476e+04) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-2.44995117187500000000000000000000000e+00), SC_(-9.99932083994184604856937185768503984e-01) }},
   {{ SC_(1.46500968933105468750000000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(1.47229883337667392719293723394104619e+04) }},
   {{ SC_(6.82589054107666015625000000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(1.47231873578705555546128233033262564e+04) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(2.97665214538574218750000000000000000e+00), SC_(1.47230310305239152269427914409806884e+04) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-2.97665309906005859375000000000000000e+00), SC_(-9.99932084024875906997480929401630461e-01) }},
   {{ SC_(2.14625358581542968750000000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(1.47230052292134654423587822761384613e+04) }},
   {{ SC_(4.65928077697753906250000000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(1.47230837454215403432284819702031082e+04) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(3.79183959960937500000000000000000000e+00), SC_(1.47230458645779394651579058909475465e+04) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-3.79184055328369140625000000000000000e+00), SC_(-9.99932084048404385363475078789251502e-01) }},
   {{ SC_(4.60640525817871093750000000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(1.47230213675389176001470297885177640e+04) }},
   {{ SC_(2.17088937759399414062500000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(1.47230990136945722346220273625579530e+04) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(5.22191429138183593750000000000000000e+00), SC_(1.47230203310770300326282343461929226e+04) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-5.22191619873046875000000000000000000e+00), SC_(-9.99932084004772556037714162780868111e-01) }},
   {{ SC_(2.12189788818359375000000000000000000e+01), SC_(3.14159202575683593750000000000000000e+00), SC_(1.47230420321176796021339403695979994e+04) }},
   {{ SC_(4.71276044845581054687500000000000000e-02), SC_(-3.14159297943115234375000000000000000e+00), SC_(1.47231013820722565292400612494288253e+04) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(8.38384628295898437500000000000000000e+00), SC_(1.47230534261022354688907584260987109e+04) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-8.38384628295898437500000000000000000e+00), SC_(-9.99932083919348782145090716938782335e-01) }},
   {{ SC_(4.50245117187500000000000000000000000e+02), SC_(1.57079601287841796875000000000000000e+00), SC_(1.47230447238179418591431913135180073e+04) }},
   {{ SC_(2.22101155668497085571289062500000000e-03), SC_(-1.57079648971557617187500000000000000e+00), SC_(1.47230966727414785329076643595889987e+04) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(2.12524490356445312500000000000000000e+01), SC_(1.47230012933314623444147748681215363e+04) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-2.12524566650390625000000000000000000e+01), SC_(-9.99932083912872397085102748295706699e-01) }},
   {{ SC_(2.02720687500000000000000000000000000e+05), SC_(7.85398006439208984375000000000000000e-01), SC_(1.47230459758918344999813716420722033e+04) }},
   {{ SC_(4.93289553560316562652587890625000000e-06), SC_(-7.85398244857788085937500000000000000e-01), SC_(1.47230891693384937499913818822350603e+04) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-3.97295227050781250000000000000000000e+01), SC_(1.47232230741909208260289463947021206e+04) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(3.97295074462890625000000000000000000e+01), SC_(-9.99932084451522331690130454966427969e-01) }},
   {{ SC_(4.10956759040000000000000000000000000e+10), SC_(3.92699003219604492187500000000000000e-01), SC_(1.47230458019214418648308216167390465e+04) }},
   {{ SC_(2.43334519200999466193025000393390656e-11), SC_(-3.92699122428894042968750000000000000e-01), SC_(1.47230907008226224375156771991577914e+04) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-1.02675933837890625000000000000000000e+01), SC_(1.47231055801174738400221606482680191e+04) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(1.02675933837890625000000000000000000e+01), SC_(-9.99932084159913228381953325008296969e-01) }},
   {{ SC_(1.68885492681351679180800000000000000e+21), SC_(1.96349501609802246093750000000000000e-01), SC_(1.47230463990251277987928751389897301e+04) }},
   {{ SC_(5.92117127436267897786088246128016754e-22), SC_(-1.96349561214447021484375000000000000e-01), SC_(1.47230895041545148439960597234222833e+04) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-5.89562225341796875000000000000000000e+00), SC_(1.47231158041356185814809810172253641e+04) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(5.89562034606933593750000000000000000e+00), SC_(-9.99932083996200393053200085759117688e-01) }},
   {{ SC_(3.50324616081204267730932395822479033e-43), SC_(-9.81747806072235107421875000000000000e-02), SC_(1.47242365127284988318646586260527495e+04) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-4.13494873046875000000000000000000000e+00), SC_(1.47231121244362155199172918217688497e+04) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(4.13494682312011718750000000000000000e+00), SC_(-9.99932083889437501587805791212314657e-01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-3.18405818939208984375000000000000000e+00), SC_(1.47230841395899808548951154600951678e+04) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(3.18405818939208984375000000000000000e+00), SC_(-9.99932084061017336265015348704299559e-01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-2.58874130249023437500000000000000000e+00), SC_(1.47231182680205613643081141011957103e+04) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(2.58874034881591796875000000000000000e+00), SC_(-9.99932083978316344368526816870834157e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-2.18096923828125000000000000000000000e+00), SC_(1.47231045613862494528233386014331811e+04) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(2.18096828460693359375000000000000000e+00), SC_(-9.99932083870198442480985210021494622e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-1.88417816162109375000000000000000000e+00), SC_(1.47230920808802399514735195991125240e+04) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(1.88417768478393554687500000000000000e+00), SC_(-9.99932083932691726082569951856218849e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-1.65848779678344726562500000000000000e+00), SC_(1.47231044521764983850946599962624923e+04) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(1.65848731994628906250000000000000000e+00), SC_(-9.99932083967307794030799575430517466e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-1.48108100891113281250000000000000000e+00), SC_(1.47231014164310859218065095356239038e+04) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(1.48108053207397460937500000000000000e+00), SC_(-9.99932083930857686283862413436952699e-01) }},
   {{ SC_(1.00658464431762695312500000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(3.84311780183484478350656441061241137e+04) }},
   {{ SC_(9.93458271026611328125000000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(3.84411695116832837868417608252632659e+04) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(1.42988443374633789062500000000000000e+00), SC_(3.84413283728798650649787277181880468e+04) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-1.42988443374633789062500000000000000e+00), SC_(-9.99973987007490798193511263730403289e-01) }},
   {{ SC_(1.01321268081665039062500000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(3.84322347764878215780441768460971231e+04) }},
   {{ SC_(9.86959218978881835937500000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(3.84448439317453331231793633987359050e+04) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(1.57803583145141601562500000000000000e+00), SC_(3.84412794789004839395082126973349783e+04) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-1.57803630828857421875000000000000000e+00), SC_(-9.99973987057386707679739065317733041e-01) }},
   {{ SC_(1.02660036087036132812500000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(3.84386229581152100018664363736855201e+04) }},
   {{ SC_(9.74088668823242187500000000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(3.84421634389820966661327715690249960e+04) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(1.76043605804443359375000000000000000e+00), SC_(3.84412520425351647752015410728329300e+04) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-1.76043653488159179687500000000000000e+00), SC_(-9.99973987030223420589417125828506518e-01) }},
   {{ SC_(1.05390834808349609375000000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(3.84389686885061552912561317352212930e+04) }},
   {{ SC_(9.48848724365234375000000000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(3.84422478706017077637478344444915655e+04) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(1.99051332473754882812500000000000000e+00), SC_(3.84412304912119556694244059633931085e+04) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-1.99051380157470703125000000000000000e+00), SC_(-9.99973987007042368158167402335902720e-01) }},
   {{ SC_(1.11072349548339843750000000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(3.84413670435850230801278531611960246e+04) }},
   {{ SC_(9.00314092636108398437500000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(3.84414283833064796504586412391271580e+04) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(2.28977108001708984375000000000000000e+00), SC_(3.84411875893268083096359816656691760e+04) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-2.28977203369140625000000000000000000e+00), SC_(-9.99973987026601870882892983065127971e-01) }},
   {{ SC_(1.23370647430419921875000000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(3.84410395139218924567478501503923280e+04) }},
   {{ SC_(8.10565471649169921875000000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(3.84414134837992082590460701360341005e+04) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(2.69493389129638671875000000000000000e+00), SC_(3.84413171673427304046837187292378034e+04) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-2.69493389129638671875000000000000000e+00), SC_(-9.99973986999908280410396845854298858e-01) }},
   {{ SC_(1.52203178405761718750000000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(3.84411152542413746763328971630433064e+04) }},
   {{ SC_(6.57016277313232421875000000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(3.84415701201664488323583978802978789e+04) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(3.27430248260498046875000000000000000e+00), SC_(3.84412292795919588805042467132603090e+04) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-3.27430343627929687500000000000000000e+00), SC_(-9.99973987020421671808713446052676161e-01) }},
   {{ SC_(2.31658077239990234375000000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(3.84411195746370812766267388130183753e+04) }},
   {{ SC_(4.31670546531677246093750000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(3.84413934398225408976086117485214501e+04) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(4.17100334167480468750000000000000000e+00), SC_(3.84411486764801473088675236733563863e+04) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-4.17100524902343750000000000000000000e+00), SC_(-9.99973987011473210956627685321681143e-01) }},
   {{ SC_(5.36654853820800781250000000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(3.84412124337491572732520402214380705e+04) }},
   {{ SC_(1.86339437961578369140625000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(3.84414229699752251233085279044468404e+04) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(5.74407958984375000000000000000000000e+00), SC_(3.84411963241235926778795613140969057e+04) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-5.74408149719238281250000000000000000e+00), SC_(-9.99973987009324264632356780966552760e-01) }},
   {{ SC_(2.87998504638671875000000000000000000e+01), SC_(3.14159202575683593750000000000000000e+00), SC_(3.84412428399071515694506120425562321e+04) }},
   {{ SC_(3.47224026918411254882812500000000000e-02), SC_(-3.14159297943115234375000000000000000e+00), SC_(3.84413653993073739463828655818868286e+04) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(9.22218704223632812500000000000000000e+00), SC_(3.84412070592317296284863615676421106e+04) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-9.22219085693359375000000000000000000e+00), SC_(-9.99973987038994105133118807032963350e-01) }},
   {{ SC_(8.29431396484375000000000000000000000e+02), SC_(1.57079601287841796875000000000000000e+00), SC_(3.84412435492439846912114230404207549e+04) }},
   {{ SC_(1.20564503595232963562011718750000000e-03), SC_(-1.57079648971557617187500000000000000e+00), SC_(3.84413760545640529816481731392163835e+04) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(2.33775863647460937500000000000000000e+01), SC_(3.84411203604913522176199721915557697e+04) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-2.33775939941406250000000000000000000e+01), SC_(-9.99973986956356013655805561849635156e-01) }},
   {{ SC_(6.87956500000000000000000000000000000e+05), SC_(7.85398006439208984375000000000000000e-01), SC_(3.84412461177835863176234473651991888e+04) }},
   {{ SC_(1.45358035297249443829059600830078125e-06), SC_(-7.85398244857788085937500000000000000e-01), SC_(3.84413677407756128493707750987472594e+04) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-4.37022705078125000000000000000000000e+01), SC_(3.84417260294608520744976932552328094e+04) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(4.37022552490234375000000000000000000e+01), SC_(-9.99973987180689921521882177577264684e-01) }},
   {{ SC_(4.73284083712000000000000000000000000e+11), SC_(3.92699003219604492187500000000000000e-01), SC_(3.84412441344348755123779473683444791e+04) }},
   {{ SC_(2.11289579582496500620436563622206450e-12), SC_(-3.92699122428894042968750000000000000e-01), SC_(3.84413680746012535212796602695407346e+04) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-1.12943038940429687500000000000000000e+01), SC_(3.84415328290832231928785158323900342e+04) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(1.12943000793457031250000000000000000e+01), SC_(-9.99973987053087912652705052768526805e-01) }},
   {{ SC_(2.23997804480738554281984000000000000e+23), SC_(1.96349501609802246093750000000000000e-01), SC_(3.84412434802235948567740251509689819e+04) }},
   {{ SC_(4.46432794571399177728049759047686609e-24), SC_(-1.96349561214447021484375000000000000e-01), SC_(3.84413692552657469060965210251067339e+04) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-6.48515510559082031250000000000000000e+00), SC_(3.84414785735846269550697880369568708e+04) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(6.48515319824218750000000000000000000e+00), SC_(-9.99973987028360167449860183289270353e-01) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-4.54842185974121093750000000000000000e+00), SC_(3.84413660542364595938618688290024545e+04) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(4.54842185974121093750000000000000000e+00), SC_(-9.99973987032988834538285638748393503e-01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-3.50244808197021484375000000000000000e+00), SC_(3.84413803649246064809354761697917712e+04) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(3.50244712829589843750000000000000000e+00), SC_(-9.99973986967897616726592024866687556e-01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-2.84760189056396484375000000000000000e+00), SC_(3.84413937901199978005856405398722780e+04) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(2.84760093688964843750000000000000000e+00), SC_(-9.99973986959786552019011316430680577e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-2.39905548095703125000000000000000000e+00), SC_(3.84414775590499168197356201141719700e+04) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(2.39905452728271484375000000000000000e+00), SC_(-9.99973986999275300398378902350929169e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-2.07258701324462890625000000000000000e+00), SC_(3.84414932334990152034057024905716488e+04) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(2.07258605957031250000000000000000000e+00), SC_(-9.99973986992686232439404811699454238e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-1.82432794570922851562500000000000000e+00), SC_(3.84413641444794906050753828325764548e+04) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(1.82432746887207031250000000000000000e+00), SC_(-9.99973986959917992458872734807193989e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-1.62918138504028320312500000000000000e+00), SC_(3.84413511334418339472640657154303727e+04) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(1.62918138504028320312500000000000000e+00), SC_(-9.99973987022892310081963466269656806e-01) }},
   {{ SC_(1.00724554061889648437500000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(1.10457843567232475472606185245587243e+05) }},
   {{ SC_(9.92806434631347656250000000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(1.10484179804918967413494007572860510e+05) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(1.57286977767944335937500000000000000e+00), SC_(1.10478249260347188690213372382762269e+05) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-1.57287025451660156250000000000000000e+00), SC_(-9.99990948558338452834007646666672609e-01) }},
   {{ SC_(1.01454353332519531250000000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(1.10453835763810897689965612276817565e+05) }},
   {{ SC_(9.85664606094360351562500000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(1.10485130983835459780972516966824470e+05) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(1.73583650588989257812500000000000000e+00), SC_(1.10478473014219121337775497392224084e+05) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-1.73583698272705078125000000000000000e+00), SC_(-9.99990948573678659021471966387932542e-01) }},
   {{ SC_(1.02929878234863281250000000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(1.10462524228008177162645980295804095e+05) }},
   {{ SC_(9.71534729003906250000000000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(1.10484522913494870069193676536578338e+05) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(1.93647670745849609375000000000000000e+00), SC_(1.10478577432902321150323746380507185e+05) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-1.93647670745849609375000000000000000e+00), SC_(-9.99990948553359490073540425006850398e-01) }},
   {{ SC_(1.05945634841918945312500000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(1.10470177771879979027326963926222091e+05) }},
   {{ SC_(9.43879842758178710937500000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(1.10481861169405741248566683558161011e+05) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(2.18956089019775390625000000000000000e+00), SC_(1.10478260722106227999422618426321843e+05) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-2.18956184387207031250000000000000000e+00), SC_(-9.99990948573193218190668497311555206e-01) }},
   {{ SC_(1.12244844436645507812500000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(1.10477006599469062003712243995748193e+05) }},
   {{ SC_(8.90909433364868164062500000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(1.10478422833573329215242616768182667e+05) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(2.51874446868896484375000000000000000e+00), SC_(1.10478437856749502186726180722470928e+05) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-2.51874542236328125000000000000000000e+00), SC_(-9.99990948581722295982972568992395769e-01) }},
   {{ SC_(1.25989055633544921875000000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(1.10477209683792381640857233591378187e+05) }},
   {{ SC_(7.93719530105590820312500000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(1.10479041001298823943062561123757450e+05) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(2.96442222595214843750000000000000000e+00), SC_(1.10478554484333942289569097605350080e+05) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-2.96442222595214843750000000000000000e+00), SC_(-9.99990948551479343623576183073665656e-01) }},
   {{ SC_(1.58732461929321289062500000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(1.10477918742570051739447847609013770e+05) }},
   {{ SC_(6.29990577697753906250000000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(1.10479546862589623025812419175858822e+05) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(3.60172653198242187500000000000000000e+00), SC_(1.10478256065519633862449982971293033e+05) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-3.60172748565673828125000000000000000e+00), SC_(-9.99990948554861716408446573445907477e-01) }},
   {{ SC_(2.51959991455078125000000000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(1.10478176359035816064670860235338702e+05) }},
   {{ SC_(3.96888256072998046875000000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(1.10479098814012979560391423546400814e+05) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(4.58809661865234375000000000000000000e+00), SC_(1.10478235950964000240824372800217087e+05) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-4.58809852600097656250000000000000000e+00), SC_(-9.99990948569078534878308461226621160e-01) }},
   {{ SC_(6.34838485717773437500000000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(1.10478299674942920472141046362196146e+05) }},
   {{ SC_(1.57520353794097900390625000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(1.10478808027088530727417202183080733e+05) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(6.31847763061523437500000000000000000e+00), SC_(1.10478346084732907378387608602318036e+05) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-6.31847953796386718750000000000000000e+00), SC_(-9.99990948566135001730243192115715982e-01) }},
   {{ SC_(4.03019866943359375000000000000000000e+01), SC_(3.14159202575683593750000000000000000e+00), SC_(1.10478268667361133336618044101083637e+05) }},
   {{ SC_(2.48126611113548278808593750000000000e-02), SC_(-3.14159297943115234375000000000000000e+00), SC_(1.10478818491086369360481468817369829e+05) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(1.01443901062011718750000000000000000e+01), SC_(1.10478415881631347935688246993284539e+05) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-1.01443901062011718750000000000000000e+01), SC_(-9.99990948540123787320664679319357197e-01) }},
   {{ SC_(1.62425097656250000000000000000000000e+03), SC_(1.57079601287841796875000000000000000e+00), SC_(1.10478358955604649453529514530041907e+05) }},
   {{ SC_(6.15668250247836112976074218750000000e-04), SC_(-1.57079648971557617187500000000000000e+00), SC_(1.10478790635976015737580027268952357e+05) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(2.57153015136718750000000000000000000e+01), SC_(1.10477950191833754595690133905206310e+05) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-2.57153091430664062500000000000000000e+01), SC_(-9.99990948533155243956147550824584045e-01) }},
   {{ SC_(2.63819100000000000000000000000000000e+06), SC_(7.85398006439208984375000000000000000e-01), SC_(1.10478351230905773089568920949850095e+05) }},
   {{ SC_(3.79047605747473426163196563720703125e-07), SC_(-7.85398244857788085937500000000000000e-01), SC_(1.10478742246419189460627524727156458e+05) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-4.80724182128906250000000000000000000e+01), SC_(1.10479916938278243718690445541052943e+05) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(4.80724029541015625000000000000000000e+01), SC_(-9.99990948629738926929219992375624560e-01) }},
   {{ SC_(6.96005112627200000000000000000000000e+12), SC_(3.92699003219604492187500000000000000e-01), SC_(1.10478347327463489559296740322627872e+05) }},
   {{ SC_(1.43677062434954816438903435482643545e-13), SC_(-3.92699122428894042968750000000000000e-01), SC_(1.10478749791875807928622500351959107e+05) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-1.24237098693847656250000000000000000e+01), SC_(1.10478902590751173835714589399406871e+05) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(1.24237098693847656250000000000000000e+01), SC_(-9.99990948579999167061085663557070853e-01) }},
   {{ SC_(4.84423120824379262453678080000000000e+25), SC_(1.96349501609802246093750000000000000e-01), SC_(1.10478347507532645872346064545590272e+05) }},
   {{ SC_(2.06431032200739201378107362493318545e-26), SC_(-1.96349561214447021484375000000000000e-01), SC_(1.10478744590061952871258105936440052e+05) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-7.13365745544433593750000000000000000e+00), SC_(1.10478885340937504271964675633028256e+05) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(7.13365554809570312500000000000000000e+00), SC_(-9.99990948550482166516033157184516527e-01) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-5.00325584411621093750000000000000000e+00), SC_(1.10478793439094305143945362842554463e+05) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(5.00325393676757812500000000000000000e+00), SC_(-9.99990948530986083718540260501341387e-01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-3.85268688201904296875000000000000000e+00), SC_(1.10478941037102086432627516128964090e+05) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(3.85268592834472656250000000000000000e+00), SC_(-9.99990948557130484122998882985440404e-01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-3.13235664367675781250000000000000000e+00), SC_(1.10478757746093190768027686849443397e+05) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(3.13235569000244140625000000000000000e+00), SC_(-9.99990948536130375821818198379768794e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-2.63895606994628906250000000000000000e+00), SC_(1.10478838105776306794403662743306763e+05) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(2.63895511627197265625000000000000000e+00), SC_(-9.99990948536730788985200169251456773e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-2.27984142303466796875000000000000000e+00), SC_(1.10478883564068102839723635422997357e+05) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(2.27984046936035156250000000000000000e+00), SC_(-9.99990948534471775039319816197644525e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-2.00675773620605468750000000000000000e+00), SC_(1.10478969932268719653693500494445648e+05) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(2.00675678253173828125000000000000000e+00), SC_(-9.99990948535564450005984600633225505e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-1.79209661483764648437500000000000000e+00), SC_(1.10478767025336175090224924511828567e+05) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(1.79209613800048828125000000000000000e+00), SC_(-9.99990948540924896740571325356127549e-01) }},
   {{ SC_(1.00797271728515625000000000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(3.52646959857751236437116884062175926e+05) }},
   {{ SC_(9.92089986801147460937500000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(3.52852711676772672677205052842823758e+05) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(1.73015594482421875000000000000000000e+00), SC_(3.52862052439164188459083314557481216e+05) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-1.73015642166137695312500000000000000e+00), SC_(-9.99997166049342431604807332719301374e-01) }},
   {{ SC_(1.01600980758666992187500000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(3.52872805194655866403557066114461788e+05) }},
   {{ SC_(9.84242439270019531250000000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(3.52882306918711953666307993612770085e+05) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(1.90941905975341796875000000000000000e+00), SC_(3.52862361446272908792936124493533852e+05) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-1.90941953659057617187500000000000000e+00), SC_(-9.99997166050887487668133352860862847e-01) }},
   {{ SC_(1.03227567672729492187500000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(3.52838113490675088539682938689438614e+05) }},
   {{ SC_(9.68733310699462890625000000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(3.52863053845092709536299254599100125e+05) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(2.13012313842773437500000000000000000e+00), SC_(3.52862693844921238933010916776476094e+05) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-2.13012313842773437500000000000000000e+00), SC_(-9.99997166044516783054747320407965498e-01) }},
   {{ SC_(1.06559324264526367187500000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(3.52849423698460743202273671563940231e+05) }},
   {{ SC_(9.38444137573242187500000000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(3.52869834244391696483665123337759003e+05) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(2.40851593017578125000000000000000000e+00), SC_(3.52862241321180321055120008383020358e+05) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-2.40851688385009765625000000000000000e+00), SC_(-9.99997166055216323023994472326003132e-01) }},
   {{ SC_(1.13548898696899414062500000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(3.52850304589978924513728118559672972e+05) }},
   {{ SC_(8.80677461624145507812500000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(3.52867325619041563254022689028694568e+05) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(2.77061748504638671875000000000000000e+00), SC_(3.52862499634166150370340986272068861e+05) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-2.77061843872070312500000000000000000e+00), SC_(-9.99997166055417565714749287490922712e-01) }},
   {{ SC_(1.28933572769165039062500000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(3.52857019887285054211412479308365278e+05) }},
   {{ SC_(7.75592803955078125000000000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(3.52867038787537069031129724056555342e+05) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(3.26086235046386718750000000000000000e+00), SC_(3.52862336497247667981240923688135257e+05) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-3.26086330413818359375000000000000000e+00), SC_(-9.99997166052234024536857676634363949e-01) }},
   {{ SC_(1.66238737106323242187500000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(3.52861033508846116494954321558415866e+05) }},
   {{ SC_(6.01544380187988281250000000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(3.52864346127969134777886884353220991e+05) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(3.96189785003662109375000000000000000e+00), SC_(3.52862669208465850203388323916322831e+05) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-3.96189785003662109375000000000000000e+00), SC_(-9.99997166044318920186086074579192329e-01) }},
   {{ SC_(2.76353168487548828125000000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(3.52860894563766828677757282571031959e+05) }},
   {{ SC_(3.61855626106262207031250000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(3.52864532752625198654306862196113467e+05) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(5.04690361022949218750000000000000000e+00), SC_(3.52861732673058397147308010267646583e+05) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-5.04690551757812500000000000000000000e+00), SC_(-9.99997166050478351499137613794359310e-01) }},
   {{ SC_(7.63710975646972656250000000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(3.52861586409103589324025150721452959e+05) }},
   {{ SC_(1.30939543247222900390625000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(3.52863701331182348519158138479624919e+05) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(6.95032119750976562500000000000000000e+00), SC_(3.52861783162385080827852114838553821e+05) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-6.95032310485839843750000000000000000e+00), SC_(-9.99997166047137155794136291969910490e-01) }},
   {{ SC_(5.83254699707031250000000000000000000e+01), SC_(3.14159202575683593750000000000000000e+00), SC_(3.52862052792064649370791621723673886e+05) }},
   {{ SC_(1.71451643109321594238281250000000000e-02), SC_(-3.14159297943115234375000000000000000e+00), SC_(3.52863680308508739277824259290344521e+05) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(1.11588211059570312500000000000000000e+01), SC_(3.52861513823929078886116218472807171e+05) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-1.11588249206542968750000000000000000e+01), SC_(-9.99997166047414967666392408282706729e-01) }},
   {{ SC_(3.40186035156250000000000000000000000e+03), SC_(1.57079601287841796875000000000000000e+00), SC_(3.52862037192698592394682088420346936e+05) }},
   {{ SC_(2.93956720270216464996337890625000000e-04), SC_(-1.57079648971557617187500000000000000e+00), SC_(3.52863565247934330977590381283441965e+05) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(2.82868118286132812500000000000000000e+01), SC_(3.52859952690131139690727374175566874e+05) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-2.82868194580078125000000000000000000e+01), SC_(-9.99997166032265454443885556872127110e-01) }},
   {{ SC_(1.15726520000000000000000000000000000e+07), SC_(7.85398006439208984375000000000000000e-01), SC_(3.52861992852825202654380224461667000e+05) }},
   {{ SC_(8.64106084463855950161814689636230469e-08), SC_(-7.85398244857788085937500000000000000e-01), SC_(3.52863388675588847071428031148132537e+05) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-5.28796234130859375000000000000000000e+01), SC_(3.52866901807261548341532016024827106e+05) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(5.28796081542968750000000000000000000e+01), SC_(-9.99997166067865993026800921710594291e-01) }},
   {{ SC_(1.33926274203648000000000000000000000e+14), SC_(3.92699003219604492187500000000000000e-01), SC_(3.52861992739574814801286047238201585e+05) }},
   {{ SC_(7.46679194169042048656592669431120157e-15), SC_(-3.92699122428894042968750000000000000e-01), SC_(3.52863412993838826526168043682578645e+05) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-1.36660728454589843750000000000000000e+01), SC_(3.52863817453625965177819033194711160e+05) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(1.36660728454589843750000000000000000e+01), SC_(-9.99997166053540797046076198077645231e-01) }},
   {{ SC_(1.79362515345448600987542487040000000e+28), SC_(1.96349501609802246093750000000000000e-01), SC_(3.52862010556725072536159141099682954e+05) }},
   {{ SC_(5.57529996622126406562244462684383093e-29), SC_(-1.96349561214447021484375000000000000e-01), SC_(3.52863390921181348818478457466947982e+05) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-7.84701919555664062500000000000000000e+00), SC_(3.52864098271342999678605751254456505e+05) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(7.84701728820800781250000000000000000e+00), SC_(-9.99997166046997001233435452757666753e-01) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-5.50357818603515625000000000000000000e+00), SC_(3.52863420561510315476079743096322707e+05) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(5.50357818603515625000000000000000000e+00), SC_(-9.99997166050353252651429657964497863e-01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-4.23795318603515625000000000000000000e+00), SC_(3.52864058933748490186648949474166458e+05) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(4.23795127868652343750000000000000000e+00), SC_(-9.99997166039187672470891691718061240e-01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-3.44559097290039062500000000000000000e+00), SC_(3.52864204163243489725467585341095156e+05) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(3.44559001922607421875000000000000000e+00), SC_(-9.99997166046626969288793556494245507e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-2.90285015106201171875000000000000000e+00), SC_(3.52863863767328785755720426601570976e+05) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(2.90284919738769531250000000000000000e+00), SC_(-9.99997166042019807916882957772301123e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-2.50782394409179687500000000000000000e+00), SC_(3.52863478857867352126143512665240115e+05) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(2.50782299041748046875000000000000000e+00), SC_(-9.99997166037055134505336873417169421e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-2.20743179321289062500000000000000000e+00), SC_(3.52863191026815621335331565065950911e+05) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(2.20743179321289062500000000000000000e+00), SC_(-9.99997166048509796207034348814140397e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-1.97130537033081054687500000000000000e+00), SC_(3.52863911797237978801146197982671133e+05) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(1.97130489349365234375000000000000000e+00), SC_(-9.99997166045542007896527673654244289e-01) }},
   {{ SC_(1.00877380371093750000000000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(1.26561498873937441999253677335524646e+06) }},
   {{ SC_(9.91302251815795898437500000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(1.26614329228329119810043714769701428e+06) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(1.90317153930664062500000000000000000e+00), SC_(1.26580399562848112030514577141734649e+06) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-1.90317153930664062500000000000000000e+00), SC_(-9.99999209988897615708225799806479608e-01) }},
   {{ SC_(1.01762437820434570312500000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(1.26540610679689611363277157222961090e+06) }},
   {{ SC_(9.82680320739746093750000000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(1.26597099297022941846856962180194933e+06) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(2.10036087036132812500000000000000000e+00), SC_(1.26580440737680882722186934358874367e+06) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-2.10036087036132812500000000000000000e+00), SC_(-9.99999209989154594978800046809695736e-01) }},
   {{ SC_(1.03556013107299804687500000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(1.26577762134420985124680636383032097e+06) }},
   {{ SC_(9.65660810470581054687500000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(1.26586677291129927989161356119580755e+06) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(2.34313488006591796875000000000000000e+00), SC_(1.26580218314278004348168277510112657e+06) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-2.34313583374023437500000000000000000e+00), SC_(-9.99999209992284442209397040459447609e-01) }},
   {{ SC_(1.07238483428955078125000000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(1.26578930274222623149292689768383739e+06) }},
   {{ SC_(9.32500839233398437500000000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(1.26585630437904238307124207487082283e+06) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(2.64936733245849609375000000000000000e+00), SC_(1.26580346048244926745686689158687089e+06) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-2.64936733245849609375000000000000000e+00), SC_(-9.99999209988563621541070224491636343e-01) }},
   {{ SC_(1.15000915527343750000000000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(1.26578072270910679571314361850437266e+06) }},
   {{ SC_(8.69558095932006835937500000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(1.26581521629695168123246532045829447e+06) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(3.04767894744873046875000000000000000e+00), SC_(1.26580409056470199036713662145359199e+06) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-3.04767894744873046875000000000000000e+00), SC_(-9.99999209988956867064587699822290298e-01) }},
   {{ SC_(1.32252120971679687500000000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(1.26578805954264467339974784263830274e+06) }},
   {{ SC_(7.56131410598754882812500000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(1.26580441193221153948551844910819395e+06) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(3.58694744110107421875000000000000000e+00), SC_(1.26579944189670248325438216955764658e+06) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-3.58694839477539062500000000000000000e+00), SC_(-9.99999209989006906485730121500777684e-01) }},
   {{ SC_(1.74906301498413085937500000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(1.26580015188985208046081025783283378e+06) }},
   {{ SC_(5.71734666824340820312500000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(1.26580681960147465973925639120224569e+06) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(4.35808563232421875000000000000000000e+00), SC_(1.26579825596104506687435484274798341e+06) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-4.35808753967285156250000000000000000e+00), SC_(-9.99999209990173646380647345996900261e-01) }},
   {{ SC_(3.05922126770019531250000000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(1.26579930600311307399222953030203708e+06) }},
   {{ SC_(3.26880455017089843750000000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(1.26581043185659041363523708429639274e+06) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(5.55159378051757812500000000000000000e+00), SC_(1.26580212277012521355792638710852920e+06) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-5.55159568786621093750000000000000000e+00), SC_(-9.99999209991542541011959496571974248e-01) }},
   {{ SC_(9.35883712768554687500000000000000000e+00), SC_(6.28318405151367187500000000000000000e+00), SC_(1.26580131405769049907427377819744275e+06) }},
   {{ SC_(1.06850862503051757812500000000000000e-01), SC_(-6.28318595886230468750000000000000000e+00), SC_(1.26580815188241816862285985170810236e+06) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(7.64535331726074218750000000000000000e+00), SC_(1.26580293307159248190583478074128476e+06) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-7.64535331726074218750000000000000000e+00), SC_(-9.99999209988234454758091694280049600e-01) }},
   {{ SC_(8.75877990722656250000000000000000000e+01), SC_(3.14159202575683593750000000000000000e+00), SC_(1.26579980171574785105318368652631238e+06) }},
   {{ SC_(1.14171095192432403564453125000000000e-02), SC_(-3.14159297943115234375000000000000000e+00), SC_(1.26580721089792982821292526015520421e+06) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(1.22747001647949218750000000000000000e+01), SC_(1.26579744827558720587759601372948298e+06) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-1.22747039794921875000000000000000000e+01), SC_(-9.99999209988261105361824326305745015e-01) }},
   {{ SC_(7.67162695312500000000000000000000000e+03), SC_(1.57079601287841796875000000000000000e+00), SC_(1.26580094386137720826070405291776105e+06) }},
   {{ SC_(1.30350410472601652145385742187500000e-04), SC_(-1.57079648971557617187500000000000000e+00), SC_(1.26580689517353861307469582100340777e+06) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(3.11154937744140625000000000000000000e+01), SC_(1.26579614619847673558437010366923202e+06) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-3.11154937744140625000000000000000000e+01), SC_(-9.99999209983998618369295180606517101e-01) }},
   {{ SC_(5.88538560000000000000000000000000000e+07), SC_(7.85398006439208984375000000000000000e-01), SC_(1.26580087447056939152172109276871525e+06) }},
   {{ SC_(1.69912368619407061487436294555664063e-08), SC_(-7.85398244857788085937500000000000000e-01), SC_(1.26580646503084322145531074339781829e+06) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-5.81675720214843750000000000000000000e+01), SC_(1.26581893186145826460757138355060962e+06) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(5.81675720214843750000000000000000000e+01), SC_(-9.99999209998219470723093624319271163e-01) }},
   {{ SC_(3.46377623384883200000000000000000000e+15), SC_(3.92699003219604492187500000000000000e-01), SC_(1.26580085549597367757446672340411536e+06) }},
   {{ SC_(2.88702180346563693630335123430086242e-16), SC_(-3.92699122428894042968750000000000000e-01), SC_(1.26580637851488038159017023229515526e+06) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-1.50326805114746093750000000000000000e+01), SC_(1.26581141166012213491088511604683518e+06) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(1.50326766967773437500000000000000000e+01), SC_(-9.99999209990709178143548678653040297e-01) }},
   {{ SC_(1.19977473473047427770532013015040000e+31), SC_(1.96349501609802246093750000000000000e-01), SC_(1.26580088758698213456691224749510656e+06) }},
   {{ SC_(8.33489676724556740047769297905504520e-32), SC_(-1.96349561214447021484375000000000000e-01), SC_(1.26580632264665423985619956127281556e+06) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-8.63172149658203125000000000000000000e+00), SC_(1.26581285445789235598054722098025623e+06) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(8.63171768188476562500000000000000000e+00), SC_(-9.99999209989520744370542811828563285e-01) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-6.05393600463867187500000000000000000e+00), SC_(1.26580939419335358503160913295285423e+06) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(6.05393409729003906250000000000000000e+00), SC_(-9.99999209988769593653780200370234456e-01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-4.66174697875976562500000000000000000e+00), SC_(1.26580609143425466432451926248232698e+06) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(4.66174697875976562500000000000000000e+00), SC_(-9.99999209990205642690176762263112534e-01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-3.79014873504638671875000000000000000e+00), SC_(1.26580622077731411722945746106616649e+06) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(3.79014778137207031250000000000000000e+00), SC_(-9.99999209987493238104162365487986205e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-3.19313430786132812500000000000000000e+00), SC_(1.26580636218843024375459464636694846e+06) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(3.19313335418701171875000000000000000e+00), SC_(-9.99999209987059267908312566907309107e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-2.75860595703125000000000000000000000e+00), SC_(1.26580716469505335563178871422496750e+06) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(2.75860500335693359375000000000000000e+00), SC_(-9.99999209987037898920770627646859728e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-2.42817497253417968750000000000000000e+00), SC_(1.26580848845700389710612309786774586e+06) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(2.42817401885986328125000000000000000e+00), SC_(-9.99999209987341853828691196637370958e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-2.16843509674072265625000000000000000e+00), SC_(1.26580468361732231637607177756988178e+06) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(2.16843509674072265625000000000000000e+00), SC_(-9.99999209989327001379261952111125821e-01) }},
   {{ SC_(1.00965547561645507812500000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(5.15916755075052943902357237679883432e+06) }},
   {{ SC_(9.90436792373657226562500000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(5.15976711017947857196266082611074200e+06) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(2.09348869323730468750000000000000000e+00), SC_(5.15944992404194926647176286206540690e+06) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-2.09348869323730468750000000000000000e+00), SC_(-9.99999806180926086492719972019258791e-01) }},
   {{ SC_(1.01940393447875976562500000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(5.15817057963272857272421407332584151e+06) }},
   {{ SC_(9.80965137481689453125000000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(5.15935343209231340335401123306441076e+06) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(2.31039619445800781250000000000000000e+00), SC_(5.15942543641820020168812473109407911e+06) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-2.31039714813232421875000000000000000e+00), SC_(-9.99999806181242750315748267986582342e-01) }},
   {{ SC_(1.03918504714965820312500000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(5.15949913327715650893349484568597715e+06) }},
   {{ SC_(9.62292432785034179687500000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(5.15971601762320123248729447543879260e+06) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(2.57744789123535156250000000000000000e+00), SC_(5.15942704424282578197861862649999700e+06) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-2.57744884490966796875000000000000000e+00), SC_(-9.99999806181175028449898871002027077e-01) }},
   {{ SC_(1.07990550994873046875000000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(5.15944892123551794117539258319720392e+06) }},
   {{ SC_(9.26006793975830078125000000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(5.15964008242513655950509980335438419e+06) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(2.91430377960205078125000000000000000e+00), SC_(5.15943969583109682957000693995296864e+06) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-2.91430473327636718750000000000000000e+00), SC_(-9.99999806181522175161464196018879963e-01) }},
   {{ SC_(1.16619586944580078125000000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(5.15943069838886288833205916667445373e+06) }},
   {{ SC_(8.57488870620727539062500000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(5.15946579176254761141196848139906816e+06) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(3.35244655609130859375000000000000000e+00), SC_(5.15944354405434619214674297124436610e+06) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-3.35244655609130859375000000000000000e+00), SC_(-9.99999806180686416644880921846545050e-01) }},
   {{ SC_(1.36001253128051757812500000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(5.15937832899991572842401966734215154e+06) }},
   {{ SC_(7.35287189483642578125000000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(5.15945653481606831396956406056947836e+06) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(3.94564247131347656250000000000000000e+00), SC_(5.15943528927056129169852203501495492e+06) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-3.94564342498779296875000000000000000e+00), SC_(-9.99999806181100396453942039385737703e-01) }},
   {{ SC_(1.84963464736938476562500000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(5.15941773744155140626099440898197248e+06) }},
   {{ SC_(5.40647268295288085937500000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(5.15945239113438789403705488880348458e+06) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(4.79389381408691406250000000000000000e+00), SC_(5.15941784383091774847003493226169539e+06) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-4.79389572143554687500000000000000000e+00), SC_(-9.99999806180912876260922308094894331e-01) }},
   {{ SC_(3.42114830017089843750000000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(5.15941719584476121168259115457659003e+06) }},
   {{ SC_(2.92299389839172363281250000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(5.15946988682807419975960764846420849e+06) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(6.10675239562988281250000000000000000e+00), SC_(5.15943156387910933417340030794264636e+06) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-6.10675430297851562500000000000000000e+00), SC_(-9.99999806181172040641566992906464111e-01) }},
   {{ SC_(1.17042579650878906250000000000000000e+01), SC_(6.28318405151367187500000000000000000e+00), SC_(5.15942349233579262862587835210041796e+06) }},
   {{ SC_(8.54389667510986328125000000000000000e-02), SC_(-6.28318595886230468750000000000000000e+00), SC_(5.15945719469979963871801627103633096e+06) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(8.40988540649414062500000000000000000e+00), SC_(5.15941441332695787134656386429962966e+06) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-8.40988922119140625000000000000000000e+00), SC_(-9.99999806180950946942385885697920542e-01) }},
   {{ SC_(1.36989685058593750000000000000000000e+02), SC_(3.14159202575683593750000000000000000e+00), SC_(5.15942710649562212842917925475907648e+06) }},
   {{ SC_(7.29981623589992523193359375000000000e-03), SC_(-3.14159297943115234375000000000000000e+00), SC_(5.15945897904792187128151118114325869e+06) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(1.35021705627441406250000000000000000e+01), SC_(5.15942282118402858446939594305951772e+06) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-1.35021743774414062500000000000000000e+01), SC_(-9.99999806180754310886629409409354638e-01) }},
   {{ SC_(1.87661875000000000000000000000000000e+04), SC_(1.57079601287841796875000000000000000e+00), SC_(5.15943301763696840951908447105541638e+06) }},
   {{ SC_(5.32873236807063221931457519531250000e-05), SC_(-1.57079648971557617187500000000000000e+00), SC_(5.15945797482930503719374095158864200e+06) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(3.42270355224609375000000000000000000e+01), SC_(5.15939695443542475536474606406967406e+06) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-3.42270507812500000000000000000000000e+01), SC_(-9.99999806180271757895232944001180287e-01) }},
   {{ SC_(3.52169728000000000000000000000000000e+08), SC_(7.85398006439208984375000000000000000e-01), SC_(5.15943226643933433861373751987958770e+06) }},
   {{ SC_(2.83953927038282927242107689380645752e-09), SC_(-7.85398244857788085937500000000000000e-01), SC_(5.15945739639310595461471012894523552e+06) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-6.39843292236328125000000000000000000e+01), SC_(5.15951689256193821796298506117882054e+06) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(6.39843292236328125000000000000000000e+01), SC_(-9.99999806183441782105352438747365413e-01) }},
   {{ SC_(1.24023537223598080000000000000000000e+17), SC_(3.92699003219604492187500000000000000e-01), SC_(5.15943259160013618126661705298305510e+06) }},
   {{ SC_(8.06298272553003980613745005356918227e-18), SC_(-3.92699122428894042968750000000000000e-01), SC_(5.15945753271983888597773763615747740e+06) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-1.65359497070312500000000000000000000e+01), SC_(5.15948869382912898609509959065709820e+06) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(1.65359420776367187500000000000000000e+01), SC_(-9.99999806181000321217869223345087142e-01) }},
   {{ SC_(1.53818357912545212279572833784299520e+34), SC_(1.96349501609802246093750000000000000e-01), SC_(5.15943246026163557466192161399680395e+06) }},
   {{ SC_(6.50117252626843485315381348240379726e-35), SC_(-1.96349561214447021484375000000000000e-01), SC_(5.15945698996709304398278384693716697e+06) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-9.49489212036132812500000000000000000e+00), SC_(5.15947682800827957105981815806717350e+06) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(9.49488830566406250000000000000000000e+00), SC_(-9.99999806180733178045475340968078238e-01) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-6.65932846069335937500000000000000000e+00), SC_(5.15946042471151665956529700112713915e+06) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(6.65932655334472656250000000000000000e+00), SC_(-9.99999806180462521095968885414639657e-01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-5.12792205810546875000000000000000000e+00), SC_(5.15946525324526626304948889895721358e+06) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(5.12792015075683593750000000000000000e+00), SC_(-9.99999806180387665314982042616169014e-01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-4.16916465759277343750000000000000000e+00), SC_(5.15947996654357147183735145500310503e+06) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(4.16916275024414062500000000000000000e+00), SC_(-9.99999806180684137766726658805881446e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-3.51244735717773437500000000000000000e+00), SC_(5.15945187395346112503855405311741676e+06) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(3.51244735717773437500000000000000000e+00), SC_(-9.99999806180999336516060552154141436e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-3.03446674346923828125000000000000000e+00), SC_(5.15946914551022473318708818773675715e+06) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(3.03446578979492187500000000000000000e+00), SC_(-9.99999806180706654020488606324696792e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-2.67099189758300781250000000000000000e+00), SC_(5.15945298419330279536317034902195475e+06) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(2.67099189758300781250000000000000000e+00), SC_(-9.99999806181041043560501413061800707e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-2.38527870178222656250000000000000000e+00), SC_(5.15945619711743728306284119858426989e+06) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(2.38527774810791015625000000000000000e+00), SC_(-9.99999806179963992764290474985012108e-01) }},
   {{ SC_(1.01062583923339843750000000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(2.41898167723368700898268506422364085e+07) }},
   {{ SC_(9.89485502243041992187500000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(2.42048830259873328340581551132627766e+07) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(2.30283737182617187500000000000000000e+00), SC_(2.42026658554376100355751975168439376e+07) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-2.30283737182617187500000000000000000e+00), SC_(-9.99999958682239194011376924197892612e-01) }},
   {{ SC_(1.02136516571044921875000000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(2.42008437651921927052137304046690917e+07) }},
   {{ SC_(9.79081630706787109375000000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(2.42034603135152218619386929878640832e+07) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(2.54143619537353515625000000000000000e+00), SC_(2.42026353456983362016882886568932116e+07) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-2.54143714904785156250000000000000000e+00), SC_(-9.99999958682450715519806155175452283e-01) }},
   {{ SC_(1.04318666458129882812500000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(2.41995643894809092300389648960843128e+07) }},
   {{ SC_(9.58600759506225585937500000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(2.42042734016817427966649702582750738e+07) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(2.83519268035888671875000000000000000e+00), SC_(2.42025818771556556819317851488717252e+07) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-2.83519363403320312500000000000000000e+00), SC_(-9.99999958682332123970027470435943372e-01) }},
   {{ SC_(1.08823871612548828125000000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(2.42009011262507686397673267606120386e+07) }},
   {{ SC_(9.18915510177612304687500000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(2.42037753108130973054373973471463235e+07) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(3.20573425292968750000000000000000000e+00), SC_(2.42026594013382437854253557469647200e+07) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-3.20573425292968750000000000000000000e+00), SC_(-9.99999958682228175845216229671098635e-01) }},
   {{ SC_(1.18426418304443359375000000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(2.42022976790608173882478419560658937e+07) }},
   {{ SC_(8.44405889511108398437500000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(2.42032720003110936194873640722950898e+07) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(3.68769073486328125000000000000000000e+00), SC_(2.42026138087255120516729074861839697e+07) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-3.68769168853759765625000000000000000e+00), SC_(-9.99999958682332011228400521719833297e-01) }},
   {{ SC_(1.40248203277587890625000000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(2.42026251615786521684693885892100198e+07) }},
   {{ SC_(7.13021516799926757812500000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(2.42029127379101265548279804410187491e+07) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(4.34020614624023437500000000000000000e+00), SC_(2.42025701715023556511506527191446796e+07) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-4.34020805358886718750000000000000000e+00), SC_(-9.99999958682384559477817970761496473e-01) }},
   {{ SC_(1.96695566177368164062500000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(2.42025662542916108870699507532284663e+07) }},
   {{ SC_(5.08399724960327148437500000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(2.42028630357569442252217394183490912e+07) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(5.27328491210937500000000000000000000e+00), SC_(2.42026683557872648817239797440210823e+07) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-5.27328491210937500000000000000000000e+00), SC_(-9.99999958682243462501246847017224259e-01) }},
   {{ SC_(3.86891460418701171875000000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(2.42025685185547645579438829195662456e+07) }},
   {{ SC_(2.58470296859741210937500000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(2.42028435966620285958225052895319304e+07) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(6.71742820739746093750000000000000000e+00), SC_(2.42026402504268938946096286491075917e+07) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-6.71743011474609375000000000000000000e+00), SC_(-9.99999958682394945272411237128192553e-01) }},
   {{ SC_(1.49685020446777343750000000000000000e+01), SC_(6.28318405151367187500000000000000000e+00), SC_(2.42025871119364600432459101931235029e+07) }},
   {{ SC_(6.68069422245025634765625000000000000e-02), SC_(-6.28318595886230468750000000000000000e+00), SC_(2.42027346412806817688935457409946217e+07) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(9.25087356567382812500000000000000000e+00), SC_(2.42024997329232648055997716963056140e+07) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-9.25087738037109375000000000000000000e+00), SC_(-9.99999958682245272266274837081602739e-01) }},
   {{ SC_(2.24056091308593750000000000000000000e+02), SC_(3.14159202575683593750000000000000000e+00), SC_(2.42025999555515410224553988985194510e+07) }},
   {{ SC_(4.46316786110401153564453125000000000e-03), SC_(-3.14159297943115234375000000000000000e+00), SC_(2.42027289901217253692052422847643667e+07) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(1.48523864746093750000000000000000000e+01), SC_(2.42025283797335766647416272458127500e+07) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-1.48523902893066406250000000000000000e+01), SC_(-9.99999958682184926931823184542569096e-01) }},
   {{ SC_(5.02011406250000000000000000000000000e+04), SC_(1.57079601287841796875000000000000000e+00), SC_(2.42026064475229695004027939743957389e+07) }},
   {{ SC_(1.99198620975948870182037353515625000e-05), SC_(-1.57079648971557617187500000000000000e+00), SC_(2.42027390266700222789694541437987296e+07) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(3.76497344970703125000000000000000000e+01), SC_(2.42023765819337964871883514635988149e+07) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-3.76497497558593750000000000000000000e+01), SC_(-9.99999958682030059393664148092820775e-01) }},
   {{ SC_(2.52015411200000000000000000000000000e+09), SC_(7.85398006439208984375000000000000000e-01), SC_(2.42026033697309962561576648530576253e+07) }},
   {{ SC_(3.96801036472993473580572754144668579e-10), SC_(-7.85398244857788085937500000000000000e-01), SC_(2.42027327757359387420521097220518594e+07) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-7.03827819824218750000000000000000000e+01), SC_(2.42031614741834195640701218641545758e+07) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(7.03827514648437500000000000000000000e+01), SC_(-9.99999958682780687743288256757781652e-01) }},
   {{ SC_(6.35117718524343091200000000000000000e+18), SC_(3.92699003219604492187500000000000000e-01), SC_(2.42026040237072387028002213452887469e+07) }},
   {{ SC_(1.57451089563689736007599632994224947e-19), SC_(-3.92699122428894042968750000000000000e-01), SC_(2.42027311448400296777842481593201606e+07) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-1.81895446777343750000000000000000000e+01), SC_(2.42028999915106835578753224149143517e+07) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(1.81895370483398437500000000000000000e+01), SC_(-9.99999958682344250315021346812430444e-01) }},
   {{ SC_(4.03374736780560092741124778323670467e+37), SC_(1.96349501609802246093750000000000000e-01), SC_(2.42026066202114373432878757203361600e+07) }},
   {{ SC_(2.47908419686543519402475304311218917e-38), SC_(-1.96349561214447021484375000000000000e-01), SC_(2.42027318418571851168795244761094542e+07) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-1.04443817138671875000000000000000000e+01), SC_(2.42028537928248452370129790368190895e+07) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(1.04443778991699218750000000000000000e+01), SC_(-9.99999958682303456815515781946053245e-01) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-7.32526206970214843750000000000000000e+00), SC_(2.42027969796422284249531197359107379e+07) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(7.32526016235351562500000000000000000e+00), SC_(-9.99999958682280130629107622114268584e-01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-5.64071464538574218750000000000000000e+00), SC_(2.42028068656792208562234132090359111e+07) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(5.64071273803710937500000000000000000e+00), SC_(-9.99999958682242382465675089445388638e-01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-4.58608055114746093750000000000000000e+00), SC_(2.42028036160450358971427997088106635e+07) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(4.58607864379882812500000000000000000e+00), SC_(-9.99999958682182209712041669223191740e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-3.86369228363037109375000000000000000e+00), SC_(2.42027303132184753996352292501743890e+07) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(3.86369132995605468750000000000000000e+00), SC_(-9.99999958682175839523739356990084385e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-3.33791255950927734375000000000000000e+00), SC_(2.42026933101480391018782062061283240e+07) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(3.33791255950927734375000000000000000e+00), SC_(-9.99999958682286063469131063979656309e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-2.93809127807617187500000000000000000e+00), SC_(2.42027424416645631961939064098956714e+07) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(2.93809032440185546875000000000000000e+00), SC_(-9.99999958682141919453953804081556346e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-2.62380695343017578125000000000000000e+00), SC_(2.42027921334836696474048495136718327e+07) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(2.62380599975585937500000000000000000e+00), SC_(-9.99999958682199438393681122122747898e-01) }},
   {{ SC_(1.01169490814208984375000000000000000e+00), SC_(1.60849511718750000000000000000000000e+03), SC_(1.32494957647089155254624797466092996e+08) }},
   {{ SC_(9.88440036773681640625000000000000000e-01), SC_(-1.60849560546875000000000000000000000e+03), SC_(1.32548529578050880532452189237375702e+08) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(2.53312110900878906250000000000000000e+00), SC_(1.32510270913672902403531430572548136e+08) }},
   {{ SC_(1.60849511718750000000000000000000000e+03), SC_(-2.53312110900878906250000000000000000e+00), SC_(-9.99999992453415229187102113638492667e-01) }},
   {{ SC_(1.02352666854858398437500000000000000e+00), SC_(8.04247558593750000000000000000000000e+02), SC_(1.32503431169233492006854587508249411e+08) }},
   {{ SC_(9.77014064788818359375000000000000000e-01), SC_(-8.04247802734375000000000000000000000e+02), SC_(1.32509420367970196347134098536731400e+08) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(2.79557991027832031250000000000000000e+00), SC_(1.32510171709214716836567173003324774e+08) }},
   {{ SC_(8.04247558593750000000000000000000000e+02), SC_(-2.79558086395263671875000000000000000e+00), SC_(-9.99999992453457726433078792103291596e-01) }},
   {{ SC_(1.04760694503784179687500000000000000e+00), SC_(4.02123779296875000000000000000000000e+02), SC_(1.32508711081048179809135069112074380e+08) }},
   {{ SC_(9.54556465148925781250000000000000000e-01), SC_(-4.02123901367187500000000000000000000e+02), SC_(1.32510405419390106331107263893223281e+08) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(3.11871242523193359375000000000000000e+00), SC_(1.32510144061296232181321696300213882e+08) }},
   {{ SC_(4.02123779296875000000000000000000000e+02), SC_(-3.11871337890625000000000000000000000e+00), SC_(-9.99999992453451163321628755359362998e-01) }},
   {{ SC_(1.09748029708862304687500000000000000e+00), SC_(2.01061889648437500000000000000000000e+02), SC_(1.32508366291716829859918959013292424e+08) }},
   {{ SC_(9.11177873611450195312500000000000000e-01), SC_(-2.01061950683593750000000000000000000e+02), SC_(1.32515421516064897295400206675865712e+08) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(3.52630710601806640625000000000000000e+00), SC_(1.32509829908635695842831560052148819e+08) }},
   {{ SC_(2.01061889648437500000000000000000000e+02), SC_(-3.52630805969238281250000000000000000e+00), SC_(-9.99999992453428283498480806953015770e-01) }},
   {{ SC_(1.20446300506591796875000000000000000e+00), SC_(1.00530944824218750000000000000000000e+02), SC_(1.32508394695491990740128158153726940e+08) }},
   {{ SC_(8.30245256423950195312500000000000000e-01), SC_(-1.00530975341796875000000000000000000e+02), SC_(1.32513190135114296688634829303837851e+08) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(4.05645942687988281250000000000000000e+00), SC_(1.32509724408707704639044394484074397e+08) }},
   {{ SC_(1.00530944824218750000000000000000000e+02), SC_(-4.05646133422851562500000000000000000e+00), SC_(-9.99999992453450467963052000540104497e-01) }},
   {{ SC_(1.45073127746582031250000000000000000e+00), SC_(5.02654724121093750000000000000000000e+01), SC_(1.32509069114181162056434745463702552e+08) }},
   {{ SC_(6.89307451248168945312500000000000000e-01), SC_(-5.02654876708984375000000000000000000e+01), SC_(1.32510625249638333539268747310545107e+08) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(4.77422714233398437500000000000000000e+00), SC_(1.32509892668841386763982928573399118e+08) }},
   {{ SC_(5.02654724121093750000000000000000000e+01), SC_(-4.77422904968261718750000000000000000e+00), SC_(-9.99999992453450073432948531573128441e-01) }},
   {{ SC_(2.10462188720703125000000000000000000e+00), SC_(2.51327362060546875000000000000000000e+01), SC_(1.32510094168533834529308593132106474e+08) }},
   {{ SC_(4.75144743919372558593750000000000000e-01), SC_(-2.51327438354492187500000000000000000e+01), SC_(1.32510754406224422635926383398482091e+08) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(5.80061340332031250000000000000000000e+00), SC_(1.32510285972105015139852808344297129e+08) }},
   {{ SC_(2.51327362060546875000000000000000000e+01), SC_(-5.80061340332031250000000000000000000e+00), SC_(-9.99999992453416086778894049145534652e-01) }},
   {{ SC_(4.42943191528320312500000000000000000e+00), SC_(1.25663681030273437500000000000000000e+01), SC_(1.32509578078078112642590521593658012e+08) }},
   {{ SC_(2.25762546062469482421875000000000000e-01), SC_(-1.25663719177246093750000000000000000e+01), SC_(1.32510618778131511447172800577195768e+08) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(7.38916969299316406250000000000000000e+00), SC_(1.32509668918466830563551807067242208e+08) }},
   {{ SC_(1.25663681030273437500000000000000000e+01), SC_(-7.38917160034179687500000000000000000e+00), SC_(-9.99999992453417376394541769218409655e-01) }},
   {{ SC_(1.96198730468750000000000000000000000e+01), SC_(6.28318405151367187500000000000000000e+00), SC_(1.32509830771858965883921849932742018e+08) }},
   {{ SC_(5.09687215089797973632812500000000000e-02), SC_(-6.28318595886230468750000000000000000e+00), SC_(1.32510711817910196777367636775807065e+08) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(1.01759643554687500000000000000000000e+01), SC_(1.32510106552302586422699199872493237e+08) }},
   {{ SC_(6.28318405151367187500000000000000000e+00), SC_(-1.01759643554687500000000000000000000e+01), SC_(-9.99999992453405868640672499284296668e-01) }},
   {{ SC_(3.84939453125000000000000000000000000e+02), SC_(3.14159202575683593750000000000000000e+00), SC_(1.32509868351636389453884929456344859e+08) }},
   {{ SC_(2.59781070053577423095703125000000000e-03), SC_(-3.14159297943115234375000000000000000e+00), SC_(1.32510691261928045321572806541307853e+08) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(1.63376235961914062500000000000000000e+01), SC_(1.32509211505743144152500096698371581e+08) }},
   {{ SC_(3.14159202575683593750000000000000000e+00), SC_(-1.63376312255859375000000000000000000e+01), SC_(-9.99999992453420803475151024668501072e-01) }},
   {{ SC_(1.48178375000000000000000000000000000e+05), SC_(1.57079601287841796875000000000000000e+00), SC_(1.32509857715013822855990545027163848e+08) }},
   {{ SC_(6.74861985316965728998184204101562500e-06), SC_(-1.57079648971557617187500000000000000e+00), SC_(1.32510709232526187899989459194425398e+08) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(4.14147186279296875000000000000000000e+01), SC_(1.32509167902254640159430906974661382e+08) }},
   {{ SC_(1.57079601287841796875000000000000000e+00), SC_(-4.14147338867187500000000000000000000e+01), SC_(-9.99999992453404411892508654341762366e-01) }},
   {{ SC_(2.19568373760000000000000000000000000e+10), SC_(7.85398006439208984375000000000000000e-01), SC_(1.32509888800919636780570574628187805e+08) }},
   {{ SC_(4.55438881052927513337635900825262070e-11), SC_(-7.85398244857788085937500000000000000e-01), SC_(1.32510667682708067402946363974452653e+08) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(-7.74210510253906250000000000000000000e+01), SC_(1.32512962730981596034771037020273300e+08) }},
   {{ SC_(7.85398006439208984375000000000000000e-01), SC_(7.74210205078125000000000000000000000e+01), SC_(-9.99999992453512895340851052783749069e-01) }},
   {{ SC_(4.82102881023128764416000000000000000e+20), SC_(3.92699003219604492187500000000000000e-01), SC_(1.32509907524348585776541601736704900e+08) }},
   {{ SC_(2.07424585885621488214199635569112701e-21), SC_(-3.92699122428894042968750000000000000e-01), SC_(1.32510664794961779233524868338910658e+08) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(-2.00084991455078125000000000000000000e+01), SC_(1.32511681005994133513825663885108569e+08) }},
   {{ SC_(3.92699003219604492187500000000000000e-01), SC_(2.00084915161132812500000000000000000e+01), SC_(-9.99999992453441717948213899270564454e-01) }},
   {{ SC_(4.30198628547718840773584982070004252e-42), SC_(-1.96349561214447021484375000000000000e-01), SC_(1.32513746693747491403890537797416490e+08) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(-1.14888191223144531250000000000000000e+01), SC_(1.32511238199277123994169005161361076e+08) }},
   {{ SC_(1.96349501609802246093750000000000000e-01), SC_(1.14888153076171875000000000000000000e+01), SC_(-9.99999992453423454105390532743860649e-01) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(-8.05778884887695312500000000000000000e+00), SC_(1.32511236600194321144472081902988900e+08) }},
   {{ SC_(9.81747508049011230468750000000000000e-02), SC_(8.05778503417968750000000000000000000e+00), SC_(-9.99999992453403408755134486424680238e-01) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(-6.20478630065917968750000000000000000e+00), SC_(1.32511196333613501625056681220635449e+08) }},
   {{ SC_(4.90873754024505615234375000000000000e-02), SC_(6.20478439331054687500000000000000000e+00), SC_(-9.99999992453424546906418471379431692e-01) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(-5.04468727111816406250000000000000000e+00), SC_(1.32510444682153244308944741276249743e+08) }},
   {{ SC_(2.45436877012252807617187500000000000e-02), SC_(5.04468727111816406250000000000000000e+00), SC_(-9.99999992453425125452718343016626620e-01) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(-4.25006103515625000000000000000000000e+00), SC_(1.32510381066245855377858266863800391e+08) }},
   {{ SC_(1.22718438506126403808593750000000000e-02), SC_(4.25006103515625000000000000000000000e+00), SC_(-9.99999992453421502474647969430194543e-01) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(-3.67170429229736328125000000000000000e+00), SC_(1.32510758104285983489485249432557085e+08) }},
   {{ SC_(6.13592192530632019042968750000000000e-03), SC_(3.67170333862304687500000000000000000e+00), SC_(-9.99999992453406316573389351881712106e-01) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(-3.23190021514892578125000000000000000e+00), SC_(1.32510585900182699403632785183039269e+08) }},
   {{ SC_(3.06796096265316009521484375000000000e-03), SC_(3.23189926147460937500000000000000000e+00), SC_(-9.99999992453391520816030464475703070e-01) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(-2.88618755340576171875000000000000000e+00), SC_(1.32510949539383669902674940342567829e+08) }},
   {{ SC_(1.53398048132658004760742187500000000e-03), SC_(2.88618659973144531250000000000000000e+00), SC_(-9.99999992453407241797117696042091820e-01) }},
}};

// 5456
