/*****************************************************************************
   file         : $Id: nodes.cpp,v 1.7 2006/09/08 13:25:49 nils Exp $
   description  :
   ------------------------------------------------------------------------

   copyright    : (C) 2006 by Nils Springob, Aachen, GERMANY
   email        : nils.springob@nicai-systems.de
   project      : nicai-systems library

 *****************************************************************************/

#include "xml/nodes.h"

namespace nicai {
namespace xml {

bool node::operator== (const node & node) const
{
  if (getNodeType()==node.getNodeType())
  {
    switch(getNodeType())
    {
      case NULL_NODE:
        return true;
      case DOCUMENT_NODE:
        return (document &)(*this) == (document &)(node);
      case TAG_NODE:
        return (tag &)(*this) == (tag &)(node);
      case COMMENT_NODE:
        return (comment &)(*this) == (comment &)(node);
      case INSTRUCTION_NODE:
        return (instruction &)(*this) == (instruction &)(node);
      case CDATA_NODE:
        return (cdata &)(*this) == (cdata &)(node);
      case ATTRIBUTE_NODE:
        return (attribute &)(*this) == (attribute &)(node);
      case ENDTAG_NODE:
        return (endtag &)(*this) == (endtag &)(node);
      case ENDDOCUMENT_NODE:
        return (enddocument &)(*this) == (enddocument &)(node);
      case TEXT_NODE:
        return (text &)(*this) == (text &)(node);
      case POLY_NODE:
        return (polynode &)(*this) == (polynode &)(node);
    }
  }
  return false;
}

node::~node()
{
}

} // namespace
} // namespace
