/*
 *                    BioJava development code
 *
 * This code may be freely distributed and modified under the
 * terms of the GNU Lesser General Public Licence.  This should
 * be distributed with the code.  If you do not have a copy,
 * see:
 *
 *      http://www.gnu.org/copyleft/lesser.html
 *
 * Copyright for this code is held jointly by the individual
 * authors.  These should be listed in @author doc comments.
 *
 * For more information on the BioJava project and its aims,
 * or to join the biojava-l mailing list, visit the home page
 * at:
 *
 *      http://www.biojava.org/
 *
 */
/**
 * Classes related to the implementation of the FATCAT alignment algorithm, here called jFATCAT.
 *
 * FATCAT reference:
 * <pre>
 * Yuzhen Ye &amp; Adam Godzik (2003)
 * Flexible structure alignment by chaining aligned fragment pairs allowing twists.
 * Bioinformatics vol.19 suppl. 2. ii246-ii255.
 * </pre>
 *
 * see also:
 * <pre>
 * Andreas Prlic; Spencer Bliven; Peter W. Rose; Wolfgang F. Bluhm; Chris Bizon; Adam Godzik; Philip E. Bourne (2010)
 * Pre-calculated protein structure alignments at the RCSB PDB website
 * Bioinformatics 26: 2983-2985
 * </pre>
 */
package org.biojava.nbio.structure.align.fatcat;