/*  This file is part of GDB.

    Copyright 2004-2015 Free Software Foundation, Inc.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 
    */


#include "psim.h"
#include "options.h"
#include "registers.h"

#include "ansidecl.h"
#include "sim_callbacks.h"
#include "gdb/callback.h"
#include "gdb/remote-sim.h"
#include "gdb/sim-ppc.h"

/* Return the register name for the supplied SPR if any, or NULL if
   none.  */
const char *
sim_spr_register_name (int spr)
{
  if (spr_is_valid (spr))
    return spr_name (spr);
  else
    return NULL;
}

#define regnum2spr(SPR) sim_spr_register_name (SPR)

/* Return the name of the register whose number is REGNUM, or zero if
   REGNUM is an invalid register number.  */

static const char *
regnum2name (int regnum)
{
  switch (regnum)
    {
    case sim_ppc_r0_regnum: return "r0";
    case sim_ppc_r1_regnum: return "r1";
    case sim_ppc_r2_regnum: return "r2";
    case sim_ppc_r3_regnum: return "r3";
    case sim_ppc_r4_regnum: return "r4";
    case sim_ppc_r5_regnum: return "r5";
    case sim_ppc_r6_regnum: return "r6";
    case sim_ppc_r7_regnum: return "r7";
    case sim_ppc_r8_regnum: return "r8";
    case sim_ppc_r9_regnum: return "r9";
    case sim_ppc_r10_regnum: return "r10";
    case sim_ppc_r11_regnum: return "r11";
    case sim_ppc_r12_regnum: return "r12";
    case sim_ppc_r13_regnum: return "r13";
    case sim_ppc_r14_regnum: return "r14";
    case sim_ppc_r15_regnum: return "r15";
    case sim_ppc_r16_regnum: return "r16";
    case sim_ppc_r17_regnum: return "r17";
    case sim_ppc_r18_regnum: return "r18";
    case sim_ppc_r19_regnum: return "r19";
    case sim_ppc_r20_regnum: return "r20";
    case sim_ppc_r21_regnum: return "r21";
    case sim_ppc_r22_regnum: return "r22";
    case sim_ppc_r23_regnum: return "r23";
    case sim_ppc_r24_regnum: return "r24";
    case sim_ppc_r25_regnum: return "r25";
    case sim_ppc_r26_regnum: return "r26";
    case sim_ppc_r27_regnum: return "r27";
    case sim_ppc_r28_regnum: return "r28";
    case sim_ppc_r29_regnum: return "r29";
    case sim_ppc_r30_regnum: return "r30";
    case sim_ppc_r31_regnum: return "r31";

    case sim_ppc_f0_regnum: return "f0";
    case sim_ppc_f1_regnum: return "f1";
    case sim_ppc_f2_regnum: return "f2";
    case sim_ppc_f3_regnum: return "f3";
    case sim_ppc_f4_regnum: return "f4";
    case sim_ppc_f5_regnum: return "f5";
    case sim_ppc_f6_regnum: return "f6";
    case sim_ppc_f7_regnum: return "f7";
    case sim_ppc_f8_regnum: return "f8";
    case sim_ppc_f9_regnum: return "f9";
    case sim_ppc_f10_regnum: return "f10";
    case sim_ppc_f11_regnum: return "f11";
    case sim_ppc_f12_regnum: return "f12";
    case sim_ppc_f13_regnum: return "f13";
    case sim_ppc_f14_regnum: return "f14";
    case sim_ppc_f15_regnum: return "f15";
    case sim_ppc_f16_regnum: return "f16";
    case sim_ppc_f17_regnum: return "f17";
    case sim_ppc_f18_regnum: return "f18";
    case sim_ppc_f19_regnum: return "f19";
    case sim_ppc_f20_regnum: return "f20";
    case sim_ppc_f21_regnum: return "f21";
    case sim_ppc_f22_regnum: return "f22";
    case sim_ppc_f23_regnum: return "f23";
    case sim_ppc_f24_regnum: return "f24";
    case sim_ppc_f25_regnum: return "f25";
    case sim_ppc_f26_regnum: return "f26";
    case sim_ppc_f27_regnum: return "f27";
    case sim_ppc_f28_regnum: return "f28";
    case sim_ppc_f29_regnum: return "f29";
    case sim_ppc_f30_regnum: return "f30";
    case sim_ppc_f31_regnum: return "f31";

    case sim_ppc_vr0_regnum: return "vr0";
    case sim_ppc_vr1_regnum: return "vr1";
    case sim_ppc_vr2_regnum: return "vr2";
    case sim_ppc_vr3_regnum: return "vr3";
    case sim_ppc_vr4_regnum: return "vr4";
    case sim_ppc_vr5_regnum: return "vr5";
    case sim_ppc_vr6_regnum: return "vr6";
    case sim_ppc_vr7_regnum: return "vr7";
    case sim_ppc_vr8_regnum: return "vr8";
    case sim_ppc_vr9_regnum: return "vr9";
    case sim_ppc_vr10_regnum: return "vr10";
    case sim_ppc_vr11_regnum: return "vr11";
    case sim_ppc_vr12_regnum: return "vr12";
    case sim_ppc_vr13_regnum: return "vr13";
    case sim_ppc_vr14_regnum: return "vr14";
    case sim_ppc_vr15_regnum: return "vr15";
    case sim_ppc_vr16_regnum: return "vr16";
    case sim_ppc_vr17_regnum: return "vr17";
    case sim_ppc_vr18_regnum: return "vr18";
    case sim_ppc_vr19_regnum: return "vr19";
    case sim_ppc_vr20_regnum: return "vr20";
    case sim_ppc_vr21_regnum: return "vr21";
    case sim_ppc_vr22_regnum: return "vr22";
    case sim_ppc_vr23_regnum: return "vr23";
    case sim_ppc_vr24_regnum: return "vr24";
    case sim_ppc_vr25_regnum: return "vr25";
    case sim_ppc_vr26_regnum: return "vr26";
    case sim_ppc_vr27_regnum: return "vr27";
    case sim_ppc_vr28_regnum: return "vr28";
    case sim_ppc_vr29_regnum: return "vr29";
    case sim_ppc_vr30_regnum: return "vr30";
    case sim_ppc_vr31_regnum: return "vr31";
    case sim_ppc_rh0_regnum: return "rh0";
    case sim_ppc_rh1_regnum: return "rh1";
    case sim_ppc_rh2_regnum: return "rh2";
    case sim_ppc_rh3_regnum: return "rh3";
    case sim_ppc_rh4_regnum: return "rh4";
    case sim_ppc_rh5_regnum: return "rh5";
    case sim_ppc_rh6_regnum: return "rh6";
    case sim_ppc_rh7_regnum: return "rh7";
    case sim_ppc_rh8_regnum: return "rh8";
    case sim_ppc_rh9_regnum: return "rh9";
    case sim_ppc_rh10_regnum: return "rh10";
    case sim_ppc_rh11_regnum: return "rh11";
    case sim_ppc_rh12_regnum: return "rh12";
    case sim_ppc_rh13_regnum: return "rh13";
    case sim_ppc_rh14_regnum: return "rh14";
    case sim_ppc_rh15_regnum: return "rh15";
    case sim_ppc_rh16_regnum: return "rh16";
    case sim_ppc_rh17_regnum: return "rh17";
    case sim_ppc_rh18_regnum: return "rh18";
    case sim_ppc_rh19_regnum: return "rh19";
    case sim_ppc_rh20_regnum: return "rh20";
    case sim_ppc_rh21_regnum: return "rh21";
    case sim_ppc_rh22_regnum: return "rh22";
    case sim_ppc_rh23_regnum: return "rh23";
    case sim_ppc_rh24_regnum: return "rh24";
    case sim_ppc_rh25_regnum: return "rh25";
    case sim_ppc_rh26_regnum: return "rh26";
    case sim_ppc_rh27_regnum: return "rh27";
    case sim_ppc_rh28_regnum: return "rh28";
    case sim_ppc_rh29_regnum: return "rh29";
    case sim_ppc_rh30_regnum: return "rh30";
    case sim_ppc_rh31_regnum: return "rh31";

    case sim_ppc_ev0_regnum: return "ev0";
    case sim_ppc_ev1_regnum: return "ev1";
    case sim_ppc_ev2_regnum: return "ev2";
    case sim_ppc_ev3_regnum: return "ev3";
    case sim_ppc_ev4_regnum: return "ev4";
    case sim_ppc_ev5_regnum: return "ev5";
    case sim_ppc_ev6_regnum: return "ev6";
    case sim_ppc_ev7_regnum: return "ev7";
    case sim_ppc_ev8_regnum: return "ev8";
    case sim_ppc_ev9_regnum: return "ev9";
    case sim_ppc_ev10_regnum: return "ev10";
    case sim_ppc_ev11_regnum: return "ev11";
    case sim_ppc_ev12_regnum: return "ev12";
    case sim_ppc_ev13_regnum: return "ev13";
    case sim_ppc_ev14_regnum: return "ev14";
    case sim_ppc_ev15_regnum: return "ev15";
    case sim_ppc_ev16_regnum: return "ev16";
    case sim_ppc_ev17_regnum: return "ev17";
    case sim_ppc_ev18_regnum: return "ev18";
    case sim_ppc_ev19_regnum: return "ev19";
    case sim_ppc_ev20_regnum: return "ev20";
    case sim_ppc_ev21_regnum: return "ev21";
    case sim_ppc_ev22_regnum: return "ev22";
    case sim_ppc_ev23_regnum: return "ev23";
    case sim_ppc_ev24_regnum: return "ev24";
    case sim_ppc_ev25_regnum: return "ev25";
    case sim_ppc_ev26_regnum: return "ev26";
    case sim_ppc_ev27_regnum: return "ev27";
    case sim_ppc_ev28_regnum: return "ev28";
    case sim_ppc_ev29_regnum: return "ev29";
    case sim_ppc_ev30_regnum: return "ev30";
    case sim_ppc_ev31_regnum: return "ev31";

    case sim_ppc_sr0_regnum: return "sr0";
    case sim_ppc_sr1_regnum: return "sr1";
    case sim_ppc_sr2_regnum: return "sr2";
    case sim_ppc_sr3_regnum: return "sr3";
    case sim_ppc_sr4_regnum: return "sr4";
    case sim_ppc_sr5_regnum: return "sr5";
    case sim_ppc_sr6_regnum: return "sr6";
    case sim_ppc_sr7_regnum: return "sr7";
    case sim_ppc_sr8_regnum: return "sr8";
    case sim_ppc_sr9_regnum: return "sr9";
    case sim_ppc_sr10_regnum: return "sr10";
    case sim_ppc_sr11_regnum: return "sr11";
    case sim_ppc_sr12_regnum: return "sr12";
    case sim_ppc_sr13_regnum: return "sr13";
    case sim_ppc_sr14_regnum: return "sr14";
    case sim_ppc_sr15_regnum: return "sr15";

    case sim_ppc_pc_regnum: return "pc";
    case sim_ppc_ps_regnum: return "ps";
    case sim_ppc_cr_regnum: return "cr";
    case sim_ppc_fpscr_regnum: return "fpscr";
    case sim_ppc_acc_regnum: return "acc";
    case sim_ppc_vscr_regnum: return "vscr";

    case sim_ppc_spr0_regnum: return regnum2spr (0);
    case sim_ppc_spr1_regnum: return regnum2spr (1);
    case sim_ppc_spr2_regnum: return regnum2spr (2);
    case sim_ppc_spr3_regnum: return regnum2spr (3);
    case sim_ppc_spr4_regnum: return regnum2spr (4);
    case sim_ppc_spr5_regnum: return regnum2spr (5);
    case sim_ppc_spr6_regnum: return regnum2spr (6);
    case sim_ppc_spr7_regnum: return regnum2spr (7);
    case sim_ppc_spr8_regnum: return regnum2spr (8);
    case sim_ppc_spr9_regnum: return regnum2spr (9);
    case sim_ppc_spr10_regnum: return regnum2spr (10);
    case sim_ppc_spr11_regnum: return regnum2spr (11);
    case sim_ppc_spr12_regnum: return regnum2spr (12);
    case sim_ppc_spr13_regnum: return regnum2spr (13);
    case sim_ppc_spr14_regnum: return regnum2spr (14);
    case sim_ppc_spr15_regnum: return regnum2spr (15);
    case sim_ppc_spr16_regnum: return regnum2spr (16);
    case sim_ppc_spr17_regnum: return regnum2spr (17);
    case sim_ppc_spr18_regnum: return regnum2spr (18);
    case sim_ppc_spr19_regnum: return regnum2spr (19);
    case sim_ppc_spr20_regnum: return regnum2spr (20);
    case sim_ppc_spr21_regnum: return regnum2spr (21);
    case sim_ppc_spr22_regnum: return regnum2spr (22);
    case sim_ppc_spr23_regnum: return regnum2spr (23);
    case sim_ppc_spr24_regnum: return regnum2spr (24);
    case sim_ppc_spr25_regnum: return regnum2spr (25);
    case sim_ppc_spr26_regnum: return regnum2spr (26);
    case sim_ppc_spr27_regnum: return regnum2spr (27);
    case sim_ppc_spr28_regnum: return regnum2spr (28);
    case sim_ppc_spr29_regnum: return regnum2spr (29);
    case sim_ppc_spr30_regnum: return regnum2spr (30);
    case sim_ppc_spr31_regnum: return regnum2spr (31);
    case sim_ppc_spr32_regnum: return regnum2spr (32);
    case sim_ppc_spr33_regnum: return regnum2spr (33);
    case sim_ppc_spr34_regnum: return regnum2spr (34);
    case sim_ppc_spr35_regnum: return regnum2spr (35);
    case sim_ppc_spr36_regnum: return regnum2spr (36);
    case sim_ppc_spr37_regnum: return regnum2spr (37);
    case sim_ppc_spr38_regnum: return regnum2spr (38);
    case sim_ppc_spr39_regnum: return regnum2spr (39);
    case sim_ppc_spr40_regnum: return regnum2spr (40);
    case sim_ppc_spr41_regnum: return regnum2spr (41);
    case sim_ppc_spr42_regnum: return regnum2spr (42);
    case sim_ppc_spr43_regnum: return regnum2spr (43);
    case sim_ppc_spr44_regnum: return regnum2spr (44);
    case sim_ppc_spr45_regnum: return regnum2spr (45);
    case sim_ppc_spr46_regnum: return regnum2spr (46);
    case sim_ppc_spr47_regnum: return regnum2spr (47);
    case sim_ppc_spr48_regnum: return regnum2spr (48);
    case sim_ppc_spr49_regnum: return regnum2spr (49);
    case sim_ppc_spr50_regnum: return regnum2spr (50);
    case sim_ppc_spr51_regnum: return regnum2spr (51);
    case sim_ppc_spr52_regnum: return regnum2spr (52);
    case sim_ppc_spr53_regnum: return regnum2spr (53);
    case sim_ppc_spr54_regnum: return regnum2spr (54);
    case sim_ppc_spr55_regnum: return regnum2spr (55);
    case sim_ppc_spr56_regnum: return regnum2spr (56);
    case sim_ppc_spr57_regnum: return regnum2spr (57);
    case sim_ppc_spr58_regnum: return regnum2spr (58);
    case sim_ppc_spr59_regnum: return regnum2spr (59);
    case sim_ppc_spr60_regnum: return regnum2spr (60);
    case sim_ppc_spr61_regnum: return regnum2spr (61);
    case sim_ppc_spr62_regnum: return regnum2spr (62);
    case sim_ppc_spr63_regnum: return regnum2spr (63);
    case sim_ppc_spr64_regnum: return regnum2spr (64);
    case sim_ppc_spr65_regnum: return regnum2spr (65);
    case sim_ppc_spr66_regnum: return regnum2spr (66);
    case sim_ppc_spr67_regnum: return regnum2spr (67);
    case sim_ppc_spr68_regnum: return regnum2spr (68);
    case sim_ppc_spr69_regnum: return regnum2spr (69);
    case sim_ppc_spr70_regnum: return regnum2spr (70);
    case sim_ppc_spr71_regnum: return regnum2spr (71);
    case sim_ppc_spr72_regnum: return regnum2spr (72);
    case sim_ppc_spr73_regnum: return regnum2spr (73);
    case sim_ppc_spr74_regnum: return regnum2spr (74);
    case sim_ppc_spr75_regnum: return regnum2spr (75);
    case sim_ppc_spr76_regnum: return regnum2spr (76);
    case sim_ppc_spr77_regnum: return regnum2spr (77);
    case sim_ppc_spr78_regnum: return regnum2spr (78);
    case sim_ppc_spr79_regnum: return regnum2spr (79);
    case sim_ppc_spr80_regnum: return regnum2spr (80);
    case sim_ppc_spr81_regnum: return regnum2spr (81);
    case sim_ppc_spr82_regnum: return regnum2spr (82);
    case sim_ppc_spr83_regnum: return regnum2spr (83);
    case sim_ppc_spr84_regnum: return regnum2spr (84);
    case sim_ppc_spr85_regnum: return regnum2spr (85);
    case sim_ppc_spr86_regnum: return regnum2spr (86);
    case sim_ppc_spr87_regnum: return regnum2spr (87);
    case sim_ppc_spr88_regnum: return regnum2spr (88);
    case sim_ppc_spr89_regnum: return regnum2spr (89);
    case sim_ppc_spr90_regnum: return regnum2spr (90);
    case sim_ppc_spr91_regnum: return regnum2spr (91);
    case sim_ppc_spr92_regnum: return regnum2spr (92);
    case sim_ppc_spr93_regnum: return regnum2spr (93);
    case sim_ppc_spr94_regnum: return regnum2spr (94);
    case sim_ppc_spr95_regnum: return regnum2spr (95);
    case sim_ppc_spr96_regnum: return regnum2spr (96);
    case sim_ppc_spr97_regnum: return regnum2spr (97);
    case sim_ppc_spr98_regnum: return regnum2spr (98);
    case sim_ppc_spr99_regnum: return regnum2spr (99);
    case sim_ppc_spr100_regnum: return regnum2spr (100);
    case sim_ppc_spr101_regnum: return regnum2spr (101);
    case sim_ppc_spr102_regnum: return regnum2spr (102);
    case sim_ppc_spr103_regnum: return regnum2spr (103);
    case sim_ppc_spr104_regnum: return regnum2spr (104);
    case sim_ppc_spr105_regnum: return regnum2spr (105);
    case sim_ppc_spr106_regnum: return regnum2spr (106);
    case sim_ppc_spr107_regnum: return regnum2spr (107);
    case sim_ppc_spr108_regnum: return regnum2spr (108);
    case sim_ppc_spr109_regnum: return regnum2spr (109);
    case sim_ppc_spr110_regnum: return regnum2spr (110);
    case sim_ppc_spr111_regnum: return regnum2spr (111);
    case sim_ppc_spr112_regnum: return regnum2spr (112);
    case sim_ppc_spr113_regnum: return regnum2spr (113);
    case sim_ppc_spr114_regnum: return regnum2spr (114);
    case sim_ppc_spr115_regnum: return regnum2spr (115);
    case sim_ppc_spr116_regnum: return regnum2spr (116);
    case sim_ppc_spr117_regnum: return regnum2spr (117);
    case sim_ppc_spr118_regnum: return regnum2spr (118);
    case sim_ppc_spr119_regnum: return regnum2spr (119);
    case sim_ppc_spr120_regnum: return regnum2spr (120);
    case sim_ppc_spr121_regnum: return regnum2spr (121);
    case sim_ppc_spr122_regnum: return regnum2spr (122);
    case sim_ppc_spr123_regnum: return regnum2spr (123);
    case sim_ppc_spr124_regnum: return regnum2spr (124);
    case sim_ppc_spr125_regnum: return regnum2spr (125);
    case sim_ppc_spr126_regnum: return regnum2spr (126);
    case sim_ppc_spr127_regnum: return regnum2spr (127);
    case sim_ppc_spr128_regnum: return regnum2spr (128);
    case sim_ppc_spr129_regnum: return regnum2spr (129);
    case sim_ppc_spr130_regnum: return regnum2spr (130);
    case sim_ppc_spr131_regnum: return regnum2spr (131);
    case sim_ppc_spr132_regnum: return regnum2spr (132);
    case sim_ppc_spr133_regnum: return regnum2spr (133);
    case sim_ppc_spr134_regnum: return regnum2spr (134);
    case sim_ppc_spr135_regnum: return regnum2spr (135);
    case sim_ppc_spr136_regnum: return regnum2spr (136);
    case sim_ppc_spr137_regnum: return regnum2spr (137);
    case sim_ppc_spr138_regnum: return regnum2spr (138);
    case sim_ppc_spr139_regnum: return regnum2spr (139);
    case sim_ppc_spr140_regnum: return regnum2spr (140);
    case sim_ppc_spr141_regnum: return regnum2spr (141);
    case sim_ppc_spr142_regnum: return regnum2spr (142);
    case sim_ppc_spr143_regnum: return regnum2spr (143);
    case sim_ppc_spr144_regnum: return regnum2spr (144);
    case sim_ppc_spr145_regnum: return regnum2spr (145);
    case sim_ppc_spr146_regnum: return regnum2spr (146);
    case sim_ppc_spr147_regnum: return regnum2spr (147);
    case sim_ppc_spr148_regnum: return regnum2spr (148);
    case sim_ppc_spr149_regnum: return regnum2spr (149);
    case sim_ppc_spr150_regnum: return regnum2spr (150);
    case sim_ppc_spr151_regnum: return regnum2spr (151);
    case sim_ppc_spr152_regnum: return regnum2spr (152);
    case sim_ppc_spr153_regnum: return regnum2spr (153);
    case sim_ppc_spr154_regnum: return regnum2spr (154);
    case sim_ppc_spr155_regnum: return regnum2spr (155);
    case sim_ppc_spr156_regnum: return regnum2spr (156);
    case sim_ppc_spr157_regnum: return regnum2spr (157);
    case sim_ppc_spr158_regnum: return regnum2spr (158);
    case sim_ppc_spr159_regnum: return regnum2spr (159);
    case sim_ppc_spr160_regnum: return regnum2spr (160);
    case sim_ppc_spr161_regnum: return regnum2spr (161);
    case sim_ppc_spr162_regnum: return regnum2spr (162);
    case sim_ppc_spr163_regnum: return regnum2spr (163);
    case sim_ppc_spr164_regnum: return regnum2spr (164);
    case sim_ppc_spr165_regnum: return regnum2spr (165);
    case sim_ppc_spr166_regnum: return regnum2spr (166);
    case sim_ppc_spr167_regnum: return regnum2spr (167);
    case sim_ppc_spr168_regnum: return regnum2spr (168);
    case sim_ppc_spr169_regnum: return regnum2spr (169);
    case sim_ppc_spr170_regnum: return regnum2spr (170);
    case sim_ppc_spr171_regnum: return regnum2spr (171);
    case sim_ppc_spr172_regnum: return regnum2spr (172);
    case sim_ppc_spr173_regnum: return regnum2spr (173);
    case sim_ppc_spr174_regnum: return regnum2spr (174);
    case sim_ppc_spr175_regnum: return regnum2spr (175);
    case sim_ppc_spr176_regnum: return regnum2spr (176);
    case sim_ppc_spr177_regnum: return regnum2spr (177);
    case sim_ppc_spr178_regnum: return regnum2spr (178);
    case sim_ppc_spr179_regnum: return regnum2spr (179);
    case sim_ppc_spr180_regnum: return regnum2spr (180);
    case sim_ppc_spr181_regnum: return regnum2spr (181);
    case sim_ppc_spr182_regnum: return regnum2spr (182);
    case sim_ppc_spr183_regnum: return regnum2spr (183);
    case sim_ppc_spr184_regnum: return regnum2spr (184);
    case sim_ppc_spr185_regnum: return regnum2spr (185);
    case sim_ppc_spr186_regnum: return regnum2spr (186);
    case sim_ppc_spr187_regnum: return regnum2spr (187);
    case sim_ppc_spr188_regnum: return regnum2spr (188);
    case sim_ppc_spr189_regnum: return regnum2spr (189);
    case sim_ppc_spr190_regnum: return regnum2spr (190);
    case sim_ppc_spr191_regnum: return regnum2spr (191);
    case sim_ppc_spr192_regnum: return regnum2spr (192);
    case sim_ppc_spr193_regnum: return regnum2spr (193);
    case sim_ppc_spr194_regnum: return regnum2spr (194);
    case sim_ppc_spr195_regnum: return regnum2spr (195);
    case sim_ppc_spr196_regnum: return regnum2spr (196);
    case sim_ppc_spr197_regnum: return regnum2spr (197);
    case sim_ppc_spr198_regnum: return regnum2spr (198);
    case sim_ppc_spr199_regnum: return regnum2spr (199);
    case sim_ppc_spr200_regnum: return regnum2spr (200);
    case sim_ppc_spr201_regnum: return regnum2spr (201);
    case sim_ppc_spr202_regnum: return regnum2spr (202);
    case sim_ppc_spr203_regnum: return regnum2spr (203);
    case sim_ppc_spr204_regnum: return regnum2spr (204);
    case sim_ppc_spr205_regnum: return regnum2spr (205);
    case sim_ppc_spr206_regnum: return regnum2spr (206);
    case sim_ppc_spr207_regnum: return regnum2spr (207);
    case sim_ppc_spr208_regnum: return regnum2spr (208);
    case sim_ppc_spr209_regnum: return regnum2spr (209);
    case sim_ppc_spr210_regnum: return regnum2spr (210);
    case sim_ppc_spr211_regnum: return regnum2spr (211);
    case sim_ppc_spr212_regnum: return regnum2spr (212);
    case sim_ppc_spr213_regnum: return regnum2spr (213);
    case sim_ppc_spr214_regnum: return regnum2spr (214);
    case sim_ppc_spr215_regnum: return regnum2spr (215);
    case sim_ppc_spr216_regnum: return regnum2spr (216);
    case sim_ppc_spr217_regnum: return regnum2spr (217);
    case sim_ppc_spr218_regnum: return regnum2spr (218);
    case sim_ppc_spr219_regnum: return regnum2spr (219);
    case sim_ppc_spr220_regnum: return regnum2spr (220);
    case sim_ppc_spr221_regnum: return regnum2spr (221);
    case sim_ppc_spr222_regnum: return regnum2spr (222);
    case sim_ppc_spr223_regnum: return regnum2spr (223);
    case sim_ppc_spr224_regnum: return regnum2spr (224);
    case sim_ppc_spr225_regnum: return regnum2spr (225);
    case sim_ppc_spr226_regnum: return regnum2spr (226);
    case sim_ppc_spr227_regnum: return regnum2spr (227);
    case sim_ppc_spr228_regnum: return regnum2spr (228);
    case sim_ppc_spr229_regnum: return regnum2spr (229);
    case sim_ppc_spr230_regnum: return regnum2spr (230);
    case sim_ppc_spr231_regnum: return regnum2spr (231);
    case sim_ppc_spr232_regnum: return regnum2spr (232);
    case sim_ppc_spr233_regnum: return regnum2spr (233);
    case sim_ppc_spr234_regnum: return regnum2spr (234);
    case sim_ppc_spr235_regnum: return regnum2spr (235);
    case sim_ppc_spr236_regnum: return regnum2spr (236);
    case sim_ppc_spr237_regnum: return regnum2spr (237);
    case sim_ppc_spr238_regnum: return regnum2spr (238);
    case sim_ppc_spr239_regnum: return regnum2spr (239);
    case sim_ppc_spr240_regnum: return regnum2spr (240);
    case sim_ppc_spr241_regnum: return regnum2spr (241);
    case sim_ppc_spr242_regnum: return regnum2spr (242);
    case sim_ppc_spr243_regnum: return regnum2spr (243);
    case sim_ppc_spr244_regnum: return regnum2spr (244);
    case sim_ppc_spr245_regnum: return regnum2spr (245);
    case sim_ppc_spr246_regnum: return regnum2spr (246);
    case sim_ppc_spr247_regnum: return regnum2spr (247);
    case sim_ppc_spr248_regnum: return regnum2spr (248);
    case sim_ppc_spr249_regnum: return regnum2spr (249);
    case sim_ppc_spr250_regnum: return regnum2spr (250);
    case sim_ppc_spr251_regnum: return regnum2spr (251);
    case sim_ppc_spr252_regnum: return regnum2spr (252);
    case sim_ppc_spr253_regnum: return regnum2spr (253);
    case sim_ppc_spr254_regnum: return regnum2spr (254);
    case sim_ppc_spr255_regnum: return regnum2spr (255);
    case sim_ppc_spr256_regnum: return regnum2spr (256);
    case sim_ppc_spr257_regnum: return regnum2spr (257);
    case sim_ppc_spr258_regnum: return regnum2spr (258);
    case sim_ppc_spr259_regnum: return regnum2spr (259);
    case sim_ppc_spr260_regnum: return regnum2spr (260);
    case sim_ppc_spr261_regnum: return regnum2spr (261);
    case sim_ppc_spr262_regnum: return regnum2spr (262);
    case sim_ppc_spr263_regnum: return regnum2spr (263);
    case sim_ppc_spr264_regnum: return regnum2spr (264);
    case sim_ppc_spr265_regnum: return regnum2spr (265);
    case sim_ppc_spr266_regnum: return regnum2spr (266);
    case sim_ppc_spr267_regnum: return regnum2spr (267);
    case sim_ppc_spr268_regnum: return regnum2spr (268);
    case sim_ppc_spr269_regnum: return regnum2spr (269);
    case sim_ppc_spr270_regnum: return regnum2spr (270);
    case sim_ppc_spr271_regnum: return regnum2spr (271);
    case sim_ppc_spr272_regnum: return regnum2spr (272);
    case sim_ppc_spr273_regnum: return regnum2spr (273);
    case sim_ppc_spr274_regnum: return regnum2spr (274);
    case sim_ppc_spr275_regnum: return regnum2spr (275);
    case sim_ppc_spr276_regnum: return regnum2spr (276);
    case sim_ppc_spr277_regnum: return regnum2spr (277);
    case sim_ppc_spr278_regnum: return regnum2spr (278);
    case sim_ppc_spr279_regnum: return regnum2spr (279);
    case sim_ppc_spr280_regnum: return regnum2spr (280);
    case sim_ppc_spr281_regnum: return regnum2spr (281);
    case sim_ppc_spr282_regnum: return regnum2spr (282);
    case sim_ppc_spr283_regnum: return regnum2spr (283);
    case sim_ppc_spr284_regnum: return regnum2spr (284);
    case sim_ppc_spr285_regnum: return regnum2spr (285);
    case sim_ppc_spr286_regnum: return regnum2spr (286);
    case sim_ppc_spr287_regnum: return regnum2spr (287);
    case sim_ppc_spr288_regnum: return regnum2spr (288);
    case sim_ppc_spr289_regnum: return regnum2spr (289);
    case sim_ppc_spr290_regnum: return regnum2spr (290);
    case sim_ppc_spr291_regnum: return regnum2spr (291);
    case sim_ppc_spr292_regnum: return regnum2spr (292);
    case sim_ppc_spr293_regnum: return regnum2spr (293);
    case sim_ppc_spr294_regnum: return regnum2spr (294);
    case sim_ppc_spr295_regnum: return regnum2spr (295);
    case sim_ppc_spr296_regnum: return regnum2spr (296);
    case sim_ppc_spr297_regnum: return regnum2spr (297);
    case sim_ppc_spr298_regnum: return regnum2spr (298);
    case sim_ppc_spr299_regnum: return regnum2spr (299);
    case sim_ppc_spr300_regnum: return regnum2spr (300);
    case sim_ppc_spr301_regnum: return regnum2spr (301);
    case sim_ppc_spr302_regnum: return regnum2spr (302);
    case sim_ppc_spr303_regnum: return regnum2spr (303);
    case sim_ppc_spr304_regnum: return regnum2spr (304);
    case sim_ppc_spr305_regnum: return regnum2spr (305);
    case sim_ppc_spr306_regnum: return regnum2spr (306);
    case sim_ppc_spr307_regnum: return regnum2spr (307);
    case sim_ppc_spr308_regnum: return regnum2spr (308);
    case sim_ppc_spr309_regnum: return regnum2spr (309);
    case sim_ppc_spr310_regnum: return regnum2spr (310);
    case sim_ppc_spr311_regnum: return regnum2spr (311);
    case sim_ppc_spr312_regnum: return regnum2spr (312);
    case sim_ppc_spr313_regnum: return regnum2spr (313);
    case sim_ppc_spr314_regnum: return regnum2spr (314);
    case sim_ppc_spr315_regnum: return regnum2spr (315);
    case sim_ppc_spr316_regnum: return regnum2spr (316);
    case sim_ppc_spr317_regnum: return regnum2spr (317);
    case sim_ppc_spr318_regnum: return regnum2spr (318);
    case sim_ppc_spr319_regnum: return regnum2spr (319);
    case sim_ppc_spr320_regnum: return regnum2spr (320);
    case sim_ppc_spr321_regnum: return regnum2spr (321);
    case sim_ppc_spr322_regnum: return regnum2spr (322);
    case sim_ppc_spr323_regnum: return regnum2spr (323);
    case sim_ppc_spr324_regnum: return regnum2spr (324);
    case sim_ppc_spr325_regnum: return regnum2spr (325);
    case sim_ppc_spr326_regnum: return regnum2spr (326);
    case sim_ppc_spr327_regnum: return regnum2spr (327);
    case sim_ppc_spr328_regnum: return regnum2spr (328);
    case sim_ppc_spr329_regnum: return regnum2spr (329);
    case sim_ppc_spr330_regnum: return regnum2spr (330);
    case sim_ppc_spr331_regnum: return regnum2spr (331);
    case sim_ppc_spr332_regnum: return regnum2spr (332);
    case sim_ppc_spr333_regnum: return regnum2spr (333);
    case sim_ppc_spr334_regnum: return regnum2spr (334);
    case sim_ppc_spr335_regnum: return regnum2spr (335);
    case sim_ppc_spr336_regnum: return regnum2spr (336);
    case sim_ppc_spr337_regnum: return regnum2spr (337);
    case sim_ppc_spr338_regnum: return regnum2spr (338);
    case sim_ppc_spr339_regnum: return regnum2spr (339);
    case sim_ppc_spr340_regnum: return regnum2spr (340);
    case sim_ppc_spr341_regnum: return regnum2spr (341);
    case sim_ppc_spr342_regnum: return regnum2spr (342);
    case sim_ppc_spr343_regnum: return regnum2spr (343);
    case sim_ppc_spr344_regnum: return regnum2spr (344);
    case sim_ppc_spr345_regnum: return regnum2spr (345);
    case sim_ppc_spr346_regnum: return regnum2spr (346);
    case sim_ppc_spr347_regnum: return regnum2spr (347);
    case sim_ppc_spr348_regnum: return regnum2spr (348);
    case sim_ppc_spr349_regnum: return regnum2spr (349);
    case sim_ppc_spr350_regnum: return regnum2spr (350);
    case sim_ppc_spr351_regnum: return regnum2spr (351);
    case sim_ppc_spr352_regnum: return regnum2spr (352);
    case sim_ppc_spr353_regnum: return regnum2spr (353);
    case sim_ppc_spr354_regnum: return regnum2spr (354);
    case sim_ppc_spr355_regnum: return regnum2spr (355);
    case sim_ppc_spr356_regnum: return regnum2spr (356);
    case sim_ppc_spr357_regnum: return regnum2spr (357);
    case sim_ppc_spr358_regnum: return regnum2spr (358);
    case sim_ppc_spr359_regnum: return regnum2spr (359);
    case sim_ppc_spr360_regnum: return regnum2spr (360);
    case sim_ppc_spr361_regnum: return regnum2spr (361);
    case sim_ppc_spr362_regnum: return regnum2spr (362);
    case sim_ppc_spr363_regnum: return regnum2spr (363);
    case sim_ppc_spr364_regnum: return regnum2spr (364);
    case sim_ppc_spr365_regnum: return regnum2spr (365);
    case sim_ppc_spr366_regnum: return regnum2spr (366);
    case sim_ppc_spr367_regnum: return regnum2spr (367);
    case sim_ppc_spr368_regnum: return regnum2spr (368);
    case sim_ppc_spr369_regnum: return regnum2spr (369);
    case sim_ppc_spr370_regnum: return regnum2spr (370);
    case sim_ppc_spr371_regnum: return regnum2spr (371);
    case sim_ppc_spr372_regnum: return regnum2spr (372);
    case sim_ppc_spr373_regnum: return regnum2spr (373);
    case sim_ppc_spr374_regnum: return regnum2spr (374);
    case sim_ppc_spr375_regnum: return regnum2spr (375);
    case sim_ppc_spr376_regnum: return regnum2spr (376);
    case sim_ppc_spr377_regnum: return regnum2spr (377);
    case sim_ppc_spr378_regnum: return regnum2spr (378);
    case sim_ppc_spr379_regnum: return regnum2spr (379);
    case sim_ppc_spr380_regnum: return regnum2spr (380);
    case sim_ppc_spr381_regnum: return regnum2spr (381);
    case sim_ppc_spr382_regnum: return regnum2spr (382);
    case sim_ppc_spr383_regnum: return regnum2spr (383);
    case sim_ppc_spr384_regnum: return regnum2spr (384);
    case sim_ppc_spr385_regnum: return regnum2spr (385);
    case sim_ppc_spr386_regnum: return regnum2spr (386);
    case sim_ppc_spr387_regnum: return regnum2spr (387);
    case sim_ppc_spr388_regnum: return regnum2spr (388);
    case sim_ppc_spr389_regnum: return regnum2spr (389);
    case sim_ppc_spr390_regnum: return regnum2spr (390);
    case sim_ppc_spr391_regnum: return regnum2spr (391);
    case sim_ppc_spr392_regnum: return regnum2spr (392);
    case sim_ppc_spr393_regnum: return regnum2spr (393);
    case sim_ppc_spr394_regnum: return regnum2spr (394);
    case sim_ppc_spr395_regnum: return regnum2spr (395);
    case sim_ppc_spr396_regnum: return regnum2spr (396);
    case sim_ppc_spr397_regnum: return regnum2spr (397);
    case sim_ppc_spr398_regnum: return regnum2spr (398);
    case sim_ppc_spr399_regnum: return regnum2spr (399);
    case sim_ppc_spr400_regnum: return regnum2spr (400);
    case sim_ppc_spr401_regnum: return regnum2spr (401);
    case sim_ppc_spr402_regnum: return regnum2spr (402);
    case sim_ppc_spr403_regnum: return regnum2spr (403);
    case sim_ppc_spr404_regnum: return regnum2spr (404);
    case sim_ppc_spr405_regnum: return regnum2spr (405);
    case sim_ppc_spr406_regnum: return regnum2spr (406);
    case sim_ppc_spr407_regnum: return regnum2spr (407);
    case sim_ppc_spr408_regnum: return regnum2spr (408);
    case sim_ppc_spr409_regnum: return regnum2spr (409);
    case sim_ppc_spr410_regnum: return regnum2spr (410);
    case sim_ppc_spr411_regnum: return regnum2spr (411);
    case sim_ppc_spr412_regnum: return regnum2spr (412);
    case sim_ppc_spr413_regnum: return regnum2spr (413);
    case sim_ppc_spr414_regnum: return regnum2spr (414);
    case sim_ppc_spr415_regnum: return regnum2spr (415);
    case sim_ppc_spr416_regnum: return regnum2spr (416);
    case sim_ppc_spr417_regnum: return regnum2spr (417);
    case sim_ppc_spr418_regnum: return regnum2spr (418);
    case sim_ppc_spr419_regnum: return regnum2spr (419);
    case sim_ppc_spr420_regnum: return regnum2spr (420);
    case sim_ppc_spr421_regnum: return regnum2spr (421);
    case sim_ppc_spr422_regnum: return regnum2spr (422);
    case sim_ppc_spr423_regnum: return regnum2spr (423);
    case sim_ppc_spr424_regnum: return regnum2spr (424);
    case sim_ppc_spr425_regnum: return regnum2spr (425);
    case sim_ppc_spr426_regnum: return regnum2spr (426);
    case sim_ppc_spr427_regnum: return regnum2spr (427);
    case sim_ppc_spr428_regnum: return regnum2spr (428);
    case sim_ppc_spr429_regnum: return regnum2spr (429);
    case sim_ppc_spr430_regnum: return regnum2spr (430);
    case sim_ppc_spr431_regnum: return regnum2spr (431);
    case sim_ppc_spr432_regnum: return regnum2spr (432);
    case sim_ppc_spr433_regnum: return regnum2spr (433);
    case sim_ppc_spr434_regnum: return regnum2spr (434);
    case sim_ppc_spr435_regnum: return regnum2spr (435);
    case sim_ppc_spr436_regnum: return regnum2spr (436);
    case sim_ppc_spr437_regnum: return regnum2spr (437);
    case sim_ppc_spr438_regnum: return regnum2spr (438);
    case sim_ppc_spr439_regnum: return regnum2spr (439);
    case sim_ppc_spr440_regnum: return regnum2spr (440);
    case sim_ppc_spr441_regnum: return regnum2spr (441);
    case sim_ppc_spr442_regnum: return regnum2spr (442);
    case sim_ppc_spr443_regnum: return regnum2spr (443);
    case sim_ppc_spr444_regnum: return regnum2spr (444);
    case sim_ppc_spr445_regnum: return regnum2spr (445);
    case sim_ppc_spr446_regnum: return regnum2spr (446);
    case sim_ppc_spr447_regnum: return regnum2spr (447);
    case sim_ppc_spr448_regnum: return regnum2spr (448);
    case sim_ppc_spr449_regnum: return regnum2spr (449);
    case sim_ppc_spr450_regnum: return regnum2spr (450);
    case sim_ppc_spr451_regnum: return regnum2spr (451);
    case sim_ppc_spr452_regnum: return regnum2spr (452);
    case sim_ppc_spr453_regnum: return regnum2spr (453);
    case sim_ppc_spr454_regnum: return regnum2spr (454);
    case sim_ppc_spr455_regnum: return regnum2spr (455);
    case sim_ppc_spr456_regnum: return regnum2spr (456);
    case sim_ppc_spr457_regnum: return regnum2spr (457);
    case sim_ppc_spr458_regnum: return regnum2spr (458);
    case sim_ppc_spr459_regnum: return regnum2spr (459);
    case sim_ppc_spr460_regnum: return regnum2spr (460);
    case sim_ppc_spr461_regnum: return regnum2spr (461);
    case sim_ppc_spr462_regnum: return regnum2spr (462);
    case sim_ppc_spr463_regnum: return regnum2spr (463);
    case sim_ppc_spr464_regnum: return regnum2spr (464);
    case sim_ppc_spr465_regnum: return regnum2spr (465);
    case sim_ppc_spr466_regnum: return regnum2spr (466);
    case sim_ppc_spr467_regnum: return regnum2spr (467);
    case sim_ppc_spr468_regnum: return regnum2spr (468);
    case sim_ppc_spr469_regnum: return regnum2spr (469);
    case sim_ppc_spr470_regnum: return regnum2spr (470);
    case sim_ppc_spr471_regnum: return regnum2spr (471);
    case sim_ppc_spr472_regnum: return regnum2spr (472);
    case sim_ppc_spr473_regnum: return regnum2spr (473);
    case sim_ppc_spr474_regnum: return regnum2spr (474);
    case sim_ppc_spr475_regnum: return regnum2spr (475);
    case sim_ppc_spr476_regnum: return regnum2spr (476);
    case sim_ppc_spr477_regnum: return regnum2spr (477);
    case sim_ppc_spr478_regnum: return regnum2spr (478);
    case sim_ppc_spr479_regnum: return regnum2spr (479);
    case sim_ppc_spr480_regnum: return regnum2spr (480);
    case sim_ppc_spr481_regnum: return regnum2spr (481);
    case sim_ppc_spr482_regnum: return regnum2spr (482);
    case sim_ppc_spr483_regnum: return regnum2spr (483);
    case sim_ppc_spr484_regnum: return regnum2spr (484);
    case sim_ppc_spr485_regnum: return regnum2spr (485);
    case sim_ppc_spr486_regnum: return regnum2spr (486);
    case sim_ppc_spr487_regnum: return regnum2spr (487);
    case sim_ppc_spr488_regnum: return regnum2spr (488);
    case sim_ppc_spr489_regnum: return regnum2spr (489);
    case sim_ppc_spr490_regnum: return regnum2spr (490);
    case sim_ppc_spr491_regnum: return regnum2spr (491);
    case sim_ppc_spr492_regnum: return regnum2spr (492);
    case sim_ppc_spr493_regnum: return regnum2spr (493);
    case sim_ppc_spr494_regnum: return regnum2spr (494);
    case sim_ppc_spr495_regnum: return regnum2spr (495);
    case sim_ppc_spr496_regnum: return regnum2spr (496);
    case sim_ppc_spr497_regnum: return regnum2spr (497);
    case sim_ppc_spr498_regnum: return regnum2spr (498);
    case sim_ppc_spr499_regnum: return regnum2spr (499);
    case sim_ppc_spr500_regnum: return regnum2spr (500);
    case sim_ppc_spr501_regnum: return regnum2spr (501);
    case sim_ppc_spr502_regnum: return regnum2spr (502);
    case sim_ppc_spr503_regnum: return regnum2spr (503);
    case sim_ppc_spr504_regnum: return regnum2spr (504);
    case sim_ppc_spr505_regnum: return regnum2spr (505);
    case sim_ppc_spr506_regnum: return regnum2spr (506);
    case sim_ppc_spr507_regnum: return regnum2spr (507);
    case sim_ppc_spr508_regnum: return regnum2spr (508);
    case sim_ppc_spr509_regnum: return regnum2spr (509);
    case sim_ppc_spr510_regnum: return regnum2spr (510);
    case sim_ppc_spr511_regnum: return regnum2spr (511);
    case sim_ppc_spr512_regnum: return regnum2spr (512);
    case sim_ppc_spr513_regnum: return regnum2spr (513);
    case sim_ppc_spr514_regnum: return regnum2spr (514);
    case sim_ppc_spr515_regnum: return regnum2spr (515);
    case sim_ppc_spr516_regnum: return regnum2spr (516);
    case sim_ppc_spr517_regnum: return regnum2spr (517);
    case sim_ppc_spr518_regnum: return regnum2spr (518);
    case sim_ppc_spr519_regnum: return regnum2spr (519);
    case sim_ppc_spr520_regnum: return regnum2spr (520);
    case sim_ppc_spr521_regnum: return regnum2spr (521);
    case sim_ppc_spr522_regnum: return regnum2spr (522);
    case sim_ppc_spr523_regnum: return regnum2spr (523);
    case sim_ppc_spr524_regnum: return regnum2spr (524);
    case sim_ppc_spr525_regnum: return regnum2spr (525);
    case sim_ppc_spr526_regnum: return regnum2spr (526);
    case sim_ppc_spr527_regnum: return regnum2spr (527);
    case sim_ppc_spr528_regnum: return regnum2spr (528);
    case sim_ppc_spr529_regnum: return regnum2spr (529);
    case sim_ppc_spr530_regnum: return regnum2spr (530);
    case sim_ppc_spr531_regnum: return regnum2spr (531);
    case sim_ppc_spr532_regnum: return regnum2spr (532);
    case sim_ppc_spr533_regnum: return regnum2spr (533);
    case sim_ppc_spr534_regnum: return regnum2spr (534);
    case sim_ppc_spr535_regnum: return regnum2spr (535);
    case sim_ppc_spr536_regnum: return regnum2spr (536);
    case sim_ppc_spr537_regnum: return regnum2spr (537);
    case sim_ppc_spr538_regnum: return regnum2spr (538);
    case sim_ppc_spr539_regnum: return regnum2spr (539);
    case sim_ppc_spr540_regnum: return regnum2spr (540);
    case sim_ppc_spr541_regnum: return regnum2spr (541);
    case sim_ppc_spr542_regnum: return regnum2spr (542);
    case sim_ppc_spr543_regnum: return regnum2spr (543);
    case sim_ppc_spr544_regnum: return regnum2spr (544);
    case sim_ppc_spr545_regnum: return regnum2spr (545);
    case sim_ppc_spr546_regnum: return regnum2spr (546);
    case sim_ppc_spr547_regnum: return regnum2spr (547);
    case sim_ppc_spr548_regnum: return regnum2spr (548);
    case sim_ppc_spr549_regnum: return regnum2spr (549);
    case sim_ppc_spr550_regnum: return regnum2spr (550);
    case sim_ppc_spr551_regnum: return regnum2spr (551);
    case sim_ppc_spr552_regnum: return regnum2spr (552);
    case sim_ppc_spr553_regnum: return regnum2spr (553);
    case sim_ppc_spr554_regnum: return regnum2spr (554);
    case sim_ppc_spr555_regnum: return regnum2spr (555);
    case sim_ppc_spr556_regnum: return regnum2spr (556);
    case sim_ppc_spr557_regnum: return regnum2spr (557);
    case sim_ppc_spr558_regnum: return regnum2spr (558);
    case sim_ppc_spr559_regnum: return regnum2spr (559);
    case sim_ppc_spr560_regnum: return regnum2spr (560);
    case sim_ppc_spr561_regnum: return regnum2spr (561);
    case sim_ppc_spr562_regnum: return regnum2spr (562);
    case sim_ppc_spr563_regnum: return regnum2spr (563);
    case sim_ppc_spr564_regnum: return regnum2spr (564);
    case sim_ppc_spr565_regnum: return regnum2spr (565);
    case sim_ppc_spr566_regnum: return regnum2spr (566);
    case sim_ppc_spr567_regnum: return regnum2spr (567);
    case sim_ppc_spr568_regnum: return regnum2spr (568);
    case sim_ppc_spr569_regnum: return regnum2spr (569);
    case sim_ppc_spr570_regnum: return regnum2spr (570);
    case sim_ppc_spr571_regnum: return regnum2spr (571);
    case sim_ppc_spr572_regnum: return regnum2spr (572);
    case sim_ppc_spr573_regnum: return regnum2spr (573);
    case sim_ppc_spr574_regnum: return regnum2spr (574);
    case sim_ppc_spr575_regnum: return regnum2spr (575);
    case sim_ppc_spr576_regnum: return regnum2spr (576);
    case sim_ppc_spr577_regnum: return regnum2spr (577);
    case sim_ppc_spr578_regnum: return regnum2spr (578);
    case sim_ppc_spr579_regnum: return regnum2spr (579);
    case sim_ppc_spr580_regnum: return regnum2spr (580);
    case sim_ppc_spr581_regnum: return regnum2spr (581);
    case sim_ppc_spr582_regnum: return regnum2spr (582);
    case sim_ppc_spr583_regnum: return regnum2spr (583);
    case sim_ppc_spr584_regnum: return regnum2spr (584);
    case sim_ppc_spr585_regnum: return regnum2spr (585);
    case sim_ppc_spr586_regnum: return regnum2spr (586);
    case sim_ppc_spr587_regnum: return regnum2spr (587);
    case sim_ppc_spr588_regnum: return regnum2spr (588);
    case sim_ppc_spr589_regnum: return regnum2spr (589);
    case sim_ppc_spr590_regnum: return regnum2spr (590);
    case sim_ppc_spr591_regnum: return regnum2spr (591);
    case sim_ppc_spr592_regnum: return regnum2spr (592);
    case sim_ppc_spr593_regnum: return regnum2spr (593);
    case sim_ppc_spr594_regnum: return regnum2spr (594);
    case sim_ppc_spr595_regnum: return regnum2spr (595);
    case sim_ppc_spr596_regnum: return regnum2spr (596);
    case sim_ppc_spr597_regnum: return regnum2spr (597);
    case sim_ppc_spr598_regnum: return regnum2spr (598);
    case sim_ppc_spr599_regnum: return regnum2spr (599);
    case sim_ppc_spr600_regnum: return regnum2spr (600);
    case sim_ppc_spr601_regnum: return regnum2spr (601);
    case sim_ppc_spr602_regnum: return regnum2spr (602);
    case sim_ppc_spr603_regnum: return regnum2spr (603);
    case sim_ppc_spr604_regnum: return regnum2spr (604);
    case sim_ppc_spr605_regnum: return regnum2spr (605);
    case sim_ppc_spr606_regnum: return regnum2spr (606);
    case sim_ppc_spr607_regnum: return regnum2spr (607);
    case sim_ppc_spr608_regnum: return regnum2spr (608);
    case sim_ppc_spr609_regnum: return regnum2spr (609);
    case sim_ppc_spr610_regnum: return regnum2spr (610);
    case sim_ppc_spr611_regnum: return regnum2spr (611);
    case sim_ppc_spr612_regnum: return regnum2spr (612);
    case sim_ppc_spr613_regnum: return regnum2spr (613);
    case sim_ppc_spr614_regnum: return regnum2spr (614);
    case sim_ppc_spr615_regnum: return regnum2spr (615);
    case sim_ppc_spr616_regnum: return regnum2spr (616);
    case sim_ppc_spr617_regnum: return regnum2spr (617);
    case sim_ppc_spr618_regnum: return regnum2spr (618);
    case sim_ppc_spr619_regnum: return regnum2spr (619);
    case sim_ppc_spr620_regnum: return regnum2spr (620);
    case sim_ppc_spr621_regnum: return regnum2spr (621);
    case sim_ppc_spr622_regnum: return regnum2spr (622);
    case sim_ppc_spr623_regnum: return regnum2spr (623);
    case sim_ppc_spr624_regnum: return regnum2spr (624);
    case sim_ppc_spr625_regnum: return regnum2spr (625);
    case sim_ppc_spr626_regnum: return regnum2spr (626);
    case sim_ppc_spr627_regnum: return regnum2spr (627);
    case sim_ppc_spr628_regnum: return regnum2spr (628);
    case sim_ppc_spr629_regnum: return regnum2spr (629);
    case sim_ppc_spr630_regnum: return regnum2spr (630);
    case sim_ppc_spr631_regnum: return regnum2spr (631);
    case sim_ppc_spr632_regnum: return regnum2spr (632);
    case sim_ppc_spr633_regnum: return regnum2spr (633);
    case sim_ppc_spr634_regnum: return regnum2spr (634);
    case sim_ppc_spr635_regnum: return regnum2spr (635);
    case sim_ppc_spr636_regnum: return regnum2spr (636);
    case sim_ppc_spr637_regnum: return regnum2spr (637);
    case sim_ppc_spr638_regnum: return regnum2spr (638);
    case sim_ppc_spr639_regnum: return regnum2spr (639);
    case sim_ppc_spr640_regnum: return regnum2spr (640);
    case sim_ppc_spr641_regnum: return regnum2spr (641);
    case sim_ppc_spr642_regnum: return regnum2spr (642);
    case sim_ppc_spr643_regnum: return regnum2spr (643);
    case sim_ppc_spr644_regnum: return regnum2spr (644);
    case sim_ppc_spr645_regnum: return regnum2spr (645);
    case sim_ppc_spr646_regnum: return regnum2spr (646);
    case sim_ppc_spr647_regnum: return regnum2spr (647);
    case sim_ppc_spr648_regnum: return regnum2spr (648);
    case sim_ppc_spr649_regnum: return regnum2spr (649);
    case sim_ppc_spr650_regnum: return regnum2spr (650);
    case sim_ppc_spr651_regnum: return regnum2spr (651);
    case sim_ppc_spr652_regnum: return regnum2spr (652);
    case sim_ppc_spr653_regnum: return regnum2spr (653);
    case sim_ppc_spr654_regnum: return regnum2spr (654);
    case sim_ppc_spr655_regnum: return regnum2spr (655);
    case sim_ppc_spr656_regnum: return regnum2spr (656);
    case sim_ppc_spr657_regnum: return regnum2spr (657);
    case sim_ppc_spr658_regnum: return regnum2spr (658);
    case sim_ppc_spr659_regnum: return regnum2spr (659);
    case sim_ppc_spr660_regnum: return regnum2spr (660);
    case sim_ppc_spr661_regnum: return regnum2spr (661);
    case sim_ppc_spr662_regnum: return regnum2spr (662);
    case sim_ppc_spr663_regnum: return regnum2spr (663);
    case sim_ppc_spr664_regnum: return regnum2spr (664);
    case sim_ppc_spr665_regnum: return regnum2spr (665);
    case sim_ppc_spr666_regnum: return regnum2spr (666);
    case sim_ppc_spr667_regnum: return regnum2spr (667);
    case sim_ppc_spr668_regnum: return regnum2spr (668);
    case sim_ppc_spr669_regnum: return regnum2spr (669);
    case sim_ppc_spr670_regnum: return regnum2spr (670);
    case sim_ppc_spr671_regnum: return regnum2spr (671);
    case sim_ppc_spr672_regnum: return regnum2spr (672);
    case sim_ppc_spr673_regnum: return regnum2spr (673);
    case sim_ppc_spr674_regnum: return regnum2spr (674);
    case sim_ppc_spr675_regnum: return regnum2spr (675);
    case sim_ppc_spr676_regnum: return regnum2spr (676);
    case sim_ppc_spr677_regnum: return regnum2spr (677);
    case sim_ppc_spr678_regnum: return regnum2spr (678);
    case sim_ppc_spr679_regnum: return regnum2spr (679);
    case sim_ppc_spr680_regnum: return regnum2spr (680);
    case sim_ppc_spr681_regnum: return regnum2spr (681);
    case sim_ppc_spr682_regnum: return regnum2spr (682);
    case sim_ppc_spr683_regnum: return regnum2spr (683);
    case sim_ppc_spr684_regnum: return regnum2spr (684);
    case sim_ppc_spr685_regnum: return regnum2spr (685);
    case sim_ppc_spr686_regnum: return regnum2spr (686);
    case sim_ppc_spr687_regnum: return regnum2spr (687);
    case sim_ppc_spr688_regnum: return regnum2spr (688);
    case sim_ppc_spr689_regnum: return regnum2spr (689);
    case sim_ppc_spr690_regnum: return regnum2spr (690);
    case sim_ppc_spr691_regnum: return regnum2spr (691);
    case sim_ppc_spr692_regnum: return regnum2spr (692);
    case sim_ppc_spr693_regnum: return regnum2spr (693);
    case sim_ppc_spr694_regnum: return regnum2spr (694);
    case sim_ppc_spr695_regnum: return regnum2spr (695);
    case sim_ppc_spr696_regnum: return regnum2spr (696);
    case sim_ppc_spr697_regnum: return regnum2spr (697);
    case sim_ppc_spr698_regnum: return regnum2spr (698);
    case sim_ppc_spr699_regnum: return regnum2spr (699);
    case sim_ppc_spr700_regnum: return regnum2spr (700);
    case sim_ppc_spr701_regnum: return regnum2spr (701);
    case sim_ppc_spr702_regnum: return regnum2spr (702);
    case sim_ppc_spr703_regnum: return regnum2spr (703);
    case sim_ppc_spr704_regnum: return regnum2spr (704);
    case sim_ppc_spr705_regnum: return regnum2spr (705);
    case sim_ppc_spr706_regnum: return regnum2spr (706);
    case sim_ppc_spr707_regnum: return regnum2spr (707);
    case sim_ppc_spr708_regnum: return regnum2spr (708);
    case sim_ppc_spr709_regnum: return regnum2spr (709);
    case sim_ppc_spr710_regnum: return regnum2spr (710);
    case sim_ppc_spr711_regnum: return regnum2spr (711);
    case sim_ppc_spr712_regnum: return regnum2spr (712);
    case sim_ppc_spr713_regnum: return regnum2spr (713);
    case sim_ppc_spr714_regnum: return regnum2spr (714);
    case sim_ppc_spr715_regnum: return regnum2spr (715);
    case sim_ppc_spr716_regnum: return regnum2spr (716);
    case sim_ppc_spr717_regnum: return regnum2spr (717);
    case sim_ppc_spr718_regnum: return regnum2spr (718);
    case sim_ppc_spr719_regnum: return regnum2spr (719);
    case sim_ppc_spr720_regnum: return regnum2spr (720);
    case sim_ppc_spr721_regnum: return regnum2spr (721);
    case sim_ppc_spr722_regnum: return regnum2spr (722);
    case sim_ppc_spr723_regnum: return regnum2spr (723);
    case sim_ppc_spr724_regnum: return regnum2spr (724);
    case sim_ppc_spr725_regnum: return regnum2spr (725);
    case sim_ppc_spr726_regnum: return regnum2spr (726);
    case sim_ppc_spr727_regnum: return regnum2spr (727);
    case sim_ppc_spr728_regnum: return regnum2spr (728);
    case sim_ppc_spr729_regnum: return regnum2spr (729);
    case sim_ppc_spr730_regnum: return regnum2spr (730);
    case sim_ppc_spr731_regnum: return regnum2spr (731);
    case sim_ppc_spr732_regnum: return regnum2spr (732);
    case sim_ppc_spr733_regnum: return regnum2spr (733);
    case sim_ppc_spr734_regnum: return regnum2spr (734);
    case sim_ppc_spr735_regnum: return regnum2spr (735);
    case sim_ppc_spr736_regnum: return regnum2spr (736);
    case sim_ppc_spr737_regnum: return regnum2spr (737);
    case sim_ppc_spr738_regnum: return regnum2spr (738);
    case sim_ppc_spr739_regnum: return regnum2spr (739);
    case sim_ppc_spr740_regnum: return regnum2spr (740);
    case sim_ppc_spr741_regnum: return regnum2spr (741);
    case sim_ppc_spr742_regnum: return regnum2spr (742);
    case sim_ppc_spr743_regnum: return regnum2spr (743);
    case sim_ppc_spr744_regnum: return regnum2spr (744);
    case sim_ppc_spr745_regnum: return regnum2spr (745);
    case sim_ppc_spr746_regnum: return regnum2spr (746);
    case sim_ppc_spr747_regnum: return regnum2spr (747);
    case sim_ppc_spr748_regnum: return regnum2spr (748);
    case sim_ppc_spr749_regnum: return regnum2spr (749);
    case sim_ppc_spr750_regnum: return regnum2spr (750);
    case sim_ppc_spr751_regnum: return regnum2spr (751);
    case sim_ppc_spr752_regnum: return regnum2spr (752);
    case sim_ppc_spr753_regnum: return regnum2spr (753);
    case sim_ppc_spr754_regnum: return regnum2spr (754);
    case sim_ppc_spr755_regnum: return regnum2spr (755);
    case sim_ppc_spr756_regnum: return regnum2spr (756);
    case sim_ppc_spr757_regnum: return regnum2spr (757);
    case sim_ppc_spr758_regnum: return regnum2spr (758);
    case sim_ppc_spr759_regnum: return regnum2spr (759);
    case sim_ppc_spr760_regnum: return regnum2spr (760);
    case sim_ppc_spr761_regnum: return regnum2spr (761);
    case sim_ppc_spr762_regnum: return regnum2spr (762);
    case sim_ppc_spr763_regnum: return regnum2spr (763);
    case sim_ppc_spr764_regnum: return regnum2spr (764);
    case sim_ppc_spr765_regnum: return regnum2spr (765);
    case sim_ppc_spr766_regnum: return regnum2spr (766);
    case sim_ppc_spr767_regnum: return regnum2spr (767);
    case sim_ppc_spr768_regnum: return regnum2spr (768);
    case sim_ppc_spr769_regnum: return regnum2spr (769);
    case sim_ppc_spr770_regnum: return regnum2spr (770);
    case sim_ppc_spr771_regnum: return regnum2spr (771);
    case sim_ppc_spr772_regnum: return regnum2spr (772);
    case sim_ppc_spr773_regnum: return regnum2spr (773);
    case sim_ppc_spr774_regnum: return regnum2spr (774);
    case sim_ppc_spr775_regnum: return regnum2spr (775);
    case sim_ppc_spr776_regnum: return regnum2spr (776);
    case sim_ppc_spr777_regnum: return regnum2spr (777);
    case sim_ppc_spr778_regnum: return regnum2spr (778);
    case sim_ppc_spr779_regnum: return regnum2spr (779);
    case sim_ppc_spr780_regnum: return regnum2spr (780);
    case sim_ppc_spr781_regnum: return regnum2spr (781);
    case sim_ppc_spr782_regnum: return regnum2spr (782);
    case sim_ppc_spr783_regnum: return regnum2spr (783);
    case sim_ppc_spr784_regnum: return regnum2spr (784);
    case sim_ppc_spr785_regnum: return regnum2spr (785);
    case sim_ppc_spr786_regnum: return regnum2spr (786);
    case sim_ppc_spr787_regnum: return regnum2spr (787);
    case sim_ppc_spr788_regnum: return regnum2spr (788);
    case sim_ppc_spr789_regnum: return regnum2spr (789);
    case sim_ppc_spr790_regnum: return regnum2spr (790);
    case sim_ppc_spr791_regnum: return regnum2spr (791);
    case sim_ppc_spr792_regnum: return regnum2spr (792);
    case sim_ppc_spr793_regnum: return regnum2spr (793);
    case sim_ppc_spr794_regnum: return regnum2spr (794);
    case sim_ppc_spr795_regnum: return regnum2spr (795);
    case sim_ppc_spr796_regnum: return regnum2spr (796);
    case sim_ppc_spr797_regnum: return regnum2spr (797);
    case sim_ppc_spr798_regnum: return regnum2spr (798);
    case sim_ppc_spr799_regnum: return regnum2spr (799);
    case sim_ppc_spr800_regnum: return regnum2spr (800);
    case sim_ppc_spr801_regnum: return regnum2spr (801);
    case sim_ppc_spr802_regnum: return regnum2spr (802);
    case sim_ppc_spr803_regnum: return regnum2spr (803);
    case sim_ppc_spr804_regnum: return regnum2spr (804);
    case sim_ppc_spr805_regnum: return regnum2spr (805);
    case sim_ppc_spr806_regnum: return regnum2spr (806);
    case sim_ppc_spr807_regnum: return regnum2spr (807);
    case sim_ppc_spr808_regnum: return regnum2spr (808);
    case sim_ppc_spr809_regnum: return regnum2spr (809);
    case sim_ppc_spr810_regnum: return regnum2spr (810);
    case sim_ppc_spr811_regnum: return regnum2spr (811);
    case sim_ppc_spr812_regnum: return regnum2spr (812);
    case sim_ppc_spr813_regnum: return regnum2spr (813);
    case sim_ppc_spr814_regnum: return regnum2spr (814);
    case sim_ppc_spr815_regnum: return regnum2spr (815);
    case sim_ppc_spr816_regnum: return regnum2spr (816);
    case sim_ppc_spr817_regnum: return regnum2spr (817);
    case sim_ppc_spr818_regnum: return regnum2spr (818);
    case sim_ppc_spr819_regnum: return regnum2spr (819);
    case sim_ppc_spr820_regnum: return regnum2spr (820);
    case sim_ppc_spr821_regnum: return regnum2spr (821);
    case sim_ppc_spr822_regnum: return regnum2spr (822);
    case sim_ppc_spr823_regnum: return regnum2spr (823);
    case sim_ppc_spr824_regnum: return regnum2spr (824);
    case sim_ppc_spr825_regnum: return regnum2spr (825);
    case sim_ppc_spr826_regnum: return regnum2spr (826);
    case sim_ppc_spr827_regnum: return regnum2spr (827);
    case sim_ppc_spr828_regnum: return regnum2spr (828);
    case sim_ppc_spr829_regnum: return regnum2spr (829);
    case sim_ppc_spr830_regnum: return regnum2spr (830);
    case sim_ppc_spr831_regnum: return regnum2spr (831);
    case sim_ppc_spr832_regnum: return regnum2spr (832);
    case sim_ppc_spr833_regnum: return regnum2spr (833);
    case sim_ppc_spr834_regnum: return regnum2spr (834);
    case sim_ppc_spr835_regnum: return regnum2spr (835);
    case sim_ppc_spr836_regnum: return regnum2spr (836);
    case sim_ppc_spr837_regnum: return regnum2spr (837);
    case sim_ppc_spr838_regnum: return regnum2spr (838);
    case sim_ppc_spr839_regnum: return regnum2spr (839);
    case sim_ppc_spr840_regnum: return regnum2spr (840);
    case sim_ppc_spr841_regnum: return regnum2spr (841);
    case sim_ppc_spr842_regnum: return regnum2spr (842);
    case sim_ppc_spr843_regnum: return regnum2spr (843);
    case sim_ppc_spr844_regnum: return regnum2spr (844);
    case sim_ppc_spr845_regnum: return regnum2spr (845);
    case sim_ppc_spr846_regnum: return regnum2spr (846);
    case sim_ppc_spr847_regnum: return regnum2spr (847);
    case sim_ppc_spr848_regnum: return regnum2spr (848);
    case sim_ppc_spr849_regnum: return regnum2spr (849);
    case sim_ppc_spr850_regnum: return regnum2spr (850);
    case sim_ppc_spr851_regnum: return regnum2spr (851);
    case sim_ppc_spr852_regnum: return regnum2spr (852);
    case sim_ppc_spr853_regnum: return regnum2spr (853);
    case sim_ppc_spr854_regnum: return regnum2spr (854);
    case sim_ppc_spr855_regnum: return regnum2spr (855);
    case sim_ppc_spr856_regnum: return regnum2spr (856);
    case sim_ppc_spr857_regnum: return regnum2spr (857);
    case sim_ppc_spr858_regnum: return regnum2spr (858);
    case sim_ppc_spr859_regnum: return regnum2spr (859);
    case sim_ppc_spr860_regnum: return regnum2spr (860);
    case sim_ppc_spr861_regnum: return regnum2spr (861);
    case sim_ppc_spr862_regnum: return regnum2spr (862);
    case sim_ppc_spr863_regnum: return regnum2spr (863);
    case sim_ppc_spr864_regnum: return regnum2spr (864);
    case sim_ppc_spr865_regnum: return regnum2spr (865);
    case sim_ppc_spr866_regnum: return regnum2spr (866);
    case sim_ppc_spr867_regnum: return regnum2spr (867);
    case sim_ppc_spr868_regnum: return regnum2spr (868);
    case sim_ppc_spr869_regnum: return regnum2spr (869);
    case sim_ppc_spr870_regnum: return regnum2spr (870);
    case sim_ppc_spr871_regnum: return regnum2spr (871);
    case sim_ppc_spr872_regnum: return regnum2spr (872);
    case sim_ppc_spr873_regnum: return regnum2spr (873);
    case sim_ppc_spr874_regnum: return regnum2spr (874);
    case sim_ppc_spr875_regnum: return regnum2spr (875);
    case sim_ppc_spr876_regnum: return regnum2spr (876);
    case sim_ppc_spr877_regnum: return regnum2spr (877);
    case sim_ppc_spr878_regnum: return regnum2spr (878);
    case sim_ppc_spr879_regnum: return regnum2spr (879);
    case sim_ppc_spr880_regnum: return regnum2spr (880);
    case sim_ppc_spr881_regnum: return regnum2spr (881);
    case sim_ppc_spr882_regnum: return regnum2spr (882);
    case sim_ppc_spr883_regnum: return regnum2spr (883);
    case sim_ppc_spr884_regnum: return regnum2spr (884);
    case sim_ppc_spr885_regnum: return regnum2spr (885);
    case sim_ppc_spr886_regnum: return regnum2spr (886);
    case sim_ppc_spr887_regnum: return regnum2spr (887);
    case sim_ppc_spr888_regnum: return regnum2spr (888);
    case sim_ppc_spr889_regnum: return regnum2spr (889);
    case sim_ppc_spr890_regnum: return regnum2spr (890);
    case sim_ppc_spr891_regnum: return regnum2spr (891);
    case sim_ppc_spr892_regnum: return regnum2spr (892);
    case sim_ppc_spr893_regnum: return regnum2spr (893);
    case sim_ppc_spr894_regnum: return regnum2spr (894);
    case sim_ppc_spr895_regnum: return regnum2spr (895);
    case sim_ppc_spr896_regnum: return regnum2spr (896);
    case sim_ppc_spr897_regnum: return regnum2spr (897);
    case sim_ppc_spr898_regnum: return regnum2spr (898);
    case sim_ppc_spr899_regnum: return regnum2spr (899);
    case sim_ppc_spr900_regnum: return regnum2spr (900);
    case sim_ppc_spr901_regnum: return regnum2spr (901);
    case sim_ppc_spr902_regnum: return regnum2spr (902);
    case sim_ppc_spr903_regnum: return regnum2spr (903);
    case sim_ppc_spr904_regnum: return regnum2spr (904);
    case sim_ppc_spr905_regnum: return regnum2spr (905);
    case sim_ppc_spr906_regnum: return regnum2spr (906);
    case sim_ppc_spr907_regnum: return regnum2spr (907);
    case sim_ppc_spr908_regnum: return regnum2spr (908);
    case sim_ppc_spr909_regnum: return regnum2spr (909);
    case sim_ppc_spr910_regnum: return regnum2spr (910);
    case sim_ppc_spr911_regnum: return regnum2spr (911);
    case sim_ppc_spr912_regnum: return regnum2spr (912);
    case sim_ppc_spr913_regnum: return regnum2spr (913);
    case sim_ppc_spr914_regnum: return regnum2spr (914);
    case sim_ppc_spr915_regnum: return regnum2spr (915);
    case sim_ppc_spr916_regnum: return regnum2spr (916);
    case sim_ppc_spr917_regnum: return regnum2spr (917);
    case sim_ppc_spr918_regnum: return regnum2spr (918);
    case sim_ppc_spr919_regnum: return regnum2spr (919);
    case sim_ppc_spr920_regnum: return regnum2spr (920);
    case sim_ppc_spr921_regnum: return regnum2spr (921);
    case sim_ppc_spr922_regnum: return regnum2spr (922);
    case sim_ppc_spr923_regnum: return regnum2spr (923);
    case sim_ppc_spr924_regnum: return regnum2spr (924);
    case sim_ppc_spr925_regnum: return regnum2spr (925);
    case sim_ppc_spr926_regnum: return regnum2spr (926);
    case sim_ppc_spr927_regnum: return regnum2spr (927);
    case sim_ppc_spr928_regnum: return regnum2spr (928);
    case sim_ppc_spr929_regnum: return regnum2spr (929);
    case sim_ppc_spr930_regnum: return regnum2spr (930);
    case sim_ppc_spr931_regnum: return regnum2spr (931);
    case sim_ppc_spr932_regnum: return regnum2spr (932);
    case sim_ppc_spr933_regnum: return regnum2spr (933);
    case sim_ppc_spr934_regnum: return regnum2spr (934);
    case sim_ppc_spr935_regnum: return regnum2spr (935);
    case sim_ppc_spr936_regnum: return regnum2spr (936);
    case sim_ppc_spr937_regnum: return regnum2spr (937);
    case sim_ppc_spr938_regnum: return regnum2spr (938);
    case sim_ppc_spr939_regnum: return regnum2spr (939);
    case sim_ppc_spr940_regnum: return regnum2spr (940);
    case sim_ppc_spr941_regnum: return regnum2spr (941);
    case sim_ppc_spr942_regnum: return regnum2spr (942);
    case sim_ppc_spr943_regnum: return regnum2spr (943);
    case sim_ppc_spr944_regnum: return regnum2spr (944);
    case sim_ppc_spr945_regnum: return regnum2spr (945);
    case sim_ppc_spr946_regnum: return regnum2spr (946);
    case sim_ppc_spr947_regnum: return regnum2spr (947);
    case sim_ppc_spr948_regnum: return regnum2spr (948);
    case sim_ppc_spr949_regnum: return regnum2spr (949);
    case sim_ppc_spr950_regnum: return regnum2spr (950);
    case sim_ppc_spr951_regnum: return regnum2spr (951);
    case sim_ppc_spr952_regnum: return regnum2spr (952);
    case sim_ppc_spr953_regnum: return regnum2spr (953);
    case sim_ppc_spr954_regnum: return regnum2spr (954);
    case sim_ppc_spr955_regnum: return regnum2spr (955);
    case sim_ppc_spr956_regnum: return regnum2spr (956);
    case sim_ppc_spr957_regnum: return regnum2spr (957);
    case sim_ppc_spr958_regnum: return regnum2spr (958);
    case sim_ppc_spr959_regnum: return regnum2spr (959);
    case sim_ppc_spr960_regnum: return regnum2spr (960);
    case sim_ppc_spr961_regnum: return regnum2spr (961);
    case sim_ppc_spr962_regnum: return regnum2spr (962);
    case sim_ppc_spr963_regnum: return regnum2spr (963);
    case sim_ppc_spr964_regnum: return regnum2spr (964);
    case sim_ppc_spr965_regnum: return regnum2spr (965);
    case sim_ppc_spr966_regnum: return regnum2spr (966);
    case sim_ppc_spr967_regnum: return regnum2spr (967);
    case sim_ppc_spr968_regnum: return regnum2spr (968);
    case sim_ppc_spr969_regnum: return regnum2spr (969);
    case sim_ppc_spr970_regnum: return regnum2spr (970);
    case sim_ppc_spr971_regnum: return regnum2spr (971);
    case sim_ppc_spr972_regnum: return regnum2spr (972);
    case sim_ppc_spr973_regnum: return regnum2spr (973);
    case sim_ppc_spr974_regnum: return regnum2spr (974);
    case sim_ppc_spr975_regnum: return regnum2spr (975);
    case sim_ppc_spr976_regnum: return regnum2spr (976);
    case sim_ppc_spr977_regnum: return regnum2spr (977);
    case sim_ppc_spr978_regnum: return regnum2spr (978);
    case sim_ppc_spr979_regnum: return regnum2spr (979);
    case sim_ppc_spr980_regnum: return regnum2spr (980);
    case sim_ppc_spr981_regnum: return regnum2spr (981);
    case sim_ppc_spr982_regnum: return regnum2spr (982);
    case sim_ppc_spr983_regnum: return regnum2spr (983);
    case sim_ppc_spr984_regnum: return regnum2spr (984);
    case sim_ppc_spr985_regnum: return regnum2spr (985);
    case sim_ppc_spr986_regnum: return regnum2spr (986);
    case sim_ppc_spr987_regnum: return regnum2spr (987);
    case sim_ppc_spr988_regnum: return regnum2spr (988);
    case sim_ppc_spr989_regnum: return regnum2spr (989);
    case sim_ppc_spr990_regnum: return regnum2spr (990);
    case sim_ppc_spr991_regnum: return regnum2spr (991);
    case sim_ppc_spr992_regnum: return regnum2spr (992);
    case sim_ppc_spr993_regnum: return regnum2spr (993);
    case sim_ppc_spr994_regnum: return regnum2spr (994);
    case sim_ppc_spr995_regnum: return regnum2spr (995);
    case sim_ppc_spr996_regnum: return regnum2spr (996);
    case sim_ppc_spr997_regnum: return regnum2spr (997);
    case sim_ppc_spr998_regnum: return regnum2spr (998);
    case sim_ppc_spr999_regnum: return regnum2spr (999);
    case sim_ppc_spr1000_regnum: return regnum2spr (1000);
    case sim_ppc_spr1001_regnum: return regnum2spr (1001);
    case sim_ppc_spr1002_regnum: return regnum2spr (1002);
    case sim_ppc_spr1003_regnum: return regnum2spr (1003);
    case sim_ppc_spr1004_regnum: return regnum2spr (1004);
    case sim_ppc_spr1005_regnum: return regnum2spr (1005);
    case sim_ppc_spr1006_regnum: return regnum2spr (1006);
    case sim_ppc_spr1007_regnum: return regnum2spr (1007);
    case sim_ppc_spr1008_regnum: return regnum2spr (1008);
    case sim_ppc_spr1009_regnum: return regnum2spr (1009);
    case sim_ppc_spr1010_regnum: return regnum2spr (1010);
    case sim_ppc_spr1011_regnum: return regnum2spr (1011);
    case sim_ppc_spr1012_regnum: return regnum2spr (1012);
    case sim_ppc_spr1013_regnum: return regnum2spr (1013);
    case sim_ppc_spr1014_regnum: return regnum2spr (1014);
    case sim_ppc_spr1015_regnum: return regnum2spr (1015);
    case sim_ppc_spr1016_regnum: return regnum2spr (1016);
    case sim_ppc_spr1017_regnum: return regnum2spr (1017);
    case sim_ppc_spr1018_regnum: return regnum2spr (1018);
    case sim_ppc_spr1019_regnum: return regnum2spr (1019);
    case sim_ppc_spr1020_regnum: return regnum2spr (1020);
    case sim_ppc_spr1021_regnum: return regnum2spr (1021);
    case sim_ppc_spr1022_regnum: return regnum2spr (1022);
    case sim_ppc_spr1023_regnum: return regnum2spr (1023);
    default:
      /* Not a valid register number at all.  */
      return NULL;
    }
}


int
sim_fetch_register (SIM_DESC sd, int regno, unsigned char *buf, int length)
{
  const char *regname = regnum2name (regno);

  if (simulator == NULL || regname == NULL)
    return -1;

  TRACE(trace_gdb, ("sim_fetch_register(regno=%d(%s), buf=0x%lx)\n",
		    regno, regname, (long)buf));
  return psim_read_register(simulator, MAX_NR_PROCESSORS,
			    buf, regname, raw_transfer);
}


int
sim_store_register (SIM_DESC sd, int regno, unsigned char *buf, int length)
{
  const char *regname = regnum2name (regno);

  if (simulator == NULL || regname == NULL)
    return 0;

  TRACE(trace_gdb, ("sim_store_register(regno=%d(%s), buf=0x%lx)\n",
		    regno, regname, (long)buf));
  return psim_write_register(simulator, MAX_NR_PROCESSORS,
			     buf, regname, raw_transfer);
}
