#!/bin/sh
# -*-ksh-*-

# This is the BINS install procedure.
# Run it as root to install BINS system wide
# or run it with your user to install it only for this user

# PREFIX, RC and DESTDIR environment variables can be set to choose
# installation paths

# $Id: install.sh,v 1.34 2005/08/24 21:29:44 jerome Exp $

set -o errexit
set -o nounset

langs="fr de pl it ru es zh_TW nl ja eo fi hu ca"
templates="swigs joi satyap marc petrus mwolson martin"

DESTDIR="${DESTDIR:-}" # prefix to append to the install dirs
                       # this is used by the Mandrake and Debian packages
PREFIX="${PREFIX:-/usr/local}"
ETC="${ETC:-/etc}"
RC="${RC:-/etc/bins}"
GLOBAL_RC="$RC"

DESTDIR=`echo "$DESTDIR"|sed 's%/$%%'`
PREFIX=$DESTDIR/`echo "$PREFIX"|sed 's%^/%%'`
PREFIX=`echo "$PREFIX"|sed 's%/$%%'`
ETC=$DESTDIR/`echo "$ETC"|sed 's%^/%%'`
ETC=`echo "$ETC"|sed 's%/$%%'`
RC=$DESTDIR/`echo "$RC"|sed 's%^/%%'`
RC=`echo "$RC"|sed 's%/$%%'`

BIN="$PREFIX/bin"
SHARE="$PREFIX/share"
DATA="$SHARE/bins"
GLADE="$DATA"
LOCALE="$SHARE/locale"
MAN="$PREFIX/man/man1"

cd `dirname $0`

cat <<!EoF

This will install BINS program and configuration files in the following paths :
PREFIX = $PREFIX
BIN    = $BIN
SHARE  = $GLADE
MAN    = $MAN
LOCALE = $LOCALE
RC     = $RC

***************************** WARNING ********************************
Note that this may replace your old programs, configuration files and
HTML templates by new ones, so you should backup them if you have
modified something for personalization.
**********************************************************************

Press Enter to go on or Crtl-C to stop now...
!EoF

read dummy

install_binaries()
{
  mkdir -p $BIN 2>/dev/null || true
  if [ -w $BIN ] ; then
    echo "Installing program files in $BIN"
    # bins_cleanupgallery anti_bins
    cp bins bins_edit bins-edit-gui $BIN
    chmod a+rx $BIN/bins
    chmod a+rx $BIN/bins_edit
    chmod a+rx $BIN/bins_cleanupgallery
    chmod a+rx $BIN/bins-edit-gui
    chmod a+rx $BIN/anti_bins
#    perl -pi -e "s{/usr/local/share}{$SHARE}g" \
#     $BIN/bins $BIN/bins_edit $BIN/bins-edit-gui
#    perl -pi -e "s{/etc/bins}{$RC}g" \
#     $BIN/bins $BIN/bins_edit $BIN/bins-edit-gui
    return 0
  else
    echo "Cannot write to $BIN directory." 
    return 1
  fi
}

install_config()
{
  mkdir -p $RC 2>/dev/null || true
  if [ -w $RC ]; then
    echo "Installing configuration file in $RC"
    cp binsrc $RC
    for T in $templates
    do
      if [ -d "$RC/templates.$T" ]; then
	echo "Removing old template.$T in $RC"
	rm -Rf "$RC/templates.$T"
      fi
    done
    chmod -R a+r $RC/*
  else
    echo "Cannot write to $RC."
    return 1
  fi
}

install_data()
{
  mkdir -p $DATA 2>/dev/null || true
  if [ -w $DATA ]; then
    for T in $templates
    do
      echo "Installing default HTML templates in $DATA/templates.$T"
      if [ ! -d $DATA/templates.$T ] ; then
	mkdir $DATA/templates.$T
      fi
      cp templates.$T/*.html $DATA/templates.$T
      if ls templates.$T/*.js >/dev/null 2>&1 ; then
	cp templates.$T/*.js $DATA/templates.$T
      fi
      if [ -d templates.$T/static ] ; then
	cp -R templates.$T/static $DATA/templates.$T
      fi
    done
    chmod -R a+r $DATA/*
    return 0
  else
    echo "Cannot write to $DATA."
    return 1
  fi
}


# program files
set +o errexit
install_binaries
if [ "$?" -eq "1" ] ; then
  BIN=~/bin
  echo "Trying $BIN..."
  install_binaries
  if [ "$?" -eq "1" ] ; then
    echo "Error: unable to find a directory to write program files, aborting."
    exit 2
  fi
fi

# config file
install_config
if [ "$?" -eq "1" ] ; then
  RC=~/.bins
  echo "Trying $RC..."
  install_config
  if [ "$?" -eq "1" ] ; then
    echo "Error: unable to find a directory to write configuration file, aborting."
    exit 2
  fi
fi

# templates
install_data
if [ "$?" -eq "1" ] ; then
  DATA=~/.bins
  echo "Trying $DATA..."
  install_data
  if [ "$?" -eq "1" ] ; then
    echo "Error: unable to find a directory to write templates, aborting."
    exit 2
  fi
fi
set -o errexit

# additionnal files
mkdir -p $GLADE 2>/dev/null || true
if [ -w $GLADE ] ; then
  echo "Installing additionnal files in $GLADE"
  cp bins-edit-gui.glade $GLADE
fi

# man pages
mkdir -p $MAN 2>/dev/null || true
if [ -w $MAN ] ; then
  echo "Installing man page in $MAN"
  cp doc/*.1 $MAN
fi

# bash completion
if [ -w $ETC/bash_completion.d ] ; then
  echo "Installing bash completion system wide."
  cp -f bash_completion $ETC/bash_completion.d/bins
else
  mkdir ~/.bash_completion 2>/dev/null || true
  if [ -w ~/.bash_completion ] ; then
    echo "Installing bash completion for user `whoami`."
    cp -f bash_completion ~/.bash_completion/bins
  fi
fi

# I18N files
mkdir -p $LOCALE 2>/dev/null || true
if [ -w $LOCALE ] ; then
  echo "Installing internationalization messages files."
  for L in $langs
  do
    mkdir -p $LOCALE/$L/LC_MESSAGES 2>/dev/null || true
    cp intl/$L.mo $LOCALE/$L/LC_MESSAGES/bins.mo
    if [ -f intl/gui-$L.mo ]; then
      cp intl/gui-$L.mo $LOCALE/$L/LC_MESSAGES/bins-edit-gui.mo
    fi
  done
else
  cat <<!EoF  

***************************** Warning **********************************
Cannot install internationalization messages files and additional
files.  If you want to generate HTML albums in non-english langage,
use bins-edit-gui or install the man pages, then you must run this
install program as root.
************************************************************************

!EoF
fi

set +o errexit
# set directory paths in source code
echo -n "setting directory paths in programs :"
for FILE in "$BIN/bins" "$BIN/bins_edit" "$BIN/bins-edit-gui"
do
  echo -n " $FILE"
  ed "$FILE" <<EoF 2>/dev/null
1,\$s%/usr/local/share%$SHARE%g
1,\$s%/etc/bins%$GLOBAL_RC%g
wq
EoF
done
echo .
echo
echo "Installation complete"
