/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.apicover;

import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.ConstructorDescr;
import com.sun.tdk.signaturetest.model.FieldDescr;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MethodDescr;
import com.sun.tdk.signaturetest.model.PackageDescr;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class APIVisitor {
    List<ClassDescription> api = new ArrayList<ClassDescription>();
    PackageDescr top = new PackageDescr("");

    APIVisitor() {
    }

    public void visit(List<ClassDescription> api) {
        this.api = api;
        this.collectPackages();
        this.visit(this.top);
    }

    private void collectPackages() {
        ArrayList<PackageDescr> packages = new ArrayList<PackageDescr>();
        packages.add(this.top);
        for (ClassDescription cd : this.api) {
            String pname = cd.getPackageName();
            this.addPackage(pname, packages).add(cd);
        }
    }

    private PackageDescr addPackage(String pname, List<PackageDescr> packages) {
        PackageDescr newPackage = new PackageDescr(pname);
        PackageDescr parent = null;
        for (PackageDescr pd : packages) {
            if (pd.equals(newPackage)) {
                return pd;
            }
            if (!ClassDescription.getPackageName(pname).equals(pd.getQualifiedName())) continue;
            parent = pd;
        }
        if (parent == null) {
            parent = this.addPackage(ClassDescription.getPackageName(pname), packages);
        }
        packages.add(newPackage);
        parent.add(newPackage);
        return newPackage;
    }

    protected void visit(PackageDescr x) {
        for (Object cd : x.getDeclaredClasses()) {
            this.visit((ClassDescription)cd);
        }
        for (Object pd : x.getDeclaredPackages()) {
            this.visit((PackageDescr)pd);
        }
    }

    protected void visit(ClassDescription x) {
        ArrayList<MemberDescription> list = new ArrayList<MemberDescription>();
        Iterator i = x.getMembersIterator();
        while (i.hasNext()) {
            boolean isInserted = false;
            MemberDescription md = (MemberDescription)i.next();
            for (int j = 0; j < list.size(); ++j) {
                if ((((MemberDescription)list.get(j)).getName() + ((MemberDescription)list.get(j)).getArgs()).compareTo(md.getName() + md.getArgs()) <= 0) continue;
                list.add(j, md);
                isInserted = true;
                break;
            }
            if (isInserted) continue;
            list.add(md);
        }
        for (MemberDescription md : list) {
            if (md instanceof ConstructorDescr) {
                ConstructorDescr constr = (ConstructorDescr)md;
                this.visit(constr);
            }
            if (!(md instanceof MethodDescr)) continue;
            MethodDescr meth = (MethodDescr)md;
            this.visit(meth);
        }
        for (MemberDescription md : list) {
            if (!(md instanceof FieldDescr)) continue;
            FieldDescr field = (FieldDescr)md;
            this.visit(field);
        }
    }

    protected void visit(MemberDescription x) {
    }
}

