/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.file.verify;

import java.util.List;
import net.sf.jiapi.file.ClassFile;
import net.sf.jiapi.file.Method;
import net.sf.jiapi.file.attribute.CodeAttribute;
import net.sf.jiapi.file.attribute.StackMapTableAttribute;
import net.sf.jiapi.file.verify.AbstractTypeChecker;

public class Environment
extends AbstractTypeChecker {
    private ClassFile clazz;
    private Method method;
    private CodeAttribute code;
    private short maxStack;
    private StackMapTableAttribute stackMapTable;

    public Environment(ClassFile clazz, Method method) {
        this.clazz = clazz;
        this.method = method;
        this.code = (CodeAttribute)method.getAttribute("Code");
        this.stackMapTable = this.code.getStackMapTable();
        this.maxStack = this.code.getMaxStack();
    }

    public boolean checkStackMap() {
        if (this.stackMapTable != null) {
            List<StackMapTableAttribute.StackMapFrame> entries = this.stackMapTable.getEntries();
            byte[] codeBytes = this.code.getBytes();
            int codeSize = 0;
            for (StackMapTableAttribute.StackMapFrame smf : entries) {
                codeSize += smf.getOffsetDelta();
            }
            if (codeSize != codeBytes.length) {
                this.verifyErrorMessage("CodeAttribute of " + this.method.getName() + " " + this.method.getDescriptor() + " is illegal; code size mismatch " + codeBytes.length + " (actual) vs. " + codeSize + " (calculated from StackMapTable)");
                return false;
            }
        }
        return true;
    }
}

