/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff;

import cz.startnet.utils.pgdiff.PgDiffUtils;
import cz.startnet.utils.pgdiff.SearchPathHelper;
import cz.startnet.utils.pgdiff.schema.PgRelation;
import cz.startnet.utils.pgdiff.schema.PgSchema;
import cz.startnet.utils.pgdiff.schema.PgTrigger;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class PgDiffTriggers {
    public static void createTriggers(PrintWriter printWriter, PgSchema pgSchema, PgSchema pgSchema2, SearchPathHelper searchPathHelper) {
        for (PgRelation pgRelation : pgSchema2.getRels()) {
            PgRelation pgRelation2 = pgSchema == null ? null : pgSchema.getRelation(pgRelation.getName());
            for (PgTrigger pgTrigger : PgDiffTriggers.getNewTriggers(pgRelation2, pgRelation)) {
                searchPathHelper.outputSearchPath(printWriter);
                printWriter.println();
                printWriter.println(pgTrigger.getCreationSQL());
            }
        }
    }

    public static void dropTriggers(PrintWriter printWriter, PgSchema pgSchema, PgSchema pgSchema2, SearchPathHelper searchPathHelper) {
        for (PgRelation pgRelation : pgSchema2.getRels()) {
            PgRelation pgRelation2 = pgSchema == null ? null : pgSchema.getRelation(pgRelation.getName());
            for (PgTrigger pgTrigger : PgDiffTriggers.getDropTriggers(pgRelation2, pgRelation)) {
                searchPathHelper.outputSearchPath(printWriter);
                printWriter.println();
                printWriter.println(pgTrigger.getDropSQL());
            }
        }
    }

    private static List<PgTrigger> getDropTriggers(PgRelation pgRelation, PgRelation pgRelation2) {
        ArrayList<PgTrigger> arrayList = new ArrayList<PgTrigger>();
        if (pgRelation2 != null && pgRelation != null) {
            List<PgTrigger> list = pgRelation2.getTriggers();
            for (PgTrigger pgTrigger : pgRelation.getTriggers()) {
                if (list.contains(pgTrigger)) continue;
                arrayList.add(pgTrigger);
            }
        }
        return arrayList;
    }

    private static List<PgTrigger> getNewTriggers(PgRelation pgRelation, PgRelation pgRelation2) {
        ArrayList<PgTrigger> arrayList = new ArrayList<PgTrigger>();
        if (pgRelation2 != null) {
            if (pgRelation == null) {
                arrayList.addAll(pgRelation2.getTriggers());
            } else {
                for (PgTrigger pgTrigger : pgRelation2.getTriggers()) {
                    if (pgRelation.getTriggers().contains(pgTrigger)) continue;
                    arrayList.add(pgTrigger);
                }
            }
        }
        return arrayList;
    }

    public static void alterComments(PrintWriter printWriter, PgSchema pgSchema, PgSchema pgSchema2, SearchPathHelper searchPathHelper) {
        if (pgSchema == null) {
            return;
        }
        for (PgRelation pgRelation : pgSchema.getRels()) {
            PgRelation pgRelation2 = pgSchema2.getRelation(pgRelation.getName());
            if (pgRelation2 == null) continue;
            for (PgTrigger pgTrigger : pgRelation.getTriggers()) {
                PgTrigger pgTrigger2 = pgRelation2.getTrigger(pgTrigger.getName());
                if (pgTrigger2 == null) continue;
                if (pgTrigger.getComment() == null && pgTrigger2.getComment() != null || pgTrigger.getComment() != null && pgTrigger2.getComment() != null && !pgTrigger.getComment().equals(pgTrigger2.getComment())) {
                    searchPathHelper.outputSearchPath(printWriter);
                    printWriter.println();
                    printWriter.print("COMMENT ON TRIGGER ");
                    printWriter.print(PgDiffUtils.getQuotedName(pgTrigger2.getName()));
                    printWriter.print(" ON ");
                    printWriter.print(PgDiffUtils.getQuotedName(pgTrigger2.getRelationName()));
                    printWriter.print(" IS ");
                    printWriter.print(pgTrigger2.getComment());
                    printWriter.println(';');
                    continue;
                }
                if (pgTrigger.getComment() == null || pgTrigger2.getComment() != null) continue;
                searchPathHelper.outputSearchPath(printWriter);
                printWriter.println();
                printWriter.print("COMMENT ON TRIGGER ");
                printWriter.print(PgDiffUtils.getQuotedName(pgTrigger2.getName()));
                printWriter.print(" ON ");
                printWriter.print(PgDiffUtils.getQuotedName(pgTrigger2.getRelationName()));
                printWriter.println(" IS NULL;");
            }
        }
    }

    private PgDiffTriggers() {
    }

    private static List<PgTrigger> getEnablerOrDisableTriggers(PgRelation pgRelation, PgRelation pgRelation2) {
        ArrayList<PgTrigger> arrayList = new ArrayList<PgTrigger>();
        if (pgRelation2 != null) {
            for (PgTrigger pgTrigger : pgRelation2.getTriggers()) {
                PgTrigger pgTrigger2 = pgRelation.getTrigger(pgTrigger.getName());
                if ((!pgTrigger.isDisable() || pgTrigger2 != null) && (pgTrigger2 == null || pgTrigger2.isDisable() == pgTrigger.isDisable())) continue;
                arrayList.add(pgTrigger);
            }
        }
        return arrayList;
    }

    public static void disableOrEnableTriggers(PrintWriter printWriter, PgSchema pgSchema, PgSchema pgSchema2, SearchPathHelper searchPathHelper) {
        for (PgRelation pgRelation : pgSchema2.getRels()) {
            PgRelation pgRelation2 = pgSchema == null ? null : pgSchema.getRelation(pgRelation.getName());
            for (PgTrigger pgTrigger : PgDiffTriggers.getEnablerOrDisableTriggers(pgRelation2, pgRelation)) {
                searchPathHelper.outputSearchPath(printWriter);
                printWriter.println();
                printWriter.println(pgTrigger.getDisableOrEnableSQL());
            }
        }
    }
}

