
There is a CI workflow `DNS.yml` to test your DNS API when you send PR to add a new DNS API.

This test suite uses GitHub actions. The purpose is to try your changes on one particular API across a bunch of different operating systems so that we have confidence your changes will work wherever this script is used. This test must be passing before your PR can get merged.

However, as a limitation of github actions, the workflow `DNS.yml` can only run in your Forked repo when you push code.

## So, please enable Github Actions on your Forked repo first, and then push code to your repo, it will run there.

If you have not enabled Github Actions before you push to your fork, unfortunately you'll need to trigger some kind of push in order for GitHub actions to realise it needs to run the workflow, so either push a new commit after enabling GitHub actions, roll your fork back to be even with the main repo, then push again, or delete your fork and re-push your changes.

Once you've got GitHub Actions running the DNS API tests on your fork, we need to configure them so they can put your change through its paces.


### 1.  An example DNS API

We'll use this API as an example. It's called `dns_myapi`, and it takes two environment variable arguments, `MyDnsKey1`, and `MyDnsKey2`. To run it on the command line, we'd do this:

```
export  MyDnsKey1=myValue1
export  MyDnsKey2=myValue2

acme.sh  --issue  -d  mytest.myExample.com  --dns  dns_myapi  

```

### 2.  In order to test this particular API, we'd need to do this:

1. Go to your repository on GitHub.
1. Click on the “Settings” tab.
1. Scroll down to the “Security” section and click on “Secrets and variables”, then on “Actions” and finally on “New repository secret”.
1. Enter a name for your secret (e.g. TokenName1 ) and insert the corresponding value.
1. Click on “Add secret”.

**The secrets are only visible to yourself, nobody else can read the secrets.**


**You must create a separate secret for each variable. Each entry under “Add secret” only takes one name and one value**

And we'd need to set the following secrets:

```
TokenName1 =  MyDnsKey1
```
```
TokenValue1 = myValue1
```
```
TokenName2 =  MyDnsKey2
```
```
TokenValue2 = myValue2
```
```

TEST_DNS = dns_myapi  
```
```
TestingDomain = mytest.myExample.com
```
```

TEST_DNS_SLEEP = 120
```

The `TEST_DNS_SLEEP` is the time (in seconds) to sleep to wait for your DNS records to propagate. 

Different DNS providers may require different propagate time,  please ask your DNS provider support for the time.

Usually, it's larger than `120` seconds.

## Note

Note that in order to test a different API, you'd need different values, for example the Netlify API is run like this:

```
export  NETLIFY_ACCESS_TOKEN="xxxx"

acme.sh  --issue  -d  mytest.myExample.com  --dns  dns_netlify
```

So we'd need to set the following secrets in GitHub:
```
TEST_DNS = dns_netlify  
```
```
TokenName1 = NETLIFY_ACCESS_TOKEN
```
```
TokenValue1 = xxxx
```
```
TestingDomain = mytest.myExample.com
```

Now the tests should be able to try out your change to the Netlify DNS API!

# How to get a Solaris server

If you need a solaris shell to debug your script,  please see this project: https://github.com/vmactions/shell-solaris


# How to get a FreeBSD server

If you need a freebsd shell to debug your script,  please see this project: https://github.com/vmactions/shell-freebsd
