#include <stdlib.h>
#include "../util/memory.h"

#define list_IMPORT
#include "list.h"

static void list_destruct(void *p)
{
	list_Type *l = p;
	int i;

	if( l == NULL )
		return;
	
	for( i = l->n-1; i >=0; i-- )
		memory_dispose(l->arr[i]);
	memory_dispose(l->arr);
}


list_Type * list_new()
{
	list_Type *l;

	l = memory_allocate(sizeof( list_Type ), list_destruct);
	l->size = 0;
	l->n = 0;
	l->arr = NULL;
	return l;
}


void list_add_elem(list_Type *l, char *s)
{
	if( l->n >= l->size ){
		l->size = l->size * 2 + 50;
		l->arr = memory_realloc(l->arr, l->size * sizeof(char *));
	}

	l->arr[ l->n++ ] = memory_strdup(s);
}


void list_add_list(list_Type *l, list_Type *q)
{
	int i;

	if( q == NULL )
		return;
	
	for( i = 0; i < q->n; i++ )
		list_add_elem(l, q->arr[i]);
}
