/*
    ACfax - Fax reception with X11-interface for amateur radio
    Copyright (C) 1995-1998 Andreas Czechanowski, DL4SDC

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

    andreas.czechanowski@ins.uni-stuttgart.de
*/
    
/*
 * widgets.h - structure definitions for widgets.c
 */

#include <X11/Intrinsic.h>

/*
 * these structures are for grouping widgets together and not having
 * too many global widget-variables. Most states are remembered by the
 * status of the appropriate widget. For numeric values, or multi-state
 * widgets, integer variables have been added.
 */

struct modem_ws {
  Widget
    form,	/* form widget containining... : */
    modemdesc,	/* label "modem settings" */
    modinfo,	/* label "modulation type" */
    mmode,	/* toggle (AM/FM) */
    filinfo,	/* label "filter select" */
    mfilter,	/* command (narrow/middle/wide filter) */
    mflpd,	/* simpleMenu containing... : */
    mflt1,	/* smeBSB: narrow filter */
    mflt2,	/* smeBSB: middle filter */
    mflt3,	/* smeBSB: wide filter */
    fmdevinfo,	/* label "deviation (+/- Hz)" */
    fmdevval,	/* asciiText (entry of deviation value) */
    siginfo,	/* label "Signal" */
    sigbar;	/* scrollbar showing current input signal level */
  int
    c_filter,	/* currently selected filter (see mod_demod.h) */
    c_devi;	/* currently selected deviation (for FM) */
};

struct runctl_ws {
  Widget
    form,	/* form widget containining... : */
    runinfo,	/* label "operation control" */
    rmstop,	/* toggle (stop) */
    rmsyn,	/* toggle (sync) */
    rmrun;	/* toggle (run) */
};

struct dirctl_ws {
  Widget
    form,	/* form widget containining... : */
    dirinfo,	/* label "direction control" */
    dirhv,	/* toggle (hor/vert) */
    dirlr,	/* toggle (right/left) */
    dirtb;	/* toggle (bottom/top) */
};

struct polctl_ws {
  Widget
    form,	/* form widget containining... : */
    polinfo,	/* label "image polarity" */
    norinv,	/* toggle (normal/invers) */
    phsinfo,	/* label "phase polarity" */
    posneg;	/* toggle (pos/neg phase) */
};

struct adjctl_ws {
  Widget
    form,	/* form widget containining... : */
    adjinfo,	/* label "image adjust" */
    lshift,	/* command (shift image) */
    azimut;	/* command (azimut correction) */
};

struct numval_ws {
  Widget
    form,	/* form widget containining... : */
    numinfo,	/* label "numeric parameters" */
    lpmtxt,	/* label "lpm" */
    lpmval,	/* asciiText (lpm entry) */
    ioctxt,	/* label "IOC" */
    iocval,	/* asciiText (IOC entry) */
    statxt,	/* label "APT start" */
    staval,	/* asciiText (APT start entry) */
    stotxt,	/* label "APT stop" */
    stoval;	/* asciiText (APT stop entry) */
  int
    c_lpm,
    c_ioc,
    c_aptsta,
    c_aptstp;
};

struct info_popup {
  Widget
    shell,	/* popup-shell for displaying auxiliary information */
    form,	/* form widget containing... : */
    text,	/* asciiText, displaying message */
    butn;	/* button for Ok/cancel/dismiss etc */
};

struct file_menu {
  Widget
    butn,	/* menuButton opening... : */
    menu,	/* simpleMenu containing... : */
    saveas,	/* smeBSB "save-as" */
    close,      /* smeBSB "close" */
    autosave,	/* smeBSB "save (auto-filename)" */
    quit;	/* smeBSB "quit ACfax" */
};

struct fileshell_args {
  char *title;		/* title of shell to be poped up */
  char *dir_io;		/* directory input/output */
  char *filename;	/* filename_return */
  void (*file_act)(char *);	/* function accepting name as argument */
};

struct file_browser {
  Widget
    shell,	/* popup-shell for the file-browser */
    form,	/* form widget containing... : */
    fchs,	/* XfwfFileChooserWidget */
    okbut,	/* command "Ok" */
    cancel,	/* command "cancel" */
    fname;	/* asciiText for file-/directory name entry */
  char
    name[256];	/* name of file being selected */
  struct fileshell_args
    *fsarg;	/* file-shell arguments passed from application */
};

extern Widget
	/* form, */
	fax_shell,
	fax_form,
	disp_form,
	vport,
	canvas;

extern Pixmap
	px_horiz,
	px_vert,
	px_right,
	px_left,
	px_top,
	px_bottom,
	px_normal,
	px_invers,
	px_nphs,
	px_iphs,
	px_azimut,
	px_shift,
	px_stop,
	px_syn,
	px_run,
	px_mam,
	px_mfm,
	px_narrow,
	px_middle,
	px_wide;

extern struct modem_ws		mod_s;
extern struct runctl_ws		run_s;
extern struct dirctl_ws		dir_s;
extern struct polctl_ws		pol_s;
extern struct adjctl_ws		adj_s;
extern struct numval_ws		num_s;
extern struct file_menu		file_m;
extern struct info_popup	info_s;

Widget	cr_modemform(Widget);	/* creates mod_s */
Widget	cr_faxctls(Widget);	/* creates run_s, dir_s, pol_s, adj_s */
Widget	cr_faxparams(Widget);	/* creates num_s */
Widget	cr_menubar(Widget);	/* creates menu with pulldown-menus */
Widget	cr_infopop(Widget);	/* creates info_s */
void	query_filename(struct fileshell_args *);
void	create_widgets(Widget);
void	simple_info(char *);
void	create_pixmaps(Widget);
void	set_sigdisplay(double);
