!{\src2tex{textfont=tt}}
!!****f* ABINIT/hermitianize
!! NAME
!! hermitianize
!!
!! FUNCTION
!! Force a matrix to be hermitian
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  n=dimension of the m matrix
!!
!! OUTPUT
!!  (see side effects)
!!
!! SIDE EFFECTS
!!  m(n,n)=complex input matrix, hermitianized at output
!!
!! PARENTS
!!      screening
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine hermitianize(m,n)

 use defs_basis

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: n
!arrays
 complex,intent(inout) :: m(n,n)

!Local variables-------------------------------
!scalars
 integer :: i,j
!arrays
 complex,allocatable :: t(:)

! *************************************************************************

 allocate(t(n))

 do i=1,n
   do j=i,n
     t(j)=(m(i,j)+conjg(m(j,i)))/2.0
   end do
   do j=i,n
     m(i,j)=t(j)
   end do
   do j=i,n
     m(j,i)=conjg(t(j))
   end do
 end do

 deallocate(t)

end subroutine hermitianize
!!***
