!{\src2tex{textfont=tt}}
!!****f* ABINIT/findnq
!! NAME
!! findnq
!!
!! FUNCTION
!! Identify the number of q-points by which the k-points in BZ differ
!! (count the q points in the k-point difference set)
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG, MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  kbz(3,nkbz)=coordinates of k points in BZ
!!  ninv=1 if inversion is not to be taken into account; 2 if inversion is to be taken into account
!!  nkbz=number of k points in Brillouin zone
!!  nop=number of symmetry operations
!!  op(3,3,nop)=symmetry operations in reciprocal space
!!
!! OUTPUT
!!  nq=number of q points
!!
!! PARENTS
!!      mrgscr,screening
!!
!! CHILDREN
!!      dosym
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine findnq(nkbz,kbz,nop,op,nq,ninv)

 use defs_basis

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_15gw, except_this_one => findnq
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: ninv,nkbz,nop
 integer,intent(out) :: nq
!arrays
 real(dp),intent(in) :: kbz(3,nkbz),op(3,3,nop)

!Local variables ------------------------------
!scalars
 integer :: ifound,iinv,ik,iop,iq,istat,memory_exhausted,nqall,nqallm
 character(len=500) :: message
!arrays
 integer :: gtemp(3)
 real(dp) :: qposs(3),qrot(3)
 real(dp),allocatable :: qall(:,:)

! *************************************************************************
!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifndef HAVE_FORTRAN_INTERFACES
 integer :: icmpk2
#endif
!End of the abilint section

 nqallm=1000
 memory_exhausted=0

 do !Infinite do-loop to be able to allocate sufficient memory

  allocate(qall(3,nqallm),stat=istat)
  if(istat/=0) then 
   call memerr('findnq','qall',3*nqallm,'dp')
  end if 

  nqall=0

  !Loop over all k-points in BZ, forming k-k1
  do ik=1,nkbz
   qposs(1)=kbz(1,ik)-kbz(1,1)
   qposs(2)=kbz(2,ik)-kbz(2,1)
   qposs(3)=kbz(3,ik)-kbz(3,1)

   !check whether this q (or its equivalent) has already been found
   ifound=0
   do iq=1,nqall
    do iinv=1,ninv
     do iop=1,nop
      call dosym(op(1,1,iop),iinv,qall(1,iq),qrot)
      if(icmpk2(qrot,qposs)==1) ifound=ifound+1
     end do
    end do
   end do

   if(ifound==0) then
    nqall=nqall+1
    !Check that the allocation was big enough
    if(nqall>nqallm) then
     memory_exhausted=1
     deallocate(qall)
     nqallm=nqallm*2
     exit ! exit the do ik=1 loop
    end if
    qall(1,nqall)=qposs(1)
    qall(2,nqall)=qposs(2)
    qall(3,nqall)=qposs(3)
   end if
  end do

  if(memory_exhausted==0)exit
 end do

 deallocate(qall)
 nq=nqall

 write(message,'(a,i8)')' number of q-points found ',nq
 call wrtout(06,message,'COLL')
 call wrtout(ab_out,message,'COLL')

end subroutine findnq
!!***
